/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.ai;

import com.isomorphic.ai.AIDataSource;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.RestConnector;
import com.isomorphic.log.Logger;
import com.isomorphic.util.SimpleHttpResponse;
import java.util.Map;
import org.apache.http.Header;

public class AIRestConnector
extends RestConnector {
    private static Logger log = new Logger(AIRestConnector.class.getName());
    private boolean debugRatelimit;

    protected DSResponse processRequest(DSRequest req, boolean skipExecution, RestConnector.RESTRequestElements elements) throws Exception {
        if (!AIDataSource.isAIAuthorized(log, req)) {
            return AIDataSource.createAINotAuthorizedResponse(req);
        }
        return super.processRequest(req, skipExecution, elements);
    }

    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        boolean defaultDebug = Config.getGlobal().getBoolean((Object)"airestconnector.default.debugRatelimit", false);
        this.debugRatelimit = this.getConfig().getBoolean((Object)"debugRatelimit", defaultDebug);
    }

    protected void onHttpResponseParsed(String opType, DataTypeMap serverConfig, SimpleHttpResponse httpResponse, Object responseData) {
        if (!this.debugRatelimit || !(responseData instanceof Map)) {
            return;
        }
        String responseFormat = this.getResponseFormat(serverConfig, opType);
        if (!AIRestConnector.isFetch((String)opType) || !"json".equals(responseFormat)) {
            return;
        }
        DataTypeMap ratelimitDetails = new DataTypeMap();
        for (Header header : httpResponse.getAllHeaders()) {
            String propertyName = header.getName().toLowerCase();
            if (!propertyName.startsWith("x-ratelimit")) continue;
            Object value = header.getValue();
            try {
                value = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ratelimitDetails.put(propertyName.replaceAll("-", "_"), value);
        }
        if (ratelimitDetails.size() > 0) {
            ((Map)responseData).put("ratelimit_details", ratelimitDetails);
        }
    }
}

