/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.BitSet;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.UnfetchedBasicPartResultAssembler;
import org.hibernate.sql.results.graph.UnfetchedResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.sql.results.graph.basic.CoercingResultAssembler;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicFetch<T>
implements Fetch,
BasicResultGraphNode<T> {
    private final NavigablePath navigablePath;
    private final FetchParent fetchParent;
    private final BasicValuedModelPart valuedMapping;
    private final DomainResultAssembler<T> assembler;
    private final FetchTiming fetchTiming;

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        this(valuesArrayPosition, fetchParent, fetchablePath, valuedMapping, valuedMapping.getJdbcMapping().getValueConverter(), fetchTiming, true, creationState);
    }

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, FetchTiming fetchTiming, DomainResultCreationState creationState, boolean coerceResultType) {
        this(valuesArrayPosition, fetchParent, fetchablePath, valuedMapping, valuedMapping.getJdbcMapping().getValueConverter(), fetchTiming, true, creationState, coerceResultType);
    }

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, BasicValueConverter<T, ?> valueConverter, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        this(valuesArrayPosition, fetchParent, fetchablePath, valuedMapping, valueConverter, fetchTiming, true, creationState);
    }

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, BasicValueConverter<T, ?> valueConverter, FetchTiming fetchTiming, boolean canBasicPartFetchBeDelayed, DomainResultCreationState creationState) {
        this(valuesArrayPosition, fetchParent, fetchablePath, valuedMapping, valueConverter, fetchTiming, canBasicPartFetchBeDelayed, creationState, false);
    }

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, BasicValueConverter<T, ?> valueConverter, FetchTiming fetchTiming, boolean canBasicPartFetchBeDelayed, DomainResultCreationState creationState, boolean coerceResultType) {
        this.navigablePath = fetchablePath;
        this.fetchParent = fetchParent;
        this.valuedMapping = valuedMapping;
        this.fetchTiming = fetchTiming;
        JavaType<?> javaType = valuedMapping.getJavaType();
        this.assembler = fetchTiming == FetchTiming.DELAYED && valuesArrayPosition == -1 ? (canBasicPartFetchBeDelayed ? new UnfetchedResultAssembler(javaType) : new UnfetchedBasicPartResultAssembler(javaType)) : (coerceResultType ? new CoercingResultAssembler(valuesArrayPosition, javaType, valueConverter) : new BasicResultAssembler(valuesArrayPosition, javaType, valueConverter));
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.fetchTiming == FetchTiming.IMMEDIATE;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.valuedMapping;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return null;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public String getResultVariable() {
        return null;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        if (this.assembler instanceof BasicResultAssembler) {
            valueIndexes.set(((BasicResultAssembler)this.assembler).valuesArrayPosition);
        }
    }
}

