/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BuilderSpecifier;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.DetailViewParser;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHTMLLauncher;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerWebDriver;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.webdriver.SeleneseTestOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;

public class TestRunnerHelper
extends ConfiguredBase {
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : System.getProperty("java.io.tmpdir");
    protected static final String GET_ACTIVE_WINDOW = "selenium.browserbot.getCurrentWindow()";
    protected static final String TESTRUNNER_OBJECT = "isc.TestRunner.getSingletonInstance()";
    protected static final String STATIC_TESTCONFIG = "isc.TestRunner.getActiveTestConfig()";
    protected static final String EXTRACT_TESTRUNNER_OBJECT = "var runner = window.isc.TestRunner.getSingletonInstance();     runner";
    protected static final String EXTRACT_STATIC_TESTCONFIG = "var config = window.isc.TestRunner.getActiveTestConfig();     config";
    protected static final String TESTRUNNER_RUN_TESTS = "var runner = window.isc.TestRunner.getSingletonInstance(); if (runner.autoRun == null) runner.runTestsWrapper()";
    protected static final String EXTRACT_TESTCONFIG_OBJECT = "var runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig";
    protected static final String HTML_BEGIN_COMMENT = "\\<!\\-\\-";
    protected static final String HTML_END_COMMENT = "\\-\\-\\>";
    protected static final String RCTEST_MAXIMIZE_TAG = "(?m)^\\<!\\-\\-\\s*maximize\\s*\\-\\-\\>$";
    private static Logger log = new Logger(TestRunnerHelper.class.getName());
    private static final TestCaseResults SEPARATE_BROWSER_TOKEN = new TestCaseResults();
    private static final int MAX_SESSION_ID_COLLISIONS = 10;
    private static RuntimeException fatalException;

    public static void testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, String builder, boolean batchRun, TestCallback callback) {
        List<String> testFiles;
        String testRootPath = config.getTestRoot(null);
        BuilderSpecifier specifier = BuilderSpecifier.newInstance(builder);
        String subdirRegEx = BuilderSpecifier.getSubdirectoryRegEx(specifier);
        if (runUsualTests && (testFiles = ((TestRunnerLauncher)config).getTestScripts(scripts, subdirRegEx, "\\.test(\\.(jsp|isc|html))?$", testRootPath)) != null && testFiles.size() > 0) {
            TestRunnerHelper.processUsualTests(testFiles, browser, callback, testRootPath, batchRun);
        }
        if (runSelenium && (testFiles = ((TestRunnerLauncher)config).getTestScripts(scripts, subdirRegEx, "\\.rctest(\\.(jsp|isc|html))?$", testRootPath)) != null && testFiles.size() > 0) {
            TestRunnerHelper.processSeleniumTests(testFiles, browser, callback, testRootPath, specifier);
        }
        if (fatalException != null) {
            log.error((Object)"Test framework aborted due to exception!");
            Utils.dumpStringToFile(tmpDir + "/awstest.exception.txt", ExceptionUtils.getStackTrace((Throwable)fatalException));
            throw fatalException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processSeleniumTests(List testFiles, String browser, TestCallback callback, String testRootPath, BuilderSpecifier specifier) {
        String browserURL = config.getHttpBaseURL(null);
        TestRunnerWebDriver driver = new TestRunnerWebDriver(browser);
        int i = 0;
        while (i < testFiles.size()) {
            String filePath = (String)testFiles.get(i++);
            try {
                driver.start();
                TestCaseResults tcr = TestRunnerHelper.testRctest(browserURL, testRootPath, filePath, driver, null, specifier, null, i == testFiles.size());
                callback.onTestResults(tcr);
            }
            catch (IOException e) {
                log.error((Object)("Problems with selenium test: " + filePath), (Throwable)e);
            }
            finally {
                driver.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processUsualTests(List testFiles, String browser, TestCallback callback, String testRootPath, boolean batch) {
        if (!"localhost".equals(config.getHttpTarget())) {
            log.warn((Object)"Attempting to run .test TestRunner.js tests on a remote machine. This is unpredictable because the list of tests to run is generated locally, yet the files are then loaded by the remote browser.  If the two hiearchies differ, tests may not load and may time out.");
        }
        String browserURL = config.getHttpBaseURL(null);
        String fileRootPath = config.getFileRoot();
        TestRunnerWebDriver driver = new TestRunnerWebDriver(browser, browserURL);
        try {
            driver.start();
            if (batch) {
                for (Object object : testFiles) {
                    String name = ((String)object).substring(testRootPath.length() + 1);
                    String filePath = ((String)object).substring(fileRootPath.length() + 1);
                    TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
                    TestCaseResults tcr = TestRunnerHelper.test(ts, browser, driver, null, true);
                    if (tcr != null) {
                        callback.onTestResults(tcr);
                        continue;
                    }
                    if (tcr != SEPARATE_BROWSER_TOKEN) continue;
                    TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath, driver);
                }
            } else {
                for (Object object : testFiles) {
                    TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath, driver);
                }
            }
        }
        catch (RuntimeException e) {
            fatalException = e;
        }
        finally {
            driver.stop();
        }
    }

    public static List<TestCaseResults> testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, String builder, boolean batchRun) {
        final ArrayList<TestCaseResults> result = new ArrayList<TestCaseResults>();
        TestRunnerHelper.testAll(browser, runSelenium, runUsualTests, scripts, builder, batchRun, new TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                result.add(testCaseResults);
            }
        });
        return result;
    }

    protected static void processUsualTest(String testFile, String browser, TestCallback callback, String testRootPath, TestRunnerWebDriver driver) {
        String browserURL = config.getHttpBaseURL(null);
        String fileRootPath = config.getFileRoot();
        String name = testFile.substring(testRootPath.length() + 1);
        String filePath = testFile.substring(fileRootPath.length() + 1);
        TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
        TestCaseResults tcr = TestRunnerHelper.test(ts, browser, driver, null, false);
        if (tcr != null) {
            callback.onTestResults(tcr);
        }
    }

    public static TestCaseResults testRctest(String browserURL, String filePathPrefix, String filePath, TestRunnerWebDriver driver, ShowcaseSpecifier showcase, BuilderSpecifier builder, String smartClientId, Boolean lastTest) throws IOException {
        String password;
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        TestRunnerHTMLLauncher l = new TestRunnerHTMLLauncher(driver, browserURL);
        InputStream testOrig = ISCFile.getCanonicalInputStream((String)filePath);
        boolean maximizeTag = Utils.matchRegExp(RCTEST_MAXIMIZE_TAG, testOrig);
        SeleneseTestOptions testOptions = new SeleneseTestOptions();
        if (launcher.shouldMaximizeBrowser(maximizeTag)) {
            testOptions.setMaximize(true);
        }
        if (launcher.shouldSaveMessages()) {
            testOptions.setSaveMessages(true);
        }
        if (launcher.shouldSaveServerLogs()) {
            testOptions.setServerLogMode(config.getServerLogMode());
        }
        if (launcher.useTargetSkin()) {
            testOptions.setSkin(launcher.getTargetSkin());
        }
        if (showcase != null) {
            String param = showcase.getExampleOpenShowcase();
            if (param != null) {
                testOptions.setShowcase(param);
            }
            if (showcase.isSmartReact()) {
                testOptions.setReactMode(true);
            }
        }
        if (launcher.hasGoogleMapsAPIKey()) {
            testOptions.setMapsAPIKey(launcher.getGoogleMapsAPIKey());
        }
        if (smartClientId != null) {
            String mappedId = showcase.getShowcaseSpecificId(smartClientId);
            testOptions.setMappedId(mappedId);
        }
        if (builder != null) {
            testOptions.setBuilder(builder.getBuilderName());
        }
        testOptions.setAdvancedVars(true);
        testOptions.setAutoTest(true);
        int timeout = config.getSeleniumTimeout();
        testOptions.setTimeout(timeout);
        String username = ((TestRunnerLauncher)config).getTargetUserName();
        if (username != null) {
            testOptions.setUserName(username);
        }
        if ((password = ((TestRunnerLauncher)config).getTargetPassword()) != null) {
            testOptions.setPassword(password);
        }
        if (builder != null && builder.requiresAuth()) {
            if (password == null || username == null) {
                log.error((Object)"You're targeting Reify but have not provided login credentials!");
            }
        } else if (password != null || username != null) {
            log.warn((Object)"Unexpected login credentials were supplied to SeleniumRunner!");
        }
        String filename = Utils.getTestName(filePath, filePathPrefix);
        TestCaseResults results = new TestCaseResults();
        results.setStartTime(new Date());
        results.setTestName(filename);
        TestResult res = new TestResult();
        res.setTestFile(filename);
        res.setTestNumber(1);
        try {
            res.setStartTime(results.getStartTime());
            boolean passed = l.runSelenese(filePath, testOptions);
            results.setEndTime(new Date());
            res.setEndTime(results.getEndTime());
            res.setResult(passed ? "success" : "failure");
            if (res.isFailure()) {
                res.setContent(l.getOutput());
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error((Object)("test " + filePath + " cannot be run"), (Throwable)e);
        }
        catch (TimeoutException te) {
            res.setResult("timeout");
            results.setEndTime(new Date());
            res.setEndTime(results.getEndTime());
            res.setDetails("TestCase results have not appeared after " + timeout + " seconds");
            String content = l.getOutput();
            if (content != null) {
                res.setContent(res.getDetails() + "<p>" + content);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (builder != null) {
                builder.testEnd(driver, lastTest);
            }
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.add(res);
        results.setTestResults(testResults);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestCaseResults test(TestSpecifier specifier, String browser, TestRunnerWebDriver driver, ShowcaseSpecifier showcase, boolean batch) {
        TestCaseResults results;
        block19: {
            results = new TestCaseResults();
            results.setTestName(specifier.getTestName());
            Date testStartTime = new Date();
            try {
                specifier.run(driver);
                int timeout = TestRunnerHelper.getTestTimeout(driver, showcase);
                if (timeout == 0) {
                    TestCaseResults testCaseResults = null;
                    return testCaseResults;
                }
                if (batch && showcase == null && TestRunnerHelper.shouldUseSeparateBrowser(driver)) {
                    TestCaseResults testCaseResults = SEPARATE_BROWSER_TOKEN;
                    return testCaseResults;
                }
                boolean success = TestRunnerHelper.configureBrowserAndWaitForElementPresent(driver, "scLocator=//DetailViewer[ID='isc_AutoTest_DetailViewer']", timeout, showcase);
                Date testEndTime = new Date();
                if (success) {
                    String html = driver.getHtmlSource();
                    try {
                        List<Map<String, String>> testResults = DetailViewParser.parse(html);
                        ArrayList<TestResult> trs = new ArrayList<TestResult>();
                        boolean saveMessages = config.shouldSaveMessages();
                        boolean saveServerLogs = config.shouldSaveServerLogs();
                        int[] counts = TestRunnerHelper.getTestCaseNotificationCounts(driver);
                        int testNumber = 0;
                        for (Map<String, String> testData : testResults) {
                            TestResult tr = new TestResult();
                            tr.setStartTime(testStartTime);
                            tr.setEndTime(testEndTime);
                            tr.setResult(testData.get("result"));
                            tr.setDescription(testData.get("description"));
                            tr.setDetails(testData.get("detail"));
                            tr.setTestFile(specifier.getTestName());
                            if (counts != null) {
                                tr.setNotificationCount(counts[testNumber]);
                            }
                            tr.setTestNumber(++testNumber);
                            if (tr.isFailure() && saveMessages) {
                                String messages = showcase != null ? driver.getDeveloperConsoleMessages() : TestRunnerHelper.getMessagesForTest(driver, testNumber);
                                tr.setMessages(messages);
                            }
                            if (saveServerLogs) {
                                tr.setServerLogs(ShowcaseSpecifier.getServerLogs(driver, showcase, testNumber));
                            }
                            trs.add(tr);
                        }
                        results.setTestResults(trs);
                    }
                    catch (Exception e) {
                        log.error((Object)"Parsing detail viewer data failed:", (Throwable)e);
                        try {
                            results.setUnparsableResponse(DetailViewParser.getDetailViewerHtml(html));
                            break block19;
                        }
                        catch (Exception e2) {
                            results.setUnparsableResponse(html);
                        }
                    }
                    break block19;
                }
                results.setTimeoutError(true);
                results.setStartTime(testStartTime);
                results.setEndTime(testEndTime);
                results.setTimeoutInSeconds(timeout);
                String report = ShowcaseSpecifier.getPartialReportForTimedoutTest(driver, showcase);
                results.setPartialReport(report);
            }
            catch (WebDriverException se) {
                log.error((Object)"WebDriver error: ", (Throwable)se);
                results.setStartTime(testStartTime);
                results.setEndTime(new Date());
                results.setSeleniumError(se.getMessage());
            }
            finally {
                specifier.complete(driver);
            }
        }
        if (results.getTestResults() == null) {
            int count = TestRunnerHelper.getDefaultTestCaseNotificationCount(driver);
            results.setNotificationCount(count);
        }
        return results;
    }

    protected static String getMessagesForTest(TestRunnerWebDriver driver, int naturalIndex) {
        return driver.getEvalWithTry("var runner = window.isc.TestRunner.getSingletonInstance();     runner.getMessages(" + (naturalIndex - 1) + ")");
    }

    protected static boolean shouldMaximizeBrowser(TestRunnerWebDriver driver) {
        String testConfigJs = EXTRACT_STATIC_TESTCONFIG;
        String maximize = driver.getEvalWithTry(testConfigJs + ".maximize");
        if (maximize.equalsIgnoreCase("null")) {
            maximize = null;
        }
        if (maximize != null) {
            return Boolean.parseBoolean(maximize);
        }
        return ((TestRunnerLauncher)config).shouldMaximizeBrowser();
    }

    protected static boolean shouldUseSeparateBrowser(TestRunnerWebDriver driver) {
        String testConfigJs = EXTRACT_STATIC_TESTCONFIG;
        return Boolean.parseBoolean(driver.getEvalWithTry(testConfigJs + ".separate"));
    }

    protected static boolean configureBrowserAndWaitForElementPresent(TestRunnerWebDriver driver, String element, int timeoutInSeconds, ShowcaseSpecifier showcase) {
        boolean maximize = TestRunnerHelper.shouldMaximizeBrowser(driver);
        if (driver.getBrowserMaximized() != maximize) {
            driver.setBrowserMaximization(maximize);
        }
        if (showcase == null || showcase.isSmartGWTRunner()) {
            driver.getEvalWithTry(TESTRUNNER_RUN_TESTS);
        }
        return ShowcaseSpecifier.isTestRunnerBased(showcase) ? driver.waitForElementPresent(element, timeoutInSeconds) : driver.waitForElementClickable(element, timeoutInSeconds);
    }

    public static int getTestTimeout(TestRunnerWebDriver driver, ShowcaseSpecifier showcase) {
        String testConfigJs;
        String testIsDisabled;
        if (!ShowcaseSpecifier.isTestRunnerBased(showcase)) {
            return config.getSeleniumTimeout();
        }
        int timeout = config.getTestRunnerTimeout();
        if (!driver.waitForJSToSucceed("var runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig != null", 10)) {
            log.error((Object)"Attempt to read TestRunner.testConfig timed out. WebDriver will not be able to apply any custom test configuration.");
        }
        if ("true".equalsIgnoreCase(testIsDisabled = driver.getEvalWithTry((testConfigJs = EXTRACT_STATIC_TESTCONFIG) + ".testDisabled"))) {
            return 0;
        }
        String testTimeout = driver.getEvalWithTry(testConfigJs + ".timeout");
        if (testTimeout != null && !"null".equalsIgnoreCase(testTimeout)) {
            try {
                int minTimeout = Integer.parseInt(testTimeout) / 1000;
                if (minTimeout > timeout) {
                    timeout = minTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static int[] getTestCaseNotificationCounts(TestRunnerWebDriver driver) {
        String rawValue = driver.getEvalWithTry("var runner = window.isc.TestRunner.getSingletonInstance();     runner.getTestCaseNotificationCounts()");
        try {
            String[] values = rawValue.split("[\\[\\s,]");
            int[] counts = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                counts[i] = Integer.parseInt(values[i]);
            }
            return counts;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getDefaultTestCaseNotificationCount(TestRunnerWebDriver driver) {
        String testConfigJs = EXTRACT_STATIC_TESTCONFIG;
        String rawValue = driver.getEvalWithTry(testConfigJs + ".notificationCount");
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Unable to parse number from '" + rawValue + "'.  Will return 0"), (Throwable)e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestCaseResults test(String url, String browser) {
        TestCaseResults result;
        TestRunnerWebDriver driver = new TestRunnerWebDriver(browser, config.getHttpBaseURL(null));
        try {
            driver.start();
            result = TestRunnerHelper.test(new TestSpecifier(url, null), browser, driver, null, false);
        }
        finally {
            driver.stop();
        }
        return result;
    }

    public static interface TestCallback {
        public void onTestResults(TestCaseResults var1);
    }
}

