/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.SummaryFunctionType;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MCPServlet
extends HttpServlet {
    private static final ObjectMapper M = new ObjectMapper();

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonNode root;
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        try {
            root = M.readTree((InputStream)req.getInputStream());
        }
        catch (Exception e) {
            this.writeJsonRpcError(resp, null, -32700, "Parse error: " + e.getMessage(), null);
            return;
        }
        JsonNode idNode = root.get("id");
        String method = MCPServlet.str(root.get("method"));
        if (method == null) {
            this.writeJsonRpcError(resp, idNode, -32600, "Invalid Request: missing 'method'", null);
            return;
        }
        try {
            Map<String, Object> result;
            switch (method) {
                case "tools/list": {
                    Map<String, Object> map = this.toolsList();
                    break;
                }
                case "tools/call": {
                    Map<String, Object> map = this.toolsCall(root.path("params"));
                    break;
                }
                default: {
                    this.writeJsonRpcError(resp, idNode, -32601, "Method not found: " + method, null);
                    Map<String, Object> map = result = null;
                }
            }
            if (result != null) {
                this.writeJsonRpcResult(resp, idNode, result);
            }
        }
        catch (UserError ue) {
            this.writeJsonRpcError(resp, idNode, ue.code, ue.getMessage(), ue.data);
        }
        catch (Exception ex) {
            this.writeJsonRpcError(resp, idNode, -32000, "Internal error: " + ex.getMessage(), null);
        }
    }

    private Map<String, Object> toolsList() throws Exception {
        ArrayList<Map<String, Object>> tools = new ArrayList<Map<String, Object>>();
        LinkedHashMap<Object, Map<String, Object>> defs = new LinkedHashMap<Object, Map<String, Object>>();
        ArrayList<String> dsIds = new ArrayList<String>(DataSourceManager.getDefinedDataSourceIdentifiers());
        for (String id : dsIds) {
            DataSource ds = MCPServlet.tryGetDS(id);
            if (ds == null) continue;
            tools.add(MCPServlet.tool("ds." + id + ".fetch", "Fetch " + id, this.inputSchemaFor(Op.FETCH, ds)));
            tools.add(MCPServlet.tool("ds." + id + ".add", "Add " + id, this.inputSchemaFor(Op.ADD, ds)));
            tools.add(MCPServlet.tool("ds." + id + ".update", "Update " + id, this.inputSchemaFor(Op.UPDATE, ds)));
            tools.add(MCPServlet.tool("ds." + id + ".remove", "Remove " + id, this.inputSchemaFor(Op.REMOVE, ds)));
            if (MCPServlet.supportsAdvancedCriteria(ds) || MCPServlet.supportsAggregation(ds)) {
                tools.add(MCPServlet.tool("ds." + id + ".fetchAdvanced", "Advanced fetch " + id, this.inputSchemaFor(Op.FETCHADVANCED, ds)));
            }
            defs.put("record:" + id, this.recordSchema(ds));
        }
        defs.put("criteria", MCPServlet.criteriaSchema());
        defs.put("advancedCriteria", MCPServlet.advancedCriteriaSchema());
        return Map.of("tools", tools, "definitions", defs);
    }

    private static Map<String, Object> tool(String name, String description, Map<String, Object> inputSchema) {
        LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>();
        t.put("name", name);
        t.put("description", description);
        t.put("inputSchema", inputSchema);
        return t;
    }

    private static Op parseOp(String s) {
        return switch (String.valueOf(s).toLowerCase(Locale.ROOT)) {
            case "fetch" -> Op.FETCH;
            case "add" -> Op.ADD;
            case "update" -> Op.UPDATE;
            case "remove" -> Op.REMOVE;
            case "fetchadvanced" -> Op.FETCHADVANCED;
            default -> throw new IllegalArgumentException("Unsupported op: " + s);
        };
    }

    private Map<String, Object> inputSchemaFor(Op op, DataSource ds) {
        return switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case Op.FETCH -> Map.of("type", "object", "properties", Map.of("criteria", Map.of("type", "object", "additionalProperties", Map.of("type", "string")), "startRow", Map.of("type", "integer", "minimum", 0), "endRow", Map.of("type", "integer", "minimum", 0), "sortBy", Map.of("type", "array", "maxItems", 1, "items", Map.of("type", "string")), "textMatchStyle", Map.of("type", "string", "enum", List.of("exact", "substring", "startswith"))));
            case Op.ADD -> Map.of("type", "object", "data", this.recordSchema(ds), "required", List.of("data"));
            case Op.UPDATE -> Map.of("type", "object", "properties", Map.of("criteria", Map.of("type", "object", "additionalProperties", Map.of("type", "string")), "data", this.recordSchema(ds)), "required", List.of("criteria", "data"));
            case Op.REMOVE -> Map.of("type", "object", "properties", Map.of("criteria", Map.of("type", "object", "additionalProperties", Map.of("type", "string")), "startRow", Map.of("type", "integer", "minimum", 0), "endRow", Map.of("type", "integer", "minimum", 0)), "required", List.of("criteria"));
            case Op.FETCHADVANCED -> {
                LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
                props.put("sortBy", Map.of("type", "array", "items", Map.of("type", "string")));
                props.put("startRow", Map.of("type", "integer", "minimum", 0));
                props.put("endRow", Map.of("type", "integer", "minimum", 0));
                if (MCPServlet.supportsAdvancedCriteria(ds)) {
                    props.put("advancedCriteria", Map.of("$ref", "#/definitions/advancedCriteria"));
                }
                if (MCPServlet.supportsAggregation(ds)) {
                    props.put("groupBy", Map.of("type", "array", "items", Map.of("type", "string")));
                    props.put("summaryFunctions", Map.of("type", "object", "additionalProperties", Map.of("type", "string")));
                }
                yield Map.of("type", "object", "properties", props);
            }
        };
    }

    private void applyOpValidations(Op op, Map<String, Object> args, DSRequest r) {
        switch (op) {
            case FETCH: {
                Object criteria = args.get("criteria");
                if (MCPServlet.isAdvancedCriteria(criteria)) {
                    throw new UserError(-32602, "fetch only supports simple (flat) criteria", Map.of("hint", "use a flat object of field:value"));
                }
                List<String> sortBy = MCPServlet.asStringList(args.get("sortBy"));
                if (sortBy == null || sortBy.size() <= 1) break;
                throw new UserError(-32602, "fetch supports only single-field sort", Map.of("hint", "use [\"field\"] or [\"-field\"]"));
            }
            case FETCHADVANCED: {
                Object sf;
                boolean wantsGrouping;
                DataSource ds = MCPServlet.tryGetDS(r.getDataSourceName());
                Object ac = args.get("advancedCriteria");
                if (ac != null) {
                    if (!MCPServlet.supportsAdvancedCriteria(ds)) {
                        throw new UserError(-32602, "This DataSource does not allow advancedCriteria", Map.of("hint", "Call tools/list to see which DS support fetchAdvanced with advancedCriteria"));
                    }
                    if (!(ac instanceof Map)) {
                        throw new UserError(-32602, "advancedCriteria must be an object", null);
                    }
                    Map acMap = (Map)ac;
                    r.setCriteria(acMap);
                } else {
                    Object plain = args.get("criteria");
                    if (MCPServlet.isAdvancedCriteria(plain)) {
                        throw new UserError(-32602, "Use 'advancedCriteria' for nested criteria in fetchAdvanced", Map.of("hint", "Move your AdvancedCriteria object to arguments.advancedCriteria"));
                    }
                }
                boolean bl = wantsGrouping = args.get("groupBy") != null || args.get("summaryFunctions") != null;
                if (wantsGrouping && !MCPServlet.supportsAggregation(ds)) {
                    throw new UserError(-32602, "This DataSource does not allow aggregation (groupBy/summaryFunctions)", null);
                }
                List<String> groupBy = MCPServlet.asStringList(args.get("groupBy"));
                if (groupBy != null) {
                    try {
                        r.setGroupBy(groupBy);
                    }
                    catch (Throwable t) {
                        r.setAttribute("groupBy", groupBy);
                    }
                }
                if ((sf = args.get("summaryFunctions")) instanceof Map) {
                    Map raw = (Map)sf;
                    Map<String, String> incoming = raw.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
                    Map<String, SummaryFunctionType> summaryFunctions = r.convertMapOfStringToMapOfSummaryFunctionType(incoming);
                    try {
                        r.setSummaryFunctions(summaryFunctions);
                    }
                    catch (Throwable t) {
                        r.setAttribute("summaryFunctions", summaryFunctions);
                    }
                    break;
                }
                if (sf == null) break;
                throw new UserError(-32602, "summaryFunctions must be an object: { fieldName: functionName }", null);
            }
            case ADD: {
                break;
            }
            case UPDATE: {
                Map crit = r.getCriteria();
                if (crit == null || crit.isEmpty()) {
                    String pk = Optional.ofNullable(MCPServlet.primaryKeyFieldName(MCPServlet.tryGetDS(r.getDataSourceName()))).orElse("pk");
                    throw new UserError(-32602, "update requires non-empty arguments.criteria", Map.of("hint", "Pass {criteria:{" + pk + ":<id>}} plus a 'data' object with changes"));
                }
                r.setAllowMultiUpdate(true);
                break;
            }
            case REMOVE: {
                r.setValues(null);
                Map crit = r.getCriteria();
                if (crit == null || crit.isEmpty()) {
                    String pk = Optional.ofNullable(MCPServlet.primaryKeyFieldName(MCPServlet.tryGetDS(r.getDataSourceName()))).orElse("pk");
                    throw new UserError(-32602, "remove requires non-empty arguments.criteria", Map.of("hint", "Pass {criteria:{" + pk + ":<id>}} or another non-empty filter"));
                }
                r.setAllowMultiUpdate(true);
            }
        }
    }

    private Map<String, Object> toolsCall(JsonNode params) throws Exception {
        String tms;
        List<String> sortBy;
        Object d;
        Map args;
        if (params == null || params.isNull()) {
            throw new UserError(-32602, "Missing 'params'", null);
        }
        String name = MCPServlet.str(params.get("name"));
        if (name == null || name.isEmpty()) {
            throw new UserError(-32602, "Missing 'params.name'", null);
        }
        Map map = args = params.hasNonNull("arguments") ? (Map)M.convertValue((Object)params.get("arguments"), (TypeReference)new TypeReference<Map<String, Object>>(){}) : Collections.emptyMap();
        if (!name.startsWith("ds.") || name.split("\\.").length < 3) {
            throw new UserError(-32601, "Unknown tool: " + name, null);
        }
        String[] parts = name.split("\\.");
        String dsId = parts[1];
        Op op = MCPServlet.parseOp(parts[2]);
        DataSource ds = MCPServlet.tryGetDS(dsId);
        if (ds == null) {
            throw new UserError(-32602, "No such DataSource: " + dsId, null);
        }
        String dsOperationId = op == Op.FETCHADVANCED ? "fetch" : parts[2];
        DSRequest r = new DSRequest(dsId, dsOperationId);
        Object c = args.get("criteria");
        if (c instanceof Map) {
            Map m = (Map)c;
            r.setCriteria(m);
        }
        if ((d = args.get("data")) instanceof Map) {
            Map m = (Map)d;
            r.setValues(m);
        }
        Integer startRow = MCPServlet.asInt(args.get("startRow"));
        Integer endRow = MCPServlet.asInt(args.get("endRow"));
        if (startRow != null) {
            r.setStartRow(startRow.intValue());
        }
        if (endRow != null) {
            r.setEndRow(endRow.intValue());
        }
        if ((sortBy = MCPServlet.asStringList(args.get("sortBy"))) != null && !sortBy.isEmpty()) {
            if (op == Op.FETCH) {
                r.setSortBy(sortBy.get(0));
            } else {
                try {
                    r.setSortBy(sortBy);
                }
                catch (Throwable t) {
                    r.setAttribute("sortBy", sortBy);
                }
            }
        }
        if ((tms = MCPServlet.asString(args.get("textMatchStyle"))) != null) {
            r.setTextMatchStyle(tms);
        }
        this.applyOpValidations(op, args, r);
        DSResponse res = r.execute();
        if (res.getStatus() != 0) {
            LinkedHashMap<String, Object> errData = new LinkedHashMap<String, Object>();
            errData.put("status", res.getStatus());
            if (res.getErrors() != null) {
                errData.put("errors", res.getErrors());
            }
            throw new UserError(res.getStatus(), "DataSource error", errData);
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("status", res.getStatus());
        payload.put("totalRows", res.getTotalRows());
        payload.put("startRow", res.getStartRow());
        payload.put("endRow", res.getEndRow());
        List dataList = res.getDataList();
        payload.put("data", dataList != null ? dataList : Collections.emptyList());
        return MCPServlet.wrapJsonContent(M.writeValueAsString(payload));
    }

    private Map<String, Object> recordSchema(DataSource ds) {
        LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> required2 = new ArrayList<String>();
        for (DSField f : ds.getFields()) {
            String name = MCPServlet.fStr(f, "name");
            if (name == null) continue;
            props.put(name, this.schemaForField(f));
            if (!Boolean.TRUE.equals(MCPServlet.fBool(f, "required"))) continue;
            required2.add(name);
        }
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("title", ds.getID());
        schema.put("type", "object");
        schema.put("properties", props);
        if (!required2.isEmpty()) {
            schema.put("required", required2);
        }
        return schema;
    }

    private static Map<String, Object> criteriaSchema() {
        return Map.of("type", "object", "additionalProperties", true);
    }

    private static Map<String, Object> advancedCriteriaSchema() {
        return Map.of("type", "object", "properties", Map.of("_constructor", Map.of("type", "string", "const", "AdvancedCriteria"), "operator", Map.of("type", "string"), "criteria", Map.of("type", "array", "items", Map.of("type", "object"))), "additionalProperties", true);
    }

    private Map<String, Object> schemaForField(DSField f) {
        List validators;
        String fk;
        List list;
        Object vmRaw;
        Map<String, Object> base = MCPServlet.jsonTypeFor(f);
        LinkedHashMap<String, Object> s = new LinkedHashMap<String, Object>(base);
        if (Boolean.TRUE.equals(MCPServlet.fBool(f, "multiple"))) {
            s = new LinkedHashMap();
            s.put("type", "array");
            s.put("items", base);
        }
        if ((vmRaw = f.get("valueMap")) instanceof Map) {
            Map vm = (Map)vmRaw;
            List stored = vm.keySet().stream().map(String::valueOf).collect(Collectors.toList());
            if (!stored.isEmpty()) {
                s.put("enum", stored);
            }
            s.put("x-valueMapDisplay", new LinkedHashMap(vm));
        } else if (vmRaw instanceof List && !(list = (List)vmRaw).isEmpty()) {
            s.put("enum", list.stream().map(String::valueOf).collect(Collectors.toList()));
        }
        Integer minLen = MCPServlet.fInt(f, "minLength");
        Integer maxLen = MCPServlet.fInt(f, "maxLength");
        Number min2 = MCPServlet.fNum(f, "min");
        Number max2 = MCPServlet.fNum(f, "max");
        if (minLen != null) {
            s.put("minLength", minLen);
        }
        if (maxLen != null) {
            s.put("maxLength", maxLen);
        }
        if (min2 != null) {
            s.put("minimum", min2);
        }
        if (max2 != null) {
            s.put("maximum", max2);
        }
        Integer precision = MCPServlet.fInt(f, "precision");
        Integer scale = MCPServlet.fInt(f, "scale");
        if (precision != null) {
            s.put("x-precision", precision);
        }
        if (scale != null) {
            s.put("x-scale", scale);
        }
        if (Boolean.TRUE.equals(MCPServlet.fBool(f, "primaryKey"))) {
            s.put("x-primaryKey", true);
        }
        if ((fk = MCPServlet.fStr(f, "foreignKey")) != null) {
            s.put("x-foreignKey", fk);
        }
        LinkedHashMap<String, Object> xui = new LinkedHashMap<String, Object>();
        Boolean canEdit = MCPServlet.fBool(f, "canEdit");
        Boolean hidden = MCPServlet.fBool(f, "hidden");
        String roDisp = MCPServlet.fStr(f, "readOnlyDisplay");
        if (canEdit != null) {
            xui.put("canEdit", canEdit);
        }
        if (hidden != null) {
            xui.put("hidden", hidden);
        }
        if (roDisp != null) {
            xui.put("readOnlyDisplay", roDisp);
        }
        if (!xui.isEmpty()) {
            s.put("x-ui", xui);
        }
        LinkedHashMap<String, String> xrel = new LinkedHashMap<String, String>();
        String optDS = MCPServlet.fStr(f, "optionDataSource");
        String dFld = MCPServlet.fStr(f, "displayField");
        String vFld = MCPServlet.fStr(f, "valueField");
        if (optDS != null) {
            xrel.put("optionDataSource", optDS);
        }
        if (dFld != null) {
            xrel.put("displayField", dFld);
        }
        if (vFld != null) {
            xrel.put("valueField", vFld);
        }
        if (!xrel.isEmpty()) {
            s.put("x-rel", xrel);
        }
        if ((validators = MCPServlet.fList(f, "validators")) != null && !validators.isEmpty()) {
            ArrayList<Map<String, String>> notes = new ArrayList<Map<String, String>>();
            for (Object v : validators) {
                notes.add(Map.of("note", String.valueOf(v)));
            }
            s.put("x-validator", notes);
        }
        return s;
    }

    private static Map<String, Object> jsonTypeFor(DSField f) {
        String t = String.valueOf(MCPServlet.fStr(f, "type")).toLowerCase(Locale.ROOT);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        switch (t) {
            case "int": 
            case "integer": {
                m.put("type", "integer");
                break;
            }
            case "float": 
            case "double": 
            case "decimal": {
                m.put("type", "number");
                break;
            }
            case "boolean": {
                m.put("type", "boolean");
                break;
            }
            case "date": {
                m.put("type", "string");
                m.put("format", "date");
                break;
            }
            case "datetime": {
                m.put("type", "string");
                m.put("format", "date-time");
                break;
            }
            case "time": {
                m.put("type", "string");
                m.put("format", "time");
                break;
            }
            default: {
                m.put("type", "string");
            }
        }
        return m;
    }

    private static String primaryKeyFieldName(DataSource ds) {
        for (DSField f : ds.getFields()) {
            if (!Boolean.TRUE.equals(f.getBoolean("primaryKey"))) continue;
            return f.getString("name");
        }
        return null;
    }

    private static Map<String, Object> wrapJsonContent(String jsonText) {
        return Map.of("content", List.of(Map.of("type", "json", "text", jsonText)));
    }

    private void writeJsonRpcResult(HttpServletResponse resp, JsonNode idNode, Map<String, Object> result) throws IOException {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        out.put("jsonrpc", "2.0");
        out.put("id", idNode == null || idNode.isNull() ? null : M.convertValue((Object)idNode, Object.class));
        out.put("result", result);
        M.writeValue((OutputStream)resp.getOutputStream(), out);
    }

    private void writeJsonRpcError(HttpServletResponse resp, JsonNode idNode, int code, String message, Object data) throws IOException {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        out.put("jsonrpc", "2.0");
        out.put("id", idNode == null || idNode.isNull() ? null : M.convertValue((Object)idNode, Object.class));
        LinkedHashMap<String, Object> err = new LinkedHashMap<String, Object>();
        err.put("code", code);
        err.put("message", message);
        if (data != null) {
            err.put("data", data);
        }
        out.put("error", err);
        M.writeValue((OutputStream)resp.getOutputStream(), out);
    }

    private static String str(JsonNode n) {
        return n == null || n.isNull() ? null : n.asText();
    }

    private static String asString(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    private static Integer asInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(o));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> asStringList(Object o) {
        if (o instanceof List) {
            List l = (List)o;
            return l.stream().map(String::valueOf).collect(Collectors.toList());
        }
        return null;
    }

    private static Boolean fBool(DSField f, String k) {
        return f.getBoolean(k);
    }

    private static Integer fInt(DSField f, String k) {
        return f.getInteger(k);
    }

    private static Number fNum(DSField f, String k) {
        return (Number)f.get(k);
    }

    private static String fStr(DSField f, String k) {
        return f.getString(k);
    }

    private static <T> List<T> fList(DSField f, String k) {
        Object v = f.get(k);
        return v instanceof List ? (List)v : null;
    }

    private static boolean isAdvancedCriteria(Object criteria) {
        if (!(criteria instanceof Map)) {
            return false;
        }
        Map m = (Map)criteria;
        Object ctor = m.get("_constructor");
        if ("AdvancedCriteria".equals(String.valueOf(ctor))) {
            return true;
        }
        return m.containsKey("operator") && m.containsKey("criteria");
    }

    private static boolean supportsAdvancedCriteria(DataSource ds) {
        try {
            Method m = ds.getClass().getMethod("allowAdvancedCriteria", new Class[0]);
            m.setAccessible(true);
            Object v = m.invoke((Object)ds, new Object[0]);
            if (v instanceof Boolean) {
                Boolean b = (Boolean)v;
                return b;
            }
            if (v != null) {
                return Boolean.parseBoolean(String.valueOf(v));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean supportsAggregation(DataSource ds) {
        try {
            Method m = ds.getClass().getMethod("allowAggregation", new Class[0]);
            m.setAccessible(true);
            Object v = m.invoke((Object)ds, new Object[0]);
            if (v instanceof Boolean) {
                Boolean b = (Boolean)v;
                return b;
            }
            if (v != null) {
                return Boolean.parseBoolean(String.valueOf(v));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static DataSource tryGetDS(String id) {
        if (id == null) {
            return null;
        }
        try {
            return DataSourceManager.getDataSource(id);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static class UserError
    extends RuntimeException {
        final int code;
        final Object data;

        UserError(int code, String msg, Object data) {
            super(msg);
            this.code = code;
            this.data = data;
        }
    }

    private static enum Op {
        FETCH,
        ADD,
        UPDATE,
        REMOVE,
        FETCHADVANCED;

    }
}

