/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, ButtonItem, CheckboxItem, DynamicForm, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onShowContractClick = function () {
    employeeTree.filterData({ EmployeeType: 'contract' });
};
let onShowFullTimeClick = function () {
    employeeTree.filterData({ EmployeeType: 'full time' });
};
let onShowEngineersClick = function () {
    var criteria = {
        _constructor: 'AdvancedCriteria',
        operator: 'and',
        criteria: [{
                fieldName: 'Job',
                operator: 'iContains',
                value: 'engineer'
            }]
    };
    employeeTree.filterData(criteria);
};
let onKeepParentsChanged = function (form, item, value) {
    createTreeGrid(employeeTree.getCriteria(), value);
};

var employeeTree;
function createTreeGrid(criteria, keepParents) {
    mainLayout.removeMember(employeeTree);
    employeeTree = isc.TreeGrid.create({
        width: 600,
        height: 400,
        dataSource: 'employees',
        autoFetchData: true,
        loadDataOnDemand: true,
        showFilterEditor: true,
        filterOnKeypress: true,
        keepParentsOnFilter: keepParents,
        initialCriteria: criteria,
        autoOpenTree: 'all',
        fields: [
            {
                name: 'Name',
                title: 'Employee'
            },
            {
                name: 'Job',
                title: 'Job Title'
            },
            {
                name: 'EmployeeType',
                title: 'Employee Type'
            }
        ]
    });
    mainLayout.addMember(employeeTree);
}

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="5" ID="mainLayout" width="100%" height="100%">
        <members>
            <DynamicForm numCols="8" width="600">
                <fields>
                    <ButtonItem name="showContract" title="Show Contract" startRow="false" endRow="false" click={onShowContractClick}/>
                    <ButtonItem name="showFullTime" title="Show Full Time" startRow="false" endRow="false" click={onShowFullTimeClick}/>
                    <ButtonItem name="showEngineers" title="Show Engineers" startRow="false" endRow="false" click={onShowEngineersClick}/>
                    <CheckboxItem showTitle="false" name="keepParents" title="Keep parents" value="true" startRow="false" endRow="false" changed={onKeepParentsChanged}/>
                </fields>
            </DynamicForm>
        </members>
    </VLayout>,
    document.getElementById(target)
);

createTreeGrid({}, true);
