/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, DynamicForm, HLayout, IButton, LGField, ListGrid, SelectItem, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onDsSelectorChanged = function (form, item, value) {
    if (value == 'ScienceStudies') {
        scienceStudiesLayout.show();
        worldLayout.hide();
    } else {
        scienceStudiesLayout.hide();
        worldLayout.show();
    }
};
let onIVPumpSafetyClick = function () {
    var prompt = 'Select only those abstracts that specifically relate to IV Pump Safety.';
    lgScienceStudies.filterViaAI(prompt);
};
let onGeneTherapyDeliveryClick = function () {
    var prompt = 'Select only those abstracts that specifically relate to Gene Therapy delivery.';
    lgScienceStudies.filterViaAI(prompt);
};
let onCustomPromptClick = function () {
    lgScienceStudies.showAIFilterWindow();
};

var exampleFilterDescriptions = [
    'in the Northern Hemisphere',
    'Spanish is one of the official languages',
    'in the Caribbean'
];

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="15" width="100%" height="100%">
        <members>
            <DynamicForm ID="form" width="600">
                <items>
                    <SelectItem name="dsSelector" title="DataSource" defaultValue="ScienceStudies" required="true" changed={onDsSelectorChanged}>
                        <valueMap>
                                <value>ScienceStudies</value>
                                <value>worldDS</value>
                        </valueMap>
                    </SelectItem>
                </items>
            </DynamicForm>
            <VLayout membersMargin="10" ID="scienceStudiesLayout" width="100%" height="100%">
                <members>
                    <HLayout membersMargin="10" width="*">
                        <members>
                            <IButton title="IV Pump Safety" width="200" prompt="Show some studies focused on infusion device safety—alarm performance, interface usability, error reduction, and patient risk mitigation" click={onIVPumpSafetyClick}/>
                            <IButton title="Gene Therapy Delivery" width="200" prompt="Show some studies demonstrating significant clinical outcomes—patient recovery, practice guideline updates, or treatment advances in infusion therapy" click={onGeneTherapyDeliveryClick}/>
                            <IButton title="Custom Prompt" click={onCustomPromptClick}/>
                        </members>
                    </HLayout>
                    <ListGrid ID="lgScienceStudies" sortField="Title" dataSource="ScienceStudies" autoFetchData="true" width="100%" height="100%" filterViaAIMode="AIDE">
                        <fields>
                            <LGField name="Study_ID" width="150"/>
                            <LGField name="Title" width="150" showHover="true" hoverWidth="300"/>
                            <LGField name="Authors" width="150"/>
                            <LGField name="Journal" width="150"/>
                            <LGField name="Year" width="150"/>
                            <LGField name="Abstract" width="*" showHover="true" hoverWidth="500"/>
                        </fields>
                    </ListGrid>
                </members>
            </VLayout>
            <VLayout membersMargin="12" ID="worldLayout" width="100%" height="100%" visibility="hidden">
                <members>
                    <HLayout members={[isc.Label.create({
        height: '30',
        contents: 'Examples: ',
        autoFit: true
    })].concat(exampleFilterDescriptions.map(function (exampleFilterDescription) {
    return isc.IButton.create({
        title: '"' + exampleFilterDescription + '"',
        prompt: exampleFilterDescription,
        autoFit: true,
        click: function () {
            grid.filterViaAI(exampleFilterDescription);
        }
    });
})).concat(isc.IButton.create({
    title: 'Custom Prompt',
    click: function () {
        grid.showAIFilterWindow();
    }
}))} membersMargin="6" width="100%" height="*"/>
                    <ListGrid ID="grid" sortField="countryName" dataSource="worldDS" autoFetchData="true" width="100%" height="100%" dataFetchMode="local" filterViaAIMode="AIDE">
                        <implicitCriteria fieldName="continent" operator="inSet">
                            <value>North America</value>
                            <value>Australia/Oceania</value>
                        </implicitCriteria>
                    </ListGrid>
                </members>
            </VLayout>
        </members>
    </VLayout>,
    document.getElementById(target)
);
