import React from 'react';
import { DropZone, DropZoneProps } from './DropZone';
import { AsComponentXML } from './core/ReactComponent';


declare interface FileDropZoneProps extends DropZoneProps {

/**
 * See {@link isc.FileDropZone.videoFileIcon FileDropZone.videoFileIcon}.
 */
videoFileIcon?: string;

/**
 * See {@link isc.FileDropZone.audioFileIcon FileDropZone.audioFileIcon}.
 */
audioFileIcon?: string;

/**
 * See {@link isc.FileDropZone.minSize FileDropZone.minSize}.
 */
minSize?: number;

/**
 * See {@link isc.FileDropZone.getProcessingPercentDone() FileDropZone.getProcessingPercentDone()}.
 */
getProcessingPercentDone?: Function;

/**
 * See {@link isc.FileDropZone.archiveFileIcon FileDropZone.archiveFileIcon}.
 */
archiveFileIcon?: string;

/**
 * See {@link isc.FileDropZone.defaultFileIcon FileDropZone.defaultFileIcon}.
 */
defaultFileIcon?: string;

/**
 * See {@link isc.FileDropZone.showDropError() FileDropZone.showDropError()}.
 */
showDropError?: Function;

/**
 * See {@link isc.FileDropZone.spreadsheetFileIcon FileDropZone.spreadsheetFileIcon}.
 */
spreadsheetFileIcon?: string;

/**
 * See {@link isc.FileDropZone.fileUploadFailed() FileDropZone.fileUploadFailed()}.
 */
fileUploadFailed?: Function;

/**
 * See {@link isc.FileDropZone.codeFileIcon FileDropZone.codeFileIcon}.
 */
codeFileIcon?: string;

/**
 * See {@link isc.FileDropZone.fileUploadComplete() FileDropZone.fileUploadComplete()}.
 */
fileUploadComplete?: Function;

/**
 * See {@link isc.FileDropZone.showFileThumbnails FileDropZone.showFileThumbnails}.
 */
showFileThumbnails?: boolean;

/**
 * See {@link isc.FileDropZone.baseStyle FileDropZone.baseStyle}.
 */
baseStyle?: string;

/**
 * See {@link isc.FileDropZone.setProcessingProgress() FileDropZone.setProcessingProgress()}.
 */
setProcessingProgress?: Function;

/**
 * See {@link isc.FileDropZone.filesRemoved() FileDropZone.filesRemoved()}.
 */
filesRemoved?: Function;

/**
 * See {@link isc.FileDropZone.getSize() FileDropZone.getSize()}.
 */
getSize?: Function;

/**
 * See {@link isc.FileDropZone.clearFiles() FileDropZone.clearFiles()}.
 */
clearFiles?: Function;

/**
 * See {@link isc.FileDropZone.progressTextProperties FileDropZone.progressTextProperties}.
 */
progressTextProperties?: Label;

/**
 * See {@link isc.FileDropZone.documentFileIcon FileDropZone.documentFileIcon}.
 */
documentFileIcon?: string;

/**
 * See {@link isc.FileDropZone.maxFileSize FileDropZone.maxFileSize}.
 */
maxFileSize?: number;

/**
 * See {@link isc.FileDropZone.pdfFileIcon FileDropZone.pdfFileIcon}.
 */
pdfFileIcon?: string;

/**
 * See {@link isc.FileDropZone.replaceFilesOnDrop FileDropZone.replaceFilesOnDrop}.
 */
replaceFilesOnDrop?: boolean;

/**
 * See {@link isc.FileDropZone.removeFile() FileDropZone.removeFile()}.
 */
removeFile?: Function;

/**
 * See {@link isc.FileDropZone.imageFileIcon FileDropZone.imageFileIcon}.
 */
imageFileIcon?: string;

/**
 * See {@link isc.FileDropZone.maxSize FileDropZone.maxSize}.
 */
maxSize?: number;

/**
 * See {@link isc.FileDropZone.valign FileDropZone.valign}.
 */
valign?: string;

/**
 * See {@link isc.FileDropZone.cancelProcessing() FileDropZone.cancelProcessing()}.
 */
cancelProcessing?: Function;

/**
 * See {@link isc.FileDropZone.progressLabelProperties FileDropZone.progressLabelProperties}.
 */
progressLabelProperties?: Label;

/**
 * See {@link isc.FileDropZone.thumbnailWidth FileDropZone.thumbnailWidth}.
 */
thumbnailWidth?: number;

/**
 * See {@link isc.FileDropZone.acceptedFileTypes FileDropZone.acceptedFileTypes}.
 */
acceptedFileTypes?: string[];

/**
 * See {@link isc.FileDropZone.showCancelButton FileDropZone.showCancelButton}.
 */
showCancelButton?: boolean;

/**
 * See {@link isc.FileDropZone.align FileDropZone.align}.
 */
align?: string;

/**
 * See {@link isc.FileDropZone.removeIcon FileDropZone.removeIcon}.
 */
removeIcon?: string;

/**
 * See {@link isc.FileDropZone.filesAdded() FileDropZone.filesAdded()}.
 */
filesAdded?: Function;

/**
 * See {@link isc.FileDropZone.getFiles() FileDropZone.getFiles()}.
 */
getFiles?: Function;

/**
 * See {@link isc.FileDropZone.setFiles() FileDropZone.setFiles()}.
 */
setFiles?: Function;

/**
 * See {@link isc.FileDropZone.canAddFilesOnClick FileDropZone.canAddFilesOnClick}.
 */
canAddFilesOnClick?: boolean;

/**
 * See {@link isc.FileDropZone.multiple FileDropZone.multiple}.
 */
multiple?: boolean;

/**
 * See {@link isc.FileDropZone.thumbnailHeight FileDropZone.thumbnailHeight}.
 */
thumbnailHeight?: number;

/**
 * See {@link isc.FileDropZone.setFileProgress() FileDropZone.setFileProgress()}.
 */
setFileProgress?: Function;

/**
 * See {@link isc.FileDropZone.progressBarProperties FileDropZone.progressBarProperties}.
 */
progressBarProperties?: Progressbar;

/**
 * See {@link isc.FileDropZone.processingCancelled() FileDropZone.processingCancelled()}.
 */
processingCancelled?: Function;

/**
 * See {@link isc.FileDropZone.showImagePreviews FileDropZone.showImagePreviews}.
 */
showImagePreviews?: boolean;

/**
 * See {@link isc.FileDropZone.startProcessing() FileDropZone.startProcessing()}.
 */
startProcessing?: Function;

/**
 * See {@link isc.FileDropZone.cancelButtonProperties FileDropZone.cancelButtonProperties}.
 */
cancelButtonProperties?: Button;

/**
 * See {@link isc.FileDropZone.endProcessing() FileDropZone.endProcessing()}.
 */
endProcessing?: Function;

/**
 * See {@link isc.FileDropZone.maxFiles FileDropZone.maxFiles}.
 */
maxFiles?: number;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * FileDropZone wraps the SmartClient widget class
 * {@link isc.FileDropZone FileDropZone} for React, allowing you to import
 * FileDropZone for use in React JS and JSX.
 * @class
 * @extends DropZone
 */
declare class FileDropZone extends DropZone {
    props: AsComponentXML<FileDropZoneProps>;
}
