isc.docVersionInfo={scVersionNumber:"15.0",edition:"Evaluation",scVersion:"15.0d",versionNumber:"SNAPSHOT_v15.0d_2026-02-19",version:"SNAPSHOT_v15.0d_2026-02-19/EVAL Deployment"};isc.docItems={"attr:FormSetFieldValueTask.targetField":{seeAlso:[],ref:"attr:FormSetFieldValueTask.targetField",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FormSetFieldValueTask",valueType:"FieldName",description:"Field to assign new value.",flags:"IR",name:"targetField"},"classMethod:TabIndexManager.getTabIndex":{seeAlso:[],ref:"classMethod:TabIndexManager.getTabIndex",deprecated:null,type:"classMethod",definingClass:"class:TabIndexManager",params:[{defaultValue:null,optional:false,type:"String",description:"ID of the target for which you want to get a numeric tabIndex.",name:"ID"}],description:" Returns a tabIndex number for some target ID registered via ${isc.DocUtils.linkForRef('classMethod:TabIndexManager.addTarget')}.\n Generated tab indices are guaranteed to be in order.\n <P>\n As targets are added to, or moved within the TabIndexManager, their tab index may become invalid.\n The <code>tabIndexUpdated</code> notification will be fired when this occurs, giving developers\n a way to pick up the new tab index, and assign it to the appropriate DOM element if appropriate.\n",flags:"",returns:{type:"Integer",description:"returns the numeric tabIndex value for the specified target"},name:"getTabIndex"},"method:EventStream.end":{seeAlso:[{ref:"attr:EventStream.autoStart",description:null},{ref:"method:EventStream.start",description:null}],ref:"method:EventStream.end",deprecated:null,type:"method",definingClass:"class:EventStream",description:" Ends event capturing and returns the ${isc.DocUtils.linkForRef('object:EventStreamData')}.  Once ended, capturing\n cannot be restarted without losing all stored events.\n",flags:"",returns:{type:"EventStreamData",description:null},name:"end"},"method:PickList.dataArrived":{seeAlso:[],ref:"method:PickList.dataArrived",deprecated:null,type:"method",definingClass:"interface:PickList",params:[{defaultValue:null,optional:false,type:"int",description:"index of first row returned by the server",name:"startRow"},{defaultValue:null,optional:false,type:"int",description:"index of last row returned by the server",name:"endRow"},{defaultValue:null,optional:false,type:"ResultSet",description:"pointer to this pickList's data",name:"data"}],description:" If this item is showing a dataBound pickList, this notification method will be fired \n when new data arrives from the server.\n",flags:"",name:"dataArrived"},"attr:SelectItem.fetchDisplayedFieldsOnly":{seeAlso:[],ref:"attr:SelectItem.fetchDisplayedFieldsOnly",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SelectItem",valueType:"boolean",description:"If this item has a specified <code>optionDataSource</code> and this property is\n <code>true</code>, the list of fields used by this pickList will be passed to\n the datasource as ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')}. If the datasource supports this feature\n the returned fields will be limited to this list. A custom datasource will need to\n add code to implement field limiting.\n <P>\n This list of used fields consists of the values of ${isc.DocUtils.linkForRef('attr:FormItem.valueField','valueField')},\n ${isc.DocUtils.linkForRef('attr:FormItem.displayField','displayField')} and ${isc.DocUtils.linkForRef('attr:SelectItem.pickListFields','pickListFields')}.\n <P>\n NOTE: When enabled, ${isc.DocUtils.linkForRef('method:FormItem.getSelectedRecord','getSelectedRecord')} will only include the\n fetched fields.",flags:"IRA",name:"fetchDisplayedFieldsOnly"},"class:SendEmailTask":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"ProcessElement",classMethods:[],classAttrs:[],attrs:["attr:SendEmailTask.to","attr:SendEmailTask.subject","attr:SendEmailTask.subjectFormula","attr:SendEmailTask.message","attr:SendEmailTask.mockModeNotifyMessage","attr:SendEmailTask.failureElement","attr:SendEmailTask.requestProperties"],ref:"class:SendEmailTask",deprecated:null,treeLocation:["Client Reference/Workflow"],description:"Sends the specified message via email or ${isc.DocUtils.linkForRef('class:Notify','notification')}.\n\n <p>\n Email is sent using the ${isc.DocUtils.linkForRef('group:reifyMessaging')} <code>isc_sendEmail</code> DataSource.\n Refer to ${isc.DocUtils.linkForRef('class:Mail','Mail overview')} to know how to set up access to an SMTP server.\n\n <p>\n There is a matching Reify Workflow Editor task editor, ${isc.DocUtils.linkForRef('class:SendEmailTaskEditor')}, that\n can be enabled by ${isc.DocUtils.linkForRef('attr:Reify.enableSendEmailTaskEditor')}.\n <p>\n If ${isc.DocUtils.linkForRef('attr:Process.mockMode','mock mode')} is enabled, instead of sending an email a\n ${isc.DocUtils.linkForRef('attr:SendEmailTask.mockModeNotifyMessage','notification message')} is shown instead.",methods:[],name:"SendEmailTask"},"method:ColorItem.pickerColorSelected":{seeAlso:[],ref:"method:ColorItem.pickerColorSelected",deprecated:null,type:"method",definingClass:"class:ColorItem",params:[{defaultValue:null,optional:false,type:"String",description:"The selected color as a string.",name:"color"},{defaultValue:null,optional:false,type:"Integer",description:"The selected opacity, from 0 (transparent) to 100 (opaque),                          or null if ${isc.DocUtils.linkForRef('attr:ColorItem.supportsTransparency')} is false or the\n                          ${isc.DocUtils.linkForRef('class:ColorPicker','color picker')} selected a color while in\n                          ${isc.DocUtils.linkForRef('type:ColorPickerMode','simple mode')}.",name:"opacity"}],description:" Store the color value selected by the user from the color picker.  You will need to \n override this method if you wish to capture opacity information from the\n ${isc.DocUtils.linkForRef('class:ColorPicker')}.\n",flags:"",name:"pickerColorSelected"},"attr:DataSource.canAggregate":{seeAlso:[{ref:"group:serverSummaries",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DataSource",groups:["serverSummaries"],ref:"attr:DataSource.canAggregate",deprecated:null,valueType:"boolean",description:"By default, all DataSources are assumed to be capable of handling \n ${isc.DocUtils.linkForRef('group:serverSummaries')} on fetch or filter type operations.  This property may be\n set to <code>false</code> to indicate that this dataSource does not support \n serverSummaries.\n <p>\n <b>NOTE:</b> If you specify this property in a DataSource descriptor \n (<code>.ds.xml</code> file), it is enforced on the server.  This means that if you run \n a request containing serverSummaries against a DataSource that advertises itself as \n <code>canAggregate:false</code>, it will be rejected.",flags:"IRWA",serverDS:"allowed",name:"canAggregate"},"attr:MultiSortDialog.deleteLevelButton":{seeAlso:[],ref:"attr:MultiSortDialog.deleteLevelButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:MultiSortDialog",valueType:"AutoChild IButton",description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for deleting levels\n from the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.deleteLevelButtonProperties</code> and \n <code>multiSortPanel.deleteLevelButtonDefaults</code>.",flags:"RA",name:"deleteLevelButton"},"attr:SectionItem.editProxyConstructor":{seeAlso:[],ref:"attr:SectionItem.editProxyConstructor",defaultValue:'"SectionItemEditProxy"',deprecated:null,type:"attr",definingClass:"class:SectionItem",valueType:"SCClassName",description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",flags:"IR",name:"editProxyConstructor"},"method:SimpleType.getGroupValue":{seeAlso:[],ref:"method:SimpleType.getGroupValue",deprecated:null,type:"method",definingClass:"class:SimpleType",params:[{defaultValue:null,optional:false,type:"Any",description:"the record value to return a group value for",name:"value"},{defaultValue:null,optional:false,type:"Record",description:"the record containing the passed value",name:"record"},{defaultValue:null,optional:false,type:"Object",description:"the field relating to the value to be processed",name:"field"},{defaultValue:null,optional:false,type:"String",description:"the name of the field relating to the value to be processed",name:"fieldName"},{defaultValue:null,optional:false,type:"Canvas",description:"the component, usually a ${isc.DocUtils.linkForRef('class:ListGrid')}, containing the                           passed record",name:"component"}],description:" Returns a group value appropriate for the passed record, field and value, in the passed \n component.\n \n",flags:"",returns:{type:"Any",description:"the group value for the passed parameters"},name:"getGroupValue"},"attr:ListGrid.clipHeaderTitles":{seeAlso:[{ref:"attr:ListGrid.headerBaseStyle",description:null}],defaultValue:"varies",type:"attr",definingClass:"class:ListGrid",groups:["gridHeader","appearance"],deprecated:null,ref:"attr:ListGrid.clipHeaderTitles",valueType:"Boolean",description:"Whether the ListGrid should manage the clipping of titles of header buttons, showing\n ellipses if the title is clipped, and potentially showing the full title\n on ${isc.DocUtils.linkForRef('attr:ListGrid.showClippedHeaderTitlesOnHover','hover')}.\n <p>\n In some cases this may be preferable to the button component's default clipping behavior\n because if a ${isc.DocUtils.linkForRef('attr:ListGrid.showSortArrow','sort arrow')} or sort numeral is displayed for\n a header, then the button's default clipping behavior may clip the sort arrow/numeral\n whereas ListGrid-managed title clipping utilizes special HTML which keeps the sort\n arrow/numeral visible.\n <p>\n This feature is automatically enabled if supported by the browser. The only supported\n use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles\n to false.\n <P>\n Note that this feature is incompatible with ${isc.DocUtils.linkForRef('attr:ListGridField.wrap')}, and will\n automatically be disabled for wrapping fields.",flags:"IRA",name:"clipHeaderTitles"},"attr:CubeGrid.valueFormat":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:CubeGrid",groups:["exportFormatting"],deprecated:null,ref:"attr:CubeGrid.valueFormat",valueType:"FormatString",description:"${isc.DocUtils.linkForRef('type:FormatString')} for numeric or date formatting.  See ${isc.DocUtils.linkForRef('attr:DataSourceField.format')}.",flags:"IR",name:"valueFormat"},"attr:ListGrid.hiliteCanReplaceValue":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["hiliting"],deprecated:null,ref:"attr:ListGrid.hiliteCanReplaceValue",valueType:"boolean",description:'If set, end users can create advanced hiliting rules that will use the\n ${isc.DocUtils.linkForRef(\'attr:Hilite.replacementValue\')} feature to cause values in hilited cells\n to be replaced with a user-entered value.  For example, a user could create a hilite rule\n that replaces numeric values ranging from 0.5 to 1.0 with the text "LOW".\n <p>\n Specifically, when the "Add Advanced Rule" button is pressed and\n <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled\n "Replace value with" (${isc.DocUtils.linkForRef(\'attr:ListGrid.hiliteReplaceValueFieldTitle\')}) and if they enter a value, that\n value will appear in the grid cell in lieu of the cell\'s original value.',flags:"IR",name:"hiliteCanReplaceValue"},"group:reifyMessaging":{refs:[],seeAlso:[],ref:"group:reifyMessaging",deprecated:null,type:"group",title:"Reify Messaging",description:"<P>Reify allows you to send two different kind of messages from your applications: Email and SMS.\n <P><b>Email</b>\n <P>\n There is a special DataSource named 'isc_sendEmail', which you can directly use from your app.\n The following fields are required to send this kind of message:\n <P>\n <ul>\n <li><b>to</b>: indicates the email accounts of the destinataries. Use commas (',') in order \n to use more than one destinatary.</li>\n <li><b>subject</b>: indicates the topic of the email.</li>\n <li><b>message</b>: indicates the message to send.</li>\n </ul>\n <P>\n You need to set up the following entry in the server.properties file in order to use this feature:\n <ul>\n <li><b>reify.emailFrom</b>: the email account used as 'from' in the email message.</li>\n </ul>\n <P>\n Also, you can check the ${isc.DocUtils.linkForRef('class:Mail','Mail overview')} to know how to set up access to an SMTP server\n and complete the configuration to use this feature.\n \n <P><b>SMS</b>\n <P>\n There is a special DataSource named 'isc_sendSMS', which you can directly use from your app.\n The following fields are required to send this kind of message:\n <ul>\n <li><b>to</b>: phone numbers of the destinataries that will receive the message. \n Use commas (',') in order to use more than one phone number.</li>\n <li><b>message</b>: message to send.</li>\n </ul>\n <P>\n Also, Reify uses a specific Twilio library to achieve this. You need to set up the following entries\n in the server.properties file in order to use this feature:\n <ul>\n <li><b>twilio.ACCOUNT_SID</b>: identifier of the account, which acts as a username.</li>\n <li><b>twilio.AUTH_TOKEN</b>: acts as a password.</li>\n <li><b>twilio.twilioPhoneNumber</b>: Twilio phone number you get when setting up your account in Twilio.</li>\n </ul>\n <P>\n You need to register in the Twilio website and set up your account in order to get the required values.",name:"reifyMessaging"},"method:DataSource.getFieldOperators":{seeAlso:[],type:"method",definingClass:"class:DataSource",returns:{type:"Array of OperatorId",description:"available Operators"},groups:["advancedFilter"],deprecated:null,ref:"method:DataSource.getFieldOperators",params:[{defaultValue:null,optional:false,type:"String | DataSourceField",description:"Field (or field name) to obtain operators for",name:"field"}],description:" Get the list of ${isc.DocUtils.linkForRef('type:OperatorId')}s available for this field.\n <P>\n By default, if ${isc.DocUtils.linkForRef('attr:DataSourceField.validOperators','field.validOperators')} is set,\n returns that list, otherwise returns the result of ${isc.DocUtils.linkForRef('method:DataSource.getTypeOperators')}.\n",flags:"",name:"getFieldOperators"},"method:Array.find":{seeAlso:[{ref:"classMethod:DataSource.isAdvancedCriteria",description:null}],type:"method",definingClass:"object:Array",returns:{type:"Object",description:"first matching object or null if not found"},groups:["access","find"],deprecated:null,ref:"method:Array.find",params:[{defaultValue:null,optional:false,type:"String | Object | AdvancedCriteria",description:"property to match, or if an Object is passed, set of                                        properties and values to match",name:"propertyName"},{defaultValue:null,optional:true,type:"Any",description:"value to compare against (if propertyName is a string)",name:"value"}],description:" Like ${isc.DocUtils.linkForRef('method:Array.findIndex')}, but returns the object itself instead of its index.\n <P>\n When an Object is passed as the first argument, ${isc.DocUtils.linkForRef('classMethod:DataSource.isAdvancedCriteria')}\n is used to determine if it should be treated as ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}. If the list has an\n associated ${isc.DocUtils.linkForRef('attr:ResultSet.dataSource','dataSource')}, it is passed to\n <code>isAdvancedCriteria()</code> for enhanced detection. See <code>isAdvancedCriteria()</code>\n for details on the heuristics used to detect AdvancedCriteria format.\n\n",flags:"",name:"find"},"method:TabSet.tabIconClick":{seeAlso:[],ref:"method:TabSet.tabIconClick",deprecated:null,type:"method",definingClass:"class:TabSet",params:[{defaultValue:null,optional:false,type:"Tab",description:"with click handler being fired",name:"tab"}],description:" Method fired when the user clicks the icon for a tab, as specified via ${isc.DocUtils.linkForRef('attr:Tab.icon')}.\n <P>\n Default behavior will fire <code>icon.click()</code> if specified, with two parameters\n <code>tab</code> (a pointer to the tab object and <code>tabSet</code> a pointer to the tabSet\n instance.\n",flags:"",name:"tabIconClick"},"attr:ListGrid.filterByCell":{seeAlso:[{ref:"attr:ListGrid.fetchDelay",description:null}],defaultValue:"true",type:"attr",definingClass:"class:ListGrid",groups:["filterEditor"],deprecated:null,ref:"attr:ListGrid.filterByCell",valueType:"boolean",description:"If we're showing the ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filterEditor')}, should this list\n be filtered every time the user changes edit values for particular cells rather than\n waiting for an Enter keypress or a click on the filterEditor submit button.\n <P>\n Note that by default fields in the filter editor will be set to \n ${isc.DocUtils.linkForRef('attr:FormItem.changeOnKeypress','changeOnKeypress:false')}, so the grid will not filter as\n the user types in text-based items.<br>\n To enable filtering as the user types in text fields, we recommend the \n ${isc.DocUtils.linkForRef('attr:ListGrid.filterOnKeypress')} attribute. Also note that <code>filterOnKeypress:true</code>\n implies filtering will occur on change to edit values for cells, even if <code>filterByCell</code>\n is not set to true.",flags:"IRWA",name:"filterByCell"},"attr:DynamicForm.checkFileAccessOnSubmit":{seeAlso:[],ref:"attr:DynamicForm.checkFileAccessOnSubmit",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:DynamicForm",valueType:"boolean",description:"For dynamicForms containing a ${isc.DocUtils.linkForRef('class:FileItem')} for uploading files,\n should the browser verify that the file is accessible before submitting\n the uploaded file to the server?\n <P>\n In some cases the browser may not be able to access the selected file.<br>\n This can occur when the file has been modified in the file system after selection in the\n browser, or if the current user doesn't have permission to view the file.\n <P>\n By default, before submitting the file to the server\n the browser will verify that it can access the file's contents and display \n the ${isc.DocUtils.linkForRef('attr:DynamicForm.fileAccessFailedWarning')} if file access fails.<br>\n Note that accessing the file's contents is an asynchronous process, so\n form submission is not performed synchronously.\n <P>\n This means that if application code calls ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} on a form containing a\n fileItem and then synchronously ${isc.DocUtils.linkForRef('method:Canvas.clear','clears')} it from the DOM, the upload will\n never be kicked off.<br>\n Setting <code>checkFileAccessOnSubmit</code> to false will suppress the (asynchronous) check, \n and can be used to bypass this limitation, but this is not recommended except as a short term\n backwards-compatibility workaround. Instead we'd recommend using the ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saveData callback')}\n to clear the form when the upload has completed. This also gives the user an opportunity to correct\n validation errors and re-submit the form if necessary.",flags:"IRWA",name:"checkFileAccessOnSubmit"},"attr:PickTreeItem.valueTree":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:PickTreeItem",ref:"attr:PickTreeItem.valueTree",deprecated:null,setter:["setValueTree"],valueType:"Tree",description:"A ${isc.DocUtils.linkForRef('class:Tree')} of options from which the user can select.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('pickTree')}"],name:"valueTree"},"method:MultiGroupDialog.getNumLevels":{seeAlso:[],ref:"method:MultiGroupDialog.getNumLevels",deprecated:null,type:"method",definingClass:"class:MultiGroupDialog",description:" Return the number of levels of grouping that have been configured.\n\n",flags:"",returns:{type:"number",description:"The number of levels of grouping that have been configured"},name:"getNumLevels"},"method:PortalLayout.willAcceptPortletDrop":{seeAlso:[{ref:"attr:Canvas.dragType",description:null},{ref:"attr:PortalLayout.portletDropTypes",description:null},{ref:"method:PortalLayout.portletsChanged",description:null}],type:"method",definingClass:"class:PortalLayout",returns:{type:"boolean",description:"true if the ${isc.DocUtils.linkForRef('class:Portlet')} or other component being dragged can be dropped on this PortalLayout,                      false otherwise"},groups:["portalLayoutDrop"],deprecated:null,ref:"method:PortalLayout.willAcceptPortletDrop",params:[{defaultValue:null,optional:false,type:"Canvas",description:"The ${isc.DocUtils.linkForRef('class:Portlet')}, or other component, being dragged",name:"dragTarget"},{defaultValue:null,optional:false,type:"int",description:"indicates the target column number for the portlet to be added to.",name:"colNum"},{defaultValue:null,optional:true,type:"int",description:"indicates the row number being dropped on within the target column.  If this parameter is not passed, the user is attempting to add a new column by dropping\n  outside any existing column.",name:"rowNum"},{defaultValue:null,optional:true,type:"int",description:"Drop position within an existing row.   If this parameter is not passed, the user is attempting to add a new row by dropping\n  above or below any existing row.",name:"dropPosition"}],description:" This method will be invoked to determine whether a dragged ${isc.DocUtils.linkForRef('class:Portlet')} or other component\n can be dropped into this <code>PortalLayout</code> at the specified position.\n <P>\n The method will be called with the appropriate parameters from ${isc.DocUtils.linkForRef('method:Canvas.willAcceptDrop')}\n when the user attempts to drop within the PortalLayout or its subcomponents.\n <P>\n The default implementation acts like ${isc.DocUtils.linkForRef('method:Canvas.willAcceptDrop')}, checking the ${isc.DocUtils.linkForRef('attr:PortalLayout.dropTypes')} of the\n appropriate subcomponent, which will be derived from the ${isc.DocUtils.linkForRef('attr:PortalLayout.portletDropTypes')} by default.\n <P>\n This method may be overridden to control Portlet drop capabilities based on custom logic.\n <P>\n See ${isc.DocUtils.linkForRef('group:portalLayoutDrop')} for an overview of Portlet drop behaviors within a PortalLayout.\n\n",flags:"A",name:"willAcceptPortletDrop"},"attr:DSRequest.exportToClient":{seeAlso:[],ref:"attr:DSRequest.exportToClient",defaultValue:"true",deprecated:null,type:"attr",definingClass:"object:DSRequest",valueType:"Boolean",description:"If set to true (the default), SmartClient Server will export data back to the client,\n either as a file download or as content in a new browser window, depending on the setting of\n ${isc.DocUtils.linkForRef('attr:DSRequest.exportDisplay','exportDisplay')}.\n <p>\n Setting this property to false disables this. This may be useful when developers \n wish to ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','export the data to a file on the server fileSystem')},\n but do not need to display it in the browser in response to the export request.\n <p>\n Note that it is perfectly valid to have both this property and \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','exportToFilesystem')} set to true; in this case the data is both \n exported to a file on the server filesystem, and downloaded to the client.  If you specify \n <em>neither</em> property, the export no-ops.",flags:"IR",name:"exportToClient"},"classMethod:Canvas.getSnapPosition":{seeAlso:[],type:"classMethod",definingClass:"class:Canvas",returns:{type:"Point",description:'the position for <code>snapper</code> to be placed in order to "snap to" an edge or  corner of <code>target</code>'},groups:["snapPositioning"],deprecated:null,ref:"classMethod:Canvas.getSnapPosition",params:[{defaultValue:null,optional:false,type:"Canvas | Array of Integer",description:"canvas to snap to",name:"target"},{defaultValue:null,optional:false,type:"String",description:"edge against which to snap",name:"snapTo"},{defaultValue:null,optional:false,type:"Canvas | Array of Integer",description:"canvas being snapped",name:"snapper"},{defaultValue:null,optional:true,type:"String",description:"optional edge to snapTo. Default is the <b>opposite</b> edge or corner from  <code>snapTo</code>",name:"snapEdge"}],description:'  Return the position for <code>snapper</code> to be placed in order to "snap to" an edge or\n  corner of <code>target</code>, in the same sense as ${isc.DocUtils.linkForRef(\'attr:Canvas.snapTo\')}.\n  <p>\n  Default for <code>snapEdge</code> is the <b>opposite</b> edge or corner from\n  <code>snapTo</code>.  For example, <code>snapTo</code> of "T" (top) means <code>snapEdge</code>\n  will default to "B" (bottom), so the returned coordinates would place <code>snapper</code>\n  centered along the top edge of <code>target</code>.  A <code>snapTo</code> of "TL" (top left)\n  means <code>snapEdge</code> will default to "BR" (bottom right), so the returned coordinates\n  would place the bottom right of <code>snapper</code> at the top left corner of\n  <code>target</code>.\n  <p>\n  <code>target</code> can be passed as either a Canvas or 4-element Array giving the top, left,\n  width and height of the target.  \n  <code>snapper</code> can be passed as either a Canvas or a\n  two-element Array of the width and height of the rectangle to be placed.\n\n',flags:"",name:"getSnapPosition"},"method:Chart.setData":{seeAlso:[],ref:"method:Chart.setData",deprecated:null,type:"method",definingClass:"interface:Chart",params:[{defaultValue:null,optional:false,type:"Array of CellRecord | CellRecord",description:"new dataset",name:"newData"}],description:" Change the dataset for this chart on the fly.  May or may not be supported by concrete chart\n implementations.\n\n",flags:"",name:"setData"},"attr:StretchImgButton.showRollOverIcon":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:StretchImgButton",groups:["buttonIcon"],deprecated:null,ref:"attr:StretchImgButton.showRollOverIcon",valueType:"Boolean",description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",flags:"IR",name:"showRollOverIcon"},"method:RecordEditor.performAction":{seeAlso:[],ref:"method:RecordEditor.performAction",deprecated:null,type:"method",definingClass:"class:RecordEditor",description:" Fired when the user clicks the ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButton')} for this RecordEditor.\n May also be triggered from other user interaction with edit values (for\n example filter-editor change - see ${isc.DocUtils.linkForRef('attr:ListGrid.filterOnKeypress')}).\n <P>\n This is the method which initiates a filter in a listGrid\n ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter editor')}. Note that for custom\n filtering behavior, developers can use the ${isc.DocUtils.linkForRef('method:ListGrid.filterEditorSubmit')}\n notification method rather than overriding this method directly.\n\n",flags:"",name:"performAction"},"attr:ListGrid.autoFitExtraRecords":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["autoFitData"],ref:"attr:ListGrid.autoFitExtraRecords",deprecated:null,setter:["setAutoFitExtraRecords"],valueType:"Integer",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code>,\n setting this property will cause the ListGrid body to size large enough to accommodate\n the actual data and also leave this many extra rows' worth of blank space below the last\n record. If a maximum size is specified via ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxHeight')} or\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxRecords')}, it will still be respected. Once the data set\n is large enough to fill or exceed that space, this property no longer has an effect.",flags:"IRW",name:"autoFitExtraRecords"},"attr:TabSet.moreTabPane":{seeAlso:[],ref:"attr:TabSet.moreTabPane",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TabSet",valueType:"AutoChild VLayout",description:"Pane contents for the \"more\" tab based on a VLayout. Typically contains\n a ${isc.DocUtils.linkForRef('class:NavigationBar')} and ${isc.DocUtils.linkForRef('class:TableView')}.",flags:"R",name:"moreTabPane"},"attr:Validator.caseSensitive":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:Validator",deprecated:null,ref:"attr:Validator.caseSensitive",valueType:"boolean",description:'Applies only to the "isUnique" and "hasRelatedRecord" validators and controls\n whether the search for existing records is case sensitive or not.',flags:"IR",serverDS:"only",name:"caseSensitive"},"attr:ListGrid.showGroupSummaryInHeader":{seeAlso:[{ref:"method:ListGrid.groupBy",description:null}],defaultValue:"false",type:"attr",definingClass:"class:ListGrid",groups:["grouping"],ref:"attr:ListGrid.showGroupSummaryInHeader",deprecated:null,valueType:"Boolean",setter:["setShowGroupSummaryInHeader"],description:"If this grid is ${isc.DocUtils.linkForRef('method:ListGrid.groupBy','grouped')}, and ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')}\n is true, setting this property causes field summary values for each group to be displayed\n directly in the group header node, rather than showing up at the bottom of each\n expanded group.\n <P>\n Note that this means the group header node will be showing multiple field values\n rather than the default display of a single cell spanning all columns containing the\n group title. Developers may specify an explicit ${isc.DocUtils.linkForRef('attr:ListGrid.groupTitleField')}, or\n rely on the automatically generated ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupTitleColumn','groupTitleColumn')}\n to have group titles be visible as well as the summary values.\n <P>\n Also note that multi-line group summaries are not supported when showing\n the group summary in the group header. If multiple\n ${isc.DocUtils.linkForRef('attr:ListGridField.summaryFunction','field summary functions')} are defined for some field\n only the first will be displayed when this property is set to true.",flags:"IRW",name:"showGroupSummaryInHeader"},"classAttr:Canvas.REPEAT":{seeAlso:[],defaultValue:'"repeat"',type:"classAttr",definingClass:"class:Canvas",deprecated:null,ref:"classAttr:Canvas.REPEAT",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:BackgroundRepeat','BackgroundRepeat')}.",flags:"R",name:"REPEAT",constant:true},"class:DrawShape":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"DrawItem",classMethods:[],classAttrs:[],attrs:["attr:DrawShape.titleRotationMode","attr:DrawShape.commands"],ref:"class:DrawShape",deprecated:null,treeLocation:["Client Reference/Drawing/DrawItem"],description:"DrawItem to render a shape defined by executing the series of drawing commands in the\n ${isc.DocUtils.linkForRef('attr:DrawShape.commands','commands')} array.",methods:["method:DrawShape.setCommands","method:DrawShape.moveBy","method:DrawShape.resizeBy"],name:"DrawShape"},"attr:TreeMenuButton.title":{seeAlso:[],ref:"attr:TreeMenuButton.title",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TreeMenuButton",valueType:"String",description:"Title for this button. If not specified, the selected value from the tree will\n be displayed instead.",flags:"IRW",name:"title"},"method:Class.getClassName":{seeAlso:[],ref:"method:Class.getClassName",deprecated:null,type:"method",definingClass:"class:Class",description:"\t\n\tGets the name of this class as a string.\n\n",flags:"",returns:{type:"String",description:"String name of this instance's Class object."},name:"getClassName"},"attr:OperationBinding.requiredCriterion":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",groups:["clientDataIntegration"],ref:"attr:OperationBinding.requiredCriterion",deprecated:null,valueType:"String",description:"A comma-separated list of field names that must be present in criteria / advancedCriteria provided by the caller.\n Failure to provide any one of these will yield a ${isc.DocUtils.linkForRef('classAttr:RPCResponse.STATUS_CRITERIA_REQUIRED_ERROR')} from the server.",flags:"IR",serverDS:"allowed",examples:["${isc.DocUtils.linkForExampleId('requiredCriterion')}"],name:"requiredCriterion"},"attr:DataSource.sqlUsePagingHint":{seeAlso:[{ref:"attr:OperationBinding.sqlUsePagingHint",description:null}],defaultValue:"null",requiresModules:["SCServer"],type:"attr",definingClass:"class:DataSource",groups:["sqlPaging"],ref:"attr:DataSource.sqlUsePagingHint",deprecated:null,valueType:"boolean",description:"If explicitly set true or left null, causes the server to use a \"hint\" in the SQL we \n generate for paged queries.  If explicitly set false, forces off the use of hints.  This\n property can be overridden per operationBinding - see \n ${isc.DocUtils.linkForRef('attr:OperationBinding.sqlUsePagingHint')}.\n <p>\n Note this property is only applicable to ${isc.DocUtils.linkForRef('attr:DataSource.serverType','SQL')} DataSources, \n only when a ${isc.DocUtils.linkForRef('attr:DataSource.sqlPaging','paging strategy')} of \"sqlLimit\" is in force,\n and it only has an effect for those specific database products where we employ a native\n hint in the generated SQL in an attempt to improve performance.",flags:"IR",serverDS:"only",name:"sqlUsePagingHint"},"attr:ViewLoader.httpMethod":{seeAlso:[],defaultValue:'"GET"',type:"attr",definingClass:"class:ViewLoader",groups:["contentLoading"],deprecated:null,ref:"attr:ViewLoader.httpMethod",valueType:"String",description:'Selects the HTTP method that will be used when fetching content.  Valid values are "POST"\n and "GET".',flags:"IRW",name:"httpMethod"},"attr:FacetChart.facetFields":{seeAlso:[{ref:"attr:FacetChart.valueProperty",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",deprecated:null,ref:"attr:FacetChart.facetFields",valueType:"Array of FieldName | FieldName",description:"Specifies what ${isc.DocUtils.linkForRef('class:DataSource')} fields to use as the chart ${isc.DocUtils.linkForRef('attr:FacetChart.facets')} for a databound\n chart.  If ${isc.DocUtils.linkForRef('attr:FacetChart.facets')} is also explicitly set, ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')} is definitive but\n ${isc.DocUtils.linkForRef('object:Facet')} properties will be picked up from ${isc.DocUtils.linkForRef('attr:FacetChart.facets')} also present in the\n ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')}.\n <P>\n If neither this property nor ${isc.DocUtils.linkForRef('attr:FacetChart.facets')} is set, a databound chart will attempt to\n auto-derive ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')} from the DataSource fields.  The first two text or\n text-derived fields in the DataSource will be assumed to be the ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')}.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('chartDataBinding')}"],name:"facetFields"},"attr:HeaderSpan.title":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:HeaderSpan",groups:["headerSpan"],deprecated:null,ref:"attr:HeaderSpan.title",valueType:"String",description:"A title for this headerSpan, to display in the headerSpan button for this headerSpan\n and in other contexts such as the ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields','menu for picking visible fields')}.\n\n Note: if you want to use HTML tags to affect the display of the header, you should do so\n via ${isc.DocUtils.linkForRef('attr:HeaderSpan.headerTitle')} instead so that other places where the title\n appears in the UI are not affected.  Refer to discussion at ${isc.DocUtils.linkForRef('attr:ListGridField.title')}.",flags:"IR",name:"title"},"method:Canvas.visibilityChanged":{seeAlso:[],ref:"method:Canvas.visibilityChanged",deprecated:null,type:"method",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"boolean",description:"whether the canvas is visible to the user",name:"isVisible"}],description:" Notification  fired when this canvas becomes visible or hidden to the user.\n Note - this method is fired when the ${isc.DocUtils.linkForRef('method:Canvas.isVisible')} state of this\n component changes. It may be fired in response an explicit call to ${isc.DocUtils.linkForRef('method:Canvas.show')}\n or ${isc.DocUtils.linkForRef('method:Canvas.hide')}, or in response to a parent component\n being shown or hidden when this widgets ${isc.DocUtils.linkForRef('attr:Canvas.visibility')} is set to \"inherit\".\n <P>\n Note that a call to ${isc.DocUtils.linkForRef('method:Canvas.show')} or ${isc.DocUtils.linkForRef('method:Canvas.hide')} will not <b>always</b> fire this\n notification. If this widget has a hidden parent, show or hide would change this\n components ${isc.DocUtils.linkForRef('attr:Canvas.visibility')} property, and may update the CSS visibility attribute\n of the drawn handle in the DOM, but would not actually hide or reveal the component to\n the user and as such the notification would not fire.\n <P>\n Note also that this notification will only be fired for components which have been\n ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn')}.\n",flags:"",name:"visibilityChanged"},"type:Selected":{groups:["state"],seeAlso:[],ref:"type:Selected",deprecated:null,type:"type",values:[{value:"StatefulCanvas.FOCUSED",description:"StatefulCanvas should show                                     focused state"},{value:"StatefulCanvas.SELECTED",description:"StatefulCanvas is selected"},{value:"StatefulCanvas.UNSELECTED",description:"StatefulCanvas is not selected"}],description:null,name:"Selected"},"method:Sound.setCurrentTime":{seeAlso:[],ref:"method:Sound.setCurrentTime",deprecated:null,type:"method",definingClass:"class:Sound",params:[{defaultValue:null,optional:false,type:"Float",description:"time to move to. This method will have no effect if the  file has not been loaded or no ${isc.DocUtils.linkForRef('attr:Sound.src')} element is defined.",name:"time"}],description:" Move playback to a particular time in a loaded audio file.\n",flags:"",name:"setCurrentTime"},"attr:Window.hiliteHeaderStyle":{seeAlso:[],defaultValue:'"WindowHeader"',type:"attr",definingClass:"class:Window",groups:["appearance","header"],deprecated:null,ref:"attr:Window.hiliteHeaderStyle",valueType:"CSSStyleName",description:"Highlight style for the Window header. Displayed when a window \n is ${isc.DocUtils.linkForRef('method:Window.flash','flashed')}",flags:"IRWA",name:"hiliteHeaderStyle"},"object:AdvancedCriterionSubquery":{seeAlso:[],type:"object",staticMethods:[],inheritsFrom:"DSRequest",classMethods:[],classAttrs:[],attrs:["attr:AdvancedCriterionSubquery.queryOutput","attr:AdvancedCriterionSubquery.queryFK","attr:AdvancedCriterionSubquery.dataSource","attr:AdvancedCriterionSubquery.criteria","attr:AdvancedCriterionSubquery.canEmbedSQL","attr:AdvancedCriterionSubquery.summaryFunctions","attr:AdvancedCriterionSubquery.groupBy","attr:AdvancedCriterionSubquery.operationId"],groups:["advancedFilter"],ref:"object:AdvancedCriterionSubquery",deprecated:null,treeLocation:["Client Reference/Data Binding/DataSource"],description:'A specialized subclass of ${isc.DocUtils.linkForRef(\'object:DSRequest\')} that you use to declare the properties of\n a subquery (a ${isc.DocUtils.linkForRef(\'attr:Criterion.fieldQuery\',\'fieldQuery\')} or \n ${isc.DocUtils.linkForRef(\'attr:Criterion.valueQuery\',\'valueQuery\')}) to be used in ${isc.DocUtils.linkForRef(\'object:AdvancedCriteria\')}.  \n Subquery definitions are often very compact; only a few properties are permitted for a \n client-driven subquery (see "Restrictions on client-driven subqueries", below), and many \n use cases can be satisfied specifying just a \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.dataSource\',\'dataSource\')} and a \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.summaryFunctions\',\'summary function\')}.\n <p>\n Criteria subquery definitions fall into two broad categories:<ul>\n <li><b>Aggregation</b>, where the subquery uses a ${isc.DocUtils.linkForRef(\'type:SummaryFunction\')} to aggregate\n or summarize a related dataset, and then filter on that aggregated or summarized value.  For\n example, orders with more than 10 lines, customers with an average order value more than \n $1000, UK customers with an outstanding payment more than a week old, etc</li>\n <li><b>Related value</b>, where the subquery selects a value (or, for <code>inSet</code>-type\n clauses, a set of values) from a related dataSource and then filters on that value.  For \n example, Products that were not ordered last month, Employees who are based in one of the \n North American offices, Orders that include a particular category of Product, etc</li>\n </ul>\n <p> \n In ideal circumstances - when both main and subquery ${isc.DocUtils.linkForRef(\'class:DataSource\',\'dataSource\')}s are\n ${isc.DocUtils.linkForRef(\'group:sqlDataSource\',\'SQL DataSources\')}, and a number of other restrictions are \n satisfied - subqueries are implemented by incorporating their functionality into a larger\n overall SQL query, because this is the most efficient thing to do, and gives the best \n performance.  See ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.canEmbedSQL\',\'canEmbedSQL\')} for a description\n of the rules and nuances around this.\n <p>\n In cases where we cannot implement subqueries by embedding SQL, they are implemented by \n converting the subquery definitions into separate real <code>DSRequest</code>s, executing\n them, and then combining their results into the wider resultset.\n <h3>Subquery Overview</h3>\n Subqueries are used to derive a value to be compared as part of the main query, from a set\n of related data where there is no way to directly join to a single record (usually because \n the subquery is summarizing or extracting from a larger dataset).  Each subquery must \n return a single value per record in the main query, because it going to be compared to a \n single value from each main record (this value either comes directly from the main record,\n or is derived via a <code>fieldQuery</code>)\n <p>\n Because the nature of a subquery is that it is deriving a single value from multiple records,\n subqueries are often involved in some kind of aggregation (returning a record count, or the\n minimum value, for example).  While this is the most common use of subqueries, it is not\n the only one - see the "Simple valueQuery" example below.\n <p>\n Whether or not a subquery is aggregating multiple records, it typically needs to be \n constrained by a join to the outer query.  For example, if you were looking for all customers\n that have placed more than $1000-worth of orders, you would use something like the \n "Simple aggregating subquery" below.  As you will see, that example displays no explicit \n means of joining the subquery to the outer query, and yet one is obviously necessary because\n we are looking for the sum of "lineValue" customer-by-customer, not the total sum for all \n customers.\n <p>\n This join from the subquery to the outer query is applied implicitly by SmartClient\'s SQL \n engine.  It auto-discovers a Relation between the main dataSource and subquery dataSource\n by following ${isc.DocUtils.linkForRef(\'attr:DataSourceField.foreignKey\',\'foreignKey\')} definitions from the subquery \n dataSource, until it finds a path to the main dataSource.  This auto-discovery usually does\n the right thing, but there are two possibilities it does not address:<ul>\n <li>There is no direct or indirect Relation from the subquery dataSource to the main \n dataSource.  This is an unusual case for a subquery - most use use cases call for related \n dataSources - but valid cases are conceivable.  To cope with this scenario, you set \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.queryFK\',\'queryFK\')} to the special value \n "<code><b>*none*</b></code>".  Note, if SmartClient fails to find a path from the subquery\n dataSource to the main dataSource and <code>queryFK:"*none*"</code> has not been set, the \n framework will log a warning and the fetch will fail</li>\n <li>There is more than one direct or indirect Relation from the subquery dataSource to the \n main dataSource, and you want to use a different one from the one that was auto-discovered.\n Again, the solution is to explicitly name the ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.queryFK\',\'queryFK\')}\n - see the documentation for that property for details of the syntax</li>\n </ul>\n <p>\n Since SmartClient can usually only make use of a single value as output from a subquery\n (see the section "Subqueries with inSet criteria" below for an important caveat), if your\n subquery returns multiple records, we will simply use the first.  If the query returns\n multiple fields, you can specify the field to use as the subquery output with \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.queryOutput\',\'queryOutput\')}.  If the subquery returns more \n than one field and no <code>queryOutput</code> is specified, we will use the first \n aggregated (${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.summaryFunctions\',\'summaryFunction\')}) field, or\n the first ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.groupBy\',\'grouped\')} field if there are no \n aggregated fields, or the ${isc.DocUtils.linkForRef(\'attr:DataSourceField.primaryKey\',\'primaryKey\')} field if there are \n also no <code>groupBy</code> fields, or just the first numeric field failing all else.  \n Note, however, that although we attempt to derive a sensible value, it never makes sense to\n return multiple records from a subquery, and it only really makes sense to return multiple \n fields if you explicitly identify the correct field with <code>queryOutput</code>.  \n Ideally, for the sake of clarity, return a single record, and either have that record \n contain a single field, or specify <code>queryOutput</code>\n <h4>Restrictions on client-driven subqueries</h4>\n For security reasons, subqueries in ${isc.DocUtils.linkForRef(\'object:DSRequest\',\'requests\')} that came from the \n client-side are only permitted to specify a handful of properties.  These properties are\n sufficient to allow the full power of the subquery feature to be used, without allowing any\n of the much broader set of general properties associated with the <code>DSRequest</code>\n superclass.  The properties that can be set in a client-driven subquery are just those that\n are documented as direct properties of the <code>AdvancedCriterionSubquery</code> class - \n specifically ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.canEmbedSQL\',\'canEmbedSQL\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.criteria\',\'criteria\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.dataSource\',\'dataSource\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.groupBy\',\'groupBy\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.operationId\',\'operationId\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.queryFK\',\'queryFK\')}, \n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.queryOutput\',\'queryOutput\')}, and\n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.summaryFunctions\',\'summaryFunctions\')}\n <p>\n For <code>DSRequest</code>s that originally came from the server, it is possible to have a\n subquery that specifies any <code>DSRequest</code> property.  Many of these would only have\n any relevance or effect if the subquery was run separately rather than embedded (as \n described above and in the ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.canEmbedSQL\',\'canEmbedSQL\')} doc).  \n If you need to do this, look in the server Javadoc for \n <code>DSRequest.setAllowArbitrarySubqueries(boolean)</code>\n <p>\n Finally, note that it is possible to switch off the ability to use subqueries altogether, \n either  ${isc.DocUtils.linkForRef(\'attr:DataSource.allowCriteriaSubqueries\',\'per-DataSource\')}, or globally by setting \n the <code>allowCriteriaSubqueries</code> flag in your <code>server.properties</code> file:<pre>\n allowCriteriaSubqueries: false\n </pre>\n <p>\n <h4>Subqueries with inSet criteria</h4>\n As noted above, subqueries nearly always need to return a single value, since that value is \n going to be used instead of a literal scalar value in record-by-record comparisons.  The \n exception to this rule is when you are specifying a <code>valueQuery</code> with the \n <code>inSet</code> operator.  In this case, you are saying that the field value must be one\n of a set of valid values, so in this one case it is appropriate and correct for the\n <code>valueQuery</code> to return a list of values rather than a single value.  Note, we are \n still comparing a single field to the values in the list, so it should be a list of \n simple values (strings, numbers, booleans or dates, as appropriate), NOT a list of records\n <p>\n <h4>Standalone Evaluator Support</h4>\n For server-side Java code that needs to evaluate AdvancedCriteria containing\n <code>fieldQuery</code> or <code>valueQuery</code> outside of the normal DSRequest flow,\n the <code>com.isomorphic.criteria.Evaluator</code> class provides direct support.  The\n <code>filterRecords()</code> method accepts a list of records and automatically resolves\n any subqueries before filtering.  You can either provide a <code>SubqueryResolver</code>\n via the constructor, or use the convenience overload that accepts a parent\n <code>DataSource</code> and auto-creates a <code>DSRequestSubqueryResolver</code>.  For\n scenarios where data is not in a database (e.g., in-memory caches, file-based data),\n <code>InMemorySubqueryResolver</code> can resolve subqueries against in-memory collections.\n See the Evaluator Javadoc for details.\n <p>\n <h4><code>exists / notExists</code> operators</h4>\n The ${isc.DocUtils.linkForRef(\'type:OperatorId\',\'<code>exists / notExists</code>\')} operators provide a concise\n way to filter records based on the existence (or absence) of related rows.\n <p>\n When both main DataSource and subquery DataSource are instances of <code>SQLDataSource</code>,\n these operators are transformed into <code>EXISTS (...)</code> / <code>NOT EXISTS (...)</code>\n correlated subselects in the generated SQL. Non-SQL backends, as well as when\n ${isc.DocUtils.linkForRef(\'attr:AdvancedCriterionSubquery.canEmbedSQL\',\'canEmbedSQL:false\')} is set for SQL backends, will\n execute subqueries as separate ${isc.DocUtils.linkForRef(\'object:DSRequest\',\'DSRequests\')} and apply their results manually.\n <p>\n These operators must be used with a ${isc.DocUtils.linkForRef(\'attr:Criterion.fieldQuery\',\'fieldQuery\')}:\n <pre>\n // EXISTS: at least one related row matches the subquery\n { operator: "exists",\n   fieldQuery: { dataSource: "OrderLine", criteria: { /&#42 ... &#42/ } }\n }\n </pre>\n See full examples in the "Examples" section below.\n <p>\n <h3>Examples</h3>\n Subqueries are quite hard to describe in narrative text, but the following examples \n demonstrate their use and should make things clearer\n <p>\n <h4>Simple aggregating subquery</h4>\n This example uses a <code>fieldQuery</code> to select all Order records for customer \n 1234, where the order total (sum of all the order line values) is greater than $1000.<pre>\n Order.fetchData({\n     _constructor: "AdvancedCriteria", operator: "and", criteria: [\n         {fieldName: "customerNumber", operator: "equals", value: 1234},\n         {\n              fieldQuery: {\n                  dataSource: "OrderLine",\n                  summaryFunctions: {lineValue: "sum"}\n              }, operator: "greaterThan", value: 1000\n         }\n     ] \n });\n </pre>\n <h4>Simple valueQuery</h4>\n This example uses a <code>valueQuery</code> to derive the employeeNumber of a manager when\n we only know the email address of that manager, so we can find out who reports to her.  \n This example shows how to use additional criteria within a subquery.  It also demonstrates \n the relatively rare situation where no join to the outer dataSource is required (hence the\n declaration of <code>queryFK: "*none*"</code>)<pre>\n Employee.fetchData({\n     _constructor: "AdvancedCriteria", operator: "and", criteria: [\n         {\n             fieldName: "reportsTo", \n             operator: "equals",\n                 valueQuery: {\n                     dataSource: "Employee",\n                     queryFK: "*none*",\n                     criteria: { operator: "and", criteria: [\n                         {fieldName: "email", operator: "equals", value: "mpatterson@classicmodelcars.com"}\n                     ]\n                 }\n             }\n         }\n     ]\n });\n </pre>\n <h4>More complex aggregation example</h4>\n This example uses both a <code>fieldQuery</code> and a <code>valueQuery</code> to select \n all US-based customers who placed more orders in 2022 than they placed in 2021.  Note, this \n is the number of orders, not the value, and the particular field that we add the "count"\n function to is not important (count is the same regardless of which field you count).  We\n chose the orderNumber in this case, but that choice is arbitrary<pre>\n Customer.fetchData({\n     _constructor: "AdvancedCriteria", operator: "and", criteria: [\n         {fieldName: "country", operator: "equals", value: "USA"},\n         {\n             fieldQuery: {\n                 dataSource: "Order",\n                 summaryFunctions : { orderNumber : "count" },\n                 criteria: {fieldName: "orderDate", operator: "iBetweenInclusive", \n                                         start:new Date("2021-01-01"), end:new Date("2021-12-31")}\n             }, \n             operator: "lessThan",\n             valueQuery: {\n                 dataSource: "Order",\n                 summaryFunctions : { orderNumber : "count" },\n                 criteria: {fieldName: "orderDate", operator: "iBetweenInclusive", \n                                         start:new Date("2022-01-01"), end:new Date("2022-12-31")}\n             }\n         }\n     ]\n });\n </pre>\n <h4><code>exists</code> / <code>notExists</code> operators</h4>\n Show customers with any Orders in 2024 (exists).\n <pre>\n Customer.fetchData({\n   _constructor: "AdvancedCriteria", operator: "and", criteria: [\n     { operator: "exists",\n       fieldQuery: {\n         dataSource: "Order",\n         criteria: { fieldName: "orderDate", operator: "iBetweenInclusive",\n                     start: new Date("2024-01-01"), end: new Date("2024-12-31") }\n       }\n     }\n   ]\n });\n </pre>\n Products not ordered last month (notExists).\n <pre>\n Product.fetchData({\n   _constructor: "AdvancedCriteria", operator: "and", criteria: [\n     { operator: "notExists",\n       fieldQuery: {\n         dataSource: "OrderLine",\n         criteria: { operator: "and", criteria: [\n           { fieldName: "orderDate", operator: "iBetweenInclusive",\n             start: startOfLastMonth, end: endOfLastMonth }\n         ]}\n       }\n     }\n   ]\n });\n </pre>',methods:[],serverDS:"allowed",name:"AdvancedCriterionSubquery"},"attr:DatabaseBrowser.schemaCriteria":{seeAlso:[],ref:"attr:DatabaseBrowser.schemaCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"Criteria",description:"Optional criteria to pass to the ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schemaDataSource')} when retrieving the list of \n schemas for a selected database.  Note, this criteria is in addition to the criteria\n implied by the current ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.dbName','dbName')}",flags:"IR",name:"schemaCriteria"},"classAttr:FileDropZone.maxSizeErrorMessage":{seeAlso:[],defaultValue:'"The specified file(s) are too large"',type:"classAttr",definingClass:"class:FileDropZone",groups:["i18nMessages"],deprecated:null,ref:"classAttr:FileDropZone.maxSizeErrorMessage",valueType:"String",description:"Error message shown when ${isc.DocUtils.linkForRef('attr:FileDropZone.maxSize')} is exceeded.",flags:"IR",name:"maxSizeErrorMessage"},"attr:EditContext.selectedTintOpacity":{seeAlso:[{ref:"attr:EditContext.selectedTintColor",description:null}],ref:"attr:EditContext.selectedTintOpacity",defaultValue:"25",deprecated:null,type:"attr",definingClass:"class:EditContext",valueType:"Number",description:"Opacity applied to ${isc.DocUtils.linkForRef('attr:EditProxy.editMask','editMask')} of selected component when\n ${isc.DocUtils.linkForRef('attr:EditProxy.selectedAppearance')} is \"tintMask\".\n <P>\n This value is applied as a default to ${isc.DocUtils.linkForRef('attr:EditProxy.selectedTintOpacity')}.",flags:"IR",name:"selectedTintOpacity"},"group:serverDataIntegration":{refs:["type:DSDataFormat","type:DSServerType","attr:DataSource.dataFormat","attr:DataSource.dataProtocol","attr:DataSource.requestProperties","attr:DataSource.serverType","attr:DataSource.tableName","attr:DataSource.quoteTableName","attr:DataSource.dbName","attr:DataSource.configBean","attr:DataSource.forceSort","attr:OperationBinding.forceSort","attr:DataSource.defaultSortField","attr:DataSource.defaultTextMatchStyle","attr:DataSource.arrayCriteriaForceExact","attr:OperationBinding.arrayCriteriaForceExact","attr:DSRequest.arrayCriteriaForceExact","attr:DataSource.defaultBooleanStorageStrategy","attr:DataSource.useAnsiJoins","attr:DataSource.audit","attr:DataSource.serverObject","attr:OperationBinding.requestProperties","attr:DataSource.suppressManualAggregation","attr:RestDataSource.dataProtocol"],seeAlso:[],ref:"group:serverDataIntegration",treeLocation:["Concepts/Client-Server Integration","Java Server Reference"],deprecated:null,type:"group",title:"Server DataSource Integration",description:"Server Data Integration means:\n <ul>\n <li> You ${isc.DocUtils.linkForRef('group:iscInstall','install')} the \n      ${isc.DocUtils.linkForRef('group:iscServer','SmartClient Java Server Framework')} into any J2SE/J2EE\n      environment, including any existing web application\n <li> You ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','create DataSources')} via an XML declaration,\n possibly on-the-fly from ${isc.DocUtils.linkForRef('group:metadataImport','existing metadata')}.  \n <li> Server communication for components bound to these DataSources is handled\n automatically with a highly efficient, compressed protocol.  You work with clean Java APIs\n instead of dealing with the details of XML or JSON over HTTP.\n <li> You can use built-in connectors for SQL, Hibernate and other common data providers\n without writing any code, or you can easily build your own connectors in Java.\n <li> Whether using the built-in connectors or custom connectors, declarations in your\n DataSource control a large set of server features that can make common types of business\n logic entirely declarative\n </ul>\n This approach is in contrast to \n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side Data Integration')} in which client-side\n DataSources are configured to send and receive HTTP messages containing XML, JSON\n or other content.\n <P>\n <B>Server-side Request Processing</B>\n <P>\n Client-side ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} will send\n ${isc.DocUtils.linkForRef('object:DSRequest','DSRequests')} to the SmartClient Server as background communications transparent\n to the user.  Integrating SmartClient's DataSource layer with your data model is a matter of\n handling these DSRequests and sending back DSResponses, in order to fulfill the 4 basic\n operations of the ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource Protocol')}.\n <P>\n Out of the box, SmartClient is set up to route all DSRequests through a special servlet\n called <code>IDACall</code>.\n <P>\n Note that the SmartClient SDK includes detailed Javadoc reference for this servlet and\n all shipped SmartClient Java server classes.\n <P>\n Requests that go through <code>IDACall</code> have the \n following lifecycle:\n <ul>\n <li>The overall HTTP request is received by the IDACall servlet.  SmartClient supports \n queuing of transactions, so each HTTP request might contain multiple DSRequests.</li>\n <li>IDACall sets up an instance of <code>RPCManager</code> to manage the processing of\n the entire queue of transactions.  For every DSRequest in the queue, this RPCManager:</li>\n   <ul>\n   <li>Validates the DSRequest</li>\n   <li>Checks the DataSource configuration for customizations implemented via \n       ${isc.DocUtils.linkForRef('group:serverScript','server scripting')} or ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} - in other words, your code -\n       and passes the request to this logic.\n       <p>\n       As described later in this section, your code can\n       perform some custom logic here: either completely fulfilling the request, or\n       alternatively modifying the request and causing the default\n       processing of the request to continue</li>\n   <li>Calls the DataSource's <code>execute</code> method to obtain a DSResponse.</li>\n   </ul>\n <li>Having processed all requests, the RPCManager now serializes all the DSResponses \n and sends them back to the browser as a single HTTP response</li>\n </ul>\n <p>\n This basic request handling flow can be customized at a number of points:\n <ul>\n <li>If you need an overarching authentication service, this is best implemented using \n <a href=http://java.sun.com/products/servlet/Filters.html>servlet Filters</a> to intercept\n unauthenticated requests before they reach the <code>IDACall</code> servlet</li>\n\n <li>The ${isc.DocUtils.linkForRef('attr:DataSource.serverType')} specification within your <code>.ds.xml</code> configuration\n     file is used to specify a standard server-side connector to service your requests.</li>\n\n <li>General custom business logic can be added in a number of ways, both declaratively and\n programmatically:</li>\n <ul>\n   <li>The &lt;criteria&gt; and &lt;values&gt; properties of an ${isc.DocUtils.linkForRef('class:OperationBinding')} \n       allow you to modify the dataSource request dynamically at transaction-processing time, using \n       built-in ${isc.DocUtils.linkForRef('group:velocitySupport','Velocity support')}.<br>\n       Note this feature also allows developers to use\n       ${isc.DocUtils.linkForRef('group:transactionChaining','Transaction Chaining')} to dynamically set data values \n       according to the results of earlier transactions.</li>\n   <li>For editing, standard ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')} defined in the <code>.ds.xml</code> \n       file will be processed on both the client and the server. In addition to the built-in validator\n       types, entirely custom server validation logic may be implemented using\n       ${isc.DocUtils.linkForRef('type:ValidatorType','\"serverCustom\" type validators')}.</li>\n   <li>For SQL DataSources, use ${isc.DocUtils.linkForRef('group:customQuerying','SQL Templating')} to change, add \n       to or even completely replace the SQL sent to the database, including calling\n       stored procedures</li>\n   <li>The ${isc.DocUtils.linkForRef('attr:DataSource.serverConstructor')} allows you to specify an explicit custom DataSource\n       subclass to create as your DataSource instance. This must be a subclass of \n       <code>BasicDataSource</code>.<br>\n       When requests are recieved by the \n       <code>IDACall</code> servlet, they will be passed to standard methods on this DataSource, which\n       can be overridden for custom behavior.<br>\n       Validation is performed via a call to the <code>validate()</code> method.<br>\n       The request is processed by the <code>execute()</code>, method which can be overridden directly,\n       or developers may override the operation-specific \n       methods <code>executeFetch()</code>, <code>executeAdd()</code>, <code>executeUpdate</code>,\n       or <code>executeRemove()</code> called from the standard <code>execute()</code> implementation.<br>\n       This approach allows you to either extend one of the built-in persistence mechanisms\n       by subclassing a shipped class such as <code>SQLDataSource</code>, or\n       create an entirely custom implementation from scratch.<br>\n       A custom dataSource will still take full advantage of \n       DataSource-agnostic features of the SmartClient Server, like validation, queuing,\n       transaction chaining, support for Velocity templating, and so on.<br>\n       For more information see the ${isc.DocUtils.linkForRef('group:writeCustomDataSource','custom server dataSource overview')}</li>\n   <li>Use ${isc.DocUtils.linkForRef('group:dmiOverview','Direct Method Invocation')} to call directly into your own Java \n       classes. An operation configured to use DMI will invoke the specified method instead of\n       running through the standard DataSource <code>execute()</code> method directly - the DMI\n       implementation can then use <code>dsRequest.execute()</code> to call the default behavior.\n       This means DMIs allow you to modify the <code>DSRequest</code> before it executes,\n       modify the <code>DSResponse</code> before it returns, or replace the default behavior with\n       unrelated actions. Note that DMI can be applied \n       ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','to all operations')}, or to \n       ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject','individual operation bindings')}, and can be used\n       in conjunction with a ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','custom dataSource')}.</li> \n   <li>Use ${isc.DocUtils.linkForRef('group:serverScript','server scripting')} to add small amounts of business logic \n       right in your <code>.ds.xml</code> file (either \n       ${isc.DocUtils.linkForRef('attr:OperationBinding.script','per operation')}, or as standard handling for\n       ${isc.DocUtils.linkForRef('attr:DataSource.script','all operations')}).  DMI scripts allow you to add business\n       logic just like normal DMIs, but don't require the logic to be in a separate .java\n       file.</li>\n </ul><br>\n\n <li>If you need to use a Front Controller servlet for some other reason than authentication -\n for example, you are using Spring some other similar system which requires that \n all requests go through some particular servlet - just call \n <code>RPCManager.processRequest()</code> within your Spring Controller or \n whatever the equivalent is in the framework in use.\n <p>\n However, note carefully that taking this approach is often a sign that the SmartClient \n architecture has not been correctly understood.  SmartClient is architected for \n <em>client-server</em> data communication, as opposed to early web MVC frameworks which \n do everything on the server.  In particular, it is absolutely incorrect to represent every \n individual DataSource operation - or even every DataSource - as a separate \n Spring Controller because this implies different URLs for different operations.  All \n DataSource operations should go through a single URL in order to allow \n ${isc.DocUtils.linkForRef('class:RPCManager','transaction queuing')} - see these \n ${isc.DocUtils.linkForExampleId('transactionsFolder', 'Queuing examples')}.</li>\n </ul>\n <P>\n For more information on the DMI subsystem, see the ${isc.DocUtils.linkForRef('group:dmiOverview','DMI overview')},\n ${isc.DocUtils.linkForRef('class:DMI','DMI class')} and the \n ${isc.DocUtils.linkForExampleId('DMI', 'DMI example')} in the Feature Explorer.\n <P>\n Note that, as you continue to integrate your prototype with your backend, you can use a\n mixture of DataSources that have been fully integrated with your backend and DataSources\n that are running in \"client-only\" mode (see ${isc.DocUtils.linkForRef('group:clientOnlyDataSources')}).\n <P>\n <b>Important methods for handling DataSource requests</b>\n <P>\n The basic flow of logic for handling DataSource requests is:\n <P>\n <table class=\"normal\" border=1 width=\"700\">\n <tr>\n <td>1. Determine operation type (Fetch, Add, Update, Remove) for a single request.  Not \n necessary if you follow the recommendations for \n ${isc.DocUtils.linkForRef('group:writeCustomDataSource','writing a custom DataSource')} and provide your \n implementation via <code>executeFetch(), executeAdd()</code>, et al.</td>\n <td>dsRequest.getOperationType()</td>\n </tr>\n\n <tr>\n <td>2. Get inbound values (Add, Update) and/or criteria (Fetch, Update, Remove) for this\n request.</td>\n <td>dsRequest.getFieldValue()<br>\n dsRequest.getValues()<br> \n dsRequest.getCriteria()</td>\n </tr>\n\n <tr>\n <td>3. Business logic, validation, calls to data and service tiers... anything you can code.\n </td>\n <td><b>execute custom logic</b></td>\n </tr>\n\n <tr>\n <td>4. Set status and data for the response.</td>\n <td>dsResponse.setStatus()<br>\n dsResponse.setData()</td>\n </tr>\n </table>\n <P>\n For more information, see the ${isc.DocUtils.linkForRef('class:RPCManager','RPCManager documentation')}, and the \n ${isc.DocUtils.linkForExampleId('ormDataSource', 'Custom ORM DataSource example')}.",name:"serverDataIntegration"},"classAttr:Browser.isSupported":{seeAlso:[],ref:"classAttr:Browser.isSupported",defaultValue:"auto-detected based on browser",deprecated:null,type:"classAttr",definingClass:"class:Browser",valueType:"boolean",description:"Whether SmartClient supports the current browser.\n <P>\n Note that this flag will only be available on browsers that at least support basic\n JavaScript.",flags:"R",name:"isSupported"},"method:ListGrid.cellErrorIconOver":{seeAlso:[{ref:"attr:ListGrid.showErrorIcons",description:null}],type:"method",definingClass:"class:ListGrid",returns:{type:"Boolean",description:"false to suppress the default behavior (show a standard error message                   hover)"},groups:["events"],deprecated:null,ref:"method:ListGrid.cellErrorIconOver",params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"cell record as returned by getCellRecord()",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number of the cell",name:"colNum"}],description:" Optional stringMethod to fire when the mouse moves over the error icon of a cell with \n validation errors.\n\n",flags:"A",name:"cellErrorIconOver"},"attr:ListGridField.groupingMode":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["grouping"],deprecated:null,ref:"attr:ListGridField.groupingMode",valueType:"Identifier",description:"For a field that allows multiple ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','grouping modes')},\n the current grouping mode.\n <P>\n This property is set when a user chooses a particular grouping mode, and may be set on\n ListGrid creation to affect the initial grouping.",flags:"IR",name:"groupingMode"},"method:Toolbar.itemDragResized":{seeAlso:[],ref:"method:Toolbar.itemDragResized",deprecated:null,type:"method",definingClass:"class:Toolbar",params:[{defaultValue:null,optional:false,type:"number",description:"the index of the item that was resized",name:"itemNum"},{defaultValue:null,optional:false,type:"number",description:"the new size of the item",name:"newSize"}],description:" Observable, overrideable method - called\n when one of the Toolbar buttons is drag resized.\n\n",flags:"",name:"itemDragResized"},"attr:DateItem.inputFormat":{seeAlso:[{ref:"attr:DateItem.dateFormatter",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DateItem",getter:["getInputFormat"],deprecated:null,ref:"attr:DateItem.inputFormat",valueType:"DateInputFormat",description:"If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is <code>true</code> this property can be used to specify\n the input format for date strings. \n If unset, the input format will be determined based on the specified\n ${isc.DocUtils.linkForRef('attr:DateItem.dateFormatter')} if possible (see ${isc.DocUtils.linkForRef('method:DateItem.getInputFormat')}), otherwise\n picked up from the Date class (see ${isc.DocUtils.linkForRef('classMethod:DateUtil.setInputFormat')}).\n <P>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateInputFormat')}\n <P>\n Note that the ${isc.DocUtils.linkForRef('type:DateInputFormat')} property is sufficient to parse date or datetime\n strings specified in most standard date formats. However should an entirely custom\n parsing function be required developers can \n implement a custom ${isc.DocUtils.linkForRef('method:DateItem.parseEditorValue')} method.\n \n <p>\n This attribute does not have an effect if a native HTML5 date input is being used.\n See ${isc.DocUtils.linkForRef('attr:DateItem.browserInputType')}.",flags:"IRW",name:"inputFormat"},"method:ListGrid.getDefaultFormattedFieldValue":{seeAlso:[{ref:"method:ListGridField.formatCellValue",description:null},{ref:"method:ListGrid.formatCellValue",description:null},{ref:"method:ListGrid.getDefaultFormattedValue",description:null},{ref:"method:ListGrid.getFormattedValue",description:null}],ref:"method:ListGrid.getDefaultFormattedFieldValue",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"Record",description:"the record object",name:"record"},{defaultValue:null,optional:false,type:"ListGridField",description:"the field object",name:"field"},{defaultValue:null,optional:true,type:"int",description:"rowNum (passed to field-level formatter if present)",name:"rowNum"},{defaultValue:null,optional:true,type:"int",description:"colNum (passed to field-level formatter if present)",name:"colNum"}],description:" Get a field value for some record with default field formatters applied.\n <P>\n This method differs from ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')} in that this method does\n not rely on the rowNum and colNum parameters to find the record and field in the grid.\n Also, unlike ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')}, this method <i>will</i> call any\n ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue','field-level formatter')} if one is defined on the\n field (though it will not call a ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','grid-level formatter')}\n if one exists).\n <P>\n This method is typically called from within a grid-level\n ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','formatCellValue()')} override when the developer wants\n to conditionally customize formatting for some fields while allowing other fields to\n use their standard formatting (including any field-level formatters). This avoids\n infinite recursion since the grid-level formatter is not called.\n <P>\n This method applies standard formatting such as ${isc.DocUtils.linkForRef('attr:ListGridField.valueMap')} mapping,\n ${isc.DocUtils.linkForRef('attr:ListGridField.displayField')} substitution, ${isc.DocUtils.linkForRef('attr:ListGridField.format')} application,\n and type-specific formatters. If a field-level formatter is present, it is called and\n other declarative formatting is skipped. The ${isc.DocUtils.linkForRef('attr:ListGrid.useLegacyDefaultFormattedValue')} flag\n can be used to revert to legacy behavior where these formatting steps were not applied\n when no field-level formatter is present.\n <P>\n The <code>rowNum</code> and <code>colNum</code> parameters are passed through to\n the field-level formatter if one exists. If not explicitly provided, these are\n defaulted to -1.\n <P>\n For other use cases, see also:\n <ul>\n <li>${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')} - get formatted value without any custom formatters</li>\n <li>${isc.DocUtils.linkForRef('method:ListGrid.getFormattedValue')} - get fully formatted value including all custom formatters</li>\n </ul>\n\n",flags:"A",returns:{type:"String",description:"Formatted value"},name:"getDefaultFormattedFieldValue"},"method:Window.setHeaderStyle":{seeAlso:[],ref:"method:Window.setHeaderStyle",deprecated:null,type:"method",definingClass:"class:Window",params:[{defaultValue:null,optional:false,type:"CSSStyleName",description:"new ${isc.DocUtils.linkForRef('attr:Canvas.styleName','styleName')} for the ${isc.DocUtils.linkForRef('attr:Window.header','header')}.",name:"newHeaderStyle"}],description:" Setter for ${isc.DocUtils.linkForRef('attr:Window.headerStyle','headerStyle')}.\n",flags:"",name:"setHeaderStyle"},"class:ResetPasswordTask":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"ProcessElement",classMethods:[],classAttrs:[],attrs:[],ref:"class:ResetPasswordTask",deprecated:null,treeLocation:["Client Reference/Workflow"],description:"Show user password reset dialog by opening the ${isc.DocUtils.linkForRef('classAttr:Authentication.resetPasswordURL','Auth.resetPasswordURL')}\n in another tab or window.",methods:[],name:"ResetPasswordTask"},"method:ValuesManager.itemChanged":{seeAlso:[],ref:"method:ValuesManager.itemChanged",deprecated:null,type:"method",definingClass:"class:ValuesManager",params:[{defaultValue:null,optional:false,type:"FormItem",description:"the FormItem where the change event occurred",name:"item"},{defaultValue:null,optional:false,type:"Any",description:"new value for the FormItem",name:"newValue"}],description:" Handler fired whenever a change to a FormItem fires itemChanged() on one of the \n member forms.  Fires after that event.\n\n",flags:"",name:"itemChanged"},"method:CoTProcess.getPromptPart":{seeAlso:[],type:"method",definingClass:"class:CoTProcess",returns:{type:"String",description:"Assembled fragment(s)"},groups:["CoT"],deprecated:null,ref:"method:CoTProcess.getPromptPart",params:[{defaultValue:null,optional:false,type:"String | Array of String",description:"One or more fragment names",name:"names"},{defaultValue:null,optional:false,type:"Boolean",description:"If true, do not surround with newlines",name:"omitNewlines"}],description:" Returns a named prompt fragment or concatenation of fragments for inclusion in task prompts.\n Built-in names:\n <ul>\n <li><b>\"goal\"</b> – primer from ${isc.DocUtils.linkForRef('attr:CoTProcess.goalPrimer')}, then ${isc.DocUtils.linkForRef('attr:CoTProcess.goal')}.</li>\n <li><b>\"history\"</b> – primer from ${isc.DocUtils.linkForRef('attr:CoTProcess.historyPrimer')}, then recent entries (omitted if\n      ${isc.DocUtils.linkForRef('attr:CoTProcess.noHistory','noHistory')} is true)</li>\n <li><b>\"transitions\"</b> – ${isc.DocUtils.linkForRef('attr:CoTProcess.transitionsPrimer')} followed by the current task's transitions</li>\n <li><b>\"errors\"</b> – primer from ${isc.DocUtils.linkForRef('attr:CoTProcess.errorsPrimer')} (or ${isc.DocUtils.linkForRef('attr:CoTTask.errorsPrimer')}),\n      then current validation errors if any</li>\n <li><b>\"goalData\"</b> – the raw ${isc.DocUtils.linkForRef('attr:CoTProcess.goal')} value.</li>\n </ul>\n Names matching keys in ${isc.DocUtils.linkForRef('attr:CoTProcess.optionalPrompts')} return that text. Pass an Array of names to\n concatenate multiple parts. Set <code>omitNewlines</code> to true to omit surrounding newlines.\n",flags:"",name:"getPromptPart"},"method:EditContext.serializeEditNodesAsJSON":{seeAlso:[],ref:"method:EditContext.serializeEditNodesAsJSON",deprecated:null,type:"method",definingClass:"class:EditContext",params:[{defaultValue:null,optional:false,type:"Array of EditNode",description:"EditNodes to be serialized",name:"nodes"},{defaultValue:null,optional:true,type:"SerializationSettings",description:"Additional serialization settings",name:"settings"}],description:" Serialize the provided ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} to a JSON\n representation of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')}. Note that the\n EditNodes must have been added to this EditContext. The result can be\n supplied to ${isc.DocUtils.linkForRef('method:EditContext.addPaletteNodesFromJSON','addPaletteNodesFromJSON()')} to\n recreate the EditNodes.\n\n",flags:"",returns:{type:"String",description:"a JSON representtion of the provided EditNodes"},name:"serializeEditNodesAsJSON"},"method:Layout.reflow":{seeAlso:[],ref:"method:Layout.reflow",deprecated:null,type:"method",definingClass:"class:Layout",params:[{defaultValue:null,optional:true,type:"String",description:"reason reflow() had to be called (appear in logs if enabled)",name:"reason"}],description:" Layout members according to current settings.\n <P>\n Members will reflow automatically when the layout is resized, members resize, the list of\n members changes or members change visibility.  It is only necessary to manually call\n <code>reflow()</code> after changing settings on the layout, for example,\n <code>layout.reverseOrder</code>.\n\n",flags:"A",name:"reflow"},"group:angularIntegration":{refs:[],seeAlso:[],ref:"group:angularIntegration",treeLocation:["Concepts/Integrating into Existing Apps"],deprecated:null,type:"group",title:"Angular Integration",description:"As with ${isc.DocUtils.linkForRef('group:integrationIntoExistingApps','other integrations')}, you can add\n SmartClient components to your Angular application by providing SmartClient with a DOM\n element created by Angular (or even the ID of a DOM element before it's been\n created).\n <p>\n All the same mechanisms for loading the framework apply, although Isomorphic recommends\n FileLoader's ${isc.DocUtils.linkForRef('classMethod:FileLoader.cache','cache')} &amp; ${isc.DocUtils.linkForRef('classMethod:FileLoader.load','load')}\n functions in most cases, where it's desirable to load the SmartClient runtime in the\n ${isc.DocUtils.linkForRef('group:backgroundDownload','background')}.\n <p>\n A simple way to facilitate that ability is to install SmartClient using Isomorphic\n ${isc.DocUtils.linkForRef('group:npmjs','npm support')}, providing the location tag to point at a location\n  that will be bundled with your app.  The 'assets' directory is a standard location\n for such things, so from your project's root directory:\n <pre>\n      npm install smartclient-eval --branch=13.0 --location=src/assets --yes\n </pre>\n\n Next, use a script tag to load FileLoader itself, and ideally, follow it with a request\n to cache framework resources.  So from perhaps a login.html, registration.html, and/or\n index.html:\n <pre>\n     &lt;script&gt;window.isomorphicDir = \"./assets/isomorphic/\"; &lt;/script&gt;\n     &lt;script src=\"./assets/isomorphic/system/modules/ISC_FileLoader.js\"&gt;&lt;/script&gt;\n     &lt;script&gt;\n       isc.FileLoader.cache();\n     &lt;/script&gt;\n </pre>\n Now you're ready to build SmartClient components and use them in your Angular components.\n Here, we have an complete Angular Component, written in TypeScript, that hooks into the\n Angular Component Lifecycle and calls an imported JavaScript helper function at the\n appropriate event:\n <h4>list.component.ts</h4>\n <pre>\n import {Component, AfterViewInit, ViewChild, ElementRef} from '@angular/core';\n\n import {drawCanvasOnElement} from '@app/_helpers/smartclient-framework';\n import {buildLayout} from './js/listComponent';\n\n &#64;Component({\n     template: `&lt;div #layout style=\"width:auto; height:250px;\"&gt;&lt;/div&gt;`\n })\n export class ListComponent implements AfterViewInit {\n\n     &#64;ViewChild('layout', {static: true}) layoutElementRef: ElementRef;\n\n     /*\n      * When the Angular component creates the '#layout' element in the template,\n      * provide it to the drawCanvasOnElement helper function.  Note that we do\n      * not implement an ngOnDestroy function here to destroy the layout,\n      * since SmartClient while detect the destruction of the nativeElement and in\n      * turn destroy the component\n      */\n     ngAfterViewInit() {\n         const ele = this.layoutElementRef.nativeElement;\n         drawCanvasOnElement(buildLayout, ele);\n     }\n }\n </pre>\n This looks exactly like any other Angular component, but we import a few very simple\n JavaScript functions that do the heavy lifting.\n <h4>./js/listComponent.js</h4>\n <pre>\n export function buildLayout(element) {\n\n   const ds = isc.DataSource.create({\n     clientOnly: true,\n     fields: [\n       {name: 'id', type: 'text', primaryKey: true, canEdit: false, hidden: true},\n       {name: 'title', type: 'text', required: true, valueMap: ['Mr', 'Mrs', 'Miss', 'Ms']},\n       {name: 'firstName', type: 'text', required: true},\n       {name: 'lastName', type: 'text', required: true},\n       {name: 'email', type: 'text', required: true,\n         validators: [\n           {type: 'regexp', expression: '^([a-zA-Z0-9_.\\\\-+])+@(([a-zA-Z0-9\\\\-])+\\\\.)+[a-zA-Z0-9]{2,4}$'}\n         ]\n       },\n       {name: 'role', type: 'text', required: true, valueMap: ['User', 'Admin']}\n     ],\n     cacheData: [{\n       id: 1,\n       title: 'Mr',\n       firstName: 'Joe',\n       lastName: 'Bloggs',\n       email: 'joe@bloggs.com',\n       role: 'User',\n       password: 'joe123'\n     }]\n   });\n\n   const grid = isc.ListGrid.create({\n     dataSource: ds,\n     autoFetchData: true,\n     canEdit: true,\n     canRemoveRecords: true\n   });\n\n   const button = isc.Button.create({\n     title: 'Add User',\n     autoFit: true,\n     click: function() {\n       grid.startEditingNew();\n       return this.Super('click', arguments);\n     }\n   });\n\n   /* position the layout on the provided element */\n   return isc.VLayout.create({\n     autoDraw: true,\n     htmlElement: element,\n     matchElement: true,\n     members: [\n       button,\n       grid\n     ],\n     membersMargin: 10\n   });\n }\n </pre>\n This just creates a typical SmartClient Layout containing a databound ListGrid and\n a Button that manipulates the ListGrid, the same as any other SmartClient component\n creation.  Note that when it's drawn, the layout will be placed in the DOM element\n created by the Angular component thanks to ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')}.\n <p>\n Finally, a little helper <code>drawCanvasOnElement</code> function that causes the\n SmartClient runtime to be loaded if it hasn't already, and provides the given element\n to the builder function when everything is ready.\n <h4>@app/_helpers/smartclient-framework.js</h4>\n <pre>\n\n /*\n  * Load the SmartClient Runtime if it hasn't yet been, positioning a spinner placeholder\n  * over the given element until the framework is available.  At that time, provide the\n  * element to a 'builder' function, which will use it to create a component at the right\n  * place.\n  */\n export function drawCanvasOnElement (builder, element) {\n\n     isc.FileLoader.load(() => {\n         builder(element);\n     }, {target: element});\n }\n </pre>",name:"angularIntegration"},"attr:Class.autoCreator":{seeAlso:[{ref:"group:autoChildren",description:null}],defaultValue:"varies",type:"attr",definingClass:"class:Class",groups:["autoChildren"],deprecated:null,ref:"attr:Class.autoCreator",valueType:"Class | String",description:"Specifies the component on which ${isc.DocUtils.linkForRef('method:Class.createAutoChild')} should be called to\n create ${isc.DocUtils.linkForRef('group:autoChildren')} defined lazily on this component in the format\n \"autoChild:<i>autoChildName</i>\".  This property may be either specified as a live\n component, or set to the <code><i>childName</i></code> of another already-created\n AutoChild.\n <P>\n If left unspecified, the Framework applies rules to determine which component to use as\n the creator.  If this component is itself an autochild, and properties or defaults for\n the child are defined on its ${isc.DocUtils.linkForRef('attr:Class.creator')} but not on the component itself, then the\n creator of this component is also used to create the new AutoChild.  Otherwise, this\n component is used.",flags:"IRA",name:"autoCreator"},"method:Layout.removeMember":{seeAlso:[],ref:"method:Layout.removeMember",deprecated:null,type:"method",definingClass:"class:Layout",params:[{defaultValue:null,optional:false,type:"Canvas",description:"the canvas to be removed from the layout",name:"member"}],description:" Removes the specified member from the layout.  If it has a resize bar, the bar will be\n destroyed.\n\n",flags:"",name:"removeMember"},"attr:ListGridField.valueIconWidth":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["imageColumns"],deprecated:null,ref:"attr:ListGridField.valueIconWidth",valueType:"number",description:"Width for value icons for this listGrid field.\n Overrides ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconSize')}, ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconWidth')}, and\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')}.",flags:"IRW",name:"valueIconWidth"},"method:ListGrid.getHeaderSpanContextMenuItems":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"Array of MenuItem",description:"return false instead to avoid showing any menu"},groups:["headerSpan"],deprecated:null,ref:"method:ListGrid.getHeaderSpanContextMenuItems",params:[{defaultValue:null,optional:false,type:"HeaderSpan",description:"the component representing the headerSpan.  This component will                            have all the properties specified via ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans')}.",name:"headerSpan"}],description:" Return the menus items that should be shown in a menu triggered from a \n ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')}.  The default implementation returns the parent \n element's context menu, unless ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderSpanContextMenu')} is \n <code>true</code>, in which case it returns standard items for showing / hiding fields and \n freezing / unfreezing header spans.  Note that no column picker will be shown unless \n ${isc.DocUtils.linkForRef('attr:ListGrid.showTreeColumnPicker')} is <code>true</code>.\n\n",flags:"",name:"getHeaderSpanContextMenuItems"},"method:CellSelection.selectSingleCell":{seeAlso:[],type:"method",definingClass:"class:CellSelection",returns:{type:"Boolean",description:"true == selection actually changed, false == no change"},groups:["selection"],deprecated:null,ref:"method:CellSelection.selectSingleCell",params:[{defaultValue:null,optional:false,type:"int",description:"row index of cell to select",name:"rowNum"},{defaultValue:null,optional:false,type:"int",description:"column index of cell to select",name:"colNum"}],description:"   select a single cell and deselect everything else\n",flags:"",name:"selectSingleCell"},"attr:DSRequest.endRow":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DSRequest",groups:["paging"],deprecated:null,ref:"attr:DSRequest.endRow",valueType:"number",description:"End row of requested results, used only with fetch operations.\n <p>\n Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at\n the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.",flags:"IR",name:"endRow"},"class:SpacerItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"FormItem",classMethods:[],classAttrs:[],attrs:["attr:SpacerItem.showTitle","attr:SpacerItem.width","attr:SpacerItem.height"],ref:"class:SpacerItem",deprecated:null,description:"A SpacerItem takes up a single cell in the FormLayout, of arbitrary size.",methods:[],name:"SpacerItem"},"attr:ListGrid.sorterConstructor":{seeAlso:[],defaultValue:"Button",type:"attr",definingClass:"class:ListGrid",groups:["gridHeader","appearance"],deprecated:null,ref:"attr:ListGrid.sorterConstructor",valueType:"Class",description:"Widget class for the corner sort button, if showing.  This button displays the current\n sort direction of the primary sort field (either the only sorted field or the first in a\n ${isc.DocUtils.linkForRef('attr:ListGrid.canMultiSort','multi-sort')} grid) and reverses the direction of that field\n when clicked.  For consistent appearance, this\n is usually set to match ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonConstructor')}",flags:"IR",name:"sorterConstructor"},"attr:CalendarEvent.styleName":{seeAlso:[],ref:"attr:CalendarEvent.styleName",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:CalendarEvent",valueType:"CSSStyleName",description:"CSS style series to use for ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvas','canvas instances')} that \n represent this event in the various ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.  The basic \n series should include three classes - the base style and others suffixed \"Header\" and \"Body\".\n <P>\n If not specified on the event, the style can be specified on the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleName','calendar')}, the ${isc.DocUtils.linkForRef('attr:CalendarView.eventStyleName','view')} or\n individually on each ${isc.DocUtils.linkForRef('attr:Lane.eventStyleName','lane')} or ${isc.DocUtils.linkForRef('attr:Lane.sublanes','sublane')}.\n <P>\n The name of this field within the CalendarEvent can be changed via\n ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleNameField')}",flags:"IR",name:"styleName"},"attr:FieldPicker.instructionLabel":{seeAlso:[],ref:"attr:FieldPicker.instructionLabel",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FieldPicker",valueType:"AutoChild Label",description:"A ${isc.DocUtils.linkForRef('class:Label','label')} displaying the text assigned as the FieldPicker's\n ${isc.DocUtils.linkForRef('attr:FieldPicker.instructions','instructions')}.  Shown across the top of the widget.",flags:"IR",name:"instructionLabel"},"attr:ListGrid.collapseGroupOnRowClick":{seeAlso:[{ref:"method:ListGrid.groupBy",description:null}],defaultValue:"true",type:"attr",definingClass:"class:ListGrid",groups:["grouping"],deprecated:null,ref:"attr:ListGrid.collapseGroupOnRowClick",valueType:"boolean",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canCollapseGroup')} is true, will a click anywhere on the group row\n toggle the group's expanded state? If false, the user must click the\n ${isc.DocUtils.linkForRef('attr:ListGrid.groupIcon')} directly to toggle the group.",flags:"IR",name:"collapseGroupOnRowClick"},"classMethod:Canvas.stopDebuggingOverflow":{seeAlso:[{ref:"classMethod:Canvas.startDebuggingOverflow",description:null}],ref:"classMethod:Canvas.stopDebuggingOverflow",deprecated:null,type:"classMethod",definingClass:"class:Canvas",description:" Stop tracking and reporting excessive overflow.\n",flags:"",name:"stopDebuggingOverflow"},"attr:ResultTree.serverKeepParentsOnFilter":{seeAlso:[],ref:"attr:ResultTree.serverKeepParentsOnFilter",defaultValue:"See Below",deprecated:null,type:"attr",definingClass:"class:ResultTree",valueType:"Boolean",description:"If true, indicates that your own server code will handle the complexities associated with\n the combination of ${isc.DocUtils.linkForRef('attr:ResultTree.keepParentsOnFilter','keepParentsOnFilter')} and \n ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','loadDataOnDemand')}.  If this flag is true and your\n server code does <i>not</i> handle those complexities, the results are undefined, but \n most likely you will simply exclude non-matching parents if your tree is load-on-demand, \n which effectively means that filtering will be broken.\n <p>\n If this flag is not set, SmartClient will use its own automatic client-driven algorithm\n to ensure that <code>keepParentsOnFilter</code> is honored on load-on-demand trees.  See\n the <code>keepParentsOnFilter</code> overview for details",flags:"IRW",name:"serverKeepParentsOnFilter"},"attr:Scrollbar.cornerSize":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Scrollbar",groups:["corner"],deprecated:null,ref:"attr:Scrollbar.cornerSize",valueType:"Integer",description:"Allows the size of the corner segment to be set independently of the ${isc.DocUtils.linkForRef('attr:Scrollbar.btnSize')}.",flags:"IR",name:"cornerSize"},"attr:CubeGrid.editByCell":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:CubeGrid",groups:["cellEditing"],deprecated:null,ref:"attr:CubeGrid.editByCell",valueType:"Boolean",description:"CubeGrids only support editing by cell.",flags:"R",name:"editByCell"},"attr:RPCRequest.suppressAutoDraw":{seeAlso:[],ref:"attr:RPCRequest.suppressAutoDraw",defaultValue:"true",deprecated:null,type:"attr",definingClass:"object:RPCRequest",valueType:"Boolean",description:"If ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} is set, setting this property to true causes\n ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw')} to be set to false for the duration of the result evaluation -\n which is generally what you want if you're returning new components from the server.\n <P>\n This also effects components loaded via the ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadScreen')} API.",flags:"IRWA",name:"suppressAutoDraw"},"classMethod:RPCManager.isScreenCached":{seeAlso:[{ref:"attr:LoadScreenSettings.cacheScreen",description:null}],ref:"classMethod:RPCManager.isScreenCached",deprecated:null,type:"classMethod",definingClass:"class:RPCManager",params:[{defaultValue:null,optional:false,type:"String",description:"name of the screen",name:"screenName"}],description:"\n Returns true if a screen with the given name has already been cached by a call to \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.cacheScreens')} or similar (e.g. ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadProject')}), false otherwise.\n \n",flags:"",name:"isScreenCached"},"object:RESTAuthentication":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:RESTAuthentication.type","attr:RESTAuthentication.username","attr:RESTAuthentication.password","attr:RESTAuthentication.authToken","attr:RESTAuthentication.authHeader","attr:RESTAuthentication.dataSource"],groups:["serverRestConnector"],ref:"object:RESTAuthentication",deprecated:null,treeLocation:["Client Reference/Data Binding/DataSource"],description:"Authentication settings, applicable only to the ${isc.DocUtils.linkForRef('group:serverRestConnector','RestConnector')}",methods:[],serverDS:"only",name:"RESTAuthentication"},"method:ListGrid.anySelected":{groups:["selection"],seeAlso:[],ref:"method:ListGrid.anySelected",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Whether at least one item is selected\n",flags:"",returns:{type:"boolean",description:"true == at least one item is selected\t\t\t\t\t\t\t\tfalse == nothing at all is selected"},name:"anySelected"},"attr:JSONEncoder.skipNullValues":{seeAlso:[],ref:"attr:JSONEncoder.skipNullValues",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:JSONEncoder",valueType:"Boolean",description:"If true, don't include properties with null values when encoding an object.",flags:"IR",name:"skipNullValues"},"classMethod:Page.setIsomorphicDir":{groups:["files"],seeAlso:[],ref:"classMethod:Page.setIsomorphicDir",deprecated:null,type:"classMethod",definingClass:"class:Page",params:[{defaultValue:null,optional:true,type:"String",description:"New IsomorphicDir URL.",name:"URL"}],description:" Specify the root directory for Isomorphic-supplied files - the directory containing \n the <code>modules/</code> and <code>system/</code> subdirectories shipped as part of\n the SmartClient package.\n <P>\n Note that this property is commonly specified directly in the bootstrap HTML file\n by setting <code>window.isomorphicDir</code> before loading the SmartClient library files.\n\n",flags:"",name:"setIsomorphicDir"},"attr:SectionStack.canTabToHeaders":{seeAlso:[],ref:"attr:SectionStack.canTabToHeaders",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SectionStack",valueType:"boolean",description:"If true, the headers for the sections (if shown) will be included in the page's tab\n order for accessibility. \n May be overridden at the Section level via ${isc.DocUtils.linkForRef('attr:SectionStackSection.canTabToHeader')}\n <P>\n If unset, section headers will be focusable if ${isc.DocUtils.linkForRef('staticMethod:isc.setScreenReaderMode')}\n \n  has been called.\n See ${isc.DocUtils.linkForRef('group:accessibility')}.",flags:"IRA",name:"canTabToHeaders"},"method:TileLayout.getTile":{seeAlso:[],ref:"method:TileLayout.getTile",deprecated:null,type:"method",definingClass:"class:TileLayout",params:[{defaultValue:null,optional:false,type:"int",description:"index of the tile",name:"index"}],description:" Retrieve a tile by index.  \n <P>\n The TileLayout consistently uses this method to access tiles, in order to allow subclasses\n to create tiles on demand.\n\n",flags:"",returns:{type:"Canvas",description:"the tile"},name:"getTile"},"group:paging":{refs:["attr:DSResponse.startRow","attr:DSResponse.endRow","attr:DSResponse.totalRows","attr:DSResponse.progressiveLoading","attr:DSRequest.startRow","attr:DSRequest.endRow"],seeAlso:[],ref:"group:paging",deprecated:null,type:"group",description:null,name:"paging"},"classMethod:Page.getIsomorphicDir":{groups:["files"],seeAlso:[],ref:"classMethod:Page.getIsomorphicDir",deprecated:null,type:"classMethod",definingClass:"class:Page",description:"\t\tReturn the root directory for Isomorphic-specific files.\n\n",flags:"",returns:{type:"String",description:"IsomorphicDir URL."},name:"getIsomorphicDir"},"attr:LoadScreenSettings.missingDSIsNotFatal":{seeAlso:[],ref:"attr:LoadScreenSettings.missingDSIsNotFatal",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:LoadScreenSettings",valueType:"Boolean",description:"If true, server logic does not crash out if it cannot load a DataSource specified in the\n screen definition.  Instead, a stub DataSource is returned, which consists of nothing\n except the ID and an <code>unableToLoad</code> flag, which client-side code can use to\n determine that the DataSource could not be loaded on the server.  Optional, defaults to\n false (ie, a missing DataSource causes a crash by default)",flags:"IRW",name:"missingDSIsNotFatal"},"attr:ResultSet.requestProperties":{seeAlso:[],ref:"attr:ResultSet.requestProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ResultSet",valueType:"DSRequest Properties",description:"Allows to set a DSRequest properties to this ResulSet.",flags:"IR",name:"requestProperties"},"attr:EventCanvas.headerStyle":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:EventCanvas",groups:["appearance"],deprecated:null,ref:"attr:EventCanvas.headerStyle",valueType:"CSSStyleName",description:"CSS class for the ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')} of the EventCanvas.\n If unset, defaults to the ${isc.DocUtils.linkForRef('attr:EventCanvas.styleName','base styleName')} with the suffix\n \"Header\".",flags:"IRW",name:"headerStyle"},"classAttr:EventHandler.STOP_BUBBLING":{seeAlso:[],ref:"classAttr:EventHandler.STOP_BUBBLING",defaultValue:'"***STOP***"',deprecated:null,type:"classAttr",definingClass:"class:EventHandler",valueType:"String",description:"Return this constant from a child event to stop the event propagating to its parent,\n without suppressing any native browser handling associated with the event.\n Developers should not need to modify this value - it should be treated as read-only\n in most circumstances.",flags:"IRA",name:"STOP_BUBBLING"},"method:ListGrid.editFailed":{groups:["editing"],seeAlso:[],ref:"method:ListGrid.editFailed",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"number",description:"current index of the row we attempted to save",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"index of the column where the edit failed, if applicable",name:"colNum"},{defaultValue:null,optional:false,type:"Object | Record",description:"new values that we attempted to save",name:"newValues"},{defaultValue:null,optional:false,type:"Record",description:"the complete original values from before the save occurred",name:"oldValues"},{defaultValue:null,optional:false,type:"EditCompletionEvent",description:"Edit completion event that led to the save                                                  attempt",name:"editCompletionEvent"},{defaultValue:null,optional:true,type:"DSResponse",description:"DSResponse, for saves through a DataSource",name:"dsResponse"}],description:" Called when an attempt to save inline edits fails, due to a validation error or other\n server error.\n <P>\n The default implementation of editFailed does nothing for normal validation errors,\n which are displayed before editFailed() is called.  For any other errors, the default\n implementation will call ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError')}, which by default\n will result in a warning dialog.\n\n",flags:"",name:"editFailed"},"method:Calendar.timelineEventMoved":{seeAlso:[],ref:"method:Calendar.timelineEventMoved",deprecated:"in favor of ${isc.DocUtils.linkForRef('method:Calendar.eventRepositionStop')}",type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"CalendarEvent",description:"the event that was moved",name:"event"},{defaultValue:null,optional:false,type:"Date",description:"new start date of the passed event",name:"startDate"},{defaultValue:null,optional:false,type:"Date",description:"new end date of the passed event",name:"endDate"},{defaultValue:null,optional:false,type:"Lane",description:"the Lane in which this event has been dropped",name:"lane"}],description:" Called when a Timeline event is moved via dragging by a user.  Return false to disallow the \n move.\n",flags:"",returns:{type:"Boolean",description:"return false to disallow the move."},name:"timelineEventMoved"},"attr:ListGridField.includeFrom":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["display_values"],deprecated:null,ref:"attr:ListGridField.includeFrom",valueType:"String",description:"Indicates this field's values should be fetched from another, related DataSource.\n The individual field will inherit settings such as ${isc.DocUtils.linkForRef('attr:ListGridField.type','field.type')}\n and ${isc.DocUtils.linkForRef('attr:ListGridField.title','field.title')} from the related DataSource just like\n fields from the primary DataSource.\n <P>\n When ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fechData()')} is called, the automatically created ${isc.DocUtils.linkForRef('object:DSRequest')} will\n specify ${isc.DocUtils.linkForRef('attr:DSRequest.additionalOutputs')} requesting the field, and any ${isc.DocUtils.linkForRef('type:Criteria')}\n generated by the component will likewise refer to the field from the related DataSource.\n <P>\n It's an error to use this property if the ListGrid does not have a DataSource at all.\n The related DataSource must be loaded or a warning will be logged and the field\n definition ignored.\n <P>\n This value is expected to be set to the following format\n <code>dataSourceID.fieldName</code> where <i>dataSourceID</i> is the ID of the\n related dataSource and <i>fieldName</i> is the name of the field from that dataSource\n from which you wish to retrieve values. Note that if this property is set and\n ${isc.DocUtils.linkForRef('attr:ListGridField.name','field.name')} is not explicitly specified, this field's <code>name</code> will\n default to the <i>fieldName</i> value from this property.\n <p>\n Note about automatic cache updates: \"update\" and \"add\" operations\n submitted automatically by this ListGrid will include\n <code>dsRequest.additionalOutputs</code> to ensure all data necessary\n for cache updates is returned by the server.\n <p>\n If your grid shows data that can be edited elsewhere in the UI (not by\n inline editing), to avoid problems with ${isc.DocUtils.linkForRef('class:ResultSet')} automatic\n cache synchronization, you may need to switch from using\n <code>listGridField.includeFrom</code> to\n <code>dataSourceField.includeFrom</code>.  This is because\n server responses to \"add\" and \"update\" operations which are initiated\n outside of this grid do not know about the\n <code>listGridField.includeFrom</code> setting, and so will not\n automatically return data for fields included in this way.  Switching\n to <code>dataSourceField.includeFrom</code> ensures the field is\n always included in server responses, avoiding the issue.",flags:"IR",name:"includeFrom"},"attr:Snapbar.showDown":{seeAlso:[],ref:"attr:Snapbar.showDown",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:Snapbar",valueType:"Boolean",description:"Snapbars show mouse-down styling.",flags:"IRW",name:"showDown"},"attr:ListGrid.operatorIcon":{seeAlso:[],ref:"attr:ListGrid.operatorIcon",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"MultiAutoChild FormItemIcon",description:"Inline icon shown inside ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter editor')} fields when\n ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterOperators')} is enabled.",flags:"I",name:"operatorIcon"},"attr:ShowHideTask.targetSectionName":{seeAlso:[],ref:"attr:ShowHideTask.targetSectionName",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ShowHideTask",valueType:"String",description:"If ${isc.DocUtils.linkForRef('attr:ComponentTask.componentId','componentId')} targets a SectionStack, this property\n specifies the name of the target section. Alternately, the target section can be\n specified by using ${isc.DocUtils.linkForRef('attr:ShowHideTask.targetSectionTitle')}.",flags:"IR",name:"targetSectionName"},"method:DateItem.setSelectionRange":{seeAlso:[],ref:"method:DateItem.setSelectionRange",deprecated:null,type:"method",definingClass:"class:DateItem",params:[{defaultValue:null,optional:false,type:"int",description:"character index for start of new selection",name:"start"},{defaultValue:null,optional:false,type:"int",description:"character index for end of new selection",name:"end"}],description:" If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.setSelectionRange','setSelectionRange()')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",flags:"",name:"setSelectionRange"},"method:SavedSearches.getApplicationId":{seeAlso:[],ref:"method:SavedSearches.getApplicationId",deprecated:null,type:"method",definingClass:"class:SavedSearches",description:" Retrieves the value to saves as the link{SavedSearches.applicationIdField,\"applicationIdField\"} value\n for saved searches within this application.\n <P>\n Returns ${isc.DocUtils.linkForRef('attr:SavedSearches.applicationId','this.applicationId')} if specified, otherwise the current \n <a href='https://www.w3schools.com/jsref/prop_loc_pathname.asp' target='_blank'>window.location.pathname</a>\n will be returned by default.<br>\n Set ${isc.DocUtils.linkForRef('attr:SavedSearches.allowNullApplicationId')} to suppress this behavior of defaulting to the location.pathname.\n\n",flags:"",returns:{type:"String",description:"applicationId to be stored for saved searches."},name:"getApplicationId"},"attr:FacadeDataSource.queuedRequests":{seeAlso:[],ref:"attr:FacadeDataSource.queuedRequests",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FacadeDataSource",valueType:"Array of DSRequest",description:"An array of derived DS requests that are queued to be ${isc.DocUtils.linkForRef('method:DataSource.execute','executed')} on the\n underlying ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inherited')} DataSource.\n <p>\n When a DS request is made on this FacadeDataSource, if ${isc.DocUtils.linkForRef('attr:FacadeDataSource.queueRequests','queueRequests')}\n is true, then a new DS request is created based on the given DS request and added to this\n queue.\n <p>\n To clear the queue, set ${isc.DocUtils.linkForRef('attr:FacadeDataSource.queueRequests','queueRequests')} to false\n or call ${isc.DocUtils.linkForRef('method:FacadeDataSource.clearQueue','clearQueue()')}.",flags:"R",name:"queuedRequests"},"staticMethod:isA.nonemptyString":{seeAlso:[],ref:"staticMethod:isA.nonemptyString",deprecated:null,type:"staticMethod",definingClass:"object:isA",params:[{defaultValue:null,optional:false,type:"Object",description:"object to test",name:"object"}],description:"\n\tIs <code>object</code> a non-empty String?<br><br>\n\t\n",flags:"",returns:{type:"boolean",description:"true == <code>object</code> is a non-empty string"},name:"nonemptyString"},"method:DrawPane.zoom":{seeAlso:[],ref:"method:DrawPane.zoom",deprecated:null,type:"method",definingClass:"class:DrawPane",params:[{defaultValue:null,optional:false,type:"float",description:"Desired zoom level as a float where <code>1.0</code> is equivalent to 100% magnification. Must be greater than 0.",name:"zoomLevel"}],description:" Synonym of ${isc.DocUtils.linkForRef('method:DrawPane.setZoomLevel')}.\n",flags:"",name:"zoom"},"attr:ComboBoxItem.pickerExitButton":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ComboBoxItem",groups:["panelPlacement"],deprecated:null,ref:"attr:ComboBoxItem.pickerExitButton",valueType:"AutoChild NavigationButton",description:"${isc.DocUtils.linkForRef('class:NavigationButton')} to dismiss the picker interface, created when \n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListPlacement')} indicates that the search interface takes over the\n entire panel or screen.\n <p>\n The following ${isc.DocUtils.linkForRef('group:autoChildUsage','passthroughs')} apply:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickerExitButtonTitle','pickerExitButtonTitle')} for ${isc.DocUtils.linkForRef('attr:Button.title')}</li>\n </ul>",flags:"IR",name:"pickerExitButton"},"method:ListGrid.cellContextClick":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"Boolean",description:"whether to cancel the event"},groups:["events"],ref:"method:ListGrid.cellContextClick",deprecated:null,params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"cell record as returned by getCellRecord",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number of the cell",name:"colNum"}],description:" Called when a cell receives a contextclick event.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('cellClicks')}"],name:"cellContextClick"},"attr:Canvas.locatePeersType":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["autoTest"],deprecated:null,ref:"attr:Canvas.locatePeersType",valueType:"LocatorTypeStrategy",description:"${isc.DocUtils.linkForRef('type:LocatorTypeStrategy')} to use when finding peers of this canvas.",flags:"IRWA",name:"locatePeersType"},"group:mobileDevelopment":{refs:["classMethod:Page.getOrientation","classMethod:Page.updateViewport"],seeAlso:[],ref:"group:mobileDevelopment",treeLocation:["Concepts"],deprecated:null,type:"group",title:"Mobile Application Development",description:"SmartClient is designed to automatically adapt to smaller screen sizes and the lower\n accuracy of touch-based interfaces.  \n <p>\n In general, a SmartClient application written with complete ignorance of mobile development\n will still be highly usable on tablet or handset-sized touch devices.  This topic explains\n all the automatic behaviors that make this possible, and the few areas developers need to\n consider in order to optimize the mobile experience, the most important being:\n <p>\n <ul>\n <li> read about potential issues created by the automatically shown and hidden browser\n      toolbars in Safari on iOS7+, discussed under \"minimal-ui\" below.  SmartClient\n      automatically handles this, but most applications will want to create a non-interactive\n      banner to fill the blank screen area that is rendered unusable by iOS' behavior\n <li> read about \"Automatic touch scrolling\" below - if your application does not already\n      have alternative UIs for performing drag operations (as is required anyway for\n      ${isc.DocUtils.linkForRef('group:accessibility','accessibility reasons')}), this section discusses options for\n      controlling drag scrolling vs dragging of data\n <li> review your application for the rare screen that has a fixed, very wide width and\n      doesn't allow scrolling.  Such screens would already be unusable for narrow desktop\n      browsers but are more of a problem for fixed-size mobile screens.  The section\n      \"Exceptionally wide screens\" below explains strategies for dealing with this.\n </ul>\n <p>\n <h3>Supported Browsers</h3>\n <P>\n <ul>\n <li> Safari on iOS devices (iPad, iPhone, iPod Touch)\n <li> Android's default (WebKit-based) browser <b>*</b>\n <li> Windows Phone default browser, latest release only <b>**</b>\n <li> Blackberry 10+ default (WekKit-based) browser <b>**</b>\n </ul>\n <b>*</b>: Android issues that occur <i>exclusively</i> on rare devices (under a certain\n percent of market share) will not normally be covered by a Support plan.  This is a\n necessity because highly customized versions of Android are used for a variety of niche\n devices (even microsatellites)<br>\n <b>**</b>: These browsers generally work and bug reports are accepted, but they do not yet\n fall under the normal Enterprise+ Support guarantee of fixing every confirmed bug \n <p>\n If you would like to check whether a specific device falls under normal Support, or would\n like a quote for a Support plan that would include a specific device or platform,\n <a href='http://smartclient.com/company/contact.jsp' target='_blank'>contact Isomorphic here</a>.\n <P>\n <h3>Adaptive Components</h3>\n <p>\n Many SmartClient components automatically change their behavior and/or appearance when used\n with touch devices in general, or tablets and handsets specifically.  There are too many\n adaptations to comprehensively list, but some of the more obvious behaviors are listed below:\n <ul>\n <li> ${isc.DocUtils.linkForRef('class:SelectItem')} and ${isc.DocUtils.linkForRef('class:ComboBoxItem')} controls automatically fill the entire screen\n      or a major portion of the screen when activated, and add a control to dismiss the\n      full-screen interface.  See ${isc.DocUtils.linkForRef('attr:ComboBoxItem.pickListPlacement')} for details\n <li> ${isc.DocUtils.linkForRef('class:Menu')} components likewise fill the entire screen or a major portion, and offer\n      submenu navigation via a slide-in animation and back button instead of displaying the\n      origin menu and submenu simultaneously\n <li> ${isc.DocUtils.linkForRef('attr:Calendar.minimalUI','Calendar')} eliminates the tabs normally used to switch between\n      Day, Week and Month view, instead using device pivot to switch between Day and Week\n      views and offering a compact link to Month view\n <li> Windows and Dialogs fill the screen by default and remove rounded edges to save space\n <li> many controls implement an expanded hit area for clicks or drags so that finger touches\n      that are technically outside of the drawn area of the control still activate the\n      control.  This accommodates the imprecision of finger touches as compared to mouse\n      clicks, while still showing the same compact appearance as is used for desktop\n      interfaces.  This includes the ${isc.DocUtils.linkForRef('class:Slider')} thumb, ${isc.DocUtils.linkForRef('attr:Window.headerControls')},\n      ${isc.DocUtils.linkForRef('attr:Canvas.resizeFrom','edge-based resizing')}, and many other controls.\n <li> ${isc.DocUtils.linkForRef('class:SpinnerItem')} switches to side-by-side +/- controls instead of the very small,\n      vertically stacked +/- control typical of desktop interfaces\n <li> ${isc.DocUtils.linkForRef('class:AdaptiveMenu')} can either display menu items inline, or in a drop-down,\n        or mix the two modes according to available space.\n </ul>\n <p>\n In addition to automatic behavior, SmartClient offers Adaptive Layout whereby a ${isc.DocUtils.linkForRef('class:Layout')}\n member may be <i>designed</i> to render itself at multiple possible sizes, in order to fit\n into the amount of space available in the Layout.  Unlike simply indicating a flexible size\n on a member, setting an adaptive width or height indicates that the member has two (or more)\n different <i>ways</i> of rendering itself with different <i>discrete</I> sizes, but does not\n have the ability to use every additional available pixel.\n <p>\n For more guidance, see the documentation under ${isc.DocUtils.linkForRef('attr:Canvas.canAdaptWidth')} and the\n ${isc.DocUtils.linkForExampleId('inlinedMenuMobileSample', 'Inlined Menu Mobile')} and \n ${isc.DocUtils.linkForExampleId('adaptiveMenuMobileSample', 'Adaptive Menu')} samples.\n <p>\n <h3>Finger / touch event handling</h3>\n <P>\n Mobile and touch devices support \"touch events\" that correspond to finger actions on the\n screen.  By default, SmartClient simply sends touch events to UI components as normal mouse\n events.  Specifically:\n <ul>\n <li> a finger tap gesture will trigger mouseDown, mouseUp and click events\n <li> a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient\n      sequence of dragStart, dragMove, and dragStop\n <li> a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover\n      if no contextMenu is shown\n </ul>\n This means that most applications that are written with mouse interaction in mind will\n function with a touch-based UI without special efforts.  Some interfaces which rely heavily\n on mouse hovers may want to display instructions to explicitly tell the user that they have\n to touch a given element to see more information.\n <p>\n <h3>Automatic touch scrolling</h3>\n <p>\n Components that normally show scrollbars on desktop browsers will, by default, hide\n scrollbars and allow scrolling via finger dragging instead.\n <p>\n If you are using drag and drop features such as ${isc.DocUtils.linkForRef('attr:ListGrid.canReorderRecords')}, this\n obviously conflicts with using finger drags for scrolling.  There are two options:\n <p>\n <ol>\n <li> Leave touch scrolling active for the grid, but provide additional controls, such as\n      buttons, that enable users to perform the drag operation in a different way.\n      Optionally display scrollbars <em>in addition to</em> leaving touch scrolling active\n      by setting ${isc.DocUtils.linkForRef('attr:Canvas.alwaysShowScrollbars')} to <code>true</code>.\n <li> Set ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','useTouchScrolling')} to <code>false</code> on the component.\n      Scrollbars will be shown, and finger drags will no longer cause scrolling, so that\n      finger drags can now be used for the drag and drop operation configured on the\n      component\n </ol>\n Option #1 above is generally preferred, since it is also considered an\n ${isc.DocUtils.linkForRef('group:accessibility')} violation if drag and drop is the sole way to trigger an\n operation (keyboard-only users cannot use drag and drop), and also because scrollbars are\n not usually found in touch interfaces.\n <p>\n If your application is not required to be keyboard accessible, and you prefer to show\n scrollbars and use finger drags for normal drag operations, you can use\n ${isc.DocUtils.linkForRef('attr:Canvas.disableTouchScrollingForDrag')} to make this choice system-wide or on a\n per-component-type basis.\n <p>\n <h3>Exceptionally wide screens / forms</h3>\n <p>\n If you have designed a screen for desktop use and it is too wide to fit on a handset or\n tablet-sized screen, there are several possible strategies:\n <ul>\n <li> <b>use ${isc.DocUtils.linkForRef('class:SplitPane')}</b>: any time you have two or more panes where a choice in one\n      pane decides what is displayed in the other.  See the \"SplitPane\" section further down\n      for details\n <li> <b>rely on horizontal scrolling</b>: if you have something like a ${isc.DocUtils.linkForRef('class:DynamicForm')}\n      that has 3 columns of input fields, as long as the form itself or some parent has\n      ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow:\"auto\"')} set, horizontal touch scrolling will be\n      available to reach fields that initially render offscreen.  Most of the time, there is\n      already an <code>overflow:\"auto\"</code> parent component as a result of default\n      framework behaviors or application settings that also make sense for desktop mode,\n      so nothing needs to be done.\n      <p>\n      However, consider whether scrolling is already in use for other purposes: if you have a\n      grid plus an adjacent component to the right, if the adjacent component is entirely\n      offscreen, attempting touch scrollng on the grid will just scroll the grid as such and\n      won't reveal the adjacent component.  In this kind of situation, you can:\n   <ul>\n   <li> <i>use ${isc.DocUtils.linkForRef('class:SplitPane')}</i> as described above, a grid with something adjacent is\n        frequently a good candidate for conversion to <code>SplitPane</code>\n   <li> <i>make the scrolling component smaller or flexible size</i>.  Whether it's a grid or\n        other scrollable component on the left, this situation usually arises because an\n        inappropriately large fixed size has been set, instead of a\n        ${isc.DocUtils.linkForRef('attr:Canvas.width','flexible size')}.\n   <li> <i>leave some blank space</i> above or below the grid - this gives the user somewhere\n        to use touch scrolling to move both the grid and adjacent component\n   <li> <i>force scrollbars to appear</i> by setting\n        ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','useTouchScrolling')} to false.  This is another way to\n        give the user a place they can touch in order to scroll the both the grid and\n        adjacent component together\n   </ul>\n <li> <b>use ${isc.DocUtils.linkForRef('class:FlowLayout')}</b>: a <code>FlowLayout</code> can automatically take two\n      side-by-side elements and switch them to vertical stacking when the screen is narrow\n </ul>\n <p>\n <h3>SplitPane</h3>\n <p>\n The ${isc.DocUtils.linkForRef('class:SplitPane')} component implements the common pattern of rendering\n two or three panes simultaneously on desktop machines and on tablets in landscape\n orientation, while switching to showing a single pane for handset-sized devices or tablets\n in portrait orientation.\n <p>\n Use <code>SplitPane</code> anywhere you have two or more panes in your application where a\n choice in one pane decides what is displayed in the other pane.  For example, you may have a\n list of Records where details of a single selected Record are shown next to the list.  A\n <code>SplitPane</code> is well-suited to this interface since it provides automatic \"Back\"\n navigation and a place to show the title of the selected record when only the detail view is\n showing.\n <p>\n Note that you do not need to use a <code>SplitPane</code> as your top-level component\n containing the whole application, and it <i>does</i> makes sense to use multiple\n <code>SplitPane</code> components in a single application.  For example, your top-level\n container component might be a ${isc.DocUtils.linkForRef('class:TabSet')}, and a ${isc.DocUtils.linkForRef('class:SplitPane')} would be used to manage\n components in tabs which normally show 2 panes side-by-side on desktop browsers.\n <P>\n <h3>Device type and overriding</h3>\n <p>\n In most cases SmartClient will correctly detect the device running your application, and set\n the flags ${isc.DocUtils.linkForRef('classAttr:Browser.isTouch')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isTablet')} and\n ${isc.DocUtils.linkForRef('classAttr:Browser.isDesktop')} appropriately.\n <p>\n For any uncommon device for which these variables are not set correctly, you can use\n ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTablet')}, ${isc.DocUtils.linkForRef('classMethod:Browser.setIsHandset')} and ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTouch')}\n to override the auto-detected settings.  If you use these APIs, call them <b>before</b>\n creating or drawing any SmartClient components or using any other SmartClient APIs.\n <p>\n Note that the various automatic behaviors triggered by flags on the ${isc.DocUtils.linkForRef('class:Browser')} class can\n be overriden at a fine-grained level on individual components.  For example,\n ${isc.DocUtils.linkForRef('class:SplitPane')} will use 2-pane display when a tablet is detected, however, for a\n particularly large, high-resolution tablet device, you could instead use 3-pane display by\n setting ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode')} to \"desktop\".\n <p>\n <h3>Mobile look and feel</h3>\n <P>\n We recommend using either the Shiva, Tahoe, Twilight, Stratus or Obsidian skins for applications\n that support mobile (or a custom skin based on one of these skins).  These skins make\n maximum use of CSS3 to minimize the number of images that need to be loaded and the number\n of DOM elements used to create components.\n <p>\n We also do <b>not</b> recommend attempting to mimic the native UI of each particular mobile\n platform, because:\n <ul>\n <li> if users access the same application via desktop and mobile browsers, consistent\n appearance and behavior between the desktop and mobile rendering of the application is more\n important for familiarity than looking similar to other applications on the mobile device\n <li> mobile platform design overhauls, such as the major changes from iOS6 to iOS7, can\n easily invalidate efforts to look like native applications on the device\n <li> there is no single consistent appearance across Android devices because different\n manufacturers customize the platform a great deal, so efforts to closely mimic any one\n device won't yield any real consistency\n </ul>\n <P>\n <h3>iOS 7, browser toolbars and \"minimal-ui\" setting</h3>\n <p>\n Safari in iOS 7.0 will automatically hide and show browser toolbars as the user scrolls\n around a normal web page, pivots, or touches near edges of the screen.  This creates serious\n problems for web applications, partly because notifications are not reliably fired when\n toolbars are shown and hidden, and partly because it introduces \"dead zones\" where an\n application cannot place interactive controls, since touching there shows browser toolbars\n instead.\n <p>\n iOS 7.1 introduces a \"minimal-ui\" setting on the viewport <code>meta</code> tag which\n eliminates most of these problems, by requiring that the user specifically touch the \n URL bar to reveal browser toolbars.  Even with this setting, the top 20px of space <i>in\n landscape orientation only</i> is still a \"dead zone\".\n <p>\n SmartClient automatically uses the minimal-ui setting whenever iOS is detected, and also\n sets ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')} to 20px in landscape orientation to avoid components\n being placed in the dead zone.  These default behaviors can be disabled by defining the\n <code>isc_useMinimalUI</code> global variable with the value <code>false</code> before the\n framework is loaded: \n <pre> &lt;script type=\"text/javascript\"&gt;\n window.isc_useMinimalUI = false;\n &lt;/script&gt;</pre>\n <p>\n Whether minimal-ui is used or not, it is recommend to place some kind of non-interactive\n widget or content in the dead zones created by browser toolbars, for example, a ${isc.DocUtils.linkForRef('class:Label')}\n showing your company name or application name.  When using ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')} to have\n all components avoid a dead zone at the top of the page, you can set\n ${isc.DocUtils.linkForRef('attr:Canvas.leavePageSpace','leavePageSpace:0')} to allow individual components to place\n themselves in a dead zone.\n <p>\n <h3>Configuring the viewport</h3>\n <p>\n When a SmartClient application loads, by default a viewport &ltmeta&gt; tag is added to the\n page which, on touch devices, fixes the page zoom to 100% and disables the pinch-zoom gesture.\n This is usually the expected behavior of a touch-enabled web application because it makes\n the application look and feel more like a native app. This default setting can be disabled\n by defining the <code>isc_useDefaultViewport</code> global variable with the value\n <code>false</code> before the framework is loaded:\n <pre> &lt;script type=\"text/javascript\"&gt;\n window.isc_useDefaultViewport = false;\n &lt;/script&gt;</pre>\n For more information on the mobile device viewport, see:\n <ul>\n <li><a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Viewport_meta_tag' target='_blank'>Using the viewport meta tag to control layout on mobile browsers [MDN]</a></li>\n <li><a href='https://www.w3schools.com/css/css_rwd_viewport.asp' target='_blank'>Responsive Web Design - The Viewport [w3schools]</a></li>\n </ul>\n <p>\n <h3>Orientation Change &amp; Screen Size</h3>\n <P>\n When orientation changes, this is treated identically to resizing the browser on a desktop\n machine.  If you've already created a UI that fills the browser and makes good use of\n available screen space for desktop browsers, the same behaviors will automatically apply\n when your application runs on mobile devices and the device is pivoted.\n <P>\n If you want to build specialized interfaces that respond to device orientation, the\n ${isc.DocUtils.linkForRef('classMethod:Page.getOrientation')} API may be used to determine the current orientation of the\n application, and ${isc.DocUtils.linkForRef('type:PageEvent','the page orientationChange event')} will fire whenever the\n user rotates the screen allowing applications or components to directly respond to the user\n pivoting their device.\n <p>\n <h3>Launching native helper apps (phone, facetime, maps..)</h3>\n <p>\n Generally, all that's required to launch native mobile apps is to create an ordinary HTML\n hyperlink (<code>&lt;a&gt;</code> tag) with a special prefix for the URL specified in the\n <code>href</code> attribute.  For example, the following HTML link will place a call when\n the user finger-taps it:\n <pre>\n   &lt;a href=\"tel:8675309\"&gt;Call Jenny&lt;/a&gt;</pre>\n You can provide HTML like this as ${isc.DocUtils.linkForRef('attr:HTMLFlow.contents')}.  Or use a field of\n ${isc.DocUtils.linkForRef('type:FieldType','type:\"link\"')} to cause various\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')} to render a DataSourceField value as a\n clickable URL.\n <p>\n The URL prefixes that are valid for iOS are documented \n <a href='https://developer.apple.com/library/ios/featuredarticles/iPhoneURLScheme_Reference/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007899-CH1-SW1' target='_blank'>at Apple.com</a>.\n Typically, the same prefixes also work for Android, Windows Phone and others.\n <p>\n <h3>Configure the soft keyboard</h3>\n <p>\n ${isc.DocUtils.linkForRef('attr:TextItem.browserInputType')} can be set to various values such as \"email\" or \"tel\"\n (telephone number) to hint to mobile devices to use a different software keyboard with\n specialized keys appropriate for entering certain types of data values.\n <p>\n <h3>Note on mobile platform performance</h3>\n <p>\n When the first modern smartphones were released, it was necessary to use tiny,\n mobile-specific frameworks to get adequate performance for mobile web applications.\n <p>\n The situation is now completely different: through a combination of hardware improvements,\n optimizations in mobile browsers and vastly improved network speeds, typical mobile devices\n are easily able to run applications built with full-featured web platforms like SmartClient.\n For an application that supports both desktop and mobile interfaces, the worst case scenario\n for platform performance is often <b>not</b> a mobile phone, but an older desktop machine\n running Internet Explorer.\n <p>\n Unfortunately, there is a lot of out-of-date advice on the web about mobile web development\n that still advises using ultra-light, feature-poor frameworks for performance reasons.\n Carefully consider the source and recency of any such advice - the reality is that using\n such feature-poor frameworks means you will under-deliver with both your desktop <i>and</i>\n mobile interfaces.\n <p>\n For more background on choosing the right technologies for mobile and desktop web\n applications, see the \n <a href='http://smartclient.com/product/mobileStrategy.jsp' target='_blank'>Mobile Strategy Page</a> at\n smartclient.com.\n <P>\n <h3>Offline Operation</h3>\n <P>\n SmartClient applications support \"offline\" operation (continuing to work without network\n access).\n <P>\n Permanent caching of resources such as .js, .css files and images are handled via the standard\n <a href='https://www.google.com/search?q=html5+manifest' target='_blank'>HTML5 Manifest</a> - just list all\n the static files your application needs in a manifest file and mobile browsers will cache\n those resources.\n <P>\n Dynamic data is handled via the ${isc.DocUtils.linkForRef('class:Offline')} APIs as well as special DataSource support\n enabled by ${isc.DocUtils.linkForRef('attr:DataSource.useOfflineStorage')}.\n <P>\n The end result is that you can bookmark a SmartClient application to a phone's home screen\n and use it offline with cached data, much like an installed native application.\n <P>\n <h2>Packaging as a native application</h2>\n <P>\n Via \"packaging\" technologies such as PhoneGap/Cordova and Titanium, a SmartClient web application\n can be packaged as an installable native application that can be delivered via the \"App Store\"\n for the target mobile platform.  Applications packaged in this way have access to phone-specific\n data and services such as contacts stored on the phone, or the ability to invoke the device's camera.\n <P>\n Both Titanium and PhoneGap provide access to the underlying native device APIs such as the\n accelerometer, geolocation, and UI. Both frameworks enable application development using\n only JavaScript, CSS and HTML. Additionally they provide development environments that work\n across a wide variety of devices.\n <P>\n PhoneGap has good support for native device APIs as noted <a href='http://www.phonegap.com/about/feature' target='_blank'>here</a>.\n Titanium has similar support. There are differences between the two environments and how they\n expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE.\n See ${isc.DocUtils.linkForRef('group:titaniumIntegration','Integration with Titanium')} and ${isc.DocUtils.linkForRef('group:phonegapIntegration','Integration with PhoneGap')}\n for more information.",name:"mobileDevelopment"},"attr:PickList.clickMaskMode":{seeAlso:[],ref:"attr:PickList.clickMaskMode",defaultValue:'"hard"',deprecated:null,type:"attr",definingClass:"interface:PickList",valueType:"ClickMaskMode",description:'Determines the behavior of the click-mask thrown up when this pickList is visible.\n <P>\n The default value, "hard", matches the familiar behavior of combos and selects on \n Windows, Mac and other platforms - mouse-events such as rollovers are blocked and, when \n a click is received, the picker is hidden and the event is cancelled.\n <P>\n When <code>clickMaskMode</code> is "soft", mouse-events continue to fire, meaning that \n rollover styles, for example, continue to be updated.  When a click is received in this\n mode, the picker is hidden and the click event is allowed to proceed to its target - \n this means that clicking an item with an open picker will re-open the picker.',flags:"IRW",name:"clickMaskMode"},"attr:Window.printBodyStyle":{seeAlso:[],ref:"attr:Window.printBodyStyle",defaultValue:'"printHeader"',deprecated:null,type:"attr",definingClass:"class:Window",valueType:"CSSStyleName",description:"Style for the Window body in printed output.",flags:"IR",name:"printBodyStyle"},"attr:Calendar.baseStyle":{seeAlso:[],defaultValue:'"calendar"',type:"attr",definingClass:"class:Calendar",groups:["appearance"],deprecated:null,ref:"attr:Calendar.baseStyle",valueType:"CSSStyleName",description:'The base name for the CSS class applied to the grid cells of the day and week views\n of the calendar. This style will have "Dark", "Over", "Selected", or "Disabled"\n appended to it according to the state of the cell.\n <P>\n See ${isc.DocUtils.linkForRef(\'group:cellStyleSuffixes\')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles.',flags:"IRW",name:"baseStyle"},"attr:RadialGradient.cy":{seeAlso:[],ref:"attr:RadialGradient.cy",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:RadialGradient",valueType:"String",description:"y coordinate of outer radial",flags:"IR",name:"cy"},"attr:LoadProjectSettings.drawFirstScreen":{seeAlso:[{ref:"method:Project.createScreen",description:null},{ref:"classMethod:RPCManager.createScreen",description:null}],ref:"attr:LoadProjectSettings.drawFirstScreen",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:LoadProjectSettings",valueType:"boolean",description:"Determines whether the ${isc.DocUtils.linkForRef('attr:LoadProjectSettings.currentScreenName')} screen is drawn\n after all screens have been loaded.  If not drawn, the screen will not be created.\n <p>\n This setting only affects the first project specified in the <code>projectNames</code>\n argument to ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadProject')}.",flags:"IRW",name:"drawFirstScreen"},"method:Canvas.dragResizeMove":{groups:["widgetEvents"],seeAlso:[{ref:"method:Canvas.getOffsetX",description:null},{ref:"method:Canvas.getOffsetY",description:null},{ref:"classMethod:EventHandler.getDragRect",description:null}],ref:"method:Canvas.dragResizeMove",deprecated:null,type:"method",definingClass:"class:Canvas",description:"\n Executed every time the mouse moves while drag-resizing. If this method\n does not return false, the ${isc.DocUtils.linkForRef('attr:Canvas.dragTarget')} (or outline if\n ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance')} is set to \"outline\") will automatically be moved as appropriate\n whenever the mouse moves.\n\n",flags:"A",returns:{type:"Boolean",description:"false to suppress auto-resize of the ${isc.DocUtils.linkForRef('attr:Canvas.dragTarget')} or outline."},name:"dragResizeMove"},"attr:Dialog.styleName":{seeAlso:[],defaultValue:'"dialogBackground"',type:"attr",definingClass:"class:Dialog",groups:["appearance"],deprecated:null,ref:"attr:Dialog.styleName",valueType:"CSSStyleName",description:"Style of the Dialog background",flags:"IRW",name:"styleName"},"attr:RibbonButton.showTitle":{seeAlso:[],ref:"attr:RibbonButton.showTitle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:RibbonButton",valueType:"Boolean",description:"showTitle is not applicable to this class - use ${isc.DocUtils.linkForRef('attr:RibbonButton.showButtonTitle')}\n instead.",flags:"IRW",name:"showTitle"},"attr:FileDropZone.videoFileIcon":{seeAlso:[],ref:"attr:FileDropZone.videoFileIcon",defaultValue:'"[SKINIMG]FileDropZone/video.png"',deprecated:null,type:"attr",definingClass:"class:FileDropZone",valueType:"SCImgURL",description:"Icon for video files.",flags:"IR",name:"videoFileIcon"},"attr:ListGrid.headerMenuButton":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["headerMenuButton"],deprecated:null,ref:"attr:ListGrid.headerMenuButton",valueType:"AutoChild StatefulCanvas",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderMenuButton')} is true, when the user rolls over the header buttons in this\n grid the headerMenuButton will be shown over the header button in question. When clicked\n this button will display the standard header context menu (see\n ${isc.DocUtils.linkForRef('method:ListGrid.displayHeaderContextMenu')}).\n <P>\n ${isc.DocUtils.linkForRef('group:headerMenuButton','Several properties')} exist to customize the appearance of the\n headerMenuButton. Also see the ${isc.DocUtils.linkForRef('type:AutoChild')} documentation for information on how\n to make free-form modifications to autoChild widgets",flags:"RA",name:"headerMenuButton"},"classAttr:LoginDialog.LOGIN_ERROR_MESSAGE":{seeAlso:[],defaultValue:'"Invalid username or password"',type:"classAttr",definingClass:"class:LoginDialog",groups:["i18nMessages"],deprecated:null,ref:"classAttr:LoginDialog.LOGIN_ERROR_MESSAGE",valueType:"HTMLString",description:"Default error message displayed on failed login in the dialog shown by\n ${isc.DocUtils.linkForRef('staticMethod:isc.showLoginDialog')}.",flags:"IRW",name:"LOGIN_ERROR_MESSAGE"},"attr:DrawSector.radius":{seeAlso:[],ref:"attr:DrawSector.radius",defaultValue:"100",deprecated:null,type:"attr",definingClass:"class:DrawSector",valueType:"Distance",description:"Radius of the sector.",flags:"IR",name:"radius"},"attr:DatabaseBrowser.schemaPickerForm":{seeAlso:[],ref:"attr:DatabaseBrowser.schemaPickerForm",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"AutoChild DynamicForm",description:"A form containing a single ${isc.DocUtils.linkForRef('class:SelectItem')} which lists all the schemas\n available in the current database (though see \n ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schemaDataSource','schemaDataSource')} for details of how you can \n filter or otherwise modify this list)\n <P>\n Select a schema in the picklist to update the selected schema and display the table\n details in the ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schemaTree')}.  Set the selected schema to blank to show tables from\n all schemas.\n <p>\n Note, if the ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schema','schema')} property is set when the \n <code>DatabaseBrowser</code> is created, the schemaPicker shows the schema name, but is\n set read only so the user cannot change the selection.",flags:"IR",name:"schemaPickerForm"},"method:MultiPickerItem.getOptionCriteria":{seeAlso:[],ref:"method:MultiPickerItem.getOptionCriteria",deprecated:null,type:"method",definingClass:"class:MultiPickerItem",description:" Return the derived ${isc.DocUtils.linkForRef('attr:MultiPickerItem.optionCriteria')} for this item\n",flags:"",returns:{type:"Criteria",description:"criteria to apply to the pickList and expandedPickerGrid"},name:"getOptionCriteria"},"attr:Tour.tourStepWizardAutoCompleteTitle":{seeAlso:[],defaultValue:'"Auto Complete"',type:"attr",definingClass:"class:Tour",groups:["i18nMessages"],deprecated:null,ref:"attr:Tour.tourStepWizardAutoCompleteTitle",valueType:"HTMLString",description:"Title for the <i>Auto Complete</i> field in the TourStep Wizard.",flags:"IR",name:"tourStepWizardAutoCompleteTitle"},"classMethod:MultiWindow.resize":{seeAlso:[],ref:"classMethod:MultiWindow.resize",deprecated:null,type:"classMethod",definingClass:"class:MultiWindow",params:[{defaultValue:null,optional:false,type:"String",description:"unique window name",name:"name"},{defaultValue:null,optional:false,type:"number",description:"desired new width",name:"width"},{defaultValue:null,optional:false,type:"number",description:"desired new height",name:"height"},{defaultValue:null,optional:true,type:"RemoteWindowCallback",description:"callback run after ${isc.DocUtils.linkForRef('class:RemoteWindow')} moved",name:"callback"}],description:" Resizes e existing window with the specified name,\n",flags:"",name:"resize"},"method:DrawItem.scaleBy":{seeAlso:[],ref:"method:DrawItem.scaleBy",deprecated:null,type:"method",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:false,type:"float",description:"scale in the x direction",name:"x"},{defaultValue:null,optional:false,type:"float",description:"scale in the y direction",name:"y"}],description:" Scale the shape by the x, y multipliers\n",flags:"",name:"scaleBy"},"classMethod:Page.isDarkSkin":{seeAlso:[],ref:"classMethod:Page.isDarkSkin",deprecated:null,type:"classMethod",definingClass:"class:Page",description:" Returns true if the current skin has a dark background and light text, false otherwise.\n",flags:"",returns:{type:"Boolean",description:"true if the current skin has a dark background and light text"},name:"isDarkSkin"},"attr:LinearGradient.x2":{seeAlso:[],ref:"attr:LinearGradient.x2",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:LinearGradient",valueType:"String",description:"X coordinate of the end point. This can be a number or a percentage of the width of the\n bounding box of the DrawItem to which it is applied.",flags:"IR",name:"x2"},"attr:GroupNode.groupMembers":{seeAlso:[{ref:"method:ListGrid.groupBy",description:null}],defaultValue:"see below",type:"attr",definingClass:"object:GroupNode",groups:["grouping"],deprecated:null,ref:"attr:GroupNode.groupMembers",valueType:"Array of ListGridRecord | GroupNode",description:"Array of ListGridRecord that belong to this group, or, for multi-field grouping, array\n of groupNodes of subgroups under this groupNode.",flags:"R",name:"groupMembers"},"method:Date.toNormalDate":{seeAlso:[],type:"method",definingClass:"object:Date",returns:{type:"String",description:"formatted date string"},groups:["dateFormatting"],deprecated:null,ref:"method:Date.toNormalDate",params:[{defaultValue:null,optional:false,type:"DateDisplayFormat",description:"Optional Format for the date returned",name:"format"}],description:' Returns the date as a formatted string using the format set up via the\n <code>setNormalDisplayFormat()</code> method. Note that the default formatter for this\n method is <code>"toLocaleString"</code>.\n',flags:"",name:"toNormalDate"},"attr:FacetChart.logBase":{seeAlso:[],defaultValue:"10",type:"attr",definingClass:"class:FacetChart",groups:["gradations"],deprecated:null,ref:"attr:FacetChart.logBase",valueType:"int",description:"When ${isc.DocUtils.linkForRef('attr:FacetChart.useLogGradations')}, base value for logarithmic gradation lines.  Gradation\n lines will be shown at every power of this value plus intervening values specified by\n ${isc.DocUtils.linkForRef('attr:FacetChart.logGradations')}.",flags:"IR",name:"logBase"},"method:DrawSector.getCenter":{seeAlso:[],ref:"method:DrawSector.getCenter",deprecated:null,type:"method",definingClass:"class:DrawSector",description:" Returns the sector's ${isc.DocUtils.linkForRef('attr:DrawSector.centerPoint','centerPoint')}.\n",flags:"",returns:{type:"Point",description:"the current centerPoint"},name:"getCenter"},"attr:ToggleSwitch.defaultValue":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:ToggleSwitch",groups:["appearance"],deprecated:null,ref:"attr:ToggleSwitch.defaultValue",valueType:"Boolean",description:"The default value of this ToggleSwitch.",flags:"IRW",name:"defaultValue"},"attr:DataBoundComponent.dataFetchMode":{seeAlso:[],defaultValue:'"paged"',type:"attr",definingClass:"interface:DataBoundComponent",groups:["databinding"],deprecated:null,ref:"attr:DataBoundComponent.dataFetchMode",valueType:"FetchMode",description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",flags:"IR",name:"dataFetchMode"},"attr:Shuttle.deselectAllButtonHeight":{seeAlso:[],ref:"attr:Shuttle.deselectAllButtonHeight",defaultValue:"22",deprecated:null,type:"attr",definingClass:"class:Shuttle",valueType:"Integer",description:"Height for the ${isc.DocUtils.linkForRef('attr:Shuttle.deselectAllButton')}",flags:"IR",name:"deselectAllButtonHeight"},"method:EditContext.removeAll":{seeAlso:[],ref:"method:EditContext.removeAll",deprecated:null,type:"method",definingClass:"class:EditContext",description:" Removes all ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} from the EditContext, but does not destroy \n the ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObjects')}.\n",flags:"",name:"removeAll"},"method:SimpleType.parseInput":{seeAlso:[],ref:"method:SimpleType.parseInput",deprecated:null,type:"method",definingClass:"class:SimpleType",params:[{defaultValue:null,optional:false,type:"String",description:"edited value provided by the user",name:"value"},{defaultValue:null,optional:true,type:"FormItem",description:"Editor for this field",name:"field"},{defaultValue:null,optional:true,type:"DynamicForm",description:"DynamicForm containing this editor",name:"form"},{defaultValue:null,optional:true,type:"Record",description:"Current edit values for this record, as displayed in      the edit component.",name:"record"}],description:" Parser to convert some user-edited value to an underlying data value of this type.\n This parser is called when storing out values edited in a freeform editor such as\n a ${isc.DocUtils.linkForRef('class:TextItem')}. Typically this will convert from the format produced by \n ${isc.DocUtils.linkForRef('method:SimpleType.editFormatter')} back to a data value.\n\n",flags:"",returns:{type:"Any",description:"data value derived from display string passed in."},name:"parseInput"},"classMethod:Canvas.showPrintPreview":{groups:["printing"],seeAlso:[],ref:"classMethod:Canvas.showPrintPreview",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"Array of Canvas",description:"components to get the print HTML for. May also include  raw HTML strings which will be folded into the generated print output",name:"components"},{defaultValue:null,optional:true,type:"PrintProperties",description:"PrintProperties object for customizing the     print HTML output",name:"printProperties"},{defaultValue:null,optional:true,type:"PrintWindow Properties",description:"Properties to apply to the     generated print window.",name:"printWindowProperties"},{defaultValue:null,optional:true,type:"Callback",description:"callback to fire when the print preview canvas has     been populated with the printable HTML. This callback takes 2 parameters:\n    <code>printPreview</code> - a pointer to the generated print canvas shown in the\n    body of the print window.\n    <code>printWindow</code> - a pointer to the generated print window and",name:"callback"},{defaultValue:null,optional:true,type:"String",description:"Optional HTML separator to render between each component's printable                      HTML",name:"separator"}],description:" Generate and show a ${isc.DocUtils.linkForRef('class:PrintWindow')} containing a ${isc.DocUtils.linkForRef('class:PrintCanvas')}\n showing a printable view of the components passed in.\n\n",flags:"",name:"showPrintPreview"},"attr:TestFunctionResult.record":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:TestFunctionResult",groups:["formulaFields"],deprecated:null,ref:"attr:TestFunctionResult.record",valueType:"Record",description:"Set to the record that was used when testing the generated function.  This is the record\n selected by ${isc.DocUtils.linkForRef('method:FormulaBuilder.getTestRecord')}.",flags:"IRW",name:"record"},"classMethod:Canvas.setNativeAutoHideScrollbars":{seeAlso:[{ref:"attr:Canvas.scrollbarConstructor",description:null},{ref:"attr:Canvas.showCustomScrollbars",description:null}],ref:"classMethod:Canvas.setNativeAutoHideScrollbars",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"boolean",description:"whether the native scrollbar should auto-hide by default.",name:"autoHideNativeScrollbars"}],description:" In some platform/browser configurations, scrollable regions do not show visible scrollbars until \n the user attempts to interact with the region. The interaction to show the scrollbar varies by \n browser/OS but may include starting a trackpad scroll or simply rolling over the scrollable element. \n <P>\n This method changes the value of ${isc.DocUtils.linkForRef('attr:Canvas.nativeAutoHideScrollbars')}.\n",flags:"",name:"setNativeAutoHideScrollbars"},"attr:FacetChart.autoSortBubblePoints":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:FacetChart",groups:["appearance"],ref:"attr:FacetChart.autoSortBubblePoints",deprecated:null,valueType:"boolean",description:"Whether to draw data points in order of descending ${isc.DocUtils.linkForRef('attr:FacetChart.pointSizeMetric','point size')}\n so that small values are less likely to be completely occluded by larger values.  Set\n this to <code>false</code> to draw the data points in the same order that they appear\n in the data.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('bubbleChart')}"],name:"autoSortBubblePoints"},"method:FormItem.show":{seeAlso:[],ref:"method:FormItem.show",deprecated:null,type:"method",definingClass:"class:FormItem",description:" Show this form item.\n <p>\n This will cause the form to redraw.  If this item had an item.showIf expression, it will\n be destroyed.\n",flags:"",name:"show"},"classAttr:RPCManager.keepParentsOnFilterMaxNodesExceededMessage":{seeAlso:[],defaultValue:'"The filter includes too many tree nodes; please specify a more restrictive filter"',type:"classAttr",definingClass:"class:RPCManager",groups:["i18nMessages"],deprecated:null,ref:"classAttr:RPCManager.keepParentsOnFilterMaxNodesExceededMessage",valueType:"HTMLString",description:"Default message displayed to the user when a databound \n ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','load-on-demand')} ${isc.DocUtils.linkForRef('class:TreeGrid','TreeGrid')} is \n filtered while ${isc.DocUtils.linkForRef('attr:ResultTree.keepParentsOnFilter','keepParentsOnFilter')} is in force, \n and the number of tree nodes matching the filter exceeds \n ${isc.DocUtils.linkForRef('attr:ResultTree.keepParentsOnFilterMaxNodes','keepParentsOnFilterMaxNodes')}",flags:"IRW",name:"keepParentsOnFilterMaxNodesExceededMessage"},"method:Canvas.animateResize":{seeAlso:[],type:"method",definingClass:"class:Canvas",groups:["animation"],deprecated:null,ref:"method:Canvas.animateResize",params:[{defaultValue:null,optional:false,type:"Integer",description:"new width (or null for unchanged)",name:"width"},{defaultValue:null,optional:false,type:"Integer",description:"new height (or null for unchanged)",name:"height"},{defaultValue:null,optional:true,type:"AnimationCallback",description:"When the resize completes this callback will be                       fired. Single 'earlyFinish' parameter will be passed if the\n                       animation was cut short, for example by a call to the non-animated\n                       APIs ${isc.DocUtils.linkForRef('method:Canvas.resizeTo')} or ${isc.DocUtils.linkForRef('method:Canvas.resizeBy')}.",name:"callback"},{defaultValue:null,optional:true,type:"Integer",description:"Duration in ms of the animated resize",name:"duration"},{defaultValue:null,optional:true,type:"AnimationAcceleration",description:"Optional acceleration effect to apply to the resize",name:"acceleration"}],description:" Animate a resize of this canvas from its current size to the specified size\n <p>\n Note that ${isc.DocUtils.linkForRef('attr:Canvas.animateResizeLayoutMode')} allows you to control whether child layout is\n rerun during every step of the animation, or just at the end, since the former may incur\n significant overhead depending on the widget hierarchy.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('animateResize')}"],name:"animateResize"},"method:CancellationController.createSubController":{seeAlso:[],ref:"method:CancellationController.createSubController",deprecated:null,type:"method",definingClass:"class:CancellationController",description:" Creates a new ${isc.DocUtils.linkForRef('class:CancellationController')} which is canceled whenever this\n <code>CancellationController</code> is canceled.\n <p>\n Note that the sub-<code>CancellationController</code> may be independently canceled\n before this parent <code>CancellationController</code> is canceled.\n",flags:"",returns:{type:"CancellationController",description:"a new ${isc.DocUtils.linkForRef('class:CancellationController')} that is canceled whenever this <code>CancellationController</code> is canceled."},name:"createSubController"},"attr:DatabaseBrowser.schemaFetchOperation":{seeAlso:[],ref:"attr:DatabaseBrowser.schemaFetchOperation",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"String",description:"Optional ${isc.DocUtils.linkForRef('attr:OperationBinding.operationId')} to pass to the ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schemaDataSource')} when \n retrieving the list of schemas for a selected database.",flags:"IRA",name:"schemaFetchOperation"},"method:ListGrid.showFields":{seeAlso:[],ref:"method:ListGrid.showFields",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"Array of String | Array of ListGridField",description:"Fields to show.",name:"field"},{defaultValue:null,optional:true,type:"boolean",description:"If passed, don't resize non-explicitly sized columns                                       to fill the available space.",name:"suppressRelayout"}],description:" Force an array of fields to be shown. This method does not add new fields to the grid,\n it simply changes field visibility. If a field.showIf expression exists, it will be\n destroyed.\n <P>\n Note: for showing multiple fields it is more efficient to call this method than to call\n ${isc.DocUtils.linkForRef('method:ListGrid.showField')} repeatedly.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('columnOrder')}"],name:"showFields"},"attr:Menu.baseStyle":{seeAlso:[],ref:"attr:Menu.baseStyle",defaultValue:'"menu"',deprecated:null,type:"attr",definingClass:"class:Menu",valueType:"CSSStyleName",description:"CSS style for a normal cell",flags:"IRW",name:"baseStyle"},"class:HStack":{seeAlso:[{ref:"attr:Layout.hPolicy",description:null}],exampleConfig:"HStack.xml",type:"class",staticMethods:[],inheritsFrom:"Layout",classMethods:[],classAttrs:[],attrs:[],ref:"class:HStack",deprecated:null,treeLocation:["Client Reference/Layout"],description:"A subclass of Layout that simply stacks members on the horizontal axis without trying to\n manage their width.  On the vertical axis, any members that do not have explicit heights will\n be sized to match the height of the stack.",methods:[],name:"HStack"},"attr:Window.isModal":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:Window",groups:["modal"],ref:"attr:Window.isModal",deprecated:null,valueType:"Boolean",description:"If true, when shown this Window will intercept and block events to all other existing\n components on the page.\n <P>\n Use ${isc.DocUtils.linkForRef('attr:Window.showModalMask')} to darken all other elements on the screen when a modal dialog\n is showing.\n <P>\n Chained modal windows - that is, modal windows that launch other modal windows - are\n allowed.  You can accomplish this by simply creating a second modal Window while a modal\n Window is showing.\n <P>\n Note only top-level Windows (Windows without parents) can be modal.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('modality')}"],name:"isModal"},"attr:ToolbarItem.colSpan":{seeAlso:[],defaultValue:'"*"',type:"attr",definingClass:"class:ToolbarItem",groups:["appearance"],deprecated:null,ref:"attr:ToolbarItem.colSpan",valueType:"int | String",description:"these items span all columns",flags:"IRW",name:"colSpan"},"group:gradations":{refs:["method:FacetChart.setPixelsPerGradation","method:FacetChart.setOtherAxisPixelsPerGradation","method:FacetChart.setGradationGaps","method:FacetChart.setOtherAxisGradationGaps","method:FacetChart.setOtherAxisGradationTimes","method:MetricSettings.getGradations","method:FacetChart.getGradations","attr:FacetChart.pixelsPerGradation","attr:FacetChart.otherAxisPixelsPerGradation","attr:FacetChart.gradationGaps","attr:FacetChart.otherAxisGradationGaps","attr:FacetChart.otherAxisGradationTimes","attr:FacetChart.gradationLabelProperties","attr:FacetChart.gradationLineProperties","attr:FacetChart.gradationZeroLineProperties","attr:FacetChart.pointSizeGradations","attr:FacetChart.usePointSizeLogGradations","attr:FacetChart.pointSizeLogGradations","attr:FacetChart.useLogGradations","attr:FacetChart.logBase","attr:FacetChart.logGradations","attr:FacetChart.showGradationsOverData","attr:FacetChart.gradationTickMarkLength","attr:MetricSettings.gradationLabelProperties","attr:MetricSettings.gradationLineProperties","attr:MetricSettings.gradationZeroLineProperties","attr:MetricSettings.useLogGradations","attr:MetricSettings.logBase","attr:MetricSettings.logGradations","attr:FacetChart.gradationLabelPadding"],seeAlso:[],ref:"group:gradations",deprecated:null,type:"group",description:null,name:"gradations"},"attr:MockDSExportSettings.includeCustomSimpleTypes":{seeAlso:[],ref:"attr:MockDSExportSettings.includeCustomSimpleTypes",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:MockDSExportSettings",valueType:"boolean",description:"Whether to include custom-defined ${isc.DocUtils.linkForRef('class:SimpleType','SimpleTypes')}.",flags:"IR",name:"includeCustomSimpleTypes"},"group:lifecycle":{refs:["attr:TabSet.destroyPanes"],seeAlso:[],ref:"group:lifecycle",deprecated:null,type:"group",description:null,name:"lifecycle"},"method:ImgButton.setAutoFit":{seeAlso:[],ref:"method:ImgButton.setAutoFit",deprecated:null,type:"method",definingClass:"class:ImgButton",params:[{defaultValue:null,optional:false,type:"boolean",description:"New autoFit setting.",name:"autoFit"}],description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",flags:"",name:"setAutoFit"},"attr:Facet.sortFoldersBeforeLeaves":{seeAlso:[],ref:"attr:Facet.sortFoldersBeforeLeaves",defaultValue:"true",deprecated:null,type:"attr",definingClass:"object:Facet",valueType:"Boolean",description:"If ${isc.DocUtils.linkForRef('attr:Facet.separateFolders')} is true, should folders be displayed above or below leaves?\n When set to <code>true</code> folders will appear above leaves unless the data order has\n been reversed by setting ${isc.DocUtils.linkForRef('attr:Facet.showParentsLast')} to <code>true</code>.",flags:"IR",name:"sortFoldersBeforeLeaves"},"attr:AdvancedHiliteEditor.invalidHilitePrompt":{seeAlso:[],defaultValue:"\"Enter at least one rule, a color or icon, and a target field, or press 'Cancel' to abandon changes.\"",type:"attr",definingClass:"class:AdvancedHiliteEditor",groups:["i18nMessages"],deprecated:null,ref:"attr:AdvancedHiliteEditor.invalidHilitePrompt",valueType:"String",description:'The message to show when the user clicks "Save" without entering any criteria.',flags:"IR",name:"invalidHilitePrompt"},"attr:StatefulCanvas.iconHeight":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:StatefulCanvas",groups:["buttonIcon"],deprecated:null,ref:"attr:StatefulCanvas.iconHeight",valueType:"Integer",description:"Height in pixels of the icon image.\n <P>\n If unset, defaults to ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconSize','iconSize')}.",flags:"IR",name:"iconHeight"},"attr:ListGrid.tableRowStyle":{seeAlso:[],ref:"attr:ListGrid.tableRowStyle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"CSSStyleName",description:"The style to apply to &lt;TR&gt; tags in this grid's table.  Useful for applying spacing \n or a custom border between records in the grid.\n <p>\n This is an advanced capability and care should be taken not to use CSS that applies sizes or \n other settings that could cause sizing/rendering issues when used in \n conjunction with certain other features, such as ${isc.DocUtils.linkForRef('attr:ListGrid.virtualScrolling')}.  For example, the \n style should apply <i>box-sizing: border-box;</i> to ensure that settings like border and \n padding don't change the size of row elements.  In some cases, the style will also need \n to apply <i>display: inline-block;</i> for CSS changes to take effect - this is because the \n default display setting for &lt;TR&gt; elements, <i>table-row</i>, has limited styling \n support.",flags:"IRWA",name:"tableRowStyle"},"classMethod:Log.getDefaultLogPriority":{seeAlso:[],ref:"classMethod:Log.getDefaultLogPriority",deprecated:null,type:"classMethod",definingClass:"class:Log",description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.getDefaultLogPriority')} is to call the\n method directly on the Log class.\n",flags:"",returns:{type:"LogPriority",description:"default priority for logging messages on this object."},name:"getDefaultLogPriority"},"attr:FormItem.editProxyConstructor":{seeAlso:[],ref:"attr:FormItem.editProxyConstructor",defaultValue:'"FormItemEditProxy"',deprecated:null,type:"attr",definingClass:"class:FormItem",valueType:"SCClassName",description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",flags:"IR",name:"editProxyConstructor"},"method:CSSEditor.editCancelled":{seeAlso:[],ref:"method:CSSEditor.editCancelled",deprecated:null,type:"method",definingClass:"class:CSSEditor",description:" Notification fired when the cancelButton is clicked.\n",flags:"",name:"editCancelled"},"attr:MetricSettings.filled":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:MetricSettings",groups:["chartType"],ref:"attr:MetricSettings.filled",deprecated:null,setter:["setFilled"],valueType:"boolean",description:"Whether shapes are filled, for example, whether a multi-series line chart appears as a\n stack of filled regions as opposed to just multiple lines.\n <P>\n If unset, fills will be automatically used when there are multiple facets and stacking\n is active (so Line and Radar charts will show stacked regions).  \n <P>\n You can explicitly set filled:false to create multi-facet Line or Radar charts where\n translucent regions overlap, or filled:true to fill in a single-facet Line or Radar\n chart.",flags:"IRW",name:"filled"},"attr:TimeItem.millisecondIncrement":{seeAlso:[],ref:"attr:TimeItem.millisecondIncrement",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"Number",description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondValues','millisecondValues')} is unset, this attribute specifies \n the increment to use when generating entries for the millisecond picker.  For example, \n if this attribute is set to 5, the millisecond picker will contain only every fifth \n value between the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMinValue','millisecondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMaxValue','millisecondMaxValue')}.",flags:"IRW",name:"millisecondIncrement"},"attr:Window.restoreButton":{seeAlso:[],ref:"attr:Window.restoreButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Window",valueType:"AutoChild ImgButton",description:"ImgButton that restores the Window via ${isc.DocUtils.linkForRef('method:Window.restore')}.",flags:"R",name:"restoreButton"},"class:Timeline":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Calendar",classMethods:[],classAttrs:[],attrs:[],ref:"class:Timeline",deprecated:null,treeLocation:["Client Reference/Calendar"],description:"Timeline is a trivial subclass of ${isc.DocUtils.linkForRef('class:Calendar')} that configures the Calendar with settings\n typical for a standalone timeline view: hides the ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')}, \n ${isc.DocUtils.linkForRef('attr:Calendar.weekView','week')} and ${isc.DocUtils.linkForRef('attr:Calendar.monthView','month')} tabs and the \n ${isc.DocUtils.linkForRef('attr:Calendar.controlsBar','controls bar')} by default.\n <P>\n Note that the ${isc.DocUtils.linkForRef('group:loadingOptionalModules','Calendar module')} must be loaded to make \n use of the Timeline class.",methods:[],name:"Timeline"},"method:List.getItems":{seeAlso:[],type:"method",definingClass:"interface:List",returns:{type:"Array",description:"subset of the array, in the same order as itemList"},groups:["access"],deprecated:null,ref:"method:List.getItems",params:[{defaultValue:null,optional:false,type:"List of Number",description:"array of positions",name:"itemList"}],description:" Return the items at a list of specified positions.\n\n",flags:"",name:"getItems"},"attr:ListGridField.linkTextProperty":{seeAlso:[{ref:"type:ListGridFieldType",description:null},{ref:"type:FieldType",description:null},{ref:"attr:ListGridRecord.linkText",description:null},{ref:"attr:ListGridField.linkText",description:null},{ref:"attr:ListGrid.linkTextProperty",description:null}],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["display_values"],deprecated:null,ref:"attr:ListGridField.linkTextProperty",valueType:"String",description:'Name of the property in a ListGridRecord that holds the HTML to display in cells of this\n field if the fieldType is set to "link".',flags:"IRW",name:"linkTextProperty"},"attr:ListGridRecord.embeddedComponent":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridRecord",groups:["appearance"],deprecated:null,ref:"attr:ListGridRecord.embeddedComponent",valueType:"Canvas",description:"A component that should be rendered on top of this record, similar to a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','record component')} but statically defined on the record.\n <p>\n The embedded component will default to covering all fields of the record, but specific fields\n can be specified via ${isc.DocUtils.linkForRef('attr:ListGridRecord.embeddedComponentFields')}.\n <p>\n By default, the embeddedComponent will fill the entire vertical and horizontal space of the\n record (or of the specified fields).  ${isc.DocUtils.linkForRef('attr:ListGridRecord.embeddedComponentPosition')} can be set to control\n exact sizing behavior.\n \n <p>\n When creating a component to use as an embedded component the component will most likely\n end up drawing before the record it is due to be embedded within, therefore it is recommended\n to set ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw','autoDraw')} to false on the embedded component.\n \n <p>\n When a record with an <code>embeddedComponent</code> is eliminated from view by filtering or\n because it is not currently rendered due to ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','incremental rendering')}, the\n ListGrid may ${isc.DocUtils.linkForRef('method:Canvas.hide')} or ${isc.DocUtils.linkForRef('method:Canvas.clear')} it.\n <p>\n If the current dataset is completely replaced (by a call to ${isc.DocUtils.linkForRef('method:ListGrid.setData')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.setDataSource')}, for example), any embedded component is\n ${isc.DocUtils.linkForRef('method:Canvas.deparent','deparented')} (which implies being ${isc.DocUtils.linkForRef('method:Canvas.clear','clear()ed')}).\n <p>\n When a ListGrid is ${isc.DocUtils.linkForRef('method:Canvas.destroy','destroyed')}, it will destroy() all embedded components\n regardless of whether they are currently visible.  Use a call to ${isc.DocUtils.linkForRef('method:ListGrid.setData')} immediately\n before destroying the ListGrid to avoid this effect when unwanted.\n <p>\n For more advanced control over the lifecycle of components displayed over records, including\n deferred creation and pooling, use the ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents','record components')}\n subsystem.",flags:"IR",name:"embeddedComponent"},"method:Array.equals":{seeAlso:[],type:"method",definingClass:"object:Array",returns:{type:"boolean",description:"whether the specified list is equal to this list"},groups:["access"],deprecated:null,ref:"method:Array.equals",params:[{defaultValue:null,optional:false,type:"List",description:"list to check for equality",name:"list"}],description:" Return whether this list is equal to another list.\n <P>\n Two lists are equal only if they have the same length and all contained items are in the same\n order and are also equal.\n\n",flags:"",name:"equals"},"method:DataBoundComponent.getSort":{seeAlso:[],ref:"method:DataBoundComponent.getSort",deprecated:null,type:"method",definingClass:"interface:DataBoundComponent",description:" Return the ${isc.DocUtils.linkForRef('object:SortSpecifier')}s representing the current sort configuration of this\n component.\n",flags:"",returns:{type:"Array of SortSpecifier",description:"sortSpecifiersA copy of the current sort specification for this component"},name:"getSort"},"method:ValuesManager.editRecord":{groups:["dataBoundComponentMethods"],seeAlso:[{ref:"method:DynamicForm.saveData",description:null}],ref:"method:ValuesManager.editRecord",deprecated:null,type:"method",definingClass:"class:ValuesManager",params:[{defaultValue:null,optional:false,type:"Record",description:"the record to be edited as a map of field names to their corresponding values",name:"record"}],description:"\n Edit an existing record.  Updates this editors values to match the values of the record \n passed in, via ${isc.DocUtils.linkForRef('method:ValuesManager.setValues')}.\n <P>\n This method will also call ${isc.DocUtils.linkForRef('method:DynamicForm.setSaveOperationType')} to ensure \n subsequent calls to <code>saveData()</code> will use an <code>update</code> rather than\n an <code>add</code> operation.\n\n",flags:"",name:"editRecord"},"attr:Canvas.maxHeight":{seeAlso:[{ref:"attr:Canvas.dragMaxHeight",description:null}],defaultValue:"10000",type:"attr",definingClass:"class:Canvas",groups:["sizing"],deprecated:null,ref:"attr:Canvas.maxHeight",valueType:"number",description:"Maximum height available to this Canvas.  See ${isc.DocUtils.linkForRef('attr:Canvas.maxWidth')} for details of behavior.",flags:"IRWA",name:"maxHeight"},"method:Button.setIconOrientation":{groups:["buttonIcon"],seeAlso:[],ref:"method:Button.setIconOrientation",deprecated:null,type:"method",definingClass:"class:Button",params:[{defaultValue:null,optional:false,type:"String",description:"The new orientation of the icon relative to the text of the button.",name:"orientation"}],description:" Changes the orientation of the icon relative to the text of the button.\n\n",flags:"",name:"setIconOrientation"},"method:Array.setSort":{seeAlso:[],ref:"method:Array.setSort",deprecated:null,type:"method",definingClass:"object:Array",params:[{defaultValue:null,optional:false,type:"Array of SortSpecifier",description:"the list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s to sort by",name:"sortSpecifiers"}],description:" Sort this Array by a list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s. \n",flags:"",returns:{type:"Array",description:"the array itself"},name:"setSort"},"attr:FormItem.exportFormat":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["exportFormatting"],deprecated:null,ref:"attr:FormItem.exportFormat",valueType:"FormatString",description:"${isc.DocUtils.linkForRef('type:FormatString')} used during exports for numeric or date formatting.  See\n ${isc.DocUtils.linkForRef('attr:DataSourceField.exportFormat')}.",flags:"IR",name:"exportFormat"},"attr:ListGrid.editPendingMarkerStyle":{seeAlso:[{ref:"attr:ListGrid.baseStyle",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["appearance"],deprecated:null,ref:"attr:ListGrid.editPendingMarkerStyle",valueType:"CSSStyleName",description:"The name of a CSS class used to overlay regular cell styles with additional styling when\n a cell has unsaved edits - these styles are in addition to the styling applied by \n ${isc.DocUtils.linkForRef('attr:ListGrid.editPendingCSSText')} or ${isc.DocUtils.linkForRef('attr:ListGrid.editPendingBaseStyle')}.\n <p>\n You can use a custom class that overlays styling of your choosing, or use the default \n <i>pendingMarker</i> class which is present in modern skins and provides a small \n corner-marker in the top-left of unsaved cells.\n <p>\n Once set, this styleName is automatically appended to the style-list for cells with \n unsaved edits.",flags:"IRWA",name:"editPendingMarkerStyle"},"method:SimpleTile.getInnerHTML":{seeAlso:[],ref:"method:SimpleTile.getInnerHTML",deprecated:null,type:"method",definingClass:"class:SimpleTile",description:" The default implementation will call ${isc.DocUtils.linkForRef('method:TileGrid.getTileHTML')}.\n",flags:"",returns:{type:"HTMLString",description:"HTML contents for the tile, as a String"},name:"getInnerHTML"},"attr:ListGrid.removeFieldProperties":{seeAlso:[],ref:"attr:ListGrid.removeFieldProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"ListGridField Properties",description:"Configuration properties for the \"remove field\" displayed when\n ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} is enabled.\n These configuration settings will be overlaid\n on top of the ${isc.DocUtils.linkForRef('attr:ListGrid.removeFieldDefaults')}.",flags:"IR",name:"removeFieldProperties"},"attr:SavedSearches.screenIdField":{seeAlso:[],ref:"attr:SavedSearches.screenIdField",defaultValue:'"screenId"',deprecated:null,type:"attr",definingClass:"class:SavedSearches",valueType:"String",description:"Type: \"string\".  Required because component IDs are not unique if components are loaded as \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadScreen','screens')}, especially ${isc.DocUtils.linkForRef('group:reifyForDevelopers','Reify Screens')}.",flags:"RW",name:"screenIdField"},"attr:CubeGrid.hideEmptyFacetValues":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:CubeGrid",groups:["facetLayout"],deprecated:null,ref:"attr:CubeGrid.hideEmptyFacetValues",valueType:"boolean",description:"This causes the headers for any combination of facetValues for which there are no \n cellRecords to be suppressed.\n <P>\n To use this feature, either:\n <ul>\n <li> all must be provided via ${isc.DocUtils.linkForRef('method:ListGrid.setData','setData()')} before the CubeGrid is first drawn, OR\n <li> all data must be returned by the first DataSource fetch, OR\n <li> ${isc.DocUtils.linkForRef('attr:CubeGrid.hideEmptyAxis')} must be set to either \"row\" or \"column\" so that empty values\n are only automatically hidden for one axis\n </ul>\n This last point is required because there is no way to determine whether a row is empty\n unless data for all columns of the row has been loaded (and vice-versa).  For this\n reason if you set hideEmptyFacetValues but do not set hideEmptyAxis, the default\n behavior of ${isc.DocUtils.linkForRef('class:DataSource','loading only visible data')} is automatically disabled and\n only ${isc.DocUtils.linkForRef('attr:CubeGrid.fixedFacetValues')} will be sent as criteria.",flags:"IR",name:"hideEmptyFacetValues"},"attr:Shuttle.deselectAllButton":{seeAlso:[],ref:"attr:Shuttle.deselectAllButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Shuttle",valueType:"ImgButton AutoChild",description:"ImgButton for deselecting the full set of selected data in the shuttle.",flags:"IR",name:"deselectAllButton"},"attr:ResultTree.sendNullParentInLinkDataCriteria":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:ResultTree",groups:["multiLinkTree"],deprecated:null,ref:"attr:ResultTree.sendNullParentInLinkDataCriteria",valueType:"Boolean",description:"For ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}s only, should we send up the \n ${isc.DocUtils.linkForRef('attr:Tree.parentIdField','parentId')} in fetch criteria if the criteria value is null?  If \n false, we remove the <code>parentId</code> from the criteria when \n ${isc.DocUtils.linkForRef('attr:ResultTree.linkDataSource','fetching link data')}, <b>if</b> the criteria value is \n null (as it will be by default when fetching the direct child nodes of the tree's root).\n <p>\n Ignored for non-multiLink trees.",flags:"IR",name:"sendNullParentInLinkDataCriteria"},"attr:DataSourceField.autoGenerated":{seeAlso:[{ref:"attr:DataSourceField.sequenceName",description:null},{ref:"type:FieldType",description:null},{ref:"type:SequenceMode",description:null}],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["dataType"],ref:"attr:DataSourceField.autoGenerated",deprecated:null,valueType:"boolean",description:"Indicates that values for this field are automatically generated by the database or ORM \n provider.  Setting this flag makes the field behave somewhat like a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.sequenceName','sequence field')}, in that server-side logic does not expect client code\n to provide values for the field on \"add\" operations.  However, it is not entirely the same\n as a sequence:<ul>\n <li>Sequences must be integers, whereas autoGenerated fields can be of any type</li>\n <li>SmartClient Server's DataSource implementations are capable of discovering the value \n     that was generated by the database for sequence fields, which may not be possible \n     with an autoGenerated field.  See the docs for \n     ${isc.DocUtils.linkForRef('attr:DataSourceField.customInsertExpression','customInsertExpression')} for a discussion\n     of this</li>\n </ul>\n Unrelated to the <code>autoGenerated</code> flag, you have a general ability for field \n values to be generated by application code (as opposed to being generated by the database\n or ORM provider).  For example, you can use ${isc.DocUtils.linkForRef('group:dmiOverview','DMI methods')}, \n ${isc.DocUtils.linkForRef('group:serverScript','server scripts')}, or ${isc.DocUtils.linkForRef('group:customQuerying','custom SQL')}.  (Note, \n if you want to have application code generate values for primaryKey fields, you may need to\n use an ${isc.DocUtils.linkForRef('class:OperationBinding','operationBinding')} that specifies \n ${isc.DocUtils.linkForRef('attr:OperationBinding.providesMissingKeys','providesMissingKeys')}).",flags:"IR",serverDS:"only",name:"autoGenerated"},"attr:ResultTree.autoOpen":{seeAlso:[],ref:"attr:ResultTree.autoOpen",defaultValue:'"none"',deprecated:null,type:"attr",definingClass:"class:ResultTree",valueType:"String",description:"Which nodes should be opened automatically - applied whenever \n ${isc.DocUtils.linkForRef('method:Tree.setRoot','setRoot()')} is called, including during initialization and as part of \n a re-fetch caused, for example, by ${isc.DocUtils.linkForRef('method:Tree.duplicate','duplicate()')} or \n ${isc.DocUtils.linkForRef('method:ResultTree.invalidateCache','invalidateCache()')}.\n <P>\n Options are:\n <ul>\n <li>\"none\" - no nodes are opened automatically</li>\n <li>\"root\" - opens the ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode','top-level node')} - in databound \n              trees, this node is always hidden</li>\n <li>\"all\" - when ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','loading data on demand')}, opens the\n             ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode','top-level node')} and all of it's direct\n             descendants - otherwise, opens all loaded nodes </li>\n </ul>",flags:"IRW",name:"autoOpen"},"method:Menu.setItemEnabled":{seeAlso:[],ref:"method:Menu.setItemEnabled",deprecated:null,type:"method",definingClass:"class:Menu",params:[{defaultValue:null,optional:false,type:"MenuItem | int",description:"MenuItem or visible index of the MenuItem",name:"item"},{defaultValue:null,optional:true,type:"boolean",description:"true to enable the menu item, false to disable it.  If not                             passed, true is assumed",name:"newState"}],description:" Enables or disables the menu item according to the value of newState, and redraws\n the menu if necessary. Returns true if there's a change in the enabled state.\n\n",flags:"",returns:{type:"boolean",description:"true if the enabled state was changed"},name:"setItemEnabled"},"attr:Button.selected":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:Button",groups:["state"],ref:"attr:Button.selected",deprecated:null,setter:["setSelected"],valueType:"Boolean",description:"Whether this component is selected.  For some components, selection affects appearance.",flags:"IRW",name:"selected"},"attr:SCStatefulImgConfig.Selected":{seeAlso:[],ref:"attr:SCStatefulImgConfig.Selected",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:SCStatefulImgConfig",valueType:"String",description:"Image to display when the component is ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected','selected')}.\n <P>\n May be specified as \n <ul><li>A ${isc.DocUtils.linkForRef('type:SCImgURL')} indicating the media to load</li>\n     <li>A reference to another entry in this SCStatefulImgConfig via the format \n         <code>\"#state:<i>otherStateName</i>\"</code></li>\n     <li>A modifier to apply to the ${isc.DocUtils.linkForRef('attr:SCStatefulImgConfig._base')} media via the\n         format <code>\"#modifier:<i>modifierString</i>\"</code></li>\n </ul>\n See ${isc.DocUtils.linkForRef('object:SCStatefulImgConfig','SCStatefulImgConfig overview')} for further information.",flags:"IRW",name:"Selected"},"class:SetTitleTask":{seeAlso:[{ref:"method:TabSet.setTabTitle",description:null},{ref:"method:SectionStack.setSectionTitle",description:null},{ref:"method:Window.setTitle",description:null},{ref:"attr:FacetChart.title",description:null},{ref:"method:Label.setContents",description:null},{ref:"method:Button.setTitle",description:null},{ref:"attr:FormItem.title",description:null}],type:"class",staticMethods:[],inheritsFrom:"ComponentTask",classMethods:[],classAttrs:[],attrs:["attr:SetTitleTask.title","attr:SetTitleTask.textFormula","attr:SetTitleTask.targetTabName","attr:SetTitleTask.targetFieldName","attr:SetTitleTask.targetSectionName","attr:SetTitleTask.targetSectionTitle"],ref:"class:SetTitleTask",deprecated:null,treeLocation:["Client Reference/Workflow"],description:"Sets the title of a tab, section, window, label, button, form control or facet chart.\n <P>\n For a label, button, window, or chart the ${isc.DocUtils.linkForRef('attr:ComponentTask.componentId','componentId')}\n specifies everything necessary to identify the target.\n <P>\n For a tab, section or form control more information is needed. The\n ${isc.DocUtils.linkForRef('attr:ComponentTask.componentId','componentId')} identifies the container\n (i.e. TabSet, SectionStack or DynamicForm) and the individual component is specified as:\n <ul>\n <li>Tab - ${isc.DocUtils.linkForRef('attr:SetTitleTask.targetTabName','targetTabName')} references the ${isc.DocUtils.linkForRef('attr:Tab.name')}.</li>\n <li>Section - ${isc.DocUtils.linkForRef('attr:SetTitleTask.targetSectionName','targetSectionName')} for \n               ${isc.DocUtils.linkForRef('attr:SectionStackSection.name')} or ${isc.DocUtils.linkForRef('attr:SetTitleTask.targetSectionTitle','targetSectionTitle')} \n               for ${isc.DocUtils.linkForRef('attr:SectionStackSection.title')}.</li>\n <li>FormItem - ${isc.DocUtils.linkForRef('attr:SetTitleTask.targetFieldName','targetFieldName')} for ${isc.DocUtils.linkForRef('attr:FormItem.name')}.</li>\n </ul>",methods:[],name:"SetTitleTask"},"attr:Canvas.dropTarget":{seeAlso:[{ref:"classMethod:EventHandler.getDragTarget",description:null},{ref:"attr:Canvas.dragTarget",description:null}],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["dragdrop"],deprecated:null,ref:"attr:Canvas.dropTarget",valueType:"Canvas | String",description:'Delegates a different widget that should actually be dropped on if the cursor is over\n this widget when the drop completes.  If you\'re building your own "drop indicator"\n widget, it may need this property set to the main canvas (receiving the drop) to avoid\n itself being considered a drop target (causing the indicator to flicker).',flags:"IRWA",name:"dropTarget"},"attr:TimeItem.hourMinValue":{seeAlso:[],ref:"attr:TimeItem.hourMinValue",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"Number",description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourValues','hourValues')} is unset, this attribute specifies the minimum\n value present in the hour picker.\n <P>Used for specifying a limited set of valid Hour values, or when using the \n TimeItem to record duration, rather than time per-se.  The default is zero in all cases.\n <P> See also ${isc.DocUtils.linkForRef('attr:TimeItem.hourMaxValue','hourMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourIncrement','hourIncrement')}.",flags:"IRW",name:"hourMinValue"},"method:NavigationBar.setShowRightButton":{seeAlso:[],ref:"method:NavigationBar.setShowRightButton",deprecated:null,type:"method",definingClass:"class:NavigationBar",params:[{defaultValue:null,optional:false,type:"Boolean",description:"if <code>false</code>, then the <code>rightButton</code> will be hidden. If unset or <code>true</code> then the <code>rightButton</code> will be shown as\n long as it is a member of the <code>controls</code> array.",name:"show"}],description:" Show or hide the ${isc.DocUtils.linkForRef('attr:NavigationBar.rightButton','rightButton')}. The <code>rightButton</code>\n must be a ${isc.DocUtils.linkForRef('attr:NavigationBar.controls','control')} of this <code>NavigationBar</code> or else it will\n still be hidden.\n",flags:"",name:"setShowRightButton"},"object:NavItem":{seeAlso:[],type:"object",staticMethods:[],inheritsFrom:"TreeNode",classMethods:[],classAttrs:[],attrs:["attr:NavItem.id","attr:NavItem.title","attr:NavItem.icon","attr:NavItem.items","attr:NavItem.isHeader","attr:NavItem.customStyle","attr:NavItem.isSeparator","attr:NavItem.pane","attr:NavItem.enableWhen"],ref:"object:NavItem",deprecated:null,treeLocation:["Client Reference/Layout/NavPanel"],description:"Properties for a navigation item in a ${isc.DocUtils.linkForRef('class:NavPanel')}.",methods:[],name:"NavItem"},"method:FormItemIcon.click":{seeAlso:[],type:"method",definingClass:"object:FormItemIcon",returns:{type:"Boolean",description:"Return false to cancel the event."},groups:["formIcons"],ref:"method:FormItemIcon.click",deprecated:null,params:[{defaultValue:null,optional:false,type:"DynamicForm",description:"The Dynamic Form to which this icon's item belongs.",name:"form"},{defaultValue:null,optional:false,type:"FormItem",description:"The Form Item containing this icon",name:"item"},{defaultValue:null,optional:false,type:"FormItemIcon",description:"A pointer to the form item icon clicked",name:"icon"}],description:" Click handler for this icon.\n <P>\n \n Return false to cancel this event. \n \n \n If this event is not cancelled by the icon-level click handler, it may also\n be handled at the FormItem level via ${isc.DocUtils.linkForRef('method:FormItem.pickerIconClick')} [for the\n picker icon only], and then ${isc.DocUtils.linkForRef('method:FormItem.iconClick')}\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('formIcons')}"],name:"click"},"attr:Label.valign":{seeAlso:[],defaultValue:"Canvas.CENTER",type:"attr",definingClass:"class:Label",groups:["positioning"],deprecated:null,ref:"attr:Label.valign",valueType:"VerticalAlignment",description:"Vertical alignment of label text. See VerticalAlignment type for details.",flags:"IRW",name:"valign"},"attr:PickListMenu.canSaveSearches":{seeAlso:[],ref:"attr:PickListMenu.canSaveSearches",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:PickListMenu",valueType:"boolean",description:"Option to save searches is disabled for PickListMenus",flags:"IRA",name:"canSaveSearches"},"attr:CoTTransition.label":{seeAlso:[],ref:"attr:CoTTransition.label",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:CoTTransition",valueType:"String",description:"Optional UI label override. If omitted, the target's\n   ${isc.DocUtils.linkForRef('attr:CoTTask.description','description')} is used if present, otherwise\n   ${isc.DocUtils.linkForRef('attr:CoTTask.title')}.",flags:"IR",name:"label"},"attr:FormItemIcon.neverDisable":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:FormItemIcon",groups:["formIcons"],deprecated:null,ref:"attr:FormItemIcon.neverDisable",valueType:"boolean",description:"If <code>icon.neverDisable</code> is true, when this form item is disabled, the \n icon will remain enabled. \n Note that disabling the entire form will disable all items, together with their \n icons including those marked as neverDisable - this property only has an effect \n if the form is enabled and a specific item is disabled within it.\n <P>\n If this property is true, the icons will also remain enabled if a form item \n is marked as ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit:false')}. For finer grained control over\n whether icons are enabled for read-only icons see ${isc.DocUtils.linkForRef('attr:FormItem.disableIconsOnReadOnly')}\n and ${isc.DocUtils.linkForRef('attr:FormItemIcon.disableOnReadOnly')}",flags:"IRWA",name:"neverDisable"},"attr:ListGrid.headerMenuButtonSnapOffsetLeft":{seeAlso:[],ref:"attr:ListGrid.headerMenuButtonSnapOffsetLeft",defaultValue:"0",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"Integer",description:"Offset of the right edge of a ${isc.DocUtils.linkForRef('attr:ListGrid.headerMenuButton')} from the right edge of it's \n parent button.",flags:"IRW",name:"headerMenuButtonSnapOffsetLeft"},"attr:SelectItem.showFocused":{seeAlso:[{ref:"attr:FormItem.cellStyle",description:null}],defaultValue:"true, [IRWA]",type:"attr",definingClass:"class:SelectItem",groups:["formItemStyling"],deprecated:null,ref:"attr:SelectItem.showFocused",valueType:"Boolean",description:"When this item receives focus, should it be re-styled to indicate it has focus?\n <P>\n See ${isc.DocUtils.linkForRef('group:formItemStyling')} for more details on formItem styling.",flags:"IRWA",name:"showFocused"},"method:DataSource.createAlias":{seeAlso:[],ref:"method:DataSource.createAlias",deprecated:null,type:"method",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"String",description:"The alias assigned to this DataSource.",name:"alias"}],description:" Assigns an alias to this DataSource\n",flags:"",name:"createAlias"},"method:ImgSectionHeader.titleHover":{groups:["hovers"],seeAlso:[{ref:"attr:ImgSectionHeader.clipTitle",description:null},{ref:"method:ImgSectionHeader.titleClipped",description:null}],ref:"method:ImgSectionHeader.titleHover",deprecated:null,type:"method",definingClass:"class:ImgSectionHeader",description:" Optional stringMethod to fire when the user hovers over this section header and the title is\n clipped. If ${isc.DocUtils.linkForRef('attr:ImgSectionHeader.showClippedTitleOnHover')} is true, the default behavior is to\n show a hover canvas containing the HTML returned by ${isc.DocUtils.linkForRef('method:ImgSectionHeader.titleHoverHTML')}.\n Return false to suppress this default behavior.\n",flags:"",returns:{type:"Boolean",description:"false to suppress the standard hover"},name:"titleHover"},"method:RelativeDateItem.getFiscalCalendar":{seeAlso:[],ref:"method:RelativeDateItem.getFiscalCalendar",deprecated:null,type:"method",definingClass:"class:RelativeDateItem",description:" Returns the ${isc.DocUtils.linkForRef('object:FiscalCalendar')} object that will be used by this item's DateChooser.\n\n",flags:"",returns:{type:"FiscalCalendar",description:"the fiscal calendar for this chooser, if set, or the global            one otherwise"},name:"getFiscalCalendar"},"attr:Shuttle.sourceGridTitle":{seeAlso:[],defaultValue:'"Unselected Values"',type:"attr",definingClass:"class:Shuttle",groups:["i18nMessages"],deprecated:null,ref:"attr:Shuttle.sourceGridTitle",valueType:"String",description:"Title for the source grid, shown as a ${isc.DocUtils.linkForRef('attr:Canvas.groupTitle')}",flags:"IR",name:"sourceGridTitle"},"attr:TileLayout.tileSize":{seeAlso:[],defaultValue:"100",type:"attr",definingClass:"class:TileLayout",groups:["sizing"],ref:"attr:TileLayout.tileSize",deprecated:null,setter:["setTileSize"],valueType:"int",description:"Size of each tile in pixels.  Depending on the ${isc.DocUtils.linkForRef('type:TileLayoutPolicy')}, <code>tileSize</code>\n may be taken as a maximum, minimum or exact size of tiles, or may be irrelevant.\n <P>\n Width and height may be separately set via ${isc.DocUtils.linkForRef('attr:TileLayout.tileHeight')} and ${isc.DocUtils.linkForRef('attr:TileLayout.tileWidth')}.",flags:"IR",name:"tileSize"},"classMethod:Messaging.subscribe":{groups:["messaging"],seeAlso:[],ref:"classMethod:Messaging.subscribe",deprecated:null,type:"classMethod",definingClass:"class:Messaging",params:[{defaultValue:null,optional:false,type:"String",description:null,name:"channel"},{defaultValue:null,optional:false,type:"MessagingCallback",description:"callback fired whenever data is sent to this channel",name:"callback"},{defaultValue:null,optional:false,type:"Callback",description:"callback fired when the subscription is established",name:"subscribeCallback"},{defaultValue:null,optional:true,type:"String",description:"JMS selector used with Queues to filter the messages that arrive to the channel (optional).",name:"selector"}],description:" Subscribes the client to the messaging channel identified by channel.\n <p>\n When the server or another connected browser sends a message on this channel, the callback \n will be invoked with a single 'data' parameter containing the data that was just sent to the\n channel.\n <p>\n Calling subscribe() again for a channel you are already subscribed to will result in the new\n callback replacing the old, and will cause the server connection to be re-established.\n\n",flags:"",name:"subscribe"},"method:Canvas.getContents":{seeAlso:[],ref:"method:Canvas.getContents",deprecated:null,type:"method",definingClass:"class:Canvas",description:"      Returns the contents of a Canvas. The contents are an HTML string.\n",flags:"",returns:{type:"HTMLString",description:"contents of this Canvas"},name:"getContents"},"method:Canvas.shouldDragScroll":{groups:["events","dragdrop"],seeAlso:[],ref:"method:Canvas.shouldDragScroll",deprecated:null,type:"method",definingClass:"class:Canvas",description:" If this widget is showing scrollbars, and a user drags close to the edge of the viewport,\n should we scroll the viewport in the appropriate direction?\n Returns this.canDragScroll if there are scrollbars, else false.\n",flags:"A",name:"shouldDragScroll"},"method:Canvas.moveTo":{seeAlso:[],type:"method",definingClass:"class:Canvas",returns:{type:"boolean",description:"whether the component actually moved"},groups:["positioning"],ref:"method:Canvas.moveTo",deprecated:null,params:[{defaultValue:null,optional:true,type:"number | Object",description:"x-coordinate to move to in LOCAL coordinates                                             or Object with left and top properties.",name:"left"},{defaultValue:null,optional:true,type:"number",description:"y-coordinate to move to in LOCAL coordinates",name:"top"}],description:" Moves the widget so that its top-left corner is at the specified coordinates.\n <P>\n This method will also accept a single parameter as an object array with left and top given\n as properties.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('move')}"],name:"moveTo"},"attr:TabBar.moreTab":{seeAlso:[],ref:"attr:TabBar.moreTab",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TabBar",valueType:"Tab",description:"Tab to show as the \"more\" tab when ${isc.DocUtils.linkForRef('attr:TabBar.showMoreTab')} is enabled and the number\n of tabs to show exceeds ${isc.DocUtils.linkForRef('attr:TabBar.moreTabCount')}.",flags:"IR",name:"moreTab"},"attr:DataSource.suppressAutoMappings":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:DataSource",groups:["serverRestConnector"],ref:"attr:DataSource.suppressAutoMappings",deprecated:null,valueType:"Boolean",description:"Applies to RestConnector dataSources (${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"rest\") only,\n and is overridable per operationBinding (see ${isc.DocUtils.linkForRef('attr:OperationBinding.requestTemplate')}).\n <p>\n By default, if you have a ${isc.DocUtils.linkForRef('attr:DataSource.requestFormat','requestFormat')} of \"params\", \n <code>RestConnector</code> will add your values or criteria as standard HTTP parameters to \n the the URL it generates for hitting the target REST server - this is described in more \n detail in the ${isc.DocUtils.linkForRef('type:RESTRequestFormat')} documentation.\n <p>\n With a <code>requestFormat</code> of \"json\", <code>RestConnector</code> will generate a \n block of JSON from your criteria or values, again as described in the \n <code>RESTRequestFormat</code> docs\n <p>\n You can switch off both of these behaviors by setting this property true",flags:"IR",serverDS:"only",name:"suppressAutoMappings"},"class:SimpleType":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:["classMethod:SimpleType.create","classMethod:SimpleType.getType","classMethod:SimpleType.registerSummaryFunction","classMethod:SimpleType.setDefaultSummaryFunction","classMethod:SimpleType.getDefaultSummaryFunction","classMethod:SimpleType.applySummaryFunction"],classAttrs:[],attrs:["attr:SimpleType.name","attr:SimpleType.inheritsFrom","attr:SimpleType.validators","attr:SimpleType.valueMap","attr:SimpleType.canEdit","attr:SimpleType.canFilter","attr:SimpleType.editorType","attr:SimpleType.readOnlyDisplay","attr:SimpleType.readOnlyEditorType","attr:SimpleType.filterEditorType","attr:SimpleType.fieldProperties","attr:SimpleType.format","attr:SimpleType.exportFormat","attr:SimpleType.validOperators","attr:SimpleType.defaultOperator","attr:SimpleType.groupingModes","attr:SimpleType.defaultGroupingMode"],ref:"class:SimpleType",deprecated:null,treeLocation:["Client Reference/Data Binding"],description:"An atomic type such as a string or number, that is generally stored, displayed and\n manipulated as a single value.\n <P>\n SimpleTypes can be ${isc.DocUtils.linkForRef('classMethod:SimpleType.create','created')} at any time, and subsequently referred\n to as a ${isc.DocUtils.linkForRef('attr:Field.type','field type')} in ${isc.DocUtils.linkForRef('class:DataSource','DataSources')} and\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}.  This allows you to define\n ${isc.DocUtils.linkForRef('attr:SimpleType.validators','validation')}, ${isc.DocUtils.linkForRef('method:SimpleType.normalDisplayFormatter','formatting')}\n and ${isc.DocUtils.linkForRef('attr:SimpleType.editorType','editing')} behaviors for a type to be reused across all\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}.\n <P>\n The SimpleType class also allows data to be stored in some opaque format but treated as\n simple atomic values as far as SmartClient components are concerned by implementing\n ${isc.DocUtils.linkForRef('method:SimpleType.getAtomicValue')} and ${isc.DocUtils.linkForRef('method:SimpleType.updateAtomicValue')} methods.\n For example, if some record has a field value set to a javascript object with the\n following properties:\n <pre>\n { stringValue:\"A String\", length: 9 }\n </pre>\n this value could be treated as a simple string by defining a SimpleType with \n ${isc.DocUtils.linkForRef('attr:SimpleType.inheritsFrom')} set to <code>\"text\"</code> and a custom \n <code>getAtomicValue()</code> method that simply extracted the <i>\"stringValue\"</i>\n attribute from the data object. DataBoundComponents would then display\n the string value, and use it for sorting and other standard databinding features.\n <P>\n Note that the term \"simpleType\" is used in the same sense as in\n <a href='http://www.w3.org/TR/xmlschema-0/' target='_blank'>XML Schema</a>, and\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')} will create new SimpleType definitions.\n <P>\n When using the SmartClient Server, SimpleTypes can be defined server-side, and should\n be defined server-side if validators are going to be declared so that the server will\n enforce validation. To define server-side SimpleTypes using Component XML you should create\n file {typeName}.type.xml in the following format:\n <pre>\n   &lt;SimpleType name=\"{typeName}\" inheritsFrom=\"{otherSimpleType}\" \n                  editorType=\"{FormItemClassName}\"&gt;\n     &lt;validators&gt;\n       &lt;!-- validator definition just like DataSourceField --&gt;\n     &lt;/validators&gt;\n   &lt;/SimpleType&gt;\n </pre>\n .. and place this file alongside your DataSource files (.ds.xml) files - in any of folders\n listed in <code>project.datasources</code> property in ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}.\n <P>\n SimpleTypes can be loaded via DataSourceLoader or ${isc.DocUtils.linkForRef('group:loadDSTag','loadDS JSP tags')} and\n should be loaded <b>before</b> the definitions of any DataSources that use them (so\n generally put all SimpleType definitions first).\n <P>\n Define validators in the server-side type definition, for example:\n <pre>\n   &lt;SimpleType name=\"countryCodeType\" inheritsFrom=\"text\"&gt;\n     &lt;validators&gt;\n       &lt;validator type=\"lengthRange\" min=\"2\" max=\"2\"\n         errorMessage=\"Length of country code should be equal to 2.\" /&gt;\n       &lt;validator type=\"regexp\" expression=\"[A-Z][A-Z]\"\n         errorMessage=\"CountryCode should have only uppercase letters.\" /&gt;\n     &lt;/validators&gt;\n   &lt;/SimpleType&gt;\n </pre>\n <P>\n For client-side formatters, add these to the type definition after loading it from the\n server, for example:\n \n   <pre>\n     isc.SimpleType.getType(\"independenceDateType\").addProperties({\n         normalDisplayFormatter : function (value) {\n             if (value == null) return \"\";\n             return \"&lt;i&gt;\" + (value.getYear() + 1900) + \"&lt;/i&gt;\";\n         }\n     });\n   </pre>\n \n \n Note that formatters must be added to the SimpleType definition <b>before</b> any\n DataBoundComponent binds to a DataSource that uses the SimpleType.\n <p>\n An example is ${isc.DocUtils.linkForExampleId('formsCustomSimpleType', 'here')}.\n ",methods:["method:SimpleType.getAtomicValue","method:SimpleType.updateAtomicValue","method:SimpleType.compareValues","method:SimpleType.shortDisplayFormatter","method:SimpleType.normalDisplayFormatter","method:SimpleType.editFormatter","method:SimpleType.parseInput","method:SimpleType.getGroupingModes","method:SimpleType.getGroupValue","method:SimpleType.getGroupTitle"],serverDS:"allowed",examples:["${isc.DocUtils.linkForExampleId('extCustomSimpleType')}"],name:"SimpleType"},"method:DataBoundComponent.findAll":{seeAlso:[],ref:"method:DataBoundComponent.findAll",deprecated:null,type:"method",definingClass:"interface:DataBoundComponent",params:[{defaultValue:null,optional:false,type:"AdvancedCriteria",description:"AdvancedCriteria to use with",name:"advancedCriteria"}],description:" This API is equivalent to ${isc.DocUtils.linkForRef('method:List.findAll')} but searches for a matching record among already-loaded data only.  \n Use ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData')} to load data from the server.\n",flags:"",returns:{type:"Array",description:"all matching Objects or null if none found"},name:"findAll"},"attr:ListGrid.originBaseStyle":{seeAlso:[],ref:"attr:ListGrid.originBaseStyle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"CSSStyleName",description:"Name of a CSS Style to use as the ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} for a cell that\n is currently a selection origin for shifted incremental cell selection.\n Only has an effect if ${isc.DocUtils.linkForRef('attr:ListGrid.canSelectCells')} is true.\n <P>",flags:"IRW",name:"originBaseStyle"},"type:DateInputFormat":{seeAlso:[],ref:"type:DateInputFormat",deprecated:null,type:"type",description:'3 character string containing the <code>"M"</code>, <code>"D"</code> and <code>"Y"</code>\n  characters to indicate the format of strings being parsed into Date instances via\n  <code>DateUtil.parseInput()</code>.\n  <P>\n  As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999\n \n  <P>\n  Note: In addition to these standard formats, a custom date string parser function may be\n  passed directly to ${isc.DocUtils.linkForRef(\'classMethod:DateUtil.setInputFormat\')} or passed into \n ${isc.DocUtils.linkForRef(\'classMethod:DateUtil.parseInput\')} as the inputFormat parameter.\n ',name:"DateInputFormat",baseType:"String"},"object:RelativeDate":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:RelativeDate.value","attr:RelativeDate.rangePosition"],ref:"object:RelativeDate",deprecated:null,treeLocation:["Client Reference/System"],description:"An object representing a relative date, useful for representing date ranges etc in criteria.\n RelativeDate objects may be created directly by SmartClient components such as the\n ${isc.DocUtils.linkForRef('class:RelativeDateItem')}.\n <P>\n RelativeDate objects will have <code>\"_constructor\"</code> set to <code>\"RelativeDate\"</code>\n and must have a specified ${isc.DocUtils.linkForRef('attr:RelativeDate.value')}. Any other attributes are optional.",methods:[],name:"RelativeDate"},"attr:Canvas.resizeBarTarget":{seeAlso:[{ref:"attr:Canvas.showResizeBar",description:null}],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["layoutMember"],deprecated:null,ref:"attr:Canvas.resizeBarTarget",valueType:"String",description:'When this Canvas is included as a member in a Layout, and ${isc.DocUtils.linkForRef(\'attr:Canvas.showResizeBar\')} is set to\n <code>true</code> so that a resizeBar is created, <code>resizeBarTarget:"next"</code> can be\n set to indicate that the resizeBar should resize the next member of the layout rather than\n this one.  For resizeBars that support hiding their target member when clicked on, \n <code>resizeBarTarget:"next"</code> also means that the next member will be the one hidden.\n <P>\n This is typically used to create a 3-way split pane, where left and right-hand sections can\n be resized or hidden to allow a center section to expand.\n <P>\n <b>NOTE:</b> as with any Layout, to ensure all available space is used, one or more members\n must maintain a flexible size (eg 75%, or *).  In a two pane Layout with a normal resize\n bar, to fill all space after a user resizes, the member on the <b>right</b> should have\n flexible size.  With resizeBarTarget:"next", the member on the <b>left</b> should have\n flexible size.',flags:"IR",name:"resizeBarTarget"},"attr:SavedSearchForm.savedSearchItem":{seeAlso:[],ref:"attr:SavedSearchForm.savedSearchItem",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SavedSearchForm",valueType:"SavedSearchItem AutoChild",description:"Automatically generated ${isc.DocUtils.linkForRef('class:SavedSearchItem')} for this form.\n <P>\n This may be customized using the ${isc.DocUtils.linkForRef('group:autoChildUsage','autoChild subsystem')}.",flags:"IR",name:"savedSearchItem"},"method:DoubleItem.getValueAsDouble":{seeAlso:[{ref:"method:FormItem.getValue",description:null}],ref:"method:DoubleItem.getValueAsDouble",deprecated:null,type:"method",definingClass:"class:DoubleItem",description:" Return the value tracked by this form item as a Double.  If the value cannot\n be parsed to a valid double, null will be returned.\n\n",flags:"",returns:{type:"Double",description:"the value of this element"},name:"getValueAsDouble"},"attr:MultiFileItem.editButton":{seeAlso:[],ref:"attr:MultiFileItem.editButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:MultiFileItem",valueType:"AutoChild StatefulCanvas",description:"Button for launching a picker to add new files for upload.  Supports the properties of a\n ${isc.DocUtils.linkForRef('object:FormItemIcon')}.",flags:"IR",name:"editButton"},"attr:Point.x":{seeAlso:[],ref:"attr:Point.x",defaultValue:"0",deprecated:null,type:"attr",definingClass:"object:Point",valueType:"Coordinate",description:"The x coordinate of this point.",flags:"IR",name:"x"},"method:DynamicForm.getField":{seeAlso:[{ref:"method:DynamicForm.getItem",description:null}],type:"method",definingClass:"class:DynamicForm",returns:{type:"FormItem",description:"FormItem object or null if not found"},groups:["items"],deprecated:null,ref:"method:DynamicForm.getField",params:[{defaultValue:null,optional:false,type:"FieldName",description:"name of the item you're looking for",name:"itemName"}],description:" Synonym for dynamicForm.getItem()\n\n",flags:"",name:"getField"},"attr:TimeItem.secondIncrement":{seeAlso:[],ref:"attr:TimeItem.secondIncrement",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"Number",description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','secondValues')} is unset, this attribute specifies the increment\n to use when generating entries for the second picker.  For example, if this attribute is\n set to 5, the second picker will contain only every fifth value between the \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')}.",flags:"IRW",name:"secondIncrement"},"method:Date.getShortDayName":{seeAlso:[],type:"method",definingClass:"object:Date",returns:{type:"String",description:"Abbreviated day name"},groups:["dateFormatting"],deprecated:null,ref:"method:Date.getShortDayName",params:[{defaultValue:null,optional:false,type:"int",description:"Number of characters to return (Defaults to 3, can't be                                  longer than 3)",name:"length"}],description:" Return the abbreviated (up to 3 chars) day of week name for this date (Mon, Tue, etc).\n To modify the value returned by this method, set ${isc.DocUtils.linkForRef('classAttr:DateUtil.shortDayNames')}\n\n",flags:"",name:"getShortDayName"},"attr:CoTProcess.promptModeMinimal":{seeAlso:[],defaultValue:"{...}",type:"attr",definingClass:"class:CoTProcess",groups:["CoTPartialPrompt"],deprecated:null,ref:"attr:CoTProcess.promptModeMinimal",valueType:"PartialPromptConfig",description:'Partial prompt mode producing the smallest useful prompt for quick inspection.\n <P>\n Keeps only goal and taskPrompt; omits everything else including large state variables.\n Best for: "Show me just the essentials" or "Quick overview of prompt structure"',flags:"IR",name:"promptModeMinimal"},"attr:SavedSearchItem.copySearchField":{seeAlso:[],ref:"attr:SavedSearchItem.copySearchField",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SavedSearchItem",valueType:"AutoChild ListGridField",description:'ListGridField shown in the pickList to allow users to copy existing searches.  The field is type "icon"\n and displays the skin\'s standard "copy" icon.',flags:"IR",name:"copySearchField"},"method:ColumnTree.selectRecords":{groups:["selection"],seeAlso:[],ref:"method:ColumnTree.selectRecords",deprecated:null,type:"method",definingClass:"class:ColumnTree",params:[{defaultValue:null,optional:false,type:"Array of Record | number",description:"records (or row numbers) to select",name:"records"},{defaultValue:null,optional:true,type:"boolean",description:"new selection state (if null, defaults to true)",name:"newState"},{defaultValue:null,optional:true,type:"Array of Integer | Integer",description:"row numbers to select.  Required for                         ${isc.DocUtils.linkForRef('attr:Tree.multiLinkTree','multi-link trees')} unless row numbers are\n                         passed in the \"records\" param.  If passed, the rowNums array should\n                         correspond to the records array (ie, rowNums[0] refers to the same\n                         object as records[0])",name:"rowNums"},{defaultValue:null,optional:true,type:"Integer",description:"Column number",name:"colNum"}],description:"\n Select/deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n\n",flags:"",name:"selectRecords"},"classMethod:Tour.getTour":{seeAlso:[],ref:"classMethod:Tour.getTour",deprecated:null,type:"classMethod",definingClass:"class:Tour",params:[{defaultValue:null,optional:false,type:"Identifier",description:"tour ID to retrieve",name:"tourId"}],description:" Get a Tour instance by it's ID.\n",flags:"",returns:{type:"Tour",description:"the tour, or null if not defined"},name:"getTour"},"attr:DetailViewer.hiliteIconRightPadding":{seeAlso:[],defaultValue:"2",type:"attr",definingClass:"class:DetailViewer",groups:["hiliting"],deprecated:null,ref:"attr:DetailViewer.hiliteIconRightPadding",valueType:"number",description:"How much padding should there be on the right of ${isc.DocUtils.linkForRef('attr:DetailViewer.hiliteIcons','hilite icons')} by default?\n Can be overridden at the field level",flags:"IRW",name:"hiliteIconRightPadding"},"method:ColorPicker.getRed":{seeAlso:[{ref:"method:ColorPicker.setRed",description:null}],ref:"method:ColorPicker.getRed",deprecated:null,type:"method",definingClass:"class:ColorPicker",description:" Returns the Red element of the currently-selected color, as an integer from 0-255\n",flags:"",returns:{type:"int",description:"red color component"},name:"getRed"},"classMethod:DMI.call":{seeAlso:[],ref:"classMethod:DMI.call",deprecated:null,type:"classMethod",definingClass:"class:DMI",params:[{defaultValue:null,optional:false,type:"String | Object",description:"the appID (.app.xml file to look in) or comprehensive request                          object as documented above.",name:"appID"},{defaultValue:null,optional:false,type:"String",description:"${isc.DocUtils.linkForRef('attr:ServerObject.className')} or ${isc.DocUtils.linkForRef('attr:ServerObject.ID')}",name:"className"},{defaultValue:null,optional:false,type:"String",description:"the name of the method to call on the serverObject",name:"methodName"},{defaultValue:null,optional:true,type:"Any",description:"The next N-1 params specify arguments to the server-side method.",name:"args"},{defaultValue:null,optional:true,type:"RPCCallback",description:"The callback of the response.  If you do not want a callback, you                          must specify a <code>null</code> value for this parameter when\n                          using the first signature (documented above).",name:"callback"}],description:"\n Calls a server-side DMI method.  At a minimum, you need to specify the appID \n (${isc.DocUtils.linkForRef('group:applicationDeclaration','.app.xml file')}), ${isc.DocUtils.linkForRef('attr:ServerObject.className')}\n or ${isc.DocUtils.linkForRef('attr:ServerObject.ID')} and methodName to call.\n Arguments and callback are optional.  There are two ways to invoke this method:\n <pre>\n DMI.call(appID, className, methodName, \n          arg1, arg2 ...argN, callback);\n </pre>\n or:\n <pre>\n DMI.call({\n     appID: appID,\n     className: className,\n     methodName: methodName,\n     arguments: [arg1, arg2, ...argN], //optional\n     callback: callback, //optional\n     requestParams: requestProps // optional\n });\n </pre>\n If you use the first signature, you must either specify a callback or if you don't want a\n callback, pass a <code>null</code> as the last argument.  The second signature allows you to\n specify requestParams that are applied to the ${isc.DocUtils.linkForRef('object:RPCRequest')} generated by this DMI call.\n This allows you to override some defaults - for example to suppress the \"Contacting Server\"\n prompt, change it's text; change the timeout or set any other property settable on\n ${isc.DocUtils.linkForRef('object:RPCRequest')}.\n <p>\n Arguments to be passed to the server method may be specified.\n If present, each argument will be serialized into JSON, \n sent to the server and translated to an equivalent Java object to be passed into the\n method. The translation follows the same rules as for data passed to the server as \n part of a standard ${isc.DocUtils.linkForRef('attr:RPCRequest.data','RPCRequest')}. <br>\n For example if a server side method has the signature\n <pre>\n someMethod(String title, Map overrides);\n </pre>\n a DMI call to that method would could pass in a standard String and JavaScript object -\n for example:\n <pre>\n isc.DMI.call({\n     appID: \"someApp\",\n     className: \"com.smartclient.demo.MyClass\",\n     methodName: \"someMethod\",\n     arguments: [\"Title String\", {field1:\"Value 1\", field2:\"Value 2\"}]\n });\n </pre>\n <p>\n Note that you can use the ${isc.DocUtils.linkForRef('group:loadDMIStubsTag')} tag to bind all methods of\n <code>ServerObjects</code> defined in a given .app.xml file and call methods on them\n directly.\n\n",flags:"",returns:{type:"RPCRequest",description:"the RPCRequest that was sent to the server."},name:"call"},"attr:ListGrid.savedSearchStoredState":{seeAlso:[{ref:"class:SavedSearchItem",description:null}],ref:"attr:ListGrid.savedSearchStoredState",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"SavedSearchStoredState",description:'Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of the component.',flags:"IR",name:"savedSearchStoredState"},"method:DrawSector.setCenterPoint":{seeAlso:[],ref:"method:DrawSector.setCenterPoint",deprecated:null,type:"method",definingClass:"class:DrawSector",params:[{defaultValue:null,optional:false,type:"Coordinate",description:"X coordinate of the center point (in the global coordinate system).",name:"left"},{defaultValue:null,optional:false,type:"Coordinate",description:"Y coordinate of the center point (in the global coordinate system.",name:"top"}],description:" Change the center point for this sector.\n",flags:"",name:"setCenterPoint"},"method:ProcessElement.updateGlobalIDReferences":{seeAlso:[{ref:"method:ProcessElement.updateGlobalIDInValueProperty",description:null},{ref:"method:ProcessElement.updateGlobalIDInValues",description:null},{ref:"method:ProcessElement.updateGlobalIDInCriteria",description:null}],ref:"method:ProcessElement.updateGlobalIDReferences",deprecated:null,type:"method",definingClass:"class:ProcessElement",params:[{defaultValue:null,optional:false,type:"Identifier",description:"the ID being renamed",name:"oldId"},{defaultValue:null,optional:false,type:"Identifier",description:"the new ID to be assigned",name:"newId"}],description:" Updates references to a global ID within the properties of this process element\n (i.e. rename). This method is not called as part of workflow execution but is used\n by ${isc.DocUtils.linkForRef('class:Reify')} to keep workflow event handlers in sync with ID changes within the\n screen.\n <p>\n Each processElement or Task that has properties that save global IDs (like a\n component ID or criteria referencing ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope','ruleContext')}) must \n be able to update its references on demand by overriding this method or defer to its\n superclass.\n <p>\n There are a number of helper methods to make this easier listed below.\n\n",flags:"",returns:{type:"Boolean",description:"true if any references were updated; false otherwise"},name:"updateGlobalIDReferences"},"method:DateItem.getEnteredValue":{seeAlso:[],ref:"method:DateItem.getEnteredValue",deprecated:null,type:"method",definingClass:"class:DateItem",description:" Returns the raw text value typed into this items text field if ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} \n is true (otherwise returns the result of this.getValue()).\n",flags:"",returns:{type:"String",description:"value the user entered"},name:"getEnteredValue"},"attr:DataSourceField.canSortClientOnly":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"object:DataSourceField",deprecated:null,ref:"attr:DataSourceField.canSortClientOnly",valueType:"boolean",description:"When true, this field can only be used for sorting if the data is entirely client-side.",flags:"IRW",serverDS:"allowed",name:"canSortClientOnly"},"attr:ListGrid.fieldPickerShowSampleValues":{seeAlso:[],ref:"attr:ListGrid.fieldPickerShowSampleValues",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"Boolean",description:"When set to false, sample values of the FieldPicker are never shown. This property applies \n to the entire FieldPicker.",flags:"IR",name:"fieldPickerShowSampleValues"},"class:FieldPicker":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"VLayout",classMethods:[],classAttrs:[],attrs:["attr:FieldPicker.dataBoundComponent","attr:FieldPicker.dataSource","attr:FieldPicker.sampleRecord","attr:FieldPicker.showHilitesButton","attr:FieldPicker.showFieldOrderButtons","attr:FieldPicker.hilitesText","attr:FieldPicker.availableFieldsTitle","attr:FieldPicker.currentFieldsTitle","attr:FieldPicker.addCustomFieldsButtonTitle","attr:FieldPicker.availableTitleTitle","attr:FieldPicker.currentTitleTitle","attr:FieldPicker.sampleValueTitle","attr:FieldPicker.canFilterSampleValue","attr:FieldPicker.confirmText","attr:FieldPicker.removeText","attr:FieldPicker.instructions","attr:FieldPicker.instructionLabel","attr:FieldPicker.saveAndExitButtonTitle","attr:FieldPicker.cancelButtonTitle","attr:FieldPicker.removeItemTitle","attr:FieldPicker.emptyTitleHint","attr:FieldPicker.availableFieldsHeaderControls","attr:FieldPicker.availableFieldsGrid","attr:FieldPicker.buttonLayout","attr:FieldPicker.saveAndExitButton","attr:FieldPicker.cancelChangesButton","attr:FieldPicker.currentFieldsGrid"],ref:"class:FieldPicker",deprecated:null,treeLocation:["Client Reference/Data Binding"],description:"FieldPicker provides a configuration dialog that displays, side-by-side, the available and\n currently-displayed fields of a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}. It allows for easy customization \n of the order in which the fields of a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} are displayed, and of which\n are visible.  If so configured, it also allows for convenient launching of the HiliteEditor,\n FormulaBuilder, and SummaryBuilder.  A FieldPicker instance runs in its own window, \n a ${isc.DocUtils.linkForRef('class:FieldPickerWindow')}",methods:["method:FieldPicker.callback","method:FieldPicker.setAvailableFields"],name:"FieldPicker"},"attr:ColumnTree.fields":{seeAlso:[{ref:"object:ListGridField",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ColumnTree",groups:["databinding"],deprecated:null,ref:"attr:ColumnTree.fields",valueType:"Array of ListGridField",description:"An array of field objects, specifying the order, layout, dynamic calculation, and\n sorting behavior of each field in each column in the columnTree object. In ColumnTrees, \n the fields array specifies sub-columns within each main column. \n Each field in the fields array is a ListGridField object.\n <p>\n If ${isc.DocUtils.linkForRef('attr:ColumnTree.dataSource')} is also set, this value acts as a set of overrides as\n explained in ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}.",flags:"IRW",name:"fields"},"attr:Window.maximizeButton":{seeAlso:[],ref:"attr:Window.maximizeButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Window",valueType:"AutoChild ImgButton",description:"Button that will make this Window fill the browser via ${isc.DocUtils.linkForRef('method:Window.maximize')}.",flags:"R",name:"maximizeButton"},"attr:Canvas.editNode":{seeAlso:[],ref:"attr:Canvas.editNode",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Canvas",valueType:"EditNode",description:"The component's ${isc.DocUtils.linkForRef('object:EditNode')} for a component that has been created by a\n ${isc.DocUtils.linkForRef('interface:Palette')} from a ${isc.DocUtils.linkForRef('object:PaletteNode')}.",flags:"R",name:"editNode"},"attr:OperationBinding.headers":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",groups:["serverRestConnector"],ref:"attr:OperationBinding.headers",deprecated:null,valueType:"String",description:"Applies to RestConnector dataSources (${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"rest\") only.\n This is an operationBinding-level override of ${isc.DocUtils.linkForRef('attr:DataSource.headers')} - see \n that property's documentation for details",flags:"IR",serverDS:"only",name:"headers"},"attr:RibbonButton.menuAlign":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:RibbonButton",groups:["menu"],deprecated:null,ref:"attr:RibbonButton.menuAlign",valueType:"Alignment",description:"The horizontal alignment of this button's menu, in relation to the button.  When unset,\n default behavior is to align the right edges of button and menu if the page is in RTL \n mode, and the left edges otherwise.",flags:"IR",name:"menuAlign"},"method:DrawLinePath.getCenter":{seeAlso:[],ref:"method:DrawLinePath.getCenter",deprecated:null,type:"method",definingClass:"class:DrawLinePath",description:" Get the center point of the line path.\n",flags:"",returns:{type:"Point",description:"the center point"},name:"getCenter"},"method:ListGrid.showFilterWindow":{seeAlso:[],ref:"method:ListGrid.showFilterWindow",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Shows the dialog for ${isc.DocUtils.linkForRef('attr:ListGrid.filterWindowCriteria')} allowing end-users to edit\n the advanced filter. This method can be called directly but it is also used to show the\n dialog when ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterWindow')} is enabled and the user chooses the\n ${isc.DocUtils.linkForRef('attr:ListGrid.advancedFilteringText','\"Advanced Filtering\"')} menu option.\n <p>\n <b>Note:</b> this feature requires\n <a href='https://www.smartclient.com/product/' target='_blank'>SmartClient Pro</a> or better.\n\n",flags:"",name:"showFilterWindow"},"attr:ListGrid.fullRowRangeDisplayValue":{seeAlso:[],defaultValue:'"Showing ${rowRange} of ${rowCount} rows"',type:"attr",definingClass:"class:ListGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:ListGrid.fullRowRangeDisplayValue",valueType:"String",description:"Dynamic String specifying the format for the \n ${isc.DocUtils.linkForRef('method:ListGrid.getRowRangeDisplayValue','row range summary value')} when \n ${isc.DocUtils.linkForRef('type:RowRangeDisplayStyle')} is set to <code>\"full\"</code>.\n <P>\n The following variables are available for evaluation within this string:\n <ul><li><code>rowRange</code>: the ${isc.DocUtils.linkForRef('method:ListGrid.getFormattedRowRange','formatted row range')}</li>\n     <li><code>rowCount</code>: the ${isc.DocUtils.linkForRef('method:ListGrid.getFormattedRowCount','formatted row count')}</li></ul>",flags:"IRW",name:"fullRowRangeDisplayValue"},"attr:OperationBinding.recordName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",groups:["clientDataIntegration"],ref:"attr:OperationBinding.recordName",deprecated:null,valueType:"String",description:"For an XML DataSource, tagName of the elements to be used as records.\n <p>\n This is a simple alternative to ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath')} when the elements to be used as\n records all share a tagName.\n <p>\n When a DataSource has a WebService, <code>recordName</code> can also be set to the name\n of any <code>complexType</code> declared within the WebService's WSDL file.",flags:"IR",serverDS:"allowed",name:"recordName"},"attr:SectionStack.canCollapseAll":{seeAlso:[],ref:"attr:SectionStack.canCollapseAll",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:SectionStack",valueType:"Boolean",description:"In ${isc.DocUtils.linkForRef('attr:SectionStack.visibilityMode','visibilityMode')}\n \"mutex\",\n whether to allow the last remaining expanded section to be collapsed.  If false, collapsing the\n last open section will open the next one (wrapping around at the end).",flags:"IRW",name:"canCollapseAll"},"attr:StyleGroup.expanded":{seeAlso:[],ref:"attr:StyleGroup.expanded",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:StyleGroup",valueType:"Boolean",description:"Should this group's section be expanded?",flags:"IR",name:"expanded"},"attr:BuildUIViaAIProgressDialog.title":{seeAlso:[],defaultValue:'"Building UI via AI&amp;hellip;"',type:"attr",definingClass:"class:BuildUIViaAIProgressDialog",groups:["i18nMessages"],deprecated:null,ref:"attr:BuildUIViaAIProgressDialog.title",valueType:"HTMLString",description:"Title for this Window, shown if ${isc.DocUtils.linkForRef('attr:Window.showTitle','showTitle')} is true in the ${isc.DocUtils.linkForRef('attr:Window.header','header')}\n (if drawn).",flags:"IRW",name:"title"},"attr:Canvas.autoDraw":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:Canvas",groups:["drawing"],ref:"attr:Canvas.autoDraw",deprecated:null,valueType:"Boolean",description:"\n If true, this canvas will draw itself immediately after it is created.\n <P>\n <b>Note</b> that you should turn this OFF for any canvases that are provided as children\n of other canvases, or they will draw initially, then be clear()ed and drawn again when\n added as children, causing a large performance penalty.\n <P>\n For example, the following code is incorrect and will cause extra draw()s:\n <P>\n <pre>\n     isc.Layout.create({\n         members : [\n             isc.ListGrid.create()\n         ]\n     });\n </pre>\n It should instead be:\n <pre>\n     isc.Layout.create({\n         members : [\n             isc.ListGrid.create(<b>{ autoDraw: false }</b>)\n         ]\n     });\n </pre>\n In order to avoid unwanted autoDrawing systematically, it is recommend that you call\n ${isc.DocUtils.linkForRef('staticMethod:isc.setAutoDraw','isc.setAutoDraw(false)')} immediately after SmartClient is loaded\n and before any components are created, then set <code>autoDraw:true</code> or call\n draw() explicitly to draw components.\n <P>\n Otherwise, if the global setting for autoDraw remains <code>true</code>, you must set\n autoDraw:false, as shown above, on every component in your application that\n should not immediately draw: all Canvas children, Layout members, Window items, Tab\n panes, etc, however deeply nested.  Forgetting to set autoDraw:false will result in one\n more clear()s - these are reported on the Results tab of the\n ${isc.DocUtils.linkForRef('group:debugging','Developer Console')}, and can be tracked to individual components by\n using the \"clears\" log category in the Developer Console.\n ",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('autodraw')}"],name:"autoDraw"},"attr:SelectItem.pickerExitButtonTitle":{seeAlso:[],defaultValue:'"Done"',type:"attr",definingClass:"class:SelectItem",groups:["i18nMessages","panelPlacement"],deprecated:null,ref:"attr:SelectItem.pickerExitButtonTitle",valueType:"HTMLString",description:"The title for the ${isc.DocUtils.linkForRef('attr:SelectItem.pickerExitButton')}.",flags:"IR",name:"pickerExitButtonTitle"},"method:FormItem.getPageTop":{groups:["positioning"],seeAlso:[],ref:"method:FormItem.getPageTop",deprecated:null,type:"method",definingClass:"class:FormItem",description:" Returns the drawn page-top coordinate of this form item in pixels.\n",flags:"",returns:{type:"int",description:"page-top coordinate in px"},name:"getPageTop"},"method:DrawItem.setStartArrow":{seeAlso:[],ref:"method:DrawItem.setStartArrow",deprecated:null,type:"method",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:false,type:"ArrowStyle",description:"style of arrow to use",name:"arrowStyle"}],description:" Set the arrowhead at the beginning of this path.\n <p>\n <b>NOTE:</b> Not all DrawItem classes support arrowheads. You can use ${isc.DocUtils.linkForRef('method:DrawItem.supportsStartArrow')}\n to dynamically check whether a DrawItem instance supports this method.\n",flags:"",name:"setStartArrow"},"classMethod:EventHandler.setDragOffset":{groups:["dragdrop"],seeAlso:[{ref:"method:Canvas.dragStart",description:null}],ref:"classMethod:EventHandler.setDragOffset",deprecated:null,type:"classMethod",definingClass:"class:EventHandler",params:[{defaultValue:null,optional:false,type:"int",description:"initial x-offset for the drag",name:"offsetX"},{defaultValue:null,optional:false,type:"int",description:"initial y-offset for the drag",name:"offsetY"}],description:" Sets the initial coordinate offset of the last event, typically a mouseDown or touchStart,\n from the drag target.  For example, when grabbing and dragging a ${isc.DocUtils.linkForRef('class:Scrollbar')} thumb with\n the mouse, you'd expect positive coordinates that reflect your position relative to the top,\n left corner of the thumb.  If a drag tracker will be used, call ${isc.DocUtils.linkForRef('classMethod:EventHandler.setDragTracker')}\n instead, which takes optional arguments <code>offsetX</code> and <code>offsetY</code> that\n act similarly to those passed to this method.\n <P>\n Your canvas can call this method to set the initial drag offset to whatever you want like so:\n <pre>\n    dragStart : function () {\n        isc.EventHandler.setDragOffset(5, 20);\n    }</pre>\n\n",flags:"",name:"setDragOffset"},"attr:MetricSettings.gradationZeroLineProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:MetricSettings",groups:["gradations"],deprecated:null,ref:"attr:MetricSettings.gradationZeroLineProperties",valueType:"DrawLine Properties",description:"Properties for the gradation line drawn for zero (slightly thicker by default).",flags:"IR",name:"gradationZeroLineProperties"},"attr:FormItem.foreignDisplayField":{seeAlso:[{ref:"method:FormItem.getDisplayFieldName",description:null}],ref:"attr:FormItem.foreignDisplayField",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FormItem",valueType:"String",description:"For items with an ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}, this property specifies an explicit\n display field for records within the option dataSource. Typically this property\n will be set in conjunction with ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} in the case where\n the name of the displayField within the record being edited differs from the \n displayField in the optionDataSource.\n <P>\n See ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignDisplayField')} for additional details.",flags:"IR",name:"foreignDisplayField"},"attr:DSRequest.startRow":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DSRequest",groups:["paging"],deprecated:null,ref:"attr:DSRequest.startRow",valueType:"number",description:"Starting row of requested results, used only with fetch operations.  If unset, 0 is assumed.\n <p>\n Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at\n the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.",flags:"IR",name:"startRow"},"attr:ColorPicker.cancelButton":{seeAlso:[],ref:"attr:ColorPicker.cancelButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ColorPicker",valueType:"AutoChild IButton",description:"Cancel button for the ColorPicker",flags:"R",name:"cancelButton"},"type:MockDSExportFormat":{seeAlso:[],ref:"type:MockDSExportFormat",deprecated:null,type:"type",values:[{value:'"reifyCSV"',description:"export as Reify-specific CSV"},{value:'"xmlMockDS"',description:"serialize as XML"},{value:'"jsMockDS"',description:"serialize as JavaScript"}],description:null,name:"MockDSExportFormat"},"attr:JSONEncoder.strictQuoting":{seeAlso:[],ref:"attr:JSONEncoder.strictQuoting",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:JSONEncoder",valueType:"Boolean",description:'Whether all property names should be quoted, or only those property names that are not valid\n identifiers or are JavaScript reserved words (such as "true").\n <P>\n Encoding only where required produces slightly shorter, more readable output which is still\n compatible with JavaScript\'s eval():\n <pre>\n {\n     someProp : "someValue",\n     "true" : "otherValue",\n     otherProp : "otherValue"\n }\n </pre>\n .. but is not understood by many server-side JSON parser implementations.',flags:"IR",name:"strictQuoting"},"method:Calendar.eventRepositionStart":{seeAlso:[],ref:"method:Calendar.eventRepositionStart",deprecated:null,type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"CalendarEvent",description:"the event that's about to be moved",name:"event"}],description:" Notification fired when a user drags an EventCanvas.  Return false to cancel the drag.\n \n",flags:"",returns:{type:"Boolean",description:"return false to cancel the default drag start behavior"},name:"eventRepositionStart"},"method:ListGridField.formatInactiveCellValue":{seeAlso:[{ref:"method:ListGrid.formatInactiveCellValue",description:null}],ref:"method:ListGridField.formatInactiveCellValue",deprecated:null,type:"method",definingClass:"object:ListGridField",params:[{defaultValue:null,optional:false,type:"Any",description:"raw value for the cell, from the record for the row",name:"value"},{defaultValue:null,optional:false,type:"ListGridRecord",description:"Record object for the cell. Note: If this is a new row that has not been saved, in an\n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter (see ${isc.DocUtils.linkForRef('method:ListGrid.getEditValues')})",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number for the cell.",name:"colNum"},{defaultValue:null,optional:false,type:"ListGrid",description:"the ListGrid displaying the cell",name:"grid"}],description:" Field-level formatter for inactive content.\n <P>\n If present, this method will be invoked instead of ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue')} in cases \n where the grid is rendering non-interactive content outside. \n See ${isc.DocUtils.linkForRef('method:ListGrid.formatInactiveCellValue')} for more details.\n <P>\n",flags:"",returns:{type:"HTMLString",description:"HTML to display in the cell"},name:"formatInactiveCellValue"},"attr:Calendar.eventHeaderHeight":{seeAlso:[],ref:"attr:Calendar.eventHeaderHeight",defaultValue:"14",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"int",description:"When ${isc.DocUtils.linkForRef('attr:Calendar.eventHeaderWrap','eventHeaderWrap')} is false and \n ${isc.DocUtils.linkForRef('attr:Calendar.showEventDescriptions','showEventDescriptions')} is true, this is the fixed \n height for the ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')} in event canvases.",flags:"IR",name:"eventHeaderHeight"},"attr:FilterBuilder.operatorPickerWidth":{seeAlso:[],ref:"attr:FilterBuilder.operatorPickerWidth",defaultValue:"150",deprecated:null,type:"attr",definingClass:"class:FilterBuilder",valueType:"Integer | String",description:"Width for the operator picker formItem displayed in clauses within this FilterBuilder.",flags:"IR",name:"operatorPickerWidth"},"method:ButtonItem.setShowFocusedAsOver":{seeAlso:[],ref:"method:ButtonItem.setShowFocusedAsOver",deprecated:null,type:"method",definingClass:"class:ButtonItem",params:[{defaultValue:null,optional:false,type:"boolean",description:null,name:"showFocusedAsOver"}],description:" Sets showFocusedAsOver.\n",flags:"",name:"setShowFocusedAsOver"},"attr:FacetChart.extraAxisLabelAlign":{seeAlso:[],defaultValue:'"left"',type:"attr",definingClass:"class:FacetChart",groups:["labelsAndTitles"],deprecated:null,ref:"attr:FacetChart.extraAxisLabelAlign",valueType:"Alignment",description:"Horizontal alignment of labels shown in extra y-axes, shown to the right of the chart.",flags:"IRW",name:"extraAxisLabelAlign"},"attr:FormItem.hoverPersist":{seeAlso:[{ref:"attr:FormItem.hoverFocusKey",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["hovers"],ref:"attr:FormItem.hoverPersist",deprecated:null,valueType:"HoverPersistMode",setter:["setHoverPersist"],description:"Allows interaction with hovers when the cursor is positioned over them.\n <P>\n Overrides the ${isc.DocUtils.linkForRef('attr:Canvas.hoverPersist','same attribute')} on the parent form.",flags:"IRW",name:"hoverPersist"},"attr:Button.iconAlign":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Button",groups:["buttonIcon"],deprecated:null,ref:"attr:Button.iconAlign",valueType:"String",description:"If this button is showing an icon should it be right or left aligned?",flags:"IR",name:"iconAlign"},"attr:DynamicForm.readOnlyDisplay":{seeAlso:[],defaultValue:'"readOnly"',type:"attr",definingClass:"class:DynamicForm",groups:["appearance","readOnly"],ref:"attr:DynamicForm.readOnlyDisplay",deprecated:null,setter:["setReadOnlyDisplay"],valueType:"ReadOnlyDisplayAppearance",description:"If ${isc.DocUtils.linkForRef('attr:DynamicForm.canEdit')} is set to <code>false</code>, how should the items in this\n form be displayed to the user?\n <p>\n Can be overridden via ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay')} on individual form items.",flags:"IRW",name:"readOnlyDisplay"},"group:communication":{refs:["type:SendMethod"],seeAlso:[],ref:"group:communication",deprecated:null,type:"group",description:null,name:"communication"},"staticMethod:isc.warn":{groups:["Prompting"],seeAlso:[{ref:"classAttr:Dialog.Warn",description:null},{ref:"staticMethod:isc.say",description:null},{ref:"staticMethod:isc.ask",description:null},{ref:"method:Dialog.okClick",description:null},{ref:"classAttr:Dialog.WARN_TITLE",description:null}],ref:"staticMethod:isc.warn",deprecated:null,type:"staticMethod",definingClass:"object:isc",params:[{defaultValue:null,optional:false,type:"HTMLString",description:"message to display",name:"message"},{defaultValue:null,optional:true,type:"Callback",description:"Optional Callback to fire when the user                                      dismisses the dialog. This has the single parameter\n                                      'value', indicating the value returned by the Warn\n                                      dialog from 'okClick()' etc.",name:"callback"},{defaultValue:null,optional:true,type:"Dialog Properties",description:"additional properties for the Dialog.                                      To set ${isc.DocUtils.linkForRef('attr:Dialog.buttons','custom buttons')} for\n                                      the Dialog, set properties.buttons to\n                                      an array of buttons\n\t\t\t\t\t\t\t\t\t\teg:\t{ buttons : [Dialog.OK, Dialog.CANCEL] }",name:"properties"}],description:" Show a modal dialog with a message, icon, and \"OK\" button. See ${isc.DocUtils.linkForRef('attr:Dialog.warnIcon')}.\n <P>\n The callback will receive boolean true for an OK button click, or null if the Dialog is\n dismissed via the close button.\n\n",flags:"",name:"warn"},"attr:AsyncOperationParams.cancellationController":{seeAlso:[],ref:"attr:AsyncOperationParams.cancellationController",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:AsyncOperationParams",valueType:"CancellationController",description:"A ${isc.DocUtils.linkForRef('class:CancellationController')} that the asynchronous operation should look to for whether\n the operation is canceled.\n <p>\n This may be <code>null</code> if the invoker of the asynchronous operation does not need the\n ability to cancel. However, note that the ${isc.DocUtils.linkForRef('attr:AsyncOperationResult.type','result type')} may\n still be \"canceled\"; for example,\n the asynchronous operation may be self-canceling after a timeout.\n <p>\n Implementations of asynchronous operations must treat this <code>CancellationController</code>\n as observe-only, and they cannot ${isc.DocUtils.linkForRef('method:CancellationController.cancel','cancel')} it.",flags:"IR",name:"cancellationController"},"method:FormItem.mapDisplayToValue":{seeAlso:[{ref:"method:FormItem.mapValueToDisplay",description:null}],ref:"method:FormItem.mapDisplayToValue",deprecated:null,type:"method",definingClass:"class:FormItem",params:[{defaultValue:null,optional:false,type:"String",description:"display value",name:"value"}],description:" Given a display value for this FormItem, return the underlying data value.  This is \n done by reverse value-mapping, and/or parsing.\n <p>\n This method is called by the framework to derive an underlying data value for a given \n display value (ie, the value the user sees and interacts with) in a FormItem.  Your own \n code can call this method if you need to programmatically obtain the underlying data  \n value for a given display value.  However,\n it is <b>not</b> intended as an override point, and you should not treat \n it as one.\n \n If you have a field that requires the stored value to be different from the displayed \n value, and the requirement cannot be satisfied with a ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')}\n for some reason, you can add custom parsing logic by \n implementing ${isc.DocUtils.linkForRef('method:FormItem.parseEditorValue','parseEditorValue()')}\n \n <p>\n This method is also <b>not</b> intended as a place where you can validate, sanitize, \n transform or canonicalize user input<ul>\n <li>To ensure you get well-formed input values, use ${isc.DocUtils.linkForRef('attr:TextItem.mask','input masks')} or \n the ${isc.DocUtils.linkForRef('method:FormItem.change','change() event')}\n \n </li>\n <li>To transform or canonicalize input values, use a ${isc.DocUtils.linkForRef('type:ValidatorType','mask validator')}\n with \"transformTo\".  See the link to \"mask validator\" for more details and an example of this</li>\n <li>To transform or canonicalize input character-by-character as the user types, use \n ${isc.DocUtils.linkForRef('method:FormItem.transformInput','transformInput()')}\n \n </li></ul>\n <h3>Deriving the data value</h3>\n The process of deriving an underlying data display value from a display value involves \n the following steps:<ul>\n <li>If the formItem \n     declares a ${isc.DocUtils.linkForRef('method:FormItem.parseEditorValue')}\n     method,\n     \n      it is called</li>\n <li>Otherwise, if the formItem is of a ${isc.DocUtils.linkForRef('class:SimpleType')} that \n     declares a ${isc.DocUtils.linkForRef('method:SimpleType.parseInput','parseInput()')} method, it\n     \n     is called</li>\n <li>If the formItem is of a <code>SimpleType</code> that \n     ${isc.DocUtils.linkForRef('attr:SimpleType.inheritsFrom','inheritsFrom')} \"date\", \"time\" or \"datetime\", it will \n     be parsed as a date, time or datetime.  Note, this parsing step is applied on top of \n     custom SimpleType- and FormItem-level parsing</li>\n <li>If the formItem declares a ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')}, a value is derived by \n looking up the display value (including the effects of any parsing we may have done so far)\n in the valueMap</li>\n </ul>\n <b>Note:</b> Unlike the corollary method ${isc.DocUtils.linkForRef('method:FormItem.mapValueToDisplay','mapValueToDisplay()')},\n there is no special built-in handling of <code>${isc.DocUtils.linkForRef('attr:DataSourceField.multiple')}:true</code> \n fields.  If you want an array to be parsed out of some user input, you must write the\n parser method to do so.\n",flags:"",returns:{type:"Any",description:"value re-mapped for storing"},name:"mapDisplayToValue"},"method:TileGrid.setHilites":{groups:["hiliting"],seeAlso:[],ref:"method:TileGrid.setHilites",deprecated:null,type:"method",definingClass:"class:TileGrid",params:[{defaultValue:null,optional:false,type:"Array of Hilite",description:"Array of hilite objects",name:"hilites"}],description:" Only supported on ListGrid for now.\n",flags:"",name:"setHilites"},"method:TileGrid.filterData":{groups:["dataBoundComponentMethods"],seeAlso:[{ref:"method:DataBoundComponent.willFetchData",description:null}],ref:"method:TileGrid.filterData",deprecated:null,type:"method",definingClass:"class:TileGrid",params:[{defaultValue:null,optional:true,type:"Criteria",description:"Search criteria.                       If a ${isc.DocUtils.linkForRef('class:DynamicForm')} is passed in as this argument\n                      instead of a raw criteria object, will be derived by calling\n                      ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}",name:"criteria"},{defaultValue:null,optional:true,type:"DSCallback",description:"callback to invoke when a fetch is complete.  Fires                                          only if server contact was required; see\n                                          ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} for details",name:"callback"},{defaultValue:null,optional:true,type:"DSRequest Properties",description:"for databound components only - optional                           additional properties to set on the DSRequest that will be issued",name:"requestProperties"}],description:" Retrieves data that matches the provided criteria and displays the matching data in this\n component.\n <P>\n This method behaves exactly like ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} except that\n ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} is automatically set to \"substring\" so that String-valued\n fields are matched by case-insensitive substring comparison.\n <p>\n For a discussion of the various filtering and criteria-management APIs and when to use \n them, see the ${isc.DocUtils.linkForRef('group:gridFiltering','Grid Filtering overview')}.\n",flags:"",name:"filterData"},"attr:ModalWindow.autoCenter":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:ModalWindow",groups:["appearance","location"],deprecated:null,ref:"attr:ModalWindow.autoCenter",valueType:"boolean",description:"If true, this Window widget will automatically be centered on the page when shown.\n If false, it will show up in the last position it was placed (either programmatically,\n or by user interaction).\n <P>\n <b>Note:</b> If an auto-centering Window is either programmatically moved or dragged \n by an end user, auto-centering behavior is automatically turned off. To manually center \n a Window, you can use ${isc.DocUtils.linkForRef('method:Window.centerInPage','centerInPage()')}.  Auto-centering will also be disabled if\n you pass an explicit ${isc.DocUtils.linkForRef('attr:Canvas.left','left')} or ${isc.DocUtils.linkForRef('attr:Canvas.top','top')} value at ${isc.DocUtils.linkForRef('classMethod:Class.create','create time')}.",flags:"IRW",name:"autoCenter"},"attr:OperationBinding.transformRawResponseScript":{seeAlso:[],defaultValue:"null",requiresModules:["SCServer"],type:"attr",definingClass:"class:OperationBinding",groups:["serverScript"],ref:"attr:OperationBinding.transformRawResponseScript",deprecated:null,valueType:"String",description:"<b>Applicable to ${isc.DocUtils.linkForRef('group:serverRestConnector','server-side REST DataSources')} only</b>\n <p>\n A scriptlet to be executed on the server after data has been fetched from the REST service\n by this operation, but before it is processed through templating.  See \n ${isc.DocUtils.linkForRef('attr:DataSource.transformRawResponseScript')} for further details.\n <p>\n Note, unlike many OperationBinding-level properties, a <code>transformRawResponseScript</code>\n at the OperationBinding level does not hide a <code>transformRawResponseScript</code> defined \n at the DataSource level.  Instead, if you define <code>transformRawResponseScript</code> against\n both the DataSource and the OperationBinding, <b>both</b> are run - first the \n DataSource-level script, then the OperationBinding-level one.",flags:"IR",serverDS:"only",name:"transformRawResponseScript"},"method:DrawItem.showAllKnobs":{seeAlso:[],ref:"method:DrawItem.showAllKnobs",deprecated:null,type:"method",definingClass:"class:DrawItem",description:" Shows all supported control knobs for this drawItem. Updates ${isc.DocUtils.linkForRef('attr:DrawItem.knobs')} to include the\n supported knobTypes and if necessary draws out the appropriate control knobs.\n",flags:"",name:"showAllKnobs"},"method:FormItem.titleHoverHTML":{seeAlso:[{ref:"attr:FormItem.canHover",description:null},{ref:"attr:FormItem.prompt",description:null},{ref:"method:FormItem.titleHover",description:null},{ref:"method:FormItem.itemHoverHTML",description:null},{ref:"attr:FormItem.showClippedTitleOnHover",description:null}],type:"method",definingClass:"class:FormItem",returns:{type:"HTMLString",description:"HTML to be displayed in the hover"},groups:["Hovers"],deprecated:null,ref:"method:FormItem.titleHoverHTML",params:[{defaultValue:null,optional:false,type:"FormItem",description:"Pointer to this item",name:"item"},{defaultValue:null,optional:false,type:"DynamicForm",description:"This items form",name:"form"}],description:" If defined, this method should return the HTML to display in a hover canvas when the \n user holds the mousepointer over this item's title.  Return null to suppress the hover \n canvas altogether.\n <P>\n If not defined, ${isc.DocUtils.linkForRef('method:DynamicForm.titleHoverHTML')} will be evaluated to determine\n hover content instead.\n <p>\n If ${isc.DocUtils.linkForRef('attr:FormItem.canHover')} is set to false, this method is not called.\n",flags:"A",name:"titleHoverHTML"},"classAttr:ListGrid.BOTH":{seeAlso:[],defaultValue:'"both"',type:"classAttr",definingClass:"class:ListGrid",deprecated:null,ref:"classAttr:ListGrid.BOTH",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:RecordDropAppearance','RecordDropAppearance')}.",flags:"R",name:"BOTH",constant:true},"attr:DataSource.autoDiscoverTree":{seeAlso:[],ref:"attr:DataSource.autoDiscoverTree",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:DataSource",valueType:"boolean",description:"Causes ${isc.DocUtils.linkForRef('classMethod:Tree.discoverTree')} to be called on dsResponse.data in order to automatically\n discover tree structures in the response data.\n <P>\n If autoDiscoverTree is set, discoverTree() is called after the default dsResponse.data\n has been derived (${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')} and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','valueXPath')} have been applied) and after\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} has been called.\n <P>\n If a DataSourceField is declared with\n ${isc.DocUtils.linkForRef('attr:DataSourceField.childrenProperty','childrenProperty:true')}, discoverTree() will be invoked with\n ${isc.DocUtils.linkForRef('attr:DiscoverTreeSettings.newChildrenProperty','settings.newChildrenProperty')} set to the name of\n the field marked as the childrenField.  Similarly, if the DataSource has a\n ${isc.DocUtils.linkForRef('attr:DataSource.titleField')} it will be used as the\n ${isc.DocUtils.linkForRef('attr:DiscoverTreeSettings.nameProperty','settings.nameProperty')}.",flags:"IR",name:"autoDiscoverTree"},"classAttr:Operators.isNullTitle":{seeAlso:[],defaultValue:'"is null"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.isNullTitle",valueType:"String",description:'Title for the "isNull" operator',flags:"IR",name:"isNullTitle"},"classMethod:AutoTest.setTestRoot":{groups:["autoTest"],seeAlso:[],ref:"classMethod:AutoTest.setTestRoot",deprecated:null,type:"classMethod",definingClass:"class:AutoTest",params:[{defaultValue:null,optional:false,type:"Canvas",description:"the implicit root",name:"canvas"}],description:' Sets the implicit root canvas available in scLocators starting "//testRoot[]".\n Setting this property may enable one to use the same script to test identical\n widget hierarchies that are rooted under different base widgets.\n',flags:"",name:"setTestRoot"},"classAttr:Operators.regexpTitle":{seeAlso:[],defaultValue:'"matches expression (match case)"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.regexpTitle",valueType:"String",description:'Title for the "regexp" operator',flags:"IR",name:"regexpTitle"},"method:MultiLinkSelection.getSelection":{groups:["selection"],seeAlso:[],ref:"method:MultiLinkSelection.getSelection",deprecated:null,type:"method",definingClass:"class:MultiLinkSelection",description:" Returns the selected nodes in this grid as a list of ${isc.DocUtils.linkForRef('object:NodeLocator')}s.\n\n",flags:"",returns:{type:"Array of NodeLocator",description:"The list of selected node occurences in the grid"},name:"getSelection"},"classMethod:Canvas.getAllCanvases":{seeAlso:[],ref:"classMethod:Canvas.getAllCanvases",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:true,type:"CanvasFilterMode",description:'Filter mode determining which canvases to include.        Defaults to "visible".',name:"mode"},{defaultValue:null,optional:true,type:"AdvancedCriteria",description:"Optional criteria to further filter the results.        Evaluated against each canvas's properties.",name:"criteria"}],description:' Returns an array of Canvas instances based on the specified filter mode and optional\n ${isc.DocUtils.linkForRef(\'object:AdvancedCriteria\')}.\n <P>\n <b>Note:</b> This method is intended for debugging, testing, and diagnostic purposes\n only. It should not be used in production application code. Applications should maintain\n their own references to canvases they create rather than querying the global canvas\n registry.\n <P>\n This method provides access to the internal registry of all created Canvas instances,\n filtered according to the specified mode. The default mode ("visible") returns only\n canvases that are drawn, visible to the end user (checking parental visibility), and\n non-generated (i.e., developer-created canvases, not autoChildren or other framework-\n generated components).\n <P>\n The optional <code>criteria</code> parameter allows further filtering using\n ${isc.DocUtils.linkForRef(\'object:AdvancedCriteria\')}. The criteria are evaluated against each canvas\'s properties.\n For example, to find all visible Buttons with a specific title:\n \n <pre>\n var buttons = isc.Canvas.getAllCanvases("visible", {\n     _constructor: "AdvancedCriteria",\n     operator: "and",\n     criteria: [\n         { fieldName: "_constructor", operator: "equals", value: "Button" },\n         { fieldName: "title", operator: "iContains", value: "Save" }\n     ]\n });\n </pre>\n \n\n',flags:"",returns:{type:"Array of Canvas",description:"Array of matching Canvas instances"},name:"getAllCanvases"},"attr:Button.canAdaptWidth":{seeAlso:[{ref:"attr:Canvas.canAdaptWidth",description:null}],defaultValue:"false",type:"attr",definingClass:"class:Button",deprecated:null,ref:"attr:Button.canAdaptWidth",valueType:"Boolean",description:"This flag enables ${isc.DocUtils.linkForRef('attr:Canvas.canAdaptWidth','adaptive width')} for the button.\n <P>\n If enabled the button will support rendering in a 'collapsed' view if there isn't enough\n space in a layout to render it at normal size. There are a couple of ways this can be achieved.\n <ul>\n <li>If ${isc.DocUtils.linkForRef('attr:Button.adaptWidthShowIconOnly')} is true and this button shows an icon, the title\n     will be hidden if there isn't enough space to render it, allowing it to shrink to either\n     the rendered icon width, or any specified ${isc.DocUtils.linkForRef('attr:Canvas.minWidth','minWidth')}, whichever is larger.</li>\n <li>Otherwise, if the button has a specified ${isc.DocUtils.linkForRef('attr:Canvas.minWidth','minWidth')}, and \n     ${isc.DocUtils.linkForRef('attr:Button.autoFit')} is true, autoFit will be temporarily disabled, if there isn't enough\n     room, allowing the title to be clipped</li>\n </ul>\n In either case the title will show on hover unless an explicit hover has been\n specified such as by overriding ${isc.DocUtils.linkForRef('method:Button.titleHoverHTML')}.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('buttonAdaptiveWidth')}"],name:"canAdaptWidth"},"attr:SimpleType.readOnlyDisplay":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:SimpleType",deprecated:null,ref:"attr:SimpleType.readOnlyDisplay",valueType:"ReadOnlyDisplayAppearance",description:"Default ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','readOnlyDisplay')} for fields of this type.\n <P>\n For more sophisticated management of read-only behavior, see ${isc.DocUtils.linkForRef('attr:SimpleType.readOnlyEditorType')}.",flags:"IR",serverDS:"allowed",name:"readOnlyDisplay"},"attr:ListGrid.showSelectionCanvas":{seeAlso:[{ref:"attr:ListGrid.showSelectionUnderCanvas",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["rowEffects"],deprecated:null,ref:"attr:ListGrid.showSelectionCanvas",valueType:"Boolean",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType','selectionType')} is set to\n \"single\",\n \n setting this property to <code>true</code> means selection will be displayed to the\n user with the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionCanvas','selectionCanvas')} and/or\n ${isc.DocUtils.linkForRef('attr:ListGrid.selectionUnderCanvas','selectionUnderCanvas')} rather than with CSS styling.\n <p>\n If <code>showSelectionCanvas</code> is set to <code>true</code>, then the\n <code>selectionUnderCanvas</code> will automatically be enabled unless\n ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectionUnderCanvas','showSelectionUnderCanvas')} is set to <code>false</code>.\n <p>\n NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the\n <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is\n stacked on top of the selected record and this may interfere with event handling in rare\n cases. If no interactive components are shown in the <code>selectionCanvas</code> and it\n simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used\n instead.\n <p>\n With ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','frozen fields')}, the <code>selectionCanvas</code>\n is displayed only over the non-frozen fields of the selected row.",flags:"IRWA",name:"showSelectionCanvas"},"attr:ShowNextToComponentTask.canOcclude":{seeAlso:[],ref:"attr:ShowNextToComponentTask.canOcclude",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ShowNextToComponentTask",valueType:"Boolean",description:"Can this component can be positioned on top of the other\n component if there isn't room to show next to it?",flags:"IR",name:"canOcclude"},"classAttr:Authentication.logOutURL":{seeAlso:[],ref:"classAttr:Authentication.logOutURL",defaultValue:"null",deprecated:null,type:"classAttr",definingClass:"class:Authentication",valueType:"String",description:"URL to open for logging the current user out.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will \n be evaluated as JS code when the message is displayed.\n <P>\n The dynamic variables available are the fields in the ${isc.DocUtils.linkForRef('classMethod:Authentication.getCurrentUser')} record.",flags:"IR",name:"logOutURL"},"method:Canvas.getWidth":{groups:["sizing"],seeAlso:[],ref:"method:Canvas.getWidth",deprecated:null,type:"method",definingClass:"class:Canvas",description:" Return the width of this object, in pixels.\n <P>\n See ${isc.DocUtils.linkForRef('group:gettingCanvasSize')}\n",flags:"",returns:{type:"Number",description:"width"},name:"getWidth"},"method:ListGridField.recordDoubleClick":{seeAlso:[{ref:"method:ListGrid.recordClick",description:null}],type:"method",definingClass:"object:ListGridField",returns:{type:"boolean",description:"false to stop event bubbling"},groups:["events"],ref:"method:ListGridField.recordDoubleClick",deprecated:null,params:[{defaultValue:null,optional:false,type:"ListGrid",description:"the listGrid that contains doubleclick event",name:"viewer"},{defaultValue:null,optional:false,type:"ListGridRecord",description:"the record that was double-clicked",name:"record"},{defaultValue:null,optional:false,type:"number",description:"number of the record clicked on in the current set of                                  displayed records (starts with 0)",name:"recordNum"},{defaultValue:null,optional:false,type:"ListGridField",description:"the field that was clicked on (field definition)",name:"field"},{defaultValue:null,optional:false,type:"number",description:"number of the field clicked on in the listGrid.fields                                  array",name:"fieldNum"},{defaultValue:null,optional:false,type:"Object",description:"value of the cell (after valueMap, etc. applied)",name:"value"},{defaultValue:null,optional:false,type:"Object",description:"raw value of the cell (before valueMap, etc applied)",name:"rawValue"}],description:"\n Executed when this field is double-clicked.  Note that if\n ${isc.DocUtils.linkForRef('method:ListGrid.recordDoubleClick')} is also defined, it will be fired for fields that define\n a recordDoubleClick handler if the field-level handler returns true. Return false to prevent\n the grid-level handler from firing.\n\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('recordClicks')}"],name:"recordDoubleClick"},"method:ValuesManager.showErrors":{groups:["errors"],seeAlso:[],ref:"method:ValuesManager.showErrors",deprecated:null,type:"method",definingClass:"class:ValuesManager",description:" Method to explicitly show the latest set of validation errors present on this \n ValuesManager.<br>\n Will redraw all member forms to display (or clear) currently visible errors, and\n fire ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')} to allow custom handling of\n hidden errors.\n",flags:"",name:"showErrors"},"group:autoChildren":{refs:["type:AutoChild","method:Class.addAutoChild","method:Class.createAutoChild","method:Class.getChildPropertyValue","attr:Class.creator","attr:Class.autoCreator","attr:Canvas.autoParent"],seeAlso:[{ref:"attr:Canvas.autoParent",description:null},{ref:"attr:Class.autoCreator",description:null}],ref:"group:autoChildren",deprecated:null,type:"group",description:'An autoChild is an automatically generated subcomponent that a component creates to\n handle part of its presentation or functionality.\n <P>\n An example is the Window component and its subcomponent the "header".\n <P>\n AutoChildren support a standard set of properties that can be used to customize or skin\n them.\n <P>\n This topic explains how to use the autoChild system when creating custom components in\n order to create maximum flexibility.  To learn how to use the autoChild system with \n pre-existing components, ${isc.DocUtils.linkForRef(\'group:autoChildUsage\',\'go here\')}.  \n <P>\n Before reading this topic, be sure you have read the ${isc.DocUtils.linkForDocNode(\'QuickStart Guide\')}\n material on creating custom components and have reviewed the provided examples.\n <P>\n <i>Note:</i> the autoChild pattern allows you to generate instances of any ${isc.DocUtils.linkForRef(\'class:Canvas\')} subclass,\n but FormItems ${isc.DocUtils.linkForRef(\'classMethod:FormItem.create\',\'may not be created outside of a DynamicForm\')} and\n as such can not be instantiated as autoChildren using the APIs described below.\n <P>\n <h3>Basics</h3>\n <P>\n The following is an example of creating subcomponents <b>without</b> using the AutoChild\n pattern.  In this case a fictitious "Portlet" class is being created, which uses an\n instance of isc.Label to serve as it\'s header.\n <pre>\n isc.defineClass("Portlet", "VLayout").addProperties({\n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         this.headerLabel = isc.Label.create({\n             autoDraw:false,\n             contents: this.title, \n             styleName: this.titleStyleName,\n             portlet:this,\n             click : function () { this.portlet.bringToFront() },\n             wrap:false,  \n             overflow:"hidden", \n             width:"100%"\n         });\n         this.addMember(this.headerLabel);\n         ...\n </pre>\n While straightforward, this approach provides limited flexibility to someone using the\n "Portlet" class.  There is no way to:\n <ol>\n <li> avoid creating the headerLabel, for a "headerless" portlet\n <li> use a different, more advanced class as a header (eg, StretchImgButton or a custom \n class)\n <li> skin / change the appearance of the headerLabel, beyond setting its <code>styleName</code>\n <li> change it\'s layout behavior (eg enable autoSize)\n <li> add or override event handlers\n </ol>\n Let\'s imagine we wanted to add some of the above features.  We could change the code\n like so:\n <P>\n <pre>\n isc.defineClass("Portlet", "VLayout").addProperties({\n     <b>showHeaderLabel:true,</b>\n     <b>headerLabelConstructor:isc.Label,</b>\n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         <b>if (this.showHeaderLabel) {</b>\n             this.headerLabel = this.headerLabelConstructor.create({\n                 autoDraw:false,\n                 contents: this.title, \n                 styleName: this.titleStyleName,\n                 portlet:this,\n                 click : function () { this.portlet.bringToFront() },\n                 wrap:false,  \n                 overflow:"hidden", \n                 width:"100%"\n             }<b>, this.headerLabelProperties</b>);\n             this.addMember(this.headerLabel);\n         <b>}</b>\n         ...\n </pre>\n Our additions solve our initial concerns:\n <ul>\n <li> <code>showHeaderLabel:false</code> can be set to suppress the header label\n <li> <code>headerLabelConstructor</code> allows you to switch to a different class\n <li> <code>headerLabelProperties</code> give you a means to add arbitrary properties\n (skinning properties, sizing properties, event handlers, etc)\n </ul>\n However, the code is becoming more verbose and repetitive, and we\'ve created a few\n additional properties that now need documentation and testing.  This extra work is going\n to be multiplied by every subcomponent we create where we want this kind of flexibility.\n <P>\n Enter the AutoChild system: the purpose of the AutoChild system is to define a standard\n pattern for creating subcomponents with maximum flexibility.  This means:\n <ul>\n <li> developers creating custom components write less code, have less to test and less\n to document\n <li> developers can more easily understand each other\'s code for custom components,\n because it follows a standard pattern\n <li> developers <b>using</b> custom components have a standard pattern for\n customization, instead of learning customization APIs for every component separately\n </ul>\n The code below uses the autoChild system to create the "headerLabel" subcomponent.  This\n version of the code would still respect all of the customization properties from earlier\n examples (<code>headerLabelProperties</code> et al) and offers several additional degrees\n of flexibility still to be explained, yet it\'s significantly shorter.  More importantly,\n this code is less redundant; the "boilerplate" code is gone and what\'s left is just the\n actual settings for the headerLabel subcomponent.\n <pre>\n isc.defineClass("Portlet", "VLayout").addProperties({\n     headerLabelDefaults : {\n         _constructor:isc.Label,\n         click : function () { this.creator.bringToFront() },\n         wrap:false,  \n         overflow:"hidden", \n         width:"100%"\n     },\n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         this.addAutoChild("headerLabel", {\n             contents: this.title, \n             styleName: this.titleStyleName\n         });\n         ...\n </pre>\n <P>\n The documentation for ${isc.DocUtils.linkForRef(\'method:Class.addAutoChild\',\'addAutoChild()\')} and \n ${isc.DocUtils.linkForRef(\'group:autoChildUsage\')} explains why this code\n will still respect the <code>showHeaderLabel</code> flag and other customization\n properties even though they aren\'t mentioned specifically.<br>\n In this case the <code>_constructor</code> property has been used to make the headerLabel be\n generated as an instance of ${isc.DocUtils.linkForRef(\'class:Label\')}, but the developer could alternatively\n have used <code>headerLabelConstructor</code>. If both <code><i>autoChildName</i>Constructor</code>\n and <code>_constructor</code> are set, <code><i>autoChildName</i>Constructor</code> will\n be used.\n <P>\n Note that AutoChildren are not always created as soon as the parent component, and may \n be created only when the parent is drawn, or in some cases, only when needed.  \n For the best chance of forward compatibility, use properties and defaults instead of \n accessing the live reference, and if you do access the live reference, access it only \n when it is clear that the AutoChild must have been created by that point.  \n For example, even if you determined by experimentation that the Window class currently \n creates it\'s "header" AutoChild when the Window is created, you should avoid accessing \n it until the Window has drawn, to leave room for the Window\'s implementation to change \n such that creation of the "header" AutoChild is deferred until draw.\n <P>\n <h3>AutoChildren lifecycle</h3>\n <P>\n By default any auto-children created by ${isc.DocUtils.linkForRef(\'method:Class.addAutoChild\')} or \n ${isc.DocUtils.linkForRef(\'method:Class.createAutoChild\')} will be ${isc.DocUtils.linkForRef(\'method:Canvas.destroy\',\'destroyed\')} when the\n canvas that created them is destroyed. You can suppress this behavior by setting\n <code>dontAutoDestroy</code> to <code>true</code> on the auto child. To do this you\n could add the property to the defaults or properties block for the autoChild, or\n pass it into the creating method in the dynamic set of properties.\n <p>\n <h3>Subclassing a component with autoChildren</h3>\n <P>\n If you are subclassing a component that has an autoChild and you want to change\n defaults for that autoChild, the correct way to do so is to use\n ${isc.DocUtils.linkForRef(\'classMethod:Class.changeDefaults\',\'changeDefaults()\')}:\n <pre>\n isc.defineClass("MyWindow", "Window");\n isc.MyWindow.changeDefaults("headerDefaults", { layoutMargin:10 });\n isc.MyWindow.addProperties({ \n    ...\n </pre>\n <P>\n <code>changeDefaults()</code> creates a copy of the superclass defaults and applies your\n changes, which is important because you want to inherit the superclass behavior without\n affecting the superclass, and yet apply overrides.\n <P>\n The following code sample indicates two common \n <span style="color:red;font-weight:bold">incorrect</span> patterns for working with\n defaults, and the consequences of each: \n <pre>\n isc.defineClass("MyWindow", "Window").addProperties({\n     // NO.  Superclass behavior / settings for autoChild\n     // won\'t be inherited.  Use changeDefaults() instead.\n     headerDefaults : { ... },\n \n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         // NO.  "headerDefaults" object is shared across the class,\n         // changing it affects all instances created from here on.\n         // Pass dynamic defaults to addAutoChild() instead\n         this.headerDefaults.myProperty = this.newValue;\n         ...\n });\n </pre>\n <b>defaults vs properties</b>\n <P>\n For AutoChildren, defaults and properties both provide similar means of adding\n properties to an AutoChild, and the distinction between them is primarily one of\n convention: a class that uses AutoChildren should never define a default value for\n <i>autoChildName</i>Properties, so that instances can freely specify\n <i>autoChildName</i>Properties without overriding built-in behavior.\n <pre>\n isc.defineClass("MyWindow", "Window").addProperties({\n     // NO.  Any further use of "headerProperties", in\n     // instances or in subclasses, would wipe out behavior\n     headerProperties : { ... },\n </pre>\n <P>\n By consistently using ${isc.DocUtils.linkForRef(\'classMethod:Class.changeDefaults\')} whenever you override autoChild\n defaults in a subclass, you ensure that your classes can in turn be subclassed and\n extended uniformly.\n <P>\n <h3>autoParents and creation order</h3>\n <P>\n The AutoChild pattern can create an entire hierarchy of generated subcomponents.  For\n example, the ${isc.DocUtils.linkForRef(\'class:Window\')} class included with SmartClient uses several AutoChildren as\n part of the overall header structure: separate autoChildren for the minimize button,\n close button, and then the header itself, a Layout-derived class that contains all other\n header controls. \n <P>\n To facilitate construction of hierarchies of autoChildren, the special\n <code>autoParent</code> property may appear in either defaults or properties for an\n autoChild, and indicates the name of another autoChild that should used as a parent.\n For example, to create a "closeButton" autoChild that will be a member of the "header"\n autoChild:\n <P>\n <pre>\n isc.defineClass("Portlet", "VLayout").addProperties({\n     headerDefaults : {\n         _constructor:isc.HLayout,\n         ...\n     },\n     closeButtonDefaults : {\n         <b>autoParent:"header",</b>\n         _constructor:isc.ImgButton,\n         ...\n     },\n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         this.addAutoChild("header");\n         this.addAutoChild("closeButton");\n         ...\n </pre>\n <P>\n In addition to cutting down on code and making inter-autoChild relationships clearer,\n using <code>autoParent</code> rather than manual calls to addMember() allows a\n subclass of your component to potentially completely rearrange the autoChildren you have\n defined, while retaining their behavior.\n <P>\n When using <code>autoParent</code> to arrange autoChildren, create parents first, then\n children.\n <P>\n <b>Tip:</b> if you want all of the behaviors of\n ${isc.DocUtils.linkForRef(\'method:Class.addAutoChild\',\'addAutoChild()\')} <i>except</i> automatically adding the\n autoChild to a parent, set <code>autoParent:"none"</code>.\n <P>\n <b>special case: TabSets and SectionStacks</b>\n <p>\n An autoChild that appears as a ${isc.DocUtils.linkForRef(\'attr:Tab.pane\')} or\n ${isc.DocUtils.linkForRef(\'attr:SectionStackSection.items\',\'section item\')} does not have a clear way to refer to it\'s\n tab or section via the <code>autoParent</code> property.  For this special case, the\n TabSet and SectionStack components allow tab.pane / section.items to contain the special\n string "autoChild:<i>autoChildName</i>".  This will cause the corresponding autoChild to\n be automatically created when the tab is selected or section expanded.\n <P>\n Generally, whatever component is creating the AutoChildren should be the logically\n reusable, self-contained component, and all the meaty logic should appear as methods on\n that component.  Then you know that the ${isc.DocUtils.linkForRef(\'attr:Class.creator\',\'creator\')} is always the same\n thing, and always where all the logic is.\n <P>\n For example:\n <pre>\n isc.defineClass("Portlet", "VLayout").addProperties({\n     ...\n     mainTabsDefaults : {\n         _constructor:isc.TabSet,\n         tabs : [\n             { title:"First Pane", pane:"autoChild:firstPane" }\n         ]\n     },\n     firstPaneDefaults : {\n         ...\n     },\n     initWidget : function () {\n         this.Super("initWidget", arguments);\n\n         // this automatically creates firstPane as an autoChild\n         this.addAutoChild("mainTabs");\n         ...\n </pre>',name:"autoChildren"},"classMethod:Page.ignore":{seeAlso:[],ref:"classMethod:Page.ignore",deprecated:null,type:"classMethod",definingClass:"class:Page",params:[{defaultValue:null,optional:false,type:"String",description:"ID returned from ${isc.DocUtils.linkForRef('classMethod:Page.observe')} call we want to clear",name:"observerID"}],description:" Clear an observation set up by ${isc.DocUtils.linkForRef('classMethod:Page.observe')}.\n <P>\n This method is available as <code>isc.Page.ignore()</code> or just <code>isc.ignore()</code>\n\n",flags:"",name:"ignore"},"class:ToolStripMenuButton":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"MenuButton",classMethods:[],classAttrs:[],attrs:[],ref:"class:ToolStripMenuButton",deprecated:null,treeLocation:["Client Reference/Layout/ToolStrip"],description:"Simple subclass of MenuButton with appearance appropriate for a ToolStrip menu button.\n Can be used to create an icon-only menu button, and icon with text, or a text only button by setting the \n icon and title attibutes as required.",methods:[],name:"ToolStripMenuButton"},"method:ListGrid.getDrawnRowHeight":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"number",description:"height"},groups:["sizing","positioning"],deprecated:null,ref:"method:ListGrid.getDrawnRowHeight",params:[{defaultValue:null,optional:false,type:"number",description:null,name:"rowNum"}],description:" Get the drawn height of a row.\n\n",flags:"A",name:"getDrawnRowHeight"},"attr:FacetChart.showRegressionLine":{seeAlso:[{ref:"attr:FacetChart.xAxisMetric",description:null},{ref:"attr:FacetChart.yAxisMetric",description:null},{ref:"attr:FacetChart.regressionLineProperties",description:null}],defaultValue:"false",type:"attr",definingClass:"class:FacetChart",groups:["statistics"],ref:"attr:FacetChart.showRegressionLine",deprecated:null,valueType:"Boolean",setter:["setShowRegressionLine"],description:'For scatter plots only, whether to display a regression curve that best fits the data of\n the two metric facet values.\n <P>\n The type of regression curve used depends on the ${isc.DocUtils.linkForRef(\'type:RegressionLineType\')} property,\n which can be:\n <ul>\n <li><b>"line"</b> &ndash; to draw a linear regression curve, or</li>\n <li><b>"polynomial"</b> &ndash; to draw a polynomial regression curve (of degree\n ${isc.DocUtils.linkForRef(\'attr:FacetChart.regressionPolynomialDegree\')}).<li>\n </ul>\n <P>\n Note that the regression is computed using all of the data points and it does not depend\n on the values of any non-metric facets.  For example, adding a legend facet will not\n change the regression curve.\n <P>\n See <a href="http://en.wikipedia.org/wiki/Simple_linear_regression">http://en.wikipedia.org/wiki/Simple_linear_regression</a>.\n See <a href="http://en.wikipedia.org/wiki/Polynomial_regression">http://en.wikipedia.org/wiki/Polynomial_regression</a>.',flags:"IRW",name:"showRegressionLine"},"type:PreserveOpenState":{seeAlso:[],ref:"type:PreserveOpenState",deprecated:null,type:"type",values:[{value:"never",description:"Never try to automatically preserve the openState.  Nodes will be initially open \n  or closed based solely on the ${isc.DocUtils.linkForRef('attr:Tree.openProperty')} optionally set by the server."},{value:"whenUnique",description:"If either the ${isc.DocUtils.linkForRef('attr:Tree.idField')} or ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} has been set on \n  the Tree, (so that nodes have either unique ids or unique paths), \n  preserve openState by respecting the ${isc.DocUtils.linkForRef('attr:Tree.openProperty')} set by the server, \n  then applying the openState."},{value:"always",description:'Like "whenUnique" but automatically preserves openState even if nodes cannot be\n  uniquely identified.  This means that nodes at the same tree positions \n  (eg 3rd child of 5th node under root) will be placed in the same openState, \n  regardless of whether that node has anything to do with the node that previously \n  was at that tree position.'}],description:null,name:"PreserveOpenState"},"attr:CreateScreenSettings.verifyAsError":{seeAlso:[{ref:"attr:CreateScreenSettings.verifyAsError",description:null},{ref:"attr:LoadProjectSettings.verifyAsError",description:null}],ref:"attr:CreateScreenSettings.verifyAsError",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:CreateScreenSettings",valueType:"boolean",description:"Enable ${isc.DocUtils.linkForRef('classAttr:RPCManager.verifyAsError','verifyAsError')} behavior only for\n requests using these settings.",flags:"IRW",name:"verifyAsError"},"method:Layout.removeMembers":{seeAlso:[],ref:"method:Layout.removeMembers",deprecated:null,type:"method",definingClass:"class:Layout",params:[{defaultValue:null,optional:false,type:"Array of Canvas | Canvas",description:"array of members to be removed, or single member",name:"members"}],description:"\n  Removes the specified members from the layout. If any of the removed members have resize\n  bars, the bars will be destroyed.\n\n",flags:"",name:"removeMembers"},"attr:TabSet.bottomEdgeSizes":{seeAlso:[],ref:"attr:TabSet.bottomEdgeSizes",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TabSet",valueType:"EdgeSizes",description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n and ${isc.DocUtils.linkForRef('attr:TabSet.symmetricEdges')} is set to false, the <code>leftEdgeSizes</code>, \n <code>rightEdgeSizes</code>, <code>topEdgeSizes</code> and <code>bottomEdgeSizes</code> \n properties allow the sizes of edges for the paneContainer to be customized depending on\n the ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.\n <P>\n The attribute should be specified an ${isc.DocUtils.linkForRef('type:EdgeSizes','edgeSizes map')}, specifying the\n desired edge sizes where for the appropriate ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')}.",flags:"IR",name:"bottomEdgeSizes"},"classAttr:AI.dataSourceIsRequiredErrorMessage":{seeAlso:[],defaultValue:'"A globally-installed DataSource with a non-composite primary key is required."',type:"classAttr",definingClass:"class:AI",groups:["i18nMessages"],deprecated:null,ref:"classAttr:AI.dataSourceIsRequiredErrorMessage",valueType:"HTMLString",description:null,flags:"RW",name:"dataSourceIsRequiredErrorMessage"},"attr:SelectItem.pickButtonWidth":{seeAlso:[],ref:"attr:SelectItem.pickButtonWidth",defaultValue:"null",deprecated:"As of SmartClient version 5.5, pickButtonWidth has been deprecated in   favor of ${isc.DocUtils.linkForRef('attr:SelectItem.pickerIconWidth')}.",type:"attr",definingClass:"class:SelectItem",valueType:"number",description:"How large should the pick button be rendered?",flags:"IRWA",name:"pickButtonWidth"},"method:EditContext.makePaletteNodeTree":{seeAlso:[],ref:"method:EditContext.makePaletteNodeTree",deprecated:null,type:"method",definingClass:"class:EditContext",params:[{defaultValue:null,optional:false,type:"EditNode",description:"root editNode to make Tree of PaletteNodes from",name:"editNode"},{defaultValue:null,optional:false,type:"Boolean",description:"should ID and autoID defaults be removed?",name:"removeAutoIDs"}],description:" Creates a ${isc.DocUtils.linkForRef('class:Tree')} of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')} from an ${isc.DocUtils.linkForRef('object:EditNode')} in this\n context's ${isc.DocUtils.linkForRef('method:EditContext.getEditNodeTree','editNodeTree')}, by using ${isc.DocUtils.linkForRef('method:EditContext.makePaletteNode')} on the\n passed <code>EditNode</code> and its descendents within the\n ${isc.DocUtils.linkForRef('method:EditContext.getEditNodeTree','editNodeTree')}.\n <p>\n The root node of the returned ${isc.DocUtils.linkForRef('class:Tree')} will be a PaletteNode derived from the passed\n <code>EditNode</code>.\n\n",flags:"",returns:{type:"Tree",description:"a Tree of paletteNodes or null"},name:"makePaletteNodeTree"},"type:ValidatorType":{seeAlso:[],ref:"type:ValidatorType",deprecated:null,type:"type",values:[{value:"isBoolean",description:"Validation will fail if this field is non-empty and has a non-boolean value."},{value:"isString",description:"Validation will fail if the value is not a string value."},{value:"isInteger",description:"Tests whether the value for this field is a whole number.  If \n <code>validator.convertToInteger</code> is true, float values will be converted \n into integers and validation will succeed."},{value:"isFloat",description:"Tests whether the value for this field is a valid floating point number."},{value:"isFunction",description:"Tests whether the value for this field is a valid expression or function; if it is\n valid, creates a ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')} object with the value\n and set the resultingValue to the StringMethod."},{value:"requiredIf",description:"RequiredIf type validators should be specified with an <code>expression</code>\n property set to a ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')}, which takes four\n parameters:<ul>\n <li>item - the DynamicForm item on which the error occurred (may be null)\n <li>validator - a pointer to the validator object\n <li>value - the value of the field in question\n <li>record - the \"record\" object - the set of values being edited by the widget\n </ul>\n When validation is performed, the expression will be evaluated (or executed). If it\n returns <code>true</code>, the field will be treated as a required field, so validation\n will fail if the field has no value, or, in the case of a ${isc.DocUtils.linkForRef('class:FileItem')} or ${isc.DocUtils.linkForRef('class:UploadItem')}\n and if client-side validation is supported by the browser, if no file is selected for upload\n or the selected file is empty.\n <p>To allow server-side enforcement, a <code>required</code> validator can be used instead.\n With the exception of \"binary\" fields, conditional criteria can be specified with the\n ${isc.DocUtils.linkForRef('attr:Validator.applyWhen','applyWhen')} property.\n <p>See ${isc.DocUtils.linkForExampleId('conditionallyRequired')}.\n <p>\n \n <p><strong>NOTE:</strong> A requiredIf validator cannot be used to guarantee that a non-empty\n file is uploaded. The user's browser might not support client-side file validation.\n Using a requiredIf validator on a \"binary\" field may be appropriate in scenarios where the\n application does not technically require a non-empty file to be uploaded by the user.\n For example, in a bug tracking application, a file upload may be required if the\n \"Have a test case?\" checkbox is checked, but the value of the \"Have a test case?\" checkbox is\n not actually saved by the application; instead, whether the user is providing a test case is\n inferred by whether a non-empty test case file was uploaded."},{value:"matchesField",description:"Tests whether the value for this field matches the value of some other field.\n The field to compare against is specified via the <code>otherField</code> property\n on the validator object (should be set to a field name).\n <p>See ${isc.DocUtils.linkForExampleId('matchValue')}."},{value:"equals",description:"Tests whether the value for this field matches some value specified via\n <code>value</code>."},{value:"notEqual",description:"Tests whether the value for this field does not match some value specified via\n <code>value</code>."},{value:"isOneOf",description:"Tests whether the value for this field matches any value from an arbitrary\n list of acceptable values.  The set of acceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. If validator.list is not supplied, the valueMap for the field will be used.\n If there is no valueMap, not providing validator.list is an error."},{value:"inSet",description:"Tests whether the value for this field matches any value from an arbitrary\n list of acceptable values.  The set of acceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. If validator.list is not supplied, the valueMap for the field will be used.\n If there is no valueMap, not providing validator.list is an error."},{value:"notInSet",description:"Tests whether the value for this field does not match any value from an arbitrary\n list of unacceptable values.  The set of unacceptable values is specified via\n the <code>list</code> property on the validator, which should be set to an array of\n values. Not providing validator.list is an error."},{value:"integerRange",description:"Tests whether the value for this field is a whole number within the range \n specified.  The <code>max</code> and <code>min</code> properties on the validator\n are used to determine the acceptable range, inclusive. To specify the range as\n exclusive of the min/mix values, set <code>exclusive</code> to <code>true</code>.\n <p>See ${isc.DocUtils.linkForExampleId('validationBuiltins')}."},{value:"lengthRange",description:"This validator type applies to string values only.  If the value is a string value\n validation will fail if the string's length falls outside the range specified by \n <code>validator.max</code> and <code>validator.min</code>.\n <p>\n Note that non-string values will always pass validation by this validator type.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>."},{value:"contains",description:"Determine whether a string value contains some substring specified via \n <code>validator.substring</code>."},{value:"doesntContain",description:"Determine whether a string value does <b>not</b> contain some substring specified via \n <code>validator.substring</code>."},{value:"substringCount",description:"Determine whether a string value contains some substring multiple times.\n The substring to check for is specified via <code>validator.substring</code>.\n The <code>validator.operator</code> property allows you to specify how to test\n the number of substring occurrences. Valid values for this property are\n <code>==</code>, <code>!=</code>, <code>&lt;</code>, <code>&lt;=</code>,\n <code>&gt;</code>, <code>&gt;=</code>.\n <p>\n The number of matches to check for is specified via <code>validator.count</code>."},{value:"regexp",description:"<code>regexp</code> type validators will determine whether the value specified \n matches a given regular expression.  The expression should be specified on the\n <code>validator</code> object as the <code>expression</code> property.\n <p>See ${isc.DocUtils.linkForExampleId('formsRegularExpression')}."},{value:"mask",description:"Validate against a regular expression mask, specified as <code>validator.mask</code>.\n If validation is successful a transformation can also be specified via the\n <code>validator.transformTo</code> property. This should be set to a string in the\n standard format for string replacement via the native JavaScript <code>replace()</code>\n method.\n <p>See ${isc.DocUtils.linkForExampleId('formsValueTransform')}."},{value:"dateRange",description:'Tests whether the value for a date field is within the range specified.\n Range is inclusive, and is specified via <code>validator.min</code> and\n <code>validator.max</code>, which should be specified in\n <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema\n date format</a> or as a live JavaScript Date object (for client-only validators only).\n To specify the range as exclusive of the min/mix values, set <code>exclusive</code>\n to <code>true</code>.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.'},{value:"floatLimit",description:'Validate a field as a valid floating point value within a value range.\n Range is specified via <code>validator.min</code> and <code>validator.max</code>.\n Also checks precision, specified as number of decimal places in \n <code>validator.precision</code>. If <code>validator.roundToPrecision</code> is set \n a value that doesn\'t match the specified number of decimal places will be rounded\n to the nearest value that does.        \n <p>\n For backwards compatibility only. Use "floatRange" and/or "floatPrecision" instead.'},{value:"floatRange",description:"Tests whether the value for this field is a floating point number within the range \n specified.  The <code>max</code> and <code>min</code> properties on the validator\n are used to determine the acceptable range, inclusive. To specify the range as\n exclusive of the min/mix values, set <code>exclusive</code> to <code>true</code>.\n <p>\n Note that the <code>errorMessage</code> for this validator will be evaluated as\n a dynamicString - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>."},{value:"floatPrecision",description:"Tests whether the value for this field is a floating point number with the \n appropriate number of decimal places - specified in <code>validator.precision</code>\n If the value is of higher precision and <code>validator.roundToPrecision</code> \n is specified, the value will be rounded to the specified number of decimal places\n and validation will pass, otherwise validation will fail."},{value:"required",description:'A non-empty value is required for this field to pass validation.\n <p>In the case of a "binary" field, a non-empty file must be uploaded.'},{value:"isUnique",description:"Returns true if the value for this field is unique.  The uniqueness check is performed across\n the whole DataSource unless you specify property <code>validator.criteriaFields</code> as a \n comma-separated string of field names; in that case, the uniqueness check is done in the \n context of those extra criteria, allowing you to check, for example, whether an employee \n number is unique for the department and location found on the record being validated.\n By default the uniqueness check is not case sensitive but this can be controlled through\n the ${isc.DocUtils.linkForRef('attr:Validator.caseSensitive','caseSensitive')} attribute.  You can specify the \n ${isc.DocUtils.linkForRef('attr:DataSource.operationBindings','operation')} to use for the uniqueness check with the \n ${isc.DocUtils.linkForRef('attr:Validator.operationId','operationId')} attribute.\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client, unless all of the following are true:\n <ul>\n   <li> The validation is run in the context of a DataBoundComponent or ValuesManager\n        bound to some DataSource.\n   <li> The DataSource is either clientOnly:true or cacheAllData: true and all data is loaded\n   <li> The item is made available to the validator.  Note that the item is not be available\n        during a save performed without a form (eg programmatic save), or if the field is\n        not available in the form.\n </ul>\n <p>\n Note when isUnique validator is executed as part of validation process during update \n operation, it will perform uniqueness check only for single row updates. If update targets \n ${isc.DocUtils.linkForRef('attr:OperationBinding.allowMultiUpdate','multiple records')}, then isUnique validator will \n be skipped. If uniqueness check is needed when updating multiple records, consider using \n ${isc.DocUtils.linkForRef('group:dmiOverview','custom DMI')} approach to add this check manually.\n <p>See ${isc.DocUtils.linkForExampleId('uniqueCheckValidation')}."},{value:"hasRelatedRecord",description:"Returns true if the record implied by a relation exists.  The relation can be \n derived automatically from the ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey')} attribute of \n the field being validated, or you can specify it manually via \n <code>validator.relatedDataSource</code> and <code>validator.relatedField</code>.\n <p>\n You can specify at DataSource level that this validator should be automatically \n applied to all fields that specify a ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} -\n see ${isc.DocUtils.linkForRef('attr:DataSource.validateRelatedRecords')}.\n <p>\n By default the uniqueness check is not case sensitive but this can be controlled through\n the ${isc.DocUtils.linkForRef('attr:Validator.caseSensitive','caseSensitive')} attribute.\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client.\n <p>\n Note that this validation is generally unnecessary for data coming from a UI.  The \n typical UI uses a ${isc.DocUtils.linkForRef('class:SelectItem')} or ${isc.DocUtils.linkForRef('class:ComboBoxItem')} with an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')} for user entry, such that the user \n can't accidentally enter a related record if that doesn't exist, and a typical SQL \n schema will include constraints that prevent a bad insert if the user attempts to \n circumvent the UI.  The primary purpose of declaring this validation explicitly is \n to provide clear, friendly error messages for use cases such as ${isc.DocUtils.linkForRef('class:BatchUploader')}, \n where values aren't individually chosen by the user. See also the example\n ${isc.DocUtils.linkForExampleId('hasRelatedValidation', 'Related Records')}."},{value:"maxFileSize",description:"This validator type is not for direct usage, instead ${isc.DocUtils.linkForRef('attr:DataSourceField.maxFileSize')} can \n be set and <code>maxFileSize</code> validator will be added automatically. Use \n ${isc.DocUtils.linkForRef('classAttr:DataSource.maxFileSizeExceededMessage')} to customize validation error message.\n <p>\n In supported browsers (Internet Explorer 10+, Chrome, Firefox, Safari 6+, Opera 11.1+), returns\n <code>true</code> if the file(s) selected by the user are not larger than the field's\n ${isc.DocUtils.linkForRef('attr:DataSourceField.maxFileSize')}. If not supported by the browser, the validator will always\n return <code>true</code>.\n <p>\n Note that server-side enforcement of the <code>maxFileSize</code> is always required because\n the user's browser might not support client-side file size checks. Also, any client-side\n check can be bypassed by a malicious user."},{value:"custom",description:"Custom client-side validator.  \n ${isc.DocUtils.linkForRef('attr:Validator.condition')} will be called to verify data.\n "},{value:"serverCustom",description:"Custom server-side validator that either evaluates the Velocity expression provided in \n ${isc.DocUtils.linkForRef('attr:Validator.serverCondition','serverCondition')} (see ${isc.DocUtils.linkForExampleId('velocityValidation')})\n or makes DMI call to ${isc.DocUtils.linkForRef('attr:Validator.serverObject','serverObject')} to evaluate condition\n (see ${isc.DocUtils.linkForExampleId('dmiValidation')}).\n <p>\n Validators of this type have ${isc.DocUtils.linkForRef('attr:ValidatorDefinition.requiresServer','requiresServer')} \n set to <code>true</code> and do not run on the client."}],description:"Used to name a validator or reference a standard, built-in ${isc.DocUtils.linkForRef('class:Validator')} - see list below.\n <p>\n To make use of a standard validator type for a field in a DataSource, or \n DynamicForm instance, specify the <code>validators</code> property to an array \n containing a validator definition where the <code>type</code> property is set to \n the appropriate type.  \n <p>\n A custom error message can be specified for any validator type by setting the\n <code>errorMessage</code> property on the validator definition object, and some\n validator types make use of additional properties on the validator definition \n object such as <code>max</code> or <code>min</code>.\n <p>\n For example, to use the <code>integerRange</code> validator type:<br><br><code>\n &nbsp;&nbsp;field:{<br>\n &nbsp;&nbsp;&nbsp;&nbsp;validators:[<br>\n &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{type:\"integerRange\", min:1, max:100}<br>\n &nbsp;&nbsp;&nbsp;&nbsp;]<br>\n &nbsp;&nbsp;}\n </code>\n <p>\n Custom validators can be reused on the client by adding them to the global validator list,\n via the ${isc.DocUtils.linkForRef('classMethod:Validator.addValidatorDefinition')} method.",name:"ValidatorType"},"attr:Canvas.proportionalResizing":{seeAlso:[{ref:"attr:Canvas.proportionalResizeModifiers",description:null}],defaultValue:'"none"',type:"attr",definingClass:"class:Canvas",groups:["dragdrop"],deprecated:null,ref:"attr:Canvas.proportionalResizing",valueType:"ProportionalResizeMode",description:"If ${isc.DocUtils.linkForRef('attr:Canvas.canDragResize')} is true, this property specifies the conditions for when\n proportional resizing is used.  The default is \"none\"\n \n , which means that proportional resizing is disabled.",flags:"IR",name:"proportionalResizing"},"attr:ResultSet.initialData":{seeAlso:[{ref:"attr:ResultSet.fetchMode",description:null},{ref:"attr:ResultSet.useClientFiltering",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ResultSet",groups:["fetching","cacheSync"],deprecated:null,ref:"attr:ResultSet.initialData",valueType:"Array of Record",description:"Initial set of data for the ResultSet.\n <P>\n This data will be treated exactly as though it were the data returned from the\n ResultSet's first server fetch.\n <P>\n By default, <code>initialData</code> will be considered a complete response\n (all rows that match the ${isc.DocUtils.linkForRef('type:Criteria')} which the ResultSet was initialized with).\n <P>\n Set ${isc.DocUtils.linkForRef('attr:ResultSet.initialLength')} to treat <code>initialData</code> as a partial response,\n equivalent to receiving a ${isc.DocUtils.linkForRef('class:DSResponse')} with <code>startRow:0</code>,\n <code>endRow:initialData.length</code> and <code>totalRows:initialLength</code>.\n Normal data paging will then occur if data is requested for row indices not filled via \n <code>initialData</code>.\n <P>\n <code>initialData</code> may be provided as a \"sparse\" array, that is, slots may be left\n null indicating rows that have not been loaded.  In this way you can create a ResultSet\n that is missing rows at the beginning of the dataset, but has loaded rows toward the end,\n so that you can create a component that is scrolled to a particular position of a dataset\n without loading rows at the beginning.\n <P>\n To keep the logic simple and support partial <code>initialData</code>, the data is\n assumed to be already sorted and filtered according to the ${isc.DocUtils.linkForRef('attr:ResultSet.sortSpecifiers')} and\n ${isc.DocUtils.linkForRef('attr:ResultSet.criteria')} supplied to the ResultSet, since otherwise, for partial\n <code>initialData</code>, sorting or filtering would immediately cause the data to be\n discarded.\n <P>\n If <code>initialData</code> is complete and needs to be sorted or filtered, then don't\n pass the ${isc.DocUtils.linkForRef('attr:ResultSet.sortSpecifiers')} or ${isc.DocUtils.linkForRef('attr:ResultSet.criteria')}, respectively, when creating\n the ResultSet.  Instead, call ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria')} or ${isc.DocUtils.linkForRef('method:ResultSet.setSort')}, respectively, on\n the instance afterwards.",flags:"IA",name:"initialData"},"attr:ListGrid.rangeRowCountFormat":{seeAlso:[],defaultValue:'"${minRowCount}-${maxRowCount}"',type:"attr",definingClass:"class:ListGrid",groups:["rowRangeDisplay"],deprecated:null,ref:"attr:ListGrid.rangeRowCountFormat",valueType:"String",description:"Format for the string returned from ${isc.DocUtils.linkForRef('method:ListGrid.getFormattedRowCount')} when\n ${isc.DocUtils.linkForRef('method:ListGrid.getRowCountStatus','row count status')} is <code>\"range\"</code>.\n <P>\n The following variables are available for evaluation within this string:\n <ul><li><code>minRowCount</code>: the lower bound of this row count value\n         from ${isc.DocUtils.linkForRef('method:ListGrid.getRowCountRange','getRowCountRange()[0]')},\n         as a ${isc.DocUtils.linkForRef('classMethod:NumberUtil.toLocalizedString','locale-formatted number')}.</li>\n     <li><code>minRowCount</code>: the upper bound of this row count value\n         from ${isc.DocUtils.linkForRef('method:ListGrid.getRowCountRange','getRowCountRange()[1]')},\n         as a ${isc.DocUtils.linkForRef('classMethod:NumberUtil.toLocalizedString','locale-formatted number')}.</li></ul>",flags:"IRW",name:"rangeRowCountFormat"},"attr:SpacerItem.showTitle":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:SpacerItem",groups:["appearance"],deprecated:null,ref:"attr:SpacerItem.showTitle",valueType:"Boolean",description:"we never show a separate title cell for spacers",flags:"IRW",name:"showTitle"},"type:TEXTAREA_WRAP":{seeAlso:[],ref:"type:TEXTAREA_WRAP",deprecated:null,type:"type",values:[{value:"TextAreaItem.OFF",description:"don't allow wrapping at all"},{value:"TextAreaItem.SOFT",description:"when the entered text reaches the edge of the text area,                                  wrap visibly but don't include line breaks in the textarea\n                                  value"},{value:"TextAreaItem.HARD",description:"when the entered text reaches the edge of the text area,                                   insert a line break"}],description:null,name:"TEXTAREA_WRAP"},"attr:MockDataSource.mockData":{seeAlso:[],ref:"attr:MockDataSource.mockData",defaultValue:'"md"',deprecated:null,type:"attr",definingClass:"class:MockDataSource",valueType:"String | Array of Record",description:"Data intended for a ${isc.DocUtils.linkForRef('class:ListGrid')} or ${isc.DocUtils.linkForRef('class:TreeGrid')}, expressed in a simple text\n format popularized by mockup tools such as <a href='http://balsamiq.com' target='_blank'>balsamiq</a> and now\n commonly supported in a variety of mockup tools.\n <p>\n Balsamiq publishes documentation of the grid format \n <a href='https://docs.balsamiq.com/cloud/editing-controls/#the-data-grid-table-control' target='_blank'>here</a>,\n with a simple example of using tree-specific formatting\n <a href='https://docs.balsamiq.com/cloud/editing-controls/#the-tree-pane' target='_blank'>here</a>.\n <p>\n MockData can also be provided as XML, CSV or JSON text by setting ${isc.DocUtils.linkForRef('type:MockDataFormat')} to\n the correct format.\n <p>\n An alternative format of data consisting of an array of ${isc.DocUtils.linkForRef('object:Record','Records')} can\n also be provided. In this case the records are converted to \"grid\" ${isc.DocUtils.linkForRef('type:MockDataType','format')}.",flags:"IR",name:"mockData"},"attr:Canvas.autoShowParent":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:Canvas",groups:["appearance"],deprecated:null,ref:"attr:Canvas.autoShowParent",valueType:"Boolean",description:"If set to true, the widget's parent (if any) will automatically be shown whenever the\n      widget is shown.",flags:"IRWA",name:"autoShowParent"},"method:Process.setTaskOutput":{seeAlso:[],ref:"method:Process.setTaskOutput",deprecated:null,type:"method",definingClass:"class:Process",params:[{defaultValue:null,optional:false,type:"ProcessElement",description:"the workflow task setting the output (i.e. this)",name:"task"},{defaultValue:null,optional:false,type:"Any",description:"the output value for task",name:"value"}],description:" Sets the task output of <code>task</code> in the ${isc.DocUtils.linkForRef('type:State','process state')} so it\n can be used by later tasks with ${isc.DocUtils.linkForRef('method:Process.getLastTaskOutput')} or more commonly with a\n ${isc.DocUtils.linkForRef('type:TaskInputExpression')} property.\n <p>\n If the task sets <code>bindOutput</code> the output value is also written into that\n ${isc.DocUtils.linkForRef('attr:Process.state','process state')} variable.\n\n",flags:"",name:"setTaskOutput"},"attr:HiliteRule.hiliteForm":{seeAlso:[],ref:"attr:HiliteRule.hiliteForm",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:HiliteRule",valueType:"AutoChild DynamicForm",description:"AutoChild ${isc.DocUtils.linkForRef('class:DynamicForm')} displaying the ${isc.DocUtils.linkForRef('class:FormItem','formItems')} used to \n specify the hiliting properties of this rule.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>hiliteRule.hiliteFormProperties</code>.",flags:"IR",name:"hiliteForm"},"method:ValuesManager.isNewRecord":{seeAlso:[],ref:"method:ValuesManager.isNewRecord",deprecated:null,type:"method",definingClass:"class:ValuesManager",description:" Returns true if ${isc.DocUtils.linkForRef('attr:ValuesManager.saveOperationType')} is currently \"add\".  See\n ${isc.DocUtils.linkForRef('attr:ValuesManager.saveOperationType')}.\n\n",flags:"",returns:{type:"Boolean",description:'whether this form will use an "add" operation when saving'},name:"isNewRecord"},"attr:TreeGrid.customIconDropProperty":{seeAlso:[{ref:"attr:TreeGrid.customIconProperty",description:null},{ref:"attr:TreeGrid.showCustomIconDrop",description:null}],defaultValue:'"showDropIcon"',type:"attr",definingClass:"class:TreeGrid",groups:["treeIcons"],deprecated:null,ref:"attr:TreeGrid.customIconDropProperty",valueType:"String",description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.showDropIcon','default node.showDropIcon')} property.",flags:"IRWA",name:"customIconDropProperty"},"staticMethod:Date.setFirstDayOfWeek":{seeAlso:[],ref:"staticMethod:Date.setFirstDayOfWeek",deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.setFirstDayOfWeek')}.",type:"staticMethod",definingClass:"object:Date",params:[{defaultValue:null,optional:false,type:"int",description:"the number of the day to use as the first day of the week",name:"firstDayOfWeek"}],description:" Sets the global attribute that dictates which day should be treated as the first day of the\n week in calendars and date calculations.  The parameter is expected to be an integer value \n between 0 (Sunday) and 6 (Saturday).\n <P>\n The default value is picked up from the current locale.\n\n",flags:"",name:"setFirstDayOfWeek"},"attr:DateItem.monthSelector":{seeAlso:[{ref:"attr:DateItem.selectorFormat",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DateItem",groups:["dateItemAppearance"],deprecated:null,ref:"attr:DateItem.monthSelector",valueType:"AutoChild SelectItem",description:"${isc.DocUtils.linkForRef('class:SelectItem')} for picking a month.\n <P>\n To control which selectors are visible and in what order, use ${isc.DocUtils.linkForRef('attr:DateItem.selectorFormat')}.",flags:"R",name:"monthSelector"},"attr:ComboBoxItem.pendingTextBoxStyle":{seeAlso:[],ref:"attr:ComboBoxItem.pendingTextBoxStyle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ComboBoxItem",valueType:"CSSStyleName",description:"Optional \"pending\" style for this item's text box.\n <P>\n If ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} is false, when the user modifies the\n value displayed in the combobox item text box, the underlying data value (as returned\n from item.getValue()) is not immediately updated - instead the value is used to filter\n the set of results displayed in the comboBoxItem pickList.\n <P>\n While the comboBoxItem is in this pending state (where the result of getEnteredValue() will\n not necessarily match the display value for whatever is returned by getValue()), the \n pendingTextBoxStyle may be applied to the text box for the item.\n <P>\n When the element value is updated to display the actual value for the item (typically due\n to the user selecting a value from the pickList), the standard \n ${isc.DocUtils.linkForRef('attr:TextItem.textBoxStyle')} will be reapplied.\n <P>\n May be left unset in which case the standard text box style is always applied.\n Has no effect if ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} is true.",flags:"IRW",name:"pendingTextBoxStyle"},"attr:TimeItem.ampmItem":{seeAlso:[],ref:"attr:TimeItem.ampmItem",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"AutoChild SelectItem",description:"Select item to hold the AM/PM value for the timeItem when \n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.",flags:"R",name:"ampmItem"},"attr:SavedSearchItem.hint":{seeAlso:[],defaultValue:'"Saved views..."',type:"attr",definingClass:"class:SavedSearchItem",groups:["i18nMessages"],deprecated:null,ref:"attr:SavedSearchItem.hint",valueType:"String",description:"Text shown inside the field that serves as an indicator of what this field is for.",flags:"IR",name:"hint"},"method:FormItem.setIconShowOnFocus":{groups:["formIcons"],seeAlso:[],ref:"method:FormItem.setIconShowOnFocus",deprecated:null,type:"method",definingClass:"class:FormItem",params:[{defaultValue:null,optional:false,type:"Identifier",description:"${isc.DocUtils.linkForRef('attr:FormItemIcon.name','name')} of the icon to update",name:"icon"},{defaultValue:null,optional:false,type:"Boolean",description:"new value of ${isc.DocUtils.linkForRef('attr:FormItemIcon.showOnFocus')}",name:"showOnFocus"}],description:" Sets ${isc.DocUtils.linkForRef('attr:FormItemIcon.showOnFocus')} for the supplied icon, and causes that icon's\n visibility to be updated and the item redrawn as appropriate.\n\n",flags:"",name:"setIconShowOnFocus"},"attr:ImgButton.iconWidth":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ImgButton",groups:["buttonIcon"],deprecated:null,ref:"attr:ImgButton.iconWidth",valueType:"Integer",description:"Width in pixels of the icon image.\n <P>\n If unset, defaults to ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconSize','iconSize')}.",flags:"IR",name:"iconWidth"},"method:ListGrid.getFormattedValue":{seeAlso:[{ref:"method:ListGrid.getDefaultFormattedValue",description:null},{ref:"method:ListGrid.getDefaultFormattedFieldValue",description:null}],ref:"method:ListGrid.getFormattedValue",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"Record",description:"the record containing the value to format",name:"record"},{defaultValue:null,optional:false,type:"String",description:"the name of the field to format",name:"fieldName"},{defaultValue:null,optional:true,type:"Any",description:"the value to format. If not provided, the value will be extracted                   from the record",name:"value"}],description:" Get the fully formatted value for a cell in this grid, including all custom formatters.\n <P>\n This method applies the complete formatting pipeline that would be used when rendering\n a cell in the grid, including:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:ListGridField.valueMap')} mapping</li>\n <li>${isc.DocUtils.linkForRef('attr:ListGridField.displayField')} substitution</li>\n <li>Custom ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue')} or ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue')}\n     methods</li>\n <li>${isc.DocUtils.linkForRef('attr:ListGridField.format')} application</li>\n <li>Type-specific formatters</li>\n <li>Final string formatting and HTML escaping</li>\n </ul>\n This method is useful when you want to display a grid cell's value elsewhere in your UI\n with the exact same formatting that appears in the grid itself.\n <P>\n Unlike ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')}, this method <i>will</i> call any custom\n formatter methods that have been defined on the field or grid, so it returns the complete\n formatted value exactly as it would appear in the grid.\n <P>\n For other use cases, see also:\n <ul>\n <li>${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedValue')} - get formatted value without any custom formatters</li>\n <li>${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFormattedFieldValue')} - get formatted value with field-level formatters only</li>\n </ul>\n\n",flags:"",returns:{type:"String",description:"the fully formatted cell value"},name:"getFormattedValue"},"object:AnimateShowEffect":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:AnimateShowEffect.effect","attr:AnimateShowEffect.startFrom","attr:AnimateShowEffect.endAt","attr:AnimateShowEffect.endsAt"],ref:"object:AnimateShowEffect",deprecated:null,treeLocation:["Client Reference/System"],description:"Configuration object for effect to apply during an animated show or hide.",methods:[],name:"AnimateShowEffect"},"attr:ListGrid.rowSpanSelectionMode":{seeAlso:[],ref:"attr:ListGrid.rowSpanSelectionMode",defaultValue:'"forward"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"RowSpanSelectionMode",description:"Chooses the selection mode when ${isc.DocUtils.linkForRef('attr:ListGrid.useRowSpanStyling')} is enabled.  See\n ${isc.DocUtils.linkForRef('type:RowSpanSelectionMode')}.",flags:"IR",name:"rowSpanSelectionMode"},"attr:EventCanvas.showContextButton":{seeAlso:[],ref:"attr:EventCanvas.showContextButton",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:EventCanvas",valueType:"Boolean",description:"When set to true, shows a ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','small icon')} in the \n top corner of an EventCanvas, beside the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','close-icon')}.  When clicked, shows a \n ${isc.DocUtils.linkForRef('method:Calendar.getEventCanvasMenuItems','context menu')} containing items applicable to \n this canvas.",flags:"IRW",name:"showContextButton"},"method:Sound.setSrc":{seeAlso:[],ref:"method:Sound.setSrc",deprecated:null,type:"method",definingClass:"class:Sound",params:[{defaultValue:null,optional:false,type:"String | Array of String",description:"URL of new audio file to be played by this sound instance.",name:"src"}],description:" Update the ${isc.DocUtils.linkForRef('attr:Sound.src')} of this sound instance at runtime. Note that \n ${isc.DocUtils.linkForRef('attr:Sound.autoLoad')} and ${isc.DocUtils.linkForRef('attr:Sound.autoPlay')} govern whether this media will\n be loaded or played immediately when the src value is changed.\n",flags:"",name:"setSrc"},"class:EdgedCanvas":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Canvas",classMethods:[],classAttrs:[],attrs:["attr:EdgedCanvas.skinImgDir","attr:EdgedCanvas.edgeImage","attr:EdgedCanvas.edgeColor","attr:EdgedCanvas.customEdges","attr:EdgedCanvas.showCenter","attr:EdgedCanvas.edgeSize","attr:EdgedCanvas.edgeLeft","attr:EdgedCanvas.edgeRight","attr:EdgedCanvas.edgeTop","attr:EdgedCanvas.edgeBottom","attr:EdgedCanvas.edgeOffset","attr:EdgedCanvas.edgeOffsetTop","attr:EdgedCanvas.edgeOffsetBottom","attr:EdgedCanvas.edgeOffsetLeft","attr:EdgedCanvas.edgeOffsetRight","attr:EdgedCanvas.centerBackgroundColor","attr:EdgedCanvas.edgeStyleName","attr:EdgedCanvas.addEdgeStyleSuffix"],groups:["imageEdges"],ref:"class:EdgedCanvas",deprecated:null,treeLocation:["Client Reference/Foundation"],description:"EdgedCanvas acts as a decorative, image-based frame around another single Canvas.",methods:[],name:"EdgedCanvas"},"staticMethod:Date.setFiscalCalendar":{seeAlso:[],ref:"staticMethod:Date.setFiscalCalendar",deprecated:"Use ${isc.DocUtils.linkForRef('classMethod:DateUtil.setFiscalCalendar')}.",type:"staticMethod",definingClass:"object:Date",params:[{defaultValue:null,optional:false,type:"FiscalCalendar",description:"the object representing the start month and date of           the fiscal year in the current locale",name:"fiscalCalendar"}],description:" Sets the global fiscal calendar, which is used for all calls to\n getFiscalYear() / getFiscalWeek() if those methods aren't passed a fiscalCalander.\n\n",flags:"",name:"setFiscalCalendar"},"attr:Menu.target":{seeAlso:[],ref:"attr:Menu.target",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Menu",valueType:"Canvas",description:"Optional target canvas for this menu.  Available as a parameter to dynamic menuItem configuration\n methods such as ${isc.DocUtils.linkForRef('method:MenuItem.checkIf')}.\n <P>\n Whenever a Menu is shown as a contextMenu by a widget due to ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu')}\n being set, <code>menu.target</code> is automatically set to the widget that showed the\n contextMenu.\n <P>\n If this item has any ${isc.DocUtils.linkForRef('attr:MenuItem.submenu','submenus')} the <code>target</code> will be propagated down\n to these child menus.",flags:"IRW",name:"target"},"method:DrawPane.getDrawingX":{seeAlso:[],ref:"method:DrawPane.getDrawingX",deprecated:null,type:"method",definingClass:"class:DrawPane",description:" Returns the X coordinate in the ${isc.DocUtils.linkForRef('class:DrawPane','drawing coordinate system')} of the last event.\n Note: If you need both the X and Y coordinates in the drawing coordinate system of the last event,\n it is more efficient to call ${isc.DocUtils.linkForRef('method:DrawPane.getDrawingPoint','getDrawingPoint()')} instead.\n <p>\n See the documentation of ${isc.DocUtils.linkForRef('method:DrawPane.getDrawingPoint','getDrawingPoint()')} for a clarifying\n example.\n",flags:"A",returns:{type:"int",description:"X coordinate in the drawing coordinate system of the last event."},name:"getDrawingX"},"attr:EventStreamEvent.deltaX":{seeAlso:[{ref:"attr:EventStreamEvent.deltaY",description:null}],ref:"attr:EventStreamEvent.deltaX",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:EventStreamEvent",valueType:"float",description:"The ${isc.DocUtils.linkForRef('classMethod:EventHandler.getWheelDeltaX','horizontal scroll delta')}, present for\n ${isc.DocUtils.linkForRef('attr:EventStream.captureWheelEvents','wheel events')}.",flags:"R",name:"deltaX"},"classAttr:DrawLabel.defaultSerifFont":{seeAlso:[],ref:"classAttr:DrawLabel.defaultSerifFont",defaultValue:'"Times"',deprecated:null,type:"classAttr",definingClass:"class:DrawLabel",valueType:"String",description:"This setting exists due to platform limitations in some versions of Internet Explorer\n where the browser does not recognize the five generic font families\n (<code>cursive</code>, <code>fantasy</code>, <code>monospace</code>,\n <code>sans-serif</code>, and <code>serif</code>) and instead uses a non-configurable,\n default font.  This setting specifies a specific font to replace the\n <code>serif</code> keyword should a DrawLabel list it in its\n ${isc.DocUtils.linkForRef('attr:DrawLabel.fontFamily','font family')}.",flags:"IRW",name:"defaultSerifFont"},"attr:DateChooser.navigationButtonHeight":{seeAlso:[],ref:"attr:DateChooser.navigationButtonHeight",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DateChooser",valueType:"Integer",description:"Height of buttons in the ${isc.DocUtils.linkForRef('attr:DateChooser.navigationLayout','navigation area')},  \n used for navigating the ${isc.DocUtils.linkForRef('attr:DateChooser.dateGrid','calendar view')}.  If unset, the \n default, buttons are sized by settings applied by the current skin.\n <p>\n If this attribute is set to a value greater than ${isc.DocUtils.linkForRef('attr:DateChooser.navigationLayoutHeight')}, it will  \n cause the layout to expand to match the button height.",flags:"IR",name:"navigationButtonHeight"},"attr:PrintWindow.printButtonTitle":{seeAlso:[],defaultValue:'"Print"',type:"attr",definingClass:"class:PrintWindow",deprecated:null,ref:"attr:PrintWindow.printButtonTitle",setter:["setPrintButtonTitle"],valueType:"String",description:"Title for the print button",flags:"IRW",name:"printButtonTitle"},"attr:AdaptiveMenu.partialInlining":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:AdaptiveMenu",deprecated:null,ref:"attr:AdaptiveMenu.partialInlining",setter:["setPartialInlining"],valueType:"boolean",description:"If there is not enough space to show the full set of items as buttons inline, how\n should the Adaptive menu behave?<br>\n If <code>showPartialInlining</code> is true, the menu will render as many items as\n inline buttons as can be shown in the available space, plus the menu button to \n access the remaining items.<br>\n If false, it will show just the menu button.\n <P>\n If there is enough space to show the full set of items inline they will be shown\n inline regardless of this property.",flags:"IRW",name:"partialInlining"},"attr:ResultSet.reapplyUnchangedLocalFilter":{seeAlso:[{ref:"method:ResultSet.willFetchData",description:null}],ref:"attr:ResultSet.reapplyUnchangedLocalFilter",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ResultSet",valueType:"boolean",description:"To avoid needless work, the ResultSet by default doesn't refilter the data when methods such\n as ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} or ${isc.DocUtils.linkForRef('method:ListGrid.filterData')} are called with unchanged\n criteria.  However, this property can be set true for backward compatibility to force\n refiltering if we're ${isc.DocUtils.linkForRef('method:ResultSet.filterLocalData','filtering locally')} and the criteria haven't\n changed. but are narrower than the criteria used to fetch the current cache.\n <P>\n Going forward, we may deprecate this property, so you should move to approach that\n doesn't require such notification in the case of unchanged criteria.",flags:"IRWA",name:"reapplyUnchangedLocalFilter"},"attr:FileDropZone.audioFileIcon":{seeAlso:[],ref:"attr:FileDropZone.audioFileIcon",defaultValue:'"[SKINIMG]FileDropZone/audio.png"',deprecated:null,type:"attr",definingClass:"class:FileDropZone",valueType:"SCImgURL",description:"Icon for audio files.",flags:"IR",name:"audioFileIcon"},"attr:Mail.messageTemplate":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Mail",groups:["mail"],ref:"attr:Mail.messageTemplate",deprecated:null,valueType:"VelocityExpression",description:"The text that will form the body of the mail message.  Like all other <code>String</code> \n properties of <code>Mail</code>, you can use Velocity substitution variables in this property.\n <p>\n You must specify either this property or ${isc.DocUtils.linkForRef('attr:Mail.templateFile','templateFile')}, but clearly\n it makes no sense to specify them both.",flags:"IR",serverDS:"only",name:"messageTemplate"},"classAttr:FieldPickerField.alignTitle":{seeAlso:[],defaultValue:'"Header Text Alignment"',type:"classAttr",definingClass:"class:FieldPickerField",groups:["i18nMessages"],deprecated:null,ref:"classAttr:FieldPickerField.alignTitle",valueType:"String",description:"The title displayed for the align property",flags:"IR",name:"alignTitle"},"method:Calendar.getWorkdayEnd":{seeAlso:[],ref:"method:Calendar.getWorkdayEnd",deprecated:null,type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"Date",description:"a Date instance",name:"date"},{defaultValue:null,optional:true,type:"String",description:"the name of the relevant lane - only passed for dayView with                             showDayLanes: true",name:"laneName"}],description:" Returns the end of the working day on the passed date.  By default, this method returns\n the value of ${isc.DocUtils.linkForRef('attr:Calendar.workdayEnd','workdayEnd')}.\n",flags:"",returns:{type:"String",description:"any parsable time-string"},name:"getWorkdayEnd"},"attr:FilterBuilder.operatorPickerProperties":{seeAlso:[],ref:"attr:FilterBuilder.operatorPickerProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FilterBuilder",valueType:"FormItem Properties",description:"Properties to combine with the ${isc.DocUtils.linkForRef('attr:FilterBuilder.operatorPicker')} autoChild FormItem.",flags:"IR",name:"operatorPickerProperties"},"class:ScreenLoaderEditProxy":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"CanvasEditProxy",classMethods:[],classAttrs:[],attrs:[],groups:["devTools"],ref:"class:ScreenLoaderEditProxy",deprecated:null,treeLocation:["Client Reference/Tools/EditProxy"],description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:ScreenLoader')} objects when editMode is enabled.",methods:[],name:"ScreenLoaderEditProxy"},"classAttr:Operators.iEqualsTitle":{seeAlso:[],defaultValue:'"equals"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.iEqualsTitle",valueType:"String",description:'Title for the "iEquals" operator',flags:"IR",name:"iEqualsTitle"},"attr:FacetChart.valueAxisLabelProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["labelsAndTitles"],deprecated:null,ref:"attr:FacetChart.valueAxisLabelProperties",valueType:"DrawLabel Properties",description:"Properties for labels of value axis.",flags:"IRW",name:"valueAxisLabelProperties"},"method:List.indexOf":{seeAlso:[],type:"method",definingClass:"interface:List",returns:{type:"number",description:"position of the item, if found, -1 if not found"},groups:["access"],deprecated:null,ref:"method:List.indexOf",params:[{defaultValue:null,optional:false,type:"Any",description:"object to look for",name:"obj"},{defaultValue:null,optional:true,type:"number",description:"earliest index to consider",name:"pos"},{defaultValue:null,optional:true,type:"number",description:"last index to consider",name:"endPos"}],description:" Return the position in the list of the first instance of the specified object.\n <p>\n If pos is specified, starts looking after that position.\n <p>\n Returns -1 if not found.\n\n",flags:"",name:"indexOf"},"attr:AdvancedCriterionSubquery.queryOutput":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:AdvancedCriterionSubquery",groups:["advancedFilter"],ref:"attr:AdvancedCriterionSubquery.queryOutput",deprecated:null,valueType:"String",description:"The name of the field that will be used as the output of this query.  Only useful if your\n subquery returns more than one field, and optional even in that case.  See the \n ${isc.DocUtils.linkForRef('object:AdvancedCriterionSubquery','Subqueries overview')} for more details",flags:"IR",serverDS:"allowed",name:"queryOutput"},"attr:Hilite.fieldName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:Hilite",groups:["hiliting"],deprecated:null,ref:"attr:Hilite.fieldName",valueType:"FieldName | Array of FieldName",description:"Name of the field, or array of fieldNames, this hilite should be applied to.  \n <P>\n If unset, hilite is applied to every field of the record.",flags:"IR",name:"fieldName"},"attr:Slider.flipValues":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:Slider",deprecated:null,ref:"attr:Slider.flipValues",setter:["setFlipValues"],valueType:"Boolean",description:"Specifies whether the value range of the slider should be flipped so that values increase as\n the thumb is moved down (for a ${isc.DocUtils.linkForRef('attr:Slider.vertical','vertical')} slider) or to the left \n (for a horizontal slider).",flags:"IRW",name:"flipValues"},"method:ValuesManager.getValuesAsCriteria":{seeAlso:[],type:"method",definingClass:"class:ValuesManager",returns:{type:"Criteria | AdvancedCriteria",description:"a ${isc.DocUtils.linkForRef('type:Criteria')} object, or ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}"},groups:["criteriaEditing"],deprecated:null,ref:"method:ValuesManager.getValuesAsCriteria",params:[{defaultValue:null,optional:false,type:"boolean",description:"if true, return an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object even if the   form item values could be represented in a simple ${isc.DocUtils.linkForRef('object:Criterion')} object.",name:"advanced"},{defaultValue:null,optional:true,type:"TextMatchStyle",description:"This parameter may be passed to indicate whether   the criteria are to be applied to a substring match (filter) or exact match (fetch).\n   When advanced criteria are returned this parameter will cause the appropriate\n   <code>operator</code> to be generated for individual fields' criterion clauses.",name:"textMatchStyle"}],description:" Retrieves the combined ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','criteria values')} \n for all member forms.\n <P>\n As with the DynamicForm getValuesAsCriteria, this method may return\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} or simple ${isc.DocUtils.linkForRef('type:Criteria')} depending on whether\n the <code>advanced</code> parameter was passed, whether the ${isc.DocUtils.linkForRef('attr:ValuesManager.operator')}\n is set to <code>\"or\"</code> rather than <code>\"and\"</code>, and whether any member\n forms return ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.\n <P>\n Note that developers can also use ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')} to combine\n sub-criteria from various sources, including member forms of a ValuesManager, into\n a combined criteria object.\n\n",flags:"",name:"getValuesAsCriteria"},"attr:SpinnerItem.mask":{seeAlso:[],ref:"attr:SpinnerItem.mask",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SpinnerItem",valueType:"String",description:"Not applicable to a SpinnerItem.",flags:"IRWA",name:"mask"},"attr:ListGrid.escapeKeyEditAction":{seeAlso:[],defaultValue:'"cancel"',type:"attr",definingClass:"class:ListGrid",groups:["editing"],deprecated:null,ref:"attr:ListGrid.escapeKeyEditAction",valueType:"EscapeKeyEditAction",description:'What to do when a user hits escape while editing a cell:<ul>\n <li>"cancel": close the editor and discard the current set of edit values\n <li>"done": just close the editor (the edit is complete, but the edited values are retained).\n </ul>\n Note that if ${isc.DocUtils.linkForRef(\'attr:ListGrid.autoSaveEdits\')} is true, this may cause a save of the current edit values',flags:"IRW",name:"escapeKeyEditAction"},"group:creation":{refs:["method:Tree.duplicate"],seeAlso:[],ref:"group:creation",deprecated:null,type:"group",description:null,name:"creation"},"attr:MetricSettings.logScale":{seeAlso:[],ref:"attr:MetricSettings.logScale",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:MetricSettings",valueType:"Boolean",description:"Whether to use logarithmic scaling for values.\n <P>\n Logarithmic scale charts show an equivalent percentage increase as equivalent distance\n on the chart.  That is, 10 and 100 are the same distance apart as 100 and 1000 (each\n being a 10 times or 1000% increase).",flags:"IR",name:"logScale"},"method:EditContext.getRootEditNode":{seeAlso:[],ref:"method:EditContext.getRootEditNode",deprecated:null,type:"method",definingClass:"class:EditContext",description:" Returns the root ${isc.DocUtils.linkForRef('object:EditNode')} of the EditContext typically created from ${isc.DocUtils.linkForRef('attr:EditContext.rootComponent')}.\n\n",flags:"",returns:{type:"EditNode",description:"the root EditNode"},name:"getRootEditNode"},"type:AutoSelectionModel":{seeAlso:[],ref:"type:AutoSelectionModel",deprecated:null,type:"type",values:[{value:'"both"',description:"Rows and Columns will be selected on header selection"},{value:'"rows"',description:"Rows will be selected on row-header selection"},{value:'"cols"',description:"Columns will be selected on column-header selection"},{value:'"none"',description:"Selecting row or column headers will not select cells in the body."}],description:"Selection model for ${isc.DocUtils.linkForRef('class:CubeGrid')} indicating which cells in the body should\n be selected when row or column headers are selected.",name:"AutoSelectionModel"},"group:facetLayout":{refs:["method:CubeGrid.getFacetValueLayout","method:CubeGrid.getRowFacetLayout","method:CubeGrid.getColumnFacetLayout","method:CubeGrid.addRowFacet","method:CubeGrid.addColumnFacet","method:CubeGrid.removeFacet","method:CubeGrid.setFixedFacetValue","method:CubeGrid.facetValueReordered","method:CubeGrid.facetAdded","method:CubeGrid.facetRemoved","method:CubeGrid.facetMoved","attr:CubeGrid.columnFacets","attr:CubeGrid.rowFacets","attr:CubeGrid.hideEmptyFacetValues","attr:CubeGrid.hideEmptyAxis","attr:CubeGrid.canReorderColumns","attr:CubeGrid.canMoveFacets"],seeAlso:[],ref:"group:facetLayout",deprecated:null,type:"group",description:null,name:"facetLayout"},"classMethod:Page.isAddVersionToSkinCSS":{groups:["skins","files"],seeAlso:[],ref:"classMethod:Page.isAddVersionToSkinCSS",deprecated:null,type:"classMethod",definingClass:"class:Page",description:" Returns true if add version to skin CSS is currently turned on.\n\n",flags:"",returns:{type:"Boolean",description:"true == add version to skin CSS is turned on"},name:"isAddVersionToSkinCSS"},"attr:DrawItem.resizeViaLocalTransformOnly":{seeAlso:[],ref:"attr:DrawItem.resizeViaLocalTransformOnly",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:DrawItem",valueType:"boolean",description:"If this DrawItem is showing \"resize\"\n \n ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','control knobs')}, should resizing the shape solely update the local\n transform (for example, the DrawItem's ${isc.DocUtils.linkForRef('attr:DrawItem.scale','scale')} or\n ${isc.DocUtils.linkForRef('attr:DrawItem.translate','translation')})?.\n <p>\n The default is <code>false</code>, which means that the DrawItem is allowed to modify\n its shape properties in order to fit within a given width and height.  Some examples:\n <ul>\n <li>A ${isc.DocUtils.linkForRef('class:DrawOval','DrawOval')} might decrease its ${isc.DocUtils.linkForRef('attr:DrawOval.radius','radius')}\n when resized to a smaller size.</li>\n <li>A ${isc.DocUtils.linkForRef('class:DrawPath','DrawPath')} might change its ${isc.DocUtils.linkForRef('attr:DrawPath.points','points')}\n to lengthen all line segments in the path by some proportion so that it fits into a\n larger size.</li>\n </ul>\n This approach allows a DrawItem to maintain the same\n ${isc.DocUtils.linkForRef('attr:DrawItem.lineWidth','line width')} even as it is being resized.\n <p>\n If this property is set to <code>true</code> then all visual aspects of the DrawItem,\n including the line width and the fill, will be magnified or reduced during resizes\n as if the DrawItem were placed under a lens.",flags:"IR",name:"resizeViaLocalTransformOnly"},"attr:DrawItem.titleAutoFitRotationMode":{seeAlso:[{ref:"attr:DrawItem.titleLabel",description:null},{ref:"attr:DrawItem.titleAutoFit",description:null}],ref:"attr:DrawItem.titleAutoFitRotationMode",defaultValue:'"auto"',deprecated:null,type:"attr",definingClass:"class:DrawItem",valueType:"TitleAutoFitRotationMode",description:"Whether to rotate the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel')} 90 degrees clockwise while trying to maximize its\n size in accordance with ${isc.DocUtils.linkForRef('attr:DrawItem.titleAutoFit')}.  If automatic rotation is specified, the\n default, the label will be rotated if and only if it allows the label to become larger.",flags:"IR",name:"titleAutoFitRotationMode"},"attr:DSRequest.additionalOutputs":{seeAlso:[],ref:"attr:DSRequest.additionalOutputs",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DSRequest",valueType:"String",description:"For fetch, add or update operation, an optional comma separated list of fields to fetch from another,\n related DataSource.\n <P>\n Fields should be specified in the format \n <code>\"localFieldName!relatedDataSourceID.relatedDataSourceFieldName\"</code>.\n where <code><i>relatedDataSourceID</i></code> is the ID of the related dataSource, and\n <code><i>relatedDataSourceFieldName</i></code> is the field for which you want to\n fetch related values. The returned field values will be stored on \n the data returned to the client under the specified <code><i>localFieldName</i></code>.\n Note that this will be applied in addition to any specified ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')}.\n <P>\n Note that as with ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom')}, the related dataSource must be\n linked to the primary datasource via a foreignKey relationship.\n <P>\n Note additionalOutputs sent in request from the browser can be completely disabled in \n ${isc.DocUtils.linkForRef('group:server_properties','server.properties')} by setting\n <code>datasource.allowClientAdditionalOutputs</code>:\n <pre>\n     datasource.allowClientAdditionalOutputs: false\n </pre>\n In this case ${isc.DocUtils.linkForRef('attr:DSRequest.additionalOutputs')} sent from the browser will be cleared before \n executing request. Note that programatically configured additionalOutputs are always allowed, but \n you can't modify them from within a DMI method, so the only way to execute a request \n with additionalOutputs that differ from what was sent by the client is to create a new DSRequest",flags:"IRA",name:"additionalOutputs"},"class:AutoFitTextAreaItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"TextAreaItem",classMethods:[],classAttrs:[],attrs:["attr:AutoFitTextAreaItem.maxHeight"],ref:"class:AutoFitTextAreaItem",deprecated:null,description:"Class for editable multi-line text areas (uses HTML <code>&lt;TEXTAREA&gt;</code> object)\n automatically expands to accommodate its content",methods:[],examples:["${isc.DocUtils.linkForExampleId('textAreaItem')}"],name:"AutoFitTextAreaItem"},"method:StatefulCanvas.getStateSuffix":{seeAlso:[],ref:"method:StatefulCanvas.getStateSuffix",deprecated:null,type:"method",definingClass:"class:StatefulCanvas",description:" Returns the suffix that will be appended to the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.baseStyle')}  \n as the component changes ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state')} and/or is selected / focused.\n <P>\n Note that suffixes will only be included if the relevant <code>show<i>[StateName]</i></code>\n attributes (EG ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')}, ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')}, etc) are set to true.\n <P>\n The following table lists out the standard set of suffixes which may be applied \n to the base style:\n <table border=1>\n <tr><td><b>CSS Class Applied</b></td><td><b>Description</b></td></tr>\n <tr><td><code><i>baseStyle</i></code></td><td>Default css style</td></tr>\n <tr><td><code><i>baseStyle</i>+Selected</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected')} is set to true.</td></tr>\n <tr><td><code><i>baseStyle</i>+Focused</code></td>\n      <td>Applied when the component has keyboard focus, if \n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')} is true, and \n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is not true.</td></tr>\n <tr><td><code><i>baseStyle</i>+Over</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')} is set to true and either the user\n      rolls over the component or ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true and the\n      component has keyboard focus.</td></tr>\n <tr><td><code><i>baseStyle</i>+Down</code></td>\n      <td>Applied when the user presses the mouse button on the component if\n          ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDown')} is set to true</td></tr>\n <tr><td><code><i>baseStyle</i>+Disabled</code></td>\n      <td>Applied when the component is ${isc.DocUtils.linkForRef('attr:Canvas.disabled','disabled')}\n       if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabled')} is true.</td></tr>\n <tr><td colspan=2><i>Combined styles</i></td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocused</code></td>\n      <td>Combined Selected and focused styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedOver</code></td>\n      <td>Combined Selected and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+FocusedOver</code></td>\n      <td>Combined Focused and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocusedOver</code></td>\n      <td>Combined Selected, Focused and rollOver styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedDown</code></td>\n      <td>Combined Selected and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+FocusedDown</code></td>\n      <td>Combined Focused and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedFocusedDown</code></td>\n      <td>Combined Selected, Focused and mouse-down styling</td></tr>\n <tr><td><code><i>baseStyle</i>+SelectedDisabled</code></td>\n      <td>Combined Selected and Disabled styling</td></tr>\n </table>\n\n",flags:"",returns:{type:"String",description:"suffix to be appended to the baseStyle"},name:"getStateSuffix"},"attr:UploadItem.textBoxStyle":{seeAlso:[{ref:"attr:FormItem.cellStyle",description:null}],defaultValue:'"uploadItem"',type:"attr",definingClass:"class:UploadItem",groups:["formItemStyling"],deprecated:null,ref:"attr:UploadItem.textBoxStyle",valueType:"FormItemBaseStyle",description:"Base CSS class name for this <code>UploadItem</code>'s native file input element.\n <p>\n Note that the customization via CSS of a native file input element allowable by the\n browser varies widely; in some browsers on certain platforms, it may be possible to\n customize certain CSS properties, but not in others; or, it may be that the CSS property\n (e.g. border) is applied differently in some browsers.\n <p>\n If the textBoxStyle is changed at runtime, ${isc.DocUtils.linkForRef('method:FormItem.updateState')} must be called\n to update the visual state. However, calling updateState() will clear any file selected\n by the user to be uploaded.",flags:"IRW",name:"textBoxStyle"},"attr:Tour.tourStepWizardRecordStepHeaderPrompt":{seeAlso:[],defaultValue:'"Drag this window out of the way to get at UI within the application"',type:"attr",definingClass:"class:Tour",groups:["i18nMessages"],deprecated:null,ref:"attr:Tour.tourStepWizardRecordStepHeaderPrompt",valueType:"HTMLString",description:"Prompt for the <i>Record Step</i> window header in the TourStep Wizard.",flags:"IR",name:"tourStepWizardRecordStepHeaderPrompt"},"attr:FieldPickerWindow.title":{seeAlso:[],defaultValue:'"Field Picker"',type:"attr",definingClass:"class:FieldPickerWindow",groups:["i18nMessages"],deprecated:null,ref:"attr:FieldPickerWindow.title",valueType:"String",description:null,flags:"IR",name:"title"},"method:EditContext.setNodeProperties":{seeAlso:[{ref:"method:EditContext.removeNodeProperties",description:null},{ref:"method:EditContext.getNodeProperty",description:null}],ref:"method:EditContext.setNodeProperties",deprecated:null,type:"method",definingClass:"class:EditContext",params:[{defaultValue:null,optional:false,type:"EditNode",description:"the editNode to update",name:"editNode"},{defaultValue:null,optional:false,type:"Canvas Properties",description:"the properties to apply",name:"properties"},{defaultValue:null,optional:true,type:"Boolean",description:"whether to skip updating the                                         ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObject')},\n                                         e.g. if you have already updated the liveObject",name:"skipLiveObjectUpdate"}],description:" Update an editNode's serializable \"defaults\" with the supplied properties. If you\n wish to remove a property from the defaults (rather than setting it to null), then\n use ${isc.DocUtils.linkForRef('method:EditContext.removeNodeProperties','removeNodeProperties()')} instead.\n",flags:"",name:"setNodeProperties"},"attr:ResultTree.matchingLeafJoinDepth":{seeAlso:[],ref:"attr:ResultTree.matchingLeafJoinDepth",defaultValue:"3",deprecated:null,type:"attr",definingClass:"class:ResultTree",valueType:"Integer",description:"This property allows you to specify the number of ancestor levels SmartClient attempts \n to retrieve with each request, when using the built-in support for\n ${isc.DocUtils.linkForRef('attr:ResultTree.keepParentsOnFilter','keepParentsOnFilter')} on\n ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','loadDataOnDemand')} trees.  See the \n <code>keepParentsOnFilter</code> overview for details.",flags:"IRW",name:"matchingLeafJoinDepth"},"classAttr:AsyncUtil.asyncCanceledMessageGeneric":{seeAlso:[{ref:"classMethod:AsyncUtil.getAsyncMessage",description:null}],defaultValue:'"An asynchronous operation was canceled."',type:"classAttr",definingClass:"class:AsyncUtil",groups:["i18nMessages"],deprecated:null,ref:"classAttr:AsyncUtil.asyncCanceledMessageGeneric",valueType:"HTMLString",description:"A message string to use when displaying an ${isc.DocUtils.linkForRef('object:AsyncOperationResult')} of\n ${isc.DocUtils.linkForRef('attr:AsyncOperationResult.type','type')} \"canceled\"\n to the user, and no ${isc.DocUtils.linkForRef('attr:AsyncOperationResult.cancellationReason')} is available.\n <p>\n ${isc.DocUtils.linkForRef('classAttr:AsyncUtil.asyncCanceledMessage')} is used when a cancellationReason is available.",flags:"RW",name:"asyncCanceledMessageGeneric"},"method:RemoteWindow.isShowing":{seeAlso:[],ref:"method:RemoteWindow.isShowing",deprecated:null,type:"method",definingClass:"class:RemoteWindow",params:[{defaultValue:null,optional:false,type:"RemoteWindowBooleanCallback",description:"callback to receive output",name:"callback"}],description:" Checks whether this RemoteWindow is showing.\n",flags:"",name:"isShowing"},"attr:Canvas.edgeSize":{seeAlso:[],defaultValue:"10",type:"attr",definingClass:"class:Canvas",groups:["imageEdges"],ref:"attr:Canvas.edgeSize",deprecated:null,valueType:"number",description:"Size in pixels for corners and edges",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('edges')}"],name:"edgeSize"},"attr:Canvas.htmlElement":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["htmlElement","positioning"],ref:"attr:Canvas.htmlElement",deprecated:null,setter:["setHtmlElement"],valueType:"DOMElement | String",description:"If specified as a pointer to an HTML element present in the DOM, this canvas will be\n rendered inside that element on ${isc.DocUtils.linkForRef('method:Canvas.draw','draw()')}.  If provided as a String,\n the String will be replaced by a DOM node as returned from\n document.getElementById(htmlElement) on initialization.\n <P>\n <i>NOTES:</i><br>\n This feature is intended for integration with other JavaScript frameworks and\n legacy page architectures only;\n the native browser's reaction to DOM insertion is unspecified and unsupported. For\n consistent cross-browser layout and positioning semantics, use Canvas parents\n (especially Layouts) and use absolute positioning at top level.\n <P>\n In some cases, the target element may need a specified height to be rendered\n correctly.  In this cases, you can expect to find a message like the following in the\n JavaScript console:\n \"isc_DataView_0:can't resize to height: 0; clamping to 1 [enable 'sizing' log for stack trace]\"\n <p>\n Persistence of htmlElement: If ${isc.DocUtils.linkForRef('attr:Canvas.htmlPosition')} is set to <code>\"replace\"</code>\n the htmlElement will be removed from the DOM when the canvas is drawn - therefore the\n htmlElement attribute will be cleared at this time.\n Otherwise if a Canvas is clear()d and then draw()n again it will\n be rendered inside the same htmlElement.<br>\n If a Canvas is added as a child to Canvas parent, its htmlElement will be dropped.\n <P>\n ${isc.DocUtils.linkForRef('attr:Canvas.position')} should typically be set to <code>\"relative\"</code> if the widget\n is to be rendered inline within a standard page.",flags:"IRWA",name:"htmlElement"},"classAttr:Canvas.defaultPageSpace":{seeAlso:[],defaultValue:"0",type:"classAttr",definingClass:"class:Canvas",groups:["positioning"],ref:"classAttr:Canvas.defaultPageSpace",deprecated:null,setter:["setDefaultPageSpace"],valueType:"int",description:"A fixed number of pixels at the top of the page in which components will not be placed.\n This is overridable per-instance via the ${isc.DocUtils.linkForRef('attr:Canvas.leavePageSpace')} attribute.\n Essentially, the effect is that all top-level components are shifted down this number of\n pixels, and the page height is treated as this number of pixels <em>less</em> than the\n real page height.\n <p>\n This attribute can be useful on certain mobile devices, when components should not be\n placed in a top portion of the screen. For example, on iOS devices in certain configurations,\n this can be set to 20 to avoid placing any component into the status bar area. Or, if\n using iOS 7.1's 'minimal-ui' viewport parameter, this can be set to 20 to avoid placing\n any component into the top 20px area of the screen, which if tapped on iPhone in landscape,\n causes Mobile Safari's address bar and tab bar to be shown.\n <p>\n This setting can be changed at runtime by calling ${isc.DocUtils.linkForRef('classMethod:Canvas.setDefaultPageSpace')}.\n <p>\n <strong>Note:</strong> As documented by the ${isc.DocUtils.linkForRef('group:mobileDevelopment','Mobile Application Development')}\n page, when the SmartClient application is running in Mobile Safari on iPhone running iOS 7.1 or\n later, and neither the <code>isc_useDefaultViewport</code> nor the <code>isc_useMinimalUI</code>\n global is set to <code>false</code> when the framework is loaded, then the framework\n will automatically set the <code>defaultPageSpace</code> to 0 in portrait orientation,\n and to 20 in landscape orientation.",flags:"IRA",name:"defaultPageSpace"},"classAttr:ListGrid.UP_ARROW_KEYPRESS":{seeAlso:[],defaultValue:'"arrow_up"',type:"classAttr",definingClass:"class:ListGrid",deprecated:null,ref:"classAttr:ListGrid.UP_ARROW_KEYPRESS",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:EditCompletionEvent','EditCompletionEvent')}.",flags:"R",name:"UP_ARROW_KEYPRESS",constant:true},"type:double":{seeAlso:[],ref:"type:double",treeLocation:["Client Reference/System"],deprecated:null,type:"type",description:'A decimal (or "floating point") number, for example, 5.5.  May not be null.',name:"double",baseType:"Double"},"attr:ValuesManager.updateOperation":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ValuesManager",groups:["operations"],deprecated:null,ref:"attr:ValuesManager.updateOperation",valueType:"String",description:"${isc.DocUtils.linkForRef('attr:DSRequest.operationId','operationId')} to use when performing update operations.",flags:"IRW",name:"updateOperation"},"method:FormItem.getVisibleWidth":{groups:["sizing"],seeAlso:[],ref:"method:FormItem.getVisibleWidth",deprecated:null,type:"method",definingClass:"class:FormItem",description:"\tOutput the drawn width for this item in pixels. This method is only reliable after\n  the item has been drawn into the page.\n",flags:"A",returns:{type:"Integer",description:"width of the form item"},name:"getVisibleWidth"},"attr:TileLayout.paddingAsLayoutMargin":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:TileLayout",groups:["layoutMargin"],deprecated:null,ref:"attr:TileLayout.paddingAsLayoutMargin",valueType:"Boolean",description:"If this widget has padding specified (as ${isc.DocUtils.linkForRef('attr:Canvas.padding','this.padding')} or in the\n CSS style applied to this layout), should it show up as space outside the members,\n similar to layoutMargin?\n <P>\n If this setting is false, padding will not affect member positioning (as CSS padding\n normally does not affect absolutely positioned children).  Leaving this setting true\n allows a designer to more effectively control layout purely from CSS.\n <P>\n Note that ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')} if specified, takes precedence over this value.",flags:"IRWA",name:"paddingAsLayoutMargin"},"method:TileGrid.loadAllRecords":{seeAlso:[],type:"method",definingClass:"class:TileGrid",returns:{type:"Boolean",description:"true if a fetch was made or was not needed - false otherwise"},groups:["dataBoundComponentMethods"],deprecated:null,ref:"method:TileGrid.loadAllRecords",params:[{defaultValue:null,optional:true,type:"Integer",description:"optional maximum record count - if passed, no fetch takes place                                if maxRecords is below the known length of the data",name:"maxRecords"},{defaultValue:null,optional:true,type:"DSCallback",description:"callback to fire if a fetch is issued - if all data was                                 already loaded, the callback is fired with no parameters",name:"callback"}],description:" Loads all records that match this grid's current filter-criteria, optionally firing a \n callback when the data arrives.\n <p>\n If the length of the data is ${isc.DocUtils.linkForRef('method:ResultSet.lengthIsKnown','not known')}, or is greater than \n the passed <i>maxRecords</i>, this call returns false.  No fetch \n is issued and the <i>callback</i>, if passed, is not fired.\n <p>\n If all data is ${isc.DocUtils.linkForRef('method:ResultSet.allMatchingRowsCached','already loaded')}, no fetch is issued \n and this call returns true.  The <i>callback</i>, if passed, will be fired, but its \n parameters will be null, since there was no fetch to provide the values from.\n <p>\n In all other cases, this call returns true and a fetch is issued for all necessary records. \n When the data arrives, the <i>callback</i> is fired.\n\n",flags:"",name:"loadAllRecords"},"attr:StyleGroup.settings":{seeAlso:[],ref:"attr:StyleGroup.settings",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:StyleGroup",valueType:"Array of StyleSetting",description:"The array of ${isc.DocUtils.linkForRef('object:StyleSetting','settings')} to make available for editing in this \n group.",flags:"IR",name:"settings"},"method:DataSource.xmlSerialize":{seeAlso:[],ref:"method:DataSource.xmlSerialize",deprecated:null,type:"method",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"Any",description:"data to be serialized",name:"data"},{defaultValue:null,optional:false,type:"SerializationContext",description:"options for the serialization engine",name:"flags"}],description:" Serialize a JavaScript object as XML.\n <P>\n The JavaScript Object passed to ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} becomes an XML\n element named after the ${isc.DocUtils.linkForRef('attr:DataSource.tagName')} (or ${isc.DocUtils.linkForRef('attr:DataSource.ID')} if\n tagName is unset).  Each property of the object becomes a subElement.  For example,\n using a DataSource to serialize like this:\n <pre>\n     var inputObject = {\n        startRow : 5,\n        endRow : 50,\n        data : [\n           { field1 : \"value1\", field2: new Date() },\n           { field1 : \"value3\", field2: null }\n        ]\n     };\n     var myDS = isc.DataSource.create({ tagName:\"DSRequest\" });\n     myDS.xmlSerialize(inputObject);\n </pre>\n .. produces the following XML:\n <pre>\n     &lt;DSRequest&gt;\n         &lt;startRow&gt;5&lt;/startRow&gt;\n         &lt;endRow&gt;50&lt;/endRow&gt;\n         &lt;data&gt;\n             &lt;field1&gt;value1&lt;/field1&gt;\n             &lt;field2&gt;2005-10-14T18:01:16&lt;/field2&gt;\n         &lt;/data&gt;\n         &lt;data&gt;\n             &lt;field1&gt;value3&lt;/field1&gt;\n             &lt;field2&gt;&lt;/field2&gt;\n         &lt;/data&gt;\n     &lt;/DSRequest&gt;\n </pre>\n <P>\n Various properties on the DataSource and DataSourceField can affect how serialization is\n performed, see for example ${isc.DocUtils.linkForRef('attr:DataSource.tagName')},\n ${isc.DocUtils.linkForRef('attr:DataSource.schemaNamespace')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.xmlAttribute')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.multiple')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.childTagName')}.\n By setting the ${isc.DocUtils.linkForRef('attr:DataSourceField.type','type of a field')} to the ID of another\n DataSource which has further XML serialization settings, you can control serialization of\n nested structures.\n <P>\n If you are working with a WSDL-described web service, XML serialization is performed\n automatically by APIs like ${isc.DocUtils.linkForRef('method:WebService.callOperation')} - you only need to\n know about serialization in order to understand how to put together JavaScript data that\n will fill in an XML message properly, and for simple messages, setting\n ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields')} makes that unnecessary as well.   \n <P>\n <b>Note:</b> when trying to send data to a web service, it is best to avoid putting\n together any XML yourself, instead modify the JavaScript data being fed to SmartClient's\n SOAP engine.  This is because the WSDL and SOAP rules for correctly namespacing and\n encoding Web Service messages are very complex and are subject to change with new\n versions of the web service you are contacting, whereas the data itself is easy to\n manipulate and less likely to change.\n <P>\n To troubleshoot message formation, you can set the log category \"xmlSerialize\" to \n <code>INFO</code> or <code>DEBUG</code> level in order to see diagnostics about XML\n message formation, and you can use the RPC tab in the Developer Console to see the\n actual messages being passed to web services.\n\n",flags:"A",returns:{type:"String",description:"data as serialized to XML"},name:"xmlSerialize"},"attr:SplitPane.detailToolStrip":{seeAlso:[],ref:"attr:SplitPane.detailToolStrip",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SplitPane",valueType:"AutoChild NavigationBar",description:"Toolstrip servicing the ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane','detailPane')}.\n <p>\n In ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','deviceMode')}\n \"desktop\"\n \n and <code>deviceMode</code>\n \"tablet\",\n \n the <code>detailToolStrip</code> is shown <em>above</em> the <code>detailPane</code>.\n In ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','deviceMode')}\n \"handset\",\n \n the <code>detailToolStrip</code> is created <strong>only</strong> if\n ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolButtons','detailToolButtons')} are specified, and is placed\n <em>underneath</em> the <code>detailPane</code>.",flags:"IR",name:"detailToolStrip"},"attr:ListGrid.allowFilterOperators":{seeAlso:[{ref:"attr:ListGrid.allowFilterWindow",description:null}],ref:"attr:ListGrid.allowFilterOperators",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"Boolean",description:"Causes a menu item titled ${isc.DocUtils.linkForRef('attr:ListGrid.filterUsingText','\"Filter using\"')} to appear in the\n ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} that allows the end user to pick an advanced\n ${isc.DocUtils.linkForRef('type:OperatorId','search operator')} to use for this field.\n <p>\n Once an operator has been chosen, the active operator is indicated by an\n ${isc.DocUtils.linkForRef('attr:ListGrid.operatorIcon')} placed within the field (you can alternatively cause the\n icon to ${isc.DocUtils.linkForRef('attr:ListGrid.alwaysShowOperatorIcon','always be present')}).  The <code>operatorIcon</code> \n shows the same textual representation of the search operator as is used by the\n ${isc.DocUtils.linkForRef('attr:FormItem.allowExpressions')} feature.  Clicking on the icon provides a second way to \n modify the search operator.  \n <p>\n This feature is enabled by default if ${isc.DocUtils.linkForRef('method:DataSource.supportsAdvancedCriteria')} is true, \n for all fields where it is normally possible to filter by typing in a search string.  This \n excludes field types such as \"date\" or \"boolean\" which show specialized filter controls.  \n Use ${isc.DocUtils.linkForRef('attr:ListGridField.allowFilterOperators')} to disable this interface for individual \n fields, or set ${isc.DocUtils.linkForRef('attr:DataSourceField.canFilter')} to false to disallow filtering entirely for \n a field.\n <p>\n Note that this feature is similar to ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterExpressions')}, which allows \n the end users to directly type in characters such as \"&gt;\" to control filtering.\n <code>allowFilterOperators</code> is easier to use and more discoverable than\n <code>allowFilterExpressions</code>, and also avoids the drawback where special characters \n like \"&gt;\" cannot be used in filter values.  However, <code>allowFilterExpressions</code> \n allows users to make use of certain operators that <code>allowFilterOperators</code> does \n not support, such as using the \"betweenInclusive\" operator by typing \"5...10\".\n <P>\n When both <code>allowfilterExpressions</code> and <code>allowFilterOperators</code> are set,\n filter expressions entered in to the edit-area are parsed and the operator automatically \n applied to the ${isc.DocUtils.linkForRef('attr:ListGrid.operatorIcon')}.\n <P>\n If ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterWindow')} is enabled another option,\n ${isc.DocUtils.linkForRef('attr:ListGrid.advancedFilteringText','\"Advanced Filtering\"')}, is added to the \"Filter using\" menu.",flags:"IR",name:"allowFilterOperators"},"method:FilterBuilder.clearCriteria":{seeAlso:[],ref:"method:FilterBuilder.clearCriteria",deprecated:null,type:"method",definingClass:"class:FilterBuilder",description:" Clear all current criteria.\n",flags:"",name:"clearCriteria"},"attr:ListGrid.dragScrollRedrawDelay":{seeAlso:[],defaultValue:"75",type:"attr",definingClass:"class:ListGrid",groups:["performance"],deprecated:null,ref:"attr:ListGrid.dragScrollRedrawDelay",valueType:"int",description:"Like ${isc.DocUtils.linkForRef('attr:ListGrid.scrollRedrawDelay')}, but applies when the component is being\n drag-scrolled (via a scrollbar).  This value is typically set higher than ${isc.DocUtils.linkForRef('attr:ListGrid.scrollRedrawDelay')}\n to avoid too many concurrent fetches to the server for ${isc.DocUtils.linkForRef('class:ResultSet')}-backed components\n since it's quite easy to induce such a case with a scrollbar and a grid bound to a large databaset.",flags:"IRW",name:"dragScrollRedrawDelay"},"class:TabSet":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Canvas",classMethods:[],classAttrs:[],attrs:["attr:TabSet.tabs","attr:TabSet.tabBar","attr:TabSet.tabProperties","attr:TabSet.defaultTabWidth","attr:TabSet.defaultTabHeight","attr:TabSet.useSimpleTabs","attr:TabSet.simpleTabBaseStyle","attr:TabSet.simpleTabIconOnlyBaseStyle","attr:TabSet.tabBarPosition","attr:TabSet.tabBarAlign","attr:TabSet.tabBarThickness","attr:TabSet.selectedTab","attr:TabSet.canCloseTabs","attr:TabSet.closeTabIcon","attr:TabSet.closeTabIconSize","attr:TabSet.ariaCloseableSuffix","attr:TabSet.canReorderTabs","attr:TabSet.showMoreTab","attr:TabSet.moreTabCount","attr:TabSet.moreTabTitle","attr:TabSet.moreTabImage","attr:TabSet.moreTab","attr:TabSet.moreTabProperties","attr:TabSet.moreTabPane","attr:TabSet.moreTabPaneProperties","attr:TabSet.moreTabPaneDefaults","attr:TabSet.moreTabPaneNavBar","attr:TabSet.moreTabPaneTable","attr:TabSet.tabBarControls","attr:TabSet.showTabScroller","attr:TabSet.showTabPicker","attr:TabSet.tabBarControlLayout","attr:TabSet.animateTabScrolling","attr:TabSet.scroller","attr:TabSet.scrollerButtonSize","attr:TabSet.tabPicker","attr:TabSet.pickerButtonSize","attr:TabSet.touchPickerButtonSize","attr:TabSet.skinImgDir","attr:TabSet.symmetricScroller","attr:TabSet.scrollerSrc","attr:TabSet.scrollerHSrc","attr:TabSet.scrollerVSrc","attr:TabSet.symmetricPickerButton","attr:TabSet.pickerButtonSrc","attr:TabSet.pickerButtonHSrc","attr:TabSet.pickerButtonVSrc","attr:TabSet.paneContainer","attr:TabSet.paneContainerClassName","attr:TabSet.paneContainerOverflow","attr:TabSet.symmetricEdges","attr:TabSet.leftEdgeSizes","attr:TabSet.topEdgeSizes","attr:TabSet.bottomEdgeSizes","attr:TabSet.rightEdgeSizes","attr:TabSet.leftEdgeOffsets","attr:TabSet.rightEdgeOffsets","attr:TabSet.topEdgeOffsets","attr:TabSet.bottomEdgeOffsets","attr:TabSet.showPaneContainerEdges","attr:TabSet.paneMargin","attr:TabSet.canEditTabTitles","attr:TabSet.titleEditEvent","attr:TabSet.titleEditor","attr:TabSet.titleEditorProperties","attr:TabSet.titleEditorLeftOffset","attr:TabSet.titleEditorRightOffset","attr:TabSet.titleEditorTopOffset","attr:TabSet.useIOSTabs","attr:TabSet.canAddTabs","attr:TabSet.addTabButton","attr:TabSet.addTabButtonIcon","attr:TabSet.showTabBar","attr:TabSet.simpleTabButtonConstructor","attr:TabSet.tabBarProperties","attr:TabSet.showPartialEdges","attr:TabSet.destroyPanes","attr:TabSet.locateTabsBy","attr:TabSet.editProxyConstructor"],ref:"class:TabSet",deprecated:null,treeLocation:["Client Reference/Layout"],description:"The TabSet class allows components on several panes to share the same space. The tabs at \n the top can be selected by the user to show each pane. \n <P>\n Tabs are configured via the <code>tabs</code> property, each of which has a\n <code>pane</code> property which will be displayed in the main pane when that tab is\n selected.",methods:["method:TabSet.setPaneContainerOverflow","method:TabSet.getPaneContainerEdges","method:TabSet.setTabTitle","method:TabSet.setTabPickerTitle","method:TabSet.setTabIcon","method:TabSet.enableTab","method:TabSet.disableTab","method:TabSet.setTabProperties","method:TabSet.addTab","method:TabSet.addTabs","method:TabSet.tabIsVisible","method:TabSet.hideTab","method:TabSet.showTab","method:TabSet.setTabPane","method:TabSet.removeTab","method:TabSet.removeTabs","method:TabSet.removeLastTab","method:TabSet.reorderTab","method:TabSet.setCanCloseTab","method:TabSet.setCanCloseTabs","method:TabSet.closeClick","method:TabSet.tabIconClick","method:TabSet.getTabObject","method:TabSet.getTab","method:TabSet.getTabPane","method:TabSet.getTabNumber","method:TabSet.updateTab","method:TabSet.revealChild","method:TabSet.scrollForward","method:TabSet.scrollBack","method:TabSet.getSelectedTab","method:TabSet.getSelectedTabNumber","method:TabSet.selectTab","method:TabSet.tabForPane","method:TabSet.editTabTitle","method:TabSet.cancelTabTitleEditing","method:TabSet.saveTabTitle","method:TabSet.addTabClicked","method:TabSet.addTabClick","method:TabSet.tabSelected","method:TabSet.tabDeselected","method:TabSet.titleChanged","method:TabSet.showTabContextMenu","method:TabSet.tabsReordered"],name:"TabSet"},"classMethod:XMLTools.selectNodes":{seeAlso:[],type:"classMethod",definingClass:"class:XMLTools",returns:{type:"Array",description:"list of nodes matching XPath"},groups:["xmlTransform"],ref:"classMethod:XMLTools.selectNodes",deprecated:null,params:[{defaultValue:null,optional:false,type:"XMLElement | XMLDocument | String",description:"Native XMLElement,document, or xml string                                                      to select from",name:"element"},{defaultValue:null,optional:false,type:"XPath",description:"XPath expression to use to select nodes",name:"expression"},{defaultValue:null,optional:true,type:"Map<Prefix,URI>",description:"namespace mapping used by the expression",name:"namespaces"}],description:' Retrieve a set of nodes from an XML element or document based on an XPath expression.\n <P>\n If the target document is namespaced, namespace prefixes declared in the document element of\n the target document will be available, as well as the default namespace, if declared, under\n the prefix "default".\n <P>\n To declare your own namespace prefixes, provide a prefix to URI mapping as a simple JS\n Object, for example:\n <pre>\n   {\n      az : "http://webservices.amazon.com/AWSECommerceService/2005-03-23",\n      xsd : "http://www.w3.org/2001/XMLSchema"\n   }\n </pre>\n <P>\n <b>NOTE:</b> this API cannot be supported on the Safari web browser for versions earlier\n than 3.0.3.\n\n',flags:"",examples:["${isc.DocUtils.linkForExampleId('xmlServerValidationErrors')}"],name:"selectNodes"},"attr:ComboBoxItem.editProxyConstructor":{seeAlso:[],ref:"attr:ComboBoxItem.editProxyConstructor",defaultValue:'"SelectItemEditProxy"',deprecated:null,type:"attr",definingClass:"class:ComboBoxItem",valueType:"SCClassName",description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",flags:"IR",name:"editProxyConstructor"},"attr:DetailViewerField.imageHeight":{seeAlso:[{ref:"attr:DetailViewerField.imageSize",description:null},{ref:"attr:DetailViewerField.imageWidth",description:null}],defaultValue:"null",type:"attr",definingClass:"object:DetailViewerField",groups:["imageColumns"],deprecated:null,ref:"attr:DetailViewerField.imageHeight",valueType:"Integer | String",description:'Height of image shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageHeight</code> is "logoHeight",\n <code>record.logoHeight</code> will control the height of the image.',flags:"IRW",name:"imageHeight"},"attr:Splitbar.showClosedGrip":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Splitbar",groups:["grip"],deprecated:null,ref:"attr:Splitbar.showClosedGrip",valueType:"Boolean",description:"If ${isc.DocUtils.linkForRef('attr:Splitbar.showGrip')} is true, this property determines whether the grip image\n displayed should show the <code>\"Closed\"</code> state when the ${isc.DocUtils.linkForRef('attr:Splitbar.target')} \n is hidden. Note that if ${isc.DocUtils.linkForRef('attr:Splitbar.invertClosedGripIfTargetAfter')} is true, we\n may show the \"closed\" state when the target is visible, rather than when it is hidden.",flags:"IRA",name:"showClosedGrip"},"attr:GridRenderer.showClippedValuesOnHover":{seeAlso:[{ref:"attr:GridRenderer.canHover",description:null},{ref:"method:GridRenderer.cellValueHoverHTML",description:null}],defaultValue:"null",type:"attr",definingClass:"class:GridRenderer",groups:["events"],deprecated:null,ref:"attr:GridRenderer.showClippedValuesOnHover",valueType:"Boolean",description:"If true and a cell's value is clipped, then a hover containing the full cell value is\n enabled.\n <p>\n Note that standard cell hovers override clipped value hovers. Thus, to enable clipped value\n hovers, ${isc.DocUtils.linkForRef('attr:GridRenderer.canHover','canHover')} must be unset or null and the corresponding field must have\n ${isc.DocUtils.linkForRef('attr:ListGridField.showHover','showHover')} unset or null as well.",flags:"IRWA",name:"showClippedValuesOnHover"},"classAttr:Browser.isTouch":{seeAlso:[],defaultValue:"auto-detected based on device",type:"classAttr",definingClass:"class:Browser",deprecated:null,ref:"classAttr:Browser.isTouch",setter:["setIsTouch"],valueType:"boolean",description:"Is the application running on a touch device (e.g. iPhone, iPad, Android device, etc.)?\n <p>\n SmartClient's auto-detected value for <code>isTouch</code> can be overridden via\n ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTouch')}.",flags:"RW",name:"isTouch"},"attr:TreeGrid.useAllDataSourceFields":{seeAlso:[{ref:"attr:FieldPicker.dataBoundComponent",description:null}],defaultValue:"null",type:"attr",definingClass:"class:TreeGrid",groups:["databinding"],ref:"attr:TreeGrid.useAllDataSourceFields",deprecated:null,valueType:"boolean",description:"If true, the set of fields given by the \"default binding\" (see \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}) is used, with any fields specified in\n <code>component.fields</code> acting as overrides that can suppress or modify the\n display of individual fields, without having to list the entire set of fields that\n should be shown.\n <P>\n If <code>component.fields</code> contains fields that are not found in the DataSource,\n they will be shown after the most recently referred to DataSource field.  If the new\n fields appear first, they will be shown first.\n <P>\n ${isc.DocUtils.linkForExampleId('validationFieldBinding', 'This example')} shows a mixture of component\n fields and DataSource fields, and how they interact for validation.\n <P>\n This setting may be cleared if a ${isc.DocUtils.linkForRef('class:FieldPicker')} is used to edit the component's field\n order.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('validationFieldBinding')}"],name:"useAllDataSourceFields"},"attr:ListPropertiesDialog.cancelButton":{seeAlso:[],ref:"attr:ListPropertiesDialog.cancelButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListPropertiesDialog",valueType:"AutoChild IButton",description:"The Cancel button. When clicked, the ${isc.DocUtils.linkForRef('method:ListPropertiesDialog.cancelClick','cancelClick')}\n event is fired.\n <p>\n ${isc.DocUtils.linkForRef('attr:ListPropertiesDialog.cancelButtonTitle','cancelButtonTitle')} is a ${isc.DocUtils.linkForRef('group:autoChildUsage','passthrough')}\n for the button's ${isc.DocUtils.linkForRef('attr:Button.title','title')}.",flags:"R",name:"cancelButton"},"attr:TileLayout.showDragLine":{seeAlso:[],ref:"attr:TileLayout.showDragLine",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TileLayout",valueType:"boolean",description:"Set false to prevent the ${isc.DocUtils.linkForRef('attr:TileLayout.dragLine')} autochild from showing during dragging.",flags:"IRW",name:"showDragLine"},"attr:DatabaseBrowser.selectButton":{seeAlso:[],ref:"attr:DatabaseBrowser.selectButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"AutoChild Button",description:"Instance of Button used to continue once a table has been selected.",flags:"IR",name:"selectButton"},"attr:FacetChart.facets":{seeAlso:[],ref:"attr:FacetChart.facets",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FacetChart",valueType:"Array of Facet | Facet",description:"An array of facets, exactly analogous to ${isc.DocUtils.linkForRef('attr:CubeGrid.facets')}, except that:\n <ul>\n <li> the ${isc.DocUtils.linkForRef('attr:Facet.inlinedValues','inlinedValues')} property can be set on a facet\n to change data representation, as described under ${isc.DocUtils.linkForRef('attr:Chart.data')}.\n <li> for a non-inlined facet, charts support auto-derivation of facet values from the\n data.\n </ul>\n <p>\n In all chart types except Bubble and Scatter, the chart displays a value for each\n discrete value of one facet (i.e. single-facet charts) or it displays a value for each\n combination of discrete values of two facets (multi-facet charts).  The two different\n facets are the ${isc.DocUtils.linkForRef('method:FacetChart.getDataLabelFacet','data label facet')} and the\n ${isc.DocUtils.linkForRef('method:FacetChart.getLegendFacet','legend facet')}.  They are named based on where the\n ${isc.DocUtils.linkForRef('attr:Facet.values','values')} of the facet appear in the chart.  The facet whose values\n are rendered as labels along the data axis or in the main chart area is the data label\n facet, and the facet whose values are rendered in the legend is the legend facet.\n <p>\n For single-facet charts, most chart types have a data label facet as the first facet\n but no legend facet.  Single-facet Pie charts have a legend facet as the first facet\n but no data label facet.  Bubble and Scatter plots may have a legend facet as the\n second facet, after the metric facet.\n <p>\n In multi-facet charts with two non-metric facets, the data label facet is the first facet\n and the legend facet is the second facet. These may be swapped on the fly by the user clicking\n the \"Swap Facets\" item of the context menu.\n <p>\n Bar and Column charts also support three non-metric facets, where the first two facets\n in that case are taken as the data label facets, and the third facet as the legend facet.\n This works by positioning both data label\n facets on the same axis, in a way that clearly shows which inner facet values are\n associated with each outer facet value. \"Swap Facets\" swaps the order of the two data\n label facets.\n <p>\n For databound charts, ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')} may be specified instead of this property.  If\n both are provided, ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')} is definitive but ${isc.DocUtils.linkForRef('object:Facet')} properties will be\n picked up from ${isc.DocUtils.linkForRef('attr:FacetChart.facets')} also present in the ${isc.DocUtils.linkForRef('attr:FacetChart.facetFields')}.",flags:"IR",name:"facets"},"classMethod:DateUtil.combineLogicalDateAndTime":{seeAlso:[],ref:"classMethod:DateUtil.combineLogicalDateAndTime",deprecated:null,type:"classMethod",definingClass:"class:DateUtil",params:[{defaultValue:null,optional:false,type:"Date",description:"a Date instance representing logical date value",name:"date"},{defaultValue:null,optional:false,type:"Date",description:"a Date instance representing logical time value",name:"time"}],description:" Combine a logical date (a value appropriate for a DataSourceField of type \"date\") with a\n logical time (a value appropriate for a DataSourceField of type \"time\") into a datetime\n value (a value appropriate for a DataSourceField of type \"datetime\")\n <P>\n This method correctly takes into account the current\n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','display timezone')}, specifically, the returned datetime\n value will show the same date and time as the passed date and time objects when rendered by\n a SmartClient component that has been configured with a field of type \"datetime\".\n <P>\n For further background on date, time and datetime types, storage and transmission, see\n ${isc.DocUtils.linkForRef('group:dateFormatAndStorage','this overview')}.\n\n",flags:"",returns:{type:"Date",description:"a Date instance representing a datetime value combining the logical date and                time passed"},name:"combineLogicalDateAndTime"},"attr:DynamicForm.errorItemProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DynamicForm",groups:["validation"],deprecated:null,ref:"attr:DynamicForm.errorItemProperties",valueType:"Object",description:"If ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors')} is false we show all errors for the form item in \n a single item rendered at the top of the form.<br>\n This attribute contains a properties block for this item.",flags:"IRA",name:"errorItemProperties"},"attr:ListGrid.expansionFieldImageShowSelected":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:ListGrid",groups:["expansionField"],deprecated:null,ref:"attr:ListGrid.expansionFieldImageShowSelected",valueType:"boolean",description:"Should a \"_selected\" suffix be added to the \n ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldTrueImage','expansionFieldTrueImage')}\n and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldFalseImage','expansionFieldFalseImage')} image URLs for\n selected rows?\n <P>\n This allows developers to provide separate expansion field media for selected\n rows, in case the selected row style does not contrast well with the standard\n expansion field image media.\n <P>\n If both this property and ${isc.DocUtils.linkForRef('attr:ListGrid.expansionFieldImageShowRTL')} are true, and\n the grid is in RTL mode, both suffixes will be applied to selected rows'\n expansion field image (combined as \"selected_rtl\")",flags:"IRA",name:"expansionFieldImageShowSelected"},"attr:TourStep.pointerSnapTo":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:TourStep",groups:["snapPositioning"],deprecated:null,ref:"attr:TourStep.pointerSnapTo",valueType:"String",description:"Applied directly to ${isc.DocUtils.linkForRef('attr:TourStep.targetView')} ${isc.DocUtils.linkForRef('attr:Canvas.pointerSettings','pointerSettings')}.",flags:"IR",name:"pointerSnapTo"},"attr:DataSourceField.columnCode":{seeAlso:[],requiresModules:["SCServer"],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",ref:"attr:DataSourceField.columnCode",deprecated:null,valueType:"String",description:"See ${isc.DocUtils.linkForRef('attr:DataSource.tableCode')}.",flags:"R",serverDS:"only",name:"columnCode"},"attr:DataSourceField.valueMap":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["dataType"],ref:"attr:DataSourceField.valueMap",deprecated:null,valueType:"ValueMap",description:"A ${isc.DocUtils.linkForRef('type:ValueMap')} is a set of legal values for a field.\n <p>\n The valueMap can be specified as either an Array of legal values, or as an\n ${isc.DocUtils.linkForRef('type:Object')} where each property maps a stored value to a user-displayable value.\n <p>\n To enforce that a field should be constrained to only the values in the valueMap, either\n declare ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field.type')} as \"enum\", or use a\n ${isc.DocUtils.linkForRef('type:ValidatorType')} of \"isOneOf\" with explicitly listed values.  Otherwise,\n although a normal ${isc.DocUtils.linkForRef('class:SelectItem')} control will only allow values from the valueMap to be\n entered, other controls such as a ${isc.DocUtils.linkForRef('class:ComboBoxItem','ComboBox')} will allow other values \n to be entered.\n <p>\n In XML, a valueMap that specifies only a list of legal values is specified as follows:\n <pre>\n   &lt;valueMap&gt;\n   \t&lt;value&gt;Pens &amp; Pencils&lt;/value&gt;\n   \t&lt;value&gt;Stationery&lt;/value&gt;\n   \t&lt;value&gt;Computer Products&lt;/value&gt;\n   \t&lt;value&gt;Furniture&lt;/value&gt;\n   \t&lt;value&gt;Misc&lt;/value&gt;\n   &lt;/valueMap&gt;\n </pre>\n A ValueMap that specifies stored values mapped to user-visible values is specified as\n follows:\n <pre>\n   &lt;valueMap&gt;\n   \t&lt;value ID=\"1\"&gt;Pens &amp; Pencils&lt;/value&gt;\n   \t&lt;value ID=\"2\"&gt;Stationery&lt;/value&gt;\n   \t&lt;value ID=\"3\"&gt;Computer Products&lt;/value&gt;\n   \t&lt;value ID=\"4\"&gt;Furniture&lt;/value&gt;\n   \t&lt;value ID=\"5\"&gt;Misc&lt;/value&gt;\n   &lt;/valueMap&gt;\n </pre>",flags:"IR",serverDS:"allowed",name:"valueMap"},"attr:CoTTransition.visibleWhen":{seeAlso:[],ref:"attr:CoTTransition.visibleWhen",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:CoTTransition",valueType:"String | AdvancedCriteria | Function",description:'Conditional visibility for this transition, evaluated with the same semantics as\n ${isc.DocUtils.linkForRef(\'attr:Canvas.visibleWhen\')}. When false, the transition is treated as unavailable:\n it is omitted from prompt fragments (see ${isc.DocUtils.linkForRef(\'method:CoTProcess.getPromptPart\',\'"transitions"\')})\n and hidden from any UI that lists transitions. If the AI attempts to use a\n non-visible transition (e.g., emits {goTo} to this target) resulting in a validation\n error and a retry.\n <p>\n <b>Evaluation context</b><br>\n The expression is evaluated against the process ${isc.DocUtils.linkForRef(\'attr:Process.ruleScope\',\'ruleScope\')}.\n In addition, the special identifier <code>state</code> is prebound to\n <code>process.state</code>\n <p>\n <b>Examples</b>\n <pre>\n // Only show "addField" while total fields < 50\n visibleWhen: {\n   operator:"lessThan",\n   fieldName:"state.currentDS.fields.length",\n   value:50\n }\n\n // Hide "done" unless we\'ve added at least one field in this run\n visibleWhen: {\n   operator:"isNotNull",\n   fieldName:"state.lastCreatedField"\n }\n\n // Require both a DataSource and at least 1 field\n visibleWhen: {\n   operator:"and",\n   criteria:[\n     { fieldName:"state.currentDS", operator:"isNotNull" },\n     { fieldName:"state.currentDS.fields.length", operator:"greaterThan", value:0 }\n   ]\n }\n </pre>',flags:"IR",name:"visibleWhen"},"attr:StretchImgButton.height":{seeAlso:[{ref:"attr:StatefulCanvas.autoFit",description:null}],defaultValue:"null",type:"attr",definingClass:"class:StretchImgButton",groups:["sizing"],deprecated:null,ref:"attr:StretchImgButton.height",valueType:"Number | String",description:"Size for this component's vertical dimension.  See ${isc.DocUtils.linkForRef('attr:Canvas.height')} for more\n details.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} is set on non-${isc.DocUtils.linkForRef('class:StretchImgButton')} instances, this\n property will be ignored so that the widget is always sized just large enough to\n accommodate the title.",flags:"IRW",name:"height"},"method:FormItem.parseEditorValue":{seeAlso:[],ref:"method:FormItem.parseEditorValue",deprecated:null,type:"method",definingClass:"class:FormItem",params:[{defaultValue:null,optional:false,type:"String",description:"value as entered by the user",name:"value"},{defaultValue:null,optional:false,type:"DynamicForm",description:"pointer to the dynamicForm containing this item",name:"form"},{defaultValue:null,optional:false,type:"FormItem",description:"pointer to this item",name:"item"}],description:" Allows customization of how a used-entered text value is converted to the FormItem's\n logical stored value (the value available from ${isc.DocUtils.linkForRef('method:FormItem.getValue')}).  \n <p>\n This method only applies to form items which show an editable text entry area, such at\n the ${isc.DocUtils.linkForRef('class:TextItem')} or ${isc.DocUtils.linkForRef('class:TextAreaItem')}.\n <p>\n See also ${isc.DocUtils.linkForRef('method:FormItem.formatEditorValue')}\n\n",flags:"",returns:{type:"Any",description:"Data value to store for this item."},name:"parseEditorValue"},"attr:ListGrid.valueIconSize":{seeAlso:[{ref:"attr:ListGrid.valueIconWidth",description:null},{ref:"attr:ListGrid.valueIconHeight",description:null},{ref:"attr:ListGridField.valueIconSize",description:null}],defaultValue:"16",type:"attr",definingClass:"class:ListGrid",groups:["imageColumns"],deprecated:null,ref:"attr:ListGrid.valueIconSize",valueType:"number",description:"Default width and height of value icons for this ListGrid.\n Can be overridden at the listGrid level via explicit ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconHeight')}, or at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')},\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')} and {ListGridField.valueIconHeight}",flags:"IRW",name:"valueIconSize"},"attr:EditNode.liveObject":{seeAlso:[],ref:"attr:EditNode.liveObject",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:EditNode",valueType:"Object",description:"Live version of the object created from the ${isc.DocUtils.linkForRef('attr:EditNode.defaults')}.  For example, \n if ${isc.DocUtils.linkForRef('attr:EditNode.type')} is \"ListGrid\", <code>liveObject</code> would be a ListGrid.",flags:"IR",name:"liveObject"},"attr:DateChooser.baseWeekdayStyle":{seeAlso:[],ref:"attr:DateChooser.baseWeekdayStyle",defaultValue:'"dateChooserWeekday"',deprecated:null,type:"attr",definingClass:"class:DateChooser",valueType:"CSSStyleName",description:'Base CSS style applied to weekdays. Will have "Over", "Selected" and "Down"\n suffix appended as the user interacts with buttons.  Defaults to ${isc.DocUtils.linkForRef(\'attr:DateChooser.baseButtonStyle\')}.\n <P>\n See ${isc.DocUtils.linkForRef(\'group:cellStyleSuffixes\')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles in Grids.',flags:"IRW",name:"baseWeekdayStyle"},"attr:Calendar.cancelButton":{seeAlso:[],ref:"attr:Calendar.cancelButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"AutoChild IButton",description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} of type ${isc.DocUtils.linkForRef('class:IButton')}, used to cancel editing of an event and close the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','eventEditor')}.",flags:"R",name:"cancelButton"},"attr:CoTTask.maxRetries":{seeAlso:[],ref:"attr:CoTTask.maxRetries",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:CoTTask",valueType:"Number",description:"Maximum number of retries for validation failures for this task. If unset, inherits from ${isc.DocUtils.linkForRef('attr:CoTProcess.maxRetries')}.\n A value of 0 disables retries.",flags:"IR",name:"maxRetries"},"object:isc":{seeAlso:[],type:"object",staticMethods:["staticMethod:isc.showPrompt","staticMethod:isc.clearPrompt","staticMethod:isc.showFadingPrompt","staticMethod:isc.warn","staticMethod:isc.say","staticMethod:isc.ask","staticMethod:isc.confirm","staticMethod:isc.askForValue","staticMethod:isc.dismissCurrentDialog","staticMethod:isc.showLoginDialog","staticMethod:isc.logWarn","staticMethod:isc.logInfo","staticMethod:isc.echo","staticMethod:isc.echoAll","staticMethod:isc.echoLeaf","staticMethod:isc.logEcho","staticMethod:isc.logEchoAll","staticMethod:isc.addProperties","staticMethod:isc.getKeys","staticMethod:isc.firstKey","staticMethod:isc.getValues","staticMethod:isc.sortObject","staticMethod:isc.sortObjectByProperties","staticMethod:isc.addDefaults","staticMethod:isc.propertyDefined","staticMethod:isc.defineClass","staticMethod:isc.overwriteClass","staticMethod:isc.eval","staticMethod:isc.timeStamp","staticMethod:isc.showConsole","staticMethod:isc.getValueForKey","staticMethod:isc.getKeyForValue","staticMethod:isc.makeReverseMap","staticMethod:isc.observe","staticMethod:isc.ignore","staticMethod:isc.createErrorResult","staticMethod:isc.rejectWithError","staticMethod:isc.defaultAsyncOperationCatchCallback","staticMethod:isc.getAsyncMessage","staticMethod:isc.setAutoDraw","staticMethod:isc.clone","staticMethod:isc.shallowClone","staticMethod:isc.setScreenReaderMode","staticMethod:isc.notify","staticMethod:isc.getIconLeft","staticMethod:isc.getIconTop","staticMethod:isc.getIconRect","staticMethod:isc.getIconPageRect","staticMethod:isc.setRadioGroup"],classMethods:[],classAttrs:[],attrs:[],ref:"object:isc",deprecated:null,treeLocation:["Client Reference/System"],description:"<code>window.isc</code> is the base object for the Isomorphic SmartClient framework. \n Every SmartClient class is available on this object as <code>isc.<i>ClassName</i></code>.\n The <code>isc</code> also contains a number of static utility methods.\n <P>\n See also ${isc.DocUtils.linkForRef('group:simpleNamesMode','Simple Names mode')}.",methods:[],name:"isc"},"attr:TabSet.symmetricEdges":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:TabSet",groups:["appearance"],deprecated:null,ref:"attr:TabSet.symmetricEdges",valueType:"Boolean",description:"If this tabSet will ${isc.DocUtils.linkForRef('attr:TabSet.showPaneContainerEdges','show edges')} for the paneContainer,\n this property determines whether the same edge media will be used regardless of the tab\n bar position, or whether different media should be used (necessary if the edge appearance is\n not symmetrical on all sides).\n <P>\n If this property is set to false the paneContainer edge image URLs will be prefixed with\n the tabBarPosition of the tabSet - for example <code>\"[SKIN]edge_top_T.gif\"</code> rather\n than just <code>\"[SKIN]edge_T.gif\"</code>.\n <P>\n When <code>symmetricEdges</code> is false, custom edge sizes for the pane container may be\n specified via ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeSizes')} et al, and custom edge offsets via \n ${isc.DocUtils.linkForRef('attr:TabSet.topEdgeOffsets')} et al.",flags:"IR",name:"symmetricEdges"},"attr:DataSourceField.initRequiresAuthentication":{seeAlso:[{ref:"attr:DataSourceField.editRequiresAuthentication",description:null}],defaultValue:"null",requiresModules:["SCServer"],type:"attr",definingClass:"object:DataSourceField",groups:["fieldLevelAuth","declarativeSecurity"],ref:"attr:DataSourceField.initRequiresAuthentication",deprecated:null,valueType:"boolean",description:"Whether a user must be authenticated in order to initialize to this field.  If this property is \n set and the user is not authenticated, the SmartClient Server will not allow this field to\n be initialized.",flags:"IR",serverDS:"only",name:"initRequiresAuthentication"},"attr:RPCRequest.isBackgroundRequest":{seeAlso:[],ref:"attr:RPCRequest.isBackgroundRequest",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:RPCRequest",valueType:"Boolean",description:"Is this a background request?\n <P>\n This attribute may be set to true for requests that \n do not interfere with the normal flow of user interaction\n within an application.\n <P>\n Background requests are ignored by ${isc.DocUtils.linkForRef('classMethod:AutoTest.waitForSystemDone')},\n giving automated testing tools a way to identify specific\n operations that should not interfere with the flow of the test,\n without entirely disabling the ability to \n ${isc.DocUtils.linkForRef('attr:SystemWaitConfig.includeNetworkOperations','wait for network operations')}.",flags:"IRW",name:"isBackgroundRequest"},"type:DSInheritanceMode":{groups:["fields"],seeAlso:[],ref:"type:DSInheritanceMode",deprecated:null,type:"type",values:[{value:'"full"',description:"Inherit fields by copying them onto the inheriting DataSource's underlying table.  When we \n import a DataSource with this inheritanceMode, we create actual columns for inherited fields\n  on the table we create.  With this inheritanceMode, inherited fields are updatable."},{value:'"none"',description:"Do not physically inherit fields onto the inheriting DataSource's SQL table.  Columns will\n not be created for inherited fields on import, and all generated SQL operations will exclude\n inherited fields.  However, those fields are still part of the DataSource's schema so you\n can, for example, write ${isc.DocUtils.linkForRef('group:customQuerying','custom SQL')} that returns values for \n the inherited fields, and they will be delivered to the client."}],description:"For DataSources of type \"sql\" and \"hibernate\", specifies the kind of inheritance to use when a dataSource\n specifies ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inheritsFrom')}.",serverDS:"only",name:"DSInheritanceMode"},"attr:Canvas.canDropFiles":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["dragdrop"],deprecated:null,ref:"attr:Canvas.canDropFiles",valueType:"Boolean",description:"Set this property to true to enable HTML5 file upload by dropping files into this canvas\n from the desktop (in browsers where this feature is supported by the browser).\n <P>\n To make use of this feature, developers should set ${isc.DocUtils.linkForRef('attr:Canvas.canDrop')} to true.\n This will cause standard drop events (${isc.DocUtils.linkForRef('method:Canvas.dropOver')}, ${isc.DocUtils.linkForRef('method:Canvas.dropOut')}, ${isc.DocUtils.linkForRef('method:Canvas.dropMove')} and\n ${isc.DocUtils.linkForRef('method:Canvas.drop')}) to fire when the user drags a file onto this canvas.\n <P>\n The dropped file(s) may be retrieved as a list of JavaScript File objects via\n ${isc.DocUtils.linkForRef('classMethod:EventHandler.getNativeDragData')}",flags:"IR",name:"canDropFiles"},"attr:Shuttle.fetchOperation":{seeAlso:[],ref:"attr:Shuttle.fetchOperation",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Shuttle",valueType:"String",description:"${isc.DocUtils.linkForRef('attr:DSRequest.operationId','OperationId')} for fetching records from the\n shuttle's ${isc.DocUtils.linkForRef('class:DataSource')}.",flags:"IR",name:"fetchOperation"},"method:Array.getUniquePropertyValues":{seeAlso:[],type:"method",definingClass:"object:Array",returns:{type:"Array",description:"array of unique property values in order encountered"},groups:["subset"],deprecated:null,ref:"method:Array.getUniquePropertyValues",params:[{defaultValue:null,optional:false,type:"String",description:"the property name to extract",name:"property"}],description:' Optimized method combining getProperty() and getUniqueItems() into a single pass.\n Returns an array of unique values for the specified property, preserving the order\n in which values were first encountered.\n <P>\n This method is significantly faster than chaining <code>array.getProperty(prop).getUniqueItems()</code>\n because it:\n <ul>\n <li>Uses forward iteration (much faster than backward iteration in V8)</li>\n <li>Uses Set for O(1) uniqueness checking instead of Array.contains() which is O(n)</li>\n <li>Avoids creating an intermediate array with all property values</li>\n </ul>\n <P>\n Usage example:<br>\n &nbsp;&nbsp;&nbsp;&nbsp;// Instead of: uniqueValues = fundAssetList.getProperty("securityType").getUniqueItems();<br>\n &nbsp;&nbsp;&nbsp;&nbsp;uniqueValues = fundAssetList.getUniquePropertyValues("securityType");\n\n',flags:"",name:"getUniquePropertyValues"},"method:DrawItem.setMoveKnobOffset":{seeAlso:[],ref:"method:DrawItem.setMoveKnobOffset",deprecated:null,type:"method",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:true,type:"Array of int[]",description:"the new move knob offset. This is a 2-element array of [left offset, top offset]. If null, then <code>[0,0]</code>\n  is assumed.",name:"newMoveKnobOffset"}],description:" Setter for ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobOffset')}.\n",flags:"A",examples:["${isc.DocUtils.linkForExampleId('drawKnobs')}"],name:"setMoveKnobOffset"},"attr:TreeMenuButton.treeMenu":{seeAlso:[],ref:"attr:TreeMenuButton.treeMenu",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TreeMenuButton",valueType:"AutoChild Menu",description:"AutoChild menu displayed when the button is clicked.",flags:"IR",name:"treeMenu"},"attr:FusionChart.chartURL":{seeAlso:[],ref:"attr:FusionChart.chartURL",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FusionChart",valueType:"URL",description:"Full URL to the chart.  Needed only if you have renamed the charts such that automatic\n URL formation won't work.",flags:"IR",name:"chartURL"},"class:EventHandler":{seeAlso:[{ref:"type:PageEvent",description:null},{ref:"classMethod:Page.setEvent",description:null},{ref:"classMethod:Page.clearEvent",description:null},{ref:"class:Canvas#methods#widgetEvents",description:null}],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:["classMethod:EventHandler.getNativeMouseTarget","classMethod:EventHandler.getFocusCanvas","classMethod:EventHandler.setDragTrackerImage","classMethod:EventHandler.getNativeDragData","classMethod:EventHandler.setNativeDragData","classMethod:EventHandler.getWheelDelta","classMethod:EventHandler.getWheelDeltaX","classMethod:EventHandler.getWheelDeltaY","classMethod:EventHandler.setDragOffset","classMethod:EventHandler.setDragTracker","classMethod:EventHandler.getDragRect","classMethod:EventHandler.getTarget","classMethod:EventHandler.getDragTarget","classMethod:EventHandler.getX","classMethod:EventHandler.getY","classMethod:EventHandler.leftButtonDown","classMethod:EventHandler.rightButtonDown","classMethod:EventHandler.middleButtonDown","classMethod:EventHandler.getKeyEventCharacterValue","classMethod:EventHandler.getKeyEventCharacter","classMethod:EventHandler.getKey","classMethod:EventHandler.getKeyEventKey","classMethod:EventHandler.getReportedKey","classMethod:EventHandler.getKeyEventCode","classMethod:EventHandler.shiftKeyDown","classMethod:EventHandler.ctrlKeyDown","classMethod:EventHandler.altKeyDown","classMethod:EventHandler.targetIsMasked"],classAttrs:["classAttr:EventHandler.lastEvent","classAttr:EventHandler.mouseDownEvent","classAttr:EventHandler.IDLE_DELAY","classAttr:EventHandler.STOP_BUBBLING","classAttr:EventHandler.ALL_EDGES","classAttr:EventHandler.showNoDropIndicator","classAttr:EventHandler.synchronousFocusNotifications"],attrs:[],groups:["eventHandling"],ref:"class:EventHandler",deprecated:null,treeLocation:["Client Reference/System"],description:"\n The ISC system provides a predictable cross-browser event-handling mechanism for ISC\n widgets. Events can be handled both at the page level (i.e., globally), and at the level of\n individual widgets.\n <p>\n With the exception of a few page-specific events ('load', 'unload', 'idle' and 'resize'),\n events are processed in the following sequence:\n <p>\n 1. The event is sent to any global (page-level) event handlers. These handlers can cancel\n further propagation of the event by returning false.  You can register to listen for any of the\n events linked in the seeAlso section (below) by calling ${isc.DocUtils.linkForRef('classMethod:Page.setEvent')}\n method.\n <p>\n 2. If the event occurred on a form element or a link, it is passed on to the browser so that\n the element will perform its default action. No widget receives the event.\n <p>\n 3. If the event occurred on an enabled widget (but not on a form element or link inside\n the widget), it is sent to that widget's event handler, if any. This handler can cancel\n further propagation of the event by returning false.  An \"enabled\" widget is any widget that\n defines an event handler for one of the supported events.  Interceptable events are defined in\n the ${isc.DocUtils.linkForRef('class:Canvas#methods#events','\"widgetEvents\" section of Canvas')}.\n <p>\n 4. The event is \"bubbled\" up to the widget's parent in the containment hierarchy, if any.\n Again, the parent's handler for the event can cancel further propagation by returning\n false. This step is repeated, with the event \"bubbling\" up through the containment\n hierarchy, until a top-level widget is reached or the event is explicitly canceled.\n In brief, the ISC event model offers the best features of browser event models:\n <ul>\n <li> Page-first event handling allows you to reliably process or cancel any event before it\n      affects the objects on the page.\n <li> Event \"bubbling\" ensures that parent widgets receive events sent to their children,\n      and allows you to create generalized parent-level handlers rather than duplicating\n      code in each child.\n </ul>\n Note: Canceling propagation of an event may cancel its side effects as well, including the\n generation of other (synthetic) events. For example, if a global mouseDown handler returns\n false, drag-and-drop events will not be generated. Specific effects are discussed in the\n descriptions of the various events in the following sections.\n <p>\n SmartClient libraries will not interfere with native event handling when events occur\n outside of a target widget. You can therefore have HTML that is not ISC-based on the same\n page as widget objects that will react to native events as you would expect.\n <p>\n You can use isc.Event as an alias for isc.EventHandler.\n \n ",methods:[],name:"EventHandler"},"attr:DynamicForm.clipItemTitles":{seeAlso:[],ref:"attr:DynamicForm.clipItemTitles",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:DynamicForm",valueType:"boolean",description:"Should the titles for form items be clipped if they are too large for the available \n space?\n <p>\n Can be overridden for individual items via ${isc.DocUtils.linkForRef('attr:FormItem.clipTitle')}.",flags:"IRW",name:"clipItemTitles"},"method:Layout.setLayoutMargin":{groups:["layoutMargin"],seeAlso:[],ref:"method:Layout.setLayoutMargin",deprecated:null,type:"method",definingClass:"class:Layout",params:[{defaultValue:null,optional:true,type:"Integer",description:"optional new setting for layout.layoutMargin.  Regardless of whether a new                          layout margin is passed, the layout reflows according to the current settings\n                          for layoutStartMargin et al",name:"newMargin"}],description:" Method to force a reflow of the layout after directly assigning a value to any of the\n layout*Margin properties. Takes no arguments.\n\n",flags:"",name:"setLayoutMargin"},"attr:Dialog.messageStyle":{seeAlso:[],ref:"attr:Dialog.messageStyle",defaultValue:'"normal"',deprecated:null,type:"attr",definingClass:"class:Dialog",valueType:"CSSStyleName",description:"Style to apply to the message text shown in the center of the dialog",flags:"IR",name:"messageStyle"},"type:KnobType":{seeAlso:[],ref:"type:KnobType",deprecated:null,type:"type",values:[{value:'"resize"',description:"Display up to 8 control knobs at the corners specified by ${isc.DocUtils.linkForRef('attr:DrawItem.resizeKnobPoints')},\n  allowing the user to drag-resize the item.\n  See also ${isc.DocUtils.linkForRef('attr:DrawItem.cornerResizeKnob')} and ${isc.DocUtils.linkForRef('attr:DrawItem.sideResizeKnob')}."},{value:'"move"',description:"Display a control knob for moving the item around. See also ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobPoint')}\n  and ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobOffset')}"},{value:'"startPoint"',description:"Control knob  to manipulate ${isc.DocUtils.linkForRef('attr:DrawLine.startPoint')}."},{value:'"endPoint"',description:"Control knob to manipulate ${isc.DocUtils.linkForRef('attr:DrawLine.endPoint')}."},{value:'"controlPoint1"',description:"Display a draggable control knob along with a DrawLine indicating the angle between controlPoint1\n  and the startPoint. Dragging the knob will adjust controlPoint1."},{value:'"controlPoint2"',description:"Display a draggable control knob along with a DrawLine indicating the angle between controlPoint2\n  and the endPoint. Dragging the knob will adjust controlPoint2."},{value:'"rotate"',description:"Display a rotation knob above the top resize knob, allowing the user to rotate the item.\n  See also ${isc.DocUtils.linkForRef('attr:DrawItem.rotateKnob')}."}],description:"Entries for the ${isc.DocUtils.linkForRef('attr:DrawItem.knobs')} array. Each specified knobType will enable some UI \n allowing the user to manipulate the DrawItem directly.\n <p>\n <b>NOTE:</b> Not all knob types are supported by each DrawItem type. Refer to the DrawItem\n type's ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','knobs')} attribute documentation for a list of the supported knob types.",name:"KnobType"},"method:TileGrid.recordClick":{seeAlso:[],type:"method",definingClass:"class:TileGrid",groups:["events"],deprecated:null,ref:"method:TileGrid.recordClick",params:[{defaultValue:null,optional:false,type:"TileGrid",description:"the TileGrid itself",name:"viewer"},{defaultValue:null,optional:false,type:"Canvas",description:"the tile that was clicked on",name:"tile"},{defaultValue:null,optional:false,type:"TileRecord",description:"the record that was clicked on",name:"record"}],description:" Executed when the tileGrid receives a 'click' event on a\n tile. The default implementation does nothing -- override to perform some action\n when any record is clicked.<br>\n A record event handler can be specified either as\n a function to execute, or as a string of script to evaluate. If the handler is defined\n as a string of script, all the parameters below will be available as variables for use\n in the script.<br>\n If you want to cancel the click based on the parameters, return false. Otherwise, return \n true so that the click event be registered with the tile.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('tilingEditing')}"],name:"recordClick"},"attr:DataBoundComponent.emptyGeneratedHoverContents":{seeAlso:[],defaultValue:'"(Empty)"',type:"attr",definingClass:"interface:DataBoundComponent",groups:["pseudoFieldGeneration","i18nMessages"],deprecated:null,ref:"attr:DataBoundComponent.emptyGeneratedHoverContents",valueType:"HTMLString",description:"Hover contents to use when the generated hover contents are empty",flags:"IRW",name:"emptyGeneratedHoverContents"},"attr:TimeItem.hourItemPrompt":{seeAlso:[],defaultValue:'"Choose hours"',type:"attr",definingClass:"class:TimeItem",groups:["i18nMessages"],deprecated:null,ref:"attr:TimeItem.hourItemPrompt",valueType:"HTMLString",description:"The hover prompt to show for the ${isc.DocUtils.linkForRef('attr:TimeItem.hourItem','hour picker')}.",flags:"IRW",name:"hourItemPrompt"},"attr:DataSource.resultBatchSize":{seeAlso:[],defaultValue:"150",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.resultBatchSize",valueType:"int",description:'Very advanced: for servers that do not support paging, and must return large numbers of XML\n records in one HTTP response, SmartClient breaks up the processing of the response\n in order to avoid the "script running slowly" dialog appearing for an end user.\n <P>\n If you have a relatively small number of records with a great deal of properties or\n subobjects on each record, and you have not set ${isc.DocUtils.linkForRef(\'attr:DataSource.dropExtraFields\')} to eliminate unused\n data, and you see the "script running slowly" dialog, you may need to set this number\n lower.',flags:"IRWA",serverDS:"allowed",name:"resultBatchSize"},"attr:TextAreaItem.selectOnFocus":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:TextAreaItem",groups:["focus"],deprecated:null,ref:"attr:TextAreaItem.selectOnFocus",valueType:"boolean",description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus','selectOnFocus')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus')}.",flags:"IRW",name:"selectOnFocus"},"attr:ListGrid.filterWindowCriteriaIndicator":{seeAlso:[],ref:"attr:ListGrid.filterWindowCriteriaIndicator",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"AutoChild Canvas",description:"Instance of ${isc.DocUtils.linkForRef('class:Canvas')} used to show visual indicator that ${isc.DocUtils.linkForRef('attr:ListGrid.filterWindowCriteria')}\n is configured. ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterWindowCriteriaIndicator')} must be enabled to show indicator.",flags:"IR",name:"filterWindowCriteriaIndicator"},"object:SerializationSettings":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:SerializationSettings.serverless","attr:SerializationSettings.indent","attr:SerializationSettings.outputComponentsIndividually"],groups:["devTools"],ref:"object:SerializationSettings",deprecated:null,treeLocation:["Client Reference/Tools"],description:"Settings to control ${isc.DocUtils.linkForRef('class:EditContext')} serialization.",methods:[],name:"SerializationSettings"},"type:FieldFilterMode":{seeAlso:[],ref:"type:FieldFilterMode",deprecated:null,type:"type",values:[{value:'"both"',description:"- filter on the client where possible and contact the server when necessary"},{value:'"serverOnly"',description:'- any change to criteria for a field causes cache invalidation and a   trip to the server.  This mode is quite useful for cases where client filtering can\'t \n  replicate server filtering, such as:\n  <ul>\n    <li> search engines that consider something a match based on word roots (like treating \n      "sunken" as a match for "sink")</li>\n    <li> server-side formatting, where values are delivered as HTML or even as images, \n      where the value seen in the browser no longer matches the search text</li>\n    <li> searching large files where the files won\'t be delivered to the client</li>\n </ul>\n By using this mode only for fields that are special, you can preserve the performance \n benefits of client-side filtering on other fields.'}],description:"Indicates where a given field can be legally filtered.  By default, any field where\n ${isc.DocUtils.linkForRef('attr:DataSourceField.canFilter')} isn't <code>false</code> allows filtering either at the \n server or at the ${isc.DocUtils.linkForRef('attr:ResultSet.useClientFiltering','client')}, according to related settings.\n <p>\n This is the recommended behavior, but it can be useful or necessary to limit filtering \n in some cases.",name:"FieldFilterMode"},"attr:Button.iconStyle":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Button",groups:["buttonIcon"],ref:"attr:Button.iconStyle",deprecated:null,setter:["setIconStyle"],valueType:"CSSStyleName",description:"Base CSS style applied to the icon image. If set, as the <code>StatefulCanvas</code> changes\n ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state','state')} and/or is ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected','selected')},\n suffixes will be appended to <code>iconStyle</code> to form the className set on the\n image element.\n <p>\n The following table lists out the standard set of suffixes which may be appended:\n <table border=1>\n <tr><th>CSS Class Applied</th><th>Description</th></tr>\n <tr><td><code><i>iconStyle</i></code></td><td>Default CSS style</td></tr>\n <tr><td><code><i>iconStyle</i>+Selected</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.selected')} and ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showSelectedIcon')}\n      are true.</td></tr>\n <tr><td><code><i>iconStyle</i>+Focused</code></td>\n      <td>Applied when the component has keyboard focus, if\n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedIcon')} is true, and\n      ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is not true.</td></tr>\n <tr><td><code><i>iconStyle</i>+Over</code></td>\n      <td>Applied when ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOverIcon')} is set to true and either\n      the user rolls over the component or ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true\n      and the component has keyboard focus.</td></tr>\n <tr><td><code><i>iconStyle</i>+Down</code></td>\n      <td>Applied when the user presses the mouse button on the component if\n          ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDownIcon')} is set to true</td></tr>\n <tr><td><code><i>iconStyle</i>+Disabled</code></td>\n      <td>Applied when the component is ${isc.DocUtils.linkForRef('attr:Canvas.disabled','disabled')}\n       if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabledIcon')} is true.</td></tr>\n <tr><td colspan=2><i>Combined styles</i></td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocused</code></td>\n      <td>Combined Selected and focused styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedOver</code></td>\n      <td>Combined Selected and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+FocusedOver</code></td>\n      <td>Combined Focused and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocusedOver</code></td>\n      <td>Combined Selected, Focused and rollOver styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedDown</code></td>\n      <td>Combined Selected and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+FocusedDown</code></td>\n      <td>Combined Focused and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedFocusedDown</code></td>\n      <td>Combined Selected, Focused and mouse-down styling</td></tr>\n <tr><td><code><i>iconStyle</i>+SelectedDisabled</code></td>\n      <td>Combined Selected and Disabled styling</td></tr>\n </table>\n <p>\n In addition, if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRTLIcon')} is true, then in RTL mode, a final\n \"RTL\" suffix will be appended.",flags:"IRW",name:"iconStyle"},"classMethod:DataSource.discardAllQueuedChanges":{seeAlso:[],ref:"classMethod:DataSource.discardAllQueuedChanges",deprecated:null,type:"classMethod",definingClass:"class:DataSource",params:[{defaultValue:null,optional:true,type:"Criteria | AdvancedCriteria",description:"Optional filter",name:"criteria"}],description:" Discards queued changes across ALL DataSources. Useful for test cleanup.\n\n",flags:"",returns:{type:"int",description:"Total requests discarded across all DataSources"},name:"discardAllQueuedChanges"},"attr:Slider.valueStyle":{seeAlso:[],ref:"attr:Slider.valueStyle",defaultValue:'"sliderValue"',deprecated:null,type:"attr",definingClass:"class:Slider",valueType:"CSSStyleName",description:"CSS style for the floating ${isc.DocUtils.linkForRef('attr:Slider.valueLabel','valueLabel')}, visible when\n ${isc.DocUtils.linkForRef('attr:Slider.showValue')} is true.",flags:"IR",name:"valueStyle"},"attr:ListGrid.clearAllSortingText":{seeAlso:[],defaultValue:'"Clear All Sorting"',type:"attr",definingClass:"class:ListGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:ListGrid.clearAllSortingText",valueType:"String",description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, this\n attribute will be shown as the menu item title to clear any existing sort on all fields.  This\n menu-item is displayed only in the context menu for the sorter button.",flags:"IRW",name:"clearAllSortingText"},"method:ListGrid.getRowCountStatus":{groups:["rowRangeDisplay"],seeAlso:[],ref:"method:ListGrid.getRowCountStatus",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" This method indicates whether ${isc.DocUtils.linkForRef('method:ListGrid.getRowCount')} reflects an accurate\n row-count for this listGrid. An accurate row count may not currently be available\n if ${isc.DocUtils.linkForRef('attr:DataSource.progressiveLoading','progressiveLoading')} is active.\n <P>\n See ${isc.DocUtils.linkForRef('type:RowCountStatus')} for further details.\n\n",flags:"",returns:{type:"RowCountStatus",description:"Current row-count status for this grid"},name:"getRowCountStatus"},"method:EventStream.getAsSeleneseCommands":{seeAlso:[],type:"method",definingClass:"class:EventStream",returns:{type:"Array of SeleniumCommand",description:null},groups:["automatedTesting","experimental"],deprecated:null,ref:"method:EventStream.getAsSeleneseCommands",params:[{defaultValue:null,optional:true,type:"SeleneseSettings",description:null,name:"settings"}],description:" Creates and returns Selenese that represents the events captured by the stream as an array\n of ${isc.DocUtils.linkForRef('object:SeleniumCommand','Selenium commands')}.  Compare with ${isc.DocUtils.linkForRef('method:EventStream.getAsSeleneseHTML')},\n where you'll also find more common details.\n <P>\n Just as when retrieving the Selenese as HTML, if a ${isc.DocUtils.linkForRef('method:EventStream.transformSelenese')} function has\n been defined, it's called before returning the Selenese.\n",flags:"",name:"getAsSeleneseCommands"},"attr:ColorPicker.satFieldTitle":{seeAlso:[],defaultValue:'"Sat"',type:"attr",definingClass:"class:ColorPicker",groups:["i18nMessages"],deprecated:null,ref:"attr:ColorPicker.satFieldTitle",valueType:"HTMLString",description:"The title for the 'Sat' field in the complex chooser.",flags:"IR",name:"satFieldTitle"},"attr:DataSource.beanClassName":{seeAlso:[{ref:"attr:OperationBinding.beanClassName",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.beanClassName",valueType:"String",description:"This property has different meanings depending on the ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')}:\n <p>\n <b>For SQL DataSources (DataSources with serverType \"sql\")</b><br>\n If set, results from the database will be used to create one instance of the indicated Java\n bean per database row.  Otherwise a Map is used to represent each row retrieved from SQL.\n <P>\n With this feature active, a DSResponse from this DataSource will contain a Collection of\n instances of the indicated <code>beanClassName</code>, available via DSResponse.getData().\n This creates a couple of possibilities:\n <P>\n <dl>\n <dt>Add business logic for derived properties, such as computed formulas</dt>\n <dd>For example, declare a DataSourceField named \"revenueProjection\".  By default this\n field will call getRevenueProjection() on your bean to retrieve the value to send to the\n client.  Your implementation of getRevenueProjection() could apply some kind of formula to\n other values loaded from the database.</dd>\n <dt>Call business logic on retrieved beans via DMI</dt>\n <dd>By adding a ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} method that calls DSRequest.execute() to retrieve a DSResponse,\n you have an opportunity to call business logic methods on the beans representing each\n row affected by the DSRequest.  For example, notify a related BPEL process of changes to\n certain fields.</dd>\n </dl>\n <P>\n By using <code>beanClassName</code> on a specific ${isc.DocUtils.linkForRef('class:OperationBinding')}, you can:\n <ul>\n <li>Use a bean to represent your data only when it matters; for example, avoid the overhead\n     of using a bean for \"fetch\" operations, but do use a bean for \"update\" operations so\n     that you can execute relevant business logic after the update completes.</li>\n <li>Skip the use of beans for complex reporting queries that produce results unrelated to\n     your persistent object model.  Set beanClassName to blank (\"\") on a specific\n     operationBinding to override DataSource.beanClassName for that specific operation.</li>\n <li>For SQL joins that produce additional data fields, use a special, operation-specific\n     bean that represents a join of multiple entities and contains business logic specific\n     to that joined dataset</li>\n </ul>\n <P>\n Note that <code>beanClassName</code> affects what numeric field types will be used for \n inbound DSRequest data. For fields with numeric types, the ${isc.DocUtils.linkForRef('attr:DSRequest.data','record data')} \n in DSRequests will automatically be converted to the type of the target field, before the \n request is received in a ${isc.DocUtils.linkForRef('class:DMI')}.  For details, see ${isc.DocUtils.linkForRef('group:dsRequestBeanTypes')}.\n <p>\n Note that ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} also has a built-in facility for populating a bean \n with the inbound ${isc.DocUtils.linkForRef('attr:DSRequest.data')} - just declare the bean as a method argument.\n <p>\n <b>For generic DataSources (DataSources with serverType \"generic\")</b><br>\n ${isc.DocUtils.linkForRef('group:reify','Reify')} sets this property when it creates a generic \n DataSource using the Javabean Wizard.  It has no built-in server-side effects.\n <p>\n <b>For Hibernate DataSources (DataSources with serverType \"hibernate\")</b><br>\n The name of the Java bean or POJO class that is mapped in Hibernate.  This will typically \n be the fully-qualified class name - eg <code>com.foo.MyClass</code> - but it may be the \n simple class name - just <code>MyClass</code> - or it may be some other value.  It all \n depends on how your classes have been mapped in Hibernate.\n <p>\n The declared Java bean will affect how its properties will be mapped to built-in numeric \n types, see ${isc.DocUtils.linkForRef('group:hibernateIntegration','Hibernate Integration overview')} for details.\n <p>\n Note:  If you are intending to use Hibernate as a data-access layer only, \n you do not need to create Hibernate mappings or Java objects: SmartClient will generate\n everything it needs on the fly.\n <p>\n <b>For JPA DataSources (DataSources with serverType \"jpa\" or \"jpa1\")</b><br>\n The fully qualified class name of the JPA annotated entity.\n <p>\n <b>NOTE for Hibernate and JPA users:</b> When you use JPA, or use Hibernate as a full ORM\n system (ie, not just allowing SmartClient Server to drive Hibernate as a data access layer),\n the beans returned on the server-side are <b>live</b>.  This means that if you make any \n changes to them, the ORM system will persist those changes.  This is true even if the beans\n were created as part of a fetch operation.\n <p>\n This causes a problem in the common case where you want to use a DMI or custom DataSource \n implementation to apply some post-processing to the beans fetched from the persistent \n store.  If you change the values in the beans directly, those changes will be persisted.\n <p>\n If you want to alter the data returned from a JPA or Hibernate persistent store as part of\n a fetch request just so you can alter what gets sent to the client, you can use the \n server-side <code>DSResponse</code>'s <code>getRecords()</code> method.  This will return\n your bean data in \"record\" format - ie, as a List of Maps.  You can alter these records \n without affecting your persistent store, and then call <code>setData()</code> on the \n <code>DSResponse</code>), passing the altered list of records.  See the server-side Javadocs\n for <code>DSResponse</code> for details of these two methods.",flags:"IR",serverDS:"only",name:"beanClassName"},"attr:StatefulCanvas.state":{seeAlso:[{ref:"type:State",description:null},{ref:"group:state",description:null}],defaultValue:'""',type:"attr",definingClass:"class:StatefulCanvas",getter:["getState"],groups:["state"],ref:"attr:StatefulCanvas.state",deprecated:null,valueType:"State",setter:["setState"],description:"Current \"state\" of this widget. The state setting is automatically updated as the \n user interacts with the component (see ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')}, \n ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDown')}, ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabled')}).\n <P>\n StatefulCanvases will have a different appearance based\n on their current state. \n By default this is handled by changing the css className applied to\n the StatefulCanvas - see ${isc.DocUtils.linkForRef('attr:StatefulCanvas.baseStyle')} and \n ${isc.DocUtils.linkForRef('method:StatefulCanvas.getStateSuffix')} for a description of how this is done.\n <P>\n For ${isc.DocUtils.linkForRef('class:Img')} or ${isc.DocUtils.linkForRef('class:StretchImg')} based subclasses of StatefulCanvas, the \n appearance may also be updated by changing the src of the rendered image. See\n ${isc.DocUtils.linkForRef('attr:Img.src')} and ${isc.DocUtils.linkForRef('attr:StretchImgButton.src')} for a description of how the URL \n is modified to reflect the state of the widget in this case.",flags:"IRWA",name:"state"},"group:reflection":{refs:[],seeAlso:[],ref:"group:reflection",deprecated:null,type:"group",title:"Registering Classes for Reflection",description:"In order to specify a SmartGWT class as a constructor in\n ${isc.DocUtils.linkForRef('group:componentXML','Component XML')} or \n ${isc.DocUtils.linkForRef('group:componentSchema','Component Schema')},\n or for other purposes, such as for \n {@link com.smartgwt.client.docs.AutoChildUsage autoChildren} or for \n {@link com.smartgwt.client.data.DataSourceField#setEditorType(Class)}, \n you must first register the class with the \n {@link com.smartgwt.client.bean.BeanFactory} reflection mechanism.\n <p>\n If you want to register {@link com.smartgwt.client.widgets.Canvas}\n and all its subclasses found in the classpath (including your custom subclasses), \n you can use the {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory}\n interface to do this automatically:\n <blockquote><pre>\n GWT.create(BeanFactory.CanvasMetaFactory.class);</pre></blockquote>\n <p>\n Similarly, to register {@link com.smartgwt.client.widgets.form.fields.FormItem}\n and all its subclasses found in the classpath (including your custom subclasses),\n you can use the {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}.\n <blockquote><pre>\n GWT.create(BeanFactory.FormItemMetaFactory.class);</pre></blockquote>\n <p>\n Alternatively, if only specific classes need to be instantiated and\n configured dynamically, you can register just those classes by annotating\n them with the {@link com.smartgwt.client.bean.BeanFactory.Generate}\n annotation instead. For instance:\n <blockquote><pre>\n {@literal @}BeanFactory.Generate\n public class MyCanvas extends Canvas {\n     ...\n }</pre></blockquote>\n <p>\n For framework classes (where you cannot annotate the class directly), you\n can supply an array of Class literals to the annotation. For instance:\n <blockquote><pre>\n {@literal @}BeanFactory.Generate({Canvas.class, TreeGrid.class})\n public interface EmptyInterface {\n     ...\n }</pre></blockquote>\n <p>\n When you supply an array of class literals, the class you annotate\n (here <code>EmptyInterface</code>) will <b>not</b> itself have a \n BeanFactory generated for it. Thus, you can use an empty inner\n interface for this purpose.\n <p>\n If there are only a limited number of classes which require dynamic\n configuration, it will save code size to use the\n {@link com.smartgwt.client.bean.BeanFactory.Generate} annotation to generate\n factories for those specific types, rather than using \n {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory} or\n {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}. Once a factory\n is generated for a class, GWT's opportunities to prune dead code are more\n limited for that class, since it cannot know what properties will be set or\n retrieved at run-time.",name:"reflection"},"attr:DetailViewerField.displayField":{seeAlso:[],ref:"attr:DetailViewerField.displayField",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DetailViewerField",valueType:"FieldName",description:"If <code>displayField</code> is defined for the field then the DetailViewer will\n display the <code>displayField</code> attribute of records instead of the attribute\n given by the ${isc.DocUtils.linkForRef('attr:DetailViewerField.name')} of the field.",flags:"IR",name:"displayField"},"classMethod:Messaging.unsubscribe":{groups:["messaging"],seeAlso:[],ref:"classMethod:Messaging.unsubscribe",deprecated:null,type:"classMethod",definingClass:"class:Messaging",params:[{defaultValue:null,optional:false,type:"String",description:null,name:"channel"}],description:" Unsubscribes the client from the messaging channel identified by channel.\n <p>\n This will cause a reconnect to the server - for this reason\n we defer the actual reconnect to allow for multiple unsubscribe() calls in sequence.\n\n",flags:"",name:"unsubscribe"},"attr:ListGrid.booleanPartialImage":{seeAlso:[{ref:"attr:ListGrid.booleanTrueImage",description:null},{ref:"attr:ListGrid.booleanFalseImage",description:null},{ref:"attr:ListGrid.printBooleanPartialImage",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["imageColumns"],deprecated:null,ref:"attr:ListGrid.booleanPartialImage",valueType:"SCImgURL",description:"Image to display for a partially true value in a boolean field (typically selection).\n The special value \"blank\" means that no image will be shown.\n <P>\n To turn this off explicitly set ${isc.DocUtils.linkForRef('attr:ListGridField.suppressValueIcon')} to true.\n <P>\n If this, ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}\n are unset, this will be set to the default ${isc.DocUtils.linkForRef('attr:CheckboxItem.partialSelectedImage')}.\n <P>\n ${isc.DocUtils.linkForRef('group:skinning','Spriting')} can be used for this image, by setting this property to\n a ${isc.DocUtils.linkForRef('type:SCSpriteConfig')} formatted string. Alternatively developers can\n omit this property and instead use CSS directly in the \n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanBaseStyle')} property to provide a \"boolean true\" appearance.",flags:"IRWA",name:"booleanPartialImage"},"method:Calendar.setZones":{seeAlso:[],ref:"method:Calendar.setZones",deprecated:null,type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"Array of CalendarEvent",description:"array of zones to display",name:"zones"}],description:" Sets the ${isc.DocUtils.linkForRef('attr:Calendar.zones','zones')} used to highlight areas of this calendar.\n\n",flags:"",name:"setZones"},"attr:ListGrid.headerButtonProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["gridHeader","appearance"],deprecated:null,ref:"attr:ListGrid.headerButtonProperties",valueType:"Button Properties",description:"Properties to apply to all header buttons.\n Overrides defaults applied via  ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonDefaults')}.",flags:"IRA",name:"headerButtonProperties"},"method:ListGrid.cellErrorIconOut":{seeAlso:[{ref:"attr:ListGrid.showErrorIcons",description:null}],type:"method",definingClass:"class:ListGrid",returns:{type:"Boolean",description:"false to suppress the standard behavior (clear the standard error                    message hover if it is showing)"},groups:["events"],deprecated:null,ref:"method:ListGrid.cellErrorIconOut",params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"cell record as returned by getCellRecord()",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number of the cell",name:"colNum"}],description:" Optional stringMethod to fire when the mouse moves off the error icon of a cell with \n validation errors.\n\n",flags:"A",name:"cellErrorIconOut"},"attr:MultiPickerItem.canSelectFolders":{seeAlso:[],ref:"attr:MultiPickerItem.canSelectFolders",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:MultiPickerItem",valueType:"Boolean",description:"For multiPickerItems with ${isc.DocUtils.linkForRef('type:SelectionStyle','selectionStyle:\"pickTree\"')},\n should the user be able to select and deselect folders?\n <P>\n If false, selection checkboxes will only be visible by leaf nodes within\n the pickTree data set.\n <P>\n Note that this flag may be set to true in conjunction with \n ${isc.DocUtils.linkForRef('attr:MultiPickerItem.includeSelectedParents','includeSelectedParents:false')}. In this case\n the user may check and uncheck parent nodes as a convenient way to \n select or unselect all their children due to\n ${isc.DocUtils.linkForRef('attr:MultiPickerItem.cascadeSelection','cascading selection')}, but the parent nodes themselves\n won't be present in the item's value.",flags:"IR",name:"canSelectFolders"},"classMethod:Time.toShortTime":{seeAlso:[{ref:"classMethod:Time.toTime",description:null}],ref:"classMethod:Time.toShortTime",deprecated:null,type:"classMethod",definingClass:"class:Time",params:[{defaultValue:null,optional:false,type:"Date",description:"Date to convert to a time string.",name:"date"},{defaultValue:null,optional:true,type:"TimeDisplayFormat | FormatString | Function",description:"Optional custom  formatter to use. Will accept a function (which will be passed a pointer to the\n  Date to format), a format string, or a string designating a standard formatter",name:"formatter"},{defaultValue:null,optional:true,type:"boolean",description:"Is the date passed in a representation of a logical time value such as  a value from a <code>\"time\"</code> type field on a dataSource or a datetime value? \n  For datetime values the formatted string will respect any custom \n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','display timezone')}.\n If not explicitly specified, the date passed in will be assumed to be a datetime unless\n it was created explicitly as a time via ${isc.DocUtils.linkForRef('classMethod:Time.createLogicalTime')} or similar APIs.",name:"logicalTime"}],description:" Given a date object, return the time associated with the date as a short string.\n If no formatter is passed, use the standard formatter set up via ${isc.DocUtils.linkForRef('classMethod:Time.setShortDisplayFormat')}\n",flags:"",name:"toShortTime"},"attr:StatefulCanvas.showMenuOnClick":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:StatefulCanvas",groups:["menu"],deprecated:null,ref:"attr:StatefulCanvas.showMenuOnClick",valueType:"Boolean",description:"If true, this widget will fire ${isc.DocUtils.linkForRef('method:Canvas.showContextMenu','showContextMenu()')} to\n show the ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu','context menu')} if one is defined, rather than\n ${isc.DocUtils.linkForRef('method:Canvas.click','click()')}, when the left mouse is clicked.\n <P>\n Note that this property has a different interpretation in ${isc.DocUtils.linkForRef('class:IconButton')} as\n ${isc.DocUtils.linkForRef('attr:RibbonButton.showMenuOnClick','IconButton.showMenuOnClick')}.",flags:"IRW",name:"showMenuOnClick"},"method:DataBoundComponent.getFieldNum":{seeAlso:[],ref:"method:DataBoundComponent.getFieldNum",deprecated:null,type:"method",definingClass:"interface:DataBoundComponent",params:[{defaultValue:null,optional:false,type:"FieldName | Field",description:"field name or field",name:"fieldName"}],description:" Find the index of a currently visible field.\n\n",flags:"",returns:{type:"int",description:"index of field within currently visible fields, or -1 if not found."},name:"getFieldNum"},"attr:AIRequest.cancellationController":{seeAlso:[],ref:"attr:AIRequest.cancellationController",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:AIRequest",valueType:"CancellationController",description:"If provided, the ${isc.DocUtils.linkForRef('class:CancellationController')} that will be looked to for whether the AI\n request is canceled.",flags:"IR",name:"cancellationController"},"attr:DrawnValue.barThickness":{seeAlso:[],ref:"attr:DrawnValue.barThickness",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DrawnValue",valueType:"int",description:"For bar and column charts, thickness of the bar representing this data value.",flags:"IR",name:"barThickness"},"classMethod:DataSource.makeFileSpec":{seeAlso:[],type:"classMethod",definingClass:"class:DataSource",returns:{type:"FileSpec",description:'The equivalent FileSpec, e.g. {fileName: "employees", fileType: "ds",                    fileFormat: xml"}'},groups:["fileSource"],deprecated:null,ref:"classMethod:DataSource.makeFileSpec",params:[{defaultValue:null,optional:false,type:"String",description:'The path to convert, e.g. "employees.ds.xml"',name:"path"}],description:"\n Converts a file path to a ${isc.DocUtils.linkForRef('object:FileSpec')}.\n\n",flags:"",name:"makeFileSpec"},"class:GridTransferDataTask":{seeAlso:[{ref:"method:ListGrid.transferSelectedData",description:null}],type:"class",staticMethods:[],inheritsFrom:"ComponentTask",classMethods:[],classAttrs:[],attrs:["attr:GridTransferDataTask.sourceComponent"],ref:"class:GridTransferDataTask",deprecated:null,treeLocation:["Client Reference/Workflow"],description:"Transfer selected records from one grid to another.",methods:[],name:"GridTransferDataTask"},"method:FacetChart.getDataLineWidth":{seeAlso:[{ref:"attr:DrawItem.lineWidth",description:null},{ref:"method:FacetChart.getDataLineColor",description:null}],ref:"method:FacetChart.getDataLineWidth",deprecated:null,type:"method",definingClass:"class:FacetChart",params:[{defaultValue:null,optional:false,type:"Number",description:"index of the legend facet value to target",name:"index"},{defaultValue:null,optional:false,type:"String | Number | Date",description:"id of the legend facet value to target",name:"facetValueId"},{defaultValue:null,optional:false,type:"String",description:'purpose for the requested width - such as "legend", "line",                         "area", "points", etc.',name:"purpose"}],description:" Specifies the width to use for data lines in the chart.  No default implementation.  If not\n defined or null is returned, the line width will be set by the appropriate chart properties,\n such as ${isc.DocUtils.linkForRef('attr:FacetChart.dataLineProperties')}, ${isc.DocUtils.linkForRef('attr:FacetChart.barProperties')}, or ${isc.DocUtils.linkForRef('attr:FacetChart.bubbleProperties')}.\n \n <P>\n Note that this method is simply an override point, since it has no default implementation.\n \n\n",flags:"",returns:{type:"int",description:"width to use for data lines or null to use ${isc.DocUtils.linkForRef('type:ChartType')} default"},name:"getDataLineWidth"},"attr:DrawLinePath.connectorOrientation":{seeAlso:[],defaultValue:'"auto"',type:"attr",definingClass:"class:DrawLinePath",groups:["line"],deprecated:null,ref:"attr:DrawLinePath.connectorOrientation",valueType:"ConnectorOrientation",description:"The ConnectorOrientation controlling the orientation and behavior of this line's \n tail segments.",flags:"IR",name:"connectorOrientation"},"classAttr:RPCResponse.STATUS_LOGIN_SUCCESS":{seeAlso:[{ref:"object:RPCRequest",description:null}],defaultValue:"-8",type:"classAttr",definingClass:"class:RPCResponse",groups:["statusCodes","constant"],deprecated:null,ref:"classAttr:RPCResponse.STATUS_LOGIN_SUCCESS",valueType:"int",description:"Indicates that the login succeeded.",flags:"R",name:"STATUS_LOGIN_SUCCESS"},"attr:RecordEditor.filterImg":{seeAlso:[],ref:"attr:RecordEditor.filterImg",defaultValue:'"[SKIN]filter.png"',deprecated:null,type:"attr",definingClass:"class:RecordEditor",valueType:"SCImgURL",description:"${isc.DocUtils.linkForRef('attr:Button.icon','Icon')} to show on the ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButton')} if this \n component is being used as a ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor')}.\n <P>\n Note that this ${isc.DocUtils.linkForRef('type:SCImgURL')} will be resolved using the ${isc.DocUtils.linkForRef('attr:RecordEditor.skinImgDir')} defined\n for the RecordEditor.",flags:"IR",name:"filterImg"},"attr:DataSource.auditDataSourceID":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.auditDataSourceID",valueType:"String",description:"For DataSources with ${isc.DocUtils.linkForRef('attr:DataSource.audit','auditing enabled')}, optionally specifies the ID of the audit\n DataSource.  If this property is not specified, the ID of the audit DataSource will\n be <code>audit_[OriginalDSID] </code>",flags:"IR",serverDS:"only",name:"auditDataSourceID"},"type:Double":{seeAlso:[{ref:"type:double",description:null}],ref:"type:Double",treeLocation:["Client Reference/System"],deprecated:null,type:"type",description:'A decimal (or "floating point") number, for example, 5.5.  Null is allowed.',name:"Double",baseType:"Number"},"method:GridRenderer.refreshCellStyle":{groups:["appearance"],seeAlso:[{ref:"method:GridRenderer.refreshCell",description:"to update cell contents too"}],ref:"method:GridRenderer.refreshCellStyle",deprecated:null,type:"method",definingClass:"class:GridRenderer",params:[{defaultValue:null,optional:false,type:"number",description:"row number of cell to refresh",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number of cell to refresh",name:"colNum"}],description:" Refresh the styling of an individual cell without redrawing the grid.\n <P>\n The cell's CSS class and CSS text will be refreshed, to the current values returned by\n getCellStyle() and getCellCSSText() respectively.\n <P>\n The cell's contents (as returned by getCellValue()) will <b>not</b> be refreshed.  To\n refresh both styling and contents, call refreshCell() instead.\n\n",flags:"",name:"refreshCellStyle"},"attr:DataBoundComponent.descriptionField":{seeAlso:[],ref:"attr:DataBoundComponent.descriptionField",defaultValue:"null",deprecated:null,type:"attr",definingClass:"interface:DataBoundComponent",valueType:"String",description:"Name of the field that has a long description of the record, or has the primary text data\n value for a record that represents an email message, SMS, log or similar.\n <P>\n This attribute has the same function as ${isc.DocUtils.linkForRef('attr:DataSource.descriptionField')} but can be\n set for a component with no dataSource, or can be used to override the dataSource setting.",flags:"IR",name:"descriptionField"},"attr:Canvas.animateScrollTime":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["animation"],deprecated:null,ref:"attr:Canvas.animateScrollTime",valueType:"number",description:"Default time for performing an animated scroll.  If unset, <code>this.animateTime</code>\n will be used by default instead",flags:"IRWA",name:"animateScrollTime"},"method:DynamicForm.getEditorType":{seeAlso:[],type:"method",definingClass:"class:DynamicForm",returns:{type:"String",description:"form item type for the field"},groups:["editing"],deprecated:null,ref:"method:DynamicForm.getEditorType",params:[{defaultValue:null,optional:false,type:"Object",description:"field definition for which we are deriving form item type.",name:"field"},{defaultValue:null,optional:true,type:"Object",description:"Current set of values being edited by this form. May be null.",name:"values"}],description:"\n Returns the form item type (Class Name) to be created for some field.<br>\n By default <code>field.editorType</code> will be used if present - otherwise backs off to\n deriving the appropriate form item type from the data type of the field (see\n ${isc.DocUtils.linkForRef('type:FormItemType')} for details).\n\n",flags:"A",name:"getEditorType"},"attr:Calendar.dateEditingStyle":{seeAlso:[],ref:"attr:Calendar.dateEditingStyle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"DateEditingStyle",description:'Indicates the type of controls to use in event-windows.  Valid values are those in the \n ${isc.DocUtils.linkForRef(\'type:DateEditingStyle\',\'DateEditingStyle\')} type.\n <P>\n If unset, the editing style will be set to the field-type on the DataSource, if there is one.\n If there\'s no DataSource, it will be set to "date" if the \n ${isc.DocUtils.linkForRef(\'attr:Calendar.timelineGranularity\',\'granularity\')} is "day" or larger and "time" if granularity \n is "minute" or smaller, otherwise "datetime".',flags:"IR",name:"dateEditingStyle"},"method:Calendar.getMonthViewHoverHTML":{seeAlso:[],ref:"method:Calendar.getMonthViewHoverHTML",deprecated:null,type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"Date",description:"Date the user is hovering over",name:"date"},{defaultValue:null,optional:false,type:"Array of CalendarEvent",description:"array of events occurring on the current date. May be empty.",name:"events"}],description:" This method returns the hover HTML to be displayed when the user hovers over a cell\n displayed in the calendar month view tab.\n <P>\n Default implementation will display a list of the events occurring on the date the user is\n hovering over. Override for custom behavior. Note that returning null will suppress the\n hover altogether.\n\n",flags:"",returns:{type:"HTMLString",description:"HTML string to display"},name:"getMonthViewHoverHTML"},"attr:ListGrid.aiFilterWindowHint":{seeAlso:[],defaultValue:'"Explain which records should be shown"',type:"attr",definingClass:"class:ListGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:ListGrid.aiFilterWindowHint",valueType:"HTMLString",description:"The inline hint-text displayed in the user-entry area in the ${isc.DocUtils.linkForRef('attr:ListGrid.aiFilterWindow')}.",flags:"IR",name:"aiFilterWindowHint"},"attr:FieldPickerWindow.fieldPicker":{seeAlso:[],ref:"attr:FieldPickerWindow.fieldPicker",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FieldPickerWindow",valueType:"AutoChild FieldPicker",description:"A ${isc.DocUtils.linkForRef('class:FieldPicker','FieldPicker')} for altering the working field-set in a \n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','Data-bound component')}.",flags:"IR",name:"fieldPicker"},"method:ResultSet.resort":{seeAlso:[],ref:"method:ResultSet.resort",deprecated:null,type:"method",definingClass:"class:ResultSet",description:" Forcibly resort this ResultSet by the current list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n",flags:"",name:"resort"},"attr:Calendar.zoneTitleOrientation":{seeAlso:[],ref:"attr:Calendar.zoneTitleOrientation",defaultValue:'"bottom"',deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"VerticalAlignment",description:"The vertical alignment of the header-text in each ${isc.DocUtils.linkForRef('attr:Calendar.zones','zone')}.",flags:"IR",name:"zoneTitleOrientation"},"attr:TimeItem.showMillisecondItem":{seeAlso:[],ref:"attr:TimeItem.showMillisecondItem",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"Boolean",description:"Controls whether to display the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem')} when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is false.",flags:"IRW",name:"showMillisecondItem"},"staticMethod:History.setHistoryTitle":{seeAlso:[],ref:"staticMethod:History.setHistoryTitle",deprecated:null,type:"staticMethod",definingClass:"object:History",params:[{defaultValue:null,optional:false,type:"String",description:"The title to show in the history drop-down.",name:"title"}],description:"\n Sets the title associated with all history entries.  This is the string that appears in the\n history drop-down.  If left unset, this default to the history id that is passed into\n ${isc.DocUtils.linkForRef('staticMethod:History.addHistoryEntry')}.\n <p>\n Note: Currently, this works in IE only.  You may call this method in all other browsers,\n but it will not change what's displayed in the history drop-down.\n\n",flags:"",name:"setHistoryTitle"},"method:DataSource.compareValues":{seeAlso:[],ref:"method:DataSource.compareValues",deprecated:null,type:"method",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"Any",description:"first value to compare",name:"value1"},{defaultValue:null,optional:false,type:"Any",description:"second value to compare",name:"value2"},{defaultValue:null,optional:false,type:"String",description:"field name for type-aware comparison",name:"fieldName"},{defaultValue:null,optional:true,type:"Boolean",description:"whether to ignore case for string comparisons",name:"ignoreCase"}],description:" Compares two field values, returning -1, 0, or 1 to indicate sort order. Handles\n type-aware comparison including dates and relative date values.\n",flags:"",returns:{type:"Integer",description:"-1 if value1 > value2, 1 if value1 < value2, 0 if equal, 2 if incomparable"},name:"compareValues"},"attr:RangeSlider.vertical":{seeAlso:[],ref:"attr:RangeSlider.vertical",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:RangeSlider",valueType:"boolean",description:"Whether the rangeSlider should be vertical or horizontal.  Default is horizontal.",flags:"IR",name:"vertical"},"class:SpinnerItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"TextItem",classMethods:[],classAttrs:[],attrs:["attr:SpinnerItem.mask","attr:SpinnerItem.maskSaveLiterals","attr:SpinnerItem.maskPadChar","attr:SpinnerItem.maskPromptChar","attr:SpinnerItem.maskOverwriteMode","attr:SpinnerItem.defaultValue","attr:SpinnerItem.unstackedTextBoxStyle","attr:SpinnerItem.unstackedPrintTextBoxStyle","attr:SpinnerItem.unstackedReadOnlyTextBoxStyle","attr:SpinnerItem.step","attr:SpinnerItem.max","attr:SpinnerItem.min","attr:SpinnerItem.increaseIcon","attr:SpinnerItem.increaseIconProperties","attr:SpinnerItem.decreaseIcon","attr:SpinnerItem.decreaseIconProperties","attr:SpinnerItem.writeStackedIcons","attr:SpinnerItem.stackedIconsWidth","attr:SpinnerItem.stackedIconsHeight","attr:SpinnerItem.unstackedIncreaseIcon","attr:SpinnerItem.unstackedDecreaseIcon"],ref:"class:SpinnerItem",deprecated:null,treeLocation:["Client Reference/Forms/Form Items"],description:"Item for picking a number. Includes arrow buttons to increase / decrease the value",methods:["method:SpinnerItem.getNextValue","method:SpinnerItem.getPreviousValue"],examples:["${isc.DocUtils.linkForExampleId('spinnerItem')}"],name:"SpinnerItem"},"class:IPickTreeItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"PickTreeItem",classMethods:[],classAttrs:[],attrs:["attr:IPickTreeItem.button"],ref:"class:IPickTreeItem",deprecated:null,treeLocation:["Client Reference/Forms/Form Items"],description:"Subclass of ${isc.DocUtils.linkForRef('class:PickTreeItem')} which shows an ${isc.DocUtils.linkForRef('class:IMenuButton')} rather than a\n simple ${isc.DocUtils.linkForRef('class:MenuButton')} as it's main button.",methods:[],name:"IPickTreeItem"},"attr:SavedSearchForm.hint":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:SavedSearchForm",groups:["i18nMessages"],deprecated:null,ref:"attr:SavedSearchForm.hint",valueType:"String",description:"If set this property will override ${isc.DocUtils.linkForRef('attr:SavedSearchItem.hint')} on the \n automatically generated ${isc.DocUtils.linkForRef('class:SavedSearchItem')}.",flags:"IR",name:"hint"},"method:LoginDialog.loginFunc":{seeAlso:[],ref:"method:LoginDialog.loginFunc",deprecated:null,type:"method",definingClass:"class:LoginDialog",params:[{defaultValue:null,optional:false,type:"Object",description:"Login credentials supplied by the user",name:"credentials"},{defaultValue:null,optional:false,type:"Function",description:"Function that must be called once the login transaction completes",name:"dialogCallback"}],description:' User-supplied callback function to process login transactions.\n <p>If the user clicks the "Log in" button, the credentials entered by the user are passed to\n loginFunc as an Object with properties "username" and "password" (NOTE: both\n property names are all lowercase), as the variable "credentials".  For example:\n <pre>{ username: "barney", password: "rUbbL3" }</pre>\n <P>\n This function should then attempt to log in by whatever means is necessary.  The second\n parameter to the loginFunc, "dialogCallback", is a function, which must be called <i>whether\n login succeeds or fails</i> with a true/false value indicating whether login succeeded.\n <P>\n If the login dialog is dismissable (settable as properties.dismissable, default false) and\n the user dismisses it, loginFunc will be fired with null for the credentials.\n <P>\n The following code shows typical usage.  This code assumes you have created a global\n function sendCredentials() that send credentials to some authentication system and fires a\n callback function with the result:\n <pre>\n ...\n loginFunc : function (credentials, dialogCallback) {\n     if (credentials == null) return; // dismissed\n\n     // send credentials\n     sendCredentials(credentials, function (loginSucceeded) {\n         // report success or failure\n         dialogCallback(loginSucceeded);\n     })\n })\n ...\n </pre>\n',flags:"",name:"loginFunc"},"attr:MetricSettings.fixedFacetValue":{seeAlso:[],ref:"attr:MetricSettings.fixedFacetValue",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:MetricSettings",valueType:"String | Number",description:"For a ${isc.DocUtils.linkForRef('attr:MetricSettings.multiFacet','single-facet')} chart of an extra value axis, this property provides a constant facet value\n for the second facet.  By varying the value of the other facet in multi-facet data, the chart\n obtains the series of values to plot.  The default facet value is the first facet value of the second facet.",flags:"IR",name:"fixedFacetValue"},"attr:DateTimeItem.displayFormat":{seeAlso:[{ref:"attr:DateTimeItem.inputFormat",description:null}],ref:"attr:DateTimeItem.displayFormat",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DateTimeItem",valueType:"DateDisplayFormat",description:"This property can be used to customize the format in which datetimes are displayed.<br>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} or\n a function which will return a formatted date time string.\n <P>\n If unset, the standard shortDateTime format as set up in \n ${isc.DocUtils.linkForRef('classMethod:DateUtil.setShortDatetimeDisplayFormat')} will be used.\n <P>\n <B>NOTE: you may need to update the ${isc.DocUtils.linkForRef('attr:DateTimeItem.inputFormat','inputFormat')}\n to ensure the DateItem is able to parse user-entered date strings back into Dates</B>",flags:"IRW",name:"displayFormat"},"group:formLayout":{refs:["attr:DynamicForm.itemLayout","attr:DynamicForm.linearMode","attr:DynamicForm.linearOnMobile","attr:DynamicForm.numCols","attr:DynamicForm.linearNumCols","attr:DynamicForm.linearHintWidth","attr:DynamicForm.fixedColWidths","attr:DynamicForm.autoDetectColumnMinWidths","attr:DynamicForm.colWidths","attr:DynamicForm.minColWidth","attr:DynamicForm.cellPadding","attr:DynamicForm.cellBorder","attr:DynamicForm.sectionVisibilityMode","attr:FormItem.width","attr:FormItem.linearWidth","attr:FormItem.height","attr:FormItem.staticHeight","attr:FormItem.titleColSpan","attr:FormItem.colSpan","attr:FormItem.linearColSpan","attr:FormItem.rowSpan","attr:FormItem.startRow","attr:FormItem.endRow","attr:FormItem.linearStartRow","attr:FormItem.linearEndRow","attr:ButtonItem.startRow","attr:ButtonItem.endRow","attr:SelectItem.height","attr:TextAreaItem.staticHeight","attr:ShuttleItem.width","attr:ShuttleItem.height"],seeAlso:[{ref:"attr:FormItem.width",description:null},{ref:"attr:FormItem.height",description:null},{ref:"attr:DynamicForm.itemLayout",description:null}],ref:"group:formLayout",treeLocation:["Client Reference/Forms"],deprecated:null,type:"group",title:"Form Layout",description:"<b>FormItem Placement in Columns and Rows</b>\n <P>\n With the default tabular layout mechanism, items are laid out in rows from left to\n right until the number of columns, specified by ${isc.DocUtils.linkForRef('attr:DynamicForm.numCols','form.numCols')},\n is filled, then a new row is begun.  Flags on FormItems, including\n ${isc.DocUtils.linkForRef('attr:FormItem.startRow','startRow')}, ${isc.DocUtils.linkForRef('attr:FormItem.endRow','endRow')},\n ${isc.DocUtils.linkForRef('attr:FormItem.colSpan','colSpan')} and ${isc.DocUtils.linkForRef('attr:FormItem.rowSpan','rowSpan')}, control row and\n column placement and spanning.  \n <P>\n Note that the most common form items (TextItem, SelectItem, etc) take up <b>two</b>\n columns by default: one for the form control itself, and one for it's title.  The\n default setting of ${isc.DocUtils.linkForRef('attr:DynamicForm.numCols','form.numCols:2')} will result in one TextItem\n or SelectItem per row.\n <P>\n Note also that ButtonItems have both startRow:true and endRow:true by default.  You must\n set startRow and/or endRow to <code>false</code> on a ButtonItem in order to place a\n button in the same row as any other item.\n <P>\n The log category \"tablePlacement\" can be enabled from the Developer Console to watch\n items being placed.  You can also set ${isc.DocUtils.linkForRef('attr:DynamicForm.cellBorder','form.cellBorder:1')} to\n reveal the table structure for layout troubleshooting purposes.\n <P>\n <b>Row and Column Sizing</b>\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.colWidths')} controls the widths of form columns.  FormItems that have\n \"*\" for ${isc.DocUtils.linkForRef('attr:FormItem.width')} will fill the column.  FormItems with a numeric width will\n have that width in pixels regardless of the column's specified width, which may cause the\n column to overflow as described under ${isc.DocUtils.linkForRef('attr:DynamicForm.fixedColWidths')}.\n <P>\n <b>Browser Layout and Column Compression</b>\n <P>\n With ${isc.DocUtils.linkForRef('attr:DynamicForm.fixedColWidths','fixedColWidths:false')} (the default), the browser\n may compress columns containing smaller content (such as titles) below their specified\n ${isc.DocUtils.linkForRef('attr:DynamicForm.colWidths')} to make room for columns with larger content. This compression works\n well when all columns can shrink, but certain items cannot shrink below their specified\n width: TextItem with <code>width:\"*\"</code>, and FileItem and CanvasItem in general.\n <P>\n If a colSpan item is sized based on policy column widths but other columns compress,\n the colSpan item may force the form to overflow. Use ${isc.DocUtils.linkForRef('attr:DynamicForm.colWidths')} min/max syntax\n or ${isc.DocUtils.linkForRef('attr:DynamicForm.autoDetectColumnMinWidths')} to prevent this by ensuring columns have\n appropriate minimums.\n <P>\n For row heights, the largest pixel height specified on any item in the row is taken as a\n minimum size for the row.  Then, any rows that have \"*\" or \"%\" height items will share\n any height not taken up by fixed-sized items.\n <P>\n Individual item heights are controlled by ${isc.DocUtils.linkForRef('attr:FormItem.height','item.height')}. This may be specified as\n an integer (pixel value), or a percentage string, or the special string \"*\", which \n indicates an item should fill the available space.<br>\n Percentages allow developers to determine how the available space in the form\n is split amongst items. For example if a form has 4 items in a single column,\n 2 of which have an  absolute pixel height specified, and 2 of which are have\n heights of <code>\"30%\"</code> and <code>\"70%\"</code> respectively, the percentage\n sized items will split up the available space after the fixed size items have been\n rendered.<br>\n Note that ${isc.DocUtils.linkForRef('attr:FormItem.cellHeight','item.cellHeight')} may be specified to explicitly control the height of \n an item's cell. In this case the specified ${isc.DocUtils.linkForRef('attr:FormItem.height','item.height')} will govern the size\n of the item within the cell (and if set to a percentage, this will be interpreted as\n a percentage of the cellHeight).\n <P>\n <b>Managing Overflow</b>\n <P>\n Forms often contain labels, data values, or instructional text which can vary in\n size based on the skin, data values, or internationalization settings.  There are a few\n ways to deal with a form potentially varying in size:\n <ol>\n <li> Allow scrolling when necessary, using ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow:auto')}, either\n on the immediate form, or on some parent.\n <li> Place the form in a Layout along with a component that can render any specified\n size, such as a ${isc.DocUtils.linkForRef('class:ListGrid')}.  In this case, the Layout will automatically shrink the\n grid in order to accommodate the form.\n <li> Ensure that the form can always render at a designed minimum size by reducing\n the number of cases of variable-sized text, and testing remaining cases across all\n supported skins.  For example, move help text into hovers on help icons, or clip \n long text values at a maximum length and provide a hover to see the rest.\n </ol>\n <P>\n <b>Adaptive Layout</b>\n <P>\n To have various automatic adjustments made to render your form items in a single column,\n you can use ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode','linearMode')}.  Importantly, you can have this\n mode automatically applied to a form on ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset','handset devices')} by\n setting ${isc.DocUtils.linkForRef('attr:DynamicForm.linearOnMobile','linearOnMobile')} true.  For further details and\n the properties that are available to customize this mode, see the\n ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode','linearMode')} documentation.\n <P>\n Several examples of Form Layout are available ${isc.DocUtils.linkForExampleId('formsLayout', 'here')}.",name:"formLayout"},"method:Canvas.setBottom":{groups:["sizing"],seeAlso:[],ref:"method:Canvas.setBottom",deprecated:null,type:"method",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"number",description:"new bottom coordinate",name:"bottom"}],description:" Resizes the widget vertically to position its bottom edge at the specified coordinate.\n <P>\n NOTE: if you're setting multiple coordinates, use setRect(), moveTo() or resizeTo()\n instead\n\n",flags:"",name:"setBottom"},"method:FormItem.getGridColNum":{seeAlso:[],ref:"method:FormItem.getGridColNum",deprecated:null,type:"method",definingClass:"class:FormItem",description:" If this formItem is part of a ${isc.DocUtils.linkForRef('class:ListGrid')}'s \n ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','inline edit form')}, returns the number of the grid column this \n formItem is responsible for editing, but <b>only</b> if a row is currently being\n edited.  If the formItem is not part of a ListGrid inline edit for any reason, this \n method returns null.  Reasons for a formItem not being part of an inline edit include<ul>\n <li>The item is part of an ordinary DynamicForm, not an inline edit form</li>\n <li>There is no row in the grid currently being edited</li>\n <li>A row is being edited, but this formItem is not currently visible and is being \n excluded because of horizontal incremental rendering (where SmartClient avoids drawing\n grid columns that would not be visible without scrolling)</li>\n </ul>\n\n",flags:"",returns:{type:"Integer",description:"The grid column number being edited by this formItem, or null, as                    described above"},name:"getGridColNum"},"attr:RibbonButton.menuIconHeight":{seeAlso:[],defaultValue:"13",type:"attr",definingClass:"class:RibbonButton",groups:["menu"],deprecated:null,ref:"attr:RibbonButton.menuIconHeight",valueType:"Number",description:"The height of the icon for this button.",flags:"IRW",name:"menuIconHeight"},"classAttr:Log.WARN":{seeAlso:[],defaultValue:"3",type:"classAttr",definingClass:"class:Log",deprecated:null,ref:"classAttr:Log.WARN",valueType:"LogPriority",description:"A declared value of the enum type\n ${isc.DocUtils.linkForRef('type:LogPriority','LogPriority')}.",flags:"R",name:"WARN",constant:true},"classMethod:TabIndexManager.focusInTarget":{seeAlso:[],ref:"classMethod:TabIndexManager.focusInTarget",deprecated:null,type:"classMethod",definingClass:"class:TabIndexManager",params:[{defaultValue:null,optional:false,type:"String",description:"target to shift focus to",name:"ID"}],description:" Request the TabIndexManager shift focus to a registered focus target.\n <P>\n This method does not directly change the focus within the DOM - instead it invokes the \n <code>shiftFocusCallback</code> registered for the specified target if it is marked as\n <code>canFocus:true</code>.\n <P>\n Returns false if the target had no no <code>shiftFocusCallback</code>, \n the <code>shiftFocusCallback</code> returned false, or if the target is marked\n as not <code>canFocus:true</code>\n",flags:"",returns:{type:"boolean",description:"returns false to indicate failure to shift focus."},name:"focusInTarget"},"attr:FilteredList.dataSource":{seeAlso:[],ref:"attr:FilteredList.dataSource",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FilteredList",valueType:"DataSource",description:"Optional dataSource to specifying field names and types for records within this\n List. Note that since a full data set should be provided to the list via\n ${isc.DocUtils.linkForRef('attr:FilteredList.allRows')}, this filteredList will not issue fetch requests against\n this DataSource.\n <P>\n If no DataSource was explicitly specified, filteredList will automatically generate\n its own DataSource with ${isc.DocUtils.linkForRef('attr:DataSource.dropUnknownCriteria','dropUnknownCriteria')} set to false.",flags:"IR",name:"dataSource"},"object:FacetValue":{seeAlso:[],requiresModules:["Analytics"],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:FacetValue.id","attr:FacetValue.title","attr:FacetValue.parentId","attr:FacetValue.canEdit","attr:FacetValue.collapsed","attr:FacetValue.minimized","attr:FacetValue.canCollapse","attr:FacetValue.canMinimize","attr:FacetValue.isMinimizeValue","attr:FacetValue.width","attr:FacetValue.align","attr:FacetValue.cellAlign","attr:FacetValue.borderBefore","attr:FacetValue.borderAfter","attr:FacetValue.selectionBoundary","attr:FacetValue.titleHilite"],ref:"object:FacetValue",deprecated:null,treeLocation:["Optional Modules/Analytics/CubeGrid"],description:"Facet value definition object made use of by the ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrid')} and\n ${isc.DocUtils.linkForRef('class:FacetChart','FacetChart')} classes (contained by facets).",methods:["method:FacetValue.getCellValue","method:FacetValue.formatCellValue"],name:"FacetValue"},"method:ListGrid.setHeaderSpans":{groups:["headerSpan"],seeAlso:[],ref:"method:ListGrid.setHeaderSpans",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"Array of HeaderSpan",description:"same configuration block as that passed to                                          ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans')}.",name:"headerSpans"}],description:" Update the headerSpans configuration on the grid dynamically.\n\n",flags:"",name:"setHeaderSpans"},"class:BaseWidget":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:[],classAttrs:[],attrs:["attr:BaseWidget.ID","attr:BaseWidget.autoDraw"],ref:"class:BaseWidget",deprecated:null,treeLocation:["Client Reference/Foundation"],description:"Base class for ${isc.DocUtils.linkForRef('class:Canvas')} and ${isc.DocUtils.linkForRef('class:DrawItem')}.",methods:[],name:"BaseWidget"},"class:SectionItem":{seeAlso:[{ref:"attr:DynamicForm.sectionVisibilityMode",description:null}],type:"class",staticMethods:[],inheritsFrom:"CanvasItem",classMethods:[],classAttrs:[],attrs:["attr:SectionItem.editProxyConstructor","attr:SectionItem.defaultValue","attr:SectionItem.itemIds","attr:SectionItem.sectionVisible","attr:SectionItem.sectionExpanded","attr:SectionItem.sectionHeaderClass","attr:SectionItem.canCollapse","attr:SectionItem.canTabToHeader"],ref:"class:SectionItem",deprecated:null,treeLocation:["Client Reference/Forms/Form Items"],description:"Header item for a collapsible section in a ${isc.DocUtils.linkForRef('class:DynamicForm')}.  Each <code>SectionItem</code>\n is associated with a number of other <code>item</code>s in the form, which will be shown or\n hidden as a group when the section is expanded or collapsed.  Clicking on a\n <code>SectionItem</code> will expand or collapse the section.\n <P>\n To make a form where only one section is expanded at a time, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.sectionVisibilityMode')} to \"mutex\".",methods:["method:SectionItem.isExpanded","method:SectionItem.expandSection","method:SectionItem.collapseSection"],examples:["${isc.DocUtils.linkForExampleId('formSections')}"],name:"SectionItem"},"method:Gauge.setDialRadius":{seeAlso:[],ref:"method:Gauge.setDialRadius",deprecated:null,type:"method",definingClass:"class:Gauge",params:[{defaultValue:null,optional:false,type:"float",description:"Radius in pixels of the dial",name:"dialRadius"}],description:" All DrawItems currently associated with this Gauge are destroyed and \n new DrawItems are created instead.\n\n",flags:"",name:"setDialRadius"},"method:PortalLayout.setCanShrinkColumnWidths":{groups:["sizing"],seeAlso:[{ref:"attr:PortalLayout.canShrinkColumnWidths",description:null},{ref:"attr:PortalLayout.canStretchColumnWidths",description:null}],ref:"method:PortalLayout.setCanShrinkColumnWidths",deprecated:null,type:"method",definingClass:"class:PortalLayout",params:[{defaultValue:null,optional:false,type:"boolean",description:"Whether columns can shrink to avoid overflowing the PortalLayout's width.",name:"canShrink"}],description:" Sets ${isc.DocUtils.linkForRef('attr:PortalLayout.canShrinkColumnWidths')} and reflows to reflect the new setting.\n",flags:"",name:"setCanShrinkColumnWidths"},"method:Canvas.encloses":{seeAlso:[],type:"method",definingClass:"class:Canvas",returns:{type:"Boolean",description:"true if this canvas encloses other; false otherwise"},groups:["positioning"],deprecated:null,ref:"method:Canvas.encloses",params:[{defaultValue:null,optional:false,type:"Canvas",description:"other canvas to test for enclosure",name:"other"}],description:" Returns true if the rectangle of this widget encloses the rectangle of the specified widget.\n",flags:"",name:"encloses"},"staticMethod:isc.showConsole":{groups:["debug"],seeAlso:[],ref:"staticMethod:isc.showConsole",deprecated:null,type:"staticMethod",definingClass:"object:isc",description:"\n\tMethod available on the isc object to open the Developer Console.\n\n",flags:"",name:"showConsole"},"method:ListGrid.setFieldIcon":{seeAlso:[],ref:"method:ListGrid.setFieldIcon",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"String",description:"field to update",name:"fieldName"},{defaultValue:null,optional:false,type:"SCImgURL",description:"icon for the field",name:"icon"}],description:" Change the ${isc.DocUtils.linkForRef('attr:ListGridField.icon')} for a field after the grid is created\n",flags:"",name:"setFieldIcon"},"method:SectionItem.isExpanded":{seeAlso:[],ref:"method:SectionItem.isExpanded",deprecated:null,type:"method",definingClass:"class:SectionItem",description:" Returns a boolean indicating whether this SectionItem is expanded.\n\n",flags:"",returns:{type:"Boolean",description:"true if the section is expanded false if not"},name:"isExpanded"},"attr:DynamicForm.target":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DynamicForm",groups:["submitting"],ref:"attr:DynamicForm.target",deprecated:null,setter:["setTarget"],valueType:"String",description:"The name of a window or frame that will receive the results returned by the form's\n action. The default null indicates to use the current frame.\n <p>\n <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data\n directly to a URL.  Normal server contact is through\n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}.",flags:"IRWA",name:"target"},"attr:Tab.pane":{seeAlso:[{ref:"group:autoChildren",description:null},{ref:"method:TabSet.updateTab",description:null}],ref:"attr:Tab.pane",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:Tab",valueType:"Canvas | ID | AutoChildShortcut",description:"Specifies the pane associated with this tab.  You have three options for the value of\n the pane attribute:\n <ul>\n <li><b>ID</b> - The global ID of an already created Canvas (or subclass).\n <li><b>Canvas</b> - A live instance of a Canvas (or subclass).\n <li><b>AutoChildShortcut</b> - String with format \"autoChild:<i>autoChildName</i>\"\n </ul>\n You can change the pane associated with a given tab after the TabSet has\n been created by calling ${isc.DocUtils.linkForRef('method:TabSet.updateTab')}.",flags:"IR",name:"pane"},"attr:NotifyAction.dismissMessage":{seeAlso:[],ref:"attr:NotifyAction.dismissMessage",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:NotifyAction",valueType:"Boolean",description:"Should a click on this action automatically dismiss the associated message?",flags:"IR",name:"dismissMessage"},"classMethod:MathFunction.getRegisteredFunctionIndex":{groups:["formulaFields"],seeAlso:[],ref:"classMethod:MathFunction.getRegisteredFunctionIndex",deprecated:null,type:"classMethod",definingClass:"class:MathFunction",description:" Returns an index of all registered functions by name\n \n",flags:"",returns:{type:"int",description:null},name:"getRegisteredFunctionIndex"},"attr:DateItem.autoUseTextField":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:DateItem",groups:["basics"],deprecated:null,ref:"attr:DateItem.autoUseTextField",valueType:"Boolean",description:"When set to true, the default, and when ${isc.DocUtils.linkForRef('attr:DateItem.useTextField','useTextField')} is \n set to false, such that the item displays multiple separate pickers, \n <code>useTextField</code> is automatically switched\n on when the item is rendering in a non-interactive way, such as when printing, or when \n ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit')} is false and the read-only display-mode is \n ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','static')}.",flags:"IR",name:"autoUseTextField"},"attr:Menu.canSaveSearches":{seeAlso:[],ref:"attr:Menu.canSaveSearches",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:Menu",valueType:"boolean",description:"Option to save searches is disabled for menus",flags:"IRA",name:"canSaveSearches"},"method:ListGrid.setCanRemoveRecords":{seeAlso:[],ref:"method:ListGrid.setCanRemoveRecords",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"boolean",description:"new canRemoveRecords value",name:"canRemove"}],description:" Updates the ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} property for this listGrid at runtime.\n",flags:"",name:"setCanRemoveRecords"},"attr:DetailViewer.fieldPickerFieldProperties":{seeAlso:[],ref:"attr:DetailViewer.fieldPickerFieldProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DetailViewer",valueType:"Array of String",description:"Names of properties on ${isc.DocUtils.linkForRef('object:DetailViewerField')} for which the ${isc.DocUtils.linkForRef('class:FieldPicker')} should\n show an editing interface, for convenience.\n <P>\n For example, specify [\"decimalPad\", \"decimalPrecision\"] to allow end users to modify\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.decimalPad')} and ${isc.DocUtils.linkForRef('attr:DetailViewerField.decimalPrecision')} respectively.",flags:"IR",name:"fieldPickerFieldProperties"},"attr:MultiSortPanel.otherSortLevelTitle":{seeAlso:[],defaultValue:'"Then by"',type:"attr",definingClass:"class:MultiSortPanel",groups:["i18nMessages"],deprecated:null,ref:"attr:MultiSortPanel.otherSortLevelTitle",valueType:"String",description:"The title-text to appear in the first column for all sort-levels other than the first.",flags:"IR",name:"otherSortLevelTitle"},"attr:ListGrid.applyFormulaAfterSummary":{seeAlso:[],ref:"attr:ListGrid.applyFormulaAfterSummary",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"Boolean",description:"If ${isc.DocUtils.linkForRef('attr:ListGridField.userFormula')} is set for some field, and this grid is showing\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary','group summaries')} or a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary','grid summary')}, this property determines what field value\n should be present in those summary rows. Should the field's user-formula be applied to the\n calculated summary row (applyFormulaAfterSummary <code>true</code>), or should\n a standard grid or group summary be applied to the user-formula values displayed in the grid\n (applyFormulaAfterSummary <code>false</code>)?\n <P>\n May be overridden at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.applyAfterSummary')}",flags:"IRW",name:"applyFormulaAfterSummary"},"classAttr:DrawLabel.defaultCursiveFont":{seeAlso:[],ref:"classAttr:DrawLabel.defaultCursiveFont",defaultValue:'"Zapf-Chancery"',deprecated:null,type:"classAttr",definingClass:"class:DrawLabel",valueType:"String",description:"This setting exists due to platform limitations in some versions of Internet Explorer\n where the browser does not recognize the five generic font families\n (<code>cursive</code>, <code>fantasy</code>, <code>monospace</code>,\n <code>sans-serif</code>, and <code>serif</code>) and instead uses a non-configurable,\n default font.  This setting specifies a specific font to replace the\n <code>cursive</code> keyword should a DrawLabel list it in its\n ${isc.DocUtils.linkForRef('attr:DrawLabel.fontFamily','font family')}.",flags:"IRW",name:"defaultCursiveFont"},"class:CancelItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"ButtonItem",classMethods:[],classAttrs:[],attrs:["attr:CancelItem.title"],ref:"class:CancelItem",deprecated:null,description:"Button that cancels any changes in the form, by calling ${isc.DocUtils.linkForRef('method:DynamicForm.cancelEditing')} \n when clicked.\n See ${isc.DocUtils.linkForRef('method:DynamicForm.cancelEditing')} for details on what happens when a form editing is \n cancelled.",methods:[],name:"CancelItem"},"attr:RadialGradient.r":{seeAlso:[],ref:"attr:RadialGradient.r",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:RadialGradient",valueType:"String",description:"radius",flags:"IR",name:"r"},"attr:DateRangeItem.fromTitle":{seeAlso:[],defaultValue:'"From"',type:"attr",definingClass:"class:DateRangeItem",groups:["i18nMessages"],deprecated:null,ref:"attr:DateRangeItem.fromTitle",valueType:"String",description:"The title for the ${isc.DocUtils.linkForRef('attr:DateRangeItem.fromField','from')} part of the range.",flags:"IR",name:"fromTitle"},"attr:CoTTask.outputFields":{seeAlso:[],ref:"attr:CoTTask.outputFields",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:CoTTask",valueType:"Array of Field",description:"Shorthand for ${isc.DocUtils.linkForRef('attr:CoTTask.outputDS')}, causing a temporary DataSource to be created to validate AI outputs.\n See ${isc.DocUtils.linkForRef('attr:CoTTask.outputDS')} for details of how validation is performed.",flags:"IR",name:"outputFields"},"attr:ComboBoxItem.completeOnEnter":{seeAlso:[],ref:"attr:ComboBoxItem.completeOnEnter",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ComboBoxItem",valueType:"Boolean",description:"If true, when the pickList is showing, the user can select the current value by hitting\n the <code>Enter</code> key.\n <P>\n If not explicitly set, completeOnEnter will default to false for items embedded\n in a ${isc.DocUtils.linkForRef('class:SearchForm','filtering interface')}, true otherwise.",flags:"IRW",name:"completeOnEnter"},"attr:Layout.managePercentBreadth":{seeAlso:[],ref:"attr:Layout.managePercentBreadth",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:Layout",valueType:"Boolean",description:"If set, a Layout with breadthPolicy:\"fill\" will specially interpret a percentage breadth on\n a member as a percentage of available space excluding the ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')}.  If false,\n percentages work exactly as for a non-member, with layoutMargins, if any, ignored.",flags:"IR",name:"managePercentBreadth"},"attr:MultiSortDialog.fields":{seeAlso:[],ref:"attr:MultiSortDialog.fields",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:MultiSortDialog",valueType:"Array of DataSourceField",description:"The list of fields which the user can choose to sort by.",flags:"IR",name:"fields"},"attr:FacetChart.logScalePointColor":{seeAlso:[{ref:"attr:FacetChart.pointColorLogBase",description:null}],defaultValue:"false",type:"attr",definingClass:"class:FacetChart",groups:["dataPoints"],ref:"attr:FacetChart.logScalePointColor",deprecated:null,valueType:"boolean",description:"Whether to use logarithmic scaling for the ${isc.DocUtils.linkForRef('attr:FacetChart.colorScaleMetric','color scale')} of the\n data points.  Defaults to the value of ${isc.DocUtils.linkForRef('attr:FacetChart.logScale')}.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('colorScaleChart')}"],name:"logScalePointColor"},"method:Canvas.pageScrollUp":{seeAlso:[],ref:"method:Canvas.pageScrollUp",deprecated:null,type:"method",definingClass:"class:Canvas",description:' This method is the programmatic equivalent of the user pressing the "Page Up" key while \n this widget has the focus.  It scrolls the widget\'s content upwards by the viewport \n height, if the content can be scrolled that far upwards\n',flags:"",name:"pageScrollUp"},"attr:LoadingIndicatorSettings.message":{seeAlso:[],ref:"attr:LoadingIndicatorSettings.message",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:LoadingIndicatorSettings",valueType:"HTML String",description:"Optional HTML text message to display in the loading indicator.",flags:"IRW",name:"message"},"attr:DataSourceField.includeFrom":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["dataSourceRelations"],ref:"attr:DataSourceField.includeFrom",deprecated:null,valueType:"String",description:'Indicates that this field should be fetched from another, related DataSource.\n <P>\n The <code>includeFrom</code> attribute should be of the form\n "<i>dataSourceId</i>.<i>fieldName</i>", for example:\n <pre>\n    &lt;field includeFrom="supplyItem.itemName"/&gt;\n </pre>\n <P>\n A ${isc.DocUtils.linkForRef(\'attr:DataSourceField.foreignKey\')} declaration must exist between the two DataSources, establishing either\n a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related\n DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there\n is a chain of <code>foreignKey</code> declarations from the target DataSource to the\n DataSource where the <code>includeFrom</code> field is declared.  You may use dot-notation\n to provide an explicit path between DataSources, or provide the name of only the last\n DataSource in the chain to have the complete path calculated for you at runtime.\n i.e., either of the following are acceptable forms, where foreign keys\n are defined to link records in the current DataSource to Employee records and in turn to\n Office records:\n <pre>\n   &lt;field includeFrom="Employee.Office.territory"/&gt;\n   &lt;!-- OR --&gt;\n   &lt;field includeFrom="Office.territory"/&gt;\n </pre>\n Note that when using the shorthand form, there is potential ambiguity: there could be\n multiple ways in which two DataSources are related via different intervening DataSources,\n so the auto-discovered relation may be different depending on which other DataSources are\n loaded in the page. For this reason, explicitly spelling out the inclusion path is\n preferred.\n <p>\n Nested inclusions, where an\n included field is itself an included field, are also supported - for details on this and\n other complex scenarios see ${isc.DocUtils.linkForRef(\'attr:DataSourceField.includeVia\')} docs.\n <P>\n In all cases, ${isc.DocUtils.linkForRef(\'attr:DataSourceField.name\')} will default to the name of the included field,\n or you can specify a different name.\n <p>\n If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with\n Hibernate as the provider) the related data will be retrieved via a SQL join and criteria\n and sort directions applied to the field work normally (they become part of the generated\n SQL query).\n <p>\n Note that includeFrom is also supported between two clientOnly or MockDataSources, but not\n for any other combination (for example, a RestDataSource cannot use includeFrom with a\n clientOnly DataSource).  Here, the related data (including any values derived via\n ${isc.DocUtils.linkForRef(\'attr:DataSourceField.includeSummaryFunction\')}) will be retrieved from cacheData after the\n primary (fetch, add, or update) operation has returned its response.\n <P>\n Otherwise, the related data will be retrieved via performing a DSRequest against\n the related DataSource once the data from the primary DataSource has been retrieved.  In\n this case, criteria or sorting directions applied to the included field are only allowed if\n data paging is not in use (for example ${isc.DocUtils.linkForRef(\'attr:ListGrid.dataFetchMode\')}:"basic"); otherwise,\n criteria and sort direction are ignored for the included field and a warning is logged on\n the server.\n <P>\n <b>Editing included fields</b>\n <p>\n An included field is ${isc.DocUtils.linkForRef(\'attr:DataSourceField.canEdit\',\'canEdit:false\')} by default.  Note that \n included fields are not updatable, even if you set canEdit:true; the server will simply drop\n values for included fields if client code sends them. \n <p>\n When thinking about editing an included field value, typically what is really intended is to\n edit the value of the <code>foreignKey</code> field.  For example, take the scenario of a\n system that tracks accounts and the employees assigned to manage them.  Given a DataSource\n "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field,\n we might declare an <code>includeFrom</code> so that the name of the account manager can\n be shown with each "account" record.  \n <p>\n Editing the manager\'s name while viewing the account would be intended to pick a new account\n manager, and <b>not</b> to change the legal name of the employee who happens to be the\n current account manager. \n <p>\n To correctly set up this scenario, declare an <code>includeFrom</code> field that is hidden,\n but is used as the ${isc.DocUtils.linkForRef(\'attr:DataSourceField.displayField\',\'displayField\')} for the foreign key\n field:\n <pre>\n &lt;field name="managerId" foreignKey="employee.id" displayField="managerName" /&gt; \n &lt;field name="managerName" includeFrom="employee.name" hidden="true"/&gt; \n </pre>\n Now:\n <ul>\n <li> the "managerId" foreignKey field is shown in grids and forms, but takes its displayed\n value from the hidden <code>includeFrom</code> field. Note that when the\n <code>foreignKey</code> and <code>displayField</code> are specified, the \n framework automatically defaults ${isc.DocUtils.linkForRef(\'attr:DataSourceField.useLocalDisplayFieldValue\')} to \n true to ensure the displayed value is picked up from the record being edited.\n <li> the automatically chosen editor will be a SelectItem with\n ${isc.DocUtils.linkForRef(\'attr:SelectItem.optionDataSource\',\'optionDataSource\')} set to "employees": it will allow\n picking a different "employee" record from the "employee" DataSource.\n <li> saving will save the ID of a new "employee" record to the "managerId" foreign key\n field, as intended\n </ul>\n\n You can alternatively set <code>editorType="ComboBoxItem"</code> on the\n "managerId" field to allow typeahead search of the "employee" DataSource.\n Note that the ${isc.DocUtils.linkForRef(\'attr:DataSourceField.foreignDisplayField\')} attribute allows developers to have a different\n fieldName be used locally as a displayField from the field name for the display field\n in the foreign dataSource.\n <P>\n <b>Including fields that use summary functions</b>\n <p>\n The ${isc.DocUtils.linkForRef(\'attr:DataSourceField.includeSummaryFunction\',\'Include Summary Function\')} feature is used\n for including from a related DataSource where there are multiple related records. It applies\n a ${isc.DocUtils.linkForRef(\'type:SummaryFunction\')} to the related records aggregating them into single value.\n It is regularly used on directly included fields, but it supports indirect inclusions as well,\n when entire <code>includeFrom</code>+<code>includeSummaryFunction</code> setup is included from\n another DataSource. See ${isc.DocUtils.linkForRef(\'attr:DataSourceField.includeSummaryFunction\')} docs for more details.\n <p>\n For best results, ensure that the field with <code>includeFrom</code> has its\n ${isc.DocUtils.linkForRef(\'attr:DataSourceField.type\')} explicitly set to the included field\'s <code>type</code>.\n <P>\n <b><code>includeFrom</code> combined with <code>${isc.DocUtils.linkForRef(\'attr:DataSourceField.multiple\',\'multiple\')}:true</code></b>\n <p>\n If you specify <code>${isc.DocUtils.linkForRef(\'attr:DataSourceField.multiple\',\'multiple\')}:true</code> on an \n <code>includeFrom</code> field, it has one of two quite different meanings:<ol>\n <li>It is including a field which is itself marked <code>multiple:true</code>, across a \n regular many-to-one or one-to-one ${isc.DocUtils.linkForRef(\'group:dataSourceRelations\',\'relation\')}.  In this case,\n the value of the included field is likely to be a flattened list of text values stored in a\n regular text field - see ${isc.DocUtils.linkForRef(\'attr:DataSourceField.multipleStorage\')}</li>\n <li>It is including multiple related values across a one-to-many or many-to-many relation</li>\n </ol>\n The first of these is exactly the same as any other regular <code>includeFrom</code>, except\n that it will have normal <code>multiple:true</code> processing applied to the included \n value, so the client sees a true list of values rather than a flat string of text.\n <p>\n The second is more involved.  With this type of <code>includeFrom</code> we will actually \n fetch multiple records from the included DataSource.  You should read the <b>One-to-many</b>\n and <b>Many-to-many</b> sections of the ${isc.DocUtils.linkForRef(\'group:dataSourceRelations\',\'relations overview\')}\n to make sure you understand how these relation types work, but essentially you declare a \n ${isc.DocUtils.linkForRef(\'attr:DataSourceField.foreignKey\',\'foreignKey\')} on a field that is also marked \n <code>multiple:true</code>, and this causes SmartClient to return a list of key values that\n your client-side code can use to obtain the related records (some SmartClient UI components\n will do this automatically).\n <p>\n Once one of these relation types is in place, it is also possible to declare \n <code>includeFrom</code> fields that make use of the relation to include fields other than \n the identifying key field, for convenience.  For example, if a <b>Country</b> dataSource\n declared a one-to-many relation to a <b>City</b> dataSource, like this:<pre>\n     &lt;field name="majorCities" multiple="true" foreignKey="City.cityId" /&gt;\n </pre>\n The same dataSource could make use of that relation to include the names of all related\n cities for convenience, so you can show a list of "Major Cities" against each country without\n having to go back to the server and fetch the actual City records.  The declaration would \n look like this:<pre>\n     &lt;field name="cityNames" multiple="true" includeFrom="City.cityName" /&gt;\n </pre>\n With <b>Many-to-many</b> related includeFroms - which require a "middle" dataSource, and thus\n a three-part <code>foreignKey</code> declaration - you may specify either the entire inclusion \n path, or just the endpoint.  For example, if your <b>Country</b> dataSource has a \n many-to-many relation with a <b>River</b> dataSource - necessary, because most countries \n contain more than one river, and many rivers flow through more than one country - via the \n following <code>foreignKey</code> definition:<pre>\n     &lt;field name="rivers" multiple="true" foreignKey="CountryRivers.Rivers.riverId" /&gt;\n </pre>\n you could <code>includeFrom</code> the list of related river names with either this:<pre>\n     &lt;field name="riverNames" multiple="true" includeFrom="CountryRivers.Rivers.name" /&gt;\n </pre> or slightly simpler, this:<pre>\n     &lt;field name="riverNames" multiple="true" includeFrom="Rivers.name" /&gt;\n </pre>\n If just the endpoint is specified, SmartClient will figure out the remainder of the path \n based on the available <code>foreignKey</code>s; if there is ambiguity that makes this \n impossible - ie, two <code>foreignKey</code> fields that target the same endpoint via \n different paths - you can either specify the entire include path in the <code>includeFrom</code>\n definition, or declare an ${isc.DocUtils.linkForRef(\'attr:DataSourceField.includeVia\',\'includeVia\')} setting on the field.',flags:"IR",serverDS:"only",examples:["${isc.DocUtils.linkForExampleId('sqlIncludeFrom')}"],name:"includeFrom"},"attr:DynamicForm.revertValueKey":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DynamicForm",deprecated:null,ref:"attr:DynamicForm.revertValueKey",valueType:"KeyIdentifier",description:"Keyboard shortcut that causes the value of the currently focused form item to be reverted\n to whatever value would be shown if ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')} were called.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('pendingValues')}"],name:"revertValueKey"},"method:RangeSlider.changed":{seeAlso:[],ref:"method:RangeSlider.changed",deprecated:null,type:"method",definingClass:"class:RangeSlider",params:[{defaultValue:null,optional:false,type:"float",description:"new start value",name:"startValue"},{defaultValue:null,optional:false,type:"float",description:"new end value",name:"endValue"},{defaultValue:null,optional:false,type:"boolean",description:"whether the user is still in the middle of a drag, so that  expensive operations can be avoided if needed",name:"isDragging"}],description:" Notification fired when the selected range is changed by the end user.\n\n",flags:"",name:"changed"},"group:title":{refs:["classMethod:DataSource.getAutoTitle","method:DataSource.getAutoTitle","attr:FormItem.showTitle","attr:FormItem.titleSuffix","attr:FormItem.titlePrefix","attr:FormItem.rightTitleSuffix","attr:FormItem.rightTitlePrefix","attr:FormItem.requiredTitlePrefix","attr:FormItem.requiredTitleSuffix","attr:FormItem.requiredRightTitlePrefix","attr:FormItem.requiredRightTitleSuffix","attr:FormItem.titleOrientation","attr:FormItem.titleAlign","attr:FormItem.titleVAlign","attr:FormItem.clipTitle","attr:FormItem.wrapTitle","attr:FormItem.vAlign","attr:FormItem.titleClassName","attr:FormItem.titleErrorClassName","attr:RibbonGroup.autoSizeToTitle"],seeAlso:[],ref:"group:title",deprecated:null,type:"group",description:null,name:"title"},"method:DynamicForm.valuesAreValid":{seeAlso:[],type:"method",definingClass:"class:DynamicForm",returns:{type:"boolean | Map",description:"Boolean value indicating validation success, or if  <code>returnErrors</code> was specified, an object mapping\n  field names to the associated errors, for those fields that\n failed validation, or null if validation succeeded."},groups:["validation"],deprecated:null,ref:"method:DynamicForm.valuesAreValid",params:[{defaultValue:null,optional:false,type:"boolean",description:'Should validators be processed for non-visible fields         such as dataSource fields with no associated item or fields with visibility set to\n         <code>"hidden"</code>?',name:"validateHiddenFields"},{defaultValue:null,optional:true,type:"boolean",description:"If unset, this method returns a simple boolean value indicating success or failure of validation. If this parameter is passed, this method will return\n an object mapping each field name to the errors(s) encountered on validation failure, or null\n if validation was successful.",name:"returnErrors"}],description:" Method to determine whether the current form values would pass validation.\n This method operates client-side, without contacting the server, running validators on the\n form's values and returning a value indicating whether validation was successful.  \n <P>\n Unlike ${isc.DocUtils.linkForRef('method:DynamicForm.validate')} this method will not store the errors on the DynamicForm\n or display them to the user.\n <P>\n Note that ${isc.DocUtils.linkForRef('method:DynamicForm.checkForValidationErrors')} allows for checking for server-side errors, and\n finding out what those errors are via a callback.\n\n",flags:"",name:"valuesAreValid"},"attr:TourConfirmStep.targetViewDefaults":{seeAlso:[],ref:"attr:TourConfirmStep.targetViewDefaults",defaultValue:"{...}",deprecated:null,type:"attr",definingClass:"class:TourConfirmStep",valueType:"Canvas Properties",description:"Defaults for the ${isc.DocUtils.linkForRef('attr:TourConfirmStep.targetView')} autoChild.",flags:"IR",name:"targetViewDefaults"},"attr:Window.headerControls":{seeAlso:[],defaultValue:"(see below)",type:"attr",definingClass:"class:Window",groups:["windowHeader"],ref:"attr:Window.headerControls",deprecated:null,valueType:"Array of String | Array of Canvas",description:'Array of members to show in the Window header.\n <P>\n The default value of <code>headerControls</code> is an Array of Strings listing the\n standard header controls in their default order:\n <pre>\n    headerControls : ["headerIcon", "headerLabel",\n                      "minimizeButton", "maximizeButton", "closeButton"]\n </pre>\n You can override <code>headerControls</code> to change the order of standard controls in\n the header.  You can also omit standard controls this way, although it more efficient to\n use the related "show" property if available (eg ${isc.DocUtils.linkForRef(\'attr:Window.showMinimizeButton\')}).\n <P>\n By embedding a Canvas directly in this list you can add arbitrary additional controls to\n the header, for example, an additional button (eg return to dock) or a DynamicForm with\n various kinds of input controls.\n <P>\n Note that having added controls to headerControls, you can still call APIs directly on\n those controls to change their appearance, and you can also show() and hide() them if\n they should not be shown in some circumstances.\n <P>\n Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.\n <P>\n <B>Component XML:</B>\n <P>\n To define <code>headerControls</code> in Component XML a special set of components\n are used as markers. The standard header controls can be explicitly specified as: \n <pre>\n  &lt;headerControls&gt;\n      &lt;WindowHeaderIcon/&gt;\n      &lt;WindowHeaderLabel/&gt;\n      &lt;WindowMinimizeButton/&gt;\n      &lt;WindowMaximizeButton/&gt;\n      &lt;WindowCloseButton/&gt;\n  &lt;/headerControls&gt;\n </pre>',flags:"IR",examples:["${isc.DocUtils.linkForExampleId('windowHeaderControls')}"],name:"headerControls"},"attr:Tree.titleProperty":{seeAlso:[],ref:"attr:Tree.titleProperty",defaultValue:'"title"',deprecated:null,type:"attr",definingClass:"class:Tree",valueType:"String",description:"Name of the property on a ${isc.DocUtils.linkForRef('object:TreeNode')} that holds the title of the node as it should be\n shown to the user.  Default value is \"title\".  See ${isc.DocUtils.linkForRef('attr:TreeNode.title')} for usage.",flags:"IRW",name:"titleProperty"},"attr:DataSource.serverConstructor":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.serverConstructor",valueType:"String",description:'This property allows you to write and use custom DataSource subclasses on the server, by \n specifying either <ul>\n <li>the fully-qualified name of the DataSource subclass that should be instantiated\n server-side for this dataSource, or</li>\n <li>the token "spring:" followed by a valid Spring bean ID, if you wish to instantiate \n your custom dataSource object using Spring dependency injection.  For example, \n <code>"spring:MyDataSourceBean"</code>.  See also ${isc.DocUtils.linkForRef(\'group:serverInit\')} for special\n concerns with framework initialization when using Spring.  It is also particularly important\n that you read the discussion of caching and thread-safety linked to below, as there are \n special considerations in this area when using Spring.</li>\n <li>the token "cdi:" followed by a valid CDI bean name, if you wish to instantiate \n your custom dataSource object using CDI dependency injection.  For example, \n <code>"cdi:MyDataSourceBean"</code>.</li>\n </ul>\n <p>\n One reason you might wish to do this would be to override the validate() method to provide \n some arbitrary custom validation (such as complex database lookups, validation embedded in \n legacy applications, etc).  It is also possible - though obviously a more substantial task -\n to override the execute() method in your custom DataSource.  This is one way of creating \n a completely customized DataSource implementation.\n <p>\n <b>Note:</b> If you use this property, you are responsible for making sure that it refers to\n a valid server-side class that extends <code>com.isomorphic.datasource.BasicDataSource</code>,\n or to a Spring bean of the same description.\n If your implementation relies on methods or state only present in certain specialized \n subclasses of DataSource (for example, you want the normal behavior and features of a \n HibernateDataSource, but with a specialized validate() method), then you should extend the \n subclass rather than the base class.\n <P>\n NOTE: Please take note of the points made in \n ${isc.DocUtils.linkForRef(\'group:serverDataSourceImplementation\',\'this discussion\')} of caching and thread-safety\n issues in server-side DataSources.',flags:"IR",serverDS:"only",name:"serverConstructor"},"classAttr:Dialog.ASK_TITLE":{seeAlso:[],defaultValue:'"Question"',type:"classAttr",definingClass:"class:Dialog",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Dialog.ASK_TITLE",valueType:"HTMLString",description:"Default title for the dialog displayed in response to the ${isc.DocUtils.linkForRef('staticMethod:isc.ask')} method.\n Note that a custom title can be specified as the <code>title</code> attribute of the\n <code>properties</code> parameter passed to that method.",flags:"IRW",name:"ASK_TITLE"},"attr:ListGrid.dataProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["databinding"],deprecated:null,ref:"attr:ListGrid.dataProperties",valueType:"ResultSet",description:"For databound ListGrids, this attribute can be used to customize the ${isc.DocUtils.linkForRef('class:ResultSet')}\n object created for this grid when data is fetched",flags:"IRWA",name:"dataProperties"},"attr:DetailViewer.fetchRequestProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DetailViewer",groups:["databinding"],deprecated:null,ref:"attr:DetailViewer.fetchRequestProperties",valueType:"DSRequest Properties",description:"If ${isc.DocUtils.linkForRef('attr:DetailViewer.autoFetchData')} is <code>true</code>, this attribute allows the developer to\n declaratively specify ${isc.DocUtils.linkForRef('object:DSRequest')} properties for the initial \n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} call.\n <P>\n Note that any properties governing more specific request attributes for\n the initial fetch (such as ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchTextMatchStyle','autoFetchTextMatchStyle')} and\n initial sort specifiers) will be applied on top of this properties block.",flags:"IR",name:"fetchRequestProperties"},"attr:FacetChart.colorMutePercent":{seeAlso:[],ref:"attr:FacetChart.colorMutePercent",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FacetChart",valueType:"float",description:'Should be set to a number between -100 and 100.  If set, all colors in the chart are "muted" by\n this percentage by shifting them toward white (or for negative numbers, toward black).',flags:"IR",name:"colorMutePercent"},"attr:Canvas.leavePageSpace":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["positioning"],ref:"attr:Canvas.leavePageSpace",deprecated:null,setter:["setLeavePageSpace"],valueType:"Integer",description:"If set, overrides the global ${isc.DocUtils.linkForRef('classAttr:Canvas.defaultPageSpace')}.",flags:"IRWA",name:"leavePageSpace"},"type:FieldName":{seeAlso:[],ref:"type:FieldName",deprecated:null,type:"type",description:"Name for a field.\n <p>\n Must be unique across all fields of its containing field container as well as a valid\n JavaScript identifier, as specified by ECMA-262 Section 7.6.\n <p>\n Note: The ${isc.DocUtils.linkForRef('staticMethod:String.isValidID')}\n  function can be used to test whether a name is\n a valid JavaScript identifier.",serverDS:"allowed",name:"FieldName",baseType:"Identifier"},"attr:ListGridField.maxWidth":{seeAlso:[{ref:"attr:ListGridField.width",description:null}],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["appearance"],deprecated:null,ref:"attr:ListGridField.maxWidth",valueType:"Number",description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.showHeader')} is false and a field is subject to autofitting (see\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')}), sets the maximum width of the field.  The actual\n effective maximum will be the largest of this property, ${isc.DocUtils.linkForRef('attr:ListGridField.minWidth')}, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')}.  That is, ${isc.DocUtils.linkForRef('attr:ListGridField.minWidth')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')} dominate this property.",flags:"IRW",name:"maxWidth"},"attr:DateRangeDialog.rangeItem":{seeAlso:[],ref:"attr:DateRangeDialog.rangeItem",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DateRangeDialog",valueType:"AutoChild DateRangeItem",description:null,flags:"IR",name:"rangeItem"},"method:ValuesManager.getValuesAsAdvancedCriteria":{seeAlso:[],type:"method",definingClass:"class:ValuesManager",returns:{type:"AdvancedCriteria",description:"a ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} based on the form's current values"},groups:["criteriaEditing"],deprecated:null,ref:"method:ValuesManager.getValuesAsAdvancedCriteria",params:[{defaultValue:null,optional:true,type:"TextMatchStyle",description:"If specified the text match style will be used to   generate the appropriate <code>operator</code> for per field criteria.",name:"textMatchStyle"}],description:" Return an AdvancedCriteria object based on the current set of values within memberForms.\n <p>\n Similar to ${isc.DocUtils.linkForRef('method:ValuesManager.getValuesAsCriteria')}, except the returned criteria object\n is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a\n specified ${isc.DocUtils.linkForRef('attr:FormItem.operator')}\n\n",flags:"",name:"getValuesAsAdvancedCriteria"},"method:TreeGrid.getDropFolder":{groups:["events"],seeAlso:[],ref:"method:TreeGrid.getDropFolder",deprecated:null,type:"method",definingClass:"class:TreeGrid",description:" When the user is dragging a droppable element over this grid, this method returns the folder\n which would contain the item if dropped. This is the current drop node if the user is hovering\n over a folder, or the node's parent if the user is hovering over a leaf.\n",flags:"",returns:{type:"TreeNode | NodeLocator",description:"If this is a regular treeGrid, the target drop folder; if this                               is a treeGrid based on a ${isc.DocUtils.linkForRef('attr:Tree.multiLinkTree','multiLink tree')},\n                               a NodeLocator unambiguously identifying the specific occurence\n                               of the drop folder in the tree"},name:"getDropFolder"},"attr:DetailViewer.showDetailFields":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:DetailViewer",groups:["databinding"],deprecated:null,ref:"attr:DetailViewer.showDetailFields",valueType:"Boolean",description:"Whether to show fields marked <code>detail:true</code> when a DataBoundComponent is \n given a DataSource but no <code>component.fields</code>.\n <p>\n The <code>detail</code> property is used on DataSource fields to mark fields that \n shouldn't appear by default in a view that tries to show many records in a small space.",flags:"IR",name:"showDetailFields"},"method:TimeItem.setSelectionRange":{seeAlso:[],ref:"method:TimeItem.setSelectionRange",deprecated:null,type:"method",definingClass:"class:TimeItem",params:[{defaultValue:null,optional:false,type:"int",description:"character index for start of new selection",name:"start"},{defaultValue:null,optional:false,type:"int",description:"character index for end of new selection",name:"end"}],description:" If ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.setSelectionRange','setSelectionRange')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",flags:"",name:"setSelectionRange"},"classAttr:FacetChart.invalidPolynomialDegreeMessage":{seeAlso:[],defaultValue:'"The regression polynomial degree must be a positive integer."',type:"classAttr",definingClass:"class:FacetChart",groups:["i18nMessages"],deprecated:null,ref:"classAttr:FacetChart.invalidPolynomialDegreeMessage",valueType:"String",description:'Warning message issued when an invalid polynomial degree is entered into the prompt dialog created\n by the <code>"Polynomial Degree..."</code> option in the context menu for scatter plots.',flags:"IRW",name:"invalidPolynomialDegreeMessage"},"attr:Layout.members":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Layout",getter:["getMembers"],ref:"attr:Layout.members",deprecated:null,setter:["setMembers"],valueType:"Array of Canvas | Array of String",description:"An array of canvases that will be contained within this layout. You can set the\n following properties on these canvases (in addition to the standard component\n properties):\n <ul>\n  <li>${isc.DocUtils.linkForRef('attr:Canvas.layoutAlign','layoutAlign')} -- specifies the member's alignment along the\n      breadth axis; valid values are \"top\", \"center\" and \"bottom\" for a horizontal layout\n      and \"left\", \"center\" and \"right\" for a vertical layout (see\n      ${isc.DocUtils.linkForRef('attr:Layout.defaultLayoutAlign')} for default implementation.)\n  <li>${isc.DocUtils.linkForRef('attr:Canvas.showResizeBar','showResizeBar')} -- set to true to show a resize bar\n      (default is false)\n </ul>\n Height and width settings found on members are interpreted by the Layout according to\n the ${isc.DocUtils.linkForRef('attr:Layout.vPolicy','layout policy')}.\n <P>\n \n As an alternative to providing Canvas instances, the <code>members</code> array may also\n contain Strings. A String will be assumed to be a global ID, and a Canvas with that ID\n will be used as the member. Additionally, some Layout subclasses interpret certain\n special String values as references to automatically generated components (AutoChildren).\n See ${isc.DocUtils.linkForRef('attr:ToolStrip.members')} and ${isc.DocUtils.linkForRef('attr:ListGrid.gridComponents')} for examples.\n \n <P>\n Note that it is valid to have null slots in the provided <code>members</code> Array,\n and the Layout will ignore those slots. This can be useful to keep code compact, for\n example, when constructing the <code>members</code> Array, you might use an expression\n that either returns a component or null depending on whether the component should be\n present. If the expression returns null, the null slot will be ignored by the Layout.",flags:"IRW",name:"members"},"attr:AIFieldBuilder.pendingSuggestTitleHint":{seeAlso:[{ref:"attr:AIFieldBuilder.initialAutoSuggestTitleHint",description:null}],defaultValue:'"[generating a title…]"',type:"attr",definingClass:"class:AIFieldBuilder",groups:["i18nMessages"],deprecated:null,ref:"attr:AIFieldBuilder.pendingSuggestTitleHint",valueType:"HTMLString",description:"The hint to display in the ${isc.DocUtils.linkForRef('attr:SummaryBuilder.titleField','titleField')} when a suggested title\n is being generated.",flags:"IR",name:"pendingSuggestTitleHint"},"attr:DataSource.dataFormat":{seeAlso:[],defaultValue:'"iscServer"',type:"attr",definingClass:"class:DataSource",groups:["clientDataIntegration","serverDataIntegration"],ref:"attr:DataSource.dataFormat",deprecated:null,valueType:"DSDataFormat",description:"Indicates the format to be used for HTTP requests and responses when\n fulfilling DSRequests (eg, when ${isc.DocUtils.linkForRef('method:DataSource.fetchData')} is called).",flags:"IR",serverDS:"allowed",examples:["${isc.DocUtils.linkForExampleId('jsonDataSource')}","${isc.DocUtils.linkForExampleId('simpleJSON')}"],name:"dataFormat"},"attr:PortalLayout.numColumns":{seeAlso:[{ref:"attr:PortalLayout.portlets",description:null}],defaultValue:"2",type:"attr",definingClass:"class:PortalLayout",getter:["getNumColumns"],deprecated:null,ref:"attr:PortalLayout.numColumns",valueType:"int",description:"Initial number of columns to show in this PortalLayout. Note that after initialization\n columns should be added / removed via ${isc.DocUtils.linkForRef('method:PortalLayout.addColumn')} and ${isc.DocUtils.linkForRef('method:PortalLayout.removeColumn')}.\n numColumns is ignored if you initialize the ${isc.DocUtils.linkForRef('attr:PortalLayout.portlets')} attribute, since the portlets\n attribute will imply how many columns to create.",flags:"IR",name:"numColumns"},"method:DrawGroup.scaleBy":{seeAlso:[],ref:"method:DrawGroup.scaleBy",deprecated:null,type:"method",definingClass:"class:DrawGroup",params:[{defaultValue:null,optional:false,type:"float",description:"scale in the x direction",name:"x"},{defaultValue:null,optional:false,type:"float",description:"scale in the y direction",name:"y"}],description:" Scale all drawItem[] shapes by the x, y multipliers\n",flags:"",name:"scaleBy"},"attr:ImgSplitbar.src":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ImgSplitbar",groups:["appearance"],deprecated:null,ref:"attr:ImgSplitbar.src",valueType:"String",description:"The base filename or stateful image configuration for the image. \n Note that as the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state','state')} \n of the component changes, the image displayed will be updated as described in\n ${isc.DocUtils.linkForRef('group:statefulImages')}.",flags:"IR",name:"src"},"attr:ListGrid.canMultiGroup":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:ListGrid",deprecated:null,ref:"attr:ListGrid.canMultiGroup",valueType:"boolean",description:"When true, indicates that this ListGrid supports grouping on multiple fields.",flags:"IRW",serverDS:"allowed",name:"canMultiGroup"},"attr:RibbonGroup.styleName":{seeAlso:[],defaultValue:'"ribbonGroup"',type:"attr",definingClass:"class:RibbonGroup",groups:["appearance"],ref:"attr:RibbonGroup.styleName",deprecated:null,setter:["setStyleName"],valueType:"CSSStyleName",description:"CSS class applied to this RibbonGroup.",flags:"IRW",name:"styleName"},"method:PickTreeItem.setValueTree":{seeAlso:[],ref:"method:PickTreeItem.setValueTree",deprecated:null,type:"method",definingClass:"class:PickTreeItem",params:[{defaultValue:null,optional:false,type:"Tree",description:"new value tree for the item",name:"valueTree"}],description:" Setter to change the ${isc.DocUtils.linkForRef('attr:PickTreeItem.valueTree')} at runtime\n",flags:"",name:"setValueTree"},"attr:ProcessElement.forceSingle":{seeAlso:[],ref:"attr:ProcessElement.forceSingle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ProcessElement",valueType:"Boolean",description:"Should ${isc.DocUtils.linkForRef('attr:ProcessElement.supportsMultipleInputRecords','multiple record processing')} be suppressed\n for this task instance? This property can be set at any time is checked before\n executing the task and after each execution during processing of multiple last task\n output records.\n <p>\n Note that since this property applies to an instance of a task that could be used\n multiple times in a process (by branching) care should be taken to restore the\n property value after execution completes. See ${isc.DocUtils.linkForRef('method:ProcessElement.completeElement')} or\n ${isc.DocUtils.linkForRef('method:ProcessElement.reset')}.",flags:"IRW",name:"forceSingle"},"classMethod:ClassFactory.overwriteClass":{seeAlso:[],ref:"classMethod:ClassFactory.overwriteClass",deprecated:null,type:"classMethod",definingClass:"object:ClassFactory",params:[{defaultValue:null,optional:false,type:"String",description:"Name for the new class.",name:"className"},{defaultValue:null,optional:true,type:"Class | SCClassName",description:"Optional SuperClass Class object or name",name:"superClass"}],description:"\n Intentionally clobber an existing SmartClient Class, if it already exists.  Works\n identically to ${isc.DocUtils.linkForRef('classMethod:ClassFactory.defineClass')}, except that no warning is logged to the\n console.\n\n",flags:"",returns:{type:"Class",description:"Returns the new Class object."},name:"overwriteClass"},"attr:ListGrid.invalidSummaryValue":{seeAlso:[],ref:"attr:ListGrid.invalidSummaryValue",defaultValue:'"&amp;nbsp;"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"String",description:"Value to display to the user if showing summary values (through ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')},\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} or ${isc.DocUtils.linkForRef('type:ListGridFieldType','listGridFieldType:\"summary\"')}), and\n the summary function returns <code>\"null\"</code> (implying it was unable to calculate a\n valid summary value). This property will only be used in the default formatting behavior. If\n an explicit formatter has been specified - via ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue')} or\n ${isc.DocUtils.linkForRef('attr:ListGridField.formatGridSummary','formatGridSummary()')}, for example - this property has\n no effect.",flags:"IRWA",name:"invalidSummaryValue"},"method:MenuButton.setShowMenuBelow":{groups:["menu"],seeAlso:[],ref:"method:MenuButton.setShowMenuBelow",deprecated:null,type:"method",definingClass:"class:MenuButton",params:[{defaultValue:null,optional:false,type:"boolean",description:"True if the menu should be shown below the <code>MenuButton</code>.",name:"below"}],description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the <code>MenuButton</code>.\n",flags:"",name:"setShowMenuBelow"},"classAttr:GroupingMessages.byMillisecondsTitle":{seeAlso:[],defaultValue:'"by Milliseconds"',type:"classAttr",definingClass:"class:GroupingMessages",groups:["i18nMessages"],deprecated:null,ref:"classAttr:GroupingMessages.byMillisecondsTitle",valueType:"String",description:"Title to use for the menu option which groups a time field by milliseconds.",flags:"IRW",name:"byMillisecondsTitle"},"attr:FormItem.showValueIconOnly":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["valueIcons"],deprecated:null,ref:"attr:FormItem.showValueIconOnly",valueType:"boolean",description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is set, this property may be set to show the valueIcon\n only and prevent the standard form item element or text from displaying",flags:"IRW",name:"showValueIconOnly"},"attr:Slider.minValue":{seeAlso:[{ref:"attr:Slider.flipValues",description:null}],defaultValue:"1",type:"attr",definingClass:"class:Slider",ref:"attr:Slider.minValue",deprecated:null,valueType:"float",setter:["setMinValue"],description:"The minimum slider value. The slider value is equal to minValue when the thumb is at the\n bottom or left of the slider (unless flipValues is true, in which case the minimum value\n is at the top/right of the slider)",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('slider')}"],name:"minValue"},"attr:FormItem.optionTextMatchStyle":{seeAlso:[],defaultValue:'"exact"',type:"attr",definingClass:"class:FormItem",groups:["databinding","searchCriteria"],deprecated:null,ref:"attr:FormItem.optionTextMatchStyle",valueType:"TextMatchStyle",description:"If this item has a specified <code>optionDataSource</code>, this property determines\n the textMatchStyle to use when interpretating any ${isc.DocUtils.linkForRef('attr:FormItem.optionCriteria')} during the\n fetch to map valueField values to displayField values.",flags:"IRA",name:"optionTextMatchStyle"},"attr:CubeGrid.indentVTreeFacets":{seeAlso:[{ref:"attr:Facet.indentVTree",description:null},{ref:"attr:CubeGrid.vTreeFacetIndent",description:null},{ref:"attr:CubeGrid.vTreeFacetIndentDirection",description:null}],ref:"attr:CubeGrid.indentVTreeFacets",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:CubeGrid",valueType:"boolean",description:"Turns on indenting of any ${isc.DocUtils.linkForRef('attr:Facet.isTree','hierarchical')} column facets.  This can be\n overridden at the facet level via ${isc.DocUtils.linkForRef('attr:Facet.indentVTree')}.  Setting this property also\n ensures that the header is sized tall enough to accommodate the fully expanded facet.  \n <P>\n The amount of indenting per level can be set with ${isc.DocUtils.linkForRef('attr:CubeGrid.vTreeFacetIndent')}, and the\n direction of the indenting specified with ${isc.DocUtils.linkForRef('attr:CubeGrid.vTreeFacetIndentDirection')}.\n <P>\n Note that if you specify an explicit height for such a fscet, such as by setting\n ${isc.DocUtils.linkForRef('attr:Facet.height')} or ${isc.DocUtils.linkForRef('attr:Facet.labelHeight')}, then the greater of that or the space\n required to accommodate the fully expanded facet will determine the actual height used.",flags:"IR",name:"indentVTreeFacets"},"attr:GridEditProxy.generateEditableHilites":{seeAlso:[],ref:"attr:GridEditProxy.generateEditableHilites",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:GridEditProxy",valueType:"Boolean",description:"Controls whether highlights created while in edit mode are editable by end users at\n runtime (when the grid is no longer in edit mode).  See ${isc.DocUtils.linkForRef('attr:Hilite.canEdit')}.",flags:"IR",name:"generateEditableHilites"},"attr:Layout.paddingAsLayoutMargin":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:Layout",groups:["layoutMargin"],deprecated:null,ref:"attr:Layout.paddingAsLayoutMargin",valueType:"Boolean",description:"If this widget has padding specified (as ${isc.DocUtils.linkForRef('attr:Canvas.padding','this.padding')} or in the\n CSS style applied to this layout), should it show up as space outside the members,\n similar to layoutMargin?\n <P>\n If this setting is false, padding will not affect member positioning (as CSS padding\n normally does not affect absolutely positioned children).  Leaving this setting true\n allows a designer to more effectively control layout purely from CSS.\n <P>\n Note that ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')} if specified, takes precedence over this value.",flags:"IRWA",name:"paddingAsLayoutMargin"},"method:ImgButton.setDisabled":{groups:["enable","state"],seeAlso:[],ref:"method:ImgButton.setDisabled",deprecated:null,type:"method",definingClass:"class:ImgButton",params:[{defaultValue:null,optional:false,type:"boolean",description:"true if this widget is to be disabled",name:"disabled"}],description:" Enable or disable this object\n",flags:"",name:"setDisabled"},"method:RemoteWindow.getInfo":{seeAlso:[],ref:"method:RemoteWindow.getInfo",deprecated:null,type:"method",definingClass:"class:RemoteWindow",params:[{defaultValue:null,optional:false,type:"RemoteWindowMapCallback",description:"callback to receive output",name:"callback"}],description:" Checks whether this RemoteWindow is showing.\n",flags:"",name:"getInfo"},"attr:StaticTextItem.applyAlignToText":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:StaticTextItem",groups:["appearance"],deprecated:null,ref:"attr:StaticTextItem.applyAlignToText",valueType:"boolean",description:"If the ${isc.DocUtils.linkForRef('attr:FormItem.textAlign','textAlign')} is unset, should the ${isc.DocUtils.linkForRef('attr:FormItem.align','align')}\n setting, if set, be used for this <code>StaticTextItem</code>'s <code>textAlign</code>?",flags:"IRA",name:"applyAlignToText"},"method:Gauge.addSector":{seeAlso:[],ref:"method:Gauge.addSector",deprecated:null,type:"method",definingClass:"class:Gauge",params:[{defaultValue:null,optional:false,type:"GaugeSector | double",description:"the new GaugeSector or the new sector's value. This is formatted with ${isc.DocUtils.linkForRef('method:Gauge.formatLabelContents')} to get its label.",name:"newSector"}],description:" Adds a new sector.\n\n",flags:"",returns:{type:"int",description:"the index of the newly-added sector."},name:"addSector"},"classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED":{seeAlso:[{ref:"classAttr:RPCResponse.STATUS_FILE_REQUIRED_ERROR",description:null},{ref:"object:RPCRequest",description:null}],defaultValue:"-11",type:"classAttr",definingClass:"class:RPCResponse",groups:["statusCodes","constant"],deprecated:null,ref:"classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED",valueType:"int",description:"Indicates that an uploaded file's size exceeded the maximum file size allowed.",flags:"R",name:"STATUS_MAX_FILE_SIZE_EXCEEDED"},"attr:FacetChart.dataPointProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["dataPoints"],deprecated:null,ref:"attr:FacetChart.dataPointProperties",valueType:"DrawItem Properties",description:"Common properties to apply for all data points (see ${isc.DocUtils.linkForRef('attr:FacetChart.showDataPoints')}).",flags:"IR",name:"dataPointProperties"},"attr:DateItem.useTextField":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DateItem",groups:["basics"],ref:"attr:DateItem.useTextField",deprecated:null,valueType:"Boolean",description:"When set to true, the item uses a ${isc.DocUtils.linkForRef('attr:DateItem.textField','single text field')} for \n working with the item's value.\n <P>\n When false or unset, the default, the item's value is represented by separate \n ${isc.DocUtils.linkForRef('attr:DateItem.daySelector','day')}, ${isc.DocUtils.linkForRef('attr:DateItem.monthSelector','month')}, \n and/or ${isc.DocUtils.linkForRef('attr:DateItem.yearSelector','year')} selectors.  In this mode, null values are not\n supported, and a default value of Today will be enforced if no \n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue','defaultValue')} is specified.  This means that a DateItem \n with <code>useTextField</code> set to false is effectively a \n ${isc.DocUtils.linkForRef('attr:FormItem.required','required')} field.\n <P>\n If you want to change the appearance of a DateItem, you will need to configure some\n autoChildren such as ${isc.DocUtils.linkForRef('attr:DateItem.textField')} via ${isc.DocUtils.linkForRef('attr:DateItem.textFieldProperties')},\n or in <code>useTextField:false</code> mode, the ${isc.DocUtils.linkForRef('attr:DateItem.daySelector')} and other selectors, \n configured via <code>daySelectorProperties</code> et al.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('dateItem')}"],name:"useTextField"},"method:ScreenLoader.setDataContextBinding":{groups:["dataContext"],seeAlso:[],ref:"method:ScreenLoader.setDataContextBinding",deprecated:null,type:"method",definingClass:"class:ScreenLoader",params:[{defaultValue:null,optional:false,type:"DataContext",description:"the new DataContext binding",name:"binding"}],description:" Set the dataContextBinding property.\n",flags:"",name:"setDataContextBinding"},"group:dataContext":{refs:["method:Canvas.setDataContext","method:Canvas.dataContextChanged","method:ScreenLoader.setDataContextBinding","method:ScreenLoader.dataContextChanged","attr:Canvas.dataContext","attr:Canvas.testDataContext","attr:Canvas.autoPopulateData","attr:LoadProjectSettings.dataContext","attr:CreateScreenSettings.dataContext","attr:ScreenLoader.dataContextBinding"],seeAlso:[],ref:"group:dataContext",deprecated:null,type:"group",description:null,name:"dataContext"},"attr:TextItem.width":{seeAlso:[],defaultValue:"150",type:"attr",definingClass:"class:TextItem",groups:["appearance"],deprecated:null,ref:"attr:TextItem.width",valueType:"number",description:"Default width for fields.",flags:"IRW",name:"width"},"classMethod:Canvas.getPrintPreview":{groups:["printing"],seeAlso:[],ref:"classMethod:Canvas.getPrintPreview",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"Array of Canvas",description:"components to get the print HTML for. May also include    raw HTML strings which will be folded into the generated print output",name:"components"},{defaultValue:null,optional:true,type:"PrintProperties",description:"PrintProperties object for customizing the print HTML output",name:"printProperties"},{defaultValue:null,optional:true,type:"Canvas Properties",description:"properties to apply to the generated printPreview Canvas.",name:"previewProperties"},{defaultValue:null,optional:true,type:"PrintCanvasCallback",description:"callback to fire when the print preview canvas has been populated    with the printable HTML. The generated canvas will be passed to the callback as a single \n    <code>printPreview</code> parameter.",name:"callback"},{defaultValue:null,optional:true,type:"String",description:"optional string of HTML to render between each component",name:"separator"}],description:" Creates a printCanvas containing the full printHTML for a series of components, passing\n it as an argument to the callback (if supplied) when it fires. Note that the generated\n preview canvas will be drawn automatically by this method. Developers may also\n explicitly create a PrintCanvas instance and populate it with HTML derived from the\n ${isc.DocUtils.linkForRef('method:Canvas.getPrintHTML')} for finer grained control over when the print canvas is\n drawn.\n",flags:"",name:"getPrintPreview"},"attr:CoTProcess.transitionsPrimer":{seeAlso:[],ref:"attr:CoTProcess.transitionsPrimer",defaultValue:'"You may request a transition by emitting {goTo,intent,stepAfter}."',deprecated:null,type:"attr",definingClass:"class:CoTProcess",valueType:"String",description:"Primer text shown before the transitions list when using ${isc.DocUtils.linkForRef('method:CoTProcess.getPromptPart')} with \"transitions\".",flags:"IR",name:"transitionsPrimer"},"attr:ListGridField.valueField":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["display_values"],deprecated:null,ref:"attr:ListGridField.valueField",valueType:"String",description:"Specifies the ${isc.DocUtils.linkForRef('attr:ListGridField.optionDataSource')} field used to retrieve the stored\n values that are to be mapped to the display values (specified by\n ${isc.DocUtils.linkForRef('attr:ListGridField.displayField')}). Note that if this field is editable this will also\n be applied to this field's editors.",flags:"IRW",name:"valueField"},"object:isA":{seeAlso:[],type:"object",staticMethods:["staticMethod:isA.emptyString","staticMethod:isA.nonemptyString","staticMethod:isA.Object","staticMethod:isA.emptyObject","staticMethod:isA.emptyArray","staticMethod:isA.nonemptyArray","staticMethod:isA.String","staticMethod:isA.Array","staticMethod:isA.Function","staticMethod:isA.Number","staticMethod:isA.Boolean","staticMethod:isA.Date","staticMethod:isA.RegularExpression","staticMethod:isA.Instance","staticMethod:isA.ClassObject","staticMethod:isA.Interface","staticMethod:isA.List"],classMethods:[],classAttrs:[],attrs:[],ref:"object:isA",deprecated:null,treeLocation:["Client Reference/System"],description:'A library of functions for determining the types of other objects.<br><br>\n\n  The "isA" methods for the basic JavaScript types are much faster and more consistent across\n  platforms than JavaScript\'s "typeof" operator.<br><br>\n\n  An isA method is automatically created for every ISC Class and Interface definition, for\n  example, isA.Canvas().<br><br>',methods:[],examples:['<code>if (isA.Number(myVariable)) ...</code>\n\tNote: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used\n\t\t\tinterchangably when it looks better syntactically, eg:\n\t\t\t\t<code>if (myObject == null) ...</code>\n\t\t\tor\n\t\t\t\t<code>if (isAn.Array(myObject)) ...</code>\n <P>\n <h4>Global Configuration Flags</h4>\n <P>\n <b><code>window.isc_crossFrameCompat</code></b>\n <P>\n By default, the isA functions use fast <code>typeof</code> checks that work correctly for\n primitive values passed between frames. However, <i>boxed primitives</i> created in another\n frame are not detected:\n <pre>\n    // Boxed primitive created in an iframe\n    var iframe = document.createElement("iframe");\n    document.body.appendChild(iframe);\n    var boxedString = new iframe.contentWindow.String("hello");\n\n    typeof boxedString;           // "object" - not "string"!\n    boxedString instanceof String; // false - different constructor\n    isc.isA.String(boxedString);   // false - cannot detect by default\n </pre>\n This edge case is extremely rare because boxed primitives are almost never used in practice.\n Normal usage such as string literals (<code>"hello"</code>), concatenation\n (<code>"a" + "b"</code>), or any standard string/number/boolean operations produce primitive\n values, not boxed objects. Only explicit constructor calls like <code>new String()</code>,\n <code>new Number()</code>, or <code>new Boolean()</code> produce boxed primitives - and these\n are widely considered a JavaScript antipattern. Primitive values passed cross-frame work\n correctly with the default isA functions.\n <P>\n For applications that need cross-frame boxed primitive detection, set\n <code>window.isc_crossFrameCompat = true</code> before loading SmartClient. This installs\n slower versions that use <code>Object.prototype.toString.call()</code>. These versions are\n also always available as <code>isc.isA.crossFrame.String()</code>,\n <code>isc.isA.crossFrame.Number()</code>, and <code>isc.isA.crossFrame.Boolean()</code>.\n <P>\n <b><code>window.isc_legacyGWT</code></b>\n <P>\n GWT versions prior to 2.5 (released 2012) had a bug where Java String objects passed to\n JavaScript would have a <code>.Class</code> property set to "String" but would not be\n detected as strings by <code>typeof</code>. Set <code>window.isc_legacyGWT = true</code>\n before loading SmartClient if using GWT versions older than 2.5.'],name:"isA"},"group:integrationIntoExistingApps":{refs:[],seeAlso:[],ref:"group:integrationIntoExistingApps",treeLocation:["Concepts"],deprecated:null,type:"group",title:"Integrating into Existing Apps",description:"SmartClient can be easily integrated into any existing web application, regardless of\n the technology used, because it's careful not to interfere with the functionality or\n appearance of content created by other frameworks.\n <p>\n SmartClient components can be adapted to your existing application's layout by using the\n ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} and ${isc.DocUtils.linkForRef('attr:Canvas.matchElement')} APIs, for example,\n allowing them to be placed appropriately and respond automatically to DOM-level\n create, destroy, and resize events.\n <p>\n Using this strategy, replacing another table or list component with a SmartClient\n ListGrid can be as simple as ${isc.DocUtils.linkForRef('group:backgroundDownload','loading')} the framework\n and creating the ListGrid:\n <pre>\n   isc.FileLoader.load(function() {\n       isc.DataSource.load('User', function() {\n           isc.ListGrid.create({dataSource: 'User', htmlElement: 'userGrid', matchElement: true});\n       });\n   });\n </pre>\n A screen or even an entire project could be imported from\n ${isc.DocUtils.linkForRef('group:reifyForDevelopers','Reify')} and added in a similar fashion:\n <pre>\n   const callback = (project, projects, rpcResponse) => {\n       const screen = project.createStartScreen({\n         htmlElement: 'userScreen'\n       });\n   };\n   isc.FileLoader.load(function() {\n     isc.Reify.loadProject('your-proj', callback, {userName: 'you', password: 'secret'});\n   });\n </pre>\n The ${isc.DocUtils.linkForRef('group:angularIntegration','Angular')} documentation topic illustrates these\n points with a simple approach to integration of a ListGrid in that environment, but the\n same concepts apply to any existing web application, including those written in\n Angular, React, Vue, jQuery, Backbone, Svelte, etc.",name:"integrationIntoExistingApps"},"attr:FormItem.linearEndRow":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["formLayout"],deprecated:null,ref:"attr:FormItem.linearEndRow",valueType:"int | String",description:"Specifies ${isc.DocUtils.linkForRef('attr:FormItem.endRow')} for an item in ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode','linearMode')},\n overriding the default of <code>true</code> in that mode.",flags:"IRW",name:"linearEndRow"},"attr:ButtonItem.enableWhen":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ButtonItem",groups:["ruleCriteria"],deprecated:null,ref:"attr:ButtonItem.enableWhen",valueType:"AdvancedCriteria",description:"Criteria to be evaluated to determine whether this item should be enabled.  This\n property is incompatible with ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyWhen','readOnlyWhen')} and any setting you provide for\n the latter will be ignored if this property is set.\n <P>\n Criteria are evaluated against the ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form\\'s current values')} as\n well as the current ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope','rule context')}.  Criteria are re-evaluated\n every time form values or the rule context changes, whether by end user action or by\n programmatic calls.\n <P>\n A basic criteria uses textMatchStyle:\"exact\". When specified in\n ${isc.DocUtils.linkForRef('group:componentXML','Component XML')} this property allows\n ${isc.DocUtils.linkForRef('group:xmlCriteriaShorthand','shorthand formats')} for defining criteria.\n <p>\n Note: A ButtonItem using enableWhen must have a ${isc.DocUtils.linkForRef('attr:FormItem.name','name')} defined.\n ${isc.DocUtils.linkForRef('attr:CanvasItem.shouldSaveValue','shouldSaveValue')} can be set to <code>false</code> to prevent the field from storing\n its value into the form's values.",flags:"IR",name:"enableWhen"},"group:simpleNamesMode":{refs:[],seeAlso:[],ref:"group:simpleNamesMode",treeLocation:["Client Reference/System"],deprecated:null,type:"group",title:"Simple Names mode",description:'When SmartClient runs in "simple names" mode (the default), all ISC Classes and several\n global methods are installed as JavaScript global variables, that is, properties of the\n browser\'s "window" object.  When simple names mode is disabled (called "portal mode"),\n the framework uses only the global variable: "isc" and global variables prefixed with\n "isc_".  \n <P>\n Portal mode is intended for applications which must integrate with fairly arbitrary\n JavaScript code written by third-party developers, and/or third party JavaScript frameworks,\n where it is important that each framework stays within it\'s own namespace.\n <P>\n \n In portal mode, all references to ISC classes and global functions must be prefixed with\n "isc.", for example:<pre>\n \n      Canvas.create(addProperties({}, myDefaults))\n\n </pre>would become<pre>\n\n      isc.Canvas.create(isc.addProperties({}, myDefaults));\n\n </pre>\n \n Portal mode is enabled by setting <code>window.isc_useSimpleNames = false</code> <b>before</b>\n SmartClient is loaded, generally inside the &lt;head&gt; element.',name:"simpleNamesMode"},"attr:CubeGrid.canSelectHeaders":{seeAlso:[],ref:"attr:CubeGrid.canSelectHeaders",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:CubeGrid",valueType:"Boolean",description:"Determines whether row or column facetValue headers can be selected.",flags:"IRW",name:"canSelectHeaders"},"attr:DiscoverTreeSettings.typeProperty":{seeAlso:[],ref:"attr:DiscoverTreeSettings.typeProperty",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DiscoverTreeSettings",valueType:"String",description:'Each discovered child is labeled with a configurable "typeProperty" set to the value\n of the property that held the children',flags:"IRW",name:"typeProperty"},"method:Callbacks.RemoteWindowMapCallback":{seeAlso:[],ref:"method:Callbacks.RemoteWindowMapCallback",deprecated:null,type:"method",definingClass:"class:Callbacks",params:[{defaultValue:null,optional:false,type:"RemoteWindow",description:"window affected",name:"remoteWindow"},{defaultValue:null,optional:false,type:"Map",description:"result",name:"result"}],description:" Callback reporting the result of a ${isc.DocUtils.linkForRef('class:RemoteWindow')} operation yielding a map.\n",flags:"",name:"RemoteWindowMapCallback"},"attr:Calendar.otherDayBodyBaseStyle":{seeAlso:[],defaultValue:'"calMonthOtherDayBody"',type:"attr",definingClass:"class:Calendar",groups:["appearance"],deprecated:null,ref:"attr:Calendar.otherDayBodyBaseStyle",valueType:"CSSStyleName",description:'The base name for the CSS class applied to the day body of the month view\n of the calendar. This style will have "Dark", "Over", "Selected", or "Disabled"\n appended to it according to the state of the cell.\n <P>\n See ${isc.DocUtils.linkForRef(\'group:cellStyleSuffixes\')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles.',flags:"IRW",name:"otherDayBodyBaseStyle"},"attr:FormItemEventInfo.overInlineError":{seeAlso:[],ref:"attr:FormItemEventInfo.overInlineError",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:FormItemEventInfo",valueType:"Boolean",description:"True if the event occurred over the form's \n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorItemProperties','single error item')}.",flags:"R",name:"overInlineError"},"attr:DrawShapeCommand.args":{seeAlso:[],ref:"attr:DrawShapeCommand.args",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DrawShapeCommand",valueType:"Array",description:"The command arguments. The number of arguments and their types depend on this command's ${isc.DocUtils.linkForRef('attr:DrawShapeCommand.type','type')}.",flags:"IR",name:"args"},"method:TileGrid.getTitleField":{seeAlso:[],ref:"method:TileGrid.getTitleField",deprecated:null,type:"method",definingClass:"class:TileGrid",description:' Method to return the fieldName which represents the "title" for records in this\n Component.<br>\n If this.titleField is explicitly specified it will always be used.\n Otherwise, default implementation will check ${isc.DocUtils.linkForRef(\'attr:DataSource.titleField\')} for databound\n compounds.<br>\n For non databound components returns the first defined field name of <code>"title"</code>,\n <code>"name"</code>, or <code>"id"</code> where the field is visible. If we don\'t find any\n field-names that match these titles, the first field in the component will be used instead.\n',flags:"",returns:{type:"String",description:"fieldName for title field for this component."},name:"getTitleField"},"attr:ListGrid.checkboxFieldImageWidth":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["checkboxField"],deprecated:null,ref:"attr:ListGrid.checkboxFieldImageWidth",valueType:"Integer",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionAppearance')} is set to <code>\"checkbox\"</code> this property\n may be set to govern the width of the checkbox image displayed to indicate whether a row is\n selected. If unset, the checkboxField image will be sized to match the\n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanImageWidth')} for this grid.",flags:"IR",name:"checkboxFieldImageWidth"},"attr:MockDSExportSettings.requestProperties":{seeAlso:[],ref:"attr:MockDSExportSettings.requestProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:MockDSExportSettings",valueType:"Array of DSRequest Properties | DSRequest Properties",description:"The properties that will be specified on the ${isc.DocUtils.linkForRef('object:DSRequest')} when fetching records.\n You can pass an array of different request properties matching the length of the\n <code>dsNames</code> param of ${isc.DocUtils.linkForRef('classMethod:Reify.getMockDS')} or ${isc.DocUtils.linkForRef('classMethod:Reify.showMockDS')} if you want the\n fetch for each ${isc.DocUtils.linkForRef('class:DataSource')} made with different properties.",flags:"IR",name:"requestProperties"},"attr:CoTTask.stateUpdates":{seeAlso:[],ref:"attr:CoTTask.stateUpdates",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:CoTTask",valueType:"Object | StatePath",description:"Declarative mapping from ${isc.DocUtils.linkForRef('type:StatePath','StatePaths')} to ${isc.DocUtils.linkForRef('type:TaskInputExpression','TaskInputExpressions')}, or\n just a single StatePath if the entire outputs object should be applied to a single path.\n When the task completes successfully (no validation errors), each mapping is applied to update\n ${isc.DocUtils.linkForRef('attr:Process.state')}. Shorthand: a String path means the entire outputs go to that path.",flags:"IR",name:"stateUpdates"},"attr:RPCRequest.useSimpleHttp":{seeAlso:[],ref:"attr:RPCRequest.useSimpleHttp",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:RPCRequest",valueType:"Boolean",description:"When set to true, assume the request is not going to the SmartClient server, and hence send\n a simple HTTP request that does not use SmartClient-specific request encoding.\n <P>\n Values specified in ${isc.DocUtils.linkForRef('attr:RPCRequest.params')} are sent to to the server as HTTP request\n parameters.  If ${isc.DocUtils.linkForRef('attr:RPCRequest.httpMethod')} is \"GET\", parameters appear in the request URL, otherwise\n if httpMethod is \"POST\", parameters are encoded in the request body (exactly like an HTML form\n does).  These parameters are then accessible via typical server-side APIs for retrieving\n HTTP parameters, eg, servletRequest.getParameter(paramName) in Java Servlets.  \n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:RPCRequest.httpMethod')} method is POST and ${isc.DocUtils.linkForRef('attr:RPCRequest.data')} is supplied,\n ${isc.DocUtils.linkForRef('attr:RPCRequest.data')} is assumed to be a string to post as the HTTP request body, and\n ${isc.DocUtils.linkForRef('attr:RPCRequest.params')} are sent as URL parameters instead.  This usage is for sending\n custom request bodies such as the XML payloads used for SOAP.  In this case,\n ${isc.DocUtils.linkForRef('attr:RPCRequest.contentType')} is typically also set to indicate the content type of the\n request body.\n <p>\n Setting <code>useSimpleHttp</code> to true also automatically sets\n ${isc.DocUtils.linkForRef('attr:RPCRequest.serverOutputAsString')} to true as well.",flags:"IRWA",name:"useSimpleHttp"},"attr:SavedSearchEditor.cancelButton":{seeAlso:[],ref:"attr:SavedSearchEditor.cancelButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SavedSearchEditor",valueType:"AutoChild IButton",description:"Button used to cancel changes.",flags:"IR",name:"cancelButton"},"method:Canvas.setAriaState":{groups:["accessibility"],seeAlso:[],ref:"method:Canvas.setAriaState",deprecated:null,type:"method",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"String",description:"aria state to update",name:"stateName"},{defaultValue:null,optional:false,type:"String | Boolean | Integer | Float",description:"value for the aria state",name:"stateValue"}],description:" Set a specific ${isc.DocUtils.linkForRef('attr:Canvas.ariaState','ARIA state')} for this component.\n \n",flags:"",name:"setAriaState"},"attr:Calendar.showDateChooser":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:Calendar",groups:["visibility"],deprecated:null,ref:"attr:Calendar.showDateChooser",valueType:"Boolean",description:"Determines whether the ${isc.DocUtils.linkForRef('attr:Calendar.dateChooser','dateChooser')} is displayed.",flags:"IR",name:"showDateChooser"},"method:DrawCurve.setStartPoint":{seeAlso:[],ref:"method:DrawCurve.setStartPoint",deprecated:null,type:"method",definingClass:"class:DrawCurve",params:[{defaultValue:null,optional:false,type:"Coordinate",description:"left coordinate for start point, in pixels",name:"left"},{defaultValue:null,optional:false,type:"Coordinate",description:"top coordinate for start point, in pixels",name:"top"}],description:" Update the startPoint\n\n",flags:"",name:"setStartPoint"},"attr:PaletteNode.icon":{seeAlso:[],ref:"attr:PaletteNode.icon",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:PaletteNode",valueType:"SCImgURL",description:"Icon for this paletteNode.",flags:"IR",name:"icon"},"method:ListGrid.hilitesChanged":{groups:["hiliting"],seeAlso:[],ref:"method:ListGrid.hilitesChanged",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Notification method executed whenever the end user uses the HiliteEditor to change\n the set of hilites applied to this grid.  This method will not be called after\n a purely programmatic change to the hilites made with a call to\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.setHilites','setHilites()')}.  The array of currently applied hilite objects is\n accessible via ${isc.DocUtils.linkForRef('method:DataBoundComponent.getHilites','getHilites()')}.\n",flags:"",name:"hilitesChanged"},"attr:FacetChart.zoomChartSlider":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["zoom"],deprecated:null,ref:"attr:FacetChart.zoomChartSlider",valueType:"RangeSlider AutoChild",description:"Slider controls shown on the mini-chart which is created when ${isc.DocUtils.linkForRef('attr:FacetChart.canZoom')} is enabled.",flags:"IR",name:"zoomChartSlider"},"method:Progressbar.getLength":{seeAlso:[],ref:"method:Progressbar.getLength",deprecated:null,type:"method",definingClass:"class:Progressbar",description:" Returns the current width of a horizontal progressbar, or height of a vertical progressbar.\n\n",flags:"",returns:{type:"Number",description:"the length of the progressbar"},name:"getLength"},"attr:ColumnTree.showOpenIcons":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:ColumnTree",groups:["treeIcons"],ref:"attr:ColumnTree.showOpenIcons",deprecated:null,valueType:"Boolean",description:"If true, show a different icon for <code>open</code> folders than closed folders.\n This is achieved by appending the ${isc.DocUtils.linkForRef('attr:ColumnTree.openIconSuffix')} onto the \n ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} URL [for example <code>\"[SKIN]/folder.gif\"</code> might be \n replaced by <code>\"[SKIN]/folder_open.gif\"</code>.<br>\n <b>Note</b> If this property is set to <code>false</code> the same icon is shown for\n open folders as for closed folders, unless a custom folder icon was specified. This will be\n determined by ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} plus the ${isc.DocUtils.linkForRef('attr:ColumnTree.closedIconSuffix')}.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('millerColumns')}"],name:"showOpenIcons"},"method:DetailViewer.fieldIsVisible":{seeAlso:[],ref:"method:DetailViewer.fieldIsVisible",deprecated:null,type:"method",definingClass:"class:DetailViewer",params:[{defaultValue:null,optional:false,type:"String | DetailViewerField",description:"field to be checked",name:"field"}],description:" Check whether a field is currently visible\n\n",flags:"",returns:{type:"boolean",description:"true if the field is currently visible, false otherwise."},name:"fieldIsVisible"},"method:Tree.remove":{seeAlso:[],ref:"method:Tree.remove",deprecated:null,type:"method",definingClass:"class:Tree",params:[{defaultValue:null,optional:false,type:"TreeNode | String | Integer | NodeLocator",description:"node to remove, or the node's ID,                                                              or a NodeLocator",name:"node"}],description:"\n Removes a node, along with all its children.  See ${isc.DocUtils.linkForRef('class:ResultTree','\"Modifying ResultTrees\"')}\n when working with a <code>ResultTree</code> for limitations.  Note, if this is a \n ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}, you must pass in a ${isc.DocUtils.linkForRef('object:NodeLocator')} rather than\n a node or id.\n\n",flags:"",returns:{type:"Boolean",description:"true if the tree was changed as a result of this call"},name:"remove"},"object:NotifyAction":{seeAlso:[{ref:"classMethod:Notify.configureMessages",description:null}],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:NotifyAction.title","attr:NotifyAction.separator","attr:NotifyAction.target","attr:NotifyAction.methodName","attr:NotifyAction.wholeMessage","attr:NotifyAction.dismissMessage"],ref:"object:NotifyAction",deprecated:null,treeLocation:["Client Reference/Control/Notify"],description:"Represents an action that's associated with a message.  Similar to the object form of\n ${isc.DocUtils.linkForRef('type:Callback')}, except a title must also be specified, which is rendered as a clickable\n link in the message (unless ${isc.DocUtils.linkForRef('attr:NotifyAction.wholeMessage','wholeMessage')} is set).",methods:[],name:"NotifyAction"},"method:Canvas.dropOut":{seeAlso:[{ref:"method:Canvas.getOffsetX",description:null},{ref:"method:Canvas.getOffsetY",description:null}],type:"method",definingClass:"class:Canvas",returns:{type:"Boolean",description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble."},groups:["widgetEvents"],deprecated:null,ref:"method:Canvas.dropOut",description:"\n Executed when the dragged object is no longer over this drop target, including when the drag\n interaction is ending with a drop on this drop target. If you have set a visual indication \n in dropOver or dropMove, you should reset it to its normal state in dropOut.\n\n",flags:"A",examples:["${isc.DocUtils.linkForExampleId('customDrag')}"],name:"dropOut"},"method:Deck.removePane":{seeAlso:[],ref:"method:Deck.removePane",deprecated:null,type:"method",definingClass:"class:Deck",params:[{defaultValue:null,optional:false,type:"Canvas",description:"pane to remove",name:"pane"}],description:" Remove a pane from this deck.\n",flags:"",name:"removePane"},"attr:ListGrid.canEdit":{seeAlso:[{ref:"method:ListGrid.startEditing",description:null},{ref:"attr:ListGridField.canEdit",description:null},{ref:"attr:ListGrid.recordEditProperty",description:null},{ref:"method:ListGrid.canEditCell",description:null},{ref:"attr:ListGrid.fields",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["editing"],ref:"attr:ListGrid.canEdit",deprecated:null,valueType:"Boolean",description:"Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for\n      individual fields.<br>\n      If 'canEdit' is false at the listGrid level, fields can never be edited - in this case\n      the canEdit property on individual fields will be ignored.<br>\n      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit' property to\n      false at the field level will prevent the field from being edited inline unless a\n      custom override of ${isc.DocUtils.linkForRef('method:ListGrid.canEditCell')} allows it.<br>\n      If 'canEdit' is not set at the listGrid level, setting 'canEdit' to true at the field\n      level enables the field to be edited inline.\n      <P>\n      For more information on editing, see the ${isc.DocUtils.linkForRef('group:editing','editing overview')}.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('editByRow')}"],name:"canEdit"},"method:ColorPicker.getBlue":{seeAlso:[{ref:"method:ColorPicker.setBlue",description:null}],ref:"method:ColorPicker.getBlue",deprecated:null,type:"method",definingClass:"class:ColorPicker",description:" Returns the Blue element of the currently-selected color, as an integer from 0-255\n",flags:"",returns:{type:"int",description:"blue color component"},name:"getBlue"},"attr:SetFilterItem.expandedPickListFields":{seeAlso:[],ref:"attr:SetFilterItem.expandedPickListFields",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SetFilterItem",valueType:"Array of ListGridField",description:"If ${isc.DocUtils.linkForRef('attr:SetFilterItem.canExpand')} is true, this is the list of fields to display in the \n ${isc.DocUtils.linkForRef('interface:PickList')} or ${isc.DocUtils.linkForRef('attr:MultiPickerItem.pickTree','pickTree')} when the picker is expanded",flags:"IR",name:"expandedPickListFields"},"attr:DatabaseBrowser.tableDataSource":{seeAlso:[],ref:"attr:DatabaseBrowser.tableDataSource",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"DataSource",description:'DataSource to retrieve the list of tables and views from a database.\n <P>\n If not explicitly specified, a dataSource will be automatically created for you and will\n invoke a special BuiltInRPC method <code>getTables()</code> to retrieve\n the set defined set of tables and views for the selected database.\n <P>\n See ${isc.DocUtils.linkForRef(\'group:server_properties\')} for details on how to enable access to BuiltInRPC\n utility methods.\n <P>\n We ship a default dataSource implementation, and we recommend that you use it instead \n of the auto-created client-side dataSource, which is really intended as a fallback in\n case the DataSource is not specified or wasn\'t deployed with the application.  This \n implementation gives the same results as the client-side version, but it works on the \n server-side, it supports filtering the results with regular <code>AdvancedCriteria</code>,\n and its functionality is implemented in Groovy script in the dataSource definition file,\n so it is easy to modify.\n <p>\n If you wish to use this DS implementation, set <code>tableDataSource</code> to \n "DBBrowser_tables" (the DBBrowser_* dataSource definitions are shipped in the SmartClient\n SDK inside /shared/ds - you must ensure that these are deployed to the same location - \n or another valid dataSource location - in your deployed app)\n <p>\n If you do use the default "DBBrowser_tables" dataSource, it provides a user hook where \n you can provide additional filtering logic without changing the base logic.  To do this, \n create a new class that implements interface\n <code>com.isomorphic.tools.DiscoverableTableListFilter</code> and add a \n <code>server.properties</code> entry pointing to it, like this:<pre>\n    discoverable.table.list.filter.impl:com.mycompany.MyTableFilterImpl\n </pre>\n SmartClient will instantiate an instance of your class and call its <code>filter()</code>\n method, passing in the list of tables it derived, after fields have been renamed to suit\n suit the dataSource (eg, renaming "TABLE_NAME" to "name"), and any criteria has been \n applied.  You should return a list, filtered or otherwise modified however \n you like - the intention is that you make filtering changes, such as removing tables\n that are not applicable to the current department or user, but there is nothing to stop you \n from making any change you like, including adding or modifying entries.\n <P>\n Finally, to allow completely custom behavior retrieving the set of tables within a \n database, you can provide your own DataSource implementation to retrieve table names.\n At a minimum this DataSource must have fields for <code>name</code> (primary key) \n and <code>type</code> (one of "table" or "view"). The request to retrieve tables may be\n customized via ${isc.DocUtils.linkForRef(\'attr:DatabaseBrowser.tableCriteria\')}, ${isc.DocUtils.linkForRef(\'attr:DatabaseBrowser.tableFetchOperation\')} and \n ${isc.DocUtils.linkForRef(\'attr:DatabaseBrowser.tableFetchRequestProperties\')}.',flags:"IR",name:"tableDataSource"},"type:FormMethod":{groups:["submitting"],seeAlso:[],ref:"type:FormMethod",deprecated:null,type:"type",values:[{value:"DynamicForm.GET",description:"GET request -- URL encoding (~4K max)"},{value:"DynamicForm.POST",description:"POST request -- separate field encoding (no max)"}],description:"Form METHOD parameters - how the form fields are submitted to the server",name:"FormMethod"},"method:Tree.getParents":{seeAlso:[],ref:"method:Tree.getParents",deprecated:null,type:"method",definingClass:"class:Tree",params:[{defaultValue:null,optional:false,type:"TreeNode | NodeLocator",description:"node in question, or a NodeLocator",name:"node"}],description:"\n Given a node, return an array of the node's ancestors, with the immediate parent first, then\n the grandparent, and so on.  The node itself is not included in the result.  For example, \n for the following tree:\n <pre>\n root\n   foo\n     bar\n </pre>\n Calling <code>tree.getParents(bar)</code> would return: <code>[foo, root]</code>.  Note that\n the returned array will contain references to the nodes, not the names.\n <p>\n Note, for reasons of backwards compatibility, if you pass this method a <code>TreeNode</code>\n instance on a ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','multi-link tree')}, it will return an array \n representing one path through the node's ancestors, which is unlikely to be useful.  To get \n the ancestor chain of a specific node occurence, you must pass a ${isc.DocUtils.linkForRef('object:NodeLocator')}\n that specifies the full ID-based path to that occurence.  If what you actually want is a \n list of the node's direct parents, see ${isc.DocUtils.linkForRef('method:Tree.getMultiLinkParents')}.\n\n\n",flags:"",returns:{type:"Array",description:"array of node's parents"},name:"getParents"},"object:FiscalCalendar":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:FiscalCalendar.defaultMonth","attr:FiscalCalendar.defaultDate","attr:FiscalCalendar.defaultYearMode","attr:FiscalCalendar.fiscalYears"],ref:"object:FiscalCalendar",deprecated:null,treeLocation:["Client Reference/System/Date"],description:"An object representing the start date for fiscal years in the current locale.\n <P>\n A fiscal year spans a configurable date range - it may not exactly\n match a calendar year in length and it can start on any date within the calendar year\n and potentially end in the next calendar year.\n <P>\n Developers may specify explicit fiscal year start dates by adding ${isc.DocUtils.linkForRef('object:FiscalYear')}\n objects to the ${isc.DocUtils.linkForRef('attr:FiscalCalendar.fiscalYears','fiscal years array')}.\n If none are provided, or if there is no entry for the given year, one is\n manufactured based on the default ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultMonth','month')}\n and ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultDate','date')}.",methods:[],name:"FiscalCalendar"},"method:DataSource.renameFile":{seeAlso:[],requiresModules:["SCServer"],type:"method",definingClass:"class:DataSource",groups:["fileSource"],deprecated:null,ref:"method:DataSource.renameFile",params:[{defaultValue:null,optional:false,type:"FileSpec | String",description:'Either a FileSpec, or a String which                 will be parsed to determine the fileName, fileType and fileFormat\n                 of the file to rename.\n                 For instance, "employees.ds.xml" would be parsed as\n                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.\n                 Depending on the configuration of the DataSource, the fileType and fileFormat\n                 may be optional.',name:"oldFileSpec"},{defaultValue:null,optional:false,type:"FileSpec | String",description:'Either a FileSpec, or a String which                 will be parsed to determine the fileName, fileType and fileFormat\n                 to rename the file to.\n                 For instance, "employees.ds.xml" would be parsed as\n                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.\n                 If the fileType or fileFormat are not provided, then they will not\n                 be changed.',name:"newFileSpec"},{defaultValue:null,optional:true,type:"DSCallback",description:"Callback executed with the results.                  The <code>data</code> parameter is either an array of\n                 records represening the renamed file(s), or null to\n                 indicate an error.\n                 The records will have their <code>fileName</code> fields and\n                 <code>fileType</code> fields populated, but not the\n                 <code>fileContents</code> field.\n                 You can examine <code>${isc.DocUtils.linkForRef('attr:DSResponse.status','dsResponse.status')}</code>\n                 and <code>${isc.DocUtils.linkForRef('attr:DSResponse.data','dsResponse.data')}</code>\n                 for additional information about any error.",name:"callback"}],description:"\n Rename a file stored in this DataSource.  Note, if \n ${isc.DocUtils.linkForRef('attr:DataSource.fileVersionField','automatic file versioning')} is switched on for the dataSource,\n all versions of the file are renamed.\n\n",flags:"",name:"renameFile"},"attr:OperationBinding.outputs":{seeAlso:[{ref:"attr:DataSourceField.outputWhen",description:null},{ref:"attr:DSRequest.outputs",description:null}],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",deprecated:null,ref:"attr:OperationBinding.outputs",valueType:"String",description:"Specifies, for this operationBinding only, the list of field names that should be returned\n to the client.  Typically this will be a subset of the ${isc.DocUtils.linkForRef('attr:DataSource.fields')}, but note \n that this is not a requirement; <code>outputs</code> can include fields that are not defined\n in the DataSource's field list.  In this case, the server will return extra fields even if \n ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')} is true.\n <p>\n You specify this property as a string containing a comma-separated list of field names \n (eg, \"foo, bar, baz\")\n <p>\n Note that this setting overrides ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.outputWhen')} \n setting, meaning fields listed in operationBinding.outputs will be returned to the client regardless \n of those settings.",flags:"IR",serverDS:"only",name:"outputs"},"class:Shuttle":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"HLayout",classMethods:[],classAttrs:[],attrs:["attr:Shuttle.dataSource","attr:Shuttle.fields","attr:Shuttle.data","attr:Shuttle.valueField","attr:Shuttle.fetchOperation","attr:Shuttle.sortField","attr:Shuttle.sortDirection","attr:Shuttle.initialSort","attr:Shuttle.textMatchStyle","attr:Shuttle.filterContext","attr:Shuttle.implicitCriteria","attr:Shuttle.sourceGrid","attr:Shuttle.targetGrid","attr:Shuttle.sourceGridTitle","attr:Shuttle.targetGridTitle","attr:Shuttle.selectedRecords","attr:Shuttle.loadingPlaceholderAttribute","attr:Shuttle.selectedValues","attr:Shuttle.controlBar","attr:Shuttle.selectAllButton","attr:Shuttle.selectAllButtonIcon","attr:Shuttle.selectAllButtonWidth","attr:Shuttle.selectAllButtonHeight","attr:Shuttle.incompleteDataWarning","attr:Shuttle.selectButton","attr:Shuttle.selectButtonIcon","attr:Shuttle.selectButtonWidth","attr:Shuttle.selectButtonHeight","attr:Shuttle.deselectButton","attr:Shuttle.deselectButtonIcon","attr:Shuttle.deselectButtonWidth","attr:Shuttle.deselectButtonHeight","attr:Shuttle.deselectAllButton","attr:Shuttle.deselectAllButtonIcon","attr:Shuttle.deselectAllButtonWidth","attr:Shuttle.deselectAllButtonHeight"],ref:"class:Shuttle",deprecated:null,treeLocation:["Client Reference/Grids"],description:"Shuttle-style selection component allowing uses to select records by moving them from\n a set of source records to a set of target records",methods:["method:Shuttle.getValueFieldName","method:Shuttle.setImplicitCriteria","method:Shuttle.selectRecords","method:Shuttle.deselectRecords","method:Shuttle.clearSelection","method:Shuttle.selectionUpdated","method:Shuttle.setSelectedByValue","method:Shuttle.valuesFetchInProgress","method:Shuttle.valuesFetchComplete","method:Shuttle.getSelectedRecords","method:Shuttle.getSelectedValues"],name:"Shuttle"},"method:RelativeDateItem.setFiscalCalendar":{seeAlso:[],ref:"method:RelativeDateItem.setFiscalCalendar",deprecated:null,type:"method",definingClass:"class:RelativeDateItem",params:[{defaultValue:null,optional:true,type:"FiscalCalendar",description:"the fiscal calendar for this chooser, if set, or the global            one otherwise",name:"fiscalCalendar"}],description:" Sets the ${isc.DocUtils.linkForRef('object:FiscalCalendar')} object that will be used by this item's DateChooser.  If \n unset, the ${isc.DocUtils.linkForRef('classMethod:DateUtil.getFiscalCalendar','global fiscal calendar')} is used.\n\n",flags:"",name:"setFiscalCalendar"},"class:IconButton":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"RibbonButton",classMethods:[],classAttrs:[],attrs:[],ref:"class:IconButton",deprecated:"this is an old synonym for ${isc.DocUtils.linkForRef('class:RibbonButton')}, scheduled for removal in the next release",treeLocation:["Client Reference/Layout/RibbonBar"],description:"A simple subclass of ${isc.DocUtils.linkForRef('class:RibbonButton','RibbonButton')}.",methods:[],name:"IconButton"},"attr:MultiComboBoxItem.pickListConstructor":{seeAlso:[],defaultValue:'"PickListMenu"',type:"attr",definingClass:"class:MultiComboBoxItem",groups:["pickList"],deprecated:null,ref:"attr:MultiComboBoxItem.pickListConstructor",valueType:"SCClassName",description:"The Class to use when creating a picker of ${isc.DocUtils.linkForRef('attr:PickList.dataSetType','type \"list\"')} for \n a FormItem.  Must be a subclass of the builtin default, \n ${isc.DocUtils.linkForRef('class:PickListMenu','PickListMenu')}.",flags:"IR",name:"pickListConstructor"},"method:DataSource.recordsAreEqual":{seeAlso:[],ref:"method:DataSource.recordsAreEqual",deprecated:null,type:"method",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"Any",description:"record to be compared against.",name:"record1"},{defaultValue:null,optional:false,type:"Any",description:"record to be compared.",name:"record2"}],description:" Convenience method to test if two records are equal. Testing is done only for the\n fields defined in the DataSource, anything else is ignored.\n\n",flags:"",returns:{type:"boolean",description:"true if the records are equal, false otherwise."},name:"recordsAreEqual"},"attr:StretchImgButton.autoFit":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:StretchImgButton",groups:["sizing"],ref:"attr:StretchImgButton.autoFit",deprecated:null,setter:["setAutoFit"],valueType:"boolean",description:'If true, ignore the specified size of this widget and always size just large\n enough to accommodate the title.  If <code>setWidth()</code> is explicitly called on an\n autoFit:true button, autoFit will be reset to <code>false</code>.\n <P>\n Note that for StretchImgButton instances, autoFit will occur horizontally only, as \n unpredictable vertical sizing is likely to distort the media. If you do want vertical \n auto-fit, this can be achieved by simply setting a small height, and having \n overflow:"visible"',flags:"IRW",name:"autoFit"},"attr:StretchImgButton.definingProperty":{seeAlso:[],ref:"attr:StretchImgButton.definingProperty",defaultValue:'"title"',deprecated:null,type:"attr",definingClass:"class:StretchImgButton",valueType:"String",description:"This attribute denotes the name of a property to use as a\n ${isc.DocUtils.linkForRef('method:Canvas.getDefiningPropertyName','getDefiningPropertyName()')} for this property when generating and resolving\n ${isc.DocUtils.linkForRef('type:AutoTestLocator','AutoTest locators with search segments')}.",flags:"IRWA",name:"definingProperty"},"method:List.getLength":{groups:["access"],seeAlso:[],ref:"method:List.getLength",deprecated:null,type:"method",definingClass:"interface:List",description:" Return the number of items in this list\n\n",flags:"",returns:{type:"Number",description:"number of items in the list"},name:"getLength"},"attr:ToggleSwitch.thumbOffset":{seeAlso:[],defaultValue:"2",type:"attr",definingClass:"class:ToggleSwitch",groups:["appearance"],deprecated:null,ref:"attr:ToggleSwitch.thumbOffset",valueType:"Integer",description:"Spacing to apply inside of this ToggleSwitch, outside of the ${isc.DocUtils.linkForRef('attr:ToggleSwitch.thumb')}.",flags:"IRW",name:"thumbOffset"},"group:gridFiltering":{refs:[],seeAlso:[],ref:"group:gridFiltering",treeLocation:["Client Reference/Grids/ListGrid"],deprecated:null,type:"group",title:"Grid Filtering Overview",description:"This overview discusses various ways that ${isc.DocUtils.linkForRef('type:Criteria','search criteria')} can be \n applied to a ${isc.DocUtils.linkForRef('class:ListGrid','grid')} to filter the data being displayed.  \n <p>\n Typically, there are two types of criteria that affect how a grid matches data:\n <ul>\n <li>Implicit criteria - hidden criteria, applied by the developer, to the \n     ${isc.DocUtils.linkForRef('attr:ListGrid.implicitCriteria','grid')} or its\n     ${isc.DocUtils.linkForRef('attr:DataSource.implicitCriteria','dataSource')}, and never made available to \n     users</li>\n <li>Explicit criteria - public criteria, which may be applied by the developer or \n     entered by the user - this\n     criteria may be displayed to and modified by the user at runtime in various ways</li>\n </ul>\n A grid may have both implicit criteria, and explicit criteria that may come from multiple \n sources.  When data is fetched, the implicit-criteria and any sources of \n ${isc.DocUtils.linkForRef('method:ListGrid.getCriteria','explicit criteria')} are  \n ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria','combined')} and used to match records.\n <p>\n Note, however, that attempts to fetch with more restrictive criteria may not result in a \n server-trip, because ${isc.DocUtils.linkForRef('class:ResultSet')}s implement local filtering adaptively and may \n not require a server-trip if a filter can be achieved from local caches.\n\n <h4>Initial Filter Criteria</h4>\n You can provide an initial filter for a grid by setting \n ${isc.DocUtils.linkForRef('attr:ListGrid.implicitCriteria','implicit criteria')}, which is never shown to the user, or\n ${isc.DocUtils.linkForRef('attr:ListGrid.initialCriteria','initial criteria')}, which may be shown for editing in the \n grid's builtin ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter-row')}.  You can also provide both \n types, if only some parts of the criteria should be public. \n \n <h4>Filter Row Criteria</h4>\n Grids provide a ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor','filter-row')} that allows users\n to apply search-values on a per-field basis.  When ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterOperators')} is\n true, the default, users can modify the ${isc.DocUtils.linkForRef('object:Operator','search operator')} assigned to a\n given field via the grid's ${isc.DocUtils.linkForRef('attr:ListGrid.headerContextMenu','header context-menu')}, allowing \n for more complex matching.  If the selected operator is not the field's\n ${isc.DocUtils.linkForRef('attr:ListGridField.filterOperator','default operator')}, or if \n ${isc.DocUtils.linkForRef('attr:ListGrid.alwaysShowOperatorIcon')} is true, the current operator is indicated in a small\n icon in each filter-field. \n <p>\n Developers can interact with a field's search operator with \n ${isc.DocUtils.linkForRef('method:ListGrid.getFieldSearchOperator')}, ${isc.DocUtils.linkForRef('method:ListGrid.setFieldSearchOperator')} and\n ${isc.DocUtils.linkForRef('method:ListGrid.clearFieldSearchOperator')}.\n <p>\n Criteria in the filter-row reflects current public criteria that \n ${isc.DocUtils.linkForRef('method:FormItem.canEditCriterion','can be edited')}.  Developers can retrieve this criteria with\n ${isc.DocUtils.linkForRef('method:ListGrid.getFilterEditorCriteria')} and set it with \n ${isc.DocUtils.linkForRef('method:ListGrid.setFilterEditorCriteria')}.  When the filter-row is showing, Calls to APIs such \n as ${isc.DocUtils.linkForRef('method:ListGrid.setCriteria')} or ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} will apply criteria to the \n filter-row, if the editors there allow it.  Any criteria\n applied by these methods, that cannot be edited by the associated field's filter-editor, are \n still applied to fetches and will be \n returned by calls to ${isc.DocUtils.linkForRef('method:ListGrid.getCriteria')} or \n ${isc.DocUtils.linkForRef('method:ListGrid.getFilterEditorCriteria')}, but are not shown to the user for editing. \n <p>\n Developers may specify a field's ${isc.DocUtils.linkForRef('attr:ListGridField.filterEditorType','filterEditor-type')},\n and this can be a custom ${isc.DocUtils.linkForRef('class:FormItem')} class that uses \n ${isc.DocUtils.linkForRef('method:FormItem.getCriterion','getCriterion()')}, \n ${isc.DocUtils.linkForRef('method:FormItem.setCriterion','setCriterion()')} and \n ${isc.DocUtils.linkForRef('method:FormItem.canEditCriterion','canEditCriterion()')} to manage the criteria it works with.\n <p>\n For more complicated cases or more control, developers can implement \n ${isc.DocUtils.linkForRef('method:ListGrid.filterEditorSubmit')}.\n <p>\n Criteria from the filter-row is combined with other sources of criteria when data is fetched.\n \n <h4>External Criteria</h4>\n If you have external logic, or a ${isc.DocUtils.linkForRef('class:SearchForm','form')} outside of the grid, that \n produces criteria, you can apply the criteria by passing it to \n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData')} or  ${isc.DocUtils.linkForRef('method:ListGrid.filterData','filterData')}.  The \n primary difference between these two APIs is that <code>filterData</code> applies a \n ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} of <i>substring</i>, so that records are matched by \n case-insensitive substring comparison.\n <p>\n If you have the <code>FilterEditor</code> showing, these external criteria will be appear\n in the filterEditor, where supported.  Developers can apply additional external criteria \n without that effect by passing them to\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.setImplicitCriteria')}, or by setting ${isc.DocUtils.linkForRef('attr:ListGrid.searchForm')} to \n the external criteria form. \n <p>\n If you need more power or variance than the filter-row provides, you can set \n ${isc.DocUtils.linkForRef('attr:ListGrid.allowFilterWindow')} to show a full-blown ${isc.DocUtils.linkForRef('class:FilterBuilder')}, to \n construct more complex criteria that can also include logical operators like <i>or</i>.\n <p>\n All sources of criteria are combined to match records when data is fetched.  \n <h4>Saving Criteria</h4>\n Grid criteria can be saved and restored with ${isc.DocUtils.linkForRef('method:ListGrid.getViewState','view-state')} and \n via the ${isc.DocUtils.linkForRef('class:SavedSearches')} feature, which is turned on by default.",name:"gridFiltering"},"attr:FormValidateValuesTask.passThruOutput":{seeAlso:[],ref:"attr:FormValidateValuesTask.passThruOutput",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:FormValidateValuesTask",valueType:"Boolean",description:"Does this processElement pass through output from the last executed task\n (i.e. transient state)?\n <P>\n See ${isc.DocUtils.linkForRef('type:TaskInputExpression','taskInputExpressions')} for details on the\n transient state outputs.\n <p>\n Note that this property does not affect the task at all but is an indicator\n to the user and to the workflow editor of the behavior of the task as coded\n (See ${isc.DocUtils.linkForRef('method:Process.passThruTaskOutput')}).",flags:"IR",name:"passThruOutput"},"attr:ListGridField.showDownIcon":{seeAlso:[{ref:"attr:ListGridField.icon",description:null}],defaultValue:"false",type:"attr",definingClass:"object:ListGridField",groups:["buttonIcon"],deprecated:null,ref:"attr:ListGridField.showDownIcon",valueType:"Boolean",description:"If using an icon for this button, whether to switch the icon image when the mouse goes\n down on the button.",flags:"IR",name:"showDownIcon"},"group:loadDMIStubsTag":{refs:[],seeAlso:[{ref:"class:DMI",description:null}],ref:"group:loadDMIStubsTag",requiresModules:["SCServer"],treeLocation:["Java Server Reference/SmartClient JSP Tags"],deprecated:null,type:"group",title:"&lt;isomorphic:loadDMIStubs&gt;",description:'See ${isc.DocUtils.linkForRef(\'group:jspTags\')}\n <P>\n <i>produces:</i> JavaScript\n <p>\n Creates global bindings for all serverObjects defined in the <code>rpcBindings</code>\n section of the .app.xml file specified by the <code>ID</code> or <code>name</code> attribute of\n this tag.  Once you\'ve loaded your <code>rpcBindings</code> using this tag, you can call\n methods on the <code>ServerObjects</code> defined there directly.  For example, you can load\n the example.app.xml (located in /shared/app directory of the webRoot of the SDK) like this:\n <pre>\n &lt;isomorphic:loadDMIStubs ID="example"/&gt;\n </pre>\n Whereas using ${isc.DocUtils.linkForRef(\'classMethod:DMI.call\')} you would have had to invoke the <code>getTimeStamp</code>\n method like this:\n <pre>\n DMI.call("example", "GetTimeStampDMI", "getTimeStamp", new Date(), "alert(data)";\n </pre>\n Having loaded the stubs of the <code>example</code> .app.xml, you can then call\n <code>getTimeStamp</code> like this:\n <pre>\n GetTimeStampDMI.getTimeStamp(new Date(), "alert(data)");\n </pre>\n or this:\n <pre>\n GetTimeStampDMI.getTimeStamp({\n     arguments: [new Date()],\n     callback: "alert(data)"\n });\n </pre>\n or this:\n <pre>\n GetTimeStampDMI.call({\n     methodName: "getTimeStamp",\n     arguments: [new Date()],\n     callback: "alert(data)"\n });\n </pre>\n As with ${isc.DocUtils.linkForRef(\'classMethod:DMI.call\')}, the last argument must be the callback - if you don\'t want a\n callback, simply specify <code>null</code> as the callback.  The name of the global binding\n created will be the same as the ${isc.DocUtils.linkForRef(\'attr:ServerObject.ID\')} or the non-qualified name of the\n ${isc.DocUtils.linkForRef(\'attr:ServerObject.className\')} (java namespace, if any, will be stripped).\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>ID or name</b><br>\n <i>value format</i>: String - name of .app.xml file to load (minus the .app.xml extension)<br>\n <i>default value</i>: NONE\n <p>\n This attribute specifies the name of the file that contains the rpcBindings to load.\n UI files are located in <code>[webroot]/shared/app</code> by default.  This location is\n changeable in ${isc.DocUtils.linkForRef(\'group:server_properties\',\'[webroot]/WEB-INF/classes/server.properties\')}\n by setting the config\n parameter <code>project.apps</code> to the directory where your .app.xml files are located.   \n We recommend that for prototyping, at least, you use the default directory.',name:"loadDMIStubsTag"},"attr:FormItem.validateOnChange":{seeAlso:[{ref:"attr:DynamicForm.validateOnChange",description:null}],defaultValue:"false",type:"attr",definingClass:"class:FormItem",groups:["changeHandling"],deprecated:null,ref:"attr:FormItem.validateOnChange",valueType:"Boolean",description:'If true, form items will be validated when each item\'s "change" handler is fired\n as well as when the entire form is submitted or validated.\n <p>\n Note that this property can also be set at the form level or on each validator;\n If true at the form or field level, validators not explicitly set with\n <code>validateOnChange:false</code> will be fired on change - displaying errors and\n rejecting the change on validation failure.',flags:"IRW",name:"validateOnChange"},"method:StretchImgButton.addToRadioGroup":{groups:["state","event handling"],seeAlso:[],ref:"method:StretchImgButton.addToRadioGroup",deprecated:null,type:"method",definingClass:"class:StretchImgButton",params:[{defaultValue:null,optional:false,type:"String",description:"- ID of the radiogroup to which this widget should be added",name:"groupID"}],description:" Add this widget to the specified mutually exclusive selection group with the ID\n passed in.\n Selecting this widget will then deselect any other StatefulCanvases with the same\n radioGroup ID.\n StatefulCanvases can belong to only one radioGroup, so this method will remove from \n any other radiogroup of which this button is already a member.\n",flags:"",name:"addToRadioGroup"},"attr:DrawItem.knobs":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DrawItem",deprecated:null,ref:"attr:DrawItem.knobs",valueType:"Array of KnobType",description:"Array of control knobs to display for this item. Each ${isc.DocUtils.linkForRef('type:KnobType')} specified in this array\n will turn on UI element(s) allowing the user to manipulate this drawItem.  To update the\n set of knobs at runtime use ${isc.DocUtils.linkForRef('method:DrawItem.showKnobs')} and ${isc.DocUtils.linkForRef('method:DrawItem.hideKnobs')}.\n <p>\n <b>NOTE:</b> Unless otherwise documented, DrawItem types only support\n \"resize\" and \"move\"\n \n knobs.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('editDrawPane')}","${isc.DocUtils.linkForExampleId('drawKnobs')}"],name:"knobs"},"classMethod:DataSource.getDataSource":{seeAlso:[{ref:"classMethod:DataSource.get",description:null}],ref:"classMethod:DataSource.getDataSource",deprecated:null,type:"classMethod",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"GlobalId",description:"DataSource ID",name:"ID"},{defaultValue:null,optional:true,type:"Callback",description:"callback to fire when the DataSource is loaded. The callback     receives the loaded ${isc.DocUtils.linkForRef('class:DataSource')} as its single parameter.",name:"callback"}],description:" Lookup a DataSource by ID.\n <P>\n If the DataSource is not yet loaded and a callback is provided, the DataSource will be\n loaded from the server and the callback will be fired with the DataSource as its single\n argument.\n\n",flags:"",returns:{type:"DataSource",description:"the DataSource with this ID, if loaded, otherwise null."},name:"getDataSource"},"attr:DataBoundComponent.initialCriteria":{seeAlso:[],ref:"attr:DataBoundComponent.initialCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"interface:DataBoundComponent",valueType:"Criteria",description:"Criteria to be used when ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchData')} is set.\n <p>\n This property supports ${isc.DocUtils.linkForRef('group:dynamicCriteria')} - use ${isc.DocUtils.linkForRef('attr:Criterion.valuePath')}\n to refer to values in the ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope')}.",flags:"IR",name:"initialCriteria"},"attr:FormItem.hint":{seeAlso:[{ref:"attr:FormItem.hintStyle",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["appearance"],ref:"attr:FormItem.hint",deprecated:null,valueType:"HTMLString",setter:["setHint"],description:'Specifies "hint" string to show next to the form item to indicate something to the user.\n This string generally appears to the right of the form item.',flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('formHints')}"],name:"hint"},"type:SQLPagingStrategy":{seeAlso:[{ref:"attr:DataSource.sqlPaging",description:null},{ref:"attr:OperationBinding.sqlPaging",description:null}],ref:"type:SQLPagingStrategy",deprecated:null,type:"type",values:[{value:'"sqlLimit"',description:"Specify the paging directly in the SQL query we generate.  The way this is done varies \n considerably from database to database: with some it is a straightforward built-in \n facility while others require arcane tricks or simply don't support the idea.  This is \n the most efficient method, where available.  Note that this strategy is not supported \n for operations that make use of a ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL','customSQL')} clause, \n because it depends upon being able to determine the size of the whole dataset without\n actually retrieving the whole dataset.  Ordinary operations do this by means of an \n automatically-generated \"row count query\", but we cannot generate such a query for a \n <code>customSQL</code> operation."},{value:'"jdbcScroll"',description:"Implement the paging behavior by use of the <code>absolute()</code> method of the\n JDBC <code>ResultSet</code>."},{value:'"dropAtServer"',description:"Implement the paging behavior by fetching the entire resultset from the database and\n dropping any unnecessary rows on the server before returning the data to the client.\n This approach is extremely inefficient, but also extremely straightforward; it is \n intended as a fallback option, for situations where the more sophisticated approaches\n cause problems (a JDBC driver that throws vague exceptions when <code>absolute()</code>\n is called, for example)"},{value:'"none"',description:"No paging behavior: we always return the entire resultset to the client."}],description:'The technique SmartClient Server\'s SQL DataSource should use to select a "page" of data \n from a table.',serverDS:"only",name:"SQLPagingStrategy"},"attr:FormulaBuilder.titleField":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FormulaBuilder",groups:["formulaFields"],deprecated:null,ref:"attr:FormulaBuilder.titleField",valueType:"AutoChild TextItem",description:"TextItem that allows users to set the title for this field.",flags:"IR",name:"titleField"},"classMethod:Canvas.setAutoResizeAutoChildAttributes":{seeAlso:[],ref:"classMethod:Canvas.setAutoResizeAutoChildAttributes",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"boolean",description:"true if attributes should be auto-resized",name:"autoResize"}],description:" Should registered autoChild attributes be automatically resized with \n ${isc.DocUtils.linkForRef('classMethod:Canvas.resizeControls','controls')} and\n ${isc.DocUtils.linkForRef('classMethod:Canvas.resizeFonts','text')}?\n <P>\n If true, attributes registered for resize with policy <code>\"controls\"</code> will\n be resized when <code>resizeControls()</code> runs, and icons registered\n with policy <code>\"fonts\"</code> will resize when <code>resizeFonts()</code> runs.\n <P>\n To resize autoChild attributes with other policies, developers should call\n ${isc.DocUtils.linkForRef('classMethod:Canvas.resizeAutoChildAttributes')} directly\n\n\n",flags:"",name:"setAutoResizeAutoChildAttributes"},"attr:FacetChart.radarRotateLabels":{seeAlso:[{ref:"attr:FacetChart.rotateLabels",description:null},{ref:"attr:FacetChart.radialLabelOffset",description:null}],defaultValue:'"auto"',type:"attr",definingClass:"class:FacetChart",groups:["labelsAndTitles"],deprecated:null,ref:"attr:FacetChart.radarRotateLabels",valueType:"LabelRotationMode",description:"This property controls whether to rotate the labels on the\n ${isc.DocUtils.linkForRef('method:FacetChart.getDataLabelFacet','data label facet')} of radar or ${isc.DocUtils.linkForRef('attr:FacetChart.stacked')} pie charts so that\n each label is parallel to its radial gradation (these are the labels that appear around\n the perimeter).  For now, \"auto\" means the same thing as \"always\" - but this may change\n in the future if heuristics are added to determine when the affected labels are likely to\n overlap and not be legible.  If rotateLabels is \"never\" then the labels will not be\n rotated.\n <P>",flags:"IR",name:"radarRotateLabels"},"class:Notify":{seeAlso:[{ref:"staticMethod:isc.say",description:null},{ref:"staticMethod:isc.confirm",description:null}],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:["classMethod:Notify.addMessage","classMethod:Notify.dismissMessage","classMethod:Notify.canDismissMessage","classMethod:Notify.configureMessages","classMethod:Notify.configureDefaultSettings","classMethod:Notify.setMessageContents","classMethod:Notify.setMessageActions","classMethod:Notify.messageHasActions"],classAttrs:["classAttr:Notify.ERROR","classAttr:Notify.WARN","classAttr:Notify.MESSAGE"],attrs:[],ref:"class:Notify",deprecated:null,treeLocation:["Client Reference/Control"],description:"Notify provides a means to display on-screen messages that are automatically dismissed after\n a configurable amount of time, as an alternative to ${isc.DocUtils.linkForRef('staticMethod:isc.confirm','modal notification')}\n dialogs that can lower end user productivity.  Messages may be shown at a particular\n location, specified either with viewport-relative coordinates, or as an edge or center\n location relative to the viewport or a canvas.  Messages can be configured to appear and\n disappear instantly, by sliding into (or out of) view, or by fading in (or out).\n <P>\n One or more ${isc.DocUtils.linkForRef('object:NotifyAction','actions')} can be provided when ${isc.DocUtils.linkForRef('classMethod:Notify.addMessage','addMessage()')} is called to display a message.  They will be rendered as links on which to\n click to execute the action.\n <P>\n The behavior and appearance of messages are configured per ${isc.DocUtils.linkForRef('type:NotifyType')}, which is simply\n a string that identifies that message group, similar to ${isc.DocUtils.linkForRef('method:Class.logWarn','log category')}.\n By calling ${isc.DocUtils.linkForRef('classMethod:Notify.configureMessages','configureMessages()')} with the\n <code>NotifyType</code>, it can be assigned a ${isc.DocUtils.linkForRef('object:NotifySettings')} configuration to control\n message animation, placement, and the the ${isc.DocUtils.linkForRef('class:Label')} used to render each message, allowing\n styling and autofit behavior to be configured.\n <P>\n Messages of the same <code>NotifyType</code> may be stacked to provide a visible\n history, with a configurable stacking direction and maximum stacking depth.  Details on how\n to configure messages are provided in the documentation for ${isc.DocUtils.linkForRef('object:NotifySettings')}.\n <P>\n Messages for different <code>NotifyType</code>s are stacked separately and animated by\n independent Framework pipelines.  It's up to you to configure the placement of supported\n <code>NotifyType</code>s in your app so that they don't overlap, as the Framework doesn't\n manage it.  For example, separate <code>NotifyType</code>s could be assigned separate screen\n edges, or assigned a different ${isc.DocUtils.linkForRef('attr:NotifySettings.positionCanvas')}.\n <P>\n To dismiss a message manually before its scheduled duration expires, you may call\n ${isc.DocUtils.linkForRef('classMethod:Notify.dismissMessage','dismissMessage()')} with a <code>NotifyType</code> (to dismiss\n all such messages) or an ID previously returned by ${isc.DocUtils.linkForRef('classMethod:Notify.addMessage','addMessage()')}\n (to dismiss that single message).\n <P>\n <B>Warnings and Errors</B>\n <P>\n Each notification may be assigned a ${isc.DocUtils.linkForRef('attr:NotifySettings.messagePriority','messagePriority')} in\n the settings passed to ${isc.DocUtils.linkForRef('classMethod:Notify.addMessage','addMessage()')}.  By default, all\n <code>NotifyType</code>s are configured to have priority ${isc.DocUtils.linkForRef('classAttr:Notify.MESSAGE')}, except for\n \"error\" and \"warn\" <code>NotifyType</code>s, which are configured with priority\n ${isc.DocUtils.linkForRef('classAttr:Notify.ERROR')} and ${isc.DocUtils.linkForRef('classAttr:Notify.WARN')}, respectively.\n <P>\n The ${isc.DocUtils.linkForRef('attr:NotifySettings.messagePriority','messagePriority')} determines the default styling of a\n message, and which message to remove if a new message is sent while the message stack is\n already at its limit.  We recommended applying a ${isc.DocUtils.linkForRef('attr:NotifySettings.messagePriority','messagePriority')} as the best approach for showing pre-styled warnings and errors, since that\n allows you to interleave them with ordinary messages in a single <code>NotifyType</code>.\n <P>\n Alternatively, you can display pre-styled warnings and errors by calling\n ${isc.DocUtils.linkForRef('classMethod:Notify.addMessage','addMessage()')} with the separate <code>NotifyType</code>s\n \"warning\" and \"error\", respectively, but then you must take care to\n ${isc.DocUtils.linkForRef('classMethod:Notify.configureMessages','assign each NotifyType')} used to a separate screen\n location to avoid one rendering on top of the other.\n <P>\n <B>Viewport Considerations</B>\n <P>\n Messages are edge or corner-aligned based on the ${isc.DocUtils.linkForRef('classMethod:Page.getScrollWidth','viewport width')}\n and ${isc.DocUtils.linkForRef('classMethod:Page.getScrollHeight','viewport height')} of the current page rather than screen, so\n you may need to scroll to see the targeted corner or edge.  Note that widgets placed\n offscreen below or to the right of a page may cause the browser to report a larger viewport,\n and prevent messages from being visible, even if no scrollbars are present.  If you need to\n stage widgets offscreen for measurement or other reasons, place them above or to the left.\n <P>\n <B>Modal Windows and Click Masks</B>\n <P>\n Messages are always shown above all other widgets, including ${isc.DocUtils.linkForRef('attr:Window.isModal','modal windows')} and ${isc.DocUtils.linkForRef('method:Canvas.showClickMask','click masks')}.  This is because it's expected\n that messages are \"out of band\" and logically indepedent of the widget hierarchy being shown.\n We apply this layering policy even for windows and widgets created by ${isc.DocUtils.linkForRef('object:NotifyAction')}s.\n If there may a scenario where a message can block a window created by an action, set\n ${isc.DocUtils.linkForRef('attr:NotifySettings.canDismiss')} to true so that an unobstructed view of the underlying\n widgets can be restored.\n <P>\n In the linked sample, note how we take care to reuse the existing modal window, if any, if\n the \"Launch...\" link is clicked, so that repeated clicks never stack windows over each other.",methods:[],examples:["${isc.DocUtils.linkForExampleId('notifications')}"],name:"Notify"},"attr:ListGrid.groupTitleField":{seeAlso:[{ref:"method:ListGrid.groupBy",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["grouping"],deprecated:null,ref:"attr:ListGrid.groupTitleField",valueType:"String",description:"When a list grid is ${isc.DocUtils.linkForRef('method:ListGrid.groupBy','grouped')}, each group shows\n under an auto generated header node. By default the title of the group will be\n shown, with a hanging indent in this node, and will span all columns in the grid.\n Setting this property causes the titles of auto-generated group nodes to appear as\n though they were values of the designated field instead of spanning all columns\n and record values in the designated groupTitleField will appear indented under\n the group title in a manner similar to how a TreeGrid shows a Tree.\n <P>\n Note if ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummaryInHeader')} is true, the header nodes will not show\n a single spanning title value by default - instead they will show the summary values for\n each field. In this case, if groupTitleField is unset, a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupTitleColumn','groupTitleColumn')} can be automatically generated to\n show the title for each group.",flags:"IR",name:"groupTitleField"},"attr:NavPanel.navGrid":{seeAlso:[],ref:"attr:NavPanel.navGrid",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:NavPanel",valueType:"AutoChild TreeGrid",description:"The ${isc.DocUtils.linkForRef('class:TreeGrid')} used to display ${isc.DocUtils.linkForRef('object:NavItem')}s.",flags:"IR",name:"navGrid"},"attr:DataBoundComponent.reapplyingAsyncFilterAndSortMessage":{seeAlso:[],defaultValue:'"${animatedLoadingImage} Re-filtering and sorting ${numRecords} record(s)&amp;hellip;"',type:"attr",definingClass:"interface:DataBoundComponent",groups:["i18nMessages"],deprecated:null,ref:"attr:DataBoundComponent.reapplyingAsyncFilterAndSortMessage",valueType:"HTMLString",description:"The HTML-format message displayed to users while asynchronous filters are being re-evaluated on a list of records.",flags:"IRW",name:"reapplyingAsyncFilterAndSortMessage"},"classAttr:Operators.notStartsWithTitle":{seeAlso:[],defaultValue:'"does not start with (match case)"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.notStartsWithTitle",valueType:"String",description:'Title for the "notStartsWith" operator',flags:"IR",name:"notStartsWithTitle"},"classMethod:DataSource.flattenCriteria":{seeAlso:[],ref:"classMethod:DataSource.flattenCriteria",deprecated:null,type:"classMethod",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"AdvancedCriteria",description:"the AdvancedCriteria to flatten",name:"criteria"}],description:' Returns new criteria that has at most one top-level LogicalOperator ("and" or "or").\n This new criteria will be considered "flat" by ${isc.DocUtils.linkForRef(\'classMethod:DataSource.isFlatCriteria\')}.\n <p>\n Not all AdvancedCriteria can be flattened and remain logically equivalent.  When\n criteria will be logically modified by flattening, all criteria that appear anywhere in\n the AdvancedCriteria structure will appear under a single top-level operator, which\n will be the same top-level operator as the passed AdvancedCriteria.\n <p>\n For example, given criteria like this (in the JSON representation of AdvancedCriteria):\n <pre>\n      { operator: "and", criteria: [\n         { fieldName: "continent", operator: "equals", value: "Europe"},\n         { operator: "or", criteria: [\n            { fieldName: "countryName", operator: "iEndsWith", value: "land"},\n            { fieldName: "population", operator: "lessThan", value: 3000000}\n         ]}\n        ]\n      }\n </pre>\n The returned criteria would be:\n <pre>\n      { operator: "and", criteria: [\n         { fieldName: "continent", operator: "equals", value: "Europe"},\n         { fieldName: "countryName", operator: "iEndsWith", value: "land"},\n         { fieldName: "population", operator: "lessThan", value: 3000000}\n       ]}\n </pre>\n This returned criteria is not logically equivalent to the passed criteria - the\n "iEndsWith" and "lessThan" criteria that were formerly nested under a logical "or"\n operator must now <i>both</i> be satisfied instead of <i>either</i> being satisfied.\n You can use ${isc.DocUtils.linkForRef(\'classMethod:DataSource.canFlattenCriteria\')} to detect whether an AdvancedCriteria is going\n to be changed by <code>flattenCriteria()</code>.\n <p>\n Because the returned criteria may not be logically equivalent,\n <code>flattenCriteria</code> should not be used as a means of simplifying criteria to\n make server implementation easier or anything of the kind.  The primary purpose of\n returning logically different criteria is to enable an end user to switch from an\n interface for editing nested criteria to an interface that can\'t handle nested\n criteria and convert the criteria while preserving as much as possible.\n\n',flags:"",returns:{type:"AdvancedCriteria",description:"flattened criteria"},name:"flattenCriteria"},"attr:OperationBinding.dataTransport":{seeAlso:[{ref:"type:RPCTransport",description:null},{ref:"attr:DataSource.callbackParam",description:null}],defaultValue:"RPCManager.defaultTransport",type:"attr",definingClass:"class:OperationBinding",groups:["clientDataIntegration"],deprecated:null,ref:"attr:OperationBinding.dataTransport",valueType:"RPCTransport",description:"Transport to use for this operation.  Defaults to ${isc.DocUtils.linkForRef('attr:DataSource.dataTransport')}, which in\n turn defaults to ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTransport')}.  This would typically only be set to\n enable \"scriptInclude\" transport for contacting ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','JSON')} web\n services hosted on servers other than the origin server.\n <p>\n When using the \"scriptInclude\" transport, be sure to set ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')} or\n ${isc.DocUtils.linkForRef('attr:OperationBinding.callbackParam')} to match the name of the query parameter name expected\n by your JSON service provider.",flags:"IR",name:"dataTransport"},"method:TreeGrid.openFolder":{seeAlso:[{ref:"method:TreeGrid.closeFolder",description:null},{ref:"method:TreeGrid.folderOpened",description:null},{ref:"class:ListGrid",description:null}],ref:"method:TreeGrid.openFolder",deprecated:null,type:"method",definingClass:"class:TreeGrid",params:[{defaultValue:null,optional:false,type:"TreeNode",description:"node to open",name:"node"},{defaultValue:null,optional:true,type:"String",description:"optional parameter containing the full path to the node.                                      This is essential context for a\n                                      ${isc.DocUtils.linkForRef('attr:Tree.multiLinkTree','multi-link tree')}, but is not \n                                      required in ordinary trees",name:"path"}],description:" Opens a folder.\n <p>\n Executed when a folder node receives a 'doubleClick' event.\n If you override this method, the single parameter passed will be\n a reference to the relevant folder node in the tree's data.\n <p>\n See the ListGrid Widget Class for inherited recordClick and recordDoubleClick events.\n\n",flags:"A",name:"openFolder"},"attr:Tour.tourWizardShowProgressTitle":{seeAlso:[],defaultValue:'"Show Progress"',type:"attr",definingClass:"class:Tour",groups:["i18nMessages"],deprecated:null,ref:"attr:Tour.tourWizardShowProgressTitle",valueType:"HTMLString",description:"Title for the <i>Show Progress</i> picker in the Tour Wizard.",flags:"IR",name:"tourWizardShowProgressTitle"},"attr:DrawImage.top":{seeAlso:[],defaultValue:"0",type:"attr",definingClass:"class:DrawImage",deprecated:null,ref:"attr:DrawImage.top",setter:["setTop"],valueType:"Coordinate",description:"Top coordinate in pixels relative to the ${isc.DocUtils.linkForRef('class:DrawPane','local coordinate system')}.",flags:"IRW",name:"top"},"attr:FacetChart.canZoom":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["zoom"],deprecated:null,ref:"attr:FacetChart.canZoom",valueType:"boolean",description:"Enables \"zooming\" on the X axis, specifically, only a portion of the overall dataset is shown\n in the main chart, and a ${isc.DocUtils.linkForRef('attr:FacetChart.zoomChart','second smaller chart')} appears with slider controls\n allowing a range to be selected for display in the main chart.\n <P>\n A ${isc.DocUtils.linkForRef('attr:FacetChart.labelCollapseMode','labelCollapseMode')} is automatically enabled if\n unset and is based on the type of the first non-null data value.",flags:"IR",name:"canZoom"},"attr:SavedSearchItem.editProxyConstructor":{seeAlso:[],ref:"attr:SavedSearchItem.editProxyConstructor",defaultValue:'"SavedSearchItemEditProxy"',deprecated:null,type:"attr",definingClass:"class:SavedSearchItem",valueType:"SCClassName",description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",flags:"IR",name:"editProxyConstructor"},"class:SectionHeader":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Label",classMethods:[],classAttrs:[],attrs:["attr:SectionHeader.definingProperty","attr:SectionHeader.editProxyConstructor","attr:SectionHeader.title","attr:SectionHeader.clipTitle","attr:SectionHeader.showClippedTitleOnHover","attr:SectionHeader.controls","attr:SectionHeader.controlsLayout","attr:SectionHeader.icon","attr:SectionHeader.baseStyle","attr:SectionHeader.noDoubleClicks"],ref:"class:SectionHeader",deprecated:null,treeLocation:["Client Reference/Layout/SectionStack"],description:"Simple SectionHeader class based on a Label with an icon, skinnable via CSS.",methods:["method:SectionHeader.getSectionStack","method:SectionHeader.titleClipped","method:SectionHeader.titleHoverHTML","method:SectionHeader.titleHover"],name:"SectionHeader"},"attr:RestDataSource.dataURL":{seeAlso:[],ref:"attr:RestDataSource.dataURL",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:RestDataSource",valueType:"String",description:"Default URL to contact to fulfill all DSRequests.  \n RestDataSources also allow per-operationType dataURLs to be set via\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:RestDataSource.fetchDataURL')}</li>\n <li>${isc.DocUtils.linkForRef('attr:RestDataSource.addDataURL')}</li> \n <li>${isc.DocUtils.linkForRef('attr:RestDataSource.updateDataURL')}</li>\n <li>${isc.DocUtils.linkForRef('attr:RestDataSource.removeDataURL')}</li>\n </ul>\n <b>NOTE:</b>: when using ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','queuing')} with RestDataSource, an\n HTTP request containing mixed ${isc.DocUtils.linkForRef('attr:DSRequest.operationType','operationTypes')} (such as a\n mixture of \"add\", \"update\" and \"remove\" operations resulting from\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoSaveEdits','Grid Mass Editing')}) can only go to one URL, so you\n should not set distinct URLs for each <code>operationType</code>; doing so will break\n queuing of mixed operationTypes: multiple requests will be sent to distinct URLs, and a\n warning logged.",flags:"IR",name:"dataURL"},"attr:DynamicForm.canTabToIcons":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:DynamicForm",groups:["formIcons"],deprecated:null,ref:"attr:DynamicForm.canTabToIcons",valueType:"Boolean",description:"Should users be able to tab into the ${isc.DocUtils.linkForRef('attr:FormItem.icons','icons')} and \n ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon','picker icon')} for items within this form by default?\n <p>\n May be overridden at the item level by ${isc.DocUtils.linkForRef('attr:FormItem.canTabToIcons')}.\n <P>\n Developers may also suppress tabbing to individual icons by \n setting ${isc.DocUtils.linkForRef('attr:FormItemIcon.tabIndex')} to <code>-1</code>.",flags:"IRWA",name:"canTabToIcons"},"attr:HTMLPane.contentsURL":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:HTMLPane",groups:["contentLoading"],deprecated:null,ref:"attr:HTMLPane.contentsURL",valueType:"URL",description:"If specified the HTMLFlow will load its contents from this URL instead of\n displaying ${isc.DocUtils.linkForRef('attr:HTMLPane.contents','this.contents')}. May be combined with parameters if\n ${isc.DocUtils.linkForRef('attr:HTMLPane.contentsURLParams')} were specified.\n <P>\n The HTML retrieved from the target URL may be a complete standalone page to\n be rendered into its own scope using an IFRAME, or a fragment of HTML \n to display within this component's handle. See ${isc.DocUtils.linkForRef('type:ContentsType')} and\n ${isc.DocUtils.linkForRef('attr:HTMLPane.autoDeriveContentsType')} for more information.\n <P>\n Note that the link{loadingMessage} and\n ${isc.DocUtils.linkForRef('attr:HTMLFlow.httpMethod','httpMethod')} features only apply if contentsURL was set and \n contentsType was not explicitly set to  <code>\"page\"</code>",flags:"IRW",name:"contentsURL"},"attr:ColorPicker.lessButtonTitle":{seeAlso:[],defaultValue:'"&lt;&lt; Less"',type:"attr",definingClass:"class:ColorPicker",groups:["i18nMessages"],deprecated:null,ref:"attr:ColorPicker.lessButtonTitle",valueType:"HTMLString",description:"The title for the button that switches to a less complex view.",flags:"IR",name:"lessButtonTitle"},"object:CreateScreenSettings":{seeAlso:[{ref:"attr:CreateScreenSettings.classSubstitutions",description:null},{ref:"attr:CreateScreenSettings.componentSubstitutions",description:null}],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:CreateScreenSettings.classSubstitutions","attr:CreateScreenSettings.componentSubstitutions","attr:CreateScreenSettings.allowPlaceholders","attr:CreateScreenSettings.dataContext","attr:CreateScreenSettings.clobberDataSources","attr:CreateScreenSettings.suppressAutoDraw","attr:CreateScreenSettings.htmlElement","attr:CreateScreenSettings.verifyAsError","attr:CreateScreenSettings.verifyComponents"],ref:"object:CreateScreenSettings",deprecated:null,treeLocation:["Client Reference/Tools"],description:"Controls what class and instance substitutions, if any, are applied during a call to\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.createScreen')}.  Classes and instances can be mapped (constructed as)\n other classes, and existing widget instances can be returned for new ones.",methods:[],name:"CreateScreenSettings"},"method:ImgButton.setActionType":{groups:["state","event handling"],seeAlso:[],ref:"method:ImgButton.setActionType",deprecated:null,type:"method",definingClass:"class:ImgButton",params:[{defaultValue:null,optional:false,type:"SelectionType",description:"new action type",name:"actionType"}],description:" Update the 'actionType' for this canvas (radio / checkbox / button)\n If the canvas is currently selected, and the passed in actionType is 'button'\n this method will deselect the canvas.\n",flags:"",name:"setActionType"},"method:String.pluralize":{seeAlso:[],ref:"method:String.pluralize",deprecated:null,type:"method",definingClass:"object:String",description:" Given a number, this method will return the plural version of the string if appropriate.\n <P>\n The plural value will be derived from ${isc.DocUtils.linkForRef('classAttr:String.pluralNounMap')} if present, otherwise\n the plural value will be created by adding a lower or upper case <code>\"s\"</code>\n character to the string.\n \n",flags:"",returns:{type:"String",description:"plural version of the string"},name:"pluralize"},"attr:CubeGrid.showHoverTipsTitle":{seeAlso:[],defaultValue:'"Show Hover Tips"',type:"attr",definingClass:"class:CubeGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:CubeGrid.showHoverTipsTitle",valueType:"String",description:"Title for the show hover tips menu item.",flags:"IRW",name:"showHoverTipsTitle"},"method:RPCRequest.xhr_onProgress":{seeAlso:[],ref:"method:RPCRequest.xhr_onProgress",deprecated:null,type:"method",definingClass:"object:RPCRequest",params:[{defaultValue:null,optional:false,type:"Object",description:"The native  <a href='https://developer.mozilla.org/en-US/docs/Web/API/ProgressEvent' target='_blank'>ProgressEvent</a> with \n  attributes indicating the <code>loaded</code> content so far, and, if <code>Content-Length</code> headers were\n  set on the response, the <code>total</code> download size. Note that this is a native event produced\n  by the browser and SmartClient does not guarantee consistency for the event object, or the timing of the\n  <code>onprogress</code> event notifications across browsers.",name:"progressEvent"},{defaultValue:null,optional:false,type:"RPCRequest",description:"the request that initiated the download",name:"request"}],description:" Progress event notification fired repeatedly during requests with ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')} set\n to <code>\"xmlHttpRequest\"</code>.\n <P>\n This callback will be invoked from the native \n <a href='https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/progress_event' target='_blank'>XMLHttpRequest progress event</a>.\n <P>\n This is typically useful to provide visual feedback to the user when a lengthy download is in progress.\n \n",flags:"",name:"xhr_onProgress"},"attr:AUN.promptModeNavGraphDebug":{seeAlso:[],defaultValue:"{...}",type:"attr",definingClass:"class:AUN",groups:["CoTPartialPrompt"],deprecated:null,ref:"attr:AUN.promptModeNavGraphDebug",valueType:"PartialPromptConfig",description:'Partial prompt mode for debugging navigation graph and screen transitions.\n <P>\n Keeps history and transitions visible to trace navigation paths.\n Best for: "Why is the navigation graph in this state?"',flags:"IR",name:"promptModeNavGraphDebug"},"attr:PickList.showAllOptions":{seeAlso:[],ref:"attr:PickList.showAllOptions",defaultValue:"null",deprecated:null,type:"attr",definingClass:"interface:PickList",valueType:"boolean",description:"If true, even non-matching options will be shown, with configurable \n ${isc.DocUtils.linkForRef('attr:PickList.separatorRows','separator rows')} in between.  Not valid for\n ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource','databound pickLists')}.",flags:"IR",name:"showAllOptions"},"attr:Shuttle.sortDirection":{seeAlso:[],ref:"attr:Shuttle.sortDirection",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Shuttle",valueType:"SortDirection",description:"${isc.DocUtils.linkForRef('attr:ListGrid.sortDirection','Sort direction')} for this item's list of options. Will be applied\n to ${isc.DocUtils.linkForRef('attr:Shuttle.sourceGrid')} and ${isc.DocUtils.linkForRef('attr:Shuttle.targetGrid')}. To specify initial sort for each grid separately,\n these properties may be set per grid using the standard ${isc.DocUtils.linkForRef('type:AutoChild','autoChild pattern')}.",flags:"IR",name:"sortDirection"},"attr:BatchUploader.uploadDelimiter":{seeAlso:[],ref:"attr:BatchUploader.uploadDelimiter",defaultValue:'","',deprecated:null,type:"attr",definingClass:"class:BatchUploader",valueType:"String",description:"The delimiter to use when importing character-delimited files.  The default is\n comma (CSV).",flags:"IRW",name:"uploadDelimiter"},"attr:RichTextEditor.toolbar":{seeAlso:[],ref:"attr:RichTextEditor.toolbar",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:RichTextEditor",valueType:"MultiAutoChild Layout",description:"Layout used to contain each of the ${isc.DocUtils.linkForRef('attr:RichTextEditor.controlGroups')}.",flags:"R",name:"toolbar"},"attr:FacetChart.showDataValuesMode":{seeAlso:[],defaultValue:'"never"',type:"attr",definingClass:"class:FacetChart",groups:["labelsAndTitles"],deprecated:null,ref:"attr:FacetChart.showDataValuesMode",valueType:"ShowDataValuesMode",description:"Strategy for determining whether and when to show data-values - either in the chart,\n near the shape representing a value (above columns of a column chart for example, or \n adjacent to points in a line chart), in hovers, or some combination of both, including \n ${isc.DocUtils.linkForRef('attr:FacetChart.rotateDataValues','automatic rotation')} where supported.\n <p>\n Depending on the chart type, there are different options for showing data-values - eg, \n ${isc.DocUtils.linkForRef('attr:FacetChart.stacked','stacked-charts')} cannot show values inline in the chart-body;  \n column-charts can, and they can rotate titles if they're wider than their columns;  \n pie charts can show some data-values in the chart but not others;  all the types can \n show values in hovers.  \n <P>\n If set to <i>never</i>, then data-values will never be shown; <i>inChartOnly</i> \n allows data-values in the chart-body, where supported and where they will fit, but \n suppresses them in hovers and <i>inHoverOnly</i> always shows all data-values in hovers.\n <p>\n If set to <i>auto</i>, first try to show values in the chart, where the chart-type \n supports it, and where they'll fit.  If they don't all fit, show the ones that \n do, including rotating them if necessary, if the chart-type allows it, and \n then switch on hovers as well, as needed.  This mode is particularly useful in situations \n where the chart-type can be changed by the user.",flags:"IRW",name:"showDataValuesMode"},"method:Slider.setMaxValueLabel":{seeAlso:[],ref:"method:Slider.setMaxValueLabel",deprecated:null,type:"method",definingClass:"class:Slider",params:[{defaultValue:null,optional:false,type:"String",description:"new label text",name:"labelText"}],description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.maxValueLabel')} property of the slider\n\n",flags:"",name:"setMaxValueLabel"},"attr:LoadProjectSettings.currentScreenName":{seeAlso:[],ref:"attr:LoadProjectSettings.currentScreenName",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:LoadProjectSettings",valueType:"String",description:"The name of the screen within the project to return first when loading.  \n A null value means to use the currentScreenName as specified in the project file.\n <p>\n This setting only affects the first project specified in the <code>projectNames</code>\n argument to ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadProject')}.",flags:"IRW",name:"currentScreenName"},"attr:Calendar.indicatorCanvas":{seeAlso:[],ref:"attr:Calendar.indicatorCanvas",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"MultiAutoChild IndicatorCanvas",description:"AutoChild component created for each ${isc.DocUtils.linkForRef('attr:Calendar.indicators','indicator')} entry.",flags:"A",name:"indicatorCanvas"},"attr:TextItem.escapeHTML":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:TextItem",groups:["appearance"],deprecated:null,ref:"attr:TextItem.escapeHTML",valueType:"Boolean",description:"By default HTML characters will be escaped when ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit')} is false and \n ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','readOnlyDisplay')} is \"static\", so that the raw value of the field (for\n example <code>\"&lt;b&gt;AAA&lt;/b&gt;\"</code>) is displayed to the user rather than\n the interpreted HTML (for example <code>\"<b>AAA</b>\"</code>).  Setting\n <code>escapeHTML</code> false will instead force HTML values in a textItem to be\n interpreted by the browser in that situation.",flags:"IRW",name:"escapeHTML"},"attr:TextItem.maskOverwriteMode":{seeAlso:[],ref:"attr:TextItem.maskOverwriteMode",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TextItem",valueType:"boolean",description:"During entry into a ${isc.DocUtils.linkForRef('attr:TextItem.mask','masked field')}, should keystrokes overwrite current position value?\n By default new keystrokes are inserted into the field.",flags:"IRWA",name:"maskOverwriteMode"},"attr:RichTextEditor.backgroundColorPrompt":{seeAlso:[],defaultValue:'"Set selection background color"',type:"attr",definingClass:"class:RichTextEditor",groups:["i18nMessages"],deprecated:null,ref:"attr:RichTextEditor.backgroundColorPrompt",valueType:"String",description:"The prompt for the built-in ${isc.DocUtils.linkForRef('type:ControlName','backgroundColor')} control.",flags:"IRW",name:"backgroundColorPrompt"},"classAttr:StatefulCanvas.SELECTED":{seeAlso:[],defaultValue:'"Selected"',type:"classAttr",definingClass:"class:StatefulCanvas",deprecated:null,ref:"classAttr:StatefulCanvas.SELECTED",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:Selected','Selected')}.",flags:"R",name:"SELECTED",constant:true},"classAttr:DateItem.MONTH_YEAR":{seeAlso:[],defaultValue:'"MY"',type:"classAttr",definingClass:"class:DateItem",deprecated:null,ref:"classAttr:DateItem.MONTH_YEAR",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:DateItemSelectorFormat','DateItemSelectorFormat')}.",flags:"R",name:"MONTH_YEAR",constant:true},"method:ListGrid.getDataSource":{seeAlso:[],ref:"method:ListGrid.getDataSource",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" The DataSource that this component should bind to for default fields and \n for performing ${isc.DocUtils.linkForRef('object:DSRequest','DataSource requests')}.\n\n",flags:"",returns:{type:"DataSource",description:"Datasource object for this ListGrid instance."},name:"getDataSource"},"attr:SavedSearchForm.markAsDefaultHoverText":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:SavedSearchForm",groups:["i18nMessages"],deprecated:null,ref:"attr:SavedSearchForm.markAsDefaultHoverText",valueType:"String",description:"If set this property will override ${isc.DocUtils.linkForRef('attr:SavedSearchItem.markAsDefaultHoverText')} on the \n automatically generated ${isc.DocUtils.linkForRef('class:SavedSearchItem')}.",flags:"IR",name:"markAsDefaultHoverText"},"attr:SectionStack.closeSectionIconSize":{seeAlso:[],ref:"attr:SectionStack.closeSectionIconSize",defaultValue:"16",deprecated:null,type:"attr",definingClass:"class:SectionStack",valueType:"Number",description:"Pixel width/height for the ${isc.DocUtils.linkForRef('attr:SectionStack.closeSectionIcon')}.",flags:"IR",name:"closeSectionIconSize"},"classMethod:EventHandler.rightButtonDown":{seeAlso:[{ref:"classMethod:EventHandler.leftButtonDown",description:null},{ref:"classMethod:EventHandler.middleButtonDown",description:null}],type:"classMethod",definingClass:"class:EventHandler",platformNotes:"Mac:\t\tMacintosh platform generally has only one mouse button, and the\n\t\tcontrol key being held down serves the same purpose of the \n\t\tright mouse button on Windows.  This is taken into account automatically.<br>\n      Opera: \n      The Opera browser does not pass right mouse button events to JavaScript code by default\n      (the user must explicitly enable this behavior via a menu item). Therefore we \n      treat <b>Shift+Ctrl+Click</b> as a context click in Opera.",returns:{type:"Boolean",description:"true == right button is down, false == up"},groups:["mouseEvents"],deprecated:null,ref:"classMethod:EventHandler.rightButtonDown",description:"\t\t\tReturns true if the right mouse button is being pressed.\n\n",flags:"",name:"rightButtonDown"},"attr:ImgProperties.imgDir":{seeAlso:[],ref:"attr:ImgProperties.imgDir",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:ImgProperties",valueType:"URL",description:"Specifies the image-specific image directory to override the default.",flags:"IRW",name:"imgDir"},"attr:MultiFileItem.pickerAddAnotherFileButtonTitle":{seeAlso:[],defaultValue:'"&lt;u&gt;Add&amp;nbsp;another&lt;/u&gt;"',type:"attr",definingClass:"class:MultiFileItem",groups:["i18nMessages"],deprecated:null,ref:"attr:MultiFileItem.pickerAddAnotherFileButtonTitle",valueType:"HTMLString",description:"The contents of the \"Add another\" file button in the picker launched by the\n ${isc.DocUtils.linkForRef('attr:MultiFileItem.editButton','edit button')}.",flags:"IR",name:"pickerAddAnotherFileButtonTitle"},"method:GridRenderer.getCellElementId":{seeAlso:[],ref:"method:GridRenderer.getCellElementId",deprecated:null,type:"method",definingClass:"class:GridRenderer",params:[{defaultValue:null,optional:false,type:"number",description:"<b>virtual</b> row number",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"<b>physical</b> row number",name:"physicalRowNum"},{defaultValue:null,optional:false,type:"number",description:"<b>virtual</b> col number",name:"colNum"},{defaultValue:null,optional:false,type:"number",description:"<b>physical</b> col number",name:"physicalColNum"}],description:" Get the DOM ID that should be used for a cell element if \n ${isc.DocUtils.linkForRef('staticMethod:isc.setScreenReaderMode','screen reader mode')} is enabled \n or ${isc.DocUtils.linkForRef('attr:GridRenderer.writeOutRowElementId')} is true.\n <P>\n Note that for integration with automated testing tools, we recommend using \n ${isc.DocUtils.linkForRef('classMethod:AutoTest.getLocator')} and ${isc.DocUtils.linkForRef('classMethod:AutoTest.getElement')} to identify \n specific elements within the DOM wherever possible. These are more robust than simple\n cell locators as they can identify the DOM element representing a specific data elements\n using primary key and other approaches rather than relying on the generated DOM structure.\n <P>\n When using incremental rendering, the <code>rowNum</code> and <code>colNum</code> params\n represents virtual coordinates, and the <code>physicalRowNum</code> param represents the\n index that the row/cell will ultimately have in table.rows or row.cells.\n\n",flags:"A",returns:{type:"String",description:"ID for the cell element. This should be unique within the DOM."},name:"getCellElementId"},"attr:DataSourceField.relatedTableAlias":{seeAlso:[{ref:"attr:DataSource.relatedTableAlias",description:null},{ref:"attr:DataSourceField.includeVia",description:null}],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["dataSourceRelations"],ref:"attr:DataSourceField.relatedTableAlias",deprecated:null,valueType:"String",description:"For a ${isc.DocUtils.linkForRef('group:sqlDataSource','SQL DataSource')} field that specifies a\n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')}, this property defines the table alias name to\n use in generated SQL.\n <p>\n Aliasing is necessary when the same table appears more than once in a query.  This can \n happen when using ${isc.DocUtils.linkForRef('attr:DataSourceField.includeVia','Multiple <code>includeFrom</code> \\n fields referring to the same related DataSource')}.  It can also happen when a\n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} definition references the same dataSource\n that the field is defined in; this happens with hierarchical structures, for example where\n every Employee reports to another Employee, a so-called \"self join\", and it\n <em>always</em> requires <code>relatedTableAlias</code> to be specified; failure to do so\n will result in invalid SQL.\n <p>\n In case of indirect relationship, when more than single join is needed to join the target table, and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.includeVia','includeVia')} is missing, generated alias is a concatenation of\n <code>relatedTableAlias</code> and FK field names starting with the first <code>relatedTableAlias</code> \n met in chain of relations leading to the target table.\n <p>\n See the \"Automatically generated table aliases\" section of the ${isc.DocUtils.linkForRef('group:customQuerying','SQL Templating')}\n for more details.",flags:"IR",serverDS:"only",examples:["${isc.DocUtils.linkForExampleId('sqlIncludeVia')}"],name:"relatedTableAlias"},"attr:TreeNode.iconPadding":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:TreeNode",groups:["treeIcons"],deprecated:null,ref:"attr:TreeNode.iconPadding",valueType:"Integer",description:"Developers may customize the padding between the folder or leaf node icon and the\n text content of the tree cell for individual nodes.\n <P>\n You can change the name of this property by setting ${isc.DocUtils.linkForRef('attr:TreeGrid.iconPaddingProperty')}",flags:"IRA",name:"iconPadding"},"method:Slider.getValue":{seeAlso:[],ref:"method:Slider.getValue",deprecated:null,type:"method",definingClass:"class:Slider",description:" Returns the current slider value.\n\n",flags:"",returns:{type:"float",description:"current slider value "},name:"getValue"},"attr:RadioGroupItem.editProxyConstructor":{seeAlso:[],ref:"attr:RadioGroupItem.editProxyConstructor",defaultValue:'"RadioGroupItemEditProxy"',deprecated:null,type:"attr",definingClass:"class:RadioGroupItem",valueType:"SCClassName",description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",flags:"IR",name:"editProxyConstructor"},"method:SearchForm.criteriaChanged":{seeAlso:[],ref:"method:SearchForm.criteriaChanged",deprecated:null,type:"method",definingClass:"class:SearchForm",params:[{defaultValue:null,optional:false,type:"Criteria",description:"Current criteria of the form       (matches ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')})",name:"criteria"},{defaultValue:null,optional:false,type:"SearchForm",description:"the SearchForm being edited",name:"form"}],description:" Notification method fired when the criteria are modified in this SearchForm.\n As the user edits values, this method will be fired after a\n ${isc.DocUtils.linkForRef('attr:SearchForm.criteriaChangedDelay','configurable delay')}. \n\n",flags:"",name:"criteriaChanged"},"attr:RPCRequest.downloadResult":{seeAlso:[],ref:"attr:RPCRequest.downloadResult",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:RPCRequest",valueType:"Boolean",description:"If enabled, causes the RPCRequest to download the requested resource as a file, either \n showing the browser's Save dialog or displaying the file-content in \n ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadToNewWindow','a new browser window')}.\n <P>\n Download requests will use ${isc.DocUtils.linkForRef('attr:RPCRequest.transport','transport')}: \"hiddenFrame\" by default.\n <P>\n In this mode, the download will be performed by a standard HTTP request issued by the browser.\n If ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadToNewWindow','DSRequest.downloadToNewWindow')} is true, the request will be targeted against a new\n browser window, and if the resulting file can be displayed inline by the browser it will be.\n If ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadToNewWindow','DSRequest.downloadToNewWindow')} is not true, or the browser cannot display the\n returned file inline, the browser will download the file and store it to the user's file\n system.\n <P>\n Download requests with ${isc.DocUtils.linkForRef('attr:RPCRequest.transport','transport')}: \"hiddenFrame\" do not fire\n any callbacks.\n <P>\n If a developer explicitly sets <code>request.transport</code> to \"xmlHttpRequest\", the\n browser will instead use an XMLHttpRequest to download the data from the server. This \n mode differs from hiddenFrame downloads in various ways:\n <ul><li>Explicit ${isc.DocUtils.linkForRef('attr:RPCRequest.httpHeaders')} may be sent to the server in this mode</li>\n     <li>Instead of automatically downloading the response to the user's filesystem, \n         the server response will be available as a \n         <a href='https://developer.mozilla.org/en-US/docs/Web/API/Blob' target='_blank'>Blob</a>, and the\n         ${isc.DocUtils.linkForRef('method:RPCRequest.downloadCallback')} will be invoked, if specified.<br>\n         Returning <code>false</code> from the downloadCallback will suppress the default behavior\n         of saving the file to the user's filesystem, giving developers an opportunity\n         to take other actions, such as generating a data URL from the Blob.</li>\n     <li>xmlHttpRequest download does not have a built-in progress bar to indicate download progress.\n         Developers may make use of the ${isc.DocUtils.linkForRef('method:RPCRequest.xhr_onProgress')} event to indicate\n         download progress if required.</li>\n </ul>",flags:"IRWA",name:"downloadResult"},"attr:TreeGrid.customIconOpenProperty":{seeAlso:[{ref:"attr:TreeGrid.customIconProperty",description:null},{ref:"attr:TreeGrid.showCustomIconOpen",description:null}],defaultValue:'"showOpenIcon"',type:"attr",definingClass:"class:TreeGrid",groups:["treeIcons"],deprecated:null,ref:"attr:TreeGrid.customIconOpenProperty",valueType:"String",description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.showOpenIcon','default node.showOpenIcon')} property.",flags:"IRWA",name:"customIconOpenProperty"},"attr:DetailViewer.loadingMessage":{seeAlso:[],defaultValue:'"&amp;nbsp;${loadingImage}"',type:"attr",definingClass:"class:DetailViewer",groups:["emptyMessage"],deprecated:null,ref:"attr:DetailViewer.loadingMessage",valueType:"HTMLString",description:"The string to display in the body of a detailViewer which is loading records.\n Use <code>\"&#36;{loadingImage}\"</code> to include ${isc.DocUtils.linkForRef('classAttr:Canvas.loadingImageSrc','a loading image')}.",flags:"IRW",name:"loadingMessage"},"object:DataQuestionSettings":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:DataQuestionSettings.referenceTime","attr:DataQuestionSettings.dataSourceNames","attr:DataQuestionSettings.applicationPurpose","attr:DataQuestionSettings.maxFixAttempts"],groups:["answerEngine"],ref:"object:DataQuestionSettings",deprecated:null,treeLocation:["Client Reference/Tools/Answer Engine"],description:"Settings for a data question.",methods:[],name:"DataQuestionSettings"},"attr:FormItem.deferActionConversion":{seeAlso:[],ref:"attr:FormItem.deferActionConversion",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:FormItem",valueType:"Boolean",description:"Controls whether action objects and Process definitions in event handler slots (like\n ${isc.DocUtils.linkForRef('method:FormItem.change')}) are converted to executable functions immediately during\n component creation, or deferred until the event is first invoked.\n <P>\n When <code>true</code> (the default), a lightweight stub function is installed that\n converts the action to a real function only when the event fires. This optimizes\n creation time for forms with many event handlers that may never be invoked.\n <P>\n When <code>false</code>, action objects are converted to functions immediately during\n component creation, which was the original behavior prior to SmartClient 14.2.\n <P>\n This setting can be changed system-wide via\n <code>isc.FormItem.addProperties({deferActionConversion: false})</code>, on any\n subclass, or on individual form item configurations.",flags:"IRA",name:"deferActionConversion"},"classAttr:Browser.isTablet":{seeAlso:[],defaultValue:"auto-detected based on device",type:"classAttr",definingClass:"class:Browser",deprecated:null,ref:"classAttr:Browser.isTablet",setter:["setIsTablet"],valueType:"boolean",description:"Is the application running on a tablet device (e.g. iPad, Nexus 7)?\n <p>\n SmartClient can correctly determine whether the device is a tablet in most cases. On any\n uncommon device for which this variable is incorrect, you can define the <code>isc_isTablet</code>\n global with the correct value, and SmartClient will use <code>isc_isTablet</code> for\n <code>Browser.isTablet</code> instead of its own detection logic. Alternatively, you can use\n ${isc.DocUtils.linkForRef('classMethod:Browser.setIsTablet')} to change this global variable before any components are\n created.\n <p>\n The value of this variable is only meaningful on touch devices.",flags:"RW",name:"isTablet"},"method:TabSet.setPaneContainerOverflow":{seeAlso:[],ref:"method:TabSet.setPaneContainerOverflow",deprecated:null,type:"method",definingClass:"class:TabSet",params:[{defaultValue:null,optional:false,type:"Overflow",description:"new overflow setting",name:"newOverflow"}],description:" Update ${isc.DocUtils.linkForRef('attr:TabSet.paneContainerOverflow')} after creation.\n\n",flags:"",name:"setPaneContainerOverflow"},"attr:FacetChart.tickMarkToValueAxisMargin":{seeAlso:[],defaultValue:"7",type:"attr",definingClass:"class:FacetChart",groups:["ticks"],deprecated:null,ref:"attr:FacetChart.tickMarkToValueAxisMargin",valueType:"Number",description:"Margin between the tick marks and the labels of the\n ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','extra value axes')}.",flags:"IR",name:"tickMarkToValueAxisMargin"},"attr:MinimalScrollbar.setInteractiveOnMouseOver":{seeAlso:[],ref:"attr:MinimalScrollbar.setInteractiveOnMouseOver",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:MinimalScrollbar",valueType:"boolean",description:"Always set to ${isc.DocUtils.linkForRef('attr:MinimalScrollbar.interactive')} mode on roll over.",flags:"IRW",name:"setInteractiveOnMouseOver"},"attr:DataBoundAIRequest.maxRetries":{seeAlso:[],ref:"attr:DataBoundAIRequest.maxRetries",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DataBoundAIRequest",valueType:"Integer",description:"The maximum number of retries for any one particular request to AI.\n <p>\n Note that multiple AI requests may be involved in processing the data-bound AI request. This\n limit is the maximum number of retries of any one request. For example, if there are 2\n requests made to AI, then each one would be submitted at most <code>1 + maxRetries</code>\n number of times for up to <code>2 * (1 + maxRetries)</code> total requests.\n <p>\n If unset, then ${isc.DocUtils.linkForRef('classAttr:AI.defaultMaxRetries')} will be used.",flags:"IR",name:"maxRetries"},"attr:DetailViewer.emptyMessageStyle":{seeAlso:[],defaultValue:'"normal"',type:"attr",definingClass:"class:DetailViewer",groups:["emptyMessage"],deprecated:null,ref:"attr:DetailViewer.emptyMessageStyle",valueType:"CSSStyleName",description:"CSS style to display this message in",flags:"IRWA",name:"emptyMessageStyle"},"classMethod:TabIndexManager.removeTarget":{seeAlso:[],ref:"classMethod:TabIndexManager.removeTarget",deprecated:null,type:"classMethod",definingClass:"class:TabIndexManager",params:[{defaultValue:null,optional:false,type:"String",description:"target to remove",name:"ID"}],description:" Removes a target from this TabIndexManager.\n Any children of this target will also be removed - developers wishing to preserve\n children should first call ${isc.DocUtils.linkForRef('classMethod:TabIndexManager.moveTarget')} to move the children out of this parent\n",flags:"",name:"removeTarget"},"attr:FacetChartEditProxy.dataSeparatorChar":{seeAlso:[],ref:"attr:FacetChartEditProxy.dataSeparatorChar",defaultValue:'","',deprecated:null,type:"attr",definingClass:"class:FacetChartEditProxy",valueType:"String",description:"If ${isc.DocUtils.linkForRef('type:InlineEditEvent','inline editing')} for this chart edits the\n ${isc.DocUtils.linkForRef('attr:FacetChart.data')}, character that should be used as a separator between\n values, or between pairs of label vs values.\n <p>\n The ${isc.DocUtils.linkForRef('attr:FacetChartEditProxy.dataEscapeChar','dataEscapeChar')} can be used to enter the separator\n char as part of a field name or value.",flags:"IR",name:"dataSeparatorChar"},"attr:TreeGrid.selectedIconSuffix":{seeAlso:[],defaultValue:'"selected"',type:"attr",definingClass:"class:TreeGrid",groups:["treeIcons"],deprecated:null,ref:"attr:TreeGrid.selectedIconSuffix",valueType:"String",description:"If ${isc.DocUtils.linkForRef('attr:TreeGrid.showSelectedIcons')} is true, this suffix will be appended to the\n ${isc.DocUtils.linkForRef('attr:TreeGrid.folderIcon')} for selected nodes in this grid.",flags:"IR",name:"selectedIconSuffix"},"attr:DataSource.autoCacheAllData":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:DataSource",groups:["clientData"],deprecated:null,ref:"attr:DataSource.autoCacheAllData",valueType:"Boolean",description:"When a DataSource is not ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')}:true and a fetch results in the\n entire dataset being retrieved, this attribute being set to true causes the DataSource\n to automatically switch to <code>cacheAllData:true</code> and prevent further server-trips for fetch \n requests.\n <p>\n ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData','cacheAllData')} is automatically enabled in either of these conditions:\n <ul>\n   <li>\n     The request has no criteria and no startRow/endRow request properties. The latter can\n     be accomplished by disabling paging with a ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dataFetchMode','dataFetchMode')}\n     setting of \"basic\" or \"local\" or by an explicit fetchData request with those request properties\n     excluded.\n  </li>\n  <li>\n     The request has no criteria but has startRow/endRow specified and the response received has\n     all data available (<code>startRow:0</code> and <code>endRow:totalRows</code>).\n  </li>\n </ul>",flags:"IR",name:"autoCacheAllData"},"attr:ListGrid.aiSortFieldMaxRecordsMessage":{seeAlso:[],defaultValue:'"There were too many records to sort using AI; the number of records exceeded the limit of ${aiSortFieldMaxRecords} records."',type:"attr",definingClass:"class:ListGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:ListGrid.aiSortFieldMaxRecordsMessage",valueType:"HTMLString",description:"The message to show when a user asks the AI to sort more than the\n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.aiSortFieldMaxRecords','maximum allowed records')}.",flags:"IRW",name:"aiSortFieldMaxRecordsMessage"},"classAttr:Operators.iNotEqualFieldTitle":{seeAlso:[],defaultValue:'"differs from field"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.iNotEqualFieldTitle",valueType:"String",description:'Title for the "iNotEqualField" operator',flags:"IR",name:"iNotEqualFieldTitle"},"attr:ListGrid.groupSummaryRecordProperty":{seeAlso:[],ref:"attr:ListGrid.groupSummaryRecordProperty",defaultValue:'"isGroupSummary"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"String",description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} is true, this attribute will be set to true on each\n record object representing a group-level summary row.",flags:"IRW",name:"groupSummaryRecordProperty"},"attr:Canvas.isGroup":{seeAlso:[{ref:"attr:Canvas.groupBorderCSS",description:null},{ref:"attr:Canvas.groupLabelStyleName",description:null},{ref:"attr:Canvas.groupLabelBackgroundColor",description:null}],defaultValue:"true",type:"attr",definingClass:"class:Canvas",groups:["appearance"],deprecated:null,ref:"attr:Canvas.isGroup",valueType:"boolean",description:"Should a grouping frame be shown around this canvas if a non-empty string has been specified\n for ${isc.DocUtils.linkForRef('attr:Canvas.groupTitle')}.",flags:"IR",name:"isGroup"},"attr:DateItem.dateFormatter":{seeAlso:[],ref:"attr:DateItem.dateFormatter",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DateItem",valueType:"DateDisplayFormat",description:"If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is <code>true</code> this property can be used to \n customize the format in which dates are displayed for this item.<br>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateDisplayFormat')}.\n <P>\n As with any formItem rendering out a date value, if no explicit dateFormatter is\n supplied, dateFormatter will be derived from ${isc.DocUtils.linkForRef('attr:DynamicForm.dateFormatter')} or\n ${isc.DocUtils.linkForRef('attr:DynamicForm.datetimeFormatter')},  depending on the specified ${isc.DocUtils.linkForRef('attr:FormItem.type')} for\n this field, if set, otherwise from the standard default \n ${isc.DocUtils.linkForRef('classMethod:DateUtil.setShortDisplayFormat')} or ${isc.DocUtils.linkForRef('classMethod:DateUtil.setShortDatetimeDisplayFormat')}.\n <P>\n NOTE: For entirely custom formats, developers may apply a custom\n \n ${isc.DocUtils.linkForRef('method:DateItem.formatEditorValue')} method. To ensure the\n DateItem is able to parse user-entered date strings back into Dates, for most cases\n developers can specify an explicit ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat')}, or if necessary a\n custom ${isc.DocUtils.linkForRef('method:DateItem.parseEditorValue')}.\n \n \n <p>\n This attribute does not have an effect if a native HTML5 date or datetime input is being used.\n See ${isc.DocUtils.linkForRef('attr:DateItem.browserInputType')}.",flags:"IRW",name:"dateFormatter"},"method:Canvas.linkHTML":{seeAlso:[],ref:"method:Canvas.linkHTML",deprecated:null,type:"method",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"String",description:"URL for the link to point to",name:"href"},{defaultValue:null,optional:true,type:"HTMLString",description:"HTML to display in the link element (defaults to the href)",name:"text"},{defaultValue:null,optional:true,type:"String",description:"Target window for the link (defaults to opening in a new, unnamed window)",name:"target"},{defaultValue:null,optional:true,type:"String",description:"optional ID for the link element to be written out",name:"ID"},{defaultValue:null,optional:true,type:"Integer",description:"optional tabIndex for the link",name:"tabIndex"},{defaultValue:null,optional:true,type:"String",description:"optional accessKey for the link",name:"accessKey"}],description:" Generates the HTML for a standard link (anchor) element.\n\n",flags:"A",returns:{type:"HTMLString",description:"HTML for the link"},name:"linkHTML"},"attr:ListGrid.editSelectionType":{seeAlso:[],ref:"attr:ListGrid.editSelectionType",defaultValue:'"single"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"SelectionStyle",description:'If ${isc.DocUtils.linkForRef(\'attr:ListGrid.selectOnEdit\')} is true, what should be the edit-selection behavior\n be?\n <P>\n Default setting of <code>"single"</code> will cause the edit row to be automatically\n selected and any other selection in the grid to be dropped.<br>\n If set to <code>"multiple"</code>, selection will be additive (as a record goes \n into edit mode, it is selected in addition to any pre-existant selection).\n <P>\n If set to <code>null</code> behavior is as follows:<ul>\n <li>For grids with ${isc.DocUtils.linkForRef(\'attr:ListGrid.selectionType\')} set to\n <code>"simple"</code> edit rows will be selected additively - this is the same\n behavior as if the <code>editSelectionType</code> was <code>"multiple"</code></li>\n <li>Otherwise edit rows will be selected singly - this is the same behavior as\n if the <code>editSelectionType</code> was <code>"single"</code></li>\n </ul>',flags:"IRW",name:"editSelectionType"},"attr:Facet.collapsed":{seeAlso:[],ref:"attr:Facet.collapsed",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:Facet",valueType:"Boolean",description:"For tree facets, default collapse state for parent nodes.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.",flags:"IR",name:"collapsed"},"classMethod:AutoTest.variableIsDefined":{seeAlso:[],ref:"classMethod:AutoTest.variableIsDefined",deprecated:null,type:"classMethod",definingClass:"class:AutoTest",params:[{defaultValue:null,optional:false,type:"String",description:"variable to retrieve",name:"name"}],description:" Determine whether a variable has been explicitly set via ${isc.DocUtils.linkForRef('classMethod:AutoTest.setVariable')}\n or ${isc.DocUtils.linkForRef('classMethod:AutoTest.storeLocatorResult')}.\n <P>\n This method will return true if the variable has been set to any\n value, including <code>null</code>, or false if the variable has never been\n set or has been ${isc.DocUtils.linkForRef('classMethod:AutoTest.clearVariable','cleared')}.\n \n",flags:"",returns:{type:"Boolean",description:"true"},name:"variableIsDefined"},"method:ResultSet.rangeIsLoaded":{seeAlso:[],ref:"method:ResultSet.rangeIsLoaded",deprecated:null,type:"method",definingClass:"class:ResultSet",params:[{defaultValue:null,optional:false,type:"number",description:"start position, inclusive",name:"startRow"},{defaultValue:null,optional:false,type:"number",description:"end position, exclusive",name:"endRow"}],description:" Whether the given range of rows has been loaded.\n\n Unlike getRange(), will not trigger a server fetch.  \n\n",flags:"A",returns:{type:"boolean",description:"true if all rows in the given range have been loaded, false if any rows in                   the range have not been loaded or are still in the process of being loaded"},name:"rangeIsLoaded"},"attr:DynamicForm.showInlineErrors":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:DynamicForm",groups:["validation"],deprecated:null,ref:"attr:DynamicForm.showInlineErrors",valueType:"Boolean",description:"If true, field errors are written into the form next to the item(s) where the errors\n occurred.  Errors may appear as text or just an icon (via ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}:false).\n <P>\n If false, errors are written at the top of the form.\n <P>\n To do some other kind of error display, override ${isc.DocUtils.linkForRef('method:DynamicForm.showErrors')}.",flags:"IRW",name:"showInlineErrors"},"method:ResultTree.willFetchData":{seeAlso:[],ref:"method:ResultTree.willFetchData",deprecated:null,type:"method",definingClass:"class:ResultTree",params:[{defaultValue:null,optional:false,type:"Criteria",description:"new criteria to test.",name:"newCriteria"}],description:" Will changing the criteria for this resultTree require fetching new data from the server\n or can the new criteria be satisfied from data already cached on the client?\n <p>\n This method can be used to determine whether ${isc.DocUtils.linkForRef('method:TreeGrid.fetchData')} or \n ${isc.DocUtils.linkForRef('method:TreeGrid.filterData')} will cause a server side fetch when passed a certain set of \n criteria.\n\n",flags:"",returns:{type:"Boolean",description:"true if server fetch would be required to satisfy new criteria."},name:"willFetchData"},"group:clientServerIntegration":{refs:[],seeAlso:[],ref:"group:clientServerIntegration",treeLocation:["Concepts"],deprecated:null,type:"group",title:"Client-Server Integration",description:"Like client-server desktop applications, SmartClient browser-based applications interact\n with remote data and services via background communication channels. Background requests\n retrieve chunks of data rather than new HTML pages, and update your visual components in\n place rather than rebuilding the entire user interface.\n <P>\n <b>DataSources</b>\n <p>\n First you must create ${isc.DocUtils.linkForRef('class:DataSource','DataSources')} that describe the objects from\n your object model that will be loaded or manipulated within your application.  All of \n SmartClient's most powerful functionality builds on the concept of a DataSource, and because \n of SmartClient's databinding framework (see ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}), it's as easy to \n create a DataSource that can configure an unlimited number of components as it is to \n configure a single component.\n <P>\n For background information on how to create DataSources, ${isc.DocUtils.linkForRef('interface:DataBoundComponent','bind')}\n components to DataSources and initiate ${isc.DocUtils.linkForRef('object:DSRequest')}s, please see the <em>Data \n Binding</em> chapter of the <em>SmartClient Quickstart Guide</em>.\n <P>\n <b>Data Integration</b>\n <P>\n DataSources provide a data-provider agnostic API to SmartClient Visual Components that \n allow them to perform the 4 CRUD operations (<b>C</b>reate, <b>R</b>etrieve, \n <b>U</b>pdate, <b>D</b>elete).  By \"agnostic\" we mean that the implementation details - \n the nuts and bolts of how a given DataSource actually retrieves or updates data - are \n unknown to bound SmartClient components.  One effect of this is that DataSources are \n \"pluggable\": they can be replaced without affecting the User Interface.\n <p>\n When a visual component, or your own custom code, performs a CRUD operation on a DataSource,\n the DataSource creates a ${isc.DocUtils.linkForRef('object:DSRequest')} (DataSource Request) representing the operation.\n \"Data Integration\" is the process of fulfilling that DSRequest by creating a corresponding\n ${isc.DocUtils.linkForRef('class:DSResponse')} (DataSource Response), by using a variety of possible approaches to \n connect to the ultimate data provider.  \n <p>\n There are two main approaches to integrating DataSources with your server technology: \n <ul>\n <li>${isc.DocUtils.linkForRef('group:serverDataIntegration','Server-side integration')}: DataSource requests from the browser arrive as Java \n Objects on the server. You deliver responses to the browser by returning Java Objects. The\n various server-side integration possibilities are discussed later in this article.</li>\n <li>${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side integration')}: DataSource requests arrive as \n simple HTTP requests which your server code receives directly (in Java, you use the \n Servlet API or .jsps to handle the requests). Responses are sent as XML or JSON which you \n directly generate.</li>\n </ul>\n The possible approaches are summarized in the diagram below. Paths 2, 3 and 4 are \n client-side integration approaches, and path 1 includes all server-side integration \n approaches. \n <p>\n <img src=\"skin/ClientServerIntegration.png\" width=\"866px\" height=\"495px\">\n <p>\n SmartClient supports, out of the box, codeless connectivity to various kinds of common data\n providers, including SQL and Hibernate.  SmartClient also provides functionality and tools\n for accelerated integration with broad categories of data providers, such as Java\n Object-based persistence mechanisms (JPA, EJB, MyBatis, in-house written systems), and REST\n and WSDL web services in XML or JSON formats.  Ultimately, a DataSource can be connected to \n anything that is accessible via HTTP or HTTPS, and also to in-browser persistence engines \n such as <a href='http://gears.google.com' target='_blank'>Google Gears</a>.\n <p>\n <b>Choosing a Data Integration Approach</b><p>\n This section aims to help you decide which of the many possible data integration approaches\n is best for your particular circumstances.  The recommendations given here will guide you\n to the approach that involves the least effort.<p>\n <img src=\"skin/dataIntegrationFlowchart.png\" width=\"640px\" height=\"300px\">\n <p>\n <ul>\n <li>If you have a Java server:</li>\n <ul>\n   <li>If your ultimate storage is a SQL database:</li>\n     <ul>\n       <li>Use the SQLDataSource unless you have a very large amount of pre-existing\n           JPA or Hibernate code - small amounts of business logic can be easily migrated.\n           Be sure to read the overview of ${isc.DocUtils.linkForRef('group:sqlVsJPA','SQLDataSource vs JPA/Hibernate')} \n           in order to understand the large benefits the SQLDataSource provides</li>\n       <li>Derive DataSource definitions from existing tables or Hibernate mappings using the\n           ${isc.DocUtils.linkForRef('attr:DataSource.autoDeriveSchema','autoDeriveSchema')} feature, or from Java Beans\n           via the ${isc.DocUtils.linkForRef('attr:DataSource.schemaBean','schemaBean')} feature.\n           Or, use the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} to generate tables from DataSource\n           definitions you create by hand</li>\n     </ul>\n   <li>If your ultimate storage is not a SQL database:</li>\n     <ul>\n       <li>If your persistence is based on Java Beans, use the\n           ${isc.DocUtils.linkForRef('attr:DataSource.schemaBean','schemaBean')} feature to derive DataSource definitions from\n            any Java bean</li>\n       <li>write a ${isc.DocUtils.linkForRef('group:writeCustomDataSource','custom DataSource')} that provides the\n           CRUD operations you want to support.</li>\n     </ul>\n   <li>Whether or not your storage is SQL, add business logic either declaratively in the \n       DataSource definition, via ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')}, or any combination of the two:\n     <ul>\n       <li>The &lt;criteria&gt; and &lt;values&gt; properties of an ${isc.DocUtils.linkForRef('class:OperationBinding')}\n           allow you to dynamically set data values at transaction-processing time, using \n           built-in ${isc.DocUtils.linkForRef('group:velocitySupport','Velocity support')}</li>\n       <li>Override the <code>validate()</code> method of the DataSource to provide extra\n           custom validations - just call <code>super</code> to obtain the list of errors \n           derived from SmartClient validations, then add to that list as required with your\n           own custom code</li>\n       <li>Override the <code>execute()</code> method of the DataSource to add extra processing\n           either before or after the SmartClient processing</li>\n       <li>Use ${isc.DocUtils.linkForRef('group:transactionChaining','Transaction Chaining')} to dynamically set\n           data values according to the results of earlier transactions</li>\n       <li>For SQL DataSources, use ${isc.DocUtils.linkForRef('group:customQuerying','SQL Templating')} to change, \n           add to or even completely replace the SQL sent to the database, and to implement\n           special query requirements</li>\n       <li>For JPA DataSources, use ${isc.DocUtils.linkForRef('attr:OperationBinding.customJQL','custom JQL queries')}\n           to implement special query requirements</li>\n       <li>For Hibernate DataSources, use ${isc.DocUtils.linkForRef('attr:OperationBinding.customHQL','custom HQL queries')}\n           to implement special query requirements</li>\n      </ul>\n      Read more about the server-side request processing flow and how to customize it in\n      ${isc.DocUtils.linkForRef('group:serverDataIntegration','the server integration overview')}.\n </ul>\n </ul>\n <ul>\n <li>If you do not have a Java server:</li>\n   <ul><li>If you are not obliged to use a pre-existing network protocol, use the \n           ${isc.DocUtils.linkForRef('class:RestDataSource')}</li>\n       <li>Otherwise, use ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side data integration')} features\n           to create a custom client-side DataSource that adapts the DataSource protocol to \n           your existing services</li>\n   </ul>\n </ul>\n <p><br>\n <b>RPCs: Unstructured Server Communication</b>\n <P>\n SmartClient also supports \"unstructured\" client-server operations.  These \n ${isc.DocUtils.linkForRef('object:RPCRequest')}s (Remote Procedure Call Requests) are a low-level, very flexible \n mechanism for custom client-server communications.  In an nutshell, RPCRequests:\n <ul>\n <li> may contain arbitrary data\n <li> are always initiated by custom code (a call to ${isc.DocUtils.linkForRef('classMethod:RPCManager.send')}), and have\n their responses handled by custom code (the callback passed to <code>send()</code>)\n </ul>\n <P>\n RPCRequests are relatively rare.  Most client-server communications are better done in a \n structured fashion using a ${isc.DocUtils.linkForRef('object:DSRequest')} (DataSource Request).  Note that <em>any</em>\n RPCRequest can alternatively be framed as a ${isc.DocUtils.linkForRef('method:DataSource.fetchData','DataSource fetch')}; \n depending on the circumstances, this may be more convenient.\n <P>\n See the ${isc.DocUtils.linkForRef('class:RPCManager')} documentation for further information on RPCRequests.",name:"clientServerIntegration"},"attr:DatabaseBrowser.tableCriteria":{seeAlso:[],ref:"attr:DatabaseBrowser.tableCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DatabaseBrowser",valueType:"Criteria",description:"Optional criteria to pass to the ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.tableDataSource')} when retrieving the set of \n tables and views for a selected database.  Note, this criteria is in addition to the \n criteria implied by the current ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.dbName','dbName')} and \n ${isc.DocUtils.linkForRef('attr:DatabaseBrowser.schema','schema')} (if any), and any criteria the user has entered\n into the table list widget's filterEditor",flags:"IR",name:"tableCriteria"},"method:Flashlet.setSrc":{seeAlso:[],ref:"method:Flashlet.setSrc",deprecated:null,type:"method",definingClass:"class:Flashlet",description:" \n  Sets the source file for the flash component  \n\n",flags:"",name:"setSrc"},"attr:Menu.iconBodyStyleName":{seeAlso:[{ref:"attr:Menu.iconFillSpaceStyleName",description:null}],defaultValue:"null",type:"attr",definingClass:"class:Menu",groups:["appearance"],deprecated:null,ref:"attr:Menu.iconBodyStyleName",valueType:"CSSStyleName",description:'If set, the CSS style used for the body of this menu when there <em>is</em> an icon field.\n In RTL mode, the <code>iconBodyStyleName</code> is suffixed with "RTL", which allows skins\n to apply different styles in LTR and RTL modes.\n <p>\n Note: Any skin which uses <code>iconBodyStyleName</code> should add "RTL" styles as well,\n even if identical to LTR styles. Otherwise, menus may lose their styling in RTL mode.',flags:"IR",name:"iconBodyStyleName"},"method:CubeGrid.collapseField":{seeAlso:[],ref:"method:CubeGrid.collapseField",deprecated:null,type:"method",definingClass:"class:CubeGrid",params:[{defaultValue:null,optional:false,type:"FacetValueMap",description:"field specified as a facetValueMap",name:"facetValueMap"}],description:" Collapses the specified field.  No-ops if it's not showing, or it it's already collapsed.\n",flags:"",returns:{type:"Boolean",description:"whether specified field was actually collapsed"},name:"collapseField"},"attr:RichTextEditor.editAreaBackgroundColor":{seeAlso:[],ref:"attr:RichTextEditor.editAreaBackgroundColor",defaultValue:'"white"',deprecated:null,type:"attr",definingClass:"class:RichTextEditor",valueType:"String",description:"Background color for the ${isc.DocUtils.linkForRef('attr:RichTextEditor.editArea','edit canvas')}.",flags:"IR",name:"editAreaBackgroundColor"},"object:Shadow":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:Shadow.color","attr:Shadow.blur","attr:Shadow.offset"],ref:"object:Shadow",deprecated:null,treeLocation:["Client Reference/Drawing"],description:"A class used to define a shadow used in a Draw&lt;Shape&gt; Types.",methods:[],examples:["${isc.DocUtils.linkForExampleId('drawingShadows')}"],name:"Shadow"},"attr:AdaptiveMenu.menuButtonTitle":{seeAlso:[],ref:"attr:AdaptiveMenu.menuButtonTitle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:AdaptiveMenu",valueType:"HTMLString",description:"Title used for the ${isc.DocUtils.linkForRef('class:MenuButton')}.",flags:"IR",name:"menuButtonTitle"},"attr:DataBoundComponent.fieldEditorWindowTitle":{seeAlso:[],defaultValue:'"${builderType} Editor [${fieldTitle}]"',type:"attr",definingClass:"interface:DataBoundComponent",groups:["i18nMessages"],deprecated:null,ref:"attr:DataBoundComponent.fieldEditorWindowTitle",valueType:"HTMLString",description:"The title for the ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fieldEditorWindow','Window')} used to edit calculated\n fields.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will\n be evaluated as JS code whenever the message is displayed.\n <P>\n Two dynamic variables are available - \"builderType\", either Formula or Summary, and \n \"fieldTitle\", which is the title of the calculated field being edited.",flags:"IRWA",name:"fieldEditorWindowTitle"},"method:ProcessElement.updateGlobalIDInCriteria":{seeAlso:[],ref:"method:ProcessElement.updateGlobalIDInCriteria",deprecated:null,type:"method",definingClass:"class:ProcessElement",params:[{defaultValue:null,optional:false,type:"AdvancedCriteria",description:"the criteria to be updated in place",name:"criteria"},{defaultValue:null,optional:false,type:"Identifier",description:"the ID being renamed",name:"oldId"},{defaultValue:null,optional:false,type:"Identifier",description:"the new ID to be assigned",name:"newId"}],description:" Updates ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} ${isc.DocUtils.linkForRef('object:Criterion')} ${isc.DocUtils.linkForRef('type:TaskInputExpression')} values\n containing ruleScope references.\n <p>\n This method is a helper to implement task-specific ${isc.DocUtils.linkForRef('method:ProcessElement.updateGlobalIDReferences')}.\n\n",flags:"",returns:{type:"Boolean",description:"true if any references were updated; false otherwise"},name:"updateGlobalIDInCriteria"},"attr:ListGrid.recordCanSelectProperty":{seeAlso:[],ref:"attr:ListGrid.recordCanSelectProperty",defaultValue:'"canSelect"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"String",description:"If set to false on a record, selection of that record is disallowed.",flags:"IRA",name:"recordCanSelectProperty"},"classAttr:FileDropZone.clickToAddMessage":{seeAlso:[],defaultValue:'"or click to browse"',type:"classAttr",definingClass:"class:FileDropZone",groups:["i18nMessages"],deprecated:null,ref:"classAttr:FileDropZone.clickToAddMessage",valueType:"String",description:"Message shown below ${isc.DocUtils.linkForRef('classAttr:FileDropZone.emptyDropAreaMessage')} when ${isc.DocUtils.linkForRef('attr:FileDropZone.canAddFilesOnClick')} is true.",flags:"IR",name:"clickToAddMessage"},"attr:GridFetchDataTask.applyToImplicitCriteria":{seeAlso:[],ref:"attr:GridFetchDataTask.applyToImplicitCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:GridFetchDataTask",valueType:"Boolean",description:"Should criteria be applied to the grid as\n ${isc.DocUtils.linkForRef('attr:ListGrid.implicitCriteria','implicit criteria')}? When criteria is applied this way,\n it is not shown to the user and cannot be changed by the user.",flags:"IR",name:"applyToImplicitCriteria"},"method:MultiSortPanel.getSortLevel":{seeAlso:[],ref:"method:MultiSortPanel.getSortLevel",deprecated:null,type:"method",definingClass:"class:MultiSortPanel",params:[{defaultValue:null,optional:false,type:"number",description:"The index of the level to return a SortSpecifier for",name:"levelNum"}],description:" Return a ${isc.DocUtils.linkForRef('object:SortSpecifier')} object for the requested levelNum.\n\n",flags:"",returns:{type:"SortSpecifier",description:"A SortSpecifier representing the requested levelNum"},name:"getSortLevel"},"attr:DataSource.jsonSuffix":{seeAlso:[{ref:"attr:OperationBinding.dataFormat",description:null},{ref:"attr:OperationBinding.dataTransport",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.jsonSuffix",valueType:"String",description:"Allows you to specify an arbitrary suffix string to apply to all json format responses \n sent from the server to this application.\n <P>\n The inclusion of such a suffix ensures your code is not directly executable outside of\n your application, as a preventative measure against\n <a href='http://www.google.com/search?q=javascript+hijacking' target='_blank'>javascript hijacking</a>.\n <P>\n Only applies to responses formatted as json objects. Does not apply to responses returned\n via scriptInclude type transport.",flags:"IRA",serverDS:"allowed",name:"jsonSuffix"},"method:GridRenderer.getRowHeight":{seeAlso:[],ref:"method:GridRenderer.getRowHeight",deprecated:null,type:"method",definingClass:"class:GridRenderer",params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"cell record as returned by getCellRecord",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number",name:"rowNum"}],description:" Return the height this row should be.  Default is this.cellHeight. If\n ${isc.DocUtils.linkForRef('attr:GridRenderer.fixedRowHeights')} is false, the row may be rendered taller than this\n specified size.\n <P>\n If records will be variable height,\n you should switch on ${isc.DocUtils.linkForRef('attr:GridRenderer.virtualScrolling','virtualScrolling')}.\n",flags:"",returns:{type:"number",description:"height in pixels"},name:"getRowHeight"},"attr:RichTextEditor.fontSelectorItem":{seeAlso:[],ref:"attr:RichTextEditor.fontSelectorItem",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:RichTextEditor",valueType:"AutoChild SelectItem",description:"The ${isc.DocUtils.linkForRef('type:AutoChild')} ${isc.DocUtils.linkForRef('class:SelectItem')} used for choosing the font to apply\n to the current selection.",flags:"IR",name:"fontSelectorItem"},"attr:FieldPicker.confirmText":{seeAlso:[],defaultValue:'"Must save pending changes to proceed. OK?"',type:"attr",definingClass:"class:FieldPicker",groups:["i18nMessages"],deprecated:null,ref:"attr:FieldPicker.confirmText",valueType:"String",description:null,flags:"IR",name:"confirmText"},"attr:PortalLayout.canAddColumns":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:PortalLayout",deprecated:null,ref:"attr:PortalLayout.canAddColumns",setter:["setCanAddColumns"],valueType:"Boolean",description:"Can the user add columns to this PortalLayout?\n <P>\n Columns may be added via the ${isc.DocUtils.linkForRef('attr:PortalLayout.showColumnMenus','column menu')},\n or by dragging a portlet and dropping next to an existing column, if \n ${isc.DocUtils.linkForRef('attr:PortalLayout.dropTypes')} includes the drop type for the portlet.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:PortalLayout.removeEmptyColumns')} is true, when the user drags every\n portlet out of a portalLayout column, the column will be removed automatically.",flags:"IRW",name:"canAddColumns"},"attr:MathFunction.description":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:MathFunction",groups:["formulaFields"],deprecated:null,ref:"attr:MathFunction.description",valueType:"String",description:"A short description of this function",flags:"IR",name:"description"},"attr:ListGrid.showRecordComponents":{seeAlso:[{ref:"attr:ListGrid.recordComponentPosition",description:null},{ref:"attr:ListGrid.showRecordComponentsByCell",description:null},{ref:"type:RecordComponentPoolingMode",description:null},{ref:"method:ListGrid.showRecordComponent",description:null},{ref:"method:ListGrid.createRecordComponent",description:null},{ref:"method:ListGrid.updateRecordComponent",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["recordComponents"],ref:"attr:ListGrid.showRecordComponents",deprecated:null,valueType:"boolean",setter:["setShowRecordComponents"],description:"When enabled, ${isc.DocUtils.linkForRef('method:ListGrid.createRecordComponent')} will be called when saved rows are being\n rendered, and any returned component will be displayed embedded within the row or cell.\n <P>\n recordComponents are not created for newly added rows which have not yet been saved.  \n See the ${isc.DocUtils.linkForRef('group:unsavedRecords','Handling Unsaved Records overview')} for more\n information.\n <P>\n Depending on the ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponentsByCell')} setting,\n <code>createRecordComponent()</code> will be called either once per row, or once for\n every cell.\n <P>\n Depending on ${isc.DocUtils.linkForRef('attr:ListGrid.recordComponentPosition')}, components can either be placed underneath\n normal record or cell content (\"expand\" setting) or placed so that they overlap normal\n cell content (\"within\" setting).  For the \"within\" setting, the default is to fill the\n row or cell, but the component can specify percent size or even use\n ${isc.DocUtils.linkForRef('attr:Canvas.snapTo','snapTo-positioning')} to place itself within the row or cell.\n <p>\n The \"expand\" setting is incompatible with ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','frozen columns')}\n <i>unless</i> all <code>recordComponents</code> are the same height and they are present\n in every row, in which case the fixed height of all <code>recordComponents</code> can be\n set via ${isc.DocUtils.linkForRef('attr:ListGrid.recordComponentHeight')} to re-enable frozen fields.\n <p>\n Using <code>recordComponents</code> potentially means creating one component for every\n visible grid row or cell and so can impact performance.  Before using this subsystem:\n <ul>\n <li> consider using ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')} (possibly with a specified \n      ${isc.DocUtils.linkForRef('method:ListGridField.valueIconClick')} handler) for icons based on field values\n      which may be displayed alone in the cell or alongside standard content\n      (see ${isc.DocUtils.linkForRef('attr:ListGridField.showValueIconOnly')});\n <li> for clickable icons representing actions that can be taken on a record, also \n      consider using ${isc.DocUtils.linkForRef('type:ListGridFieldType','a field of type \"icon\"')}, or \n      multiple such fields\n <li> for controls that only need to appear on rollover, consider\n      ${isc.DocUtils.linkForRef('attr:ListGrid.showRollOverCanvas','rollOver controls')}\n <li> if you are trying to customize the editor for a field, you can provide a custom\n      control via ${isc.DocUtils.linkForRef('attr:ListGridField.editorType')}, and ${isc.DocUtils.linkForRef('attr:FormItem.icons')} are a common\n      way to add clickable buttons.  You can also\n      ${isc.DocUtils.linkForRef('method:ListGrid.getEditorType','provide different controls per record')}.  These options are\n      usually better that using <code>recordComponents</code> as custom editors, since\n      you won't have to manage issues like making the <code>recordComponent</code> appear\n      only when editing, having changes affect ${isc.DocUtils.linkForRef('group:editing','editValues')},\n      triggering saves and handling validation errors, etc.\n </ul>\n <P>\n See ${isc.DocUtils.linkForRef('type:RecordComponentPoolingMode')} for an overview of how best to optimize use of\n <code>recordComponents</code> for different data sets.\n <p>\n Regardless of the pooling mode, you can explicitly refresh record components via\n ${isc.DocUtils.linkForRef('method:ListGrid.invalidateRecordComponents')} and\n ${isc.DocUtils.linkForRef('method:ListGrid.refreshRecordComponent')}.\n <P>\n <i>Interaction with ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths','column auto-fit')}</i>: per-cell record\n components are not taken into account when determining the size for column auto fit.\n The default ${isc.DocUtils.linkForRef('method:ListGrid.getDefaultFieldWidth')} implementation looks at cell content\n only. We typically recommend that, for fields showing record-components, \n ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')} and ${isc.DocUtils.linkForRef('attr:ListGridField.canAutoFitWidth')} be disabled, or if \n the record components are of a predictable size, a ${isc.DocUtils.linkForRef('attr:ListGridField.defaultWidth')}\n be specified.<br>\n This is particularly pertinent where ${isc.DocUtils.linkForRef('attr:ListGrid.recordComponentPosition')}\n is set to \"within\", in which case cells' content is often empty or completely covered\n by record-components.",flags:"IRW",name:"showRecordComponents"},"group:fieldGeneration":{refs:["object:AsyncSingleValueGenerationResult","object:AsyncMultipleValuesGenerationResult","object:UserFormula","object:UserSummary","attr:DataBoundComponent.showAsyncValues","attr:DataBoundComponent.asyncValueHoverContents","attr:DataBoundComponent.defaultAsyncErrorHoverContents","attr:DataBoundComponent.asyncErrorHoverProperties","attr:ListGridField.userFormula","attr:ListGridField.userSummary"],seeAlso:[],ref:"group:fieldGeneration",deprecated:null,type:"group",description:null,name:"fieldGeneration"},"attr:FormItem.inputFormat":{seeAlso:[{ref:"attr:FormItem.dateFormatter",description:null}],ref:"attr:FormItem.inputFormat",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FormItem",valueType:"DateInputFormat",description:"For fields of type <code>\"date\"</code>, if this is an editable field such as a\n ${isc.DocUtils.linkForRef('class:TextItem')}, this property \n allows you to specify the ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')} applied to the item.",flags:"IRWA",name:"inputFormat"},"attr:AUN.loopThreshold":{seeAlso:[],ref:"attr:AUN.loopThreshold",defaultValue:"3",deprecated:null,type:"attr",definingClass:"class:AUN",valueType:"Number",description:"Maximum number of times AUN can return to the same screen (identified by component\n structure hash) before considering it stuck in a loop.\n <P>\n This detects when the AI is making actions but not making progress (e.g., repeatedly\n clicking the same button, navigating back and forth between two screens).\n <P>\n AUN will stop if either this limit is reached OR if ${isc.DocUtils.linkForRef('attr:AUN.maxSteps')} is exceeded.\n <P>\n Screen identity is determined by the ${isc.DocUtils.linkForRef('class:UISession')} structure hash of visible\n components, so different arrangements of the same components count as different screens.",flags:"IR",name:"loopThreshold"},"attr:SliderItem.shouldSaveValue":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:SliderItem",groups:["formValues"],deprecated:null,ref:"attr:SliderItem.shouldSaveValue",valueType:"Boolean",description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",flags:"IR",name:"shouldSaveValue"},"attr:DynamicForm.operator":{seeAlso:[],ref:"attr:DynamicForm.operator",defaultValue:'"and"',deprecated:null,type:"attr",definingClass:"class:DynamicForm",valueType:"OperatorId",description:"When ${isc.DocUtils.linkForRef('attr:FormItem.operator')} has been set for any ${isc.DocUtils.linkForRef('class:FormItem')} in this form, what\n logical operator should be applied across the ${isc.DocUtils.linkForRef('object:Criterion','criteria')} produced by the form\n items?  Only applicable to forms that have a ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dataSource','dataSource')}.",flags:"IR",name:"operator"},"classAttr:DateUtil.shortMonthNames":{seeAlso:[],defaultValue:"null",type:"classAttr",definingClass:"class:DateUtil",getter:["getShortMonthNames"],groups:["i18nMessages"],ref:"classAttr:DateUtil.shortMonthNames",deprecated:null,valueType:"Array",description:'This property may be set to an array of shortened month-names.<br>\n For example:\n <pre>\n ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]\n </pre>\n The appropriate month name will then be returned from ${isc.DocUtils.linkForRef(\'method:Date.getShortMonthName\')},\n and may be used whenever SmartClient components display month-names (for example in the\n ${isc.DocUtils.linkForRef(\'class:DateItem\',\'DateItem class\')}).',flags:"IRWA",name:"shortMonthNames"},"method:CoTProcess.isCanceled":{seeAlso:[],ref:"method:CoTProcess.isCanceled",deprecated:null,type:"method",definingClass:"class:CoTProcess",description:" Returns true if this process has been canceled.\n",flags:"",returns:{type:"Boolean",description:null},name:"isCanceled"},"method:ListGrid.getSummaryTitle":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"String",description:"Field summary title."},groups:["i18nMessages","display"],deprecated:null,ref:"method:ListGrid.getSummaryTitle",params:[{defaultValue:null,optional:false,type:"ListGridField",description:"field for which we're returning the title",name:"field"}],description:" Return the summary title of particular field.  This is the title of\n the field to be used in the show / hide fields context menu. Default implementation will\n use  ${isc.DocUtils.linkForRef('method:ListGridField.getSummaryTitle')} or ${isc.DocUtils.linkForRef('attr:ListGridField.summaryTitle')} if specified,\n otherwise ${isc.DocUtils.linkForRef('attr:ListGridField.title')}.\n",flags:"A",name:"getSummaryTitle"},"method:DetailViewer.getViewState":{groups:["viewState"],seeAlso:[{ref:"type:DetailViewerViewState",description:null},{ref:"method:DetailViewer.setViewState",description:null}],ref:"method:DetailViewer.getViewState",deprecated:null,type:"method",definingClass:"class:DetailViewer",description:" Returns a snapshot of the current view state of this DetailViewer.<br>\n This includes the field state of the DetailViewer, returned as a\n ${isc.DocUtils.linkForRef('type:DetailViewerViewState')} object.<br>\n This object can be passed to ${isc.DocUtils.linkForRef('method:DetailViewer.setViewState')} to reset this detail \n viewer's view state to the current state (assuming the same data / fields are present in \n the detail viewer).\n",flags:"",returns:{type:"DetailViewerViewState",description:"current view state for the detail viewer."},name:"getViewState"},"attr:Canvas.shadowSoftness":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["shadow"],ref:"attr:Canvas.shadowSoftness",deprecated:null,valueType:"number",description:"Softness, or degree of blurring, of the shadow.\n <P>\n A shadow with <code>softness:x</code> is 2x pixels larger in each direction than the element\n throwing the shadow, and the media for each edge should be x pixels wide/tall.\n <P>\n Defaults to <code>shadowDepth</code> if unset.",flags:"IRWA",examples:["${isc.DocUtils.linkForExampleId('shadows')}"],name:"shadowSoftness"},"group:dsRequestBeanTypes":{refs:[],seeAlso:[],ref:"group:dsRequestBeanTypes",deprecated:null,type:"group",title:"DSRequest data auto-converted to bean types",description:"For fields with numeric types, the ${isc.DocUtils.linkForRef('attr:DSRequest.data','record data')} in DSRequests will \n automatically be converted to the type of the target field, before the request is received \n in a ${isc.DocUtils.linkForRef('class:DMI')}.\n <p>\n For example, if ${isc.DocUtils.linkForRef('attr:DataSource.beanClassName','your bean')} has a field \"price\" of type Float, \n an \"update\" DSRequest with a new value for this field will use the Java Float type for the \n new value, whereas in the absence of a bean, the Double type would ordinarily be used \n (see ${isc.DocUtils.linkForRef('attr:RPCRequest.data')}).\n <p>\n This happens only for fields of type <i>integer</i>, <i>sequence</i>, <i>intEnum</i> and\n <i>float</i>. Because the conversion is performed as part of server-side validation, it \n applies only to \"update\" or \"add\" requests, and does not apply to ${isc.DocUtils.linkForRef('attr:DSRequest.oldValues')},\n which will continue to use the generic types listed in ${isc.DocUtils.linkForRef('attr:RPCRequest.data')}.\n <P>\n Note that, while values for non-numeric fields will still use basic Java types (for example,\n values for Java Enum fields will arrive ${isc.DocUtils.linkForRef('attr:DataSource.enumTranslateStrategy','as Strings by \\n default')}), manual conversion of the remaining data is not necessary; the server-side API \n <code>DataSource.setProperties()</code> does all remaining conversion necessary to populate \n a bean from the request data (see that API's docs for details), and this conversion\n will be performed automatically if your DMI logic calls <code>execute()</code> on the DSRequest.\n <P>\n You may need to explicitly define what Java type must be used during conversion for a given\n field. This can be achieved by setting ${isc.DocUtils.linkForRef('attr:DataSourceField.javaClass')} property.\n <p>\n If conversion fails, because of target field using an abstract Java type or invalid \n class defined in DSField.javaClass property etc, conversion will fall back to its \n default behavior, i.e. Java type will be guessed from the actual field value. \n It would be Long for integer based types and Double for float type or, if the value would \n appear to exceed the ranges of these types, BigInteger and BigDecimal accordingly.",name:"dsRequestBeanTypes"},"attr:DrawKnob.knobShape":{seeAlso:[],ref:"attr:DrawKnob.knobShape",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DrawKnob",valueType:"AutoChild DrawItem",description:"The ${isc.DocUtils.linkForRef('class:DrawItem')} instance rendered into this DrawKnob's drawPane",flags:"R",name:"knobShape"},"method:FacetChart.setDataColors":{seeAlso:[],ref:"method:FacetChart.setDataColors",deprecated:null,type:"method",definingClass:"class:FacetChart",params:[{defaultValue:null,optional:false,type:"Array of CSSColor",description:"New set of data colors",name:"dataColors"}],description:" Setter for ${isc.DocUtils.linkForRef('attr:FacetChart.dataColors')}.\n",flags:"",name:"setDataColors"},"method:CubeGrid.facetLabelClick":{groups:["events"],seeAlso:[],ref:"method:CubeGrid.facetLabelClick",deprecated:null,type:"method",definingClass:"class:CubeGrid",description:" Method handler fired when the user clicks on a facet label.\n\n",flags:"",name:"facetLabelClick"},"method:SectionStack.getSectionNumber":{seeAlso:[],ref:"method:SectionStack.getSectionNumber",deprecated:null,type:"method",definingClass:"class:SectionStack",params:[{defaultValue:null,optional:false,type:"String",description:"name of a section for which you want to obtain the position.",name:"sectionName"}],description:"\n Returns the position of the specified section in the SectionStack.  The numbering is\n zero-based.  \n\n",flags:"",returns:{type:"number",description:"Position of the section in the SectionStack or -1 if the specified                      section is not a member of this SectionStack."},name:"getSectionNumber"},"attr:ListGrid.dateInputFormat":{seeAlso:[{ref:"attr:ListGrid.dateFormatter",description:null}],ref:"attr:ListGrid.dateInputFormat",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"DateInputFormat",description:"If this is an editable listGrid, this property will specify the\n ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')} applied to editors for fields of type\n <code>\"date\"</code>. May be overridden per field via ${isc.DocUtils.linkForRef('attr:ListGridField.inputFormat')}.",flags:"IRWA",name:"dateInputFormat"},"attr:GaugeSector.value":{seeAlso:[],ref:"attr:GaugeSector.value",defaultValue:"0",deprecated:null,type:"attr",definingClass:"object:GaugeSector",valueType:"float",description:null,flags:"IR",name:"value"},"attr:DynamicForm.showErrorIcons":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:DynamicForm",groups:["validation"],deprecated:null,ref:"attr:DynamicForm.showErrorIcons",valueType:"Boolean",description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation','errorOrientation')},\n and ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code>, <code>errorOrientation</code>\n and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).<br>\n If <code>showErrorText</code> is unset, the error text will be shown if\n ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode')} is true (or ${isc.DocUtils.linkForRef('attr:DynamicForm.linearOnMobile')} is true for\n mobile devices), otherwise it will not be shown.\n <P>\n In addition to this:\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).<br>\n If <code>errorOrientation</code> is unset, the error orientation will default to \"top\" \n if ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode')} is enabled (or ${isc.DocUtils.linkForRef('attr:DynamicForm.linearOnMobile')} is true\n for mobile devices) and error text is not showing, \"left\" otherwise.\n <P>\n <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. Error styling is achieved by\n applying suffixes to existing styling applied to various parts of the form item.\n See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')}  for more on this.",flags:"IRW",name:"showErrorIcons"},"method:Chart.getFacet":{seeAlso:[{ref:"object:Facet",description:null}],ref:"method:Chart.getFacet",deprecated:null,type:"method",definingClass:"interface:Chart",params:[{defaultValue:null,optional:false,type:"String",description:"the id of the facet to retrieve",name:"facetId"}],description:" Get a facet definition by facetId.\n",flags:"",returns:{type:"Facet",description:"the Facet if found, or null"},name:"getFacet"},"attr:FacetValue.isMinimizeValue":{seeAlso:[],ref:"attr:FacetValue.isMinimizeValue",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:FacetValue",valueType:"Boolean",description:"Used to determine which facetValue is to be shown when the facet is minimized.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.  See\n ${isc.DocUtils.linkForRef('attr:CubeGrid.canMinimizeFacets')}.",flags:"IR",name:"isMinimizeValue"},"attr:SimpleType.groupingModes":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:SimpleType",getter:["simpleType.getGroupingModes"],ref:"attr:SimpleType.groupingModes",deprecated:null,valueType:"ValueMap",description:"A set of key-value pairs that represent the names and titles of the grouping modes \n available to values of this type, for use in components that support grouping.\n <P>\n Some types provide a set of builtin groupingModes, as covered \n ${isc.DocUtils.linkForRef('group:builtinGroupingModes','here')}.\n <P>\n Use ${isc.DocUtils.linkForRef('method:SimpleType.getGroupValue')} and ${isc.DocUtils.linkForRef('method:SimpleType.getGroupTitle')} to implement\n custom grouping logic for each of the grouping modes you provide.",flags:"IRW",serverDS:"allowed",name:"groupingModes"},"attr:ListGrid.showHeaderSpanContextMenu":{seeAlso:[{ref:"method:ListGrid.getHeaderSpanContextMenuItems",description:null}],defaultValue:"true",type:"attr",definingClass:"class:ListGrid",groups:["gridHeader"],deprecated:null,ref:"attr:ListGrid.showHeaderSpanContextMenu",valueType:"Boolean",description:"Whether to show a context menu on the header span with standard items for showing and hiding\n fields.  Not supported for ${isc.DocUtils.linkForRef('class:CubeGrid')}.",flags:"IR",name:"showHeaderSpanContextMenu"},"attr:StretchImg.ignoreRTL":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:StretchImg",groups:["RTL","appearance"],ref:"attr:StretchImg.ignoreRTL",deprecated:null,setter:["setIgnoreRTL"],valueType:"boolean",description:"Should the ${isc.DocUtils.linkForRef('attr:StretchImg.items','items')} for this StretchImg display left-to-right even\n if this page is displaying ${isc.DocUtils.linkForRef('classMethod:Page.isRTL','right to left text')}?\n <P>\n Only has an effect if this StretchImg is horizontal (${isc.DocUtils.linkForRef('attr:StretchImg.vertical','vertical')}\n is set to false).\n <P>\n Having this property set to true is usually desirable for the common pattern of media\n consisting of fixed size \"end caps\" and a stretchable center, because it allows the same\n media to be used for LTR and RTL pages.\n <P>\n If set to false, items will be displayed in RTL order for RTL pages.",flags:"IRW",name:"ignoreRTL"},"class:StatefulCanvas":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Canvas",classMethods:[],classAttrs:["classAttr:StatefulCanvas.STATE_UP","classAttr:StatefulCanvas.STATE_DOWN","classAttr:StatefulCanvas.STATE_OVER","classAttr:StatefulCanvas.STATE_DISABLED","classAttr:StatefulCanvas.BUTTON","classAttr:StatefulCanvas.CHECKBOX","classAttr:StatefulCanvas.RADIO","classAttr:StatefulCanvas.FOCUSED","classAttr:StatefulCanvas.SELECTED","classAttr:StatefulCanvas.UNSELECTED"],attrs:["attr:StatefulCanvas.editProxyConstructor","attr:StatefulCanvas.title","attr:StatefulCanvas.ignoreRTL","attr:StatefulCanvas.redrawOnStateChange","attr:StatefulCanvas.selected","attr:StatefulCanvas.state","attr:StatefulCanvas.showRollOver","attr:StatefulCanvas.showFocus","attr:StatefulCanvas.showFocused","attr:StatefulCanvas.showFocusedAsOver","attr:StatefulCanvas.showDown","attr:StatefulCanvas.showDisabled","attr:StatefulCanvas.actionType","attr:StatefulCanvas.radioGroup","attr:StatefulCanvas.styleName","attr:StatefulCanvas.baseStyle","attr:StatefulCanvas.align","attr:StatefulCanvas.valign","attr:StatefulCanvas.autoFit","attr:StatefulCanvas.width","attr:StatefulCanvas.height","attr:StatefulCanvas.icon","attr:StatefulCanvas.iconSize","attr:StatefulCanvas.iconWidth","attr:StatefulCanvas.iconHeight","attr:StatefulCanvas.iconStyle","attr:StatefulCanvas.vIconStyle","attr:StatefulCanvas.iconOrientation","attr:StatefulCanvas.iconSpacing","attr:StatefulCanvas.showDisabledIcon","attr:StatefulCanvas.showRollOverIcon","attr:StatefulCanvas.showDownIcon","attr:StatefulCanvas.showSelectedIcon","attr:StatefulCanvas.showFocusedIcon","attr:StatefulCanvas.showRTLIcon","attr:StatefulCanvas.showOverCanvas","attr:StatefulCanvas.overCanvas","attr:StatefulCanvas.overCanvasConstructor","attr:StatefulCanvas.overCanvasDefaults","attr:StatefulCanvas.ariaLabel","attr:StatefulCanvas.showMenuOnClick"],ref:"class:StatefulCanvas",deprecated:null,treeLocation:["Client Reference/Foundation"],description:'A component that has a set of possible states, and which presents itself differently according to\n which state it is in.  An example is a button, which can be "up", "down", "over" or "disabled".',methods:["method:StatefulCanvas.getAriaStateDefaults","method:StatefulCanvas.getAriaLabel","method:StatefulCanvas.setIgnoreRTL","method:StatefulCanvas.setBaseStyle","method:StatefulCanvas.setState","method:StatefulCanvas.getState","method:StatefulCanvas.setSelected","method:StatefulCanvas.select","method:StatefulCanvas.deselect","method:StatefulCanvas.isSelected","method:StatefulCanvas.getActionType","method:StatefulCanvas.setActionType","method:StatefulCanvas.addToRadioGroup","method:StatefulCanvas.removeFromRadioGroup","method:StatefulCanvas.setDisabled","method:StatefulCanvas.getStateSuffix","method:StatefulCanvas.setIconOrientation","method:StatefulCanvas.setAutoFit","method:StatefulCanvas.getTitle","method:StatefulCanvas.setTitle","method:StatefulCanvas.setIcon","method:StatefulCanvas.setIconStyle"],name:"StatefulCanvas"},"method:Callbacks.RunTaskCallback":{seeAlso:[],ref:"method:Callbacks.RunTaskCallback",deprecated:null,type:"method",definingClass:"class:Callbacks",params:[{defaultValue:null,optional:false,type:"Task",description:"The task instance that was executed.",name:"task"},{defaultValue:null,optional:false,type:"Process",description:"The owning process instance.",name:"process"},{defaultValue:null,optional:false,type:"Object",description:"Task outputs, if any (for ${isc.DocUtils.linkForRef('class:CoTTask','CoTTask')}, this        is the final <code>$outputs</code> JSON). May be null if the task does not\n        produce outputs.",name:"outputs"}],description:" Called when ${isc.DocUtils.linkForRef('method:Process.runTask')} has finished executing the specified task.\n",flags:"",name:"RunTaskCallback"},"class:GridSelectRecordsTask":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"ComponentTask",classMethods:[],classAttrs:[],attrs:["attr:GridSelectRecordsTask.criteria","attr:GridSelectRecordsTask.select","attr:GridSelectRecordsTask.selectMultiple","attr:GridSelectRecordsTask.keepExistingSelection","attr:GridSelectRecordsTask.scrollIntoView"],ref:"class:GridSelectRecordsTask",deprecated:null,treeLocation:["Client Reference/Workflow"],description:"Select or deselect one or more records as specified by criteria. Target records will also\n be scrolled into view or, for a tree, parent folders will be opened to reveal the node.\n <p>\n Task Output:\n <ul>\n   <li>On a select, the set of newly selected records is the output, even if other records\n       are also selected.\n   <li>On a deselect, the entire set of de-selected records is the output.\n </ul>",methods:[],name:"GridSelectRecordsTask"},"classAttr:Hover.hoverCanvas":{seeAlso:[],ref:"classAttr:Hover.hoverCanvas",defaultValue:"null",deprecated:null,type:"classAttr",definingClass:"class:Hover",valueType:"Label",description:"This is a single-instance widget, used to show contextual hover HTML and created lazily \n on the first call to ${isc.DocUtils.linkForRef('classMethod:Hover.show')}. \n <p>\n This component is created using the ${isc.DocUtils.linkForRef('type:AutoChild','autoChild pattern')}, so you\n can configure it using ${isc.DocUtils.linkForRef('classAttr:Hover.hoverCanvasDefaults','autoChild defaults')} and\n ${isc.DocUtils.linkForRef('classAttr:Hover.hoverCanvasProperties','properties')}, or change its type with\n ${isc.DocUtils.linkForRef('classAttr:Hover.hoverCanvasConstructor')}.  Note that size and position are managed by the \n Hover subsystem, so not all ${isc.DocUtils.linkForRef('class:Canvas','Canvas settings')} are supported.\n <p>\n To fully customize what a hover looks like, see ${isc.DocUtils.linkForRef('classMethod:Hover.showHoverComponent')}, which \n allows entirely custom widgets such as ${isc.DocUtils.linkForRef('class:ListGrid','grids')} to be shown as \n hovers.",flags:"RA",name:"hoverCanvas"},"method:ResultSet.getProperty":{seeAlso:[],type:"method",definingClass:"class:ResultSet",returns:{type:"Array",description:"array of the values of property in each item of this list"},groups:["iteration"],deprecated:null,ref:"method:ResultSet.getProperty",params:[{defaultValue:null,optional:false,type:"String",description:"name of the property to look for",name:"property"}],description:" Like ${isc.DocUtils.linkForRef('method:List.getProperty')}.  Checks only loaded rows and will not trigger a fetch.\n",flags:"",name:"getProperty"},"attr:DataSourceField.required":{seeAlso:[{ref:"attr:Validator.applyWhen",description:null}],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["dataType"],ref:"attr:DataSourceField.required",deprecated:null,valueType:"boolean",description:'Indicates this field must be non-null in order for a record to pass validation. Or, in the\n case of a "binary" field, a non-empty file must be uploaded.  Setting this property has the\n same effect as giving the field a ${isc.DocUtils.linkForRef(\'type:ValidatorType\',\'"required" validator\')}. \n <P>\n Note that <code>required</code> should not be set for a server-generated field, such as a\n sequence, or validation will fail on the client.\n <h3>Conditionally required fields</h3>\n Adding an ${isc.DocUtils.linkForRef(\'attr:Validator.applyWhen\',\'applyWhen\')} condition to a <code>required</code> \n validator introduces subtle complexities to the process of validating an existing record.  \n The client is not guaranteed to know the full and complete state of the record it is \n editing because it is common for a ${isc.DocUtils.linkForRef(\'class:DynamicForm\')} to be editing a subset of\n fields.  When a field is <i>unconditionally</i> required, things are simple: if the \n DynamicForm has a ${isc.DocUtils.linkForRef(\'class:FormItem\')} for that field, then the <code>required</code> validation\n passes if that FormItem has a value, and fails if it does not.  If the form has no FormItem\n for the field, it can assume that the field has a value because otherwise it would have \n failed validation when we attempted to add it (when we are adding a record, we of course do \n know the full and complete state of the record - it is whatever we are about to add).\n <p>\n When a field is <i>conditionally</i> required, the client can no longer assume that all \n required fields will have a value.  It may be the case that the condition of requirement \n was not met when the record was added, but now it is.  For example, consider these field\n definitions:<pre>\n    &lt;field name="yearsAtCurrentAddress" type="integer" /&gt;\n    &lt;field name="previousAddress" type="text" &gt;\n      &lt;validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years"&gt;\n        &lt;applyWhen operator="and"&gt;\n          &lt;criteria&gt;\n            &lt;criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" /&gt;\n          &lt;/criteria&gt;\n        &lt;/applyWhen&gt;\n      &lt;/validator&gt;\n    &lt;/field&gt;\n </pre>\n Imagine a record for this DataSource is added where the user has entered a value of "3" for \n "yearsAtCurrentAddress", and no previous address.  Later, the value of that field is \n changed to "2".  If this is done using a form that is also showing the "previousAddress" \n field, we will know that "previousAddress" has not been provided, so we can fail the \n validation and the user will get a helpful error message explaining what the problem is.\n <p>\n However, if the form does not also show the "previousAddress" field, we may choose to use an\n ${isc.DocUtils.linkForRef(\'class:OperationBinding\')} that uses ${isc.DocUtils.linkForRef(\'attr:OperationBinding.outputs\',\'outputs\')} to trim the\n record down to just the fields the form does contain, in the interests of avoiding \n information leakage.  Or perhaps that value is automatically culled from the record before\n the client sees it by the application of a ${isc.DocUtils.linkForRef(\'attr:DataSourceField.viewRequires\',\'declarative security rule\')}.\n Whatever the reason, if the client does not have the complete record, it is not possible \n for the client to sensibly apply this validation.  And because the client has no way of \n knowing if a value is missing because it is genuinely null, or because it has been trimmed\n away by the server, we must treat any null value with suspicion (unless it has a matching \n FormItem - the presence of the FormItem means that the user can edit the value, so it \n would make no sense to pair it with a trimmed record that excludes that field value).\n <p>\n When this happens, we mark the validation as having passed on the client, but in need of \n running on the server.  The server validation makes use of the "storedRecord" facility \n (look for the description of <b>$storedRecord</b> in the \n ${isc.DocUtils.linkForRef(\'group:velocitySupport\',\'Velocity support overview\')}) to overlay the changed record on\n top of the existing record as it currently exists in the database.  This gives the validator\n the complete record including both changed and unchanged values, so it is able to carry \n out the required check in a meaningful way.  However, you should be aware that the \n combination of conditional "required" validators and DynamicForms that edit partial \n records can result in a validation that cannot run on the client and must do both a server \n roundtrip and a database fetch.',flags:"IR",serverDS:"allowed",name:"required"},"method:Menu.getVisibleItemNum":{seeAlso:[{ref:"attr:Menu.filterHiddenItems",description:null}],type:"method",definingClass:"class:Menu",returns:{type:"int",description:"index of the item in the visible items, or -1 if not found."},groups:["menuItems"],deprecated:null,ref:"method:Menu.getVisibleItemNum",params:[{defaultValue:null,optional:false,type:"MenuItem",description:"Menu Item to find",name:"item"}],description:" Given a MenuItem, return its index in the currently visible set of items.\n <P>\n To get the index of the item in the ${isc.DocUtils.linkForRef('method:Menu.getAllItems','full set of items')}, including\n ${isc.DocUtils.linkForRef('attr:MenuItem.hidden','hidden items')}, use ${isc.DocUtils.linkForRef('method:Menu.getItemNum')} instead\n\n",flags:"",name:"getVisibleItemNum"},"attr:FilterBuilder.fieldDataSource":{seeAlso:[],ref:"attr:FilterBuilder.fieldDataSource",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FilterBuilder",valueType:"DataSource | ID",description:"If specified, the FilterBuilder will dynamically fetch DataSourceField definitions from\n this DataSource rather than using ${isc.DocUtils.linkForRef('attr:FilterBuilder.dataSource')}.\n May be specified as a DataSource instance or the String ID of a DataSource.  The ${isc.DocUtils.linkForRef('class:FieldPicker')} \n will default to being a ${isc.DocUtils.linkForRef('class:ComboBoxItem')} rather than a ${isc.DocUtils.linkForRef('class:SelectItem')} so that the user \n will have type-ahead auto-completion.\n <P>\n The records returned from the <code>fieldDataSource</code> must have properties \n corresponding to a ${isc.DocUtils.linkForRef('object:DataSourceField')} definition, at a minimum, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.name','\"name\"')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.type','\"type\"')}.  Any property \n legal on a DataSourceField is legal on the returned records, including \n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueMap','valueMap')}.\n <P>\n Even when a <code>fieldDataSource</code> is specified, ${isc.DocUtils.linkForRef('attr:FilterBuilder.dataSource')} may\n still be specified in order to control the list of \n ${isc.DocUtils.linkForRef('method:DataSource.setTypeOperators','valid operators')} for each field.",flags:"IR",name:"fieldDataSource"},"attr:MultiPickerItem.textMatchStyle":{seeAlso:[],ref:"attr:MultiPickerItem.textMatchStyle",defaultValue:'"substring"',deprecated:null,type:"attr",definingClass:"class:MultiPickerItem",valueType:"TextMatchStyle",description:"textMatchStyle to apply to ${isc.DocUtils.linkForRef('method:MultiPickerItem.getOptionCriteria','option criteria')} for this\n item",flags:"IR",name:"textMatchStyle"},"group:constant":{refs:["classAttr:RPCResponse.STATUS_SUCCESS","classAttr:RPCResponse.STATUS_OFFLINE","classAttr:RPCResponse.STATUS_FAILURE","classAttr:RPCResponse.STATUS_AUTHORIZATION_FAILURE","classAttr:RPCResponse.STATUS_VALIDATION_ERROR","classAttr:RPCResponse.STATUS_LOGIN_INCORRECT","classAttr:RPCResponse.STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED","classAttr:RPCResponse.STATUS_LOGIN_REQUIRED","classAttr:RPCResponse.STATUS_LOGIN_SUCCESS","classAttr:RPCResponse.STATUS_UPDATE_WITHOUT_PK_ERROR","classAttr:RPCResponse.STATUS_TRANSACTION_FAILED","classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED","classAttr:RPCResponse.STATUS_MAX_POST_SIZE_EXCEEDED","classAttr:RPCResponse.STATUS_REQUIRED_CRITERIA_MISSING","classAttr:RPCResponse.STATUS_CRITERIA_REQUIRED_ERROR","classAttr:RPCResponse.STATUS_FILE_REQUIRED_ERROR","classAttr:RPCResponse.INVALID_RESPONSE_FORMAT","classAttr:RPCResponse.STATUS_TRANSPORT_ERROR","classAttr:RPCResponse.STATUS_UNKNOWN_HOST_ERROR","classAttr:RPCResponse.STATUS_CONNECTION_RESET_ERROR","classAttr:RPCResponse.STATUS_SERVER_TIMEOUT"],seeAlso:[],ref:"group:constant",deprecated:null,type:"group",description:null,name:"constant"},"attr:SpinnerItem.decreaseIconProperties":{seeAlso:[],ref:"attr:SpinnerItem.decreaseIconProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:SpinnerItem",valueType:"FormItemIcon Properties",description:"FormItemIcon properties applied to the ${isc.DocUtils.linkForRef('attr:SpinnerItem.decreaseIcon','decreaseIcon')} AutoChild of this\n SpinnerItem.",flags:"IR",name:"decreaseIconProperties"},"method:ListGrid.hideDragHandles":{groups:["dragHandleField"],seeAlso:[{ref:"method:ListGrid.showDragHandles",description:null}],ref:"method:ListGrid.hideDragHandles",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Hides the ${isc.DocUtils.linkForRef('attr:ListGrid.dragHandleField','drag handle field')}, if currently shown.\n",flags:"",name:"hideDragHandles"},"attr:FormItem.top":{seeAlso:[],defaultValue:"0",type:"attr",definingClass:"class:FormItem",getter:["getTop"],ref:"attr:FormItem.top",deprecated:null,setter:["setTop"],valueType:"int",description:'Top coordinate of this item in pixels.  Applies only when the containing DynamicForm\n sets <code>itemLayout:"absolute"</code>.',flags:"IRWA",name:"top"},"method:ListGrid.headerHover":{groups:["events","gridHeader","hovers"],seeAlso:[{ref:"method:ListGrid.headerHoverHTML",description:null}],ref:"method:ListGrid.headerHover",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"number",description:"field number for the header that was hovered",name:"fieldNum"}],description:" Handle a hover over a button in the header.\n\n",flags:"A",name:"headerHover"},"attr:DynamicForm.minHintWidth":{seeAlso:[{ref:"attr:DynamicForm.wrapHintText",description:null}],ref:"attr:DynamicForm.minHintWidth",defaultValue:"80",deprecated:null,type:"attr",definingClass:"class:DynamicForm",valueType:"Integer",description:"Minimum horizontal space made available for ${isc.DocUtils.linkForRef('attr:FormItem.hint')} text.\n Typically this reflects how much space the hint text takes up before it wraps.\n May be overridden at the item level via ${isc.DocUtils.linkForRef('attr:FormItem.minHintWidth')}.\n <p>\n This setting does not apply to hints that are ${isc.DocUtils.linkForRef('attr:TextItem.showHintInField','shown in field')}.",flags:"IR",name:"minHintWidth"},"attr:ImgButton.showRollOverIcon":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:ImgButton",groups:["buttonIcon"],deprecated:null,ref:"attr:ImgButton.showRollOverIcon",valueType:"Boolean",description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",flags:"IR",name:"showRollOverIcon"},"attr:ListGrid.autoFitMaxRecords":{seeAlso:[],defaultValue:"50",type:"attr",definingClass:"class:ListGrid",groups:["autoFitData"],ref:"attr:ListGrid.autoFitMaxRecords",deprecated:null,setter:["setAutoFitMaxRecords"],valueType:"int",description:'If ${isc.DocUtils.linkForRef(\'attr:ListGrid.autoFitData\')} is set to <code>"vertical"</code> or <code>"both"</code> this\n property provides the maximum number of records for which the ListGrid will expand. If more\n records are present, scrolling will be introduced to reach them as normal.\n If unset, by default the ListGrid will expand to accommodate as many records as are present.',flags:"IRW",name:"autoFitMaxRecords"},"attr:SimpleType.inheritsFrom":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:SimpleType",ref:"attr:SimpleType.inheritsFrom",deprecated:null,valueType:"Identifier",description:"Name of another SimpleType from which this type should inherit.\n <P>\n Validators, if any, will be combined.  All other SimpleType properties default to the\n inherited type's value.",flags:"IR",serverDS:"allowed",examples:["${isc.DocUtils.linkForExampleId('extCustomSimpleType')}"],name:"inheritsFrom"},"attr:LoadProjectSettings.requestProperties":{seeAlso:[],ref:"attr:LoadProjectSettings.requestProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:LoadProjectSettings",valueType:"RPCRequest Properties",description:"Allows customizing the projectLoader servlet request properties.  Properties that\n conflict with proper operation of the servlet will be overridden by\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadProject')}.",flags:"IRA",name:"requestProperties"},"classAttr:Browser.allowsSpeechRecognition":{seeAlso:[],ref:"classAttr:Browser.allowsSpeechRecognition",defaultValue:"null",deprecated:null,type:"classAttr",definingClass:"class:Browser",valueType:"Boolean",description:'Whether this browser allows speech recognition sessions to be started using its\n SpeechRecognition implementation. Some browsers expose the API but prevent sessions\n from starting (for example, by blocking access to the vendor-operated speech-to-text\n service used by the implementation), typically surfacing as an immediate service or\n "network" error.\n <p>\n This flag is set on the first attempt to start speech recognition.',flags:"RA",name:"allowsSpeechRecognition"},"classAttr:AI.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage":{seeAlso:[],defaultValue:'"No AI engine is registered which supports vision requests."',type:"classAttr",definingClass:"class:AI",groups:["i18nMessages"],deprecated:null,ref:"classAttr:AI.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage",valueType:"HTMLString",description:null,flags:"RW",name:"noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage"},"classAttr:SelectionOutline.labelBackgroundColor":{seeAlso:[],defaultValue:'"#44ff44"',type:"classAttr",definingClass:"class:SelectionOutline",getter:["getLabelBackgroundColor"],ref:"classAttr:SelectionOutline.labelBackgroundColor",deprecated:null,setter:["setLabelBackgroundColor"],valueType:"String",description:"The background color for the selection label. It corresponds to the CSS background-color\n attribute. You can set this property to an RGB value (e.g. #22AAFF) or a named color\n (e.g. red) from a list of browser supported color names.",flags:"RW",name:"labelBackgroundColor"},"classAttr:Array.DATE_VALUES":{seeAlso:[{ref:"classAttr:Array.TIME_VALUES",description:null},{ref:"classAttr:Array.DATETIME_VALUES",description:null}],ref:"classAttr:Array.DATE_VALUES",defaultValue:"See below",deprecated:null,type:"classAttr",definingClass:"object:Array",valueType:"Function",description:"This is a built-in comparator for the ${isc.DocUtils.linkForRef('method:Array.find','find')} and ${isc.DocUtils.linkForRef('method:Array.findIndex','findIndex')}\n methods of Array.  Passing this comparator to those methods will find instances where Dates\n in the search criteria match Dates in the array members (ordinarily, Javascript only regards\n Dates as equal if they refer to the exact same object).  This comparator compares <i>logical</i>\n dates; the time elements of the values being compared are ignored, so two Dates representing\n different times on the same day will be considered equal.",flags:"R",name:"DATE_VALUES"},"attr:Canvas.hoverHeight":{seeAlso:[{ref:"attr:Canvas.showHover",description:null}],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["hovers"],deprecated:null,ref:"attr:Canvas.hoverHeight",valueType:"int",description:"If <code>this.showHover</code> is true, this property can be used to customize the\n height of the hover canvas shown.",flags:"IRW",name:"hoverHeight"},"group:monthViewFormatting":{refs:["method:Calendar.getDayBodyHTML"],seeAlso:[],ref:"group:monthViewFormatting",deprecated:null,type:"group",description:null,name:"monthViewFormatting"},"object:EventStreamData":{seeAlso:[{ref:"object:EventStreamEvent",description:null}],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:EventStreamData.startTime","attr:EventStreamData.endTime","attr:EventStreamData.events","attr:EventStreamData.nEvents"],groups:["experimental"],ref:"object:EventStreamData",deprecated:null,treeLocation:["Client Reference/System/EventStream"],description:"A JavaScript object representing the state of a live ${isc.DocUtils.linkForRef('class:EventStream')} instance,\n including all captured events retained by the stream.  When ${isc.DocUtils.linkForRef('method:EventStream.end')} is\n called to complete capturing, a <code>EventStreamData</code> object is returned.\n <P>\n Note that <code>EventStreamData</code> is essentially JSON, except that dates remain\n JavaScript ${isc.DocUtils.linkForRef('object:Date')}s, rather than being converted to string format.  This ensures that\n if you ${isc.DocUtils.linkForRef('classMethod:JSON.encode','serialize')} the data and then ${isc.DocUtils.linkForRef('classMethod:JSON.decode','deserialize')}\n it, dates round trip properly and time zone information is not lost.",methods:[],name:"EventStreamData"},"attr:DataSource.sequenceMode":{seeAlso:[],defaultValue:'"native"',type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.sequenceMode",valueType:"SequenceMode",description:"For fields of ${isc.DocUtils.linkForRef('attr:DataSourceField.type','type')} \"sequence\" in a dataSource of \n ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"sql\", indicates the \n ${isc.DocUtils.linkForRef('type:SequenceMode')} to use.  This property has no effect for fields or dataSources of \n other types.\n <p>\n You can set a default sequenceMode for all DataSources of a given database type by setting\n property \"sql.{database_type}.default.sequence.mode\" in <code>server.properties</code>.  \n You set a global default sequenceMode that applies to all database types by setting property\n \"sql.default.sequence.mode\".  For example:<pre>\n   sql.mysql.default.sequence.mode: jdbcDriver\n </pre>\n <P>",flags:"IR",serverDS:"only",name:"sequenceMode"},"method:WebService.getFetchDS":{groups:["webService"],seeAlso:[],ref:"method:WebService.getFetchDS",deprecated:null,type:"method",definingClass:"class:WebService",params:[{defaultValue:null,optional:false,type:"String",description:"name of the web service operation to invoke to fetch                               records",name:"operationName"},{defaultValue:null,optional:false,type:"String",description:"tag or type name of the XML element to be returned as                               DataSource records",name:"resultType"},{defaultValue:null,optional:true,type:"OperationBinding Properties",description:"Optional additional properties for the operationType:\"fetch\" \n ${isc.DocUtils.linkForRef('class:OperationBinding','operationBinding')} which this method automatically creates.  This\n can be used to set properties such as ${isc.DocUtils.linkForRef('attr:OperationBinding.useFlatFields')} or\n ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath')}",name:"operationBindingProperties"}],description:" Retrieve a DataSource that provides read-only access to records returned by a web\n service operation.\n <P>\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBound Components')} can be bound to the returned\n DataSource, and the ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} method can be invoked\n to retrieve data from the web service.\n <P>\n The returned DataSource is only capable of the \"fetch\" \n ${isc.DocUtils.linkForRef('group:dataSourceOperations','DataSource operation')}, not \"update\", \"add\" or\n \"remove\".  To create a DataSource capable of full read-write access, use\n ${isc.DocUtils.linkForRef('attr:DataSource.operationBindings')} with the\n ${isc.DocUtils.linkForRef('attr:OperationBinding.wsOperation','wsOperation')} property set to associate each\n DataSource operation with a web service operation. \n\n",flags:"",name:"getFetchDS"},"attr:ListGrid.canAddAISummaryFields":{seeAlso:[],ref:"attr:ListGrid.canAddAISummaryFields",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"boolean",description:"Adds an item to the header context menu allowing users to launch a dialog to define a new\n field based on an AI summary of the entire record.\n <P>\n AI summary fields can be persisted via ${isc.DocUtils.linkForRef('method:ListGrid.getFieldState')} and\n ${isc.DocUtils.linkForRef('method:ListGrid.setFieldState')}.",flags:"IRW",name:"canAddAISummaryFields"},"attr:DSRequest.textMatchStyle":{seeAlso:[],ref:"attr:DSRequest.textMatchStyle",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DSRequest",valueType:"TextMatchStyle",description:"For \"fetch\" operations, how search criteria should be interpreted for text fields: one of\n \"exact\" for exact match, \"exactCase\" for case-sensitive exact match, \"startsWith\" for \n matching at the beginning only, or \"substring\" for substring match.  All \n <code>textMatchStyle</code> settings except \"exactCase\" are case-insensitive; use\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} for greater control over matching.\n <p>\n This property defaults to the value of ${isc.DocUtils.linkForRef('attr:DataSource.defaultTextMatchStyle')} if it is not\n explicitly provided on the <code>DSRequest</code>.  Note, however, that DSRequests issued \n by ${isc.DocUtils.linkForRef('class:ListGrid')}s and other ${isc.DocUtils.linkForRef('interface:DataBoundComponent','components')} will generally have a \n setting for textMatchStyle on the component itself \n (see ${isc.DocUtils.linkForRef('attr:ListGrid.autoFetchTextMatchStyle')}, for example).\n <p>\n This setting is respected by the built-in server-side connectors for SQL, JPA and Hibernate.\n A custom server-side DataSource implementation should generally respect this flag as well,\n or server-side filtering will not match client-side filtering, which will require\n ${isc.DocUtils.linkForRef('attr:ResultSet.useClientFiltering','disabling client-side filtering')}, a huge performance\n loss.",flags:"IR",name:"textMatchStyle"},"method:PortalLayout.getPortletArray":{seeAlso:[{ref:"method:PortalLayout.getPortlets",description:null}],ref:"method:PortalLayout.getPortletArray",deprecated:null,type:"method",definingClass:"class:PortalLayout",description:" Returns a multi-level array of the ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} in this PortalLayout,\n where the first level corresponds to columns, the second to rows, and the third\n to Portlets within rows.\n",flags:"",returns:{type:"Array of Array of Array of Portlet",description:"portlets"},name:"getPortletArray"},"attr:Canvas.isSnapAlignCandidate":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["snapGridDragging"],deprecated:null,ref:"attr:Canvas.isSnapAlignCandidate",valueType:"Boolean",description:"Flag to disable snapping to alignment against this Canvas when <i>other</i> Canvases\n dragged into the same parent when ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapAlign')} is enabled on this\n Canvas' parent.",flags:"IRW",name:"isSnapAlignCandidate"},"method:FilterBuilder.filterChanged":{seeAlso:[],ref:"method:FilterBuilder.filterChanged",deprecated:null,type:"method",definingClass:"class:FilterBuilder",description:" Handler fired when there is a change() event fired on any FormItem within the \n filterBuilder. \n\n",flags:"",name:"filterChanged"},"class:IconImgButton":{seeAlso:[{ref:"attr:StatefulCanvas.showMenuOnClick",description:null}],type:"class",staticMethods:[],inheritsFrom:"ImgButton",classMethods:[],classAttrs:[],attrs:["attr:IconImgButton.showMenuOnClick","attr:IconImgButton.src"],ref:"class:IconImgButton",deprecated:null,treeLocation:["Client Reference/Control"],description:"A specialized subclass of ${isc.DocUtils.linkForRef('class:ImgButton')} designed to show an icon that launches a\n ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu','context menu')} when clicked.  The icon is specified as the\n ${isc.DocUtils.linkForRef('attr:IconImgButton.src','src')} property.",methods:[],name:"IconImgButton"},"method:StretchImg.setIgnoreRTL":{seeAlso:[],ref:"method:StretchImg.setIgnoreRTL",deprecated:null,type:"method",definingClass:"class:StretchImg",params:[{defaultValue:null,optional:false,type:"boolean",description:"new value for ignoreRTL.",name:"ignoreRTL"}],description:" Setter for ${isc.DocUtils.linkForRef('attr:StretchImg.ignoreRTL')}.\n",flags:"A",name:"setIgnoreRTL"},"attr:FormulaBuilder.sampleHeaderTitle":{seeAlso:[],defaultValue:'"Sample:"',type:"attr",definingClass:"class:FormulaBuilder",groups:["i18nMessages"],deprecated:null,ref:"attr:FormulaBuilder.sampleHeaderTitle",valueType:"String",description:'The default title for the "Sample" panel, which displays a sample result for the formula.',flags:"IRWA",name:"sampleHeaderTitle"},"attr:GridRenderer.baseStyle":{seeAlso:[{ref:"method:GridRenderer.getCellStyle",description:null},{ref:"method:GridRenderer.getBaseStyle",description:null}],defaultValue:'"cell"',type:"attr",definingClass:"class:GridRenderer",getter:["getBaseStyle"],groups:["cellStyling"],ref:"attr:GridRenderer.baseStyle",deprecated:null,valueType:"CSSStyleName",description:'The base name for the CSS class applied to cells. This style will have "Dark", \n "Over", "Selected", or "Disabled" appended to it according to the state of the cell.',flags:"IR",name:"baseStyle"},"attr:Lane.sublanes":{seeAlso:[],ref:"attr:Lane.sublanes",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:Lane",valueType:"Array of Lane",description:"Array of ${isc.DocUtils.linkForRef('object:Lane')} objects that will share the available space in the parent Lane,\n vertically in ${isc.DocUtils.linkForRef('attr:Calendar.timelineView','timelines')} and horizontally in \n ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day views')}.\n <P>\n Only one level of sublanes is supported, so this attribute only has an effect on\n ${isc.DocUtils.linkForRef('attr:Calendar.lanes','top-level lanes')}.\n <P>\n Note that this feature is mutually exclusive with the \n ${isc.DocUtils.linkForRef('attr:Calendar.eventAutoArrange','auto arrangement')} of events that share time.",flags:"IR",name:"sublanes"},"attr:DropZone.baseStyle":{seeAlso:[],ref:"attr:DropZone.baseStyle",defaultValue:'"dropZone"',deprecated:null,type:"attr",definingClass:"class:DropZone",valueType:"CSSStyleName",description:"Base CSS class for the drop zone. Supports state suffixes: Over, Disabled.",flags:"IR",name:"baseStyle"},"classMethod:Time.getDefaultDisplayTimezone":{seeAlso:[],ref:"classMethod:Time.getDefaultDisplayTimezone",deprecated:null,type:"classMethod",definingClass:"class:Time",description:" Returns the default display timezone set up by ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone')}.\n If no explicit timezone has been set this will return the browser locale timezone offset.\n",flags:"",returns:{type:"String",description:"String of the format <code>+/-HH:MM</code>"},name:"getDefaultDisplayTimezone"},"attr:GridRenderer.emptyCellValue":{seeAlso:[],defaultValue:'"&amp;nbsp;"',type:"attr",definingClass:"class:GridRenderer",groups:["cellStyling"],deprecated:null,ref:"attr:GridRenderer.emptyCellValue",valueType:"HTMLString",description:"Value to show in empty cells (when getCellValue returns null).",flags:"IRW",name:"emptyCellValue"},"attr:Process.state":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Process",deprecated:null,ref:"attr:Process.state",setter:["setState"],valueType:"Record",description:"Current state of a process.  As with Records in general, any field of a Record may\n contain a nested Record or Array of Records, so the process state is essentially a\n hierarchical data structure.\n <p>\n <h4>Transient state</h4>\n In addition to the explicit process state there is a \"transient state.\" The transient\n state represents the complete output of each of the last tasks of each type within the current\n process execution. This allows easy reference to the previous task output with\n ${isc.DocUtils.linkForRef('type:TaskInputExpression','taskInputExpressions')}.",flags:"IRW",name:"state"},"method:DynamicForm.setTarget":{seeAlso:[],ref:"method:DynamicForm.setTarget",deprecated:null,type:"method",definingClass:"class:DynamicForm",params:[{defaultValue:null,optional:false,type:"String",description:"New submission target",name:"target"}],description:" Sets the ${isc.DocUtils.linkForRef('attr:DynamicForm.target','target')} for this form.\n",flags:"",name:"setTarget"},"attr:TreeGrid.openerIconSize":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:TreeGrid",groups:["treeIcons"],deprecated:null,ref:"attr:TreeGrid.openerIconSize",valueType:"number",description:"Default width and height in pixels of the opener icons, that is, the icons which show\n the open or closed state of the node, typically a [+] or [-] symbol, if not overridden\n by ${isc.DocUtils.linkForRef('attr:TreeGrid.openerIconWidth')}/${isc.DocUtils.linkForRef('attr:TreeGrid.openerIconHeight')}.\n <P>\n If ${isc.DocUtils.linkForRef('attr:TreeGrid.showConnectors')} is true, the opener icon includes the connector line, and\n defaults to ${isc.DocUtils.linkForRef('attr:ListGrid.cellHeight','cellHeight')}.\n <P>\n Otherwise, <code>openerIconSize</code> defaults to ${isc.DocUtils.linkForRef('attr:TreeGrid.iconSize')}.",flags:"IRW",name:"openerIconSize"},"attr:DrawnValue.record":{seeAlso:[],ref:"attr:DrawnValue.record",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DrawnValue",valueType:"CellRecord",description:"The data record of the data point from which this <code>drawnValue</code> was created.\n <P>\n Note that a chart with an ${isc.DocUtils.linkForRef('attr:Facet.inlinedValues','inlined facet')} or a\n ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','multi-axis chart')} may define multiple data points in\n the same record, each of which will correspond to a different <code>drawnValue</code>.\n The way to uniquely identify the data value of this particular <code>drawnValue</code>\n is to use the ${isc.DocUtils.linkForRef('attr:DrawnValue.facetValues')}.",flags:"IR",name:"record"},"attr:ServerObject.bean":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ServerObject",deprecated:null,ref:"attr:ServerObject.bean",valueType:"String",description:'For use when ${isc.DocUtils.linkForRef(\'attr:ServerObject.lookupStyle\')} is <code>"spring"</code> or <code>"cdi"</code>, \n id (name) of the bean to ask Spring (CDI) to create.',flags:"IR",serverDS:"only",name:"bean"},"attr:Canvas.hoverMoveWithMouse":{seeAlso:[{ref:"attr:Canvas.showHover",description:null}],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["hovers"],deprecated:null,ref:"attr:Canvas.hoverMoveWithMouse",valueType:"boolean",description:"If <code>this.showHover</code> is true, should this widget's hover canvas be moved with\n the mouse while visible?",flags:"IRW",name:"hoverMoveWithMouse"},"method:DynamicForm.fetchData":{groups:["dataBoundComponentMethods"],seeAlso:[],ref:"method:DynamicForm.fetchData",deprecated:null,type:"method",definingClass:"class:DynamicForm",params:[{defaultValue:null,optional:true,type:"Criteria",description:"search criteria",name:"criteria"},{defaultValue:null,optional:true,type:"DSCallback",description:"callback to invoke on completion",name:"callback"},{defaultValue:null,optional:true,type:"DSRequest",description:"additional properties to set on the DSRequest                                            that will be issued",name:"requestProperties"}],description:" Retrieve data that matches the provided criteria, and edit the first record returned\n \n",flags:"",name:"fetchData"},"method:ViewLoader.getView":{groups:["contentLoading"],seeAlso:[],ref:"method:ViewLoader.getView",deprecated:null,type:"method",definingClass:"class:ViewLoader",description:" Retrieve the current view.  May be null if the view has not yet been loaded, or has been\n explicitly set to null.\n\n",flags:"",returns:{type:"Canvas",description:"the current view"},name:"getView"},"attr:RPCRequest.downloadToNewWindow":{seeAlso:[],ref:"attr:RPCRequest.downloadToNewWindow",defaultValue:"false",deprecated:null,type:"attr",definingClass:"object:RPCRequest",valueType:"Boolean",description:"When ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadResult','downloadResult')} is true, setting this attribute to\n true causes the content of the downloaded file to be displayed in a new browser window. \n <P>\n Note that this setting is currently incompatible with\n ${isc.DocUtils.linkForRef('attr:RPCRequest.transport','transport:\"xmlHttpRequest\"')}. See the \n ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadResult','downloadResult')} documentation for more details on \n xmlHttpRequest downloads",flags:"IRWA",name:"downloadToNewWindow"},"classMethod:Page.setTitle":{seeAlso:[],ref:"classMethod:Page.setTitle",deprecated:null,type:"classMethod",definingClass:"class:Page",params:[{defaultValue:null,optional:false,type:"String",description:"the browser page title",name:"title"}],description:"\t\tSet the title of the page, which is typically shown as part of the browser window title\n",flags:"",name:"setTitle"},"attr:Calendar.implicitCriteria":{seeAlso:[],ref:"attr:Calendar.implicitCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"Criteria",description:"Criteria that are never shown to or edited by the user and are cumulative with any criteria\n provided via ${isc.DocUtils.linkForRef('attr:DataBoundComponent.initialCriteria')} and related methods.\n <p>\n This property supports ${isc.DocUtils.linkForRef('group:dynamicCriteria')} - use ${isc.DocUtils.linkForRef('attr:Criterion.valuePath')}\n to refer to values in the ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope')}.",flags:"IRW",name:"implicitCriteria"},"attr:DateChooser.previousYearButton":{seeAlso:[],ref:"attr:DateChooser.previousYearButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DateChooser",valueType:"AutoChild IButton",description:"A button shown in the ${isc.DocUtils.linkForRef('attr:DateChooser.navigationLayout','navigation layout')} that shifts\n the calendar view backward by a year.",flags:"IR",name:"previousYearButton"},"classMethod:Offline.goOnline":{seeAlso:[{ref:"classMethod:Offline.goOffline",description:null},{ref:"classMethod:Offline.useNativeOfflineDetection",description:null}],ref:"classMethod:Offline.goOnline",deprecated:null,type:"classMethod",definingClass:"class:Offline",description:" Explicitly sets this session into online mode.  This setting will override whatever \n state the browser reports.  This allows users to manually set an application into \n offline or online state.\n \n",flags:"",name:"goOnline"},"attr:ToolStrip.verticalStyleName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ToolStrip",groups:["appearance"],deprecated:null,ref:"attr:ToolStrip.verticalStyleName",valueType:"CSSStyleName",description:"Default stylename to use if ${isc.DocUtils.linkForRef('attr:ToolStrip.vertical','this.vertical')} is true.\n If unset, the standard ${isc.DocUtils.linkForRef('attr:ToolStrip.styleName')} will be used for both vertical and horizontal\n toolstrips.\n <P>\n Note that this property only applies to the widget at init time. To modify the \n styleName after this widget has been initialized, you should\n simply call ${isc.DocUtils.linkForRef('method:Canvas.setStyleName','setStyleName()')} rather than updating this \n property.",flags:"IR",name:"verticalStyleName"},"method:Tree.getFolders":{seeAlso:[],ref:"method:Tree.getFolders",deprecated:null,type:"method",definingClass:"class:Tree",params:[{defaultValue:null,optional:false,type:"TreeNode",description:"node in question",name:"node"}],description:"\n Returns all the first-level folders of a node.\n <br><br>\n For load on demand trees (those that only have a partial representation client-side), this\n method will return only nodes that have already been loaded from the server.\n\n",flags:"",returns:{type:"Array of TreeNode",description:"List of immediate children that are folders"},name:"getFolders"},"attr:BatchUploader.previousButton":{seeAlso:[],ref:"attr:BatchUploader.previousButton",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:BatchUploader",valueType:"AutoChild IButton",description:"Button that scrolls grid to the previous error.",flags:"IR",name:"previousButton"},"method:ListGrid.getHeaderContextMenuItems":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"Array of MenuItem",description:null},groups:["gridHeader"],deprecated:null,ref:"method:ListGrid.getHeaderContextMenuItems",params:[{defaultValue:null,optional:true,type:"Integer",description:"Index of the field the user clicked in the    ${isc.DocUtils.linkForRef('attr:ListGrid.fields','fields')} array. <b>Note:</b> if the user right-clicked the sorter button\n    this parameter will be <code>null</code>.",name:"fieldNum"}],description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu')} is <code>true</code> this method returns\n the menu items to be displayed in the default header context menu.\n <P>\n This method is called at various times, including during redraws, as the mouse moves over a\n ListGrid header button and each time the menu is actually displayed - this allows for \n dynamic content depending on the current state of the grid and its fields.\n <P>\n Consequently, this method should not instantiate any classes, because they'll be re-created\n on each call, resulting in a leak - your implementation should return an array of menuItem \n config-blocks only, so you shouldn't instantiate actual Menu instances to apply as the \n ${isc.DocUtils.linkForRef('attr:MenuItem.submenu','submenu')} of items - instead, set submenu to a simple array of\n menuItems.  If your use-case necessitates that class instances are created, because specific\n submenus have a different Menu class, for example, you should keep a reference to them and \n either, if their content is dynamic, destroy and recreate them with the new items, or just\n return the existing instances otherwise. \n <P>\n The default set of menu items includes items for built-in ListGrid features like showing \n and hiding fields, freezing fields or grouping by them, and other functions.\n\n",flags:"",name:"getHeaderContextMenuItems"},"attr:NotifyAction.methodName":{seeAlso:[],ref:"attr:NotifyAction.methodName",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:NotifyAction",valueType:"String",description:"The method to invoke on the ${isc.DocUtils.linkForRef('attr:NotifyAction.target')} when the action is executed.",flags:"IR",name:"methodName"},"method:DataSource.formatFieldValue":{seeAlso:[],ref:"method:DataSource.formatFieldValue",deprecated:null,type:"method",definingClass:"class:DataSource",params:[{defaultValue:null,optional:false,type:"DataSourceField | FieldName",description:"name of the field to use to format value",name:"field"},{defaultValue:null,optional:false,type:"Any",description:"raw value to be formatted",name:"value"}],description:" Formats the supplied value using the ${isc.DocUtils.linkForRef('class:SimpleType')} derived from the field definition.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:DataSourceField.format')} is defined for a date, time or numeric-based\n value, or ${isc.DocUtils.linkForRef('attr:DataSourceField.dateFormatter')} or ${isc.DocUtils.linkForRef('attr:DataSourceField.timeFormatter')} is\n defined for a date or time-based value, that format is given priority and used to format\n the value rather than the <code>SimpleType</code>.\n\n",flags:"",returns:{type:"String",description:"formatted value or null"},name:"formatFieldValue"},"classAttr:Canvas.loadingImageSrc":{seeAlso:[{ref:"attr:ListGrid.loadingDataMessage",description:null},{ref:"attr:DetailViewer.loadingMessage",description:null},{ref:"attr:HTMLFlow.loadingMessage",description:null},{ref:"attr:ViewLoader.loadingMessage",description:null}],defaultValue:'"[SKINIMG]loadingSmall.gif"',type:"classAttr",definingClass:"class:Canvas",groups:["animation"],deprecated:null,ref:"classAttr:Canvas.loadingImageSrc",valueType:"SCImgURL",description:"Image URL to be displayed while data is being loaded (if enabled for the widget\n waiting for data). Must be square; ${isc.DocUtils.linkForRef('classAttr:Canvas.loadingImageSize')} specifies the width\n and height.",flags:"RWA",name:"loadingImageSrc"},"attr:DynamicForm.linearAutoSpanItems":{seeAlso:[],ref:"attr:DynamicForm.linearAutoSpanItems",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:DynamicForm",valueType:"Boolean",description:"When a form is rendered in ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode')}, should each item appear on its own\n row, spanning the full set of rendered columns by default?",flags:"IRW",name:"linearAutoSpanItems"},"attr:Canvas.keepInParentRect":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["dragdrop"],ref:"attr:Canvas.keepInParentRect",deprecated:null,valueType:"Boolean | Array of Integer",description:'Constrains drag-resizing and drag-repositioning of this canvas to either the rect of its\n parent (if set to true) or an arbitrary rect based on its parent (if set to a\n [Left,Top,Width,Height] rect array).  In the latter mode you may use negative offsets\n for left/top and a width/height greater than the visible or scroll width of the parent\n to allow positioning beyond the confines of the parent.\n <p>\n If this canvas has no parent, constrains dragging to within the browser window.\n <p>\n Affects target and outline dragAppearance, not tracker.\n <p>\n Note: keepInParentRect affects only user drag interactions, not programmatic moves.\n <p>\n <u>Example use cases:</u><br>\n <code>keepInParentRect: true</code> - confine to parent<br>\n <code>keepInParentRect: [0, 0, 500, 500]</code> - confine to top left 500x500 region within parent<br>\n <code>keepInParentRect: [0, 0, 10000, 10000]</code> - in combination with\n overflow: "auto", confine to parent, but allow moving off the right and bottom of the\n parent to force scrolling (and hence enlarge the scrollWidth of the parent).',flags:"IRWA",examples:["${isc.DocUtils.linkForExampleId('dragCreate')}"],name:"keepInParentRect"},"attr:FileUploadItem.canvasConstructor":{seeAlso:[],ref:"attr:FileUploadItem.canvasConstructor",defaultValue:'"FileDropZone"',deprecated:null,type:"attr",definingClass:"class:FileUploadItem",valueType:"String",description:"The class to use for the ${isc.DocUtils.linkForRef('class:Canvas')} autoChild. Default is FileDropZone.",flags:"IR",name:"canvasConstructor"},"attr:MenuBar.menus":{seeAlso:[{ref:"class:Menu",description:null}],defaultValue:"null",type:"attr",definingClass:"class:MenuBar",deprecated:null,ref:"attr:MenuBar.menus",setter:["setMenus"],valueType:"Array of Menu",description:"An array of menu object initializers or instantiated menu objects. Buttons for each\n menu item will automatically be created. See the Menu Widget Class for fundamental\n menu properties and other properties.  Titles for the buttons are derived from the \n <code>title</code> property of each menu.",flags:"IRW",name:"menus"},"classAttr:DynamicForm.NORMAL":{seeAlso:[],defaultValue:'"normal"',type:"classAttr",definingClass:"class:DynamicForm",deprecated:null,ref:"classAttr:DynamicForm.NORMAL",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:Encoding','Encoding')}.",flags:"R",name:"NORMAL",constant:true},"classMethod:Class.changeDefaults":{seeAlso:[],ref:"classMethod:Class.changeDefaults",deprecated:null,type:"classMethod",definingClass:"class:Class",params:[{defaultValue:null,optional:false,type:"String",description:"name of the property to change",name:"defaultsName"},{defaultValue:null,optional:false,type:"Object",description:"overrides for defaults",name:"newDefaults"}],description:' \n Changes a set of defaults defined as a JavaScript Object.  For these kind of properties,\n simply calling ${isc.DocUtils.linkForRef(\'method:Class.addProperties\')} would replace the original Object\n with yours, wiping out settings required for the basic functionality of the component.\n This method instead applies your overrides over the existing properties, without\n destroying non-overridden properties.\n <p>\n For example let\'s say you have a component that\'s defined as follows\n <pre>\n isc.defineClass("MyComponent");\n isc.MyComponent.addProperties({\n     simpleProperty: "some value",\n     propertyBlock : {\n       foo: "bar",\n       zoo: "moo"\n     }\n }\n </pre>\n If you wanted to override simpleProperty, you can just call ${isc.DocUtils.linkForRef(\'method:Class.addProperties\')}\n like this:\n <pre>\n isc.MyComponent.addProperties({\n     simpleProperty: "my override"\n });\n </pre>\n If you want to override the value of <code>propertyBlock.moo</code> above,\n but you don\'t want to clobber the value of <code>propertyBlock.zoo</code>.  If you use\n the above pattern like so:\n <pre>\n isc.MyComponent.addProperties({\n     propertyBlock: {\n         foo: "new value",\n         zoo: "moo"\n     }\n });\n </pre>\n You need to re-specify the value of <code>propertyBlock.zoo</code> which you didn\'t want\n to override.  Failing to re-specify it would destroy the value.\n <p>\n Instead of re-specifying the value, you can use this method to modify the value of\n <code>foo</code> - like this:\n <pre>\n isc.MyComponent.changeDefaults("propertyBlock", {\n     foo: "new value"\n });\n </pre>\n <p>\n See also the ${isc.DocUtils.linkForRef(\'type:AutoChild\')} system for information about standard sets of defaults\n that are available for customization.\n\n',flags:"A",name:"changeDefaults"},"method:EditPane.getPaletteNodesFromJS":{seeAlso:[{ref:"method:Callbacks.PaletteNodeCallback",description:null}],ref:"method:EditPane.getPaletteNodesFromJS",deprecated:null,type:"method",definingClass:"class:EditPane",params:[{defaultValue:null,optional:false,type:"String",description:"JavaScript code to eval.",name:"jsCode"},{defaultValue:null,optional:false,type:"PaletteNodeCallback",description:"Callback used to return the PaletteNodes",name:"callback"},{defaultValue:null,optional:true,type:"Array of String",description:"widgets to allow to take their global IDs",name:"globals"}],description:" Obtain ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')} from a JavaScript source representation.\n <P>\n By default, components that have ${isc.DocUtils.linkForRef('attr:Canvas.ID','global IDs')} will not\n actually be allowed to take those global IDs - instead, only widgets that have one of the\n global IDs passed as the <code>globals</code> parameter will actually receive their global\n IDs.  To override this behavior, pass the special value ${isc.DocUtils.linkForRef('classAttr:RPCManager.ALL_GLOBALS')}\n for the <code>globals</code> parameter.\n\n",flags:"",name:"getPaletteNodesFromJS"},"attr:TileGrid.wrapValues":{seeAlso:[],ref:"attr:TileGrid.wrapValues",defaultValue:"false",deprecated:null,type:"attr",definingClass:"class:TileGrid",valueType:"Boolean",description:"Whether values should be allowed to wrap by default, or should be shown on one line\n regardless of length.",flags:"IR",name:"wrapValues"},"method:Array.slide":{seeAlso:[],ref:"method:Array.slide",deprecated:null,type:"method",definingClass:"object:Array",params:[{defaultValue:null,optional:false,type:"number",description:"start position",name:"start"},{defaultValue:null,optional:false,type:"number",description:"destination position for the value at start",name:"destination"}],description:" Slide element at position start to position destination, moving all the other elements to cover\n the gap.\n\n",flags:"A",name:"slide"},"attr:FileDropZone.minSize":{seeAlso:[],ref:"attr:FileDropZone.minSize",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FileDropZone",valueType:"Integer",description:"Minimum total size in bytes for all files combined.",flags:"IR",name:"minSize"},"attr:TourStep.bindEnteredText":{seeAlso:[],ref:"attr:TourStep.bindEnteredText",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TourStep",valueType:"String",description:"When set on a step with an ${isc.DocUtils.linkForRef('attr:TourStep.actionType','actionType')} of \"change\",\n the entered or selected value will be automatically bound to the specified value\n in the ${isc.DocUtils.linkForRef('attr:Process.state','tour state')}.",flags:"IR",name:"bindEnteredText"},"method:ColumnTree.getRecord":{seeAlso:[],ref:"method:ColumnTree.getRecord",deprecated:null,type:"method",definingClass:"class:ColumnTree",params:[{defaultValue:null,optional:false,type:"int",description:"index of record to return.",name:"index"},{defaultValue:null,optional:true,type:"Integer",description:"optional index of the column",name:"colNum"}],description:" Retrieve a record by index.  \n <P>\n If <code>colNum</code> is passed, returns the record found in that column at that index,\n or null if the column doesn't exist or the index is too high.\n <P>\n With no <code>colNum</code> parameter, a record's index is it's position counting from the\n first record of the first column and including all records in each column. Note that both\n index and colNum are zero-based - so the first column is column 0, not column 1.\n \n",flags:"",returns:{type:"TreeNode",description:"node at the specified index"},name:"getRecord"},"classAttr:RPCResponse.STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED":{seeAlso:[{ref:"object:RPCRequest",description:null}],defaultValue:"-6",type:"classAttr",definingClass:"class:RPCResponse",groups:["statusCodes","constant"],deprecated:null,ref:"classAttr:RPCResponse.STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED",valueType:"int",description:"Indicates that too many authentication attempts have been made and the server refuses to\n accept any more login attempts.",flags:"R",name:"STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED"},"attr:RichTextEditor.pasteSelectionPrompt":{seeAlso:[],defaultValue:'"Paste"',type:"attr",definingClass:"class:RichTextEditor",groups:["i18nMessages"],deprecated:null,ref:"attr:RichTextEditor.pasteSelectionPrompt",valueType:"String",description:"The prompt for the built-in ${isc.DocUtils.linkForRef('type:ControlName','pasteSelection')} control.",flags:"IRW",name:"pasteSelectionPrompt"},"attr:TreeGrid.canReorderRecords":{seeAlso:[{ref:"attr:TreeNode.canDrag",description:null},{ref:"attr:TreeNode.canAcceptDrop",description:null},{ref:"method:ListGrid.showDragHandles",description:null}],defaultValue:"false",type:"attr",definingClass:"class:TreeGrid",groups:["treeGridDrop"],ref:"attr:TreeGrid.canReorderRecords",deprecated:null,valueType:"Boolean",description:"Indicates whether records can be reordered by dragging within this <code>ListGrid</code>.\n <p>\n <strong>NOTE:</strong> If <code>canReorderRecords</code> is initially enabled or might be\n ${isc.DocUtils.linkForRef('method:ListGrid.setCanReorderRecords','dynamically enabled')} after the grid is created,\n it may be desirable to disable ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','touch scrolling')}\n so that touch-dragging a record starts a reorder operation rather than a scroll,\n but see the discussion of ${isc.DocUtils.linkForRef('method:ListGrid.showDragHandles','drag handles')}. If \n ${isc.DocUtils.linkForRef('attr:Canvas.disableTouchScrollingForDrag')} is set to <code>true</code>, then touch\n scrolling will be disabled automatically. However, for ${isc.DocUtils.linkForRef('group:accessibility','accessibility')}\n reasons, it is recommended to leave touch scrolling enabled and provide an alternative\n set of controls that can be used to perform drag-reordering of records.",flags:"IRWA",examples:["${isc.DocUtils.linkForExampleId('treeDragReparent')}"],name:"canReorderRecords"},"method:DataBoundComponent.editHilites":{groups:["hiliting"],seeAlso:[],ref:"method:DataBoundComponent.editHilites",deprecated:null,type:"method",definingClass:"interface:DataBoundComponent",description:" Shows a ${isc.DocUtils.linkForRef('class:HiliteEditor','HiliteEditor')} interface allowing end-users to edit\n the data-hilites currently in use by this DataBoundComponent.\n\n",flags:"",name:"editHilites"},"attr:Menu.fillSpaceStyleName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Menu",groups:["appearance"],deprecated:null,ref:"attr:Menu.fillSpaceStyleName",valueType:"CSSStyleName",description:"If set, alternative body style for the menu used when there is no icon field and the\n ${isc.DocUtils.linkForRef('attr:Menu.placement')} settings indicate the menu will be filling a portion of the screen or\n a panel.  Generally this alternative style should not have rounded or excessively large\n edges.  If unset, then ${isc.DocUtils.linkForRef('attr:Menu.bodyStyleName')} is used instead.\n <p>\n When there is an icon field, ${isc.DocUtils.linkForRef('attr:Menu.iconFillSpaceStyleName')}, if set, overrides this setting.",flags:"IR",name:"fillSpaceStyleName"},"method:FileUploadItem.endProcessing":{seeAlso:[],ref:"method:FileUploadItem.endProcessing",deprecated:null,type:"method",definingClass:"class:FileUploadItem",description:" See ${isc.DocUtils.linkForRef('method:FileDropZone.endProcessing')}.\n",flags:"",name:"endProcessing"},"method:EditTree.makePaletteNode":{seeAlso:[],ref:"method:EditTree.makePaletteNode",deprecated:null,type:"method",definingClass:"class:EditTree",params:[{defaultValue:null,optional:false,type:"EditNode",description:"the editNode to use to make a paletteNode",name:"editNode"}],description:" Creates a ${isc.DocUtils.linkForRef('object:PaletteNode')} from an ${isc.DocUtils.linkForRef('object:EditNode')} in this context's\n ${isc.DocUtils.linkForRef('method:EditTree.getEditNodeTree','editNodeTree')}.\n <p>\n This essentially creates a new ${isc.DocUtils.linkForRef('object:PaletteNode')} with the ${isc.DocUtils.linkForRef('attr:EditNode.defaults')} from the\n passed <code>editNode</code>.  The returned <code>paletteNode</code> could then be used with\n ${isc.DocUtils.linkForRef('method:EditContext.addFromPaletteNode')} to effectively create a copy of the original editNode -\n specifically a new editNode with a new ${isc.DocUtils.linkForRef('attr:EditNode.liveObject')} created from the same\n defaults.\n <p>\n However note that <code>makePaletteNode()</code> does not copy descendant nodes - use\n ${isc.DocUtils.linkForRef('method:EditTree.makePaletteNodeTree')} for that.\n <p>\n May return null if the passed editNode cannot validly by transformed into a paletteNode, for\n example if ${isc.DocUtils.linkForRef('attr:EditNode.canDuplicate')} was set false.\n\n",flags:"",returns:{type:"PaletteNode",description:"paletteNode derived from the editNode or null"},name:"makePaletteNode"},"attr:UploadItem.capture":{seeAlso:[],ref:"attr:UploadItem.capture",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:UploadItem",valueType:"String",description:'This attribute enables camera capture functionality for mobile devices, accepting the \n following values:\n <ul>\n <li>Set it to "user" to capture using the front-facing camera.</li>\n <li>Set it to "environment" to capture using the rear-facing camera.</li>\n </ul>\n <p>\n Please note that in the latest versions of Android and iOS, utilizing this attribute \n will consistently load the rear camera. This behavior is due to the direct camera software\'s \n ability to switch between the two cameras seamlessly.\n <p>\n When working with the capture functionality of iPhones and Android devices, it\'s important \n to consider the supported DataSourceField.mimeTypes for audio, video, and image files that \n can be used with the fileItem.accept attribute. Here\'s a list of commonly supported mime types \n for capturing on these devices:\n <p>\n Supported Image Mime Types:\n <ul>\n <li>image/jpeg: JPEG image format (.jpg, .jpeg)</li>\n <li>image/png: Portable Network Graphics format (.png)</li>\n </ul>\n Supported Audio Mime Types:\n <ul>\n <li>audio/3gpp: 3GPP format, commonly used for audio capture.</li>\n <li>audio/mp4: MP4 format, widely supported for audio capture.</li>\n </ul>\n Supported Video Mime Types:\n <ul>\n <li>video/3gpp: 3GPP format, commonly used for video capture.</li>\n <li>video/mp4: MP4 format, widely supported for video capture.</li>\n </ul>\n <b>Behavior Based on \'accept\' Attribute</b>\n <p>\n The behavior of using the capture attribute depends on the value used in the accept \n attribute. For example:\n <ul>\n <li><i>accept="image/*"</i> will load the camera ready to take pictures.</li>\n <li><i>accept="audio/*"</i> will load the default audio recorder, not the camera.</li>\n <li><i>accept="video/*"</i> will load the camera in video mode, ready to capture videos.</li>\n </ul>\n Please note that the SmartClient framework does not control the native device behavior \n beyond these attribute settings.\n <p>\n Lastly, keep in mind that these settings have no effect on desktop browsers; they apply \n exclusively to mobile devices.\n <p>\n This information is "circa 2023" and may not apply to all devices.\n <p>',flags:"IR",name:"capture"},"attr:CubeGrid.dataSource":{seeAlso:[],ref:"attr:CubeGrid.dataSource",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:CubeGrid",valueType:"DataSource | ID",description:"DataSource to use to fetch CubeGrid data.\n <p>\n The DataSource should have a field named after each facetId.  The CubeGrid will submit\n requests for data as DataSource \"fetch\" operations that request \n ${isc.DocUtils.linkForRef('object:CellRecord','cellRecords')} only for currently visible area\n (including ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio','drawAheadRatio')}).  The ${isc.DocUtils.linkForRef('type:Criteria')} passed\n in each fetch operation will be a ${isc.DocUtils.linkForRef('object:FacetValueMap')} that corresponds to a rectangular\n swath of cells the CubeGrid needs data for, for example:<pre>\n      { region:\"west\", product:[\"chair\", \"table\"], timePeriod:\"Q1 2004\" }\n </pre>\n Note that in the criteria above, the Array value for the \"product\" facet indicates the\n CubeGrid needs cellRecords for both the \"chair\" and \"table\" facetValues.\n <P>\n ${isc.DocUtils.linkForRef('attr:CubeGrid.fixedFacetValues')}, if any, are always sent in each \"fetch\" operation.\n <P>\n Scrolling, expanding/collapsing tree facets, pivoting, and changing the currently\n visible facets may all trigger data requests.\n <P>\n The CubeGrid will generally attempt to fetch a minimal set of data to fill the viewport,\n sending multiple fetch operations in a batch (via ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','queueing')})\n which minimally describe newly revealed areas without specifying each individual cell.\n The CubeGrid will automatically handle being provided <i>more</i> data than was asked\n for, so server-side fetch-ahead policies can be implemented without any client-side\n customization.\n <P>\n Note that the ${isc.DocUtils.linkForRef('attr:DataSource.serverType','SQL connector')} shipped with the SmartClient\n SDK is capable of responding to the CubeGrid's data requests without writing any custom\n server code.",flags:"IR",name:"dataSource"},"group:columnControls":{refs:["method:CubeGrid.closeFacet","method:CubeGrid.closeColumn","method:CubeGrid.sortByFacetValues","method:CubeGrid.sortByFacetId"],seeAlso:[],ref:"group:columnControls",deprecated:null,type:"group",description:null,name:"columnControls"},"attr:DetailViewerField.valueMap":{seeAlso:[],ref:"attr:DetailViewerField.valueMap",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DetailViewerField",valueType:"Object",description:"A property list (or an expression that evaluates to a property list)\n specifying a mapping of internal values to display values for the field (row).",flags:"IR",name:"valueMap"},"attr:Calendar.dataSource":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Calendar",groups:["databinding"],ref:"attr:Calendar.dataSource",deprecated:null,valueType:"DataSource | ID",description:"The DataSource that this component should bind to for default fields and for performing\n ${isc.DocUtils.linkForRef('object:DSRequest','DataSource requests')}.\n <P>\n Can be specified as either a DataSource instance or the String ID of a DataSource.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('dataSourceFields')}"],name:"dataSource"},"attr:FacetChart.showValueOnHover":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["appearance"],deprecated:"in favor of ${isc.DocUtils.linkForRef('attr:FacetChart.showDataValuesMode')}, a compound setting that supports showing data-values in the chart and in hovers in various combinations.  The\n equivalent to <i>showValueOnHover:true</i> is ShowDataValuesMode.inHoverOnly.",ref:"attr:FacetChart.showValueOnHover",valueType:"boolean",description:"Shows the value of the nearest data value in a floating label whenever the mouse moves\n within the main chart area.  The visual element representing the data\n value will also be emphasized by brightening or highlighting it (appearance differs by\n chart type).\n <p>\n Calculates nearest value based on ${isc.DocUtils.linkForRef('method:FacetChart.getNearestDrawnValue')}.\n <p>\n The data value will be formatted using ${isc.DocUtils.linkForRef('method:FacetChart.formatDataValue')}.\n The label's appearance is controlled by ${isc.DocUtils.linkForRef('attr:FacetChart.hoverLabelProperties')}.",flags:"IR",name:"showValueOnHover"},"method:ResultSet.filterLocalData":{seeAlso:[],ref:"method:ResultSet.filterLocalData",deprecated:null,type:"method",definingClass:"class:ResultSet",description:" Derive the current filtered set of data from the cache of all matching rows.\n <P>\n This method is automatically called by ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria')} when criteria have actually\n changed, as well as in various other situations.  You could only need to call this method\n directly if:\n <ul>\n <li> you know that client-side filtering is enabled (${isc.DocUtils.linkForRef('attr:ResultSet.useClientFiltering')}:true) and\n active ${isc.DocUtils.linkForRef('method:ResultSet.allMatchingRowsCached')}.\n <li> you have directly, programmatically modified data within the ResultSet such that it no\n longer matches the filter criteria\n <li> you want your modified records to disappear from the list of visible records (that is,\n those accessible via ${isc.DocUtils.linkForRef('method:ResultSet.get')})\n </ul>\n \n",flags:"A",name:"filterLocalData"},"attr:ImgTab.skinImgDir":{seeAlso:[],ref:"attr:ImgTab.skinImgDir",defaultValue:'"images/Tab/"',deprecated:null,type:"attr",definingClass:"class:ImgTab",valueType:"URL",description:"Base path for the images.   <B>Note</B> that when used within a TabSet, the\n ${isc.DocUtils.linkForRef('attr:TabSet.tabBarPosition')} is appended as an additional path segment, yielding\n \"images/Tab/top/\" et al.",flags:"IRW",name:"skinImgDir"},"attr:Canvas.opacity":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["cues"],ref:"attr:Canvas.opacity",deprecated:null,setter:["setOpacity"],valueType:"number",description:"Renders the widget to be partly transparent. A widget's opacity property may\n      be set to any number between 0 (transparent) to 100 (opaque).\n      Null means don't specify opacity directly, 100 is fully opaque.\n      Note that heavy use of opacity may have a performance impact on some older\n      browsers.\n      <P>\n      In older versions of Internet Explorer (Pre IE9 / HTML5), opacity is achieved\n      through proprietary filters. If\n      ${isc.DocUtils.linkForRef('classAttr:Canvas.neverUseFilters','filters have been disabled')} within this application\n      developers must set ${isc.DocUtils.linkForRef('attr:Canvas.useOpacityFilter')} to true for specific components\n      on which opacity support is required.\n      <P>\n      Also note that opacity is incompatible\n      with ${isc.DocUtils.linkForRef('attr:Canvas.useBackMask','backMasks')}.",flags:"IRWA",name:"opacity"},"attr:DetailViewerField.imageURLSuffix":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DetailViewerField",groups:["imageColumns"],deprecated:null,ref:"attr:DetailViewerField.imageURLSuffix",valueType:"String",description:'If this field has type set to <code>"image"</code>, the value\n of this property will be appended to the end of the URL for the icon displayed.',flags:"IRWA",name:"imageURLSuffix"},"attr:Label.iconWidth":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Label",groups:["buttonIcon"],deprecated:null,ref:"attr:Label.iconWidth",valueType:"Integer",description:"Width in pixels of the icon image.\n <P>\n If unset, defaults to ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconSize','iconSize')}.",flags:"IR",name:"iconWidth"},"classMethod:Page.getAppFilesDir":{groups:["files","images"],seeAlso:[],ref:"classMethod:Page.getAppFilesDir",deprecated:null,type:"classMethod",definingClass:"class:Page",params:[{defaultValue:null,optional:true,type:"String",description:"New app files URL.",name:"URL"}],description:" Returns the directory for application-specific files (other than images).\n\n",flags:"",name:"getAppFilesDir"},"group:gridValidation":{refs:["method:ListGrid.validateRow","method:ListGrid.validateCell","method:ListGrid.getRequiredFieldMessage","method:ListGrid.hasErrors","method:ListGrid.rowHasErrors","method:ListGrid.cellHasErrors","method:ListGrid.getRowErrors","method:ListGrid.getCellErrors","method:ListGrid.setFieldError","method:ListGrid.setRowErrors","method:ListGrid.clearFieldError","attr:ListGridField.validators","attr:ListGridField.validateOnChange","attr:ListGridField.required","attr:ListGrid.validateByCell","attr:ListGrid.validateOnChange","attr:ListGrid.neverValidate"],seeAlso:[{ref:"group:editing",description:null}],ref:"group:gridValidation",deprecated:null,type:"group",description:"ListGrids support automatic validation of edited cells / records. This group is a collection\n of APIs related to the validation subsystem.\n <p>\n Default validation occurs in response to the user navigating between edit cells\n (see ${isc.DocUtils.linkForRef('attr:ListGrid.validateByCell')}) or whenever edited values are to be committed to the\n server for saving.  Standard validation can also be triggered for a cell or row programmatically at\n any time.<br>\n When standard validation occurs, ${isc.DocUtils.linkForRef('attr:ListGridField.validators')} will be run on each\n cell to be validated.<br>\n In addition to this standard behavior developers can add custom errors to fields\n via ${isc.DocUtils.linkForRef('method:ListGrid.setFieldError')} / ${isc.DocUtils.linkForRef('method:ListGrid.setFieldError')}.",name:"gridValidation"},"classMethod:Canvas.resizeControlsTo":{seeAlso:[],ref:"classMethod:Canvas.resizeControlsTo",deprecated:null,type:"classMethod",definingClass:"class:Canvas",params:[{defaultValue:null,optional:false,type:"int",description:"the final size, expressed as a differential from the default",name:"targetDelta"}],description:" Resizes controls as if calling ${isc.DocUtils.linkForRef('classMethod:Canvas.resizeControls')}, but takes a final target size\n instead of a delta representing the change from a current size.  Note that all the same\n limitations apply.\n",flags:"",name:"resizeControlsTo"},"group:elements":{refs:["method:DynamicForm.setItems","method:DynamicForm.setFields","method:DynamicForm.getFields","method:DynamicForm.getItems"],seeAlso:[],ref:"group:elements",deprecated:null,type:"group",description:"Manipulating native form elements",name:"elements"},"attr:CubeGrid.bodyMinWidth":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:CubeGrid",groups:["gridLayout"],deprecated:null,ref:"attr:CubeGrid.bodyMinWidth",valueType:"number",description:"Minimum width for the body of this cubeGrid.",flags:"IRWA",name:"bodyMinWidth"},"method:DrawItem.setLineWidth":{seeAlso:[],ref:"method:DrawItem.setLineWidth",deprecated:null,type:"method",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:false,type:"int",description:"new pixel lineWidth",name:"width"}],description:" Update lineWidth for this drawItem.\n",flags:"",name:"setLineWidth"},"classAttr:RPCResponse.STATUS_AUTHORIZATION_FAILURE":{seeAlso:[{ref:"object:RPCRequest",description:null}],defaultValue:"-3",type:"classAttr",definingClass:"class:RPCResponse",groups:["statusCodes","constant"],deprecated:null,ref:"classAttr:RPCResponse.STATUS_AUTHORIZATION_FAILURE",valueType:"int",description:"Indicates a ${isc.DocUtils.linkForRef('group:declarativeSecurity','Declarative Security')} failure on the server.\n See the error handling section in ${isc.DocUtils.linkForRef('class:RPCManager','RPCManager documentation')}\n for more information.",flags:"R",name:"STATUS_AUTHORIZATION_FAILURE"},"method:IMenuButton.setShowMenuBelow":{groups:["menu"],seeAlso:[],ref:"method:IMenuButton.setShowMenuBelow",deprecated:null,type:"method",definingClass:"class:IMenuButton",params:[{defaultValue:null,optional:false,type:"boolean",description:"True if the menu should be shown below the <code>MenuButton</code>.",name:"below"}],description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the <code>MenuButton</code>.\n",flags:"",name:"setShowMenuBelow"},"group:fields":{refs:["type:DSInheritanceMode","attr:DataSource.fields","attr:DataSource.inheritsFrom","attr:DataSource.addedAuditFields","attr:DataSource.inheritanceMode","attr:DataSource.useFlatFields","attr:DataSource.showLocalFieldsOnly","attr:DataSource.useParentFieldOrder","attr:DataSource.autoDeriveSchema","attr:DataSource.schemaBean","attr:DataSource.idClassName"],seeAlso:[],ref:"group:fields",deprecated:null,type:"group",description:null,name:"fields"},"method:Canvas.getViewportWidth":{groups:["sizing"],seeAlso:[],ref:"method:Canvas.getViewportWidth",deprecated:null,type:"method",definingClass:"class:Canvas",description:" Returns the width of the viewport onto the scrollable content.\n <P>\n See ${isc.DocUtils.linkForRef('group:gettingCanvasSize')}\n\n",flags:"A",returns:{type:"number",description:"width of the viewport, in pixels"},name:"getViewportWidth"},"classAttr:RPCManager.timeoutErrorMessage":{seeAlso:[{ref:"classAttr:RPCManager.defaultTimeout",description:null}],defaultValue:'"Operation timed out"',type:"classAttr",definingClass:"class:RPCManager",groups:["i18nMessages"],deprecated:null,ref:"classAttr:RPCManager.timeoutErrorMessage",valueType:"HTMLString",description:"Default message displayed to user when an operation fails to return from the server within\n the timeout period specified by ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTimeout')}.",flags:"IRW",name:"timeoutErrorMessage"},"attr:TileGrid.implicitCriteria":{seeAlso:[],ref:"attr:TileGrid.implicitCriteria",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TileGrid",valueType:"Criteria",description:"Criteria that are never shown to or edited by the user and are cumulative with any criteria\n provided via ${isc.DocUtils.linkForRef('attr:DataBoundComponent.initialCriteria')} and related methods.\n <p>\n This property supports ${isc.DocUtils.linkForRef('group:dynamicCriteria')} - use ${isc.DocUtils.linkForRef('attr:Criterion.valuePath')}\n to refer to values in the ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope')}.",flags:"IRW",name:"implicitCriteria"},"attr:DrawPolygon.knobs":{seeAlso:[{ref:"attr:DrawItem.knobs",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DrawPolygon",deprecated:null,ref:"attr:DrawPolygon.knobs",valueType:"Array of KnobType",description:'DrawPolygon only supports the\n "move"\n \n knob type.',flags:"IR",examples:["${isc.DocUtils.linkForExampleId('editDrawPane')}","${isc.DocUtils.linkForExampleId('drawKnobs')}"],name:"knobs"},"attr:FormItem.valueIconWidth":{seeAlso:[{ref:"attr:FormItem.valueIconHeight",description:null},{ref:"attr:FormItem.valueIconSize",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["valueIcons"],deprecated:null,ref:"attr:FormItem.valueIconWidth",valueType:"number",description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is specified, use this property to specify a width for\n the value icon written out.",flags:"IRW",name:"valueIconWidth"},"attr:SliderItem.vertical":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:SliderItem",deprecated:null,ref:"attr:SliderItem.vertical",valueType:"Boolean",description:"Indicates whether this is a vertical or horizontal slider.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('slider')}"],name:"vertical"},"method:DynamicForm.getValuesAsAdvancedCriteria":{seeAlso:[],type:"method",definingClass:"class:DynamicForm",returns:{type:"AdvancedCriteria",description:"a ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} based on the form's current values"},groups:["criteriaEditing"],deprecated:null,ref:"method:DynamicForm.getValuesAsAdvancedCriteria",params:[{defaultValue:null,optional:true,type:"TextMatchStyle",description:"If specified the text match style will be used to   generate the appropriate <code>operator</code> for per field criteria.",name:"textMatchStyle"}],description:" Return an AdvancedCriteria object based on the current set of values within this form.\n <p>\n Similar to ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}, except the returned criteria object\n is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a\n specified ${isc.DocUtils.linkForRef('attr:FormItem.operator')}\n\n",flags:"",name:"getValuesAsAdvancedCriteria"},"method:ListGrid.saveAllEdits":{seeAlso:[],type:"method",definingClass:"class:ListGrid",returns:{type:"boolean",description:"true if a save has been initiated (at least one row had changes, passed                   client-side validation, and a save has been attempted).  False otherwise"},groups:["editing"],deprecated:null,ref:"method:ListGrid.saveAllEdits",params:[{defaultValue:null,optional:true,type:"Array of Number",description:"optionally specify which rows to save",name:"rows"},{defaultValue:null,optional:true,type:"Callback",description:"If specified this callback will be fired on a successful save  of the specified rows. Note that if there are no pending edits to be saved this callback will\n  not fire - you can check for this condition using ${isc.DocUtils.linkForRef('method:ListGrid.hasChanges')} or\n  ${isc.DocUtils.linkForRef('method:ListGrid.rowHasChanges')}.  Use ${isc.DocUtils.linkForRef('method:ListGrid.editFailed')} to find out about failures\n  encountered during saving (on a per-row basis).",name:"saveCallback"}],description:" Save a number of outstanding edits for this ListGrid. If no rows are specified, all\n outstanding edits will be saved.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:ListGrid.saveRequestProperties')} is specified and the grid is performing\n a databound save, these properties will be applied to each generated DSRequest.\n\n",flags:"",name:"saveAllEdits"},"attr:Layout.minMemberLength":{seeAlso:[{ref:"attr:Canvas.minWidth",description:null}],defaultValue:"1",type:"attr",definingClass:"class:Layout",groups:["layoutPolicy"],deprecated:null,ref:"attr:Layout.minMemberLength",valueType:"int",description:"Minimum size, in pixels, below which flexible-sized members should never be shrunk, even\n if this requires the Layout to overflow.  Note that this property only applies along\n the <i>length</i> axis of the Layout, and has no affect on <i>breadth</i>.\n <p>\n Does not apply to members given a fixed size in pixels - such members will never be\n shrunk below their specified size in general.",flags:"IRW",name:"minMemberLength"},"attr:SavedSearchForm.overflow":{seeAlso:[],ref:"attr:SavedSearchForm.overflow",defaultValue:"Canvas.VISIBLE",deprecated:null,type:"attr",definingClass:"class:SavedSearchForm",valueType:"Overflow",description:"SavedSearchForms are sized to fit their single item by default",flags:"IRW",name:"overflow"},"method:Array.removeIndex":{seeAlso:[],type:"method",definingClass:"object:Array",returns:{type:"Array",description:"this array (for chaining)"},groups:["indexing"],deprecated:null,ref:"method:Array.removeIndex",params:[{defaultValue:null,optional:false,type:"String",description:"Name of the indexed property to remove",name:"property"}],description:" Remove a property index created by ${isc.DocUtils.linkForRef('method:Array.createIndex')}.\n This frees the memory used by the index. After removal, find operations on this property\n will revert to O(n) linear scans.\n\n",flags:"",name:"removeIndex"},"attr:FacetChart.maxBarThickness":{seeAlso:[{ref:"method:FacetChart.getMinClusterSize",description:null}],defaultValue:"150",type:"attr",definingClass:"class:FacetChart",groups:["barChart"],deprecated:null,ref:"attr:FacetChart.maxBarThickness",valueType:"int",description:"Bars will not be drawn over this thickness, instead, margins will be increased.",flags:"IR",name:"maxBarThickness"},"attr:ListGrid.criteriaIndicatorColor":{seeAlso:[],ref:"attr:ListGrid.criteriaIndicatorColor",defaultValue:'"#33AAFF"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"String",description:"The color of the ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterWindowCriteriaIndicator','filterWindow criteria indicator')}.",flags:"IR",name:"criteriaIndicatorColor"},"classAttr:AutoTest.implicitNetworkWait":{seeAlso:[],defaultValue:"false",type:"classAttr",definingClass:"class:AutoTest",groups:["autoTest"],deprecated:null,ref:"classAttr:AutoTest.implicitNetworkWait",valueType:"boolean",description:"Controls whether certain AutoTest APIs wait for network operations to complete\n before returning true.  When value is true, ${isc.DocUtils.linkForRef('classMethod:AutoTest.isElementClickable')}\n will return false until all network operations have completed.",flags:"IRW",name:"implicitNetworkWait"},"attr:Canvas.updateTabPositionOnReparent":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:Canvas",deprecated:null,ref:"attr:Canvas.updateTabPositionOnReparent",setter:["setUpdateTabPositionOnReparent"],valueType:"boolean",description:"Should canvases with a ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas','parent canvas')} be added to\n the TabIndexManager under the parent as described in ${isc.DocUtils.linkForRef('method:Canvas.updateChildTabPositions')} and\n ${isc.DocUtils.linkForRef('method:Canvas.updateChildTabPosition')}?\n <P>\n If set to false, the tab-position will not be modified on parent change.\n <P>\n This property is useful for cases where the tab position of a widget will be managed\n by something other than the parent canvas, for example for \n ${isc.DocUtils.linkForRef('attr:CanvasItem.canvas','canvasItem canvases')}.",flags:"IRWA",name:"updateTabPositionOnReparent"},"classMethod:DrawItem.computeAngle":{seeAlso:[],ref:"classMethod:DrawItem.computeAngle",deprecated:null,type:"classMethod",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:false,type:"double",description:"X coordinate of <b>v</b><sub>1</sub>",name:"px1"},{defaultValue:null,optional:false,type:"double",description:"Y coordinate of <b>v</b><sub>1</sub>",name:"py1"},{defaultValue:null,optional:false,type:"double",description:"X coordinate of <b>v</b><sub>2</sub>",name:"px2"},{defaultValue:null,optional:false,type:"double",description:"Y coordinate of <b>v</b><sub>2</sub>",name:"py2"}],description:" Computes the angle in degrees from the positive X axis to the difference vector\n <nobr><b>v</b><sub>2</sub> - <b>v</b><sub>1</sub></nobr> between the two given vectors.\n",flags:"",returns:{type:"double",description:"the angle in degrees, in the range [0, 360)."},name:"computeAngle"},"method:ListGridField.formatCellValue":{seeAlso:[{ref:"method:ListGrid.formatCellValue",description:null},{ref:"method:ListGridField.formatEditorValue",description:null}],type:"method",definingClass:"object:ListGridField",returns:{type:"HTMLString",description:"HTML to display in the cell"},groups:["display_values"],ref:"method:ListGridField.formatCellValue",deprecated:"",params:[{defaultValue:null,optional:false,type:"Any",description:"raw value for the cell, from the record for the row",name:"value"},{defaultValue:null,optional:false,type:"ListGridRecord",description:"Record object for the cell. Note: If this is a new row that has not been saved, in an\n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter (see ${isc.DocUtils.linkForRef('method:ListGrid.getEditValues')})",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number for the cell.",name:"colNum"},{defaultValue:null,optional:false,type:"ListGrid",description:"the ListGrid displaying the cell",name:"grid"}],description:" Return the HTML to display in cells of this field.\n <P>\n Given the raw value for this field as taken from the record Formatter to apply to the\n static values displayed in cells for this field.\n <P>\n <i>Example usage</i>: formatting a currency value stored in cents (so \"100\" to \"$1.00\")<br>\n The value passed to this method is the raw value for the cell.<br>\n Takes precedence over <code>formatCellValue</code> defined at the grid level for cells\n in this field.\n <P>\n Note: this formatter will not be applied to the values displayed in cells being edited.\n The ${isc.DocUtils.linkForRef('method:ListGridField.formatEditorValue','formatEditorValue()')} is provided for that purpose.\n\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('formatValues')}"],name:"formatCellValue"},"method:ListGrid.setHideOnTablet":{seeAlso:[],ref:"method:ListGrid.setHideOnTablet",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"ListGridField | String",description:"field or field name to update",name:"field"},{defaultValue:null,optional:false,type:"Boolean",description:"new setting for hideOnTablet property",name:"hideOnTablet"}],description:" Updates the ${isc.DocUtils.linkForRef('attr:ListGridField.hideOnTablet')} attribute at runtime.\n",flags:"",name:"setHideOnTablet"},"classAttr:Canvas.CLIP_H":{seeAlso:[],defaultValue:'"clip-h"',type:"classAttr",definingClass:"class:Canvas",deprecated:null,ref:"classAttr:Canvas.CLIP_H",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:Overflow','Overflow')}.",flags:"R",name:"CLIP_H",constant:true},"attr:FieldPicker.removeText":{seeAlso:[],defaultValue:'"You are about to remove the field. Are you sure?"',type:"attr",definingClass:"class:FieldPicker",groups:["i18nMessages"],deprecated:null,ref:"attr:FieldPicker.removeText",valueType:"String",description:null,flags:"IR",name:"removeText"},"attr:AIProgressMessage.content":{seeAlso:[],ref:"attr:AIProgressMessage.content",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:AIProgressMessage",valueType:"HTMLString",description:"The content of the message.",flags:"IR",name:"content"},"attr:DataSource.sqlPaging":{seeAlso:[{ref:"attr:OperationBinding.sqlPaging",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DataSource",deprecated:null,ref:"attr:DataSource.sqlPaging",valueType:"SQLPagingStrategy",description:"The paging strategy to use for this DataSource.  If this property is not set, the \n default paging strategy, specified with the ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}\n setting <code>sql.defaultPaging</code>, is used.  \n <p>\n This setting can be overridden with the ${isc.DocUtils.linkForRef('attr:OperationBinding.sqlPaging')} property.\n <P>\n <b>NOTE:</b> Operations that involve a ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL','customSQL')} \n clause ignore this property, because customSQL operations usually need to be treated\n as special cases.  For these operations, the paging strategy comes from the \n ${isc.DocUtils.linkForRef('group:server_properties','server.properties')} setting\n <code>sql.defaultCustomSQLPaging</code> or \n <code>sql.defaultCustomSQLProgressivePaging</code>, depending on whether or not \n ${isc.DocUtils.linkForRef('attr:DataSource.progressiveLoading','progressiveLoading')} is in force.  Note that these\n can always be overridden by a <code>sqlPaging</code> setting on the OperationBinding.",flags:"IRW",serverDS:"only",name:"sqlPaging"},"attr:FormSaveDataTask.unboundNotifyMessage":{seeAlso:[],defaultValue:'"Saved successfully"',type:"attr",definingClass:"class:FormSaveDataTask",groups:["i18nMessages"],deprecated:null,ref:"attr:FormSaveDataTask.unboundNotifyMessage",valueType:"String",description:"The default message to be shown when a target form is not bound to a DataSource.",flags:"IR",name:"unboundNotifyMessage"},"group:loadISCTag":{refs:[],seeAlso:[],ref:"group:loadISCTag",requiresModules:["SCServer"],treeLocation:["Java Server Reference/SmartClient JSP Tags"],deprecated:null,type:"group",title:"&lt;isomorphic:loadISC&gt;",description:'See ${isc.DocUtils.linkForRef(\'group:jspTags\')}\n <P>\n <i>produces:</i> HTML\n <p>\n This tag sets window.isomorphicDir and loads a default set of SmartClient modules and a\n skin.  SmartClient modules are JavaScript files that need to be loaded via \n <code>&lt;SCRIPT SRC=/some/filename.js&gt;&lt;/SCRIPT&gt;</code>\n blocks as part of the loading HTML page.\n These and ${isc.DocUtils.linkForRef(\'group:loadingOptionalModules\',\'optional\')} modules are stored in the\n <code>[webroot]/isomorphic/system/modules</code>\n directory.  A skin defines the look and feel of your\n website and typically consists of at least one CSS file and some SmartClient UI Component\n default overrides.  Skins are located in <code>[webroot]/isomorphic/skins</code>.  Loading a skin\n consists of loading the corresponding <code>load_skin.js</code> - residing at top-level in\n each skin directory.\n <p>\n The default set of modules loaded by this tag are: \n <code>Core, Foundation, Containers, Grids, Forms, Drawing, DataBinding, Calendar</code>.<br>\n The default skin is the <code>Tahoe</code> skin.<br>\n So, for example inserting this into your JSP:\n <pre>\n &lt;isomorphic:loadISC/&gt;\n </pre>\n Produces the output like:\n <pre>\n &lt;SCRIPT&gt;window.isomorphicDir=\'isomorphic/\';&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Core.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Foundation.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Containers.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Grids.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Forms.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Drawing.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_DataBinding.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Calendar.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT src=isomorphic/skins/Tahoe/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n <i>(Note: The output you see may differ slightly from the above. The isomorphicDir will be set to\n an appropriate value based on the location of the file in the file system, and the target\n URLs for resources may include version information as described in the <b>versionStyle</b> \n attribute details below.)</i>\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>skin</b><br>\n <i>value format</i>: Name of skin to load.  See the <code>[webroot]/isomorphic/skins</code> directory\n for a list of available skins.  You can also create your own skin by copying an existing\n skin directory recursively, modifying anything you need, and using your new skin name as the\n value here.<br>\n <i>default value</i>: "Tahoe"\n <p>\n This selects a skin other than the default.  The value of this attribute is used as a path\n component to <code>load_skin.js</code>.  For example, specifying:\n <pre>\n &lt;isomorphic:loadISC skin="Stratus"/&gt;\n </pre>\n Produces the following <code>load_skin.js</code> directive (in addition to all the standard\n module loads):\n <pre>\n &lt;SCRIPT src=isomorphic/skins/Stratus/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n <p>\n <b>versionStyle</b><br>\n <i>value format</i>: one of "param", "pathSegment" or "none"<br>\n <i>default value</i>: "param"\n <p>\n By default the URLs generated by a <code>loadISC</code> tag include version information.\n This ensures that the browser will reliably fetch new resources each time a new version\n of SmartClient is loaded, even if the browser has been instructed to cache these files\n indefinitely.\n <p>\n ${isc.DocUtils.linkForRef(\'group:server_properties\',\'The default setting of <code>"param"</code>\')} appends a URL parameter of the format \n "<code>?isc_version=<i>SmartClient_Version</i></code>" to each of the <code>&lt;SCRIPT SRC=... &gt;</code>\n tags used to load the framework.\n <p>\n The alternative setting of <code>"pathSegment"</code> instead adds a new segment to the\n URL path of the format "<code>isc_version.<i>SmartClient_Version</i></code>".\n The <code>"isc_version."</code> prefix is derived from the\n ${isc.DocUtils.linkForRef(\'group:server_properties\',\'isc.versionPathSegmentPrefix in server.properties\')}.\n The versioned path-segment will always\n be added after the isomorphicDir, so the generated output might look like this:\n <pre>\n &lt;SCRIPT&gt;window.isomorphicDir=\'isomorphic/isc_version.<i>version</i>\';&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/isc_version.<i>version</i>/system/modules/ISC_Core.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/isc_version.<i>version</i>/system/modules/ISC_Foundation.js&gt;&lt;/SCRIPT&gt;\n ... etc\n </pre>\n Note that the <code>"param"</code> setting ensures that the browser will request new\n versions of the SmartClient JavaScript libraries, but does not ensure that other resources\n such as CSS and images under the skin directory will be re-fetched. The <code>"pathSegment"</code>\n setting ensures the browser will request new versions of all SmartClient resources.\n In order to support this, the SmartClient resources must be made available at the generated\n URLs. The server side FileDownload servlet, or the dedicated VersionedURLFilter filter\n will automatically handle stripping out SmartClient-version path segments - see the server\n side JavaDocs for details.\n <P>\n For more information on caching of resources see the ${isc.DocUtils.linkForRef(\'group:caching\',\'caching overview\')}.\n <p>\n <b>skinDir</b><br>\n <i>value format</i>: path or URL up to and including the name of the skin<br>\n <i>default value</i>: automatically derived from the value of the <code>skin</code>\n attribute\n <p>\n This attribute is usable in lieu of the <code>skin</code> attribute and allows you to\n specify the full path or URL to the directory containing the load_skin.js for your skin.\n This allows you to move the directory containing the skin anywhere you want - including to a\n completely different server.\n <p>\n <b>includeModules</b><br>\n <i>value format</i>: Comma separated list of additional modules to load.  See the\n <code>[webroot]/isomorphic/system/modules</code> directory for a list of loadable modules.  The\n leading "ISC_" is optional, spaces after commas are also optional.<br>\n <i>default value</i>: NONE\n <p>\n This attribute allows you to specify SmartClient modules that you want to load in addition\n to the default set of modules. For example, specifying:\n <pre>\n &lt;isomorphic:loadISC includeModules="Analytics"/&gt;\n </pre>\n Will add a tag to load the module to the generated block of <code>SCRIPT</code> tags\n described above:\n <pre>\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Analytics.js&gt;&lt;/SCRIPT&gt;\n </pre>\n SmartClient modules must be loaded in a particular order and may have dependencies on \n other modules.\n The <code>loadISC</code> automatically resolves any missing dependencies and includes them\n in the list of modules to load.  The list of modules to load is also automatically reordered\n as required by this tag, so you can specify just the modules you care about, in any order,\n and <code>loadISC</code> will do the right thing.<br>\n The skin will always be loaded after all modules.\n <p>\n <b>modules</b><br>\n <i>value format</i>: Comma separated list of modules to load.  See the\n <code>[webroot]/isomorphic/system/modules</code> directory for a list of loadable modules.  The\n leading "ISC_" is optional, spaces after commas are also optional.<br>\n <i>default value</i>: <code>"Core,Foundation,Containers,Grids,Forms,Drawing,DataBinding,Calendar"</code>\n <p>\n Specifying this attribute overrides the default set of modules loaded by\n <code>loadISC</code>. This is useful if you don\'t need to load all of the default modules on\n a particular page.\n <p>\n <b>locale</b><br>\n <i>value format</i>: String - name of locale to load\n <i>default value</i>: null\n <p>\n Use this attribute to specify a locale to load.  The default value of null omits locale\n loading, which effectively means the framework default "en" locale is used.  Note that if\n you\'re using a mix of <code>loadISC</code> and <code>loadModules</code> tags, or multiple\n <code>loadModules</code> tags, the right place to specify this attribute is on the last\n <code>loadModules</code> tag.\n <p>\n <b>isomorphicURI</b><br>\n <i>value format</i>: absolute or relative (from current URI) path to the\n <code>isomorphic</code> directory (by default, located in webRoot).<br>\n <i>default value</i>: automatically derived\n <p>\n This value sets <code>window.isomorphicDir</code> and defines the base path to SmartClient\n modules from the currently executing JSP.  By default, this value is automatically derived\n and you don\'t need to override it.  Generally, an override is only required if you\'re\n pointing multiple web application deployments at one base URL for cache coherence reasons.\n <p>\n <b>defer</b><br>\n <i>value format</i>: boolean - acceptable values: "true" or "false"<br>\n <i>default value</i>: "false"\n <p>\n This attribute applies only if you\'re using the optional Network Performance component of\n SmartClient.  By default, the modules specified by the <code>loadISC</code> tag are loaded\n synchronously - that is, the browser waits for each module to download before rendering\n any HTML on the page.  Specifying <code>defer="true"</code> makes the module load\n asynchronous.  In this mode, all the page content except the modules specified by\n <code>loadISC</code> is loaded and rendered first, and then the SmartClient modules are\n loaded.  The asynchronous mode makes it possible to render some content and allow the user\n to interact with the site immediately, while SmartClient modules load in the background.\n <p>\n Note that typically SmartClient modules are delivered compressed with cache headers, so the\n download delay really only affects first time users of your site, those whose cached\n versions have expired, or if you\'ve upgraded your SmartClient module to a newer version that\n the user has cached.\n <p>\n Using this directive is equivalent to calling ${isc.DocUtils.linkForRef(\'classMethod:FileLoader.load\')}.\n <p>\n <b>cacheOnly</b><br>\n <i>value format</i>: boolean - acceptable values: "true" or "false"<br>\n <i>default value</i>: "false"\n <p>\n This attribute applies only if you\'re using the optional Network Performance component of\n SmartClient.  This works like <code>defer</code> (see above), except that the modules are\n only loaded into the browser cache, but not executed.  This means that when the specified\n modules download, they\'ll be added to the browser cache, but will not be available to the\n execution context of the page.  Actually executing the module code takes some processing\n time on the client, whereas simply caching it does not.  The typical use case for this\n directive is on some intermediary page before the user gets to a SmartClient-enabled page.\n For example, you could include a cacheOnly <code>loadISC</code> tag on a login page that\n does not use SmartClient components, but protects a SmartClient-enabled application.  While\n the user is typing in their credentials, the SmartClient modules will cache in the\n background, then once the user logs in and is sent to a SmartClient-enabled page, the\n modules are simply read from cache.\n <p>\n Using this directive is equivalent to calling ${isc.DocUtils.linkForRef(\'classMethod:FileLoader.cache\')}.\n <p>\n <b>onload</b><br>\n <i>value format</i>: String - any javascript code<br>\n <i>default value</i>: NONE\n <p>\n This attribute applies only if you\'re using the optional Network Performance component of\n SmartClient.  This attribute is usable in conjunction with <code>defer</code> and\n <code>cacheOnly</code> attributes.  This attribute allows you to specify a callback to\n execute when loading or caching of the specified modules has completed.  You can use this\n to, for example, replace portions of the page with SmartClient components once SmartClient\n has loaded.\n <p>\n The value of this attribute is passed as the <code>onload</code> handler to the generated\n ${isc.DocUtils.linkForRef(\'classMethod:FileLoader.cache\')} or ${isc.DocUtils.linkForRef(\'classMethod:FileLoader.load\')} call as appropriate.\n <p>\n <b>useSimpleNames</b><br>\n <i>value format</i>: boolean - acceptable values: "true" or "false"<br>\n <i>default value</i>: "true"\n <p>\n Setting this attribute to false puts SmartClient in namespace mode.  See ${isc.DocUtils.linkForRef(\'object:isc\')}\n for more info.',name:"loadISCTag"},"method:Canvas.dragMove":{seeAlso:[{ref:"method:Canvas.getOffsetX",description:null},{ref:"method:Canvas.getOffsetY",description:null}],type:"method",definingClass:"class:Canvas",returns:{type:"Boolean",description:"false to cancel drag interaction."},groups:["widgetEvents"],deprecated:null,ref:"method:Canvas.dragMove",description:" Executed every time the mouse moves while dragging this canvas.\n\n",flags:"A",examples:["${isc.DocUtils.linkForExampleId('dragPan')}"],name:"dragMove"},"method:SectionStack.addItem":{seeAlso:[],ref:"method:SectionStack.addItem",deprecated:null,type:"method",definingClass:"class:SectionStack",params:[{defaultValue:null,optional:false,type:"String | Number",description:"ID or index of the section to add item to",name:"section"},{defaultValue:null,optional:false,type:"Canvas",description:"Item to insert into the section",name:"item"},{defaultValue:null,optional:false,type:"Number",description:"Index into section to insert item",name:"index"}],description:" Add a canvas as an item to a section.\n",flags:"",name:"addItem"},"attr:BatchUploader.uploadFileItem":{seeAlso:[],ref:"attr:BatchUploader.uploadFileItem",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:BatchUploader",valueType:"AutoChild FileItem",description:"FileItem for selecting the file to upload.",flags:"IR",name:"uploadFileItem"},"group:javaModuleDependencies":{refs:[],seeAlso:[],ref:"group:javaModuleDependencies",treeLocation:["Concepts/Deploying SmartClient"],deprecated:null,type:"group",title:"Java Module Dependencies",description:'Note that if you are using GWT, GWT itself also has an Apache 2.0 license, however tools and\n test environments that you may use during development have different license (such as\n Eclipse - Eclipse Public License).  Also, specific GWT widgets, not required by Smart GWT, \n have licenses different from core GWT (such as JFreeChart\'s LGPL license).  See \n <a href=\'http://code.google.com/webtoolkit/terms.html\' target=\'_blank\'>Google\'s summary of terms</a> for\n details.\n <p>\n If you are using ${isc.DocUtils.linkForRef(\'group:serverScript\',\'server scripting\')} with the Javascript language,\n dependencies are JVM-specific.  Java versions earlier than 6 do not include JSR223 support \n at all, so server scripting is not an option with those JVMs.  Versions of the Oracle and \n OpenJDK JVMs from 6 to 14 inclusive include a JS engine by default - Rhino in Java 6 and 7, \n and Nashorn from 8 to 14 - so Javascript server scripting works out of the box with no \n dependencies with those versions.  Oracle and OpenJDK JVMs from version 15 onwards do not\n include JS support automatically.  However, we ship the standalone OpenJDK implementation\n of Nashorn with SmartClient, so Javascript scripting still works out of the box as long as\n you leave that dependency in place.  You can also leave that dependency in place with JDK \n versions from 8 to 14 - the OpenJDK implementation will mask the built-in Oracle \n implementation, but you should not notice any difference.  See the Server Scripting \n documentation for more details of your options with this.\n <p>\n ${isc.DocUtils.linkForRef(\'group:mavenSupport\',\'Maven\')} users should generally refer to the POMs bundled with the \n SDK, and installed for them by the official \n <a href=\'http://github.smartclient.com/isc-maven-plugin/\' target=\'_blank\'>Isomorphic plugin for Maven</a>. \n For others,  the following is a short description of the functionality contained in each \n SmartClient server JAR, and a link to the documentation listing its dependencies.  Please \n refer to that documentation for more detail on the dependency graph, including version \n numbers, transitive dependencies, and licensing.\n <P>\n <style>\n   .jmd-module  {\n     width: 140px;\n     text-align: right;\n     vertical-align: top;\n     padding-right: 10px;\n   }\n   .jmd-optional  {\n     text-decoration: underline;\n     margin-top: 10px; margin-bottom: 8px;\n   }\n </style>\n \n <table width="100%" >\n   <tr>\n     <td class="jmd-module">\n       <a target="_blank" href="./mavendoc/isomorphic-core-rpc.html">isomorphic_core_rpc</a>\n     </td>\n     <td>      \n       This is the core SmartClient module.  It provides the RPC, DMI, and DataSource\n       support. Please note that both commons-collections-3.x and commons-collections4-4.x \n       are required and safe to include side by side in the CLASSPATH (different third party \n       libs rely on one or the other).  The same is true of commons-lang and commons-lang3.\n       <div class="jmd-optional">\n         Optional Dependencies\n       </div>\n       <ul>\n         <li><i>freemarker</i>\n              - if you\'re using the built-in support for REST via the\n                ${isc.DocUtils.linkForRef(\'group:servletDetails\',\'RESTHandler servlet\')} servlet\n         <li><i>isomorphic_js_parser</i> \n              - if you\'re using the built-in support for REST via the \n                ${isc.DocUtils.linkForRef(\'group:servletDetails\',\'RESTHandler servlet\')} servlet with JSON payloads\n         <li><i>xercesImpl</i> \n              - if you\'re using JDK &lt; 1.5\n         <li><i>javax.mail</i> \n              - if you plan to use the Mail messaging feature\n         <li><i>javax.persistence</i> \n              - if you plan to use the metadata-from-annotations feature.  Note that if you \n                are using JPA, or a recent version of Hibernate, then you are probably \n                already using this library.\n         <li><i>poi and commons-math</i> \n              - if you plan to export datasets in Microsoft Excel 97 (xls) or 2007 (xlsx) \n                formats.  \n         <li><i>poi-ooxml, poi-ooxml-schemas, and commons-compress</i>\n              - also needed if you plan to export data in Excel 2007 (xlsx) format\n         <li><i>isomorphic_contentexport</i> \n              - if you plan to export to PDF format\n         <li><i>isomorphic_jpa</i> \n              - if you plan to use BatchDS Generator (even if you are not using JPA, \n                although the generated DataSources will not require JPA at runtime if you \n                are not using JPA).\n         <li><i>log4j</i> \n              - if you plan to use log4j logging (used by default)\n         <li><i>slf4j-log4j12</i> \n              - if you plan to use slf4j with log4j (for example), or any other slf4j bridge \n                library depending on which logging framework will be used.  See \n                ${isc.DocUtils.linkForRef(\'group:serverLogging\')} for information on server-side logging and how to \n                configure it.\n         <li><i>groovy</i> \n              - if you plan to use Groovy with the ${isc.DocUtils.linkForRef(\'group:serverScript\')} feature.  \n                Note, we also recommend that you use Groovy as the evaluation engine if you \n                intend to use Java as an inline scripting language.  \n                See the "Server Scripting" documentation.\n         <li><i>commons-digester3 and commons-beanutils</i> \n              - if you plan to use Velocity Tools.\n         <li><i>nashorn-core, asm, asm-commons, asm-tree, and asm-analysis</i>\n              - if you are using server scripting with the Javascript language, and you want\n                out of the box support with JDK versions from 15 onwards, as described in\n                the paragraph above.  The ASM libraries are required for Nashorn\'s\n                JavaAdapterFactory, which enables JavaScript to extend Java classes via\n                Java.extend()\n         <li><i>GraalJS JARs</i>\n              - as an alternative to Nashorn, you can use GraalJS on any standard JVM (Oracle\n                or OpenJDK) by adding the following JARs from the GraalVM project (available\n                via Maven or from graalvm.org). SmartClient ships these in\n                <code>WEB-INF/lib-graaljs/</code>:<ul>\n                <li><i>js-scriptengine</i> (from org.graalvm.js) - JSR223 adapter</li>\n                <li><i>js-language</i> (from org.graalvm.js) - Core JavaScript engine</li>\n                <li><i>polyglot</i> (from org.graalvm.polyglot) - Polyglot API</li>\n                <li><i>truffle-api</i> (from org.graalvm.truffle) - Truffle framework</li>\n                <li><i>truffle-runtime</i> (from org.graalvm.truffle) - Runtime support</li>\n                <li><i>truffle-compiler</i> (from org.graalvm.truffle) - JIT compiler</li>\n                <li><i>regex</i> (from org.graalvm.regex) - Regular expression engine</li>\n                <li><i>collections</i> (from org.graalvm.sdk) - Collection utilities</li>\n                <li><i>nativeimage</i> (from org.graalvm.sdk) - Native image support</li>\n                <li><i>word</i> (from org.graalvm.sdk) - Low-level memory access</li>\n                <li><i>icu4j</i> (from org.graalvm.shadowed) - Internationalization</li>\n                </ul>\n                In GraalJS 24.x, Java interop is enabled by default when using the JSR-223\n                ScriptEngine API. See the ${isc.DocUtils.linkForRef(\'group:serverScript\',\'Server Scripting\')}\n                documentation for configuration details.\n         <li><i>parquet-hadoop-bundle</i> \n              - columnar reader/writer and schema APIs for Parquet files; enables reading\n                row groups, pages and converting values to Java types as used by the fetcher.\n         <li><i>hadoop-common</i> \n              - Hadoop core utilities and filesystem/config plumbing that Parquet’s Hadoop\n                layer links against, even when reading over HTTP instead of HDFS.\n         <li><i>hadoop-mapreduce-client-core</i> \n              - MapReduce abstractions (InputSplit, job/config classes) that Parquet’s\n                Hadoop integration references for compatibility; no MR jobs are run here,\n                but the APIs must be present on the classpath.\n         <li><i>hadoop-shaded-protobuf_3_7</i> \n              - shaded Protobuf runtime required by Hadoop internals used transitively by\n                the Parquet Hadoop layer; avoids clashing with other protobuf versions.\n         <li><i>hadoop-shaded-guava</i> \n              - shaded Guava utilities used by Hadoop/Parquet (collections, I/O helpers,\n                preconditions) without exposing Guava to the app’s dependency graph.\n         <li><i>snappy-java</i> \n              - native/portable Snappy codec to decompress Parquet column chunks that are\n                Snappy-encoded; needed for fast reads of compressed datasets.\n         <li><i>woodstox-core</i> \n              - high-performance StAX XML parser used by Hadoop for reading XML configs and\n                other streaming XML tasks required by transitive code paths.\n         <li><i>stax2-api</i> \n              - StAX2 extension API implemented by Woodstox; required at runtime whenever\n                Woodstox is on the classpath to satisfy XML stream parser interfaces.\n        </ul>\n      </td>\n   </tr>  \n   <tr>\n     <td class="jmd-module"><a target="_blank" \n         href="./mavendoc/isomorphic-contentexport.html">isomorphic_contentexport</a>\n     </td>\n     <td>\n       Provides support for PDF Export.\n       <div class="jmd-optional">\n       Optional Dependencies\n       </div>\n       <ul>\n       <li><i>batik-anim, batik-awt-util, batik-bridge, batik-css, batik-dom, batik-ext, \n              batik-gvt, batik-parser, batik-script, batik-svg-dom, batik-util, batik-xml\n           </i> -\n           <p/>\n           These are all required to use ${isc.DocUtils.linkForRef(\'classMethod:RPCManager.exportImage\')}, or when using \n           ${isc.DocUtils.linkForRef(\'classMethod:RPCManager.exportContent\')} to export a DrawPane or FacetChart only \n           in IE8 or earlier, or if a DrawPane has a DrawImage which loads a cross-domain \n           image.\n           <p/>\n           <b>NOTE:</b> \n           Between iText 2.0.x and iText 2.1.x there is a binary (but not source) \n           incompatibility that causes a server-side <code>NoSuchMethodError</code> \n           when exporting, e.g., charts in Internet Explorer. This is a \n       <a href=\'http://code.google.com/p/flying-saucer/issues/detail?id=126\' target=\'_blank\'>known issue</a> \n           with the Flying Saucer product that is fixed by using \n           core-renderer-R8-isomorphic.jar and iText-2.1.7.jar in the lib-iTextAlternate/ \n           directory instead of core-renderer.jar and iText-2.0.8.jar in the lib/ directory.  \n           To use iText 2.1.7 with the Server Framework, exclude lib/core-renderer.jar and \n           lib/iText-2.0.x.jar from the application\'s classpath and instead add \n           lib-iTextAlternate/core-renderer-R8-isomorphic.jar and \n           lib-iTextAlternate/iText-2.1.7.jar.\n       </ul>\n     </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n      <a target="_blank" href="./mavendoc/isomorphic-tools.html">isomorphic_tools</a>\n   </td>\n   <td>\n     Contains back-end logic for the "Admin Console" tool visible in the Developer Console, \n     and also standalone from the SDK home page.  Also contains the various data importers \n     and exporters, and the server-side components of the BatchUploader.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-cdi.html">isomorphic_cdi</a>\n   </td>\n   <td>\n     Support for ${isc.DocUtils.linkForRef(\'group:dmiOverview\',\'DMI\')} dispatches to Spring beans \n     (via ${isc.DocUtils.linkForRef(\'attr:ServerObject.lookupStyle\')} : "cdi").\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring</a>\n   </td>\n   <td>\n     Support for ${isc.DocUtils.linkForRef(\'group:dmiOverview\',\'DMI\')} dispatches to Spring beans \n     (via ${isc.DocUtils.linkForRef(\'attr:ServerObject.lookupStyle\')} : "spring").\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring_hibernate3</a>\n   </td>\n   <td>\n     Support for Spring + Hibernate 3, see the Compatibility section of ${isc.DocUtils.linkForRef(\'group:springIntegration\')} for more details.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-messaging.html">\n     isomorphic_realtime_messaging</a>\n   </td>\n   <td>\n     Server support required for the SmartClient Realtime Messaging Module.  Install this \n     if you\'re using this \'push\' technology.  For more information, see \n     ${isc.DocUtils.linkForRef(\'group:messaging\',\'Messaging\')}.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-hibernate.html">isomorphic_hibernate</a>\n   </td>\n   <td>\n     Contains support for Hibernate DataSources as described here: \n     ${isc.DocUtils.linkForRef(\'group:hibernateIntegration\')}.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-jpa.html">isomorphic_jpa</a>\n   </td>\n   <td>\n     Contains support for JPA DataSources as described ${isc.DocUtils.linkForRef(\'group:jpaIntegration\',\'here\')}\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-sql.html">isomorphic_sql</a></td>\n   <td>\n     The SmartClient SQLDataSource.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-autotest.html">isomorphic_autotest</a>\n   </td>\n   <td>\n     Support for ${isc.DocUtils.linkForRef(\'group:automatedTesting\',\'automated testing and Continuous Integration\')}\n     <div class="jmd-optional">\n     Optional Dependencies\n     </div>\n     <ul>\n       <li><i>jna</i> - if testing with IE on Windows environments\n       <li><i>servlet-api</i> - needed only if you intend to run TestRunner from a standalone\n            process (ie, from a normal Java program, not a webapp).  \n            <p/>\n            However, it should <u>not</u> be deployed to a servlet container such as Tomcat \n            or Jetty.  The best case is that the file will be unused and a source of \n            confusion for anybody looking at the webapp\'s library usage; the worst case is \n            that it will conflict with the container\'s own implementation of the Servlet API.\n     </ul>\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-js-parser.html">isomorphic_js_parser</a>\n   </td>\n   <td>\n     A parser capable of reading a JSON byte stream and creating an in-memory Java object \n     structure to match.  Used by any mechanism that relies on JSON-style configuration.  \n     Examples include FileAssembly definitions in JSON format, any use of the rulesFile with \n     a URIRegexFilter (Java Servlet) or subclass.  \n   </td>\n </tr>\n <tr>\n   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-compression.html">\n     isomorphic_compression</a>\n   </td>\n   <td>\n     This is a part of the Network Performance Module.  The isomorphic_compression module is \n     required for dynamic and static compression of various assets delivered to the browser.  \n     For more information, see: ${isc.DocUtils.linkForRef(\'group:compression\')}.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-assembly.html">\n     isomorphic_assembly</a>\n   </td>\n   <td>\n     This is part of the Network Performance Module.  The isomorphic_assembly module is \n     required for file assembly and stripping.  For more information, see: \n     ${isc.DocUtils.linkForRef(\'group:fileAssembly\')}.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-scheduler.html">\n     isomorphic_scheduler</a>\n   </td>\n   <td>\n     Server-side libraries providing ${isc.DocUtils.linkForRef(\'group:quartzAdapters\',\'DataSource adapters\')} for the\n     <a href=\'http://www.quartz-scheduler.org\' target=\'_blank\'>Quartz</a> API.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-m2pluginextras.html">\n     isomorphic_m2pluginextras</a>\n   </td>\n   <td>\n     A small collection of tools / utilities for use by Maven builds, Ant Scripts, and \n     command line invocation.\n   </td>\n </tr>\n <tr>\n   <td class="jmd-module">\n     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring_hibernate4</a>\n   </td>\n   <td>\n     Support for Spring + Hibernate 4, see the Compatibility section of ${isc.DocUtils.linkForRef(\'group:springIntegration\')} for more details.\n   </td>\n </tr>\n </table>',name:"javaModuleDependencies"},"attr:Window.hiliteHeaderSrc":{seeAlso:[],defaultValue:'"[SKIN]Window/headerGradient_hilite.gif" | null',type:"attr",definingClass:"class:Window",groups:["appearance","header"],deprecated:null,ref:"attr:Window.hiliteHeaderSrc",valueType:"SCImgURL",description:"If ${isc.DocUtils.linkForRef('attr:Window.showHeaderBackground')} is true, this governs the URL of the image to \n use in the header's highlighted state when the window is ${isc.DocUtils.linkForRef('method:Window.flash','flashed')}",flags:"IRWA",name:"hiliteHeaderSrc"},"attr:Button.definingProperty":{seeAlso:[],ref:"attr:Button.definingProperty",defaultValue:'"title"',deprecated:null,type:"attr",definingClass:"class:Button",valueType:"String",description:"This attribute denotes the name of a property to use as a\n ${isc.DocUtils.linkForRef('method:Canvas.getDefiningPropertyName','getDefiningPropertyName()')} for this property when generating and resolving\n ${isc.DocUtils.linkForRef('type:AutoTestLocator','AutoTest locators with search segments')}.",flags:"IRWA",name:"definingProperty"},"classAttr:Operators.lessThanFieldTitle":{seeAlso:[],defaultValue:'"less than field"',type:"classAttr",definingClass:"class:Operators",groups:["i18nMessages"],deprecated:null,ref:"classAttr:Operators.lessThanFieldTitle",valueType:"String",description:'Title for the "lessThanField" operator',flags:"IR",name:"lessThanFieldTitle"},"attr:Shuttle.selectedValues":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Shuttle",getter:["getSelectedValues"],deprecated:null,ref:"attr:Shuttle.selectedValues",valueType:"Array of String | Array of Number",description:"Initial selected values for the shuttle.\n <P>\n If specified, the shuttle will be initialized with records with\n matching ${isc.DocUtils.linkForRef('attr:Shuttle.valueField')} being selected.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:Shuttle.selectedRecords')} for initializing selection with specific\n records. If both properties are specified, <code>selectedValues</code> will\n have no effect\n <P>\n To update the selection by value at runtime use ${isc.DocUtils.linkForRef('method:Shuttle.setSelectedByValue')}",flags:"IR",name:"selectedValues"},"attr:MenuButton.title":{seeAlso:[],defaultValue:'"Show Menu"',type:"attr",definingClass:"class:MenuButton",groups:["i18nMessages"],deprecated:null,ref:"attr:MenuButton.title",valueType:"String",description:"Default title for the button.",flags:"IRW",name:"title"},"attr:RichTextEditor.toolbarBackgroundColor":{seeAlso:[],ref:"attr:RichTextEditor.toolbarBackgroundColor",defaultValue:'"#CCCCCC"',deprecated:null,type:"attr",definingClass:"class:RichTextEditor",valueType:"String",description:"The background color for the toolbar.",flags:"IR",name:"toolbarBackgroundColor"},"type:TableMode":{seeAlso:[],ref:"type:TableMode",deprecated:null,type:"type",values:[{value:"TableView.PLAIN",description:"The default mode which displays a list of rows"},{value:"TableView.GROUPED",description:"Grouped table is a set of rows embedded in a rounded                                rectangle"}],description:"Controls the display mode of TableView record display",name:"TableMode"},"method:FormItem.hideIcon":{seeAlso:[],ref:"method:FormItem.hideIcon",deprecated:null,type:"method",definingClass:"class:FormItem",params:[{defaultValue:null,optional:false,type:"Identifier",description:"${isc.DocUtils.linkForRef('attr:FormItemIcon.name','name')} of the icon to be hidden.",name:"icon"}],description:" This method will hide some icon in this item's ${isc.DocUtils.linkForRef('attr:FormItem.icons')} array, if it is \n currently visible. Note that once this method has been called, any previously specified\n ${isc.DocUtils.linkForRef('method:FormItemIcon.showIf')} will be discarded.\n\n",flags:"",name:"hideIcon"},"attr:FiscalCalendar.defaultMonth":{seeAlso:[],ref:"attr:FiscalCalendar.defaultMonth",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:FiscalCalendar",valueType:"Integer",description:"The default zero-based month-number to use for calculating fiscal dates when no\n ${isc.DocUtils.linkForRef('attr:FiscalCalendar.fiscalYears','fiscal years')} are provided. This value together\n with ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultDate')} will be used as the start date for the\n fiscal years where no explicitly specified fiscalYear configuration is present.\n <br>\n See also ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultYearMode')}.",flags:"IRW",name:"defaultMonth"},"attr:ListGrid.exportRawValues":{seeAlso:[],ref:"attr:ListGrid.exportRawValues",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"Boolean",description:"Dictates whether the data in this grid should be exported raw by\n ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData','exportClientData()')}.  If set to true,\n data will not be processed by field-formatters during exports.\n Decreases the time taken for large exports.  This property can also be set at the\n ${isc.DocUtils.linkForRef('attr:ListGridField.exportRawValues','field level')}.",flags:"IR",name:"exportRawValues"},"type:DetailViewerViewState":{groups:["viewState"],seeAlso:[],ref:"type:DetailViewerViewState",deprecated:null,type:"type",description:"An object containing the stored grouping information for a detailViewer.\n Note that this object is not intended to be interrogated directly, but may be stored \n (for example) as a blob on the server for state persistence across sessions.",name:"DetailViewerViewState",baseType:"String"},"attr:GridRenderer.predictiveScrollRedraw":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:GridRenderer",groups:["performance","scrolling"],deprecated:null,ref:"attr:GridRenderer.predictiveScrollRedraw",valueType:"Boolean",description:"When true, the grid uses velocity tracking and momentum prediction to determine when and\n where to redraw during scrolling. This predicts where the user's scroll will stop and\n pre-renders that viewport, reducing perceived lag.\n <P>\n The algorithm tracks scroll position history, calculates velocity and acceleration, and\n detects deceleration patterns that indicate the user is about to stop scrolling. When\n deceleration is detected, it predicts the final scroll position using exponential decay\n modeling and renders ahead to that position.\n <P>\n Set to false to use the simple delay-based approach with ${isc.DocUtils.linkForRef('attr:GridRenderer.scrollRedrawDelay')}.",flags:"IRW",name:"predictiveScrollRedraw"},"type:HTMLString":{seeAlso:[],ref:"type:HTMLString",deprecated:null,type:"type",description:"A String of HTML, such as \"<span class='somestyle'>text</span>\".\n <P>\n In many contexts, such as ${isc.DocUtils.linkForRef('attr:Button.title')} and ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue')}, an\n HTML String can be specified, allowing you to use normal HTML tags and CSS to do\n formatting or styling.\n <P>\n However, bear in mind that if you attempt any kind of layout or advanced styling in such\n an HTML string, different browsers may render the HTML differently - use SmartClient\n ${isc.DocUtils.linkForRef('class:Layout','layout')} and ${isc.DocUtils.linkForRef('attr:Canvas.styleName','styling')} features wherever possible to\n avoid this.  See also ${isc.DocUtils.linkForRef('type:CSSStyleName')}.",name:"HTMLString",baseType:"String"},"staticMethod:isc.showPrompt":{groups:["Prompting"],seeAlso:[{ref:"classAttr:Dialog.Prompt",description:null}],ref:"staticMethod:isc.showPrompt",deprecated:null,type:"staticMethod",definingClass:"object:isc",params:[{defaultValue:null,optional:false,type:"HTMLString",description:"message to display",name:"message"},{defaultValue:null,optional:true,type:"Dialog Properties",description:"additional properties for the Dialog, applied before                                       the Dialog is shown",name:"properties"}],description:"\n\tMethod available on the isc object to show a modal prompt to the user.\n  This method will display the message using the Dialog.Prompt singleton object.<br>\n  Note: if this prompt is to be shown to the user during some slow JavaScript logic, we\n  advise calling this method, then using ${isc.DocUtils.linkForRef('method:Class.delayCall')} or ${isc.DocUtils.linkForRef('classMethod:Timer.setTimeout')}\n  to kick off the slow logic in a separate thread. This ensures that the prompt is showing\n  before the lengthy execution begins.\n  <p/>Use <code>\"&#36;{loadingImage}\"</code> to include ${isc.DocUtils.linkForRef('classAttr:Canvas.loadingImageSrc','a loading image')}.\n\n\n",flags:"",name:"showPrompt"},"class:BrowserPlugin":{seeAlso:[],requiresModules:["PluginBridges"],type:"class",staticMethods:[],inheritsFrom:"Canvas",classMethods:[],classAttrs:[],attrs:[],ref:"class:BrowserPlugin",deprecated:null,treeLocation:["Client Reference/Client Bridges"],description:"Container for a Browser Plugin.",methods:[],name:"BrowserPlugin"},"attr:DrawItem.zIndex":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DrawItem",getter:["getZIndex"],groups:["zIndex"],ref:"attr:DrawItem.zIndex",deprecated:null,valueType:"Integer",setter:["setZIndex"],description:"Relative stacking order of this draw item with respect to other items in the same ${isc.DocUtils.linkForRef('class:DrawPane')}\n or ${isc.DocUtils.linkForRef('class:DrawGroup')}.\n <p>\n null means that the zIndex has not been resolved. Upon adding this draw item to a\n <code>DrawPane</code> or <code>DrawGroup</code>, this item's zIndex will be resolved to\n the next higher auto-assigned zIndex. Note that this may still be less than another item's\n zIndex if ${isc.DocUtils.linkForRef('method:DrawItem.bringToFront','bringToFront()')} was called on that item.\n <p>\n If two items within the same <code>DrawPane</code> or <code>DrawGroup</code> have the\n same zIndex, then they are stacked in the order in which they were added to the\n <code>DrawPane</code> or <code>DrawGroup</code>.\n <p>\n When the <code>DrawPane</code>'s ${isc.DocUtils.linkForRef('attr:DrawPane.drawingType','drawingType')} is\n \"bitmap\",\n \n zIndex, ${isc.DocUtils.linkForRef('method:DrawItem.bringToFront')}, and ${isc.DocUtils.linkForRef('method:DrawItem.sendToBack')} are not supported\n for ${isc.DocUtils.linkForRef('class:DrawLabel')}s on iOS due to platform limitations.",flags:"IR",name:"zIndex"},"method:Tree.getLeaves":{seeAlso:[],ref:"method:Tree.getLeaves",deprecated:null,type:"method",definingClass:"class:Tree",params:[{defaultValue:null,optional:false,type:"TreeNode",description:"node in question",name:"node"}],description:"\n Return all the first-level leaves of a node.\n <br><br>\n For load on demand trees (those that only have a partial representation client-side), this\n method will return only nodes that have already been loaded from the server.\n\n",flags:"",returns:{type:"Array of TreeNode",description:"List of immediate children that are leaves."},name:"getLeaves"},"attr:Lane.styleName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:Lane",groups:["appearance"],deprecated:null,ref:"attr:Lane.styleName",valueType:"CSSStyleName",description:"The base style-name for normal cells in this Lane.",flags:"IRW",name:"styleName"},"attr:DropZone.acceptedFileTypes":{seeAlso:[],ref:"attr:DropZone.acceptedFileTypes",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DropZone",valueType:"Array of String",description:'Array of accepted MIME types (e.g., ["image/*", "application/pdf"]).\n If null, all file types are accepted when ${isc.DocUtils.linkForRef(\'attr:DropZone.canDropFiles\')} is true.',flags:"IR",name:"acceptedFileTypes"},"group:networkPerformance":{refs:[],seeAlso:[],ref:"group:networkPerformance",treeLocation:["Optional Modules"],deprecated:null,type:"group",title:"Network Performance",description:"This section describes various methods for optimizing delivery of your SmartClient-based\n application to the browser.  The various techniques discussed here should enable you to\n drastically reduce the time to load your SmartClient based application and to cut down on\n bandwidth costs and server-side CPU usage.\n <P>\n <i>Note that in addition to these network performance considerations, you should also be aware\n of the recommended application design practices discussed in ${isc.DocUtils.linkForRef('group:smartArchitecture')}.</i>\n <P>\n\n There are three main ways of improving the performance of your application:\n <p>\n <u><b>Compression</b></u>\n <p>\n You'll want to deliver as much of your application assets compressed as possible.  For a start, the\n SmartClient modules come pre-compressed.  The ${isc.DocUtils.linkForRef('group:compression')} section describes how\n to make sure that SmartClient modules and your application logic are delivered compressed\n and how to enable dynamic compression of your dynamic content.\n <p>\n Compression drastically reduces transfer times to the browser.  Compression ratios for css\n and javascript files can be as high as 8:1.\n\n <p>\n <u><b>Caching</b></u>\n <p>\n The ${isc.DocUtils.linkForRef('group:caching')} section deals with delivering as much content as possible with\n caching headers.  Setting these headers allows the end-user's browser and any intermediary\n proxies to keep a local copy of the file across browser reloads, ensuring the subsequent\n visits require almost no fetches from the server.  Eliminating these fetches is also\n important for the reasons explained under File Assembly below.\n \n <p>\n <u><b>File Assembly</b></u>\n <p>\n Modern browsers limit the number of HTTP connections they use to fetch the assets required\n to render your pages - typically to just 2 connections.  As a result, connection latency can\n play a much higher role than available bandwidth and the two connection limit effectively\n drastically limits the user's usable bandwidth.  For this reason, it's important to minimize\n the number of HTTP requests made to the server.  The File Assembly services make it easy to\n deliver multiple css and javascript file via one HTTP response.  Assembling files together\n also helps to increase the compression ratio because the compression engine has more\n redundant data to work with.\n\n <p>\n <u><b>FileLoader</b></u>\n <p>\n The FileLoader is a standalone client-side module that allows you to performing caching or\n loading of various resources in the background on any page.  The typical usage pattern is to\n use this module to pre-cache SmartClient modules, skin images, and application logic while\n the user is, for example filling in a login form.  See the ${isc.DocUtils.linkForRef('object:FileLoader')} documentation\n on usage.\n\n <p>\n <u><b>SSL Considerations</b></u>\n <p>\n Some quirks to be aware of when optimizing for pages serviced via HTTPS:\n <ul>\n <li>If your top-level https page loads an image via http, IE will pop a warning to the user\n asking if it's ok to serve the \"unsecure\" content.  Firefox does not pop an alert, bug shows\n a different lock icon to indicate that not all content is served from a secure server.\n <li>Firefox will not write images fetched via SSL to disk, even if expires headers are set.\n But it will cache them in memory for the duration of the browser session.  This makes the\n use of the ${isc.DocUtils.linkForRef('object:FileLoader')} even more important for SSL applications.  IE will cache SSL\n content across browser restarts.\n <li>If your only concern is with actual security and not with perception, it makes a lot of\n sense to serve the top-level page via plain HTTP and then use the SmartClient RPC mechanism\n to fetch sensitive data with no-cache headers via HTTPS.  Unfortunately this almost never\n practical because most users look for the secure lock icon on the top-level page and may\n become worried that the application is not secure if they don't see it.\n </ul>\n\n <p>\n <u><b>Other Tips</b></u>\n <p>\n 1.  Modern applications often use a number of cookies to keep track of session state,\n application state, etc.  If you don't limit the paths these cookies are served for, you can\n easily end up with these cookies being sent to the server with every HTTP request as\n part of the HTTP headers.  This can severely limit bandwidth where a large number of\n requests are made - typically for skin images.  Also note that most technologies used by\n end-users to connect to the internet such as DSL and Cable are half-duplex, meaning that\n downstream must pause for upstream traffic to be sent and these connections also are\n asymmetric, allowing much faster download speeds than upload speeds.  As a result, the\n limited upstream capability of most connections ends up limiting the download bandwidth by\n delaying the download of other assets required to render the page.\n <p>\n 2.  Whenever possible, don't set the \"Cache-Control\" header to \"private\" - this tells\n intermediary proxies to not allow caching of the specified content, eliminating that cache\n as a useful intermediary for other users behind it.\n <p>\n 3.  For a good overview of performance considerations, see this post:\n <a href='http://www.die.net/musings/page_load_time/' target='_blank'>http://www.die.net/musings/page_load_time/</a>",name:"networkPerformance"},"method:EditTree.getPaletteNodesFromXML":{seeAlso:[{ref:"method:Callbacks.PaletteNodeCallback",description:null},{ref:"method:EditTree.serializeAllEditNodes",description:null},{ref:"method:EditTree.serializeEditNodes",description:null}],ref:"method:EditTree.getPaletteNodesFromXML",deprecated:null,type:"method",definingClass:"class:EditTree",params:[{defaultValue:null,optional:false,type:"String",description:"XML string",name:"xmlString"},{defaultValue:null,optional:false,type:"PaletteNodeCallback",description:"Callback used to return the PaletteNodes",name:"callback"}],description:" Obtain ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')} from an XML representation,\n but do not add them to the EditContext.\n\n",flags:"",name:"getPaletteNodesFromXML"},"method:GradientEditor.getGradient":{seeAlso:[],ref:"method:GradientEditor.getGradient",deprecated:null,type:"method",definingClass:"class:GradientEditor",description:" Returns the current state of the widget as a CSS gradient\n",flags:"",returns:{type:"String",description:"the gradient definition"},name:"getGradient"},"method:ListGrid.setSortState":{groups:["viewState"],seeAlso:[{ref:"method:ListGrid.getSortState",description:null}],ref:"method:ListGrid.setSortState",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"ListGridSortState",description:"Object describing the desired sort state for the grid.",name:"sortState"}],description:" Reset this grid's sort state (sort field and direction or list of\n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s) to match the\n ${isc.DocUtils.linkForRef('type:ListGridSortState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.getSortState')}.\n\n",flags:"",name:"setSortState"},"method:Label.setStyleName":{seeAlso:[],ref:"method:Label.setStyleName",deprecated:null,type:"method",definingClass:"class:Label",params:[{defaultValue:null,optional:false,type:"CSSStyleName",description:"new CSS style name",name:"newStyle"}],description:" Dynamically change the CSS class for this widget.  For a Label, this is equivalent to\n ${isc.DocUtils.linkForRef('method:StatefulCanvas.setBaseStyle','setBaseStyle()')}.\n\n",flags:"",name:"setStyleName"},"attr:ColorPicker.basicColorLabel":{seeAlso:[],defaultValue:'"Basic Colors:"',type:"attr",definingClass:"class:ColorPicker",groups:["i18nMessages"],deprecated:null,ref:"attr:ColorPicker.basicColorLabel",valueType:"HTMLString",description:"The label shown above the basic color blocks.",flags:"IR",name:"basicColorLabel"},"attr:TreeGrid.showSelectedIcons":{seeAlso:[],defaultValue:"false",type:"attr",definingClass:"class:TreeGrid",groups:["treeIcons"],deprecated:null,ref:"attr:TreeGrid.showSelectedIcons",valueType:"Boolean",description:"If true, show a different icon for selected nodes than unselected nodes.\n This is achieved by appending the ${isc.DocUtils.linkForRef('attr:TreeGrid.selectedIconSuffix')} onto the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.folderIcon')} URL or ${isc.DocUtils.linkForRef('attr:TreeGrid.nodeIcon')} for selected records.\n <P>\n If appropriate, this suffix will be combined with the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.openIconSuffix')} or ${isc.DocUtils.linkForRef('attr:TreeGrid.closedIconSuffix')} (see \n ${isc.DocUtils.linkForRef('attr:TreeGrid.showOpenIcons')}. So a treeGrid with its <code>folderIcon</code>\n property set to <code>\"[SKIN]/folder.gif\"</code>, with both\n <code>showSelectedIcons</code> and <code>showOpenIcons</code> set to true would show\n an icon with the URL <code>\"[SKIN]/folder_open_selected.gif\"</code> for a\n folder that was both selected and opened.",flags:"IRW",name:"showSelectedIcons"},"type:DragDataAction":{groups:["dragdrop"],seeAlso:[],ref:"type:DragDataAction",deprecated:null,type:"type",values:[{value:'"none"',description:"Don't do anything, resulting in the same data being in both lists."},{value:"Canvas.COPY",description:"Copy the data leaving the original in our list."},{value:"Canvas.MOVE",description:"Remove the data from this list so it can be moved into the other list."}],description:"What do we do with data that's been dropped into another list?",name:"DragDataAction"},"method:ListGrid.setDataSource":{seeAlso:[],ref:"method:ListGrid.setDataSource",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"GlobalId | DataSource",description:"DataSource to bind to",name:"dataSource"},{defaultValue:null,optional:true,type:"Array of DataSourceField",description:"optional array of fields to use",name:"fields"}],description:' Bind to a new DataSource.\n <P>\n Like passing the "dataSource" property on creation, binding to a DataSource means that the\n component will use the DataSource to provide default data for its fields.\n <P>\n When binding to a new DataSource, if the component has any existing "fields" or has a dataset,\n these will be discarded by default, since it is assumed the new DataSource may represent a\n completely unrelated set of objects.  If the old "fields" are still relevant, pass them to\n setDataSource().\n \n',flags:"",examples:["${isc.DocUtils.linkForExampleId('WSDLDataSource')}"],name:"setDataSource"},"attr:OperationBinding.preventHTTPCaching":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",deprecated:null,ref:"attr:OperationBinding.preventHTTPCaching",valueType:"boolean",description:"Configures ${isc.DocUtils.linkForRef('attr:DataSource.preventHTTPCaching')} on a per-operationType basis.",flags:"IR",serverDS:"allowed",name:"preventHTTPCaching"},"class:FieldPickerWindow":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Window",classMethods:[],classAttrs:[],attrs:["attr:FieldPickerWindow.title","attr:FieldPickerWindow.autoDismiss","attr:FieldPickerWindow.fieldPicker"],ref:"class:FieldPickerWindow",deprecated:null,treeLocation:["Client Reference/Data Binding/FieldPicker"],description:"A dialog for picking fields to display from among the available fields.\n <p>\n This is typically useful in scenarios where there are many more fields than can reasonably\n fit on screen. The application can start off displaying a few of the fields by default (such\n as the most commonly-needed fields), and show a FieldPickerWindow to allow the user to\n customize which fields to display as well as the order in which to display them.",methods:[],examples:["${isc.DocUtils.linkForExampleId('fieldPicker')}"],name:"FieldPickerWindow"},"attr:GridRenderer.showHover":{seeAlso:[{ref:"attr:GridRenderer.canHover",description:null},{ref:"method:GridRenderer.cellHoverHTML",description:null}],defaultValue:"null",type:"attr",definingClass:"class:GridRenderer",groups:["events"],deprecated:null,ref:"attr:GridRenderer.showHover",valueType:"boolean",description:"If true, and canHover is also true, when the user hovers over a cell, hover text will pop up\n next to the mouse.  The contents of the hover is determined by ${isc.DocUtils.linkForRef('method:GridRenderer.cellHoverHTML')}.",flags:"RW",name:"showHover"},"attr:ListGridField.editorValueIcons":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:ListGridField",groups:["imageColumns"],deprecated:null,ref:"attr:ListGridField.editorValueIcons",valueType:"Map<String,String>",description:"When some cell in this field is being edited, setting this property will specify the\n value icons to display in the cell's editor. If unset, the editor's valueIcons\n will be determined in the same way as it would be for a static cell.",flags:"IRW",name:"editorValueIcons"},"attr:ListGridField.summaryValue":{seeAlso:[],ref:"attr:ListGridField.summaryValue",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:ListGridField",valueType:"HTMLString",description:"The value to display for a ListGridField when it appears in the ${isc.DocUtils.linkForRef('attr:ListGrid.summaryRow','summaryRow')}.  The\n default for normal fields is null and for special fields, like the ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxField','checkboxField')},\n the default is to show a blank value (a non-breaking space).",flags:"IRW",name:"summaryValue"},"object:MultiWindowSettings":{seeAlso:[],type:"object",staticMethods:[],classMethods:[],classAttrs:[],attrs:["attr:MultiWindowSettings.autoCopyDataSources","attr:MultiWindowSettings.shareMessageChannels"],ref:"object:MultiWindowSettings",deprecated:null,treeLocation:["Client Reference/Foundation"],description:"Allows specifying settings to apply to the ${isc.DocUtils.linkForRef('class:MultiWindow')} of a child window.",methods:[],name:"MultiWindowSettings"},"method:ListGrid.getUserCriteriaState":{groups:["viewState"],seeAlso:[{ref:"type:ListGridUserCriteriaState",description:null},{ref:"method:ListGrid.setUserCriteriaState",description:null}],ref:"method:ListGrid.getUserCriteriaState",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Returns a snapshot of the current user-provided criteria for this ListGrid.\n <P>\n This object can be passed to ${isc.DocUtils.linkForRef('method:ListGrid.setUserCriteriaState')} to reset this grid's \n user-criteria to the current state.\n",flags:"",returns:{type:"ListGridUserCriteriaState",description:"current criteria state for the grid."},name:"getUserCriteriaState"},"method:CancellationController.cancel":{seeAlso:[],ref:"method:CancellationController.cancel",deprecated:null,type:"method",definingClass:"class:CancellationController",params:[{defaultValue:null,optional:true,type:"HTMLString",description:"A reason for cancellation.",name:"reason"}],description:" Requests cancellation of all asynchronous operations that are polling ${isc.DocUtils.linkForRef('attr:CancellationController.canceled')}\n or ${isc.DocUtils.linkForRef('method:Class.observe','observing')} this method. Also cancels any\n ${isc.DocUtils.linkForRef('method:CancellationController.createSubController','sub-<code>CancellationController</code>')}s of this\n <code>CancellationController</code> that are not already canceled.\n <p>\n ${isc.DocUtils.linkForRef('attr:CancellationController.cancellationReason','this.cancellationReason')} is set to the provided <code>reason</code>\n only on the first call to cancel().\n <p>\n For observers of this method, the recommended practice is to capture the <code>returnVal</code>\n and only perform the cancellation steps if the <code>returnVal</code> was <code>true</code>.\n This is because it could happen that cancel() is called a second time before the observers\n finish.\n",flags:"",returns:{type:"Boolean",description:"<code>true</code> if this was the first call to cancel(); <code>false</code> otherwise."},name:"cancel"},"attr:FormItem.linearColSpan":{seeAlso:[{ref:"attr:FormItem.colSpan",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["formLayout"],deprecated:null,ref:"attr:FormItem.linearColSpan",valueType:"int | String",description:"Specifies a column span for an item in ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode','linearMode')},\n overriding the default value of \"*\" in that mode.",flags:"IRW",name:"linearColSpan"},"attr:Calendar.laneEventPadding":{seeAlso:[],ref:"attr:Calendar.laneEventPadding",defaultValue:"0",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"Integer",description:"The pixel space to leave between events and the edges of the ${isc.DocUtils.linkForRef('attr:Calendar.lanes','lane')} or \n ${isc.DocUtils.linkForRef('attr:Lane.sublanes','sublane')} they appear in.  Only applicable to \n ${isc.DocUtils.linkForRef('attr:Calendar.timelineView','timelines')} and to ${isc.DocUtils.linkForRef('attr:Calendar.dayView','dayViews')} showing\n ${isc.DocUtils.linkForRef('attr:Calendar.showDayLanes','day lanes')}.",flags:"IRW",name:"laneEventPadding"},"attr:OperationBinding.ansiJoinClause":{seeAlso:[{ref:"attr:OperationBinding.customSQL",description:null},{ref:"attr:DataSource.useAnsiJoins",description:null},{ref:"attr:OperationBinding.includeAnsiJoinsInTableClause",description:null}],defaultValue:"null",type:"attr",definingClass:"class:OperationBinding",groups:["customQuerying"],ref:"attr:OperationBinding.ansiJoinClause",deprecated:null,valueType:"VelocityExpression",description:"<b>This feature is available with Power or better licenses only.</b> See\n <a href=http://smartclient.com/product>smartclient.com/product</a> for details.\n <p>\n For a dataSource of ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"sql\", this\n property can be specified on an operationBinding to provide the server with a bespoke\n ANSI-style joins clause to use when constructing the SQL query to perform this operation.\n The property should be a set of joins implemented with JOIN directives (as opposed to\n additional join expressions in the where clause), joining related tables to the\n main table or view defined in ${isc.DocUtils.linkForRef('attr:OperationBinding.tableClause','tableClause')}.\n The server will insert the text of this property immediately after the\n ${isc.DocUtils.linkForRef('attr:OperationBinding.tableClause','tableClause')}.\n <p>\n See the documentation for ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL')} for usage examples",flags:"IR",serverDS:"only",name:"ansiJoinClause"},"attr:CanvasItem.prompt":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:CanvasItem",groups:["basics"],ref:"attr:CanvasItem.prompt",deprecated:null,setter:["setPrompt"],valueType:"HTMLString",description:"This text is shown as a tooltip prompt when the cursor hovers over this item.\n <P>\n When the item is ${isc.DocUtils.linkForRef('method:FormItem.setCanEdit','read-only')} a different hover can be shown with\n ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyHover')}. Or, when the item is ${isc.DocUtils.linkForRef('attr:FormItem.disabled','disabled')} or\n read-only with ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','readOnlyDisplay:disabled')} a different hover can be \n shown with ${isc.DocUtils.linkForRef('attr:FormItem.disabledHover')}.\n <P>\n Note that when the form is ${isc.DocUtils.linkForRef('attr:Canvas.disabled','disabled')}, or when this item \n ${isc.DocUtils.linkForRef('attr:FormItem.canHover','suppresses hovers')}, this prompt will not\n be shown.",flags:"IRW",name:"prompt"},"type:SCClassName":{seeAlso:[],ref:"type:SCClassName",deprecated:null,type:"type",description:"Name of a SmartClient Class, that is, a Class that has been created via\n ${isc.DocUtils.linkForRef('staticMethod:isc.defineClass')}, including Classes built into SmartClient, such as \"ListGrid\".\n \n ",name:"SCClassName",baseType:"String"},"class:FormItemEditProxy":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"EditProxy",classMethods:[],classAttrs:[],attrs:["attr:FormItemEditProxy.valueMapSeparatorChar","attr:FormItemEditProxy.valueMapDisplaySeparatorChar","attr:FormItemEditProxy.valueMapSelectedChar","attr:FormItemEditProxy.valueMapEscapeChar"],groups:["devTools"],ref:"class:FormItemEditProxy",deprecated:null,treeLocation:["Client Reference/Tools/EditProxy"],description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:FormItem')}s when editMode is enabled.",methods:[],name:"FormItemEditProxy"},"classMethod:Browser.setIsTablet":{seeAlso:[],ref:"classMethod:Browser.setIsTablet",deprecated:null,type:"classMethod",definingClass:"class:Browser",params:[{defaultValue:null,optional:false,type:"boolean",description:"new setting for <code>Browser.isTablet</code>.",name:"isTablet"}],description:" Setter for ${isc.DocUtils.linkForRef('classAttr:Browser.isTablet')} to allow this global variable to be changed at runtime.\n This advanced method is provided to override SmartClient's detection of devices, since the\n framework can only detect devices that existed at the time the platform was released. Any\n changes to ${isc.DocUtils.linkForRef('classAttr:Browser.isDesktop')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}, or ${isc.DocUtils.linkForRef('classAttr:Browser.isTablet')}\n must be made before any component is created;\n <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,\n <code>isHandset</code>, or <code>isTablet</code> after components have been created.\n <p>\n Note that setting <code>Browser.isTablet</code> might affect the values of\n ${isc.DocUtils.linkForRef('classAttr:Browser.isDesktop')} and ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}.\n\n",flags:"A",name:"setIsTablet"},"attr:OperationBinding.transformResponseScript":{seeAlso:[],defaultValue:"null",requiresModules:["SCServer"],type:"attr",definingClass:"class:OperationBinding",groups:["serverScript"],ref:"attr:OperationBinding.transformResponseScript",deprecated:null,valueType:"String",description:"Scriptlet to be executed after the DataSource operation which is configured by this\n operationBinding.  See ${isc.DocUtils.linkForRef('attr:DataSource.transformResponseScript')} for further details.\n <p>\n Note, unlike many OperationBinding-level properties, a <code>transformResponseScript</code>\n at the OperationBinding level does not hide a <code>transformResponseScript</code> defined \n at the DataSource level.  Instead, if you define <code>transformResponseScript</code> against\n both the DataSource and the OperationBinding, <b>both</b> are run - first the \n DataSource-level script, then the OperationBinding-level one.",flags:"IR",serverDS:"only",name:"transformResponseScript"},"method:FacetChartEditProxy.setInlineEditText":{seeAlso:[],ref:"method:FacetChartEditProxy.setInlineEditText",deprecated:null,type:"method",definingClass:"class:FacetChartEditProxy",params:[{defaultValue:null,optional:false,type:"String",description:"the new component data",name:"newValue"}],description:" Save the new value into the component's state. Called by the\n ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditForm')} to commit the change.\n <p>\n Updates the component's <code>facets</code> and <code>data</code>.\n <p>\n Lines starting with \"--\" or \"==\" are considered titles. A single title\n is used as the chart title. Titles are matched to the next series of\n data. If titles are provided for each series, a legend will be shown.\n <p>\n Series data can be entered as a list of values separated by commas\n (see ${isc.DocUtils.linkForRef('attr:FacetChartEditProxy.dataSeparatorChar','dataSeparatorChar')}) or as a valueMap-style\n list of <code>label:value</code> pairs. The first data series defines the\n number of chart values and the titles, if provided.\n\n",flags:"",name:"setInlineEditText"},"attr:FacetChart.drawTitleBackground":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["chartTitle"],deprecated:null,ref:"attr:FacetChart.drawTitleBackground",valueType:"Boolean",description:"should a background color be set behind the Title. Use\n ${isc.DocUtils.linkForRef('attr:FacetChart.titleBackgroundProperties')} to set these values if this is true.",flags:"IRW",name:"drawTitleBackground"},"attr:WebService.serviceNamespace":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:WebService",groups:["webService"],deprecated:null,ref:"attr:WebService.serviceNamespace",valueType:"URI",description:"Namespace of this WebService, derived from the <code>targetNamespace</code>\n attribute of the <code>&lt;wsdl:definitions&gt;</code> element.",flags:"R",name:"serviceNamespace"},"attr:ListGrid.drawAllMaxCells":{seeAlso:[],defaultValue:"250",type:"attr",definingClass:"class:ListGrid",groups:["performance"],deprecated:null,ref:"attr:ListGrid.drawAllMaxCells",valueType:"int",description:"If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered,\n the full dataset will instead be drawn even if ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','showAllRecords')}\n is false and the viewport size and ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio')} setting would normally have caused\n incremental rendering to be used.\n <P>\n The <code>drawAllMaxCells</code> setting prevents incremental rendering from being used in\n situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200\n cells) which happens to be in a grid with a viewport showing only 20 or so rows.\n Incremental rendering causes a brief \"flash\" during scrolling as the visible portion of the\n dataset is redrawn, and a better scrolling experience can be obtained in this situation by\n drawing the entire dataset up front, which in this example would have negligible effect on\n initial draw time.\n <P>\n <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature\n if performance is an issue and:\n <ul>\n <li> you are very frequently redraw a grid\n <li> you do a lot of computation when rendering each cell (eg formulas)\n <li> you are showing many grids on one screen and the user won't scroll most of them\n </ul>",flags:"IRWA",name:"drawAllMaxCells"},"method:ListGridField.getRecordSummary":{seeAlso:[],ref:"method:ListGridField.getRecordSummary",deprecated:null,type:"method",definingClass:"object:ListGridField",params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"record for which a summary is being generated",name:"record"},{defaultValue:null,optional:false,type:"ListGridField",description:"this field",name:"field"},{defaultValue:null,optional:false,type:"ListGrid",description:"the grid",name:"grid"}],description:" Only applies to ${isc.DocUtils.linkForRef('type:ListGridFieldType','\"summary\"-type')} fields. If specified, this\n method will be called to generate the record summary value to be displayed for each row\n in this field.  When this method is called, current values for other record summary\n fields have not necessarily been stored on the record, but are accessible via\n ${isc.DocUtils.linkForRef('method:ListGrid.getRecordSummary')}.\n <P>\n The grid is passed to be able to evaluate dependency record summary values via\n ListGrid.getRecordSummary(). Other than that, the properties and state of the grid should\n not be used in the implementation of this method. To do so would be a source of undefined\n behavior.\n <P>\n Note that if implemented, this is called instead of making use of the\n ${isc.DocUtils.linkForRef('attr:ListGridField.recordSummaryFunction')}.\n <P>\n If ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} or ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} is true, this\n field's value in the summary row[s] will still be calculated by calling this method.\n In this case, the record object passed in will contain summary values for each field.\n If custom handling is required for this case, it may be detected by checking the\n record object's ${isc.DocUtils.linkForRef('attr:ListGridRecord.isGroupSummary')} and ${isc.DocUtils.linkForRef('attr:ListGridRecord.isGridSummary')}\n attributes.\n\n\n\n\n\n\n\n\n\n\n",flags:"A",returns:{type:"Any",description:"summary value to display"},name:"getRecordSummary"},"group:i18n":{refs:["classAttr:Comm.concurrentXHRErrorMessage"],seeAlso:[],ref:"group:i18n",treeLocation:["Concepts"],deprecated:null,type:"group",title:"Internationalization and Localization",description:"<b><u>Internationalizing SmartClient Applications</u></b>\n <p>\n Internationalizing a SmartClient application involves creating locale-specific\n versions of all strings, images, and possibly colors.  In some cases, component layout may\n be affected as well (for example date field order differs between some locales).\n <p>\n <u><b>Character Encodings</b></u>\n <p>\n In order to deliver content in different languages to the browser and have it be displayed\n correctly, it is important that the browser and server agree on the character encoding being\n used to send the page.  \n <p>\n Generally speaking, you can use whatever character encoding you prefer, so long as\n you're consistent about serving your files to the browser with exactly the same encoding\n as was used to save the file to disk.  Keep in mind though that the character encoding you\n choose must be supported by all browsers you intend to support.  Isomorphic recommends that,\n where possible, you use the UTF-8 encoding.  Regardless of which character encoding you\n choose, keep in mind that for the browser to correctly display non-ASCII characters, you\n <b>must</b> explicitly set the character encoding of your page to match the encoding you\n used to save the file.  Browsers have built-in heuristics to guess the character encoding,\n but they can't be relied upon to work 100% of the time.\n <p>\n There are two ways to explicitly tell the browser what character\n encoding is being used for a given page.  One is to set the \"Content-Type\" HTTP header, for\n example:\n <pre>\n Content-Type: text/html; charset=UTF-8\n </pre>\n If you're using JSP on the back-end, you can set this header as follows:\n <pre>\n &lt;%@ page contentType=\"text/html; charset=UTF-8\"%&gt;\n </pre>\n Or using Java Servlet APIs in a Servlet as follows:\n <pre>\n response.setContentType(\"text/html; charset=UTF-8\");\n </pre>\n Note that the latter needs to be done before any content is written to the response output\n stream.\n <p>\n The other approach to setting the content encoding is to use an HTML META tag to embed it\n in the page itself (note that this applies to HTML documents only).  The META tag must go\n inside the &lt;HEAD&gt; HTML element - e.g. as follows:\n <pre>\n &lt;HEAD&gt;\n &lt;META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\"&gt;\n &lt;/HEAD&gt;\n </pre>\n In addition, for a .html or other static (non-.jsp) file, you must also ensure that the file\n itself is saved in UTF-8 encoding.  Advanced text editors (including the Eclipse IDE) can\n show you the encoding of a text file and allow you to change it.  In Eclipse this is in the\n Preferences area (search for \"Encoding\") and UTF-8 is <b>not the default</b> for .html\n files, and should be changed.\n <P>\n Isomorphic recommends that you follow <b>all</b> of the above approaches for maximum\n compatibility.  For example, if you omit the META tag approach, pages saved by the user\n using the browser save function may not render correctly when subsequently read from disk\n because HTTP headers are not available in that context.  Conversely, not providing the\n HTTP header or not saving the file in UTF-8 can result in application servers delivering the\n file in the encoding in which it is saved, or in their own default and incorrect content\n encoding.\n <p>\n If you're using a given character encoding pervasively in your pages, you can also configure\n your web server or application server to use that character encoding as the default for all\n pages of a given mime type or some other criteria (depending on the capability of your\n server) - for example on a per-directory basis.\n <p>\n For more information on character encodings, character sets, and working with HTML, please\n see W3C's tutorial here:\n <a href='http://www.w3.org/International/tutorials/tutorial-char-enc/' target='_blank'>http://www.w3.org/International/tutorials/tutorial-char-enc/</a>\n <p>\n <b>NOTE: Default Encoding</b>\n <p>\n As mentioned above, Isomorphic recommends the use of UTF-8 encoding.  However, it is \n not possible to configure some servlet engines to do this by default.  Both Tomcat and Jetty \n default to the ISO-8859-1 character set (commonly known as Latin-1), even if the Java VM \n specifies a different encoding (the Tomcat documentation claims that this behavior is a \n requirement of the Servlet specification).\n <p>\n To work around this, we change charset encoding to UTF-8 on every request/response that \n goes through two core Isomorphic servlets: <code>IDACall</code> and <code>DataSourceLoader</code>.\n If you need to change this, you can do so by adding <code>init-param</code> settings to your\n <code>web.xml</code> file.  Please see the Javadocs for those two servlets for examples of \n how to do this.\n <p>\n <u><b>Framework Message Localization</b></u>\n <p>\n SmartClient components include standard prompts and error messages in various cases, and all\n such messages support localization.\n <P>\n \n Language packs are included in the directory smartclientSDK/isomorphic/locales.  To load a\n language pack, simply include the desired locale via a\n standard HTML &lt;script src=&gt; tag, for example: \n <pre>\n    &lt;SCRIPT SRC=\"isomorphic/locales/frameworkMessages_pt.properties\"&gt;&lt;/SCRIPT&gt;\n </pre>\n .. to load the Portuguese locale. \n <p>\n Alternatively can use the <code>locale</code> attribute on the <code>loadISC</code> or\n <code>loadModules</code> jsp tags:\n <pre>\n   &lt;isomorphic:loadISC skin=\"Enterprise\" locale=\"pt\"/&gt; \n </pre>\n Or, if you have the ${isc.DocUtils.linkForRef('group:networkPerformance','Network Performance')}, you can use the\n ${isc.DocUtils.linkForRef('classMethod:FileLoader.loadLocale')}/${isc.DocUtils.linkForRef('classMethod:FileLoader.cacheLocale')} APIs:\n <pre>\n   isc.FileLoader.loadLocale(\"pt\");\n </pre>\n <p>\n To see various locales, have a look at the \n ${isc.DocUtils.linkForExampleId('changeLocales', 'Localization example')}.\n \n \n <P>\n If you find that the language pack you are using has any incorrect or missing translations,\n or you want to add a new language pack, please visit\n <a href='http://forums.smartclient.com/showthread.php?t=9987' target='_blank'>this forums thread</a> for\n instructions on how to contribute translations so that they will be added to future\n SmartClient builds.\n <P>\n You can alternatively maintain your own private additions or overrides to the default\n language packs.\n \n A complete list of standard messages is presented ${isc.DocUtils.linkForRef('group:i18nMessages','here')}.<br>\n To customize these messages, use ${isc.DocUtils.linkForRef('method:Class.addProperties')} or\n ${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties')} to override default values at the instance or class level\n respectively.  For example, the class property\n ${isc.DocUtils.linkForRef('classAttr:RPCManager.timeoutErrorMessage')} is displayed to the user in a warning dialog\n when a SmartClient operation fails to complete.  This can be modified using the\n ${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties')} method, as follows:\n <pre>\n isc.RPCManager.addClassProperties({timeoutErrorMessage:\"Custom Timeout Message\"});\n </pre>\n \n \n <p>\n <u><b>Application Message Localization</b></u>\n <p>\n \n Text such as button titles typically appears in the middle of JavaScript code:\n <pre>\n     isc.Button.create({ title: \"Click me!\"});\n </pre>\n If you are on the Java platform and your JavaScript code appears in a .jsp, you can use the\n JSTL Core package (Java Server Pages Standard Tag Library) to replace that static \"Click\n me!\" text with a localized reference.  This can be done as follows:\n <pre>\n     &lt;%@ taglib prefix=\"fmt\" uri=\"/WEB-INF/fmt.tld\" %&gt;\n     &lt;SCRIPT&gt;\n     isc.Button.create({ title: &lt;fmt:message key=\"buttonTitle\"&gt; });\n     &lt;/SCRIPT&gt;\n </pre>\n Assuming you've set the current Locale and provided a resource bundle with the relevant\n translated text, the above would create a button with a title that comes from the locale-specific\n bundle you provided.  For more information, see Sun's i18n tutorial:\n <a href='http://java.sun.com/docs/books/tutorial/i18n/' target='_blank'>http://java.sun.com/docs/books/tutorial/i18n/</a>.\n <P>\n Note that this approach does not imply that your JavaScript must appear in the midst of an\n HTML page.  A .jsp file can be used to return a pure JavaScript response via just removing\n the &lt;SCRIPT&gt; tags in the example above, and targetting the .jsp with a &lt;SCRIPT\n SRC=&gt; tag from another .jsp or .html file.\n <P>\n A second common technique is to load internationalized messages as a JavaScript Object\n mapping from a message name to the internationalized message.  For example, if your messages\n are stored in Java .properties format, you could load your .properties file as a standard Java\n <a href='http://docs.oracle.com/javase/6/docs/api/java/util/Properties.html' target='_blank'>Properties object</a>, \n and use the server-side com.isomorphic.js.JSTranslater.toJSVariable() API to output the\n properties as a JavaScript variable.\n <P>\n If the variable name chosen was 'i18nMessages', code to make use of the .properties data\n would look like:\n <pre>\n     isc.Button.create({ title: i18nMessages[\"buttonTitle\"] });\n </pre>\n <P>\n Approaches for non-Java platforms are similar, and generally any approach that works for\n HTML or JavaScript files works with SmartClient.  See the end of this section for pointers\n to additional resources.\n \n \n <p>\n <u><b>Localizing Server-side Error Messages</b></u>\n <p>\n If you are providing error messages from server-side code, use standard Java techniques to\n determine the locale (<code>servletRequest.getLocale()</code>) and load ResourceBundles.\n Note that if you are using ${isc.DocUtils.linkForRef('attr:Validator.serverObject','DMI validation')}, the\n HttpServletRequest is available via the standard ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} approach: just\n declare it as an additional parameter, and it is provided.\n <p>\n <u><b>Support for Right-to-Left (RTL) languages</b></u>\n <p>\n SmartClient includes support for RTL languages.  To enable, simply set\n <code>dir=\"rtl\"</code> on the HTML element:\n <pre>\n    &lt;HTML dir=\"rtl\"&gt;\n </pre>\n ListGrid columns, horizontal layouts, scrolling directions, etc will reverse order\n automatically.\n <p>\n Because RTL in some cases requires additional media files, RTL is only supported for the\n Enterprise, EnterpriseBlue and Graphite skins.\n <p>\n <u><b>DataSource and Component XML localization</b></u>\n <p>\n Please see the separate article on \n ${isc.DocUtils.linkForRef('group:dataSourceLocalization','DataSource and Component XML Localization')}\n <p>\n <u><b>Localized Number and Currency Formatting</b></u>\n <p>\n Please see the separate article on \n ${isc.DocUtils.linkForRef('group:localizedNumberFormatting','Localized Number Formatting')}\n <p>\n \n <u><b>Image, CSS localization</b></u>\n <p>\n Most SmartClient components use a mixture of text, CSS and images to render.  If you wish to\n provide locale-specific images or use locale-specific CSS, you can create localized copies\n of a SmartClient skin named after the locale and modify images as you see fit.  A skin is\n specified at load time using either the <code>skin</code> attribute of the\n <code>&lt;isomorphic:loadISC&gt;</code> tag or by loading the skin\n directly using a script tag like so: &lt;SCRIPT SRC=/isomorphic/skins/[skin]/load_skin.js&gt;.\n If you're using the <code>loadISC</code> tag, you can specify a locale-specific skin like so:\n <pre>\n &lt;isomorphic:loadISC skin=\"[localeName]\"/&gt;\n </pre>\n Or you can use a script tag like so:\n <pre>\n &lt;SCRIPT SRC=/isomorphic/skins/[localeName]/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n Where the <code>[localeName]</code> is the name of the current locale - you'll have this in the\n current page context as you'll need it to use the JSTL &lt;fmt:setLocale&gt; tag.\n <p>\n \n Resources:\n <p>\n <b><u>Java</u></b>\n <ul>\n <li>Sun's i18n tutorial: <a href='http://java.sun.com/docs/books/tutorial/i18n/' target='_blank'>http://java.sun.com/docs/books/tutorial/i18n/</a>\n <li>JSTL documentation home page: <a href='https://www.oracle.com/java/technologies/jstl-documentation.html' target='_blank'>https://www.oracle.com/java/technologies/jstl-documentation.html</a>\n <li>Apache taglibs: <a href='https://tomcat.apache.org/taglibs/index.html' target='_blank'>https://tomcat.apache.org/taglibs/index.html</a>\n </ul>\n <p>\n\n <b><u>.NET</u></b>\n <ul>\n <li>MSDN Developer Resource: \"Developing World-Ready Applications\":\n <a href='https://docs.microsoft.com/en-us/dotnet/core/extensions/best-practices-for-developing-world-ready-apps' target='_blank'>https://docs.microsoft.com/en-us/dotnet/core/extensions/best-practices-for-developing-world-ready-apps</a>\n </ul>\n\n <b><u>PHP</u></b>\n <ul>\n <li>PHP Gettext manual: <a href='http://us2.php.net/gettext' target='_blank'>http://us2.php.net/gettext</a>\n </ul>\n <p>",name:"i18n"},"attr:MetricSettings.showAxisLine":{seeAlso:[],ref:"attr:MetricSettings.showAxisLine",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:MetricSettings",valueType:"boolean",description:"Whether to show an axis line for this extra value axis if it is not placed\n directly adjacent to the chart rect.  The default setting is the value\n of the ${isc.DocUtils.linkForRef('attr:FacetChart.showChartRect','showChartRect')} property of the FacetChart.",flags:"IR",name:"showAxisLine"},"type:ClickMaskMode":{groups:["clickMask"],seeAlso:[],ref:"type:ClickMaskMode",deprecated:null,type:"type",values:[{value:'"hard"',description:"When the mask receives a click, it will fire its click action,                   and cancel the event, leaving the clickMask up."},{value:'"soft"',description:"When the mask receives a click, it will fire its click action,                   then dismiss the clickMask and allow the event to proceed to its target."}],description:"Passed as a parameter to ${isc.DocUtils.linkForRef('method:Canvas.showClickMask')} to determine the masks behavior\n when clicked.",name:"ClickMaskMode"},"attr:ListGrid.recordCustomStyleProperty":{seeAlso:[{ref:"method:ListGrid.getCellStyle",description:null},{ref:"attr:ListGrid.recordBaseStyleProperty",description:null}],ref:"attr:ListGrid.recordCustomStyleProperty",defaultValue:'"customStyle"',deprecated:null,type:"attr",definingClass:"class:ListGrid",valueType:"String",description:'Denotes the name of a property that can be set on records to display a custom style.\n For example if this property is set to <code>"customStyle"</code>, setting \n <code>record.customStyle</code> to a css styleName will cause the record in question to\n render out with that styling applied to it.  Note that this will be a static \n style - it will not be modified as the state of the record (selected / over etc) changes.',flags:"IRW",name:"recordCustomStyleProperty"},"attr:DecisionTask.failureElement":{seeAlso:[],ref:"attr:DecisionTask.failureElement",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:DecisionTask",valueType:"String",description:"ID of the next sequence or element to proceed to if the criteria do not match.",flags:"IR",name:"failureElement"},"method:MenuBar.removeMenus":{seeAlso:[],ref:"method:MenuBar.removeMenus",deprecated:null,type:"method",definingClass:"class:MenuBar",params:[{defaultValue:null,optional:false,type:"Array",description:"Array of menus to remove (will accept actual Menu components,                       or numbers representing the index of the menus in the current menus array)",name:"menus"}],description:" Dynamically remove menus from the menuBar. Will update the visible set of buttons as \n appropriate.\n",flags:"",name:"removeMenus"},"attr:MenuButton.menu":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:MenuButton",groups:["menu"],deprecated:null,ref:"attr:MenuButton.menu",valueType:"Menu",description:"The menu to show.\n <P>\n For a menu button with no menu (menu: null) the up/down arrow image can\n be suppressed by setting\n ${isc.DocUtils.linkForRef('attr:MenuButton.showMenuButtonImage','showMenuButtonImage')}: <code>false</code>.",flags:"IRW",name:"menu"},"classAttr:Window.HORIZONTAL":{seeAlso:[],defaultValue:'"horizontal"',type:"classAttr",definingClass:"class:Window",deprecated:null,ref:"classAttr:Window.HORIZONTAL",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:ContentLayoutPolicy','ContentLayoutPolicy')}.",flags:"R",name:"HORIZONTAL",constant:true},"attr:Calendar.canSelectEvents":{seeAlso:[],ref:"attr:Calendar.canSelectEvents",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"Boolean",description:"When set to true, makes individual ${isc.DocUtils.linkForRef('class:EventCanvas','event canvases')} selectable.\n Events may be selected via a single click, as well as being\n included in the page's tab order. The current selected event is shown in a special \n style and pressing TAB or Shift-TAB will move the selection first among the events \n in the same lane, and then among those in the next or previous lane.\n <P>\n Pressing Enter while an editable event is selected \n will show either the event- ${isc.DocUtils.linkForRef('attr:Calendar.eventDialog','dialog')} or \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','editor')}.  Pressing Delete will remove the event.\n <P>\n Note that when this property is false, single clicking the event canvas for an\n editable event will bring up an editing interface for that event. \n When true this is no longer the case - a user can double click to bring up the editing\n interface instead (a single click will simply select the event canvas).",flags:"IR",name:"canSelectEvents"},"attr:FacetChart.standardDeviations":{seeAlso:[],defaultValue:"[-1, 1]",type:"attr",definingClass:"class:FacetChart",groups:["statistics"],deprecated:null,ref:"attr:FacetChart.standardDeviations",valueType:"Array of Float",description:'When ${isc.DocUtils.linkForRef(\'attr:FacetChart.showStandardDeviationLines\')} is set, the number of standard deviation lines drawn\n and their respective standard deviation away from the mean are specified by this property.\n The default is to display lines corresponding to the mean plus or minus one standard\n deviation.\n <p>\n Note that having zero in this list of standard deviations is identical to drawing\n a line at the mean.\n <p>\n For example assume that chart1 and chart2 both plot data with mean 1 and standard deviation 0.1.\n chart1 will draw a blue line at the value 1 and two red lines at the values 0.7 and 1.2.\n chart2 will draw three red lines at values 0.9, 1.0, and 1.1.\n <p>\n \n <pre>\n isc.FacetChart.create({\n     ID: "chart1",\n     standardDeviations: [-3, 2],\n     showExpectedValueLine: true,\n     showStandardDeviationLines: true,\n     expectedValueLineProperties: { lineColor: "blue" },\n     standardDeviationLineProperties: { lineColor: "red" },\n     // ...\n });\n\n isc.FacetChart.create({\n     ID: "chart2",\n     standardDeviations: [-1, 0, 1],\n     showExpectedValueLine: false,\n     showStandardDeviationLines: true,\n     expectedValueLineProperties: { lineColor: "blue" },\n     standardDeviationLineProperties: { lineColor: "red" },\n     // ...\n });\n </pre>\n \n ',flags:"IR",name:"standardDeviations"},"group:reifyMaven":{refs:[],seeAlso:[],ref:"group:reifyMaven",treeLocation:["Concepts"],deprecated:null,type:"group",title:"Importing from Reify",description:"SmartClient \n ${isc.DocUtils.linkForRef('group:mavenSupport','support for Maven')} includes the ability to \n <a href='http://github.smartclient.com/isc-maven-plugin/reify-import-mojo.html' target='_blank'>import</a>\n (and optionally, \n <a href='http://github.smartclient.com/isc-maven-plugin/reify-validate-mojo.html' target='_blank'>verify</a>\n ) assets from <a href='http://reify.com' target='_blank'>reify.com</a> into your project either on-demand \n or during your build process.  Using the \n <a href='http://github.smartclient.com/isc-maven-plugin/examples/configuration.html' target='_blank'>example configuration</a>, \n the import command might look something like the following:\n <p>\n <pre>\n   mvn com.isomorphic:isc-maven-plugin:1.4.5:reify-import -Pisc\n </pre>\n <strong>Important:</strong> This flow is unidirectional.  That is, whatever changes are to \n be made to these resources should be made using the collaborative Reify environment and then\n re-imported.  There is, by design, no reason to modify them locally, and the plugin takes\n steps to notify you when that happens.\n Refer to the ${isc.DocUtils.linkForRef('group:reifyForDevelopers','Reify for Developers')} documentation topic for \n further discussion.",name:"reifyMaven"},"attr:ScreenLoader.dataContextBinding":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ScreenLoader",groups:["dataContext"],ref:"attr:ScreenLoader.dataContextBinding",deprecated:null,setter:["setDataContextBinding"],valueType:"DataContextBinding",description:"A ${isc.DocUtils.linkForRef('object:DataContextBinding')} to be applied to the loaded screen via\n ${isc.DocUtils.linkForRef('method:Canvas.setDataContext')}.",flags:"IWR",name:"dataContextBinding"},"method:ListPropertiesDialog.applyClick":{seeAlso:[],ref:"method:ListPropertiesDialog.applyClick",deprecated:null,type:"method",definingClass:"class:ListPropertiesDialog",params:[{defaultValue:null,optional:false,type:"ListProperties",description:"the list properties to apply",name:"listProperties"}],description:" Notification method fired when the ${isc.DocUtils.linkForRef('attr:ListPropertiesDialog.applyButton','Apply button')}\n is clicked.\n",flags:"",name:"applyClick"},"attr:StretchImgButton.labelHPad":{seeAlso:[],ref:"attr:StretchImgButton.labelHPad",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:StretchImgButton",valueType:"number",description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",flags:"IRW",name:"labelHPad"},"classAttr:FieldPickerField.frozenTitle":{seeAlso:[],defaultValue:'"Is Frozen"',type:"classAttr",definingClass:"class:FieldPickerField",groups:["i18nMessages"],deprecated:null,ref:"classAttr:FieldPickerField.frozenTitle",valueType:"String",description:"The title displayed for the frozen property",flags:"IR",name:"frozenTitle"},"classAttr:RPCResponse.STATUS_REQUIRED_CRITERIA_MISSING":{seeAlso:[],defaultValue:"-13",type:"classAttr",definingClass:"class:RPCResponse",groups:["statusCodes","constant"],deprecated:null,ref:"classAttr:RPCResponse.STATUS_REQUIRED_CRITERIA_MISSING",valueType:"int",description:"Indicates that an operation binding configured to require ${isc.DocUtils.linkForRef('attr:OperationBinding.requiredCriterion')} has received none.",flags:"R",name:"STATUS_REQUIRED_CRITERIA_MISSING"},"attr:Slider.rangeFormat":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Slider",groups:["appearance"],deprecated:null,ref:"attr:Slider.rangeFormat",valueType:"FormatString",description:"${isc.DocUtils.linkForRef('type:FormatString')} for numeric formatting of the range labels.  If unset, defaults to \n ${isc.DocUtils.linkForRef('attr:Slider.valueFormat')}",flags:"IR",name:"rangeFormat"},"attr:TourStep.afterInputTarget":{seeAlso:[],ref:"attr:TourStep.afterInputTarget",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TourStep",valueType:"String",description:"Target component which must clicked to process ${isc.DocUtils.linkForRef('attr:TourStep.expectedValue')} entered into\n ${isc.DocUtils.linkForRef('attr:TourStep.target','target')} with ${isc.DocUtils.linkForRef('attr:TourStep.actionType','actionType')} of \"change\".\n <P>\n This is commonly used for a dialog where the must select a value and then click\n a submit button.\n <P>\n Target may be specified as a ${isc.DocUtils.linkForRef('type:GlobalId')} for a Component or FormItem, or as a\n ${isc.DocUtils.linkForRef('type:AutoTestLocator')} for an element.",flags:"IR",name:"afterInputTarget"},"attr:ListGrid.canConfigureViaAI":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["ai"],deprecated:null,ref:"attr:ListGrid.canConfigureViaAI",valueType:"Boolean",description:"Whether to show the ${isc.DocUtils.linkForRef('attr:ListGrid.configureViaAIText','Configure via AI')} menu-item, which \n allows users to task the AI with performing multiple advanced configuration steps, such \n as grouping, hiliting and filtering, by entering plain-text commands.",flags:"IRW",name:"canConfigureViaAI"},"attr:DataSource.script":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DataSource",ref:"attr:DataSource.script",deprecated:null,valueType:"String",description:"Default scriptlet to be executed on the server for each operation. If ${isc.DocUtils.linkForRef('attr:OperationBinding.script')} is\n specified, it will be executed for the operation binding in question instead of running this scriptlet.\n <P>\n Scriptlets are used similarly to DMIs configured via ${isc.DocUtils.linkForRef('attr:DataSource.serverObject')} or\n ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject')} -\n they can add business logic by modifying the DSRequest before it's executed, modifying the\n default DSResponse, or taking other, unrelated actions.  \n <P>\n For example:\n <pre>\n    &lt;DataSource&gt;\n       &lt;script language=\"groovy\"&gt;\n          ... Groovy code ...\n       &lt;/script&gt;\n      ... other DataSource properties\n    &lt;/DataSource&gt;\n </pre>\n <P>\n Scriptlets can be written in any language supported by the \"JSR 223\" standard, including Java\n itself.  See the ${isc.DocUtils.linkForRef('group:dmiOverview','DMI Script Overview')} for rules on how to return data,\n add additional imports, and other settings.\n <P>\n The following variables are available for DMI scriptlets:\n <ul>\n <li><i>requestContext</i>: RequestContext (from com.isomorphic.servlet)</li>\n <li><i>dataSource</i>: the current DataSource (same as DSRequest.getDataSource())</li>\n <li><i>dsRequest</i>: the current DSRequest</li>\n <li><i>criteria</i>: shortcut to DSRequest.getCriteria() (a Map)</li>\n <li><i>values</i>: shortcut to DSRequest.getValues() (a Map)</li>\n <li><i>oldValues</i>: shortcut to DSRequest.getOldValues() (a Map)</li>\n <li><i>log</i>: an instance of <code>com.isomorphic.log.Logger</code>, so your scripts\n can log in the same manner as regular Java code</li>\n <li><i>config</i>: an instance of <code>com.isomorphic.base.Config</code>, so your scripts\n have access to your <code>server.properties</code> settings</li>\n <li><i>sqlConnection</i>: <b>SQLDataSource only</b>: the current SQLConnection object.  If\n using ${isc.DocUtils.linkForRef('attr:DataSource.autoJoinTransactions','automatic transactions')} are enabled, this\n SQLConnection is in the context of the current transaction</li>\n <li><i>rpcManager</i>: the current RPCManager</li>\n <li><i>applicationContext</i>: the Spring ApplicationContext (when applicable)</li>\n <li><i>beanFactory</i>: the Spring BeanFactory (when applicable)</li>\n </ul>\n <P>\n Scriptlets also have access to a set of contextual variables related to the Servlets\n API, as follows:\n <ul>\n <li><i>servletRequest</i>: the current ServletRequest\n <li><i>session</i>: the current HttpSession\n <li><i>servletResponse</i>: the current ServletResponse <b>(advanced use only)</b>\n <li><i>servletContext</i>: the current ServletContext<b>(advanced use only)</b>\n </ul>\n As with DMI in general, be aware that if you write scriptlets that depend upon these variables,\n you preclude your DataSource from being used in the widest possible variety of\n circumstances.  For example, adding a scriptlet that relies on the <code>HttpSession</code>\n prevents your DataSource from being used in a command-line process.\n <P>\n <i>Note that if a dataSource configuration has both a <code>&lt;script&gt;</code> block and\n a specified ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject','serverObject')} for some operation, the\n script block will be executed, and the serverObject ignored.</i>",flags:"IR",serverDS:"only",examples:["${isc.DocUtils.linkForExampleId('scriptingUserSpecificData')}"],name:"script"},"attr:FormItem.printTextBoxStyle":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["printing","formItemStyling"],deprecated:null,ref:"attr:FormItem.printTextBoxStyle",valueType:"FormItemBaseStyle",description:"Base CSS class name for a form item's text box element when getting printable HTML for the\n form. If unset ${isc.DocUtils.linkForRef('attr:FormItem.textBoxStyle')} will be used instead. Note that focused styling\n will never be displayed while printing, though error and disabled styling will.\n <P>\n By default this style will be used for printHTML for the item even if the item is\n ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit:false')} with ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay','readOnlyDisplay:static')}.<br>\n To override this behavior, developers may also specify a custom print style for this \n state via the \n ${isc.DocUtils.linkForRef('attr:FormItem.printReadOnlyTextBoxStyle')}.",flags:"IRW",name:"printTextBoxStyle"},"classMethod:Notify.addMessage":{seeAlso:[{ref:"staticMethod:isc.say",description:null},{ref:"staticMethod:isc.confirm",description:null},{ref:"staticMethod:isc.notify",description:null}],ref:"classMethod:Notify.addMessage",deprecated:null,type:"classMethod",definingClass:"class:Notify",params:[{defaultValue:null,optional:false,type:"HTMLString",description:"message to be displayed",name:"contents"},{defaultValue:null,optional:true,type:"Array of NotifyAction",description:"actions (if any) for this message",name:"actions"},{defaultValue:null,optional:true,type:"NotifyType",description:'category of message; default "message"',name:"notifyType"},{defaultValue:null,optional:true,type:"NotifySettings",description:"display and behavior settings for                                               this message that override the\n                                               ${isc.DocUtils.linkForRef('classMethod:Notify.configureMessages','configured')}\n                                               settings for the <code>notifyType</code>",name:"settings"}],description:" Displays a new message, subject to the ${isc.DocUtils.linkForRef('classMethod:Notify.configureMessages','stored configuration')}\n for the passed <code>notifyType</code>, overridden by any passed <code>settings</code>.\n Returns an opaque <code>MessageID</code> that can be passed to ${isc.DocUtils.linkForRef('classMethod:Notify.dismissMessage')}\n to clear it.\n <P>\n Note that an empty string may be passed for <code>contents</code> if <code>actions</code>\n have been provided, so you may have the message consist only of your specified actions.\n <P>\n Most users should do all configuration up front via a call to ${isc.DocUtils.linkForRef('classMethod:Notify.configureMessages')}.\n The <code>settings</code> argument in this method is provided to allow adjustment of\n properties that affect only one message, such as ${isc.DocUtils.linkForRef('attr:NotifySettings.autoFitWidth','autoFitWidth')}, ${isc.DocUtils.linkForRef('attr:NotifySettings.styleName','styleName')}, or \n ${isc.DocUtils.linkForRef('attr:NotifySettings.labelProperties','labelProperties')}.  Making changes to \n ${isc.DocUtils.linkForRef('type:MultiMessageMode','stacking')}-related properties via this argument isn't supported,\n unless specifically documented on the property.\n \n",flags:"",returns:{type:"MessageID",description:"opaque identifier for message"},name:"addMessage"},"attr:TourStep.allowDropOnDescendants":{seeAlso:[],ref:"attr:TourStep.allowDropOnDescendants",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TourStep",valueType:"Boolean",description:"For ${isc.DocUtils.linkForRef('attr:TourStep.actionType','actionType:\"drag\"')} tourSteps with a ${isc.DocUtils.linkForRef('attr:TourStep.dropTarget')},\n should we allow the drop to complete and the tour to proceed if the user drops on a\n descendant of the drop target.\n <P>\n For example - if a user has been prompted to drag a component into a Layout, but \n the layout already contains a nested child layout, should the user be able to \n drop into that child layout and continue the tour?\n <P>\n If unset this will be derived from ${isc.DocUtils.linkForRef('attr:Tour.allowDropOnDescendants')}",flags:"IR",name:"allowDropOnDescendants"},"attr:Calendar.eventEditor":{seeAlso:[],ref:"attr:Calendar.eventEditor",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"AutoChild DynamicForm",description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} of type ${isc.DocUtils.linkForRef('class:DynamicForm')} which displays ${isc.DocUtils.linkForRef('object:CalendarEvent','event data')}. \n This form is created within the ${isc.DocUtils.linkForRef('attr:Calendar.eventEditorLayout','event editor layout')}",flags:"R",name:"eventEditor"},"attr:Dialog.defaultWidth":{seeAlso:[],defaultValue:"360",type:"attr",definingClass:"class:Dialog",groups:["appearance"],deprecated:null,ref:"attr:Dialog.defaultWidth",valueType:"int",description:null,flags:"IR",name:"defaultWidth"},"method:ListGrid.formatInactiveCellValue":{seeAlso:[{ref:"method:ListGrid.formatCellValue",description:null},{ref:"method:ListGridField.formatInactiveCellValue",description:null}],ref:"method:ListGrid.formatInactiveCellValue",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"Any",description:"raw value for the cell being",name:"value"},{defaultValue:null,optional:false,type:"ListGridRecord",description:"Record object for the cell. Note: If this is a new row that has not been saved, in an\n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",name:"record"},{defaultValue:null,optional:false,type:"number",description:"row number for the cell",name:"rowNum"},{defaultValue:null,optional:false,type:"number",description:"column number for the cell.",name:"colNum"}],description:" Formatter for inactive content.\n <P>\n If present, this method will be invoked instead of ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue')} in cases \n where the grid is rendering non-interactive content outside. Examples of cases\n where this can happen include:<ul>\n <li>dragTracker HTML for a row when ${isc.DocUtils.linkForRef('attr:ListGrid.dragTrackerMode')} is set to\n    \"record\"</li>\n <li>measurement HTML used for sizing columns during autoFit</li>\n <li>measurement HTML used for sizing rows when ${isc.DocUtils.linkForRef('attr:ListGrid.fixedRecordHeights')}\n     is false and the grid has both frozen and unfrozen fields</li>\n </ul>\n May also be overridden at the ${isc.DocUtils.linkForRef('method:ListGridField.formatInactiveCellValue','field level')}.\n <P>\n This is useful for cases where it would not be appropriate to render the \n standard formatted cell value outside of the body of the grid. An example might be\n if the formatted value contains a DOM element with a specified ID - an approach\n sometimes used for integrating third party components into SmartClient listGrid\n cells. In this case developers will wish to avoid having the framework render an\n element with the same ID outside of the grid, and should instead return HTML that\n would render at the same size, with an appropriate appearance.\n\n",flags:"",returns:{type:"HTMLString",description:"formatted value to display in the cell."},name:"formatInactiveCellValue"},"method:Process.reset":{seeAlso:[],ref:"method:Process.reset",deprecated:null,type:"method",definingClass:"class:Process",params:[{defaultValue:null,optional:true,type:"Record",description:"new state of the process",name:"state"}],description:" Reset process to its initial state, so process can be started again.\n",flags:"",name:"reset"},"attr:NavPanel.navLayout":{seeAlso:[],ref:"attr:NavPanel.navLayout",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:NavPanel",valueType:"AutoChild VLayout",description:"The layout serving as the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationPane','navigationPane')} of this panel.\n By default it contains only the ${isc.DocUtils.linkForRef('attr:NavPanel.navGrid')}, but other members can be added before or\n after, respectively, via ${isc.DocUtils.linkForRef('attr:NavPanel.navBeforeMembers')} and ${isc.DocUtils.linkForRef('attr:NavPanel.navAfterMembers')}.",flags:"IR",name:"navLayout"},"class:FileUploadItem":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"CanvasItem",classMethods:[],classAttrs:[],attrs:["attr:FileUploadItem.canvas","attr:FileUploadItem.canvasConstructor","attr:FileUploadItem.canvasDefaults","attr:FileUploadItem.multiple","attr:FileUploadItem.dataSource","attr:FileUploadItem.maxFiles","attr:FileUploadItem.maxSize","attr:FileUploadItem.minSize","attr:FileUploadItem.maxFileSize","attr:FileUploadItem.replaceFilesOnDrop","attr:FileUploadItem.acceptedFileTypes","attr:FileUploadItem.canAddFilesOnClick","attr:FileUploadItem.showFileThumbnails","attr:FileUploadItem.showImagePreviews","attr:FileUploadItem.thumbnailWidth","attr:FileUploadItem.thumbnailHeight","attr:FileUploadItem.showCancelButton","attr:FileUploadItem.emptyDropAreaMessage","attr:FileUploadItem.clickToAddMessage","attr:FileUploadItem.multipleFilesErrorMessage","attr:FileUploadItem.maxFilesErrorMessage","attr:FileUploadItem.maxSizeErrorMessage","attr:FileUploadItem.minSizeErrorMessage","attr:FileUploadItem.maxFileSizeErrorMessage","attr:FileUploadItem.duplicateFileNameMessage","attr:FileUploadItem.invalidFileTypeMessage","attr:FileUploadItem.processingMessage","attr:FileUploadItem.cancelButtonTitle"],ref:"class:FileUploadItem",deprecated:null,treeLocation:["Client Reference/Forms/Form Items"],description:"FormItem for uploading files using HTML5 file drop capabilities.\n <P>\n A FileUploadItem's ${isc.DocUtils.linkForRef('attr:FileUploadItem.canvas','canvas')} is a ${isc.DocUtils.linkForRef('class:FileDropZone')}.\n The ${isc.DocUtils.linkForRef('method:getValue','value')} of a FileUploadItem is the JavaScript File object(s)\n representing files the user added.\n <P>\n FileUploadItem is not the default for <code>binary</code> type fields.\n To use FileUploadItem for binary fields, set ${isc.DocUtils.linkForRef('attr:DynamicForm.useFileUploadItem')}\n to true on the form, or specify <code>editorType:\"FileUploadItem\"</code> on the field.\n <P>\n When the form is ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saved')}, files are uploaded automatically.\n Use ${isc.DocUtils.linkForRef('attr:DynamicForm.showUploadProgress')} to display upload progress.\n <P>\n <b>Single File Upload</b>\n <P>\n With the default setting of ${isc.DocUtils.linkForRef('multiple','multiple:false')}, a FileUploadItem allows\n uploading a single file to a binary field on the DataSource. This is analogous to\n the standard ${isc.DocUtils.linkForRef('class:FileItem')}.\n <P>\n <b>Multiple File Upload</b>\n <P>\n To upload multiple files, set ${isc.DocUtils.linkForRef('multiple','multiple:true')} and configure a\n ${isc.DocUtils.linkForRef('class:DataSource')} property pointing to a related DataSource that will store the files.\n This follows the same master-detail pattern as ${isc.DocUtils.linkForRef('class:MultiFileItem')}:\n <ul>\n <li>The form's DataSource is the \"master\" record (e.g., an email message)</li>\n <li>The FileUploadItem's ${isc.DocUtils.linkForRef('class:DataSource')} is the \"detail\" DataSource storing files\n     (e.g., email attachments)</li>\n <li>The detail DataSource must have a ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')}\n     linking to the master DataSource's primary key</li>\n <li>Each uploaded file creates a separate record in the detail DataSource</li>\n </ul>\n <P>\n See ${isc.DocUtils.linkForRef('class:MultiFileItem')} for an example of the DataSource setup required.\n <P>\n <b>Multiple Binary Fields</b>\n <P>\n A form can contain multiple FileUploadItems for different binary fields in the same\n DataSource. When the form is saved, all files are uploaded in a single request,\n creating one record with all binary fields populated. This differs from ${isc.DocUtils.linkForRef('class:FileItem')}\n which has a limitation preventing multiple file uploads in a single form submission.\n <P>\n Note: If you want immediate upload on drop (like Gmail attachments), use a\n ${isc.DocUtils.linkForRef('method:FormItem.changed')} handler to call ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')}.",methods:["method:FileUploadItem.getDataSource","method:FileUploadItem.startProcessing","method:FileUploadItem.setProcessingProgress","method:FileUploadItem.setFileProgress","method:FileUploadItem.endProcessing","method:FileUploadItem.cancelProcessing","method:FileUploadItem.getSize","method:FileUploadItem.getFiles"],name:"FileUploadItem"},"method:WebService.getOutputHeaderSchema":{seeAlso:[],ref:"method:WebService.getOutputHeaderSchema",deprecated:null,type:"method",definingClass:"class:WebService",params:[{defaultValue:null,optional:false,type:"String",description:"name of an operation from this web service",name:"operationName"}],description:" Get the schema for each part of the SOAP header for the output message of a given\n operation, as a mapping from part name to schema.  For example, given WSDL like:\n <pre>\n     &lt;soap:header part=\"SessionHeader\"/&gt;\n     &lt;soap:header part=\"CallOptions\"/&gt;\n </pre>\n The following schema would be returned:\n <pre>\n     { SessionHeader : <i>sessionHeaderPartSchema</i>,\n       CallOptions : <i>callOptionsPartSchema</i> }\n </pre>\n The schema are instances of ${isc.DocUtils.linkForRef('class:DataSource')} that can be inspected to discover the\n elements and types that are legal in that header part, and can construct a valid SOAP\n header part if ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} is invoked.\n\n",flags:"",returns:{type:"Object",description:"mapping from partName to schema"},name:"getOutputHeaderSchema"},"attr:Calendar.showEventHeaders":{seeAlso:[],ref:"attr:Calendar.showEventHeaders",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:Calendar",valueType:"boolean",description:"When rendering the ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvas','canvas')} for an event, whether to show the \n ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')}, typically containing suitable title text - \n ${isc.DocUtils.linkForRef('method:Calendar.getEventHeaderHTML','by default')}, the event's ${isc.DocUtils.linkForRef('attr:Calendar.nameField','name')}.\n <P>\n The default is true - if set to false, the event's ${isc.DocUtils.linkForRef('attr:EventCanvas.showBody','body area')} \n will fill the canvas.",flags:"IR",name:"showEventHeaders"},"method:TileLayout.setTileSize":{groups:["tileLayout"],seeAlso:[],ref:"method:TileLayout.setTileSize",deprecated:null,type:"method",definingClass:"class:TileLayout",params:[{defaultValue:null,optional:false,type:"int",description:"size",name:"size"}],description:" Sets the height and width of tiles.\n",flags:"",name:"setTileSize"},"method:TableView.formatRecord":{seeAlso:[],ref:"method:TableView.formatRecord",deprecated:null,type:"method",definingClass:"class:TableView",params:[{defaultValue:null,optional:false,type:"ListGridRecord",description:"record to format",name:"record"}],description:" Formatter to apply to record display.\n\n",flags:"",returns:{type:"HTMLString",description:"formatted record contents"},name:"formatRecord"},"classMethod:AutoTest.locateCanvasFromDOMElement":{seeAlso:[],type:"classMethod",definingClass:"class:AutoTest",returns:{type:"Canvas",description:"canvas containing the element, or null if none apply"},groups:["autoTest"],deprecated:null,ref:"classMethod:AutoTest.locateCanvasFromDOMElement",params:[{defaultValue:null,optional:false,type:"DOMElement",description:"DOM element within in the page",name:"element"}],description:" Given an element in the DOM, returns the canvas containing this element, or null if\n the element is not contained in any canvas handle.\n",flags:"",name:"locateCanvasFromDOMElement"},"attr:CreateScreenSettings.htmlElement":{seeAlso:[],ref:"attr:CreateScreenSettings.htmlElement",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:CreateScreenSettings",valueType:"DOMElement | String",description:"Simplifies integrating a screen with an existing JavaScript app.  Does the following:\n <ul>\n <li>Sets ${isc.DocUtils.linkForRef('attr:CreateScreenSettings.suppressAutoDraw')}: true\n <li>Sets ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} of the screen's top widget to the DOM element\n <li>Sets the screen's top widget to have ${isc.DocUtils.linkForRef('attr:Canvas.position')}: \"relative\"\n <li>Draws the screen by calling ${isc.DocUtils.linkForRef('method:Canvas.draw')} on the top widget</ul>\n If you need to apply additional, custom configuration, for example setting\n ${isc.DocUtils.linkForRef('attr:Canvas.htmlPosition')}, then instead of using this property, you can call\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.createScreen')} with ${isc.DocUtils.linkForRef('attr:CreateScreenSettings.suppressAutoDraw')}: true, and then\n manually configure and draw the screen:\n <pre>\n     var screen = isc.RPCManager.createScreen(\"My Screen\", {suppressAutoDraw: true});\n     screen.setHtmlElement(element);\n     screen.setHtmlPosition(\"replace\");\n     screen.position = \"relative\";\n     screen.draw();\n </pre>",flags:"IR",name:"htmlElement"},"attr:AIFieldRequest.valueClass":{seeAlso:[],ref:"attr:AIFieldRequest.valueClass",defaultValue:'"general"',deprecated:null,type:"attr",definingClass:"object:AIFieldRequest",valueType:"ValueClass",description:"The class of value that AI will be asked to generate for the field.",flags:"IR",name:"valueClass"},"method:ListGrid.unsort":{groups:["sorting"],seeAlso:[],ref:"method:ListGrid.unsort",deprecated:null,type:"method",definingClass:"class:ListGrid",description:" Turn sorting off, typically because data has changed and is no longer sorted.\n <p>\n Calling <code>unsort()</code> disables visual indication of which columns are sorted,\n and calls <code>unsort()</code> on the underlying dataset if supported.\n <P>\n Note that a grid viewing a paged dataset may not be able to support ${isc.DocUtils.linkForRef('method:ResultSet.unsort')}\n because the sort order is what establishes the row numbering that allows data to be\n fetched in batches. In this case the dataset will be explicitly sorted to an empty \n array which may cause the cache to be invalidated and a new fetch.\n <P>\n <code>unsort()</code> is automatically called in response to edits or changes to the\n data set that would cause records to be reordered. See ${isc.DocUtils.linkForRef('group:editing')} for further\n details on editing records in a sorted ListGrid. \n\n",flags:"",name:"unsort"},"method:CubeGrid.getSelectedCells":{groups:["selection"],seeAlso:[],ref:"method:CubeGrid.getSelectedCells",deprecated:null,type:"method",definingClass:"class:CubeGrid",description:" Returns an array of the selected cell records.\n\n  <br><i>methodType</i> getter\n",flags:"",returns:{type:"Array of CellRecord",description:"array of the selected cell records"},name:"getSelectedCells"},"attr:EditTree.rootComponent":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:EditTree",groups:["devTools"],deprecated:null,ref:"attr:EditTree.rootComponent",valueType:"PaletteNode",description:"Root of data to edit.  Must contain the \"type\" property, with the name of a\n valid ${isc.DocUtils.linkForRef('class:DataSource','schema')} or nothing will be able to be dropped on this\n EditContext. A \"liveObject\" property representing the rootComponent is also\n suggested. Otherwise, a live object will be created from the palette node.\n <P>\n Can be retrieved at any time. Use ${isc.DocUtils.linkForRef('method:EditTree.getRootEditNode')} to retrieve the\n ${isc.DocUtils.linkForRef('object:EditNode')} created from the rootComponent.",flags:"IR",name:"rootComponent"},"attr:Palette.defaultEditContext":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"interface:Palette",deprecated:null,ref:"attr:Palette.defaultEditContext",setter:["setDefaultEditContext"],valueType:"EditContext | EditTree | EditPane",description:"Default EditContext that this palette should use.  Palettes generally create components via\n drag and drop, but may also support creation via double-click or other UI idioms when a\n defaultEditContext is set.",flags:"IRW",name:"defaultEditContext"},"type:AdminSearches":{seeAlso:[],ref:"type:AdminSearches",deprecated:null,type:"type",values:[{value:'"preferSaved"',description:"Combine both sets of records, but report the search record from the                       DataSource if two records have the same search name."},{value:'"preferLocal"',description:"Combine both sets of records, but report the search record from                       ${isc.DocUtils.linkForRef('attr:DataBoundComponent.adminSavedSearches','adminSavedSearches')}\n                       if two records have the same search name."},{value:'"localOnly"',description:"Only report the records from                       ${isc.DocUtils.linkForRef('attr:DataBoundComponent.adminSavedSearches','adminSavedSearches')}."}],description:"Policy for choosing between admin searches fetched from the DataSource vs. those declared\n locally on a component.",name:"AdminSearches"},"attr:EventCanvas.showBody":{seeAlso:[],ref:"attr:EventCanvas.showBody",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:EventCanvas",valueType:"Boolean",description:"Renders a body DIV that fills the main area of the canvas, or all of it if no \n ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header')} is shown.  This area typically displays an  \n ${isc.DocUtils.linkForRef('attr:CalendarEvent.description','event description')}.  This area can be styled via \n ${isc.DocUtils.linkForRef('attr:EventCanvas.bodyStyle')} and the HTML it shows is retrieved\n from a call to ${isc.DocUtils.linkForRef('method:EventCanvas.getBodyHTML','getBodyHTML()')}.  The default is taken\n from ${isc.DocUtils.linkForRef('attr:Calendar.showEventDescriptions')}.",flags:"IRW",name:"showBody"},"attr:DateRange.end":{seeAlso:[],ref:"attr:DateRange.end",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:DateRange",valueType:"RelativeDate | Date",description:"The end of this DateRange.",flags:"IR",name:"end"},"attr:PortalLayout.overflow":{seeAlso:[{ref:"attr:PortalLayout.canResizePortlets",description:null},{ref:"attr:PortalLayout.columnOverflow",description:null},{ref:"attr:Canvas.overflow",description:null}],defaultValue:'"auto"',type:"attr",definingClass:"class:PortalLayout",groups:["sizing"],ref:"attr:PortalLayout.overflow",deprecated:null,valueType:"Overflow",description:"Controls how the PortalLayout reacts when column widths or ${isc.DocUtils.linkForRef('class:Portlet')} widths\n overflow the width of the PortalLayout. By default, the PortalLayout scrolls\n when necessary. You can also use overflow: visible or overflow: hidden, with the \n usual results -- see ${isc.DocUtils.linkForRef('attr:PortalLayout.canResizePortlets')} for a further explanation of column widths.\n <p>\n Note that overflowing height is also affected by ${isc.DocUtils.linkForRef('attr:PortalLayout.columnOverflow','columnOverflow')}.\n By default, each column will scroll individually -- you can change\n columnOverflow to \"auto\" to scroll the whole PortalLayout instead.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('portalLayoutColumnHeight')}"],name:"overflow"},"method:Layout.getChildTabPosition":{seeAlso:[],ref:"method:Layout.getChildTabPosition",deprecated:null,type:"method",definingClass:"class:Layout",params:[{defaultValue:null,optional:false,type:"Canvas",description:"The child for which the tab position should be returned",name:"child"}],description:" Layouts ensure children are ordered\n in the tab-sequence with members being reachable first (in member order), then any\n non-member children.\n <P>\n As with ${isc.DocUtils.linkForRef('method:Canvas.getChildTabPosition')} if ${isc.DocUtils.linkForRef('method:Canvas.setRelativeTabPosition')}\n was called explicitly called for some child, it will be respected over member order.\n\n",flags:"",returns:{type:"Integer",description:"tab position of the child within this layout."},name:"getChildTabPosition"},"method:Calendar.updateEventCanvasComponent":{seeAlso:[{ref:"method:Calendar.createEventCanvasComponent",description:null}],ref:"method:Calendar.updateEventCanvasComponent",deprecated:null,type:"method",definingClass:"class:Calendar",params:[{defaultValue:null,optional:false,type:"EventCanvas",description:"the eventCanvas to update the component for",name:"canvas"},{defaultValue:null,optional:false,type:"Canvas",description:"the component to be updated the canvas in question",name:"component"}],description:" Called from ${isc.DocUtils.linkForRef('method:EventCanvas.setEvent')} when ${isc.DocUtils.linkForRef('attr:Calendar.showEventCanvasComponents')} is \n true and the eventCanvas already has a \n ${isc.DocUtils.linkForRef('method:Calendar.createEventCanvasComponent','component')}.  This method is expected to update \n the passed <code>component</code> as necessary, based on the \n ${isc.DocUtils.linkForRef('attr:EventCanvas.event','current event')}.\n <P>\n By default, if the passed <code>component</code> has methods called \n <code>setEvent</code> or <code>setData</code>, those methods are called automatically.\n",flags:"",name:"updateEventCanvasComponent"},"attr:FacetChart.gradationZeroLineProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:FacetChart",groups:["gradations"],deprecated:null,ref:"attr:FacetChart.gradationZeroLineProperties",valueType:"DrawLine Properties",description:"Properties for the gradation line drawn for zero (slightly thicker by default).",flags:"IR",name:"gradationZeroLineProperties"},"attr:ComboBoxItem.sortField":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ComboBoxItem",groups:["sorting"],ref:"attr:ComboBoxItem.sortField",deprecated:null,valueType:"String | Array of String | Integer",description:"Specifies one or more fields by which this item should be initially sorted.  It can be \n a ${isc.DocUtils.linkForRef('attr:ListGridField.name','field name')}, or an array of field names - but note that, if\n multiple fields are supplied, then each will be sorted in the same \n ${isc.DocUtils.linkForRef('attr:ListGrid.sortDirection','direction')}.\n <P>\n For full sorting control, set ${isc.DocUtils.linkForRef('attr:PickList.initialSort','initialSort')} to a list of\n custom ${isc.DocUtils.linkForRef('object:SortSpecifier','sortSpecifiers')}.\n <P>\n This attribute can also be set to the index of a field in the fields array, but note \n that it will be converted to a string (field name) after initialization.",flags:"IR",examples:["${isc.DocUtils.linkForExampleId('sort')}"],name:"sortField"},"attr:SetFilterItem.toggleUseUnselectedValuesOnSelectAll":{seeAlso:[],ref:"attr:SetFilterItem.toggleUseUnselectedValuesOnSelectAll",defaultValue:"true",deprecated:null,type:"attr",definingClass:"class:SetFilterItem",valueType:"Boolean",description:"Should this item toggle between tracking selected options and using them to\n generate \"inSet\" criteria and unselected options and using them to generate\n \"notInSet\" criteria when the user clicks the ${isc.DocUtils.linkForRef('attr:MultiPickerItem.selectAllButton')} and\n ${isc.DocUtils.linkForRef('attr:MultiPickerItem.deselectAllButton')} on an unfiltered list of options.\n <P>\n See ${isc.DocUtils.linkForRef('attr:SetFilterItem.useUnselectedValues')} for more detail",flags:"IRA",name:"toggleUseUnselectedValuesOnSelectAll"},"attr:ImgButton.width":{seeAlso:[{ref:"attr:StatefulCanvas.autoFit",description:null}],defaultValue:"null",type:"attr",definingClass:"class:ImgButton",groups:["sizing"],deprecated:null,ref:"attr:ImgButton.width",valueType:"Number | String",description:"Size for this component's horizontal dimension.  See ${isc.DocUtils.linkForRef('attr:Canvas.width')} for more\n details.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} is set, this property will be ignored so that the widget\n is always sized just large enough to accommodate the title.",flags:"IRW",name:"width"},"attr:FormItem.picker":{seeAlso:[],ref:"attr:FormItem.picker",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:FormItem",valueType:"AutoChild Canvas",description:"The component that will be displayed when ${isc.DocUtils.linkForRef('method:FormItem.showPicker')} is called due to a click\n on the ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon','picker icon')}.\n <P>\n Can be specified directly as a Canvas, or created automatically via the\n ${isc.DocUtils.linkForRef('type:AutoChild')} pattern. The default autoChild configuration for the picker is \n a Canvas with backgroundColor set and no other modifications.\n <P>\n Note that the picker is not automatically destroyed with the FormItem that uses it, in\n order to allow recycling of picker components.  To destroy a single-use picker, override\n ${isc.DocUtils.linkForRef('method:Canvas.destroy')}.",flags:"IRW",name:"picker"},"classAttr:StatefulCanvas.STATE_DOWN":{seeAlso:[],defaultValue:'"Down"',type:"classAttr",definingClass:"class:StatefulCanvas",deprecated:null,ref:"classAttr:StatefulCanvas.STATE_DOWN",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:State','State')}.",flags:"R",name:"STATE_DOWN",constant:true},"classAttr:Browser.supportsSpeechRecognition":{seeAlso:[],ref:"classAttr:Browser.supportsSpeechRecognition",defaultValue:"null",deprecated:null,type:"classAttr",definingClass:"class:Browser",valueType:"Boolean",description:"Whether this browser exposes a SpeechRecognition implementation (API is present).\n This indicates that browser-provided speech-to-text *may* be available for features\n such as ${isc.DocUtils.linkForRef('class:VoiceAssist')}, but does not guarantee that recognition sessions can be \n started.  See ${isc.DocUtils.linkForRef('classAttr:Browser.allowsSpeechRecognition')} for runtime viability.",flags:"RA",name:"supportsSpeechRecognition"},"classAttr:CubeGrid.ASCENDING":{seeAlso:[],defaultValue:'"ascending"',type:"classAttr",definingClass:"class:CubeGrid",deprecated:null,ref:"classAttr:CubeGrid.ASCENDING",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:FacetIndentDirection','FacetIndentDirection')}.",flags:"R",name:"ASCENDING",constant:true},"method:DrawItem.supportsEndArrow":{seeAlso:[],ref:"method:DrawItem.supportsEndArrow",deprecated:null,type:"method",definingClass:"class:DrawItem",description:" Does this DrawItem ${isc.DocUtils.linkForRef('classMethod:Class.isMethodSupported','support')} ${isc.DocUtils.linkForRef('method:DrawItem.setEndArrow')}?\n For example, this is false for ${isc.DocUtils.linkForRef('class:DrawRect')} and ${isc.DocUtils.linkForRef('class:DrawOval')}, and true for ${isc.DocUtils.linkForRef('class:DrawLine')}.\n",flags:"A",returns:{type:"boolean",description:"whether setEndArrow() is supported by this DrawItem."},name:"supportsEndArrow"},"attr:Canvas.canFocus":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["focus","events"],ref:"attr:Canvas.canFocus",deprecated:null,valueType:"boolean",setter:["setCanFocus"],description:"Can this widget be allowed to become the target of keyboard events?\n <P>\n If canFocus is unset (the default), only scrollable widgets with visible scrollbars are\n focusable, to allow for keyboard scrolling.\n <P>\n A widget normally receives focus by being clicked on or tabbed to.",flags:"IRWA",examples:["${isc.DocUtils.linkForExampleId('focus')}"],name:"canFocus"},"type:FormatString":{seeAlso:[{ref:"attr:DataSourceField.format",description:null},{ref:"attr:DataSourceField.exportFormat",description:null},{ref:"classMethod:DateUtil.format",description:null},{ref:"classMethod:NumberUtil.format",description:null},{ref:"classMethod:Time.toTime",description:null},{ref:"classMethod:Time.toShortTime",description:null}],ref:"type:FormatString",deprecated:null,type:"type",description:'A String to be used as a format specifier for a date, datetime, time or numeric field, via\n the ${isc.DocUtils.linkForRef(\'attr:DataSourceField.format\',\'format\')} and ${isc.DocUtils.linkForRef(\'attr:DataSourceField.exportFormat\',\'exportFormat\')} \n properties.  \n <p>\n For fields with a numeric type, the format string is similar to java.text.NumberFormat (see\n <a href=\'http://docs.oracle.com/javase/7/docs/api/java/text/DecimalFormat.html\' target=\'_blank\'>DecimalFormat JavaDoc</a>),\n and for date, time, and datetime types, the format string is similar to\n java.text.SimpleDateFormat (see \n <a href=\'http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html\' target=\'_blank\'>SimpleDateFormat JavaDoc</a>).\n <p>\n Note that all the client-side formatting described in this section is is done by the \n ${isc.DocUtils.linkForRef(\'classMethod:NumberUtil.format\',\'NumberUtil.format()\')} and \n ${isc.DocUtils.linkForRef(\'classMethod:DateUtil.format\',\'DateUtil.format()\')}\n \n methods.  These are static utility methods that your own code can call if you need to \n programmatically format a date or number using a <code>FormatString</code>\n <p>\n There are 3 possible contexts where a <code>FormatString</code> may be interpreted, and each\n has slightly different limitations:\n\n <h4>in-browser rendering &amp; client-driven exports</h4>\n Almost complete support for Java\'s SimpleDateFormat/DecimalFormat, as described below, with\n some small extensions for formatting with awareness of a ${isc.DocUtils.linkForRef(\'object:FiscalCalendar\')}.\n <p>\n This category includes cases where code running in the browser does the rendering and\n the rendered result is passed to the server, such as \n ${isc.DocUtils.linkForRef(\'method:ListGrid.exportClientData\',\'client-driven export\')} and\n ${isc.DocUtils.linkForRef(\'classMethod:RPCManager.exportContent\',\'PDF export of the printed view\')}.\n\n <h4>Excel export</h4> \n Almost the same as in-browser rendering, with minor limitations due to missing features in\n Excel.  Exact differences are described under ${isc.DocUtils.linkForRef(\'attr:DataSourceField.exportFormat\')}.\n\n <h4>non-Excel server export</h4>\n For example, CSV, XML or JSON ${isc.DocUtils.linkForRef(\'type:ExportFormat\',\'export formats\')} provided via\n ${isc.DocUtils.linkForRef(\'method:DataSource.exportData\')}.  Full support for SimpleDateFormat/DecimalFormat\n as provided by whichever Java version you have installed on the server.  However note that\n depending on the context of the export, the default behavior may be to ignore format\n strings, since formatting intended for end users wouldn\'t be desirable if data exchange is\n the goal.  See the ${isc.DocUtils.linkForRef(\'group:exportFormatting\',\'Export Formatting overview\')} for details.\n\n <P>\n <h3>Date Format</h3>\n <table width="700" style="font-size:11px;border:1px solid black;">\n <tr><td style="color:white;background-color:black;"><b>Format token</b></td>\n     <td style="color:white;background-color:black;"><b>Description</b></td>\n     <td style="color:white;background-color:black;width:150px;"><b>Sample value</b></td></tr>\n <tr><td>yy     </td><td>Year as a two-digit number                            </td><td>"99"   or "07"</td></tr>\n <tr><td>yyyy   </td><td>Year as a four-digit number                           </td><td>"1999" or "2007"</td></tr>\n <tr><td>YY     </td><td>Week year as a two-digit number (week year is the year associated with the entire week deemed to contain a given date, and it may differ from calendar year.  For example, the week year of December 31 2012 is 2013)</td><td>"99"   or "07"</td></tr>\n <tr><td>YYYY   </td><td>Week year as a four-digit number                      </td><td>"1999" or "2007"</td></tr>\n <tr><td>LL     </td><td>Fiscal year as a two-digit number (${isc.DocUtils.linkForRef(\'object:FiscalCalendar\')})</td><td>"99"   or "07"</td></tr>\n <tr><td>LLLL   </td><td>Fiscal year as a four-digit number                    </td><td>"1999" or "2007"</td></tr>\n <tr><td>M      </td><td>Month in year                                         </td><td>"1"  to "12"</td></tr>\n <tr><td>MM     </td><td>Month in year with leading zero if required           </td><td>"01" to "12"</td></tr>\n <tr><td>MMM    </td><td>Short month name (${isc.DocUtils.linkForRef(\'classAttr:DateUtil.shortMonthNames\')})        </td><td>"Jan" to "Dec"</td></tr>\n <tr><td>MMMM   </td><td>Full month name (${isc.DocUtils.linkForRef(\'classAttr:DateUtil.monthNames\')})              </td><td>"January" to "December"</td></tr>\n <tr><td>w      </td><td>Week in year                                          </td><td>"1"  to "52"</td></tr>\n <tr><td>ww     </td><td>Week in year with leading zero if required            </td><td>"01" to "52"</td></tr>\n <tr><td>C      </td><td>Week in fiscal year (${isc.DocUtils.linkForRef(\'object:FiscalCalendar\')})           </td><td>"7"  or "29"</td></tr>\n <tr><td>CC     </td><td>Week in fiscal year with leading zero if required     </td><td>"07" or "29"</td></tr>\n <tr><td>d      </td><td>Day of the month                                      </td><td>"1"  to "31"</td></tr>\n <tr><td>dd     </td><td>Day of the month with leading zero if required        </td><td>"01" to "31"</td></tr>\n <tr><td>ddd    </td><td>Short day name (${isc.DocUtils.linkForRef(\'classAttr:DateUtil.shortDayNames\')})        </td><td>"Mon" to "Sun"</td></tr>\n <tr><td>dddd   </td><td>Full day name. (${isc.DocUtils.linkForRef(\'classAttr:DateUtil.dayNames\')})             </td><td>"Monday" to "Sunday"</td></tr>\n <tr><td>E      </td><td>Short day name ("EE" and "EEE" are equivalent; all are exactly the same as "ddd" - "E" is supported purely to conform with SimpleDateFormat)</td><td>"Mon" to "Sun"</td></tr>\n <tr><td>EEEE   </td><td>Full day name (exactly the same as "dddd")            </td><td>"Monday" to "Sunday"</td></tr>\n <tr><td>D      </td><td>Day in year                                           </td><td>"1"  to "366"</td></tr>\n <tr><td>DD     </td><td>Day in year with leading zero if required             </td><td>"01" to "366"</td></tr>\n <tr><td>c      </td><td>Day in fiscal year (${isc.DocUtils.linkForRef(\'object:FiscalCalendar\')})            </td><td>"5"  or "204"</td></tr>\n <tr><td>cc     </td><td>Day in fiscal year with leading zero if required      </td><td>"05" or "204"</td></tr>\n <tr><td>u      </td><td>Day number in week (1 is Monday)                      </td><td>"1" to "7"</td></tr>\n <tr><td>H      </td><td>Hour in day, 0-23 (24-hour clock)                     </td><td>"0"  to "23"</td></tr>\n <tr><td>HH     </td><td>Hour in day with leading zero if required (24-hour)   </td><td>"00" to "23"</td></tr>\n <tr><td>h      </td><td>Hour in day, 1-12 (12-hour clock)                     </td><td>"1"  to "12"</td></tr>\n <tr><td>hh     </td><td>Hour in day with leading zero if required (12-hour)   </td><td>"01" to "12"</td></tr>\n <tr><td>m      </td><td>Minute in hour                                        </td><td>"0"  to "59"</td></tr>\n <tr><td>mm     </td><td>Minute in hour with leading zero if required          </td><td>"00" to "59"</td></tr>\n <tr><td>s      </td><td>Second in minute                                      </td><td>"0"  to "59"</td></tr>\n <tr><td>ss     </td><td>Second in minute with leading zero if required        </td><td>"00" to "59"</td></tr>\n <tr><td>S      </td><td>Millisecond in second                                 </td><td>"0"  to "999"</td></tr>\n <tr><td>SSS    </td><td>Millisecond in second with leading zero(s) if required</td><td>"000" to "999"</td></tr>\n <tr><td>a      </td><td>The AM/PM designator (${isc.DocUtils.linkForRef(\'classAttr:Time.AMIndicator\')})        </td><td>" am" or " pm"</td></tr>\n </table>\n <p>\n Note that all text that doesn\'t represent tokens specified above will be passed through to\n the output, but such unmapped character sequences are reserved for future use.  To\n future-proof your code, you may single quote <code>"\'"</code> any text to escape it to ensure\n no formatting is applied, guaranting that it\'s passed through unaltered.  Thus, a format of\n <code>"h\'h\'"</code> might end up as <code>"5h"</code>.  To create a single quote itself, use\n two in a row - for example <code>"h o\'\'clock"</code>.\n <p>\n <h3>Examples - various formatted versions of the datetime "2006-08-03 11:26:18"</h3>\n <table>\n <tr><td width="150">"M/d/yy"</td><td width="300">8/3/06</td></tr>\n <tr><td>"MMMM yyyy"</td><td>August 2006</td></tr>\n <tr><td>"HH:mm"</td><td>11:26</td></tr>\n <tr><td>"d MMM yyyy, H:ma"</td><td>3 Aug 2006, 11:26 am</td></tr>\n <tr><td>"dd/MM/yyyy"</td><td>03/08/2006</td></tr>\n <tr><td>"CC/LLLL"</td><td>53/2006 (assuming the fiscal year ends in the first week of August)</td></tr>\n </table>\n <p>\n <h3><code>SimpleDateFormat</code> specifiers that we do <b>not</b> support:</h3>\n <ul>\n <li>Era designator, BC/AD (G)</li>\n <li>Day of week in month (F)</li>\n <li>Hour in day, 24-hour, with 1-based instead of normal 0-based numbering (hours are 1-24) (k)</li>\n <li>Hour in day, 12-hour, with 0-based instead of normal 1-based numbering (hours are 0-11) (K)</li>\n <li>Timezone (z, Z, X)</li>\n </ul>\n <p>&nbsp;<p>\n <h3>Number Format</h3>\n <table width="700" style="font-size:11px;border:1px solid black;">\n <tr><td style="color:white;background-color:black;"><b>Format char</b></td>\n     <td style="color:white;background-color:black;"><b>Description</b></td>\n <tr><td>0          </td><td>Digit, zero is displayed</td></tr>\n <tr><td>#          </td><td>Digit, zero is not displayed</td></tr>\n <tr><td>-          </td><td>Minus sign</td></tr>\n <tr><td>.          </td><td>Decimal separator</td></tr>\n <tr><td>%          </td><td>Multiply by 100 and show as percentage</td></tr>\n <tr><td>&#x2030; (\\u2030) </td><td>Multiply by 1000 and show as per mille.  See below.</td></tr>\n <tr><td>,          </td><td>Indicates digit grouping should be used - eg 1,000,000.  See below.</td></tr>\n <tr><td>;          </td><td>Separates positive and negative subpatterns.  See below.</td></tr>\n <tr><td>&#x00a4; (\\u00A4) </td><td>As a prefix or suffix, indicates the local currency symbol should be used.  Note that you must use special notation to include this character in an XML file (such as a .ds.xml file).  See below.</td></tr>\n <tr><td>\'          </td><td>Used to quote special characters in a prefix or suffix, for example, "\'#\'#" formats 123 to "#123". To create a single quote itself, use two in a row: "# o\'\'clock".</td></tr>\n </table>\n <p>\n All other characters in the format string are taken literally and output unchanged.\n <p>\n <h3>Examples</h3>\n <table style="font-size:11px;border:1px solid black;">\n <tr><td width="150" style="color:white;background-color:black;"><b>Format string</b></td>\n     <td width="150" style="color:white;background-color:black;"><b>Zero value</b></td>\n     <td width="150" style="color:white;background-color:black;"><b>Positive value: 12345.678</b></td>\n     <td width="150" style="color:white;background-color:black;"><b>Negative value: -2345.123</b></td>\n <tr><td>"0.00"</td><td>0.00</td><td>12345.68</td><td>-2345.12</td></tr>\n <tr><td>",##0.00"</td><td>0.00</td><td>12,345.68</td><td>-2,345.12</td></tr>\n <tr><td>"0.###"</td><td>0</td><td>12345.678</td><td>-2345.123</td></tr>\n <tr><td>"&#x00a4;,0.00"</td><td>$0.00</td><td>$12,345.68</td><td>-$2345.12</td></tr>\n <tr><td>"0.0#%"</td><td>0.0%</td><td>1234567.8%</td><td>-234512.3%</td></tr>\n <tr><td>"0.0#&#x2030;"</td><td>0.0&#x2030;</td><td>12345678.0&#x2030;</td><td>-2345123.0&#x2030;</td></tr>\n <tr><td>"0.0#\'%\'"</td><td>0.0%</td><td>12345.68%</td><td>-2345.12%</td></tr>\n <tr><td>"0.00;(0.00)"</td><td>0.0%</td><td>12345.68</td><td>(2345.12)</td></tr>\n </table><br>\n Note, the above examples include cases where there are multiple \'#\' characters in the integer\n part of the number format (ie, to the left of the decimal separator, or the entire format \n if there is no separator).  We support this pattern simply because <code>DecimalFormat</code>\n does: the extra \'#\' characters are not significant.  In other words, the format "##0.00" \n produces exactly the same formatting as "0.00", and "##,###,###.##" produces exactly the \n same formatting as ",#.##".  However, multiple \'0\' characters in the integer part of the \n format <em>are</em> significant, as are both \'#\' and \'0\' characters in the decimal part \n of the format (ie, to the right of any decimal separator).\n <p>\n The ";" character marks the boundary between two subpatterns - the first to be used for \n formatting positive numbers (and 0), the second for negative numbers.  Specifying a separate\n pattern for negative numbers is optional: if no negative subpattern is specified, negative\n numbers are formatted like positive numbers, but with a leading "-" sign.\n <p>\n The "&#x00a4;" symbol (\\u00A4) is documented in the Java DecimalFormat class as a placeholder for the currency\n symbol appropriate to the current locale.  For client-driven exports, we replace it with\n \n the ${isc.DocUtils.linkForRef(\'classAttr:NumberUtil.currencySymbol\',\'localized currency symbol\')}.\n Likewise, we use ${isc.DocUtils.linkForRef(\'classAttr:NumberUtil.decimalSymbol\',\'decimalSymbol\')} and\n ${isc.DocUtils.linkForRef(\'classAttr:NumberUtil.groupingSymbol\',\'groupingSymbol\')} to localize the formatting of numbers.\n \n \n Note that "\\u00A4" is the correct way to specify this character in Javascript code.  If you\n need to specify the character in an XML file - the common requirement is in a .ds.xml\n DataSource descriptor file - you must use the code "&amp;#x00A4;" instead.\n <p>\n The "&permil;" per mille symbol is specified as "\\u2030" in Javascript code; in XML or HTML \n you can use either the equivalent notation "&amp;#x2030;" or the special HTML code \n "&amp;permil;".\n\n <p>\n <h3><code>DecimalFormat</code> features that we do <b>not</b> support:</h3>\n <ul>\n <li>Scientific notation</li>\n <li>Doubled currency symbol means "use international currency symbol"</li>\n <li>We do not support arbitrary digit grouping, by providing patterns of the \'#\' and \',\'\n characters, like <code>DecimalFormat</code> does.  Grouping in SmartClient FormatStrings\n is enabled with a single "," character somewhere before or within the number-formatting\n part of the string - extra "," characters within the number-formatting part of the string \n are tolerated, but they have no effect.  Grouping in SmartClient always causes digits to \n be gathered in groups of three</li>\n </ul>',serverDS:"allowed",name:"FormatString",baseType:"String"},"attr:Canvas.testDataContext":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Canvas",groups:["dataContext"],deprecated:null,ref:"attr:Canvas.testDataContext",valueType:"DataContext",description:"A ${isc.DocUtils.linkForRef('object:DataContext')} to be used if no ${isc.DocUtils.linkForRef('attr:Canvas.dataContext')} is provided (directly\n or indirectly via a parent). If a <code>dataContext</code> is provided it completely\n replaces the <code>testDataContext</code>.\n <P>\n In ${isc.DocUtils.linkForRef('group:reifyForDevelopers','Reify')}, <code>testDataContext</code> is how a screen\n defines its ${isc.DocUtils.linkForRef('group:reifyForDevelopers','Screen Inputs')}: the designer selects DataSources\n whose records the screen expects to receive when embedded in a larger application. The\n DataSource schemas plus the test values in <code>testDataContext</code> allow Reify to let\n designers define and test declarative logic (formulas, ${isc.DocUtils.linkForRef('attr:FormItem.visibleWhen','visibility\\n rules')}, ${isc.DocUtils.linkForRef('class:Process','workflows')}, etc.) based on a defined set of inputs, even when\n testing the screen in isolation.\n <P>\n DataSources included in the <code>testDataContext</code> are immediately provided to\n ${isc.DocUtils.linkForRef('attr:Canvas.ruleScope','rule context')} when used if no other component has done so already.\n These records are found in rule context 'dataContext' section (ex.\n <code>dataContext.Customer</code> for a Customer record in <code>testDataContext</code>)\n so they do not conflict with normal DataSource records.",flags:"IR",name:"testDataContext"},"method:ListGrid.exportClientData":{seeAlso:[{ref:"method:DataSource.exportClientData",description:null},{ref:"group:exportFormatting",description:null}],ref:"method:ListGrid.exportClientData",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:true,type:"DSRequest Properties",description:"Request properties for the export.  Note that specifying ${isc.DocUtils.linkForRef('attr:DSRequest.exportData','exportData')} on the request properties\n  allows the developer to pass in an explicit data set to export.",name:"requestProperties"},{defaultValue:null,optional:true,type:"RPCCallback",description:"Optional callback.  If  you specify ${isc.DocUtils.linkForRef('attr:DSRequest.exportToClient','exportToClient')}: false in the request\n  properties, this callback will fire after export completes.  Otherwise the callback will\n  fire right before the download request is made to the server.",name:"callback"}],description:" Exports this component's data with client-side formatters applied, so is suitable for direct \n display to users, using the specified ${isc.DocUtils.linkForRef('attr:DSRequest.exportAs','export format')}.\n <P>\n A variety of DSRequest settings, such as ${isc.DocUtils.linkForRef('attr:DSRequest.exportAs','exportAs')} and \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportFilename','DSRequest.exportFilename')}, affect the exporting process: \n see ${isc.DocUtils.linkForRef('attr:DSRequest.exportResults','exportResults')} for further detail.\n <P>\n If this component is ${isc.DocUtils.linkForRef('method:DataBoundComponent.setDataSource','databound')} and not all records \n that match the current ${isc.DocUtils.linkForRef('method:ListGrid.getCriteria','filter-criteria')} have \n ${isc.DocUtils.linkForRef('method:ResultSet.allMatchingRowsCached','been loaded')}, you can call\n ${isc.DocUtils.linkForRef('method:ListGrid.loadAllRecords')} - this method accepts a callback which is fired when all\n necessary data has arrived.  When that callback fires, a call to \n <code>exportClientData</code> will have access to the full dataset for the filter.\n <P>\n This feature requires the SmartClient server.\n <P>\n If your ListGrid has custom formatters, formatted values will be exported by default, with \n HTML normalized to text where possible. Since some levels of HTML normalizing aren't possible, \n this may result in missing or incorrect export values. In this case, you have three options:\n <ul>\n <li>Set ${isc.DocUtils.linkForRef('attr:ListGridField.exportRawValues','exportRawValues')} on the field.  This will export\n     the raw underlying value of the field; your formatter will not be called</li>\n <li>Have your formatter call ${isc.DocUtils.linkForRef('method:ListGrid.isExportingClientData','isExportingClientData()')}\n     and perform whatever alternative formatting you require if that method returns true</li>\n <li>Set ${isc.DocUtils.linkForRef('attr:ListGridField.exportRawNumbers','exportRawNumbers')} on the field.  This will export\n     the raw underlying number of the field; your formatter will not be called</li>\n </ul>\n Note that during export, the ${isc.DocUtils.linkForRef('attr:ListGridField.escapeHTML')} setting on a field determines\n how escaped and unescaped HTML values are handled.  In particular, if\n <code>escapeHTML</code> is not set for a field, a value like \"&lt;FOO&gt;\" will be\n exported as the empty string, and you'd need the escaped value \"&amp;lt;FOO&amp;gt;\" to end\n up exporting \"&lt;FOO&gt;\".\n <P>\n Ordinarily, calls to this method go through the static classMethod \n ${isc.DocUtils.linkForRef('classMethod:DataSource.exportClientData')}.  In this case, no server-side DataSources\n are required.  However, if this component is \n ${isc.DocUtils.linkForRef('method:DataBoundComponent.setDataSource','databound')} and you specify a valid \n ${isc.DocUtils.linkForRef('attr:DSRequest.operationId','operationId')} in the properties passed to this method, the call\n will go through the instance method ${isc.DocUtils.linkForRef('method:DataSource.exportClientData')} instead.  As the \n documentation for that method explains, this allows you more control on the server side.  \n This approach requires both the SmartClient server and server-side DataSource definitions.\n <P>\n To export data from this component's dataSource, \n see ${isc.DocUtils.linkForRef('method:DataBoundComponent.exportData','exportData')}, which does not include client-side \n formatters, but <b>does</b> include formatters declared in the <code>.ds.xml</code> file.\n <code>exportData()</code> relies on both the SmartClient server and server-side DataSources.\n",flags:"",name:"exportClientData"},"attr:DynamicForm.linearNumCols":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DynamicForm",groups:["formLayout"],deprecated:null,ref:"attr:DynamicForm.linearNumCols",valueType:"number",description:"Specifies the ${isc.DocUtils.linkForRef('attr:DynamicForm.numCols','number of columns')} when the form is being rendered in\n ${isc.DocUtils.linkForRef('attr:DynamicForm.linearMode')}, overriding any automatically derived value in that mode.",flags:"IRW",name:"linearNumCols"},"attr:Gradient.colorStops":{seeAlso:[],ref:"attr:Gradient.colorStops",defaultValue:"null",deprecated:null,type:"attr",definingClass:"object:Gradient",valueType:"Array of ColorStop",description:"An array of color stops for this gradient.",flags:"IR",name:"colorStops"},"method:StatefulCanvas.setBaseStyle":{seeAlso:[],ref:"method:StatefulCanvas.setBaseStyle",deprecated:null,type:"method",definingClass:"class:StatefulCanvas",params:[{defaultValue:null,optional:false,type:"CSSStyleName",description:"new base style",name:"style"}],description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",flags:"",name:"setBaseStyle"},"attr:ListGrid.fastCellUpdates":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:ListGrid",groups:["performance"],ref:"attr:ListGrid.fastCellUpdates",deprecated:null,setter:["setFastCellUpdates"],valueType:"Boolean",description:"<b>Note: This property only has an effect in Internet Explorer</b>\n <P>\n Advanced property to improve performance for dynamic styling of gridRenderer cells in\n Internet Explorer, at the expense of slightly slower initial drawing, and some \n limitations on supported styling options.\n <P>\n <code>fastCellUpdates</code> speeds up the dynamic styling system used by rollovers,\n selections, and custom styling that calls ${isc.DocUtils.linkForRef('method:GridRenderer.refreshCellStyle')}, at\n the cost of slightly slower draw() and redraw() times.\n <P>\n Notes:\n <ul>\n <li>When this property is set, ListGrid cells may be styled using the \n     ${isc.DocUtils.linkForRef('attr:ListGrid.tallBaseStyle')}. See ${isc.DocUtils.linkForRef('method:ListGrid.getBaseStyle')} for \n     more information.</li>\n <li>If any cell styles specify a a background image URL, the URL will be resolved relative\n     to the page location rather than the location of the CSS stylesheet. This means cell\n     styles with a background URL should either supply a fully qualified path, or the\n     background image media should be made available at a second location for IE.</li>\n <li>fastCellUpdates will not work if the styles involved are in an external stylesheet loaded\n     from a remote host. Either the stylesheet containing cell styles needs to be loaded\n     from the same host as the main page, or the cell styles need to be inlined in the html \n     of the bootstrap page.</li>\n <li>fastCellUpdates will not work if the css styles for cells are defined in\n     a <code>.css</code> file loaded via <code>@import</code>. Instead the <code>.css</code>\n     file should be loaded via a <code>&lt;link ...&gt;</code> tag.</li>\n </ul>",flags:"I",name:"fastCellUpdates"},"method:FilteredList.setAllRows":{seeAlso:[],ref:"method:FilteredList.setAllRows",deprecated:null,type:"method",definingClass:"class:FilteredList",params:[{defaultValue:null,optional:false,type:"Array of Records",description:"New set of unfiltered cache data",name:"allRows"}],description:" Updates ${isc.DocUtils.linkForRef('attr:FilteredList.allRows')} at run time.\n\n",flags:"",name:"setAllRows"},"attr:DateChooser.yearMenuStyle":{seeAlso:[],ref:"attr:DateChooser.yearMenuStyle",defaultValue:'"dateChooserYearMenu"',deprecated:null,type:"attr",definingClass:"class:DateChooser",valueType:"CSSStyleName",description:"Style for the pop-up year menu.",flags:"IR",name:"yearMenuStyle"},"classAttr:TableView.WHOLE_RECORD":{seeAlso:[],defaultValue:'"wholeRecord"',type:"classAttr",definingClass:"class:TableView",deprecated:null,ref:"classAttr:TableView.WHOLE_RECORD",valueType:"Constant",description:"A declared value of the enum type  \n ${isc.DocUtils.linkForRef('type:NavigationMode','NavigationMode')}.",flags:"R",name:"WHOLE_RECORD",constant:true},"type:Overflow":{groups:["sizing"],seeAlso:[],ref:"type:Overflow",deprecated:null,type:"type",values:[{value:"Canvas.VISIBLE",description:"Content that extends beyond the widget's width or height is                              displayed.\n                              Note: To have the content be sized only by the drawn size of\n                              the content set the overflow to be Canvas.VISIBLE and specify\n                              a small size, allowing the size to expand to the size required\n                              by the content.\n                              Leaving the width / height for the widget undefined will use the\n                              default value of 100, and setting the size to zero may cause the\n                              widget not to draw."},{value:"Canvas.HIDDEN",description:"Content that extends beyond the widget's width or height is                              clipped (hidden)."},{value:"Canvas.AUTO",description:"Horizontal and/or vertical scrollbars are displayed only if                              necessary. Content that extends beyond the remaining visible\n                              area is clipped."},{value:"Canvas.SCROLL",description:"Horizontal and vertical scrollbars are always drawn inside the                              widget. Content that extends beyond the remaining visible area\n                              is clipped, and can be accessed via scrolling."},{value:"Canvas.CLIP_H",description:"Clip horizontally but extend the canvas's clip region                              vertically if necessary. <br><b>Note:</b> only supported for\n                              specific widget subclasses."},{value:"Canvas.CLIP_V",description:"Clip vertically but extend the canvas's clip region                              horizontally if necessary. <br><b>Note:</b> only supported\n                              for specific widget subclasses."}],description:null,name:"Overflow"},"class:RPCResponse":{seeAlso:[{ref:"object:RPCRequest",description:null},{ref:"method:Callbacks.RPCCallback",description:null}],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:["classMethod:RPCResponse.create"],classAttrs:["classAttr:RPCResponse.STATUS_SUCCESS","classAttr:RPCResponse.STATUS_OFFLINE","classAttr:RPCResponse.STATUS_FAILURE","classAttr:RPCResponse.STATUS_AUTHORIZATION_FAILURE","classAttr:RPCResponse.STATUS_VALIDATION_ERROR","classAttr:RPCResponse.STATUS_LOGIN_INCORRECT","classAttr:RPCResponse.STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED","classAttr:RPCResponse.STATUS_LOGIN_REQUIRED","classAttr:RPCResponse.STATUS_LOGIN_SUCCESS","classAttr:RPCResponse.STATUS_UPDATE_WITHOUT_PK_ERROR","classAttr:RPCResponse.STATUS_TRANSACTION_FAILED","classAttr:RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED","classAttr:RPCResponse.STATUS_MAX_POST_SIZE_EXCEEDED","classAttr:RPCResponse.STATUS_REQUIRED_CRITERIA_MISSING","classAttr:RPCResponse.STATUS_CRITERIA_REQUIRED_ERROR","classAttr:RPCResponse.STATUS_FILE_REQUIRED_ERROR","classAttr:RPCResponse.INVALID_RESPONSE_FORMAT","classAttr:RPCResponse.STATUS_TRANSPORT_ERROR","classAttr:RPCResponse.STATUS_UNKNOWN_HOST_ERROR","classAttr:RPCResponse.STATUS_CONNECTION_RESET_ERROR","classAttr:RPCResponse.STATUS_SERVER_TIMEOUT"],attrs:["attr:RPCResponse.data","attr:RPCResponse.status","attr:RPCResponse.httpResponseCode","attr:RPCResponse.httpHeaders","attr:RPCResponse.httpResponseText","attr:RPCResponse.clientContext","attr:RPCResponse.transactionNum"],ref:"class:RPCResponse",deprecated:null,treeLocation:["Client Reference/RPC"],description:"Encapsulates an RPC response from the server.  Instances of this class are automatically created\n and optionally passed to you in the callback you specify as part of your RPCRequest.",methods:[],name:"RPCResponse"},"method:DataBoundComponent.getSelectionLength":{groups:["selection"],seeAlso:[],ref:"method:DataBoundComponent.getSelectionLength",deprecated:null,type:"method",definingClass:"interface:DataBoundComponent",description:" Returns the number of selected records.\n\n",flags:"",returns:{type:"int",description:"number of selected records"},name:"getSelectionLength"},"attr:PortalLayout.canResizePortlets":{seeAlso:[{ref:"attr:PortalLayout.canResizeColumns",description:null},{ref:"attr:PortalLayout.canStretchColumnWidths",description:null},{ref:"attr:PortalLayout.canShrinkColumnWidths",description:null},{ref:"attr:PortalLayout.columnOverflow",description:null}],defaultValue:"false",type:"attr",definingClass:"class:PortalLayout",groups:["sizing"],ref:"attr:PortalLayout.canResizePortlets",deprecated:null,valueType:"Boolean",setter:["setCanResizePortlets"],description:"Should the height and width of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} be drag-resizable?\n <p>\n Note that changing the <b>height</b> of a Portlet will change the height of all\n the Portlets in the same row to match.\n <p>\n If the height of Portlets causes a column to overflow, that column will scroll vertically\n (independent of other columns), depending on the ${isc.DocUtils.linkForRef('attr:PortalLayout.columnOverflow','columnOverflow')} setting.\n <p>\n Changing the <b>width</b> of a Portlet will potentially cause columns to stretch\n and shrink their <u>displayed</u> widths in order to accommodate the Portlets,\n depending on the value of ${isc.DocUtils.linkForRef('attr:PortalLayout.canStretchColumnWidths','canStretchColumnWidths')} and \n ${isc.DocUtils.linkForRef('attr:PortalLayout.canShrinkColumnWidths','canShrinkColumnWidths')}.\n <p>\n However, the <u>instrinsic</u> width of the columns will remain the same,\n so that the columns will resume their former widths when no longer necessary \n to stretch or shrink to accommodate the widths of Portlets. \n To allow drag-resizing of the intrinsic width of columns, see ${isc.DocUtils.linkForRef('attr:PortalLayout.canResizeColumns','canResizeColumns')}.\n <p>\n The net effect is that (by default) PortalLayouts behave like layouts when Portlet sizes do\n not cause overflow, but behave more like stacks when overflow occurs.",flags:"IRW",examples:["${isc.DocUtils.linkForExampleId('resizingPortlets')}"],name:"canResizePortlets"},"attr:TextItem.selectOnClick":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:TextItem",groups:["focus"],deprecated:null,ref:"attr:TextItem.selectOnClick",valueType:"boolean",description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnClick','selectOnClick')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnClick')}.",flags:"IRW",name:"selectOnClick"},"attr:DetailViewer.valueAlign":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:DetailViewer",groups:["values"],deprecated:null,ref:"attr:DetailViewer.valueAlign",valueType:"Alignment",description:'Horizontal alignment of values in this viewer.  If unspecified, defaults to \n <code>"right"</code> when in RTL mode and <code>"left"</code> otherwise.',flags:"IRW",name:"valueAlign"},"method:DrawItem.computeAngle":{seeAlso:[],ref:"method:DrawItem.computeAngle",deprecated:null,type:"method",definingClass:"class:DrawItem",params:[{defaultValue:null,optional:false,type:"double",description:"X coordinate of <b>v</b><sub>1</sub>",name:"px1"},{defaultValue:null,optional:false,type:"double",description:"Y coordinate of <b>v</b><sub>1</sub>",name:"py1"},{defaultValue:null,optional:false,type:"double",description:"X coordinate of <b>v</b><sub>2</sub>",name:"px2"},{defaultValue:null,optional:false,type:"double",description:"Y coordinate of <b>v</b><sub>2</sub>",name:"py2"}],description:" Computes the angle in degrees from the positive X axis to the difference vector\n <nobr><b>v</b><sub>2</sub> - <b>v</b><sub>1</sub></nobr> between the two given vectors.\n",flags:"",returns:{type:"double",description:"the angle in degrees, in the range [0, 360)."},name:"computeAngle"},"attr:ListGrid.useAdvancedCriteria":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:ListGrid",groups:["criteriaEditing"],deprecated:null,ref:"attr:ListGrid.useAdvancedCriteria",valueType:"Boolean",description:"Should the ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filter-editor')} in this grid always produce \n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}?",flags:"IRW",name:"useAdvancedCriteria"},"attr:DynamicForm.disableValidation":{seeAlso:[{ref:"method:DynamicForm.saveData",description:null},{ref:"method:DynamicForm.submit",description:null}],defaultValue:"null",type:"attr",definingClass:"class:DynamicForm",groups:["validation"],deprecated:null,ref:"attr:DynamicForm.disableValidation",valueType:"boolean",description:"If set to true, client-side validators will not run on the form when validate() is\n called.  Server-side validators (if any) will still run on attempted save.",flags:"IRW",name:"disableValidation"},"attr:Calendar.selectedCellStyle":{seeAlso:[],defaultValue:'"calendarCellSelected"',type:"attr",definingClass:"class:Calendar",groups:["appearance"],deprecated:null,ref:"attr:Calendar.selectedCellStyle",valueType:"CSSStyleName",description:"The base name for the CSS class applied to a cell that is selected via a mouse drag.",flags:"IRW",name:"selectedCellStyle"},"attr:Calendar.bringEventsToFront":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"class:Calendar",groups:["calendarEvent"],deprecated:null,ref:"attr:Calendar.bringEventsToFront",valueType:"Boolean",description:"If set to true, clicking an event will bring it to the front of the zorder.",flags:"IR",name:"bringEventsToFront"},"attr:FormItem.hintClassName":{seeAlso:[{ref:"attr:FormItem.hint",description:null}],defaultValue:"null",type:"attr",definingClass:"class:FormItem",groups:["appearance"],deprecated:"As of SmartClient version 5.5, deprecated in favor of ${isc.DocUtils.linkForRef('attr:FormItem.hintStyle')}",ref:"attr:FormItem.hintClassName",valueType:"CSSStyleName",description:'CSS class for the "hint" string.',flags:"IR",name:"hintClassName"},"method:Canvas.moveBy":{seeAlso:[],type:"method",definingClass:"class:Canvas",returns:{type:"Boolean",description:"whether the component actually moved"},groups:["positioning"],ref:"method:Canvas.moveBy",deprecated:null,params:[{defaultValue:null,optional:false,type:"int",description:"amount to move horizontally (may be negative)",name:"deltaX"},{defaultValue:null,optional:false,type:"int",description:"amount to move vertically (may be negative)",name:"deltaY"}],description:"          Moves the widget deltaX pixels to the right and deltaY pixels down. Pass negative\n          numbers to move up and/or to the left.\n",flags:"",examples:["${isc.DocUtils.linkForExampleId('move')}"],name:"moveBy"},"classAttr:DataSource.requiredCriterionMessage":{seeAlso:[],defaultValue:'"Operation requires criteria for the following field(s): [${requiredCriterion}]"',type:"classAttr",definingClass:"class:DataSource",groups:["i18nMessages"],deprecated:null,ref:"classAttr:DataSource.requiredCriterionMessage",valueType:"HTMLString",description:"A message returned by a <code>DataSource</code> when an operation requires criteria, but none was provided.",flags:"IRW",name:"requiredCriterionMessage"},"classAttr:Media.svgDefaultSize":{seeAlso:[],defaultValue:"16",type:"classAttr",definingClass:"class:Media",groups:["svgSymbols"],deprecated:null,ref:"classAttr:Media.svgDefaultSize",valueType:"Integer",description:'The default-size in pixels for any request for an SVG symbol that \n doesn\'t provide any sizes (none of width/height/imageWidth/imageHeight on the widget or \n "size" in the src-string).  In this way, unsized SVGs will render at a useable default \n size, rather than at browser-default size, which is 300x150 and never desirable.',flags:"IR",name:"svgDefaultSize"},"method:PortalLayout.willAcceptDrop":{seeAlso:[],ref:"method:PortalLayout.willAcceptDrop",deprecated:null,type:"method",definingClass:"class:PortalLayout",description:" This method has been overridden to support drag-reorder of PortalColumns, and adding of new\n rows by dropping directly on the PortalLayout, as described in ${isc.DocUtils.linkForRef('attr:PortalLayout.dropTypes')}\n",flags:"",returns:{type:"Boolean",description:"true if the widget object being dragged can be dropped on this widget,                      false if it cannot (and <code>drop()</code> should not bubble),\n                      null to permit <code>drop()</code> to bubble to parent elements"},name:"willAcceptDrop"},"attr:Canvas.mouseStillDownInitialDelay":{seeAlso:[],defaultValue:"400",type:"attr",definingClass:"class:Canvas",groups:["events"],deprecated:null,ref:"attr:Canvas.mouseStillDownInitialDelay",valueType:"int",description:"Amount of time (in milliseconds) before mouseStillDown events start to be fired\n repeatedly for this canvas. See ${isc.DocUtils.linkForRef('method:Canvas.mouseStillDown')} for details.",flags:"IRWA",name:"mouseStillDownInitialDelay"},"method:EditContext.substitutedNode":{seeAlso:[],ref:"method:EditContext.substitutedNode",deprecated:null,type:"method",definingClass:"class:EditContext",params:[{defaultValue:null,optional:false,type:"PaletteNode",description:"node that was originally dropped",name:"origNode"},{defaultValue:null,optional:false,type:"PaletteNode",description:"node that was substituted",name:"newNode"},{defaultValue:null,optional:false,type:"EditNode",description:"parent node of the drop",name:"parentNode"}],description:" Notification fired when a different ${isc.DocUtils.linkForRef('object:PaletteNode')} is substituted for one\n being dropped into a container.\n\n",flags:"",name:"substitutedNode"},"attr:MiniDateRangeItem.textBoxStyle":{seeAlso:[{ref:"attr:FormItem.cellStyle",description:null}],defaultValue:'"textItem"',type:"attr",definingClass:"class:MiniDateRangeItem",groups:["formItemStyling"],deprecated:null,ref:"attr:MiniDateRangeItem.textBoxStyle",valueType:"FormItemBaseStyle",description:"Base CSS class name for a form item's text box element.\n <p>\n See ${isc.DocUtils.linkForRef('group:formItemStyling')} for an overview of formItem styling, and \n the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special\n skinning considerations.\n <p>\n If the <code>textBoxStyle</code> is changed at runtime, ${isc.DocUtils.linkForRef('method:FormItem.updateState','updateState()')}\n must be called to update the visual state of this item.",flags:"IRW",name:"textBoxStyle"},"attr:DSRequest.exportShowHeaderSpanTitles":{seeAlso:[],ref:"attr:DSRequest.exportShowHeaderSpanTitles",defaultValue:"true",deprecated:null,type:"attr",definingClass:"object:DSRequest",valueType:"Boolean",description:"When you erxport a ${isc.DocUtils.linkForRef('class:ListGrid')} that has ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')},\n should headerSpans also be exported.  See ${isc.DocUtils.linkForRef('attr:DSRequest.exportSpanTitleSeparator')} for details of\n of what it means to export headerSpans to different export targets.\n <P>    \n Note that ${isc.DocUtils.linkForRef('attr:DSRequest.exportPropertyIdentifier')} controls whether field names or titles\n are appended to the headerSpan titles (and used for fields without headerSpans).",flags:"IR",name:"exportShowHeaderSpanTitles"},"classMethod:DataSource.getAppDataSources":{seeAlso:[],ref:"classMethod:DataSource.getAppDataSources",deprecated:null,type:"classMethod",definingClass:"class:DataSource",description:' Returns the list of registered DataSources\n that represent application-level data, as\n opposed to framework-internal DataSources.\n <p>\n The following categories are excluded:\n <ul>\n <li>Internal framework DataSources (marked\n     <code>_internal</code>, or with an ID\n     starting with "_"), such as those used\n     by the Rules Engine or Selenium test\n     infrastructure</li>\n <li>Component and builtin schema DataSources\n     (<code>componentSchema</code> /\n     <code>builtinSchema</code>)</li>\n <li>DataSources with IDs starting with\n     "isc_" (framework-internal)</li>\n <li>DataSources with auto-assigned IDs\n     (potentially unstable references)</li>\n </ul>\n\n',flags:"",returns:{type:"Array of DataSource",description:"application                               DataSources"},name:"getAppDataSources"},"attr:TimeItem.minuteItemProperties":{seeAlso:[],ref:"attr:TimeItem.minuteItemProperties",defaultValue:"null",deprecated:null,type:"attr",definingClass:"class:TimeItem",valueType:"SelectItem Properties",description:"Custom properties to apply to this timeItem's generated \n ${isc.DocUtils.linkForRef('attr:TimeItem.minuteItem','minute picker')}.",flags:"IRA",name:"minuteItemProperties"},"attr:MinimalScrollbar.autoHideDelay":{seeAlso:[],ref:"attr:MinimalScrollbar.autoHideDelay",defaultValue:"1000",deprecated:null,type:"attr",definingClass:"class:MinimalScrollbar",valueType:"number",description:"If ${isc.DocUtils.linkForRef('attr:MinimalScrollbar.autoShow')} is true, the scrollbar will auto hide after\n the user has stopped interacting with it for this many milliseconds.",flags:"IRW",name:"autoHideDelay"},"method:ListGrid.setBodyStyleName":{seeAlso:[],ref:"method:ListGrid.setBodyStyleName",deprecated:null,type:"method",definingClass:"class:ListGrid",params:[{defaultValue:null,optional:false,type:"CSSStyleName",description:"new body style name",name:"styleName"}],description:" Update the ${isc.DocUtils.linkForRef('attr:ListGrid.bodyStyleName','bodyStyleName')} for this listGrid.\n",flags:"",name:"setBodyStyleName"},"attr:ListGrid.showExpansionEditorSaveButton":{seeAlso:[],defaultValue:"true",type:"attr",definingClass:"class:ListGrid",groups:["expansionField"],deprecated:null,ref:"attr:ListGrid.showExpansionEditorSaveButton",valueType:"Boolean",description:"When ${isc.DocUtils.linkForRef('type:ExpansionMode')} is <i>editor</i>, should a Save button be shown below the\n the expanded editor?\n <P>\n Note that if an expanded-row containing an editor is collapsed while changes are\n outstanding, changes will be either be automatically updated to the grid, or will first\n show a confirmation dialog, according to the value of\n ${isc.DocUtils.linkForRef('attr:ListGrid.expansionEditorShowSaveDialog')}.",flags:"RW",name:"showExpansionEditorSaveButton"},"group:items":{refs:["method:DynamicForm.getItem","method:DynamicForm.getField","attr:DynamicForm.items","attr:DynamicForm.fields","attr:ToolbarItem.buttons"],seeAlso:[],ref:"group:items",deprecated:null,type:"group",title:"Form Items",description:"Manipulating the items that belong to a form.\n <BR><br>\n An item manages an atomic value (eg a String, Number, Date, etc) that appears as one of the\n properties in the overall form's values.  Some items exist purely for layout or appearance\n purposes (eg SpacerItem) and do not manage a value.",name:"items"},"attr:TreeGrid.cantDragMultipleNodeOccurencesMessage":{seeAlso:[{ref:"attr:TreeGrid.canDragRecordsOut",description:null},{ref:"attr:TreeGrid.canAcceptDroppedRecords",description:null},{ref:"attr:TreeGrid.canReorderRecords",description:null},{ref:"attr:TreeGrid.parentAlreadyContainsChildMessage",description:null}],defaultValue:'"You can\'t drag two occurrences of the same node into a parent."',type:"attr",definingClass:"class:TreeGrid",groups:["i18nMessages"],deprecated:null,ref:"attr:TreeGrid.cantDragMultipleNodeOccurencesMessage",valueType:"String",description:"For ${isc.DocUtils.linkForRef('method:Tree.isMultiLinkTree','Multi-link trees')} only, the message displayed when the \n user attempts to drag two or more occurrences of the same node into a parent.",flags:"IR",name:"cantDragMultipleNodeOccurencesMessage"},"classAttr:SortSpecifierUtil.descendingSortDescription":{seeAlso:[],defaultValue:'"${propertyTitle} in descending order"',type:"classAttr",definingClass:"class:SortSpecifierUtil",groups:["i18nMessages"],deprecated:null,ref:"classAttr:SortSpecifierUtil.descendingSortDescription",valueType:"HTMLString",description:"The description of",flags:"IRW",name:"descendingSortDescription"},"method:ResultSet.find":{seeAlso:[{ref:"classMethod:DataSource.isAdvancedCriteria",description:null}],type:"method",definingClass:"class:ResultSet",returns:{type:"Object",description:"first matching object or null if not found"},groups:["access","find"],deprecated:null,ref:"method:ResultSet.find",params:[{defaultValue:null,optional:false,type:"String | Object | AdvancedCriteria",description:"property to match, or if an Object is passed, set of                                        properties and values to match",name:"propertyName"},{defaultValue:null,optional:true,type:"Any",description:"value to compare against (if propertyName is a string)",name:"value"}],description:" Like ${isc.DocUtils.linkForRef('method:List.find')}.  Checks only loaded rows and will not trigger a fetch.\n <P>\n When ${isc.DocUtils.linkForRef('attr:ResultSet.indexFilteredData','filtered indexing')} is enabled, this method\n automatically uses filtered indices for O(1) lookups when criteria have narrowed the visible\n dataset.\n",flags:"",name:"find"},"method:CalendarView.isVerticalView":{seeAlso:[],ref:"method:CalendarView.isVerticalView",deprecated:null,type:"method",definingClass:"class:CalendarView",description:" Returns true if this is the ${isc.DocUtils.linkForRef('attr:Calendar.weekView','week')} or ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')}\n view, false otherwise.\n",flags:"",returns:{type:"boolean",description:"true if this is a Week or Day view"},name:"isVerticalView"},"attr:DataBoundComponent.asyncErrorHoverProperties":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"interface:DataBoundComponent",groups:["fieldGeneration","pseudoFieldGeneration"],deprecated:null,ref:"attr:DataBoundComponent.asyncErrorHoverProperties",valueType:"Label Properties",description:"Properties to use for a hover displaying information about a non-successful asynchronous\n operation.\n <p>\n Only the properties mentioned on the documentation of ${isc.DocUtils.linkForRef('classMethod:Hover.show')} will have an effect.",flags:"IRW",name:"asyncErrorHoverProperties"},"attr:FormItem.type":{seeAlso:[{ref:"type:FormItemType",description:null},{ref:"type:FieldType",description:null}],defaultValue:'"text"',type:"attr",definingClass:"class:FormItem",groups:["appearance"],deprecated:null,ref:"attr:FormItem.type",valueType:"FormItemType | String",description:'The DynamicForm picks a field renderer based on the type of the field (and sometimes other\n attributes of the field).\n <P>\n In addition to the standard ${isc.DocUtils.linkForRef(\'type:FormItemType\')} values, this property also accepts\n the name of any ${isc.DocUtils.linkForRef(\'class:FormItem\')} subclass (e.g., "ButtonItem", "CheckboxItem") or a\n shorthand lowercase version (e.g., "button", "checkbox"). When a class name or shorthand\n is provided, it acts as a shortcut for setting ${isc.DocUtils.linkForRef(\'attr:FormItem.editorType\')}.',flags:"IR",name:"type"},"attr:DataSourceField.sequenceName":{seeAlso:[],defaultValue:"null",type:"attr",definingClass:"object:DataSourceField",groups:["sqlDataSource"],ref:"attr:DataSourceField.sequenceName",deprecated:null,valueType:"String",description:'For a DataSource with ${isc.DocUtils.linkForRef(\'attr:DataSource.serverType\',\'serverType:"sql"\')} with a field of type\n "sequence", the name of the SQL sequence that should be used when inserting new records into\n this table.\n <P>\n Note that this is never required for SQL tables that are generated from SmartClient\n DataSources (a default sequence name of tableName + "_" + columnName is chosen, but see the\n notes below regarding this), and is never required for databases where inserting null into a \n sequence column is sufficient (MySQL, SQL Server, DB2 and others). \n <P>\n You would only need to set sequenceName if you are integrating with a pre-existing table\n stored in a database where the sequence must be named for insertion to work (Oracle,\n Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.\n <P>\n <b>Note:</b> If you specify the <code>sql.{database type}.sequence.name.prefix</code> and/or \n <code>sql.{database type}.sequence.name.suffix</code> properties in your \n ${isc.DocUtils.linkForRef(\'group:server_properties\',\'server.properties\')} file,the generated sequence name will include the prefix and/or\n suffix.  For example, with a prefix of "order_system_" and a suffix of "_seq", the sequence\n generated for column "orderNumber" on table "orders" would be:<pre>\n     order_system_orders_orderNumber_seq\n </pre>',flags:"IR",serverDS:"allowed",name:"sequenceName"},"attr:TextAreaItem.textBoxStyle":{seeAlso:[],defaultValue:'"textItem"',type:"attr",definingClass:"class:TextAreaItem",groups:["appearance"],deprecated:null,ref:"attr:TextAreaItem.textBoxStyle",valueType:"FormItemBaseStyle",description:"Base CSS class to apply to this item's input element.\n NOTE: See the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special skinning considerations.",flags:"IRW",name:"textBoxStyle"},"classMethod:Authentication.setAvailableRoles":{seeAlso:[],ref:"classMethod:Authentication.setAvailableRoles",deprecated:null,type:"classMethod",definingClass:"class:Authentication",params:[{defaultValue:null,optional:false,type:"Array of String",description:"full set of possible user roles.",name:"roles"}],description:" Specify the full set of available user roles.\n <P>\n Note that if the current user has been marked as a \n ${isc.DocUtils.linkForRef('classMethod:Authentication.isSuperUser','superUser')}, ${isc.DocUtils.linkForRef('classMethod:Authentication.getRoles')} will return\n the full set of available roles.\n\n",flags:"",name:"setAvailableRoles"},"class:Messaging":{seeAlso:[],type:"class",staticMethods:[],inheritsFrom:"Class",classMethods:["classMethod:Messaging.send","classMethod:Messaging.getSubscribedChannels","classMethod:Messaging.subscribe","classMethod:Messaging.unsubscribe","classMethod:Messaging.connected","classMethod:Messaging.disconnect","classMethod:Messaging.connectionUp","classMethod:Messaging.connectionDown"],classAttrs:["classAttr:Messaging.messagingURL","classAttr:Messaging.websocketURL","classAttr:Messaging.useWebSocket","classAttr:Messaging.fallBackToComet","classAttr:Messaging.websocketConnectTimeout","classAttr:Messaging