/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.DataTruncation;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.JDBCException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;

public class SQLExceptionTypeDelegate
extends AbstractSQLExceptionConversionDelegate {
    public SQLExceptionTypeDelegate(@UnknownKeyFor @NonNull @Initialized ConversionContext conversionContext) {
        super(conversionContext);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JDBCException convert(@UnknownKeyFor @NonNull @Initialized SQLException sqlException, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized String sql) {
        if (sqlException instanceof SQLClientInfoException || sqlException instanceof SQLInvalidAuthorizationSpecException || sqlException instanceof SQLNonTransientConnectionException || sqlException instanceof SQLTransientConnectionException) {
            return new JDBCConnectionException(message, sqlException, sql);
        }
        if (sqlException instanceof DataTruncation || sqlException instanceof SQLDataException) {
            return new DataException(message, sqlException, sql);
        }
        if (sqlException instanceof SQLIntegrityConstraintViolationException) {
            return new ConstraintViolationException(message, sqlException, sql, this.getConversionContext().getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
        }
        if (sqlException instanceof SQLSyntaxErrorException) {
            return new SQLGrammarException(message, sqlException, sql);
        }
        if (sqlException instanceof SQLTimeoutException) {
            return new QueryTimeoutException(message, sqlException, sql);
        }
        if (sqlException instanceof SQLTransactionRollbackException) {
            return new LockAcquisitionException(message, sqlException, sql);
        }
        return null;
    }
}

