/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class PlaywrightResultParser {
    private static Logger log = new Logger(PlaywrightResultParser.class.getName());
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final JSTranslater jsTrans;

    public static void parseAndCallback(BufferedReader reader, TestRunnerHelper.TestCallback callback) throws IOException {
        String line;
        boolean browserVersionLogged = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            try {
                TestCaseResults tcr;
                String browserVersion;
                if (!browserVersionLogged && (browserVersion = PlaywrightResultParser.extractBrowserVersion(line)) != null) {
                    log.info((Object)("Playwright using Chromium " + browserVersion));
                    TestRunnerConfiguration config = ConfiguredBase.getConfiguration();
                    ((TestRunnerLauncher)config).setPlaywrightBrowserVersion(browserVersion);
                    browserVersionLogged = true;
                }
                if ((tcr = PlaywrightResultParser.parseLine(line)) == null) continue;
                callback.onTestResults(tcr);
            }
            catch (Exception e) {
                log.error((Object)("Failed to parse Playwright result line: " + line), (Throwable)e);
            }
        }
    }

    private static String extractBrowserVersion(String jsonLine) {
        int idx = jsonLine.indexOf("\"browserVersion\"");
        if (idx < 0) {
            return null;
        }
        int colonIdx = jsonLine.indexOf(":", idx);
        if (colonIdx < 0) {
            return null;
        }
        int startQuote = jsonLine.indexOf("\"", colonIdx);
        if (startQuote < 0) {
            return null;
        }
        int endQuote = jsonLine.indexOf("\"", startQuote + 1);
        if (endQuote < 0) {
            return null;
        }
        return jsonLine.substring(startQuote + 1, endQuote);
    }

    public static TestCaseResults parseLine(String jsonLine) {
        Object testResultsObj;
        String error;
        Object timeoutObj;
        Object parsed;
        try {
            parsed = jsTrans.fromJS(jsonLine);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to parse JSON: " + jsonLine), (Throwable)e);
            return null;
        }
        if (!(parsed instanceof Map)) {
            log.warn((Object)("Playwright output line is not a JSON object: " + jsonLine));
            return null;
        }
        Map json = (Map)parsed;
        TestCaseResults tcr = new TestCaseResults();
        tcr.setTestName((String)json.get("testName"));
        tcr.setStartTime(PlaywrightResultParser.parseDate((String)json.get("startTime")));
        tcr.setEndTime(PlaywrightResultParser.parseDate((String)json.get("endTime")));
        Boolean timeoutError = (Boolean)json.get("timeoutError");
        if (timeoutError != null && timeoutError.booleanValue()) {
            tcr.setTimeoutError(true);
        }
        if ((timeoutObj = json.get("timeoutInSeconds")) instanceof Number) {
            tcr.setTimeoutInSeconds(((Number)timeoutObj).intValue());
        }
        if ((error = (String)json.get("error")) != null) {
            tcr.setSeleniumError(error);
        }
        if ((testResultsObj = json.get("testResults")) instanceof List) {
            List testResultsList = (List)testResultsObj;
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            for (Object trObj : testResultsList) {
                Map trJson;
                TestResult tr;
                if (!(trObj instanceof Map) || (tr = PlaywrightResultParser.parseTestResult(trJson = (Map)trObj)) == null) continue;
                testResults.add(tr);
            }
            tcr.setTestResults(testResults);
        }
        return tcr;
    }

    private static TestResult parseTestResult(Map<String, Object> json) {
        TestResult tr = new TestResult();
        tr.setTestFile((String)json.get("testFile"));
        Object testNumObj = json.get("testNumber");
        if (testNumObj instanceof Number) {
            tr.setTestNumber(((Number)testNumObj).intValue());
        } else {
            tr.setTestNumber(1);
        }
        String result = (String)json.get("result");
        if (result != null) {
            tr.setResult(result);
        } else {
            tr.setResult("unknown");
        }
        tr.setDescription((String)json.get("description"));
        tr.setDetails((String)json.get("details"));
        tr.setMessages((String)json.get("messages"));
        tr.setStartTime(PlaywrightResultParser.parseDate((String)json.get("startTime")));
        tr.setEndTime(PlaywrightResultParser.parseDate((String)json.get("endTime")));
        return tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseDate(String isoString) {
        if (isoString == null || isoString.isEmpty()) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = ISO_FORMAT;
            synchronized (simpleDateFormat) {
                return ISO_FORMAT.parse(isoString);
            }
        }
        catch (ParseException e) {
            log.warn((Object)("Failed to parse date: " + isoString));
            return new Date();
        }
    }

    public static List<TestCaseResults> parseAll(BufferedReader reader) throws IOException {
        final ArrayList<TestCaseResults> results = new ArrayList<TestCaseResults>();
        PlaywrightResultParser.parseAndCallback(reader, new TestRunnerHelper.TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                results.add(testCaseResults);
            }
        });
        return results;
    }

    static {
        ISO_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        jsTrans = JSTranslater.instance();
    }
}

