/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ProcessedFileCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.codec.digest.DigestUtils;

public class GraalContextPoolManager {
    private static final Logger log = new Logger(GraalContextPoolManager.class.getName());
    private static GraalContextPoolManager instance;
    private static JavaScriptFileCache jsFileCache;
    private final ConcurrentHashMap<String, ContextPool> contextPools = new ConcurrentHashMap();
    private static final int DEFAULT_MAX_POOL_SIZE;
    private static final boolean DEFAULT_POOL_ENABLED;

    private GraalContextPoolManager() {
        log.info("GraalContextPoolManager initialized (default pool size: " + DEFAULT_MAX_POOL_SIZE + ", enabled: " + DEFAULT_POOL_ENABLED + ")");
    }

    public static synchronized GraalContextPoolManager getInstance() {
        if (instance == null) {
            instance = new GraalContextPoolManager();
        }
        return instance;
    }

    private static void loadModuleFile(Object context, String moduleFilePath) throws Exception {
        log.debug("Loading module file: " + moduleFilePath);
        String moduleCode = jsFileCache.getJavaScriptContent(moduleFilePath);
        GraalContextPoolManager.evalInContextVoid(context, moduleCode);
    }

    private static void evalInContextVoid(Object context, String script) throws Exception {
        try {
            Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context");
            Method evalMethod = contextClass.getMethod("eval", String.class, CharSequence.class);
            evalMethod.invoke(context, "js", script);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                log.error("GraalJS eval failed: " + cause.getClass().getName() + ": " + cause.getMessage());
                try {
                    Method getSourceLocationMethod = cause.getClass().getMethod("getSourceLocation", new Class[0]);
                    Object sourceLocation = getSourceLocationMethod.invoke((Object)cause, new Object[0]);
                    if (sourceLocation != null) {
                        log.error("Error source location: " + String.valueOf(sourceLocation));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.error("Script starts with: " + script.substring(0, Math.min(200, script.length())));
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
            throw e;
        }
    }

    public Object getContext(PoolConfig config) throws Exception {
        if (!DEFAULT_POOL_ENABLED) {
            throw new Exception("Context pools are disabled (scripting.graal.contextPool.enabled=false)");
        }
        String poolKey = config.getPoolKey();
        ContextPool pool = this.contextPools.computeIfAbsent(poolKey, k -> {
            log.info("Creating new context pool pool: " + k);
            return new ContextPool(config, (String)k);
        });
        return pool.borrowContext();
    }

    public void returnContext(PoolConfig config, Object context) {
        String poolKey = config.getPoolKey();
        ContextPool pool = this.contextPools.get(poolKey);
        if (pool != null) {
            pool.returnContext(context);
        } else {
            log.warn("No pool found for pool key: " + poolKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(PoolConfig config, String script, Map<String, Object> bindings) throws Exception {
        long startTime = System.currentTimeMillis();
        Object context = null;
        try {
            long t0 = System.currentTimeMillis();
            context = this.getContext(config);
            long t1 = System.currentTimeMillis();
            if (bindings == null) {
                bindings = new HashMap<String, Object>();
            }
            bindings.put("__executionStartTime", startTime);
            long t2 = System.currentTimeMillis();
            this.setBindings(context, bindings);
            long t3 = System.currentTimeMillis();
            if (config.getOperationFiles() != null && !config.getOperationFiles().isEmpty()) {
                for (String operationFile : config.getOperationFiles()) {
                    GraalContextPoolManager.loadModuleFile(context, operationFile);
                }
            }
            long t4 = System.currentTimeMillis();
            Object result = this.evalInContext(context, script);
            long t5 = System.currentTimeMillis();
            long totalTime = t5 - startTime;
            long phase1_contextAcquisition = t1 - t0;
            long phase2_bindingPrep = t2 - t1;
            long phase3_bindingInjection = t3 - t2;
            long phase4_operationFiles = t4 - t3;
            long phase5_scriptExecution = t5 - t4;
            log.info("GRAAL_PROFILING: total=" + totalTime + "ms, contextAcq=" + phase1_contextAcquisition + "ms, bindPrep=" + phase2_bindingPrep + "ms, bindInject=" + phase3_bindingInjection + "ms, opFiles=" + phase4_operationFiles + "ms, scriptExec=" + phase5_scriptExecution + "ms");
            Object object = result;
            return object;
        }
        finally {
            if (context != null) {
                this.returnContext(config, context);
            }
        }
    }

    private void setBindings(Object context, Map<String, Object> bindings) throws Exception {
        Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context");
        Class<?> valueClass = Class.forName("org.graalvm.polyglot.Value");
        Method getBindingsMethod = contextClass.getMethod("getBindings", String.class);
        Object jsBindings = getBindingsMethod.invoke(context, "js");
        Method putMemberMethod = valueClass.getMethod("putMember", String.class, Object.class);
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            putMemberMethod.invoke(jsBindings, entry.getKey(), entry.getValue());
        }
    }

    private Object evalInContext(Object context, String script) throws Exception {
        try {
            Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context");
            Class<?> valueClass = Class.forName("org.graalvm.polyglot.Value");
            Method evalMethod = contextClass.getMethod("eval", String.class, CharSequence.class);
            Object value = evalMethod.invoke(context, "js", script);
            return this.convertValue(value, valueClass);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
            throw e;
        }
    }

    private Object convertValue(Object value, Class<?> valueClass) throws Exception {
        if (value == null || !valueClass.isInstance(value)) {
            return value;
        }
        Method isNullMethod = valueClass.getMethod("isNull", new Class[0]);
        if (((Boolean)isNullMethod.invoke(value, new Object[0])).booleanValue()) {
            return null;
        }
        Method isHostObjectMethod = valueClass.getMethod("isHostObject", new Class[0]);
        if (((Boolean)isHostObjectMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asHostObjectMethod = valueClass.getMethod("asHostObject", new Class[0]);
            return asHostObjectMethod.invoke(value, new Object[0]);
        }
        Method isStringMethod = valueClass.getMethod("isString", new Class[0]);
        if (((Boolean)isStringMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asStringMethod = valueClass.getMethod("asString", new Class[0]);
            return asStringMethod.invoke(value, new Object[0]);
        }
        Method isNumberMethod = valueClass.getMethod("isNumber", new Class[0]);
        if (((Boolean)isNumberMethod.invoke(value, new Object[0])).booleanValue()) {
            Method fitsInLongMethod = valueClass.getMethod("fitsInLong", new Class[0]);
            if (((Boolean)fitsInLongMethod.invoke(value, new Object[0])).booleanValue()) {
                Method asLongMethod = valueClass.getMethod("asLong", new Class[0]);
                return asLongMethod.invoke(value, new Object[0]);
            }
            Method asDoubleMethod = valueClass.getMethod("asDouble", new Class[0]);
            return asDoubleMethod.invoke(value, new Object[0]);
        }
        Method isBooleanMethod = valueClass.getMethod("isBoolean", new Class[0]);
        if (((Boolean)isBooleanMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asBooleanMethod = valueClass.getMethod("asBoolean", new Class[0]);
            return asBooleanMethod.invoke(value, new Object[0]);
        }
        Method hasArrayElementsMethod = valueClass.getMethod("hasArrayElements", new Class[0]);
        if (((Boolean)hasArrayElementsMethod.invoke(value, new Object[0])).booleanValue()) {
            return this.convertArrayValue(value, valueClass);
        }
        Method hasMembersMethod = valueClass.getMethod("hasMembers", new Class[0]);
        if (((Boolean)hasMembersMethod.invoke(value, new Object[0])).booleanValue()) {
            return this.convertObjectValue(value, valueClass);
        }
        return value;
    }

    private List<Object> convertArrayValue(Object value, Class<?> valueClass) throws Exception {
        Method getArraySizeMethod = valueClass.getMethod("getArraySize", new Class[0]);
        long size = (Long)getArraySizeMethod.invoke(value, new Object[0]);
        Method getArrayElementMethod = valueClass.getMethod("getArrayElement", Long.TYPE);
        ArrayList<Object> result = new ArrayList<Object>();
        for (long i = 0L; i < size; ++i) {
            Object element = getArrayElementMethod.invoke(value, i);
            result.add(this.convertValue(element, valueClass));
        }
        return result;
    }

    private Map<String, Object> convertObjectValue(Object value, Class<?> valueClass) throws Exception {
        Method getMemberKeysMethod = valueClass.getMethod("getMemberKeys", new Class[0]);
        Object keySet = getMemberKeysMethod.invoke(value, new Object[0]);
        Method getMemberMethod = valueClass.getMethod("getMember", String.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object key : (Iterable)keySet) {
            String keyStr = key.toString();
            Object memberValue = getMemberMethod.invoke(value, keyStr);
            result.put(keyStr, this.convertValue(memberValue, valueClass));
        }
        return result;
    }

    public void shutdown() {
        log.info("Shutting down GraalContextPoolManager (" + this.contextPools.size() + " context pools)");
        for (ContextPool pool : this.contextPools.values()) {
            pool.shutdown();
        }
        this.contextPools.clear();
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalContextPools", this.contextPools.size());
        stats.put("poolKeys", new ArrayList(this.contextPools.keySet()));
        return stats;
    }

    static {
        jsFileCache = new JavaScriptFileCache();
        DEFAULT_MAX_POOL_SIZE = Config.getGlobal().getInteger((Object)"scripting.graal.contextPool.maxPoolSize", 5);
        DEFAULT_POOL_ENABLED = Config.getGlobal().getBoolean((Object)"scripting.graal.contextPool.enabled", true);
    }

    private static class JavaScriptFileCache
    extends ProcessedFileCache {
        private static final Logger log = new Logger(JavaScriptFileCache.class.getName());

        private JavaScriptFileCache() {
        }

        @Override
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            if (!file.exists()) {
                throw new FileNotFoundException("JavaScript file not found: " + file.getPath());
            }
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream(), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            log.debug("Loaded JavaScript file from disk: " + file.getPath() + " (" + content.length() + " chars)");
            return content.toString();
        }

        public String getJavaScriptContent(String filePath) throws Exception {
            String line;
            BufferedReader reader;
            Object file;
            boolean isAbsoluteFilesystem;
            block30: {
                boolean isISCModule;
                boolean isWebrootRelative = filePath.startsWith("/isomorphic/") || filePath.startsWith("/shared/") || !filePath.startsWith("/") && !filePath.contains(":");
                isAbsoluteFilesystem = filePath.startsWith("/") && !isWebrootRelative || filePath.length() > 2 && filePath.charAt(1) == ':';
                boolean bl = isISCModule = filePath.contains("/ISC_") && filePath.endsWith(".js");
                if (isISCModule) {
                    String virtualPath = filePath;
                    int systemIdx = filePath.indexOf("/isomorphic/system/");
                    if (systemIdx >= 0) {
                        virtualPath = filePath.substring(systemIdx);
                    } else {
                        int lastIscIdx = filePath.lastIndexOf("/isomorphic/");
                        if (lastIscIdx >= 0) {
                            virtualPath = filePath.substring(lastIscIdx);
                        }
                    }
                    log.info("Using FileAssembler for ISC module: " + virtualPath);
                    try {
                        Class<?> assemblerClass = Class.forName("com.isomorphic.assembly.FileAssembler");
                        Object assembler = assemblerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Method assembleMethod = assemblerClass.getMethod("assembleFile", String.class);
                        String assembledFilePath = (String)assembleMethod.invoke(assembler, virtualPath);
                        if (assembledFilePath != null) {
                            log.info("FileAssembler cached to: " + assembledFilePath);
                            File cachedFile = new File(assembledFilePath);
                            if (cachedFile.exists()) {
                                StringBuilder content = new StringBuilder();
                                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cachedFile), "UTF-8"));){
                                    String line2;
                                    while ((line2 = reader2.readLine()) != null) {
                                        content.append(line2).append("\n");
                                    }
                                }
                                log.info("Loaded assembled ISC module: " + virtualPath + " (" + content.length() + " chars)");
                                return content.toString();
                            }
                            log.warn("FileAssembler cache file doesn't exist: " + assembledFilePath);
                            break block30;
                        }
                        log.warn("FileAssembler returned null for " + virtualPath + ", falling back to direct file read");
                    }
                    catch (Exception e) {
                        log.warn("FileAssembler failed for " + virtualPath + ": " + e.getMessage() + ", falling back to direct file read");
                    }
                }
            }
            if (isAbsoluteFilesystem) {
                file = new File(filePath);
                if (!((File)file).exists()) {
                    throw new FileNotFoundException("JavaScript file not found: " + filePath);
                }
                StringBuilder content = new StringBuilder();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file), "UTF-8"));
                try {
                    while ((line = reader.readLine()) != null) {
                        content.append(line).append("\n");
                    }
                }
                finally {
                    reader.close();
                }
                log.debug("Loaded JavaScript file from absolute path: " + filePath + " (" + content.length() + " chars)");
                return content.toString();
            }
            file = ISCFile.newInstance(filePath);
            if (!((ISCFile)file).exists()) {
                throw new FileNotFoundException("JavaScript file not found: " + filePath + " (resolved to: " + ((ISCFile)file).getPath() + ")");
            }
            StringBuilder content = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(((ISCFile)file).getInputStream(), "UTF-8"));
            try {
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            finally {
                reader.close();
            }
            log.debug("Loaded JavaScript file via ISCFile: " + filePath + " (resolved: " + ((ISCFile)file).getPath() + ", " + content.length() + " chars)");
            return content.toString();
        }

        public boolean hasFileChanged(String filePath) throws Exception {
            if (filePath.startsWith("/")) {
                return false;
            }
            ISCFile file = ISCFile.newInstance(filePath);
            HashMap flags = new HashMap();
            Object content = this.getObjectFromFile(file, flags);
            return flags.containsKey("objectWasStale") && (Boolean)flags.get("objectWasStale") != false;
        }
    }

    public static class PoolConfig {
        private List<String> moduleFiles = new ArrayList<String>();
        private List<String> operationFiles = new ArrayList<String>();
        private String initScript = null;
        private int maxPoolSize = DEFAULT_MAX_POOL_SIZE;
        private Map<String, Object> contextOptions = new HashMap<String, Object>();

        public PoolConfig addModuleFile(String filePath) {
            this.moduleFiles.add(filePath);
            return this;
        }

        public PoolConfig setModuleFiles(List<String> moduleFiles) {
            this.moduleFiles = moduleFiles;
            return this;
        }

        public PoolConfig addOperationFile(String filePath) {
            this.operationFiles.add(filePath);
            return this;
        }

        public PoolConfig setOperationFiles(List<String> operationFiles) {
            this.operationFiles = operationFiles;
            return this;
        }

        public PoolConfig setInitScript(String initScript) {
            this.initScript = initScript;
            return this;
        }

        public PoolConfig setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public PoolConfig setContextOption(String key, Object value) {
            this.contextOptions.put(key, value);
            return this;
        }

        public List<String> getModuleFiles() {
            return this.moduleFiles;
        }

        public List<String> getOperationFiles() {
            return this.operationFiles;
        }

        public String getInitScript() {
            return this.initScript;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public Map<String, Object> getContextOptions() {
            return this.contextOptions;
        }

        public String getPoolKey() {
            StringBuilder sb = new StringBuilder();
            for (String string : this.moduleFiles) {
                sb.append(string).append(";");
            }
            if (this.initScript != null) {
                sb.append("init:").append(this.initScript).append(";");
            }
            for (Map.Entry entry : this.contextOptions.entrySet()) {
                sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
            return DigestUtils.md5Hex((String)sb.toString());
        }
    }

    private static class ContextPool {
        private final PoolConfig config;
        private final String poolKey;
        private final LinkedBlockingQueue<Object> availableContexts;
        private final Set<Object> allContexts;
        private int totalCreated = 0;

        public ContextPool(PoolConfig config, String poolKey) {
            this.config = config;
            this.poolKey = poolKey;
            this.availableContexts = new LinkedBlockingQueue(config.getMaxPoolSize());
            this.allContexts = Collections.synchronizedSet(new HashSet());
        }

        public PoolConfig getConfig() {
            return this.config;
        }

        public synchronized Object borrowContext() throws Exception {
            Object context = this.availableContexts.poll();
            if (context != null) {
                log.debug("Borrowed existing context from pool (poolKey: " + this.poolKey + ")");
                return context;
            }
            if (this.totalCreated < this.config.getMaxPoolSize()) {
                context = this.createInitializedContext();
                ++this.totalCreated;
                this.allContexts.add(context);
                log.info("Created new context for pool " + this.poolKey + " (total: " + this.totalCreated + "/" + this.config.getMaxPoolSize() + ")");
                return context;
            }
            log.debug("Context pool exhausted, waiting for available context...");
            context = this.availableContexts.take();
            log.debug("Acquired context after waiting");
            return context;
        }

        public void returnContext(Object context) {
            if (context == null || !this.allContexts.contains(context)) {
                log.warn("Attempted to return context not from this pool");
                return;
            }
            try {
                this.resetContextBindings(context);
                boolean added = this.availableContexts.offer(context);
                if (!added) {
                    log.warn("Could not return context to pool (pool full) - closing context");
                    this.closeContext(context);
                    this.allContexts.remove(context);
                    --this.totalCreated;
                } else {
                    log.debug("Returned context to pool (poolKey: " + this.poolKey + ")");
                }
            }
            catch (Exception e) {
                log.warn("Error returning context to pool: " + e.getMessage());
                this.closeContext(context);
                this.allContexts.remove(context);
                --this.totalCreated;
            }
        }

        private Object createInitializedContext() throws Exception {
            long start = System.currentTimeMillis();
            Object context = this.createPolyglotContext();
            String globalSetup = "(function() {  var __graaljs_global__ = this;  if (typeof window === 'undefined') {    this.window = __graaljs_global__;  }  if (typeof global === 'undefined') {    this.global = __graaljs_global__;  }  if (typeof globalThis === 'undefined') {    this.globalThis = __graaljs_global__;  }  __graaljs_global__.window = __graaljs_global__;  __graaljs_global__.global = __graaljs_global__;  __graaljs_global__.globalThis = __graaljs_global__;  if (__graaljs_global__.window) {    __graaljs_global__.window.window = __graaljs_global__.window;  }  if (__graaljs_global__.global) {    __graaljs_global__.global.global = __graaljs_global__.global;  }}).call(this);";
            GraalContextPoolManager.evalInContextVoid(context, globalSetup);
            log.debug("Initialized global object references (window, global, globalThis)");
            ArrayList<String> scModules = new ArrayList<String>();
            ArrayList<String> userFiles = new ArrayList<String>();
            for (String moduleFile : this.config.getModuleFiles()) {
                if (moduleFile.contains("ISC_") || moduleFile.contains("isomorphic/system/modules/")) {
                    scModules.add(moduleFile);
                    continue;
                }
                userFiles.add(moduleFile);
            }
            String coreModule = null;
            ArrayList<String> otherModules = new ArrayList<String>();
            for (String scModule : scModules) {
                if (scModule.contains("ISC_Core_Server.js")) {
                    coreModule = scModule;
                    continue;
                }
                otherModules.add(scModule);
            }
            if (coreModule != null) {
                log.debug("Loading ISC_Core_Server.js first to establish base classes");
                GraalContextPoolManager.loadModuleFile(context, coreModule);
                String ensureStubs = "(function() {  if (typeof isc !== 'undefined' && typeof isc._ensureUIClassStubs === 'function') {    isc._ensureUIClassStubs();    return 'UI class stubs initialized';  } else {    return 'isc._ensureUIClassStubs() not available';  }}).call(this);";
                try {
                    GraalContextPoolManager.evalInContextVoid(context, ensureStubs);
                    log.debug("Called isc._ensureUIClassStubs() to set up UI class stubs");
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to call isc._ensureUIClassStubs(), continuing anyway", e);
                }
                String ensureGraalFlag = "(function() {  if (typeof isc !== 'undefined' && isc.Browser) {    isc.Browser.isGraalJS = true;    isc.Browser.isServerJS = true;    isc.Browser.isDesktop = true;    return 'isGraalJS flag set';  } else {    return 'isc.Browser not available';  }}).call(this);";
                try {
                    GraalContextPoolManager.evalInContextVoid(context, ensureGraalFlag);
                    log.debug("Set isc.Browser.isGraalJS = true for GraalDS utilities");
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to set isGraalJS flag", e);
                }
            }
            for (String scModule : otherModules) {
                GraalContextPoolManager.loadModuleFile(context, scModule);
            }
            if (!userFiles.isEmpty()) {
                log.debug("Verifying SmartClient initialization before loading user files...");
                String checkSC = "(function() {  if (typeof window === 'undefined') {    throw new Error('window object not defined after loading SC modules');  }  if (typeof window.isc === 'undefined') {    throw new Error('window.isc not defined after loading SC modules');  }  if (typeof window.isc.DataSource === 'undefined') {    var available = [];    for (var key in window.isc) {      available.push(key);    }    throw new Error('window.isc.DataSource not defined. Available: ' + available.slice(0,20).join(', '));  }  return true;}).call(this);";
                try {
                    GraalContextPoolManager.evalInContextVoid(context, checkSC);
                    log.info("SmartClient initialized successfully (isc.DataSource exists), loading user files");
                }
                catch (Exception e) {
                    log.error((Object)"SmartClient not properly initialized", e);
                    throw e;
                }
            }
            for (String userFile : userFiles) {
                GraalContextPoolManager.loadModuleFile(context, userFile);
            }
            if (this.config.getInitScript() != null && !this.config.getInitScript().trim().isEmpty()) {
                GraalContextPoolManager.evalInContextVoid(context, this.config.getInitScript());
            }
            long elapsed = System.currentTimeMillis() - start;
            log.info("Initialized context pool in " + elapsed + "ms (modules: " + this.config.getModuleFiles().size() + ")");
            return context;
        }

        private Object createPolyglotContext() throws Exception {
            Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context");
            Class<?> contextBuilderClass = Class.forName("org.graalvm.polyglot.Context$Builder");
            Method newBuilderMethod = contextClass.getMethod("newBuilder", String[].class);
            Object builder = newBuilderMethod.invoke(null, new Object[]{new String[]{"js"}});
            Method allowAllAccessMethod = contextBuilderClass.getMethod("allowAllAccess", Boolean.TYPE);
            builder = allowAllAccessMethod.invoke(builder, true);
            Method optionMethod = contextBuilderClass.getMethod("option", String.class, String.class);
            builder = optionMethod.invoke(builder, "js.ecmascript-version", "2022");
            builder = optionMethod.invoke(builder, "js.v8-compat", "true");
            builder = optionMethod.invoke(builder, "js.stack-trace-api", "true");
            builder = optionMethod.invoke(builder, "engine.WarnInterpreterOnly", "true");
            for (Map.Entry<String, Object> entry : this.config.getContextOptions().entrySet()) {
                builder = optionMethod.invoke(builder, entry.getKey(), entry.getValue().toString());
            }
            Method buildMethod = contextBuilderClass.getMethod("build", new Class[0]);
            Object context = buildMethod.invoke(builder, new Object[0]);
            this.initializeNashornCompatShims(context);
            return context;
        }

        private void resetContextBindings(Object context) throws Exception {
            log.debug("Context returned to pool (no reset needed - use operationFiles for per-request logic)");
        }

        private void closeContext(Object context) {
            try {
                Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context");
                Method closeMethod = contextClass.getMethod("close", new Class[0]);
                closeMethod.invoke(context, new Object[0]);
                log.debug("Closed Polyglot context");
            }
            catch (Exception e) {
                log.warn("Error closing Polyglot context: " + e.getMessage());
            }
        }

        private void initializeNashornCompatShims(Object context) throws Exception {
            String shimCode = "var Packages = new Proxy({}, {\n  get: function(target, prop) {\n    return new Proxy({__pkg: prop}, {\n      get: function(t, p) {\n        if (p === '__pkg') return t.__pkg;\n        var fullName = t.__pkg + '.' + p;\n        try { return Java.type(fullName); }\n        catch(e) { return new Proxy({__pkg: fullName}, this); }\n      }\n    });\n  }\n});\nvar java = Packages.java;\nvar javax = Packages.javax;\nvar jakarta = Packages.jakarta;\nvar com = Packages.com;\nvar org = Packages.org;\nfunction importClass(cls) {\n  if (typeof cls === 'string') cls = Java.type(cls);\n  var name = cls.class ? cls.class.getSimpleName() : cls.getName().split('.').pop();\n  globalThis[name] = cls;\n}\nfunction importPackage(pkg) {}\nfunction load(path) {\n  if (path && path.startsWith && path.startsWith('nashorn:')) return;\n  throw new Error('load() not supported in GraalJS Polyglot mode: ' + path);\n}\n";
            GraalContextPoolManager.evalInContextVoid(context, shimCode);
            log.debug("Initialized Nashorn compatibility shims");
        }

        public synchronized void shutdown() {
            log.info("Shutting down context pool pool: " + this.poolKey + " (closing " + this.allContexts.size() + " contexts)");
            for (Object context : this.allContexts) {
                this.closeContext(context);
            }
            this.availableContexts.clear();
            this.allContexts.clear();
            this.totalCreated = 0;
        }
    }
}

