/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.SubqueryMetadata;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DSRequestSubqueryResolver
implements SubqueryResolver {
    private static Logger log = new Logger(DSRequestSubqueryResolver.class);
    private BasicDataSource parentDS;

    public DSRequestSubqueryResolver(BasicDataSource parentDS) {
        this.parentDS = parentDS;
    }

    @Override
    public Map resolveSubquery(Map subqueryConfig, boolean isFieldQuery) throws Exception {
        DSResponse resp;
        Map sf;
        String dsName = (String)subqueryConfig.get("dataSource");
        if (dsName == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query does not specify a dataSource");
        }
        BasicDataSource subDs = (BasicDataSource)DataSourceManager.get(dsName);
        if (subDs == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query specifies dataSource '" + dsName + "', which is not known");
        }
        Object subCriteria = subqueryConfig.get("criteria");
        if (subCriteria instanceof Map) {
            DSRequestSubqueryResolver nested = new DSRequestSubqueryResolver(subDs);
            AdvancedCriteria.resolveSubqueries((Map)subCriteria, nested);
        }
        SubqueryMetadata meta = SubqueryMetadata.fromConfig(subqueryConfig, subDs, this.parentDS, true);
        DSRequest subReq = new DSRequest(dsName, "fetch");
        subReq.setIsSubquery(true);
        if (subCriteria != null) {
            subReq.setCriteria(subCriteria);
        }
        if (subqueryConfig.containsKey("operationId")) {
            subReq.setOperationId((String)subqueryConfig.get("operationId"));
        }
        if ((sf = (Map)subqueryConfig.get("summaryFunctions")) != null && !sf.isEmpty()) {
            HashMap<String, SummaryFunctionType> sfConverted = new HashMap<String, SummaryFunctionType>();
            int c = 0;
            for (String key : sf.keySet()) {
                if (c++ > 0) {
                    log.warn((isFieldQuery ? "field" : "value") + "Query specifies multiple summaryFunctions, which is not supported. Using only the first.");
                    break;
                }
                if (subDs.getField(key) == null) {
                    log.warn("A " + (isFieldQuery ? "field" : "value") + "Query on dataSource '" + dsName + "' specifies a summaryFunction on field '" + key + "' but the dataSource does not have a field of that name.");
                }
                sfConverted.put(key, SummaryFunctionType.valueOf(((String)sf.get(key)).toUpperCase()));
            }
            subReq.setSummaryFunctions(sfConverted);
        }
        ArrayList<String> groupBy = this.getGroupByList(subqueryConfig);
        if (sf != null && !sf.isEmpty() && meta.joinToParentDS && (groupBy == null || groupBy.isEmpty())) {
            groupBy = new ArrayList<String>();
            groupBy.add(meta.fromFieldName);
        }
        if (groupBy != null && !groupBy.isEmpty()) {
            subReq.setGroupBy((List<String>)groupBy);
        }
        if (meta.joinToParentDS) {
            String queryOutput;
            ArrayList<String> outputs = new ArrayList<String>();
            outputs.add(meta.fromFieldName);
            if (sf != null) {
                outputs.addAll(sf.keySet());
            }
            if ((queryOutput = (String)subqueryConfig.get("queryOutput")) != null && !outputs.contains(queryOutput)) {
                outputs.add(queryOutput);
            }
            if (!outputs.contains(meta.outputFieldName)) {
                outputs.add(meta.outputFieldName);
            }
            subReq.setOutputs(outputs);
        }
        if ((resp = subReq.execute()).getStatus() < 0) {
            throw new Exception("Sub-DSRequest for " + (isFieldQuery ? "field" : "value") + "Query failed: " + String.valueOf(resp.getData()));
        }
        List records = resp.getRecords();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fromFieldName", meta.fromFieldName);
        result.put("toFieldName", meta.toFieldName);
        result.put("records", records);
        result.put("subqueryOutputField", meta.outputFieldName);
        return result;
    }

    private List getGroupByList(Map subqueryConfig) {
        Object groupByObj = subqueryConfig.get("groupBy");
        if (groupByObj == null) {
            return null;
        }
        if (groupByObj instanceof List) {
            return (List)groupByObj;
        }
        ArrayList groupBy = new ArrayList();
        groupBy.add(groupByObj);
        return groupBy;
    }
}

