/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCSystem;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class SkinUtil {
    protected static Config config = Config.getGlobal();
    protected static Logger log = new Logger(SkinUtil.class.getName());
    protected static boolean inDevenv = config.getBoolean((Object)"devenv", false);
    protected static String compassCompileCommand = "compass compile ";
    protected static String tmpDir = config.getPath("tmpDir");
    protected static String skinsDir = config.getPath("skinsDir");
    protected static String skinToolsDir = config.getPath("toolsDir") + "/skinTools";
    protected static String fontsDir = config.getPath("isomorphicDir") + "/system/helpers/fonts";
    public static final String LOAD_SKIN_JS = "load_skin.js";
    private static ConcurrentMap<String, Map> compactSkinCache = new ConcurrentHashMap<String, Map>();
    private static Set<String> processedZipEntries = new HashSet<String>();
    public static ArrayList<String> legacySkins = new ArrayList<String>(Arrays.asList("Enterprise", "EnterpriseBlue", "Graphite", "BlackOps", "Cupertino", "fleet", "Mobile", "SilverWave", "Simplicity", "SmartClient", "standard"));

    protected static boolean isDevTheme(String theme) {
        return new File(SkinUtil.skinDir(theme) + "/_internalSource").exists();
    }

    protected static String skinTemplateDir(String theme) {
        return SkinUtil.skinDir(theme) + (SkinUtil.isDevTheme(theme) ? "/_internalSource" : "/template");
    }

    protected static String skinSettingsDir(String theme) {
        return SkinUtil.skinTemplateDir(theme) + "/sass";
    }

    protected static String skinDir(String theme) {
        return skinsDir + "/" + theme;
    }

    protected static String skinSettingsFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/" + (String)(SkinUtil.isDevTheme(theme) ? "_Theme" + theme : "_skinSettings") + ".scss";
    }

    protected static String skinSettingsCustomFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/" + (String)(SkinUtil.isDevTheme(theme) ? "_Theme" + theme + "_custom" : "_skinStyles") + ".scss";
    }

    protected static String skinSettingsShowcaseFile(String theme) {
        if (SkinUtil.isDevTheme(theme)) {
            return SkinUtil.skinSettingsDir(theme) + "/_Theme" + theme + "_showcase.scss";
        }
        return "Not a Showcase theme.";
    }

    protected static String skinConfigFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/config.json";
    }

    protected static String skinCssPropertiesFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_cssProperties.scss";
    }

    protected static String userSettingsFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_userSettings.scss";
    }

    protected static String userFontCssFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_fonts.scss";
    }

    protected static String skinStylesSCSSFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/skin_styles.scss";
    }

    protected static String skinStylesCSSFile(String theme) {
        return SkinUtil.skinDir(theme) + "/skin_styles.css";
    }

    protected static String loadSkinFile(String theme) {
        return SkinUtil.skinDir(theme) + "/load_skin.js";
    }

    protected static String variableMetadataFile() {
        return skinToolsDir + "/data/variableMetadata.json";
    }

    protected static String variableGroupMetadataFile() {
        return skinToolsDir + "/data/groupMetadata.json";
    }

    protected static String baseFlatWithCSSVariablesFile() {
        return skinToolsDir + "/data/_baseFlat_cssProps.scss";
    }

    protected static String skinBaseSCSSFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_base.scss";
    }

    protected static String getValidatedTheme(DSRequest req, String fieldName) throws Exception {
        return SkinUtil.getValidatedTheme(req, fieldName, SkinType.ALL);
    }

    protected static String getValidatedTheme(DSRequest req, String fieldName, SkinType skinType) throws Exception {
        String theme = (String)req.getValues().get(fieldName);
        if (SkinUtil.assertValidTheme(theme, skinType)) {
            return theme;
        }
        throw new Exception("Invalid theme name: " + theme);
    }

    protected static boolean assertValidTheme(String theme) throws Exception {
        return SkinUtil.assertValidTheme(theme, SkinType.ALL);
    }

    protected static boolean assertValidTheme(String theme, SkinType skinType) throws Exception {
        if (theme == null) {
            throw new Exception("Null theme in assertValidTheme()");
        }
        if (theme.contains("/") || theme.contains("\\")) {
            throw new Exception("Invalid theme name: " + theme);
        }
        if (theme.equals(".") || theme.equals("..") || IOUtil.isTmpFileName(theme)) {
            return false;
        }
        if (skinType == SkinType.ALL) {
            return true;
        }
        if (skinType == SkinType.USER) {
            return !SkinUtil.assertValidTheme(theme, SkinType.BASE);
        }
        try {
            if (skinType == SkinType.USER_RECORD_ON_DISK) {
                return SkinUtil.isCompactSkin(theme) || SkinUtil.isPackedCompactSkin(theme);
            }
            if (!ISCFile.newInstance(SkinUtil.skinConfigFile(theme)).exists()) {
                return false;
            }
            if (!ISCFile.newInstance(SkinUtil.skinStylesCSSFile(theme)).exists()) {
                return false;
            }
            if (skinType == SkinType.ON_FILESYSTEM) {
                return true;
            }
            ISCFile userSettingsFile = ISCFile.newInstance(SkinUtil.userSettingsFile(theme));
            if (userSettingsFile.exists()) {
                if (skinType == SkinType.BASE) {
                    return userSettingsFile.length() == 0L;
                }
                if (skinType == SkinType.USER_ON_FILESYSTEM) {
                    return userSettingsFile.length() != 0L;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to determine validity of base theme '" + theme + "'."), e);
        }
        return false;
    }

    public static List getThemes(SkinType skinType) throws Exception {
        ArrayList<String> themes = new ArrayList<String>();
        for (File file : new File(skinsDir).listFiles()) {
            String theme = file.getName();
            if (!SkinUtil.assertValidTheme(theme, skinType)) continue;
            themes.add(theme);
        }
        return themes;
    }

    public static Map getCompactSkin(String skinName) throws Exception {
        Map cached = (Map)compactSkinCache.get(skinName);
        if (cached != null) {
            return cached;
        }
        String skinConfig = "";
        Map skinConfigObj = null;
        ISCFile f = ISCFile.newInstance(SkinUtil.skinDir(skinName) + "/" + skinName + ".skin.json");
        if (!f.exists() && (f = ISCFile.newInstance(SkinUtil.skinDir(skinName) + "/" + skinName + ".skin.zip")).exists()) {
            skinConfigObj = SkinUtil.extractCompactSkin(skinName);
        }
        if (skinConfigObj == null && (skinConfig = f.getAsString()) != null && !"".equals(skinConfig)) {
            JSTranslater jst = JSTranslater.instance();
            skinConfigObj = (Map)jst.fromJS(skinConfig);
        }
        if (skinConfigObj == null) {
            return null;
        }
        Map oldValue = compactSkinCache.putIfAbsent(skinName, skinConfigObj);
        if (oldValue != null) {
            return oldValue;
        }
        return skinConfigObj;
    }

    public static Map<String, String> getCompactSkinNames() throws Exception {
        HashMap<String, String> skins = new HashMap<String, String>();
        File baseDir = new File(skinsDir);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            if (Config.isSpringBootApp()) {
                return new HashMap<String, String>();
            }
            throw new Exception("skinsDir does not exist or is not a directory");
        }
        File[] subDirs = baseDir.listFiles(File::isDirectory);
        if (subDirs != null) {
            for (File subDir : subDirs) {
                String skinName = subDir.getName();
                if (!SkinUtil.isCompactSkin(skinName) && !SkinUtil.isPackedCompactSkin(skinName)) continue;
                String displayName = SkinUtil.transformCompactSkinDisplayName(skinName);
                skins.put(skinName, displayName);
            }
        }
        return skins;
    }

    public static boolean isCompactSkin(String skinName) {
        File dir = new File(skinsDir, skinName);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File configFile = new File(dir, skinName + ".skin.json");
        if (!configFile.exists() || !configFile.isFile()) {
            return false;
        }
        File loadSkinFile = new File(dir, LOAD_SKIN_JS);
        return !loadSkinFile.exists();
    }

    public static boolean isPackedCompactSkin(String skinName) {
        File configFile;
        File dir = new File(skinsDir, skinName);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File zipFile = new File(dir, skinName + ".skin.zip");
        return zipFile.exists() && zipFile.isFile() && !(configFile = new File(dir, skinName + ".skin.json")).exists();
    }

    public static Map extractCompactSkin(String skinName) throws Exception {
        File dir = new File(skinsDir, skinName);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File zipFile = new File(dir, skinName + ".skin.json");
        if (zipFile.exists()) {
            return null;
        }
        zipFile = new File(dir, skinName + ".skin.zip");
        if (!zipFile.exists() || !zipFile.isFile()) {
            return null;
        }
        String skinConfig = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if ((skinName + ".skin.json").equals(entry.getName())) {
                    int len;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) != -1) {
                        bos.write(buffer, 0, len);
                    }
                    skinConfig = bos.toString(StandardCharsets.UTF_8);
                    break;
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            throw new Exception("Error while reading skin-JSON from zip: " + String.valueOf(zipFile), e);
        }
        if (skinConfig != null && !"".equals(skinConfig)) {
            JSTranslater jst = JSTranslater.instance();
            Map skinConfigObj = (Map)jst.fromJS(skinConfig);
            return skinConfigObj;
        }
        return null;
    }

    private static String transformCompactSkinDisplayName(String name) {
        String result = name.replace("_", " ");
        result = result.replaceAll("(?<=[a-z])(?=[A-Z])", " ");
        String[] words = result.split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                sb.append(word.substring(1).toLowerCase());
            }
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public static String updateSvgSymbols(String svgContent, String newSymbolContent) {
        String result = svgContent;
        Pattern symbolPattern = Pattern.compile("<symbol[^>]*>.*?</symbol>", 34);
        Matcher symbolMatcher = symbolPattern.matcher(newSymbolContent);
        Pattern idPattern = Pattern.compile("id=[\"']([^\"']+)[\"']");
        while (symbolMatcher.find()) {
            String singleSymbol = symbolMatcher.group();
            Matcher idMatcher = idPattern.matcher(singleSymbol);
            if (!idMatcher.find()) {
                throw new IllegalArgumentException("Symbol must have an id attribute: " + singleSymbol);
            }
            String symbolId = idMatcher.group(1);
            Pattern existingSymbolPattern = Pattern.compile("<symbol[^>]*id=[\"']" + Pattern.quote(symbolId) + "[\"'][^>]*>.*?</symbol>", 34);
            Matcher existingMatcher = existingSymbolPattern.matcher(result);
            if (existingMatcher.find()) {
                result = existingMatcher.replaceFirst(Matcher.quoteReplacement(singleSymbol));
                continue;
            }
            result = result.replace("</svg>", "  " + singleSymbol + "\n</svg>");
        }
        return result;
    }

    public static String getSkinStylesCSS(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinStylesCSSFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static String getSkinSettings(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettingsFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        if (!SkinUtil.isDevTheme(theme)) {
            String result = "";
            f = ISCFile.newInstance(SkinUtil.skinBaseSCSSFile(theme));
            if (f.exists()) {
                result = f.getAsString();
                int tagStart = result.indexOf("//>theme_variables");
                if (tagStart < 0) {
                    return null;
                }
                int tagEnd = result.indexOf("//<theme_variables");
                if (tagEnd < 0) {
                    return null;
                }
                result = result.substring(tagStart, tagEnd += 18);
                return result;
            }
        }
        return null;
    }

    public static void saveSkinSettings(String theme, String settings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettingsFile(theme)).write(settings);
    }

    public static String getSkinSettingsCustom(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettingsCustomFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinSettingsCustom(String theme, String settings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettingsCustomFile(theme)).write(settings);
    }

    public static String getSkinSettingsShowcase(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettingsShowcaseFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinSettingsShowcase(String theme, String content) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettingsShowcaseFile(theme)).write(content);
    }

    public static String getSkinConfig(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinConfigFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static Map getSkinConfigMap(String theme) throws Exception {
        Map userRecord;
        DataSource userSkinDS;
        String skinConfigStr = null;
        ISCFile f = ISCFile.newInstance(SkinUtil.skinConfigFile(theme));
        if (f.exists()) {
            skinConfigStr = f.getAsString();
        }
        if (Boolean.TRUE.equals(ServletTools.hasUserSkinDS) && skinConfigStr == null && (userSkinDS = DataSourceManager.get("isc_userSkin")) != null && (userRecord = new DSRequest("isc_userSkin", "fetch").setCriteria((Object)DataTools.buildMap("name", theme)).execute().getDataMap()) != null) {
            skinConfigStr = (String)userRecord.get("userSettings");
        }
        if (skinConfigStr == null && SkinUtil.isCompactSkin(theme)) {
            Map skin = SkinUtil.getCompactSkin(theme);
            skinConfigStr = (String)skin.get("userSettings");
        }
        if (skinConfigStr == null && SkinUtil.isPackedCompactSkin(theme)) {
            Map zippedSkin = SkinUtil.extractCompactSkin(theme);
            skinConfigStr = (String)zippedSkin.get("userSettings");
        }
        if (skinConfigStr != null && !"".equals(skinConfigStr)) {
            JSTranslater jst = JSTranslater.instance();
            return (Map)jst.fromJS(skinConfigStr);
        }
        return null;
    }

    public static void updateSkinConfigFile(String theme, String config) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinConfigFile(theme)).write(config);
    }

    public static String getSkinCssProperties(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinCssPropertiesFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinCssProperties(String theme, String cssProperties) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinCssPropertiesFile(theme)).write(cssProperties);
    }

    public static String getUserSettings(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.userSettingsFile(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveUserSettings(String theme, String userSettings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.USER_ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.userSettingsFile(theme)).write(userSettings);
    }

    public static String updatesForLivePreview(String theme) throws Exception {
        FileUtils.copyFile((File)new File(SkinUtil.baseFlatWithCSSVariablesFile()), (File)new File(SkinUtil.skinBaseSCSSFile(theme)), (boolean)false);
        if (SkinUtil.isDevTheme(theme)) {
            String path = SkinUtil.skinStylesSCSSFile(theme);
            ISCFile f = ISCFile.newInstance(path);
            String content = null;
            if (f.exists()) {
                content = f.getAsString();
            }
            if (content != null) {
                content = content.replace("../../../_internalSource/FlatSeries/sass/_baseFlat.scss", "./_base.scss");
            }
            ISCFile.newInstance(path).write(content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePreview(DSRequest req) throws Exception {
        Map values = req.getValues();
        String theme = SkinUtil.getValidatedTheme(req, "theme");
        String baseTheme = SkinUtil.getValidatedTheme(req, "baseTheme");
        String content = (String)values.get("content");
        Boolean livePreview = (Boolean)values.get("livePreview");
        File src = new File(SkinUtil.skinDir(baseTheme));
        String tmpTheme = IOUtil.threadSafeTmpFileName(baseTheme);
        File dst = null;
        try {
            dst = new File(SkinUtil.skinDir(tmpTheme));
            if (dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
            FileUtils.copyDirectory((File)src, (File)dst, (boolean)false);
            if (livePreview.booleanValue()) {
                SkinUtil.updatesForLivePreview(tmpTheme);
            }
            ISCFile.newInstance(SkinUtil.userSettingsFile(tmpTheme)).write(content);
            String skinStylesCSS = SkinUtil.compileTheme(tmpTheme);
            skinStylesCSS = skinStylesCSS.replaceAll(baseTheme, theme);
            HttpSession session = req.getHttpServletRequest().getSession(true);
            HashMap<CallSite, String> tmpSkinStyles = (HashMap<CallSite, String>)session.getAttribute("isc.skinEditor.tmpSkinStyles");
            if (tmpSkinStyles == null) {
                tmpSkinStyles = new HashMap<CallSite, String>();
                session.setAttribute("isc.skinEditor.tmpSkinStyles", tmpSkinStyles);
            }
            tmpSkinStyles.put((CallSite)((Object)(theme + "_base")), baseTheme);
            tmpSkinStyles.put((CallSite)((Object)(theme + "_skinStylesCSS")), skinStylesCSS);
        }
        finally {
            if (dst != null && dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
        }
    }

    public static String compileTheme(String theme) throws Exception {
        File tmpSkinFile = new File(SkinUtil.skinStylesCSSFile(theme));
        boolean origWriteableSetting = true;
        if (tmpSkinFile.exists()) {
            origWriteableSetting = tmpSkinFile.canWrite();
            tmpSkinFile.setWritable(true);
        }
        ISCSystem result = ISCSystem.execute(compassCompileCommand + "'" + SkinUtil.skinTemplateDir(theme) + "'");
        result.waitFor();
        int exitValue = result.exitValue();
        if (exitValue != 0) {
            throw new Exception(result.getFormattedErrorString());
        }
        tmpSkinFile.setWritable(origWriteableSetting);
        return ISCFile.newInstance(SkinUtil.skinStylesCSSFile(theme)).getAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileTheme(String theme, String baseTheme, String allSettings, String skinConfig) throws Exception {
        SkinUtil.assertValidTheme(theme);
        SkinUtil.assertValidTheme(baseTheme, SkinType.BASE);
        File src = new File(SkinUtil.skinDir(baseTheme));
        String tmpTheme = IOUtil.threadSafeTmpFileName(baseTheme);
        File dst = null;
        try {
            dst = new File(SkinUtil.skinDir(tmpTheme));
            if (dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
            FileUtils.copyDirectory((File)src, (File)dst, (boolean)false);
            ISCFile.newInstance(SkinUtil.userSettingsFile(tmpTheme)).write(allSettings);
            JSTranslater jst = JSTranslater.instance();
            Map skinConfigObj = (Map)jst.fromJS(skinConfig);
            String fontCss = (String)skinConfigObj.get("fontCss");
            fontCss = fontCss.replaceAll("\\[FONTS\\]", "../../system/helpers/fonts/");
            ISCFile.newInstance(SkinUtil.userFontCssFile(tmpTheme)).write(fontCss);
            ISCFile loadSkin = ISCFile.newInstance(SkinUtil.loadSkinFile(tmpTheme));
            if (!loadSkin.exists()) {
                log.warn("no load_skin.js");
            } else {
                List fonts = (List)skinConfigObj.get("fontList");
                String fContent = SkinUtil.updateSkinFontList(loadSkin.getAsString(), fonts);
                loadSkin.write(fContent);
            }
            String skinStylesCSS = SkinUtil.compileTheme(tmpTheme);
            String string = skinStylesCSS = skinStylesCSS.replaceAll(baseTheme, theme);
            return string;
        }
        finally {
            if (dst != null && dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
        }
    }

    public static void addZipEntry(ZipOutputStream zos, String fileName, String content, String theme, String exportName, boolean asBaseSkin, String baseSkin) throws Exception {
        zos.putNextEntry(new ZipEntry(fileName));
        if (processedZipEntries.contains(fileName)) {
            log.warn("addZipEntry() : A file named " + fileName + " is already in this zip file - ignoring.");
            return;
        }
        processedZipEntries.add(fileName);
        if (content == null) {
            content = "";
        }
        if (theme == null) {
            theme = "";
        }
        if (theme != "" && theme != exportName) {
            content = content.replaceAll("\\b" + theme + "\\b", exportName);
        }
        if (baseSkin != null) {
            content = content.replaceAll("\\b" + baseSkin + "\\b", asBaseSkin ? exportName : theme);
        }
        IOUtil.copyStreams(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), zos);
        zos.closeEntry();
    }

    public static void addZipEntry(ZipOutputStream zos, String fileName, String content) throws Exception {
        SkinUtil.addZipEntry(zos, fileName, content, "", "", false, "");
    }

    public static void addImageZipEntry(ZipOutputStream zos, String fileName, byte[] content) throws Exception {
        zos.putNextEntry(new ZipEntry(fileName));
        IOUtil.copyStreams(new ByteArrayInputStream(content), zos);
        zos.closeEntry();
    }

    public static void addFileZipEntry(ZipOutputStream zos, String fileName, File srcFile) throws Exception {
        if (processedZipEntries.contains(fileName)) {
            log.warn("addZipFileEntry() : A file named " + fileName + " is already in this zip file - ignoring.");
            return;
        }
        processedZipEntries.add(fileName);
        zos.putNextEntry(new ZipEntry(fileName));
        IOUtil.copyStreams(new FileInputStream(srcFile), zos);
        zos.closeEntry();
    }

    public static String getFileAsText(String fileName) throws Exception {
        String result = "";
        ISCFile file = ISCFile.newInstance(fileName);
        if (file.exists()) {
            result = file.getAsString();
        }
        return result;
    }

    public void exportAsRecord(DSRequest req, RPCManager rpc, HttpServletResponse response) throws Exception {
        Map values = req.getValues();
        String theme = (String)values.get("name");
        String exportName = (String)values.get("exportName");
        if (exportName == null || exportName.isEmpty()) {
            exportName = theme;
        }
        String fileName = exportName.substring(0, 1).toUpperCase() + exportName.substring(1);
        Map userRecord = new DSRequest("isc_userSkin", "fetch").setCriteria((Object)DataTools.buildMap("name", theme)).execute().getDataMap();
        userRecord.remove("pk");
        userRecord.put("name", exportName);
        String userSettingsStr = (String)userRecord.get("userSettings");
        userSettingsStr = userSettingsStr.replaceAll("\\b" + theme + "\\b", exportName);
        userRecord.put("userSettings", userSettingsStr);
        String json = JSTranslater.strict().toJS(userRecord);
        rpc.doCustomResponse();
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", exportName + ".zip"));
        response.setContentType("application/zip");
        ByteArrayOutputStream innerZipStream = new ByteArrayOutputStream();
        ZipOutputStream innerZos = new ZipOutputStream(innerZipStream);
        innerZos.putNextEntry(new ZipEntry(fileName + ".skin.json"));
        IOUtil.copyStreams(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), innerZos);
        innerZos.closeEntry();
        innerZos.close();
        byte[] innerZipBytes = innerZipStream.toByteArray();
        ZipOutputStream outerZos = new ZipOutputStream((OutputStream)response.getOutputStream());
        outerZos.putNextEntry(new ZipEntry(fileName + "/" + fileName + ".skin.zip"));
        IOUtil.copyStreams(new ByteArrayInputStream(innerZipBytes), outerZos);
        outerZos.closeEntry();
        outerZos.flush();
        outerZos.close();
    }

    public void export(DSRequest req, RPCManager rpc, HttpServletResponse response) throws Exception {
        Object zipFileName;
        Boolean packageFormat;
        Map values = req.getValues();
        processedZipEntries.clear();
        String baseTheme = SkinUtil.getValidatedTheme(req, "baseSkin", SkinType.ON_FILESYSTEM);
        String theme = SkinUtil.getValidatedTheme(req, "name", SkinType.USER);
        String exportName = (String)values.get("exportName");
        String content = (String)values.get("content");
        String thumbnail = (String)values.get("thumbnail");
        Object skinStylesContent = (String)values.get("skinStylesContent");
        Boolean asBaseSkin = (Boolean)values.get("asBaseSkin");
        Boolean userStylesAdded = false;
        Map baseConfig = (Map)values.get("baseConfig");
        Map userConfig = (Map)values.get("userConfig");
        Map userRecord = new DSRequest("isc_userSkin", "fetch").setCriteria((Object)DataTools.buildMap("name", theme)).execute().getDataMap();
        Map baseRecord = new DSRequest("isc_baseSkin", "fetch").setCriteria((Object)DataTools.buildMap("name", baseTheme)).execute().getDataMap();
        JSTranslater jst = JSTranslater.instance();
        if (exportName == null) {
            exportName = theme;
        }
        Map baseConfigObj = (Map)jst.fromJS((String)baseRecord.get("skinConfig"));
        Map baseSettingsMap = (Map)baseConfigObj.get("settings");
        String userSettingsStr = (String)userRecord.get("userSettings");
        userSettingsStr = userSettingsStr.replaceAll("\\b" + theme + "\\b", exportName);
        Map userConfigObj = (Map)jst.fromJS(userSettingsStr);
        Map userSettingsMap = (Map)userConfigObj.get("settings");
        userConfigObj.put("name", exportName);
        Map rootProperties = (Map)values.get("rootProperties");
        String fs = File.separator;
        String srcTemplateDir = SkinUtil.seriesTemplateDir("Flat") + fs;
        String targetTemplateDir = exportName + "/template/";
        String targetSassDir = exportName + "/template/sass/";
        String targetFontsDir = exportName + "/fonts/";
        rpc.doCustomResponse();
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", exportName + ".zip"));
        response.setContentType("application/zip");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
        List fontList = (List)userConfig.get("fontList");
        String fontCss = (String)userConfig.get("fontCss");
        Pattern fontPathPattern = Pattern.compile("\\[FONTS\\][^\"')\\s]+");
        Matcher matcher = fontPathPattern.matcher(fontCss);
        HashSet<Object> fontPaths = new HashSet<Object>();
        while (matcher.find()) {
            String matchedPath = matcher.group();
            fontPaths.add(matchedPath);
        }
        for (String string : fontPaths) {
            String remainderPath = string.replaceFirst(".*(?:\\[FONTS\\]|helpers/fonts/)/?", "");
            String realPath = fontsDir + "/" + remainderPath;
            File fontFile = new File(realPath);
            if (fontFile.exists() && fontFile.isFile()) {
                String zipEntryPath = targetFontsDir + remainderPath;
                SkinUtil.addFileZipEntry(zos, zipEntryPath, fontFile);
                continue;
            }
            log.warn((Object)"Font file not found:  {}", fontFile.getAbsolutePath());
        }
        if (asBaseSkin.booleanValue()) {
            userConfigObj.put("baseSkin", exportName);
            userConfigObj.remove("sassText");
            userConfigObj.remove("fontCss");
            for (Map.Entry entry : userSettingsMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                baseSettingsMap.put(key, value);
            }
            userConfigObj.put("settings", baseSettingsMap);
        }
        if ((packageFormat = (Boolean)values.get("packageFormat")) == null) {
            packageFormat = !inDevenv;
        }
        if (packageFormat.booleanValue() && inDevenv) {
            SkinUtil.addZipEntry(zos, targetTemplateDir + "config.rb", SkinUtil.getFileAsText(srcTemplateDir + "config.rb"));
            SkinUtil.addZipEntry(zos, targetTemplateDir + "readme.txt", SkinUtil.getFileAsText(srcTemplateDir + "readme.txt"));
            SkinUtil.addZipEntry(zos, targetTemplateDir + "compile.bat", SkinUtil.getFileAsText(srcTemplateDir + "compile.bat"));
            SkinUtil.addZipEntry(zos, targetTemplateDir + "compile.sh", SkinUtil.getFileAsText(srcTemplateDir + "compile.sh"));
            SkinUtil.addZipEntry(zos, targetTemplateDir + "compileSkin.py", SkinUtil.getFileAsText(srcTemplateDir + "compileSkin.py"));
            SkinUtil.addZipEntry(zos, targetSassDir + "readme.txt", SkinUtil.getFileAsText(srcTemplateDir + "sass" + fs + "readme.txt"));
            SkinUtil.addZipEntry(zos, targetSassDir + "skin_styles.scss", SkinUtil.getFileAsText(srcTemplateDir + "sass" + fs + "skin_styles.scss"));
        }
        String string = (String)userConfigObj.get("customCSS");
        String customSVG = (String)userConfigObj.get("customSVG");
        Iterator i = FileUtils.iterateFilesAndDirs((File)new File(SkinUtil.skinDir(baseTheme)), (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        while (i.hasNext()) {
            Object thisContent;
            File f = (File)i.next();
            if (f.getName().contains(".gz") || f.getName().equals("CVS") || f.getPath().contains("CVS" + fs) || f.getName().equals(".sass-cache") || f.getPath().contains(".sass-cache" + fs) || f.getName().endsWith(".bak") || f.isDirectory()) continue;
            zipFileName = exportName + f.getPath().substring(skinsDir.length() + baseTheme.length() + 1);
            if (processedZipEntries.contains(zipFileName)) {
                log.warn("Exporting " + exportName + ":  ignoring attempt to add a duplicate file to the export zip-file - " + (String)zipFileName + ".");
                continue;
            }
            if (f.getName().equals("unsupported_browser.html")) {
                SkinUtil.addFileZipEntry(zos, (String)zipFileName, f);
                continue;
            }
            if (f.getName().equals("skin_styles.css")) {
                if (f.getPath().contains("_internalSource") || skinStylesContent == null) continue;
                if (asBaseSkin.booleanValue() && string != null && string != "") {
                    skinStylesContent = (String)skinStylesContent + "\n\n" + string;
                }
                skinStylesContent = ((String)skinStylesContent).replaceAll("url\\((['\"]?)(.*?/fonts/)", "url($1fonts/");
                SkinUtil.addZipEntry(zos, (String)zipFileName, (String)skinStylesContent, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("skin_styles_editor.css")) {
                Object edContent = SkinUtil.getFileAsText(f.getPath());
                if (string != null && string != "") {
                    edContent = (String)edContent + "\n\n" + string;
                }
                if (asBaseSkin.booleanValue()) {
                    edContent = SkinUtil.replaceCssVariables((String)edContent, rootProperties);
                }
                edContent = ((String)edContent).replaceAll("url\\((['\"]?)(.*?(?:\\[FONTS\\]|helpers/fonts)/)", "url($1fonts/");
                SkinUtil.addZipEntry(zos, (String)zipFileName, (String)edContent, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals(LOAD_SKIN_JS)) {
                if (f.getPath().contains("_internalSource")) continue;
                ISCFile iscFile = ISCFile.newInstance(f.getPath());
                String loadSkinContent = iscFile.getAsString();
                loadSkinContent = loadSkinContent.replaceAll(baseTheme, exportName);
                loadSkinContent = SkinUtil.updateSkinFontList(loadSkinContent, fontList);
                if (asBaseSkin.booleanValue()) {
                    loadSkinContent = SkinUtil.injectCustomLoadSkinContent(loadSkinContent, (String)userRecord.get("userSettings"));
                }
                if (loadSkinContent == "") continue;
                SkinUtil.addZipEntry(zos, (String)zipFileName, loadSkinContent, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("stockIcons.svg")) {
                String stockIconsContent = null;
                stockIconsContent = ISCFile.newInstance(f.getPath()).getAsString();
                if (customSVG != null) {
                    if (stockIconsContent == null) {
                        stockIconsContent = "<svg xmlns=\"http://www.w3.org/2000/svg\">\n</svg>";
                    }
                    stockIconsContent = SkinUtil.updateSvgSymbols(stockIconsContent, customSVG);
                }
                SkinUtil.addZipEntry(zos, (String)zipFileName, stockIconsContent, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getPath().contains("fonts/")) continue;
            if (f.getPath().contains("images" + fs)) {
                if (f.getName().equals("thumbnail.png") && thumbnail != null && thumbnail.length() > 0) {
                    byte[] imagedata = DatatypeConverter.parseBase64Binary((String)thumbnail.substring(thumbnail.indexOf(",") + 1));
                    zos.putNextEntry(new ZipEntry((String)zipFileName));
                    IOUtil.copyStreams(new ByteArrayInputStream(imagedata), zos);
                    zos.closeEntry();
                    continue;
                }
                SkinUtil.addFileZipEntry(zos, (String)zipFileName, f);
                continue;
            }
            if (f.getName().startsWith("_Theme" + baseTheme)) {
                zipFileName = ((String)zipFileName).replace("_Theme" + baseTheme, "_Theme" + exportName);
            }
            if (packageFormat.booleanValue() && inDevenv && (f.getPath().contains(fs + "src") || f.getPath().contains(fs + "originalFiles") || f.getName().endsWith("_custom.scss") || f.getName().endsWith("_showcase.scss") || f.getName().equals("skin_styles.scss") || f.getName().equals("skin_styles_editor.scss") || f.getName().equals("showcase_styles.scss") || f.getName().equals("_cssProperties.scss"))) continue;
            if (f.getName().equals("_fonts.scss")) {
                if (inDevenv && packageFormat.booleanValue()) {
                    zipFileName = targetSassDir + f.getName();
                }
                SkinUtil.addZipEntry(zos, (String)zipFileName, fontCss, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("config.json")) {
                if (inDevenv && packageFormat.booleanValue()) {
                    zipFileName = targetSassDir + f.getName();
                }
                String c = JSTranslater.strict().toJS(userConfigObj);
                SkinUtil.addZipEntry(zos, (String)zipFileName, c, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("_Theme" + baseTheme + ".scss")) {
                if (packageFormat.booleanValue()) {
                    thisContent = SkinUtil.getFileAsText(SkinUtil.seriesBaseFile("Flat"));
                    thisContent = SkinUtil.replaceThemeVariables((String)thisContent, content);
                    String customFilePath = f.getPath().replace(baseTheme + ".scss", baseTheme + "_custom.scss");
                    String customFileContent = SkinUtil.getFileAsText(customFilePath);
                    thisContent = (String)thisContent + "\n\n" + customFileContent;
                    String finalFilePath = targetSassDir + "_base.scss";
                    if (processedZipEntries.contains(finalFilePath)) {
                        // empty if block
                    }
                    SkinUtil.addZipEntry(zos, finalFilePath, (String)thisContent, theme, exportName, asBaseSkin, baseTheme);
                    continue;
                }
                SkinUtil.addZipEntry(zos, (String)zipFileName, content, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (!(!f.getName().equals("_base.scss") || inDevenv && packageFormat.booleanValue())) {
                String finalFilePath;
                thisContent = SkinUtil.getFileAsText(f.getPath());
                if (asBaseSkin.booleanValue()) {
                    thisContent = SkinUtil.replaceThemeVariables((String)thisContent, content);
                }
                if (processedZipEntries.contains(finalFilePath = targetSassDir + "_base.scss")) {
                    // empty if block
                }
                thisContent = ((String)thisContent).replaceAll("url\\((['\"]?)(.*?/fonts/)", "url($1fonts/");
                SkinUtil.addZipEntry(zos, finalFilePath, (String)thisContent, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("_userSettings.scss")) {
                if (asBaseSkin.booleanValue()) {
                    if (packageFormat.booleanValue()) {
                        zipFileName = targetSassDir + f.getName();
                    }
                    SkinUtil.addZipEntry(zos, (String)zipFileName, "");
                    continue;
                }
                if (packageFormat.booleanValue()) {
                    zipFileName = targetSassDir + f.getName();
                }
                SkinUtil.addZipEntry(zos, (String)zipFileName, content, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (f.getName().equals("_userStyles.scss")) {
                userStylesAdded = true;
                if (asBaseSkin.booleanValue()) {
                    if (packageFormat.booleanValue()) {
                        zipFileName = targetSassDir + f.getName();
                    }
                    SkinUtil.addZipEntry(zos, (String)zipFileName, "");
                    continue;
                }
                if (packageFormat.booleanValue()) {
                    zipFileName = targetSassDir + f.getName();
                }
                SkinUtil.addZipEntry(zos, (String)zipFileName, string, theme, exportName, asBaseSkin, baseTheme);
                continue;
            }
            if (!inDevenv || !packageFormat.booleanValue()) {
                SkinUtil.addFileZipEntry(zos, (String)zipFileName, f);
                continue;
            }
            log.warn("skipping file: " + f.getPath());
        }
        if (!userStylesAdded.booleanValue()) {
            zipFileName = targetSassDir + "_userStyles.scss";
            if (asBaseSkin.booleanValue()) {
                SkinUtil.addZipEntry(zos, (String)zipFileName, "");
            } else {
                SkinUtil.addZipEntry(zos, (String)zipFileName, string, theme, exportName, asBaseSkin, baseTheme);
            }
        }
        zos.flush();
        zos.close();
    }

    public static String replaceThemeVariables(String content, String newVariables) {
        String openingToken = "//>theme_variables";
        String closingToken = "//<theme_variables";
        int startIndex = content.indexOf(openingToken);
        int endIndex = content.indexOf(closingToken);
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            return content;
        }
        String beforeVariables = content.substring(0, startIndex);
        String afterVariables = content.substring(endIndex + closingToken.length());
        return beforeVariables + newVariables + afterVariables;
    }

    public static String replaceCssVariables(String cssContent, Map<String, String> variables) {
        String updatedCss = cssContent;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String regex;
            Pattern pattern;
            Matcher matcher;
            Object varName = entry.getKey();
            String newValue = entry.getValue();
            if (!((String)varName).startsWith("--")) {
                varName = "--" + (String)varName;
            }
            if (!(matcher = (pattern = Pattern.compile(regex = "(" + Pattern.quote((String)varName) + "\\s*:\\s*)([^;]+)(;)")).matcher(updatedCss)).find()) continue;
            String replacement = matcher.group(1) + newValue + matcher.group(3);
            updatedCss = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
        }
        return updatedCss;
    }

    public static String convertVariableNames(String content) {
        Pattern varPattern = Pattern.compile("\\$[a-zA-Z_][a-zA-Z0-9_]*");
        Matcher matcher = varPattern.matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String varName = matcher.group();
            String replacement = "var(--isc-" + varName.substring(1) + ")";
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public void updateVariableMetadata(DSRequest req) throws Exception {
        Map values = req.getValues();
        Object metadataObj = values.get("metadata");
        String output = JSTranslater.strict().toJS(metadataObj);
        ISCFile.newInstance(SkinUtil.variableMetadataFile()).write(output);
    }

    public void updateVariableGroupMetadata(DSRequest req) throws Exception {
        Map values = req.getValues();
        Object metadataObj = values.get("metadata");
        String output = JSTranslater.strict().toJS(metadataObj);
        ISCFile.newInstance(SkinUtil.variableGroupMetadataFile()).write(output);
    }

    public static List getSeriesList() throws Exception {
        ArrayList<String> seriesList = new ArrayList<String>();
        seriesList.add("Flat");
        return seriesList;
    }

    protected static String seriesBaseFile(String series) {
        return skinsDir + "/_internalSource/" + series + "Series/sass/_base" + series + ".scss";
    }

    protected static String seriesDynamicBaseFile(String series) {
        return skinsDir + "/_internalSource/" + series + "Series/sass/_base" + series + "_cssProps.scss";
    }

    public static String getSeriesBaseFile(String series) throws Exception {
        ISCFile f = ISCFile.newInstance(SkinUtil.seriesBaseFile(series));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSeriesBaseFile(String series, String content) throws Exception {
        ISCFile.newInstance(SkinUtil.seriesBaseFile(series)).write(content);
    }

    public static String getSeriesDynamicBaseFile(String series) throws Exception {
        ISCFile f = ISCFile.newInstance(SkinUtil.seriesDynamicBaseFile(series));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSeriesDynamicBaseFile(String series, String content) throws Exception {
        ISCFile.newInstance(SkinUtil.seriesDynamicBaseFile(series)).write(content);
    }

    protected static String seriesTemplateDir(String series) {
        if (series == null) {
            series = "Flat";
        }
        return skinsDir + "/_internalSource/" + series + "Series/template";
    }

    protected static String skinDynamicBaseFile(String theme) {
        return SkinUtil.skinDynamicBaseFile(theme, "Flat");
    }

    protected static String skinDynamicBaseFile(String theme, String series) {
        if (series == null) {
            series = "Flat";
        }
        return skinsDir + "/_internalSource/FlatSeries/sass/_base" + theme + "_cssProps.scss";
    }

    public static String getSkinDynamicBaseFile(String theme, String series) throws Exception {
        ISCFile f = ISCFile.newInstance(SkinUtil.skinDynamicBaseFile(theme, series));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinDynamicBaseFile(DSRequest req) throws Exception {
        Map values = req.getValues();
        String theme = (String)values.get("theme");
        String series = (String)values.get("series");
        String content = (String)values.get("content");
        log.warn(theme + " :: " + series + "\n\n" + content);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinDynamicBaseFile(theme, series));
        if (!f.exists()) {
            FileUtils.copyFile((File)new File(SkinUtil.seriesBaseFile(series)), (File)new File(SkinUtil.skinDynamicBaseFile(theme, series)), (boolean)false);
            f = ISCFile.newInstance(SkinUtil.skinDynamicBaseFile(theme, series));
        }
        if (f.exists()) {
            f.write(content);
        }
    }

    public static void updateDensity(DSRequest req) throws Exception {
        Map values = req.getValues();
        String theme = (String)values.get("name");
        String newDensity = (String)values.get("density");
        Map userRecord = new DSRequest("isc_userSkin", "fetch").setCriteria((Object)DataTools.buildMap("name", theme)).execute().getDataMap();
        if (userRecord == null) {
            throw new IllegalStateException("Skin record not found for theme: " + theme);
        }
        JSTranslater jst = JSTranslater.instance();
        String userSettingsStr = (String)userRecord.get("userSettings");
        Map userSettings = (Map)jst.fromJS(userSettingsStr);
        userSettings.put("density", newDensity);
        String updatedUserSettings = JSTranslater.strict().toJS(userSettings);
        userRecord.put("userSettings", updatedUserSettings);
        new DSRequest("isc_userSkin", "update").setCriteria((Object)DataTools.buildMap("name", theme)).setValues((Object)DataTools.buildMap("userSettings", updatedUserSettings)).setOperationId("noScript").execute();
    }

    public static ArrayList<String> getLegacySkins() {
        return legacySkins;
    }

    public void updateRegisteredFonts(DSRequest req) throws Exception {
        Map values = req.getValues();
        Object metadataObj = values.get("metadata");
        String output = JSTranslater.strict().toJS(metadataObj);
        ISCFile.newInstance(fontsDir + "/registeredFonts.json").write(output);
    }

    public static List getUserSkinFontList(String userSettings) throws Exception {
        List fonts = new ArrayList();
        JSTranslater jst = JSTranslater.instance();
        Map skinConfigObj = (Map)jst.fromJS(userSettings);
        fonts = (List)skinConfigObj.get("fontList");
        return fonts;
    }

    public static String updateSkinFontList(String baseLoadSkin, List fonts) throws Exception {
        try {
            int customFontsOffset = baseLoadSkin.indexOf("fonts:");
            int arrayStart = baseLoadSkin.indexOf("[", customFontsOffset);
            int arrayEnd = baseLoadSkin.indexOf("]", arrayStart);
            Object result = baseLoadSkin.substring(0, arrayStart + 1);
            if (fonts == null || fonts.isEmpty()) {
                log.warn("NO FONTS PASSED");
                return baseLoadSkin;
            }
            result = (String)result + "'" + String.join((CharSequence)"', '", fonts) + "'";
            result = (String)result + baseLoadSkin.substring(arrayEnd);
            return result;
        }
        catch (Exception e) {
            return baseLoadSkin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String injectCustomLoadSkinContent(String baseLoadSkin, String userSettings) throws Exception {
        try {
            JSTranslater jst = JSTranslater.instance();
            Map skinConfigObj = (Map)jst.fromJS(userSettings);
            Map customJSObj = (Map)jst.fromJS(userSettings);
            String customJS = (String)skinConfigObj.get("customJS");
            int customJSOffset = baseLoadSkin.indexOf("// if CSS is loaded");
            int prevLineStart = baseLoadSkin.lastIndexOf("\n", customJSOffset);
            int finalBlockStart = baseLoadSkin.lastIndexOf("\n", prevLineStart);
            Object result = baseLoadSkin.substring(0, finalBlockStart);
            if (customJS != null && customJS != "null" && customJS != "") {
                result = (String)result + "\n\n    // Custom Skin Editor JS\n\n";
                result = (String)result + customJS + "\n\n";
            }
            Object object = result = (String)result + baseLoadSkin.substring(finalBlockStart);
            return object;
        }
        catch (Exception e) {
            log.error((Object)"Error injecting JS code into load_skin.js.", e);
            String string = baseLoadSkin;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String injectCustomCSSContent(String baseContent, String userSettings) throws Exception {
        try {
            JSTranslater jst = JSTranslater.instance();
            Map skinConfigObj = (Map)jst.fromJS(userSettings);
            Map customCSSObj = (Map)jst.fromJS(userSettings);
            String customCSS = (String)skinConfigObj.get("customCSS");
            String result = baseContent + "\n\n    /* Custom Skin Editor CSS */ \n\n";
            if (customCSS != null && customCSS != "null") {
                result = result + customCSS + "\n\n";
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            log.error((Object)"Error injecting JS code into load_skin.js.", e);
            String string = baseContent;
            return string;
        }
    }

    public static enum SkinType {
        BASE,
        USER,
        ON_FILESYSTEM,
        USER_ON_FILESYSTEM,
        USER_RECORD_ON_DISK,
        ALL;

    }
}

