/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class VLongWritable
implements WritableComparable<VLongWritable> {
    private long value;

    public VLongWritable() {
    }

    public VLongWritable(long value) {
        this.set(value);
    }

    public void set(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = WritableUtils.readVLong(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVLong(out, this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VLongWritable)) {
            return false;
        }
        VLongWritable other = (VLongWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(VLongWritable o) {
        long thisValue = this.value;
        long thatValue = o.value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

