var defaultGroup = "Sales Management";

var customDataByGroup = {
    "Classic Models Inc. Order Management": {
        dataSources: ["CM_ProductLine", "CM_Product", "CM_Office", "CM_Employee", "CM_Customer", "CM_Order", "CM_OrderDetail", "CM_Payment"],
        samplePrompts: [
            "Create a ListGrid listing out Product lines. Enable expansion to show related Products."
        ]
    },
    "Issue Tracking": {
        dataSources: ["iss_Department", "iss_IssueHistory", "iss_IssueMaster", "iss_IssueStatus", "iss_IssueType", "iss_Priority", "iss_Users", "iss_UserType"],
        samplePrompts: [
            "Build a user interface allowing me to identify and view details of open issues by priority"
        ]
    },
        "Sales Management": {
        dataSources: ["CM_Customer", "CM_Order"],
        samplePrompts: [
            "Create an interface for viewing orders for each customer",
            "Build a tab-based app to create new sales orders and view existing orders"
        ]
    }
};

isc.VLayout.create({
    width: "100%",
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: "100%",
            minWidth: 850,
            maxWidth: 1060,
            numCols: 4,
            colWidths: [100, 300, 150, "*"],
            cellPadding: 5,
            items: [
                {
                    name: "group",
                    editorType: "SelectItem",
                    required: true,
                    title: "Data Sets",
                    wrapTitle: false,
                    width: "100%",
                    valueMap: isc.getKeys(customDataByGroup),
                    defaultValue: defaultGroup,
                    changed : function (form, groupItem, group) {
                        var samplePromptItem = form.getField("samplePrompt"),
                            promptItem = form.getField("prompt");
                        samplePromptItem.clearValue();
                        promptItem.clearValue();

                        var customData = customDataByGroup[group];
                        if (customData) {
                            samplePromptItem.setValueMap(customData.samplePrompts);

                            promptItem.settings = {
                                dataSourceNames: customData.dataSources
                            };
                        }
                    }
                },
                {
                    name: "samplePrompt",
                    editorType: "SelectItem",
                    requiredWhen: {
                        _constructor: "AdvancedCriteria",
                        operator: "or",
                        criteria: [{
                            fieldName: "prompt",
                            operator: "isBlank"
                        }, {
                            fieldName: "prompt",
                            operator: "regexp",
                            value: "^\\s+$"
                        }]
                    },
                    title: "Sample Prompts",
                    width: "100%",
                    valueMap: customDataByGroup[defaultGroup].samplePrompts,
                    changed : function (form, samplePromptItem, samplePrompt) {
                        form.clearErrors(true);
                        form.setValue("prompt", samplePrompt);
                    }
                },         
                {
                    name: "prompt",
                    editorType:"TextItem",
                    settings:{
                        dataSourceNames: customDataByGroup[defaultGroup].dataSources
                    },
                    selectOnFocus:true,
                    hint:"Ask AI to build a User Interface",
                    showHintInField:true,
                    icons: [
                        {
                            name: "AIAnswerEngine",
                            src: "AIAnswerEngine",
                            width: 22,
                            hspace: 5,
                            height: 22,
                            showRTL: true,
                            inline: true,
                            tabIndex: -1,
                            cursor: "text",
                            ariaRole: "presentation",
                            click : function (form, item, icon) {
                                item.focusInItem();
                            }
                        }
                    ],
                    width: "*",
                    height: 45,
                    colSpan: "*",
                    showTitle:false,
                    showOver:false,
                    textBoxStyle: "dataQuestionItemControl",

                    keyPress:function () {
                        if (isc.EH.getKey() == "Enter") {
                            var value = this.getValue();
                            if (value == null) return;
                            createInstantUI(this.getValue(), this.settings);
                        }
                    }
                }
           ]
        }),

        isc.IButton.create({
            title: "Build User Interface",
            width: 200,
            click : function () {
                if (form.validate()) {
                    var promptItem = form.getField("prompt")
                    createInstantUI(promptItem.getValue(), promptItem.settings);
                }
            }
        })
    ],
    membersMargin: 10
});

isc.Window.create({
    ID:"instantUIWindow",
    title:"AI-Generated User Interface",
    canDragReposition:false,
    showMinimizeButton:false,
    
    width:"100%",
    height:"100%",
    autoDraw:false,
    close : function () {
        this.clear();
    },
    items:[

        isc.InstantUI.create({
            ID:"instantUI",
            showSQLBrowser:false,
            showEditInReifyButton:false,
            showDiscardButton:false,
            autoDraw:false
            
        })
    ]
});

function createInstantUI (prompt, settings) {
    instantUI.clearUI();

    instantUIWindow.draw();
    instantUIWindow.bringToFront();
    var dataSources = [...settings.dataSourceNames];
    dataSources.forEach(
        (element,index,array) => {array[index] = isc.DataSource.get(element)}
    );
    instantUI.dataSources = dataSources
    instantUI.createUI(prompt);
}

