isc.VLayout.create({
    width: "100%", height: "100%",
    membersMargin: 15,
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: 600,
            items: [
                {
                    name: "dsSelector",
                    editorType: "SelectItem",
                    required: true,
                    title: "DataSource",
                    valueMap: ["UserIssues","worldDS"],
                    defaultValue: "UserIssues",
                    changed : function (form, item, value) {
                        if (value == "UserIssues") {
                            buttonLayout.show();
                            lgWorld.hide();
                            lgIssues.show();
                        } else {
                            buttonLayout.hide();
                            lgWorld.show();
                            lgIssues.hide();
                            lgWorld.fetchData(lgWorld.getCriteria());
                        }
                    }
                }
           ]
        }),
        isc.HLayout.create({
            ID: "buttonLayout",
            width: "*",
            members: [
                isc.IButton.create({
                    title: "Urgency",
                    width: 150,
                    prompt: "By analyzing each record’s Description for time‑sensitivity, the AI generates an urgency score and automatically moves the highest‑urgency items to the top of the grid. Ties are broken by ascending IssueID (first‑come, first‑served).",
                    click : function () {
                        var aiAssessedUrgencyField = lgIssues.getFieldByName("aiAssessedUrgency");
                        if (!aiAssessedUrgencyField) {
                            aiAssessedUrgencyField = {
                                name: "aiAssessedUrgency",
                                title: "Issue Urgency",
                                width: 175,
                                aiFieldPrompt: "assess the urgency of the reported issue",
                                canEditAISummary: false,
                                showHover: true
                            };
                            lgIssues.addField(aiAssessedUrgencyField);
                        }

                        lgIssues.showField(aiAssessedUrgencyField);

                        var sortFieldCount = lgIssues.getSortFieldCount();
                        if (sortFieldCount == 0 ||
                            (sortFieldCount == 1 && lgIssues.isSortField(aiAssessedUrgencyField.name)))
                        {
                            lgIssues.toggleSort(aiAssessedUrgencyField.name);
                        } else {
                            lgIssues.sort(aiAssessedUrgencyField.name, "ascending");
                        }
                    }
                }),
                isc.IButton.create({
                    title: "Impact",
                    width: 150,
                    prompt: "Select the issue category based on its impact: Critical (threatens core functions/safety), High (major disruptions needing immediate attention), Moderate (manageable disruptions), or Low (minimal effect on operations).",
                    click : function () {
                        var aiAssessedImpactField = lgIssues.getFieldByName("aiAssessedImpact");
                        if (!aiAssessedImpactField) {
                            aiAssessedImpactField = {
                                name: "aiAssessedImpact",
                                title: "Department Impact",
                                width: 175,
                                aiFieldPrompt: "assess the potential impact to the Department of the issue",
                                canEditAISummary: false,
                                showHover: true
                            };
                            lgIssues.addField(aiAssessedImpactField);
                        }

                        lgIssues.showField(aiAssessedImpactField);

                        var sortFieldCount = lgIssues.getSortFieldCount();
                        if (sortFieldCount == 0 ||
                            (sortFieldCount == 1 && lgIssues.isSortField(aiAssessedImpactField.name)))
                        {
                            lgIssues.toggleSort(aiAssessedImpactField.name);
                        } else {
                            lgIssues.sort(aiAssessedImpactField.name, "ascending");
                        }
                    }
                })
            ],
            membersMargin: 10
        }),
        isc.ListGrid.create({
            ID: "lgIssues",
            width: "100%", height: "100%",
            dataSource: "UserIssues", 
            autoFetchData: true,
            canHover: true,
            showHover: false,
            fields: [
                {name:"Issue_ID", width:150},
                {name:"Reported_By", width:200},
                {name:"Department", width:150},
                {name:"Category", width:150},
                {name:"Issue_Description", width:250, hoverWidth:300, showHover:true}
            ],
            initialSort: [{
                property: "Issue_ID",
                direction: "ascending"
            }],
            canAddAISortFields: true,
            sortViaAIMode: "AIDE"
        }),
        isc.ListGrid.create({
            ID: "lgWorld",
            width: "100%", height: "100%",
            visibility: "hidden",
            dataSource: "worldDS", dataFetchMode: "local", autoFetchData: false,
            showFilterEditor: true,
            canHover: true,
            showHover: false,
            fields: [
                {name:"countryCode", title:"Flag", width:70, type: "image", imageURLPrefix: "flags/24/", imageURLSuffix: ".png"},
                {name:"countryName", width:235},
                {name:"continent", width:125},
                {name:"government", width:235},
                {
                    name: "pressFreedom",
                    title: "Press Freedom",
                    width: 175,
                    aiFieldPrompt: "press freedom in the country",
                    canEditAISummary: false,
                    showHover: true
                }
            ],
            canPickOmittedFields: true,
            implicitCriteria: {
                // exclude territories, as the press freedom in territories is usually not separately reported
                _constructor: "AdvancedCriteria",
                fieldName: "independence",
                operator: "notNull"
            },
                        initialCriteria: {
                continent: "Europe"
            },
            showFilterEditor: true,
            initialSort: [{
                property: "pressFreedom",
                direction: "descending"
            }, {
                property: "countryName",
                direction: "ascending"
            }],
            canAddAISortFields: true,
            sortViaAIMode: "AIDE",
            aiSortFieldMaxRecords: 250
        })
    ]
});

