import React from 'react';
import { ProcessElement, ProcessElementProps } from './ProcessElement';
import { AsComponentXML } from './core/ReactComponent';


declare interface TaskProps extends ProcessElementProps {

/**
 * See {@link isc.Task.getInputRecord() Task.getInputRecord()}.
 */
getInputRecord?: Function;

/**
 * See {@link isc.Task.setOutput() Task.setOutput()}.
 */
setOutput?: Function;

/**
 * See {@link isc.Task.inputFieldList Task.inputFieldList}.
 */
inputFieldList?: string[];

/**
 * See {@link isc.Task.outputFieldList Task.outputFieldList}.
 */
outputFieldList?: string[];

/**
 * See {@link isc.Task.outputExpression Task.outputExpression}.
 */
outputExpression?: string;

/**
 * See {@link isc.Task.inputs Task.inputs}.
 */
inputs?: Object | string[] | string;

/**
 * See {@link isc.Task.getState() Task.getState()}.
 */
getState?: Function;

/**
 * See {@link isc.Task.strictPaths Task.strictPaths}.
 */
strictPaths?: boolean;

/**
 * See {@link isc.Task.outputField Task.outputField}.
 */
outputField?: string;

/**
 * See {@link isc.Task.setState() Task.setState()}.
 */
setState?: Function;

/**
 * See {@link isc.Task.getExpressionValue() Task.getExpressionValue()}.
 */
getExpressionValue?: Function;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * Task wraps the SmartClient widget class
 * {@link isc.Task Task} for React, allowing you to import
 * Task for use in React JS and JSX.
 * @class
 * @extends ProcessElement
 */
declare class Task extends ProcessElement {
    props: AsComponentXML<TaskProps>;
}
