/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunnerWebDriver;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.webdriver.SeleneseRunner;
import com.isomorphic.webdriver.SeleneseTestOptions;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.TimeoutException;

public class TestRunnerHTMLLauncher {
    private File outputFile;
    private String browserURL;
    private TestRunnerWebDriver driver;
    private static final int LAUNCH_MARGIN = 10;
    private static final int SHUTDOWN_MARGIN = 5;
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : System.getProperty("java.io.tmpdir");
    private static Logger log = new Logger(TestRunnerHTMLLauncher.class.getName());

    public TestRunnerHTMLLauncher(TestRunnerWebDriver driver, String browserURL) {
        this.driver = driver;
        this.browserURL = browserURL;
    }

    public String getOutput() throws IOException {
        return FileUtils.readFileToString((File)this.outputFile);
    }

    public boolean runSelenese(String testPath, SeleneseTestOptions testOptions) throws IOException, ExecutionException, InterruptedException {
        int timeoutInSeconds = testOptions.getTimeout();
        log.info((Object)("Launching SeleneseRunner with timeout of " + timeoutInSeconds + " seconds and testPath of " + testPath));
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread serviceThread = new Thread(runnable);
                serviceThread.setDaemon(true);
                return serviceThread;
            }
        });
        SafeSeleneseRunner runner = new SafeSeleneseRunner(testPath, testOptions);
        Future<Boolean> future = executor.submit(runner);
        try {
            boolean result = future.get(timeoutInSeconds + 10, TimeUnit.SECONDS);
            log.info((Object)("SeleneseRunner has finished gracefully with result: " + result));
            boolean bl = result;
            return bl;
        }
        catch (java.util.concurrent.TimeoutException e) {
            future.cancel(true);
            log.error((Object)"SeleneseRunner ExecutorService has timed out", (Throwable)e);
            throw new TimeoutException("SeleneseRunner timed out after " + timeoutInSeconds + " seconds with no result");
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (future.isCancelled() && runner.isAlive()) {
                log.error((Object)"The SeleneseRunner thread is not responding to the interrupt from the ExecutorService.  Ignoring.  An orphaned browser window may remain.");
                this.driver.abort();
            }
        }
    }

    private class SafeSeleneseRunner
    implements Callable<Boolean> {
        private String testPath;
        private Thread runnerThread;
        private SeleneseTestOptions testOptions;

        boolean isAlive() {
            return this.runnerThread.isAlive();
        }

        public SafeSeleneseRunner(String testPath, SeleneseTestOptions testOptions) {
            this.testPath = testPath;
            this.testOptions = testOptions;
        }

        @Override
        public Boolean call() throws IOException {
            this.runnerThread = Thread.currentThread();
            File tmpDir = new File(TestRunnerHTMLLauncher.tmpDir);
            TestRunnerHTMLLauncher.this.outputFile = File.createTempFile("selenese", ".log", tmpDir);
            TestRunnerHTMLLauncher.this.outputFile.deleteOnExit();
            PrintStream outputStream = new PrintStream(TestRunnerHTMLLauncher.this.outputFile);
            return SeleneseRunner.executeSelenese((String)TestRunnerHTMLLauncher.this.browserURL, (String)this.testPath, (InputStream)ISCFile.getCanonicalInputStream((String)this.testPath), (SmartClientWebDriver)TestRunnerHTMLLauncher.this.driver.getSmartClientWebDriver(), (SeleneseTestOptions)this.testOptions, (PrintStream)outputStream, (PrintStream)outputStream);
        }
    }
}

