/*

  SmartClient Ajax RIA system
  Version v14.1p_2026-01-27/LGPL Deployment (2026-01-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//
// This script will load all of the Isomorphic SmartClient Application Framework libraries for you
//
// The idea is that in your app file you can just load the script "Isomorphic_SmartClient.js" which
// in a production situation would be all of the scripts jammed together into a single file.
//
// However, it's easier to work on the scripts as individual files, this file will load all of the
// scripts individually for you (with a speed penalty).
//		
var libs = 
	[
        "debug/version",  // check for module version mismatches

        //>Animation
		"widgets/Animation",	// Animation subsystem
        //<Animation

		"widgets/StatefulCanvas",		// minor variant on Canvas allowing for statefulness.

		"widgets/Layout",				// automatically arranges its children
		//"widgets/DetailViewer",			// show attributes of one or more objects as a vertical table
		"widgets/Button",				// button with special up, down, disabled, etc. look
		"widgets/Img",					// positionable image

//		"widgets/ButtonTable",			// table of cheapie buttons (very low resource use) -- in Nav, they look like links
//		"widgets/DateChooser",			// a date picker

// evaluation tracker image loader


		"widgets/StretchImg",			// composite image, composed of many individual images
//        "widgets/Slider",             	// graphical slider widget (uses isc.Img and isc.StretchImg)

		"widgets/Label",				// moveable, changeable bit of text
        //>Progressbar
		"widgets/Progressbar",			// stretch image for showing progress of lengthy operations
        //<Progressbar
        //>Rangebar
        "widgets/Rangebar",            	// graphical rangebar widget
        //<Rangebar
		"widgets/Toolbar",				// collection of buttons
		//"widgets/Border",				// platform-independent border
		"widgets/ImgButton",			// image with button behaviors
		"widgets/StretchImgButton",		// stretch image with button behaviors			
		//"widgets/ImgTab",				// stretch image with tab behaviors
		//"widgets/TabBar",				// collection of tabs
		
		"widgets/Notify",				// singleton that manages auto-dismissed notifications

		"widgets/ToolStrip",			// a narrow strip with a mixed set of controls
		"widgets/RibbonBar",		    // a toolstrip for showing RibbonButtons in RibbonGroups

        //>SectionStack
        "widgets/SectionStack",         // container similar to Outlook left-hand Nav (subclass of Layout, uses Label)
        //<SectionStack

		"widgets/Scrollbar",			// horizontal and vertical image based scroll bars styled with media
		"widgets/MinimalScrollbar",		// minimalist horizontal and vertical canvas-based scrollbars styled with css
        "widgets/NativeScrollbar",      // horizontal and vertical scrollbars that display native CSS scrollbars with standard SmartClient Scrollbar interface APIs
		
		//"widgets/GridRenderer",			// high speed, flexible, feature-rich table
		//"widgets/ListGrid",			// multi-column viewer for a list of objects
        //"widgets/TreeGrid",			// viewer for a tree of objects
        
        //"widgets/RecordEditor",         // specialized listViewer for editing a single record

        "widgets/Splitbar",              // default resizer for layouts

		//"widgets/Finder",				// specialized tree viewer that resembles the Macintosh isc.Finder
		//"widgets/Explorer",			// specialized tree viewer that resembles the left part of a Windows Explorer
		//"widgets/ExplorerList",		// specialized tree viewer that resembles the right part of a Windows Explorer

        //"widgets/ScrollingMenu",        // specialized listViewer with menu type event-handling 
                                        // behaviour, but scrollable and ready for data-binding
        		
        //"widgets/Menu",               // pull-down or context menus
        //"widgets/MenuButton",         // button that shows a menu on click
        //"widgets/Menubar",            // set of menus shown as a menubar
        //"widgets/Window",             // window class
        //"widgets/Dialog",             // movable, modal dialog
        "widgets/IconImgButton",        // specialized ImgButton showing icon

        

		"widgets/StretchResizePolicy",	// code to resize a set of elements in a single dimension

        

        //>SimpleType
        "language/SimpleType",          // loads map of built-in types and their validators, SimpleType
        //<SimpleType

        "widgets/NavigationBar",        // iPhone/iPad -like navigationBar

        "widgets/SplitPane",            // manages a two-pane layout according to hardware type
                                        // and orientation
        "widgets/NavStack",
        "widgets/Deck",
        "widgets/NavPanel",
		
		"tools/LocatorEditor"

	];

//<STOP PARSING 

// The following code only executes if the script is being dynamically loaded.

// the following statement allows a page that is not in the standard location to take advantage of
// dynamically loaded scripts by explicitly setting the window.isomorphiDir variable itself.
if (! window.isomorphicDir) window.isomorphicDir = "../isomorphic/";

// dynamic loading
(function () {
    function loadLib(lib, hash) {
        if (hash == null) hash = "";
        document.write("<"+"script src='" + window.isomorphicDir + "client/" + lib + ".js" + hash + "' type='text/javascript' charset='UTF-8'><"+"/script>");
    }

    loadLib("language/startDefiningFramework", "#module=Foundation");
    for (var i = 0, l = libs.length; i < l; ++i) {
        if (!libs[i]) continue;
        if (window.UNSUPPORTED_BROWSER_DETECTED == true) break;
        loadLib(libs[i]);
    }
    loadLib("language/stopDefiningFramework", "#module=Foundation");
})();
