/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scheduler;

import com.isomorphic.base.Reflection;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.scheduler.QuartzBasicDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzJobs
extends QuartzBasicDataSource {
    public DSResponse executeCustom(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        String op = req.getOperation();
        Map values = req.getValues();
        String jobGroup = (String)values.get("group");
        String jobName = (String)values.get("name");
        JobKey jobKey = new JobKey(jobName, jobGroup);
        if ("triggerJob".equals(op)) {
            Map dataMap = (Map)values.get("dataMap");
            if (dataMap != null) {
                QuartzJobs.getScheduler().triggerJob(jobKey, new JobDataMap(dataMap));
            } else {
                QuartzJobs.getScheduler().triggerJob(jobKey);
            }
        } else if ("pauseJob".equals(op)) {
            QuartzJobs.getScheduler().pauseJob(jobKey);
        } else if ("resumeJob".equals(op)) {
            QuartzJobs.getScheduler().resumeJob(jobKey);
        } else {
            throw new Exception("Invalid operation: " + op);
        }
        return response;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        String jobGroup;
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        List<String> jobGroups = new ArrayList();
        AdvancedCriteria ac = req.getAdvancedCriteria();
        if (ac != null && (jobGroup = (String)ac.getFieldValue("group")) != null) {
            jobGroups.add(jobGroup);
        }
        if (jobGroups.isEmpty()) {
            jobGroups = QuartzJobs.getScheduler().getJobGroupNames();
        }
        ArrayList data = new ArrayList();
        for (String jobGroup2 : jobGroups) {
            for (JobKey jobKey : QuartzJobs.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroup2))) {
                HashMap<String, String> record = null;
                try {
                    record = this.convertJobDetailToMap(QuartzJobs.getScheduler().getJobDetail(jobKey));
                }
                catch (Exception e) {
                    record = new HashMap<String, String>();
                    record.put("name", jobKey.getName());
                    record.put("group", jobGroup2);
                }
                data.add(record);
            }
        }
        response.setData(data);
        return response;
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        Map record = req.getValues();
        JobDetail jobDetail = this.convertMapToJobDetail(record);
        QuartzJobs.getScheduler().addJob(jobDetail, true);
        record = this.convertJobDetailToMap(QuartzJobs.getScheduler().getJobDetail(jobDetail.getKey()));
        response.setData((Object)record);
        return response;
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        throw new Exception("Updates to jobs are not supported by Quartz");
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        Map record = req.getValues();
        String jobName = (String)record.get("name");
        String jobGroup = (String)record.get("group");
        JobKey jobKey = new JobKey(jobName, jobGroup);
        QuartzJobs.getScheduler().deleteJob(jobKey);
        response.setData((Object)req.getOldValues());
        return response;
    }

    private Map convertJobDetailToMap(JobDetail job) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("group", job.getKey().getGroup());
        record.put("name", job.getKey().getName());
        record.put("description", job.getDescription());
        record.put("className", job.getJobClass().getName());
        record.put("isPersistJobDataAfterExecution", job.isPersistJobDataAfterExecution());
        record.put("isConcurrentExectionDisallowed", job.isConcurrentExecutionDisallowed());
        record.put("durability", job.isDurable());
        record.put("recover", job.requestsRecovery());
        JobDataMap jdm = job.getJobDataMap();
        if (jdm != null) {
            record.put("dataMap", jdm);
        }
        return record;
    }

    private JobDetail convertMapToJobDetail(Map record) throws Exception {
        Boolean durabilityB = (Boolean)record.get("durability");
        boolean durability = durabilityB == null ? true : durabilityB;
        Boolean recoverB = (Boolean)record.get("recoverB");
        boolean recover = recoverB == null ? true : recoverB;
        JobKey jobKey = new JobKey((String)record.get("name"), (String)record.get("group"));
        JobBuilder jobBuilder = JobBuilder.newJob().storeDurably(durability).requestRecovery(recover).withDescription((String)record.get("description")).withIdentity(jobKey);
        Map jdm = (Map)record.get("dataMap");
        if (jdm != null) {
            jobBuilder.setJobData(new JobDataMap(jdm));
        }
        String className = (String)record.get("className");
        try {
            Class clazz = Reflection.classForName((String)className);
            jobBuilder.ofType(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Can't find specified class in runtime: " + className);
        }
        return jobBuilder.build();
    }
}

