/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.AbstractLobCreator;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;

public class BlobAndClobCreator
extends AbstractLobCreator
implements LobCreator {
    public static final LobCreationContext.Callback<Blob> CREATE_BLOB_CALLBACK = Connection::createBlob;
    public static final LobCreationContext.Callback<Clob> CREATE_CLOB_CALLBACK = Connection::createClob;
    protected final LobCreationContext lobCreationContext;

    public BlobAndClobCreator(LobCreationContext lobCreationContext) {
        this.lobCreationContext = lobCreationContext;
    }

    public Blob createBlob() {
        return this.lobCreationContext.fromContext(CREATE_BLOB_CALLBACK);
    }

    @Override
    public Blob createBlob(byte[] bytes) {
        Blob blob = this.createBlob();
        try {
            blob.setBytes(1L, bytes);
            return blob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set BLOB bytes after creation", e);
        }
    }

    @Override
    public Blob createBlob(InputStream stream, long length) {
        return NonContextualLobCreator.INSTANCE.createBlob(stream, length);
    }

    public Clob createClob() {
        return this.lobCreationContext.fromContext(CREATE_CLOB_CALLBACK);
    }

    @Override
    public Clob createClob(String string) {
        try {
            Clob clob = this.createClob();
            clob.setString(1L, string);
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set CLOB string after creation", e);
        }
    }

    @Override
    public Clob createClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.createClob(reader, length);
    }

    @Override
    public NClob createNClob(String string) {
        return NonContextualLobCreator.INSTANCE.createNClob(string);
    }

    @Override
    public NClob createNClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.createNClob(reader, length);
    }
}

