/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseFilter;
import com.isomorphic.servlet.ServletTools;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;

public class VersionedURLFilter
extends BaseFilter {
    protected Logger log;

    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        String params;
        this.log = new Logger(this.getClass().getName());
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)req);
        Object original = wrapper.getRequestURI();
        String contextPath = wrapper.getContextPath();
        if (contextPath != null && contextPath.length() > 0 && ((String)original).startsWith(contextPath)) {
            original = ((String)original).substring(contextPath.length());
        }
        if ((params = wrapper.getQueryString()) != null && params.length() > 0) {
            original = (String)original + "?" + params;
        }
        String unversioned = original;
        if (config.getBoolean((Object)"isc.stripVersionPathSegments", false)) {
            unversioned = ServletTools.stripVersionPathSegment((String)original);
        }
        if (!((String)original).equals(unversioned)) {
            RequestDispatcher dispatcher = wrapper.getRequestDispatcher(unversioned);
            dispatcher.forward(req, res);
        } else {
            fc.doFilter((ServletRequest)wrapper, res);
        }
    }
}

