/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFieldFormula;
import com.isomorphic.sql.DB2Driver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLTable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DB2iSeriesDriver
extends DB2Driver {
    SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DB2iSeriesDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public String getQualifiedSchemaSeparator() {
        if ("system".equals(this._sqlConfig.getString((Object)"naming", "sql"))) {
            return "/";
        }
        return ".";
    }

    @Override
    public Object transformFieldValue(DSField field, Object obj) {
        if ((obj instanceof String || field != null && "text".equals(field.getType())) && (this._sqlConfig.getBoolean((Object)"trimTextFields", false) || field.getBoolean("trim"))) {
            int c;
            String text = obj.toString();
            if (text.length() == 0 || text.charAt(text.length() - 1) != ' ') {
                return text;
            }
            for (c = text.length(); c > 0 && text.charAt(c - 1) == ' '; --c) {
            }
            return text.substring(0, c);
        }
        return obj;
    }

    @Override
    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) throws Exception {
        if ((field != null && "date".equals(field.getType()) || field == null && value instanceof Date) && this.shouldUseSQLDateType(field)) {
            return this.escapeValue(this.isoDateFormat.format((Date)value));
        }
        return super.sqlInTransform(value, field, ds);
    }

    @Override
    public String transformFormula(String formula) {
        if (formula != null) {
            formula = DSFieldFormula.replace((String)formula, (String)"ceiling", (String)"ceil");
            formula = DSFieldFormula.replace((String)formula, (String)"max", (String)"greatest");
            formula = DSFieldFormula.replace((String)formula, (String)"min", (String)"least");
            formula = DSFieldFormula.replace((String)formula, (String)"pow", (String)"power");
            formula = DSFieldFormula.replace((String)formula, (String)"random", (String)"rand");
            formula = DSFieldFormula.replace((String)formula, (String)"day", (String)"dayofmonth");
        }
        return formula;
    }

    @Override
    public String getLastSequenceQuery() {
        return "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM" + this.getQualifiedSchemaSeparator() + "SYSDUMMY1";
    }
}

