/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest.model;

import com.isomorphic.autotest.BuilderSpecifier;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class TestResult
implements Serializable {
    private static final long serialVersionUID = 5517047163311898846L;
    private static Logger log = new Logger(TestResult.class.getName());
    public static final String DETAILS_SEPARATOR = "ISC_DEVELOPER_MESSAGES: ";
    public static final String MESSAGES_SEPARATOR = "ISC_SERVER_LOG_MESSAGES: ";
    public static final String PAGE_TIMEOUT_MARKER = "SELENIUM_PAGE_TIMEOUT: ";
    public static final String SERVER_LOG_LEADIN = "=== 20[0-9][0-9]-[0-1][0-9]-[0-3][0-9]";
    public static final String TEST_RESULT_SUCCESS = "success";
    public static final String TEST_RESULT_FAILURE = "failure";
    public static final String TEST_RESULT_TIMEOUT = "timeout";
    public static final String TEST_RESULT_DISABLED = "disabled";
    public static final String TEST_RESULT_UNKNOWN = "unknown";
    public static final String TEST_FILE_FIELD = "testFile";
    public static final String TEST_NUMBER_FIELD = "testNumber";
    public static final String RESULT_FIELD = "result";
    public static final String DETAILS_FIELD = "details";
    public static final String MESSAGES_FIELD = "messages";
    public static final String SERVER_LOGS_FIELD = "serverLogs";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String START_TIME_FIELD = "startTime";
    public static final String END_TIME_FIELD = "endTime";
    public static final String BATCH_START_TIME_FIELD = "batchStartTime";
    public static final String NOTIFICATION_COUNT_FIELD = "notificationCount";
    public static final String REIFY_CLOUD_TARGET_FIELD = "reifyCloudTarget";
    public static final String COUNT_STATE_FIELD = "countState";
    public static final String SHOWCASE_FIELD = "showcase";
    public static final String BUILDER_FIELD = "builder";
    public static final String BRANCH_FIELD = "branch";
    public static final String SUITENAME_FIELD = "suiteName";
    public static final String LAST_PASS_FIELD = "lastPass";
    public static final String HISTORY_FIELD = "history";
    public static final String IMAGE_FILE_FIELD = "capture_filename";
    public static final String IMAGE_SIZE_FIELD = "capture_filesize";
    private String testFile;
    private int testNumber;
    private String result;
    private String description;
    private String details;
    private String messages;
    private String serverLogs;
    private Date startTime;
    private Date endTime;
    private Date batchStartTime;
    private String showcase;
    private String builder;
    private String branch;
    private Date lastPass;
    private String imageFile;
    private long imageSize;
    private int notificationCount;
    private int countState;
    private String pastResults;

    public String getTestFile() {
        return this.testFile;
    }

    public void setTestFile(String testFile) {
        this.testFile = testFile;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public void setTestNumber(int testNumber) {
        this.testNumber = testNumber;
    }

    public String getTestKey() {
        return this.getTestFile() + "_" + this.getTestNumber();
    }

    public String getTestTag() {
        return this.getTestFile() + "#" + this.getTestNumber();
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
        if (this.imageFile != null && !TestResult.isFailure(result)) {
            try {
                File file = new File(this.imageFile);
                this.imageFile = null;
                file.delete();
            }
            catch (Exception e) {
                log.error((Object)("encountered exception trying to remove screen capture file for test " + this.testFile + " #" + this.testNumber + ": "), (Throwable)e);
            }
        }
    }

    public void setIdentifiers(String branch, String suiteName, Date batchStartTime) {
        this.branch = branch;
        this.builder = BuilderSpecifier.getBuilder(suiteName);
        this.showcase = ShowcaseSpecifier.getShowcase(suiteName);
        this.batchStartTime = batchStartTime;
    }

    public boolean isSuccess() {
        return TestResult.isSuccess(this.result);
    }

    public boolean isFailure() {
        return TestResult.isFailure(this.result);
    }

    public boolean isDisabled() {
        return TestResult.isDisabled(this.result);
    }

    public boolean isUnknown() {
        return TestResult.isUnknown(this.result);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    private static String removeDuplicateContent(String content) {
        if (content == null) {
            return null;
        }
        Object newContent = "";
        String thisToken = null;
        String lastToken = null;
        int tokenCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(content, "\r\n");
        do {
            String string = thisToken = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (thisToken != null && thisToken.equals(lastToken)) {
                ++tokenCount;
                continue;
            }
            if (lastToken != null) {
                newContent = (String)newContent + lastToken;
                if (tokenCount > 1) {
                    newContent = (String)newContent + " <strong>[X" + tokenCount + "]</strong>";
                }
                newContent = (String)newContent + "\r\n";
            }
            lastToken = thisToken;
            tokenCount = 1;
        } while (thisToken != null);
        return newContent;
    }

    private static String formatAsHTML(String content) {
        if (content == null) {
            return null;
        }
        return content.replaceAll("((\\r)?\\n)", "<br>$1");
    }

    public void formatDetailsAndLogs() {
        this.details = TestResult.formatAsHTML(this.details);
        this.messages = TestResult.formatAsHTML(this.messages);
        TestRunnerConfiguration config = TestResultDao.getConfiguration();
        this.serverLogs = config.shouldCommitServerLogs() ? TestResult.formatAsHTML(this.serverLogs) : null;
    }

    public String getMessages() {
        return this.messages;
    }

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public String getServerLogs() {
        return this.serverLogs;
    }

    public void setServerLogs(String logs) {
        this.serverLogs = logs;
    }

    public void setServerLogs(String[] logs) {
        this.serverLogs = StringUtils.join((Object[])logs);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getBatchStartTime() {
        return this.batchStartTime;
    }

    public void setBatchStartTime(Date batchStartTime) {
        this.batchStartTime = batchStartTime;
    }

    public void setShowcase(String showcase) {
        this.showcase = showcase;
    }

    public String getShowcaseAsKey() {
        return this.showcase != null ? this.showcase : "dottest";
    }

    public String getShowcase() {
        return this.showcase;
    }

    public void setBuilder(String builder) {
        this.builder = builder;
    }

    public String getBuilder() {
        return this.builder;
    }

    public String getTestSuiteAsKey() {
        if (this.builder != null) {
            return this.builder;
        }
        return this.getShowcaseAsKey();
    }

    public String getTestSuite() {
        if (this.builder != null) {
            return this.builder;
        }
        return this.getShowcase();
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public Date getLastPassBatchStartTime() {
        return this.lastPass;
    }

    public void setLastPassBatchStartTime(Date lastPass) {
        this.lastPass = lastPass;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageSize(long nBytes) {
        this.imageSize = nBytes;
    }

    public long getImageSize() {
        return this.imageSize;
    }

    public void setNotificationCount(int count) {
        this.notificationCount = count;
    }

    public int getNotificationCount() {
        return this.notificationCount;
    }

    public void setResultCountState(int countState) {
        this.countState = countState;
    }

    public int getResultCountState() {
        return this.countState;
    }

    public boolean isWobbler() {
        return this.notificationCount > 0;
    }

    private int getBoundedMinimum(int maximum, int ... lengths) {
        for (int length : lengths) {
            if (length < 0 || length >= maximum) continue;
            maximum = length;
        }
        return maximum;
    }

    public void setContent(String content) {
        if (content == null) {
            return;
        }
        this.details = content;
        int messagesOffset = content.indexOf(DETAILS_SEPARATOR);
        int serverLogsOffset = content.indexOf(MESSAGES_SEPARATOR);
        int detailsMax = this.getBoundedMinimum(content.length(), messagesOffset, serverLogsOffset);
        this.details = content.substring(0, detailsMax);
        if (messagesOffset >= 0) {
            int messagesMax = this.getBoundedMinimum(content.length(), serverLogsOffset);
            this.messages = content.substring(messagesOffset += DETAILS_SEPARATOR.length(), messagesMax);
        }
        if (serverLogsOffset >= 0) {
            this.serverLogs = content.substring(serverLogsOffset += MESSAGES_SEPARATOR.length(), content.length());
        }
    }

    public TestResult() {
    }

    public TestResult(Map<String, ?> data) {
        Integer notificationCount;
        this.setBatchStartTime((Date)data.get(BATCH_START_TIME_FIELD));
        this.setDescription((String)data.get(DESCRIPTION_FIELD));
        this.setEndTime((Date)data.get(END_TIME_FIELD));
        this.setResult((String)data.get(RESULT_FIELD));
        this.setDetails((String)data.get(DETAILS_FIELD));
        this.setMessages((String)data.get(MESSAGES_FIELD));
        this.setStartTime((Date)data.get(START_TIME_FIELD));
        this.setTestFile((String)data.get(TEST_FILE_FIELD));
        this.setShowcase((String)data.get(SHOWCASE_FIELD));
        this.setBuilder((String)data.get(BUILDER_FIELD));
        this.setBranch((String)data.get(BRANCH_FIELD));
        int testNumber = data.containsKey(TEST_NUMBER_FIELD) ? DataTools.getInt(data, (Object)TEST_NUMBER_FIELD) : 1;
        this.setTestNumber(testNumber);
        Integer resultCountState = DataTools.getInteger(data, (Object)COUNT_STATE_FIELD);
        if (resultCountState != null) {
            this.setResultCountState(resultCountState);
        }
        if ((notificationCount = DataTools.getInteger(data, (Object)NOTIFICATION_COUNT_FIELD)) != null) {
            this.setNotificationCount(notificationCount);
        }
        this.setLastPassBatchStartTime((Date)data.get(LAST_PASS_FIELD));
        this.setPastResults((String)data.get(HISTORY_FIELD));
    }

    public TestResult(TestResult tr, boolean truncate) throws Exception {
        this.batchStartTime = tr.batchStartTime;
        this.description = tr.description;
        this.details = TestResult.clipTextField(DETAILS_FIELD, tr.details, truncate);
        this.messages = TestResult.clipTextField(MESSAGES_FIELD, tr.messages, truncate);
        this.serverLogs = TestResult.clipTextField(SERVER_LOGS_FIELD, tr.serverLogs, truncate);
        this.notificationCount = tr.notificationCount;
        this.result = tr.result;
        this.testFile = tr.testFile;
        this.testNumber = tr.testNumber;
        this.startTime = tr.startTime;
        this.endTime = tr.endTime;
        this.showcase = tr.showcase;
        this.builder = tr.builder;
        this.branch = tr.branch;
        this.imageFile = tr.imageFile;
        this.imageSize = tr.imageSize;
    }

    public static String clipTextField(String fieldName, String text, boolean truncate) throws Exception {
        if (!truncate) {
            return text;
        }
        TestRunnerConfiguration config = TestResultDao.getConfiguration();
        return Utils.clipTextField(config.getTestResultDS(), fieldName, text);
    }

    public static boolean isFailure(String result) {
        return TEST_RESULT_FAILURE.equals(result) || TEST_RESULT_TIMEOUT.equals(result);
    }

    public static boolean isSuccess(String result) {
        return TEST_RESULT_SUCCESS.equals(result);
    }

    public static boolean isTimeout(String result) {
        return TEST_RESULT_TIMEOUT.equals(result);
    }

    public static boolean isDisabled(String result) {
        return TEST_RESULT_DISABLED.equals(result);
    }

    public static boolean isUnknown(String result) {
        return TEST_RESULT_UNKNOWN.equals(result) || result == null;
    }

    public static boolean isRegression(String newResult, String oldResult) {
        return !TestResult.isFailure(oldResult) && TestResult.isFailure(newResult) || TestResult.isSuccess(oldResult) && TestResult.isUnknown(newResult);
    }

    public static boolean isFix(String newResult, String oldResult) {
        return (TestResult.isFailure(oldResult) || TestResult.isUnknown(oldResult)) && TestResult.isSuccess(newResult);
    }

    public void addPastResult(String pastResult, String openAnchor) {
        if (this.pastResults == null) {
            this.pastResults = "";
        }
        String grade = pastResult;
        if (TEST_RESULT_SUCCESS.equals(pastResult)) {
            grade = "P";
        } else if (TEST_RESULT_FAILURE.equals(pastResult)) {
            grade = "F";
        } else if (TEST_RESULT_TIMEOUT.equals(pastResult)) {
            grade = "O";
        } else if (TEST_RESULT_DISABLED.equals(pastResult)) {
            grade = "D";
        } else if (null == pastResult) {
            grade = "U";
        }
        this.pastResults = this.pastResults + (String)(openAnchor != null ? openAnchor + grade + "</a>" : grade);
    }

    public boolean setPastResults() {
        if (this.pastResults == null) {
            return false;
        }
        for (int i = 0; i < this.pastResults.length(); ++i) {
            if (this.pastResults.charAt(i) == '-') continue;
            return true;
        }
        this.pastResults = "&lt;No History&gt;";
        return false;
    }

    public void setPastResults(String pastResults) {
        this.pastResults = pastResults;
    }

    public String getPastResults() {
        return this.pastResults;
    }
}

