#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )

$symbol_pound Starter Application using SQL DataSources

This example illustrates the recommended approach to data access / databinding with "sql" datasources.  It was generated by a Maven archetype available in the SDK.  The related archetype / example at **archetype-quickstart** illustrates an indentical approach, but also provides integration with Spring Security for authentication & authorization (including support for CSRF protection, "Remember Me", and "SmartClient Relogin" features).

_Note that, given a choice, this is the approach most users should take when no security is required / integrating with a security framework other than Spring's.  Refer to the Quick Start Guide distributed with your build for further discussion on best practices._  

To start with a new application like this one:

1. Install Maven, if necessary 

     <https://maven.apache.org/install.html>

2. Install SmartClient, if necessary.
              
        mvn com.isomorphic:isc-maven-plugin:1.4.6:install $symbol_escape
          -Dproduct=SMARTCLIENT -Dlicense=EVAL -DbuildNumber=14.1p

3. Generate a project (using LATEST as below, or the version installed for you in step 2)

        mvn archetype:generate $symbol_escape
          -DartifactId=my-application -Dmodule=MyApplication $symbol_escape
          -DgroupId=com.example -Dpackage=com.example.myapplication $symbol_escape
          -DarchetypeGroupId=com.isomorphic.archetype $symbol_escape
          -DarchetypeArtifactId=archetype-smartclient-quickstart-unprotected $symbol_escape
          -DarchetypeVersion=LATEST -DinteractiveMode=false

Instructions are provided below for using the generated project with Eclipse and command line development environments.

If you instead want to add SmartClient to an existing project, consider declaring a dependency on the SmartClient overlay dependency as the generated project does, or see these instructions:  

<https://www.smartclient.com/smartclient-latest/isomorphic/system/reference/?id=group..iscInstall>

For instructions for launching tools such as the Developer Console, Visual Builder or DataSource Wizards, see the SmartClient FAQ:

<https://forums.smartclient.com/forum/technical-q-a/28592-the-smartclient-faq>


$symbol_pound$symbol_pound Prerequisites

Variations on the following are possible, but archetypes & sample projects were created with the following environment/s in mind:

- [Java 8](https://java.com/en/download/manual.jsp)

- [Apache Maven](http://maven.apache.org/download.cgi) version 3.5.0 or later

- [Apache Ant](https://ant.apache.org/bindownload.cgi) version 1.9.10 or later.

  - *Ensure that the ANT_HOME environment variable is set to the location of your Apache Ant directory, and the 'ant' command is in your PATH.*

- [Eclipse Java EE IDE for Web Developers](http://www.eclipse.org/downloads/packages/eclipse-ide-java-ee-developers/oxygen2), version 4.7.2 (Oxygen) or later.

$symbol_pound$symbol_pound$symbol_pound Initialization

1.  Ant users will begin by restructuring the project and removing Maven-specific resources.

        cd my-application
        ant unmaven


$symbol_pound$symbol_pound Usage: Apache Maven

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application

2.  Start the servlet container

        mvn jetty:run

3. Wait for the process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/my-application/index.jsp>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Import the generated project using the "Existing Maven Projects" wizard (File/Import/Maven/Existing Maven Projects)

2. If necessary, create or edit a Tomcat server with a JNDI configuration similar to those found at src/etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

3. Add the application to the server and launch it. 

4. Wait for each process to indicate that it's ready, and then load the app in your browser at the URL reported by Eclipse.  <http://localhost:8080/my-application/index.jsp>


$symbol_pound$symbol_pound Usage: Apache Ant

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application
        
2. Launch Jetty server.  _Note that this may fail the first time when Apache Ivy has not been installed, but correction should occur automatically, and subsequent attempts should be successful_.

        ant devmode

3. Wait for the process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/my-application/index.jsp>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Create a new project using the "Java Project" wizard (File/New/Project/Java Project)

2. When prompted for the 'Project name', use the name of the directory holding your project on disk.  

   **Project name: my-application**

   The wizard will automatically configure the JRE and the project layout based on the existing source.

3. If necessary, run the Ant build's 'javac' target to retrieve dependencies and extract the SmartClient runtime.

        ant javac

   Alternatively, you may choose to do this in steps by first running the Ant build's 'libs' and 'process-resources' targets, and then compiling via Eclipse.  Note that there is no recognizable benefit to doing so, however.    

   In either case, you may need to refresh your project's contents.

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'ant clean' execution._

4. Create or edit a Tomcat server with a JNDI configuration similar to those found at etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

5. Add the application to the server

6. Launch server

7. Wait for the process to indicate that it's ready, and then load the app in your browser at the URL reported by Eclipse.  <http://localhost:8080/index.jsp>


$symbol_pound$symbol_pound Related Topics

- Refer to the [Reify for Developers](https://www.smartclient.com/smartclient-latest/isomorphic/system/reference/?id=group..reifyForDevelopers) documentation topic for tips on importing UI assets from the Reify environment.

- See our debugging overview at <https://www.smartclient.com/smartclient-latest/isomorphic/system/reference/?ref=group:iscInstall&id=group..debugging>

