/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public abstract class AbstractEntityCollectionPart
implements EntityCollectionPart,
FetchOptions,
TableGroupProducer {
    private final NavigableRole navigableRole;
    private final CollectionPart.Nature nature;
    private final CollectionPersister collectionDescriptor;
    private final EntityMappingType associatedEntityTypeDescriptor;
    private final NotFoundAction notFoundAction;
    protected final Set<String> targetKeyPropertyNames;

    public AbstractEntityCollectionPart(CollectionPart.Nature nature, Collection collectionBootDescriptor, CollectionPersister collectionDescriptor, EntityMappingType associatedEntityTypeDescriptor, NotFoundAction notFoundAction, MappingModelCreationProcess creationProcess) {
        this.navigableRole = collectionDescriptor.getNavigableRole().appendContainer(nature.getName());
        this.nature = nature;
        this.collectionDescriptor = collectionDescriptor;
        this.associatedEntityTypeDescriptor = associatedEntityTypeDescriptor;
        this.notFoundAction = notFoundAction;
        this.targetKeyPropertyNames = AbstractEntityCollectionPart.resolveTargetKeyPropertyNames(nature, collectionDescriptor, collectionBootDescriptor, associatedEntityTypeDescriptor, creationProcess);
    }

    protected AbstractEntityCollectionPart(AbstractEntityCollectionPart original) {
        this.navigableRole = original.navigableRole;
        this.nature = original.nature;
        this.collectionDescriptor = original.collectionDescriptor;
        this.associatedEntityTypeDescriptor = original.associatedEntityTypeDescriptor;
        this.notFoundAction = original.notFoundAction;
        this.targetKeyPropertyNames = original.targetKeyPropertyNames;
    }

    public String toString() {
        return "EntityCollectionPart(" + this.navigableRole.getFullPath() + ")@" + System.identityHashCode(this);
    }

    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public EntityMappingType getMappedType() {
        return this.getAssociatedEntityMappingType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public int getFetchableKey() {
        return this.nature == CollectionPart.Nature.INDEX || !this.collectionDescriptor.hasIndex() ? 0 : 1;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.associatedEntityTypeDescriptor;
    }

    @Override
    public NotFoundAction getNotFoundAction() {
        return this.notFoundAction;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean incrementFetchDepth() {
        return false;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isUnwrapProxy() {
        return false;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getAssociatedEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup partTableGroup = this.resolveTableGroup(navigablePath, creationState);
        return this.associatedEntityTypeDescriptor.createDomainResult(navigablePath, partTableGroup, resultVariable, creationState);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        return this.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(value);
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        AssociationKey associationKey = this.resolveFetchAssociationKey();
        boolean added = creationState.registerVisitedAssociationKey(associationKey);
        TableGroup partTableGroup = this.resolveTableGroup(fetchablePath, creationState);
        EntityFetch fetch = this.buildEntityFetchJoined(fetchParent, this, partTableGroup, fetchablePath, creationState);
        if (added) {
            creationState.removeVisitedAssociationKey(associationKey);
        }
        return fetch;
    }

    protected EagerCollectionFetch buildEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, TableGroup collectionTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        return new EagerCollectionFetch(fetchedPath, fetchedAttribute, collectionTableGroup, true, fetchParent, creationState);
    }

    protected EntityFetch buildEntityFetchJoined(FetchParent fetchParent, AbstractEntityCollectionPart abstractEntityCollectionPart, TableGroup partTableGroup, NavigablePath fetchablePath, DomainResultCreationState creationState) {
        return new EntityFetchJoinedImpl(fetchParent, abstractEntityCollectionPart, partTableGroup, fetchablePath, creationState);
    }

    protected abstract AssociationKey resolveFetchAssociationKey();

    private TableGroup resolveTableGroup(NavigablePath fetchablePath, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        return fromClauseAccess.resolveTableGroup(fetchablePath, (NavigablePath np) -> {
            PluralTableGroup parentTableGroup = (PluralTableGroup)fromClauseAccess.getTableGroup(np.getParent());
            switch (this.nature) {
                case ELEMENT: {
                    return parentTableGroup.getElementTableGroup();
                }
                case INDEX: {
                    return this.resolveIndexTableGroup(parentTableGroup, fetchablePath, fromClauseAccess, creationState);
                }
            }
            throw new IllegalStateException("Could not find table group for: " + np);
        });
    }

    private TableGroup resolveIndexTableGroup(PluralTableGroup collectionTableGroup, NavigablePath fetchablePath, FromClauseAccess fromClauseAccess, DomainResultCreationState creationState) {
        return collectionTableGroup.getIndexTableGroup();
    }

    @Override
    public String getSqlAliasStem() {
        return this.getCollectionDescriptor().getAttributeMapping().getSqlAliasStem();
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return this.getAssociatedEntityMappingType().containsTableReference(tableExpression);
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlAstCreationState creationState) {
        SqlAstCreationContext creationContext = creationState.getCreationContext();
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, creationState);
        StandardTableGroup tableGroup = new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, this.getEntityMappingType().getRootEntityDescriptor()::containsTableReference, (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, creationState), creationContext.getSessionFactory());
        tableGroup.getTableReference(null, this.resolveFetchAssociationKey().getTable(), true);
        return tableGroup;
    }

    private static Set<String> resolveTargetKeyPropertyNames(CollectionPart.Nature nature, CollectionPersister collectionDescriptor, Collection collectionBootDescriptor, EntityMappingType elementTypeDescriptor, MappingModelCreationProcess creationProcess) {
        CompositeType compositeType;
        HashSet<String> targetKeyPropertyNames;
        String referencedPropertyName;
        Value bootModelValue = nature == CollectionPart.Nature.INDEX ? ((IndexedCollection)collectionBootDescriptor).getIndex() : collectionBootDescriptor.getElement();
        PersistentClass entityBinding = creationProcess.getCreationContext().getMetadata().getEntityBinding(elementTypeDescriptor.getEntityName());
        if (bootModelValue instanceof OneToMany) {
            String mappedByProperty = collectionDescriptor.getMappedByProperty();
            referencedPropertyName = StringHelper.isEmpty(mappedByProperty) ? null : mappedByProperty;
        } else {
            ToOne toOne = (ToOne)bootModelValue;
            referencedPropertyName = toOne.getReferencedPropertyName();
        }
        if (referencedPropertyName == null) {
            targetKeyPropertyNames = new HashSet<String>(2);
            targetKeyPropertyNames.add("{id}");
            Type propertyType = entityBinding.getIdentifierMapper() == null ? entityBinding.getIdentifier().getType() : entityBinding.getIdentifierMapper().getType();
            if (entityBinding.getIdentifierProperty() == null) {
                CompositeType compositeType2;
                if (propertyType.isComponentType() && (compositeType2 = (CompositeType)propertyType).isEmbedded() && compositeType2.getPropertyNames().length == 1) {
                    ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, compositeType2.getPropertyNames()[0], compositeType2.getSubtypes()[0], creationProcess.getCreationContext().getSessionFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, "{id}", propertyType, creationProcess.getCreationContext().getSessionFactory());
                } else {
                    ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, null, propertyType, creationProcess.getCreationContext().getSessionFactory());
                }
            } else {
                ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, entityBinding.getIdentifierProperty().getName(), propertyType, creationProcess.getCreationContext().getSessionFactory());
            }
            return targetKeyPropertyNames;
        }
        if (bootModelValue instanceof OneToMany) {
            targetKeyPropertyNames = new HashSet(2);
            int dotIndex = -1;
            while ((dotIndex = referencedPropertyName.indexOf(46, dotIndex + 1)) != -1) {
                targetKeyPropertyNames.add(referencedPropertyName.substring(0, dotIndex));
            }
            Type propertyType = ((PropertyMapping)((Object)elementTypeDescriptor.getEntityPersister())).toType(referencedPropertyName);
            ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames, referencedPropertyName, propertyType, creationProcess.getCreationContext().getSessionFactory());
            return targetKeyPropertyNames;
        }
        Type propertyType = entityBinding.getRecursiveProperty(referencedPropertyName).getType();
        if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
            HashSet<String> targetKeyPropertyNames2 = new HashSet<String>(2);
            ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames2, compositeType.getPropertyNames()[0], compositeType.getSubtypes()[0], creationProcess.getCreationContext().getSessionFactory());
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames2, "{id}", propertyType, creationProcess.getCreationContext().getSessionFactory());
            return targetKeyPropertyNames2;
        }
        HashSet<String> targetKeyPropertyNames3 = new HashSet<String>(2);
        targetKeyPropertyNames3.add("{id}");
        targetKeyPropertyNames3.add(referencedPropertyName);
        String mapsIdAttributeName = ToOneAttributeMapping.findMapsIdPropertyName(elementTypeDescriptor, referencedPropertyName);
        if (mapsIdAttributeName != null) {
            ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames3, mapsIdAttributeName, elementTypeDescriptor.getEntityPersister().getIdentifierType(), creationProcess.getCreationContext().getSessionFactory());
        } else {
            ToOneAttributeMapping.addPrefixedPropertyPaths(targetKeyPropertyNames3, null, propertyType, creationProcess.getCreationContext().getSessionFactory());
        }
        return targetKeyPropertyNames3;
    }
}

