/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scheduler;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.input.ReaderInputStream;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzBasicDataSource
extends BasicDataSource {
    private static Logger log = new Logger(QuartzBasicDataSource.class.getName());
    protected static Scheduler scheduler;
    public static final String SCHEDULER_FACTORY_SPRING_BEAN_CONFIG_PARAM = "scheduler.factory.springBean";
    public static final String SCHEDULER_FACTORY_CDI_BEAN_CONFIG_PARAM = "scheduler.factory.cdiBean";

    public DSResponse execute(DSRequest req) throws Exception {
        if (scheduler != null) {
            return super.execute(req);
        }
        DSResponse dsResponse = new DSResponse();
        dsResponse.setDataSource((DataSource)this);
        dsResponse.setStatus(-1);
        dsResponse.setData((Object)"No Quartz scheduler has been initialized.  Please refer to SmartClient documentation for context.");
        return dsResponse;
    }

    public void initialized() throws Exception {
        scheduler = QuartzBasicDataSource.getScheduler();
    }

    public static synchronized Scheduler getScheduler() throws Exception {
        if (scheduler == null) {
            scheduler = QuartzBasicDataSource.instantiateScheduler();
        }
        return scheduler;
    }

    protected static Scheduler instantiateScheduler() {
        try {
            String schedulerFactorySpringBeanName = config.getString((Object)SCHEDULER_FACTORY_SPRING_BEAN_CONFIG_PARAM, null);
            if (schedulerFactorySpringBeanName != null) {
                ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load((String)"ISpringBeanFactory");
                Object schedulerFactorySpringBean = beanFactory.getBean(ISCFile.servletContext, schedulerFactorySpringBeanName);
                if (schedulerFactorySpringBean == null) {
                    log.error((Object)("Unable to load Quartz Scheduler Factory via configured spring bean '" + schedulerFactorySpringBeanName + "' (as set by server.properties configuration parameter: scheduler.factory.springBean)"));
                    return null;
                }
                return (Scheduler)Reflection.invokeMethod((Object)schedulerFactorySpringBean, (String)"getScheduler");
            }
            String schedulerFactoryCDIBeanName = config.getString((Object)SCHEDULER_FACTORY_CDI_BEAN_CONFIG_PARAM, null);
            if (schedulerFactoryCDIBeanName != null) {
                ICDIBeanManager beanManager = (ICDIBeanManager)InterfaceProvider.load((String)"ICDIBeanManager");
                Object schedulerFactoryCDIBean = null;
                if (beanManager != null) {
                    schedulerFactoryCDIBean = beanManager.getBean(schedulerFactoryCDIBeanName);
                }
                if (schedulerFactoryCDIBean == null) {
                    log.error((Object)("Unable to load Quartz Scheduler Factory via configured CDI bean '" + schedulerFactoryCDIBeanName + "' (as set by server.properties configuration parameter: scheduler.factory.cdiBean)"));
                    return null;
                }
                return (Scheduler)Reflection.invokeMethod((Object)schedulerFactoryCDIBean, (String)"getScheduler");
            }
            StdSchedulerFactory factory = null;
            if (ISCFile.servletContext != null) {
                factory = (StdSchedulerFactory)ISCFile.servletContext.getAttribute("org.quartz.impl.StdSchedulerFactory.KEY");
            } else {
                String propertiesFilePath = config.getPath("quartz.pathToPropertiesFile");
                if (propertiesFilePath != null) {
                    ISCFile propertiesFile = ISCFile.newInstance((String)propertiesFilePath);
                    if (!propertiesFile.exists()) {
                        throw new Exception("Unable to open specified propertiesFile: " + propertiesFilePath);
                    }
                    log.info((Object)("Instantiating quartz factory with property file: " + propertiesFilePath));
                    Properties properties = new Properties();
                    properties.load((InputStream)new ReaderInputStream(propertiesFile.getReader()));
                    String pathToJobFile = config.getPath("quartz.pathToJobFile");
                    if (pathToJobFile != null) {
                        log.info((Object)("Overriding job initializer path to: " + pathToJobFile));
                        properties.setProperty("org.quartz.plugin.jobInitializer.fileNames", pathToJobFile);
                    }
                    factory = new StdSchedulerFactory(properties);
                }
            }
            if (factory == null) {
                return null;
            }
            return factory.getScheduler();
        }
        catch (Exception e) {
            log.error((Object)"Unable to instantiate Scheduler", (Throwable)e);
            return null;
        }
    }
}

