/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.ProjectLoadSettings;
import com.isomorphic.xml.Screen;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class Project
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Project.class.getName());
    private static String storageDS = config.getString("project.vbProjectsDS");
    private static String fileType = "proj";
    private static String fileFormat = "xml";
    DataTypeMap data;
    String xml;
    DataTypeMap metadata;

    public Project(String xml, Map metadata) throws Exception {
        this(Project.dataFromXML(xml), metadata);
        this.xml = xml;
    }

    public Project(Map data, Map metadata) {
        this.data = new DataTypeMap(data);
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
    }

    private static Map dataFromXML(String xml) throws Exception {
        return (Map)XML.toDSRecords(new StringReader(xml));
    }

    public static Project load(String name) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name));
    }

    public static Project load(String name, String ownerId) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId));
    }

    public static Project load(Object criteria) throws Exception {
        List<Project> resultsMatchingCriteria = Project.list(criteria);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            log.warn("Multiple Projects (" + resultsMatchingCriteria.size() + ") matched criteria for load() - using the latest one.  Criteria: " + DataTools.prettyPrint(criteria));
        }
        return resultsMatchingCriteria.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Project> list(Object criteria) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Project> results = new ArrayList<Project>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria, (Map)((Object)DataTools.buildMap("sortBy", "-fileLastModified")));
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Project(xml, metadata));
            }
        }
        finally {
            DataSourceManager.free(ds);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project persist() throws Exception {
        StringWriter sw = new StringWriter();
        String tagName = this.data.getString("__autoConstruct");
        if (tagName == null) {
            throw new Exception("Encountered top-level component with no _constructor: " + DataTools.prettyPrint(this));
        }
        DataSource transformDS = null;
        try {
            transformDS = DataSourceManager.get(tagName);
        }
        finally {
            DataSourceManager.free(transformDS);
        }
        XML.recordToXML(tagName, (Map)((Object)this.data), sw, false, false, transformDS, null);
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            Project project = Project.load(metadataAsSaved);
            return project;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void _persistXML() throws Exception {
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), this.xml);
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public long _persistMetadata() throws Exception {
        Date fileLastModified = (Date)this.metadata.get("fileLastModified");
        return (Long)Reflection.invokeStaticMethod("com.isomorphic.site.SandboxFilter", "setHostedRecordMetadata", storageDS, this.getName(), fileType, this.getOwner(), fileLastModified);
    }

    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project rename(String newName) throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            Project project = Project.load(metadataAsSaved);
            return project;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<String> getScreenNames() {
        return (List)this.data.xpathGetList("screens/root/children/fileName");
    }

    public List<Screen> getScreens() throws Exception {
        return this.getScreens(null);
    }

    public List<Screen> getScreens(ValidationContext vc) throws Exception {
        List<String> screenNames = this.getScreenNames();
        if (screenNames == null) {
            return null;
        }
        ArrayList<Screen> screens = new ArrayList<Screen>();
        for (String screenName : screenNames) {
            screens.add(Screen.load(screenName, this.getOwner(), false, vc));
        }
        return screens;
    }

    public String getCurrentScreenName() {
        return this.data.getString("currentScreenFileName");
    }

    public void setCurrentScreenName(String currentScreenName) {
        this.data.put("currentScreenFileName", currentScreenName);
    }

    public List<String> getDataSourceNames() {
        return (List)this.data.xpathGetList("datasources/dsName");
    }

    public String getAuthProvider() {
        Object o = this.data.xpathGetList("authentication/provider");
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ArrayList && !((ArrayList)o).isEmpty()) {
            return (String)((ArrayList)o).get(0);
        }
        return null;
    }

    public void setAuthProvider(String authProvider) {
        this.data.xpathSet("authentication/provider", authProvider);
    }

    public Map getAuthUser(String userId) {
        List users = (List)this.data.xpathGetList("authentication/users");
        for (Map user : users) {
            if (!userId.equals((String)user.get("userId"))) continue;
            return user;
        }
        return null;
    }

    public Map getAuthCurrentUser() {
        Object o = this.data.xpathGetList("authentication/lastSelectedUser");
        if (o == null) {
            return null;
        }
        String lastSelectedUser = null;
        if (o instanceof String) {
            lastSelectedUser = (String)o;
        }
        if (o instanceof ArrayList && !((List)o).isEmpty()) {
            lastSelectedUser = (String)((List)o).get(0);
        }
        if (lastSelectedUser != null) {
            return this.getAuthUser(lastSelectedUser);
        }
        return null;
    }

    public List<String> getAuthUserIds() {
        return (List)this.data.xpathGetList("authentication/users/userId");
    }

    public List<Map> getAuthUsers() {
        return (List)this.data.xpathGetList("authentication/users");
    }

    public List<String> getAuthAvailableRoleNames() {
        return (List)this.data.xpathGetList("authentication/availableRoles/name");
    }

    public List<Map> getAuthAvailableRoles() {
        return (List)this.data.xpathGetList("authentication/availableRoles");
    }

    public String getSkin() {
        return (String)this.data.get("skin");
    }

    public String getSkinUrl() {
        return (String)this.data.get("skinUrl");
    }

    public static Project _load(String name, String ownerId) throws Exception {
        Project project = null;
        String projectFile = DataStructCache.getInstanceFile(name, "project", "proj");
        if (projectFile != null) {
            String xml = ISCFile.newInstance(projectFile).getAsString();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("fileName", name);
            metadata.put("fileFormat", "xml");
            metadata.put("fileType", "proj");
            project = new Project(xml, metadata);
        }
        if (project == null) {
            project = ownerId == null ? Project.load(name) : Project.load(name, ownerId);
        }
        return project;
    }

    public static String getLoadScript(String projectName) throws Exception {
        return Project.getLoadScript(projectName, new ProjectLoadSettings());
    }

    public static String getLoadScript(String projectName, List<String> screenNames) throws Exception {
        ProjectLoadSettings settings = new ProjectLoadSettings();
        settings.setScreenNames(screenNames);
        return Project.getLoadScript(projectName, settings);
    }

    public static String getLoadScript(String projectNames, ProjectLoadSettings settings) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.setLocale(settings.getLocale());
        jsTrans.setObfuscation(false);
        StringWriter out = new StringWriter();
        List projects = Project.getResourcesMap(projectNames, settings, out);
        jsTrans.toJSVariable(projects, "projects", out);
        jsTrans.toJSVariable(settings.toMap(), "settings", out);
        jsTrans.toJSVariable(settings.getCallbackJS(), "callback", out);
        ((Writer)out).append("\nisc.RPCManager.loadProjectScreens(projects, settings, callback);\n");
        return ((Object)out).toString();
    }

    public static String loadExternalFiles(String projectNames, ProjectLoadSettings settings) throws Exception {
        return Project.getCustomJS(settings, "EXTERNAL_FILES_ONLY");
    }

    public static List getResourcesMap(String projectNames, ProjectLoadSettings settings, Writer scriptOut) throws Exception {
        boolean allowNonOwnerFetch = config.getBoolean((Object)"security.allowNonOwnerFetch", false);
        String ownerId = allowNonOwnerFetch ? null : settings.ownerId;
        String[] names = projectNames.split(",");
        if (names.length < 1) {
            throw new IllegalArgumentException("Invalid projectNames value supplied");
        }
        ArrayList<Map> data = new ArrayList<Map>();
        boolean first = true;
        for (int i = 0; i < names.length; ++i) {
            Project project = Project._load(names[i], ownerId);
            if (project == null) {
                log.warn("Project '" + names[i] + "' not found.  If the name is correct, please check that the project is shared with you.");
                continue;
            }
            data.add(project.getResourcesMap(settings, ownerId, first, scriptOut));
            first = false;
        }
        if (data.isEmpty()) {
            throw new Exception("Unable to load any of the projects: " + projectNames);
        }
        return data;
    }

    private String getDataSourceXML(String dsName) throws Exception {
        String dsConfigFile = DataStructCache.getInstanceFile(dsName, "datasources", "DS");
        if (dsConfigFile == null) {
            log.warn("Unable to locate the XML source for DataSsource " + dsName);
            return null;
        }
        Document doc = XML.getXMLDocument(dsConfigFile);
        if (doc == null) {
            log.warn("Unable to load the XML Source for DataSource " + dsName);
            return null;
        }
        return XML.toXML(doc.getDocumentElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getResourcesMap(ProjectLoadSettings settings, String ownerId, boolean first, Writer scriptOut) throws Exception {
        String customJS;
        List<String> firstNames;
        String current;
        LinkedHashSet<String> screenNames = new LinkedHashSet<String>();
        boolean singleMode = Boolean.TRUE == settings.getSingleScreenMode();
        String currentScreenName = this.getCurrentScreenName();
        String string = current = first ? settings.getCurrentScreenName() : null;
        if (current != null) {
            screenNames.add(current);
        }
        List<String> list = firstNames = first && !singleMode ? settings.getScreenNames() : null;
        if (firstNames != null) {
            if (current == null && firstNames.contains(currentScreenName)) {
                screenNames.add(currentScreenName);
            }
            screenNames.addAll(firstNames);
        }
        if (firstNames == null) {
            if (current == null) {
                screenNames.add(currentScreenName);
            }
            if (!singleMode) {
                screenNames.addAll(this.getScreenNames());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", this.getName());
        ArrayList<DataTypeMap> screens = new ArrayList<DataTypeMap>();
        map.put("screens", screens);
        ArrayList<DataTypeMap> dataSources = new ArrayList<DataTypeMap>();
        map.put("dataSources", dataSources);
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.setLocale(settings.getLocale());
        jsTrans.setObfuscation(false);
        boolean mockMode = Boolean.TRUE == settings.getMockMode();
        ValidationContext vc = new ValidationContext();
        vc.setRetrieverProject(this.getName());
        vc.setDSRequest(new DSRequest());
        vc.setExcludedDS(settings.getExcludedDS());
        Set<String> excludedDS = vc.getExcludedDS();
        boolean includeXML = settings.getIncludeXML() && config.isReify();
        try {
            for (String name : screenNames) {
                Screen screen = Screen._load(name, ownerId, mockMode, vc);
                if (screen == null) {
                    log.warn("Screen '" + name + "' not found.  If the name is correct, please check that the screen is shared with you.");
                    continue;
                }
                StringWriter out = new StringWriter();
                jsTrans.toJS((Object)screen.data, out);
                DataTypeMap screenEntry = DataTools.buildMap("ID", name, "code", ((Object)out).toString());
                if (includeXML) {
                    screenEntry.put("xml", screen.xml);
                }
                screens.add(screenEntry);
            }
            if (!vc.excludeAllDS()) {
                Map convertedDS = settings.getDataSourceOverrides();
                Map<String, DataSource> projectDS = vc.getProjectDataSources();
                for (String dsName : projectDS.keySet()) {
                    String code;
                    if (excludedDS != null && excludedDS.contains(dsName)) continue;
                    String xml = null;
                    if (convertedDS != null && convertedDS.containsKey(dsName)) {
                        code = (String)convertedDS.get(dsName);
                    } else {
                        DataSource dataSource = projectDS.get(dsName);
                        if (includeXML) {
                            xml = this.getDataSourceXML(dsName);
                        }
                        StringWriter out = new StringWriter();
                        jsTrans.toJS(dataSource, out);
                        code = ((Object)out).toString();
                    }
                    DataTypeMap dataSourceEntry = DataTools.buildMap("ID", dsName, "code", code);
                    if (xml != null) {
                        dataSourceEntry.put("xml", xml);
                    }
                    dataSources.add(dataSourceEntry);
                }
                List allDataSources = this.data.getList("datasources");
                DataTypeMap<String, Boolean> dsLookupFlags = new DataTypeMap<String, Boolean>();
                dsLookupFlags.put("forComponentXML", false);
                for (int i = 0; i < allDataSources.size(); ++i) {
                    Map dsMap = (Map)allDataSources.get(i);
                    String dsName = (String)dsMap.get("dsName");
                    if (projectDS.containsKey(dsName)) continue;
                    String xml = null;
                    BasicDataSource dataSource = vc.getType(dsName, dsLookupFlags);
                    if (includeXML) {
                        xml = this.getDataSourceXML(dsName);
                    }
                    StringWriter out = new StringWriter();
                    jsTrans.toJS(dataSource, out);
                    String code = ((Object)out).toString();
                    DataTypeMap dataSourceEntry = DataTools.buildMap("ID", dsName, "code", code);
                    if (xml != null) {
                        dataSourceEntry.put("xml", xml);
                    }
                    dataSources.add(dataSourceEntry);
                }
            }
        }
        finally {
            vc.freeResources();
            DSRequest dsRequest = vc.getDSRequest();
            if (dsRequest != null) {
                dsRequest.setRequestStarted(true);
                Map<String, DataSource> cachedInstances = dsRequest.getCachedDataSourceInstances();
                if (cachedInstances != null) {
                    Iterator<String> i = cachedInstances.keySet().iterator();
                    while (i.hasNext()) {
                        DataSourceManager.free(cachedInstances.get(i.next()));
                    }
                }
                dsRequest.getCachedDataSourceInstances().clear();
            }
        }
        if (settings.getIncludeSavedSearches()) {
            map.put("savedSearches", this.getSavedSearchesDataSource(settings, jsTrans));
        }
        if (this.data.get("skin") != null) {
            map.put("skin", this.data.get("skin"));
        }
        if (this.data.get("density") != null) {
            map.put("density", this.data.get("density"));
        }
        if (screens.isEmpty()) {
            throw new Exception("Unable to load any screens for project " + this.getName());
        }
        if (first && scriptOut != null) {
            String authProvider = this.getAuthProvider();
            Object currentUser = null;
            List<Object> userRoles = new ArrayList();
            List<Object> availableRoles = new ArrayList();
            if ("inlineSampleUsers".equals(authProvider)) {
                String roles;
                AuthenticatedUser authenticatedUser = settings.getCurrentUser();
                if (authenticatedUser != null) {
                    currentUser = authenticatedUser;
                    userRoles = authenticatedUser.getRoles();
                } else {
                    String roles2;
                    String testUserId = settings.getTestUserId();
                    if (testUserId != null && (currentUser = this.getAuthUser(testUserId)) != null && (roles2 = (String)currentUser.get("roles")) != null) {
                        userRoles = DataTools.simpleSplit(roles2, ",");
                    }
                }
                if (currentUser == null && (roles = (String)(currentUser = this.getAuthCurrentUser()).get("roles")) != null) {
                    userRoles = DataTools.simpleSplit(roles, ",");
                }
                availableRoles = this.getAuthAvailableRoleNames();
            } else if ("sql".equals(authProvider)) {
                AuthenticatedUser authenticatedUser = settings.getCurrentUser();
                currentUser = authenticatedUser;
                userRoles = authenticatedUser.getRoles();
                List dbRoles = new DSRequest("isc_hostedRoles", "fetch").execute().getRecords();
                for (Map record : dbRoles) {
                    availableRoles.add((String)record.get("name"));
                }
            }
            if (currentUser != null) {
                Object superUser;
                scriptOut.append("\nif (isc.Auth) {\n");
                jsTrans.setCurrentIndentDepth(1);
                scriptOut.append("    isc.Auth.setAvailableRoles(");
                jsTrans.toJS(availableRoles, scriptOut);
                scriptOut.append(");\n");
                scriptOut.append("    isc.Auth.setCurrentUser(");
                jsTrans.toJS(currentUser, scriptOut);
                scriptOut.append(");\n");
                if (userRoles != null) {
                    scriptOut.append("    isc.Auth.setRoles(");
                    jsTrans.toJS(userRoles, scriptOut);
                    scriptOut.append(");\n");
                }
                if ((superUser = currentUser.get("superUser")) == null) {
                    Boolean dbSuper = (Boolean)currentUser.get("isSuperUser");
                    if (dbSuper != null) {
                        superUser = dbSuper.toString();
                    }
                } else if (superUser instanceof Boolean) {
                    superUser = superUser.toString();
                }
                if (Boolean.parseBoolean((String)superUser)) {
                    scriptOut.append("    isc.Auth.setSuperUser(true);\n");
                }
                jsTrans.setCurrentIndentDepth(0);
                scriptOut.append("}\n");
            }
            scriptOut.append("\nif (isc.Auth) {\n");
            scriptOut.append("    isc.Auth.logOutURL='auth/logout.jsp';\n");
            scriptOut.append("    isc.Auth.resetPasswordURL='auth/login.jsp?emailPassword=true&USERNAME=${userId}';\n");
            scriptOut.append("}\n\n\n");
        }
        if (settings.getIncludeCustomizations() && !(customJS = Project.getCustomJS(settings, "SKIP_EXTERNAL_FILES")).isEmpty()) {
            map.put("customizations", customJS);
        }
        return map;
    }

    private Map getSavedSearchesDataSource(ProjectLoadSettings settings, JSTranslater jsTrans) {
        StringWriter out = new StringWriter();
        DataSource savedSearches = null;
        try {
            savedSearches = (DataSource)Reflection.invokeStaticMethod("com.isomorphic.datasource.SearchesDataSource", "getClientOnlyDataSource", this.getName(), settings.getOwnerId());
            jsTrans.toJS(savedSearches, out);
        }
        catch (Exception e) {
            log.error((Object)"failed to build client-only saved searches DataSource", e);
            return null;
        }
        log.info("successfully added saved searches to project as a client-only DataSource");
        return DataTools.buildMap("ID", savedSearches.getID(), "code", ((Object)out).toString());
    }

    private static Map getCustomJSUser(ProjectLoadSettings settings) {
        Object user = null;
        try {
            user = (Map)Reflection.invokeStaticMethod("com.isomorphic.site.SandboxFilter", "getRequestUserRecord", RequestContext.getThreadLocal());
        }
        catch (Exception e) {
            log.debug((Object)"Unable to get user record from the sandbox request context", e);
        }
        if (user != null) {
            log.info("Got user '" + String.valueOf(user.get("username")) + "' from sandbox request context");
            return user;
        }
        user = settings.getCurrentUser();
        if (user != null) {
            log.info("Got user '" + String.valueOf(user.get("username")) + "' from the ProjectLoadSettings");
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCustomJS(ProjectLoadSettings settings, String loadStyleRule) throws Exception {
        Map user = Project.getCustomJSUser(settings);
        if (user == null) {
            log.warn("Customizations not available; user account record not found");
            return "";
        }
        DataSource reifyCustomDS = DataSourceManager.get("isc_reifyCustomizations");
        if (reifyCustomDS == null) {
            log.warn("Customizations not available; isc_reifyCustomizations DS not found");
            return "";
        }
        try {
            Long devId = DataTools.getLong((Number)user.get("userid"));
            Long orgId = DataTools.getLong((Number)user.get("organizationId"));
            if (devId == null) {
                log.warn("user account is not a real Reify.com, Reify OnSite, or Smartclient account.  Customizations not available");
                String string = "";
                return string;
            }
            RequestContext context = RequestContext.getThreadLocal();
            DSField timingField = reifyCustomDS.getField("loadTiming");
            ArrayList<Object> loadTimings = new ArrayList<Object>((List)timingField.get("valueMap"));
            loadTimings.add(0, null);
            try {
                String string = (String)Reflection.invokeStaticMethod("com.isomorphic.tools.dmi.ReifyCustomizations", "getCustomJS", new Object[]{orgId, devId, loadTimings, orgId == null, loadStyleRule, context != null ? context.request : null});
                return string;
            }
            catch (Exception e) {
                log.info((Object)("Unable to retrieve customizations for user '" + String.valueOf(user.get("username")) + "'"), e);
                String string = "";
                DataSourceManager.free(reifyCustomDS);
                return string;
            }
        }
        finally {
            DataSourceManager.free(reifyCustomDS);
        }
    }
}

