/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.BuilderSpecifier;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.DriverConfiguration;
import com.isomorphic.autotest.InconsistentBatchRunTableException;
import com.isomorphic.autotest.LastPassBatchDao;
import com.isomorphic.autotest.SgwtRunnerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerDriver;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestShowcaseHelper;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessage;
import com.isomorphic.mail.TemplatedMailMessage;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;

public class TestRunner
extends ConfiguredBase {
    private static final int COMMIT_SEARCH_DEPTH = 50;
    private static Logger log = new Logger(TestRunner.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static int totalTests = 0;
    private static int passedTests = 0;
    private static int totalTestFiles = 0;
    private static int passedTestFiles = 0;
    private static List<TestResult> regressions = new ArrayList<TestResult>();
    private static List<TestResult> fixed = new ArrayList<TestResult>();
    private static String serverLogFileName = null;
    private static ArrayList<TestResult> localResults = null;

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)TestRunner.class.getName());
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        TestRunnerLauncher.addOptions(options);
        String details = "Sets the OPT for this batch run; it will be included in any commit to the BatchRun DS and in any email notification";
        options.addOption("un", "user-name", true, details.replaceFirst("OPT", "user name"));
        options.addOption("lg", "batch-log", true, details.replaceFirst("OPT", "log message"));
        options.addOption("re", "repeat-email", true, "Recipient(s) to email if no fixes or regressions have occurred in batch");
        options.addOption("ms", "mail-subject", true, "Subject line to use for email");
        options.addOption("se", "sender-email", true, "Sender email address to set for all batch reports");
        options = TestRunnerLauncher.filterAndAddOptions(options, DriverConfiguration.class);
        options.addOption("lp", "piped-log", false, "Signals that a log message will be piped to stdin of the TestRunner process. Message itself used identically to that of -lg option");
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp("[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options, moe.getMessage());
            return;
        }
        if (line.hasOption("h")) {
            Utils.outputHelp("[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options);
            System.exit(0);
        }
        TestRunnerLauncher.launch(null, line, "[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options, TestRunnerDriver.class);
        System.exit(0);
    }

    protected static void testAll(final Date batchStartTime, String browser, boolean storeToDb, boolean noSelenium, boolean noUsualTests, boolean batch, final String suiteName, final String branch, String[] scripts) {
        TestRunnerHelper.TestCallback callback = new TestRunnerHelper.TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                int notificationCount = testCaseResults.getNotificationCount();
                if (testCaseResults.isTimeoutError()) {
                    int timeout = testCaseResults.getTimeoutInSeconds();
                    log.error((Object)(testCaseResults.getTestName() + ": test failed due to timeout"));
                    if (localResults != null) {
                        TestResult timeoutResult = new TestResult();
                        timeoutResult.setIdentifiers(branch, suiteName, batchStartTime);
                        timeoutResult.setResult("timeout");
                        String details = "TestCase results have not appeared after " + timeout + " seconds" + testCaseResults.getPartialReport();
                        timeoutResult.setDetails(details);
                        timeoutResult.setStartTime(testCaseResults.getStartTime());
                        timeoutResult.setEndTime(testCaseResults.getEndTime());
                        timeoutResult.setTestNumber(1);
                        timeoutResult.setTestFile(testCaseResults.getTestName());
                        timeoutResult.setNotificationCount(notificationCount);
                        localResults.add(timeoutResult);
                    }
                } else if (testCaseResults.getUnparsableResponse() != null) {
                    log.error((Object)(testCaseResults.getTestName() + ": test response incorrect:\n" + testCaseResults.getUnparsableResponse()));
                    if (localResults != null) {
                        TestResult unparseableResult = new TestResult();
                        unparseableResult.setIdentifiers(branch, suiteName, batchStartTime);
                        unparseableResult.setResult("failure");
                        unparseableResult.setDetails("TestCase results contains unparseable data.");
                        unparseableResult.setStartTime(testCaseResults.getStartTime());
                        unparseableResult.setEndTime(testCaseResults.getEndTime());
                        unparseableResult.setNotificationCount(notificationCount);
                        localResults.add(unparseableResult);
                    }
                } else if (testCaseResults.getSeleniumError() != null) {
                    log.error((Object)(testCaseResults.getTestName() + ": Selenium exception reported:\n" + testCaseResults.getSeleniumError()));
                    if (localResults != null) {
                        TestResult errorResult = new TestResult();
                        errorResult.setIdentifiers(branch, suiteName, batchStartTime);
                        errorResult.setResult("failure");
                        errorResult.setDetails("Selenium error:\n" + testCaseResults.getSeleniumError());
                        errorResult.setStartTime(testCaseResults.getStartTime());
                        errorResult.setEndTime(testCaseResults.getEndTime());
                        errorResult.setTestNumber(1);
                        errorResult.setTestFile(testCaseResults.getTestName());
                        errorResult.setNotificationCount(notificationCount);
                        localResults.add(errorResult);
                    }
                } else {
                    log.info((Object)("results for " + testCaseResults.getTestName() + ":"));
                    for (TestResult tr : testCaseResults.getTestResults()) {
                        if (TestResult.isFailure(tr.getResult())) {
                            log.error((Object)("error: " + tr.getDetails()));
                        } else {
                            log.info((Object)(tr.getResult() + ": " + tr.getDetails()));
                        }
                        if (localResults == null) continue;
                        tr.setIdentifiers(branch, suiteName, batchStartTime);
                        localResults.add(tr);
                    }
                }
            }
        };
        if (!ShowcaseSpecifier.isShowcaseValid(suiteName)) {
            TestRunnerHelper.testAll(browser, !noSelenium, !noUsualTests, scripts, suiteName, batch, callback);
        } else {
            ShowcaseSpecifier specifier = new ShowcaseSpecifier(suiteName);
            if (specifier.isSmartGWTRunner()) {
                SgwtRunnerHelper.testAll(browser, scripts, specifier, callback);
            } else {
                TestShowcaseHelper.testAll(browser, !noSelenium, !noUsualTests, scripts, specifier, callback);
            }
        }
        TestRunner.filterLocalResults();
        if (config.shouldSaveServerLogs() && config.shouldEmailServerLogs()) {
            TestRunner.generateServerLogFile(suiteName, batchStartTime);
        }
        for (TestResult tr : localResults) {
            tr.formatDetailsAndLogs();
        }
        if (storeToDb) {
            try {
                for (TestResult tr : localResults) {
                    TestResultDao.add(new TestResult(tr, true));
                }
            }
            catch (Exception e) {
                log.error((Object)"unable to persist test results", (Throwable)e);
            }
        }
    }

    protected static void generateServerLogFile(String suiteName, Date batchStartTime) {
        suiteName = TestRunner.getSuiteNameAsUrlParameter(suiteName);
        String fileName = tmpDir + "/" + suiteName + "-server-logs.txt";
        try {
            new File(fileName).delete();
            if (((TestRunnerLauncher)config).onJenkinsServer()) {
                String instanceId = BatchRunDao.getAwsInstanceId(batchStartTime);
                Utils.dumpStringToFile(fileName, "********** Jenkins Instance #" + instanceId + " Logs for Test Suite " + suiteName + " **********\n");
            }
            int nTotalLogs = 0;
            for (TestResult tr : localResults) {
                String logs = tr.getServerLogs();
                if (logs == null || logs.length() == 0) continue;
                Utils.dumpStringToFile(fileName, ">>> " + tr.getTestFile() + " #" + tr.getTestNumber() + "\n");
                Utils.dumpStringToFile(fileName, logs);
                ++nTotalLogs;
            }
            if (nTotalLogs > 0) {
                serverLogFileName = fileName;
            } else {
                new File(fileName).delete();
            }
        }
        catch (Exception e) {
            log.error((Object)("failed to create server log file " + fileName), (Throwable)e);
        }
    }

    protected static void testUrl(Date batchStartTime, String url, String browser, boolean storeToDb, String suiteName, String branch) {
        log.info((Object)("testing " + url));
        TestCaseResults results = TestRunnerHelper.test(url, browser);
        if (results == null) {
            log.warn((Object)"test disabled");
        } else if (results.isTimeoutError()) {
            log.error((Object)"test failed due timeout");
        } else {
            for (TestResult tr : results.getTestResults()) {
                if (TestResult.isFailure(tr.getResult())) {
                    log.error((Object)("error: " + tr.getDetails()));
                } else {
                    log.info((Object)(tr.getResult() + ": " + tr.getDetails()));
                }
                if (!storeToDb && localResults == null) continue;
                try {
                    tr.setIdentifiers(branch, suiteName, batchStartTime);
                    if (storeToDb) {
                        TestResultDao.add(tr);
                        continue;
                    }
                    localResults.add(tr);
                }
                catch (Exception e) {
                    log.error((Object)"unable to persist test results", (Throwable)e);
                }
            }
        }
    }

    protected static void createBatchRunRecord(Date batchStartTime, String batchLog, String user, String suiteName, String branch, boolean parseLog) throws Exception {
        BatchRunDao.add(batchStartTime, user, suiteName, branch, parseLog ? Utils.getModifiedFilesFromCommitSpam(batchLog) : "", batchLog);
    }

    protected static void completeBatchRunRecord(Date batchStartTime) throws Exception {
        BatchRunDao.setBatchEndTime(batchStartTime);
    }

    private static Exception sendDifferencesEmail(TemplatedMailMessage message) {
        try {
            message.send();
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception trying to send differences email", (Throwable)e);
            return e;
        }
        return null;
    }

    protected static void sendLocalDifferencesEmail(String alertEmail, String repeatEmail, String ccEmail, String timestamp, String suiteName, String branch) throws Exception {
        boolean important;
        List<BatchResults> lastBatches = TestRunner.lastBatchesForTimestamp(timestamp, suiteName, branch, 1);
        boolean firstBatchFound = lastBatches.size() > 0;
        List<Object> firstBatch = firstBatchFound ? lastBatches.get(0).getResults() : new ArrayList();
        TestRunner.compareBatches(localResults, firstBatch);
        TestRunner.sortTestResults();
        TemplatedMailMessage msg = new TemplatedMailMessage();
        boolean bl = important = fixed.size() > 0 || regressions.size() > 0;
        if (!TestRunner.addEmailRecipients(msg, alertEmail, repeatEmail, ccEmail, important)) {
            return;
        }
        TestRunner.setEmailSubjectAndFromField((MailMessage)msg, "Local", suiteName, firstBatchFound, null, null, null, null);
        msg.addHeader("Content-Type", "text/html");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fixed", fixed);
        dataMap.put("regression", regressions);
        if (TestRunner.hasMultipleTestsPerFile(suiteName)) {
            dataMap.put("totalTests", totalTests);
            dataMap.put("passedTests", passedTests);
        }
        dataMap.put("totalTestFiles", totalTestFiles);
        dataMap.put("passedTestFiles", passedTestFiles);
        dataMap.put("firstBatchFound", firstBatchFound);
        msg.setContextMap(dataMap);
        if (serverLogFileName != null) {
            TestRunner.addZippedFileToMailMessage((MailMessage)msg, serverLogFileName);
        }
        String mailTemplate = config.getMailTemplate();
        msg.setTemplateFile(mailTemplate);
        msg.buildMessage(dataMap, mailTemplate);
        TestRunner.sendDifferencesEmail(msg);
    }

    private static void sendDifferencesEmailInternal(String alertEmail, String repeatEmail, String ccEmail, List<BatchResults> batchesToCompare, String user, String batchLog, String cvsDate, String suiteName, String branch, String newState) throws Exception {
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        log.info((Object)("email targets: " + alertEmail + ", " + repeatEmail + ", " + ccEmail));
        if (batchesToCompare.size() > 1) {
            boolean important;
            BatchResults newBatch = batchesToCompare.get(0);
            BatchResults oldBatch = batchesToCompare.get(1);
            TestRunner.compareBatches(newBatch.getResults(), oldBatch.getResults());
            int nHistoricalResults = config.getHistoryDepth();
            if (nHistoricalResults > 0) {
                List changes;
                int lastAnalyzedBatch;
                List<TestResult> wobblers = newBatch.getWobblers();
                if (wobblers.size() > 0 && (lastAnalyzedBatch = TestRunner.addHistoryForChanges(oldBatch.getBatchStartTime(), suiteName, branch, nHistoricalResults, wobblers, true)) >= 0) {
                    TestRunner.suppressWobblers(wobblers, lastAnalyzedBatch);
                }
                if ((changes = ListUtils.union(regressions, fixed)).size() > 0) {
                    TestRunner.addHistoryForChanges(oldBatch.getBatchStartTime(), suiteName, branch, nHistoricalResults, changes, false);
                }
            }
            TestRunner.sortTestResults();
            TemplatedMailMessage msg = new TemplatedMailMessage();
            boolean bl = important = fixed.size() > 0 || regressions.size() > 0;
            if (!TestRunner.addEmailRecipients(msg, alertEmail, repeatEmail, ccEmail, important)) {
                return;
            }
            Date newBatchStartTime = newBatch.getBatchStartTime();
            TestRunner.setEmailSubjectAndFromField((MailMessage)msg, "Auto", suiteName, true, user, newBatchStartTime, launcher.extractCommitMessage(batchLog), branch);
            msg.addHeader("Content-Type", "text/html");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("fixed", fixed);
            dataMap.put("regression", regressions);
            if (important && "R!".equalsIgnoreCase(newState)) {
                dataMap.put("bestEffortDiff", true);
            }
            if (config.canParseLog(suiteName)) {
                if (Utils.isCvsSpam(batchLog)) {
                    int bodyIndex = batchLog.indexOf("<body>") + "<body>".length();
                    String cvsSpamHeader = batchLog.substring(0, bodyIndex);
                    String cvsSpamFooter = batchLog.substring(bodyIndex);
                    dataMap.put("cvsSpamHeader", cvsSpamHeader);
                    dataMap.put("cvsSpamFooter", cvsSpamFooter);
                    dataMap.put("rcsName", "CVS");
                } else {
                    dataMap.put("cvsSpamFooter", batchLog);
                    dataMap.put("rcsName", "SVN");
                }
                dataMap.put("cvsCommitDate", cvsDate);
            } else {
                dataMap.put("batchLog", batchLog);
            }
            if (TestRunner.hasMultipleTestsPerFile(suiteName)) {
                dataMap.put("totalTests", totalTests);
                dataMap.put("passedTests", passedTests);
            }
            dataMap.put("firstBatchFound", true);
            dataMap.put("totalTestFiles", totalTestFiles);
            dataMap.put("passedTestFiles", passedTestFiles);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dataMap.put("batchStartTime", dateFormat.format(newBatchStartTime));
            dataMap.put("branch", branch);
            dataMap.put("batchMillis", newBatch.getBatchStartTime().getTime());
            dataMap.put("suiteName", TestRunner.getSuiteNameAsUrlParameter(suiteName));
            msg.setContextMap(dataMap);
            if (serverLogFileName != null) {
                TestRunner.addZippedFileToMailMessage((MailMessage)msg, serverLogFileName);
            }
            String mailTemplate = config.getMailTemplate();
            msg.setTemplateFile(mailTemplate);
            msg.buildMessage(dataMap, mailTemplate);
            TestRunner.sendDifferencesEmail(msg);
        }
    }

    protected static void sendDifferencesEmailFromBatchTimes(String user, String alertEmail, final Date batchStartTimeNew, final Date batchStartTimeOld, String cvsSpam, String cvsDate, String suiteName, String branch, String newState) throws Exception {
        final List<TestResult> newTests = TestResultDao.getTestsForBatch(batchStartTimeNew, suiteName, branch);
        final List<TestResult> oldTests = TestResultDao.getTestsForBatch(batchStartTimeOld, suiteName, branch);
        if (oldTests == null || oldTests.size() == 0) {
            log.error((Object)("Older test results can't be found for " + String.valueOf(batchStartTimeOld) + ", test suite " + suiteName + ", branch " + branch + "!"));
            return;
        }
        if (newTests == null || newTests.size() == 0) {
            log.error((Object)("Newer test results can't be found for " + String.valueOf(batchStartTimeNew) + ", test suite " + suiteName + ", branch " + branch + "!"));
            return;
        }
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        TestRunner.sendDifferencesEmailInternal(alertEmail, launcher.getRepeatEmail(), launcher.getCcEmail(), (List<BatchResults>)new ArrayList<BatchResults>(){
            {
                this.add(new BatchResults(batchStartTimeNew, newTests));
                this.add(new BatchResults(batchStartTimeOld, oldTests));
            }
        }, user, cvsSpam, cvsDate, suiteName, branch, newState);
        BatchRunDao.setState(batchStartTimeNew, suiteName, newState);
        log.info((Object)("Changed the state of batch " + String.valueOf(batchStartTimeNew) + " to " + newState));
    }

    protected static void sendDifferencesEmail(String alertEmail, String repeatEmail, String ccEmail, String user, String timestamp, String batchLog, String cvsDate, String suiteName, String branch, Date batchStartTime, boolean onAwsServer) throws Exception {
        if (!onAwsServer) {
            List<BatchResults> lastBatches = TestRunner.lastBatchesForTimestamp(timestamp, suiteName, branch, 2);
            TestRunner.sendDifferencesEmailInternal(alertEmail, repeatEmail, ccEmail, lastBatches, user, batchLog, cvsDate, suiteName, branch, null);
            return;
        }
        log.info((Object)("Beginning sendDifferencesEmail processing for batch " + String.valueOf(batchStartTime)));
        BatchRunDao.assertState(batchStartTime, suiteName, "t");
        Date predecessorBatchTime = BatchRunDao.getPredecessorBatchStartTime(batchStartTime, branch);
        if (predecessorBatchTime == null) {
            throw new InconsistentBatchRunTableException("No predecessor found for " + String.valueOf(batchStartTime) + ", branch " + branch);
        }
        String predecessorState = BatchRunDao.getState(predecessorBatchTime, suiteName);
        log.info((Object)("Predecessor for batch " + String.valueOf(batchStartTime) + ", batch " + String.valueOf(predecessorBatchTime) + " has state " + predecessorState));
        if (Utils.matchRegExp("(?i)T|R", predecessorState)) {
            TestRunner.sendDifferencesEmailFromBatchTimes(user, alertEmail, batchStartTime, predecessorBatchTime, batchLog, cvsDate, suiteName, branch, "r");
            log.info((Object)("Attempted to send differences email for batches " + String.valueOf(batchStartTime) + " (current) and " + String.valueOf(predecessorBatchTime) + " (predecessor)"));
        } else {
            log.info((Object)("Predecessor batch " + String.valueOf(predecessorBatchTime) + " current state doesn't permit us to send out a differences email"));
        }
        TestRunner.clearTestResults();
        Date successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(batchStartTime, branch);
        if (successorBatchTime != null) {
            TestRunnerLauncher.InstanceProperties properties;
            String successorState = BatchRunDao.getState(successorBatchTime, suiteName);
            log.info((Object)("The successor batch " + String.valueOf(successorBatchTime) + " has state " + successorState));
            if (successorState != null && successorState.equals("T") && !BuilderSpecifier.isReifyCloud(suiteName) && (properties = TestRunnerLauncher.getInstanceProperties(successorBatchTime, true)) != null) {
                TestRunner.sendDifferencesEmailFromBatchTimes(properties.instanceUsername, properties.instanceEmail, properties.instanceBatchTime, batchStartTime, properties.instanceCvsSpam, properties.instanceCvsDate, suiteName, branch, "R");
                log.info((Object)("Attempted to send differences email for batches " + String.valueOf(successorBatchTime) + " (successor) and " + String.valueOf(batchStartTime) + " (current)"));
            }
        }
        log.info((Object)("Completed sendDifferencesEmail processing for batch " + String.valueOf(batchStartTime)));
    }

    protected static String reportAndValidateBatch(Date currentBatchStartTime, Date earlierBatchStartTime, String suiteName, String branch, String validatedState, String validatedMessage, String earlierBatchType) throws Exception {
        String earlierState;
        if (earlierBatchStartTime != null && Utils.matchRegExp("(?i)T|R", earlierState = BatchRunDao.getState(earlierBatchStartTime, suiteName))) {
            if (BuilderSpecifier.isReifyCloud(suiteName)) {
                TestRunner.sendDifferencesEmailFromBatchTimes(null, ((TestRunnerLauncher)config).getAlertEmail(), currentBatchStartTime, earlierBatchStartTime, null, null, suiteName, branch, validatedState);
            } else {
                TestRunnerLauncher.InstanceProperties properties = TestRunnerLauncher.getInstanceProperties(currentBatchStartTime, false);
                if (properties != null) {
                    TestRunner.sendDifferencesEmailFromBatchTimes(properties.instanceUsername, properties.instanceEmail, currentBatchStartTime, earlierBatchStartTime, properties.instanceCvsSpam, properties.instanceCvsDate, suiteName, branch, validatedState);
                    log.info((Object)("Attempted to send failsafe " + validatedMessage + " for batches " + String.valueOf(currentBatchStartTime) + " (current) and " + String.valueOf(earlierBatchStartTime) + " " + earlierBatchType));
                }
            }
        }
        return BatchRunDao.getState(currentBatchStartTime, suiteName);
    }

    protected static void validateCommitRecord(Date batchStartTime, String branch) throws Exception {
        if (BatchRunDao.isBatchValidated(batchStartTime) || !TestRunnerLauncher.isBranchApproved(branch)) {
            return;
        }
        Date predecessorBatchTime = BatchRunDao.getPredecessorBatchStartTime(batchStartTime, branch);
        Object failsafeReport = "";
        List<String> suiteNames = ShowcaseSpecifier.getValidShowcases(branch, batchStartTime);
        suiteNames.addAll(BuilderSpecifier.getCommitBuilders(branch, batchStartTime));
        log.info((Object)("Beginning validateCommitRecord for batch " + String.valueOf(batchStartTime)));
        for (int i = 0; i < suiteNames.size(); ++i) {
            String suiteName = suiteNames.get(i);
            String description = BuilderSpecifier.isBuilderValid(suiteName) ? BuilderSpecifier.getPrintableBuilderDescription(suiteName) : ShowcaseSpecifier.getPrintableShowcaseDescription(suiteName);
            TestRunner.configureServerLogFile(suiteName, batchStartTime);
            String state = BatchRunDao.getState(batchStartTime, suiteName);
            if ("T".equalsIgnoreCase(state)) {
                state = TestRunner.reportAndValidateBatch(batchStartTime, predecessorBatchTime, suiteName, branch, "R", "differences email", "(predecessor)");
            }
            if ("T".equalsIgnoreCase(state)) {
                Date latestComparableBatchTime = BatchRunDao.getLatestPassingBatchStartTime(batchStartTime, suiteName, branch, null);
                state = TestRunner.reportAndValidateBatch(batchStartTime, latestComparableBatchTime, suiteName, branch, "R!", "best-effort differences email", "(earlier)");
            }
            if (state == null) {
                failsafeReport = (String)failsafeReport + description + " never launched<br>";
            } else if ("L".equalsIgnoreCase(state)) {
                failsafeReport = (String)failsafeReport + description + " failed before completion<br>";
            } else if ("T".equalsIgnoreCase(state)) {
                failsafeReport = (String)failsafeReport + description + " did not report test result differences<br>";
            }
            TestRunner.clearTestResults();
        }
        BatchRunDao.updateBatchStatus(batchStartTime, "awsCrash", true);
        String status = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus");
        if (((String)failsafeReport).length() == 0 && "smartGwtEeJavaDocFailed".equals(status)) {
            failsafeReport = "SmartGWT EE JavaDoc build failed<br>";
        }
        if (((String)failsafeReport).length() > 0) {
            String currentInstanceId = BatchRunDao.getAwsInstanceId(batchStartTime);
            String predecessorInstanceId = BatchRunDao.getAwsInstanceId(predecessorBatchTime);
            log.info((Object)("Sending a report of commit record for batch " + String.valueOf(batchStartTime)));
            Process reportShell = Runtime.getRuntime().exec(new String[]{"reportCommitDebug.sh", failsafeReport, currentInstanceId, predecessorInstanceId});
            int exitCode = reportShell.waitFor();
            if (exitCode != 0) {
                log.warn((Object)("Reporting of the commit record for batch " + String.valueOf(batchStartTime) + " has failed with code " + exitCode));
            }
        }
        log.info((Object)("Completed validateCommitRecord for batch " + String.valueOf(batchStartTime)));
    }

    protected static void configureServerLogFile(String suiteName, Date batchStartTime) {
        suiteName = TestRunner.getSuiteNameAsUrlParameter(suiteName);
        String awsId = BatchRunDao.getAwsInstanceId(batchStartTime);
        String fileName = "/shared/autotest/awslogs/" + suiteName + "-server-logs-" + awsId + ".txt";
        try {
            if (new File(fileName).exists()) {
                serverLogFileName = fileName;
            }
        }
        catch (Exception e) {
            log.error((Object)("failed to find server log file " + fileName), (Throwable)e);
        }
    }

    protected static void collectLocalResults() {
        localResults = new ArrayList();
    }

    private static void filterLocalResults() {
        if (localResults == null) {
            return;
        }
        HashMap<String, TestResult> resultSet = new HashMap<String, TestResult>();
        ArrayList<TestResult> filteredResults = new ArrayList<TestResult>();
        for (TestResult tr : localResults) {
            if (resultSet.get(tr.getTestKey()) != null) continue;
            resultSet.put(tr.getTestKey(), tr);
            filteredResults.add(tr);
        }
        localResults = filteredResults;
    }

    protected static Map<String, TestResult> processBatch(List<TestResult> firstBatch) {
        HashMap<String, TestResult> result = new HashMap<String, TestResult>();
        for (TestResult testResult : firstBatch) {
            result.put(testResult.getTestKey(), testResult);
        }
        return result;
    }

    private static String getRootResult(Map<String, TestResult> results, String testFile) {
        TestResult root;
        if (results != null && testFile != null && (root = results.get(testFile + "_1")) != null) {
            return root.getResult();
        }
        return null;
    }

    private static List<BatchResults> lastBatchesForTimestamp(String timestamp, String suiteName, String branch, int nRequired) throws Exception {
        Date targetBatch = timestamp == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(timestamp);
        return TestRunner.lastBatchesForTimestamp(targetBatch, suiteName, branch, nRequired);
    }

    private static List<BatchResults> lastBatchesForTimestamp(Date targetBatch, String suiteName, String branch, int nRequired) throws Exception {
        ArrayList<BatchResults> lastBatches = new ArrayList<BatchResults>();
        if (targetBatch == null || nRequired > 2) {
            log.info((Object)("looking for last batch with " + config.getBatchRunDS() + " record"));
            List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
            int nCommitsToSearch = targetBatch != null ? commits.size() : Math.min(commits.size(), 50);
            for (int i = 0; i < nCommitsToSearch && lastBatches.size() < nRequired; ++i) {
                List<TestResult> results;
                Date batchStartTime = commits.get(i);
                if (targetBatch != null && targetBatch.compareTo(batchStartTime) < 0 || (results = TestResultDao.getTestsForBatch(batchStartTime, suiteName, branch)).size() <= 0 && targetBatch == null) continue;
                lastBatches.add(new BatchResults(batchStartTime, results));
            }
        } else {
            log.info((Object)("looking for batch created at " + String.valueOf(targetBatch)));
            List<Date> batchTimes = TestResultDao.getLastBatchesTime(suiteName, branch);
            if (batchTimes.size() >= nRequired) {
                int startIndex = 0;
                if (nRequired > 1) {
                    Date last = batchTimes.get(0);
                    lastBatches.add(new BatchResults(last, TestResultDao.getTestsForBatch(last, suiteName, branch)));
                    ++startIndex;
                }
                Date closest = null;
                for (int i = startIndex; i < batchTimes.size(); ++i) {
                    Date bt = batchTimes.get(i);
                    if (closest != null && Math.abs(targetBatch.getTime() - closest.getTime()) <= Math.abs(targetBatch.getTime() - bt.getTime())) continue;
                    closest = bt;
                }
                lastBatches.add(new BatchResults(closest, TestResultDao.getTestsForBatch(closest, suiteName, branch)));
            }
        }
        return lastBatches;
    }

    protected static int addHistoryForChanges(Date batchStartTime, String suiteName, String branch, int nBatches, List<TestResult> changes, boolean skipLinks) throws Exception {
        List<BatchResults> historicalBatches = TestRunner.lastBatchesForTimestamp(batchStartTime, suiteName, branch, nBatches);
        Map<String, TestResult> changeMap = TestRunner.processBatch(changes);
        for (TestResult testResult : changes) {
            testResult.setPastResults(null);
        }
        int lastAnalyzedBatch = -1;
        for (int i = 0; i < historicalBatches.size() && changeMap.size() > 0; ++i) {
            BatchResults currentBatch = historicalBatches.get(i);
            HashSet<TestResult> currentChanges = new HashSet<TestResult>(changeMap.values());
            Date currentBatchStartTime = currentBatch.getBatchStartTime();
            boolean isAnalyzed = BatchRunDao.isBatchAnalyzed(currentBatchStartTime);
            if (isAnalyzed && lastAnalyzedBatch < 0) {
                lastAnalyzedBatch = i;
            }
            for (TestResult testResult : currentBatch.getResults()) {
                String testFile = testResult.getTestFile();
                String key = testResult.getTestKey();
                TestResult change = changeMap.get(key);
                if (change == null || !currentChanges.contains(change)) continue;
                String openAnchor = testResult.isDisabled() || skipLinks ? null : Utils.linkify(branch, currentBatchStartTime, suiteName, testFile, false, testResult.isSuccess() ? "green" : "red");
                change.addPastResult(testResult.getResult(), openAnchor);
                currentChanges.remove(change);
                if (isAnalyzed && !skipLinks) continue;
            }
            String flag = BatchRunDao.isTestSuiteDone(currentBatchStartTime, suiteName) ? "-" : "?";
            for (TestResult testResult : currentChanges) {
                testResult.addPastResult(flag, null);
            }
        }
        for (TestResult testResult : changes) {
            boolean hasHistory = testResult.setPastResults();
            if (hasHistory) continue;
            testResult.setNotificationCount(0);
        }
        return lastAnalyzedBatch;
    }

    private static void addZippedFileToMailMessage(MailMessage message, String serverLogFilePath) throws IOException {
        final String serverLogFileName = new File(serverLogFilePath).getName();
        File zipFile = Files.createTempFile("attachment-", ".zip", new FileAttribute[0]).toFile();
        zipFile.deleteOnExit();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
             FileInputStream fileIn = new FileInputStream(serverLogFilePath);){
            int len;
            ZipEntry entry = new ZipEntry(serverLogFileName);
            zipOut.putNextEntry(entry);
            byte[] buffer = new byte[8192];
            while ((len = fileIn.read(buffer)) != -1) {
                zipOut.write(buffer, 0, len);
            }
            zipOut.closeEntry();
        }
        FileDataSource fds = new FileDataSource(zipFile){

            public String getName() {
                return serverLogFileName + ".zip";
            }
        };
        message.addAttachment((DataSource)fds);
    }

    private static Boolean getCurrentWobblerStatus(String history, int countState, int notificationCount) {
        Integer resultLevel;
        Boolean state;
        if (countState > 0) {
            state = true;
            resultLevel = notificationCount - countState;
        } else {
            state = false;
            resultLevel = notificationCount + countState;
        }
        for (int i = history.length() - 1; i >= 0; --i) {
            boolean isPass;
            char result = history.charAt(i);
            if (result != 'F' && result != 'O' && result != 'P') continue;
            boolean bl = isPass = result == 'P';
            if (state != isPass) {
                Integer n = resultLevel;
                resultLevel = resultLevel + 1;
                if (resultLevel < notificationCount) continue;
                state = isPass;
                resultLevel = 0;
                if (i != 0) continue;
                return state;
            }
            resultLevel = 0;
        }
        return null;
    }

    private static void suppressWobblers(List<TestResult> wobblers, int lastAnalyzedBatch) {
        LastPassBatchDao.fetchLastPass(wobblers);
        for (TestResult testResult : wobblers) {
            Object history = testResult.getPastResults();
            if (((String)history).length() < lastAnalyzedBatch) {
                lastAnalyzedBatch = ((String)history).length() - 1;
            }
            history = ((String)history).substring(0, lastAnalyzedBatch);
            String currentResult = "";
            if (testResult.isSuccess()) {
                currentResult = "P";
            } else if (testResult.isFailure()) {
                currentResult = "F";
            }
            history = currentResult + (String)history;
            int countState = testResult.getResultCountState();
            if (countState == 0) continue;
            Boolean status = TestRunner.getCurrentWobblerStatus((String)history, countState, testResult.getNotificationCount());
            if (status == null || !status.booleanValue()) {
                fixed.remove(testResult);
            } else if (!fixed.contains(testResult)) {
                fixed.add(testResult);
            }
            if (status == null || status.booleanValue()) {
                regressions.remove(testResult);
                continue;
            }
            if (regressions.contains(testResult)) continue;
            regressions.add(testResult);
        }
    }

    protected static void compareBatches(List<TestResult> firstBatch, List<TestResult> secondBatch) {
        Map<String, TestResult> secondBatchTests = TestRunner.processBatch(secondBatch);
        HashSet<String> passedTestFileSet = new HashSet<String>();
        for (TestResult test : firstBatch) {
            passedTestFileSet.add(test.getTestFile());
        }
        totalTestFiles = passedTestFileSet.size();
        Map<String, String> lastResults = null;
        for (TestResult first : firstBatch) {
            ++totalTests;
            String testName = first.getTestKey();
            TestResult second = secondBatchTests.get(testName);
            if (first != null && first.isSuccess()) {
                ++passedTests;
            } else {
                passedTestFileSet.remove(first.getTestFile());
            }
            if (first == null) continue;
            if (second == null) {
                String lastResult;
                if (lastResults == null) {
                    lastResults = LastPassBatchDao.getLastTestResults(secondBatch);
                }
                if ((lastResult = lastResults.get(first.getTestKey())) != null) {
                    second = new TestResult();
                    second.setResult(lastResult);
                }
            }
            if (second != null) {
                if (TestResult.isFix(first.getResult(), second.getResult())) {
                    fixed.add(first);
                    log.info((Object)("fixed: " + first.getTestTag()));
                    continue;
                }
                if (!TestResult.isRegression(first.getResult(), second.getResult())) continue;
                regressions.add(first);
                log.info((Object)("regression: " + first.getTestTag()));
                continue;
            }
            if (first.isSuccess()) {
                fixed.add(first);
                log.info((Object)("First run success for new test " + first.getTestTag()));
                first.setDetails("*** First Run Success for New Test ***");
                continue;
            }
            if (!first.isFailure()) continue;
            regressions.add(first);
            log.info((Object)("First run failure for new test " + first.getTestTag()));
            String oldDetails = first.getDetails();
            Object newDetails = "*** First Run Failure for New Test ***";
            if (oldDetails != null) {
                newDetails = (String)newDetails + ": " + oldDetails;
            }
            first.setDetails((String)newDetails);
        }
        passedTestFiles = passedTestFileSet.size();
    }

    private static void setEmailSubjectAndFromField(MailMessage msg, String mode, String suiteName, boolean foundCommit, String user, Date batchStartTime, String commitMessage, String branch) {
        String subject = config.getMailSubject();
        if (subject == null) {
            String target = BuilderSpecifier.isReifyCloud(suiteName) ? ((TestRunnerLauncher)config).getReifyCloudTarget() : null;
            subject = Utils.getSubjectBaseAndSetFromFieldForEmail(msg, mode, suiteName, branch, target);
        } else {
            msg.setFrom(((TestRunnerLauncher)config).getSenderEmail());
        }
        StringBuilder builder = new StringBuilder(subject);
        if (foundCommit) {
            if (regressions.size() > 1) {
                builder.append(regressions.size()).append(" regressions ");
            } else if (regressions.size() == 1) {
                builder.append("1 regression ");
            }
            if (fixed.size() > 0) {
                builder.append(fixed.size()).append(" fixed ");
            }
            if (regressions.size() == 0 && fixed.size() == 0) {
                builder.append("no changes ");
            }
        }
        if (user != null) {
            builder.append("on checkin by ").append(user);
        }
        if (commitMessage != null) {
            int fLineEnd = commitMessage.indexOf("\n");
            if (fLineEnd > 0) {
                commitMessage = commitMessage.substring(0, fLineEnd);
            }
            builder.append(" \"").append(commitMessage).append("\"");
        }
        if (config.isInternal()) {
            String summary = passedTestFiles + "/" + totalTestFiles;
            if (batchStartTime != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                summary = dateFormat.format(batchStartTime) + " " + summary;
            }
            try {
                String instanceId = null;
                if ("Local".equals(mode)) {
                    instanceId = "local";
                } else {
                    DSRequest dsReq = new DSRequest(Config.getGlobal().getString((Object)"autotest.batchRunDS"), "fetch");
                    dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
                    Map batchRecord = dsReq.execute().getDataMap();
                    instanceId = (String)batchRecord.get("instanceId");
                }
                summary = instanceId + " " + summary;
            }
            catch (Exception shouldNotHappen) {
                log.error((Object)("Unable to obtain instanceId for batchStartTime: " + batchStartTime.toString()));
            }
            builder.append(" [" + summary + "]");
        }
        msg.setSubject(builder.toString());
    }

    private static boolean addEmailRecipients(TemplatedMailMessage msg, String alertEmail, String repeatEmail, String ccEmail, boolean resultsChanged) {
        String toEmail;
        if (alertEmail == null) {
            alertEmail = repeatEmail;
        } else if (repeatEmail == null) {
            repeatEmail = alertEmail;
        }
        String string = toEmail = resultsChanged ? alertEmail : repeatEmail;
        if (StringUtils.isEmpty((String)toEmail) || ".".equals(toEmail)) {
            log.warn((Object)"email enabled, but no valid to address was available for this batch run, based on your configuration - no email sent");
            return false;
        }
        msg.addRecipients(toEmail, Message.RecipientType.TO);
        if (!StringUtils.isEmpty((String)ccEmail)) {
            msg.addRecipients(ccEmail, Message.RecipientType.CC);
        }
        return true;
    }

    private static boolean hasMultipleTestsPerFile(String suiteName) {
        if (BuilderSpecifier.isBuilderValid(suiteName)) {
            return false;
        }
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        if (suiteName == null) {
            return !launcher.noUsualTests();
        }
        return new ShowcaseSpecifier(suiteName).isSmartGWTRunner();
    }

    protected static void sortTestResults() {
        Comparator comparator = new Comparator(){

            public int compare(Object object1, Object object2) {
                TestResult testResult1 = (TestResult)object1;
                TestResult testResult2 = (TestResult)object2;
                if (testResult1.getTestFile().equals(testResult2.getTestFile())) {
                    return testResult1.getTestNumber() - testResult2.getTestNumber();
                }
                return testResult1.getTestFile().compareTo(testResult2.getTestFile());
            }
        };
        Collections.sort(fixed, comparator);
        Collections.sort(regressions, comparator);
    }

    protected static void clearTestResults() {
        totalTests = 0;
        totalTestFiles = 0;
        passedTests = 0;
        passedTestFiles = 0;
        fixed = new ArrayList<TestResult>();
        regressions = new ArrayList<TestResult>();
        serverLogFileName = null;
    }

    protected static double getPassRatio() {
        double totalTests = TestRunner.totalTests;
        return totalTests > 0.0 ? (double)passedTests / totalTests : 0.0;
    }

    public static void setConfiguration(TestRunnerConfiguration config) {
        TestRunner.config = config;
        TestRunnerHelper.setConfiguration(config);
        TestShowcaseHelper.setConfiguration(config);
        BatchRunDao.setConfiguration(config);
        TestResultDao.setConfiguration(config);
    }

    public static String getSuiteNameAsCamelCase(String suiteName) {
        String camelSuite = BuilderSpecifier.getBuilderAsCamelCase(suiteName);
        if (camelSuite != null) {
            return camelSuite;
        }
        return ShowcaseSpecifier.getShowcaseAsCamelCase(suiteName, "standAlone");
    }

    public static String getSuiteNameAsUrlParameter(String suiteName) {
        return suiteName != null ? suiteName : "dottest";
    }

    public static class BatchResults {
        private Date batchStartTime;
        private List<TestResult> results;

        protected Date getBatchStartTime() {
            return this.batchStartTime;
        }

        protected List<TestResult> getResults() {
            return this.results;
        }

        public BatchResults(Date batchStartTime, List<TestResult> results) {
            this.batchStartTime = batchStartTime;
            this.results = results;
        }

        public List<TestResult> getWobblers() {
            ArrayList<TestResult> wobblers = new ArrayList<TestResult>();
            for (TestResult testResult : this.results) {
                if (!testResult.isWobbler()) continue;
                wobblers.add(testResult);
            }
            return wobblers;
        }
    }
}

