/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.scripting.ScriptException;
import com.isomorphic.scripting.ScriptExceptionItem;
import com.isomorphic.scripting.ScriptXBase;
import com.isomorphic.scripting.java.ISCJavaScriptEngine;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptJava
extends ScriptXBase {
    private static Logger log = new Logger(ScriptJava.class.getName());
    protected String wrapperStart;
    protected String wrapperEnd;

    @Override
    public String getImportDirectives(List imports) throws Exception {
        Object ret = "";
        if (imports != null) {
            for (String impFullLine : imports) {
                if (impFullLine == null) continue;
                for (String impSplitted : impFullLine.split(";")) {
                    for (String imp : impSplitted.split(" ")) {
                        if ((imp = imp.trim()).equals("")) continue;
                        ret = (String)ret + "import " + imp + ";\n";
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected Exception fillInStackTrace(Exception se) {
        Throwable invokeError;
        ArrayList<ScriptExceptionItem> items = new ArrayList<ScriptExceptionItem>();
        Matcher matcher = Pattern.compile(":\\d+:.*\n?").matcher(this.stderr.getBuffer().toString());
        boolean found = false;
        while (matcher.find()) {
            String errMsg;
            int line;
            found = true;
            String s = matcher.group();
            try {
                line = Integer.parseInt(s.substring(1, s.indexOf(":", 1)));
                errMsg = s.substring(s.indexOf(":", 1) + 1);
            }
            catch (Exception ex) {
                line = 0;
                errMsg = s;
            }
            items.add(this.getScriptExceptionItem(ScriptExceptionItem.Type.PARSE, line, errMsg));
        }
        if (!found && (invokeError = se.getCause()) instanceof InvocationTargetException) {
            Throwable scriptError;
            StackTraceElement invokeElement = null;
            if (invokeError.getStackTrace() != null & invokeError.getStackTrace().length > 0) {
                invokeElement = invokeError.getStackTrace()[0];
            }
            if ((scriptError = invokeError.getCause()) != null) {
                ArrayList<StackTraceElement> filledStackTrace = new ArrayList<StackTraceElement>();
                StackTraceElement[] scriptStackTrace = scriptError.getStackTrace();
                int line = -1;
                if (scriptStackTrace != null && scriptStackTrace.length > 0 && (line = scriptStackTrace[0].getLineNumber()) == -1) {
                    log.warn("Stack trace does not provide full information about where error occured (line number is missing). Please check Scripting engine for Java implementation you are using. Its compiler probably does not include debug info.");
                }
                for (StackTraceElement element : scriptError.getStackTrace()) {
                    if (this.getClass().getName().equals(element.getClassName()) && "evalScript".equals(element.getMethodName())) {
                        ScriptExceptionItem sei = this.getScriptExceptionItem(null, line, null);
                        int sourceLineNumber = sei.getScriptSourceLineNumber();
                        if (sourceLineNumber < 0) {
                            filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "", sei.getSource(), sei.getLineNumber()));
                        } else {
                            filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "scriptLine:" + sei.getLineNumber(), sei.getSource(), sourceLineNumber));
                        }
                    }
                    filledStackTrace.add(element);
                }
                StackTraceElement[] filledStackTraceArray = new StackTraceElement[filledStackTrace.size()];
                for (int i = 0; i < filledStackTrace.size(); ++i) {
                    filledStackTraceArray[i] = (StackTraceElement)filledStackTrace.get(i);
                }
                scriptError.setStackTrace(filledStackTraceArray);
                if (scriptError instanceof Exception) {
                    return (Exception)scriptError;
                }
            }
        }
        if (items == null || items.isEmpty()) {
            return new ScriptException("Script execution failed. Cannot extract error message from stderr or stackTrace.", se);
        }
        return new ScriptException(this.scriptSourceName, items, (Throwable)se);
    }

    private ScriptExceptionItem getScriptExceptionItem(ScriptExceptionItem.Type type, int line, String errMsg) {
        int footerLines;
        int importDirectivesLines = (this.importDirectives == null ? 0 : DataTools.countCompleteLines(this.importDirectives)) + 1;
        int headerLines = (this.header == null ? 0 : DataTools.countCompleteLines(this.header)) + 1;
        int wrapperStartLines = (this.wrapperStart == null ? 0 : DataTools.countCompleteLines(this.wrapperStart)) + 1;
        int scriptLines = (this.script == null ? 0 : DataTools.countCompleteLines(this.script)) + 1;
        int wrapperEndLines = (this.wrapperEnd == null ? 0 : DataTools.countCompleteLines(this.wrapperEnd)) + 1;
        int n = footerLines = this.footer == null ? 0 : DataTools.countCompleteLines(this.footer);
        if (line <= importDirectivesLines) {
            return new ScriptExceptionItem(type, "importDirectives", line, -1, errMsg);
        }
        if (line <= importDirectivesLines + headerLines) {
            return new ScriptExceptionItem(type, this.headerFilename, line - importDirectivesLines, -1, errMsg);
        }
        if (line <= importDirectivesLines + headerLines + wrapperStartLines) {
            return new ScriptExceptionItem(type, "wrapperStart", line - importDirectivesLines - headerLines, -1, errMsg);
        }
        if (line <= importDirectivesLines + headerLines + wrapperStartLines + scriptLines) {
            int scriptOffset = -1;
            int scriptLine = line - importDirectivesLines - headerLines - wrapperStartLines;
            int sourceLine = -1;
            if (this.scriptSource != null) {
                try {
                    scriptOffset = this.scriptSource.getScriptSourceOffset(this.scriptSourceContext);
                    if (scriptOffset > 0) {
                        sourceLine = scriptLine + scriptOffset;
                    }
                }
                catch (Exception soe) {
                    log.warn((Object)"Error obtaining script offset: ", soe);
                }
            }
            return new ScriptExceptionItem(type, this.scriptSourceFilename == null ? "script" : this.scriptSourceFilename, scriptLine, sourceLine, -1, errMsg);
        }
        if (line <= importDirectivesLines + headerLines + wrapperStartLines + scriptLines + wrapperEndLines) {
            return new ScriptExceptionItem(type, "wrapperEnd", line - importDirectivesLines - headerLines - wrapperStartLines - scriptLines, -1, errMsg);
        }
        if (line <= importDirectivesLines + headerLines + wrapperStartLines + scriptLines + wrapperEndLines + footerLines) {
            return new ScriptExceptionItem(type, this.footerFilename, line - importDirectivesLines - headerLines - wrapperStartLines - scriptLines - wrapperEndLines, -1, errMsg);
        }
        return new ScriptExceptionItem(type, "script", line, -1, errMsg);
    }

    @Override
    protected void init() throws Exception {
        this.engine = new ISCJavaScriptEngine();
    }

    @Override
    protected void prepareContext() throws Exception {
        super.prepareContext();
        if (this.stderr == null) {
            this.stderr = new StringWriter();
        }
        this.scriptContext.setErrorWriter(this.stderr);
    }

    @Override
    public Map evalScript() throws Exception {
        ArrayList<Class> classes = new ArrayList<Class>();
        Iterator i = config.getCommaSeparatedList("scripting.java.interface.types").iterator();
        while (i.hasNext()) {
            Class klass = Reflection.classForName((String)i.next());
            classes.add(klass);
        }
        String evalScript = null;
        Object evalResult = null;
        try {
            String useWrapper = config.getPath("script.java.useDefaultScriptWrapper");
            if (useWrapper == null || Boolean.valueOf(useWrapper.trim().toLowerCase()).booleanValue()) {
                this.wrapperStart = "import javax.script.*;\nclass iscTmpClass {\nprivate static ScriptContext ctx;\npublic static void setScriptContext(ScriptContext context) {ctx = context;}\npublic static void main(String[] args) throws Exception { Object result = doExec(args); ctx.setAttribute(\"evalResult\",result,ScriptContext.ENGINE_SCOPE);}\n@SuppressWarnings(\"unchecked\")\npublic static Object doExec(String[] args) throws Exception {";
                if (this.bindings != null && !this.bindings.isEmpty()) {
                    this.wrapperStart = this.wrapperStart + "\n";
                    for (String key : this.bindings.keySet()) {
                        Object value = this.bindings.get(key);
                        String className = null;
                        if (value != null) {
                            for (Class klass : classes) {
                                if (!klass.isAssignableFrom(value.getClass())) continue;
                                className = klass.getName();
                                break;
                            }
                        }
                        if (value != null) {
                            if (className == null) {
                                className = value.getClass().getName();
                            }
                            this.wrapperStart = this.wrapperStart + className + " " + key + " = (" + className + ") ctx.getAttribute(\"" + key + "\");\n";
                            continue;
                        }
                        if (this.bindingsClassName != null && this.bindingsClassName.get(key) != null) {
                            className = (String)this.bindingsClassName.get(key);
                            this.wrapperStart = this.wrapperStart + className + " " + key + " = null;\n";
                            continue;
                        }
                        this.wrapperStart = this.wrapperStart + "Object " + key + " = null;\n";
                    }
                }
                if (this.bindingsClassName != null && !this.bindingsClassName.isEmpty()) {
                    if (!this.wrapperStart.endsWith("\n")) {
                        this.wrapperStart = this.wrapperStart + "\n";
                    }
                    for (String key : this.bindingsClassName.keySet()) {
                        if (this.bindings != null && this.bindings.containsKey(key)) continue;
                        String className = (String)this.bindingsClassName.get(key);
                        this.wrapperStart = this.wrapperStart + className + " " + key + " = null;\n";
                    }
                }
                this.wrapperEnd = "}}";
                if (this.script.indexOf("return ") == -1) {
                    this.wrapperEnd = "\nreturn null;" + this.wrapperEnd;
                }
            }
            evalScript = (this.importDirectives == null ? "" : this.importDirectives) + "\n" + (this.wrapperStart == null ? "" : this.wrapperStart) + "\n" + (this.header == null ? "" : this.header) + "\n" + (this.script == null ? "" : this.script) + "\n" + (this.footer == null ? "" : this.footer) + "\n" + (this.wrapperEnd == null ? "" : this.wrapperEnd);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating assembled script:\n" + evalScript);
            } else {
                log.info("Evaluating script:\n" + this.script);
            }
            this.scriptContext.setAttribute("parentLoader", Thread.currentThread().getContextClassLoader(), 100);
            this.engine.eval(evalScript);
        }
        catch (Exception e) {
            throw this.fillInStackTrace(e);
        }
        evalResult = this.scriptContext.getAttribute("evalResult");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        if (this.captureOutput) {
            result.put("stdout", this.stdout.toString());
            result.put("stderr", this.stderr.toString());
        }
        return result;
    }
}

