/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-12-15/LGPL Deployment (2025-12-15)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @groupDef jUnitWebDriver
// <div style="width:600px">
//
// Let's take a look at some JUnit code designed to test a standalone version of the
// <smartclient>
// +externalLink{http://localhost:8080/isomorphic/system/reference/SmartClient_Explorer.html#treesEditing, SmartClient Showcase: Trees &gt;&gt; Editing} 
// </smartclient><smartgwt>
// +externalLink{http://localhost:8080/index.html#tree_editing, SmartClient Showcase: Trees &gt;&gt; Editing} 
// </smartgwt>
// example.  The overall test class, TreeTest, contains a test, testTree1, targeted at the
// TreeGrid in the example, and a test, testTree2, targeted at the SearchForm/ListGrid.  As
// shown in the +link{automatedTesting,automated testing overview}, we create a
// +serverDocLink{com/isomorphic/webdriver/SmartClientWebDriver.html,SmartClientWebDriver}
// instance which we'll use to execute commands such as
// +serverDocLink{com/isomorphic/webdriver/SmartClientWebDriver.html#waitForElementClickable-org.openqa.selenium.By-,waitForElementClickable()}.
// Usage of <code>SmartClientWebDriver</code> APIs parallels Selenese commands, so you may want
// to review our +link{group:usingSelenium,guide to writing Selenium scripts} before going any
// further.
// <P>
// Just as <code>SmartClientWebDriver</code> Java calls cannot be directly generated by Selenium
// IDE and require +serverDocLink{com/isomorphic/webdriver/SeleneseRunner.html,SeleneseRunner},
// neither can we directly generate <code>SmartClientWebDriver</code>-based JUnit4 classes.
// The test class TreeTest was initially generated by exporting the Selenese for testTree1 in
// JUnit 4 format (Java / JUnit 4 / WebDriver) to get the method declarations, but the method
// implementations were then filled in with Java generated by <code>SeleneseRunner</code>.
// Below we look at the two test cases testTree1 and testTree2.
// <P>
// To simplify the code for presentation, we've wrapped the driver APIs <code>click()</code> and
// <code>waitForElementClickable()</code> in local methods that automatically generate the
// +serverDocLink{com/isomorphic/webdriver/ByScLocator.html,ByScLocator}.  If you'd like to
// experiment with making changes to the sample JUnit code, one improvement that might simplify
// things further would be to add a <code>myClick()</code> function that handles both the
// <code>waitForElementClickable()</code> and the <code>click()</code> on the supplied locator.
// Often, just assigning each unique locator or locator prefix to a local Java variable so it
// can be reused for multiple calls will make the code simpler to follow and maintain.
//
// <pre>
// import org.openqa.selenium.*;
// import org.openqa.selenium.remote.*;
// import org.openqa.selenium.firefox.*;
//
// import org.junit.*;
// import static org.junit.Assert.*;
// import java.util.regex.Pattern;
//
// public class TreeTest {
//     private SmartClientWebDriver driver;
//
//     private SmartClientWebDriver click(String scLocator) {
//         return driver.click(ByScLocator.scLocator(scLocator));
//     }
//
//     private boolean waitForElementClickable(String scLocator) {
//         return driver.waitForElementClickable(ByScLocator.scLocator(scLocator));
//     }
// 
//     &#64;Before
//     public void setUp() throws Exception {
//         driver = new SmartClientFirefoxDriver();<smartgwt>
//         driver.setBaseUrl("http://localhost:8080/");</smartgwt><smartclient>
//         driver.setBaseUrl("http://localhost:8080/showcase/");</smartclient>
//     }
//
//     &#64;Test
//     public void testTree1() throws Exception {<smartgwt>
//         driver.get("#tree_editing");</smartgwt><smartclient>
//         driver.get("#treesEditing");</smartclient>
//
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
//         click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=4||Name=Charles%20Madigen||0]/col[fieldName=Name||0]/open");
//
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
//         click("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=189||Name=Gene%20Porter||8]/col[fieldName=Name||0]/open");
//
//         waitForElementClickable("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]");
//         assertEquals("5650", driver.getText(ByScLocator.
//             scLocator("scLocator=//TreeGrid[ID=\"employeeTree\"]/body/row[EmployeeId=264||Name=Cheryl%20Pearson||Salary=5650||10]/col[fieldName=Salary||2]")));
//     }
// </pre>
//
// In test testTree1, the idea is to:
// <ul>
//     <li> Open the node for the top level employee, Charles Madigen,
//     <li> Open the node for his report, Gene Porter, and
//     <li> Verify that the Salary of Cheryl Pearson, who reports to Gene, is 5650
// </ul><p>
// For this test, everything (less simplification) but the JUnit <code>Assert.assertEquals()
// </code> should be generated for you by <code>SeleneseRunner</code>.  A verification in
// Selenese will likely be generated as a <code>verifyValue()</code> call to
// <code>SmartClientWebDriver</code>, but as that simply returns a boolean, we instead want to
// invoke the JUnit API directly on the result of <code>getText()</code>.
// <P>
// Note that though the locator for Cheryl includes the salary, it will match based on the first
// field, EmployeeId, which is the primary key, so the test will correctly compare the contents 
// of Cheryl's salary against the value 5650 and fail if it doesn't match.  If for some reason 
// your test requires matching a specific field rather than the default fields and ordering
// generated automatically, you can hand edit the locator.
//
// <pre>
// 
//     public void testTree2() throws Exception {<smartgwt>
//         driver.get("#tree_editing");</smartgwt><smartclient>
//         driver.get("#treesEditing");</smartclient>
//
//         // Steps 1-3: Load the ListGrid with Joan's Reports
//         waitForElementClickable("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
//         click("scLocator=//SearchForm[ID="employeeSearchForm"]/item[index=0||Class=PickTreeItem]/button/");
//
//         waitForElementClickable("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]");
//         mouseMove(ByScLocator.
//             scLocator("scLocator=//autoID[Class=SelectionTreeMenu||index=8||length=14||classIndex=0||classLength=2||roleIndex=0||roleLength=2||scRole=menu]/body/row[Name=Charles%20Madigen]/col[fieldName=title||0]"));
//
//         waitForElementClickable("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
//         click("scLocator=//SelectionTreeMenu[ID=\"isc_SelectionTreeMenu_0_childrenSubMenu_0\"]/body/row[EmployeeId=183]/col[fieldName=title||1]");
// 
//         // Step 4: Sort by salary, descending, and wait for ListGrid to be redrawn with final result
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//         click("scLocator=//ListGrid[ID=\"employeeGrid\"]/header/headerButton[fieldName=Salary]/");
//
//         driver.waitForGridDone(ByScLocator.scLocator("scLocator=//ListGrid[ID='employeeGrid']"));
//
//         // Step 5: Verify the top salary
//         waitForElementClickable("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]");
//         assertEquals("9400", selenium.getText(ByScLocator.scLocator("scLocator=//ListGrid[ID=\"employeeGrid\"]/body/row[0]/col[fieldName=Salary||2]")));
//     }
// </pre>
//
// In test testTree2, the idea is to:
// <P>
// 1. Click on the SearchForm button, revealing a Charles Madigen popup,<BR>
// 2. Issue a MouseMove on the Charles Madigen popup, revealing a list of his reports,<BR>
// 3. Click on his report Joan Little, filling the ListGrid with her reports,<BR>
// 4. Click on the salary column header twice, sorting by descending salary, and<BR>
// 5. Verify the salary in the top row (top salary) is 9400<BR>
// <P>
// This test required more hand modification than the previous one.  In particular three
// modifications were made:
// <ul>
//    <li> A mouseMove command was manually added to the Selenium IDE script,
//    <li> A call to <code>waitForGridDone()</code> was added to assure the sorting was done
//         before we ran verifyText, and
//    <li> We manually removed all but the row qualifier from the automatically generated
//          scLocator for step &#35;5.
// </ul>
// <p>
// The first modification is required because our user extensions don't record mouseMove
// events, and the second is needed to ensure the sorts are complete before verifyText runs--for
// details see the User Guide (described in +link{automatedTesting}).  The final modification is
// just a reflection of what our intent is in step &#35;5; we want to operate on the top row,
// regardless of its contents, so we don't want our locator matching based on the EmployeeId or
// Name fields of the records.  (Matching by EmployeeId in the locator as automatically
// generated would make the test verify that Kelly Fetterman's salary is 9400 rather than that 9400 
// is the highest salary.)
// <pre><p>
//     &#64;After
//     public void tearDown() throws Exception {
//         driver.quit();
//     }
// }
// </pre>
// </div>
// @title JUnit + Selenium WebDriver
// @visibility external
//<




//> @groupDef automatedTesting
// SmartClient supports automated testing with a variety of tools. See the +link{AutoTest} class
// for information about how to generate and resolve +link{AutoTestLocator,AutoTestLocators}
// and other utilities within the SmartClient framework related to generating automated tests.
// <P>
// <h3>Cypress</h3>
// SmartClient applications integrate seamlessly with +externalLink{https://www.cypress.io/,Cypress}.
// <P>
// The SDK package includes a sample <code>commands.js</code> configuration file with custom 
// +externalLink{https://docs.cypress.io/api/cypress-api/custom-commands,cypress commands} to
// identify and interact with SmartClient components, seamlessly wait for asynchronous 
// operations, recording timing data and more. See the
// +link{group:smartClientCypress,Cypress integration overview} for details on how to
// use Cypress with SmartClient.
// <P>
// <h3>Selenium / Selenese</h3>
// <P>
// SmartClient includes free support for +externalLink{https://docs.seleniumhq.org/,Selenium}
// for robust recording and playback of tests, including the ability to record on one browser
// and play back on others, via 
// +externalLink{https://www.seleniumhq.org/docs/02_selenium_ide.jsp#selenium-commands-selenese,Selenese}
// enhanced with SmartClient-specific locators and commands that provide a stable means of
// locating SmartClient widgets and ensuring they're ready for interaction.
// <P>
// To write Selenese, we recommend Selenium IDE 2.9, which is compatible with
// +externalLink{https://www.mozilla.org/en-US/firefox/organizations/,Firefox 52 ESR}, and
// can directly load our user extensions, located in the
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory.  A user guide explaining how to create and interactively run selenese with the IDE
// can be found +link{group:usingSelenium,here}.  Selenium IDE 3, which requires Firefox 
// Quantum, has just released support for plugins that should allow the eventual migration of
// our user extensions, but for now only Selenium IDE 2.9 can load SmartClient locator and
// command extensions.
// <P>
// <b>SeleneseRunner</b>
// <P>
// For automated testing, SmartClient provides
// +serverDocLink{com/isomorphic/webdriver/SeleneseRunner.html,SeleneseRunner}, a tool that
// executes SmartClient-enhanced Selenese created by Selenium IDE via emulation, since Selenium
// 3 no longer supports the Selenium RC APIs and thus can't execute Selenese that requires
// custom user extensions.  Internally, <code>SeleneseRunner</code> makes use of the APIs in
// our WebDriver wrappers to resolve locators properly and execute SmartClient-enhanced
// Selenese.
// <P>
// <code>SeleneseRunner</code> can be used to:
// <ul>
// <li> execute Selenese directly from the command line
// <li> execute Selenese from inside a Java program (eg, as part of a JUnit test)
// <li> convert a Selenese test to Java code (as a JUnit test)
// </ul><p>
// See the server-side JavaDoc linked above for more information on how to use these features.
// <P>
// <h3>TestRunner</h3>
// <P>
// +link{group:testRunner,TestRunner} is a system for automatically running a suite of Selenium
// tests, commiting the results to a database, and reporting any regressions (or fixes) via email.
// <P>
// <smartgwt>
// <h3>GwtTestCase</h3>
// <P>
// GWT includes a way to run a GWT application under JUnit, running your GWT application in a
// "headless" browser.  This is a very limited testing approach appropriate for certain unit
// tests only - it cannot replace events such as clicks, because by default it doesn't run in
// actual browser (instead it runs in a simulator called HtmlUnit).
// <p>
// Note that running tests under HtmlUnit can lead to false failures in a variety of areas,
// including network communication and XML processing, where HtmlUnit's behaviors do not
// correspond to any real browser.  Note that, if you find that a test fails under HtmlUnit but
// would not fail in a real browser, this will not be regarded as a SmartGWT bug.
// <p>
// If you use GwtTestCase at all, Isomorphic recommends that the majority of your tests are
// executed using the
// +externalLink{http://www.gwtproject.org/doc/latest/DevGuideTestingRemoteTesting.html,runStyle option}
// that allows GwtTestCase to run under a real browser via Selenium.
// <P>
// Also note, GwtTestCase has a bug where it does not run onModuleLoad() for included GWT
// modules.  To make sure SmartGWT's onModuleLoad() runs, add a <code>gwtSetUp()</code>
// implementation like so: 
// <P>
// <pre>
//   public class SgwtTest extends GWTTestCase {
//       public void gwtSetUp() {
//           new SmartGwtEntryPoint().onModuleLoad();		
//       }
//       ...
// </pre>
// <P>
// You may need to add similar manual calls for other GWT modules you inherit which expect to
// have their <code>onModuleLoad()</code> method called normally.
// </smartgwt>
// <P>
// <h3>Selenium WebDriver</h3>
// <P>
// WebDriver, supported since Selenium 2, uses a different basic architecture in which a driver
// is added to each browser to enable Selenium interaction, instead of doing so from JavaScript.
// <P>
// Support for WebDriver-based testing for SmartClient is now available with the same custom
// locator strategies and custom commands as we provide for Selenese.  <b>However, we continue
// to recommend Selenese rather than WebDriver-based Selenium, because Webdriver requires
// Java programming skills.</b>  Tests created in Selenium IDE and stored in Selenese can be
// executed by a variety of tools without requiring Java skills, including our own
// +link{group:testRunner}.  Most ways of running WebDriver tests involve Java coding skills or
// at least the ability to work with a Java IDE.  This tends to mean that all QA personnel must
// either have Java skills or drain the time of Java developers on repetitive tasks.
// <P>
// Ultimately, our current recommendation is to use Selenium IDE and Selenese exclusively or
// at least primarily.  If there are critically important tests that you can only build via
// WebDriver, use WebDriver for those tests only, or use manual testing for those tests.
// <P>
// <b>WebDriver Usage</b>
// <P>
// When using WebDriver, we recommend using Selenum IDE as a starting point to record and store 
// tests.  You can then call <code>SeleneseRunner</code> to convert that Selenese to Java code
// that uses SmartClient locators and invokes the appropriate APIs on our WebDriver wrappers.
// <P>
// Once you become familiar with what code is generated for common interactions, you may want to
// write tests directly without using Selenium IDE.  In this case, you can retrieve locators
// for specific elements in a couple of ways. The +link{AutoTest.installLocatorShortcut()} method
// allows developers to retieve a locator for the element under the mouse via a simple
// key-combo plus click. Alternatively you can use +link{AutoTest} APIs, 
// such as +link{AutoTest.getLocator()}, which takes a +link{Canvas} or
// DOM element, to get the locators you need. These can be invoked by evaluating 
// script while a SmartClient page is loaded (from the +link{group:debugging,Developer Console} 
// or from the native browser console).
// <p>
// <b>NOTE:</b> Selenium IDE has an option to export tests as WebDriver-compatible code.  <b>Do
// not use</b> this feature, it exports useless code that doesn't understand custom commands,
// custom locators, or other key features of Selenium IDE.  Use <code>SeleneseRunner</code>
// instead.
// <p>
// <b>WebDriver Classes overview</b>
// <p>
// Storing and executing Selenese tests recorded in the Selenium IDE is recommended as the
// primary approach for using WebDriver.  However, for certain rare tests it can make sense to
// use WebDriver Java support directly.
// <p>
// SmartClient support for WebDriver is based around 3 different Java classes:
// <P>
// <ol>
// <li> +serverDocLink{com/isomorphic/webdriver/ByScLocator.html,ByScLocator}:
// This implements the ability to find WebElements or WebDriver "By"
// objects using SmartClient Locator strings.  See +link{group:usingSelenium} for more
// background on Locator strings and how to obtain them.  Given a locator String, example usage is:
// <pre>
// ByScLocator.scLocator("//ListGrid[ID=\"countryList\"]/body/row[countryCode=US||0]/col[fieldName=countryCode||0]")</pre>
// <li> +serverDocLink{com/isomorphic/webdriver/SmartClientWebDriver.html,SmartClientWebDriver}:
// This is an abstract class which provides a number of
// different methods for interacting with the browser, such as:
// <ul>
// <li> open a browser at a particular URL
// <li> find the element or elements which match a given "By" object (either ByScLocator, or a
//      standard WebDriver locator)
// <li> perform events and operations (click, drag, select etc)
// <li> perform custom SmartClient validations / state checks, such as whether a grid has
//      loaded data
// </ul>
// Three concrete implementations of SmartClientWebDriver are provided: SmartClientFireFoxDriver,
// SmartClientChromeDriver and SmartClientIEDriver. There is also a SmartClientRemoteWebdriver class
// which allows the injection of a manually configured RemoteWebDriver instance. This might be
// necessary, for example, for use with Selenium Grid.<P>
// <li> +serverDocLink{com/isomorphic/webdriver/ScActions.html,ScActions}:
// a SmartClient-specific version of the standard WebDriver
// "Action" class, providing a builder pattern to create a sequence of operations which can
// then be perform()ed.
// </ol>
// <P>
// These classes are packaged in the library isomorphic_webdriver.jar, which can be found in
// the directory <smartclient>WEB-INF/</smartclient>lib-WebDriverSupport (along with several
// 3rd-party supporting libraries).<smartgwt>This directory can be found at the top level of the
// downloaded Smart GWT zip package.</smartgwt>
// <P>
// General information regarding WebDriver can be found
// +externalLink{http://docs.seleniumhq.org/docs/03_webdriver.jsp#introducing-webdriver, here}.
// Setup for WebDriver is more complex than for classic Selenium.  Drivers can be downloaded for
// +externalLink{https://github.com/mozilla/geckodriver/,Firefox},
// +externalLink{https://sites.google.com/chromium.org/driver/,Google Chrome}, 
// +externalLink{https://www.seleniumhq.org/download/,Internet Explorer}, and
// +externalLink{https://developer.microsoft.com/en-us/microsoft-edge/tools/webdriver/,MS Edge}.
// <P>
// <b>JUnit + WebDriver</b>
// <P>
// Explore +link{jUnitWebDriver,JUnit + Selenium WebDriver}, where we walk through a JUnit test
// targeting a SmartClient Showcase sample.
// <P>
// <b>File Upload Example Test</b>
// <P>
// As discussed above, one advantage which WebDriver does have over Classic Selenium is the ability
// to test file upload. It is still limited in that if a click is triggered on the file selection button
// an OS native file selection dialog will be triggered in which case the test will be suspended until the
// file is manually selected. To avoid this, the sendKeys() method can be used to enter the file location.
// <p>Sample code:<p>
// <pre><smartclient>
//    &#47;**
//     * The following test runs against localhost and requires a small (< 5mb) image to be in /tmp/image.jpg
//     *&#47;
//    public void fileUploadSC() throws Exception {
//        SmartClientWebDriver driver = new SmartClientFirefoxDriver();
//        driver.setBaseUrl("http://localhost:8080/showcase/");
//        driver.get("#upload");
//
//        final int origSize = driver.findElements(ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile")).size();
//
//        By titleInput = ByScLocator.scLocator("//DynamicForm[ID=\"uploadForm\"]/item[name=title||title=Title||index=0|"
//                                             +"|Class=TextItem]/element");
//        driver.click(titleInput);
//        driver.sendKeys(titleInput, "test image: " + origSize);
//        
//        By uploadForm = ByScLocator.scLocator("//DynamicForm[ID=\"uploadForm\"]/");
//        WebElement form = driver.findElement(uploadForm);
//        WebElement findElement = form.findElement(By.xpath("//input[@type='FILE']"));
//        &#47;*
//         * The following causes a native dialog to be created which prevents further progress. Do NOT uncomment!
//         * We just have to sendKeys() to it
//         *&#47;
//        //findElement.click(); 
//        
//        findElement.sendKeys("/tmp/image.jpg"); // A local file. Please change accordingly
//
//        By saveButton = ByScLocator.scLocator(
//                             "//DynamicForm[ID=\"uploadForm\"]/item[title=Save||index=2||Class=ButtonItem]/button/");
//        driver.waitForElementClickable(saveButton);
//        driver.click(saveButton);
//        &#47;*
//         * Note the following fails once the grid contains more than 3 rows of data
//         * as the index becomes inconsistent as tiles scrolled out of site are removed
//         * and the indices change
//         *&#47;                                                        
//        By tile = ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile[Class=SimpleTile||index="
//                         +(origSize)+"||length="+(origSize+1)+"||classIndex="+(origSize)+"||classLength="+(origSize+1)+"]/");
//        driver.waitForElementClickable(tile);
//        WebElement tile1 = driver.findElement(tile);
//        assertEquals("test image: " + origSize, tile1.getText());
//        assertEquals(origSize + 1, driver.findElements(ByScLocator.scLocator("//TileGrid[ID=\"mediaTileGrid\"]/tile")).size());
//        driver.close();
//        driver.quit();
//    }
// </smartclient><smartgwt>
//    &#47;**
//     * The following test runs against localhost and requires a small (< 5mb) image to be in /tmp/image.jpg
//     *&#47;
//    public void fileUploadGWT() throws Exception {
//        final String basePath = "//VLayout[ID=\"isc_Showcase_1_0\"]/member[Class=HLayout||index=0||length=2|"
//                               +"|classIndex=0||classLength=1]/member[Class=HLayout||index=0||length=2||classIndex=0|"
//                               +"|classLength=1]/member[Class=Canvas||index=1||length=2||classIndex=0||classLength=1]"
//                               +"/child[Class=TabSet||index=0||length=1||classIndex=0||classLength=1]/paneContainer/"
//                               +"member[Class=VLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=VLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=HLayout||index=1||length=2||classIndex=0||classLength=1]/"
//                               +"member[Class=HLayout||index=0||length=1||classIndex=0||classLength=1]/";
//        final String formPath = basePath + "member[Class=DynamicForm||index=0||length=3||classIndex=0||classLength=1]";
//        final String tilesPath = basePath + "member[Class=VLayout||index=2||length=3||classIndex=0||classLength=1]/"
//                                          + "member[Class=TileGrid||index=2||length=4||classIndex=0||classLength=1]/tile";
//        SmartClientWebDriver driver = new SmartClientFirefoxDriver();
//        driver.setBaseUrl("http://localhost:8888/");
//        driver.get("index.html#upload_sql", true);
//
//        final int origSize = driver.findElements(ByScLocator.scLocator(tilesPath)).size();
//        By uploadForm = ByScLocator.scLocator(formPath);
//        WebElement form = driver.findElement(uploadForm);
//      
//        By titleInput = ByScLocator.scLocator(formPath + "/item[name=title||title=Title||index=0||Class=TextItem]/element");
//        driver.click(titleInput);
//        driver.sendKeys(titleInput, "test image: " + origSize);
//        
//        WebElement findElement = form.findElement(By.xpath("//input[@type='FILE']"));
//        &#47;*
//         * The following causes a native dialog to be created which prevents further progress. Do NOT uncomment!
//         * We just have to sendKeys() to it
//         *&#47;
//        //findElement.click(); 
//        
//        findElement.sendKeys("/tmp/image.jpg"); // A local file. Please change accordingly
//
//        By saveButton = ByScLocator.scLocator(formPath + "/item[title=Save||index=2||Class=ButtonItem]/button/");
//        driver.waitForElementClickable(saveButton);
//        driver.click(saveButton);
//        &#47;*
//         * Note the following fails once the grid contains more than 3 rows of data as the index becomes inconsistent
//         * as tiles scrolled out of site are removed and the indices change
//         *&#47;
//        By tile = ByScLocator.scLocator(tilesPath + "[Class=SimpleTile||index="+(origSize)+"||length="+(origSize+1)
//                                                      + "||classIndex="+(origSize)+"||classLength="+(origSize+1)+"]/");
//        driver.waitForElementClickable(tile);
//        WebElement tile1 = driver.findElement(tile);
//        assertEquals("test image: " + origSize, tile1.getText());
//        assertEquals(origSize + 1, driver.findElements(ByScLocator.scLocator(tilesPath)).size());
//        driver.close();
//        driver.quit();
//    }
// </smartgwt></pre>
// <P>
// <b>WebDriver Troubleshooting</b>
// <P>
// There is a known issue that 
// +externalLink{https://code.google.com/p/selenium/issues/detail?id=4403,native events do not work with IE in Windows 8/8.1}
// that may manifest in WebDriver as clicks having no effect.  One potential workaround is to
// disable native events:
// <pre>
//    DesiredCapabilities caps = DesiredCapabilities.internetExplorer();
//    caps.setCapability("nativeEvents",false);
//    SmartClientWebDriver driver = new SmartClientIEDriver(caps);</pre>
// It's also been reported that changing the second line above to:
// <pre>
//    caps.setCapability("requireWindowFocus", true);</pre>
// also resolves the issue, with the side effect that WebDriver then moves the mouse cursor.
// <P>
// In some versions of Internet Explorer, it's been reported that you must add the URL targeted
// by WebDriver to the "Trusted Sites" under Internet Options &gt;&gt; Security in order to
// allow the browser to communicate properly with Selenium.  A discussion of the setup needed
// to use WebDriver's InternetExplorerDriver can be found
// +externalLink{https://github.com/SeleniumHQ/selenium/wiki/InternetExplorerDriver,here}.
// <P>
// <b>Other tools</b>
// <P>
// SmartClient supports a special JavaScript API to allow other test tools to integrate in the
// same manner as Selenium and WebDriver.  This API allows the test tool to record an abstract
// "locator" string representing the logical name for an interactive DOM element, and then
// during test playback, retrieve a DOM element given a locator.
// <P>
// This is critical because, like many modern Ajax systems, SmartClient generates different DOM
// elements in different browsers, in different skins, and in different versions of SmartClient.  
// Testing tools that try to directly record the generated SmartClient DOM produce extremely
// brittle tests because they are effectively recording undocumented internals.
// <P>
// Using the "locator" API allows you to record or write tests that will run in any browser
// supported by SmartClient, in any version of SmartClient, and in any skin.  It also makes
// tests more readable and easier to understand and maintain.
// <P>
// Different testing tools vary in how easily they can be configured to use the locator API,
// and in some older tools it can be a large effort.  We highly recommend using our Selenium
// extensions - it often makes sense to use them even if you have to use them in parallel with
// another, older testing tool.  If you are forced to use another tool exclusively:
// <ul>
// <smartclient>
// <li> Read the +link{class:AutoTest,documentation for the locator system}
// </smartclient>
// <smartgwt>
// <li> Refer to the &#83;martClient documentation for the AutoTest class (because it's a
// JavaScript API).  It can be found
// +externalLink{http://www.smartclient.com/product/documentation.jsp,here}
// </smartgwt>
// <li> Read over the source code of our Selenium extensions to get a clear understanding of
// how the Selenium integration works, because this will be analogous to the work you'll need
// to do
// <li> Search the +externalLink{http://forums.smartclient.com/, forums} for other developers
// who are trying to use the same test tool with SmartClient, and share efforts
// </ul>
//
// @treeLocation Concepts
// @title Automated Testing
// @visibility external
//<





//> @groupDef smartClientCypress
// Cypress is an automated testing platform that can be used to test web applications.
// SmartClient supports a number of features to easily integrate with Cypress, making
// it extremely straightforward to start creating effective automated tests for
// SmartClient applications.
// <p>
// <i>For an overview of Automated Testing in SmartClient, see the documentation +link{group:automatedTesting,here}.</i>
// <p>
// The Cypress website contains very helpful guides to walk you through how to install Cypress,
// how to run the Cypress application, and how to create tests. If you're new to Cypress,
// we'd recommend you start 
// +externalLink{https://docs.cypress.io/guides/getting-started/installing-cypress,here}.
// You should be able to rapidly learn how to install cypress and how to create 
// and run e2e (end-to-end) tests.
// <p>
// <b>Custom cypress commands for SmartClient Applications</b>
// <P>
// The SmartClient SDK ships with a sample <code>commands.js</code> file, available under
// <code><smartclient>smartclientSDK/tools/cypress/commands.js</smartclient>
//       <smartgwt>commands.js</smartgwt></code>.
// <P>
// This file contains some 
// +externalLink{https://docs.cypress.io/api/cypress-api/custom-commands,custom commands}
// which simplify interacting with a running
// SmartClient application as cypress runs your tests. See below for more details.
// <P>
// <b>Using <i>locators</i> to interact with SmartClient User Interface components</b>
// <P>
// The +link{type:AutoTestLocator} subsystem is used to reliably identify DOM elements
// generated within a SmartClient application. 
// <p>
// You have two options for obtaining locators from your app:
// <p>
// <b>1.-</b> The Developer Console.
// <p>
// Open the Developer Console and, in the first tab titled "Results", click on the link near 
// the middle of the page, titled "Show AutoTest Locators." Now as you click on elements
// within the application, the locator for the element will be displayed in the Developer Console.
// Double-click the locator (or select and use <code>Ctrl+C</code>) to copy it to the clipboard.
// <p>
// <b>2.-</b> Via the +link{AutoTest.installLocatorShortcut()} script. After running the
// scriptlet to install the locator shortcut, you can simply click on the target element
// while holding down the appropriate modifier keys and the appropriate locator string
// will be copied to the clipboard.
// <P>
// <b>Resolving locators back to DOM elements in Cypress</b>
// <P>
// A stored locator string can be resolved back to a DOM element via +link{AutoTest.getElement()}
// or +link{AutoTest.waitForElement()}. Using <code>waitForElement()</code> is preferable 
// as this will not resolve until any active, asynchronous operations within an application
// have completed.
// <P>
// The sample <code>commands.js</code> file includes a command <code>"getSC"</code> which uses
// <code>waitForElement()</code> to wait for any pending system actions, then
// resolve an AutoTestLocator to its target DOM element and yield it back.
// You can make use of this command in your test code as follows:
// <pre>
//  cy.getSC(&lt;locator&gt;).click();
// </pre>
// <p>
// <b>Cypress actions native scroll behavior</b>
// <P>
// By default Cypress actions such as +externalLink{https://docs.cypress.io/api/commands/click,click}
// can cause the target element to be scrolled on the page. See the <code>scrollBehavior</code>
// option described 
// +externalLink{https://docs.cypress.io/guides/references/configuration#Actionability,here}.
// <P>
// In some cases SmartClient components may redraw synchronously on scroll which may
// interfere with your Cypress test's execution.
// For example if a listGrid is +link{ListGrid.showAllRecords,incrementally rendering} its
// records, a scroll may require a redraw to ensure the user doesn't see unrendered cells that
// were previously outside the viewport. If this happens while a Cypress click action is in 
// progress, Cypress will throw an error as the target element will have been replaced 
// in the DOM while the action was still in progress. Developers may avoid this problem 
// by ensuring the target element is already scrolled into view, and specifying
// <code>scrollBehavior:false</code> on Cypress' click command options.
// <p>
// <P>
// <b>Scrolling SmartClient components</b>
// <P>
// In some cases a Cypress test may need to explicitly change the scroll position of
// a SmartClient component.
// <P>
// For SmartClient skins that use +link{Canvas.showCustomScrollbars,custom scrollbars}, the Cypress
// +externalLink{https://docs.cypress.io/api/commands/scrollto,scrollTo} command may not see the component
// as a valid target for scrolling. For this reason the sample <code>commands.js</code> file includes
// a <code>scrollSC()</code> command. This command takes a locator plus target left and top position
// as arguments. Note that you can specify left and top as an explicit pixel position, or use
// a percentage string like "50%". For example, to scroll some component to its mid point vertically
// while leaving the horizontal scroll position unchanged you could invoke:
// <pre>
//  cy.scrollSC(&lt;locator&gt;, null, "50%");
// </pre>
// <b>Interacting with SmartClient FormItems</b>
// <p>
// SmartClient's SelectItem, ComboBoxItem and CheckboxItem are based on custom HTML rather than built-in 
// browser controls, because this is required to provide advanced functionality such as multi-column dropdowns.  
// Because of this, the <i>check()</i> and <i>uncheck()</i> functions for CheckboxItem
// and the <i>select()</i> function for SelectItem and ComboBoxItem are not applicable.
// <p>
// Instead, the "click()" function is the way to interact with these controls, for example:
// <pre>
//      cy.visit('https://smartclient.com/smartclient-latest/showcase/?id=updateOperation')
//
//      // Click to start editing the grid
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]' +
//              '/member[index=1||length=4||Class=ListGrid||classIndex=0||classLength=1]/body/row[1]/col[2]'
//      ).click()
//
//      // Type a value into the 'description' item
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' +
//              'member[index=2||length=4||Class=DynamicForm||classIndex=0||classLength=1]/item[name=description]/element'
//      ).type('Glue Pelikan Roll-fix Refill Permanent #955')
//
//      // Click the 'units' item to show the pickList
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' +
//              'member[index=2||length=4||Class=DynamicForm||classIndex=0||classLength=1]/item[name=units]/textbox'
//      ).click()
//
//      // Click a value in the pickList drop down
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' + 
//              'member[index=2||length=4||Class=DynamicForm||classIndex=0||classLength=1]/item[name=units]/pickList/body/row[3]/col[0]'
//      ).click()
//
//      // Click to toggle the value of the 'inStock' checkbox'
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' +
//              'member[index=2||length=4||Class=DynamicForm||classIndex=0||classLength=1]/item[name=inStock]/valueicon'
//      ).click()
//
//      // Click the Save button
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' +
//              member[title=Save]/'
//      ).click()
//
//      // Verify the value has been updated
//      cy.getSC('//testRoot[]/child[index=0||length=1||Class=VStack||classIndex=0||classLength=1]/' +
//              'member[index=1||length=4||Class=ListGrid||classIndex=0||classLength=1]/body/row[1]/col[2]'
//      ).invoke('text').then((text) =&gt; { 
//          expect(text.trim()).to.equal('Glue Pelikan Roll-fix Refill Permanent #955')
//      })
// </pre>
// <b>Using force-click to dismiss +link{Canvas.showClickMask(),click masks}</b>
// <P>
// In some cases you may need to dismiss a SmartClient click-mask by clicking.
// Examples include certain styles of drop-down, grid editing interactions, etc. - that are dismissed 
// via an outside-click. Cypress will reject attempts to send a <code>click()</code> to some 
// element under the click-mask by default as the target element will be obscured by the click mask
// in the DOM, and so is not directly "visible" as far as Cypress is aware. You can handle this by
// specifying +externalLink{https://docs.cypress.io/api/commands/hover#Force-click,&#123;force:true&#125;}
// on your click command.
// <P>
// For example if you have a <i>multiple:true</i> SelectItem, a clickMask is used to watch
// for the user clicking outside the SelectItem drop-down.
// To dismiss the drop-down from a Cypress test,
// we recommend sending a <code>{force: true}</code> click() 
// command to some other element on the page:
// <pre>
//     cy.getSC(&lt;locator&gt;).click({force: true})
// </pre>
// In this case <i>&lt;locator&gt;</i> refers to the target component that we click on the app to 
// dismiss the dropdown. Note that depending on how the application is configured, this click may
// dismiss the dropdown and prevent the click action from firing for the target that was actually
// clicked. You can handle this by invoking a second click to mimic 
// the user interaction. For example:
// <pre>
//     cy.getSC(&lt;locator&gt;).click({force: true}).click()
// </pre>
// <P>
// <b>Waiting for Asynchronous application actions</b>
// <P>
// Because the <code>getSC()</code> command uses +link{AutoTest.waitForElement()}, which will not resolve
// until all +link{AutoTest.isSystemDone(),outstanding asynchronous system actions have completed}, it is
// not usually necessary to write test code that explicitly waits for actions to complete 
// (using <code>cy.wait()</code> calls, for example).<br>
// To put it another way: 
// if an action in a test kicks off a SmartClient DataSource operation
// and the next action is using <code>getSC()</code> to interact with another SmartClient component, 
// the test will automatically wait for the asynchronous operation from the first action to complete 
// before proceeding with the second action.
// <P>
// This alone may not be sufficient to handle every asynchronous behavior in an application.
// In some cases you may want to explicitly wait for the SmartClient framework to complete some action 
// without having a subsequent <code>getSC()</code> call in your test. The +link{AutoTest.waitForSystemDone()}
// method can be used to handle this. The <code>commands.js</code> sample file includes 
// a custom command <code>"waitForSCDone"</code> which wraps this method in a Cypress command.
// <P>
// To explicitly wait for all asynchronous SmartClient actions to complete, call the method in your
// test code as follows:
// <pre>
//  cy.waitForSCDone();
// </pre>
// Additionally you may have asynchronous behaviors that are unrelated to SmartClient interactions, such
// as network activity that does not go through the SmartClient +link{RPCManager}, asynchronous rendering
// of third party widgets, etc. In these cases +link{AutoTest.isSystemDone()} may return true even though
// the application is not ready for further input.
// <P>
// The <code>options</code> parameter for <code>getSC()</code> can be used to 
// change the +link{ElementWaitConfig.waitStyle,waitStyle} passed to +link{AutoTest.waitForElement()}.
// If you request <code>"element"</code> rather than <code>"system"</code>, instead of relying on
// +link{AutoTest.isSystemDone()}, the framework will continue trying to resolve the locator to
// an element until the command times out. This gives you an easy way to instruct the test case
// to keep trying to resolve a locator even after +link{isc.AutoTest.isSystemDone()} returns true.
// <P>
// Both <code>waitForSCDone()</code> and <code>getSC()</code> support being passed an explicit
// timeout on the <code>options</code> parameter. This governs how long the commands
// will wait for system quiescense / for the locator to be resolved. If no explicit
// timeout was specified, the default wait time for these commands is 30 seconds,
// but this can be customized by setting <code>"scCommandTimeout"</code> in your Cypress config.
// <P>
// Note that as long as <code>waitStyle</code> is set to <code>"system"</code>, it is very rare for
// <code>getSC()</code> commands to time out as the application will wait for
// +link{AutoTest.isSystemDone()} and then attempt to resolve the locator. If it fails to
// resolve the locator to an element it will return <code>null</code> immediately rather than
// continue attempting to resolve the locator until the command times out.
// <P>
// If <code>getSC()</code> or <code>waitForSCDone()</code> does time out the Cypress test
// will fail.
// <P>
// <b>Logging Timing information for +link{RPCRequest,RPC} and +link{DSRequest,DataSource} transactions</b>
// <P>
// SmartClient provides a number of helpful APIs which allow developers to intercept slow client-server requests
// and get timing data, indicating how much time was elapsed in the various processing steps. 
// <P>
// Cypress tests can make use of these capabilities to log timing information for slow requests, and 
// optionally cause the test to fail.
// <P>
// The primary APIs for this are as follows:
// <ul>
//  <li>+link{RPCManager.setTimingDataEnabled()} - this method turns on logic to record 
//      detailed timing data (client and server side) on every SmartClient RPC transaction</li>
//  <li>+link{RPCManager.addProcessingCompleteCallback()} - this allows you to register a callback 
//      function to fire after every SmartClient RPC transaction completes</li>
//  <li>+link{RPCManager.getTransactionDescription()} - this method returns a brief description of
//      a transaction</li>
//  <li>+link{RPCManager.getTimingData()} - returns the timing data for a transaction as a +link{Tree}</li>
//  <li>+link{RPCManager.getFormattedTimingData()} - this formats the timing data as a string 
//     for logging purposes</li>
// </ul>
// The sample <code>commands.js</code> file includes a command <code>"enableSC_RPCTimeout"</code>
// which makes use of +externalLink{https://nodejs.org/api/events.html#class-eventemitter,Event emitters}
// in Cypress to take advantage of these APIs and log timing information for slow requests.
// <P>
//  <code>enableSC_RPCTimeout</code> should typicaly be called only once, at the beginning of your test. It will remain active
// as long as the page is loaded. The command takes the following arguments:
// <ul><li><code>logThreshold</code> Any RPCs whose duration exceeds this threshold will log timing information
//         via a <code>cy.log()</code> call.</li>
//     <li><code>timeoutThreshold</code> Any RPCs whose duration exceeds this threshold will cause the test to fail.</li>
//     <li><code>options</code> This parameter in an object where you can set various attributes to configure 
//         logging behavior. These include:
//          <ul>
//              <li><code>logDetail</code>: one of <code>"none"</code>, <code>"summary"</code>, 
//                  <code>"detailed"</code> or <code>"all"</code></li>
//              <li><code>logSuccess</code>: If true, log a 'success' type notification for RPC transactions
//                  that do not exceed the specified timing threshold. This log will not include any 
//                  explicit timing data</li>
//              <li><code>includeClientTimings</code>: Should detailed timing for client-processing be included?</li>
//              <li><code>includeServerTimings</code>: Should detailed timing for server-processing be included?</li>
//          </ul>
//     </li>
// </ul>
// See the implementation in <code>commands.js</code> for more details.
// <P>
// Here's an example of how this might be used in a <code>.cy.js</code> file:
// <pre>
// // If the turnaround takes more than this many millis, log the timing information
// const LOG_TIMEOUT = 1000;
// // If the turnaround takes longer than this many millis, the test fails
// const FAILURE_TIMEOUT = 5000;
// 
// describe('Test Suite', () =&gt; { 
//
//     beforeEach(() =&gt; {
//         cy.visit(&lt;target url&gt;); 
//         cy.enableSC_RPCTimeout(LOG_TIMEOUT, FAILURE_TIMEOUT, {logDetail:"detailed"});
//     });
//   
//     it('Perform some test', () =&gt; {
//         ... // test code goes here
//     });
//
// });
// </pre>
// Note: <code>enableSC_RPCTimeout()</code> is effectively "invisible" to the flow of your test unless 
// a transaction is encountered which exceeds the timeoutThreshold. If you want to 
// explicitly wait for all pending actions to complete at any point, including waiting for active RPCRequests
// to be resolved, you can use the <code>waitForSCDone</code> command described above.
// <P>
// <b>Drag and Drop Interaction</b>
// <p>
// To achieve this goal, the easiest way is to use a specialized plugin for Cypress, where you only 
// need to run the following command:
// <pre>
//     npm install --save-dev @4tw/cypress-drag-drop
// </pre>
// Finally, you need to add the following code to the commands.js file:
// <pre>
//     require("@4tw/cypress-drag-drop");
// </pre>
// This way, you can perform drag and drop interactions by simply running the following command:
// <pre>
//     cy.get('@source').drag('@target')
// </pre>
// where '@source' is obtained via <i>cy.get()/getSC(&lt;locator&gt;).as('source')</i> and 
// '@target' via <i>cy.get()/getSC(&lt;locator&gt;).as('target').</i>
// <P>
// <b>Final Note</b>
// <P>
// In addition to the custom commands and approaches described above, 
// developers can also always use the
// +externalLink{https://docs.cypress.io/api/commands/window,cy.window()} command 
// to execute arbitrary JavaScript with access to the application scope.
// <P>
// <b>Cypress configuration for custom SmartClient commands</b>
// <P>
// The custom commands shipped in the SmartClient SDK will respect the following 
// settings if present in the Cypress configuration:
// <ul>
// <li><i>scLogCommands</i>: Boolean - if true each command will be logged via cy.log()</li>
// <li><i>scCommandTimeout</i>: Number - default timeout for getSC() and waitForSCDone() in ms</li>
// </ul>
//
//
// @treeLocation Concepts/Automated Testing
// @title Integrating SmartClient with Cypress
// @visibility external
//<

//> @groupDef usingSelenium
// +externalLink{http://seleniumhq.org/,Selenium} is a powerful and popular tool which can be
// used to test your SmartClient applications. 
// <p>
// <i>For an overview of Automated Testing in SmartClient, see the documentation +link{group:automatedTesting,here}.</i>
// <p>
// Selenium executes tests against your running application in a browser emulating user
// interaction and asserting various conditions.
// Selenium provides a record/playback tool for authoring tests without learning a test
// scripting language - we refer to these as Selenium scripts or <i>Selenese</i>.  You must be
// familiar with +externalLink{http://seleniumhq.org/,Selenium} and use of
// +externalLink{http://seleniumhq.org/projects/ide/,Selenium IDE} before proceeding.  Refer to
// the documentation on the Selenium site.
// <P>
// <b>Note that Selenium IDE 3 for Firefox Quantum has been released, but only recently added
// plugin APIs that should eventually allow us to add support for our our custom locators and
// commands (replacing our JavaScript user extensions from Selenium IDE 2.9).  For now, if you
// want to write Selenese as this section describes, you must use Selenium IDE 2.9, which can
// be installed in 
// +externalLink{https://www.mozilla.org/en-US/firefox/organizations/,Firefox 52 ESR}, the
// extended-support release of Firefox which is still receiving updates at the time of this
// writing.</b>
// <P>
// Selenium supports the concept of +externalLink{http://seleniumhq.org/docs/02_selenium_ide.html#locating-elements,Locators}
// in order to specify the element you'd like a given Selenium command to target. For example Selenium supports XPath based
// locators and DOM ID based locators. XPath based locators are extremely fragile due to complexity of certain 
// highly nested DOM elements you need access to combined with the fact that XPath support varies across browsers and 
// so your tests might not work across different browsers. 
// <P>
// Use of Selenium with SmartClient applications is no different than using Selenium to write and run test cases with 
// any other application with the exception of one caveat: SmartClient occasionally renders a different DOM structure 
// depending on the browser for performance or rendering the UI such that it appears identical across various browsers. 
// As a result using DOM ID or DOM XPath based locators with SmartClient applications is not advisable. 
// <P>
// Instead SmartClient supports a new Selenium locator which is an XPath-like string used by Selenium to robustly identify 
// DOM elements within a SmartClient application. SmartClient locators for Selenium are prefixed by "scLocator=" and have a 
// readable XPath-like value even for cells in ListGrid's or TreeGrids. Typically these locators will not be hand-written and 
// are generated by +externalLink{http://seleniumhq.org/projects/ide/,Selenium IDE}, Selenium's test recording tool. One primary
// locator is based on the ID of the SmartClient widget and has the syntax <b>ID=&lt;Canvas ID&gt;</b>. This simplifies the task of 
// writing tests if you know the ID of the Canvas. For reference, the scLocator syntax for ListGrid cells and DynamicForm 
// FormItems can be found at the end of this document.
// <P>
// <b>You can automate the process of running Selenium tests and saving or reporting results
// using +link{group:testRunner,TestRunner}.</b>
// <P>
// <b>Setup Instructions</b>
// <P>
// SmartClient ships with two Selenium user extension Javascript files: 
// <P>
// <ul>
// <li> user-extensions.js
// <li> user-entensions-ide.js
// </ul>
// <P>
// These extensions (found in the 
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory) augment the Selenium tools to support SmartClient locators. To integrate these extensions with Selenium, 
// follow the steps below:
// <P>
// <ul>
// <li> Confirm that the Selenium IDE has been installed.
// <li> Copy the user extension files listed above to a common location on your test client machine.
// <li> Open the Selenium IDE and click the Options ==&gt; Options... menu item. On the General tab enter the path to these extension 
// files in the corresponding fields: Selenium Core extensions and Selenium IDE extensions. Refer to the Selenium Documention 
// on +externalLink{http://seleniumhq.org/docs/08_user_extensions.html#using-user-extensions-with-selenium-ide,user extensions} 
// for more information.
// <li> Go to the WebDriver tab and ensure that the "Enable WebDriver Playback" checkbox is unchecked.
// <li> Close and restart Selenium IDE to load the new extensions.
// </ul>
// <P>
// That's it, we're done configuring the environment.
// <P>
// Note: Tests recorded using Selenium IDE can be played back programmatically (e.g. from a test
// harness) using
// +serverDocLink{com/isomorphic/webdriver/SeleneseRunner.html,SeleneseRunner},
// a simulation tool that executes Selenese against SmartClient's WebDriver wrappers.  This is
// required because Selenium 3 no longer supports executing Selenese using custom user
// extensions, as it no longer contains much of the Selenium RC code base.
// <P>
// <b>Recording Selenium tests with Selenium IDE</b>
// <P>
// Once you have your application running in Firefox, open Selenium IDE from the Tools ==&gt; Selenium IDE menu option. If the Selenium IDE
// is in record mode, then clicking or carrying out other operations like typing in a text field with automatically record the 
// appropriate Selenium commands with the SmartClient locator. In most cases there's no need for you to manually enter the locator, 
// the recorder does this for you! In fact, not only do the provided user extension files record your clicks, drag operations, and 
// typing in the browser--they also try to ensure that your script executes each operation only when the SmartClient widgets it depends 
// upon exist and are ready to be interacted with.  This ensures that when the test script is executed, then even if one or more triggered 
// operations are asynchronous (delayed), it behaves as expected.
// <P>
// In the screenshot below, note the <b>waitForElementClickable()</b> operation above the click operation; it was added automatically by our 
// user extensions as the click itself was recorded: 
// <P>
// <img src="skin/user-guide-images-selenium/selenium-ide-example.png" width="1017px" height="853px">
// <P>
// Sometimes users may also want finer grain control of what Selenium command is created instead of having the Selenium IDE recorder 
// do this automatically. For example if you want to verify the value of a particular cell in a ListGrid. Instead of typing in the 
// command "verifyTable" and manually enter the SmartClient Locator (scLocator), you can simply right click on the table cell or any 
// other SmartClient widget and the most suitable Selenium commands will appear in the context menu along with the scLocator path for 
// the clicked element. See image below.
// <P>
// <img src="skin/user-guide-images-selenium/selenium-ide-example-verifyText.png" width="1211px" height="737px">
// <P>
// <b>Solving Ordering Issues in Selenium Scripts</b>
// <P>
// Fundamentally, the reason we add <b>waitForElementClickable()</b> calls before each click is to deal with asynchronous SmartClient
// operations. Many operations on widgets or the network are asynchronous, and a correctly coded test should wait for such operations to 
// complete as opposed to inserting an arbitrary delay or using Selenium's <b>setSpeed()</b> function. Using such delays runs the risk of 
// the test failing if replay occurs on a loaded machine or slow network, and also makes the test run slower than needed. 
// <P>
// Asynchronous operations include:
// <P>
// <ul>
// <li> any actual network operation,
// <li> any DataSource operation (even for a clientOnly DataSource),
// <li> any situation where a widget can be marked "dirty" (see notes at <b>Canvas.isDirty()</b>), and then asynchronously 
// redraw itself - this includes API calls like <b>ListGrid.setData()</b>, <b>Canvas.setContents()</b> as well as user interactions like 
// ListGrid sort or filter, regardless of whether the data is already present,
// <li> re-layout that occurs as a result of a size change or new member being added to a Layout or subclass of Layout (eg SectionStack, Window)
// </ul>
// <P>
// The following operations are synchronous and don't require waiting:
// <P>
// <ul>
// <li>draw()ing any widget that has no parent - but note adding a widget to an already-drawn Layout is asynchronous, as above
// </ul>
// <P>
// You may encounter cases where you have to manually insert a <b>waitForElementClickable()</b> or <b>waitForElementNotPresent()</b>
// to get a script to behave properly.  Looking at the SmartClient Showcase Example (Grids / Filtering / Advanced Filter), suppose 
// we wanted to filter by country names containing "Za" and wait for the filter step to complete before proceeding.  Since the 
// ListGrid initially contains many entries and Zaire is not among them, it is not visible and thus we can solve the original 
// problem by manually adding a <b>waitForElementClickable()</b> on the locator for Zaire's ListGrid entry:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>scLocator=//ListGrid[ID="filterGrid"]/body/row[pk=216||countryCode=CG||215]/col[fieldName=countryCode||0]</b>
// <P>
// Before the filter operation is issued, the locator is not clickable because the record is not visible:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-clickable-before.png" width="767px" height="327px">
// <P>
// When the filter operation completes, Zaire and the other search results become visible and the <b>waitForElementClickable()</b> 
// returns successfully allowing the next script command to execute:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-clickable-after.png" width="763px" height="328px">
// <P>
// Finally, suppose you wanted to do another filter operation to look only at countries (from the previous search results) with 
// populations under 30 million.   Since Zaire is above this limit, it will be missing from the search results and you could 
// wait for the filter operation to complete by adding a <b>waitForElementNotPresent()</b> on same locator that we previously used 
// for <b>waitForElementClickable()</b>. It will return true and allow the script to proceed when the filter operation completes:
// <P>
// <img src="skin/user-guide-images-selenium/manual-wait-not-present.png" width="762px" height="317px">
// <P>
// <b>Waiting on Pending ListGrid Operations</b>
// <P>
// There are cases where <b>waitForElementClickable()/waitForElementNotPresent()</b> will not work--for example if you're performing 
// a sort that's rearranging existing elements on the screen, or if you're performing a filter operation where you're not sure of
// the results and thus cannot use the approach from the previous section.  In such a situation, you may need to add a 
// <b>waitForGridDone()</b> command into your script to ensure the pending operations are complete before you hit the next command.
// <P>
// The <b>waitForGridDone()</b> command guarantees it will not complete successfully unless all of the following potential pending 
// operations on the widget are complete:
// <P>
// <ul>
// <li> any fetch or filter operation (the result of applying criteria),
// <li> any sort operation (the result of apply sort specifiers),
// <li> the flush of pending FilterEditor criteria to the parent ListGrid, and
// <li> the saving of any newly edited rows.
// </ul>
// <P>
// This command should be able to block a Selenium script until the ListGrid specified in the locator reaches a stable drawn state with 
// no pending activity.  So for a ListGrid names 'filterGrid', all you'd need to add to ensure all pending operations on it have
// completed is the command:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>waitForGridDone("//ListGrid[ID='filterGrid']");</b>
// <P>
// <P>
// <b>Waiting on All Pending Network Operations</b>
// <P>
// Because of the <b>waitForElementClickable</b> commands which are automatically inserted during recording, your scripts will
// automatically wait for the completion of any network operations that block interactivity (via showPrompt, which is enabled by 
// default). However in some cases you may want to wait for all pending network operations to complete, even if they don't block
// user interactivity.
// <P>
// To do this, use <b>RPCManager.requestsArePending()</b> in combination with <b>waitForCondition()</b>.
// So, the JavaScript in your <b>waitForCondition()</b> operation would be:
// <P>
// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>!selenium.browserbot.getCurrentWindow().isc.RPCManager.requestsArePending()</b>
// <P>
// When the call returns, you'd know that any previously initiated network operations--such as filter/sort operations on DataSources--are 
// complete.
// <P>
// <b>Automatically Waiting on All Pending Network Operations</b>
// <P>
// If you need the functionality from the section above to wait on all pending network operations, but don't want to add extra calls to
// <b>waitForCondition()</b>, you may switch on automatic enforcement of the condition that <b>isc.RPCManager.requestsArePending()</b>
// is false.  There are two ways to do this:
// <P>
// <ul>
// <li> Set the property <b>isc.AutoTest.implicitNetworkWait</b> to true on the page under test after the ISC modules are loaded, or
// <li> Add the Selenium command <b>setImplicitNetworkWait(true)</b> to your selenium script in Selenium IDE.
// </ul>
// <P>
// Like other Selenium IDE commands with a single argument, you'll want to use <b>setImplicitNetworkWait()</b> by passing <b>true</b>
// (or <b>false</b>) in the Target field of the Selenium IDE GUI (right under command). Without any modifications, the default value 
// for <b>isc.AutoTest.implicitNetworkWait</b> of <b>false</b> will prevail.
// <P>
// <b>Keystroke Capturing</b>
// <P>
// Our Selenium Extensions will automatically record the following type of keyboard activity
// in SmartClient widgets, on a keystroke-by-keystroke basis:<ul>
// <li>typing at widgets other than text items (e.g. ListGrids), including normal printing
// characters, navigation keys (up, right, etc.), or modifier sequences (e.g. Ctrl-V)
// <li>typing of printing characters in masked text items</ul>
// Unmasked text items are handled differently - we don't record individual keystokes, but
// instead record the complete text as a "type" command when we get a "change" event for the
// element.  This event is normally sent when you exit a text item by clicking elsewhere or
// tabbing into the next form item.  However, in certain situations the event may not be sent -
// one is when the text item is a managed +link{group:autoChildUsage,auto child} of another
// form item (e.g. +link{MultiComboBoxItem}).  In this case, you can tap Alt (Option on Mac) to
// manually insert a "type" command with the right value.
// <P>
// <b>Recording Movement-Driven Interactions</b>
// <P>
// Our Selenium Extensions provide the capability to automatically record click-based
// interactions with the target page, and keystrokes (under certain circumstances).  However,
// we don't automatically capture interactions based solely on movement, such as when a nested
// menu flyout is triggered by moving the mouse over the menu item of an existing menu.
//
// To avoid problems:<ul>
// <li>If you're trying to record interactions with menus or submenus of a ListGrid, the
// recommended approach is to use a right mouse click (i.e. "context menu" command) interaction
// to record the opening of the initial menu, rather than clicking on the HeaderMenuButton
// that's shown on the header buttons. For the submenus, it's recommended to click on the 
// appropriate (parent) menu item to properly record what's needed, even though the child menu
// is already visible from your mouse movement.
// <li>To manually record a "mouse move" operation over the current element, you can simply
// press the Alt key (Option on Mac).  (See also "KeyStroke Capturing" above for behavior over
// text items.)
// <li>If you find yourself often having to add commands manually (other than through the above
// mechanism), you may be approaching the situation incorrectly.  In that case check the
// +externalLink{http://forums.smartclient.com,forums} to see if it's a common problem.
// </ul>
// <P>
// <b>Capturing Logs</b>
// <P>
// Capturing of client and server-side logs can be switched on by providing appropriate options to +link{testRunner},
// but a few Selenium commands are provided to provide direct control over logging on a per-script basis.  If
// server logging has been configured as "some," then server logs won't be captured for a given script unless you
// add the captureServerLogs() Selenium command after the open command; switching the mode to "all" will force
// server logs to be collected for all Selenium scripts, and no captureServerLogs() command is then required.
// <P>
// To configure logging levels, you can use the commands <b>setClientLogLevel(category, level)</b>, or
// <b>setServerLogLevel(category, level)</b>.  For example:
// <ul>
// <li><b>setClientLogLevel("AutoTest","ERROR")</b>, or
// <li><b>setServerLogLevel("com.isomorphic.rpc.RPCManager", "INFO")</b>
// </ul>
// Note that when entering the above examples into Selenium IDE, you need neither parentheses nor quotes,
// as everything is considered a string and there are fixed slots for each.
// <P>
// <b>Disabling the Selenium SmartClient URL Query String</b>
// <P>
// By default, our user extensions automatically add a special URL variable, <b>sc_selenium</b>, to open command urls to allow 
// JavaScript to detect it's being driven by Selenium in case special logic should be used.  In the unlikely event that this causes a 
// problem with your code or page loading and you don't need the feature, you may eliminate this special URL variable by changing
// <b>Selenium.prototype.use_url_query_sc_selenium</b> from <b>true</b> to <b>false</b> in user-extensions.js.
// <P>
// <hr>
// <P>
// <b><u>Common scLocator syntax</u></b>
// <P>
// For more information on how locators are formed and how to influence them, see the +link{AutoTest,AutoTest} class in 
// the SmartClient Reference. 
// <P>
// <b><u>List Grid cells</u></b>
// <P>
// <b>//ListGrid[ID="itemList"]/body/row[itemID=1996||itemName=Sugar White 1KG||SKU=85201400||1]/col[fieldName=SKU||1]</b>
// <P>
// <ul>
// <li> This assumes the ListGrid has an explicit ID
// <li> the 'body' part might be 'frozenBody' if the field in question was frozen
// <li> row[......] identifies the row (record)
// <li> itemID= - that's the primary key field from the dataSource the grid is bound to
// <li> itemName= - that's the title field value for the record
// <li> SKU=... - that's the cell the user clicked's value
// <li> 1 - that's the index of the row (rowNum)
// <li> col[.....] - identifies the column in the grid
// <li> fieldName=... - field name for the field the user clicked
// <li> 1 - that's the index of the column
// </ul>
// <P>
// <b><u>Form Items</u></b>
// <P>
// <b>//DynamicForm[ID="autoTestForm"]/item[name=textField||title=textField||value=test||index=0||Class=TextItem]/element</b>
// <P>
// This example is the data element (text entry box) for a text field 
// <P>
// <ul>
// <li> this form has an explicit ID
// <li> item[...] identifies the item
// <li> name (field name, if set)
// <li> title (title, if set)
// <li> value (current value if set)
// <li> index (index in the form items array)
// <li> Class (SC class of the item - in this case TextItem) after the "/" we identify the part of the item in question options here include:
// <li> "element" - the data element
// <li> "canvas" - for CanvasItems - points to the canvas embedded in the item
// <li> in this case the xpath might continue to contain, for example children of the canvas or elements within it (cells in a listGrid, etc)
// <li> "textbox" - the "text box" - this is the area where content is written out for items without a 'data element' - like header items
// <li> "[icon=&lt;...&gt;]" - the icon element -- "&lt;...&gt;" would contain the "name" of the icon
// </ul>
// <P>
// <hr>
// <P>
// <b><u>Special scLocator usage</u></b>
// <P>
// <b><u>Verifying icon/image loading</u></b>
// <P>
// If you manually add <b>/imageLoaded</b> to the end of the locator generated for a
// +link{Button} or +link{Img}, then +link{AutoTest.getElement()} or +link{AutoTest.getValue()}
// can be used to verify whether the icon (in the case of a <code>Button</code>) or image (for 
// an <code>Img</code>) have been loaded succesfully.
// <P>
// Examples:<ul>
// <li><b>//Button[ID="cssButton"]/imageLoaded</b>
// <li><b>//IButton[ID="stretchButton"]/imageLoaded</b>
// <li><b>//ImgButton[ID="imgButton"]/imageLoaded</b>
// <li><b>//Img[ID="photo"]/imageLoaded</b></ul>
// <P>
// <b><u>Verifying DrawItem attributes</u></b>
// <P>
// If you record a locator to a +link{DrawItem}, by default its value will be the
// +link{drawItem.title,title}, or the +link{drawLabel.contents,contents} for a 
// +link{DrawLabel}.  However, other attributes, as listed below, can be queried by adding a
// trailing suffix.  (Those appearing as links call the associated getter rather than accessing
// a property directly.)  Note that not all properties listed are available on all
// +link{DrawItem}s, and that if multiple values are present, they will be separated by a
// single space when the Framework passes them to Selenium.
// <ul>
// <li><b>src</b>
// <li><b>rotation</b>
// <li><b>fillColor</b>, <b>lineColor</b>
// <li><b>top</b>, <b>left</b>, <b>width</b>, <b>height</b>
// <li><b>lineWidth</b>, <b>lineOpacity</b>, <b>fillOpacity</b>
// <li><b>+link{drawItem.getCenter(),center}</b>
// <li><b>+link{drawItem.getBoundingBox(),boundingBox}</b>
// <li><b>+link{drawItem.getResizeBoundingBox(),resizeBoundingBox}</b>
// </ul>
// <P>
// Examples:<ul>
// <li><b>//DrawRect[ID="myRect"]/width</b>
// <li><b>//DrawTriangle[ID="bigTriangle"]/resizeBoundingBox</b>
// </ul>
// <hr>
// <P>
// <b><u>Best Practices</u></b>
// <P>
// <ul>
// <li> <b>Maximize the test browser window to avoid offscreen widgets</b>: Some browsers will not respond to events on widgets 
// that are not visible in the browser pane (scrolled out of view or clipped off). To avoid having to manually add script commands to 
// scroll such widgets into view, it's recommended to use Selenium's <b>windowMaximize()</b> command which will force the browser to 
// occupy the entire screen.
// <P>
// Note that currently some browsers will respond to events on offscreen widgets (IE will, Firefox will not) however, web standards 
// are unclear on whether this should be allowed and the behavior may change in the future, so best practice is to maximize for all 
// browsers.
// <P>
// <li> <b>Use setID() judiciously to ensure stable locators run-to-run</b>: When setID() is not used to supply a unique component ID,
// locators will sometimes incorporate automatically generated IDs which have a sequence number (eg isc_Object_355). If your test 
// has unpredictable execution order (for example, two simultaneous network operations take place and either may complete first, 
// and both generate UI components on completion) then these IDs will not be stable from run-to-run. They will likewise not be stable 
// if you test part of an app and then embed it in a larger app and try to use the same script.
// <P>
// Use setID() selectively to avoid this problem. Generally, it makes sense to use setID() on all top-level (parentless) widgets - at 
// this point, locators for children that do not have a unique ID will be based on the parent's ID plus a relative path. This relative 
// path will not incorporate auto-generated IDs and will generally continue to work even if the interior layout of the parent is 
// significantly rearranged (such as adding a new intervening container widget).
// </ul>
// <P>
// <hr>
// <P>
// <b><u>Known Limitations</u></b>
// <ul>
// <li> Selenium intermittently fails to generate an scLocator with the "type" command on some FormItems. If this occurs, you can 
// manually enter an scLocator into the target field, or use the drop down to select an alternative locator strategy (such as locating
//  a text input element by name).
// <li> Support for multi-select for SelectItems with selection mode "grid" (non-default)
// </ul>
// <P>
// @treeLocation Concepts/Automated Testing
// @title Using Selenium Scripts (Selenese)
// @visibility external
//<

//> @groupDef testRunner
// The SmartClient TestRunner is a system for running a suite of Selenium tests on a periodic
// basis, comparing the results to previous results, and generating email alerts reporting on
// new test failures or fixes to tests that were previously failing.
// <P>
// TestRunner is a key piece of implementing the <i>Continuous Integration</i> methodology,
// whereby continuous testing is applied so that regressions are caught immediately.  This
// allows a product or application to be kept continuously at a very high level of quality,
// allowing for more frequent and predictable releases.
// <P>
// <h3>Database Setup</h3>
// <P>
// Each time TestRunner executes it by default stores results to a SQL database via two 
// SQLDataSources:
// <ul>
// <li><b>batchRun.ds.xml</b>: stores global information about the run as a whole: an ID for
//    the run, when it started and ended, and optional data to be used in emails generated by
//    the system.
// <li><b>testResult.ds.xml</b>: stores the result of each individual test, including when it
//    started and ended, and information about errors that occurred, if any
// </ul>
// These DataSources are present in the 
// <smartclient><code>smartclientSDK/tools/selenium/</code></smartclient>
// <smartgwt><code>selenium/</code></smartgwt>
// directory of your SDK.  If you choose to move them elsewhere, simply update the DataSources
// location (configured by <code>project.datasources</code> in 
// +link{server_properties,server.properties}).
// <P>
// These DataSources behave just like other SQLDataSources: 
// <ul>
// <li> they are compatible with all the database types that SmartClient supports
// <li> they will use the default database configured for your project, or you can set
//      +link{dataSource.dbName} in the .ds.xml file to use a second database instead
// <li> you can setup the database connection and generate SQL tables using the
//      +link{adminConsole}
// <li> you can build your own UI for viewing test results, by loading the
//      <code>batchRun</code> and <code>testResult</code> DataSources like any other
//      SQLDataSource and binding components such as ListGrids to them.
// <li> if you deploy an application that includes these DataSources, third-party tools can
//      access these DataSources via the RESTHandler servlet
// </ul>
// <P>
// If needed, the IDs of these DataSources can be configured via the 
// +link{server_properties,server.properties} settings
// <code>autotest.batchRunDS</code> and <code>autotest.testResultDS</code>.
// <P>
// Note: If you use the default server.properties shipped with the SDK, TestRunner and the 
// SDK web server will share a common SQL database, so that the web server and TestRunner
// cannot both run at once.  This means that you must point TestRunner at the web server of
// a separate SDK installation - on a separate matchine or in a separate filesystem location.
// <P>
// <h3>Adding Test Files</H3>
// <P>
// TestRunner currently supports tests written in Selenese, Selenium's HTML-based format for
// recording automated tests.  The Selenium IDE can be used to record tests and save them in
// Selenese format.  For more background on the Selenium IDE, SmartClient's extensions, and
// the use of Selenium WebDriver, see the 
// +link{group:automatedTesting,Automated Testing Overview}.
// <P>
// Test files should be saved with the extension .rctest.html.  They should all appear under
// a common root directory (called <code>testRoot</code>), but any level of nesting is allowed,
// and any other files that appear under <code>testRoot</code> will be ignored; only
// .rctest.html files will be processed.
// <P>
// The <code>testRoot</code> directory is passed to TestRunner when you execute it.  In the
// database and in emails, test are identified by their directory path relative to
// <code>testRoot</code>.
// <P>
// Adding a test to the test suite is as simple as placing the .rctest.html file somewhere under
// the <code>testRoot</code> directory; on the next TestRunner execution, TestRunner will
// notice the new test and start reporting results for it (including reporting it as a failure
// if it fails in its very first run).
// <P>
// The included test result viewing application (see below) also provides an interface to
// upload tests if you prefer not to allow direct filesystem access to the machine where
// TestRunner executes.
// <P>
// <h3>Running Test Runner</h3>
// <P>
// TestRunner is an ordinary Java class - com.isomorphic.autotest.TestRunner - and can be run
// from the command line in the usual fashion, or run programmatically from within a Java
// application using the wrapper class com.isomorphic.autotest.TestRunnerDriver.  We also
// provide convenience scripts to run the TestRunner Java class in the SDK root directory.
// <P>
// Minimally, TestRunner needs to know the base directory of a set of test files.  All files
// saved anywhere under this base directory which end in the extension .rctest.html will be
// assumed to be Selenese test files and executed.
// <P>
// As is standard for Selenese test files, the first command in the file is typically an "open"
// command with the URL of the application which should be opened in a browser so that
// subsequent commands can be run.  
// <P>
// The assumption is that the application that will be tested is already deployed by the time
// TestRunner is run; how to automate building and deployment of applications is outside of the
// scope of this document, however, the recommendation is that a Revision-Control System (such
// as SVN, git or CVS) is used, and that every time a developer "checks in" or "commits"
// changes, the application being tested is built and deployed to a test server, then TestRunner
// is run.  Continuous Build Servers (such as Hudson, Bamboo or CruiseControl) may help
// automate the step of building from source control and deploying to a test server, then such
// a Build Server can typically be configured to trigger TestRunner.
// <P>
// TestRunner requires several resources to be in expected default locations from the current
// directory unless you provide overrides via the command line or +link{server_properties,server.properties}.
// Some of
// the required resources are:
// <ul>
//    <li> the batch report email template, by default at mailTemplats/batchReport.template
//    <li> the selenium test template and batchRun/testResult dataSource XML files, by default
//         in tools/selenium
//    <li> the dataSource XML schema files, by default in isomorphic/system/schema
// </ul>
// <P>
// <h4>Command-line Examples</h4>
// <P>
// The following command-line would run TestRunner, execute all tests under the default
// testRoot directory "tests", and commit the results:
// <pre>
// java com.isomorphic.autotest.TestRunner</pre>
// This assumes your classpath environment has been set to include the isomorphic SDK JARs;
// you may invoke the convenience script test_runner.sh|.bat|.command in the SDK root directory
// to run the TestRunner Java class without having to set the classpath.
// <P>
// The following command-line would execute TestRunner as above, but run all tests under the
// directory "foo/bar" relative to the current directory, and email a report of the results:
// <pre>
// java com.isomorphic.autotest.TestRunner -tr foo/bar -e user@company.com</pre>
//
// To do the same, but only run a particular test, you can use the files option (-f):
// <pre>
// java com.isomorphic.autotest.TestRunner -tr foo/bar -c -f test1.rctest.html -e user@company.com</pre>
// Note that when a file is specified, the default is not to commit the results unless
// requested via the commit option (-c).
// <P>
// <h4>Java API</h4>
// <P>
// The following Java code would do the same as the last command-line example:
// <pre>
//     TestRunnerDriver driver = new TestRunnerDriver();
//     driver.setTestRoot("foo/bar");
//     driver.setBatchCommit(true);
//     driver.setFiles(new String[] { "test1.rctest.html" });
//     driver.setAlertEmail("user@company.com");
//     driver.run();
// </pre>
// <P>
// <h4>TestRunner Configuration</h4>
// <P>
// TestRunner supports several more command-line options, or equivalent settings that can be
// applied via Java.  The following table summarizes the command-line options, equivalent Java
// Setter in the DriverConfiguration interface, and it's behavior (including default behavior).
// <P>
// <table border="1">
//  <thead>
//    <tr><th>Command-line Option</th><th>Java Setter</th>
//    <th>+link{server_properties,server.properties} Name</th><th>Behavior</th></tr>
//  <thead>
//  <tbody>
//     <tr><td>-b &lt;browser&gt;</td><td>setBrowser</td><td>N/A</td>
//     <td>Specifies the browser string passed to Selenium. Default is <b>*firefox</b>
//     See +link{usingSelenium}</td></tr>
//     <tr><td>-br &lt;branch&gt;</td><td>setBranch</td><td>autotest.branch</td>
//     <td>Specifies a branch for the batch, used in the batch run record and email
//     notification.  Default is <b>MAIN</b>.Test result comparison occurs per branch.</td></tr>
//     <tr><td>-c/-nc</td><td>setBatchCommit</td><td>N/A</td>
//     <td>This pair of argumentless options allows you to force the batch results to 
//     be committed (-c) or not committed (-nc).  This is useful to override the default
//     of committing (or of not committing if the -f option has been passed).</td></tr>
//     <tr><td>-cs</td><td>setCaptureScreenshot</td><td>N/A</td><td>
//     Configures TestRunner to capture a PNG screenshot of the browser if a
//     Selenium test fails, adding the image to the test result record.</td></tr>
//     <tr><td>-f &lt;files&gt;</td><td>setFiles</td><td>N/A</td><td>Specifies a file or list
//     of files to run. This option can restrict which Selenium scripts under testRoot get run.
//     Relative paths from the testRoot or bare filenames may be provided. When present,
//     this option also disables the default behavior of committing test results.</td></tr>
//     <tr><td>-fr &lt;path&gt;</td><td>setFileRoot</td><td>N/A</td><td>Sets the root directory
//     for all other file system paths.  If not set, defaults to current working directory where
//     Java was launched, or the web server root if TestRunner is run in a servlet.</td></tr>
//     <tr><td>-h</td><td>N/A</td><td>N/A</td><td>Lists available command-line options.</td></tr>
//     <tr><td>-hp &lt;port&gt;</td><td>setHttpPort</td><td>N/A</td>
//     <td>Sets the web server port Selenium should use to run the tests.
//     Default is <b>8080</b></td></tr>
//     <tr><td>-ht &lt;host/IP&gt;</td><td>setHttpTarget</td><td>N/A</td>
//     <td>Sets the target web server Selenium should use to run the tests.
//     Default is <b>localhost</b></td></tr>
//     <tr><td>-lg &lt;message&gt;</td><td>setBatchLog</td><td>N/A</td><td>Provides a
//     log message to include in the record for this batch run. (No Default)</td></tr>
//     <tr><td>-lp</td><td>N/A</td><td>N/A</td>
//     <td>Informs TestRunner that a message or file has been piped to STDIN as the
//     batch log message.</td></tr>
//     <tr><td>-sm</td><td>setSaveMessages</td><td>N/A</td>
//     <td>Configures TestRunner to save the client log messages for each test to the
//     associated test record if the test fails.</td></tr>
//     <tr><td>-sr &lt;path&gt;</td><td>setServerFileRoot</td><td>N/A</td>
//     <td>Sets the serverFileRoot directory. Default is <b>/</b>. Selenium scripts executing
//     open() commands on the httpTarget server will by use this default path.</td></tr>
//     <tr><td>-t &lt;timestamp&gt;</td><td>setTimestamp</td><td>N/A</td>
//     <td>Forces comparison of the batch results to be against the batch run with a
//     timestamp closest to that provided, rather than the most recent batch run.  Format
//     is "2012-12-31 23:59:59" in the local time zone.</td></tr>
//     <tr><td>-tr &lt;path&gt;</td><td>setTestRoot</td><td>autotest.testRoot</td>
//     <td>Sets the testRoot directory relative to the current directory. By default, its
//     value is <b>tests</b>, and all Selenium scripts under the testRoot will be executed
//     by TestRunner.<br>
//     &nbsp;&nbsp;&nbsp;If TestRunner is being run in s servlet container, then this path must
//     use Unix-style path separators (forward slashes) and be absolute (starting with a
//     separator).  In the host filesystem, the path will be interpreted relative to the root
//     container directory.</td><tr>
//     <tr><td>-un &lt;userName&gt;</td><td>setUserName</td><td>autotest.userName</td>
//     <td>Specifies a user name for the batch run record. (No Default)</td></tr>
//     <tr><td>-vm &lt;mode&gt;</td><td>setServerLogMode</td><td>N/A</td>
//     <td>Configures TestRunner to collect the server log messages for each test if
//     it fails.  Legal modes are "none", "some", or "all".  Default is <b>some</b>.</td></tr>
//     <tr><td>-vo &lt;out&gt;</td><td>setServerLogOutputMethod</td><td>N/A</td>
//     <td>Configures the output method that TestRunner will use to report or persist
//     any server log messages; only has an effect for server log modes of "some" or "all".
//     Legal values are "email", "datasource", or "both".  Default is <b>email</b>.</td></tr>
//     <tr><td>-x/-nx</td><td>setMaximizeBrowser</td><td>N/A</td>
//     <td>Sets whether to maximize the browser for Selenium tests.  If not explicitly
//     set via this call, the browser will be maximized if and only if screenshots 
//     are being taken.</td></tr>
//  </tbody>
// </table>
// <P>
// <h3>Email Notifications</h3>
// <P>
// At completion of the batch of tests, TestRunner can automatically send out an email
// notification summarizing the results of the test run, including error messages for 
// any newly failing tests.  A velocity template file is used to control its format; see 
// +link{group:velocitySupport, Velocity Support}. 
// The following velocity variables are available:
// <P>
// <ul>
//     <li><b>$firstBatchFound</b>. Whether baseline batch was found with which to compare</li>
//     <li><b>$fixed</b>. A list of the test results for tests fixed in this batch run</li>
//     <li><b>$regression</b>. A list of the test results for tests broken in this batch run</li>
//     <li><b>$totalTestFiles</b>. The total number of tests run in this batch run</li>
//     <li><b>$passedTestFiles</b>. The number of tests that passed  in this batch run</li>
//     <li><b>$batchStartTime</b>. Timestamp associated with start of this batch run</li>
//     <li><b>$batchLog</b>. Log message, if any was provided for this batch run</li>
// </ul>
// A sample/default template is provided as the file <b>mailTemplates/batchReport.template</b>.
// <P>
// The following options govern the Email Notifications:
// <table border="1">
//  <thead>
//    <tr><th>Command-line Option</th><th>Java Setter</th>
//    <th>+link{server_properties,server.properties} Name</th><th>Behavior</th></tr>
//  <thead>
//  <tbody>
//     <tr><td>-cc &lt;recipient&gt;</td><td>setCcEmail</td><td>autotest.ccEmail</td>
//     <td>Sets the recipient email address for batch report email.  This recipient will
//     always be cc'd a copy of the batch report email, regardless of whether fixes or
//     regressions are present. (No Default)</td></tr>
//     <tr><td>-e &lt;recipient&gt;</td><td>setAlertEmail</td><td>autotest.alertEmail</td>
//     <td>Sets the recipient email address for batch report email.  If the "repeat email"
//     recipient address has also been set via -re, this address will only be sent "alert
//     email" reports where fixes or regressions are present.  Otherwise, it will receive all
//     batch report email.  (No Default)</td></tr>
//     <tr><td>-m &lt;mailHost&gt;</td><td>setMailHost</td><td>autotest.mailHost</td>
//     <td>Specifies what mail host to use to send mail.  If not provided, your mail
//     software will decide what host to use.</td></tr>
//     <tr><td>-ms &lt;subject&gt;</td><td>setMailSubject</td><td>autotest.mailSubject</td>
//     <td>Sets subject line base to use when sending the email reporting batch results.
//     Regressions and fixes info will be appended to the provided subject content.</td></tr>
//     <tr><td>-mt &lt;file&gt;</td><td>setMailTemplate</td><td>autotest.mailTemplate</td>
//     <td>Specifies what velocity template file to use when generating the batch report
//     email for this batch run. Default is <b>mailTemplates/batchReport.template</b></td></tr>
//     <tr><td>-ne</td><td>setNoEmail</td><td>N/A</td><td>Disables sending any email for
//     the batch run. If recipient email addresses have not been set through the
//     command line, Java setters, or server.properties, it's not needed.  However, it
//     may be useful in suppressing email in cases where they have been set.</td></tr>
//     <tr><td>-re &lt;recipient&gt;</td><td>setRepeatEmail</td><td>autotest.repeatEmail</td>
//     <td>Sets the recipient email address for batch report email.  If the "alert email"
//     recipient address has also been set via -e, this address will only be sent "repeat
//     email" reports where no fixes or regressions are present.  Otherwise, it will receive
//     all batch report email.  (No Default)</td></tr>
//     <tr><td>-se &lt;sender&gt;</td><td>setSenderEmail</td><td>autotest.senderEmail</td>
//     <td>Sets the sender email address for batch report email.  Only needed if there is
//     a problem sending email using the sender address generated by default.</td></tr>
//  </tbody>
// </table>
// <P>
// Note: If you choose not to have any email sent upon completion of a batch run, and decide
// not to commit the results to the DataSources, the results of each batch run can still be
// determined by examining the Java console log, which captures the output of each RC test script.
// <P>
// <h3>Result Viewer</h3>
// <P>
// TestRunner comes with a very very simple application for interactively viewing and searching
// test results, implemented in &#83;martClient technology.  This application is meant as a
// starting point for building your own application for interactive viewing of test results, if
// you prefer to go beyond email notifications.
// <P>
// The source code for this application is just a single testResultViewer.jsp file in the "selenium"
// directory in the SDK; copy it anywhere under <code>webroot</code> in a project that includes
// the SmartClient Server and it will function.
// <P>
// The result viewing application also includes the ability to upload new test files to
// <code>testRoot</code> as an alternative to providing testers with direct access to the
// filesystem for the machine where TestRunner executes.
// <P>
// <h3>Getting Started FAQ</h3>
// <P>
// <smartclient>
// Q: When I run TestRunner, I want to target the SmartClient server, but TestRunner fails
// due to HSQLDB reporting a locked database.<BR>
// A: You must stop the SC server running from the same SDK installation as TestRunner before 
// running TestRunner.  Another copy of the SDK may be installed elsewhere on the same machine,
// or TestRunner may be pointed at a different machine using the -ht command-line option.
// </smartclient>
// <smartgwt>
// Q: When I run TestRunner, I want to target the SGWT showcase, but TestRunner fails due to 
// HSQLDB reporting a locked database.<BR>
// A: By default, TestRunner uses the HSQLDB associated with the SGWT showcase when run from
// the SGWT ZIP root directory.  Therefore, if samples/showcase/war has been deployed to a 
// webserver, you must stop it before running TestRunner.  One simple alternative is to deploy
// the file showcase.war from the SGWT ZIP root, which has a separate copy of the HSQLDB.  You
// may also simply install another copy of the SGWT ZIP in a different location on the same 
// machine, or point TestRunner at a different machine using the -ht command-line option.
// </smartgwt>
// <P>
// Q: When I run TestRunner, TestRunner fails reporting that DataSource BatchRun or TestResult
// cannot be found.<BR>
// A: These DataSources must be imported into the default HSQLDB before TestRunner can be used.
// <smartclient>
// Use the "import" option of tools/adminConsole.jsp under the SDK installation root directory
// </smartclient>
// <smartgwt>
// Use the "import" option of showcase/tools/adminConsole.jsp under the deployed SGWT showcase
// </smartgwt>
// to select and import the BatchRun and TestResult DataSources prior to running TestRunner.
// 
// @treeLocation Concepts/Automated Testing 
// @title TestRunner
// @visibility external
//<

//> @class AutoTest
// Standalone class providing a general interface for integration with Automated Testing Tools
// <p>
// <i>For an overview of Automated Testing in SmartClient, see the documentation +link{group:automatedTesting,here}.</i>
// <p>
// <h2>AutoTestLocators</h2>
// The AutoTest class is responsible for creating and resolving +link{AutoTestLocator,autoTestLocators} - 
// identifier strings which can reliably identify an interactive element in a SmartClient application.
// <P>
// These locators are designed to work across browsers, SmartClient versions, and even
// major changes to your application's UI. They do not rely on the DOM structure, and
// are intended to be able to identify the target element reliably without requiring
// pervasive explicitly specified +link{Canvas.ID,component IDs}.
// <P>
// Note that AutoTest locators are the only supported way to identify SmartClient generated DOM elements when 
// recording tests for automated testing tools. 
// Using XPath DOM locators to identify elements is not a supported approach. The DOM structure and DOM element
// attributes generated by SmartClient components are not guaranteed to be identical for functionally 
// equivalent elements across different SmartClient builds, different browsers, and for dynamically generated
// components, could even change across page reloads.
// <P>
// The primary APIs for working with AutoTest locators are as follows:
// <ul><li>+link{AutoTest.getLocator()} to retrieve a locator for an element</li>
//     <li>+link{AutoTest.getElement()} to resolve a stored locator back to an element</li>
// </ul>
// Developers should also be aware of the +link{AutoTest.installLocatorShortcut()} method 
// which allows you to retreive locators via a simple key combo + mouseDown event on the target element.
// <p>
// See the +link{AutoTestLocator,AutoTestLocator overview} documentation for
// details on how locators are structured.
// <p>
// See the +link{group:reliableLocators,Reliable AutoTestLocators overview} documentation for
// best practices for generating high quality locators.
// <p>
// <h3>AutoTest locator variables</h3>
// AutoTest locators may be written to include dynamic variables to be resolved at runtime.
// See the following APIs for details:
// <ul><li>+link{AutoTest.setVariable()}: Set up a named variable for later use</li>
//     <li>+link{AutoTest.storeLocatorResult()}: Resolve a locator against the current environment 
//         and store it as a variable</li>
//     <li>+link{AutoTest.getVariable()}: Retrieves the value of a previously defined variable</li>
// </ul>
// <h3>Locator testRoot</h3> 
// For tests that target a standard widget hierarchy such as a +link{isc.RPCManager.loadScreen(),screen},
// the +link{AutoTest.testRoot} may be used to reliably identify the widget hierarchy in question 
// wherever it is rendered inside a larger application.
// <h2>Waiting for asynchronous operations</h2>
// The AutoTest class provides utilities to wait for asynchronous actions, including both system
// delays (such as +link{canvas.markForRedraw(),redraws that fire on system idle}, for example), and 
// asynchronous +link{RPCManager,RPC operations}.
// <ul><li>+link{AutoTest.waitForElement()}: this method will wait for asynchronous operations
//         to complete before resolving an +link{AutoTestLocator} to an element and firing a
//         callback function. This allows recorded tests to reference elements that are blocked
//         or unavailable until some asynchronous action(s) complete.</li>
//     <li>+link{AutoTest.waitForSystemDone()}: this method will wait for any outstanding 
//         asynchronous system operations to complete and then fire the specified callback.</li>
//     <li>+link{AutoTest.isSystemDone()}: this method may be called to check whether there
//         are currently any outstanding asynchronous system operations.</li>
// </ul>
// Note that SmartClient's support for integrating with high level tools such as
// +link{group:smartClientCypress,Cypress} and +link{group:usingSelenium,Selenium} automatically
// makes use of these APIs.
//
// @treeLocation Concepts/Automated Testing
// @visibility external
// @group autoTest
//<

//> @groupDef reliableLocators
// The +link{AutoTestLocator,locators} generated by +link{AutoTest.getLocator()} will always resolve
// uniquely back to the target element in a live application when they are
// first generated. However, changes to the structure of the application
// on subsequent visits, due to small changes to the application or 
// certain types of dynamically generated UI can make some locator strategies
// less reliable than others. Most notably, if a locator is relying on 
// simple parent-child (or layout-member) hierarchy to identify a component, 
// any change to that hierarchy will break it, and if a locator is identifying
// a component by index, this locator can resolve incorrectly if the
// other children or members of the parent are modified, 
// even with +link{AutoTestLocator,fallback locator attributes}.
// <P>
// There are a few simple things a developer can do to allow the AutoTest
// system to generate reliable locators
// <P>
// <h2>Explicit IDs</h2>
// If a component has an explicitly specified +link{canvas.ID,ID}, it will be
// used to identify the target component's UI elements, regardless of where
// it sits within an application widget hierarchy. By giving key components
// explicit IDs, you can ensure they will be found by recorded test scripts
// even if the application layout changes.
// <P>
// Exception: note that if +link{AutoTest.testRoot} is set, the ID will be ignored
// when generating locators in favor of identifying their position within the
// designated test root. You can explicitly override this by setting 
// +link{Canvas.locateByIDOnly}.
// <P>
// <smartclient>
// <h2>Use AutoChildren to improve locator quality for custom components</h2>
// When defining custom components for use in an application, using the
// +link{group:autoChildren,autoChild pattern} will ensure that 
// AutoTestLocators that target generated sub-components of a
// composite component will by identified by their <code>autoChildName</code>.
// <P>
// This is preferable to identifying them by pure parent-child relationships
// as it is unambiguous (does not rely on index or other strategies to identify
// a component within a group of sibling components), and will continue to
// work even if you restructure the composite component to change the 
// interim hierarchy.
// </smartclient>
// <h2>Explicit locator parents</h2>
// Any component can designate itself as a named locatorChild of
// some parent via +link{canvas.setLocatorParent()}.
// <P>
// As long as this relationship has been defined, locators will 
// directly use the specified locator name to identify the child 
// when generating or resolving locators from the parent.
// <P>
// Note that a widget does not need to be a true descendant of another
// widget to mark it as its locator parent.
// <h2>Defining properties and search segments</h2>
// As described in the +link{AutoTestLocator,AutoTestLocator overview}, locators
// can include search segments to find descendants by 
// +link{canvas.getDefiningPropertyName(),defining property value}.
// Developers may choose to set an explicit defining property for some component
// or custom class to take advantage of this capability. Locators with 
// search segments will reliably find their targets within their parent
// even if the intervening widget hierarchy has changed.
// <P>
// The SmartClient AutoTest system also provides capabilities for recording
// automated test scripts for playback on different environments with significant changes.
// See +link{group:portableAutoTests} for details.
//
// @title Generating Reliable AutoTestLocators
// @treeLocation Concepts/Automated Testing
// @visibility external
//<

// As documented +link{type:AutoTestLocator,here}, locators are structured as
// a series of segments, with each segment identifying a step in the path from
// a base component to a target element on the page.
// <P>
// The SmartClient AutoTest system uses a variety of mechanisms to resolve the
// segments in a locator to their targets.
// The segments do not match the hierarchy of widgets on the page. Individual
// segments do not all represent SmartClient components, and segments that
// are representative of a component may not be a direct +link{canvas.children,child} 
// of the canvas represented by the previous segment.
// <P>
// Developers interested in having the AutoTest subsystem generate compact
// and reliable locators should be aware of the following features of 
// locator generation and resolution:
// <ul>
// <li>Named +link{group:autoChildren} will always be identified by just their
//     autoChild name. For example the body of a listGrid in a locator string will
//     show up as just <code>/body/</code>.</li>
// <li>The +link{canvas.setLocatorParent()} method allows developers to set up
//     an explicit named locator-parent / child relationshiop between any two components
//     without requiring one be an autoChild of the other.</li>
// </ul>
// When building a user interface these features can make your locators more
// reliable. If you use the autoChild system to create standard nested structures,
// or explicitly set up a relationship between components via the 
// +link{canvas.setLocatorParent(),locatorParent} feature, the AutoTest subsystem 
// will directly identify the child component by name.
// The implementation details of your nested user-interface - what class of 
// widget the logical child is, what the widget-hiearchy between the components
// looks like, etc - will have no impact on the locators, meaning you can 
// restructure the implementation without losing the ability to use already-recorded tests.
// <P>

//> @type AutoTestLocator
// An AutoTestLocator is a string generated by the +link{class:AutoTest} class to 
// reliably identify an interactive element in a SmartClient application. 
// Locators allow integration with automated testing tools. For an overview
// of automated testing in SmartClient, see the documentation topic 
// +link{group:automatedTesting,here}.
// <P>
// AutoTestLocators are designed to work across browsers, SmartClient versions, and even
// major changes to your application's UI. They do not rely on the DOM structure, and
// are intended to be able to identify the target element reliably without requiring
// pervasive explicitly specified +link{Canvas.ID,component IDs}.
// <p>
// The +link{class:AutoTest} class is responsible for creating locator strings corresponding
// to DOM elements, SmartClient components or other objects, and for resolving 
// locators back to those objects at runtime.
// <P>
// A locator for an element may be retrieved via +link{AutoTest.getLocator()}, or by using 
// the +link{AutoTest.installLocatorShortcut(),locator shortcut tool}, or the 
// <i>"Show AutoTest Locators"</i> link on the <i>Results</i> tab of the 
// SmartClient +link{group:debugging,Developer Console}.
// <P>
// Stored locators may be resolved to target elements via +link{AutoTest.getElement()}
// (or resolved to target objects via +link{AutoTest.getObject()}).
// <P>
// <b>Best Practices for building applications with reliable locators</b>
// <P>
// Developers should be aware of certain considerations that can make generated
// AutoTestLocators more reliable when designing their application.
// <P>
// The +link{group:reliableLocators} overview topic covers general recommendations
// to ensure that AutoTestLocators are robust and reliable within your app.
// <P>
// The +link{group:portableAutoTests} topic discusses considerations around 
// recording and playing back test scripts over different environments with changes
// to data or user interface, and the capabilities SmartClient offers to address these
// considerations.
// <P>
// <h2>Locator Structure</h2>
// +link{AutoTestLocator,AutoTest locators} consist of a series of segments, delineated by "/" characters.
// <P>
// Each segment identifies a step in a hierarchy from a root component to the target element.
// Individual segments may represent a Canvas, a FormItem, an interior DOM element or some
// other construction specific to the locator in question.
// <P>
// Note that the segments in an AutoTestLocator do not necessarily match parent-child 
// relationships in the widget hierarchy.
// <P>
// <b>Root locator segment</b>
// The root component of a locator may designated in one of the following ways:
// <ul>
//     <li>
//      <b>Component ID:</b> If a component has an explicitly specified +link{canvas.ID,ID} this may be used 
//      along with the class of the widget to reliably identify it, regardless of
//      where it is in the page's widget hierarchy.<br>
//      For example a VLayout with ID <code>"leftPane"</code> would be identified as:
//      <P>
//      <code>//VLayout[ID="leftPane"]</code>
//      <P>
//      Or, if +link{canvas.locateByIDOnly} is true, the class of the widget will not be
//      recorded - the locator segment to identify the root will be just the
//      widget ID prefixed by three slash characters - for example:
//      <P>
//      <code>///leftPane</code>
//    </li>
//    <li>
//      <b>Locator Test Root:</b> Developers may designate a component within an 
//      application as the explicit +link{AutoTest.setTestRoot(),testRoot}. 
//      This component can then be referenced by the special root locator segment
//      <P>
//      <code>//testRoot[]</code>
//      <P>
//      This is useful for cases where a standard
//      widget hierarchy may be dynamically rendered inside 
//      some component (such as a +link{RPCManager.loadScreen,screen}) - 
//      see the +link{group:portableAutoTests} topic for more information
//    </li>
//    <li>
//      <b>Base Search Segment:</b> The AutoTest subsystem supports searching for components
//      by a +link{canvas.definingProperty,defining property value}. If a target element
//      is not a descendant of a component with an explicitly specified ID, and is
//      also not contained within the specified +link{AutoTest.setTestRoot(),testRoot}
//      for the application, but is contained within a component that has a 
//      specified +link{canvas.definingProperty,definingProperty value}, this may be
//      used to identify the root component for the locator.
//      <P>
//      Base search segments are prefixed with <code>"//:"</code> and include the
//      class name for the target component along with the defining property value. 
//      <P>
//      For example - +link{listGrid.dataSource,dataSource} is a defining property for
//      ListGrids. The following locator would identify a ListGrid bound to a
//      dataSource with the ID <code>"someDS"</code> wherever it appeared in the page's
//      widget hierarchy:
//      <P>
//      <code>//:ListGrid[dataSource="someDS"]</code>
//      <P>
//      +link{AutoTest.getLocator()} will only generate a locator with a base search 
//      segment if the defining property value would unambiguously identify the 
//      base component within the application. The above locator would not be generated
//      in an app with more than one visible ListGrid bound to <code>"someDS"</code>.
//      <P>
//      Note that by default hidden and/or undrawn components are not considered
//      when generating and resolving locator search segments, but the special 
//      <code>"?"</code> character indicates that both hidden and visible components
//      must be considered when resolving a search segment.
//      <P>
//      For example the locator <code>//:?ListGrid[dataSource="someDS"]</code> would
//      retrieve a ListGrid bound to <code>"someDS"</code> whether visible or hidden.
//      <P>
//      +link{AutoTest.getLocator()} will generate this locator format if
//      the target element was hidden, or if passed the 
//      +link{AutoTestLocatorConfiguration.searchSegmentsIncludeHidden,searchSegmentsIncludeHidden}
//      attribute of the settings argument.
//    </li>
// </ul>
// <b>Interior locator segments</b>
// <P>
// In some cases a single segment may be sufficient to identify a target element or 
// object on the page, but in most cases, the root component locator will be
// suffixed with a number of interior locator segments to identify the path
// from the root component to the target element.
// <P>
// The format of individual segments within a locator will be different for
// different widget hierarchies and target elements. SmartClient does not exhaustively
// document every possible locator format for every widget, but the patterns used
// are consistent and can inform application design:
// <ul>
//  <li>
//      <b>Named AutoChildren:</b> Named +link{group:autoChildren} will be 
//      identified within their creator by their autoChild name - for example
//      <P>
//      <code>//Window[ID="mainWindow"]/body</code>
//      <P>
//      This happens regardless of the interim widget hierarchy between the
//      creator and its auto-child.
//  </li>
//  <li>
//      <b>Explicit locatorChildren:</b> Components with an explicit
//      +link{canvas.setLocatorParent(),named locator child} relationship
//      will be identified within their locator parent by name. For example
//      marking a member of a Layout with the locator child name <code>"myView"</code>
//      might produce a locator like:
//      <P>
//      <code>//VLayout[ID="mainLayout"]/myView</code>
//      <P>
//      Once again, this is regardless of the interim widget hierarchy between
//      the locator parent and its locator-child.
//  </li>
//  <li>
//      <b>Search Segments:</b> Interior search segments in a locator are prefixed
//      with <code>"//"</code>. Interior search segments indicate that a component
//      may be uniquely identified by a 
//      +link{Canvas.definingProperty,defining property value} within the component
//      identified by the previous segment in the locator.
//      <P>
//      For example the following locator would search for a ListGrid bound to 
//      <code>"someDS"</code> within the body of a window with ID <code>"mainWindow"</code>:
//      <P>
//      <code>//Window[ID="mainWindow"]/body//ListGrid[dataSource="someDS"]</code>
//      <P>
//      Note that the +link{AutoTest.getLocator()} method will never return a locator
//      with a search segment that is ambiguous in the current application.
//      <P>
//      If the AutoTest system can uniquely identify a component by defining property across the
//      app as a whole, it will typically be used as a base search segment. If not
//      the system will find the highest-level ancestor containing only
//      one descendant with the specified definingProperty, and ensure the previous
//      segment in the locator identifies that ancestor. This ensures that the
//      final locator string is as compact as possible while unambiguously identifying the target.
//      <P>
//      As with base search segments, a <code>"?"</code> character is used to indicate
//      that hidden or undrawn components should be considered when resolving
//      search locators. For example the following locator:
//      <P>
//      <code>//Window[ID="mainWindow"]/body//?ListGrid[dataSource="someDS"]</code>
//      <P>
//      would include hidden listGrids when searching for the grid bound to the specified
//      dataSource.
//  </li>
//  <li>
//      <b>Locator segment fallback attributes:</b> If a target element or component
//      cannot be identified within its parent by a simple identifier such as autoChildName or 
//      defining property, the AutoTest subsystem will generate a segment containing
//      one or more attributes to identify the target. When multiple attributes are recorded
//      it allows the SmartClient framework to use several strategies to find the target.
//      These additional locator segment attributes are referred to as "fallback attributes".
//      <P>
//      For example a locator segment with a full set of fallback attributes
//      identifying a member of a Layout might look like this:
//      <P>
//      <code>VLayout[ID="mainLayout"]/member[Class=TreeGrid||index=1||length=3||classIndex=0||classLength=1||roleIndex=0||roleLength=1||scRole=tree]/</code>
//      <P>
//      This specific segment indicates that the target component is a member of a layout.
//      The target is a TreeGrid, and is the first of 3 members.
//      It also indicates this is the only member TreeGrid in the members array 
//      [indicated by the <code>classIndex</code> and <code>classLength</code> attributes], and
//      that it is the only member with +link{Canvas.ariaRole,role} set to <code>"tree"</code>.
//      <P>
//      The parent layout will use these <i>fallback attributes</i> in the locator as necessary to
//      find the appropriate member. If the layout has three members, and the first is a TreeGrid,
//      the target may be resolved to this member with some confidence.
//      <P> 
//      If this is not the case, but there is exactly
//      one TreeGrid in the members array, or exactly one element with <code>role</code> set to
//      tree, it will fallback to those secondary locator strategies. If fallback locator strategies
//      are used, a warning will be logged so developers are aware of any potentially incorrect
//      locator parsing.
//      <P>
//      Developers may influence how recorded locator attributes are resolved via
//      properties on the locator parent. For Layouts this would include 
//      +link{layout.locateMembersBy} and +link{layout.locateMembersType}.
//      <P>
//      For brevity and readability, when generating locators, developers may 
//      choose whether or not to include multiple fallback attributes in locator segments by setting
//      +link{AutoTest.useMinimalFallbackAttributes,useMinimalFallbackAttributes} to false
//      globally, or on the <code>settings</code> parameter passed to +link{AutoTest.getLocator()}.
//  </li>
//  <li><b>Component interior locators:</b> Different SmartClient components have their own patterns
//      for identifying significant elements in the DOM within their handles. For example, ListGrid cell elements
//      are located by row and column data. Where appropriate, properties to control how component-interior
//      locators behave will be documented on the class in question.
//  </li>
// </ul>
// 
// @group autoTest
// @baseType String
// @see class:AutoTest
// @see group:automatedTesting
// @visibility external
//<



//> @groupDef portableAutoTests
// SmartClient has powerful features for integrating with a variety of third party testing tools.
// See the +link{group:automatedTesting,Automated Testing overview} for an overview of how
// to use testing tools with SmartClient.
// <P>
// The +link{type:AutoTestLocator} system ensures that user interface elements can
// be reliably identified when recording or playing back tests independently of the
// DOM structure generated by SmartClient components. Using locators insulates
// developers from changes to the generated DOM structure due to 
// different SmartClient builds, different browsers and different skins. 
// <P>
// See the documentation topic +link{group:reliableLocators} for best practices with
// respect to building applications that will generate robust and reliable locators.
// <P>
// The AutoTest system also has some advanced features to facilitate recording
// and playing back tests across environments with significant differences including:
// <ul><li>Different data: multiple environments with different data sets 
//         (for example, test vs staging vs production)</li>
//     <li>Embedded UI: your application or user interface may be embedded
//         within a larger application or portal</li>
//     <li>Per-User presentation: an application may present the same functionality
//         differently per user. For example if an application has separately licensable
//         modules, the user interface to navigate to some functional area may differ
//         depending on which modules are available to the user</li>
//     <li>Customer customizations: an application may allow users to add
//         additional UI or rearrange screens</li>
// </ul>
// <P>
// <b>AutoTest variables</b>
// <P>
// The +link{AutoTest.setVariable(),variables} feature allows developers
// to specify explicit variable names and corresponding values for
// use when resolving AutoTest locators.
// <P>
// Variables may be used anywhere within a locator string, but a common
// use case would be handling different data in different deployments.
// For example the locator for a ListGrid cell element might be as follows:
// <P>
// <code>//ListGrid[ID="countryList"]/body/row[pk=47||countryCode=WS||countryName=Western%20Samoa||2]/col[fieldName=countryName||1]</code>
// <P>
// This locator includes various fallback attributes to identify the
// row and column (see the +link{type:AutoTestLocator,AutoTestLocator overview}
// for information about fallback attributes in locator segments).
// <P>
// If you want to identify the cell by primary key field value and column name only,
// this could be simplified to be just:
// <P>
// <code>//ListGrid[ID="countryList"]/body/row[pk=47]/col[fieldName=countryName]</code>
// <P>
// In a different data set, the equivalent record might have a different 
// primary key field value, meaning any locators that referenced it via hardcoded
// values like <code>pk=47</code> would fail to resolve to the correct target.
// This can be handled by setting up an AutoTest variable before the test
// executes - for example recording the target record as <code>testRecord</code>,
// and referring to it directly in the locators:
// <P>
// <code>//ListGrid[ID="countryList"]/body/row[pk=&#36;{testRecord.pk}]/col[fieldName=countryName]</code>
// <P>
// <b>AutoTestLocator root</b>
// <P>
// The +link{AutoTest.testRoot} attribute allows developers to designate some
// component as the "root" for an autoTest. With this setting in place, 
// locators for elements anywhere within that root component will be generated
// as a path from the testRoot to the target component. These locators will
// always start with the special prefix <code>//testRoot[]</code>.
// <P>
// If the same UI elements are then rendered inside another container in 
// a different environment, configuring +link{AutoTest.testRoot} to point
// to this container will allow the locators to resolve correctly.
// <P>
// If no global testRoot was specified, any component with an explicit
// +link{Canvas.ID,ID} will be treated as the root component for the elements
// it contains. This means that locators for components with explicit IDs
// will resolve correctly regardless of where these components are in the
// page's structure.
// <P>
// Components with an explicit ID are located by ID and widget class name by default.
// You can also set +link{canvas.locateByIDOnly} - this will cause the generated
// locator for the component to omit the widget class name altogether and create
// a very compact locator of the format <code>///componentID</code>
//
// @title Writing AutoTests for multiple environments
// @treeLocation Concepts/Automated Testing
//<


// Document AutoTestObjectLocator as a separate type. As currently implemented it is always a
// valid standard Locator string, but that's an implementation detail and may not always be the case.


//> @type AutoTestObjectLocator
// A string that uses similar syntax to an +link{type:AutoTestLocator}, but is expected to
// resolve to a live SmartClient object such as a +link{Canvas}, or +link{FormItem} rather than
// some element within the DOM. These are created via +link{AutoTest.getObjectLocator()} and
// +link{AutoTest.getRelativeObjectLocator()}
// @group autoTest
// @visibility rules
//<




isc.defineClass("AutoTest");


isc.AutoTest.addClassMethods({

    locatorsEqual : function (locator1, locator2) {
        if (locator1 && locator2) {
            locator1 = locator1.replace(/^[^\/]*(\/\/.*?)[\/]*$/, "$1");
            locator2 = locator2.replace(/^[^\/]*(\/\/.*?)[\/]*$/, "$1");
        }
        return locator1 == locator2;
    },

    //> @classMethod AutoTest.getFullPathLocator()
    // Convenience method to generate a +link{type:AutoTestLocator} with no
    // search segments and an explicit path from the locator root to the target.
    // <P>
    // This method sets +link{AutoTest.getLocator()} with the following 
    // +link{AutoTestLocatorConfiguration,configuration settings}:
    // <ul>
    //  <li>useSearchSegments:false</li>
    //  <li>useMinimalFallbackAttributes:false</li>
    //  <li>useCompactFallbackSyntax:false</li>
    // </ul>
    // @param [target] (DOMElement | Canvas | FormItem) Target within the page. This may be
    //  a DOM element, a +link{Canvas} or a +link{FormItem}. If null, a locator for
    //  the last mouse event target DOM element will be generated.
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //  the target element responds to native browser events directly rather than going through
    //  the SmartClient widget/event handling model. If we detect this case, return null rather
    //  than a live locator.  This allows us to differentiate between (for example) an event on
    //  a Canvas handle, and an event occurring directly on a simple 
    //  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
    // @param [coords] (Array) X, Y page position
    // @return (AutoTestLocator) full-path locator string to identify the target.
    // @visibility external
    //<
    
    getFullPathLocator : function (DOMElement, checkForNativeHandling, coords, overrides) {
        overrides = isc.addProperties(
            {
                useSearchSegments:false,
                useMinimalFallbackAttributes:false,
                useCompactFallbackSyntax:false
            },
            overrides
        );
        return this.getLocator(DOMElement, checkForNativeHandling, coords, overrides);
    },

    //> @object AutoTestLocatorConfiguration
    // Configuration object for generating +link{type:AutoTestLocator,AutoTestLocators}.
    // <P>
    // An AutoTestLocatorConfiguration may be passed to +link{AutoTest.getLocator()}
    // to override default locator configuration settings.
    // @treeLocation Concepts/Automated Testing
    //
    // @visibility external
    //<

    

    //> @attr AutoTestLocatorConfiguration.useSearchSegments (boolean : null : IR)
    // Should generated locators include search segments (as detailed in 
    // the +link{type:AutoTestLocator,AutoTestLocator overview}) to identify
    // components with +link{Canvas.getDefiningPropertyName(),defining property values}?
    // <P>
    // See also +link{AutoTestLocatorConfiguration.searchSegmentsIncludeHidden}
    // @visibility external
    //<

    //> @attr AutoTestLocatorConfiguration.searchSegmentsIncludeHidden (boolean : null : IRA)
    // When generating locators with
    // +link{AutoTestLocatorConfiguration.useSearchSegments,search segments},
    // should the generation logic always consider hidden components as well as visible
    // components to determine whether the search segment will uniquely resolve?
    // <P>
    // Setting this property to true ensures that, even for visible components, 
    // search segments will be guaranteed to resolve uniquely when considering both
    // visible and hidden components on the page. Any search segments in the generated
    // locator will include a marker to indicate that both hidden and visible widgets
    // should be considered when resolving the locator back to a target via
    // +link{AutoTest.getElement()}, +link{AutoTest.getObject()} and related methods.
    // <P>
    // Note that this setting has no impact on locators being generated for components
    // that are currently hidden. Any search segments for hidden components will always consider
    // uniqueness among all components (hidden and visible), and include the 
    // marker to ensure that they are considered when resolving the locator back to 
    // an object.
    // <P>
    // See the +link{type:AutoTestLocator,AutoTestLocator overview} for more information about
    // search segments in AutoTestLocators
    //
    // @visibility external
    //<

    //> @attr AutoTestLocatorConfiguration.useMinimalFallbackAttributes (boolean : null : IR)
    // Should generated locators omit fallback locator attributes when generating
    // segments that identify components or other objects by attribute values?
    // <P>
    // See the +link{type:AutoTestLocator,AutoTestLocator overview} for details
    // of locator fallback attributes.
    //
    // @visibility external
    //<

    //> @attr AutoTestLocatorConfiguration.useCompactFallbackSyntax (boolean : null : IR)
    // This setting controls whether locator segments that identify components
    // or other objects by attribute values use a compact or verbose syntax.
    // <P>
    // See the +link{type:AutoTestLocator,AutoTestLocator overview} for details
    // of locator attributes.
    //
    // @visibility external
    //<


    //> @attr AutoTestLocatorConfiguration.useIDsAsLocators (boolean : null : IR)
    // May a simple widget ID with no other content be returned from +link{AutoTest.getLocator()}?
    // <P>
    // If true, when a locator is requested for a component, and that component has
    // an explicitly specified +link{Canvas.ID}, the ID will be returned as the entire
    // locator.
    // <P>
    // This only applies when the target of the locator is the component itself or its
    // handle. If the target is a child, or an interior DOM element that requires
    // additional locator segments to identify, a standard multi-segment locator
    // will be generated.
    // <P>
    // See the +link{type:AutoTestLocator,AutoTestLocator overview} for more
    // information on locators.
    //
    // @visibility external
    //<


    //> @classMethod AutoTest.getLocator()
    // Returns an +link{type:AutoTestLocator} for some DOM element or object in a SmartClient
    // application page. The generated locator may be resolved to a target element or
    // object via +link{getElement()} or +link{getObject()}, to target event coordinates
    // via +link{getPageCoords()}, or may be used to retrieve some data value relevant
    // to the target via +link{getValue()}.
    // <P>
    // The optional <code>coords</code> parameter allows developers to specify
    // page-level event coordinates. For certain components where the
    // exact mouse-position of an event would change its behavior, this may cause
    // the generated locator to include information about the position of an 
    // event within a target in the form of a "target area" suffix or similar. 
    // Note that not page coordinates may not impact the generated locator in
    // every case, and calling +link{getPageCoords()} is not typically expected to 
    // return exactly the coordinates passed into this method. 
    // That method will return coordinates that
    // would result in the same event handling behavior as an event that occurred
    // over the specified coordinates when the locator was created.
    // <P>
    // The <code>options</code> parameter may be used to configure how the locator
    // is generated - see +link{object:AutoTestLocatorConfiguration}.
    // <P>
    // See also the +link{type:AutoTestLocator,AutoTestLocator overview} for 
    // more information about autoTest locators.
    //
    // @param [target] (DOMElement | Canvas | FormItem) Target within the page. This may be
    //  a DOM element, a +link{Canvas} or a +link{FormItem}. If null, a locator for
    //  the last mouse event target DOM element will be generated.
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //  the target element responds to native browser events directly rather than going through
    //  the SmartClient widget/event handling model. If we detect this case, return null rather
    //  than a live locator.  This allows us to differentiate between (for example) an event on
    //  a Canvas handle, and an event occurring directly on a simple 
    //  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
    // @param [coords] (Array) X, Y page position
    // @param [options] (AutoTestLocatorConfiguration) Options to configure the 
    //  locator returned by this method
    // @return (AutoTestLocator) Locator string allowing the AutoTest subsystem to find
    //   an equivalent DOM element on subsequent page loads.
    // @visibility external
    // @group autoTest
    //<
    getLocator : function (DOMElement, checkForNativeHandling, coords, overrides) {
               
        return this._getLocator("getLocator", DOMElement, checkForNativeHandling, coords, overrides);
    },

    _getLocator : function (methodName, DOMElement, checkForNativeHandling, coords, overrides)
    {
        var lastEvent = isc.EH.lastEvent, fromEvent;
        if (lastEvent) {
            if (DOMElement == null) {
                DOMElement = lastEvent.nativeTarget;
                fromEvent = true;
            }
            if (coords == null) {
                coords = [isc.EH.getX(), isc.EH.getY()];
            }
        }
        
        var canvas;
        if (isc.isA.Canvas(DOMElement)) {
            canvas = DOMElement;
            if (canvas.destroyed) return "";
            DOMElement = canvas.getHandle();

        } else if (isc.FormItem && isc.isA.FormItem(DOMElement)) {
            var item = DOMElement;
            canvas = item.containerWidget;
            if (!canvas || canvas.destroyed || item.destroyed) return "";
            DOMElement = item.getHandle();

        } else {
            canvas = isc.AutoTest.locateCanvasFromDOMElement(DOMElement);
        }
        if (!canvas) return "";

        // This method falls through to the canvas-level getLocator() / getMinimalLocator() here
        var locator = canvas[methodName](DOMElement, fromEvent, coords, overrides);

        // if locator descriptor found, convert to locator
        if (locator.locator) locator = locator.locator;

        if (checkForNativeHandling && locator && 
            canvas.checkLocatorForNativeElement(locator, DOMElement)) 
        {
            return "";
        }

        return locator;
    },

    //> @classMethod AutoTest.getLocatorForDeveloperConsole()
    // Synonym for +link{getLocator()} used by the Developer Console Results Tab that can
    // be safely overridden without affecting other framework locator-dependent logic. 
    // @param DOMElement (DOMElement) DOM element within in the page
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //   the target element responds to native browser events directly rather than going
    //   through the SmartClient widget/event handling model.
    // @param [coords] (Array) X, Y page position
    // @return (AutoTestLocator) Locator string
    //<
    getLocatorForDeveloperConsole : function () {
        return this.getLocator.apply(this, arguments);
    },


    //> @classMethod AutoTest.getLocatorHybrid()
    // Returns the +link{getMinimalLocator(),minimal locator} to the target.
    // <p>
    // Accepts a set of +link{class:AutoTest} class properties to set for you while the locator
    // is computed.
    // 
    // @param DOMElement (DOMElement) DOM element within in the page. If null the locator for
    //     the last mouse event target will be generated
    // @param [globalConfig] (Properties) +link{AutoTest} class properties to apply before
    //     computing the locator. They'll be cleared automatically when this method call exits.
    // @return (AutoTestLocator) Locator string allowing the AutoTest subsystem to find
    //     an equivalent DOM element on subsequent page loads.
    // @deprecated This now is just an alias for +link{getMinimalLocator()} with a different
    //     argument signature.
    //<
    getLocatorHybrid : function (DOMElement, globalConfig) {
        return this.getMinimalLocator(DOMElement, null, null, globalConfig);
    },

    //> @classMethod AutoTest.getElementHybrid()
    // The same as +link{getElement()} except takes a set of +link{class:AutoTest} class
    // properties to set for you while the locator is computed.
    // @param locator (AutoTestLocator) Locator String previously returned by
    //     +link{AutoTest.getLocatorHybrid()}
    // @param [globalConfig] (Properties) +link{AutoTest} class properties to apply before
    //     computing the locator. They'll be cleared automatically when this method call exits.
    // @return (DOMElement) DOM element this locator refers to in the running application, or
    // null if not found
    //<
    getElementHybrid : function (locator, globalConfig) {
        if (!globalConfig) globalConfig = {};

        isc.AutoTest.pushConfiguration(globalConfig);

        try {
            return this.getElement(locator);

        } finally {
            isc.AutoTest.popConfiguration();
        }        
    },

    //> @object QualityIndicatedLocator
    // An object returned from +link{AutoTest.getLocatorWithIndicators} that includes the
    // locator and properties that describe the quality of the locator.
    //
    // @treeLocation Concepts/Automated Testing/AutoTest
    // @visibility external
    // @group autoTest
    //<

    //> @attr qualityIndicatedLocator.locator (AutoTestLocator : null : IR)
    // The +link{type:AutoTestLocator} associated with some DOM element in a SmartClient
    // application page.
    //
    // @visibility external
    //<

    //> @attr qualityIndicatedLocator.containsGlobalId (boolean : null : IR)
    // True if the returned +link{qualityIndicatedLocator.locator,locator} includes
    // a reference using an auto-generated global ID.
    //
    // @visibility external
    //<

    //> @attr qualityIndicatedLocator.globalID (String : null : IR)
    // The ID of the component within the locator segments that has an auto-generated global
    // ID.
    //
    // @visibility external
    //<

    //> @attr qualityIndicatedLocator.containsIndices (boolean : null : IR)
    // True if the returned +link{qualityIndicatedLocator.locator,locator} includes
    // references using index positions.
    //
    // @visibility external
    //<

    //> @attr qualityIndicatedLocator.firstParentOfIndex (String : null : IR)
    // The ID of the first parent within the locator segments that has a child referenced
    // by index. Note that a child component with an explicit
    // +link{canvas.locatorName,locatorName} will be excluded since the name is a reliable
    // means to locate the component.
    //
    // @visibility external
    //<

    //> @classMethod AutoTest.getLocatorWithIndicators()
    // Returns the +link{object:QualityIndicatedLocator} associated with some DOM element in a
    // SmartClient application page.  If coords, representing the page position, is passed in,
    // the locator
    // may be generated with a specific trailing "target area" identifer that will map back to
    // the appropriate, potentially different, physical coordinates, even if the widget is
    // moved.  The coords argument will only have an effect in cases where the mouse position
    // over the target could potentially change behavior.
    // @param DOMElement (DOMElement) DOM element within in the page. If null the locator for
    //  the last mouse event target will be generated
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //  the target element responds to native browser events directly rather than going through
    //  the SmartClient widget/event handling model. If we detect this case, return null rather
    //  than a live locator.  This allows us to differentiate between (for example) an event on
    //  a Canvas handle, and an event occurring directly on a simple 
    //  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
    // @param [coords] (Array) X, Y page position
    // @return (QualityIndicatedLocator) Locator details allowing the AutoTest subsystem to find
    //   an equivalent DOM element on subsequent page loads.
    // @visibility external
    // @group autoTest
    //<
    getLocatorWithIndicators : function (DOMElement, checkForNativeHandling, coords) {
        this._locatorDetails = {};
        var rawLocator = this.getLocator(DOMElement, checkForNativeHandling, coords),
            locator = this._locatorDetails
        ;
        locator.locator = rawLocator;
        // Don't leave indicators object around because normal locator calls
        // (like *When rules) could be affected.
        delete this._locatorDetails;
        return locator;
    },

    getTableCellValue : function (DOMElement, row, col) {
        var grid = isc.AutoTest.locateCanvasFromDOMElement(DOMElement);

        // both GR and LG support getCellRecord()/getCellValue()
        if ((isc.GridRenderer && isc.isA.GridRenderer(grid)) ||
            (isc.ListGrid     && isc.isA.ListGrid    (grid)))
        {
            var record = grid.getCellRecord(row, col);
            return grid.getCellValue(record, row, col);
        }
        return null;
    },
    
    //> @classMethod AutoTest.getObjectLocator()
    // Method to derive a locator string for identifying a SmartClient object. This is
    // a SmartClient component, a FormItem, or SectionStackSection.
    // <P>
    // Use +link{AutoTest.getObject()} to resolve an object locator to a live object.
    //
    // @param target (Canvas | FormItem | SectionStackSection) target for the locator. 
    // @return (AutoTestObjectLocator) generated locator
    // @visibility rules
    //<
    
    getObjectLocator : function (target) {
        if (target.destroyed || target.destroying) return null;

        // We can be passed
        // - a FormItem.
        // - a SectionStackSection.
        // - a Canvas.
        // _getCanvasForSCObject will resolve to the nearest "canvas" which will be
        // capable of generating a locator for the actual object.
        var targetCanvas = this._getCanvasForSCObject(target);
        var canvasLocator = targetCanvas.getLocator();

        if (targetCanvas == target) {
            return canvasLocator;
        }
        
        // The 'interiorLocator' will be the xpath to the target object, plus an "objectType" flag
        // we can parse back later.
        var interiorLocator = targetCanvas.getObjectLocator(target);
        if (interiorLocator != null) canvasLocator += "/" + interiorLocator;
        return canvasLocator;
    },
    
    // Helper - extract the "object type" from a locator string.
    
    getLocatorObjectType : function (locator) {
        var objectTypeInfo = locator.substring(locator.lastIndexOf("/")+1);
        if (objectTypeInfo && objectTypeInfo.startsWith("objectType=")) {
            return objectTypeInfo.substring(11);
        }
        return "Canvas";
    },

    
    //> @classMethod AutoTest.locateCanvasFromDOMElement()
    // Given an element in the DOM, returns the canvas containing this element, or null if
    // the element is not contained in any canvas handle.
    // @param element (DOMElement) DOM element within in the page
    // @return (Canvas) canvas containing the element, or null if none apply
    // @visibility external
    // @group autoTest
    //<
    
    locateCanvasFromDOMElement : function (element, locateContainer) {
        var canvas = isc.EH.getEventTargetCanvas(null, element);
        // don't use a destroyed canvas, as it may not have all the properties we expect
        
        if (canvas && canvas.destroyed) canvas = null;
        // if we haven't reached a DF, we're done; just return the canvas
        if (!locateContainer || !isc.isA.DynamicForm(canvas)) return canvas;
        // if we want the container, we must query the item
        var item = this.locateFormItemFromDOMElement(element, canvas);
        return item != null ? item.containerWidget : canvas;
    },

    // helper similar to locateCanvasFromDOMElement() above;
    // element must be a DynamicForm or DOM element - not a locator
    locateFormItemFromDOMElement : function (element, form) {
        if (!form) form = this.locateCanvasFromDOMElement(element);
        if (!isc.isA.DynamicForm(form) || form.destroyed) return null;
        
        var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, form);
        return itemInfo ? itemInfo.item : null;
    },
    
    //> @classMethod AutoTest.getRelativeLocator()
    // Method to derive a relative locator string for identifying a DOMElement ultimately nested
    // within some baseComponent.
    // <P>
    // This is useful for cases where a standard pattern of components may be reused within
    // an application - for example multiple Windows containing the same UI within them.
    // In this case the developer can get a 'relative locator' from the base compoent (the Window)
    // to some nested DOM element (may be nested within a number of intervening canvaes),
    // and reuse the locator for other base components (in our example, 
    // other Windows) with the same structure of descendents.
    // <P>
    // Use +link{AutoTest.resolveRelativeLocator()} to resolve a relativeLocator plus
    // baseComponent SmartClient object.
    //
    // @param baseComponent (Canvas) base component for the relative locator
    // @param target (DOMElement) target for the relative locator. 
    // @return (AutoTestLocator) generated locator
    // @visibility rules
    //<
    getRelativeLocator : function (baseComponent, target) {
        // normal behavior if passed a DOM element:  
        var targetCanvas = this.locateCanvasFromDOMElement(target),
            locator = this.getRelativeCanvasLocator(baseComponent, targetCanvas);
        if (locator) locator += "/";
        return locator + targetCanvas.getInteriorLocator(target);
    },
    
    // helper to test whether some locator is relative or absolute
    isRelativeLocator : function (locator) {
        return (!locator.startsWith("//"));
    },

    getRelativeCanvasLocator : function (baseComponent, targetCanvas) {
        if (baseComponent == targetCanvas) return "";
        // Build the path (needs a loop)
        var currentCanvas = targetCanvas,
            locators = [];
        while (currentCanvas != baseComponent) {
            var parentCanvas = currentCanvas.getLocatorParent();
            // If we don't find a relationship between the base and the child 
            // there's not a lot we can do...
            if (parentCanvas == null) {
                this.logWarn("Unexpected error: attempting to get relative locator from baseComponent:"
                    + baseComponent + " and target:"+ targetCanvas + ". Unable to determine "
                    + "relationship between these objects.");
                return "";
            }
            var canvasLocator = parentCanvas.getChildLocator(currentCanvas);
            if (canvasLocator != null) locators.add(canvasLocator);
            currentCanvas = parentCanvas;
        }
        // Locators array is backwards since we iterated up the hierarchy! flip and join
        var locatorString = "";
        for (var i = locators.length-1; i >=0; i--) {
            locatorString += locators[i];
            if (i != 0) locatorString += "/";
        }

        return locatorString;
    },

    //> @classMethod AutoTest.getRelativeObjectLocator()
    // Method to derive a relative locator string for identifying a component or SmartClient object within 
    // some baseComponent.
    // <P>
    // This is useful for cases where a standard pattern of components may be reused within
    // an application - for example multiple Windows containing the same UI within them.
    // In this case the developer can get a 'relative locator' from the base compoent (the Window)
    // to some nested sub object, and reuse the locator for other base components (in our example, 
    // other Windows) with the same structure of descendents.
    // <P>
    // Use +link{AutoTest.resolveRelativeObjectLocator()} to resolve a relativeLocator plus
    // baseComponent SmartClient object.
    // <P>
    // <b>Note:</b> For working with relativeLocators and DOM elements directly, use
    // +link{AutoTest.getRelativeLocator()} and +link{AutoTest.resolveRelativeLocator()}.
    //
    // @param baseComponent (Canvas) base component for the relative locator
    // @param target (Canvas | FormItem | SectionStackSection) target for the relative locator. 
    // @return (AutoTestObjectLocator) generated locator
    // @visibility rules
    //<
    
    
    getRelativeObjectLocator : function (baseComponent, target) {
    
        // We can be passed
        // - a FormItem.
        // - a SectionStackSection.
        // - a Canvas.
        // _getCanvasForSCObject will resolve to the nearest "canvas" which will be
        // capable of generating a locator for the actual object.
        var targetCanvas = this._getCanvasForSCObject(target);
        var canvasLocator = this.getRelativeCanvasLocator(baseComponent, targetCanvas);

        if (targetCanvas == target) {
            return canvasLocator;
        }
        
        var interiorLocator = targetCanvas.getObjectLocator(target);
        if (interiorLocator != null) canvasLocator += "/" + interiorLocator;
        return canvasLocator;
        
    },
    _getCanvasForSCObject : function (target) {
        // Existing AutoTest APIs (getChildLocator etc) can't handle FormItem etc since
        // there's no property pointing to the containing widget (EG DynamicForm) which would
        // have an understanding of the object passed in.
        // We'll have to resolve these explicitly here looking at properties on the object
        // passed in.
        
        
        // SectionStackSection: We create a SectionHeader for each section (even if it isn't shown)
        // Grab this widget and use 'parentElement' to get a pointer to the stack
        if (target._sectionHeader != null) target = target._sectionHeader;
        if (target.isSectionHeader) {
            return target.parentElement;
        }
        
        // If passed a form item, use item.form
        if (isc.FormItem && isc.isA.FormItem(target)) return target.form;
        
        if (isc.isA.Canvas(target)) return target;
        
        this.logWarn("getRelativeLocatorObject() passed target object:" + this.echo(target) +
            " This is not a recognized supported SmartClient object - expected to be a " +
            "Canvas, FormItem or SectionStackSection only");
        return null;
        
    },
    
    // ------------------------------
    // Retrieving elements from the DOM based on locator string
       
    //> @classMethod AutoTest.getElement()
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (DOMElement) DOM element this locator refers to in the running application, or
    // null if not found
    // @visibility external
    // @group autoTest
    //<
    
    getElement : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Element);
    },
    
    //> @classMethod AutoTest.getObject()
    // Given an +link{AutoTestLocator}, return the live SmartClient object it refers to, if any.
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Canvas | FormItem | SectionStackSection) target object, or null if
    //  unable to resolve the locator to a live object.
    // @visibility external
    // @group autoTest
    //<
    getObject : function (locator, moreAttributes) {
        return this.getAttribute(locator, isc.Canvas._$Object, moreAttributes);
    },

    // internal method using getObject() that returns only formItemIcons
    
    getFormItemIcon : function (locator, moreAttributes) {
        if (!moreAttributes) moreAttributes = {};
        isc.addProperties(moreAttributes, {canReturnIcon: true});
        // return null unless we've actually got an icon
        var icon = this.getObject(locator, moreAttributes);
        return isc.isAn.Instance(icon) ? null : icon;
    },

    
    
    getObjectContext : function (locator, suppressWarnings) {
        var targetObject = isc.AutoTest.getObject(locator, { 
            suppressWarnings: suppressWarnings, canReturnIcon: true
        });
        if (targetObject == null) return null;
        return this._getObjectContext(targetObject, locator);
    },

    getRelativeObjectContext : function (baseComponent, locator, suppressWarnings) {
        var targetObject = isc.AutoTest.resolveRelativeObjectLocator(baseComponent, locator, { suppressWarnings: suppressWarnings });
        if (targetObject == null) return null;

        return this._getObjectContext(targetObject, locator);
    },

    _getObjectContext : function (targetObject, locator) {
        var context = {
            locator: locator,
            object: targetObject
        };

        
        if (isc.FormItem && isc.isA.FormItem(targetObject)) {
            context.objectType = "FormItem";
            context.container = targetObject.containerWidget;
        } else if (targetObject.isSectionHeader) {
            context.objectType = "Section";
            // targetObject will probably be the Canvas but in case
            // we ever get a pointer to the actual config object, resolve it:
            if (targetObject.getSectionHeader) {
                context.object = targetObject.getSectionHeader();
            }
            
            context.container = targetObject.parentElement;
        } else if (isc.isA.Canvas(targetObject)) {
            context.objectType = "Canvas";
            // no 'container' - we'll just hide the canvas.
        } else {
            // Target objects that are not class instances like FormItemIcon, MenuItem, etc.
            var locatorType = isc.AutoTest.getLocatorObjectType(locator);
            if (locatorType == "FormItemIcon") {
                context.objectType = locatorType;
                context.container = isc.AutoTest.getLocatorFormItem(locator);
            } else if (locatorType == "MenuItem") {
                context.objectType = locatorType;
                context.container = isc.AutoTest.getLocatorCanvas(locator);
            }
        }

        return context;
    },

    isRecordLocator : function (locator) {
        
        return locator.contains("row[");
    },

    isNewRecordRowLocator : function (locator) {
        return locator.contains("body/newRecordRow");
    },

    getRecord : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Record);
    },

    getField : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Field);
    },

    
    reportValuesAsString: false,

    decimalPad: null,
    decimalPrecision: 6,
    valueSeparator: " ",

    //> @classMethod AutoTest.getValue()
    // Given an +link{AutoTestLocator} that refers to a live SmartClient object or a logical
    // subcomponent of that object, return the associated meaningful JS value, if any.
    // <P>
    // For example:
    // <ul>
    //     <li> For a locator to a ListGrid/CubeGrid cell, return the cell's value
    //     <li> For a locator to a FormItem, return the FormItem's value
    //     <li> For a locator to a ListGrid field header, return the checkbox/sorting state
    //     <li> For a locator to a Calendar EventCanvas header or body, return the text
    // </ul>
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Object) value associated with SC object if any, otherwise undefined
    // @visibility external
    // @group autoTest
    //<
    getValue : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Value);
    },
    
    isSelected : function (locator) {
        return this.getAttribute(locator, isc.Canvas._$Selected);
    },

    //> @classMethod AutoTest.setVariable()
    // Store a named variable for later use in an autoTest.
    // <P>
    // Variables may be resolved dynamically by autoTest locators using the 
    // <code>&#36;{...}</code> notation. For example a locator containing the following
    // substring:
    // <P>
    // <code>.../body/row[countryCode=&#36;{testRecord.countryCode}]/...</code>
    // <P>
    // Would resolve to the <code>countryCode</code> attributes of an object
    // stored as <code>"testRecord"</code>.
    // <P>
    // This makes it possible to make portable tests where it is easy to modify the
    // test conditions and identifiers for a specific data set.
    // <P>
    // See also +link{AutoTest.storeLocatorResult()}
    //
    // @param name (String) name for the variable
    // @param value (Any) value to store for this variable
    // @visibility smartclient
    //<
    
    _locatorVariables:{},
    setVariable : function (name, value) {
        this._locatorVariables[name] = value;
    },

    //> @classMethod AutoTest.clearVariable()
    // Clear a +link{AutoTest.setVariable(),stored variable}.
    //
    // @param name (String) name for the variable to clear
    // @visibility smartclient
    //<
    clearVariable : function (name) {
        delete this._locatorVariables[name];
    },

    //> @classMethod AutoTest.storeLocatorResult()
    // This method will resolve a locator against the current environment and
    // store it as a +link{setVariable(),variable}.
    // <P>
    // For example, the following code would store the first record from a listGrid
    // with ID "myList" as AutoTest variable <code>"testRecord"</code>
    // <pre>
    // isc.AutoTest.storeLocatorResult(
    //     "testRecord",
    //     "//ListGrid[ID=\"myList\"]/body/row[0]",
    //     "record"
    // );
    // </pre>
    // 
    // @param name (String) variable name for the locator
    // @param [locator] (String) locator to resolve. If null the named variable will be cleared.
    // @param [attribute] (LocatorAttributeType) what type of value should be 
    //      derived from the locator? Valid options differ based on the locator
    // @visibility smartclient
    //<
    storeLocatorResult : function (name, locator, attribute) {
        if (name == null) return;
        if (locator == null) delete this._locatorVariables[name];
        else {
            if (attribute == null) attribute = isc.Canvas._$Value;
            var resolved = this.getAttribute(locator, attribute);
            this._locatorVariables[name] = resolved;
        }
    },

    //> @classMethod AutoTest.getVariable()
    // Retrieve a variable stored by +link{AutoTest.setVariable()} or +link{AutoTest.storeLocatorResult()}
    // @param name (String) variable to retrieve
    // @return (Any) stored variable value
    // @visibility smartclient
    //<
    getVariable : function (name) {
        return this._getLocatorVariable(name);
    },
    
    _missingVariableMarker:{missingVariable:true},
    _getLocatorVariable : function (name, strict) {
        if (strict && !this._locatorVariables.hasOwnProperty(name)) {
            return this._missingVariableMarker;
        }
        return this._locatorVariables[name];
    },

    //> @classMethod AutoTest.variableIsDefined()
    // Determine whether a variable has been explicitly set via +link{AutoTest.setVariable()}
    // or +link{AutoTest.storeLocatorResult()}.
    // <P>
    // This method will return true if the variable has been set to any
    // value, including <code>null</code>, or false if the variable has never been
    // set or has been +link{AutoTest.clearVariable(),cleared}.
    // 
    // @param name (String) variable to retrieve
    // @return (Boolean) true
    // @visibility smartclient
    //<
    variableIsDefined : function (name) {
        var variable = this._getLocatorVariable(name, true);
        if (variable == this._missingVariableMarker) return false;
        return true;
    },

    // string.replace converter function to swap ${varname} with stored var values
    
    _locatorVariableConvert : function (match, innerContent) {

        if (innerContent == null || innerContent == "") return;
        
        // Resolve ${record.field1} etc
        var splitResult = innerContent.split(".");
        var value = isc.AutoTest._getLocatorVariable(splitResult[0],true);
        var missingVar = value == isc.AutoTest._missingVariableMarker;
        for (var i = 1; i < splitResult.length; i++) {
            if (value == null) {
                missingVar = true;
                break;
            }
            value = value[splitResult[i]];
        }
        // If the locator variable hasn't been defined, don't modify the segment
        if (missingVar) {
            isc.AutoTest.logWarn("Unable to convert unrecognized variable in locator: " + match);
            return match;
        }
        return value;
    },

    // resolveLocatorVariables: If true, ${varName} notation may be used to reference
    // variables stored via AutoTest.setVariable()
    // For example after a call to 
    //  AutoTest.setVariable("testRecord", {countryCode:"US"});
    // a locator substring to identify a cell in a listGrid body could find the correct
    // row with the following notation:
    // .../body/row[countryCode=${testRecord.countryCode}]/col[fieldName=countryCode||0]"
    resolveLocatorVariables:true,
    
    // Helper to trim slashes from a locator and process it ready to be split into
    // segments
    _normalizeLocatorString : function (locator) {
        if (!locator) return null;

        
        locator = locator.replace(/^(scLocator|ScID)=/i, "");

        // Replace every ${varName} with the registered variable
        if (this.resolveLocatorVariables) {
            locator = locator.replace(new RegExp("\\$\\{(.+?)\\}","g"), this._locatorVariableConvert);
        }
        // trim off quote chars from the start/end of the string
        
        if (locator.startsWith("'") || locator.startsWith('"')) locator = locator.substring(1);
        if (locator.endsWith("'") || locator.endsWith('"')) locator = locator.substring(0,locator.length-1);

        if (locator.startsWith("///")) {
            // Special case where base component is identified by ID only
            var locatorArray = locator.trimCharacters("/").split("/");
            
            // if "restrictSuffix" or "permitSuffix" has been injected, remember it
            var locatorMatching  = locator.match(/,locatorMatching=(restrict|permit)Suffix/);

            locator = locatorArray[0];
            // knock off the baseComponent
            locatorArray = locatorArray.slice(1);
            locator = '//*any*[ID="' + locator + '"]' + 
                        (locatorArray.length > 0 ? "/" + locatorArray.join('/') : "");

            
            if (locatorMatching) {
                
                locator = locator.replace(/,locatorMatching=(restrict|permit)Suffix/g, "");
                // finally add the configuration back to the initial bracket sequence
                locator = locator.replace(/\[([^\]]+)\]/, "[$1" + locatorMatching[0] + "]");
            }

        } else if (!locator.startsWith("//")) {

            // assume either just an ID or "ID=[ID]"
            if (locator.startsWith("ID=") || locator.startsWith("id=")) {
                locator = locator.substring(3);
            }
            locator = '//*any*[ID="' + locator + '"]';
        }
        // remove leading and trailing slashes
        locator = locator.trimCharacters("/")

        // Prefix search segments with ":"
        
        locator = locator.replaceAll("//", "/:");

        return locator;

    },

    getAttribute : function (locator, attribute, moreAttributes) {
        
        if (locator == null || locator == "") return null;
        locator = this._normalizeLocatorString(locator);

        // Split into segments by slashes
        var locatorArray = locator.split("/");

        var baseComponentID = locatorArray[0];
        if (!baseComponentID) return null;

        // knock off the baseComponent
        locatorArray = locatorArray.slice(1);

        var configuration = isc.addProperties({attribute: attribute}, moreAttributes),
            baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID,
                                                                      configuration);
        if (!baseComponent) return null;

        return baseComponent.getAttributeFromSplitLocator(locatorArray, configuration);
    },
    
    //> @classMethod AutoTest.resolveRelativeLocator()
    // Given a relative locator (retrieved from +link{AutoTest.getRelativeLocator()}) and a
    // base component, resolve it to the target element in the DOM.
    // @param baseComponent (Canvas) base component to resolve the relative locator from
    // @param relativeLocator (AutoTestLocator) relative locator retrieved from 
    //  +link{AutoTest.getRelativeLocator()}
    // @return (DOMElement) target DOM element, or null if unable to resolve the relative path.
    // 
    // @visibility rules
    //<
    resolveRelativeLocator : function (baseComponent, relativeLocator) {
        var splitLocatorArray = relativeLocator.split("/");
        return baseComponent.getAttributeFromSplitLocator(splitLocatorArray, 
                                                          {attribute: isc.Canvas._$Element});
    },

    //> @classMethod AutoTest.resolveRelativeObjectLocator()
    // Given a relative locator (retrieved from +link{AutoTest.getRelativeObjectLocator()}) and a
    // base component, resolve it to the target SmartClient object. The SmartClient object may
    // be one of:
    // <ul>
    // <li>A Canvas</li>
    // <li>A FormItem</li>
    // <li>A SectionStackSection</li>
    // </ul>
    // @param baseComponent (Canvas) base component to resolve the relative locator from
    // @param relativeLocator (AutoTestObjectLocator) relative locator retrieved from 
    //  +link{AutoTest.getRelativeObjectLocator()}
    // @return (Canvas | FormItem | SectionStackSection) target object, or null if
    //  unable to resolve the relative path.
    // 
    // @visibility rules
    //<
    resolveRelativeObjectLocator : function (baseComponent, relativeLocator, moreAttributes) {
        var splitLocator = isc.isAn.Array(relativeLocator) ? relativeLocator : 
                                                             relativeLocator.split("/");
        var configuration = isc.addProperties({attribute: isc.Canvas._$Object}, moreAttributes);
        return baseComponent.getAttributeFromSplitLocator(splitLocator, configuration);
    },

    //> @classMethod AutoTest.getPageCoords()
    // Returns the page-level coordinates corresponding to the supplied locator.  Note: The
    // physical position might change due to app redesign, but these coordinates would still
    // reflect the same logical part of the DOM element for components where event position
    // matters.
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Array) X, Y page position
    // @visibility external
    // @group autoTest
    //<
    getPageCoords : function (locator) {
        var element = this.getElement(locator);
        if (element == null) return;
        
        var canvas = this.locateCanvasFromDOMElement(element);    
        return canvas ? canvas.getAutoTestLocatorCoords(locator, element) : null;
    },
    
    //> @classMethod AutoTest.getPageRect()
    // Returns the page-level position and size of a rectangle corresponding to the supplied locator.  Note: The
    // physical position might change due to app redesign, but these coordinates would still
    // reflect the same logical part of the DOM element for components where event position
    // matters.
    // @param locator (AutoTestLocator) Locator String previously returned by 
    //       +link{AutoTest.getLocator()}
    // @return (Array) Array representing left, top, width and height values for the target rectangle
    // @group autoTest
    //<
    
    getPageRect : function (locator) {
        var element = this.getElement(locator);
        if (element == null) return;
        
        var canvas = this.locateCanvasFromDOMElement(element);
        
        return canvas ? canvas.getAutoTestLocatorRect(locator, element) : null;
    },

    // WebDriver helper to call scrollIntoView() only if needed according to our heuristics
    scrollElementIntoViewIfNeeded : function (locator) {
        var element = this.getElement(locator);
        if (element == null) return false;
        
        var canvas = this.locateCanvasFromDOMElement(element);
        if (canvas == null) return false;

        var elementCoords = canvas.getAutoTestLocatorCoords(locator, element);
        if (elementCoords == null) return false;

        var coordsElement = document.elementFromPoint(elementCoords[0], elementCoords[1]);
        if (coordsElement != null && element.contains(coordsElement)) return false;

        // scroll the target element into view
        this._scrollingElementIntoView = true;
        element.scrollIntoView();
        return true;
    },

    // WebDriver helper to detect when call to scrollElementIntoViewIfNeeded() completes
    isElementInViewport : function (element) {
        var documentElement = document.documentElement,
            boundingRect = element.getBoundingClientRect()
        ;
        return boundingRect.top >= 0 && boundingRect.left >= 0 &&
            boundingRect.bottom <= (window.innerHeight || documentElement.clientHeight) &&
            boundingRect.right  <= (window.innerWidth  || documentElement.clientWidth);
    },

    // WebDriver helper called after the scroll is done to clear the scroll state
    scrolledElementIntoView : function () {
        delete this._scrollingElementIntoView;
    },

    // WebDriver helper to choose the best point from the supplied set at which to click on
    // behalf of the supplied element - WebDriver isn't able to click on occluded elements.
    getNearestDescendantElement : function (xCoords, yCoords, rootElement, rootX, rootY) {
        var minDepth, nearest,
            nCoords = xCoords.length
        ;
        // if the occluding point at the original coordinates is contained by the rootElement,
        // then we're done - we'll just click there on behalf of the occluding element
        var elementAtPoint = document.elementFromPoint(rootX, rootY);
        if (elementAtPoint && rootElement.contains(elementAtPoint)) {
            return [elementAtPoint, -1];
        }

        // Otherwise, search the passed in points to see if one of them reaches the originally
        // targeted element, or one of its descendants.  Nearer descendants are better, as are
        // points near the middle of the sequence (currently those are near the rect's center).
        for (var i = 0; i < nCoords; i++) {
            var coordsElement = document.elementFromPoint(xCoords[i], yCoords[i]);

            // find the depth of coordsElement under rootElement (if descendant)
            for (var depth = 0, currentElement = coordsElement;
                 currentElement != null && currentElement != rootElement;
                 depth++, currentElement = currentElement.parentElement);

            // skip any points that aren't descendants, unless they share the same eventproxy
            
            if (currentElement == null && !this._eventProxyMatches(rootElement, coordsElement))
            {
                continue;
            }

            // best point is closest to rootElement, and in middle of point array
            var offset = Math.floor(Math.abs(i - nCoords/2));
            if (minDepth == null || minDepth > depth || 
                minDepth == depth  && nearest[2] > offset)
            {
                minDepth = depth; 
                nearest = [coordsElement, i, offset];
            }
        }

        // return best point
        return nearest;
    },

    // check whether the supplied two DOM elements have the same eventproxy
    _eventProxyMatches : function (element1, element2) {
        if (!element1 || !element2) return false;
        // return whether the two DOM elements have the same eventproxy
        var eventProxy1 = element1.getAttribute("eventproxy"),
            eventProxy2 = element2.getAttribute("eventproxy");
        return eventProxy1 != null && eventProxy1 == eventProxy2;
    },

    // if fallback class data is not present, we may want to warn the user
    _shouldReportClassMismatch : function (className, classInstance) {
        if (this.useMinimalFallbackAttributes) return false;
        return !isc.isA[className] || !isc.isA[className](classInstance);
    },

    // implement user-extensions.js Selenium v1 focus strategy for use by WebDriver
    locatorFocus : function (locator, refocus) {
        var focused = false,
            element = this.getElement(locator),
            canvas = isc.AutoTest.locateCanvasFromDOMElement(element, true)
        ;
        // if no canvas or masked, just bail out
        if (!canvas || canvas.isMasked()) return focused;

        // for a formitem, give the form focus rather than the containWidget
        var object = isc.AutoTest.getObject(locator);
        if (isc.FormItem && isc.isA.FormItem(object)) {
            if (object.isDrawn()) {
                canvas = object.form;
                // unless told to refocus, skip if item already has focus
                if (refocus || canvas.getFocusItem() != object) {
                    canvas.setFocusItem(object);
                    focused = true;
                }
            }
        }

        // focus on the target canvas; skip if already focused and not refocusing
        if (refocus || focused || isc.EH.getFocusCanvas() != canvas) {
            canvas.setFocus(true, "Selenium");
            focused = true;
        }
        return focused;
    },

    // provide access to the TabSet "nearest" to the current focus
    getActiveCanvas : function () {
        return this.locateCanvasFromDOMElement(this.getActiveElement());
    },

    getActiveTabSet : function (locator) {
        if (!isc.TabSet) return;

        // allow an explicit locator to override the current focus canvas
        var targets = [this.getObject(locator) || isc.EH.getFocusCanvas() ||
                       this.getActiveCanvas()];
        targets.addList(isc.Canvas._topCanvii);

        // look for a tabSet below and then above each target, in order
        for (var i = 0; i < targets.length; i++) {
            var tabSet = this._getNearestTabSet(targets[i]);
            if (tabSet) return tabSet;
        }
    },

    _getNearestTabSet : function (startWidget) {
        if (!startWidget) return;

        var widget = startWidget;
        while (!isc.isA.TabSet(widget) && widget != null) {
            widget = widget.parentElement;
        }
        if (widget) return widget;
        widget = startWidget;

        var queue = widget.children || isc._emptyArray;
        for (var i = 0; i < queue.length; i++) {
            var widget = queue[i];
            if (isc.isA.TabSet(widget)) return widget;
            queue.addList(widget.children);
        }        
    },

    // getBaseComponentFromLocatorSubstring: This actually gets the *base* component from
    // a locator substring.
    // 2 possibilities:
    // - explicit ID (respect that)
    // - part of the array of top-level canvii
    getBaseComponentFromLocatorSubstring : function (substring, configuration, returnAllMatches) {

        // If the locator is prefixes with "//:" this is a minimal locator
        
        if (substring.startsWith(":")) {
            substring = substring.substring(1,substring.length);
            var includeHidden = false;
            if (substring.startsWith("?")) {
                includeHidden = true;
                substring = substring.substring(1,substring.length);
            }
            if (substring.startsWith("[")) {
                substring = substring.replace("[", "autoID[");
            } else {
                return isc.AutoTest._searchForCanvas(null, substring, returnAllMatches, includeHidden);
            }
        }

        var IDMatches = substring.match("(.*)\\[");
        var IDType = IDMatches ? IDMatches[1] : null;

        switch (IDType) {
            // if the recorded canvas had an auto-generated ID, try to find it by looking in the
            // top level (no parent) canvas array.
            // We'll look by name, title, then index by class, scClass and role!
        case "autoID":
            
            var config = isc.AutoTest.parseLocatorFallbackPath(substring),
                widgetConfig = config.config,
                strategy = "name",
                typeStrategy = "Class";

            var canvas = isc.Canvas.getCanvasFromFallbackLocator(
                substring, widgetConfig, isc.Canvas._topCanvii, strategy, typeStrategy);
            if (canvas == null) {
                this.setLogFailureText(true, "there's no top level Canvas identifiable " +
                    "by name or Class from fallback locator '" + substring + "' for locator");
            }
            return canvas;

        case "testRoot":

            var IDMatches = substring.match("testRoot\\[(.*)?\\]"),
                configSettings = IDMatches ? IDMatches[1] : null;

            // install any declared property bindings into the configuration
            this.installLocatorConfiguration(configSettings, configuration);

            if (this.testRoot == null) {
                this.logWarn("Unable to process scLocators starting with " + this._$testRoot +
                             "... when no test root canvas has been configured");
                return null;
            }
            return this.testRoot;

        case "Menu":

            if (!isc.Menu) {
                this.setLogFailureText(true, "the Menu module is required " +
                                       "to resolve locator");
                return null;
            }

            var levelMatches = substring.match(/Menu\[level=(.*)(,.*)?\]/i),
                level = levelMatches ? levelMatches[1] : null;
            if (level != null) {
                // install any declared property bindings into the configuration
                this.installLocatorConfiguration(levelMatches[2], configuration);

                var menu = isc.Menu.getMenuAtLevel(level);
                if (menu == null) {
                    this.setLogFailureText(true, "there is no Menu corresponding " + 
                                           "to level '" + level + "' for locator");
                }
                return menu;
            }

            // fall through to allow legacy Menu locators to work!!!

        default:
        
            var className = IDType, 
                IDMatches = substring.match('\\[ID=[\\"\'](.*)[\'\\"](,.*)?\\]'),
                ID = IDMatches ? IDMatches[1] : null;
            
            if (ID == null) {
                this.setLogFailureText(true, "there appears to be a " + 
                                       "problem with the syntax for locator");
                return null;
            }

            // install any declared property bindings into the configuration
            this.installLocatorConfiguration(IDMatches[2], configuration);

            var baseComponent = window[ID];
            if (!baseComponent) {
                this.setLogFailureText(true, "there is no " + className + 
                                       "with ID '" + ID + "' for locator");
                return null;
            }
        
            if (baseComponent && className != "*any*" && 
                this._shouldReportClassMismatch(className, baseComponent))
            {
                this.logWarn("AutoTest.getElement(): Component:"+ baseComponent + 
                            " expected to be of class:" + className);
            }
            return baseComponent;
        }
    },

    //> @classMethod AutoTest.installLocatorConfiguration()
    // Inserts property bindings declared on scLocator into configuration object.
    // @param (String) bindings declaration from scLocator
    // @param (Object) configuration of this scLocator lookup
    //<
    installLocatorConfiguration : function (declaration, configuration) {
        if (!declaration) return;
        var bindings = declaration.split(",");
        for (var i = 0; i < bindings.length; i++) {
            var binding = bindings[i].trim().match("([^=]*)=([^=]*)");
            if (binding) configuration[binding[1]] = binding[2];
        }
    },

     // Retrieving SC objects from locator string
    //> @classMethod AutoTest.getLocatorCanvas()
    // Returns the Canvas for some previously generated locator string.
    // @param (AutoTestLocator) Locator String previously returned by +link{AutoTest.getLocator()}
    // @return (Canvas) Canvas associated with this locator
    // @visibility internal
    // @group autoTest
    //<
    
    
    getLocatorCanvas : function (locator) {

        if (locator == null || isc.isAn.emptyString(locator)) return null;
        locator = this._normalizeLocatorString(locator);

        var locatorArray = locator.split("/"),
            component;
        
        //this.logWarn("locatorArray" + locatorArray);
        var baseComponentID = locatorArray[0];
        if (!baseComponentID) return null;
        
        var baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID);
        if (baseComponent) {
            var i = 1,
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray);
            
            while (child != null) {
                i++;
                baseComponent = child;
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray);
            }
            return baseComponent;
        }
        return null;
    },
    
    //> @classMethod AutoTest.getLocatorFormItem()
    // Returns the FormItem for some previously generated locator string, or null if no
    // matching FormItem can be found.
    // @param (Locator) Locator String previously returned by +link{AutoTest.getLocator()}
    // @return (Canvas) Canvas associated with this locator
    // @visibility internal
    // @group autoTest
    //<
    getLocatorFormItem : function (locator) {
        // Simply get the DOM element and pick up the DynamicForm/ FormItem from it.
        // XXX this will not work if the Canvas is currently undrawn.
        /*
        var DOMElement = this.getElement(locator);
        if (DOMElement != null) {
            var form = this.locateCanvasFromDOMElement(DOMElement);
            if (isc.isA.DynamicForm(form)) {
                var itemInfo = isc.DynamicForm._getItemInfoFromElement(DOMElement,form);
                if (itemInfo) return itemInfo.item;
            }
        }
        return null;
        */
        if (locator == null || isc.isAn.emptyString(locator) || !locator.startsWith("//")) return null;

        locator = this._normalizeLocatorString(locator);

        var locatorArray = locator.split("/"),
            component;
        
        //this.logWarn("locatorArray" + locatorArray);
        var baseComponentID = locatorArray[0];
        if (!baseComponentID) return null;

        var baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID);
        if (baseComponent) {
            
            var child = baseComponent.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray);
            while (child != null) {
                locatorArray.removeAt(0);
                baseComponent = child;
                child = baseComponent.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray);
            }
        }
        if (isc.isA.DynamicForm(baseComponent)) {
            return baseComponent.getItemFromSplitLocator(locatorArray);
        }
        return null;
    },
    
    // Fallback locator subsystem:
    // For cases where there is more than one possible way to identify a component or element
    // we generate a string similar to this:
    // "row[a=b||b=c||7]"
    
    // createLocatorFallbackPath()
    // Takes a locator name and an object of the format:
    //   {fieldName:value, fieldName:value}
    // and returns a string in the format
    //   name[fieldName=value||fieldName=value...]
    // standalone values (with no "=" may also be included -- to do this set the "fallback_valueOnlyField"
    // property on the object passed in
    // For example:
    //   var identifier = {a:"b"};
    //   identifier[isc.AutoTest.fallback_valueOnlyField] = "c";
    //   isc.AutoTest.createLocatorFallbackPath("test", identifier);
    // would give back:
    //   "test[a:b||c]"
    
    fallback_valueOnlyField:"_$_standaloneProperty",
    
    fallback_startMarker:"[",
    fallback_endMarker:"]",
    fallback_separator:"||",
    fallback_equalMarker:"=",
    
    // If a property name contains the "/" character we can't store it as we use
    // simple string.split to break up based on this char.
    // Fix this by just sub-ing in a customizable marker when generating locators.
    
    slashMarker:"$fs$",
    
    createLocatorFallbackPath : function (name, config, object, sourceArray) {
        
        var locator = [];

        // filter the fallback config when generating minimal locators, 
        if (this.useMinimalFallbackAttributes) {
            config = this.minimizeFallbackConfig(config, object, sourceArray);
        }

        // for minimal locators use compact (class)index, , etc. syntax
        if (this.useCompactFallbackSyntax) {
            config = this._compactifyFallbackConfig(config, object);
        }

        for (var field in config) {
            var fieldVal = config[field];

            // reduce the length of the locator by stripping CSS styling, etc.
            if (this.simplifyLocatorAttributeHTML && isc.isA.String(fieldVal)) {
                fieldVal = String.htmlStringToString(fieldVal);
            }
            
            // If a string contains "[", "||", etc we can get very confused
            // use 'encodeURIComponent' to HTML encode the string; we'll unencode when parsing
            // We have to escape actual slashes too as this will break our logic to 
            // break up stored locators.
            // use a regex to just replace them with a customizeable marker
            if (isc.isA.String(fieldVal)) {
                fieldVal = fieldVal.replaceAll("/",this.slashMarker);
                fieldVal = encodeURIComponent(fieldVal);
            }
            
            // Not worrying about other data types for now
            // Numbers / bools will convert automatically
            // If it becomes necessary we could encode dates, arr's, objects etc
            // and unencode on the way back
                
            if (field == this.fallback_valueOnlyField) {
                locator.add(fieldVal);
            } else {
                locator.add(field + this.fallback_equalMarker + fieldVal);
            }
        }
        return name + this.fallback_startMarker + locator.join(this.fallback_separator) + 
                    this.fallback_endMarker;
    },

    _compareLocatorFallbackConfigValues : function (a, b) {

        if (isc.isA.Number(a) || isc.isA.Boolean(a)) a = a.toString();
        if (isc.isA.Number(b) || isc.isA.Boolean(b)) b = b.toString();
        if (isc.isA.String(a) && isc.isA.String(b)) return isc.AutoTest.compareHTMLStrings(a,b);
        return a == b;
    },
    
    // This method will take a generated locatorFallbackPath string and return a
    // standard config object as described above - property/field values will be unmapped
    // and any standalone value will be stored under the special
    // isc.AutoTest.fallback_valueOnlyField attribute name.
    parseLocatorFallbackPath : function (path) {
        if (path == null) path = "";
        var pathArr = path.split(this.fallback_startMarker);

        // don't crash if we were passed something we don't understand...
        if (pathArr == null || pathArr.length < 2) return;
        
        var name = pathArr[0];
        path = pathArr[1].substring(0, pathArr[1].length-this.fallback_endMarker.length);
            
        var configArr = path.split(this.fallback_separator),
            configObj = {};
        for (var i = 0; i < configArr.length; i++) {
            var string = configArr[i],
                equalsIndex = string.indexOf(this.fallback_equalMarker),
                fieldName;
                
            if (equalsIndex == -1) {
                fieldName = this.fallback_valueOnlyField;
            } else {
                fieldName = string.substring(0,equalsIndex);
                string = string.substring(equalsIndex+1);
            }
            
            // always unencode
            try {
                string = decodeURIComponent(string);
            } catch (e) {
                
                if (!this._decodeURIFailed) {
                    this._decodeURIFailed = true;
                    this.logWarn("Unable to decode " + string + " with decodeURIComponent();" +
                                 " falling back to deprecated approach - unescape()");
                }
                string = unescape(string);
            }
            string = string.replaceAll(this.slashMarker, "/");
            configObj[fieldName] = string;
        }

        // expand any compact fallback attribute metadata syntax for classIndex, classLength, etc.
        
        this._expandCompactFallbackConfig(configObj);
        
        // BackCompat: Standard locator format (pre March 2010) was always of the format
        // item[1][Class="Canvas"]
        // This is still used where we don't run through the fallback-path subsystem but is
        // being incrementally replaced.
        // If we're passed a string of that format, pull the class out of the string passed in
        // and attach it to the config object.
        // This means that for any old auto-test recordings with the previous identifier format
        // if they end up running through this subsystem we should still have predictable results
        if (pathArr[2] != null) {
            var string = pathArr[2].substring(0, pathArr[2].length-this.fallback_endMarker.length),
                equalsIndex = string.indexOf(this.fallback_equalMarker),
                
                key = string.substring(0,equalsIndex),
                val = string.substring(equalsIndex+1);
            // if the string was quoted, eat the quotes!
            if (val.startsWith("\"")) val = val.substring(1, val.length-1);
            
            configObj[key] = val; 
        }
        
        return {name:name, config:configObj};
    },
    
    
    
    // Generate a standard object "locator fallback path" identifier from an object,
    // similar to:
    //  member[title="foo"||index=1||Class="ImgButton"]
    //
    // Parameters:
    // - name attribute specifies the identifier type (in this example "member")
    // - canvas is the object to get an identifier for
    // - properties is an object specifying some default identifier properties to use which
    //   cannot be directly retrieved from the object. Typically used to specify the
    //   index of the object in the named array.
    // - mask is an object or array specifying properties to include in the locator string.
    //   If an array of strings, for each element store the same-named attribute from the object
    //   on the locator string
    //   If an object, for each entry, pick up the value field from the object and store it
    //   under the key on the locator string
    // * When getting properties from the object, use getters if present
    // * if AutoTest.fallback_valueOnlyField is included this will be included in the 
    //   locator string with no key - for example
    //   member[1]
    //
    
    getObjectLocatorFallbackPath : function (name, object, properties, mask, sourceArray) {
        
        if (properties == null) properties = {};
      
        if (mask == null) mask = {
            title:"title",
            // we do this because widget.getClass() gives us the class object whereas
            // widget.getClassName gives us the name of the smartclient class...
            Class:"ClassName"
        };
        
        if (isc.isAn.Array(mask)) {
            for (var i = 0; i < mask.length; i++) {
                var prop = mask[i],
                    value = object._getRemappedLocatorProp ?
                            object._getRemappedLocatorProp(prop) :
                           (object.getProperty ? object.getProperty(prop) : object[prop]);
                if (value != null && !isc.isAn.emptyString(value)) properties[mask[i]] = value;
            }
        } else {
            for (var field in mask) {
                var prop = mask[field],
                    value = object._getRemappedLocatorProp ?
                            object._getRemappedLocatorProp(prop) :
                           (object.getProperty ? object.getProperty(prop) : object[prop]);
                if (value != null && !isc.isAn.emptyString(value)) properties[field] = value;
            }
        }
        
        // This will turn that config object into a standard locator type string.
        return isc.AutoTest.createLocatorFallbackPath(name, properties, object, sourceArray);
    },
    
    
    // Auto Test locators use various strategies to attempt to locate widgets. In some cases
    // we return a "best guess" type locator string -- for example an index in the members array
    // of a layout -- this is prone to return the wrong element if the page is restructured.
    // When actually retrieving elements from the DOM, we have some hints as to the fact that
    // our locator may be returning the wrong thing -- number of matching elements has changed
    // might be one of them, or the role / class of the widget we think matches is different
    // from what we recorded.
    // In these cases we'll log a warning.
    // This is a generic warning text which we can append to these warnings about how to
    // make identifying more robust in the future
    robustLocatorWarning:"If you are seeing unexpected results in recorded tests, it is likely" +
    " that the application has been modified since the test was recorded. We would recommend re-recording" +
    " your test script with the latest version of your application. Note that you may be able to" +
    " avoid seeing this message in future by using the AutoChild subsystem or providing explicit" +
    " global IDs to components whose function within the page is unlikely to change.",
    logRobustLocatorWarning : function () {
        if (this._loggedWarning) return;
        this.logWarn(this.robustLocatorWarning, "AutoTest");
        this._loggedWarning = true;
    },

    // Don't log the same unreliable locator / component multiple times
    _loggedUnreliableLocators:{},
    logUnreliableLocatorWarning : function (locator, match) {
        var matchString = match ? match.toString() : "null";
            
        if (this._loggedUnreliableLocators[locator] != matchString) {
            this.logWarn("Locator string:" + locator +
            " matching by index gave " + matchString +
            ". Reliability cannot be guaranteed for matching by index if " +
            "the underlying application undergoes any changes.", "AutoTest");
            this._loggedUnreliableLocators[locator] = matchString;
        }
    },

    // This call provides a standard way to create a special DetailViewer instance
    // containing a set of test results (from .test file, Feature Explorer example, etc.)
    createDetailViewerForTestResults : function (canvas, results) {

        var seleniumPresent = isc.Browser.seleniumPresent;

        return isc.DetailViewer.create({
            ID:"isc_AutoTest_DetailViewer",
            left:canvas.getWidth() - 300,
            canDragReposition:true,
            width:280,
            emptyMessage:"No tests are defined.",
            showEmptyField:false,
            blockSeparator:"<BR>",
            autoDraw:true,
            fields: [{name:"result", 
                         valueMap:{ 
                             failure:  "<font style='color:red;'>failure</font>",
                             disabled: "<font style='color:blue;'>disabled</font>"
                         }
                     },
                     {name:"description", escapeHTML:true,
                         formatCellValue : function (value, record) {
                             
                             value = value.replace(/\s+/g, " ");
                             value = value.replace(/\<P\>/gi, "   ");
                             var showID = !seleniumPresent || !record._autoAssignedID;
                             if (record.ID && showID) value = record.ID + ": " + value;
                             if (value.length > 250) value = value.substring(0, 250) + "...";
                             return value;
                         }
                     },
                     {name:"detail", escapeHTML:true}],
            data : results
        });
    },

    setLogFailureForReturnValue : function (canvas, locatorArray, value, attribute) {
        var undef,
            clause = canvas.emptyLocatorArray(locatorArray) ? "directly with" :
                      "with the locator suffix '" + locatorArray.join("/") + "' of";
        canvas.setLogFailureText(true, "there is no " + attribute + " associated " +
                                 clause);
        return value;
    },

    getAttributeDefault : function (canvas, attribute) {
        switch (attribute) {
        case isc.Canvas._$Element: return canvas ? canvas._getHandleAndLogFailure() : null;
        case isc.Canvas._$Object:  return canvas ? canvas                           : null;

        // no return value by default
        case isc.Canvas._$Value:   
        case isc.Canvas._$Selected: return;
        }
    },

    

    _logUnboundModuleMethod : function (instance, methodName) {
        instance.logWarn(methodName + "() isn't yet bound to a valid AutoTest function.  " +
            "Wait for page load or, if you know all needed SmartClient modules have already " +
            "been loaded, call isc.ApplyAutoTestMethods() to attach AutoTest APIs to modules");
    },

    _getCheckedModuleMethods : function (methodNames) {
        var methods = {},
            AutoTest = this
        ;
        methodNames.map(function (methodName) {
            methods[methodName] = function () {AutoTest._logUnboundModuleMethod(this, methodName);};
        });
        return methods;
    },

    //> @classMethod AutoTest.installLocatorShortcut()
    // This method allows developers to retrieve locators for elements on the page via
    // a key-combo plus mouseDown on the element in question.<br>
    // It may be invoked from a bookmarklet stored in the browser, giving developers a
    // one-click way to retrieve locators for any SmartClient application
    // <P>
    // When installLocatorShortcut() is invoked, it will register a Page-level <code>mouseDown</code>
    // handler which, if the Shift+Ctrl or Shift+Meta key-combo are being held down will
    // display the locator for the element under the mouse in a text-box and also copy it to
    // clipboard.
    // <P>
    // As with the +link{group:debugging,isc.showConsole()} method, developers may wish to create a 
    // bookmark in their browser to quickly enable this functionality on any SmartClient 
    // application, without any changes to the application code:
    // <ol>
    // <li>Create a new bookmark in your browser.</li>
    // <li>Enter url "javascript:isc.AutoTest.installLocatorShortcut()".</li>
    // <li>Label the bookmark as "Locator Shortcut"</li>
    // <li>Consider adding this to the Bookmarks Toolbar. This allows you to enable the 
    // feature with a single click from any SmartClient application.</li>
    // </ol>
    // <P>
    // To uninstall the locator shortcut, call +link{AutoTest.uninstallLocatorShortcut()}
    //
    // @visibility external
    //<
    installLocatorShortcut : function () {
        if (this._installedLocatorShortcut) return;
        
        var modifierDescription =  (isc.Browser.isMac ? "Command+Shift-click" : "Ctrl+Shift-click");

        var description = "Installing locator key shortcut:\n" +
                            modifierDescription + " to copy AutoTest locators to clipboard."

        isc.logWarn(description);
        // isc.notify(
        //     description.asHTML(),
        //     null,
        //     "locatorShortcut",
        //     {position:"BL"}
        // );

        this._installedLocatorShortcut = isc.Page.setEvent("mouseDown", "isc.AutoTest.fireLocatorShortcut()");
    },
    //> @classMethod AutoTest.uninstallLocatorShortcut()
    // Uninstalls the locator shortcut installed by +link{AutoTest.installLocatorShortcut()}
    // @visibility external
    //<
    uninstallLocatorShortcut : function () {
        if (!this._installedLocatorShortcut) return;
        isc.Page.clearEvent("mouseDown", this._installedLocatorShortcut);
        delete this._installedLocatorShortcut;
    },

    // To execute a copy-to-clipboard, we need text on the page to select
    // It also makes sense to give some feedback to the user that they've successfully copied a locator

    createLocatorShortcutPrompt:function () {
        this.locatorShortcutPrompt = isc.LocatorEditor.create({
            
            autoDraw:false,
            expanded:false,
            canExpand:this.canExpandLocatorEditor,
            visibility:"hidden" // hide initially so we can draw for sizing
        });
        
        this.locatorShortcutPrompt.draw();
        this.locatorShortcutPrompt.adjustOverflow();
        this.locatorShortcutPrompt.setTop(isc.Page.getHeight()-this.locatorShortcutPrompt.getVisibleHeight());
    },
    
    
    canExpandLocatorEditor:false,
    
    fireLocatorShortcut : function () {

        // Don't track the locator for elements in the LocatorEditor!
        var target = isc.EH.getTarget();
        if (target == null || 
            (this.locatorShortcutPrompt && this.locatorShortcutPrompt.contains(target)) ||
            isc.Log._hiliteCanvas == target) 
        {
            return;
        }

        if (isc.EH.shiftKeyDown() && (isc.EH.ctrlKeyDown() || isc.EH.metaKeyDown())) {
            if (!this.locatorShortcutPrompt) {
                this.createLocatorShortcutPrompt();
            }
            var prompt = this.locatorShortcutPrompt;

            prompt.setLocator(this.getLocator());
            
            prompt.setLocatorStyle("default", true);

            // Show, with dismiss on outside click
            prompt.show();
            prompt.bringToFront();

            
            prompt.delayCall(
                "showClickMask",
                [
                    {target:this.locatorShortcutPrompt,methodName:"clear"},
                    "soft",
                    [prompt]
                ]
            );

            // copy to clipboard without requiring user interaction
            prompt.copyCurrentLocator();
        }
    },


applyCoreMethods : function () {

isc.Canvas.addClassMethods({

    //> @type LocatorAttributeType
    // Attributes that may be retrieved from +link{type:AutoTestLocator,autoTest locators}.
    // 
    // @value "element" DOM Element. May be retrieved from +link{AutoTest.getElement()}.
    // @value "object" SmartClient Object. Returns the +link{Canvas}, 
    //      +link{FormItem} or +link{SectionStackSection} for the locator. May be retrieved
    //      via +link{AutoTest.getObject()}.
    // @value "value" Atomic value for the locator. This only applies to locators that
    //      refer to the UI to display a value in some data component, such as a ListGrid cell.
    //      May be retrieved via +link{AutoTest.getValue()}.
    // @value "record" Record for the locator. This only applies to locators that
    //      refer to the UI to display a record in some data component, such as a ListGrid cell.
    // @value "field" Record for the locator. This only applies to locators that
    //      refer to the UI to display the fields of a record in some data component, such as a ListGrid cell.
    // @visibility smartclient
    //<
    // These attributes are returned from getElement / getObject / getRecord etc
    
    _$Element:  "element",
    _$Object:   "object",
    _$Value:    "value",
    _$Selected: "selected",
    _$Record:   "record",
    _$Field: "field",

    getFallbackPropertyMatch : function (propertyName, config, candidates, 
                                         substring, typeStrategy) 
    {
        var role = config.scRole,
            className = config.Class,
            // scClass will not have been recorded separately if the 
            // recorded class is already a core class.
            scClassName = config.scClass || config.Class,
            propertyValue = config[propertyName];

        if (propertyValue == null) return;
        
        var propertyMatches = candidates.findAll(function (candidate, targetValue) {
            return candidate && candidate._getRemappedLocatorProp(propertyName) == targetValue;
        }, propertyValue, isc.AutoTest.compareHTMLStrings);
        propertyMatches = (propertyMatches || []).filter(this.isValidFallbackLocatorCandidate);

        if (propertyMatches.length == 0) return;

        var propertyMatch;
                
        switch (typeStrategy) {
            
        case "Class": // scClass // role // none
            if (className) {
                var innerMatches = propertyMatches.findAll("Class", className);
                if (innerMatches != null) {
                    propertyMatch = innerMatches[0];
                    if (innerMatches.length == 1 && propertyMatch) {
                        if (this.logIsDebugEnabled("AutoTest")) {
                            this.logDebug("Locator string:" + substring + 
                                          " - returning widget with matching " +
                                          propertyName + " and ClassName:" +
                                          propertyMatch, "AutoTest");
                        }
                        return propertyMatch;
                    }
                }
            }
        case "scClass":
            if (scClassName) {
                var innerMatches = propertyMatches.findAll(isc.Class.compareScClassName,
                                                           scClassName);
                if (innerMatches != null) {
                    if (innerMatches.length == 1 || propertyMatch == null)
                        propertyMatch = innerMatches[0];
                    
                    if (innerMatches.length == 1 && propertyMatch) {
                        
                        if (this.logIsDebugEnabled("AutoTest")) {
                            this.logDebug("Locator string:" + substring +
                                          " - returning widget with matching " +
                                          propertyName + " and scClassName:" +
                                          propertyMatch, "AutoTest");
                        }
                        return propertyMatch;
                    }
                }
            }
        case "role":
            if (role) {
                var innerMatches = propertyMatches.findAll("ariaRole", role);
                if (innerMatches != null) {
                    if (innerMatches.length == 1 || propertyMatch == null)
                        propertyMatch = innerMatches[0];
                    
                    if (innerMatches.length == 1 && propertyMatch) {
                        
                        if (this.logIsDebugEnabled("AutoTest")) {
                            this.logDebug("Locator string:" + substring + 
                                          " - returning widget with matching " +
                                          propertyName + "  and role:" +
                                          propertyMatch, "AutoTest");
                        }
                        return propertyMatch;
                    }
                }
            }
            
        default:
            // In this case we've got a matching property value but we can't match
            // it to class or role.  Log the "unreliable locator" one time warning
            // -- the fact that we couldn't find a match by class as well as
            // property value implies things must have changed since the recording
            // was made...
            //
            // Return the match if it's unique, otherwise ignore it and move on to 
            // matching by index.
            
            if (propertyMatches.length == 1) {
                
                if (typeStrategy != "none") {
                    isc.AutoTest.logRobustLocatorWarning();
                    
                    this.logWarn ("Locator string:" + substring + ". Returning " +
                                  "closest match:" + propertyMatches[0] + ". This has " +
                                  "the same " + propertyName + " as the recorded " +
                                  "component but does not match class or role.", "AutoTest");
                } else {
                    if (this.logIsDebugEnabled("AutoTest")) {
                        this.logDebug("Locator string:" + substring + 
                                      " - returning widget with matching " + propertyName +
                                      ":" + propertyMatch, "AutoTest");
                    }
                }
                return propertyMatches[0];
            } else {
                this.logWarn("Locator string:" + substring + ", attempt to match " +
                             "by " + propertyName + " failed -- multiple candidate " + 
                             "components have this same " + propertyName + ". Attempting " +
                             "to match by index instead.", "AutoTest");
            }
        } // end of switch
    },

    // substring param really just used for logging
    getCanvasFromFallbackLocator : function Canvas_getCanvasFromFallbackLocator 
        (substring, config, candidates, strategy, typeStrategy, mode)
    {
        var locatorMatching = mode && mode.locatorMatching;

        // Given an array of possible candidates attempt to match as follows:
        
        // - if a 'name' was recorded,
        //  - match by name and class name
        //  - otherwise by name and scClassName
        //  - otherwise by name and scRole
        // - if a title was recorded
        //  - match by title  and class name
        //  - title / scClassName
        //  - title / role
        //
        // Otherwise back off to matching by index:
        //  - try to match by class name / index (of candidates with that className)
        //  - then by scClassName / index
        //  - then by role / index
        //  - then by raw index
        
        // Robustness:
        // We have a big one-time warning to log when we think what we're returning is
        // likely unreliable (see AutoTest.logRobustLocatorWarning())
        // We do this:
        //  - if we find a match by name but it doesn't match class, scclass or role
        //  - if we find a match by title but it doesn't match class scclass or role
        //      (If there is more than one match by title we ignore this strategy and back
        //       off to index with a different warning)
        //  - if, when attempting to find a match by index (by class scClass or role, or by
        //    raw index), we find the array length has changed (meaning the array has
        //    changed, so the index is probably worthless).
        //
        // We also log a less "things are broken" warning everytime we return
        // by raw index as this is very fragile.
        var name = config.name;
        
        // Some common things we're always going to try:
        var className = config.Class,
            // scClass will not have been recorded separately if the recorded class
            // is already a core class.
            scClassName = config.scClass || config.Class,
            role = config.scRole;
     
        var match;

        switch (strategy) {
            
        case "name":
            match = this.getFallbackPropertyMatch("name", config, candidates,
                                                  substring, typeStrategy);
            if (match) return match;

        case "title":
            match = this.getFallbackPropertyMatch("title", config, candidates,
                                                  substring, typeStrategy);
            if (match) return match;
            
        // either strategy is "index" or we didn't find a title/name match
        default:

            // normally back off to index but try "locatorName" first.
            // it is a user-supplied ID that is unique within the parent.
            match = this.getFallbackPropertyMatch("locatorName", config, candidates,
                                                  substring, typeStrategy);
            if (match) return match;

            // back off to index
            // We captured index per class name, per scClass and per role as well as the
            // raw index in the array.
            // Test them in that order.
            // Note that if the lengths have changed this is likely wrong!
             var classIndexMatch,
                scClassIndexMatch,
                roleIndexMatch;
                
             switch (typeStrategy) {
             case "Class": // scClass // role // none
              
    
                if (className && config.classIndex) {
                    var classMatches = candidates.findAll("Class", className);
                    if (classMatches && classMatches.length > 0) {
                        
                        classIndexMatch = classMatches[parseInt(config.classIndex)];
                        
                        if (classMatches.length == parseInt(config.classLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + 
                                        " - returning widget with matching ClassName / index by ClassName:" +
                                        classIndexMatch, "AutoTest");
                            }
                            return classIndexMatch;
                        }
                        // If the lengths didn't match, the index is very likely unreliable
                        // Hang onto it to return it if we can't match by scClassName or role more
                        // reliably
                    }
                }
                
            case "scClass":
                
                if (scClassName && config.scClassIndex) {
                    
                    var scClassMatches = candidates.findAll(isc.Class.compareScClassName,
                                                            scClassName);
                    if (scClassMatches && scClassMatches.length > 0) {
                        
                        scClassIndexMatch = scClassMatches[parseInt(config.scClassIndex)];
                        
                        if (scClassMatches.length == parseInt(config.scClassLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + " - returning " +
                                    "widget with matching SmartClient superclass / index by " +
                                    "ClassName:" + scClassIndexMatch, "AutoTest");
                            }
                            return scClassIndexMatch;
                        }
                        // If the lengths didn't match, the index is very likely unreliable
                        // Try roles before using this
                    }
                }
                
            case "role":
                
                if (role && config.roleIndex) {
                    
                    var roleMatches = candidates.findAll("ariaRole", role);
                    if (roleMatches && roleMatches.length > 0) {
                        
                        roleIndexMatch = roleMatches[parseInt(config.roleIndex)];
                        
                        if (roleMatches.length == parseInt(config.roleLength)) {
                        
                            if (this.logIsInfoEnabled("AutoTest")) {
                                this.logInfo("Locator string:" + substring + 
                                        " - returning widget with matching role / index by role:" +
                                        roleIndexMatch, "AutoTest");
                            }
                            return roleIndexMatch;
                        }
                    }
                }
                
            default:

                var logUnreliableMatch = (mode == null || !mode.suppressWarnings) &&
                                         !isc.AutoTest.useMinimalFallbackAttributes;
                
                // At this point if we had class/scClass or role, we know the lengths have changed
                // so index is very unreliable.
                // In this case, or if the overall length has changed, log the robustLocatorWarning
                //
                // Then return our best guess
                if ((typeStrategy != "none" && (className || scClassName || role)) || 
                    (config.length != null && (parseInt(config.length) != candidates.length))) 
                {
                    
                    if (locatorMatching == "restrictConfig") break;

                    if (logUnreliableMatch) isc.AutoTest.logRobustLocatorWarning();
                }
                
                var match = classIndexMatch || scClassIndexMatch || roleIndexMatch;
                if (match == null) {
                    var index = config[isc.AutoTest.fallback_valueOnlyField];
                    if (index == null) index = config.index;
                    index = parseInt(index);
                    
                    match = candidates[index];
                }
                
                if (match) {
                    if (logUnreliableMatch) {
                        isc.AutoTest.logUnreliableLocatorWarning(substring, match);
                    }
                    return match;
                }

            } // closes inner switch statement
        } // closes outer switch statement
        
        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // This doesn't necessarily indicate any kind of failure: We use fallback locators
        // for elements within some components - EG list grid cells
        this.logDebug("AutoTest.getElement(): locator substring:" + substring + 
            " parsed to fallback locator name:" + name + 
            ", unable to find relevant child - may refer to inner element.", "AutoTest");
    },

    // Reject "bad" candidates such as those that are
    // - marked as destroyed
    // - not visible
    // - not drawn
    isValidFallbackLocatorCandidate : function Canvas_isValidFallbackLocatorCandidate (
        candidate)
    {
       return candidate && !candidate.destroyed && candidate.isVisible() && candidate.isDrawn();
    }
});

// methods applied to Class are generally needed for both Canvas and FormItem
isc.Class.addClassMethods({

    // use fallback strategies to get at the right object from a stored path.
    getCanvasLocatorFallbackPath : function Class_getCanvasLocatorFallbackPath (name, 
                                               canvas, sourceArray, properties, mask)
    {
       if (properties == null) properties = {};
        
        if (mask == null) mask = {};
        else if (isc.isAn.Array(mask)) {
            var maskObj = {};
            for (var i = 0; i <mask.length; i++) {
                maskObj[mask[i]] = mask[i];
            }
            mask = maskObj;
        }
        
        // Always pick up the following attributes directly from the widget, if present
        if (mask.title == null) mask.title = "title";
        if (mask.scRole == null) mask.scRole = "ariaRole";
        if (mask.name == null) mask.name = "name";
        if (mask.locatorName == null) mask.locatorName = "locatorName";
        
        // ClassName / scClassName - this is more complex than just looking at attributes on
        // the widget:
        // We need to pick up the class name, and if that's not a core smartclient class, also
        // pick up the core superclass of that class so we can look at both
        var objectClass     = canvas.getClass(),
            objectClassName = canvas.getClassName();
        
        properties.Class = objectClassName;
        
        var scClassName;
        if (!objectClass.isFrameworkClass) {
            scClassName = objectClass._scClass;
        }
        if (scClassName != null) properties.scClass = scClassName;
        
        // We also want to pick up index-based locators from the source array
        // Record both the index and the current length
        // Locating by index is always imperfect: If a developer changes the orders of
        // members (for example), it'll break.
        // However if the length is different when a recorded locator is parsed, we have
        // a really good indication that the index based locator is probably unreliable.
        if (sourceArray != null && sourceArray.indexOf(canvas) >= 0) {
            
            // Raw position in the array
            properties.index = sourceArray.indexOf(canvas);
            properties.length = sourceArray.length;

            if (isc.AutoTest._locatorDetails && !canvas.locatorName) {
                if (!isc.AutoTest._locatorDetails.firstParentOfIndex && canvas.parentElement) {
                    isc.AutoTest._locatorDetails.firstParentOfIndex = canvas.parentElement.ID;
                }
                isc.AutoTest._locatorDetails.containsIndices = true;
            }
            // position within widgets of this class in the array
            // Use case: the developer adds something like a 'status label' at the top
            // of an array of buttons
            var matchingClass = sourceArray.findAll("Class", objectClassName);
            properties.classIndex = matchingClass.indexOf(canvas);
            properties.classLength = matchingClass.length;

            // position within widgets of this SmartClient class in the array
            // Use case: The developer subclasses a SmartClient component as the app matures
            // but the application layout stays the same, so an array of buttons becomes
            // an array of custom button subclasses
            if (scClassName != null) {
                var matchingSCClass = sourceArray.findAll(isc.Class.compareScClassName, 
                                                          scClassName);
                properties.scClassIndex = matchingSCClass.indexOf(canvas);
                properties.scClassLength = matchingSCClass.length;
            }
            
            // Position within widgets with this role in the warray
            // Use case: The smart client class changes due to (say) reskinning (moving from
            // a button to a stretchImgButton), but the role is unchanged
            if (canvas.ariaRole != null) {
                var matchingRoles = sourceArray.findAll("ariaRole", canvas.ariaRole);
                properties.roleIndex = matchingRoles.indexOf(canvas);
                properties.roleLength = matchingRoles.length;
            }
        }
        return isc.AutoTest.getObjectLocatorFallbackPath(name, canvas, properties, mask, sourceArray);
    }
    
});

isc.Class.addMethods({

    // given a childType -- for example "peers"
    // figure out the specified child locator strategy.
    // Works by looking for this.locate[pluralName]By -- EG
    // locatePeersBy
    getChildLocatorStrategy : function class_getChildLocatorStrategy (childType) {
        if (isc.AutoTest.locStrategyNames == null) {
            isc.AutoTest.locStrategyNames = {};
        }
        
        var attrName = isc.AutoTest.locStrategyNames[childType];
        if (attrName == null) {
            var pluralName = childType;
            if (isc.isA.String(this._locatorChildren[childType])) {
                pluralName = this._locatorChildren[childType];
            }
            attrName = isc.AutoTest.locStrategyNames[childType] =
                        "locate" + 
                        pluralName.substring(0,1).toUpperCase() + pluralName.substring(1) +
                        "By";
        }
        
        return this[attrName];
    },

    // Same type of logic for type-identifiers
    // checks for this.locate[pluralName]Type -- EG: locatePeersType
    getChildLocatorTypeStrategy : function class_getChildLocatorTypeStrategy (childType) {
           
        if (isc.AutoTest.locStrategyTypes == null) {
            isc.AutoTest.locStrategyTypes = {};
        }
        
        var attrName = isc.AutoTest.locStrategyTypes[childType];
        if (attrName == null) {
            var pluralName = childType;
            if (isc.isA.String(this._locatorChildren[childType])) {
                pluralName = this._locatorChildren[childType];
            }
            attrName = isc.AutoTest.locStrategyTypes[childType] =
                        "locate" + 
                        pluralName.substring(0,1).toUpperCase() + pluralName.substring(1) +
                        "Type";
        }
        
        return this[attrName];
    },
    
    
    getAutoChildLocator : function class_getAutoChildLocator (instance) {
        
        if (this._createdAutoChildren) {
            var ID = instance.getID();
            for (var childName in this._createdAutoChildren) {
                var children = this._createdAutoChildren[childName];
                if (children.contains(ID)) {
                    // common case this.header etc
                    if (instance == this[childName]) return childName;
                    else {
                        // create an array of the *live* auto children (not just their IDs)
                        // this allows us to figure out our index in that array as well as
                        // our index based on role!
                        var liveChildren = [];
                        for (var i = 0; i < children.length; i++) {
                            liveChildren[i] = window[children[i]];
                        }
                        return this.getCanvasLocatorFallbackPath(childName, instance, 
                                                                 liveChildren);
                    }
                }
            }
        }
        return null;
    },

    getCanvasFromFallbackLocator : function class_getCanvasFromFallbackLocator
        (substring, config, candidates, strategy, typeStrategy, mode)
    {
        return isc.Canvas.getCanvasFromFallbackLocator(substring, config, candidates,
                                          strategy, typeStrategy, mode);
    },

    // substring param really just used for logging
    getChildFromFallbackLocator : function class_getChildFromFallbackLocator (substring,
                                                                  fallbackLocatorConfig,
                                                                          configuration)
    {
        var type = fallbackLocatorConfig.name,
            config = fallbackLocatorConfig.config;

        
        if (this == isc.AutoTest.testRoot && this.getScClassName() == "Canvas") {
             if (type == "member") type = "child";
        }

        // default logic:
        // we use the "name" to find candidate widgets, then use the config to
        // figure out which candidate we actually want
        var candidates = this.getFallbackLocatorCandidates(type);
        if (candidates && candidates.length > 0) {
            var strategy = this.getChildLocatorStrategy(type);
            if (strategy == null) strategy = "name";
            var typeStrategy = this.getChildLocatorTypeStrategy(type);
            if (typeStrategy == null) typeStrategy = "Class";

            var match = this.getCanvasFromFallbackLocator(substring, config, candidates,
                                                 strategy, typeStrategy, configuration);
            if (match != null) return match;
        }
        
        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // This doesn't necessarily indicate any kind of failure: We use fallback locators
        // for elements within some components - EG list grid cells
        this.logDebug("AutoTest.getElement(): locator substring:" + substring + 
            " parsed to fallback locator name:" + type + 
            ", unable to find relevant child - may refer to inner element.", "AutoTest");
    },

    getFallbackLocatorCandidates : function class_getFallbackLocatorCandidates (name) {
    
        var candidates;
        
        // check _createdAutoChildren for autoChildren by autoChildName
        var autoChildName = this._getNewAutoChildName(name);
        if (this._createdAutoChildren != null &&
            this._createdAutoChildren[autoChildName] != null)
        {
            var IDs = this._createdAutoChildren[autoChildName];
            candidates = [];
            for (var i = 0; i < IDs.length; i++) {
                candidates[i] = window[IDs[i]];
            }
            
        // _locatorChildren object: This specifies a mapping between known cases where
        // we have an attribute on this widget containing an array of candidates
        // (EG the children array) and a known 'locator' childType name (EG "child")
        
        } else if (isc.isA.String(this._locatorChildren[name])) {
            candidates = this[this._locatorChildren[name]];
        
        // Also support the 'name' pointing directly to an attribute on this widget 
        // containing an array of candidate objects (So could store "children" directly
        // rather than using the remapping above).
        } else if (this[name] && isc.isAn.Array(this[name])) {
            candidates = this[name];
        }
        return candidates;
    },

    // getCanvasLocatorFallbackPath
    // generates a standard 'fallback path' to locate a widget from within a pool of widgets.
    // Used for locating multiple auto children with the same name, members, peers, children
    // and so on.
    // The concept is that this'll capture as much information as possible so we can
    // use fallback strategies to get at the right object from a stored path.
    getCanvasLocatorFallbackPath : function class_getCanvasLocatorFallbackpath
                         (name, canvas, sourceArray, properties, mask) {
        return isc.Canvas.getCanvasLocatorFallbackPath(name, canvas, sourceArray,
                                                       properties, mask);
    },

    // pick up customized property declared in remappedLocatorProps
    
    _getRemappedLocatorProp : function (property) {
        var remappedProps = this.remappedLocatorProps;
        if (remappedProps) {
            var remappedProp = remappedProps[property];
            if (remappedProp) return this.getProperty(remappedProp);
        }
        return this[property];
    },

    
    _getNewAutoChildName : function (oldName) {
        var depMap = this._deprecatedAutoChildren;
        return depMap && depMap[oldName] || oldName;
    },

    setLogFailureText : function class_setLogFailureText (locator, start, finish) {
        var callerFunc = isc.Class.getPrototype().setLogFailureText.caller || arguments.callee.caller,
            callerName = callerFunc.name || isc.Func.getName(callerFunc, true),
            logSlot = callerName.replace(/^.*[_]+([^_]+)/, "\x5F$1" ) + "Log";
        if (isc.AutoTest[logSlot]) return; // initial reporter has primacy
        isc.AutoTest[logSlot] = this._getLogFailureText(locator, start, finish);
    },

    _getDescription : function class__getDescription (locator) {
        var original = false,
            stable = this.hasStableID(),
            description = this.getScClassName();
            
        // locator true means to add on the original locator
        if (locator == true) {
            locator = false;
            original = true;
        }
        // if the ID is not stable, define the current locator
        if (stable) description += " with ID " + this.ID;
        else if (!isc.isA.String(locator)) locator = this.getLocator();

        // now if either just defined or passed it, set current locator
        if (locator) description += " identified by " + locator;

        // the original locator is now added at the end if required
        if (original) description += isc.AutoTest._createLocatorMarker(locator);

        return description;
    },

    _getLogFailureText : function class__getLogFailureText (locator, start, finish) {
        var description = "the " + this._getDescription(locator);

        if (finish && !finish.match(/^[.,;:\\s]/)) finish = " " + finish;

        if (start)  description  = start + " " + description;
        if (finish) description += finish;

        return description;
    },

    _locatorRootTemplate: [
    "//",
    ,   // classname
    '[ID="',
    ,   // global ID
    '"]'
    ],

    emptyLocatorArray : function class_emptyLocatorArray (locatorArray) {
        return locatorArray == null || locatorArray.length == 0 ||
                (locatorArray.length == 1 && locatorArray[0] == "");
    },

    // Should this widget's ID be used during scLocator generation?
    
    hasStableID : function class_hasStableID () {
        if (this._autoAssignedID) return false;

        
        var idPrefixParent = this.creator;
        if (!idPrefixParent && this._generated) {
            idPrefixParent = this.locatorParent || this.parentElement;
        }
        if (idPrefixParent != null && this.ID.startsWith(idPrefixParent.ID)) {
            return idPrefixParent.hasStableID();
        }

        return true;
    },
    hasStableLocalID : function class_hasStableLocalID () {
        if (this._localId) return true;
        return this.hasStableID();
    },


    //////////////////////////////////////////////////////////////////////////////////////////
    // Minimal locator support
    

    _$widgetID: "ID",
    _$defProp: "definingProperty",

    __isQualifyingContainer : function class___isQualifyingContainer (mode) {

        switch (mode) {
        case this._$widgetID:
            if (isc.isA.Canvas(this) && this.hasStableID()) {
                return true;
            }
            break;
        case this._$defProp:
            if (this.hasDefiningProperty()) return true;
            break;
        }
    },

    hasDefiningProperty : function class_hasDefiningProperty () {
        var definingProp = this.getDefiningPropertyName();
        if (definingProp) return !!this.getProperty(definingProp);
    },

    getDefiningPropertyValue : function class_getDefiningPropertyValue (propertyName) {
        if (!propertyName) propertyName = this.getDefiningPropertyName();
        if (!propertyName) return;

        switch (propertyName) {
        case "localId":
            return this.getStableScreenLocalId && this.getStableScreenLocalId();
        }

        var value = this.getProperty(propertyName);
        if (isc.isAn.Instance(value)) value = value.getID();
        if (isc.isA.String(value)) value = String.htmlStringToString(value);
        return value;
    }
    
});
    
isc.Canvas.addMethods({
    
    //> @method canvas.getLocator()
    // Returns an +link{type:AutoTestLocator} associated with some DOM element contained within
    // this Canvas.
    // @param DOMElement (DOMElement) DOM element within this Canvas
    // @return (AutoTestLocator) Locator string allowing the AutoTest subsystem to find
    // an equivalent DOM element on subsequent page loads.
    // @visibility internal
    //<
    // No apparent need to expose this directly, unless we are ready to support developers
    // writing their own locator logic in addition to the defaults
    ///
    // Additional 'fromEvent' param tells us we're actually retriving the target for the
    // current mouse event
    // In some cases we can use this to get additional info that isn't available from the
    // actual target element (EG target cell in a GR when showing a floating embedded componet)
    getLocator : function canvas_getLocator (element, fromEvent, coords, overrides) {

        var interiorLocator = element == null ? null : this.getInteriorLocator(element, fromEvent, coords);
        if (interiorLocator == "") interiorLocator = null;

        // Allow configuration of global settings
        if (overrides != null) {
            isc.AutoTest.pushConfiguration(isc.addProperties({}, overrides));
        }

        var locator;

                        
        if (isc.AutoTest.useIDsAsLocators && interiorLocator == null && this.hasStableID()) {

            locator = this.getID();

        } else {
            
            var baseLocator = this.getLocatorInternal();
            
            // Reset any overrides
            if (overrides != null) isc.AutoTest.popConfiguration();

            if (!interiorLocator) locator = baseLocator;
            locator = [baseLocator, interiorLocator].join("/");
        }
        return locator;
    },

    // internal logic to return normal or testRoot-based locator
    getLocatorInternal : function canvas_getLocatorInternal (ignoreTestRoot, 
                                                             skipAbsoluteLocator) 
    {
        // useSearchSegments may be set globally as part of getLocator() via the overrides param
        var useSearchSegments = isc.AutoTest.useSearchSegments;
        
        if (ignoreTestRoot) useSearchSegments = false;

        // get a root component - may be this, may be test root.
        var rootComponent = ignoreTestRoot ? null :  isc.AutoTest.testRoot;
        if (rootComponent == null) {
            if (this.locateByIDOnly ||
                (!this._generated && this.locatorParent == null && this.creator == null && 
                    this.hasStableID())
               ) 
            {
                rootComponent = this;
            }
        }

        var locatorParent = this.getLocatorParent();
        var useSearchSegment = false;
        var isHiddenSearchSegment = false;
        var searchParent;
            
        if (rootComponent != this) {        

            // Determine whether we can use a search segment to identify this canvas
            var proxyContext = {};
            if (!ignoreTestRoot && useSearchSegments && this._isQualifyingContainer(this._$defProp, proxyContext)) {

                
                
                var scClass = this.getScClassName();
                var locTarget = this;

                
                var proxyMarker = null;
                if (proxyContext.proxies && proxyContext.proxies[this.getID()]) {
                    proxyMarker = this._getProxyPropertyMarker(); 
                    if (proxyMarker != null) {
                        proxyMarker = proxyMarker.trimCharacters(":");
                        locTarget = proxyContext.proxies[this.getID()];
                    }
                }
                var propName = locTarget.getDefiningPropertyName();
                var propValue = locTarget.getDefiningPropertyValue();

                // Determine whether the root, or failing that, one of our ancestors contains a unique match
                // by defining property value. If so we can leapfrog over a chunk of the inheritance chain.
                
                var searchRoot = rootComponent && rootComponent.contains(this) ? rootComponent : null;   

                var includeHidden = isc.AutoTest.searchSegmentsIncludeHidden || !(this.isVisible() && this.isDrawn());
                var allCandidates = isc.AutoTest._getSearchMatches(
                                        searchRoot, scClass, 
                                        propName, propValue, proxyMarker, 
                                        includeHidden);
                if (allCandidates != null && allCandidates.contains(this)) {
                    if (allCandidates.length == 1) {
                        useSearchSegment = true;
                        isHiddenSearchSegment = includeHidden;
                        searchParent = searchRoot;
                    } else {

                        // parentChain == array of all widgets from this to the root component [not inluding root]
                        
                        var parentChain = [];
                        var ancestor = this.getParentCanvas();
                        while (ancestor != null) {

                            // don't add root component to this chain
                            if (searchRoot && (ancestor == searchRoot)) break;
                            parentChain.add(ancestor);
                            ancestor = ancestor.getParentCanvas();
                        }

                        for (var parentIdx = parentChain.length-1; parentIdx > 0; parentIdx--) {
                            
                            var searchInside = parentChain[parentIdx];
                            // Never search inside our locatorParent - we already have an explicit
                            // route from that component to us
                            if (searchInside == locatorParent) break;

                            var foundDuplicate = false;

                            for (var i = 0; i < allCandidates.length; i++) {
                                if (allCandidates[i] == this) continue;
                                if (searchInside.contains(allCandidates[i])) {
                                    foundDuplicate = true;
                                    break
                                }
                            }
                            if (!foundDuplicate) {
                                useSearchSegment = true;
                                isHiddenSearchSegment = includeHidden;
                                searchParent = searchInside;
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (useSearchSegment) {
            var searchLocator = this._getMinimalLocatorSegment(
                this._$defProp, 
                // A "?" at the end of a search segment prefix indicates
                // the logit to resolve the locator should search for hidden
                // elements.
                (searchParent ? "//" : "//:") + (isHiddenSearchSegment ? "?" : ""), 
                
                proxyContext
            );
            if (searchParent != null) {                
                return searchParent.getLocatorInternal(ignoreTestRoot) + searchLocator;
            } else {
                return searchLocator;
            }
        }


        // This canvas will be identified by a standard child locator, not a search locator.
        var parent, absoluteLocator;

        
        var testRoot = ignoreTestRoot ? null : isc.AutoTest.testRoot;
        if (!this.locateByIDOnly && testRoot != this) {
            
            if (this._generated || this.locatorParent || this.creator || !this.hasStableID()) {
                parent = this.getLocatorParent();
            }

            
            if (testRoot != null && parent == null) {
                if (!skipAbsoluteLocator) {
                    skipAbsoluteLocator = true;                    
                    absoluteLocator = this.getLocatorInternal(true);
                }
                parent = this.getLocatorParent();
            }
        }
        var baseLocator;
        if (parent == null) {
            baseLocator = this.getLocatorRoot();
        } else {
            baseLocator = parent.getLocatorInternal(false, skipAbsoluteLocator);
            var childLocator = parent.getChildLocator(this);
            if (childLocator != null) baseLocator += "/" + childLocator;
        }

        return absoluteLocator != null && !baseLocator.startsWith(isc.AutoTest._$testRoot) ?
            absoluteLocator : baseLocator;
    },

    // return locator chain to this canvas rooted at the supplied qualified container widget
    getLocatorToContainer : function canvas_getLocatorToContainer (container, mode, context,
                                                                   locatorRoot)
    {

        var parent;

        
        if (container != this) {
            // determine whether to keep going up the parent hierarchy to find a
            if (this._generated || this.locatorParent || this.creator || !this.hasStableID()) {
                parent = this.getLocatorParent();
            }
        }

        var baseLocator;
        if (parent == null) {
            baseLocator = container ? (locatorRoot || container._getMinimalLocatorSegment(mode,
                context.isRoot ? "//:" : "//", context)) : this._getLocatorRoot("//:", "");

        } else {
            baseLocator = parent.getLocatorToContainer(container, mode, context, locatorRoot);
            var childLocator = parent.getChildLocator(this);
            if (childLocator != null) baseLocator += "/" + childLocator;
        }

        return baseLocator;
    },

    _getItemLocatorInternal : function (item, a, b, c, d) {
        if (item.destroyed || item.destroying) return null;
        return this.getLocatorInternal(a, b, c, d) + "/" + this.getItemLocator(item);
    },
    _getItemLocatorToContainer : function (item, a, b, c, d) {
        if (item.destroyed || item.destroying) return null;
        return this.getLocatorToContainer(a, b, c, d) + "/" + this.getItemLocator(item);
    },

    // We support generating locators for logical SmartClient objects that aren't necessarily
    // canvii such as FormItems and SectionStackSections
    
    // This method is called to get the locator for some logical object nested within this canvas.
    // Return null to indicate no locator (or object not understood, etc).
    // Subclasses such as DynamicForm will override with concrete implementations.
    getObjectLocator : function canvas_getObjectLocator (target) {
     },

    // Returns the locator segment string for this canvas to use as the root of 
    // a locator
    getLocatorRoot : function canvas_getLocatorRoot () {
        
        if (!this.locatorRoot) {
            // If this widget is the test root, return a special locator based on that.
            // If the widget has an explicitly specified ID always use it above all else!
            // Otherwise we'll use the "fallbackLocator" pattern to find it
            if (this == isc.AutoTest.testRoot) {
                this.locatorRoot = isc.AutoTest._$testRoot;
            } else {
                this.locatorRoot = this._getLocatorRoot();
            }
        }
        return this.locatorRoot;
    },

    //> @attr canvas.locateByIDOnly (boolean : false : IRWA)
    // If <code>true</code>, when retrieving a +link{AutoTest.getLocator(),locator} for
    // this component always return a reference directly to this component by
    // +link{canvas.ID,widget ID}, using the compact format <code>"///<i>canvasID</i>"</code>, 
    // ignoring any parent elements and ignoring any configured +link{AutoTest.testRoot,testRoot}.
    // This format of locator will always be resolved back to the component by ID 
    // regardless of any changes in its position in the UI structure of an application.
    // <P>
    // This setting is appropriate for components which are expected to always be present in an application
    // with a stable +link{canvas.ID}. 
    // 
    // @visibility external
    //<
    locateByIDOnly:false,


    // This method returns the locator segment string for the canvas when it's the root of
    // a locator
    _getLocatorRoot : function canvas__getLocatorRoot (fallbackStartMarker, fallbackName) {
        
        // locateByID: Simple boolean - if set, when creating autoTest locators, 
        // use the ID of this canvas [alone] to identify it
        // This is equivalent to "//*any*[ID=canvasID]"
        // Typically we'd also expect the component in question to have an 
        // explicitly specified ID but this is not required or enforced
        if (this.locateByIDOnly) return "///" + this.getID();

        // no stable ID; build the root locator from fallback attributes
        if (!this.hasStableID() && this.parentElement == null) {
            if (isc.AutoTest._locatorDetails) {
                if (isc.AutoTest._locatorDetails.globalID == null) {
                    isc.AutoTest._locatorDetails.globalID = this.ID;
                }
                isc.AutoTest._locatorDetails.containsGlobalId = true;
            }
            if (fallbackName == null) fallbackName = "autoID";
            if (!fallbackStartMarker) fallbackStartMarker = "//";
            return fallbackStartMarker + isc.Canvas.getCanvasLocatorFallbackPath(
                fallbackName, this, isc.Canvas._topCanvii);

        // otherwise, just build a simple locator based on the canvas ID
        } else {
            this._locatorRootTemplate[1] = this.getClassName();
            this._locatorRootTemplate[3] = this.getID();
            return this._locatorRootTemplate.join(isc.emptyString);
        }
    },

    getNamedLocatorChild : function canvas_getNamedLocatorChild (childName) {

        // - standard attribute<-->name mappings in the namedLocatorChildren array:
        if (this.namedLocatorChildren != null) {
            var rename = this.namedLocatorChildren.find("name", childName);
            if (rename != null) {
                var attribute = isc.isA.String(rename) ? rename : rename.attribute;
                var canvas = this[attribute];
                if (isc.isA.Canvas(canvas)) return canvas;
                this.logWarn("Locator childName:" + childName
                    + " maps to attribute:" + attribute + 
                    " but no canvas exists under that attribute name.", "AutoTest");

                // Return false rather than null to indicate that this was a valid 'named locator' name
                // but we couldn't find the component
                return false;
            }
        }
    },

    _getLocatorChildNameForCanvas : function canvas__getLocatorChildNameForCanvas (canvas) {
        if (this.namedLocatorChildren != null) {
            for (var i = 0; i < this.namedLocatorChildren.length; i++) {
                var entry = this.namedLocatorChildren[i];
                var attr = entry;
                if (isc.isAn.Object(entry)) {
                    attr = entry.attribute;
                }
                if (canvas == this[attr]) {
                    return entry;
                }
            }
        }
    },
    
    containsLocatorChild : function canvas_containsLocatorChild (canvas) {

        if (this._getLocatorChildNameForCanvas(canvas) != null) {
            return true;
        }

        if (this.editProxy && this.editProxy.inlineEditForm) {
            if (canvas == this.editProxy.inlineEditForm) return true;
        }

        return false;
    },

    //> @method canvas.setLocatorParent()
    // This method will set mark the target canvas as the "locator parent"
    // for this canvas, using the specified child name. After calling this method,
    // +link{AutoTest.getLocator(),locators} that reference this canvas will use the
    // <code>childName</code> to navigate from the specified parent to this component,
    // exactly how named +link{autoChild,autoChildren} are referenced in locators.
    // <P>
    // Note that, as with SmartClient autoChildren, the locator parent does 
    // not need to be the direct parent of this component, or even a true ancestor, 
    // in the widget hierarchy. However, you should never set the locatorParent
    // to a descendant of this widget as that would lead to infinite loops when
    // attempting to create or resolve locators.
    // <P>
    // This method will also set <code>locatorParent.attributeName</code>, (or 
    // <code>locatorParent.childName</code> if no explicit attributeName was specified)
    // to refer to this canvas, if this is not already the case.
    // <P>
    // If the attribute is already set to refer to some other object, this method
    // will return false without taking any
    // further action.
    //
    // @param locatorParent (Canvas) New locator parent for this canvas
    // @param childName (String) Name to refer from the locator parent to this
    //   canvas in the locator
    // @param [attributeName] (String) Optional attribute to refer from the parent to this canvas. 
    //   If unset the childName will be used instead.
    // @return (boolean) returns true if the locatorParent was successfully updated
    // @visibility external
    //<
    // This method is invoked by various framework classes to register specialized 
    // auto-generated children that don't get picked up via standard named autoChild
    // locator paths.
    // Note: This uses the namedLocatorChildren array to maintain the mapping between locatorParents and the
    // appropriate childAttribute.
    // We don't want to apply a default namedLocatorChildren array to a class' instancePrototype as it
    // would be shared across all instances. Instead each canvas should have its own namedLocatorChildren
    // array that gets set dynamically after creation - typically by going through this method.
    setLocatorParent : function canvas_setLocatorParent ( locatorParent, childName, attributeName) {

        if (isc.isA.String(locatorParent)) locatorParent = isc.Canvas.getById(locatorParent);

        if (this.locatorParent != null) {
            var entry = this.locatorParent._getLocatorChildNameForCanvas(this);
            if (this.locatorParent == locatorParent) {
                var existingName, existingAttr;
                if (isc.isA.Object(entry)) {
                    existingName = entry.name;
                    existingAttr = entry.attribute;
                } else {
                    existingName = entry;
                }
                // already set up - nothing to do
                if (existingName == childName && existingAttr == attributeName) {
                    return true;
                }
            }
            // Otherwise, clear up any existing locatorChild reference to this.
            this.locatorParent._removeLocatorChild(this);
        }
        
        if (!locatorParent._addLocatorChild(this, childName, attributeName)) {
            this.logWarn("setLocatorParent(): The specified child attribute '" 
                    + (attributeName || childName) + "' is already set on the locatorParent - not taking any action.");
            return false;
        }

        this.locatorParent = locatorParent;
        return true;

    },

    _addLocatorChild : function canvas__addLocatorChild (child, childName, attributeName) {
        // Never clobber an existing attribute
        var finalAttributeName = attributeName || childName;
        if (this[finalAttributeName] != null && this[finalAttributeName] != child) {
            return false;
        }

        var existingNamedLocatorChild = this.getNamedLocatorChild(childName);
        // Never clobber an existing namedLocatorChild relationship
        
        if (existingNamedLocatorChild) {
            return (existingNamedLocatorChild == child);
        }
        if (this.namedLocatorChildren == null) {
            this.namedLocatorChildren = [];
        }
        var entry = (attributeName != null) ? 
                     {name:childName, attribute:attributeName} : childName;
        this.namedLocatorChildren.add(entry);

        // Actually set the attribute
        this[attributeName || childName] = child;
        return true;
    },

    _removeLocatorChild : function canvas__removeLocatorChild(child) {
        if (this.namedLocatorChildren == null) return;
        for (var i = 0; i < this.namedLocatorChildren.length; i++) {
            var childName = this.namedLocatorChildren[i],
                attributeName = isc.isAn.Object(childName) ? childName.attribute : childName;
            if (this[attributeName] == child) {
                delete this[attributeName];
                this.namedLocatorChildren[i] = null;
                break; // Only one reference to one child canvas
            }
        }
        this.namedLocatorChildren.removeEmpty();
    },

    // Invoked from canvas.destroy()
    locatorChildDestroyed : function canvas_locatorChildDestroyed (child) {
        this._removeLocatorChild(child);
    },
    
    getLocatorParent : function canvas_getLocatorParent () {
        // locatorParent -- this is a generic entry point allowing special locator parent/child
        // behavior. 
        // This handles "namedLocatorChildren" [typically set up via widget.setLocatorParent(...)],
        // or custom relationships set up via a parent explicitly marking itself
        // as the locatorParent of some other widget, and implementing custom 
        // 'containsLocatorChild()' / 'getChildLocator()')
        if (this.locatorParent && this.locatorParent.containsLocatorChild && 
            this.locatorParent.containsLocatorChild(this)) 
        {
            return this.locatorParent;
        }
        // Canvas and FormItem both support 'getAutoChildLocator'
        if (this.creator &&
            (isc.isA.Canvas(this.creator) || (isc.FormItem && isc.isA.FormItem(this.creator))))
        {
            var autoChildName = this.creator.getAutoChildLocator(this);
            if (autoChildName == null) {
                // failed to find the child - most likely created via 'createAutoChild' but
                // never ran through addAutoChild() which would make it detectable in the
                // getAutoChildLocator() method
                // This is likely to happen if we are using the auto-child system to create
                // numerous auto-children with common properties, so it's not really a
                // failure.
                // Allow this to continue through the standard master-peer / parent-child
                // logic.
                this.logInfo("Locator code failed to find relationship between parent:"+
                            this.creator.getID() + " and autoChild:"+ this.getID(), "AutoTest");
            } else {
                return this.creator;
            }
        }
        var parentElement = this.parentElement;
        if (this.canvasItem) parentElement = this.canvasItem.form; // not really the parentElement of course...

        return this.masterElement || parentElement;
    },
    
  
    //> @method canvas.getChildLocator()
    // Get the abstract Locator string for finding a child canvas within its parent element 
    // @param (Canvas)
    // @return (Locator) abstract Locator String for finding this child
    //<
    // Leave this internal - developers would call getLocator() directly
    _childLocatorTemplate:[
        ,   // "child" or "peer"
        "[",
        ,   // index of child/peer
        '][Class="',
        ,   // className of child/peer
        '"]'
    ],
     
    
    getChildLocator : function canvas_getChildLocator (canvas) {
        // special case scrollbars
        if (canvas == this.hscrollbar) {
            return "hscrollbar";
        }
        if (canvas == this.vscrollbar) {
            return "vscrollbar";
        }
        
        // More general behavior split into 3 parts for easy overriding
        // - If an explicit 'namedLocatorChild' relationship was set up via setLocatorParent()
        //   that always takes precedence - it's a short unambiguous string like "/frozenbody/"
        // - Otherwise use the autoChildren mechanism if possible - named autoChildren are
        //   also short and unambiguous. MultiAutoChildren are more ambiguous but still
        //   better than locators such as children/members array
        // - If we didn't find anything more explicit, use the "standard" child locator route to
        //   resolve children or members arrays, etc.
        
        var nlcs = this.getNamedLocatorChildString(canvas);
        if (nlcs) return nlcs;

        if (canvas.creator == this) {    
            var autoChildID = this.getAutoChildLocator(canvas);
            if (autoChildID) return autoChildID;
        }
        
        if (this.editProxy && this.editProxy.inlineEditForm == canvas) {
            return "inlineEditForm";
        }
        
        return this.getStandardChildLocator(canvas);
    },
    
    // Called when AutoTest.getLocator() is called with the checkNativeElement parameter.
    // This method tests for the case where we have an element that natively 
    // "has meaning" in terms of events (IE eventHandledNatively is true) and our generated
    // SC-locator won't get back to that element.
    // Example case: A link written into a canvas handle -- the locator will likely point to
    // the canvas, while the link itself is the element that should be recorded.
    // In this case testing tools such as selenium may be able to get a better identifier 
    // based on (EG) ID of the link element.
    //
    // We do have cases where a widget writes out a live element which will handle native events
    // but we already handle generating a full locator to get at them (rather than just the
    // canvas handle). Example case: link elements within the month view of a calendar widget.
    // 
    // We test for this case by doing a round-trip test - if the locator already directly
    // points to the element (via AutoTest.getElement()), we use the locator.
    //
    
    // Implemented at the Canvas level so we can override this in subclasses if appropriate.
    checkLocatorForNativeElement : function canvas_checkLocatorForNativeElement (locator, element) {
        if (element == null || locator == null) return false;
        
        return (isc.EventHandler.eventHandledNatively("mousedown", element, true) &&
                (isc.AutoTest.getElement(locator) != element));
    },

    getNamedLocatorChildString : function canvas_getNamedLocatorChildString (canvas) {
        
        // Fairly common pattern - this.<someAttribute> is set directly to the canvas
        // but for whatever reason it didn't go through the addAutoChild() subsystem.
        // We can handle this explicitly by:
        // - setting locatorParent on the child to point to this widget
        // - adding an entry to the "namedLocatorChildren" array with the attribute name
        // The easiest way to do this is via the 'setLocatorParent()' method
        if (canvas.locatorParent == this && this.namedLocatorChildren) {
            for (var i = 0; i < this.namedLocatorChildren.length; i++) {
                var name = this.namedLocatorChildren[i],
                    attrName = name;
                    
                // support an object of the format {name:"name", attribute:"attributeName"}
                // This allows us to defeat changing obfuscated names like "_editRowForm"
                if (isc.isA.Object(name)) {
                    attrName = name.attribute,
                    name = name.name;
                }
                if (canvas == this[attrName]) {
                    return name;
                }
            }
        }
    },
    
    getStandardChildLocator : function canvas_getStandardChildLocator (canvas) {       
        
        if (canvas.getMasterCanvas() == this) {
            return this.getCanvasLocatorFallbackPath("peer", canvas, this.peers);
            
        } else if (canvas.getParentCanvas() == this) {
            return this.getCanvasLocatorFallbackPath("child", canvas, this.children);
        } else {
            // Not clear what would cause this - we already catch the autoChild case, 
            // so this is really a sanity check only
            this.logWarn("unexpected error - failed to find relationship between parent:"+
                        this.getID() + " and child:"+ canvas.getID());
            // return the standard root ID for the canvas - when parsing the strings back
            // we will have to explicitly catch this case?
            return canvas.getLocatorRoot();
        }
    },
    
    //> @method canvas.getInteriorLocator()
    // Get a relative Locator for an element contained within this Canvas
    // @param (DOMElement) DOM element contained within this Canvas
    // @return (Locator) abstract Locator String
    //<
    // Overridden to provide standard "meaningful locations" for ListGrids, DynamicForm, etc
    getInteriorLocator : function canvas_getInteriorLocator (element, fromEvent, coords) {
        if (element && this.useEventParts) {
            var partObj = this.getElementPart(element);
            if (partObj != null && partObj.part != null) {
                // This will be of the format "partType_partID"
                return (partObj.partID && partObj.partID != isc.emptyString) ? 
                                        partObj.part + "_" +  partObj.partID : partObj.part;
            }
        }
        if (coords && this.canDragResize) {
            var edgeLocator = this.getEventEdge(null, coords);
            if (edgeLocator) return edgeLocator;
        }
        return isc.emptyString;
    },


    // -------------------------
    // Retrieving dom elements from locator strings
    //> @method canvas.getAttributeFromSplitLocator()
    // Given a locator string split into an array, return specified attribute.
    // @param (Locator Array) array of strings
    // @param (Object) configuration for request
    // @return (Object) requested attribute
    // @visibility internal
    //<
    // Internal - the parameter format does not match the Locator format returned by
    // canvas.getLocator -- developers should call AutoTest.getElement() rather than directly 
    // accessing this method
    getAttributeFromSplitLocator : function canvas_getAttributeFromSplitLocator (locatorArray,
                                                                                 configuration) 
    {

        var attribute = configuration.attribute,
            child = this.getChildFromLocatorSubstring(locatorArray[0], 0, locatorArray,
                                                      configuration);

        // return value if requested and it was set when the child was located
        if (configuration.value != null) return configuration.value;

        if (child) {
            locatorArray.removeAt(0);
            var result = child.getAttributeFromSplitLocator(locatorArray, configuration);

            // If the result was explicitly null [not just undefined], 
            // or an actual object, return it if appropriate
            if ((result != null || result === null) &&
                (isc.Canvas._$Value == attribute ||
                    isc.Canvas._$Selected == attribute ||
                    isc.Canvas._$Record == attribute ||
                    isc.Canvas._$Field == attribute)) 
            {
                return result;
            }
            if (configuration.locatorMatching != "permitSuffix") {
                child.setLogFailureText(true, "the trailing locator suffix '" + 
                    locatorArray.join("/") + "' does not identify any valid attribute of",
                                        "and permitSuffix mode is not active");
                return result;
            }
        } else {
            // we don't want a prefix match if locator is marked for restrictSuffix mode
            
            if (locatorArray[0] && (!isc.DynamicForm || !isc.isA.DynamicForm(this)) &&
                configuration.locatorMatching == "restrictSuffix") 
            {
                this.setLogFailureText(true, "the trailing locator suffix '" + 
                    locatorArray.join("/") + "' does not identify a valid child of",
                                        "and restrictSuffix mode is active");
                return null;
            }
        }

        // stop searching for object and return this Canvas unless it's a DynamicForm/DrawPane
        if (attribute == isc.Canvas._$Object && 
            (!isc.DynamicForm || !isc.isA.DynamicForm(this)) &&
            (!isc.DrawPane    || !isc.isA.DrawPane   (this))) {
            return this;
        }
        
        // split finding attribute within our handle to a separate method for simpler override
        return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
    },
    
    // Given a substring extracted from a split locator array, return the child widget
    // that matches the specified substring.
    // If there is no matching child, return null - we'll then treat this widget as the
    // innermost child widget treat any remaining locator info as an interior locator
     
    getChildFromLocatorSubstring : function canvas_getChildFromLocatorSubstring 
                                   (substring, index, locatorArray, configuration, returnAllMatches)
    {
        if (substring == null || substring == "") return null;

        // If the substring starts with ":" it's a search segment
        if (substring.startsWith(":")) {
            // trim off the ":" before searching for the canvas
            substring = substring.substring(1, substring.length);
            // An additional "?" character on the prefix indicates we're
            // searching for a potentially hidden component
            var includeHidden = false;
            if (substring.startsWith("?")) {
                includeHidden = true;
                substring = substring.substring(1, substring.length);
            }
            return isc.AutoTest._searchForCanvas(this, substring, returnAllMatches, includeHidden);
        }
        
        // Standard formats:
        // 
        // Attribute pointing directly to widget:
        // EG:
        // - vscrollbar/hscrollbar 
        // - named autoChild
        // - things in the "namedLocatorChildren" array
        
        if (isc.isA.Canvas(this[substring])) {
            return this[substring];
        }
        
        var canvas = this.getNamedLocatorChild(substring);

        // Unable to find a registered namedLocatorChild: this is probably a failure.
        // Could return null here or keep going
        // - keep going in case some other strategy finds the component?
        if (canvas == false) canvas = null;
        if (canvas != null) return canvas;

        if (substring == "inlineEditForm") {
            return this.editProxy && this.editProxy.inlineEditForm;
        }
        
        // Fallback locators ([childType][fallback locator for specific child])
        // EG:
        // - autoChildName[<fallback locator within auto children>]
        // - children[<fallback locator>]
        // - members[<fallback locator>]
        var fallbackLocatorConfig =  isc.AutoTest.parseLocatorFallbackPath(substring);
        if (fallbackLocatorConfig != null) {
            var child = this.getChildFromFallbackLocator(substring, fallbackLocatorConfig,
                                                        configuration);
            if (child == null) {
                this.setLogFailureText(true, null, "has no child identifiable " +
                                       "by the fallback locator '" + substring + "'");
            }
            return child;
        }

        // if we're here, we didn't find any candidates, or didn't find a child within them.
        // No need to warn here -- this is likely to happen if the remaining identifier is
        // an inner element locator
        return null;
        
    },
    
    //> @attr Canvas.locatorName (String : null : IRWA)
    // Local name for referencing this canvas from an autoTest locator string. It will be
    // used instead of <code>index</code> if found. This name must by unique within the parent
    // component.
    // <p>
    // By setting a static ID on certain top-level components and then using locatorName
    // in contained components, stable locators can be created for these components without
    // the need to pervasively assign IDs. 
    //
    // @visibility external
    // @group autoTest
    //<

    //> @type LocatorStrategy
    // The AutoTest subsystem relies on generating and parsing identifier strings to identify
    // components on the page. A very common pattern is identifying a specific component
    // within a list of possible candidates. There are many many cases where this pattern
    // is used, for example - members in a layout, tabs in a tabset, sections in a section stack.
    // <P>
    // In order to make these identifiers as robust as possible across minor
    // changes to an application, (such as skin changes, minor layout changes, etc) the
    // system will store multiple pieces of information about a component when generating
    // an identification string to retrieve it from a list of candidates.
    // The system has a default strategy for choosing the order in which to look at these
    // pieces of information but in some cases this can be overridden by setting
    // a <code>LocatorStrategy</code>.
    // <p>
    // By default we use the following strategies in order to identify a component from a list of
    // candidates:
    // <UL><li><code>name</code>: Does not apply in all cases but in cases where a specified
    // <code>name</code> attribute has meaning we will use it - for example for
    // +link{SectionStackSection.name,sections in a section stack} or +link{Img.name,images}.
    // </li>
    // <li><code>title</code>: If a title is specified for the component this may be used
    //   as a legitimate identifier if it is unique within the component - for example
    //   differently titled tabs within a tabset.</li>
    // <li><code>index</code>: Locating by index is typically less robust than by name or
    //   title as it is likely to be affected by layout changes on the page.</li>
    // </UL><P>
    // If an explicit strategy is specified, that will be used to locate the component if
    // possible. If no matching component is found using that strategy, we will continue to
    // try the remaining strategies in order as described above. In other words setting
    // a locatorStrategy to "title" will skip attempting to find a component by name, and
    // instead attempt to find by title - or failing that by index.
    // <P>
    // In cases where the name is considered definitive, such as for +link{Tab.name,Tabs} or
    // +link{FormItem.name,FormItems}, no fallback check will occur if a name is provided in the
    // locator but doesn't match a live object - the locator will fail to match anything.
    // Furthermore, in the case of +link{Tab,Tabs}, +link{FormItem,FormItems}, or collections
    // other than +link{Canvas.children,children of a widget}, if a title is
    // present in the locator and you haven't specified specified "index" as the strategy,
    // there may be no fallback check using the index if the locator title fails to match.
    // <P>
    // To avoid the Framework trying to match by name or title where they are assumed definitive
    // and we skip fallback to the remaining locator attributes, you'll need to remove the name
    // or title from the locator in question (or set the locatorStrategy to "index" in the case
    // of the title).
    // <P>
    // Note that we also support matching by type (see +link{type:LocatorTypeStrategy}).
    // Matching by type is used if we were unable to match by name or title or to disambiguate
    // between multiple components with a matching title.
    //
    // @value "name" Match by name if possible.
    // @value "title" Match by title if possible.
    // @value "index" Match by index
    //
    // @see ListGrid.locateRowsBy
    // @see ListGrid.locateColumnsBy
    // @see Canvas.locatePeersBy
    // @see Canvas.locateChildrenBy
    // @see Layout.locateMembersBy
    // @see SectionStack.locateSectionsBy
    // @see FormItem.locateItemBy
    // @see TabSet.locateTabsBy
    // @visibility external
    // @group autoTest
    //<
    
    //> @type LocatorTypeStrategy
    // When attempting to identify a component from within a list of possible candidates
    // as described +link{type:LocatorStrategy,here}, if we are unable to find a unique match
    // by name or title, we will use the recorded "type" of the component to verify
    // an apparent match.
    // <P>
    // By default we check the following properties in order:
    // <ul><li>Does the Class match?</li>
    //     <li>If this is not a +link{Class.isFrameworkClass,framework class}, does the
    //         core framework superclass match?</li>
    //     <li>Does the <code>role</code> match?</li>
    // </ul>
    // In some cases an explicit locatorTypeStrategy can be specified to modify this
    // behavior. As with +link{type:LocatorStrategy}, if we are unable to match using the
    // specified type strategy we continue to test against the remaining strategies in order - 
    // so if a type strategy of "scClass" was specified but we were unable to find a match
    // with the appropriate core superclass, we will attempt to match by role.
    // Possible values are:
    // @value "Class" Match by class if possible
    // @value "scClass" Ignore specific class and match by the SmartClient framework superclass.
    // @value "role" Ignore class altogether and attempt to match by role
    // @value "none" Don't attempt to compare type in any way
    // @see locatorStrategy
    // @visibility external
    // @group autoTest
    //<

    //> @attr Canvas.locateChildrenBy (LocatorStrategy : null : IRWA)
    // Strategy to use when locating children in this canvas from an autoTest locator string.
    // 
    // @visibility external
    // @group autoTest
    //<
    
    //> @attr Canvas.locateChildrenType (LocatorTypeStrategy : null : IRWA)
    // +link{type:LocatorTypeStrategy} to use when finding children within this canvas.
    // @visibility external
    // @group autoTest
    //<
    
    //> @attr Canvas.locatePeersBy (LocatorStrategy : null : IRWA)
    // Strategy to use when locating peers of this canvas from an autoTest locator string.
    // 
    // @visibility external
    // @group autoTest    
    //<
    
    //> @attr Canvas.locatePeersType (LocatorTypeStrategy : null : IRWA)
    // +link{type:LocatorTypeStrategy} to use when finding peers of this canvas.
    // @visibility external
    // @group autoTest
    //<

    _locatorChildren:{
        peer:"peers",
        child:"children"
    },
    
    _getEventPartElement : function (locatorArray) {
        var parts = locatorArray[0].split("_"),
            part = {
            part:   parts[0],
            partID: parts[1]
        };
        var element = this.getPartElement(part);
        if (element) return element;

        // return correct edge rather than center if locator has edge part
        if (this._isValidEdge(part.part)) return this._getHandleAndLogFailure(true);
    },
    
    getInnerAttributeFromSplitLocator : function canvas_getInnerAttributeFromSplitLocator (
        locatorArray, configuration) 
    {
        if (configuration.attribute == isc.Canvas._$Value ||
            configuration.attribute == isc.Canvas._$Selected ||
            configuration.attribute == isc.Canvas._$Record ||
            configuration.attribute == isc.Canvas._$Field) 
        {
            

            if (isc.Label && isc.isA.Label(this) || 
                (isc.HTMLFlow    && isc.isA.HTMLFlow(this)) &&
                (isc.EventWindow && isc.isA.EventWindow(this.parentElement)))
            {
                var contents = this.getContents();
                if (contents) return contents;
            }
            this.setLogFailureText(true, "the trailing locator suffix '" +
                                   locatorArray.join("/") + "' does not identify any " +
                                   "meaningful part of");
            return;
        }
        
        if (!this.emptyLocatorArray(locatorArray)) {
            // support event-parts in all canvii
            if (locatorArray.length == 1) {
                var undef, element = this._getEventPartElement(locatorArray);
                if (undef !== element) return element;
            }
            
            
            if (configuration.locatorMatching != "permitSuffix") {
                this.setLogFailureText(true, "the trailing locator suffix '" +
                                       locatorArray.join("/") + "' does not identify any AutoChild " +
                                       "or Event Part of", "and permitSuffix mode is not active");
                return null;
            }
        }

        return isc.AutoTest.getAttributeDefault(this, configuration.attribute);
    },

    // Given an autoTestLocator, return a rectangle that encompasses it
    
    getAutoTestLocatorRect : function canvas_getAutoTestLocatorRect (locator, element) {

        // we assume both are present for now
        if (locator == null || element == null) return null;

        
        var clipHandle = this.getClipHandle();
        if (this.getHandle() == element) element = clipHandle;
        var isClipHandle = (element == this.getClipHandle());


        
        var rect = isClipHandle ? this.getPageRect() : isc.Element.getElementRect(element),
            left = rect[0], width  = rect[2],
            top  = rect[1], height = rect[3]
        ;


        // return correct edge rather than center if locator has edge part
        
        var partLocator = locator.split("/").last(),
            isValidEdge = this._isValidEdge(partLocator)
        ;
        
        if (isValidEdge) {
            var edgeMarginSize = isClipHandle && this.edgeMarginSize || 2;
            if (partLocator.contains("B")) {
                top += (height-edgeMarginSize);
                height = edgeMarginSize;
            } else if (partLocator.contains("T")) {
                height = edgeMarginSize;
            }
            if (partLocator.contains("R")) {
                left += (width-edgeMarginSize);
                width = edgeMarginSize;
            } else if (partLocator.contains("L")) {
                width = edgeMarginSize;
            }
        }
        return [left, top, width, height];
    },
      
    // Retrieving coordinates based on element / locator string
    getAutoTestLocatorCoords : function canvas_getAutoTestLocatorCoords (locator, element) {

        var rect = this.getAutoTestLocatorRect(locator, element);
        if (rect == null) return null;

        var centerX = rect[0] + Math.round(rect[2]/2), 
            centerY = rect[1] + Math.round(rect[3]/2);
        return [centerX, centerY];
    },

    isLocatorAncestorOf : function (canvas, linkMenus) {
        for (var parent; canvas; canvas = parent) {
            if (canvas == this) return true;
            if (!canvas || !canvas.getLocatorParent) break;

            parent = canvas.getLocatorParent();
            if (isc.FormItem && isc.isA.FormItem(parent)) {
                parent = parent.form;
            }

            // link menu hierarchy widgets to owning canvas
            if (linkMenus && !parent && isc.isA.Menu(canvas)) {
                if (canvas.target) parent = canvas.target;
            }
        }
        return false;
    },

    _getHandleAndLogFailure : function canvas__getHandleAndLogFailure(useClipHandle) {
        // return null for handle if this canvas lies in a widget stack queued for destruction
        for (var canvas = this; canvas.parentElement; canvas = canvas.parentElement) {
            if (canvas.isPendingDestroy()) {
                this.setLogFailureText(true, "the canvas represented by", "is or has a " +
                    "parent queued for destroy - its DOM element handle is considered invalid");
                return null;
            }
        }

        var handle = useClipHandle ? this.getClipHandle() : this.getHandle();
        if (handle != null) return handle;

        var start = "null", finish;
        if (!this.isDrawn()) finish = "which is not drawn";
        else if (!this.handleDrawn()) start = "not drawn";

        start = "the DOM element handle is " + start + " for";
        this.setLogFailureText(true, start, finish);

        return null;
    },

    _isSelected : function (rowNum, colNum, record) {
        var totalRows = this.getTotalRows(),
            totalCols = this.fields.length;
        if (rowNum < 0 || rowNum >= totalRows || 
            colNum < 0 || colNum >= totalCols) return;

        var selection = this.selectionManager;
        if (!selection) return;
        
        if (selection.cellIsSelected) {
            return selection.cellIsSelected(rowNum, colNum);
        } else if (record) {
            return selection.isSelected(record);
        } 
    },
        
    _isValidEdge : function canvas__isValidEdge (edgePart) {
        var map = this.edgeCursorMap;
        return edgePart && map != null && map[edgePart] != null;
    },


    
    _isProcessingDone : function canvas__isProcessingDone (strictMode) {
        if (strictMode && !this.isDrawn()) return true;
        return isc.AutoTest.isCanvasDone(this) != false;
    },


    //////////////////////////////////////////////////////////////////////////////////////////
    // Locator search segment support
    
    //> @attr canvas.definingProperty (String : null : IRWA)
    // This attribute denotes the name of a property to use as a
    // +link{getDefiningPropertyName()} for this property when generating and resolving
    // +link{type:AutoTestLocator,AutoTest locators with search segments}.
    // @visibility external
    //<

    //> @attr canvas.definingPropertyNameOptions (Array of String : [...] : IRWA)
    // If no explicit +link{definingProperty} was specified for this component,
    // this array denotes a list of options to use as a
    // +link{getDefiningPropertyName(),defining property} when generating and resolving
    // +link{type:AutoTestLocator,AutoTest locators with search segments}.
    // The first attribute in this array that is non-null for this component will
    // be used as the defining property for locator search segments.
    // <P>
    // The default set of options are as follows:
    // <pre>
    // [
    //  "locatorName",
    //  "dataSource"
    // ]
    // </pre>
    // @visibility external
    //<
    definingPropertyNameOptions:[
        "locatorName",
        
        // "name",
        "dataSource"
    ],

    //> @method canvas.getDefiningPropertyName()
    // This method returns the name of an attribute for the +link{AutoTest} system
    // to use as the <code>definingProperty</code> when generating
    // +link{type:AutoTestLocator,locators}.
    // <P>
    // If the value for the attribute returned by this method is non null, 
    // the +link{AutoTest.getLocator()} method will use this property name and value
    // in the locators it generates to search the widget hierarchy for this component.
    // <P>
    // The default implementation will return +link{definingProperty,this.definingProperty}
    // if specified, otherwise the first entry in 
    // +link{definingPropertyNameOptions,this.definingPropertyNameOptions} 
    // that has a non empty value for this component.
    //
    // @return (String) property name to use as a defining property when generating 
    //  AutoTest locators with search segments
    // @visibility external
    // @group autoTest
    //<
    getDefiningPropertyName : function canvas_getDefiningPropertyName () {

        if (isc.AutoTest.useLocalIDsInMinimalLocators) {
            if (this.getStableScreenLocalId()) return "localId";
        }
        // If an explicit definingProperty was specified for the class, assume
        // it will always be present on the component
        if (this.definingProperty != null) return this.definingProperty;

        // Otherwise use the first of definingPropertyNameOptions that is set for this
        // component
        for (var i = 0; i < this.definingPropertyNameOptions.length; i++) {
            var prop = this.definingPropertyNameOptions[i];
            // A DataSource with an auto-assigned ID or which is configured to not
            // add a global ID should not be used as a defining property. 
            
            if (this[prop] != null && prop == "dataSource" &&
                (this.getDataSource()._autoAssignedID || this.getDataSource().addGlobalId == false))
            {
                continue;
            }
            if (this[prop] != null) return prop;
        }
    },

    _getContainerProxy : function canvas__getContainerProxy (markerType) {

        var proxy, manager = this.canvasItem ? this.canvasItem.form : this.getPanelContainer();
        if (manager) proxy = manager.__getContainerProxy(this);

        // no marker passed, just return proxy
        if (!markerType) return proxy;

        // verify that the marker is consistent with the proxy hierarchy
        if (proxy) switch (markerType) {
            case 't': if (isc.isA.TabSet(manager))       return proxy;
                break;
            case 'i': if (isc.isA.DynamicForm(manager))  return proxy;
                break;
            case 's': if (isc.isA.SectionStack(manager)) return proxy;
                break;
        }
        if (this.logIsDebugEnabled("AutoTest")) {
            this.logDebug("inconsistent proxy syntax, container ID '" + this.getID() + "'");
        }
    },

    _getProxyPropertyMarker : function canvas__getProxyPropertyMarker () {

        var manager = this.canvasItem ? this.canvasItem.form : this.getPanelContainer();
        if (isc.TabSet            && isc.isA.TabSet(manager))       return "t:";
        else if (isc.DynamicForm  && isc.isA.DynamicForm(manager))  return "i:";
        else if (isc.SectionStack && isc.isA.SectionStack(manager)) return "s:";
    },

    
    __getContainerProxy : function () {
        return null;
    },

    _isQualifyingContainer : function canvas__isQualifyingContainer (mode, context) {
        // Identify autoChildren through their creator rather than
        // searching for them
        if (this.creator) return;
        // If an explicit locatorParent has been specified, identify
        // the target through that rather than searching for it
        if (this.locatorParent != null) return;

        if (this.__isQualifyingContainer(mode)) {
            return true;
        }

        // container not qualifying; check proxy
        var proxy = this._getContainerProxy();
        if (!proxy || proxy.creator) return;

        if (proxy.__isQualifyingContainer(mode)) {
            // register proxy against container
            var proxies = context.proxies;
            if (!proxies) {
                proxies = context.proxies = {};
            }
            proxies[this.getID()] = proxy;
            return true;
        }
    },

    _getMinimalLocatorSegment : function canvas__getMinimalLocatorSegment (mode, startMarker,
                                                                           context)
    {
        // apply the specified root locator if one provided
        if (context.rootLocator) return context.rootLocator;

        // set up the container proxy and property marker
        var marker = "",
            proxies = context.proxies,
            proxy = proxies && proxies[this.getID()];
        if (proxy) marker = this._getProxyPropertyMarker();
        else proxy = this;

        // build the initial part of the locator segment
        var locator = startMarker + this.getScClassName();

        switch (mode) {
        case this._$widgetID:
            locator += "[" + marker + "ID=\"" + proxy.getID() + "\"]";
            break;
        case this._$defProp:
            var propName = proxy.getDefiningPropertyName(),
                propValue = proxy.getDefiningPropertyValue()
            ;
            locator += "[" + marker + propName + "=\"" + propValue + "\"]";
            break;
        }
        return locator;
    },

    // returns parent container with the specified qualifying mode, stopping at topContainer
    _getQualifyingContainer : function canvas__getQualifyingContainer (mode, context,
                                                                     topContainer, selfFirst)
    {
        delete context.self;
        var qualifyingSelf;

        // step up the locator parent chain looking for a qualifying container to return
        for (var container =  this; container; container = container.getLocatorParent()) {
            
            if (isc.FormItem && isc.isA.FormItem(container)) container = container.form;

            if (container == topContainer) return;

            if (container._isQualifyingContainer(mode, context)) {
                if (selfFirst || qualifyingSelf) {
                    return container;
                }
                qualifyingSelf = container;
            }

            selfFirst = true;
        }
        
        // if called with selfFirst: false, we skipped the match of widget itself so report now
        if (qualifyingSelf) context.self = true;
        return qualifyingSelf;
    },

    // returns the descriptor (including locator) for the outer qualifying container 
    _getOuterContainerDescriptor : function canvas__getOuterContainerDescriptor () {
        var locator, quality,
            context = {isRoot: true},
            container = this._getQualifyingContainer(this._$widgetID, context);
        if (container) {
            return {
                locator: container.getLocatorToContainer(container, this._$widgetID, context),
                container: container, quality: 90
            };
        } else {
            container = this._getQualifyingContainer(this._$defProp, context);
            if (container) return {
                locator: container.getLocatorToContainer(container, this._$defProp, context),
                container: container, quality: context.self ? 60 : 80
            };
        }
    },

    // adds locator segment(s) for the inner container/target (via search operator)
    _addInnerContainerToDescriptor : function canvas__addInnerContainerToDescriptor
                                              (containerDescriptor)
    {
        var desc = containerDescriptor,
            container = desc.container,
            quality = desc.quality,
            locator = desc.locator,
            context = {}
        ;
        // find the inner qualifying container; this may be the locator target itself
        var target = this._getQualifyingContainer(this._$defProp, context, container, true);
        if (target) {
            locator += this.getLocatorToContainer(target, this._$defProp, context);
        } else {
            locator = this.getLocatorToContainer(container, this._$defProp, context, locator);
            quality -= 20;
        }
        return {locator: locator, quality: quality};
    },

    // returns descriptor for the minimal locator to the target (locator, quality, etc.)
    getMinimalLocatorDescriptor : function canvas_getMinimalLocatorDescriptor (element,
        fromEvent, coords, overrides)
    {
        // configure global settings for minimal locators
        isc.AutoTest.pushConfiguration(isc.addProperties({
            useCompactFallbackSyntax: true,
            useMinimalFallbackAttributes: true
        }, overrides));

        try {
            var interiorLocator = this.getInteriorLocator(element, fromEvent, coords);

            // simplest case if where target has a stable ID; use that as the locator
            if (this.hasStableID() && !interiorLocator) {
                return {locator: this.getID(), quality: 100};
            }

            var canvasDescriptor;

            // compute the locator for the outer qualifying container, it one exists
            var outerContainerDesc = this._getOuterContainerDescriptor();
            if (outerContainerDesc) {
                canvasDescriptor = this._addInnerContainerToDescriptor(outerContainerDesc);

            // no qualifying container; fall back to a normal locator rooted at top canvas
            } else {
                canvasDescriptor = {
                    locator: this.getLocatorToContainer(),
                    quality: this.getLocatorParent() ? 20 : 10
                };
            }

            // add trailing segments (as required) to reach element inside canvas
            if (interiorLocator) canvasDescriptor.locator += "/" + interiorLocator;

            return canvasDescriptor;

        // restore original global locator settings
        } finally {
            isc.AutoTest.popConfiguration();
        }
    }

});

},


applyFoundationMethods : function () {

if (isc.Button) {
    isc.Button.addProperties({

        //> @attr button.definingProperty (String : "title" : IRWA)
        // This attribute denotes the name of a property to use as a
        // +link{getDefiningPropertyName()} for this property when generating and resolving
        // +link{type:AutoTestLocator,AutoTest locators with search segments}.
        // @visibility external
        //<
        definingProperty: "title"
    });
}

if (isc.StretchImgButton) {
    isc.StretchImgButton.addProperties({
        //> @attr stretchImgButton.definingProperty (String : "title" : IRWA)
        // This attribute denotes the name of a property to use as a
        // +link{getDefiningPropertyName()} for this property when generating and resolving
        // +link{type:AutoTestLocator,AutoTest locators with search segments}.
        // @visibility external
        //<
        definingProperty: "title"
    });
}


// -----------------------------------------------------------------
// Override getPartElement() for special cases
if (isc.Scrollbar) {
    isc.Scrollbar.addMethods({
        getPartElement : function scrollbar_getPartElement(partObj) {
            if (partObj.part == "start") {
                return this.getImage(this.startImg.name);
            } else if (partObj.part == "end") {
                return this.getImage(this.endImg.name);
            }
            return this.Super("getPartElement", arguments);
        }
    });
}

// -----------------------------------------------------------------
// Override getChildLocator() for special cases

if (isc.Layout) {
    isc.Layout.addProperties({
            
        //> @attr Layout.locateMembersBy (LocatorStrategy : null : IRWA)
        // Part of the +link{group:automatedTesting} system, strategy to use when generated
        // locators for members from within this Layout's members array.
        // 
        // @visibility external
        // @group autoTest
        //<
        
        //> @attr Layout.locateMembersType (LocatorTypeStrategy : null : IRWA)
        // +link{type:LocatorTypeStrategy} to use when finding members within this layout.
        // @visibility external
        // @group autoTest
        //<
        
            
        getStandardChildLocator : function canvas_getStandardChildLocator (canvas) {
            
            if (this.members.contains(canvas)) {
                return this.getCanvasLocatorFallbackPath("member", canvas, this.members);
            }
            
            return this.Super("getStandardChildLocator", arguments);
        },
        
        
        _locatorChildren:{
            member:"members",
            peer:"peers",
            child:"children"
        }
    });
}

if (isc.SectionStack) {
    
    // add the _locatorChildren for SectionHeader / ImgSectionHeader - this will
    // allow them to parse the item[fallbacklocator] generated by the
    // sectionStack standard child locator override below
    isc.ImgSectionHeader.changeDefaults("_locatorChildren", {item:"items"});
    isc.SectionHeader.changeDefaults("_locatorChildren", {item:"items"});

    
    // add sections to locatorChildren for SectionStack - allows it to parse the
    // section[fallbackLocator] we create below
    isc.SectionStack.changeDefaults("_locatorChildren", {section:"sections"});
    
    isc.SectionStack.addProperties({
    
        // Override getObjectLocator to handle being passed a SectionStackSection
        getObjectLocator : function sectionStack_getObjectLocator (object) {
            if (object.getSectionHeader) object = object.getSectionHeader();

            // getStandardChildLocator should already handle returning section[name="foo"]
            if (object.isSectionHeader) {
                var sectionLocator = this.getStandardChildLocator(object);
                // hang an 'objectType' flag on the object locator so we can easily figure out
                // what this thing actually is
                sectionLocator += "/objectType=Section";
                return sectionLocator;
            }                
            return this.Super("getObjectLocator", arguments);
        },
        
            
        // override getStandardChildLocator - for sections return 
        //  section[name="name"||title="title"||3]
        // for items, append
        //  item[0]
        getStandardChildLocator : function sectionStack_getStandardChildLocator (canvas) {
            var sections = this.sections || [],
                locatorString;
            for (var i = 0; i < sections.length; i++) {
    
                var items = sections[i].items,
                    section, item;
                if (canvas == sections[i]) {
                    section = canvas;
                    
                } else if (items && items.contains(canvas)) {
                    
                    section = sections[i];
                    item = canvas;
                }
                
                if (section != null) {
                    
                    // This will pick up name by default, then title, index, etc
                    locatorString = this.getCanvasLocatorFallbackPath("section", section,
                                                                      this.sections);
                }
                
                if (item != null) {
                    locatorString += "/" + this.getCanvasLocatorFallbackPath("item", item, 
                                                                             section.items);
                }
                if (locatorString != null) return locatorString;
            }
            
            return this.Super("getStandardChildLocator", arguments);
        },
           
        //> @attr SectionStack.locateSectionsBy (LocatorStrategy : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // +link{isc.AutoTest.getLocator()}, how should sections within this stack be
        // identified?  By default if a section has a specified
        // +link{SectionStackSection.name,Section.name} this will always be used.  For
        // sections with no name, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier</li>
        // <li><code>"index"</code> use the index of the section in the sections array as an identifier</li>
        // </ul>
        // 
        // If unset, and the section has no specified name, default behavior is to
        // identify by title (if available), otherwise by index.
        // @visibility external
        // @group autoTest
        //<
        
        //> @attr SectionStack.locateSectionsType (LocatorTypeStrategy : null : IRWA)
        // +link{type:LocatorTypeStrategy} to use when finding Sections within this section Stack.
        // @visibility external
        // @group autoTest
        //<
        // This will be picked up automatically based on the _locatorChildren object and
        // the standard "getLocatorStrategy()" logic
    
        // minimal locator support - return the section that contains the supplied member
        __getContainerProxy : function sectionStack___getContainerProxy (member) {
            var sections = this.sections;
            for (var i = 0; i < sections.length; i++) {
                var items = sections[i].items;
                for (var j = 0; j < items.length; j++) {
                    if (items[j] == member) {
                        return sections[i];
                    }
                }
            }
        }
            
    });

    isc.SectionHeader.addProperties({
        // ensure backcompat with SC 8.2, which contains /background/ in SectionHeader locators
        getAttributeFromSplitLocator : function sectionHeader_getAttributeFromSplitLocator 
        (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray) && locatorArray[0] == "background") {
                locatorArray.removeAt(0);
            }
            return this.Super("getAttributeFromSplitLocator", arguments);
        },

        //> @attr sectionHeader.definingProperty (String : "title" : IRWA)
        // This attribute denotes the name of a property to use as a
        // +link{getDefiningPropertyName()} for this property when generating and resolving
        // +link{type:AutoTestLocator,AutoTest locators with search segments}.
        // @visibility external
        //<
        
        definingProperty: "title"
    });
   
}

if (isc.NotifyLabel) {
    isc.NotifyLabel.addProperties({
        remappedLocatorProps: {"title": "locatorTitle"},

        // get a "stable" title for use in fallback locators
        
        getLocatorTitle : function () {
            var messageState = this.messageState,
                actions = messageState.actions,
                result = messageState.contents
            ;
            if (actions) for (var i = 0; i < actions.length; i++) {
                var title = actions[i].title;
                if (title) result = result ? result + " " + title : title;
            }
            return result;
        }
    });
}

// --------------------------------------------------
// Interior locators

if (isc.StretchImg) {
isc.StretchImg.addProperties({
    getInteriorLocator : function stretchImg_getInteriorLocator (element, fromEvent) {
        // We don't use the useEventParts flag in StretchImgs but in some cases we need to tell the
        // difference between events on different items
        // (EG a track-click and a button click)
        var origElement = element,
            handle = this.getHandle(), canvasName = this.getCanvasName();

        while (element && element != handle && element.getAttribute) {
            // check the "name" property for the open-icon 
            var ID = element.getAttribute("name");
            if (ID && ID.startsWith(canvasName)) {
                return ID.substring(canvasName.length);
            }
            element = element.parentNode;
        }
        return this.Super("getInteriorLocator", [origElement,fromEvent]);
    },
    
    getInnerAttributeFromSplitLocator : function stretchImg_getInnerAttributeFromSplitLocator (
        locatorArray, configuration) 
    {
        if (configuration.attribute == isc.Canvas._$Element) {
            // check for "name" - used for parts
            if (!this.emptyLocatorArray(locatorArray) && locatorArray.length == 1) {
                var image = this.getImage(locatorArray[0]);
                if (image) return image;
            }
        }
        return this.Super("getInnerAttributeFromSplitLocator", arguments);
    }
     
});
}

// ----------------------------------------------
// Returning element from interior locator

if (isc.StatefulCanvas) {
    isc.StatefulCanvas.addProperties({
          
        getInteriorLocator : function statefulCanvas_getInteriorLocator (element, fromEvent,
                                                                         coords) 
        {
            // special case; handle track from a slider to generate targetValue for coords
            if (isc.Slider && isc.isA.Slider(this.creator) && this.creator._track == this) {
                return this.creator.getInteriorLocator(element, fromEvent, coords);
            }
            return this.Super("getInteriorLocator", arguments);
        },

        getInnerAttributeFromSplitLocator : function statefulCanvas_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            // provide special handling for /imageLoaded locator extension
            if (locatorArray.length == 1 && locatorArray[0] == "imageLoaded") {
                var name = isc.Img && isc.isAn.Img(this) ? this.name : "icon",
                    attribute = configuration.attribute,
                    image = this.getImage(name);
                if (image) {
                    var loaded = image.naturalWidth > 0 && image.naturalHeight > 0;
                    switch (attribute) {
                    case isc.Canvas._$Value:
                        return loaded;
                    case isc.Canvas._$Element:
                        return loaded ? image : null;
                    }
                }
            }
            // label floats over statefulCanvas - if we have a specified part, assume it occurred
            // in the label since that's where we write out our icon, etc.
            if (!this.emptyLocatorArray(locatorArray) && this.label) {
                return this.label.getInnerAttributeFromSplitLocator(locatorArray, configuration);
            }
            // provide access to (Img)Button state
            var attribute = configuration.attribute;
            if ((isc.Canvas._$Value == attribute || isc.Canvas._$Selected == attribute) &&
                isc.isA.Function(this.isSelected))
            {
                return this.isSelected();
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);    
        },

        // Have slider tracks delegate their coordinate processing to the slider to handle target values
        getAutoTestLocatorRect : function statefulCanvas_getAutoTestLocatorRect (locator,
                    element) 
        {
            // special case; get coords associated with targetValue from the slider
            if (isc.Slider && isc.isA.Slider(this.creator) && this.creator._track == this) {
                return this.creator.getAutoTestLocatorRect(locator, element);
            }
            return this.Super("getAutoTestLocatorRect", arguments);
        },
        getAutoTestLocatorCoords : function statefulCanvas_getAutoTestLocatorCoords (locator,
                                                                                     element) 
        {
            // special case; get coords associated with targetValue from the slider
            if (isc.Slider && isc.isA.Slider(this.creator) && this.creator._track == this) {
                return this.creator.getAutoTestLocatorCoords(locator, element);
            }
            return this.Super("getAutoTestLocatorCoords", arguments);
        }
    });
}

},


applyContainersMethods : function () {

if (isc.Window) {
    isc.Window.addProperties({
        // Code in Window.js sets up Windows as the 'locatorParent' of their items
        containsLocatorChild : function window_containsLocatorChild (canvas) {
            if (this.items && this.items.contains(canvas)) return true;
            return this.Super("containsLocatorChild", arguments);
        },
        getStandardChildLocator : function window_getStandardChildLocator (canvas) {
        
            if (this.items && this.items.contains(canvas)) {
                var template = this._childLocatorTemplate;
                template[0] = "item";
                template[2] = this.items.indexOf(canvas);
                template[4] = canvas.getClassName();
                
                return template.join(isc.emptyString);
            }
            
            return this.invokeSuper(isc.Window, "getStandardChildLocator", canvas);            
        },
        
        _locatorChildren:{
            item:"items",
            member:"members",
            peer:"peers",
            child:"children"
        }
    });
}

if (isc.Dialog) {
    isc.Dialog.addProperties({
        _getDescription : function dialog__getDescription (locator) {
            var title   = this.title   || "",
                message = this.message || "",
                description = this.Super("_getDescription", arguments);
            if (title   != "") description = "'" + title + "' " + description;
            if (this.isModal)  description = "modal " + description;
            if (message != "") description += " with message \"" + message + "\"";
            return description;
        }
    });
}

// TabSets:
// We want to be able to locate tabs by ID or title rather than just index so if the order
// changes they continue to be accessible
if (isc.TabSet) {
    isc.TabSet.addProperties({

        // Relevant logic outside this file:
        //
        // In TabSet: tabBarControls layout has locatorParent / namedLocatorChildren set such that
        // the tabset will point directly to that auto-child by name.


        // In TabBar we have logic in makeButton to set 'locatorParent' on tabs to point
        // straight to the TabSet
        containsLocatorChild : function tabSet_containsLocatorChild (canvas) {
            if (this.Super("containsLocatorChild", arguments)) return true;

            if (this.getTabNumber(canvas) != -1) return true;
            return false;
        },

        getChildLocator : function (canvas) {
            // Instead of the standard "paneContainer" child locator for this TabSet's paneContainer,
            // we want to just skip the paneContainer when building up an scLocator. This is
            // because we want to use a "tabPane[]" locator instead; i.e. instead of this:
            //     .../paneContainer/member[...]/...
            // .. we want:
            //     .../tabPane[...]/...
            if (canvas === this.paneContainer) {
                return null;
            }
            return this.Super("getChildLocator", arguments);
        },

        _getTabObjLocatorConfig : function (tabObj, tabNum) {
            var locatorConfig = {};
            // locate by name, ID, title or index
            if (tabObj.name != null) locatorConfig.name = tabObj.name;
            if (tabObj.title != null) locatorConfig.title = tabObj.title;
            if (tabObj.ID != null && !tabObj._autoAssignedID) locatorConfig.ID = tabObj.ID;
            locatorConfig.index = tabNum;
            return locatorConfig;
        },

        getStandardChildLocator : function tabSet_getStandardChildLocator (canvas) {
            var tabNum = this.getTabNumber(canvas);
            if (tabNum != -1) {
                var tabObj = this.getTabObject(tabNum);

                var locatorConfig = this._getTabObjLocatorConfig(tabObj, tabNum);
                return isc.AutoTest.createLocatorFallbackPath("tab", locatorConfig);
            }
            return this.Super("getStandardChildLocator", arguments);
        },

        //> @attr TabSet.locateTabsBy (String : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // +link{isc.AutoTest.getLocator()}, how should tabs within this tabset be identified?
        // If the locator has a specified +link{Tab.ID} or +link{Tab.name}, no fallback
        // approach will be used as those attributes (with +link{Tab.ID} having priority) are
        // each alone considered to definitively locate it.
        // <P>
        // Otherwise, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier</li>
        // <li><code>"index"</code> use the index of the tab in the tabset as an identifier</li>
        // </ul><p>
        // If unset, and the locator has no specified ID or name, default behavior is to
        // identify by title (if available), otherwise by index.
        // @see locatorStrategy
        // @visibility external
        // @group autoTest
        //<
        getChildFromLocatorSubstring : function tabSet_getChildFromLocatorSubstring (substring) {
            var isTabLocator,
                isTabPaneLocator;                
            // this startsWith("tab[") is a bit of a hack we will probably just pass the
            // substring to AutoTest.parseLocatorFallbackPath directly and look at the returned
            // 'name' property -- however not sure if it'll handle all formats right now.
            if (substring != null &&
                ((isTabLocator = substring.startsWith("tab[")) ||
                 (isTabPaneLocator = substring.startsWith("tabPane["))))
            {
                var fallbackConfig = isc.AutoTest.parseLocatorFallbackPath(substring),
                    config = fallbackConfig.config,
                    tab;

                // if ID or name is present, always respect it:
                if (config.ID != null) {
                    tab = config.ID;
                } else if (config.name != null) {
                    tab = config.name;
                } else {
                    var locateTabsBy = this.locateTabsBy;
                    if (locateTabsBy == null) locateTabsBy = "title";

                    if (config.title && locateTabsBy == "title") {
                        tab = this.tabs.findIndex("title", config.title,
                                                  isc.AutoTest.compareHTMLStrings);
                    // last case -- we want to use the raw tab index.
                    } else {
                        tab = parseInt(config.index);
                    }
                }

                if (isTabLocator) {
                    return this.getTab(tab);
                } else {
                    
                    return this.getTabPane(tab);
                }
            }

            return this.Super("getChildFromLocatorSubstring", arguments);
        },
       
        // minimal locator support - return tab that contains the supplied tab pane
        __getContainerProxy : function tabSet___getContainerProxy (pane) {
            var tabBar = this.getTabBar();
            if (tabBar) {
                var buttons = tabBar.getMembers();
                for (var i = 0; i < buttons.length; i++) {
                    var button = buttons[i];
                    if (button.pane == pane) {
                        return button;
                    }
                }
            }
            //return container;
        }

    });

    var extraPaneContainerProperties = {
        // Override getChildLocator() for a TabSet's paneContainer to generate a "tabPane[]" 
        // locator rather than a "paneContainer/member[]" locator.
        getChildLocator : function (canvas) {
            var tabSet = this.creator,
                tabs = tabSet && tabSet.tabs;
            if (tabs != null) {
                var tabNum = tabs.findIndex("pane", canvas);
                if (tabNum >= 0) {
                    var tabObj = tabs[tabNum];
                    
                    var locatorConfig = tabSet._getTabObjLocatorConfig(tabObj, tabNum);
                    return isc.AutoTest.createLocatorFallbackPath("tabPane", locatorConfig);
                }
            }
            return this.Super("getChildLocator", arguments);
        },

        getFallbackLocatorCandidates : function (name) {
            if (name === "member") {
                if (!isc.TabSet._loggedPaneContainerMemberChildLocatorWarning) {
                    this.logWarn("scLocators involving selection of a member of a TabSet's " + 
                                 "paneContainer are deprecated. Instead, use a \"tabPane[]\" " +
                                 "locator. Note: A \"tabPane[]\" locator will be generated " + 
                                 "automatically if the test script is re-recorded.");
                        isc.TabSet._loggedPaneContainerMemberChildLocatorWarning = true;
                    }
                    return this.creator && this.creator.tabs && this.creator.tabs.getProperty("pane");
                }
            return this.Super("getFallbackLocatorCandidates", arguments);
        }
    };
    isc.TabSet.changeDefaults("paneContainerDefaults", extraPaneContainerProperties);
    if (isc.PaneContainer) isc.PaneContainer.addProperties(extraPaneContainerProperties);

}

},


applyFormsMethods : function () {

// --------------------------------------------------
// Interior locators

if (isc.Slider) {
    isc.Slider.addMethods({

        getInteriorLocator : function slider_getInteriorLocator (element, fromEvent, coords) {
            var locator = this.Super("getInteriorLocator", element, fromEvent);
            if (locator == isc.emptyString && coords != null) {
                var value = this._getValueFromCoords(false, coords);
                if (value) locator = "targetValue[" + value + "]";
            }
            return locator;
        },

        getInnerAttributeFromSplitLocator : function slider_getInnerAttributeFromSplitLocator (
            locatorArray, configuration)
        {
            switch (configuration.attribute) {
            case isc.Canvas._$Element:
                if (locatorArray.length == 1 ||
                    locatorArray.length == 2 && locatorArray[0].startsWith("track[")) {
                    if (locatorArray[locatorArray.length - 1].startsWith("targetValue[")) {
                        return this._getHandleAndLogFailure();
                    }
                }
                break;
            case isc.Canvas._$Value:
                return this.getValue();
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        getAutoTestLocatorRect : function slider_getAutoTestLocatorRect (locator, element) {
            if (locator == null || element == null) return null;

            var valueLocator = locator.split("/").last();
            if (valueLocator.startsWith("targetValue[")) {

                var targetValue = parseFloat(valueLocator.replace(/.*\[([\d-+.eE]+)\]$/, "$1"));
                if (isc.isA.Number(targetValue)) {
                    var thumbPosition = this._getThumbPositionFromValue(targetValue);
                    if (this.getHandle() == element) element = this.getClipHandle();
                    var rect = isc.Element.getElementRect(element);

                    var left   = rect[0],
                        width  = rect[2];
                    var top    = rect[1],
                        height = rect[3];

                    // thumbPosition will be an offset from our left (or top) edge.
                    // slider.thumbThinWidth is the length of the slider thumb along the track
                    if (this.vertical) {
                        // Offset from the top
                        top += Math.min(thumbPosition, height)
                        top -= Math.round(this.thumbThinWidth/2);
                        // report a rect that's only as tall as the thumb
                        height = this.thumbThinWidth;                    
                        return [left, top, width, height];
                    } else {
                        left += Math.min(thumbPosition, width),
                        left -= Math.round(this.thumbThinWidth/2);
                        width = this.thumbThinWidth;                                             
                        return [left, top, width, height];
                    }
                }
            }
            return this.Super("getAutoTestLocatorRect", arguments);
        },

        getChildFromLocatorSubstring : function scrollbar_getChildFromLocatorSubstring (substring, index, locatorArray, configuration) {
            if (substring == null) return null;
            var attribute = configuration.attribute;

            if ((substring.startsWith("thumb[") && attribute == isc.Canvas._$Value) ||
                substring.startsWith("track["))
            {
                // If a targetValue[ was recorded (recent locator format),
                // redirect track element to slider, and value requests for 
                // track or thumb to slider
                // If no targetValue[... was recorded, delegate to the track etc
                // autoChild as we always have.
                if (locatorArray.length > index+1 &&
                   locatorArray[index+1].startsWith("targetValue[")) 
                {
                    return null;
                }
            }
            return this.Super("getChildFromLocatorSubstring", arguments);
        }

    });

    // Note this is for back-compat only: Recently recorded locators will include a
    // targetValue attribute in addition to the "track" child locator and when interpreting
    // them we have the Slider (rather than the track autoChild) resolve to an element
    isc.Slider.changeDefaults("trackDefaults", {
        getInnerAttributeFromSplitLocator : function sliderTrack_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            // Slider: In 8.3 the track was a StretchImg by default. In 9.0 its a 
            // StatefulCanvas [though may still be a StretchImg depending on the skin].
            // If we have a recorded locator which includes a StretchImg part-name from the track but
            // the Slider track isn't a StretchImg, trim this off so we return the track's handle
            if (!isc.isA.StretchImg(this) && locatorArray.length > 0 && 
                    (locatorArray[0] == "stretch" || locatorArray[0] == "start" ||
                        locatorArray[0] == "end")) 
            {
                locatorArray = [];
            }
            return this.Super("getInnerAttributeFromSplitLocator",
                             [locatorArray, configuration], arguments);
        }
    });

}


// label.icon already handled via standard canvas 'eventPart' handling

if (isc.DynamicForm) {
    isc.DynamicForm.addProperties({
    
        getInteriorLocator : function dynamicForm_getInteriorLocator (element) {
            var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, this);
            // itemInfo format:
            // {item:item, overElement:boolean, overTitle:boolean, overTextBox:boolean,
            //  overControlTable:boolean, overIcon:string}
            if (!itemInfo.item) return this.Super("getInteriorLocator", arguments);
            var item = itemInfo.item,
                locator = [this.getItemLocator(item), '/'];
            if      (itemInfo.overElement)      locator[locator.length] = "element";
            else if (itemInfo.overValueIcon)    locator[locator.length] = "valueicon";
            else if (itemInfo.overTitle)        locator[locator.length] = "title";
            else if (itemInfo.overTextBox)      locator[locator.length] = "textbox";
            else if (itemInfo.overControlTable) locator[locator.length] = "controltable";
            else if (itemInfo.overInlineError)  locator[locator.length] = "inlineerror";
            else if (itemInfo.overIcon)         locator[locator.length] = "[icon=\"" + 
                     itemInfo.overIcon + "\"]";
            
            return locator.join(isc.emptyString);
        },
        
        getItemLocator : function dynamicForm_getItemLocator (item) {
            
            // containerItems contain sub items, which point back up to them via the
            // parentItem attribute
            // If we hit a sub-item of a container item, call getItemLocator on that so
            // the item is located within the containerItem's items array
            // This method is copied from DF to containerItems below
            // the check for item.parentItem != this is required - if this is running
            // on a container item and we contain an item in our items array we need to
            // allow standard identifier construction to continue or we'd have an infinite loop
            if (item.parentItem && (item.parentItem != this)) {
                return this.getItemLocator(item.parentItem) + "/" + 
                            item.parentItem.getItemLocator(item);
            }
            
            var itemIdentifiers = {};
            
            
            if (item.name != null && !item._autoAssignedName) itemIdentifiers.name = item.name;
            
            // Title - default strategy if no name
            var title = item.getTitle();
            if (title != null) itemIdentifiers.title = title;
            
            // Value - useful for things like header items where value is pretty much
            // a valid identifier
            var value = item.getValue();
            if (value != null) itemIdentifiers.value = value;
            
            // Index - cruder identifier
            itemIdentifiers.index = this.getItems().indexOf(item);
            
            // ClassName: Not used by default
            itemIdentifiers.Class = item.getClassName();
            
            var IDString = isc.AutoTest.createLocatorFallbackPath("item", itemIdentifiers, item);
            return IDString;
        },
        
        // Override getObjectLocator to handle being passed form items
        getObjectLocator : function dynamicForm_getObjectLocator (target) {
            if (isc.FormItem && isc.isA.FormItem(target)) {
                var itemLocator = this.getItemLocator(target);
                itemLocator += "/objectType=FormItem";
                return itemLocator;
            }
            return this.Super("getObjectLocator", arguments);
        },

        containsLocatorChild : function dynamicForm_containsLocatorChild (canvas) {
            if (isc.isA.DateChooser(canvas) && canvas.callingForm == this) return true;
            return this.Super("containsLocatorChild", arguments);
        },
        getChildLocator : function dynamicForm_getChildLocator (canvas) {
            if (canvas.canvasItem) {
                var item = canvas.canvasItem;
                return this.getItemLocator(item) + "/canvas";
            }
            if (isc.isA.PickListMenu(canvas) || isc.isA.PickTreeMenu(canvas)) {
                var item = canvas.formItem;
                return this.getItemLocator(item) + "/pickList";
            }
            if (isc.isA.DateChooser(canvas)) {
                var item = canvas.callingFormItem;
                return this.getItemLocator(item) + "/picker";
            }
            
            return this.Super("getChildLocator", arguments);
        },
        
        getItemFromSplitLocator : function dynamicForm_getItemFromSplitLocator (locatorArray) {
            var fullItemID = locatorArray[0],
                className;

            // BackCompat note: Old format for identifying form items was
            //   item[name="foo"][Class="TextItem"]
            // new format is
            //   item[name=foo||title=moo||index=2||Class=TextItem]
            // Handle the old format for backCompat
            if (fullItemID.contains("[Class=")) {
                var split = fullItemID.match("item\\[name=\"(.+)\"\\]\\[Class=\"(.+)\"\\]");
                if (split) fullItemID = "item[name=" + split[1] + "||Class=" + split[2] + "]";
            }
            var itemConfig = isc.AutoTest.parseLocatorFallbackPath(fullItemID);
            
            if (itemConfig && itemConfig.name == "item" && itemConfig.config != null) {
                var config = itemConfig.config;
                
                // className is stored even if we don't identify by it.
                className = config.Class;
                
                // if we have a valid name, always have it take precedence
                var item;
                if (config.name != null) {
                    //this.logWarn("locating by name" + config.name);
                    item = this.getItem(config.name);
                } else {
                    //this.logWarn("item locator:" +fullItemID + " has no name - checking for " +
                    //    " title etc.");
                                        
                    // no name - check for the item 'locateItemBy' setting
                    // Options are by title or by value
                    for (var i = 0; i < this.items.length; i++) {
                        var testItem = this.items[i],
                            locateItemBy = testItem.locateItemBy;
                        if (locateItemBy == null) locateItemBy = "title";
                        //this.logWarn("item:" + testItem + ", locate by:" + locateItemBy + 
                        //    "config[locateBy:" + config[locateItemBy]);
                        if (locateItemBy == "title" && config.title != null && 
                            testItem.title == config.title) 
                        {
                            item = testItem;
                        } else if (locateItemBy == "value" && config.value != null && 
                                    testItem.getValue() == config.value) 
                        {
                            item = testItem;
                        }
                    }
                    
                    // If we couldn't find the item by title or value (or locateItemBy was
                    // specified explicitly as index) - locate by index
                    if (item == null) {
                        var index = config.index;
                        if (isc.isA.String(index)) {
                            if (index.startsWith("'") ||
                                index.startsWith('"')) 
                            {
                                index = index.substring(1);
                            }
                            index = parseInt(index);
                        }
                        item = this.items[index];
                    }
                }
                if (!item) {
                    this.logWarn("AutoTest.getElement(): Unable to find item from " +
                        "locator string:" + fullItemID);
                    return null;
                }
                if (isc.AutoTest._shouldReportClassMismatch(className, item)) {
                    this.logWarn("AutoTest.getElement(): identifier:"+ fullItemID + 
                                " returned an item of class:"+ item.getClassName());
                }
                return item;
            }
            
            return null;
        },

        getInnerAttributeFromSplitLocator : function
            dynamicForm_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var item = this.getItemFromSplitLocator(locatorArray);
                if (item != null) {
                    locatorArray.removeAt(0);
                    return item.getAttributeFromSplitLocator(locatorArray, configuration); 
                }
                // support event-parts in all canvii
                if (locatorArray.length == 1) {
                    var undef, element = this._getEventPartElement(locatorArray);
                    if (undef !== element) return element;
                }
                
                if (configuration.locatorMatching != "permitSuffix") {
                    this.setLogFailureText(true, "the trailing locator suffix '" +
                        locatorArray.join("/") + "' does not identify any FormItem in",
                                           "and permitSuffix mode is not active");
                    return null;
                }
            }
            return isc.AutoTest.getAttributeDefault(this, configuration.attribute);
        },

        _isProcessingDone : function dynamicForm__isProcessingDone (strictMode) {
            if (strictMode && !this.isDrawn()) return true;
            return isc.AutoTest.isFormDone(this, strictMode) != false;
        },
    
        // minimal locator support - return the item that contains the supplied canvas
        __getContainerProxy : function dynamicForm___getContainerProxy (canvas) {
            var items = this.items;
            for (var i = 0; i < items.length; i++) {
                var item = items[i];
                if (canvas == item.canvas) {
                    return item;
                }
            }
            //return container;
        }
    });
    
    // containerItems contain sub items
    // copy methods across to them to form locators for sub items and
    // identify sub items from split locators
    isc.ContainerItem.addProperties({
        // getItemLocator -- called directly by DynamicForm.getItemLocator if
        // an item has a parentItem specified
        getItemLocator:isc.DynamicForm.getPrototype().getItemLocator,
        getItemFromSplitLocator:isc.DynamicForm.getPrototype().getItemFromSplitLocator,

        // getInnerAttributeFromSplitLocator - override to check for the presence of items
        getInnerAttributeFromSplitLocator : function
            containerItem_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var subItem = this.getItemFromSplitLocator(locatorArray);
                if (subItem != null) {
                    locatorArray.removeAt(0);
                    return subItem.getAttributeFromSplitLocator(locatorArray, configuration);
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        }
    });
    
    
    isc.FormItem.addProperties({
        
        //> @attr FormItem.locateItemBy (String : null : IRWA)
        // When +link{isc.AutoTest.getElement()} is used to parse locator strings generated by
        // +link{isc.AutoTest.getLocator()} for this form item, should the item be identified?
        // If the locator has a specified +link{formItem.name}, it is considered to definitely
        // locate the item and no fallback approach will be used.
        // <P>
        // Otherwise, the following options are available:
        // <ul>
        // <li><code>"title"</code> use the title as an identifier within this form</li>
        // <li><code>"value"</code> use the value of the item to identify it (often used
        //  for items with a static defaultValue such as HeaderItems</li>
        // <li><code>"index"</code> use the index within the form's items array.
        // </ul><p>
        // If unset, and the locator has no specified name, default behavior is to
        // identify by title (if available), then value (if available), otherwise by index.
        // @see locatorStrategy
        // @visibility external
        // @group autoTest
        //<
        
        // Some form items will use the autoChild subsystem to refer to some auto child, like the
        // miniDateRangeItem's date range dialog.
        // In this case, we can use the standard autoChild behavior to pick up this form item
        // as the locator parent (handled in getLocatorParent()) and we'll need to
        // support getChildLocator()
        getChildLocator : function formItem_getChildLocator (target) {
            
            // More general behavior split into 2 parts for easy overriding - autoChildren are pretty
            // much always respected over other locators such as children / members array
            if (target.creator == this) {    
                var autoChildID = this.getAutoChildLocator(target);
                if (autoChildID) return autoChildID;
            }

            if (this.editProxy && this.editProxy.inlineEditForm == target) {
                return "inlineEditForm";
            }
        },
        
        // getLocator on a form item. May be called directly if this was picked up as the
        // "parent locator" of an autoChild.
        getLocator : function formItem_getLocator () {
            // Ignore the "element" part - assume this will only be run in the 'autoChild' pattern.
            return this.getLocatorInternal();
        },

        
        getIconLocator : function formItem_getIconLocator (icon) {
            var iconIdentifiers = {};
            
            // Name
            if (icon.name != null) iconIdentifiers.name = icon.name;
            
            // Index - cruder identifier
            iconIdentifiers.index = this.icons.indexOf(icon);
            
            var IDString = isc.AutoTest.createLocatorFallbackPath("icon", iconIdentifiers);
            return IDString;
        },
        
        getLocatorInternal : function formItem_getLocatorInternal (a, b, c, d) {
            return this.form._getItemLocatorInternal(this, a, b, c, d);
        },
        getLocatorToContainer : function formItem_getLocatorToContainer (a, b, c, d) {
            return this.form._getItemLocatorToContainer(this, a, b, c, d);
        },

        // Implement getAttributeFromSplitLocator at the FormItem level. This means if a developer
        // assigns an actual ID to a FormItem and calls isc.AutoTest.getElement() passing in that
        // ID (for example //TextItem[ID='foo']) we can find it.
        getAttributeFromSplitLocator : function formItem_getAttributeFromSplitLocator (locatorArray,
                                                                                       configuration) {
            // split finding attribute within our handle to a separate method for simpler override
            return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
        },
        
        getInnerAttributeFromSplitLocator : function formItem_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            var undef,
                attribute = configuration.attribute,
                canReturnIcon = attribute == isc.Canvas._$Object && configuration.canReturnIcon
            ;

            if (!this.emptyLocatorArray(locatorArray)) {
                var part = locatorArray[0];

                // canvasItems
                if (part == "canvas" && this.canvas) {
                    locatorArray.removeAt(0);
                    var result = this.canvas.getAttributeFromSplitLocator(locatorArray, 
                                                                          configuration);
                    // if no attribute could be found in canvas, use formItem's attribute
                    if (result !== undef || attribute == isc.Canvas._$Element) return result;
                }

                // picker (EG date picker)
                if (part == "picker") {
                    if (this.picker) {
                        locatorArray.removeAt(0);
                        return this.picker.getAttributeFromSplitLocator(locatorArray, 
                                                                        configuration);
                    }
                }
                
                // pickList
                if (part == "pickList") {
                    if (!this.pickList) this.makePickList(false);
                    locatorArray.removeAt(0);
                    return this.pickList.getAttributeFromSplitLocator(locatorArray,
                                                                      configuration);
                }

                if (part == "inlineEditForm") {
                    var form = this.editProxy && this.editProxy.inlineEditForm;
                    if (form) {
                        locatorArray.removeAt(0);
                        return form.getAttributeFromSplitLocator(locatorArray,
                                                                configuration);
                    }
                }
        
                // icon
                if (part.substring(0,4) == "icon" && canReturnIcon) {
                    var iconConfig = isc.AutoTest.parseLocatorFallbackPath(part);

                    if (iconConfig && iconConfig.name == "icon" && iconConfig.config != null) {
                        var config = iconConfig.config;

                        // if we have a valid name, always have it take precedence
                        var icon;
                        if (config.name != null) {
                            //this.logWarn("locating by name" + part.name);
                            icon = this.getIcon(config.name);
                        } else {
                            var index = config.index;
                            if (isc.isA.String(index)) {
                                if (index.startsWith("'") ||
                                    index.startsWith('"')) 
                                {
                                    index = index.substring(1);
                                }
                                index = parseInt(index);
                            }
                            icon = this.icons[index];
                        }
                        if (!icon) {
                            this.logWarn("AutoTest.getObject(): Unable to find form item " +
                                "icon from locator string:" + part);
                            return null;
                        }
                        return icon;
                    }
                }

                if (attribute == isc.Canvas._$Element) {
                    if (part == "element") return this.getDataElement();
                    if (part == "title") return this.form.getTitleCell(this);
                    if (part == "textbox") return this._getTextBoxElement();
                    if (part == "controltable") return this._getControlTabelElement();
                    if (part == "inlineerror") return this.getInlineErrorHandle();
                    if (part == "handle") return this.getHandle();
                    
                    if (part == "valueicon") {
                        var cell = this.getOuterElement();
                        if (cell) {
                            // querySelectorAll is supported in all browsers since IE8
                            if (cell.querySelectorAll) {
                                var candidates = cell.querySelectorAll("[eventpart=valueicon]");
                                if (candidates.length == 1) return candidates[0];
                            }
                        }
                        this.logWarn("Locator specified click event on value icon but " +
                            "unable to find valueIcon element for this item - " +
                            "recorded test may be invalid.", "AutoTest");
                    }
                }

                if (attribute == isc.Canvas._$Element || canReturnIcon) {
                    // Handle single or double-quotes around the icon name
                    var iconSplit = part.match("\\[icon='(.+)'\\]") || 
                                    part.match('\\[icon="(.+)"\\]');
                    var iconID = iconSplit ? iconSplit[1] : null;
                    
                    if (iconID) {
                        if (canReturnIcon) {
                            // return the formItemIcon itself from the form ID 
                            var icon = this.getIcon(iconID);
                            if (!icon) {
                                if (iconID == this.errorIconName){
                                    icon = this.getErrorIconProperties();
                                } else {
                                    this.setLogFailureText(true, 
                                        "there is no Icon associated with " + iconID +
                                        " and locator '" + locatorArray.join("/") + "' for");
                                }
                            }
                            return icon;
                        } else {
                            // If passed an icon, return a pointer to the img element 
                            // Event if there is a link element, it'll be above that in the DOM
                            var imgElement = this._getIconImgElement(iconID);
                            if (!imgElement) {
                                this.setLogFailureText(true,
                                    "there is no Icon Image Element associated with " + iconID +
                                    " and locator '" + locatorArray.join("/") + "' for");
                            }
                            return imgElement;
                        }
                    }
                } 
                // Could be a named autoChild...
                if (this._createdAutoChildren) {
                    var autoChild = this._getNamedAutoChild(this._getNewAutoChildName(part),
                                                            configuration);
                    if (autoChild) {
                        locatorArray.removeAt(0);
                        return autoChild.getAttributeFromSplitLocator(locatorArray, configuration);
                    }
                }
                
                if (attribute == isc.Canvas._$Element) {
                    this.setLogFailureText(true, "the trailing locator suffix '" +
                                   locatorArray.join("/") + "' does not identify any " +
                                   "Event Part of");
                    return;
                }
            } 

            // default values
            switch (attribute) {
            case isc.Canvas._$Object:
                return this;
            case isc.Canvas._$Value:
                return this.getValue();
            case isc.Canvas._$Selected:
                return;
            case isc.Canvas._$Record:
                return;
            case isc.Canvas._$Field:
                return;
            }
            
            // no details passed; default to focus element if present, then to text box element
            
            var element = this.getFocusElement() || this._getTextBoxElement();
            if (element == null) {
                // If we're a canvasItem, return the canvas handle as a best-guess for the
                // "default" element to interact with.
                // For a buttonItem, for example, this will be appropriate for clicking or for Focus
                // For something like a nested DynamicForm it's likely not really what the dev
                // is after, but for meaningful interactions we'd expect locator to reach into
                // the embedded form and return a data item or something anyway, so it's a
                // reasonable default
                if (isc.isA.CanvasItem(this) && this.canvas) {
                    element = this.canvas.getHandle();
                }
                if (element == null) {
                    this.setLogFailureText(true, null, "has no focus or textbox elements");
                }
            }
            return element;
        },
        
        _getNamedAutoChild : function (name, configuration) {
            var createdAutoChildren = this._createdAutoChildren;
            if (!createdAutoChildren) return;

            
            var children = createdAutoChildren[name];
            if (children && children.length > 0) {
                if (this[name] != null) return this[name];
            } else { // name may not be an identifier, but a locatorArray segment!
                var fallbackLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(name);
                if (fallbackLocatorConfig != null) {
                    return this.getChildFromFallbackLocator(name, fallbackLocatorConfig,
                                                            configuration);
                }
            }
        },

        _locatorChildren: { button: "buttons" },

        // copy the 'emptyLocatorArray()' helper function across
        emptyLocatorArray:isc.Canvas.getPrototype().emptyLocatorArray,


        //////////////////////////////////////////////////////////////////////////////////////
        // Minimal locator support
        definingProperty: "name",
    
        getDefiningPropertyName : function formItem_getDefiningPropertyName () {
            return this.definingProperty;
        }
    });
    
    isc.HeaderItem.addProperties({
        //> @attr HeaderItem.locateItemBy (String : "value" : IRWA)
        // Default to locating header items by value
        // @visibility internal
        //<
        locateItemBy: "value"
    });
    
    if (isc.PickListMenu) {
        isc.PickListMenu.addProperties({
            getLocatorParent : function pickListMenu_getLocatorParent () {
                if (this.formItem) return this.formItem.form;
                return this.Super("getLocatorParent", arguments);
            }
        });
    }

    if (isc.PickTreeMenu) {
        isc.PickTreeMenu.addProperties({
            getLocatorParent : function pickTreeMenu_getLocatorParent () {
                if (this.formItem) return this.formItem.form;
                return this.Super("getLocatorParent", arguments);
            }
        });
    }
}

// DateChooser

if (isc.DateChooser) {
    
    
    isc.DateChooser.addMethods({
        
        getInteriorLocator : function dateChooser_getInteriorLocator (element) {
            
            // We don't write any kind of unique DOM IDs or attrs to our buttons which
            // would simplify determining the purpose of the buttons except our click handler.
            
            // 2 possible approaches:
            // 1) Crudely look at the current cell position in whichever table its in - likely to 
            //    break if we rework ... wait a sec
            
            // Ok so playback / record type stuff
            // 
            // Lets say we store this as prevYear, prevMo, moLauncher, nextMo, nextYear and
            // dateCell[rowNum,colNum] and today, cancel
            
            // we can then get back the appropriate button when rerun
            // however if the default date has changed (which it likely will, tests are unlikely 
            // to work unless the user changes to a specific month first....
            
            
            // Alternative would be to remember dateCell[datestamp] - then we simply won't find 
            // the element if the date changes. Ok that seems better - won't get WRONG behavior
            
            // If we have a header, the event may have occurred in it
            var handle = this.getHandle();
            if (!handle || !element) return "";
            
            var cachedString = element._cachedLocatorString;
            if (cachedString != null && cachedString != "") return cachedString;
            
            return element._cachedLocatorString = this._getInteriorLocator(element, handle);
        },
        
        _getInteriorLocator : function dateChooser__getInteriorLocator (element, handle) {
            var targetCell = element;
            while (targetCell && targetCell != null) {
                if (targetCell == handle) {
                    targetCell = null;
                    break;
                }
                if (targetCell.tagName && targetCell.tagName.toLowerCase() == "td") {
                    break;
                }
                targetCell = targetCell.parentElement;
            }
            if (targetCell == null || targetCell.getAttribute == null) return "";

            var eventPart = targetCell.getAttribute(isc.EH._$eventPartAttributeName);
            if (!eventPart) return "";
            
            var childNodes = handle.childNodes,
                tables = [];
            for (var i = 0; i < childNodes.length; i++) {
                if (!childNodes[i].tagName || childNodes[i].tagName.toLowerCase() != "table") {
                    continue;
                }
                tables[tables.length] = childNodes[i];
            }
            
            var headerTable = tables.length == 2 ? tables[0] : null,
                bodyTable = tables.length == 2 ? tables[1] : tables[0];
            
            if (headerTable != null && targetCell.offsetParent == headerTable) {
                // could look at position within rows array -- but then we'd have to also
                // look at the various 'showMonthChooser' etc configurations -- instead
                // lets look directly at the eventpart attribute

                switch (eventPart) {
                    case "showPrevYear":  return "prevYearButton";
                    case "showPrevMonth": return "prevMonthButton";
                    case "showMonthMenu": return "monthMenuButton";
                    case "showYearMenu":  return "yearMenuButton";
                    case "showNextMonth": return "nextMonthButton";
                    case "showNextYear":  return "nextYearButton";
                }
                return "";
                
            } else if (bodyTable != null && targetCell.offsetParent == bodyTable) {
                // If the event was in the body, return the appropriate date identifier

                switch (eventPart) {
                    case "cancel": return "cancelButton";
                    case "today":  return "todayButton";
                    default:
                    var eventId = targetCell.id;
                    if (eventId) {
                        var dateId = eventId.split("_");
                        if (dateId && dateId.length >= 3) {
                            dateId = dateId.slice(dateId.length - 3);
                        }
                        return dateId.join("/");
                    }
                }
            }
            return "";
        },
        
        
        getInnerAttributeFromSplitLocator : function
            dateChooser_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (configuration.attribute != isc.Canvas._$Element) {
                this.setLogFailureText(true, "getValue() is not supported for");
                return;
            }

            var handle = this._getHandleAndLogFailure();
            if (handle == null || this.emptyLocatorArray(locatorArray)) return handle;
            
            var isDateButton = (locatorArray.length == 3);
            if (!isDateButton) {
                
                var locatorString = locatorArray[0];
                if (locatorString == "") return handle;
                
                var isTodayButton = (locatorString == "todayButton"),
                    isCancelButton = !isTodayButton ? (locatorString == "cancelButton") : false;
                    
                var childNodes = handle.childNodes;
                    
                // today / cancel button show up in the "body" table
                if (isTodayButton || isCancelButton) {
                        
                    if (isTodayButton && !this.showTodayButton) {
                        this.logWarn("DateChooser attempting to locate element for " +
                            "'todayButton' but showTodayButton is false. Returning handle.",
                            "AutoTest");
                        return handle;
                    }
                    if (isCancelButton && !this.showCancelButton) {
                        this.logWarn("DateChooser attempting to locate element for " +
                            "'cancelButton' but showCancelButton is false. Returning handle.",
                            "AutoTest");
                        return handle;
                    }
                    
                    var bodyTable;
                    // we show two tables if the header is showing, or just one if not.
                    // Either way the table we want is the last table in the handle.
                    for (var i = childNodes.length-1; i >= 0; i--) {
                        if (childNodes[i].tagName && 
                            childNodes[i].tagName.toLowerCase() == "table")
                        {
                            bodyTable = childNodes[i];
                            break;
                        }
                    }
                    
                    // today/cancel button cells are in the last row of the table
                    var lastRow = bodyTable.rows[bodyTable.rows.length-1],
                        cells = lastRow.cells;
                    for (var i = 0; i < cells.length; i++) {
                        if (this.getInteriorLocator(cells[i]) == locatorString) {
                            return cells[i];
                        }
                    }
                    
                } else {
                    
                    // Other buttons show up in the header table
                    if (!this.showHeader) {
                        this.logWarn("DateChooser attempting to locate element for " + locatorArray +
                          " but this.showHeader is false so this element will not be present. " +
                          "Returning handle.", "AutoTest");
                        return handle;
                    }
                    
                    var headerTable;
                    // we show two tables if the header is showing, so grab the first table in the
                    // childNodes array
                    for (var i = 0; i < childNodes.length; i++) {
                        if (childNodes[i].tagName && 
                            childNodes[i].tagName.toLowerCase() == "table") 
                        {
                            headerTable = childNodes[i];
                            break;
                        }
                    }
                    if (headerTable) {
                        // controls show up in the first row of cells
                        var row = headerTable.rows[0],
                            cells = row.cells;
                        for (var i = 0; i < cells.length; i++) {
                            if (this.getInteriorLocator(cells[i]) == locatorString) {
                                return cells[i];
                            }
                        }
                    }
                }

            // Date Buttons. Only releveant if we're showing the date in question!
            } else {
                // If we're showing a different year, obviously we're not showing the date button
                var year = locatorArray[0],
                    month = locatorArray[1],
                    date = locatorArray[2];
                // month may differ but only for the few 'spillover' days at the beginning/end
                // of the week - so if the month is off by more than one we're not showing the
                // button
                if ((year == this.year) &&
                        (this.month == month || this.month == month+1 || this.month == month-1))
                {
                    // We could iterate through all the visible buttons looking at locators and
                    // see if they match, or we could figure out the rowNum/colNum in which
                    // the date will be showing (if it is) and pick the cell that way.
                    // We'll take the second approach
                    var buttonDate = isc.DateUtil.createLogicalDate(year,month,date),
                        buttonDay = buttonDate.getDay(),
                        cell = this.dateGrid.getDateCell(buttonDate)
                    ;
                    
                    if (cell) {
                        return this.dateGrid.body._getTableElementAndLogFailure(locatorArray,
                                                                                cell.rowNum, 
                                                                                cell.colNum);
                    }

                } else {
                    this.logInfo("DateChooser passed ID for the wrong year or month - passed:" + 
                        locatorArray + ", showing:" + [this.year,this.month], "AutoTest");
                }
                
                this.logWarn("DateChooser - passed inner locator for date (" +
                            locatorArray.join("/") + ") -- not currently showing this date.",
                            "AutoTest");
            }
                        
            this.logWarn("DateChooser, unable to find element for inner locator:"+
                locatorArray + " returning handle");
            return handle;
        }
    });
}

},


applyGridsMethods : function () {

if (isc.GridRenderer) {
    
    isc.GridRenderer.addProperties({
        // generate some helpful text indicating the GridRenderer's valid row and column ranges
        _getValidIndicesText : function gridRenderer__getValidIndices (includeColumns) {
            var result = "; valid row indices are [0, " + this.getTotalRows() + "]";
            if (includeColumns) {
                result += " and valid column indices for the " + this.getScClassName() +
                    " are [0, " + this.fields.length + "]";
            }
            return result;
        },

        // wrap getTableElement() to log any case where a null DOM element is returned
        _getTableElementAndLogFailure : function gridRenderer__getTableElementAndLogFailure
        (locatorArray, rowNum, colNum) 
        {
            var element = this.getTableElement(rowNum, colNum);
            if (element != null) {
                locatorArray = locatorArray.slice(-1);
                // support simple element part (without partID)
                if (locatorArray.length == 1) {
                    element = isc.Element.findAttribute(element, 
                                  this._$eventPart, locatorArray[0]) || element;
                }
                return element;
            }

            var undef, content, name;
            if (colNum !== undef) {
                content = "(" + rowNum + ", " +  colNum + ")";
                name = "position";
            } else {
                content = rowNum;
                name = "row";
            }

            var guidance = this._getValidIndicesText(colNum !== undef);

            // if the indices are not literals from the locator, display the locatorArrray
            if (rowNum < 0 || colNum < 0) {
                content += ", derived from the locator suffix '" + locatorArray.join("/") + "',";
                if (colNum < 0) {
                    guidance = "; a negative colNum may indicate a field could not be found";
                } else {
                    guidance = "; a negative rowNum may indicate the targeted record is " + 
                               "not present, perhaps not yet loaded";
                }
            }

            this.setLogFailureText(true, content + " does not represent a valid " + name +
                                   " within", guidance);
            if (this.grid) this.grid._testReplayDumpRows();

            return null;
        },

        // report that the row/column locator suffix could not be parsed properly
        _reportInvalidCellLocator : function gridRenderer__reportInvalidCellLocator
        (locatorArray, rowNum, colNum)
        {
            var undef, finish,
                start = "the locator suffix '" + locatorArray.join("/") +"' could not be " +
                        "resolved to a numerical";

            if (colNum !== undef) {
                start += " row and column position within";
                finish = "; only able to resolve to (" + rowNum + ", " + colNum + ")";
            } else {
                start += " row position within";
                finish = "; detected row as " + rowNum;
            }
            this.setLogFailureText(true, start, finish);
            if (this.grid) this.grid._testReplayDumpRows();
        },

        getInteriorLocator : function gridRenderer_getInteriorLocator (element, fromEvent) {
            var cell = this.getCellFromDomElement(element);
            if (cell == null) return this.Super("getInteriorLocator", [element, fromEvent]);
            
            var rowNum = cell[0], colNum = cell[1],
                locator = this.getCellLocator(rowNum, colNum);
            // attach a drop position to the end of the locator to specify where to drop
            if (locator != null && this.grid != null) {
                if (this == isc.EH.dropTarget) {
                    var dropPosition = this.grid.getRecordDropPosition(rowNum);
                    if (dropPosition != null) locator += "/" + dropPosition;
                } else {
                    var isValueIcon = false;
                    var parentNode = element.parentNode;
                    while (parentNode && element != cell) {
                        if (element.getAttribute && 
                            (element.getAttribute("eventpart") == "valueicon")) 
                        {
                            isValueIcon = true;
                            break;
                        }
                        element = parentNode;
                        parentNode = parentNode.parentNode;
                    }
                    if (isValueIcon) {
                        locator += "/valueicon";
                    }
                }
            }
            return locator;
        },
        
        //> @method gridRenderer.getCellFromDomElement() [A]
        // Given a pointer to an element in the DOM, this method will check whether this
        // element is contained within a cell of the gridRenderer, and if so return a
        // 2 element array denoting the <code>[rowNum,colNum]</code> of the element
        // in question.
        // @param element (DOMElement) DOM element to test
        // @return (Array) 2 element array containing rowNum and colNum, or null if the
        //   element is not contained in any cell in this gridRenderer
        // @group autoTest
        // @visibility external
        //<
        getCellFromDomElement : function gridRenderer_getCellFromDomElement (element) {
            var handle = this.getHandle(),
                table = this.getTableElement();
                
            if (!table) return null;
                
            var rows = table.rows,
                tagName,
                row, cell,
                tr = "tr", TR = "TR",
                td = "td", TD = "TD";
            
            while (element && element != table && element != handle) {
                
                tagName = element.tagName;           
                // document whether it's upper / lower case by default
                if (tagName == td || tagName == TD) {
                    cell = element;
                }
                
                // document whether it's upper / lower case by default
                if (tagName == tr || tagName == TR) {
                    row = element;
                }
                // keep going in case there are nested tables, etc
                element = element.parentNode;
            }
            if (!row || !cell) return null;
            
            var rows = table.rows, rowNum, logicalRowNum;
            for (var i = 0; i < rows.length; i++) {
                if (rows[i] == row) {
                    rowNum = i;
                    break;
                }
            }
            var cells = row.cells, colNum, logicalColNum;
            for (var i = 0; i < cells.length; i++) {
                if (cells[i] == cell) {
                    colNum = i;
                    break;
                }
            }

            
            if (isc.HeaderGrid && isc.isA.HeaderGrid(this)) {
                if (rows[0] != row) colNum += rows[0].cells.length - cells.length;
            }

            logicalRowNum = rowNum + (this._firstDrawnRow || 0);
            logicalColNum = colNum + (this._firstDrawnCol || 0);
            
            return [logicalRowNum,logicalColNum];
        },
        
        getCellLocator : function gridRenderer_getCellLocator (rowNum, colNum) {
            return "row[" + rowNum + "]/col[" + colNum + "]";
        },

        getInnerAttributeFromSplitLocator : function
            gridRenderer_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            var attribute = configuration.attribute;
            if (attribute == isc.Canvas._$Element ||
                attribute == isc.Canvas._$Selected ||
                attribute == isc.Canvas._$Record || 
                attribute == isc.Canvas._$Field)
            {

                if (this.emptyLocatorArray(locatorArray)) {
                    return isc.AutoTest.getAttributeDefault(this, attribute);
                }
                
                // Format should be [row[index], col[index]] with optional trailing part
                if (locatorArray.length >= 2) {
                    var cell = this.getCellFromLocator(locatorArray[0], locatorArray[1]),
                        rowNum = cell[0], colNum = cell[1];

                    if (isc.isA.Number(rowNum) && isc.isA.Number(colNum)) {
                        // check for record
                        if (attribute == isc.Canvas._$Record) {
                            return this.getCellRecord(rowNum, colNum);
                        }
                        // check selection state of cell
                        if (attribute == isc.Canvas._$Selected) {
                            return this._isSelected(rowNum, colNum);
                        }
                        
                        if (attribute == isc.Canvas._$Field) {
                            return this.getField(colNum);
                        }
                        
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (this._suppressEventHandling()) {
                            this.setLogFailureText(true, null, "is being animated");
                            return null;
                        }
                        return this._getTableElementAndLogFailure(locatorArray, rowNum, colNum);
                    } else {
                        this._reportInvalidCellLocator(locatorArray, rowNum, colNum);
                    }
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        // assumes rowLocator is row[rowNum]
        // colLocator is col[colNum]
        getCellFromLocator : function gridRenderer_getCellFromLocator (rowLocator, colLocator) {
            // This is a straight parse - to support being passed a fuller format and
            // just extracting the index, if present, we'd want to have 
            // AutoTest.parseFallbackLocator run and then extract the standalone field value
            // knowing that's an index.
            var rowString = rowLocator.replace(/^row.*(?:\|\||\[)([0-9]+)\]$/, "$1"),
                colString = colLocator.replace(/^col.*(?:\|\||\[)([0-9]+)\]$/, "$1");
            return [parseInt(rowString), parseInt(colString)];
        },

        _isProcessingDone : function gridRenderer__isProcessingDone (strictMode, includeEdits)
        {
            var checkGrid = this.grid && !strictMode;
            if (checkGrid) return this.grid._isProcessingDone(false, includeEdits);
            else return this.Super("_isProcessingDone", arguments);
        }
    });

}
if (isc.ListGrid) {
    isc.ListGrid.addProperties({
        //> @attr listGrid.remapOverRecordPositionAs (RecordDropAppearance : isc.ListGrid.AFTER : [IRW])
        // If during Selenium playback, we encounter an "over" drop position, but
        // this is not allowed based on +link{listGrid.recordDropAppearance}, then what
        // drop position should it be remapped to?
        //<
        remapOverRecordPositionAs: isc.ListGrid.AFTER

    });
      
      
    // We want to handle identifying cells by fieldName, record primary key etc as well
    // as simple rowNum / colNum.
    // We also need to handle the fact that with the option to freeze fields we can end up
    // with a logical cell that was in one sub-component (the frozen body, say)
    // is now in another (the standard body).
    
    // Implementation:
    // - when generating the Locator string include 'body' / 'frozenBody' as normal but
    //   have getCellLocator overridden in gridBody to record information about the fieldName etc
    //   as well as simple rowNum / colNum
    // - when parsing Locator strings, have the listGrid catch the case where we'd usually
    //   pass through to the body and handle it directly - figuring out which body the
    //   cell is in, and calling 'getTableElement()' on that
  
    isc.GridBody.addProperties({
  
        // override 'getInteriorLocator()' -- if an event occurred over an embedded component such
        // as a rollOverCanvas with eventProxy pointing back to us, we can't rely on the
        // DOM element
        // In the case where we're getting a locator from the event actually handle this by getting
        // coordinates from the event
        
        getInteriorLocator : function gridBody_getInteriorLocator (element, fromEvent) {
            if (fromEvent) {
                var children = this.children;
                if (children != null && children.length > 0) {
                    for (var i = 0; i < children.length; i++) {
                        var child = children[i];
                        if (child && child.eventProxy == this) {
                            var handle = child.getHandle();
                            if (handle != null) {
                                var testElement = element;
                                while (testElement != this.getHandle() && testElement != null) 
                                {
                                    if (testElement == handle) {
                                        var rowNum = this.getEventRow(),
                                            colNum = this.getEventColumn();
                                        return this.getCellLocator(rowNum,colNum);
                                        
                                    }
                                    testElement = testElement.parentNode;
                                }
                            }
                        }
                    }
                }
            }
            return this.Super("getInteriorLocator", arguments);
        },
        getAutoTestLocatorRect : function gridBody_getAutoTestLocatorRect (locator, element)
        {
            var rect = this.Super("getAutoTestLocatorRect", arguments);
            if (rect == null) return null;

            var grid = this.grid,
                locatorArray = locator.split("/").slice(-3),
                dropPosition = locatorArray[2];
                
            if (grid._isValidDropPosition(dropPosition)) {
                var rowNum = grid.getRowNumFromLocator(locatorArray, 0);

                if (isc.isA.Number(rowNum)) {
                    
                    if (dropPosition == isc.ListGrid.OVER &&
                        grid.recordDropAppearance != isc.ListGrid.OVER &&
                        grid.recordDropAppearance != isc.ListGrid.BOTH)
                    {
                        var newPosition = grid.remapOverRecordPositionAs,
                            remap = grid._isValidDropPosition(newPosition);
                        if (isc.TreeGrid && isc.isA.TreeGrid(grid)) {
                            var node = grid.getRecord(rowNum);
                            if (grid.canDropOnLeaves || grid.data.isFolder(node)) {
                                remap = false;
                            }
                        }
                        if (remap) dropPosition = newPosition;
                    }

                    var recordTop    = this.getRowTop(rowNum),
                        recordHeight = this.getRowSize(rowNum);
                    
                    switch(dropPosition) {
                    case isc.ListGrid.BEFORE:
                        rect[3] -= Math.round(recordHeight/2);
                        break;
                    case isc.ListGrid.AFTER:
                        rect[1] += Math.round(5*recordHeight/8);
                        rect[3] = Math.ceil(recordHeight/8);
                        break;
                    }
                }
            }
            return rect;
        },
        
        getCellLocator : function gridBody_getCellLocator (rowNum, colNum) {
            var grid = this.grid;
            if (grid == null) return this.Super("getCellLocator", arguments);
            return grid.getCellLocator(this, rowNum, colNum);
        }
              
    });
    
    isc.ListGrid.addProperties({

        

        testReplayLoggedRows: 50,
        _testReplayDumpRows : function listGrid__testReplayDumpRows () {
            if (!isc.Log.logIsDebugEnabled("testReplay") || !isc.JSON) return;

            var nRows = Math.min(this.testReplayLoggedRows, this.getTotalRows()),
                result = "The first " + nRows + " rows of " + this._getDescription() +
                         " are: \n";

            for (var i = 0; i < nRows; i++) {
                result += "#" + (i + 1) + ": " + isc.JSON.encode(this.getRecord(i)) + "\n";
            }
            isc.AutoTest.logDebug(result.trim(), "testReplay");
        },

        // getCellLocator -- called by the grid body to generate the identifier
        getCellLocator : function listGrid_getCellLocator (body, rowNum, colNum) {
            if (this._isNewRecordRow(rowNum)) return "newRecordRow";
            var rowLocatorOptions = this.getRowLocatorOptions(body, rowNum, colNum),
                colLocatorOptions = this.getColLocatorOptions(body, rowNum, colNum);
            return isc.AutoTest.createLocatorFallbackPath("row", rowLocatorOptions) +
                    "/" + isc.AutoTest.createLocatorFallbackPath("col", colLocatorOptions);
        },
        
        // builds a config type object that we'll pass to createLocatorFallbackPath
        getRowLocatorOptions : function listGrid_getRowLocatorOptions (body, rowNum, colNum) {
            var locatorOptions = {},
                gridColNum = this.getFieldNumFromLocal(colNum, body),
                record = this.getEditedRecord(rowNum, gridColNum),
                ds = this.getDataSource(true);

            if (record != null) {
                if (ds != null) {
                    var pks = ds.getPrimaryKeyFieldNames();
                    for (var i = 0; i < pks.length; i++) {
                        var pk = pks[i];
                        if (record[pk] != null) {
                            locatorOptions[pk] = record[pk];
                        }
                    }
                }
                
                var titleField = this.getTitleField();
                if (titleField != null && record[titleField] != null) {
                    locatorOptions[titleField] = record[titleField];
                } else if (isc.isA.Tree(this.data)) {
                    var title = record[this.data.titleProperty];
                    if (title != null) locatorOptions[this.data.titleProperty] = title;
                }
                var targetFieldName = this.getFieldName(gridColNum);
                if (targetFieldName != null && record[targetFieldName] != null) {
                    locatorOptions[targetFieldName] = record[targetFieldName];
                }

                // Handle 'rowLocatorField' if set. Support this being an array or a single field
                var fields = this.rowLocatorField;
                if (fields != null) {
                    if (!isc.isA.Array(fields)) [fields]; 
                    for (var i = 0; i < fields.length; i++) {
                        var fieldName = fields[i];
                        if (fieldName == targetFieldName || fieldName == titleField || 
                            pks && pks.contains(fieldName) || record[fieldName] == null) 
                        {
                            continue;
                        }
                        locatorOptions[fieldName] = record[fieldName];
                    }
                }

            }
            // also store the rowNum
            locatorOptions[isc.AutoTest.fallback_valueOnlyField] = rowNum;
            return locatorOptions;
        },
        
        getColLocatorOptions : function listGrid_getColLocatorOptions (body, rowNum, colNum) {
            var locatorOptions = {},
                gridColNum = this.getFieldNumFromLocal(colNum, body);
            var field = this.getField(gridColNum);
            if (this.isCheckboxField(field)) {
                locatorOptions.isCheckboxField = true;
            } else {
                var fieldName = this.getFieldName(gridColNum);
                if (fieldName != null) locatorOptions.fieldName = fieldName;
            }
            locatorOptions[isc.AutoTest.fallback_valueOnlyField] = colNum;
            return locatorOptions;  
            
        },
        
        
        // if the child substring is "frozenBody' / "body", return null - we'll handle
        // finding the element at the ListGrid level
        getChildFromLocatorSubstring : function listGrid_getChildFromLocatorSubstring (
            substring, index, locatorArray)
        {
            if (substring == "frozenBody" || substring == "body") {
                // use a switch statement with fall through to validate all locator pieces
                switch (locatorArray.length - index) {
                case 4:
                    if (locatorArray[index+3] != "valueicon" &&
                        !this._isValidDropPosition(locatorArray[index + 3])) break;
                case 3:
                    if (!locatorArray[index + 2].startsWith("col[")) break;
                case 2:
                    if (!locatorArray[index + 1].startsWith("row[") &&
                         locatorArray[index + 1] != "newRecordRow")
                    {
                        break;
                    }
                    return null;
                }
            }
            return this.Super("getChildFromLocatorSubstring", arguments);
        },
        
        getRowNumFromLocator : function listGrid_getRowNumFromLocator (locatorArray, index) {
            // return the "new record row" if it's explicitly declared in the locator array!
            if (this.shouldShowNewRecordRow() && locatorArray[index] == "newRecordRow") {
                return this.getTotalRows() - 1;
            }
            // We're looking for an individual row
            var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(locatorArray[index]);
            if (rowLocatorConfig.name != "row") {
                this.logWarn("Error parsing locator: " + locatorArray.join("/") +
                             "; unable to resolve the row");
                return null;
            }
            return this.getRowNumFromLocatorConfig(rowLocatorConfig.config);
        },

        // Override getInnerAttributeFromSplitLocator to handle cells in the body/frozenBody
        getInnerAttributeFromSplitLocator : function listGrid_getInnerAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            var attribute = configuration.attribute,
                emptyValue   = isc.AutoTest.getAttributeDefault(null, attribute),
                defaultValue = isc.AutoTest.getAttributeDefault(this, attribute);

            if (this.emptyLocatorArray(locatorArray)) {
                return isc.AutoTest.setLogFailureForReturnValue(this, locatorArray, 
                                                                defaultValue, attribute);
            }

            // expected format: "frozenBody", row[...], col[...]"
            var body = locatorArray[0];
            if (body == "body" || body == "frozenBody") {
                var suffix = locatorArray[3],
                    dropPosition;
                var isValueIcon = false;
                if (suffix == "valueicon") isValueIcon = true;
                else dropPosition = suffix;
                if (locatorArray.length == 2 && attribute == isc.Canvas._$Element) {

                    var rowNum = this.getRowNumFromLocator(locatorArray, 1);
                    if (rowNum == null) return defaultValue;

                    if (isc.isA.Number(rowNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (this.body._suppressEventHandling()) {
                            this.body.setLogFailureText(true, null, "is being animated");
                            return emptyValue;
                        }
                        return this.body._getTableElementAndLogFailure(locatorArray, rowNum);
                    }

                } else if (locatorArray.length == 2 && attribute == isc.Canvas._$Record) {

                    var rowNum = this.getRowNumFromLocator(locatorArray, 1);
                    if (rowNum == null) {
                        if (attribute == isc.Canvas._$Element) this.setLogFailureText(true,
                            "locator suffix  '" + locatorArray.join("/") + "' does not " +
                            "identify a valid row within");
                        return defaultValue;
                    }

                    var body = this.body;

                    if (isc.isA.Number(rowNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (body._suppressEventHandling()) {
                            body.setLogFailureText(true, null, "is being animated");
                            return emptyValue;
                        }

                        var record = this.getRecord(rowNum);
                        if (record == null) {
                            this.setLogFailureText(true, "no record could be found" +
                                                (field != null ? 
                                                    (" for field " + field.name + " and ") : " for ")
                                                 + "row " +
                                                rowNum + " in grid " + this);
                        }
                        return record;
    
                    } else {
                        body._reportInvalidCellLocator(locatorArray, rowNum);
                    }

                } else if (locatorArray.length == 3 && attribute == isc.Canvas._$Field) {
                    var field = this.getFieldFromLocator(locatorArray, 2, body, attribute);
                    if (field == null) return defaultValue;

                    return field;

                } else if (locatorArray.length == 3 ||
                           (locatorArray.length == 4 && 
                            (isValueIcon || this._isValidDropPosition(dropPosition))))
                {

                    var field = this.getFieldFromLocator(locatorArray, 2, body, attribute),
                        localColNum = this.getLocalFieldNum(this.getFieldNum(field)); 
                    
                    if (this.fieldIsFrozen(field)) body = this.frozenBody;
                    else                           body = this.body;

                    // Bail if we haven't created the right body for some reason
                    
                    if (body == null) {
                        this.setLogFailureText(true, "there was a problem locating the " +
                            "correct GridBody for field " + field.name + " using column " +
                            "locator '" + locatorArray[2] + "' within", ", this field seems " +
                            "to be" + (this.fieldIsFrozen(field) ? " " : " not ") + "frozen");
                        return emptyValue;
                    }
                    
                    // At this point we know what body it's in and what the colNum is within that
                    // body.
                    // Now find the row
                    
                    var rowNum = this.getRowNumFromLocator(locatorArray, 1);
                    if (rowNum == null) {
                        if (attribute == isc.Canvas._$Element) this.setLogFailureText(true,
                            "locator suffix  '" + locatorArray.join("/") + "' does not " +
                            "identify a valid row within");
                        return defaultValue;
                    }

                    var bodyName = body == this.frozenBody ? "frozen GridBody" : "GridBody";

                    if (isc.isA.Number(rowNum) && isc.isA.Number(localColNum)) {
                        // We suppress all events on row/cols during row animation
                        // in this case suppress the element entirely so auto-test engines
                        // don't attempt to fire events on them.
                        
                        if (body._suppressEventHandling()) {
                            body.setLogFailureText(true, null, "is being animated");
                            return emptyValue;
                        }

                        switch (attribute) {
                        case isc.Canvas._$Element:                       
                            var cell = body._getTableElementAndLogFailure(locatorArray, 
                                                                      rowNum, localColNum);
                            if (cell && isValueIcon) {
                                // querySelectorAll is supported in all browsers since IE8
                                if (cell.querySelectorAll) {
                                    var candidates = cell.querySelectorAll("[eventpart=valueicon]");
                                    if (candidates.length == 1) return candidates[0];
                                }
                                this.logWarn("Locator specified click event on value icon but " +
                                    "unable to find valueIcon element for this cell - " +
                                    "recorded test may be invalid.", "AutoTest");
                            }
                            return cell;
                        case isc.Canvas._$Value:
                        case isc.Canvas._$Selected:
                        case isc.Canvas._$Record:
                            var fieldNum = this.getFieldNumFromLocal(localColNum, body),
                                field = this.getField(fieldNum);
                            if (field != null) {
                                var record = this.getEditedRecord(rowNum, fieldNum);
                                if (record == null) {
                                    this.setLogFailureText(true, "no record could be found " +
                                                       "for field " + field.name + " and row " +
                                                       rowNum + " in");
                                    break;
                                }
                                // check for record
                                if (attribute == isc.Canvas._$Record) {
                                    // Get actual record to return
                                    return this.getCellRecord(rowNum, fieldNum);
                                }
                                // check selection state of record or cell
                                if (attribute == isc.Canvas._$Selected) {
                                    return this._isSelected(rowNum, fieldNum, record);
                                }
                                if (field._isCheckboxField) return this.isSelected(record);
                                
                                if (field._standardMenuIconField === true) {
                                    return !!record.checked;
                                }
                                
                                return this.getRawCellValue(record, rowNum, fieldNum);
                            } else {
                                this.setLogFailureText(true, "no field could be found for " +
                                    "column " + localColNum + " within the " + bodyName + " of");
                            }
                        }
                    } else {
                        body._reportInvalidCellLocator(locatorArray, rowNum, localColNum);
                    }
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        getFieldFromLocator : function listGrid_getFieldFromLocator(locatorArray, index, body,
                                                                    attribute)
        {
            var colLocator = locatorArray[index],
                colLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(colLocator),
                emptyValue = isc.AutoTest.getAttributeDefault(null, attribute)
            ;

            // colLocatorConfig will have name:"col", config:{config object}
            // The 'getChildFromLocatorSubstring() method already checks for this but
            // as a sanity check verify the name of the col locator
            if (colLocatorConfig.name != "col") {
                this.logWarn("Error parsing locator:" + locatorArray.join("") + 
                    " returning ListGrid handle");
                return null;
            }
                
            var field = this.getFieldFromColLocatorConfig(colLocatorConfig.config);
            // If no fieldName stored, use the previous colNum instead
            // [we stored the colNum relative to the body in question]
            
            if (body != null && field == null /*|| !isc.isAn.Object(field)*/) {
                if (body == "frozenBody" && this.frozenBody == null) {
                    this.setLogFailureText(true, "the column locator '" + colLocator +
                    "' is specified on a frozen body but", "has none");
                    return emptyValue; // locator is not valid
                }
                var localColNum = parseInt(colLocatorConfig.
                                           config[isc.AutoTest.fallback_valueOnlyField]);
                if (isc.isA.Number(localColNum) && localColNum < this.getTotalCols()) {
                    // pick out the right field from the body or frozenBody using localColNum
                    var offset, frozenCols = this.frozenFields ? this.frozenFields.length : 0;
                    if (body == "frozenBody" && localColNum < frozenCols) {
                        offset = this.freezeStart() ? 0 : this.getTotalCols() - frozenCols;
                    } else if (localColNum < this.getTotalCols() - frozenCols) {
                        offset = this.freezeStart() ? frozenCols : 0;
                    }
                    if (offset != null) field = this.getField(offset + localColNum);
                }
            }
            return field;
        },
        

        // helper to pick up field based on 'checkboxField' status and name
        // If neither work, we will use field num instead
        getFieldFromColLocatorConfig : function listGrid_getFieldFromColLocatorConfig (colConfig) {
            //this.logWarn("colConfig:" + this.echo(colConfig));
            if (colConfig.isCheckboxField != null) {
            
                for (var i = 0; i < this.fields.length; i++) {
                    if (this.isCheckboxField(this.fields[i])) {
                        return this.fields[i];
                    }
                    // In this case we didn't find a checkbox field - test is probably
                    // invalid
                    this.logWarn("AutoTest stored a locator for interaction with " +
                            "checkbox field - but this grid is not showing a checkbox field - " +
                            "recorded test may be invalid.", "AutoTest");
                    // returning -1 here - this causes use to not return some other random
                    // unrelated cell (typically the first column in the grid)
                    return -1;
                }
            } else {
       
                var locateColsBy = this.locateColumnsBy;
                //locateColsBy will be one of ("fieldName", "index")    
    
                if (locateColsBy == "fieldName" || locateColsBy == null) {
                    var fieldName = colConfig.fieldName;
                    if (fieldName != null) {
                        return this.getField(fieldName);
                    }
                }
            }
        },
        
        getRowNumFromLocatorConfig : function listGrid_getRowNumFromLocatorConfig (rowConfig) {

            // this.logWarn("rowConfig:" + this.echo(rowConfig));
            var locateRowsBy = this.locateRowsBy;
       
            if (locateRowsBy == null) locateRowsBy = "primaryKey";
            var data = this.data,
                bestGuess;
            // Flatten trees to an array - this allows us use the Array version of findAllMatching...
            // that takes a comparitor argument
            //
            if (isc.isA.Tree(data)) {
                data = data.getOpenList();
            }

            // NOTE: This switch statement does not break after each case
            // by setting 'locateRowsBy' to primaryKey for example, 
            // we still check the other strategies as a fallback, if the locator contained that data
            switch(locateRowsBy) {
                case "primaryKey":
                    this.logDebug("Trying to locate row by pk", "autotest");
                    //this.logWarn("rowConfig: " + isc.Comm.serialize(rowConfig));
                    var ds = this.getDataSource();
                    if (ds != null) {
                        var pkFields = ds.getPrimaryKeyFieldNames(),
                            allKeys = pkFields.length > 0;
                        for (var i = 0; i < pkFields.length; i++) {
                            if (rowConfig[pkFields[i]] == null) {
                                allKeys = false;
                                break;
                            }
                        }
                        if (allKeys) {
                            var rowNum = this.findRowNum(rowConfig);
                            if (rowNum != -1) {
                                this.logDebug("Located row " + rowNum + " by pk", "autotest");
                                return rowNum;
                            }
                        }
                    }
                    this.logDebug("Failed to locate row by pk.  Config: " +
                                  isc.echoAll(rowConfig), "autotest");
                    // don't break - if we were unable to use PK, fall back through
                    // titleField / cell value before index
        
                    // NOTE: The skipFallback property is an internal flag to ensure that the
                    // row is located by primary key, or not at all.  The primary motivation 
                    // for adding it is to enable automated testing of the PK functionality; 
                    // for that, we have to be certain that the element was located by 
                    // primaryKey and not some fallback strategy
                    if (isc.AutoTest.skipFallback) return -1;
                        
                case "titleField":
                    // this.logWarn("trying to locate by title field");
                    var titleField = this.getTitleField();
                    if (titleField != null && rowConfig[titleField] != null) {
                        var matches = data.findAllIndices(titleField, rowConfig[titleField],
                            isc.AutoTest._compareLocatorFallbackConfigValues);
                        if (matches.length == 0) return -1;
                        if (matches.length == 1) return matches[0];
                        // Ambiguous - fall through to fallback mechanisms, but first
                        // "sparse-up" the data array so we limit to valid matches!
                        var sparseData = [];
                        for (var i = 0; i < matches.length; i++) {
                            sparseData[matches[i]] = data.get(matches[i]);
                        }
                        bestGuess = matches[0];
                        data = sparseData;
                    }
                
                case "cellValue":
                    var fields = this.rowLocatorField;
                    if (fields != null && !isc.isA.Array(fields)) fields = [fields];
                    if (fields) {
                        var matches;

                        for (var currentFieldIndex = 0; currentFieldIndex < fields.length; currentFieldIndex++) {
                            var field = fields[currentFieldIndex];

                            if (rowConfig[field] != null) {
                                var fieldMatches = data.findAllIndices(field, rowConfig[field],
                                    isc.AutoTest._compareLocatorFallbackConfigValues); 
                                
                                if (matches == null) matches = fieldMatches;
                                else {
                                    // We're only interested in matches for all specified fields - filter
                                    // out anything we haven't seen before
                                    matches = fieldMatches.filter(function (index) {return matches.contains(index)});
                                }
                            
                                // We're looking for a match on all these fields
                                // If we don't find one value, bail.
                                if (matches.length == 0) return -1;
                            }
                        }

                        if (matches.length == 1) return matches[0];
                        bestGuess = matches[0];

                        // Still ambiguous (multiple matches found): fall back to target cell value
                        // "Sparse Up" the array...
                        var sparseData = [];
                        for (var i = 0; i < matches.length; i++) {
                            sparseData[matches[i]] = data.get(matches[i]);
                        }
                        data = sparseData;
                    }
                    
                case "targetCellValue":
                    //this.logWarn("trying to locate by target");
                    // Assertion: In this case, there was no titleField or primary key
                    // on the config object.
                    // This relies on the fact that we wouldn't store "null"s on that object
                    // when creating the locator options.
                    // ... or: we found multiple matches and need to disambiguate them
                    // All that's left is the original index under the fallback_valueOnlyField
                    // array and the target row cell value
                    for (var fieldName in rowConfig) {
                        if (fieldName == isc.AutoTest.fallback_valueOnlyField) continue;
                        
                        if (rowConfig[fieldName] != null) {
                            var matches = data.findAllIndices(fieldName, rowConfig[fieldName],
                                              isc.AutoTest._compareLocatorFallbackConfigValues);
                            if (matches.length == 0) return -1;
                            if (matches.length == 1) return matches[0];
                            var sparseData = [];
                            for (var i = 0; i < matches.length; i++) {
                                sparseData[matches[i]] = data.get(matches[i]);
                            }
                            bestGuess = matches[0];
                            data = sparseData;
                        }
                    }
                default: 
                    //this.logWarn("locate by rowNum");
                    // Final fallback option- original rowNum as stored
                    // Technically this is locateRowsBy "index"
                    // however if titleField / targetCellValue was ambiguous, this may also
                    // be hit with a sparse array of possible matches.
                    var rowNum = parseInt(rowConfig[isc.AutoTest.fallback_valueOnlyField]);
                    var undef;
                    if (bestGuess == null || data[rowNum] !== undef) return rowNum;
                    
                    else return bestGuess;
            }
        },

        _isValidDropPosition : function listGrid__isValidDropPosition (dropPosition) {
            switch (dropPosition) {
            case isc.ListGrid.BEFORE:
            case isc.ListGrid.AFTER:
            case isc.ListGrid.OVER:
                return true;
            }
            return false;
        },

        _isProcessingDone : function listGrid__isProcessingDone (strictMode, includeEdits) {
            
            if (isc.RecordEditor && isc.isA.RecordEditor(this)) includeEdits = false;
            if (isc.AutoTest.isGridDone(this, includeEdits) == false) return false;
            return this.Super("_isProcessingDone", arguments);
        }
    });
}
if (isc.Menu) {

isc.Menu.addClassMethods({


getMenuAtLevel : function (level) {
    var openMenus = isc.Menu._openMenus || [],
        menuAtLevel = openMenus.find("_parentMenu", null);
    if (menuAtLevel == null) return null;

    for (var i = 0; i < level; i++) {
        menuAtLevel = menuAtLevel._open_submenu;
        if (menuAtLevel == null) {
            this.logInfo("Unable to locate active menu at level " + level +
                         " - returning null");
            return null;
        }
    }
    return menuAtLevel;
}

});

isc.Menu.addMethods({

_menuLocatorTemplate: [
"//Menu[level=",
,   // menu level
"]"
],
getLocatorRoot : function menu_getLocatorRoot() {
    if (!this.locatorRoot) this.locatorRoot = this._getLocatorRoot();
    return this.locatorRoot;
},

_getLocatorRoot : function menu__getLocatorRoot() {
    // where a stable ID is present, give that preference for simplicity
    if (this.hasStableID()) return this.Super("_getLocatorRoot", arguments);

    // otherwise, create a level-based locator since only one menu hierarchy can be open
    var level = 0;
    for (var menu = this; menu && menu._parentMenu; menu = menu._parentMenu) level++;
    this._menuLocatorTemplate[1] = level;
    return this._menuLocatorTemplate.join(isc.emptyString);
},

// Override getObjectLocator to handle being passed a menuItem
getObjectLocator : function menu_getObjectLocator (target) {
    if (isc.isAn.Object(target)) {
        var rowNum = this.getRecordIndex(target);
        if (rowNum != null) {
            var rowLocatorOptions = this.getRowLocatorOptions(this.body, rowNum),
                rowLocator = isc.AutoTest.createLocatorFallbackPath("row", rowLocatorOptions) +
                    "/objectType=MenuItem";
            ;
            return rowLocator;
        }
    }
    return this.Super("getObjectLocator", arguments);
},

getAttributeFromSplitLocator : function menu_getAttributeFromSplitLocator (locatorArray,
        configuration) 
{    
    var attribute = configuration.attribute;

    if (isc.Canvas._$Object == attribute && locatorArray[locatorArray.length-1] == "objectType=MenuItem") {
        var rowConfig = isc.AutoTest.parseLocatorFallbackPath(locatorArray[0]);
        if (rowConfig && rowConfig.name == "row" && rowConfig.config != null) {
            var config = rowConfig.config,
                rowNum = this.getRowNumFromLocatorConfig(config)
            ;
            if (rowNum != null) {
                return this.getRecord(rowNum);
            }
        }
    }

    return this.Super("getAttributeFromSplitLocator", arguments);
},

// Override getRowLocatorOptions / getRowNumFromLocatorConfig to pick up the result of getItemTitle()

getRowLocatorOptions : function menu_getRowLocatorOptions (body, rowNum, colNum) {
    var locatorOptions = this.Super("getRowLocatorOptions", arguments);
    var gridColNum = this.getFieldNumFromLocal(colNum, body),
        record = this.getEditedRecord(rowNum, gridColNum),
        ds = this.getDataSource(true);

    if (locatorOptions.itemTitle == null && this.getItemTitle) {
        var itemTitle = this.getItemTitle(record);
        if (itemTitle != null && itemTitle != "" && itemTitle != "&nbsp;") {
            locatorOptions.itemTitle = itemTitle;
        }
    }
    return locatorOptions;
},
getRowNumFromLocatorConfig : function menu_getRowNumFromLocatorConfig (rowConfig) {
    if (rowConfig.itemTitle != null) {
        var items = this.data;
        
        if (this.getItemTitle && isc.isAn.Array(items)) {
            var matches = [];
            for (var i = 0; i < items.getLength(); i++) {
                if (this.getItemTitle(items[i]) == rowConfig.itemTitle) {
                    matches.push(i);
                }
            }
            if (matches.length == 1) {
                return matches[0];
            }
        }
    }
    return this.Super("getRowNumFromLocatorConfig", arguments);
}

});

isc.Menu.addProperties({
    // Should this widget's ID be used during scLocator generation?
    hasStableID : function menu_hasStableID () {
        
        var rootMenu = this._rootMenu;
        if (rootMenu != null && this.ID.startsWith(rootMenu.ID)) {
            return rootMenu.hasStableID();
        }
        return this.Super("hasStableID", arguments);
    }
});

}
if (isc.TreeGrid) {
    isc.TreeGridBody.addProperties({
        getOpenAreaWidth : function treeGridBody_getOpenAreaWidth (rowNum, colNum) {
            var grid = this.grid,
                data = grid.data,
                node = grid.getRecord(rowNum);

            // remap colNum relative to TreeGrid's fields
            colNum = grid.getFieldNumFromLocal(colNum, this);

            // fail if field is not the tree field, or we can't determine whether it's a folder
            if (grid.getTreeFieldNum() != colNum || data == null || !data.isFolder(node)) {
                return null;
            }
            return grid.getOpenAreaWidth(node);
        },

        getInteriorLocator : function treeGridBody_getInteriorLocator (element, fromEvent, 
                                                                       coords) 
        {
            var origElement = element;
            
            var grid = this.grid,
                handle = this.getHandle(),
                tableElement = this.getTableElement();

            if (!element || !handle || !tableElement) return isc.emptyString;
            var openAreaPrefix = grid.getCanvasName() + grid._openIconIDPrefix,
                rowNum, colNum;

            // The checkbox icon shows in the "extra icon" slot so
            // we'll have one or the other (not both) and can just store "extraIcon" as an 
            // identifier
            var extraIconPrefix = grid.getCanvasName() + grid._extraIconIDPrefix;

            // optimization - we could duplicate the logic from GR here and avoid
            // double-iterating through the DOM if we're NOT in the open area of the TG.
            while (element != this.tableElement && element != handle && element.getAttribute) {
                // check the "name"/"id" property for the open-icon
                var ID = element.getAttribute(isc.Canvas._generateSpanForBlankImgHTML ? 
                                              "id" : "name");
                if (ID) {
                    if (ID.startsWith(extraIconPrefix)) {
                        rowNum =  parseInt(ID.substring(extraIconPrefix.length));
                        colNum = grid.getLocalFieldNum(grid.getTreeFieldNum());
                        return this.getCellLocator(rowNum,colNum) + "/extra";
                    }
                }
                element = element.parentNode;
            }

            
            var cell = this.getCellFromDomElement(origElement);
            
            if (cell && coords != null) {
                var openAreaWidth = this.getOpenAreaWidth(cell[0], cell[1]);
                if (openAreaWidth != null) {
                    var rect = this.getCellPageRect(cell[0], cell[1]),
                        x = coords[0] - rect[0];
                    if (x >= 0 && x < openAreaWidth) {
                        return this.getCellLocator(cell[0], cell[1]) + "/open";
                    }
                }
            }

            
            return this.Super("getInteriorLocator", [origElement, fromEvent, coords]);
        },

        getInnerAttributeFromSplitLocator : function
            treeGridBody_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            var grid = this.grid,
                attribute = configuration.attribute,
                emptyValue   = isc.AutoTest.getAttributeDefault(null, attribute),
                defaultValue = isc.AutoTest.getAttributeDefault(this, attribute);

            if (this.emptyLocatorArray(locatorArray)) {
                return isc.AutoTest.setLogFailureForReturnValue(this, locatorArray, 
                                                                defaultValue, attribute);
            }

            // Additional Format is: [row[index], col[index], open]
            if (locatorArray.length == 3 && attribute != isc.Canvas._$Selected) 
{
                if (locatorArray[2] == "open") {
                    // We suppress all events on row/cols during row animation
                    // Also suppress toggleFolder event target in this case.
                    
                    if (this._suppressEventHandling()) {
                        this.setLogFailureText(true, null, "is being animated");
                        return emptyValue;
                    }
                    
                    var rowLocator = locatorArray[0];
                    var rowNum;
                    
                    //   old format was row3
                    // new format is a standard row locator like
                    //   row[pkFieldValue=foo|3]
                    // Test for old format explicitly since parseLocatorFallbackPath doesn't
                    // handle it.
                    if (rowLocator.charAt(3) != "[") {
                        rowNum = parseInt(rowLocator.substring(3));
                    } else {
                        var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(rowLocator);
                        if (rowLocatorConfig == null || rowLocatorConfig.name != "row") {
                            this.setLogFailureText(true, "the row locator '" +
                                                   rowLocator + "' for", "could not be parsed");
                        }
                        rowNum = grid.getRowNumFromLocatorConfig(rowLocatorConfig.config);
                    }
                    switch (attribute) {
                    case isc.Canvas._$Value:
                    case isc.Canvas._$Record:
                        var data = grid.data,
                            record = grid.getRecord(rowNum);
                        if (record == null || !data) {
                            this.setLogFailureText(true, "no record could be found " +
                                                   "for row " + rowNum + " of");
                            return;
                        }
                        return attribute == isc.Canvas._$Value ? data.isOpen(record) : record;
                    case isc.Canvas._$Field:
                    case isc.Canvas._$Element:
                        var fieldNum = grid.getTreeFieldNum(),
                            colNum = grid.getLocalFieldNum(fieldNum);
                        if (isc.isA.Number(rowNum) && isc.isA.Number(colNum)) {
                            return attribute == isc.Canvas._$Field ? grid.getField(fieldNum) :
                                this._getTableElementAndLogFailure(locatorArray, rowNum,
                                                                   colNum);
                        } else {
                            this._reportInvalidCellLocator(locatorArray, rowNum, colNum);
                            return null;
                        }
                    }

                // exactly the same logic for the "extraIcon", which is also used for
                // the checkbox icon when doing checkbox / cascading selection
                } else if (locatorArray[2] == "extra") {
                    if (this._suppressEventHandling()) {
                        this.setLogFailureText(true, null, "is being animated");
                        return emptyValue;
                    }

                    var rowLocator = locatorArray[0];
                    var rowNum;

                    //   old format was row3
                    // new format is a standard row locator like
                    //   row[pkFieldValue=foo|3]
                    // Test for old format explicitly since parseLocatorFallbackPath doesn't
                    // handle it.
                    if (rowLocator.charAt(3) != "[") {
                        rowNum = parseInt(rowLocator.substring(3));
                    } else {
                        var rowLocatorConfig = isc.AutoTest.parseLocatorFallbackPath(rowLocator);
                        if (rowLocatorConfig == null || rowLocatorConfig.name != "row") {
                            this.setLogFailureText(true, "the row locator '" +
                                                   rowLocator + "' for", "could not be parsed");

                        }
                        rowNum = grid.getRowNumFromLocatorConfig(rowLocatorConfig.config);
                    }
                    // we recorded the colNum but we don't need it!
                    //var colNum = grid.getTreeFieldNum();

                    if (attribute == isc.Canvas._$Value) {
                        var selection = grid.selectionManager,
                            record = grid.getRecord(rowNum);

                        if (record == null) {
                            this.setLogFailureText(true, "no record could be found " +
                                                   "for row " + rowNum + " of");
                            return;
                        }
                        if (selection == null) {
                            this.setLogFailureText(true, "no selection object could be found " +
                                                   "for");
                            return;
                        }

                        var isSel = selection.isSelected(record);
                        if (!isSel || !grid.showPartialSelection) return isSel;
                        return selection.isPartiallySelected(record) ? "partial" : isSel;
                    } else if (attribute == isc.Canvas._$Element) {
                        // use getImage since we write a name into the opener icon.
                        var openerID = grid._extraIconIDPrefix + rowNum,
                        image = grid.getImage(openerID, isc.Canvas._generateSpanForBlankImgHTML);
                        if (image) return image;
                        else {
                            this.setLogFailureText(true, "no opener image could be found for " +
                                                   "row " + rowNum + " of");
                            return null;
                        }
                    }
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        getAutoTestLocatorRect : function treeGridBody_getAutoTestLocatorRect (locator,
                                                                                   element)
        {
            var rect = this.Super("getAutoTestLocatorRect", arguments);
            if (rect == null) return rect;
            
            var tg = this.grid;
            // if we're picking up other icon coords will be position of icon so return it
            if (tg == null || locator.endsWith("/extra")) return rect;

            var offsetY = rect[1] - this.getPageTop()  + this.getScrollTop(),
                offsetX = rect[0] - this.getPageLeft() + this.getScrollLeft();

            var rowNum = this.getEventRow   (offsetY),
                colNum = this.getEventColumn(offsetX),
                openAreaWidth = this.getOpenAreaWidth(rowNum, colNum);
            if (openAreaWidth != null) {
                var rect = isc.Element.getElementRect(element);

                if (locator.endsWith("/open")) {
                    rect[2] = openAreaWidth;

                
                }
            }
            return rect;
        }

    });
}


if (isc.TileGrid) {
    isc.TileGrid.addMethods({
        _isProcessingDone : function tileGrid__isProcessingDone (strictMode) {
            if (strictMode && !this.isDrawn()) return true;
            return isc.AutoTest.isTileGridDone(this) != false;
        },
        
        getCanvasFromFallbackLocator : function tileGrid_getCanvasFromFallbackLocator (
            substring, config, candidates, strategy, typeStrategy)
        {
            if (typeStrategy == "Class" && config.Class == "SimpleTile") {
                var data = this.data,
                    dataIndex = parseInt(config.classIndex);

                if (this.recycleTiles) dataIndex += this.getDrawnStartIndex();

                var tileID = this.getTileID(data.get(dataIndex));
                if (tileID && window[tileID]) {
                    config.classIndex = this.tiles.indexOf(window[tileID]);
                }
            }
            return this.Super("getCanvasFromFallbackLocator", arguments);
        },
        getCanvasLocatorFallbackPath : function tileGrid_getCanvasLocatorFallbackPath (
            childName, instance, liveChildren)
        {
            var liveIndex = instance.tileNum,
                instanceId = instance.getID();
            if (this.recycleTiles) liveIndex -= this.getDrawnStartIndex();
            instance = liveChildren[liveIndex];
            // if instance isn't valid, just return the empty (locator) string
            if (!instance) {
                this.logWarn("tile instance " + instanceId +
                    " does not appear to be a currently live tile");
                return "";
            }
            return this.Super("getCanvasLocatorFallbackPath", arguments);
        }
});
}
if (isc.TileLayout) {
    isc.TileLayout.addMethods({
        _isProcessingDone : function tileLayout__isProcessingDone (strictMode) {
            if (strictMode && !this.isDrawn()) return true;
            return isc.AutoTest.isTileLayoutDone(this) != false;
        }
});
}

},


applyDrawingMethods : function () {

//  DrawPane
if (isc.DrawPane) {
    isc.DrawPane.addMethods({

        getLocator : function drawPane_getLocator (element, fromEvent, coords) {
            var locator = this.Super("getLocator", arguments);
            
            if (locator.indexOf(isc.AutoTest._$testRoot) < 0 && coords != null) {
                var item = this.getDrawItem(coords[0], coords[1]);
                if (item != null && item.masterElement == null && item.hasStableID()) {
                    return item.getLocatorRoot();
                }
            }
            return locator;
        },

        getInteriorLocator : function drawPane_getInteriorLocator(element, fromEvent, coords) {
            
            if (coords) {
                var locator = [],
                    item = this.getDrawItem(coords[0], coords[1]);
                if (item != null && item.masterElement == null) {
                    locator = [this.getItemLocator(item), '/'];
                    return locator.join(isc.emptyString);
                }
            }
            return this.Super("getInteriorLocator", arguments);
        },

        getItemLocator : function drawPane_getItemLocator (item) {
            var itemIdentifiers = {};

            // the drawItem title is primary means of locating item
            if (item.title != null) itemIdentifiers.title = item.title;

            // generate Class/ClassIndex/ClassLength as fall-back identifiers
            
            var className = item.getClassName();
            itemIdentifiers.Class = className;

            var drawItems = this.drawItems,
                classMatches = drawItems.findAll("Class", className);
            if (classMatches) {
                itemIdentifiers.classLength = classMatches.length;

                var classIndex = 0;
                for (var i = 0; i < this.drawItems.length; i++) {
                    if (drawItems[i].masterElement  != null ||
                        drawItems[i].getClassName() != className) {
                        continue;
                    }
                    if (drawItems[i] == item) break;
                    classIndex++;
                }
                itemIdentifiers.classIndex = classIndex;
            }

            // record # of points, as this won't change during resizing, scaling, etc.
            if (item.points != null) itemIdentifiers.nPoints = item.points.length; 

            var IDString = isc.AutoTest.createLocatorFallbackPath("item", itemIdentifiers);
            return IDString;
        },

        getItemFromSplitLocator : function drawPane_getItemFromSplitLocator (locatorArray) {
            var fullItemID = locatorArray[0];

            var itemConfig = isc.AutoTest.parseLocatorFallbackPath(fullItemID);
            if (itemConfig && itemConfig.name == "item" && itemConfig.config != null) {
                var config = itemConfig.config;
                
                // className is stored even if we don't identify by it.
                var className = config.Class;

                // use the title if present, subject to locateItemBy
                var item, drawItems = this.drawItems;
                for (var i = 0; i < drawItems.length; i++) {
                    var testItem = drawItems[i],
                    locateItemBy = testItem.locateItemBy;
                    // default location strategy is by title
                    if (locateItemBy == null) locateItemBy = "title";
                    // locateItemBy may have been set to "index" to ignore titles
                    if (locateItemBy == "title" && config.title != null && 
                        testItem.title == config.title) 
                    {
                        item = testItem;
                    }
                }
                
                // enforce that ClassName of item must match locator
                if (item != null && className != item.getClassName()) item = null;

                // our fallback mechanism is locating by classIndex
                if (item == null) {
                    var classMatches = drawItems.findAll("Class", className);
                    if (classMatches && classMatches.length == config.classLength) {
                        
                        var classIndex = 0;
                        for (var i = 0; i < this.drawItems.length; i++) {
                            if (drawItems[i].masterelement  != null ||
                                drawItems[i].getClassName() != className) {
                                continue;
                            }
                            if (classIndex == config.classIndex) {
                                item = drawItems[i];
                                break;
                            }
                            classIndex++;
                        }
                    }
                }

                // enforce that # of drawItem points must be equal
                if (item != null) {
                    var itemNPoints = item.points != null ? item.points.length : null;
                    if (itemNPoints != config.nPoints) item = null;
                }

                if (!item) {
                    this.logWarn("AutoTest.getElement(): Unable to find item from " +
                                 "locator string:" + fullItemID);
                    return null;
                }
                if (isc.AutoTest._shouldReportClassMismatch(className, item)) {
                    this.logWarn("AutoTest.getElement(): identifier:"+ fullItemID + 
                                 " returned an item of class:"+ item.getClassName());
                }
                return item;
            }
            
            return null;
        },

        getInnerAttributeFromSplitLocator : function
            drawPane_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var item = this.getItemFromSplitLocator(locatorArray);
                if (item != null) {
                    locatorArray.removeAt(0);
                    return item.getAttributeFromSplitLocator(locatorArray, configuration); 
                }
            }
            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },

        
        getAutoTestLocatorRect : function drawPane_getAutoTestLocatorRect (locator, element)
        {
            // retrieve the drawItem
            var drawItem = isc.AutoTest.getObject(locator);
            if (!isc.isA.DrawItem(drawItem)) {
                return this.Super("getAutoTestLocatorRect", arguments);
            }

            // getBoundingBox() will give us x1, y1, x2, y2 for opposite corners of the rectangle
            // compute center of drawItem in global (page) coordinates
            var bbox = drawItem.getBoundingBox(),
                x0 = bbox[0],
                y0 = bbox[1],
                x1 = bbox[2],
                y1 = bbox[3]
            ;
            var localToGlobalTransform = drawItem._getNormalizeTransform("local", "global");

            // Normalize to 2 element left/top, right/bottom arrays [localGlobaTransform will
            // apply transformation from draw-canvas coords]
            var lt = localToGlobalTransform.transform(Math.min(x0,x1), Math.min(y0,y1)),
                left = lt[0],
                top = lt[1],
                rb = localToGlobalTransform.transform(Math.max(x0,x1), Math.max(y0,y1)),
                width = rb[0] - left,
                height = rb[1] - top;

            // add to left, top coordinates of drawPane
            var drawPaneHandle = this.getClipHandle(),
                drawPanePageRect = isc.Element.getElementRect(drawPaneHandle);

            left = this._makeCoordinate(left + drawPanePageRect[0]);
            top  = this._makeCoordinate(top  + drawPanePageRect[1]);
            return [left, top, width, height];
        },
        // We're using getCenter() to get a center point, rather than the default implementation of returning the center
        // of getAutoTestLocatorCoords().
        getAutoTestLocatorCoords : function drawPane_getAutoTestLocatorCoords (locator, element)
        {
            // retrieve the drawItem
            var drawItem = isc.AutoTest.getObject(locator);
            if (!isc.isA.DrawItem(drawItem)) {
                return this.Super("getAutoTestLocatorCoords", arguments);
            }
            // compute center of drawItem in global (page) coordinates
            var center = drawItem.getCenter(),
                localToGlobalTransform = drawItem._getNormalizeTransform("local", "global");
            localToGlobalTransform.transform(center[0], center[1], center);

            // add to left, top coordinates of drawPane
            var drawPaneHandle = this.getClipHandle(),
                drawPanePageRect = isc.Element.getElementRect(drawPaneHandle);
            center[0] = this._makeCoordinate(center[0] + drawPanePageRect[0]);
            center[1] = this._makeCoordinate(center[1] + drawPanePageRect[1]);
            return center;
        },

        _isProcessingDone : function drawPane__isProcessingDone (strictMode) {
            if (strictMode && !this.isDrawn()) return true;
            return isc.AutoTest.isDrawPaneDone(this) != false;
        }
    });

    isc.DrawItem.addMethods({

        getLocatorRoot : function drawItem_getLocatorRoot () {
            
            if (!this.locatorRoot) {
                this._locatorRootTemplate[1] = this.getClassName();
                this._locatorRootTemplate[3] = this.getID();
                this.locatorRoot = this._locatorRootTemplate.join(isc.emptyString);
            }
            return this.locatorRoot;
        },

        getLocator : function drawItem_getLocator () {
            // Ignore "element" part - assume this will only be run in the 'autoChild' pattern.
            return this.getLocatorInternal();
        },

        getLocatorInternal : function drawItem_getLocatorInternal (a, b, c, d) {
            return this.drawPane._getItemLocatorInternal(this, a, b, c, d);
        },

        _getFloatValueAsString : function drawItem__getFloatValueAsString (value) {
            var item = this;
            if (isc.isAn.Array(value)) {
                var coords = value.map(function (prop) { 
                    return item._getFloatValueAsString(prop);
                });
                return coords.join(isc.AutoTest.valueSeparator);
            }
            if (isc.isA.Number(value) && Math.round(value) != value) {
                return isc.Canvas.getFloatValueAsString(value, 
                    isc.AutoTest.decimalPrecision, isc.AutoTest.decimalPad);
            }
            return value != null ? value.toString() : null;
        },

        getInnerAttributeFromSplitLocator : function drawItem_getInnerAttributeFromSplitLocator
            (locatorArray, configuration) 
        {
            var undef,
                attribute = configuration.attribute;

            // default values
            switch (attribute) {
            case isc.Canvas._$Object:
                return this;

            case isc.Canvas._$Value:
                // return drawItem.title by default
                if (this.emptyLocatorArray(locatorArray)) {
                    return this.getLocatorValue();
                }
                // key properties are available by trailing part name
                var coords, part = locatorArray[0];
                switch (part) {
                case "src":
                case "fillColor":
                case "lineColor":
                    return this[part];

                case "top":
                case "left":
                case "width":
                case "height":
                case "rotation":
                case "lineWidth":
                case "lineOpacity":
                case "fillOpacity":
                    coords = this[part];
                    break;

                case "center": 
                    coords = this.getCenter();
                    break;
                case "boundingBox":
                    coords = this.getBoundingBox();
                    break;
                case "resizeBoundingBox":
                    // exclude stroke to match getBoundingBox()
                    coords = this.getResizeBoundingBox(true);
                    break;

                default:
                    this.logWarn("Unknown property " + part + " requested for drawItem.  " +
                                 "Returning the default value.");
                    return this.getLocatorValue();
                }

                return isc.AutoTest.reportValuesAsString ?
                    this._getFloatValueAsString(coords) : coords;

            case isc.Canvas._$Element:
                var drawPane = this.drawPane;
                if (!drawPane) return;

                
                var drawingType = drawPane.drawingType;
                switch (drawingType) {
                case "bitmap":
                    // most drawItems have no DOM element
                    return drawPane.getBitmap();
                case "svg":
                    return this._svgHandle;
                case "vml":
                    return this._getVMLHandle();
                }
                

                break;

            default:
                return;
            }
        },

        // a drawItem's default value is its title
        getLocatorValue : function drawItem_getLocatorValue() {
            return this.title;
        },

        
        getAttributeFromSplitLocator : function drawItem_getAttributeFromSplitLocator (
            locatorArray, configuration) 
        {
            return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
        }
        
    });

    isc.DrawLabel.addMethods({
        getLocatorValue : function drawItem_getLocatorValue() {
            return this.contents;
        }
    });

}

},


applyToolsMethods : function () {

if (isc.CriteriaItem) {
    isc.CriteriaItem.addProperties({
        _deprecatedAutoChildren: {"window" : "editorWindow"}
    });
}

if (isc.WorkflowEditor) {

    isc.WorkflowEditor.addMethods({

        getItemLocator : function workflowEditor_getItemLocator (item) {
            var name,
                itemIdentifiers = {},
                node = item._node || {}
            ;

            // the node id is primary means of locating element
            if (node.id != null) {
                name = "element";
                itemIdentifiers.elementID = node.elementID;
            } else {
                // An add element has no associated node
                name = "addElement";
                itemIdentifiers.elementSegment = item.segmentId;
                itemIdentifiers.elementRow = item.rowId;
            }

            
            if (item.elementType != null) itemIdentifiers.elementType = item.elementType;
            if (node._sequence != null) itemIdentifiers.sequence = node._sequence;
            if (item.title != null) itemIdentifiers.title = item.title;

            var IDString = isc.AutoTest.createLocatorFallbackPath(name, itemIdentifiers);
            return IDString;
        },
        
        getCanvasFromFallbackLocator : function workflowEditor_getCanvasFromFallbackLocator (
            substring, config, candidates, strategy, typeStrategy)
        {
            if (typeStrategy == "Class" && config.elementID) {
                return this.getElementByID(config.elementID);
            }
            return this.Super("getCanvasFromFallbackLocator", arguments);
        },

        getElementFromSplitLocator : function workflowEditor_getItemFromSplitLocator (
            locatorArray)
        {
            var fullItemID = locatorArray[0],
                className;

            var itemConfig = isc.AutoTest.parseLocatorFallbackPath(fullItemID);
            
            if (itemConfig && itemConfig.name == "element" && itemConfig.config != null) {
                var config = itemConfig.config;
                
                // className is stored even if we don't identify by it.
                className = config.Class;
                
                // if we have a valid id, always have it take precedence
                var item;
                if (config.id != null) {
                    //this.logWarn("locating by id " + config.id);
                    item = this.getElementByID(config.id);
                } else {
                    // Combination of element details doesn't make it unique.
                    // Using the node properties does but it takes a number of
                    // different attributes on a per-type basis to do so.
                }
                if (!item) {
                    this.logWarn("AutoTest.getElement(): Unable to find element from " +
                        "locator string:" + fullItemID);
                    return null;
                }
                if (isc.AutoTest._shouldReportClassMismatch(className, item)) {
                    this.logWarn("AutoTest.getElement(): identifier:"+ fullItemID + 
                                " returned an element of class:"+ item.getClassName());
                }
                return item;
            } else if (itemConfig && itemConfig.name == "addElement" && itemConfig.config != null) {
                var config = itemConfig.config;
                
                // className is stored even if we don't identify by it.
                className = config.Class;
                
                var item = this.getAddElement(config.elementSegment, config.elementRow);
                return item;
            }
            
            return null;
        },

        getFallbackLocatorCandidates : function workflowEditor_getFallbackLocatorCandidates (name) {
            if (name === "addElement") {
                return this.getAllAddElements();
            } else if (name == "element") {
                return this.getAllElements();
            }
            return this.Super("getFallbackLocatorCandidates", arguments);
        },

        getInnerAttributeFromSplitLocator : function
            workflowEditor_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (!this.emptyLocatorArray(locatorArray)) {
                var item = this.getElementFromSplitLocator(locatorArray);
                if (item != null) {
                    locatorArray.removeAt(0);
                    return item.getAttributeFromSplitLocator(locatorArray, configuration); 
                }
                // support event-parts in all canvii
                if (locatorArray.length == 1) {
                    var undef, element = this._getEventPartElement(locatorArray);
                    if (undef !== element) return element;
                }
                
                if (configuration.locatorMatching != "permitSuffix") {
                    this.setLogFailureText(true, "the trailing locator suffix '" +
                        locatorArray.join("/") + "' does not identify any WorkflowEditorElement in",
                                           "and permitSuffix mode is not active");
                    return null;
                }
            }
            return isc.AutoTest.getAttributeDefault(this, configuration.attribute);
        }


    });
}

if (isc.WorkflowEditorElement) {

    isc.WorkflowEditorElement.addMethods({
    
        getLocatorInternal : function workflowEditorElement_getLocatorInternal (a, b, c, d) {
            return this.editor._getItemLocatorInternal(this, a, b, c, d);
        },
        getLocatorToContainer : function workflowEditorElement_getLocatorToContainer (
            a, b, c, d)
        {
            return this.editor._getItemLocatorToContainer(this, a, b, c, d);
        }

    });
}

},


applyReifyMethods : function () {

if (isc.Reify) {
    isc.Reify.addMethods({
    
        getLocatorRoot : function vb_getLocatorRoot () {
            if (!this.locatorRoot) this.locatorRoot = this._getLocatorRoot();
            return this.locatorRoot;
        },
        _getLocatorRoot : function vb_getLocatorRoot () {
            // return special shorthand locator if the VB instance has an ID=="VB"
            if (this.getID() == "VB") {
                // Note 3 leading slashes
                return "///" + this.getID();
            }
            // otherwise, assign the locator as usual
            return this.Super("_getLocatorRoot", arguments);
        },

        getComponentTreeIDs : function vb_getComponentTreeIDs() {
            var nodes = this.projectComponents.data.getNodeList();
            return nodes.map(function(node){return node.ID;});
        }

    });
}

},

    
applyDataBindingMethods : function () {

// EditMode - allow locators for edit proxy UI elements to find the appropriate live component
if (isc.EditProxy) {

    isc.EditProxy.changeDefaults("inlineEditFormDefaults",
    {
        getLocatorParent:function editProxy_getLocatorParent () {
            var editProxy = this.creator;
            if (editProxy && editProxy.creator) {
                return editProxy.creator;
            }
            return this.Super("getLocatorParent", arguments);
        }
    });
}

},


// We want to respond to interaction with calendar events based on event name and 
// potentially date /title.
// Cases to handle:
// - interacting with cells in the 3 standard ListGrid views (day, week, month)
// - interacting with event links within cells in the month view
// - interacting with eventWindow auto-children associated with existing events

// Note we also need to handle interaction with various auto-children -- the date picker,
// prev/next buttons, etc. These should be handled by the standard "single auto child" 
// subsystem rather than needing any special logic.
applyCalendarMethods : function () {

    // locateCellsBy
    //  - date
    //      - implies date AND time
    //  - index
    //      - rowNum/colNum
    
    
    // locateEventsBy
    //  - name
    //  - title
    //  ? event type
    //  - startDate
    isc._commonCalenderViewFunctions = {
            
        // Override the method to set up the 'rowLocator' - this should store
        // date and time and use that for preference over other locators
        // Note: we're leaving the columns alone here: for the day view we show only
        // two columns -- the label and the day column -- we'll already identify the correct
        // one based on field name
            
        // builds a config type object that we'll pass to createLocatorFallbackPath
        getRowLocatorOptions : function calendarView_getRowLocatorOptions (body, rowNum, colNum) {
            
            // Pick up standard options - this will get the rowNum for us
            // (Other options, such as primary key don't have much use here)
            var options = this.Super("getRowLocatorOptions", arguments);
            
            var date = this.creator.chosenDate;
            options.date = date.toSchemaDate("date");
            
            // time always starts at 12am
            // We show 2 rows per hour.
            // so just count rows to get time
            options.minutes = rowNum * this.creator.getMinutesPerRow();
            return options;
            
        },
        
        
        // parse a stored locator configuration back to the appropriate cell
        // If we're identifying by date, use the stored date / minutes
        // otherwise just use index
        getRowNumFromLocatorConfig : function calendarView_getRowNumFromLocatorConfig (rowConfig) {
            var locateCellsBy = this.creator.locateCellsBy;
            if ((locateCellsBy == "date" || locateCellsBy == null) &&
                rowConfig.date != null)
            {
                var date = isc.DateUtil.parseSchemaDate(rowConfig.date);
                if (!this.showingDate(date)) {
                    this.logWarn("Locator for cell in this calendar day-view grid has date " +
                        "stored as:" + date.toUSShortDate() + ", but we're currently showing " +
                        this.creator.chosenDate.toUSShortDate() +
                        ". The stored date doesn't map to a visible cell so not returning a cell " +
                        "- if this is not the intended behavior in this test case you may need to " +
                        "set calendar.locateCellsBy to 'index'.", "AutoTest");
                    return -1;
                }
                // map the stored minutes to the appropriate rowNum
                
                return parseInt(rowConfig.minutes) / this.creator.getMinutesPerRow();
            }
            this.locateRowsBy = "index";
            return this.Super("getRowNumFromLocatorConfig", arguments);
        },
        
        showingDate : function calendarView_showingDate (date) {
            return isc.DateUtil.compareLogicalDates(date, this.creator.chosenDate) == 0;
        }
    };
    isc.DaySchedule.addProperties(isc._commonCalenderViewFunctions);
    
    // WeekView - has fields for each day of the week (plus the label field)
    // field names are arbitrary ("day1", "day2" etc, not mapping to days of week).
    // However field objects have year, month, day stored as _yearNum, _dateNum, _monthNum
    // so we don't need to calculate based on location, etc
    isc.WeekSchedule.addProperties(isc._commonCalenderViewFunctions,{
            
        // override 'showingDate' -- we show a range of dates (a week's worth)
        // we could look at this.creator.chosenDate again but seems like it'd be easier just
        // to check the date values already stored on each visible field
        showingDate : function weekSchedule_showingDate (date) {
            for (var i = 0; i < this.fields.length; i++) {
                var field = this.fields[i];
                if (field._yearNum == null) continue;
                if (isc.DateUtil.compareLogicalDates(
                        isc.DateUtil.createLogicalDate(field._yearNum, field._monthNum, 
                                                       field._dateNum),
                        date
                    ) == 0) 
                {
                    this.logWarn("does contain date" + date.toShortDate());
                    return true;
                }
                this.logWarn("date passed in:" + date.toShortDate() +
                    "compared with:" + isc.DateUtil.createLogicalDate(field._yearNum, 
                                           field._monthNum, field._dateNum).toShortDate());
            } 
            
            this.logWarn("doesn't contain date:" + date);
            return false;
        },
        
        
        // Month view has meaningful fields - each column is one day
        // Store date information on our column locators and use it when
        // retrieving columns
        getColLocatorOptions : function weekSchedule_getColLocatorOptions (body, rowNum, colNum) {
            
            var locatorOptions = this.Super("getColLocatorOptions", arguments),
                gridColNum = this.getFieldNumFromLocal(colNum, body),
                field = this.getField(gridColNum);                
            // the label field has no associated date, of course
            if (field && field._dateNum != null) {
                // the month is zero based - add one to it so it looks like the schema date
                // not really necessary but that way the date on the rowNum (derived from
                // this.chosenDate, using getSchemaDate()) will match the
                // date on the colNum in the locator string!
                locatorOptions.date = [field._yearNum, (field._monthNum+1), field._dateNum].join("-");
            }
            
            return locatorOptions;
        },
        
        // helper to pick up field based on 'checkboxField' status and name
        // If neither work, we will use field num instead
        getFieldFromColLocatorConfig : function weekSchedule_getFieldFromColLocatorConfig (colConfig) {
            
            if ((this.locateCellsBy == "date" || this.locateCellsBy == null) &&
                (colConfig.date != null)) 
            {
                var dateArr = colConfig.date.split("-");
                // we can ignore the month and year - if the chosen date wasn't already in
                // the range, rowNum will be -1 anyway so we won't return a cell.
                return this.getFields().find("_dateNum", dateArr[2]);
                
            }
            
            return this.Super("getFieldFromColLocatorConfig", arguments);
        }
    });

    // Month view:
    // MonthSchedule is a subclass of ListGrid as well - it shows one column per day of the
    // week, and 2 rows per week -- one row is the header containing date values
    // second row is the actual events
    // Events are embedded in the cells as link elements
    // We'll need to react to
    //  - click on header rows (goes to day view)
    //  - click on empty cells (shows window to add an event)
    //  - click on stored event links (shows window to edit event)
    // Once again we'll use locateCellsBy "date" to find cells
    // If set to index we'll just set locateRowsByIndex and let standard handling occur
    // for the month
    
    // each field is named 'day1' [, 'day2', ...]
    // Each record has a 'day1' value which matches that of the field header, and a
    //  date1 value which actually specifies the date the row represents
    // The "1", "2", etc is specified by looking at field._dayIndex
    //
    // So the 'date1' value in the first row (a header row) matches the 'date1' value in the
    // second row (an 'event' row), and is the date we're showing in the 'day1' column (the
    // first column) and so on...
    
    // rows that are actual dates have an events array attached to them -- usually empty
    // rows that are not actual dates (so header rows) have no events array
    
    // Events within Month cells:
    // We record info about the event rather than the cell (essentially the date) it's located
    // in for event-links within month cells.
    // When we attempt to find the event links we can therefore have the Calendar find the
    // event and then try to find the link associated with that event in our view.
    
    // Event links call 'monthViewEventClick(rowNum,colNum,index)' on the calendar, so we
    // will parse this href string to determine which event is being interacted with...
    
    isc.MonthSchedule.addProperties({
            
        getRowLocatorOptions : function monthSchedule_getRowLocatorOptions (body, rowNum, colNum) {
            
            // Pick up standard options - this will get the rowNum for us
            // (Other options, such as primary key don't have much use here)
            var options = this.Super("getRowLocatorOptions", arguments);
            var record = this.getRecord(rowNum);
            if (!record) return options; // sanity check only
            
            var field = this.getField(colNum);
            
            var dayIndex = field._dayIndex;
            options.dayIndex = dayIndex;
            var date = record["date" + dayIndex];
            options.date = date.toSchemaDate("date");
            
            var events = record["event" + dayIndex];
            if (events == null) {
                options.isHeaderRow = true;
            } else {
                options.isHeaderRow = false;
            }
            return options;
        },
        
        getRowNumFromLocatorConfig : function monthSchedule_getRowNumFromLocatorConfig (rowConfig) {

            var locateCellsBy = this.creator.locateCellsBy;
            if ((locateCellsBy == "date" || locateCellsBy == null) &&
                rowConfig.date != null)
            {
                var date = isc.DateUtil.parseSchemaDate(rowConfig.date),
                    headerRow = (rowConfig.isHeaderRow == "true"),
                    dateField = "date" + rowConfig.dayIndex,
                    eventField = "event" + rowConfig.dayIndex;
                for (var i = 0; i < this.data.length; i++) {
                    var isHeader = (this.data[i][eventField] == null);
                    if (isHeader == headerRow) {
                        if (isc.DateUtil.compareLogicalDates(this.data[i][dateField], date) == 0) {
                            return i;
                        }
                    }
                }
                // no matching record (by date)
                return -1;
            }
            this.locateRowsBy = "index";
            return this.Super("getRowNumFromLocatorConfig", arguments);
        },
        
        
        getColLocatorOptions : function monthSchedule_getColLocatorOptions (body, rowNum, colNum) {
            var options = this.Super("getColLocatorOptions", arguments);
            // if we just record the dayIndex we can use that to find the column.
            // If the configuration changes such that (for example) the date isn't showing,
            // we'll just fail to find the cell so return -1 from getRowNumFromLocatorConfig
            options.dayIndex = this.getField(colNum)._dayIndex;
            return options;
        },
        
        getColNumFromLocatorConfig : function monthSchedule_getColNumFromLocatorConfig (colConfig) {
            var locateCellsBy = this.locateCellsBy;
            if (locateCellsBy == null || locateCellsBy == "date") {
                return this.fields.findIndex("_dayIndex", parseInt(colConfig.dayIndex));
            }
            
            this.locateColsBy = "index";
            return this.Super("getColNumFromLocatorConfig", arguments);
        }
        
    });
    
     
    isc.MonthScheduleBody.addProperties({
    
        // override getInterior locator to actually identify event link locators
        // (based on event rather than cell location)
        getInteriorLocator : function monthScheduleBody_getInteriorLocator (element) {
            if (element.tagName.toLowerCase() == "a") {
                var href = element.href;
                if (href != null) {
                    // We're using the href -- this is pretty hokey but no
                    // other info is written into the DOM element...
                    // It should be robust across page reloades etc since the
                    // stored locator is based on the event directly -- not on the
                    // href directly -- we just use that to find the event (and then to
                    // find the appropriate link from the event when parsing locators)
                    
                    // double escaping necessary -- first is eaten by quotes
                    var match = href.match("javascript:.*monthViewEventClick\\((\\d+),(\\d+),(\\d+)\\);");
                    //this.logWarn("match!:" + match);
                    if (match) {
                        var row = parseInt(match[1]),   
                            col = parseInt(match[2]),
                            index = parseInt(match[3]);
                        var events = this.grid.getEvents(row,col),
                            event = events[index];
                           
                        if (event == null) {
                            this.logWarn("Unable to determine event associated with apparent event " +
                                "link element -- returning cell");
                            return this.Super("getInteriorLocator", arguments);
                        }
                        
                        var calendar = this.grid.creator,
                            config = calendar.getEventLocatorConfig(event);
                        var string = isc.AutoTest.createLocatorFallbackPath("eventLink", config);
                        //this.logWarn("string:" + string);
                        return string;
                    }
                }
            }
            
            return this.Super("getInteriorLocator", arguments);
        },
        
        getInnerAttributeFromSplitLocator : function
            monthScheduleBody_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            if (configuration.attribute != isc.Canvas._$Element) {
                this.setLogFailureText(true, "getValue() is not supported for");
                return;
            }

            if (this.emptyLocatorArray(locatorArray)) return this._getHandleAndLogFailure();
            
            // if it starts with "eventLink" - get the relevant event from the Calendar
            // and then find it in our body if possible
            if (locatorArray.length == 1 && locatorArray[0].startsWith("eventLink")) {
                var fullConfig = isc.AutoTest.parseLocatorFallbackPath(locatorArray[0]);
                
                var calendar = this.grid.creator;
                var event = calendar.getEventFromLocatorConfig(fullConfig.config);
                
                var cell = this.grid.getEventCell(event);
                
                if (cell != null) {
                    var data = this.grid.data,
                        rowNum = cell[0],
                        colNum = cell[1],
                        dayIndex = this.grid.getField(colNum)._dayIndex;
            
                    var cellElement = this.getTableElement(rowNum,colNum),
                        links = cellElement.getElementsByTagName("A");
                    if (links != null) {
                        for (var iii = 0; iii < links.length; iii++) {
                            var href = links[iii].href;
                            if (href != null) {
                                // double escaping necessary -- first is eaten by quotes
                                var match = href.match("javascript:.*monthViewEventClick" +
                                                       "\\((\\d+),(\\d+),(\\d+)\\);");
                                if (match && data[rowNum]["event"+dayIndex][parseInt(match[3])]
                                    == event)
                                {
                                    return links[iii];
                                }
                            }
                        }
                    }
                }
                return this.Super("getInnerAttributeFromSplitLocator", arguments);
            }
         }
            
    });
    
    // Events:
    // Calendars are dataBound components where this.data is a set of events to show
    // (May come from a dataSource).
    // In Day and Week views, events show up as windows floating over the grid body
    // In Month view events are embedded directly in the cells
    // Modify the standard row locator / parsing logic to store / retrieve events
    // and find the appropriate windows (or link elements in the month view)
    isc.Calendar.addProperties({
            
        // this method gets called automatically for autoChildren.
        // Pick up eventWindows and store information based on the event they represent
        getCanvasLocatorFallbackPath : function calendar_getCanvasLocatorFallbackPath (name,
                                                      canvas, sourceArray, properties, mask)
        {
            if (name == "eventWindow" || name == "eventCanvas") {
                var options = this.getEventLocatorConfig(canvas.event);
                return isc.AutoTest.createLocatorFallbackPath(name, options);
            }
            return this.Super("getCanvasLocatorFallbackPath", arguments);
        },
        
        getEventLocatorConfig : function calendar_getEventLocatorConfig (event) {
            this.logWarn("In getEventLocatorConfig().  event:" + this.echo(event));
            var config = {};
            if (this.dataSource) {
                var pkFields = this.getDataSource().getPrimaryKeyFieldNames();
                for (var i = 0; i < pkFields.length; i++) {
                    config[pkFields[i]] = event[pkFields[i]];
                }
            }
            
            var nameField = this.nameField;
            config[nameField] = event[nameField];
            
            var startField = this.startDateField;
            var startTime = event[startField];
            config[startField] = startTime.toSchemaDate();
            
            var endField = this.endDateField;
            var endTime = event[endField];
            config[endField] = endTime.toSchemaDate();
            
            config.index = this.data.indexOf(event);
            //this.logWarn("event config: " + this.echo(config));
            return config;
        },
        
        // substring param really just used for logging
        getChildFromFallbackLocator : function calendar_getChildFromFallbackLocator (substring,
                                                                         fallbackLocatorConfig)
        {
            var type = fallbackLocatorConfig.name,
                config = fallbackLocatorConfig.config;
                
            if (type == "eventWindow" || type == "eventCanvas") {
                var view = this.getSelectedView(),
                    children = view && view.body && view.body.children
                ;
                if (children != null) {
                    var event = this.getEventFromLocatorConfig(config),
                        eWindow = children.find("event", event);
                    if (eWindow) return eWindow;
                }
                this.logWarn("unable to find event window associated with event:" + this.echo(event) +
                    " based on locator string:" + substring + 
                    ". It's possible that this event is not visible in the current view of " +
                    "this Calendar", "AutoTest");
                return null;
            }
            
            return this.Super("getChildFromFallbackLocator", arguments);
        },
        
        // we need date support.
        // So we need to be able to customize fields to record
        
        getEventFromLocatorConfig : function calendar_getEventFromLocatorConfig (config) {
            var locateBy = this.locateEventsBy;
            if (locateBy == null) locateBy = "primaryKey";
            
            switch (locateBy) {
            case "primaryKey":
                this.logDebug("Trying to locate event by pk", "autotest");
                var ds = this.getDataSource();
                if (ds) {
                    var pkFields = ds.getPrimaryKeyFieldNames(),
                        allKeys = pkFields.length > 0,
                        keyVals = {};
                    for (var i = 0; i < pkFields.length; i++) {
                        if (config[pkFields[i]] == null) {
                            allKeys = false;
                            break;
                        } else {
                            keyVals[pkFields[i]] = config[pkFields[i]];
                        }
                    }
                    if (allKeys) {
                        this.logDebug("All key fields present: " + isc.echoAll(keyVals), "autotest");
                        var record = ds.findByKeys(config, this.data);
                        if (record != null && record != -1) {
                            this.logDebug("Successfully located event by pk.  Record: " + 
                                            isc.echoAll(this.data.get(record)), "autotest");
                            return this.data.get(record);
                        }
                    } else {
                        this.logDebug("PK values missing. Config: " + isc.echoAll(config), 
                                            "autotest");
                    }
                }
                
                this.logDebug("Failed to locate event by pk.  Config: " + isc.echoAll(config),
                              "autotest");

                // The missing break statement here is intentional - we want to fall through
                // to the next case

        
                // NOTE: The skipFallback property is an internal flag to ensure that the
                // row is located by primary key, or not at all.  The primary motivation 
                // for adding it is to enable automated testing of the PK functionality; 
                // for that, we have to be certain that the element was located by 
                // primaryKey and not some fallback strategy
                if (isc.AutoTest.skipFallback) return null;
                
            case "name":
                var name = config[this.nameField];
                if (name != null) return this.data.find(this.nameField, name);
                
                
            case "date":
                // we could convert these to dates, and then compare via compareDate but
                // that could trip up on millisecond differences, etc -- this seems a
                // safer approach.
                var startTime = config[this.startDateField],
                    endTime = config[this.endDateField];
                
                // we're going to have to find all dates where start AND end time match
                // we could get more sophisticated and match start / end separately too
                // but that seems like an odd use case
                for (var i = 0; i < this.data.length; i++) {
                    var testEvent = this.data.get(i);
                    if (testEvent == null) continue;
                    
                    if (testEvent[this.startDateField].toSchemaDate() == startTime &&
                        testEvent[this.endDateField].toSchemaDate() == endTime)
                    {
                        return testEvent;
                    }
                    this.logWarn("attempt to match calendar event by startDate / endDate " +
                        "unable to locate any events. Backing off to index within data array");
                }
                
            // back off to locating by index within this.data
            default:
                var index = parseInt(config.index);
                return this.data.get(index);
                
                
            }
        }
    });

    // support SC 9.1 and earlier Calendar EventWindow header/body locators (backcompat)
    isc.EventCanvas.addProperties ({
        getAttributeFromSplitLocator : function eventCanvas_getAttributeFromSplitLocator (
            locatorArray, configuration)
        {
            // pass this call on to getInnerAttributeFromSplitLocator()
            return this.getInnerAttributeFromSplitLocator(locatorArray, configuration);
        },
        getInnerAttributeFromSplitLocator : function
            eventCanvas_getInnerAttributeFromSplitLocator (locatorArray, configuration)
        {
            var attribute     = configuration.attribute,
                returnValue   = attribute == isc.Canvas._$Value,
                returnElement = attribute == isc.Canvas._$Element,
                part = locatorArray && locatorArray[0]
            ;
            if ((returnValue || returnElement) && locatorArray.length == 1) {
                switch (part) {
                case "body":
                case "bodyLabel": 
                    return returnValue ? this.getBodyHTML() : this._getHandleAndLogFailure();
                case "header":
                case "headerLabel":
                    return returnValue ? this.getHeaderHTML() : this._getHandleAndLogFailure();
                }
            }

            return this.Super("getInnerAttributeFromSplitLocator", arguments);
        },
        // restore capability to distinguish header and body with current widget hierarchy
        getInteriorLocator : function eventCanvas_getInteriorLocator (element) {
            var partIdentifier = this.getElementPart(element);
            if (partIdentifier) {
                var part = partIdentifier.part;
                if (part == "header" || part == "headerLabel") return "header"; 
                if (part == "body" || part == "bodyLabel") return "body";
            }
            return this.Super("getInteriorLocator", arguments);
        }
    });

},


    //> @classAttr AutoTest.implicitNetworkWait (boolean : false : [IRW])
    // Controls whether certain AutoTest APIs wait for network operations to complete
    // before returning true.  When value is true, +link{AutoTest.isElementClickable}
    // will return false until all network operations have completed.
    // @visibility external
    // @group autoTest
    //<
    // default implicitNetworkWait to true for internal autotests
    implicitNetworkWait: !!isc.Browser.autotest,

    //> @classAttr AutoTest.testRoot (Canvas : null : [IRW])
    // Sets the implicit root canvas available in scLocators starting "//testRoot[]".
    // Setting this property may enable one to use the same script to test identical
    // widget hierarchies that are rooted under different base widgets.
    // @visibility external
    // @group autoTest
    //<
    
    _$testRoot: "//testRoot[]",
    testRoot: null,

    // helper also used in the user extendion files
    _isTextBased : function (element) {
        if (!element) return null;
        var tagName = element.tagName;
        if (!element.tagName) return false;
        tagName = tagName.toLowerCase();
        return tagName == "textarea" || tagName == "input" && 
            (element.type == "text" || element.type == "password" || element.type == "file");
    },

    _getSelectionLength : function (element) {
        if (!element || element.selectionStart == null || element.selectionEnd == null) return;
        return element.selectionEnd - element.selectionStart;
    },

    //> @classMethod AutoTest.setTestRoot()
    // Sets the implicit root canvas available in scLocators starting "//testRoot[]".
    // Setting this property may enable one to use the same script to test identical
    // widget hierarchies that are rooted under different base widgets.
    // @param canvas (Canvas) the implicit root
    // @visibility external
    // @group autoTest
    //<
    setTestRoot : function (canvas) {
        this.testRoot = canvas;
        if (canvas != null) {
            this.logInfo("setting testRoot to canvas " + canvas.ID + ", so scLocators " +
                "starting " + this._$testRoot + "... will now be seen as rooted there");
        } else {
            this.logInfo("clearing the testRoot canvas, so scLocators " +
                "starting " + this._$testRoot + "... may no longer be used");
        }
    },

    // provides access to the canvas capable of scrolling the test root canvas
    getTestRootScrollCanvas : function () {
        if (this.testRoot == null) {
            this.logWarn("Unable to locate the scroll canvas containing the test root " +
                         "when no test root canvas has been configured");
            return null;
        }
        
        var explorer = window.featureExplorer;
        if (explorer != null) return explorer.exampleViewer.viewPane;

        for (var pane = this.testRoot; !isc.isA.PaneContainer(pane); pane = pane.parentElement);
        return pane;    
    },


    //////////////////////////////////////////////////////////////////////////////////////////
    // Minimal locator support

    _savedConfigs: [],

    pushConfiguration : function (config) {
        var savedConfig = {};
        for (var prop in config) {
            savedConfig[prop] = this[prop];
        }
        this._savedConfigs.push(savedConfig);
        isc.addProperties(this, config);
    },

    popConfiguration : function () {
        var undefined,
            savedConfig = this._savedConfigs.pop();
        if (savedConfig) for (var prop in savedConfig) {
            if (savedConfig[prop] === undefined) {
                delete this[prop];
            } else this[prop] = savedConfig[prop];
        }
    },

    //> @classAttr AutoTest.simplifyLocatorAttributeHTML (boolean : true : [IRW])
    // Should HTMLStrings in fallback locator attributes be simplified to ordinary strings
    // before being written out?  For example:
    // <pre>
    //    title="&lt;div id=\"foo\"&gt;bar&lt;/div&gt;"
    // </pre>
    // would become
    // <pre>
    //     title="bar"
    // </pre>
    // if so simplified.
    // @see legacyLocatorAttributeHTML
    // @visibility external
    //<
    simplifyLocatorAttributeHTML: true,

    //> @classAttr AutoTest.legacyLocatorAttributeHTML (boolean : false : [IRW])
    // During script playback/locator lookup, the comparison between canvas and locator
    // attributes will be made after running HTMLString simplification on both, so that both
    // legacy locators and those created with
    // +link{simplifyLocatorAttributeHTML,simplified HTML} will work properly.  However, this
    // property can be set true to completely disable such HTMLString simpliciation.
    //<

    compareHTMLStrings : function (a, b) {
        if (isc.AutoTest.legacyLocatorAttributeHTML) return a == b;
        return String.htmlStringToString(a) == String.htmlStringToString(b);
    },

    //> @classAttr AutoTest.useSearchSegments (boolean : true : [IRW])
    // @include AutoTestLocatorConfiguration.useSearchSegments 
    // @visibility external
    //<
    useSearchSegments:true,

    //> @classAttr AutoTest.searchSegmentsIncludeHidden (boolean : false : [IRWA])
    // @include AutoTestLocatorConfiguration.searchSegmentsIncludeHidden 
    // @visibility external
    //<
    // Setting this property to true will cause ALL search segments that getLocator()
    // generates to be prefixed with "?"
    searchSegmentsIncludeHidden:false,
    
    //> @classAttr AutoTest.useCompactFallbackSyntax (boolean : false : [IRW])
    // @include AutoTestLocatorConfiguration.useCompactFallbackSyntax
    // @visibility external
    //<
    useCompactFallbackSyntax:false,

    //> @classAttr AutoTest.useMinimalFallbackAttributes (boolean : false : [IRW])
    // @include AutoTestLocatorConfiguration.useMinimalFallbackAttributes
    // @visibility external
    //<
    useMinimalFallbackAttributes:false,

    //> @classAttr AutoTest.useIDsAsLocators (boolean : false : [IRW])
    // @include AutoTestLocatorConfiguration.useIDsAsLocators
    // @visibility external
    //<
    useIDsAsLocators:false,

    //> @classAttr AutoTest.useLocalIDsInMinimalLocators (boolean : false : [IRW])
    // During calculation of a +link{getMinimalLocator(),minimal locator}, whether to
    // consider the +link{Canvas.getLocalId(),local ID} of a canvas as a defining property if
    // it's stable (was not automatically assigned) and the canvas is part of a Reify screen.
    // If this property is false, only manually assigned global IDs, binding a widget to the
    // window object, will be considered stable.
    //<

    //> @classMethod AutoTest.getMinimalLocator()
    // Convenience method to generate a +link{type:AutoTestLocator} that is as compact
    // as possible.
    // <P>
    // This method sets +link{AutoTest.getLocator()} with the following 
    // +link{AutoTestLocatorConfiguration,configuration settings}:
    // <ul>
    //  <li>useSearchSegments:true</li>
    //  <li>searchSegmentsIncludeHidden:false</li>
    //  <li>useMinimalFallbackAttributes:true</li>
    //  <li>useCompactFallbackSyntax:true</li>
    // </ul>
    // @param [target] (DOMElement | Canvas | FormItem) Target within the page. This may be
    //  a DOM element, a +link{Canvas} or a +link{FormItem}. If null, a locator for
    //  the last mouse event target DOM element will be generated.
    // @param [checkForNativeHandling] (boolean) If this parameter is passed in, check whether
    //  the target element responds to native browser events directly rather than going through
    //  the SmartClient widget/event handling model. If we detect this case, return null rather
    //  than a live locator.  This allows us to differentiate between (for example) an event on
    //  a Canvas handle, and an event occurring directly on a simple 
    //  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.
    // @param [coords] (Array) X, Y page position
    // @return (AutoTestLocator) minimal locator string to identify the target.
    // @visibility external
    //<
    

    
    checkMinimalLocatorUniqueness:true,
    minimalLocatorConfiguration:{
        useCompactFallbackSyntax: true,
        useMinimalFallbackAttributes: true,
        useSearchSegments:true,
        useIDsAsLocators:true
    },
    getMinimalLocator : function (DOMElement, checkForNativeHandling, coords, overrides) {

        if (this.checkMinimalLocatorUniqueness) {
            overrides = isc.addProperties({}, this.minimalLocatorConfiguration, overrides);
            return this.getLocator(DOMElement, checkForNativeHandling, coords, overrides);
        } else {
            
            return this._getLocator("getMinimalLocatorDescriptor", DOMElement,
                                    checkForNativeHandling, coords, overrides);
        }
    },

    // Validate a locator with search segments.
    // If the search segment(s) resolve to a single canvas in the live app, returns true.
    // If the search segment(s) are ambiguous (they resolve to more than one component), returns false
    // If the locator does not resolve to any components, returns null
    
    validateLocator : function (locator) {
        
        if (locator == null || isc.isAn.emptyString(locator)) return null;

        if (locator == null) return null;
        locator = this._normalizeLocatorString(locator);

        var locatorArray = locator.split("/"),
            component;
        
        //this.logWarn("locatorArray" + locatorArray);
        var baseComponentID = locatorArray[0];
        if (!baseComponentID) return null;
        
        var baseComponent = this.getBaseComponentFromLocatorSubstring(baseComponentID, null, true);
        if (baseComponent == null) return null;
        if (isc.isAn.Array(baseComponent)) {
            if (baseComponent.length > 1) return false;

            baseComponent = baseComponent[0];
        }

        var i = 0,
            child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray, null, true);
        
        
        while (child != null) {
            if (isc.isAn.Array(child)) {
                if (child.length > 1) return false;
                child = child[0];
            }
            i++;
            baseComponent = child;
            child = baseComponent.getChildFromLocatorSubstring(locatorArray[i], i, locatorArray, null, true);
        }
        if (baseComponent == null) return null;
        return true;
    },

    //> @classAttr AutoTest.alwaysSearchHidden (boolean : false : IRW)
    // When resolving locators via +link{getElement()}, +link{getObject} and related
    // methods, should search segments in a locator be resolved by searching
    // hidden or undrawn canvases as well as visible canvases, even if they
    // do not include the marker to explicitly request this.
    // 
    // @visibility internal
    //<
    
    alwaysSearchHidden:false,

    
    maySearchForLocatorChildren:true,
    
    _searchForCanvas : function (parent, segment, getAllMatches, includeHidden) {
        var searchMatches = segment.match("(.*)\\[(.*)=\"(.*)\"\\]");
        if (!searchMatches) {
            this.logInfo("bad search segment syntax: " + segment);
            return null;
        }
        var scClass = searchMatches[1],
            propName = searchMatches[2],
            propValue = searchMatches[3];

        var proxyMarker,
            proxyMatch = propName.match("(t|i|s):(.*)");
        if (proxyMatch) {
            proxyMarker = proxyMatch[1];
            propName = proxyMatch[2];
        }

        var warnOnDuplicates = !getAllMatches && isc.AutoTest.logIsWarnEnabled("minimalLocator");
        var ignoreDuplicates = !getAllMatches && !warnOnDuplicates
        var results = this._getSearchMatches(
                        parent, scClass, 
                        propName, propValue, proxyMarker,
                        includeHidden, ignoreDuplicates
                      );

        // If we didn't find any matches, search again, including widgets with explicit locatorParent
        if (this.maySearchForLocatorChildren && (results == null || results.length == 0)) {
            results = this._getSearchMatches(
                parent, scClass, 
                propName, propValue, proxyMarker,
                includeHidden, ignoreDuplicates,
                true
              );
        }

        if (getAllMatches) return results;

        if (results == null) return null;

        // warn if more than one widget matches class and defining property value
        if (warnOnDuplicates && results.length > 1) {
            var collidingIds = results.map(function (widget) {return widget.getID();});
            isc.AutoTest.logWarn("Multiple matches were found with a " + propName +
                                    " value of '" + propValue + "': " + collidingIds +
                                    ".  The first match will be returned.", "minimalLocator");
        }

        return results[0];

    },

    _getSearchMatches : function (parent, scClass, propName, propValue, proxyMarker, includeHidden, ignoreDuplicates, includeLocatorChildren) {
    
        if (isc[scClass] == null || !isc.isA.Class(isc[scClass])) {
            this.logInfo("Unknown framework class: '" + scClass +  "' in AutoTest locator search segment");
            return null;
        }

        if (propName == "ID") {
            var canvas = window[propValue];
            if (isc.isA.Canvas(canvas)) return [canvas];
            this.logInfo("ID '" + propValue + "' is not a canvas");
            return null;
        }

        var candidates = parent ? parent.children : isc.Canvas._topCanvii;
        if (candidates) candidates = candidates.duplicate();
        else return null;
    
        var results;
        for (var i = 0; i < candidates.length; i++) {
            var candidate = candidates[i];
            if (!candidate) continue;

            // pare out hidden search candidates if appropriate.
            
            if (!includeHidden && !this.alwaysSearchHidden && !(candidate.isVisible() && candidate.isDrawn()) ) {
                continue;
            }
            
            // conduct depth-first search by adding children as candidates
            if (candidate.children) candidates.addList(candidate.children);
            if (this._candidateMatchesSearchSegment(candidate, scClass, propName, propValue, proxyMarker, includeLocatorChildren)) {
                if (!results) {
                    results = [candidates[i]];
                } else {
                    results.add(candidates[i]);
                }
                // Optimization: If we don't care about duplicates we're done
                if (ignoreDuplicates) break;
            }

        }
        
        return results;

    },
    _candidateMatchesSearchSegment : function (candidate, scClass, propName, propValue, proxyMarker, includeLocatorChildren) {

        // skip candidates that doen't have the right framework class
        if (!isc.isA[scClass](candidate)) return false;

        // Explicitly disallow finding anything that isn't a 'qualifying container'
        // EG an autoChild
        // This means that you explicitly can't access an autoChild via "//Class[title=foo]"
        // It also means we don't have to consider invalid targets as potential duplicates
        // when generating locators with search segments - for example a ListGrid's filterEditor
        // has the same dataSource as the grid but shouldn't prevent searching for the LG
        
        if (!includeLocatorChildren && !candidate._isQualifyingContainer("definingProperty", {})) {
            return false;
        }

        // target the candidate's proxy if a proxy marker is present
        if (proxyMarker) {
            var proxy = candidate._getContainerProxy(proxyMarker);
            if (!proxy || proxy == candidate) return false;
            candidate = proxy;
        }



        // check if candidate's definitive property matches
        return (propValue == candidate.getDefiningPropertyValue(propName));
    },

    _minimalFallbackProps: [
        "index", "length", "Class", "classIndex", "classLength",
        "scClass", "scClassIndex", "scClassLength"
    ],

    _getNewFallbackConfig : function () {
        // mark the new config to distinguish from original
        return Object.defineProperty({}, "_isNew", {
            value: true, enumerable: false
        });
    },

    minimizeFallbackConfig : function (config, object, sourceArray) {
        var definingProp;

        // determine the defining property for the config
        if (object) {
            definingProp = object.getDefiningPropertyName();
        }
        else if (config.name)  definingProp = "name";
        else if (config.title) definingProp = "title";

        var newConfig = this._getNewFallbackConfig();

        // only pass through the defining property, if populated
        
        if (config[definingProp]) {
            var uniqueDefiningProp = true;
            if (object != null && sourceArray != null) {
                var matches = sourceArray.findAll(definingProp, config[definingProp]);
                uniqueDefiningProp = (matches.length == 1);
            }
            if (uniqueDefiningProp) {
                newConfig[definingProp] = config[definingProp];
                return newConfig;
            }
        }

        // otherwise, pass through index, classIndex, etc. metadata
        var minimalProps = this._minimalFallbackProps;
        for (var i = 0; i < minimalProps.length; i++) {
            var prop = minimalProps[i];
            if (prop in config) newConfig[prop] = config[prop];
        }

        
        if (isc.isAn.emptyObject(newConfig) && this.fallback_valueOnlyField in config) {
            var prop = this.fallback_valueOnlyField;
            newConfig[prop] = config[prop];
        }

        return newConfig;
    },

    _addCompactFallbackIndexMarker : function (config, indexProp, lengthProp, classProp) {
        var index  = config[indexProp],
            length = config[lengthProp];
        delete config[indexProp];
        delete config[lengthProp];
        // add compact marker if both index and length are defined and length > 1
        if (index != null && length > 1) {
            var indexMarker = (index + 1) + "of" + length;
            if (classProp) config[classProp] += "(" + indexMarker + ")";
            else config[this.fallback_valueOnlyField] = indexMarker;
        }
    },

    // Compact locator syntax is either "2of2" to indicate standalone index/length
    // attributes [used for children and members], or something like "ListGrid(2of2)"
    // to indicate both details of the child *type* [eg sc class name], index/length
    _expandCompactFallbackMarker : function (config, classProp) {

        if (classProp == this.fallback_valueOnlyField) {
            var markerMatch = config[classProp].match(/([0-9]+)of([0-9]+)/);
            if (markerMatch) {
                delete config[classProp];
                config.index = markerMatch[1] - 1;
                config.length = markerMatch[2];
            }
        } else {
            var markerMatch = config[classProp].match(/([A-Za-z_]+)\\(([0-9]+)of([0-9]+)\\)/);
            if (markerMatch) {
                config[classProp] = markerMatch[1];
                config[classProp + "Index"] = markerMatch[2] - 1;
                config[classProp + "Length"] = markerMatch[3];
            }
        }

    },

    // If index/length weren't explicitly specified in a compact fallback locator, default to 1 of 1
    _defaultCompactFallbackMarker : function (config, propertyPrefix) {
        var indexProp = propertyPrefix ? propertyPrefix + "Index" : "index";
        var lengthProp = propertyPrefix ? propertyPrefix + "Index" : "index";
        if (config[lengthProp] == null && config[indexProp] == null) {
            config[lengthProp] = 1;
            config[indexProp] = 0;
        }
    },

    _expandCompactFallbackConfig : function (config) {
        for (var prop in config) {
            if (prop == this.fallback_valueOnlyField || prop == "Class" || prop == "scClass") {
                this._expandCompactFallbackMarker(config, prop);
            }
        }
        if (config.Class) {
            this._defaultCompactFallbackMarker(config);
            this._defaultCompactFallbackMarker(config, "class");
        }
        if (config.scClass) {
            this._defaultCompactFallbackMarker(config, "scClass");
        }
    },

    _compactifyFallbackConfig : function (config, object) {
        // copy the config if it hasn't yet been copied in createLocatorFallbackPath() flow
        if (!config._isNew) config = isc.addProperties(this._getNewFallbackConfig(), config);

        this._addCompactFallbackIndexMarker(config, "index", "length");
        this._addCompactFallbackIndexMarker(config, "classIndex", "classLength", "Class");
        this._addCompactFallbackIndexMarker(config, "scClassIndex", "scClassLength", "scClass");

        return config;
    },


    //> @classMethod AutoTest.isCanvasDone()
    // Returns whether the canvas <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null
    // if the <smartclient>argument is not valid or isn't associated with an element
    // representing</smartclient><smartgwt>supplied argument is not</smartgwt> a valid canvas.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> canvas is drawn
    //     <li> canvas isn't dirty
    //     <li> canvas has no queued overflow operations
    //     <li> canvas is not animating
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>canvas to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>canvas</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    
    isCanvasDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isCanvasDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isCanvasDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself'
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var canvas = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (canvas == null) {
            this._isCanvasDone = "there's no Canvas identified by " + this.getLocator(element);
            return null;
        }

        // if canvas is scheduled to be drawn or is dirty, report as 'not done'
        if (canvas.deferredDrawEvent) {
            canvas.setLogFailureText(true, null, "is scheduled to be drawn");
            return false;
        }
        if (canvas.isDirty()) {
            if (this.logIsDebugEnabled("quiescence")) {
                var ids = isc.Canvas._redrawQueue.map(function(canvas){
                    return canvas.getID();
                });
                this.logDebug(ids.length + " canvii queued for redraw: " + ids, "quiescence");
            }
            canvas.setLogFailureText(true, null, "is dirty");
            return false;
        }

        // if canvas has pending overflow operations, report as 'not done'
        if (canvas._overflowQueued) {
            canvas.setLogFailureText(true, null, "has pending overflow operations");
            return false;
        }
        // if canvas is animating, report as 'not done'
        if (canvas.isAnimating && canvas.isAnimating() || 
            canvas._animating || canvas._pendingAnimationCallbacks > 0)
        {
            canvas.setLogFailureText(true,  null, "is currently animating");
            return false;
        }

        // if canvas has a pending scroll, report as 'not done'
        if (canvas._scrollTimeout != null) {
            canvas.setLogFailureText(true,  null, "currently has pending scroll events");            
            return false;
        }

        
        if (isc.SplitPaneSidePanel && isc.isA.SplitPaneSidePanel(canvas) && !canvas.onScreen) {
            canvas.setLogFailureText(true, null, "has not yet set onSCreen: true");
            return false;            
        }

        return true;
    },

    //> @classMethod AutoTest.isTileLayoutDone()
    // Returns whether the TileLayout <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null if the
    // <smartclient>argument is not valid or isn't associated with an element representing
    // </smartclient><smartgwt>supplied canvas is not</smartgwt> a valid TileLayout.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> the TileLayout (as a canvas) satisfies +link{isCanvasDone()}
    //     <li> the TileLayout is not currently animating any layout operations
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>TileLayout to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>TileLayout</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isTileLayoutDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isTileLayoutDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isTileLayoutDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var tileLayout = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (tileLayout == null || !isc.isA.TileLayout(tileLayout)) {
            this._isTileLayoutDoneLog = this.getLocator(element) +
                " does not correspond to a valid TileLayout!";
            return null;
        }

        // fail if underlying canvas is not reporting done
        if (!this.isCanvasDone(tileLayout)) return false;

        // fail if pending layout animation operations or currently animating
        if (tileLayout.isAnimatingTileLayout()) {
            tileLayout.setLogFailureText(true, null, "is currently animating");
            return false;
        }

        // fail if a layoutAfterScroll has been scheduled
        if (tileLayout._layoutEventId != null) {
            tileLayout.setLogFailureText(true, null, "has a layout after scroll scheduled");
            return false;
        }            

        return true;
    },

    //> @classMethod AutoTest.isTileGridDone()
    // Returns whether the TileGrid <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null if the
    // <smartclient>argument is not valid or isn't associated with an element representing
    // </smartclient><smartgwt>supplied canvas is not</smartgwt> a valid TileGrid.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> the TileGrid (as a tileLayout) satisfies +link{isTileLayoutDone()}
    //     <li> the TileGrid has no pending layout animation operations queued
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>TileGrid to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>TileGrid</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isTileGridDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isTileGridDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isTileGridDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var tileGrid = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (tileGrid == null || !isc.isA.TileGrid(tileGrid)) {
            this._isTileGridDoneLog = this.getLocator(element) +
                " does not correspond to a valid TileGrid!";
            return null;
        }

        // fail if underlying canvas is not reporting done
        if (!this.isTileLayoutDone(tileGrid)) return false;

        // fail if pending layout animation operations or currently animating
        if (tileGrid.pendingActionOnPause("tileGridAnimate")) {
            tileGrid.setLogFailureText(true, "there is a pending animation for");
            return false;
        }

        // check for pending network operations if user has requested implicit waits
        if (this.implicitNetworkWait && tileGrid.requestsArePending()) {
            tileGrid.setLogFailureText(true, "there are DSRequests pending for");
            return false;
        }

        return true;
    },

    //> @classMethod AutoTest.isFormDone()
    // Returns whether the DynamicForm <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null
    // if the <smartclient>argument is not valid or isn't associated with an element
    // representing</smartclient><smartgwt>supplied argument is not</smartgwt> a valid
    // +link{DynamicForm}.  Otherwise, returns true or false according as the conditions
    // below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> form has no pending delayed "set values" or "set values focus" operations
    //     <li> all contained items satisfy +link{isItemDone()}
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>canvas to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>canvas</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isFormDone : function (element, strictMode) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isFormDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isFormDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // if a DOM element has been passed, resolve it into a DynamicForm and FormItem
        var form = element, item;
        if (!isc.isA.Class(element)) {
            form = this.locateCanvasFromDOMElement(element);
            item = this.locateFormItemFromDOMElement(form);
        }

        // bail out if not a DynamicForm, or if invalid FormItem found
        if (!isc.isA.DynamicForm(form)) {
            this._isFormDoneLog = element + " does not correspond to a valid DynamicForm!";
            return null;
        }
        if (item != null && !(isc.FormItem && isc.isA.FormItem(item))) {
            this._isFormDoneLog = "invalid FormItem passed";
            return null;
        }

        // we're not "done" if there's a pending _delayedSetValues()/_delayedSetValuesFocus()
        if (form._setValuesPending) {
            form.setLogFailureText(true, "a delayedSetValues(Focus)() call is pending for");
            return false;
        }

        

        
        var checkOnlyIfDrawn = true;

        // fail if any FormItems (or the one passed) are not done
        var itemsToCheck = item ? [item] : form.items;
        for (var i = 0; i < itemsToCheck.length; i++) {
            var itemToCheck = itemsToCheck[i];
            if (itemToCheck.containerWidget == form) checkOnlyIfDrawn = false;

            // skip invisible items if checking all items
            if (!item && !itemToCheck.isVisible()) continue;

            var itemDone = this.isItemDone(itemToCheck, strictMode);
            if (itemDone != true) return itemDone;
        }

        // if we're not in "strict mode" or form is drawn, it must satisy isCanvasDone()
        if ((!checkOnlyIfDrawn || form.isDrawn()) && !this.isCanvasDone(form)) return false;

        return true;
    },

    //> @classMethod AutoTest.isItemDone()
    // Returns whether the FormItem <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null
    // if the <smartclient>argument is not valid or isn't associated with an element
    // representing</smartclient><smartgwt>supplied argument is not</smartgwt> a valid
    // +link{FormItem}.  Otherwise, returns true or false according as the conditions
    // below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> if the container widget of the item isn't the parent DynamicForm, then the
    //          container widget must satisfy +link{isCanvasDone()} (or +link{isGridDone()},
    //          etc., as appropriate)
    //     <li> the item cannot have any fetches in progress for missing display/value field
    //          values
    //     <li> picklists (+link{selectItem} or +link{comboBoxItem}) cannot have any pending row
    //          fetches
    //     <li> any contained +link{FormItem}s must satisfy <code>isItemDone()</code> themselves
    //     <li> any contained +link{Canvas} must satisfy +link{isCanvasDone()} (or 
    //          +link{isGridDone()}, etc., as appropriate)
    // </ul>
    // @param element (FormItem | DOMElement | AutoTestLocator) <smartclient> DOM element to
    // test (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>canvas to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>item</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    isItemDone : function (element, strictMode, skipContainerCheck) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isItemDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isItemDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // if a DOM element has been passed, resolve it into a DynamicForm and FormItem
        var item = element;
        if (!(isc.FormItem && isc.isA.FormItem(element))) {
            item = this.locateFormItemFromDOMElement(element);
        }

        // bail out if not resolved to a FormItem
        if (!(isc.FormItem && isc.isA.FormItem(item))) {
            this._isItemDoneLog = element + " does not correspond to a valid FormItem!";
            return null;
        }

        // check that any container widget is "done"
        
        var form = item.form,
            containerWidget = !skipContainerCheck && !item.destroyed && item.containerWidget;
        if (containerWidget && containerWidget != form && 
            !containerWidget._isProcessingDone(strictMode))
        {
            item.setLogFailureText(true, "the container canvas of", "reports " +
                                   this.getLogFailureText(true));
            return false;
        }

        // formItems cannot have any fetches in progress for display or value field values
        if (item._fetchMissingValueInProgress(true)) {
            item.setLogFailureText(true, "display/value field values are being fetched for");
            return false;
        }

        // textItems cannot have any pending delayed select operations
        if (isc.isA.TextItem(item) && item._delayedSelect) {
            item.setLogFailureText(true, "a delayed select operation " +
                                   "is pending for");
            return false;
        }

        // selectItems/comboBoxItems cannot have pending fetches
        if (isc.PickList && isc.isA.PickList(item)) {
            if (item.pendingActionOnPause("fetch")) {
                item.setLogFailureText(true, "a delayed fetch is queued for");
                return false;
            }
            if (item._fetchingPickListData) {
                item.setLogFailureText(true, null, "has a fetch oustanding");
                return false;
            }
        }

        

        // check that all contained formItems satisfy isItemDone()
        var subItems = item.items || [];
        for (var i = 0; i < subItems.length; i++) {
            if (isc.FormItem && isc.isA.FormItem(subItems[i]) &&
                !this.isItemDone(subItems[i], strictMode, true)) 
            {
                item.setLogFailureText(true, "a contained item of", "reports " +
                                       this.getLogFailureText(true));
                return false;
            }
        }

        // descend recursively into any contained canvas of a CanvasItem
        var subCanvas = item.canvas;
        if (isc.isA.Canvas(subCanvas) && !subCanvas._isProcessingDone(strictMode)) {
            item.setLogFailureText(true, "a contained canvas of", "reports " +
                                   this.getLogFailureText(true));
            return false;
        }

        return true;
    },

    // internal helper only called by isGridDone()
    _isGridBodyDone : function (gridBody) {
        if (gridBody == null) return true;
        
        var text = "body",
            grid = gridBody.grid;

        if (grid.body != gridBody) text = "frozen " + text;

        if (!this.isCanvasDone(gridBody)) {
            return false;
        }

        // if a scroll is in progress, we're not done
        if (gridBody.pendingActionOnPause("scrollRedraw")) {
            grid.setLogFailureText(true, "the " + text + " of", "is scrolling");
            return false;
        }
        // if a row animation is in progress or event handling is suppressed, we're not done
        if (gridBody._suppressEventHandling()) {
            grid.setLogFailureText(true, "the " + text + " of", "is suppressing events");
            return false;
        }
        var eventRow = gridBody.getEventRow(),
            eventCol = gridBody.getEventColumn();
        if (eventRow >= 0 && eventCol >= 0 && !gridBody._readyToRefreshCell(eventRow, eventCol)) {
            grid.setLogFailureText(true, "the " + text + " of", "is not ready to refresh the cell that was the target of the last event");
            return false;
        }
        if (gridBody._delayedRowAnimation) {
            grid.setLogFailureText(true, "the " + text + " of", "has a delayed row animation");
            return false;
        }
        if (gridBody._rowAnimationInfo ||
            gridBody._rowHeightAnimation ||
            gridBody._animatedShowStartRow != null)
        {
            grid.setLogFailureText(true, "the " + text + " of", "is running a row animation");
            return false;
        }

        return true;
    },

    //> @classMethod AutoTest.isGridDone()
    // Returns whether the ListGrid <smartclient>associated with or contained by the given
    // DOM element</smartclient><smartgwt>supplied or containing the supplied canvas</smartgwt>
    // is in a consistent state with no pending operations.  Returns null if the <smartclient>
    // argument is not valid or isn't associated with an element inside a valid ListGrid.
    // </smartclient><smartgwt>supplied canvas is not a ListGrid or contained in a ListGrid.
    // </smartgwt>
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> no pending scroll operations
    //     <li> no pending filter editor operations
    //     <li> no unsaved edits to the grid records
    //     <li> no asynchronous regrouping operations are in progress
    //     <li> no outstanding fetch/filter operations are present for the ResultSet
    //     <li> no outstanding sort operations are present that will update the ListGrid
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>canvas to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>canvas</smartgwt> is 'done' as described above
    // @visibility external
    // @group autoTest
    //<

    
    isGridDone : function (element, includeEdits) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isGridDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isGridDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var grid = isc.isA.Canvas(element) ? element : 
             this.locateCanvasFromDOMElement(element);

        // element may point to interior widget; search up to find owning ListGrid
        while (grid != null && !isc.isA.ListGrid(grid)) grid = grid.parentElement;

        // if owning ListGrid not found, report to alert the user and return false
        if (grid == null) {
            this._isGridDoneLog = "there's no ListGrid containing locator " + 
                this.getLocator(element);
            return null;
        }

        if (!this.isCanvasDone(grid)) {
            return false;
        }

        if (grid.layoutIsDirty()) {
            grid.setLogFailureText(true, "has a pending reflow");
            return false;
        }

        // if the grid has a summary row child grid, verify that it's done as well
        if (grid.summaryRow && !isc.AutoTest.isGridDone(grid.summaryRow, includeEdits)) {
            // log from nested call should be reported by the testReplay logger
            return false;
        }

        // check for pending network operations if user has requested implicit waits
        if (this.implicitNetworkWait && grid.requestsArePending()) {
            grid.setLogFailureText(true, "there are DSRequests pending for");
            return false;
        }

        // check for active field generation Promises on the grid
        var promises = isc.FieldGeneratorUtil._getFieldGenPromises(grid, null, false);
        if (promises && !promises.isEmpty()) {
            grid.setLogFailureText(true, "there is an active field generation Promise");
            return false;
        }

        // check for active field generation Promises on fields
        var fields = grid.getAllFields();
        if (fields) {
            for (var fieldIndex = 0, numFields = fields.length; fieldIndex < numFields; ++fieldIndex) {
                var field = fields[fieldIndex];
                promises = isc.FieldGeneratorUtil._getFieldGenPromises(grid, field, false);
                if (promises && !promises.isEmpty()) {
                    grid.setLogFailureText(true, "field '" + field.name + "' has an active field generation Promise");
                    return false;
                }
            }
        }

        var filterEditor = grid.filterEditor;

        // if the grid's filter editor has pending criteria, we cannot proceed
        if (filterEditor && filterEditor.pendingActionOnPause("performFilter")) {
            grid.setLogFailureText(true, "there is a pending " + 
                                   "filter operation for the FilterEditor of");
            return false;
        }

        
        if (includeEdits && grid.hasChanges() && !isc.isA.RecordEditor(grid)) {
            grid.setLogFailureText(true, null, "has unsaved edits");
            return false;
        }

        // if an asynchronous regroup is in progress we're not done
        if (grid._asyncRegroupInProgress) {
            grid.setLogFailureText(true, null, "is regrouping asynchronously");
            return false;
        }

        // make sure there's no outstanding fetch/filter operation on ResultSet
        if (isc.ResultSet && isc.isA.ResultSet(grid.data)) {
            if (!grid.data.lengthIsKnown()) {
                grid.setLogFailureText(true, "the length of the ResultSet " + 
                                       "associated with", "is not yet known");
                return false;
            }
            if (grid.data.fetchIsPending()) {
                grid.setLogFailureText(true, "has a pending fetch");
                return false;
            }
            if (grid.data.isAsyncFilterAndSortRunning()) {
                grid.setLogFailureText(true, "is running asynchronous filters and/or sorts");
                return false;
            }
        }

        // for a paged ResultTree, verify that a fetch isn't pending on nested ResultSets
        if (isc.ResultTree && isc.isA.ResultTree(grid.data) && grid.data.isPaged()) {
            if (grid.data._pendingResultSetActionOnPause("fetchRemoteData")) {
                grid.setLogFailureText(true, "has a pending fetch");
                return false;
            }
        }

        // in useHighPerformanceGridTimings mode, there is no modal prompt, but the grid sets
        // this internal flag for when data is being fetched
        if (grid.loadingData) return false;

        if (grid._pendingFolderAnim) {
            grid.setLogFailureText(true, "has a pending row animation");
            return false;
        }
        if (grid._rowAnimationCompleteCallback) {
            grid.setLogFailureText(true, "is running a row animation");
            return false;
        }
        if (grid._deferredApplyHilites) {
            grid.setLogFailureText(true, "is deferring applying hilites");
            return false;
        }
        if (grid._folderToggleObsRan) {
            grid.setLogFailureText(true, "has batched folder operations");
            return false;
        }

        // at this point we're done iff the body and frozen body (if any) are done
        return this._isGridBodyDone(grid.body) && this._isGridBodyDone(grid.frozenBody);
    },

    //> @classMethod AutoTest.isDrawPaneDone()
    // Returns whether the DrawPane <smartclient>associated with the given DOM element
    // </smartclient>is in a consistent state with no pending operations.  Returns null if the
    // <smartclient>argument is not valid or isn't associated with an element representing
    // </smartclient><smartgwt>supplied canvas is not</smartgwt> a valid DrawPane.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> the DrawPane (as a canvas) satisfies +link{isCanvasDone()}
    //     <li> the DrawPane has no pending +link{DrawItem} (re)draws
    // </ul>
    // @param element (Canvas | DOMElement | AutoTestLocator) <smartclient> DOM element to test
    // (element obtained from canvas or SmartClient locator if provided)</smartclient>
    // <smartgwt>DrawPane to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>DrawPane</smartgwt> is 'done' as described above
    // @group autoTest
    //<
    isDrawPaneDone : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isTileGridDoneLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isDrawPaneDoneLog = "the element is null";
            return null;
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) element = this.getElement(element);

        // allow a canvas to be passed in as the element
        var drawPane = isc.isA.Canvas(element) ? element : 
            this.locateCanvasFromDOMElement(element);

        // if canvas not valid, report to alert the user and return false
        if (drawPane == null || !isc.isA.DrawPane(drawPane)) {
            this._isDrawPaneDoneLog = this.getLocator(element) +
                " does not correspond to a valid DrawPane!";
            return null;
        }

        // fail if underlying canvas is not reporting done
        if (!this.isCanvasDone(drawPane)) return false;

        // fail if there are pending DrawItem (re)draws
        if (drawPane._redrawPending || drawPane._redrawingDelayedDrawItems) {
            drawPane.setLogFailureText(true, null, 
                "currently has DrawItem(s) waiting to be (re)drawn");
            return false;
        }

        return true;
    },
    
    // ensure that Framework focus is consistent with browser 
    _isFocusConsistent : function () {
        var focusCanvas = isc.EH.getFocusCanvas(),
            activeElement = this.getActiveElement()
        ;
        if (focusCanvas) {
            // if focused in a DF, check that focused item's focus element is activeElement
            if (isc.DynamicForm && isc.isA.DynamicForm(focusCanvas)) {
                var item = focusCanvas.getFocusSubItem(),
                    expectedElement = item ? item._getCurrentFocusElement() : null;
                if (expectedElement != activeElement) return false;

            // otherwise, the focus handle of the focused canvas should be the activeElement
            } else {
                if (focusCanvas.getFocusHandle() != activeElement) return false;
            }
            
        // if no canvas is focused, make sure that the activeElement is not inside any canvas
        } else if (activeElement != null) {
            if (isc.EH.getEventTargetCanvas(null, activeElement)) return false;
        }

        return true;
    },

    //> @classMethod AutoTest.isElementClickable()
    // Returns whether the <smartclient>DOM element</smartclient><smartgwt>instance</smartgwt>
    // is ready to be clicked on by a Selenium test.  Returns null if the 
    // <smartclient>argument is not valid or isn't associated with an element representing
    // </smartclient><smartgwt>supplied instance is not</smartgwt> a valid canvas or form item.
    // Otherwise, returns true or false according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> no network operations are outstanding (configurable, 
    //          see +link{AutoTest.implicitNetworkWait})
    //     <li> canvas is visible, enabled, and not masked,
    //     <li> canvas satisfies +link{isCanvasDone()}
    //     <li> if canvas is a TileGrid, it satisfies +link{isTileGridDone()}
    //     <li> if canvas is a TileLayout, it satisfies +link{isTileLayoutDone()}
    //     <li> if canvas is a ListGrid or body of a ListGrid, it satisfies +link{isGridDone()}
    //     <li> if canvas is a DynamicForm, it satisfies +link{isFormDone()}
    // </ul>
    // Note that for a form item in a DynamicForm, the DynamicForm must satisfy the third
    // condition above, while the container widget of the element must satisfy the remaining
    // conditions.
    // 
    // @param element (Canvas | FormItem | DOMElement | AutoTestLocator) 
    // <smartclient> DOM element to test (element obtained from
    // canvas, form item, or SmartClient locator if provided)</smartclient>
    // <smartgwt>instance to test</smartgwt>
    // @return (Boolean) whether <smartclient>element</smartclient>
    // <smartgwt>instance</smartgwt> is 'clickable' as described above
    // @visibility external
    // @group autoTest
    //<
    isElementClickable : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isElementClickableLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isElementClickableLog = "the element is null";
            return null;
        }

        // if a Canvas or FormItem has been passed, try to resolve it to element
        if (isc.isA.Canvas(element) || (isc.FormItem && isc.isA.FormItem(element))) {
            var canvas = element;
            if (!(element = element.getHandle())) {
                this._isElementClickableLog = "no element exists for instance " + canvas.ID;
                return null;
            }
        }

        // support passing a locator as the element in lieu of the element itself
        if (isc.isA.String(element)) {
            var locator = element;
            if (!(element = this.getElement(element))) {
                this._isElementClickableLog = "locator " + locator +
                    " doesn't resolve to an element";
                return null;
            }
        }

        // if locator is valid, but Canvas is not valid (null), something is wrong;
        // report the locator as not clickable and log a warning to the console
        var canvas = this.locateCanvasFromDOMElement(element);
        if (canvas == null) {
            this._isElementClickableLog = "there's no Canvas identified by " + 
                element.getLocator();
            return null;
        }
        // check for pending network operations if user has requested implicit waits
        if (this.implicitNetworkWait && isc.RPCManager.requestsArePending(true)) {
            canvas.setLogFailureText(true, "RPCManager.requestsArePending() for");
            return false;
        }

        // always allow clicking on test root canvas 
        if (canvas == this.testRoot) return true;
        
        // invisible canvas
        if (!canvas.isVisible()) {
            canvas.setLogFailureText(true, null, "isn't visible");
            return false;
        }

        // disabled canvas
        if (canvas.isDisabled()) {
            canvas.setLogFailureText(true, null, "is disabled");
            return false;
        }

        // masked target 
        var item;
        //  for forms, pass the item along when checking the target mask
        if (isc.DynamicForm && isc.isA.DynamicForm(canvas)) {
            item = this.locateFormItemFromDOMElement(element, canvas);
        }
        
        if (isc.EH._targetIsMasked(canvas, item, null, null, true)) {
            var mask = isc.EH.clickMaskRegistry.last() || {},
                instance = window[mask.ID];
            if (isc.isAn.Instance(instance)) {
                instance.setLogFailureText(false, null, "is blocking clicks at " +
                                           canvas._getDescription(true));
            } else {
                var blocker = mask.ID ? "click mask " + mask.ID : "an unknown click mask";
                canvas.setLogFailureText(true, null, "is blocked by " + blocker);
            }
            return false;
        }

        // verify that the associated canvas is done
        return canvas._isProcessingDone();
    },

    //> @classMethod AutoTest.isElementReadyForKeyPresses()
    // Given a DOM element, returns whether the associated SmartClient Canvas or FormItem is
    // ready to receive keyPress events from a Selenium test.  Returns null if the locator is
    // not valid or doesn't represent a valid Canvas or FormItem.  Otherwise, returns true or
    // false  according as the conditions below are all satisfied:
    // <ul>
    //     <li> page has finished loading
    //     <li> if a +link{textItem}, +link{fileItem}, or +link{textAreaItem}, 
    //          it has native focus,
    //     <li> the element satisfies +link{isElementClickable}
    // </ul>
    // @param element (Canvas | FormItem | DOMElement | AutoTestLocator) DOM element to test
    //     (element obtained from canvas, form item, or SmartClient locator if provided)
    // @return (Boolean) whether element is 'ready' as described above
    // @visibility external
    // @group autoTest
    //<
    isElementReadyForKeyPresses : function (element) {

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isElementReadyForKeyPressesLog = "the page is not loaded";
            return false;
        }            
        // bail out with null value if element not valid
        if (element == null) {
            this._isElementReadyForKeyPressesLog = "the element is null";
            return null;
        }

        // if an Canvas or FormItem has been passed, try to resolve it to element
        if (isc.isA.Canvas(element) || (isc.FormItem && isc.isA.FormItem(element))) {
            var canvas = element;
            if (!(element = element.getHandle())) {
                this._isElementClickableLog = "no element exists for instance " + canvas.ID;
                return null;
            }
        }

        // support passing a locator to the element in lieu of the element itself
        if (isc.isA.String(element)) {
            var locator = element;
            if (!(element = this.getElement(element))) {
                this._isElementClickableLog = "locator " + locator +
                    " doesn't resolve to an element";
                return null;
            }
        }

        // if locator is valid, but Canvas is not valid (null), something is wrong;
        // report the locator as not clickable and log a warning to the console
        var canvas = this.locateCanvasFromDOMElement(element);
        if (canvas == null) {
            this._isElementReadyForKeyPressesLog = "there's no Canvas identified by " +
                element.getLocator();
            return null;
        }

        // ensure there are no pending redraws - if a redraw fires, we'll lose focus
        var redrawQueue = isc.Canvas._redrawQeuue;
        if (isc.isAn.Array(redrawQueue) && redrawQueue.length > 0) {
            this.setLogFailureText(false, "the redraw queue contains " + redrawQueue.length +
                                   " canvii, which means that focus is unstable");
            return false;
        }

        // check whether Framework focus is consistent with DOM
        if (!this._isFocusConsistent()) {
            this.setLogFailureText(false, "focus of Framework isn't consistent with DOM");
            return false;
        }

        // text-based elements must have focus to accept keyPresses
        if (this._isTextBased(element) && element != document.activeElement) {
            canvas.setLogFailureText(true, "the text field in", 
                                   "is not the active DOM element");
            return false;
        }

        return this.isElementClickable(element);
    },




    //> @classMethod AutoTest.isSystemDone()
    // Returns a boolean to indicate whether the current application is fully loaded with no pending 
    // operations, and is ready for user interaction. This includes the following checks:
    // <ul>
    //     <li> page has finished loading
    //     <li> all ListGrids (as defined by isc.isA.ListGrid) satisfy +link{isGridDone()}
    //     <li> all TileGrids that are drawn satisfy +link{isTileGridDone()}
    //     <li> all TileLayouts that are drawn satisfy +link{isTileLayoutDone()}
    //     <li> all DynamicForms that are drawn satisfy +link{isFormDone()}
    //     <li> all Canvii that are drawn satisfy +link{isCanvasDone()}
    // </ul>
    // In addition to this the <code>options</code> parameter allows developers to
    // check additional criteria as documented under +link{SystemDoneConfig}.
    // <P>
    // Note: +link{waitForSystemDone()} will poll this method repeatedly to check for all pending 
    // actions being complete. The +link{SystemWaitConfig} parameter of that method 
    // allow the user to speciofy which actions to wait for. By default +link{waitForSystemDone()}
    // will wait for <i>all</i> actions to complete, including queued redraws, timers, network requests,
    // as well as page load and comopnent level <code>is<i>Component</i>Done</code> checks.
    // <P>
    // Depending on your application configuration, it is possible that this method
    // will not be able to determine whether it is truly in a busy state. Some examples include:
    // <ul>
    //  <li>If +link{systemDoneConfig.includeTimers} is true and the application has
    //      a constantly running background timer to perform some
    //      ongoing polling action or similar, this method may return <code>false</code>
    //      even though the application is ready for interaction
    //  </li>
    //  <li>Similarly if +link{systemDoneConfig.includeRedraws} is true, and the application is
    //      using messaging, or some other mechanism to periodically refresh component(s)
    //      such that they are repeatedly marked as dirty, this method may return
    //      <code>false</code> even though the application is ready for interaction
    //  </li>
    //  <li>If this application makes use of some third-party library to perform
    //      asynchronous actions, this method may return <code>true</code> even when
    //      the application is waiting on a response from this third-party tool.
    //  </li>
    // </ul>
    //
    // @param [options] (SystemDoneConfig | boolean) This parameter determines what specific
    //  outstanding actions are required to be completed before the system is considered
    //  "done" with current processing. If passed as a boolean rather than a SystemDoneConfig
    //  object, this determines whether the system should wait for
    //  +link{canvas.markForRedraw(),pending redraws}.
    //
    // @return (boolean) whether loaded page is 'done' as described above
    // @visibility external
    // @group autoTest
    //<
    
    
    isSystemDone : function (options, includeEdits) {

        
        if (isc.isA.String(options)) options = JSON.parse(options);
            
        var includeRedraws, includeNetworkOperations, includeBackgroundNetworkOperations,
            includeFileLoader, includeTimers;
        
        if (isc.isAn.Object(options)) {
            includeRedraws = options.includeRedraws;
            includeNetworkOperations = options.includeNetworkOperations;
            includeBackgroundNetworkOperations = options.includeBackgroundNetworkOperations;
            includeFileLoader = options.includeFileLoader;
            includeTimers = options.includeTimers;
            includeEdits = options.includeEdits;
        } else {
            includeRedraws = options;
        }

        

        // parts of AutoTest.js aren't present until page is loaded
        if (!isc.Page.isLoaded()) {
            this._isSystemDoneLog = "the page is not loaded";
            return false;
        }

        if (includeTimers) {
            for (var timerID in isc.Timer._tmrIDMap) {
                var actionID = isc.Timer._tmrIDMap[timerID];
                if (!isc.Timer._backgroundRepeatTimers[actionID]) {
                    return false;
                }
            }
        }

        // check for widgets queued for destroy()
        var destroyQueue = isc.Canvas._destroyQueue;
        if (destroyQueue.length > 0) {
            this._isSystemDoneLog = "there are " + destroyQueue.length + " pending destroys";
            return false;
        }

        // EventHandler page-level resize is in progress
        if (isc.EH.resizeTimer != null) {
            this._isSystemDoneLog = "there is a pending EventHandler page-level resize queued";
            return false;
        }

        // check for pending network operations if user has requested implicit waits
        if (includeNetworkOperations == null) includeNetworkOperations = this.implicitNetworkWait;
        if (includeNetworkOperations) {
            // by default we ignore background network operations.
            var ignoreBackgroundOps = !includeBackgroundNetworkOperations;
            if (isc.RPCManager && isc.RPCManager.requestsArePending(ignoreBackgroundOps)) {
                if (this.logIsDebugEnabled("quiescence")) {
                    isc.RPCManager._logPendingTransactions("quiescence", this);
                }
                this._isSystemDoneLog = "RPCManager.requestsArePending() is true";
                return false;
            }
        }
        if (includeFileLoader) {
            
            if (isc.FileLoader && isc.FileLoader.loadFilesPending && isc.FileLoader.loadFilesPending()) {
                this._isSystemDoneLog = "FileLoader requests are pending";
                return false;
            }
        }

        // check for pending redraws if requested
        var redrawQueue = isc.Canvas._redrawQeuue;
        if (includeRedraws && isc.isAn.Array(redrawQueue) && redrawQueue.length > 0) {
            this._isSystemDoneLog = "there are " + redrawQueue.length + " pending redraws";
            return false;
        }

        

        // check each canvas in the global list for being "done""
        for (var i = 0; i < isc.Canvas._canvasList.length; i++) {
            var canvas = isc.Canvas._canvasList[i];
            if (!canvas._isProcessingDone(true, includeEdits)) {
                this._isSystemDoneLog = "Canvas " + canvas.ID + " is not done processing";
                return false;
            }
        }
        delete this._isSystemDoneLog;        
        return true;
    },

    //> @object SystemDoneConfig
    // Configuration object for +link{AutoTest.isSystemDone()}.
    // <P>
    // Note that this format is extended by +link{SystemWaitConfig} and
    // +link{ElementWaitConfig}, used by
    // +link{AutoTest.waitForSystemDone()} and +link{AutoTest.waitForElement()}.
    // <P>
    // Note also that +link{AutoTest.waitForSystemDone()} may have different default
    // configuration from +link{AutoTest.isSystemDone()} - the default behavior for each option
    // is documented on the appropriate config object type for the method.
    //
    // @treeLocation Concepts/Automated Testing/AutoTest
    // @visibility external
    //<
    
    //> @attr SystemDoneConfig.includeRedraws (Boolean : false : IR)
    // Should the system wait for any outstanding redraws to complete before
    // +link{AutoTest.isSystemDone()} returns true?
    // @visibility external
    //<

    // Note: systemDoneConfig.includeEdits is technically supported by isSystemDone()
    // but undocumented - this is essentially an equivalent to the
    // deprecated "includeEdits" argument to that method.

    //> @attr SystemDoneConfig.includeNetworkOperations (Boolean : null : IR)
    // Should the system wait for any outstanding +link{RPCManager,RPC Requests} to complete before
    // +link{AutoTest.isSystemDone()} returns true?
    // <P>
    // If not explicitly set, +link{isc.AutoTest.implicitNetworkWait} will be consulted
    //
    // @visibility external
    //<

    //> @attr SystemDoneConfig.includeFileLoader (Boolean : true : IR)
    // Should the system wait for any outstanding +link{FileLoader.loadFiles(),FileLoader} requests?
    // to complete before +link{AutoTest.isSystemDone()} returns true?
    // @visibility external
    //<

    //> @attr SystemDoneConfig.includeTimers (Boolean : false : IR)
    // Should the system wait for all outstanding registered +link{isc.Timer.setTimeout(),timer actions}
    // to complete before +link{AutoTest.isSystemDone()} returns true?
    // @visibility external
    //<

    //> @object SystemWaitConfig
    // Configuration object for +link{AutoTest.waitForSystemDone()}
    // @treeLocation Concepts/Automated Testing/AutoTest
    // @inheritsFrom SystemDoneConfig
    // @visibility external
    //<
    
    //> @attr SystemWaitConfig.timeout (number : null : IR)
    // Timeout for +link{Autotest.waitForElement()} in ms.
    // <P>
    // If unset a default timeout of 30 seconds will be used.
    //
    // @visibility external
    //<

    // We turn *on* all the wait config flags in waitForSystemDone by default
    // Explicitly re-doc to indicate this

    //> @attr SystemWaitConfig.includeRedraws (Boolean : true : IR)
    // @include systemDoneConfig.includeRedraws
    // @visibility external
    //<

    //> @attr SystemWaitConfig.includeNetworkOperations (Boolean : true : IR)
    // @include systemDoneConfig.includeNetworkOperations
    // @visibility external
    //<

    //> @attr SystemWaitConfig.includeFileLoader (Boolean : true : IR)
    // @include systemDoneConfig.includeFileLoader
    // @visibility external
    //<

    //> @attr SystemWaitConfig.includeTimers (Boolean : true : IR)
    // @include systemDoneConfig.includeTimers
    // @visibility external
    //<


    //> @classMethod AutoTest.waitForSystemDone()
    // Fires the provided callback when +link{isSystemDone()} returns true.
    // <P>
    // By default this will wait for the following system actions to complete:
    // <ul>
    // <li>All outstanding SmartClient +link{RPCManager,RPC and DataSource requests}</li>
    // <li>All outstanding +link{FileLoader,FileLoader requests}</li>
    // <li>Any +link{canvas.markForRedraw(),queued redraws}</li>
    // <li>Any non-recurring +link{Timer,delayed actions}</li>
    // </ul>
    // Note that this behavior may differ from the default settings for
    // +link{isSystemDone()}
    // <P>
    // The <code>options</code> parameter gives developers finer grained control
    // over what to wait for.
    // 
    // @param callback (Callback) Action to fire. This will take a single parameter "done"
    //  which will be set to false if the method timed out waiting for isSystemDone() to
    //  return true;
    // @param [options] (SystemWaitConfig) options to configure the wait
    //
    // @visibility external
    //<
    
    _waitForDelayQuantum: 100,
    waitForTimeOutSeconds: 30,
    waitForSystemDone : function (callback, options, ticks) {
        
        // Default all meaningful "system done" options to true, but allow
        // them to be overridden by the explicit options argument
        var systemWaitConfig = isc.addProperties({
            includeRedraws:true,
            includeNetworkOperations:true,
            includeFileLoader:true,
            includeTimers:true
        }, options);

        
        var timeout = options && options.timeout;
        if (timeout == null) timeout = (this.waitForTimeOutSeconds * 1000);
        if (this.isSystemDone(systemWaitConfig)) {
            return this.fireCallback(callback, ["done"], [true]);
        } else if (ticks > timeout / this._waitForDelayQuantum) {
            return this.fireCallback(callback, ["done"], [false]);
        }
        if (ticks == null) ticks = 0;

        this.delayCall("waitForSystemDone", [callback, options, ++ticks],
                       this._waitForDelayQuantum);
    },
    
    //> @type ElementWaitStyle
    //  How should +link{AutoTest.waitForElement()} determine
    //  that the application is ready to retrieve the element?
    //  <P>
    //  Note: In most cases <code>"system"</code> is the appropriate setting. This will wait for standard
    //  SmartClient-initiated asychronous actions to complete, including timer-instantiated
    //  actions such as +link{canvas.markForRedraw(),delayed redraws} or actions 
    //  configured through the +link{class:Timer,Timer class}, and oustanding 
    //  +link{RPCManager,RPC Requests}. If the locator cannot be resolved to a clickable
    //  element after system quiescence, this usually implies that it will not ever resolve,
    //  and there's no need to wait for the timeout to complete and slow down your test suite.
    //  <P>
    //  The only time you'd want to use <code>"element"</code>
    //  would be if your application relies on some asynchronous event that isn't tracked by
    //  the SmartClient system. Examples might include waiting for asynchronous actions instantiated
    //  by a third-party tool on the page, or waiting for a server notification to come in through
    //  the +link{group:messaging,RealtimeMessaging} system.
    //
    // @value "system" use +link{AutoTest.waitForSystemDone()} to wait
    //         for actions to complete,
    //         then return the result of +link{AutoTest.getElement()}, even if
    //         this method doesn't resolve to an element.
    // @value "element" wait until +link{AutoTest.getElement()} resolves
    //         to an element, and the element is +link{AutoTest.isElementClickable(),clickable}.
    // @visibility external
    //<
    

    //> @classAttr AutoTest.defaultElementWaitStyle (ElementWaitStyle : "system" : IRW)
    // Default +link{ElementWaitStyle} for +link{waitForElement()}
    // @visibility external
    //<
    defaultElementWaitStyle:"system",
    defaultElementWaitTimeout:5000,

    //> @object ElementWaitConfig
    // Configuration object for +link{AutoTest.waitForElement()}
    // @treeLocation Concepts/Automated Testing/AutoTest
    // @inheritsFrom SystemWaitConfig
    // @visibility external
    //<
    
    //> @attr ElementWaitConfig.timeout (number : null : IR)
    // Timeout for +link{Autotest.waitForElement()} in ms. If this is exceeded the callback will be fired 
    // with element set to <code>null</code>, and the callback will be passed <code>false</code> as 
    // its <code>"done"</code> parameter.
    // <P>
    // Note that +link{AutoTest.getElement()} can return a valid element but this method can still 
    // timeout if the element is not clickable or the system is busy.
    // <P>
    // If unset a default timeout of 30 seconds will be used.
    //
    // @visibility external
    //<

    //> @attr ElementWaitConfig.waitStyle (ElementWaitStyle : null : IR)
    // This attribute configures how <code>waitForElement()</code> determines 
    // that the application is read to retrieve the element.
    // See +link{type:ElementWaitStyle} for options.
    // <P>
    // If not explicitly set, the +link{AutoTest.defaultElementWaitStyle} will be used.
    // 
    // @visibility external
    //<
    
    //> @classMethod AutoTest.waitForElement()
    // Waits for any in-progress actions to complete and then returns the
    // element for the specified locator.
    // <P>
    // By default this method will wait for the  +link{isSystemDone(),system to be done} 
    // before calling +link{getElement()} with the specified locator.
    // The +link{ElementWaitConfig.waitStyle,waitStyle} attribute of the options 
    // parameter may be used to instead wait for the locator to resolve to a
    // +link{isElementClickable(),clickable element}.
    //
    // @param locator (AutoTestLocator) locator for the element to retrieve
    // @param callback (Callback) callback to fire when the element has been retrieved - takes two parameters:
    //   <ul><li>"element" (+link{object:DOMElement}) - the clickable element the locator resolved to (or null)</li>
    //       <li>"done" (boolean) - this will be false if the method timed out</li></ul>
    // @param [options] (ElementWaitConfig) Options to configure the wait
    // @visibility external
    //<
    waitForElement : function (locator, callback, options) {
        if (locator == null || callback == null) {
            this.logWarn("waitForElement() called without a locator or callback - ignoring");
            return;
        }

        var waitStyle = (options && options.waitStyle);
        if (waitStyle == null) waitStyle = this.defaultElementWaitStyle;
        if (waitStyle == "system") {

            var systemDoneCallback = function (done) {
                var element = done ? isc.AutoTest.getElement(locator) : null;
                isc.AutoTest.fireCallback(callback, "element,done", [element,done]);
            }
            
            // options object may include system-wait config settings like 'includeRedraws'
            isc.AutoTest.waitForSystemDone(systemDoneCallback, options);
            
        } else {

            if (options && options.waitStyle == "systemAndElement") {
                options.waitForSystemDone = true;
            }
            this.waitForElementClickable(locator, callback, options);
        }

    },

    
    waitForElementClickable : function (locator, callback, options) {


        var timeout = options && options.timeout;
        if (timeout == null) timeout = (this.waitForTimeOutSeconds * 1000);
        
        var startTime = new Date().getTime();
        this._waitForElementClickableLoop(locator, callback, options, timeout, new Date().getTime())
    },
    _waitForElementClickableLoop : function (locator, callback, options, timeout, startTime) {
    
        var elapsed = new Date().getTime() - startTime;
        var timedOut = (elapsed > timeout);

        if (timedOut) {
            this.fireCallback(callback, "component,done", [null,false]);
        } else {

            var component;

            var waitForSystemDone = options && options.waitForSystemDone;
            if (waitForSystemDone && !this.isSystemDone(options)) {
                component = null;
            } else {
                component = this.getElement(locator);
            }

            var waitForElementClickable = true;
            if (options && options.waitForElementClickable != null) waitForElementClickable = options.waitForElementClickable;

            if (!component || (waitForElementClickable && !this.isElementClickable(component))) {

                this.delayCall(
                    "_waitForElementClickableLoop", 
                    [locator, callback, options, timeout, startTime], 
                    this._waitForDelayQuantum
                );
            } else {
                this.fireCallback(callback, "component,done", [component, true]);
            }
        }
    },

    //////////////////////////////////// TestReplay Logging ////////////////////////////////////
    

    
    _loggedFunctions : [
        "isCanvasDone", "isItemDone", "isFormDone",
        "isTileLayoutDone", "isTileGridDone",
        "isGridBodyDone", "isGridDone", "isSystemDone",
        "isElementClickable", "isElementReadyForKeyPreses",
        "getTableElementAndLogFailure", "getHandleAndLogFailure", "reportInvalidCellLocator",
        "getInnerAttributeFromSplitLocator", "getAttributeFromSplitLocator",
        "getBaseComponentFromLocatorSubstring"
    ],

    _$startLocatorMarker : "!$originalLocator{",
    _$finishLocatorMarker : "}$!",

    _createLocatorMarker : function (locator) {
        if (!locator) locator = "";
        return this._$startLocatorMarker + locator + this._$finishLocatorMarker;
    },
    _replaceLocatorMarker : function (content, locator) {
        return content.replace(/!\$originalLocator\{.*\}\$!/, locator);
    },
    _populateLocatorMarker : function (content, clearMarker) {
        var fillText = "",
            originalLocator = this._originalLocator,
            markerMatch = content.match(/^.*!\$originalLocator\{(.*)\}\$!.*$/);

        if (originalLocator && markerMatch && !clearMarker) {
            var canvasLocator = markerMatch[0].replace(/!\$originalLocator\{(.*)\}\$!/, "$1");
            if (canvasLocator == "" || !this.locatorsEqual(canvasLocator, originalLocator)) {
                fillText = " and corresponding to original locator " + originalLocator;
            }
        }
        return this._replaceLocatorMarker(content, fillText);
    },

    applyFuncToLogSlots : function (slotFunc) {
        var functions = this._loggedFunctions;
        for (var i =0; i < functions.length; i++) {
            var logSlot = "_" + functions[i] + "Log",
                result = slotFunc(logSlot);
            if (result != null) return result;
        }
        return null;
    },
    setLogFailureText : function (locator, start, finish) {
        var callerFunc = isc.AutoTest.setLogFailureText.caller || arguments.callee.caller,
            callerName = callerFunc.name || isc.Func.getName(callerFunc, true),
            logSlot = callerName.replace(/^.*[_]+([^_]+)/, "\x5F$1" ) + "Log";
        if (this[logSlot]) return; // initial reporter has primacy
        this[logSlot] = this._getLogFailureText(locator, start, finish);
     },
    _getLogFailureText : function (locator, start) {
        var text;
        if (locator == true) text = this._originalLocator;
        else if (isc.isA.String(locator)) text = locator;
        return text ? start + " " + text : start;
    },
    getLogFailureText : function (clearMarker) {
        var autotest = this,
            log = this.applyFuncToLogSlots(function (logSlot) {
            var text = autotest[logSlot];
            if (text != null) autotest[logSlot] = null;
            return text;
        });
        return log ? this._populateLocatorMarker(log, clearMarker) : log;
    },
    clearAllLogSlots : function () {
        var autotest = this;
        return this.applyFuncToLogSlots(function (logSlot) {
            autotest[logSlot] = null;
        });
    },

    // Selenium API with implicit logging of all failures
    seleniumExecute : function (command, element, locator, argument) {

        this.clearAllLogSlots();
        this._originalLocator = locator || element;

        // run the command and return normally if successful
        var undef, oldPriority, Log = isc.Log,
            result = this[command](element, argument);

        
        switch (command) {
        case "getElement":
            if (isc.isAn.Object(result)) return result;
            break;
        case "getValue":
            if (result !== undef) return result;
            break;
        default:
            if (result) return result;
        }

        // report failure as an INFO log, since it's expected that commands may fail 
        var failureReport = this.getLogFailureText();
        if (failureReport) {
            

            // if a TestRunner instance isn't present, bump testReplay priority so it's captured
            var captureInfo = !isc.TestRunner || !isc.TestRunner.getSingletonInstance();
            if (captureInfo) {
                // elevate testReplay priority to INFO for Selenese Scripts
                oldPriority = Log.getPriority("testReplay");
                if (oldPriority == null || oldPriority < Log.INFO) {
                    Log.setPriority("testReplay", Log.INFO);
                }
            }

            this.logInfo(command + "() returned " + result + " because " + failureReport,
                         "testReplay");

            if (captureInfo) {
                // restore previous testReplay logging level
                if      (oldPriority == null)    Log.clearPriority("testReplay");
                else if (oldPriority < Log.INFO) Log.setPriority("testReplay", oldPriority);
            }
        }

        return result;
    },

    _applyLoadedModuleMethods : function (target, info) {
        var methodName = "apply" + info.moduleName + "Methods";

        // attach any AutoTest methods to the appropriate classes for the module just loaded
        if (this[methodName]) {
            this[methodName]();

            if (this.logIsInfoEnabled()) {
                this.logInfo("Applied AutoTest methods to " + info.moduleName + " module");
            }
        } else {
            if (this.logIsDebugEnabled()) {
                this.logDebug("No AutoTest methods for " + info.moduleName + " module");
            }
        }
    }

});




isc.Class.addMethods(isc.AutoTest._getCheckedModuleMethods([
    "getLocator", "getMinimalLocator", "getObjectLocator", "getLocatorParent",
    "getLocatorRoot", "getAutoTestLocatorRect", "getAutoTestLocatorCoords", "getAttributeFromSplitLocator",
    "getCanvasFromFallbackLocator", "getCanvasLocatorFallbackPath"]));

isc.Class.addClassMethods(isc.AutoTest._getCheckedModuleMethods([
    "getCanvasFromFallbackLocator", "getCanvasLocatorFallbackPath"]));



isc.Page.setEvent("moduleLoaded", isc.AutoTest, null, "_applyLoadedModuleMethods");
