/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AllRecordsHandler
extends ArrayList<Map> {
    private static Logger log = new Logger(AllRecordsHandler.class);

    public AllRecordsHandler(Object baseData) throws Exception {
        if (baseData instanceof Object[]) {
            baseData = Arrays.asList((Object[])baseData);
        }
        if (baseData instanceof List) {
            for (Object o : baseData) {
                if (o instanceof Map) {
                    this.add((Map)o);
                    continue;
                }
                this.add(DataTools.getProperties(o));
            }
        } else if (baseData instanceof Map) {
            this.add((Map)((Object)baseData));
        } else {
            this.add(DataTools.getProperties(baseData));
        }
    }

    public Object get(String propName) throws Exception {
        if ("asJSON".contentEquals(propName)) {
            return this.asJSON();
        }
        if ("asSQLValuesClause".contentEquals(propName)) {
            return this.asSQLValuesClause();
        }
        ArrayList<Object> rtnList = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            rtnList.add(this.getPropertyValueAtIndex(i, propName));
        }
        return rtnList;
    }

    private Object getPropertyValueAtIndex(int index, String propertyName) throws Exception {
        Map record = (Map)this.get(index);
        return record.get(propertyName);
    }

    private String asJSON() {
        JSTranslater jst = JSTranslater.get();
        jst.setStrictJSONMode(true);
        jst.setObfuscation(false);
        try {
            return jst.toJS(this);
        }
        catch (UnconvertableException ue) {
            log.warn((Object)"Caught UnconvertableException trying to serialize an AllRecordsHandler as JSON", ue);
            return null;
        }
    }

    private String asSQLValuesClause() {
        return "Not yet implemented";
    }
}

