/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.SeleneseTestCaseParser;
import com.isomorphic.webdriver.SmartClientChromeDriver;
import com.isomorphic.webdriver.SmartClientEdgeDriver;
import com.isomorphic.webdriver.SmartClientFirefoxDriver;
import com.isomorphic.webdriver.SmartClientIEDriver;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.tags.TitleTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.OutputType;

public class SelenesePlayer {
    static int sessionIndex;
    static Map<Integer, SeleneseTestCaseParser> sessions;
    private static Map optionAPIs;

    static boolean isTagNode(Node node, String tagName) {
        return node instanceof TagNode && tagName.equals(((TagNode)node).getTagName());
    }

    public static Map getScriptObject(InputStream htmlStream) throws ParserException, UnsupportedEncodingException {
        Page page = new Page(htmlStream, "UTF-8");
        Parser parser = new Parser(new Lexer(page));
        HashMap<String, Object> script = new HashMap<String, Object>();
        ArrayList commands = new ArrayList();
        script.put("commands", commands);
        HashMap<String, String> command = new HashMap<String, String>();
        boolean inTableHeader = false;
        NodeList nodes = parser.parse((NodeFilter)new SeleneseNodeFilter());
        SimpleNodeIterator nodeIter = nodes.elements();
        while (nodeIter.hasMoreNodes()) {
            Node node = nodeIter.nextNode();
            if (node instanceof TitleTag) {
                String scriptName = ((TitleTag)node).getTitle();
                script.put("scriptName", scriptName);
                continue;
            }
            if (node instanceof RemarkNode) {
                command.put("description", node.getText());
                continue;
            }
            if (node instanceof TableRow) {
                if (inTableHeader) continue;
                int nCols = ((TableRow)node).getColumnCount();
                SelenesePlayer.addBooleanAttribute(command, "screenshot", "screenshot", node);
                SelenesePlayer.addBooleanAttribute(command, "wait-for", "waitFor", node);
                String onFailure = ((TableRow)node).getAttribute("data-isc-on-failure");
                if (onFailure != null && !onFailure.isEmpty()) {
                    command.put("onFailure", onFailure);
                }
                SelenesePlayer.addTableColumnText(command, "commandName", nodeIter.nextNode());
                if (nCols >= 2) {
                    SelenesePlayer.addTableColumnText(command, "argument1", nodeIter.nextNode());
                }
                if (nCols >= 3) {
                    SelenesePlayer.addTableColumnText(command, "argument2", nodeIter.nextNode());
                }
                commands.add(command);
                command = new HashMap();
                continue;
            }
            if (!(node instanceof TagNode) || !"THEAD".equals(((TagNode)node).getTagName())) continue;
            inTableHeader = !((TagNode)node).isEndTag();
        }
        return script;
    }

    static void addTableColumnText(Map command, String fieldName, Node node) {
        NodeList children = node.getChildren();
        if (children == null) {
            return;
        }
        Node child = children.elementAt(0);
        command.put(fieldName, child.getText());
    }

    static void addBooleanAttribute(Map command, String attributeName, String fieldName, Node tableRow) {
        String value = ((TableRow)tableRow).getAttribute("data-isc-" + attributeName);
        if (value != null) {
            command.put(fieldName, Boolean.parseBoolean(value));
        }
    }

    static String getCommandArgument(Map command, int index) {
        Object value = command.get("argument" + index);
        return value != null ? value.toString() : "";
    }

    static String getHtmlRowTags(List<Map> commands) {
        StringBuffer html = new StringBuffer();
        for (Map command : commands) {
            html.append("<tr>\t<td>" + command.get("commandName") + "</td>");
            html.append("\t<td>" + SelenesePlayer.getCommandArgument(command, 1) + "</td>");
            html.append("\t<td>" + SelenesePlayer.getCommandArgument(command, 2) + "</td></tr>");
        }
        return html.toString();
    }

    public static synchronized int openSeleneseSession(String browser) {
        SmartClientWebDriver driver;
        switch (browser) {
            default: {
                driver = new SmartClientIEDriver();
                break;
            }
            case "edge": {
                driver = new SmartClientEdgeDriver();
                break;
            }
            case "chrome": {
                driver = new SmartClientChromeDriver();
                break;
            }
            case "firefox": {
                driver = new SmartClientFirefoxDriver();
            }
        }
        SeleneseTestCaseParser visitor = new SeleneseTestCaseParser(driver, null, null, null, System.out, System.err, false, false);
        sessions.put(++sessionIndex, visitor);
        return sessionIndex;
    }

    public static synchronized void closeSeleneseSession(int sessionIndex) {
        if (!sessions.containsKey(sessionIndex)) {
            throw new IllegalArgumentException("session index " + sessionIndex + " is not valid");
        }
        SeleneseTestCaseParser visitor = sessions.get(sessionIndex);
        sessions.remove(sessionIndex);
        visitor.getDriver().quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map executeSelenese(int sessionIndex, List<Map> commands, Map testOptions) throws ParserException {
        Class<SelenesePlayer> clazz = SelenesePlayer.class;
        synchronized (SelenesePlayer.class) {
            if (!sessions.containsKey(sessionIndex)) {
                throw new IllegalArgumentException("session index " + sessionIndex + " is not valid");
            }
            SeleneseTestCaseParser visitor = sessions.get(sessionIndex);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            PrintStream commandOutput = new PrintStream(bytesOut, true);
            if (testOptions != null) {
                visitor.applySelenesePlayerOptions(testOptions, optionAPIs);
            }
            PrintStream origErr = visitor.getErrorStream();
            PrintStream origOut = visitor.getOutputStream();
            Boolean result = null;
            try {
                visitor.setErrorStream(commandOutput);
                visitor.setOutputStream(commandOutput);
                ByScLocator.setThreadLocalErrorStream(commandOutput);
                String htmlRowTags = SelenesePlayer.getHtmlRowTags(commands);
                Parser parser = new Parser(new Lexer(new Page(htmlRowTags, "UTF-8")));
                parser.visitAllNodesWith((NodeVisitor)visitor);
                result = visitor.getResult();
            }
            finally {
                visitor.resetSuccess();
                visitor.setErrorStream(origErr);
                visitor.setOutputStream(origOut);
                ByScLocator.clearThreadLocalErrorStream();
                commandOutput.flush();
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("result", result);
            Map last = commands.get(commands.size() - 1);
            Boolean screenshot = (Boolean)last.get("screenshot");
            if (Boolean.TRUE.equals(screenshot) || !Boolean.FALSE.equals(screenshot) && Boolean.FALSE.equals(result)) {
                SmartClientWebDriver driver = visitor.getDriver();
                File shotfile = (File)driver.getScreenshotAs(OutputType.FILE);
                response.put("shotfile", shotfile.getAbsolutePath());
            }
            try {
                response.put("output", bytesOut.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("!!! Unable to report command output" + e.getMessage());
            }
            return response;
        }
    }

    static {
        sessions = new HashMap<Integer, SeleneseTestCaseParser>();
        optionAPIs = new HashMap(){
            {
                this.put("waitForWait", "setDefaultWaitTimeout");
                this.put("implicitWait", "setDefaultImplicitWait");
            }
        };
    }

    static class SeleneseNodeFilter
    implements NodeFilter {
        SeleneseNodeFilter() {
        }

        public boolean accept(Node node) {
            return SelenesePlayer.isTagNode(node, "THEAD") || node instanceof TitleTag || node instanceof TableTag || node instanceof TableRow || node instanceof TableColumn || node instanceof RemarkNode;
        }
    }
}

