/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.AwsInstancesDao;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.Jenkins;
import com.isomorphic.autotest.JenkinsBuild;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Date;

public class JenkinsHelper {
    private static Logger log = new Logger(JenkinsHelper.class.getName());

    protected static String launchJenkinsBuild(Date batchStartTime) {
        try {
            Jenkins jenkins = new Jenkins();
            log.info((Object)("Launching jenkins build for " + batchStartTime));
            JenkinsBuild jenkinsBuild = jenkins.triggerBuild("jenkins_autotest");
            log.info((Object)("Jenkins build (" + batchStartTime + ") successfully submitted to Jenkins. Waiting for execution start..."));
            DataTypeMap buildStatus = jenkinsBuild.waitForExecutionStart();
            String instanceId = buildStatus.getString((Object)"id");
            if (instanceId == null) {
                throw new Exception("Failed to acquire instanceId from buildStatus: " + DataTools.prettyPrint((Object)buildStatus));
            }
            log.info((Object)("Jenkins build (" + batchStartTime + ") successfully started with instanceId: " + instanceId));
            BatchRunDao.registerAwsInstanceId(batchStartTime, instanceId);
            int vpnKeyOrdinal = -Integer.parseInt(instanceId);
            AwsInstancesDao.registerKeyOrdinalWithInstance(vpnKeyOrdinal, instanceId, batchStartTime);
            return instanceId;
        }
        catch (Exception e) {
            log.error((Object)"A fatal error occurred in launchJenkinsBuild", (Throwable)e);
            return null;
        }
    }
}

