/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class CacheManifestCreator {
    public static Logger log = new Logger(CacheManifestCreator.class.getName());
    protected String path = "./";
    protected String skinName = "Enterprise";
    protected String templateFileName = "./cache.manifest.template";
    protected String outputFileName = "./Enterprise-cache.manifest";
    protected String version;
    protected boolean useTimestamp = false;
    protected List consist = new ArrayList();
    protected List hashes = new ArrayList();
    protected List excludedFiles = new ArrayList();
    protected List excludedFolders = new ArrayList();

    public static void main(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            String cmdLineSyntax = "createCacheManifest [options]";
            Options options = new Options();
            options.addOption("p", "path", true, "Root path to build manifest for (defaults to .)");
            options.addOption("s", "skin", true, "Skin to build manifest for (defaults to Enterprise)");
            options.addOption("t", "template", true, "Template file to use (defaults to ./cache.manifest.template");
            options.addOption("o", "outputFile", true, "File to create (defaults to ./cache.manifest");
            options.addOption("v", "version", true, "Version number to embed in the manifest (see the -u option for default)");
            options.addOption("u", "useTimestamp", false, "Default version number will be the current timestamp. This will ensure that a newly-built cache manifest will ALWAYS override the data in the browser cache.  If you do not set this option, the default version will be built from an MD5 hash of the actual files; this will ensure that the browser will discard its cache ONLY if there is an actual change in one of the files.  Clearly this is better, but it is also slower.");
            options.addOption("k", "includeSDK", false, "Whether to exclude directories found in smartclientSDK that would not generally be part of a running application");
            CacheManifestCreator cmc = new CacheManifestCreator();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("p")) {
                cmc.setPath(line.getOptionValue("p"));
            }
            if (line.hasOption("s")) {
                cmc.setSkinName(line.getOptionValue("s"));
            }
            if (line.hasOption("s") && !line.hasOption("o")) {
                if ("*".equals(cmc.getSkinName())) {
                    cmc.setOutputFileName("allSkins-cache.manifest");
                } else {
                    cmc.setOutputFileName(cmc.getSkinName() + "-cache.manifest");
                }
            }
            if (line.hasOption("t")) {
                cmc.setTemplateFileName(line.getOptionValue("t"));
            }
            if (line.hasOption("o")) {
                cmc.setOutputFileName(line.getOptionValue("o"));
            }
            if (line.hasOption("v")) {
                cmc.setVersion(line.getOptionValue("v"));
            }
            if (line.hasOption("u")) {
                cmc.setUseTimestamp(true);
            }
            if (!line.hasOption("k")) {
                cmc.addExcludedFolder("docs");
                cmc.addExcludedFolder("QA");
                cmc.addExcludedFolder("tools");
                cmc.addExcludedFolder("examples");
                cmc.addExcludedFolder("inlineExamples");
                cmc.addExcludedFolder("builderOEM");
                cmc.addExcludedFolder("fckEditor");
                cmc.addExcludedFolder("isomorphicCache");
                cmc.addExcludedFolder("isomorphicCache-build");
                cmc.addExcludedFolder("isomorphicConfig");
                cmc.addExcludedFile("greenPoint*");
                cmc.addExcludedFile("logColorizer.css");
                cmc.addExcludedFolder("schema");
                cmc.addExcludedFolder("shared");
                cmc.addExcludedFile("*.gz");
                cmc.addExcludedFile("README.txt");
                cmc.addExcludedFile("license.html");
            }
            cmc.addExcludedFolder("CVS");
            cmc.addExcludedFile(".DS_Store");
            cmc.addExcludedFile("*.class");
            cmc.addExcludedFile("*.jar");
            cmc.addExcludedFolder("WEB-INF");
            cmc.addExcludedFolder("_internalSource");
            cmc.addExcludedFile("*.manifest");
            cmc.addExcludedFile(".#*");
            cmc.addExcludedFile("*~");
            cmc.createFile();
            System.exit(0);
        }
        catch (Exception any) {
            log.warn((Throwable)any);
        }
    }

    public void generate() throws Exception {
        File template = new File(this.templateFileName);
        if (template != null && template.exists()) {
            String input;
            FileInputStream fis = new FileInputStream(template);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            while ((input = bufferedReader.readLine()) != null) {
                this.consist.add(input);
            }
        } else {
            this.consist.add("CACHE MANIFEST");
        }
        this.addFilesRecursively(this.path, this.path.length());
        if (this.version == null) {
            if (this.useTimestamp) {
                this.version = new Date().toString();
            } else {
                StringBuffer hashString = new StringBuffer();
                Iterator i = this.hashes.iterator();
                while (i.hasNext()) {
                    hashString.append((String)i.next());
                }
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(hashString.toString().getBytes());
                byte[] hash = messageDigest.digest();
                this.version = this.toHexString(hash);
            }
        }
        this.consist.add(1, "# Version: " + this.version);
    }

    public void createFile() throws Exception {
        this.generate();
        FileWriter fileWriter = new FileWriter(this.outputFileName);
        Iterator i = this.consist.iterator();
        while (i.hasNext()) {
            fileWriter.write((String)i.next() + "\n");
        }
        fileWriter.close();
    }

    public String gextText() throws Exception {
        this.generate();
        StringBuffer sb = new StringBuffer();
        Iterator i = this.consist.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            sb.append('\n');
        }
        return sb.toString();
    }

    protected void addFilesRecursively(String path, int rootNameLength) throws Exception {
        if (!this.shouldIncludeFolder(path.substring(rootNameLength))) {
            return;
        }
        System.out.println("Processing " + path);
        File pathFile = new File(path);
        if (!pathFile.isDirectory()) {
            return;
        }
        String[] files = pathFile.list();
        ArrayList<String> folders = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            File fileDetail = new File(path + files[i]);
            if (fileDetail.isDirectory()) {
                folders.add(path + files[i] + "/");
                continue;
            }
            if (!this.shouldIncludeFile(path + files[i])) continue;
            this.consist.add(path.substring(rootNameLength) + files[i]);
            if (this.version != null || this.useTimestamp) continue;
            FileInputStream fis = new FileInputStream(fileDetail);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(buffer);
            byte[] hash = messageDigest.digest();
            this.hashes.add(this.toHexString(hash));
        }
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            this.addFilesRecursively((String)i.next(), rootNameLength);
        }
    }

    protected String toHexString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            result.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    protected boolean shouldIncludeFolder(String path) {
        int end;
        int start;
        String unqualName = path;
        if (unqualName.contains("/")) {
            unqualName = unqualName.indexOf(47) != unqualName.lastIndexOf(47) ? unqualName.substring(unqualName.lastIndexOf(47, unqualName.length() - 2) + 1, unqualName.length() - 1) : unqualName.substring(0, unqualName.length() - 1);
        }
        if (!"*".equals(this.skinName) && (start = path.lastIndexOf(47, (end = path.lastIndexOf(47, path.length() - 2)) - 1)) != -1 && end != -1 && "skins".equals(path.substring(start + 1, end))) {
            return path.substring(end + 1).equals(this.skinName + "/");
        }
        Iterator i = this.excludedFolders.iterator();
        while (i.hasNext()) {
            boolean match = false;
            boolean startsWith = false;
            boolean endsWith = false;
            String filter = new String((String)i.next());
            if (filter.startsWith("*")) {
                startsWith = true;
                filter = filter.substring(1);
            }
            if (filter.endsWith("*")) {
                endsWith = true;
                filter = filter.substring(0, filter.length() - 1);
            }
            if (startsWith && unqualName.endsWith(filter)) {
                match = true;
            } else if (endsWith && unqualName.startsWith(filter)) {
                match = true;
            } else if (endsWith && startsWith && unqualName.contains(filter)) {
                match = true;
            } else if (unqualName.equals(filter)) {
                match = true;
            }
            if (!match) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldIncludeFile(String qualifiedFile) {
        String unqualName = qualifiedFile;
        if (unqualName.contains("/")) {
            unqualName = unqualName.substring(unqualName.lastIndexOf(47) + 1);
        }
        Iterator i = this.excludedFiles.iterator();
        while (i.hasNext()) {
            boolean match = false;
            boolean startsWith = false;
            boolean endsWith = false;
            String filter = new String((String)i.next());
            if (filter.startsWith("*")) {
                startsWith = true;
                filter = filter.substring(1);
            }
            if (filter.endsWith("*")) {
                endsWith = true;
                filter = filter.substring(0, filter.length() - 1);
            }
            if (startsWith && unqualName.endsWith(filter)) {
                match = true;
            } else if (endsWith && unqualName.startsWith(filter)) {
                match = true;
            } else if (endsWith && startsWith && unqualName.contains(filter)) {
                match = true;
            } else if (unqualName.equals(filter)) {
                match = true;
            }
            if (!match) continue;
            return false;
        }
        return true;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/";
        }
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public boolean isUseTimestamp() {
        return this.useTimestamp;
    }

    public void setUseTimestamp(boolean useTimestamp) {
        this.useTimestamp = useTimestamp;
    }

    public List getExcludedFiles() {
        return this.excludedFiles;
    }

    public void setExcludedFiles(List excludedFiles) {
        this.excludedFiles = excludedFiles;
    }

    public void addExcludedFile(String excludedFile) {
        this.excludedFiles.add(excludedFile);
    }

    public List getExcludedFolders() {
        return this.excludedFolders;
    }

    public void setExcludedFolders(List excludedFolders) {
        this.excludedFolders = excludedFolders;
    }

    public void addExcludedFolder(String excludedFolder) {
        this.excludedFolders.add(excludedFolder);
    }
}

