/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.datasource.DataSource;

public class JSTranslaterDSConfig {
    private Object o;
    private DataSource ds;
    private String fieldName;
    private Boolean omitNullMapValues;
    private Boolean bypassDataFilter;

    public JSTranslaterDSConfig(Object o, DataSource ds) {
        this.o = o;
        if (ds == null) {
            throw new NullPointerException("Data source parameter can not be null.");
        }
        this.ds = ds;
    }

    public JSTranslaterDSConfig(Object o, DataSource ds, Boolean omitNullMapValues) {
        this(o, ds);
        this.omitNullMapValues = omitNullMapValues;
    }

    public JSTranslaterDSConfig(Object o, DataSource ds, Boolean omitNullMapValues, Boolean bypassDataFilter) {
        this(o, ds, omitNullMapValues);
        this.bypassDataFilter = bypassDataFilter;
    }

    public JSTranslaterDSConfig(Object o, DataSource ds, String fieldName) {
        this(o, ds);
        this.fieldName = fieldName;
    }

    public JSTranslaterDSConfig(Object o, DataSource ds, String fieldName, Boolean omitNullMapValues) {
        this(o, ds, fieldName);
        this.omitNullMapValues = omitNullMapValues;
    }

    public JSTranslaterDSConfig(Object o, DataSource ds, String fieldName, Boolean omitNullMapValues, Boolean bypassDataFilter) {
        this(o, ds, fieldName, omitNullMapValues);
        this.bypassDataFilter = bypassDataFilter;
    }

    public JSTranslaterDSConfig(Object o, JSTranslaterDSConfig cfg) {
        this(o, cfg.ds, cfg.fieldName, cfg.omitNullMapValues, cfg.bypassDataFilter);
    }

    public Object getObject() {
        return this.o;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean getOmitNullMapValues() {
        return this.ds.getOmitNullMapValuesInResponse() || !Boolean.FALSE.equals(this.omitNullMapValues);
    }

    public Boolean getBypassDataFilter() {
        return Boolean.TRUE.equals(this.bypassDataFilter);
    }

    public void setBypassDataFilter(Boolean newValue) {
        this.bypassDataFilter = newValue;
    }

    public String toString() {
        return "DS:" + this.ds.getName() + " field: " + (this.fieldName == null ? "null" : this.fieldName) + " object: " + (this.o == null ? "null" : this.o.toString()) + (this.omitNullMapValues == null ? "" : " omitNullMapValues: " + this.omitNullMapValues) + (this.bypassDataFilter == null ? "" : " bypassDataFilter: " + this.bypassDataFilter);
    }
}

