/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class ReifyDataSources {
    private static Logger log = new Logger(ReifyDataSources.class.getName());
    public static final String BATCHRUN = "_batchRun";
    public static final String REIFYBATCH = "reifyBatch";
    public static final String AUTOTEST = "autoTestResult";
    public static final String REIFYTEST = "reifyTestResult";

    public static synchronized void setupReifyDataSources() {
        final Config config = Config.getGlobal();
        if (!config.globalOverridesInEffect()) {
            config.setGlobalOverrides((Map)DataTools.buildMap((Object[])new Object[]{"autotest._batchRunDS", REIFYBATCH, "datasources.reifyBatch.config.xpath.set", Arrays.asList("inheritsFrom", BATCHRUN)}));
        }
        DataSource.addDynamicDSGenerator((DynamicDSGenerator)new DynamicDSGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DataSource getDataSource(String id, DSRequest dsRequest) {
                DataSource ds = null;
                if (ReifyDataSources.BATCHRUN.equals(id)) {
                    config.pushThreadLocal((Map)DataTools.buildMap((Object[])new Object[]{"datasources.batchRun.config.xpath.set", Arrays.asList("tableName", ReifyDataSources.REIFYBATCH)}));
                    try {
                        ds = DataSourceManager.get((String)"batchRun");
                        DataTypeMap dsConfig = ds.getConfig();
                        dsConfig.put("ID", ReifyDataSources.BATCHRUN);
                        DataSource dataSource = DataSource.fromConfig((Map)dsConfig, (DSRequest)dsRequest);
                        return dataSource;
                    }
                    catch (Throwable t) {
                        log.error((Object)"failed to generate batchRun DS for Reify", t);
                    }
                    finally {
                        Config.getGlobal().popThreadLocal();
                        DataSourceManager.free((DataSource)ds);
                    }
                    return null;
                }
                if (ReifyDataSources.REIFYTEST.equals(id)) {
                    try {
                        ds = DataSourceManager.get((String)ReifyDataSources.AUTOTEST);
                        String xmlDS = ds.toXML().replaceAll(ReifyDataSources.AUTOTEST, ReifyDataSources.REIFYTEST).replaceAll("batchRun", ReifyDataSources.BATCHRUN).replaceAll("&amp;#010", "");
                        DataSource dataSource = DataSource.fromXML((String)xmlDS, (DSRequest)dsRequest);
                        return dataSource;
                    }
                    catch (Throwable t) {
                        log.error((Object)"failed to generate reifyTestResult DS", t);
                    }
                    finally {
                        DataSourceManager.free((DataSource)ds);
                    }
                    return null;
                }
                return null;
            }
        }, (Pattern)Pattern.compile("_batchRun|reifyTestResult"));
    }

    static void startReifyCloudBatch() {
        Config.getGlobal().pushThreadLocal((Map)DataTools.buildMap((Object[])new Object[]{"autotest.batchRunDS", REIFYBATCH, "datasources.batchRun.config.xpath.set", Arrays.asList("tableName", REIFYBATCH), "datasources.autoTestResult.config.xpath.set", Arrays.asList("tableName", REIFYTEST)}));
    }

    static void endReifyCloudBatch() {
        Config.getGlobal().popThreadLocal();
    }
}

