/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GenericSQLDriver
extends SQLDriver {
    private static Logger log = new Logger(GenericSQLDriver.class.getName());

    public GenericSQLDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return false;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (sequencesNotPresent.size() > 0) {
            throw new Exception("GenericSQLDriver does not support sequences");
        }
        return primaryKeysPresent;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) throws Exception {
        if (value instanceof Date && (field == null || field.get((Object)"sqlStorageStrategy") == null)) {
            boolean convertToUTC;
            long timeStamp = ((Date)value).getTime();
            String dateTime = this.formatTimestamp(timeStamp, convertToUTC = field != null && "datetime".equals(field.getType()), ds, field);
            int periodIndex = dateTime.lastIndexOf(".");
            if (periodIndex != -1) {
                dateTime = dateTime.substring(0, periodIndex);
            }
            String format = config.getString((Object)"sql.defaultDateTimeFormat");
            return "TO_DATE(" + this.escapeValue(dateTime) + ",'" + format + "')";
        }
        return super.sqlInTransform(value, field, ds);
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        throw new Exception("GenericSQLDriver does not support sequences");
    }

    public String getCurrentSequenceValue(String columnName) throws Exception {
        throw new Exception("GenericSQLDriver does not support sequences");
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (this._sqlConfig.getBoolean((Object)"useCaseForSortBy", false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public InputStream handleInputStream(InputStream in) throws Exception {
        if (config.getBoolean((Object)"sql.generic.read.inputstreams.early", false)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtil.copyStreams((InputStream)in, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return in;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        return "varchar(" + length + ")";
    }

    @Override
    public String getFloatType() {
        return "float";
    }
}

