/*

  SmartClient Ajax RIA system
  Version v13.0p_2026-02-19/LGPL Deployment (2026-02-19)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>	@class	TabSet
//
// The TabSet class allows components on several panes to share the same space. The tabs at 
// the top can be selected by the user to show each pane. 
// <P>
// Tabs are configured via the <code>tabs</code> property, each of which has a
// <code>pane</code> property which will be displayed in the main pane when that tab is
// selected.
//
//  @inheritsFrom Canvas
//  @treeLocation Client Reference/Layout
//  @visibility external
//<

isc.ClassFactory.defineClass("TabSet", "Canvas");

isc.TabSet.addProperties({

    // NOTE: Setting both the paneContainer and TabSet to overflow:"visible" results in an
    // auto-expanding TabSet.  This may be appropriate as a top-level page layout when an
    // application is more web-style than desktop-style, eg, allows and utilizes browser-level
    // scrolling.
    overflow:"hidden",

	// TabBar
	// ----------------------------------------------------------------------------------------
    //>	@attr	tabSet.tabs		(Array of Tab : null : IRW)
    //
    // An array of +link{Tab} objects, specifying the title and pane contents of each tab in the TabSet.
    // <smartclient>When developing in JavaScript, tabs are specified as an array of object literals, 
    // not instances - see +link{Tab}.</smartclient>  
    // <smartgwt>Tab instances are not widgets, they just provide configuration such as title and 
    // icon.</smartgwt>
    // <p>
    // After providing +link{Tab} instances to <code>setTabs()</code>, the TabSet creates actual UI 
    // widgets to serve as interactive tabs. Any further modifications to tabs should be performed 
    // via TabSet APIs such as +link{TabSet.setTabTitle}, +link{TabSet.setTabIcon} and 
    // +link{TabSet.setTabPane}.
    // <p>
    // You can add and remove tabs after creating the TabSet by calling +link{TabSet.addTab} and 
    // +link{TabSet.removeTab}
    // @visibility external
    // @example tabsOrientation
    //<
    
    //> @object Tab
    // <smartclient>
    // Tabs are specified as objects, not class instances.  For example, when
    // developing in JavaScript, a typical initialization block for a TabSet would look like
    // this:
    // <pre>
    // TabSet.create({
    //     tabs: [
    //         {title: "tab1", pane: "pane1"},
    //         {title: "tab2"}
    //     ]
    // });
    // </pre>
    // And in XML:
    // <pre>
    // &lt;TabSet&gt;
    //    &lt;tabs&gt;
    //        &lt;Tab title="tab1" pane="pane1"/&gt;
    //        &lt;Tab title="tab2"/&gt;
    //    &lt;/tabs&gt;
    // &lt;/TabSet&gt;
    // </pre>
    // </smartclient>
    // <smartgwt>
    // Tab instances for use with {@link com.smartgwt.client.widgets.tab.TabSet}. Tab 
    // instances specify the appearance ({@link com.smartgwt.client.widgets.tab.Tab#setTitle setTitle}, 
    // {@link com.smartgwt.client.widgets.tab.Tab#setIcon setIcon}) of the tab, and provide 
    // the tab's {@link com.smartgwt.client.widgets.tab.Tab#getPane pane}. See 
    // {@link com.smartgwt.client.widgets.tab.TabSet#setTabs setTabs} for 
    // further details.
    // </smartgwt>
    // 
    // @treeLocation Client Reference/Layout/TabSet
    // @visibility external
    //<

    //> @attr tab.title (HTMLString : null : IR)
    // Specifies the title of the this tab.  <smartclient>To change the title after the TabSet
    // has been created, call +link{TabSet.setTabTitle}.</smartclient>
    //
    // @see TabSet.setTabTitle
    // @visibility external 
    //<
    

    //> @attr tab.canEditTitle (boolean : null : IR)
    //
    // If specified, overrides the +link{TabSet.canEditTabTitles} setting, for this one tab
    // only.
    // <p>
    // Note that the TabSet's +link{TabSet.titleEditEvent,titleEditEvent} must be set to a
    // supported +link{TabTitleEditEvent} in order for users to be able to edit this tab's
    // title.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>canEditTtile</code>
    // property by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @see TabSet.canEditTabTitles
    // @example userEditableTitles
    // @visibility external
    //<
    

    //> @attr tab.prompt (HTMLString : null : IR)
    // Specifies the prompt to be displayed when the mouse hovers over the tab.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>prompt</code> property by
    // calling +link{TabSet.setTabProperties()}.</smartclient>
    // @visibility external
    //<
    

    //> @attr tab.pickerTitle (HTMLString : null : IR)
    // If +link{tabSet.showTabPicker} is true for this TabSet, if set this property will determine
    // the title of the picker menu item for this tab. If unset, +link{tab.title} will be used
    // instead.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>pickerTitle</code>
    // property by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @see TabSet.showTabPicker
    // @see tab.title
    // @group tabBarControls
    // @visibility external
    //<
    

    //> @attr tab.pane (Canvas | ID | AutoChildShortcut : null : IR)
    //
    // Specifies the pane associated with this tab.  You have three options for the value of
    // the pane attribute:
    // <ul>
    // <li><b>ID</b> - The global ID of an already created Canvas (or subclass).
    // <li><b>Canvas</b> - A live instance of a Canvas (or subclass).
    // <li><b>AutoChildShortcut</b> - String with format "autoChild:<i>autoChildName</i>"
    // </ul>
    // <smartclient>You can change the pane associated with a given tab after the TabSet has
    // been created by calling +link{TabSet.updateTab}.</smartclient>
    // 
    // @see group:autoChildren
    // @see TabSet.updateTab
    // @visibility external
    //<
    

    //> @attr tab.paneMargin (int : null : IR)
    // Space to leave around the pane within this Tab.
    // If specified, this property takes precedence over +link{tabSet.paneMargin}
    // @visibility external
    //<

    //> @attr tab.ID (GlobalId : null : IR)
    // Optional ID for the tab, which can later be used to reference the tab.
    // APIs requiring a reference to a tab will accept the tab's ID 
    // [including  +link{tabSet.selectTab()}, +link{tabSet.updateTab()}, +link{tabSet.removeTab()}].<br>
    // The ID will also be passed to the +link{tabSet.tabSelected()} and +link{tabSet.tabDeselected()}
    // handler functions, if specified.
    // <p>
    // Note that if you provide an ID, it must be globally unique.  If you do not want a
    // globally unique identifier, set +link{tab.name} instead.
    //
    // @visibility external
    //< 

    //> @type TabName
    // An +link{Identifier} that must be locally unique within the containing +link{TabSet}.
    // @baseType Identifier
    // @visibility external
    //<    

    //> @attr tab.name (TabName : null : IR)
    // Optional name for the tab, which can later be used to reference the tab.
    // APIs requiring a reference to a tab will accept the tab's name
    // [including  +link{tabSet.selectTab()}, +link{tabSet.updateTab()}, +link{tabSet.removeTab()}].<br>
    // This name will also be passed to the +link{tabSet.tabSelected()} and +link{tabSet.tabDeselected()}
    // handler functions, if specified.
    // <p>
    // This identifier is requred to be locally unique to the TabSet and cannot be used to get
    // a global reference to the Tab.  If you want a global reference, set +link{tab.ID} instead.
    //
    // @visibility external
    //< 

    //> @attr tab.width (number : 100 : IR)
    // You can specify an explicit width for the tab using this property.  Note that tabs
    // automatically size to make room for the full title, but if you want to e.g. specify a
    // uniform width for all tabs in a TabSet, this property enables you to do so.
    // <p>
    // <smartclient>After the TabSet has been created, you can change a tab's <code>width</code>
    // property by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @visibility external
    //<
    

    //> @attr tab.canAdaptWidth (Boolean : false : IR)
    // If enabled, the tab will collapse to show just its icon when showing the title would
    // cause overflow of a containing +link{TabBar}.  While collapsed, the tab will show its
    // title on hover, unless an explicit hover has been specified such as by +link{prompt}.
    //
    // @see Button.canAdaptWidth
    // @see Canvas.canAdaptWidth
    // @visibility external
    //< 
    
    //> @attr tab.disabled (boolean : null : IR)
    // If specified, this tab will initially be rendered in a disabled state. <smartclient>To
    // enable or disable tabs on the fly use the +link{tabSet.enableTab()}, and
    // +link{tabSet.disableTab()}.</smartclient>
    // methods.
    // @visibility external
    //<
    


    //> @attr tab.hidden (boolean : null : IRW)
    // If specified this tab will be hidden by default. To show and hide tabs at runtime
    // use +link{tabSet.showTab()} and +link{tabSet.hideTab()}
    // @visibility external
    //<

    //> @attr tab.visibleWhen (Criteria : null : IR)
    // Criteria to be evaluated to determine whether this Tab should be visible.
    // <P>
    // A basic criteria uses textMatchStyle:"exact". When specified in
    // +link{group:componentXML,Component XML} this property allows
    // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
    //
	// @group ruleCriteria
	// @visibility external
    //<

    //> @attr tab.enableWhen (Criteria : null : IR)
    // Criteria to be evaluated to determine whether this Tab should be enabled.
    // <P>
    // A basic criteria uses textMatchStyle:"exact". When specified in
    // +link{group:componentXML,Component XML} this property allows
    // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
    //
	// @group ruleCriteria
	// @visibility external
    //<

    //> @attr tab.icon (SCImgURL : null : IR)
    // If specified, this tab will show an icon next to the tab title.  
    // <p>
    // <b>NOTE:</b> if you enable +link{tabSet.canCloseTabs,closeable tabs},
    // <code>tab.icon</code> is used for the close icon.  +link{tabSet.canCloseTabs} describes
    // a workaround to enable both a <code>closeIcon</code> and a second icon to be shown.
    // <p>
    // Use +link{tabSet.tabIconClick} to add an event handler specifically for clicks on the icon.
    // <p>
    // If a tab +link{tab.disabled,becomes disabled}, a different icon will be loaded by adding
    // a suffix to the image name (see +link{Button.icon}).
    // <p>
    // You should specify a size for the icon via +link{tab.iconSize} or +link{tab.iconWidth}
    // and +link{tab.iconHeight}. Without an explicitly specified size, tabs may be drawn
    // overlapping or with gaps the first time a page is loaded, because the icon is not cached
    // and therefore its size isn't known.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>icon</code> property by
    // calling +link{TabSet.setTabIcon()}.</smartclient>
    //
    // @visibility external
    // @example tabsOrientation
    // @see tabSet.tabIconClick
    //<
    
    
    //> @attr tab.iconSize (Integer : 16 : IR)
    // If +link{tab.icon} is specified, this property may be used to specify a size for the icon.
    // Per side sizing may be specified instead via +link{tab.iconWidth} and +link{tab.iconHeight}.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>iconSize</code> property
    // by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @visibility external
    //<
    
    defaultTabIconSize: 16,    
    
    //> @attr tab.iconWidth (Integer : null : IR)
    // If +link{tab.icon} is specified, this property may be used to specify a width for the
    // icon.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>iconWidth</code> property
    // by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @visibility external
    //<
    
    
    //> @attr tab.iconHeight (Integer : null : IR)
    // If +link{tab.icon} is specified, this property may be used to specify a height for the
    // icon.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>iconHeight</code>
    // property by calling +link{TabSet.setTabProperties()}.</smartclient>
    // @visibility external
    //<
    
    
    //> @attr tab.canReorder (Boolean : null : IR)
    // If +link{tabSet.canReorderTabs} is set to <code>true</code>, setting <code>canReorder</code>
    // explicitly to <code>false</code> for some tab will disallow drag-reordering of
    // this tab. Has no effect if <code>canReorderTabs</code> is not true at the tabSet level.
    // <P>
    // Note that this setting also disallows a reorder of another tab into the slot before
    // or following this tab. This means for tabs located at the beginning or end of the 
    // tab-bar, users cannot changing the index of the tab by dropping another
    // before or after it. However if you have a <i><code>canReorder:false</code></i>
    // tab which is not at the beginning or end of the tab bar, users can
    // drag reorder other tabs around it which may ultimately change its position.
    // @visibility external
    // @see TabSet.canReorderTabs
    //<
    
    //> @attr tab.canClose (boolean : null : IR)
    // Determines whether this tab should show a close icon allowing the user to dismiss the tab
    // by clicking on the close icon directly. The URL for the close icon's image will be derived from 
    // +link{tabSet.closeTabIcon} by default, but may be overridden by explicitly specifying
    // +link{tab.closeIcon}.
    // <p>
    // If unset or null, this property is derived from +link{tabSet.canCloseTabs}.
    // <p>
    // Note that setting <code>canClose</code> means that +link{tab.icon} cannot be used,
    // because it's used for the +link{tab.closeIcon,closeIcon} - see
    // +link{tabSet.canCloseTabs} for a workaround.
    // <smartclient><p>
    // After the TabSet has been created, you can change a tab's <code>canClose</code> property
    // by calling +link{TabSet.setCanCloseTab()}.</smartclient>
    //
    // @visibility external
    // @example closeableTabs
    // @see TabSet.closeClick()
    //<
    

    //> @attr tab.closeIcon (SCImgURL : null : IR)
    // Custom src for the close icon for this tab to display if it is closeable.
    // See +link{tab.canClose} and +link{tabSet.canCloseTabs}.
    // @visibility external
    //<
    
    //> @attr tab.closeIconSize (number : null : IR)
    // Size of the +link{tab.closeIcon} for this tab. If unspecified the icon will be sized
    // according to +link{tabSet.closeTabIconSize}
    // @visibility external
    //<

    // ---------------------------------------------------------------------------------------

    //> @attr tabSet.tabBar (AutoChild TabBar : null : R)
    // TabBar for this TabSet, an instance of +link{TabBar}.
    // @visibility external
    //<
    // NOTE: tabBar is actually not created via autoChild system, but supports the same
    // defaults.

    //>	@attr tabSet.tabProperties (Tab Properties : null : IR)
	// Properties to apply to all Tabs created by this TabSet.
    // @visibility external
	//<
    tabProperties:{},

    //> @attr tabSet.defaultTabWidth (number : null : IR)
    // If set, is passed as "width" to all tabs when +link{tabBarPosition} is set to 
    // <code>"top"</code> or <code>"bottom"</code>.
    // <P>
    // If unset, width will be picked up from
    // the Tab constructor class defaults. Tabs expand to fit their content, so 
    // this width acts as a minimum.
    // Setting width:1 will result in tabs that are
    // only as wide as their titles. May be customized by individual
    // +link{group:skinning,skins}.
    // @visibility external
    //<

    //> @attr tabSet.defaultTabHeight (number : null : IR)
    // If set, is passed as "height" to all tabs when +link{tabBarPosition} is set to 
    // <code>"left"</code> or <code>"right"</code>. 
    // <P>
    // If unset, height will be picked up from
    // the Tab constructor class defaults. Note that tabs expand to fit their content so
    // this height acts as a minimum. May be customized by individual
    // +link{group:skinning,skins}.
    // @visibility external
    //<
    
    // Simple Tabs
    // ---------------------------------------------------------------------------------------

    //> @attr tabSet.useSimpleTabs (Boolean : false : IRA)
    // Should we use simple button based tabs styled with CSS rather than
    // image based +link{class:ImgTab} tabs?
    // <P>
    // <smartclient>
    // If set to true the +link{tabSet.simpleTabButtonConstructor} will be used and tabs will
    // by styled according to +link{tabSet.simpleTabBaseStyle}.
    // </smartclient>
    // <smartgwt>
    // If set to true tabs will instances of +link{class:Button}, styled according to the
    // +link{tabSet.simpleTabBaseStyle}.
    // </smartgwt>
    // @visibility external
    //<
    //useSimpleTabs:false,
    
    //> @attr tabSet.simpleTabBaseStyle (CSSStyleName : "tabButton" : [IRW])
    // If +link{useSimpleTabs} is true, <code>simpleTabBaseStyle</code> will be the base style
    // used to determine the css style to apply to the tabs.<P>
    // This property will be suffixed with the side on which the tab-bar will appear, followed
    // by with the tab's state (selected, over, etc), resolving to a className like 
    // "tabButtonTopOver".
    // @see Button.baseStyle
    // @see simpleTabIconOnlyBaseStyle
    // @group appearance
    // @visibility external
    //<
    simpleTabBaseStyle:"tabButton",

    //> @attr tabSet.simpleTabIconOnlyBaseStyle (CSSStyleName : varies : [IRW])
    // If +link{useSimpleTabs} is true, <code>simpleTabIconOnlyBaseStyle</code> will be the
    // base style used to determine the css style to apply to the tabs if
    // +link{tab.canAdaptWidth} is set and the title is not being shown.
    // <P>
    // This property will be suffixed with the side on which the tab-bar will appear, followed
    // by with the tab's state (selected, over, etc), resolving to a className like 
    // "iconOnlyTabButtonTopOver".
    // <P>
    // Note that this property is only defined for certain skins, where it's needed.  If not
    // defined, +link{simpleTabBaseStyle} will serve as base style whether or not the title is
    // hidden.
    // @see Button.baseStyle
    // @see Button.iconOnlyBaseStyle
    // @see simpleTabBaseStyle
    // @visibility external
    //<
 
    // TabBar placement and sizing   
    // ---------------------------------------------------------------------------------------

    //> @attr tabSet.tabBarPosition (Side : isc.Canvas.TOP : IR)
    // Which side of the TabSet the TabBar should appear on.
    // @group tabBar
    // @visibility external
    // @example tabsOrientation
    //<
    tabBarPosition:isc.Canvas.TOP,

    //> @attr tabSet.tabBarAlign (Side | Alignment : see below : IRW)
    // Alignment of the tabBar.
    // <P>
    // If the +link{tabSet.tabBarPosition, tabBarPosition} is "top" or "bottom", then 
    // this attribute may be set to "left", "right" or "center".  The default is "left", or
    // "right" in +link{isc.Page.isRTL,RTL mode}.
    // <P>
    // If the +link{tabSet.tabBarPosition, tabBarPosition} is "left" or "right", then this
    // attribute may be set to "top", "bottom" or "center".  The default is "top".
    // 
    // @group tabBar
    // @visibility external
    // @example tabsAlign
    //<
    
    setTabBarAlign : function (align) {
        var Canvas = isc.Canvas,
            position = this.tabBarPosition
        ;
        // reject any tabBarAlign incompatible with tabBarPosition
        if ((position == Canvas.LEFT || position == Canvas.RIGHT) &&
            align != Canvas.TOP  && align != Canvas.BOTTOM && align != Canvas.CENTER ||
            (position == Canvas.TOP  || position == Canvas.BOTTOM) &&
            align != Canvas.LEFT && align != Canvas.RIGHT  && align != Canvas.CENTER)
        {
            this.logWarn("tabBarAlign: '" + align + "' is incompatible with tabBarPosition: '" +
                         position + "'");
            return;

        } else if (this.logIsDebugEnabled()) {
            this.logWarn("updating tabBarAlign: '" + this.tabBarAlign + "' => '" + align + "'");
        }

        
        var tabBar = this.tabBar;
        this.tabBarAlign = tabBar.tabBarAlign = align;

        tabBar.setAlign(align);
        tabBar.reflow("tabBarAlign");
    },

    //> @attr tabSet.tabBarThickness (number : 21 : IRW)
    // Thickness of tabBar, applies to either orientation (specifies height for horizontal,
    // width for vertical orientation).  Note that overriding this value for TabSets that are
    // skinned with images generally means providing new media for the borders.
    // @group tabBar
    // @visibility external
    //<
    tabBarThickness:21,

    // ---------------------------------------------------------------------------------------

    //>	@attr	tabSet.selectedTab		(Tab | int : 0 : IRW)
    // Specifies the index of the initially selected tab.
    // @group tabBar
    // @visibility external
    //<
	selectedTab:0,
    
    // ---------------------------------------------------------------------------------------

    //> @attr tabSet.canCloseTabs (boolean : null : IRW)
    // Should tabs in this tabSet show an icon allowing the user to dismiss the tab by
    // clicking on it directly. May be overridden for individual tabs by setting 
    // +link{tab.canClose}.
    // <P>
    // The URL for this icon's image will be derived from  +link{tabSet.closeTabIcon} by 
    // default, but may be overridden by explicitly specifying +link{tab.closeIcon}.
    // <P>
    // <b>Note</b>: Currently, tabs can only show a single icon, so a closable tab will show
    // the close icon only even if +link{tab.icon} is set.  To work around this, add the icon
    // as an HTML &lt;img&gt; tag to the +link{tab.title} property, for example:
    // <smartclient>
    // <pre>
    //    title : "&lt;span&gt;" + isc.Canvas.imgHTML("path/to/icon.png") + " Tab Title&lt;/span&gt;"
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //    tab.setTitle("&lt;span&gt;" + Canvas.imgHTML("path/to/icon.png") + " Tab Title&lt;/span&gt;");
    // </pre>
    // </smartgwt>
    //
    // @see TabSet.closeClick()
    // @group tabBar
    // @visibility external
    //<
    
    //> @attr tabSet.closeTabIcon (SCImgURL : [SKIN]/TabSet/close.png : IR)
    // Default src for the close icon for tabs to display if +link{tabSet.canCloseTabs} is true.
    // @group appearance
    // @visibility external
    //<
    closeTabIcon:"[SKIN]/TabSet/close.png",

    //> @attr tabSet.closeTabIconSize (int : 16 : IR)
    // Size in pixels of the icon for closing tabs, displayed when +link{canCloseTabs} is true.
    // @visibility external
    //<
    closeTabIconSize:16,

    //> @attr tabSet.ariaCloseableSuffix (String : ", closeable" : IRA)
    // When +link{isc.setScreenReaderMode(),screen reader mode} is enabled and a tab is
    // +link{TabSet.canCloseTabs,closeable}, the <code>ariaCloseableSuffix</code> is a string
    // that is appended to the label of closeable tabs. This suffix is hidden from sighted
    // users, but is announced by screen readers to indicate that the tab may be closed.
    // <p>
    // Set to <code>null</code> to disable appending this suffix.
    // @group i18nMessages
    // @visibility external
    //<
    
    ariaCloseableSuffix:", closeable",

    //> @attr tabSet.canReorderTabs (boolean : null : IR)
    // If true, tabs can be reordered by dragging on them.
    // <P>
    // To disallow drag-reorder of a specific tab, see +link{tab.canReorder}.
    // @group dragdrop
    // @visibility external
    //<
    
    //> @attr tabSet.showMoreTab (boolean : null : IR)
    // @include tabBar.showMoreTab
    // @visibility external
    //<

    //> @attr tabSet.moreTabCount (number : 5 : IR)
    // @include tabBar.moreTabCount
    // @visibility external
    //<
    moreTabCount:5,

    //> @attr tabSet.moreTabTitle (String : "More" : IR)
    // Title for the "More" tab.
    // @visibility external
    //<
    moreTabTitle:"More",

    //> @attr tabSet.moreTabImage (SCImgURL : "[SKINIMG]/iOS/more.png" : IR)
    // If +link{showMoreTab} is enabled this property determines the image to display on
    // the "More" tab button.
    // @visibility external
    //<
    moreTabImage:"[SKINIMG]/iOS/more.png",

    //> @attr tabSet.moreTab (AutoChild Tab : null : R)
    // +link{object:Tab} to be shown when +link{showMoreTab} is enabled
    // more than +link{moreTabCount} tabs are provided.
    // @visibility external
    //<

    moreTabDefaults: { ariaRole:"tab" },

    //>	@attr tabSet.moreTabProperties (Tab Properties : null : IR)
    // Properties to apply to the "more" tab created by this TabSet.
    // @visibility external
    //<
    moreTabProperties:{},

    //> @attr tabSet.moreTabPane (AutoChild VLayout : null : R)
    // Pane contents for the "more" tab based on a VLayout. Typically contains
    // a +link{NavigationBar} and +link{TableView}.
    // @visibility external
    //<

    //>	@attr tabSet.moreTabPaneProperties (Canvas Properties : null : IR)
    // Properties to apply to the "more" tab's pane created by this TabSet.
    // @visibility external
    //<
    moreTabPaneProperties:{},

    //>	@attr tabSet.moreTabPaneDefaults (Canvas Properties : null : IR)
    // Default properties for the "more" tab's pane.
    // <p>
    // Currently constructs a VLayout with a +link{NavigationBar} and +link{TableView}.
    // @visibility external
    //<
    moreTabPaneDefaults:{
        _constructor: "VLayout",
        width: "100%",
        height: "100%",
        setData : function (newData) {
            this.creator.moreTabPaneTable.setData(newData);
        }
    },
    
    //> @attr tabSet.moreTabPaneNavBar (AutoChild NavigationBar : null : IR)
    // Navigation bar shown in the +link{tabSet.moreTabPane};
    // @visibility external
    //<
    // @see +link{showMoreTab}.

    
    moreTabPaneNavBarDefaults:{
        _constructor: "NavigationBar",
        controls: ["titleLabel"],
        autoParent: "moreTabPane"
    },
    
    //> @attr tabSet.moreTabPaneTable (AutoChild TableView : null : IR)
    // +link{TableView} used to show links to other tabs in the +link{tabSet.moreTabPane};
    // @visibility external
    //<
    // @see +link{showMoreTab}.
    
    moreTabPaneTableDefaults:{
        _constructor: "TableView",
        width: "100%",
        height: "100%",
        recordNavigationClick : function (record) {
            this.creator._tabSelected(record.button);
        },
        autoParent: "moreTabPane"
    },

    // -----------------------------------------------------------
    // Tab bar controls

    //> @attr tabSet.tabBarControls (Array : "tabScroller"|"tabPicker"|Canvas: IRA)
    // This property determines what controls should show up after the tabBar for this TabSet.
    // Standard controls can be included using the strings <code>"tabScroller"</code> and 
    // <code>"tabPicker"</code>. These correspond to the +link{TabSet.scroller} and +link{TabSet.tabPicker}
    // AutoChildren, respectively. The <code>"tabScroller"</code> standard control shows two
    // buttons for scrolling through the tabs in order and the <code>"tabPicker"</code> standard
    // control allows tabs to be picked directly from a menu. The standard controls show up only if
    // +link{tabSet.showTabScroller} or +link{tabSet.showTabPicker} is true and there is not
    // enough space available to show all of the tabs in the tabBar.
    // <P>
    // +explorerExample{layout_tabs_custom_controls, This sample} illustrates the usage of this property
    // <P>
    // Additional controls can be included by adding any widget to this array.  Controls will
    // show up in the order in which they are specified.  For example, the following code would
    // add a button in the tabBar area, while preserving the normal behavior of the tabScroller
    // and tabPicker:
    // <smartclient>
    // <pre>
    // isc.TabSet.create({
    //     width:300,
    //     tabs : [
    //         { title: "Tab one" }
    //     ],
    //     tabBarControls : [
    //         isc.ImgButton.create({
    //             src:"[SKINIMG]/actions/add.png",
    //             width:16, height:16,
    //             layoutAlign:"center"
    //         }),
    //         "tabScroller", "tabPicker"
    //     ]
    // });
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //		ImgButton addButton = new ImgButton();
    //		addButton.setSrc("[SKINIMG]/actions/add.png");
    //		addButton.setTitle("Add");
    //		addButton.setWidth(16);
    //		addButton.setHeight(16);
    //		addButton.setAlign(Alignment.CENTER);
    //		TabSet ts = new TabSet();
    //		ts.setWidth(300);
    //		ts.setHeight(32);
    //		ts.setTabs(new Tab("Tab one"));
    //		ts.setTabBarControls(addButton, TabBarControls.TAB_SCROLLER, TabBarControls.TAB_PICKER);
    //		contentLayout.addMember(ts);
    // </pre>
    // </smartgwt>
    // You can also refer to the default tabPicker/tabScroll controls
    // from Component XML:
    // <pre>
    // &lt;TabSet width="300"&gt;
    //     &lt;tabBarControls&gt;
    //         &lt;Button title="Custom Button"/&gt;
    //         &lt;value xsi:type="string"&gt;tabPicker&lt;/value&gt;
    //         &lt;value xsi:type="string"&gt;tabScroller&lt;/value&gt;
    //      &lt;/tabBarControls&gt;
    //      &lt;tabs&gt;
    //          &lt;tab title="Foo"/&gt;
    //          &lt;tab title="Bar"/&gt;
    //     &lt;/tabs&gt;
    // &lt;/TabSet&gt;
    // </pre>
    // <p>
    // When +link{Browser.isTouch} is <code>true</code> and native touch scrolling is supported,
    // then by default, only the <code>"tabPicker"</code> is shown. The <code>"tabScroller"</code>
    // control is omitted by default on touch devices because the tabs in the tab bar are native
    // touch-scrollable, so the <code>"tabScroller"</code> control is unnecessary. To override
    // the omission of the <code>"tabScroller"</code>, simply add
    // <smartclient>"tabScroller"</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.TabBarControls#TAB_SCROLLER}</smartgwt>
    // to the <code>tabBarControls</code> array.
    // <P>
    // <b>Note:</b> Due to tabs supporting +link{tab.canAdaptWidth,adaptive width} and other
    // complexities of TabSet widget layout, +link{canvas.width,flexible-sized} controls
    // (including +link{LayoutSpacer,spacers}) aren't supported in <code>tabBarControls</code>.
    // However, if you take into account the width of your tabs and whether the +link{tabPicker,
    // picker} and +link{scroller} are present, you can add a fixed-width spacer to achieve the
    // desired appearance, as long as the set of tabs and TabSet width are static.
    //
    // @group tabBarControls
    // @visibility external
    //<
    tabBarControls: ["tabScroller", "tabPicker"],


    //> @attr tabSet.showTabScroller (Boolean : null : [IR])
    // If there is not enough space to display all the tab-buttons in this tabSet, should 
    // scroll buttons be displayed to allow access to tabs that are clipped?  If unset, 
    // defaults to false for +link{Browser.isHandset, handsets} and true otherwise.
    // @visibility external
    // @group tabBarControls
    //<
    //showTabScroller:null,

    //> @attr tabSet.showTabPicker (Boolean : true : [IR])
    // If there is not enough space to display all the tab-buttons in this tabSet, should
    // a drop-down "picker" be displayed to allow selection of tabs that are clipped?
    // @visibility external
    // @group tabBarControls
    //<    
    showTabPicker:true,

    //> @attr tabSet.tabBarControlLayout (AutoChild Layout : null : IR)
    // +link{AutoChild} of type +link{Layout} that holds the +link{tabBarControls} as well as
    // the built-in controls such as the +link{showTabPicker,tab picker menu}.
    // @visibility external
    //<
    tabBarControlLayoutConstructor:"Layout",
    tabBarControlLayoutDefaults:{
        overflow:"hidden",
        defaultLayoutAlign: "center"
    },
    
    //>Animation
    //> @attr   tabSet.animateTabScrolling  (Boolean : true : [IR])
    // If +link{tabSet.showTabScroller} is true, should tabs be scrolled into view via an 
    // animation when the user interacts with the scroller buttons?
    // @visibility external
    // @group tabBarControls
    //<
    animateTabScrolling:true,
    //<Animation

    //> @attr tabSet.scroller (AutoChild StretchImgButton : null : R)
    // A component containing back and forward buttons for scrolling through all of the tabs
    // of the TabSet. The scroller is created automatically when needed and when <code>"tabScroller"</code>
    // is specified in the +link{TabSet.tabBarControls}.
    // <p>
    // By default, the scroller constructor is +link{StretchImgButton}. Note that the scroller
    // +link{StretchImg.items,items} are determined automatically, so any items set in
    // scrollerProperties will be ignored.
    // @group tabBarControls
    // @visibility external
    //<
    // @see TabSet.getScrollerBackImgName()
    // @see TabSet.getScrollerForwardImgName()
    scrollerDefaults: {
        _constructor: isc.StretchImgButton,

        // set noDoubleClicks - this means if the user clicks repeatedly on the
        // scroller we'll move forward 1 tab for each click rather than appearing
        // to swallow every other click
        noDoubleClicks: true,

        // Disable normal over/down styling as that would style both buttons at once
        
        autoApplyDownState:false,
        autoApplyOverState:false,

        mouseMove : function () {
            if (!this.creator.showScrollerRollOver) return;
            var currPart = this.inWhichPart();
            var otherPart = currPart == this.backPartName ? this.forwardPartName : this.backPartName;
            this.setState(isc.StatefulCanvas.STATE_UP, otherPart);
            this.setState(isc.StatefulCanvas.STATE_OVER, currPart);
        },
        mouseOut : function () {
            if (!this.creator.showScrollerRollOver) return;
            this.setState(isc.StatefulCanvas.STATE_UP, this.forwardPartName);
            this.setState(isc.StatefulCanvas.STATE_UP, this.backPartName);
        },
        mouseDown : function () {
            this.clickPart = this.inWhichPart();
            this.setState(isc.StatefulCanvas.STATE_DOWN, this.clickPart);
        },
        mouseUp : function () {
            this.setState(isc.StatefulCanvas.STATE_UP, this.clickPart);
        },
        
        mouseStillDown : function () {
            var back = this.clickPart == this.backPartName;
            
            if (this.isRTL()) back = !back;
            // figure out which part they clicked in and remember it
            if (back) this.creator.scrollBack();
            else this.creator.scrollForward();
        },
        click : function () {
            return false; // just cancel bubbling
        }
    },

    //> @attr   tabSet.scrollerButtonSize   (number : 16 : [IR])
    // If +link{tabSet.showTabScroller} is true, this property governs the size of scroller
    // buttons. Applied as the width of buttons if the tabBar is horizontal, or the height
    // if tabBar is vertical. Note that the other dimension is determined by 
    // +link{tabBarThickness,this.tabBarThickness}
    // @group tabBarControls
    // @visibility external
    //<
    scrollerButtonSize:16,

    //> @attr tabSet.tabPicker (AutoChild ImgButton : null : R)
    // A button control that allows tabs to be picked directly from a popup menu. The tabPicker
    // is created automatically when needed and when <code>"tabPicker"</code> is specified in
    // the +link{TabSet.tabBarControls}.
    // @group tabBarControls
    // @visibility external
    //<
    // @see TabSet.getTabPickerSrc()
    tabPickerDefaults: {
        _constructor: isc.ImgButton,
        showRollOver: false,

        click : function () {
            this.creator.showTabPickerMenu();
        }
    },

    //> @attr tabSet.pickerButtonSize (int : 16 : IR)
    // If +link{TabSet.showTabPicker,showTabPicker} is <code>true</code> and +link{Browser.isTouch}
    // is <code>false</code>, this property governs the size of the tab picker button. This value
    // is applied as the width of the tab picker button if the +link{TabSet.tabBar,tabBar} is
    // horizontal, or the height if the <code>tabBar</code> is vertical. Note that the other
    // dimension is determined by +link{tabBarThickness,this.tabBarThickness}.
    // <p>
    // On touch browsers (where +link{Browser.isTouch} is <code>true</code>),
    // +link{TabSet.touchPickerButtonSize,touchPickerButtonSize} is used instead.
    // @group tabBarControls
    // @visibility external
    //<
    pickerButtonSize:16,

    //> @attr tabSet.touchPickerButtonSize (int : 16 : IR)
    // The size of the tab picker button when +link{Browser.isTouch} is <code>true</code>.
    // @see TabSet.pickerButtonSize
    // @group tabBarControls
    // @visibility external
    //<
    touchPickerButtonSize:16,

    //> @attr   tabSet.skinImgDir (SCImgURL : "images/TabSet/" : [IR])
    // @include Canvas.skinImgDir
    //<
	skinImgDir:"images/TabSet/",

    //> @attr tabSet.symmetricScroller (Boolean : true : [IR])
    // If this TabSet is showing +link{tabSet.showTabScroller,tab scroller buttons}, this property 
    // determines whether the +link{tabSet.scrollerHSrc} and +link{tabSet.scrollerVSrc} media
    // will be used for vertical and horizontal tab-bar scroller buttons, or whether separate
    // media should be used for each possible +link{tabSet.tabBarPosition,tabBarPosition} based
    // on the +link{tabSet.scrollerSrc} property for this tabSet.
    // @group tabBarScrolling
    // @visibility external
    //<
    symmetricScroller:true,
    
    //> @attr   tabSet.scrollerSrc (SCImgURL : "[SKIN]/scroll.gif" : [IR])
    // If this TabSet is showing +link{tabSet.showTabScroller,tab scroller buttons}, and 
    // +link{tabSet.symmetricScroller,symmetricScroller} is false, this property governs the base
    // URL for the tab bar back and forward scroller button images.
    // <P>
    // Note that if +link{tabSet.symmetricScroller,symmetricScroller} is true, 
    // +link{tabSet.scrollerHSrc} and +link{tabSet.scrollerVSrc} will be used instead.
    // <P>
    // To get the path to the image to display, this base URL will be modified as follows:
    // <ul>
    // <li>If appropriate a state suffix of <code>"Down"</code> or <code>"Disabled"</code> will be
    //     appended.</li>
    // <li>The +link{tabSet.tabBarPosition,tabBarPosition} for this tabSet will be appended.</li>
    // <li>A suffix of <code>"forward"</code> or <code>"back"</code> will be appended for the
    //     forward or backward scrolling button.</li>
    // </ul>
    // For example - if the scrollerSrc is set to <code>"[SKIN]scroll.gif"</code>, the image
    // displayed for the back-scroller button on a tabSet with <code>tabBarPosition</code> set to
    // "top" and <code>symmetricScroller</code> set to false would be one of 
    // <code>"[SKIN]scroll_top_back.gif"</code>, <code>"[SKIN]scroll_Down_top_back.gif"</code>,
    // and <code>"[SKIN]scroll_Disabled_top_back.gif"</code>.
    // <P>
    // Note that for best results the media should be sized to match the scroller button sizes, 
    // determined by +link{tabSet.tabBarThickness} and +link{tabSet.scrollerButtonSize}.
    // @see tabSet.symmetricScroller
    // @group tabBarScrolling
    // @visibility external
    //<
    scrollerSrc:"[SKIN]/scroll.gif",
    
    //> @attr   tabSet.scrollerHSrc (SCImgURL :"[SKIN]hscroll.gif" : [IR])
    // If this TabSet is showing +link{tabSet.showTabScroller,tab scroller buttons}, and 
    // +link{tabSet.symmetricScroller,symmetricScroller} is true, this property governs the base
    // URL for the tab bar back and forward scroller button images for horizontal tab bars [IE for
    // tab sets with +link{tabSet.tabBarPosition,tabBarPosition} set to "top" or "bottom"].
    // <P>
    // Note that if +link{tabSet.symmetricScroller,symmetricScroller} is false, 
    // +link{tabSet.scrollerSrc} will be used instead.
    // <P>
    // To get the path to the image to display, this base URL will be modified as follows:
    // <ul>
    // <li>If appropriate a state suffix of <code>"Down"</code> or <code>"Disabled"</code> will be
    //     appended.</li>
    // <li>A suffix of <code>"forward"</code> or <code>"back"</code> will be appended for the
    //     forward or backward scrolling button.</li>
    // </ul>
    // For example - if the scrollerHSrc is set to <code>"[SKIN]hscroll.gif"</code>, the image
    // displayed for the back-scroller button on a tabSet with <code>tabBarPosition</code> set to
    // "top" and <code>symmetricScroller</code> set to true would be one of 
    // <code>"[SKIN]hscroll_back.gif"</code>, <code>"[SKIN]hscroll_Down_back.gif"</code>,
    // and <code>"[SKIN]hscroll_Disabled_back.gif"</code>.
    // <P>
    // Note that for best results the media should be sized to match the scroller button sizes, 
    // determined by +link{tabSet.tabBarThickness} and +link{tabSet.scrollerButtonSize}.
    // @see tabSet.symmetricScroller
    // @group tabBarScrolling
    // @visibility external
    //<
    scrollerHSrc:"[SKIN]hscroll.gif",
    
    //> @attr   tabSet.scrollerVSrc (SCImgURL :"[SKIN]vscroll.gif" : [IR])
    // If this TabSet is showing +link{tabSet.showTabScroller,tab scroller buttons}, and 
    // +link{tabSet.symmetricScroller,symmetricScroller} is true, this property governs the base
    // URL for the tab bar back and forward scroller button images for vertical tab bars [IE for
    // tab sets with +link{tabSet.tabBarPosition,tabBarPosition} set to "left" or "right"].
    // <P>
    // Note that if +link{tabSet.symmetricScroller,symmetricScroller} is false, 
    // +link{tabSet.scrollerSrc} will be used instead.
    // <P>
    // To get the path to the image to display, this base URL will be modified as follows:
    // <ul>
    // <li>If appropriate a state suffix of <code>"Down"</code> or <code>"Disabled"</code> will be
    //     appended.</li>
    // <li>A suffix of <code>"forward"</code> or <code>"back"</code> will be appended for the
    //     forward or backward scrolling button.</li>
    // </ul>
    // For example - if the scrollerVSrc is set to <code>"[SKIN]vscroll.gif"</code>, the image
    // displayed for the back-scroller button on a tabSet with <code>tabBarPosition</code> set to
    // "left" and <code>symmetricScroller</code> set to true would be one of 
    // <code>"[SKIN]vscroll_back.gif"</code>, <code>"[SKIN]vscroll_Down_back.gif"</code>,
    // and <code>"[SKIN]vscroll_Disabled_back.gif"</code>.
    // <P>
    // Note that for best results the media should be sized to match the scroller button sizes, 
    // determined by +link{tabSet.tabBarThickness} and +link{tabSet.scrollerButtonSize}.
    // @see tabSet.symmetricScroller
    // @group tabBarScrolling
    // @visibility external
    //<
    scrollerVSrc:"[SKIN]vscroll.gif",
    
    //> @attr tabSet.showScrollerRollOver (boolean : false : [IR])
    // set this to true to show scroller rollover images when the mouse is over the scroller 
    // buttons
    // @group tabBarScrolling
    //<
    
    //> @attr tabSet.scrollerProperties (Object : null : [IR])
    // Properties set here override those supplied by default when creating
    // the scroller control.
    // @group tabBarScrolling
    //<
    
    
    //> @attr tabSet.symmetricPickerButton (Boolean : true : [IR])
    // If this TabSet is showing a +link{tabSet.showTabPicker,tab picker button}, this
    // property determines whether the +link{tabSet.pickerButtonHSrc} and
    // +link{tabSet.pickerButtonVSrc} media will be used for vertical and horizontal tab-bar
    // picker buttons, or whether separate media should be used for each possible 
    // +link{tabSet.tabBarPosition,tabBarPosition} based on the +link{tabSet.pickerButtonSrc}
    // property  for this tabSet.
    // @group tabBarScrolling
    // @visibility external
    //<
    symmetricPickerButton:true,
    
    //> @attr   tabSet.pickerButtonSrc (SCImgURL : "[SKIN]/picker.gif" : [IR])
    // If +link{tabSet.showTabPicker} is true, this property governs the base URL for the picker
    // button image, when +link{tabSet.symmetricPickerButton} is set to false
    // <P>
    // Note that if <code>symmetricPickerButton</code> is true, the +link{tabSet.pickerButtonHSrc} 
    // and +link{tabSet.pickerButtonVSrc} properties will be used instead.
    // <P>
    // To get the path to the image to display, this base URL will be modified as follows:
    // <ul>
    // <li>If appropriate a state suffix of <code>"Down"</code> or <code>"Disabled"</code> will be
    //     appended.</li>
    // <li>The +link{tabSet.tabBarPosition,tabBarPosition} for this tabSet will be appended.</li>
    // </ul>
    // @see tabSet.symmetricPickerButton    
    // @group tabBarScrolling
    // @visibility external
    //<    
    pickerButtonSrc:"[SKIN]/picker.gif",
    
    //> @attr   tabSet.pickerButtonHSrc (SCImgURL : "[SKIN]hpicker.gif" : [IR])
    // If +link{tabSet.showTabPicker} is true, and +link{tabSet.symmetricPickerButton} is 
    // set to true, this property governs the base URL for the picker
    // button image, when displayed in a horizontal tab-bar [IE +link{tabSet.tabBarPosition} is
    // set to <code>"top"</code> or <code>"bottom"</code>].
    // <P>
    // Note that if <code>symmetricPickerButton</code> is false, the +link{tabSet.pickerButtonSrc}
    // property will be used instead.
    // <P>
    // This base URL will have a suffix of <code>"Down"</code> appended when the user holds the
    // mouse down over the button, and <code>"Disabled"</code> if the tabset as a whole is 
    // disabled.
    // @see tabSet.symmetricPickerButton    
    // @group tabBarScrolling
    // @visibility external
    //<    
    pickerButtonHSrc:"[SKIN]hpicker.gif",
    
    //> @attr   tabSet.pickerButtonVSrc (SCImgURL : "[SKIN]vpicker.gif" : [IR])
    // If +link{tabSet.showTabPicker} is true, and +link{tabSet.symmetricPickerButton} is 
    // set to true, this property governs the base URL for the picker
    // button image, when displayed in a verricaL tab-bar [IE +link{tabSet.tabBarPosition} is
    // set to <code>"LEFT"</code> or <code>"right"</code>].
    // <P>
    // Note that if <code>symmetricPickerButton</code> is false, the +link{tabSet.pickerButtonSrc}
    // property will be used instead.
    // <P>
    // This base URL will have a suffix of <code>"Down"</code> appended when the user holds the
    // mouse down over the button, and <code>"Disabled"</code> if the tabset as a whole is 
    // disabled.
    // @see tabSet.symmetricPickerButton    
    // @group tabBarScrolling
    // @visibility external
    //<    
    pickerButtonVSrc:"[SKIN]vpicker.gif",

	// PaneContainer
	// ----------------------------------------------------------------------------------------

    //> @attr tabSet.paneContainer (AutoChild VLayout : null : R)
    // Container where the component specified by +link{tab.pane} is shown.
    // <P>
    // Note: paneContainer and showEdges:true for rounded tabsets: you can enable decorative
    // image-based edges on the paneContainer by setting +link{Canvas.showEdges,showEdges:true}
    // via paneContainerDefaults (to skin all tabsets) or paneContainerProperties (to use
    // edges on one instance).  In this structure, the +link{group:baseLine} should use media
    // that matches the appearance of the decorative edges and fully overlaps the edge of the
    // paneContainer that it is adjacent to.  In the most typical appearance (symmetric edges
    // on all 4 sides), both +link{tabBar.baseLineCapSize} and +link{tabBar.baseLineThickness}
    // match the +link{canvas.edgeSize,edgeSize} set on the paneContainer.  See the
    // load_skin.js file for the "SmartClient" skin for an example of setting all relevant
    // properties.
    // <P>
    // To disable edges for a particular TabSet, which you may want to do for a TabSet that
    // is already within a clearly defined container, configure the paneContainer to show only
    // it's top edge:
    // <pre>
    //      paneContainerProperties : { customEdges:["T"] },
    // </pre>
    // To completely flatten even the top edge of the TabSet:
    // <pre>
    //      paneContainerProperties : { customEdges:["T"] },
	//      tabBarProperties :{ baseLineCapSize:0 },
    // </pre>
    // This "flattens" the baseLine so that only the center image is used.
    //
    // @visibility external
    //<
    // XXX: advice above suboptimal:
    // - in general, the StretchImg baseline is using different media names for the same media.
    //   Could be fixed by passing custom sib.items to the baseline
    // - when we "flatten" as above, the paneContainer is still rendering a top edge and still
    //   using 3 pieces of media, it's just occluded by the baseline.  Ideally, we'd turn the
    //   edges off entirely, but by default this would cause the baseline to actually overlap
    //   widgets show in the paneContainer, so a margin would need to be set in CSS to
    //   compensate - more complicated to explain

	paneContainerConstructor:"PaneContainer",

	//>	@attr	tabSet.paneContainerClassName		(CSSStyleName : null : IRW)
	// CSS style used for the paneContainer.
    // @group appearance
    // @visibility external
	//<
	paneContainerClassName:"tabSetContainer",

    //>	@attr	tabSet.paneContainerOverflow	(Overflow : isc.Canvas.AUTO : IRWA)
	// Specifies the overflow of the pane container (the component that holds the pane contents
    // for all tabs).  By default this is set to "auto", meaning the pane container will
    // automatically introduce scrolling when the pane contents exceed the TabSet's specified
    // size.
    // <p>
    // For other values and their meaning, see +link{Overflow}
    //
    // @visibility external
	//<
	paneContainerOverflow:isc.Canvas.AUTO,

    //> @method tabSet.setPaneContainerOverflow()
    // Update +link{paneContainerOverflow} after creation.
    //
    // @param newOverflow (Overflow) new overflow setting
    // @visibility external
    //<
    setPaneContainerOverflow : function (newOverflow) {
        this.paneContainerOverflow = newOverflow;
        if (this.paneContainer) this.paneContainer.setOverflow(newOverflow);
    },
    
    //> @attr tabSet.symmetricEdges (Boolean : true : IR)
    // If this tabSet will +link{tabSet.showPaneContainerEdges,show edges} for the paneContainer,
    // this property determines whether the same edge media will be used regardless of the tab
    // bar position, or whether different media should be used (necessary if the edge appearance is
    // not symmetrical on all sides).
    // <P>
    // If this property is set to false the paneContainer edge image URLs will be prefixed with
    // the tabBarPosition of the tabSet - for example <code>"[SKIN]edge_top_T.gif"</code> rather
    // than just <code>"[SKIN]edge_T.gif"</code>.
    // <P>
    // When <code>symmetricEdges</code> is false, custom edge sizes for the pane container may be
    // specified via +link{tabSet.topEdgeSizes} et al, and custom edge offsets via 
    // +link{tabSet.topEdgeOffsets} et al.
    // @group appearance
    // @visibility external
    //<
    symmetricEdges:true,
    
    //> @type EdgeSizes
    // Object used to specify custom edge sizes or offsets.
    // Specified as an object where <code>defaultSize</code> will map to the default edge size or 
    // offset for the canvas (+link{canvas.edgeSize}, or +link{canvas.edgeOffset} and
    // <code>top</code>, <code>left</code>, <code>right</code> and
    // <code>bottom</code> will map to the
    // +link{edgedCanvas.edgeTop,edgeTop}/+link{edgedCanvas.edgeOffsetTop,edgeOffsetTop}, 
    // +link{edgedCanvas.edgeLeft,edgeLeft}/+link{edgedCanvas.edgeOffsetLeft,edgeOffsetLeft},
    // +link{edgedCanvas.edgeRight,edgeRight}/+link{edgedCanvas.edgeOffsetRight,edgeOffsetRight},
    // and +link{edgedCanvas.edgeBottom,edgeBottom}/+link{edgedCanvas.edgeOffsetBottom,edgeOffsetBottom}
    // attributes on the paneContainer respectively. Note that not all these properties have to be
    // set - if unset standard edge sizing rules will apply. 
    // @visibility external
    //<
       
    //> @attr tabSet.leftEdgeSizes (EdgeSizes : null : IR)
    // If this tabSet will +link{tabSet.showPaneContainerEdges,show edges} for the paneContainer,
    // and +link{tabSet.symmetricEdges} is set to false, the <code>leftEdgeSizes</code>, 
    // <code>rightEdgeSizes</code>, <code>topEdgeSizes</code> and <code>bottomEdgeSizes</code> 
    // properties allow the sizes of edges for the paneContainer to be customized depending on
    // the +link{tabSet.tabBarPosition}.
    // <P>
    // The attribute should be specified an +link{type:EdgeSizes,edgeSizes map}, specifying the
    // desired edge sizes where for the appropriate +link{tabSet.tabBarPosition}.
    // @visibility external
    //<
    
    //> @attr tabSet.topEdgeSizes (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeSizes
    // @visibility external
    //<
    
    //> @attr tabSet.bottomEdgeSizes (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeSizes
    // @visibility external
    //<
    
    //> @attr tabSet.rightEdgeSizes (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeSizes
    // @visibility external
    //<
    
    //> @attr tabSet.leftEdgeOffsets (EdgeSizes : null : IR)
    // If this tabSet will +link{tabSet.showPaneContainerEdges,show edges} for the paneContainer,
    // and +link{tabSet.symmetricEdges} is set to false, the <code>leftEdgeOffsets</code>, 
    // <code>rightEdgeOffsets</code>, <code>topEdgeOffsets</code> and <code>bottomEdgeOffsets</code> 
    // properties allow the offsets of edges for the paneContainer to be customized depending on
    // the +link{tabSet.tabBarPosition}.
    // <P>
    // The attribute should be specified an +link{type:EdgeSizes,edgeSizes map}, specifying the
    // desired edge offsets where for the appropriate +link{tabSet.tabBarPosition}.
    // @visibility external
    //<
    
    //> @attr tabSet.rightEdgeOffsets (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeOffsets
    // @visibility external
    //<
    
    //> @attr tabSet.topEdgeOffsets (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeOffsets
    // @visibility external
    //<
    
    //> @attr tabSet.bottomEdgeOffsets (EdgeSizes : null : IR)
    // @include tabSet.leftEdgeOffsets
    // @visibility external
    //<
    
    //>	@attr	tabSet.showPaneContainerEdges (boolean : null : IRWA)
    // Should the paneContainer for this tabset show +link{Canvas.showEdges,edges}.
    //
    // @visibility external
    //<
    // set to null not false by default so we pick up the value from paneContainerDefaults
    // for backCompat (pre 6.1) 

    //> @attr tabSet.paneMargin (int : 0 : IR)
    // Space to leave around the panes in our paneContainer
    // <P>
    // Note that this property may be specified on a per-tab basis via +link{tab.paneMargin}.
    // @visibility external
    //<
    //paneMargin:0

    //>	@attr tabSet.canEditTabTitles (Boolean : false : IRW)
	// If true, users can edit the titles of tabs in this TabSet when the 
    // +link{titleEditEvent,titleEditEvent} fires.  You can override this behavior per tab 
    // with the +link{Tab.canEditTitle} property.
    // <p>
    // Note that this TabSet's +link{TabSet.titleEditEvent,titleEditEvent} must be set to a
    // supported +link{TabTitleEditEvent} in order for users to be able to edit the titles of
    // tabs.
    // @visibility external
    // @example userEditableTitles
	//<

    //>	@attr tabSet.titleEditEvent (TabTitleEditEvent : null : IRW)
	// The event that triggers title editing on this TabSet.
    // @see canEditTabTitles
    // @see Tab.canEditTitle
    // @visibility external
    // @example userEditableTitles
	//<

    //> @type TabTitleEditEvent
    // An event that triggers title editing in a TabSet.
    // @value "click"       Start editing when the user single-clicks a tab title
    // @value "doubleClick" Start editing when the user double-clicks a tab title
    // @visibility external
    //<

    //> @attr tabSet.titleEditor (AutoChild TextItem : null : R)
	// TextItem we use to edit tab titles in this TabSet.  You can override this property 
    // using the normal +link{AutoChild} facilities.
    // @see canEditTabTitles
    // @see Tab.canEditTitle
    // @see TabSet.editTabTitle
    // @visibility external
	//<
	
	// Explicitly call out titleEditorProperties as TextItem config so it gets 
	// picked up in SGWT
	//> @attr tabSet.titleEditorProperties (TextItem Properties : null : IR)
	// Properties for the auto-generated +link{tabSet.titleEditor}. This is the text item
	// we use to edit tab titles in this tabSet.
	// @see tabSet.titleEditor
	// @see canEditTabTitles
	// @visibility external
	//<

    //>	@attr tabSet.titleEditorLeftOffset (Integer : null : IRW)
	// If set, offsets the tab title editor further in from the left-hand edge of the tab, by
    // the number of pixels set in this property.  Note that the editor is always offset to
    // avoid overlapping the endcaps of the tab; this property is applied on top of that 
    // default offset.
    // @see titleEditorRightOffset
    // @see titleEditorTopOffset
    // @visibility external
	//<

    //>	@attr tabSet.titleEditorRightOffset (Integer : null : IRW)
	// If set, offsets the tab title editor further in from the right-hand edge of the tab, by
    // the number of pixels set in this property.  Note that the editor is always offset to
    // avoid overlapping the endcaps of the tab; this property is applied on top of that 
    // default offset.
    // @see titleEditorLeftOffset
    // @see titleEditorTopOffset
    // @visibility external
	//<

    //>	@attr tabSet.titleEditorTopOffset (Integer : null : IRW)
	// If set, offsets the tab title editor further down from the top edge of the tab, by the
    // number of pixels set in this property.  You can use this property, together with the 
    // left and right offset properties, to fine tune positioning of the editor within or 
    // around the tab button.<p>
    // <b>Note:</b> The height of the editor is an attribute of the editor itself, and can be
    // set by specifying a "height" property in +link{titleEditor,titleEditorDefaults}.
    // @see titleEditorLeftOffset
    // @see titleEditorRightOffset
    // @visibility external
	//<
    
    titleEditorDefaults: {
        name: "title", type: "text", 
        showTitle: false
    },

    //> @attr tabSet.useIOSTabs (Boolean : false : IR)
    // Setting this to true turns on a different appearance for tabs, similar to iOS tabs from 
    // the "Music" app, where the tab.icon is enlarged and shown as a black and white mask.  
    // This mode does not support a clickable icon - clicking the enlarged icon just switches 
    // tabs.
    // <P>
    // This attribute only has an effect for tabs that are not +link{Tab.canClose,closable},
    // and only for Mobile WebKit.
    // @visibility external 
    //<
    useIOSTabs: false,

    // Adding tabs
    // ----------------------------------------------------------------------------------------

    //> @attr tabSet.canAddTabs (Boolean : null : IR)
    //
    // Causes the +link{addTabButton} to appear after the +link{tabs} and before the
    // +link{tabBarControls}.  
    // <p>
    // There is no default behavior for what happens when the <code>addTabButton</code> is
    // clicked.  Add a handler for the +link{addTabClicked()} event to implement a behavior.
    //
    // @visibility external 
    //<
    
    //> @attr tabSet.addTabButton (AutoChild ImgButton : null : IR)
    // Appears when +link{canAddTabs} is enabled.
    //
    // @visibility external 
    //<

    //> @attr tabSet.addTabButtonIcon (SCImgURL : "[SKIN]actions/add.png" : IR)
    // Icon for the +link{addTabButton}.
    //
    // @visibility external 
    //<
    addTabButtonIcon: "[SKIN]actions/add.png",
    
    //> @attr tabSet.showTabBar (Boolean : true : IRW)
    // Should the tabBar be displayed or not
    // If shrinkElementOnHide is true, the paneContainer will expand over the space
    // occupied by TabBar
    //
    // @visibility external 
    //<
    showTabBar: true,
    
    setShowTabBar : function(showTabBar) {
        this.showTabBar = showTabBar;
        this.fixLayout();
    }
    
});

// Have an explicit subclass of Button for tabs when useSimpleTabs is true.
// This allows us to include "pane" in the schema - required for Reify.
// It also would allow for simpler skinning customizations.

//> @class SimpleTabButton
// Simple subclass of +link{Button} used for tabs in a +link{TabSet} if +link{tabSet.useSimpleTabs}
// is true. See also +link{tabSet.simpleTabButtonConstructor}.
// @inheritsFrom Button
// @treeLocation Client Reference/Layout/TabSet
// @visibility external
//<
isc.defineClass("SimpleTabButton", "Button");

isc.SimpleTabButton.addProperties({

    // Override the default width of 100 set on button
    
    width:null,
    height:null,

    setIcon : function (icon) {
        var tabset = this.parentElement ? this.parentElement.parentElement : null;
        if (tabset != null && tabset.useIOSTabs && !tabset.canCloseTab(this)) {
            // Make sure the previous icon is replaced
            this.iOSIcon = null;
        }
        this.Super("setIcon", arguments);
    },

    getTitle : function () {
        var tabset = this.parentElement ? this.parentElement.parentElement : null;
        if (tabset != null && tabset.useIOSTabs && !tabset.canCloseTab(this)) {
            if (!this.iOSIcon && this.icon) {
                this.iOSIcon = this.icon;
                this.icon = null;
            }

            var imgHTML;
            if (this.iOSIcon == null) {
                imgHTML = "<a style='height:30px'>&nbsp;</a>";
            } else {
                var imgObj = {
                    src: isc.Canvas._blankImgURL,
                    width: 30,
                    height: 30,
                    extraCSSText: "-webkit-mask-box-image:url(" + this.getImgURL(this.iOSIcon) + ");background-color:#000;"
                };
                imgHTML = isc.Canvas.imgHTML(imgObj);
            }
            return imgHTML + "<span>" + this.title + "</span>";
        }
        return this.Super("getTitle", arguments);
    },
	
	setCanClose : function(canClose) {
        var tabset = this.parentElement ? this.parentElement.parentElement : null;
		if (tabset && isc.isA.TabSet(tabset)) {
			tabset.setCanCloseTab(this, canClose);
		} else {
			// We have an orphaned tab that is not part of a tabset.  Not sure how much use 
			// such a thing would be, but set its canClose attribute for completeness
			this.canClose = canClose;
		}
	}

    //>EditMode 
    // needed so that we can autodiscover this method to update the pane.
    , setPane : function (pane) {
        this.parentElement.parentElement.updateTab(this, pane);
    }, 
    // needed to allow a zero-parameter action for selecting a tab
    selectTab : function () {
        this.parentElement.parentElement.selectTab(this);
    }
    //<EditMode

});

isc.TabSet.addMethods({

//> @attr tabSet.simpleTabButtonConstructor (Class : SimpleTabButton : IRA)
// Tab button constructor if +link{tabSet.useSimpleTabs} is true.
// @visibility external
//<
simpleTabButtonConstructor: isc.SimpleTabButton,

//>	@method	tabSet.initWidget()	(A)
// Initialize the TabSet object 
//<
initWidget : function () {

    // if showTabScroller is unset, default it to false for handsets and true otherwise
    if (this.showTabScroller == null) this.showTabScroller = !isc.Browser.isHandset;
    
    // disallow 'showEdges:true' on tabSets - this is an effect the user essentially never wants
    // as edges would encompass the tab-bar as well as the (rectangular) pane container.
    
    this.showEdges = false;

	// call the superclass function
	this.Super("initWidget",arguments);

    if (!isc.Browser._supportsIOSTabs && this.useIOSTabs) {
        this.logWarn("useIOSTabs was enabled on this TabSet, but iOS tabs are not supported in the current browser. Setting useIOSTabs to false.");
        this.useIOSTabs = false;
    }

    if (this.tabs == null) this.tabs = [];

    if (this.tabBarDefaults == null) this.tabBarDefaults = {};
    // NOTE: tabInstanceDefaults is old name
    this.tabProperties = this.tabProperties || this.tabInstanceDefaults || {};
    // Set up some dynamic defaults to apply to all tabs (without modifying the
    // tabProperties object directly, which is shared across all TabSets!)
    this.dynamicTabProperties = {};
    
    var pos = this.tabBarPosition;
	var  vTabs = (pos == "left") || (pos == "right");

    // if tabBarAlign is unset, set default based on tabBarPosition 
    if (this.tabBarAlign == null) {
        this.tabBarAlign = (vTabs ? "top"
                            : (this.isRTL() ? "right" : "left"));
    }
    
    // If this has the 'useSimpleTabs' property set to true, create buttons rather than imgTabs
    // as tabs in the tab bar.  Saves on creating a number of widgets for performance.
    
    if (this.useSimpleTabs) {
        // also update the styling
        this.tabBarDefaults.buttonConstructor = this.simpleTabButtonConstructor;

        var props = this.dynamicTabProperties,
            iconOnly = this.simpleTabIconOnlyBaseStyle,
            capPos = pos.substring(0,1).toUpperCase() + pos.substring(1)
        ;

        // eg base + "Right" (derived from "right")
        props.baseStyle = this.simpleTabBaseStyle + capPos;
        if (iconOnly) props.iconOnlyBaseStyle = iconOnly + capPos;

        props.ariaRole = "tab";
    }    

	// defaultTabWidth / Height only apply on the "length" axis of tabs
	// since the thickness is determined by the tab-bar width.
    if (this.defaultTabWidth && !vTabs) {
        this.dynamicTabProperties.width = this.defaultTabWidth;
    }
    if (this.defaultTabHeight && vTabs) {
        this.dynamicTabProperties.height = this.defaultTabHeight;
    }

    if (this.defaultTabIconSize) {
        this.dynamicTabProperties.iconSize = this.defaultTabIconSize;
    }
    
    // Per the documentation, on touch devices, the default tabBarControls omits the "tabScroller"
    // because the tabs are native touch-scrollable. If the tabBarControls array instance is
    // unchanged, then the app is using the default controls.
    if (this._browserSupportsNativeTouchScrolling &&
        this.tabBarControls === isc.TabSet.getInstanceProperty("tabBarControls"))
    {
        this.tabBarControls = ["tabPicker"];
    }

	this.makeTabBar();

    this.createAddTabButton();
    
	this.makePaneContainer();

    this.createPanes();
    
},


tabBarConstructor:isc.TabBar,

//> @attr tabSet.tabBarProperties (TabBar Properties : null : IR)
// This attribute allows developers to specify custom properties for this tabset's
// +link{tabset.tabBar}
//
// @visibility external
//<

//>	@method	tabSet.makeTabBar()	(A)
//	Instantiates a tabBar for this tabSet, and then adds it as a child of
//	the tabSet. starts with tabBarDefaults and adds additional, tabSet-specific properties
// @visibility internal
//<
makeTabBar : function () {
	if (this.tabs == null) return;

    
    var barPos = this.tabBarPosition,
        tabBarIsVertical = (barPos == isc.Canvas.LEFT || barPos == isc.Canvas.RIGHT)
    ;

    
    var tabs = this.tabs.duplicate(),
        undef;
    var tabProperties = isc.addProperties({}, this.tabProperties, this.dynamicTabProperties);
    for (var i = 0; i < tabs.length; i++) {
        for (var j in tabProperties) {
            if (tabs[i][j] === undef) tabs[i][j] = tabProperties[j];
        }
        if (tabs[i].autoID && !tabs[i].name) tabs[i].name = tabs[i].autoID;
    }    

	// assemble tabBar properties
	var tabBarProperties = isc.addProperties({
        // selectTabOnContextClick: we suppress this behavior by default - this is an undocumented
        // flag to allow selection of tabs on context click 
        
        selectTabOnContextClick:this.selectTabOnContextClick,

        ID:this.getID() + "_tabBar",

        // see "fixLayout" method for where this gets updated dynamically at runtime.
        width: (tabBarIsVertical ? this.tabBarThickness : "100%"),
        height: (tabBarIsVertical ? "100%" : this.tabBarThickness),

        // Default the tab bar to having the same accessKey as the tabSet
        accessKey: this.accessKey,

        // If the user has specified a tabIndex for the tabSet, apply it to the tabBar as well
        tabIndex: this.tabIndex,

        // Passes in the user-specified tabs array. 
        // This is a simple way for the developer to specify title / size / etc. for each tab
        // Note - we copy the tabs array rather than pointing at the same array.
        // the tabSet should manage the tabs and call the appropriate actions on the tabBar.
        tabs:tabs,
        
        // Passes in the user-specified value for canAddTabs
        canAddTabs: this.canAddTabs,

        align:this.tabBarAlign,
				 
        // tabBar is set vertical or not depending on the value of tabBarPosition.
        vertical: tabBarIsVertical ? true : false,
				 
        // the initially selectedTab is passed in.
        selectedTab:this.selectedTab,

        // More tab settings
        showMoreTab:this.showMoreTab,
        moreTabCount:this.moreTabCount,
        moreTab:this.createMoreTab(),
        // When showing a "more" button, allow buttons to be re-selected.
        allowButtonReselect: this.showMoreTab ? true : false,


        // Override buttonSelected() to fire _tabSelected() on this widget
        // Note: this method is only fired on actual selection change - repeated clicks on
        // the buttons should not fire these methods.
        // _tabSelected will handle firing the public tabSelected/tabDeselected handlers
        // as well as hiding/showing panes.
        // Note that standard TabBar buttonSelected/deselected already handles moving deselected
        // tab behind the baseline image, etc.
		buttonSelected : function (button) {
            
            this.Super("buttonSelected", arguments);
            
            //call _tabSelected() on this tabSet to trigger any selection actions
            if (this.parentElement != null) {
                this.parentElement._tabSelected(button);
            }
        },
        
        // notify the tabset if a tab resizes
        childResized : function (child, deltaX, deltaY, reason) {
            this.Super("childResized", arguments);
            // Don't run 'tabResized' if we're in mid layout.
            
            if (reason == "Overflow on initial draw") {
            
                return;
            }

            if (this.parentElement != null) {
                this.parentElement._tabResized();
            }
        },
        
        // Override showContextMenu -- if this event was bubbled up  a right click on one of our tabs,
        // fire the special showTabContextMenu method
        showContextMenu : function () {
            var target = isc.EH.getTarget();
            if (this.getButtons().contains(target)) {
                var tabSet = this.parentElement,
                    tabObj = tabSet.getTabObject(target);
                if (tabSet.showTabContextMenu(tabSet, tabObj) == false) return false;
            }
            return this.Super("showContextMenu", arguments);
        
        },

        // If drag reordering of tabs is enabled configure the tabbar and
        // trap the notification so we handle the actual reordering
        canReorderItems: this.canReorderTabs,
        reorderOnDrop : !this.canReorderTabs,
        itemDragReordered : function (startPosition, currentPosition) {
            if (this.parentElement != null) {
                this.parentElement.reorderTab(startPosition, currentPosition);
            }
        },

		// other properties
		tabBarPosition:this.tabBarPosition,
        tabBarAlign:this.tabBarAlign,
		autoDraw:false

	}, this.tabBarDefaults, this.tabBarProperties);

    if (this._browserSupportsNativeTouchScrolling) {
        tabBarProperties.overflow = "auto";
        tabBarProperties.overflowStyle = "none";
    }

	// create tabBar and add as child.  NOTE: make available as this.tabBar as well since it's
    // declared as an autoChild.  For the same reason, add a "creator" property
    tabBarProperties.creator = this;
    
    // tabBar is not a real autoChild, so setting showTabBar to false needs special handling -
    // this is used by Calendars to hide the tabset on mobile devices
    if (this.showTabBar == false) tabBarProperties.visibility = "hidden";
    var tb = this.tabBar = this._tabBar = isc.ClassFactory.newInstance(this.tabBarConstructor, tabBarProperties);
    this.addChild(tb);


    // TabBar baseline: If we create a controlLayout, we're truncating the tabBar in order to
    // draw the controlLayout after it.
    // The controlLayout is as thick as the tabs, excluding the baseLine (this is appropriate -
    // we want control buttons to appear above the baseLine). However since the baseLine
    // is written into the tabBar rather than being a direct child of the tabSet, it will be
    // truncated along with the tabs, so the space under the control layout will be empty (the
    // baseLine will not extend underneath the controls).
    // Therefore if we are showing the controlLayout, create a new baseLine image to
    // sit below it so the baseLine extends beyond the (truncated) tabs in the tab-bar.
    // Note that we're not destroying the existing tab-bar baseline
    // (set up via tabBar.makeBaseline) - we're essentially duplicating it with some different
    // defaults and adding it to a different position in the DOM.
    
    
    var tbThickness = (this.tabBarThickness - tb.baseLineThickness),
        snapTo,
        snapOffsetLeft = 0,
        snapOffsetTop = 0,
        baseLineWidth,
        baseLineHeight;
    if (barPos === isc.Canvas.TOP) {
        snapTo = "T";
        baseLineWidth = "100%";
        baseLineHeight = tb.baseLineThickness;
        snapOffsetTop = tbThickness;
    } else if (barPos === isc.Canvas.RIGHT) {
        snapTo = "R";
        baseLineWidth = tb.baseLineThickness;
        baseLineHeight = "100%";
        snapOffsetLeft = -tbThickness;
    } else if (barPos === isc.Canvas.BOTTOM) {
        snapTo = "B";
        baseLineWidth = "100%";
        baseLineHeight = tb.baseLineThickness;
        snapOffsetTop = -tbThickness;
    } else {
        
        snapTo = "L";
        baseLineWidth = tb.baseLineThickness;
        baseLineHeight = "100%";
        snapOffsetLeft = tbThickness;
    }
    this._tabBarBaseLine = tb.createAutoChild("baseLine", {
        width: baseLineWidth,
        height: baseLineHeight,
        vertical: (barPos === isc.Canvas.LEFT || barPos === isc.Canvas.RIGHT),
        skinImgDir:tb.skinImgDir,
        src:tb.baseLineSrc,
        capSize:tb.baseLineCapSize,
        imageType:isc.Img.STRETCH,
        overflow:"hidden", // since the baseline can be a Canvas if it doesn't need to display images
        snapTo: snapTo,
        snapOffsetLeft: snapOffsetLeft,
        snapOffsetTop: snapOffsetTop
    }, isc.StretchImg);
    this.addChild(this._tabBarBaseLine);

    // Always position the tabBarBaseLine behind the tabBar so we only see the edge that protrudes
    // past the end of the tabs.
    this._tabBarBaseLine.moveBelow(tb);
},

// Documented under registerStringMethods
showTabContextMenu:function () {},

createMoreTab : function () {
    if (!this.showMoreTab) return null;

    // Hold onto pane independently of the tab because the pane will change
    // to show tab panes of the selected "more" tab.
    this.moreTabPane = this.createAutoChild("moreTabPane", this.moreTabPaneProperties);
    this.addAutoChild("moreTabPaneNavBar", {title: this.moreTabTitle});
    this.moreTabPaneTable = this.addAutoChild("moreTabPaneTable");
    
    var moreTab = isc.addProperties({

        title: this.moreTabTitle,
        icon: this.moreTabImage,
        pane: this.moreTabPane,
        // Mark more tab so it can be recognized in the tabbar
        moreTab: true
    }, this.moreTabDefaults, this.moreTabProperties);

    
    var undef;
    var tabProperties = isc.addProperties({}, this.tabProperties, this.dynamicTabProperties);

    for (var j in tabProperties) {
        if (moreTab[j] === undef) moreTab[j] = tabProperties[j];
    }
    this.moreTab = moreTab;
    
    return moreTab;
},

createAddTabButton : function () {
    if (!this.canAddTabs) return null;

    this.addTabButtonContainer = isc.Canvas.create({layoutAlign:"center", width:16, height:16});
    
    this.addAutoChild("addTabButton", {
        _constructor: isc.ImgButton,
        autoParent: this.addTabButtonContainer,
        src: this.addTabButtonIcon, // default icon
        width: 16, height: 16,
        showRollOver: false,
        showDown: false,
        action: this.addTabClicked  // default event handler
    });
    
    this.tabBar.addButtons(this.addTabButtonContainer);
},

updateMoreTab : function () {

    var moreTab = this.tabBar && this.tabBar.moreTab;
    if (moreTab) {
        var moreTabSelected = this.getSelectedTab() == moreTab;
        this.tabBar.updateMoreTab();
        // If the moreTab was selected and we hid it, select a different tab
        if (moreTabSelected) {
            var moreTabButton = this.tabBar.getButton(moreTab);
            if (!moreTabButton.isVisible()) {
                this.selectedTabHidden(moreTab, moreTabButton);
            }
        }
        this.rebuildMorePane();
    }
},

rebuildMorePane : function () {
    this.moreTabPane.setData(this.getMorePaneRecords());
},

getMorePaneRecords : function () {
    var tabSet = this,
        records = []
    ;
    for (var i = 0; i < this.tabs.length; i++) {
        var tabButton = this.getTab(this.tabs[i]),
            tabObject = this.getTabObject(tabButton);
        if (tabObject.hidden) continue; // ignore explicitly hidden tabs altogether
        if (tabButton.isVisible()) continue; // skip already visible tabs
        
        var icon = (tabObject.icon != null ? isc.Page.getImgURL(tabObject.icon) : null);
        records[records.length] = {
            icon: icon,
            title: tabObject.title,
            pane: tabObject.pane,
            button: tabButton
        };
    }    
    return records;
},

// override setAccessKey and setTabIndex to manage the accessKey / tabIndex of the 
// tab-bar

setTabIndex : function (index) {
    this.Super("setTabIndex", arguments)

    if (this._tabBar != null) this._tabBar.setTabIndex(index);
},

// setAccessKey()
// apply the accessKey to the tabBar, which will in turn apply it to the focus-tab.
setAccessKey : function (accessKey) {
    this.Super("setAccessKey", arguments);
    if (this._tabBar != null) this._tabBar.setAccessKey(accessKey);
},


//>	@method	tabSet.createPanes()
//      converts any tab.pane object literals to canvii
// @visibility internal
//<
createPanes : function () {
    for (var i = 0; i < this.tabs.length; i++) {
	    var tab = this.tabs[i],
			pane = tab.pane
		;
		if (pane == null) continue;
        
        tab.pane = this.createPane(pane, tab);
        
    }
},

//> @attr tabSet.disablePaneWithTab (boolean : true : IRW)
// If true when a tab is enabled or disabled it's pane will also be enabled / disabled.
// @visibility internal
//<

disablePaneWithTab:true,

//>	@method	tabSet.createPane()
//      (Internal method)
//      Given a pane object, create a canvas from it, and prepare it to be made a pane of this
//      object.
//      Creates canvas from properties object.
//      Ensures canvas is deparented / hidden.
//      Returns canvas.
//  @param  pane (Object | Canvas) object literal / canvas to be made into a pane
// @param tab (Object | ImgTab) tab to which the pane is being applied
// @visibility internal
//<
createPane : function (pane, tab) {
    if (pane == null) return pane;

    // handle string name, autoChild, props object
    if (!isc.isA.Canvas(pane)) pane = this.createCanvas(pane);

    if (pane == null) return pane;

    // make sure the pane is hidden before we add it to the pane container - otherwise it will
    // draw before the tab is actually selected
    pane.hide();

    // If the tab is disabled, disable the pane (if appropriate)
    if (this.disablePaneWithTab && tab && tab.disabled) {
        pane.setDisabled(tab.disabled);
    }

    this.paneContainer.ignoreMember(pane);
    
    pane.moveTo(this.isRTL() ? 9999 : -9999, -9999);

    // add the pane as a member to the paneContainer right away.
    
    
    this.paneContainer.addMember(pane);
    isc.Canvas.setCanvasPanelContainer(pane, this);
    return pane;
},

makePaneContainer : function () {

    var props = {   
            ID: this.getID() + "_paneContainer",
            _generated: false,
            styleName:this.paneContainerClassName,
            layoutMargin:(this.paneMargin || 0),
            overflow:this.paneContainerOverflow,

            _createEdgedCanvas : function () {
                var edgedCanvas = this.Super("_createEdgedCanvas", arguments);
                edgedCanvas.addMethods({
                    _asymmetricEdgePrefixes:{top:"_top",left:"_left",bottom:"_bottom",right:"_right"},
                    getEdgePrefix : function (edgeName) {
                        var pc = this.eventProxy,
                            tabSet = pc ? pc.creator : null;
                        if (tabSet && !tabSet.symmetricEdges) {
                            return this._asymmetricEdgePrefixes[tabSet.tabBarPosition];
                        }
                    }
                });
                return edgedCanvas;
            }
        };
    // NOTE: these dynamic defaults will override any static defaults defined in
    // this.paneContainerDefaults, (but may be overridden by attributes in
    // this.paneContainerProperties)
    // For back-compat, if showPaneContainerEdges / getPaneContainerCustomEdges() don't have
    // an explicit value, don't apply them to this object so we continue to pick up
    // showEdges/customEdges from the paneContainerDefaults block  
    if (this.showPaneContainerEdges != null) props.showEdges = this.showPaneContainerEdges;        
    if (this.getPaneContainerEdges && this.getPaneContainerEdges() != null) {
        props.customEdges = this.getPaneContainerEdges();
    }
    // asymmetricEdges needs support for asymmetric edge sizes and offsets

    if (!this.symmetricEdges) {
        var sizes = this[this._asymmetricEdgeSizePropertyMap[this.tabBarPosition]];
        if (sizes && sizes.defaultSize != null) props.edgeSize = sizes.defaultSize;
        if (sizes && sizes.bottom != null) props.edgeBottom = sizes.bottom;
        if (sizes && sizes.top != null) props.edgeTop = sizes.top;
        if (sizes && sizes.left != null) props.edgeLeft = sizes.left;
        if (sizes && sizes.right != null) props.edgeRight = sizes.right;

        var offsets = this[this._asymmetricEdgeOffsetPropertyMap[this.tabBarPosition]];
        if (offsets && offsets.defaultSize != null) props.edgeOffset = offsets.defaultSize;
        if (offsets && offsets.bottom != null) props.edgeOffsetBottom = offsets.bottom;
        if (offsets && offsets.top != null) props.edgeOffsetTop = offsets.top;
        if (offsets && offsets.left != null) props.edgeOffsetLeft = offsets.left;
        if (offsets && offsets.right != null) props.edgeOffsetRight = offsets.right;
    }

    this.addAutoChild("paneContainer", props);
},

// For efficiency avoid assembling asymmetric edge size / offset property names on the fly
_asymmetricEdgeSizePropertyMap : {
    top:"topEdgeSizes", bottom:"bottomEdgeSizes", left:"leftEdgeSizes", right:"rightEdgeSizes"
},
_asymmetricEdgeOffsetPropertyMap : {
    top:"topEdgeOffsets", bottom:"bottomEdgeOffsets", left:"leftEdgeOffsets",
    right:"rightEdgeOffsets"
},

//> @attr tabSet.showPartialEdges (Boolean : false : [IRA])
// If the paneContainer for this tab set is showing +link{Canvas.showEdges,edges}, setting this
// attribute to <code>true</code> will set the paneContainer to show
// +link{canvas.customEdges,customEdges} for the three sides opposing the tabBarPosition.
// @visibility external
//<
 
//>	@method tabSet.getPaneContainerEdges() [A]
// If the paneContainer for this tab set is showing +link{Canvas.showEdges,edges}, this 
// method can be used to specify (dynamically) which +link{canvas.customEdges,customEdges} to
// show. Called when the pane creator is created.
// <P>
// Default implementation will return null unless +link{tabSet.showPartialEdges,showPartialEdges}
// is true, in which case it will return the three edges opposite the
// +link{tabSet.tabBarPosition,tabBarPosition}.
// @return (Array) array of custom edges to show
// @visibility external
//<
getPaneContainerEdges : function () {
    if (this.showPartialEdges) {
                if (this.tabBarPosition == "bottom") return ["T","L","R"];
                else if (this.tabBarPosition == "left") return ["T","B","R"];
                else if (this.tabBarPosition == "right") return ["T","B","L"];
                else return ["B","L","R"];
    }
    return null;
},

// override draw to make sure we have a tab selected, and to fire 'tabSelected()' on the tab
draw : function (a,b,c,d) {
    if (this.tabs && this.tabs.length > 0) {    
        var selectedTab = this.getSelectedTabNumber();
        // Don't allow a bad selectedTab value to persist.
        if (!isc.isA.Number(selectedTab) || selectedTab < 0) selectedTab = this.selectedTab = 0;
        // Ensure it's selected in the tab-bar - will no op if already selected, otherwise
        // will perform selection and fire our handlers
        this._tabBar.selectTab(selectedTab);
    }
    this.invokeSuper(isc.TabSet, "draw", a,b,c,d);
    this._createTabWhenRules(this.tabs);
    this.fixLayout();
},


_getRuleNamePrefix : function (target) {
    var prefix = this.Super("_getRuleNamePrefix", arguments);
    if (target.tab != null) {
        prefix += "_tab" + target.tab;
    }
    return prefix;
},

_createTabWhenRules : function (tabs) {

    var component = this.getRuleScopeComponent();
    if (!component) return null;

    var rules = [],
        targetTabs = [];
    if (!isc.isAn.Array(tabs)) tabs = [tabs];
    for (var i = 0; i < tabs.length; i++) {
        var tab = tabs[i];
        if (tab._createdWhenRule) {
            continue;
        }
        if (tab.visibleWhen || tab.enableWhen) {
            // Give the tab an explicit name if it doesn't have one - this allows us
            // to track it as its index changes
            if (tab.name == null) {
                this._assignAutoTabName(tab);
            }
            if (tab.visibleWhen) {
                rules.add(
                    this._createWhenRule("visibility", tab.visibleWhen,
                        {targetObjectType:"Tab", tab:tab.name})
                );
            }
            if (tab.enableWhen) {
                rules.add(
                    this._createWhenRule("enable", tab.enableWhen,
                        {targetObjectType:"Tab", tab:tab.name})
                );
            }
            targetTabs.add(tab);
        }
    }
        
    if (rules.length > 0) {
        var rulesEngine = this.getRulesEngine();
        // The rulesEngine may not be accessible yet because the ruleScope
        // is not yet derived.
        if (!rulesEngine) {
            // Note - skipping before setting tab._createdWhenRule on any target tabs
            return;
        }
        if (!rulesEngine.members.contains(this)) {
            rulesEngine.addMember(this);
        }
        for (var i = 0; i < rules.length; i++) {
            rulesEngine.addRule(rules[i]);
        }
        // Set initial state
        rulesEngine.processContextRules(rules, this);
    }
    for (var i = 0; i < targetTabs.length; i++) {
        targetTabs[i]._createdWhenRule = true;
    }
},

// Given a tab object with no specified name, set it's name to an auto-generated string
// so we can identify it by something other than index / passing the object around!
_tabNameCount:0,
_assignAutoTabName : function (tab) {

    if (tab == null || tab.name != null) return;

    var autoTabName =  "_" + this._tabNameCount++;

    // If we have a live tab button, apply the name to it as well to ensure 
    // tab.getButton() can get at it via specified name
    // Note that calling getTab() before updating tab.name ensures downstream code
    // doesn't try to look up the live object by name [which wouldn't be set yet!]
    var tabButton = this.getTab(tab);
    if (tabButton != null) {
        if (tabButton.name != null) {
            
            autoTabName = tabButton.name;
        } else {
            tabButton.name = autoTabName;
        }
    }
    tab.name = autoTabName;
},

_removeTabWhenRules : function(tabs) {

    var component = this.getRuleScopeComponent();
    if (component && component.rulesEngine) {
        if (!isc.isAn.Array(tabs)) tabs = [tabs];

        for (var i = 0, len = tabs.length; i < len; ++i) {
            var tab = tabs[i];
            if (!tab || !tab._createdWhenRule) continue;
            if (tab.enableWhen) this._removeWhenRule("enable", {tab:tab.name});
            if (tab.visibleWhen) this._removeWhenRule("visibility", {tab:tab.name});
            delete tab._createdWhenRule;
        }
    }
},

//> @method tabSet.processVisibilityRule()
// Process a "visibility" type rule for this TabSet.
// <P>
// Overridden to handle showing and hiding tabs if +link{rule.targetObjectType} is
// set to "Tab". This allows TabSets to support Tab.visibleWhen.
//
// @param result (boolean) the result of evaluating criteria in the ruleScope for this rule
// @param rule (Rule) the rule to process
// @return (boolean) Returns true if the rule changed the visibility of the target object
// @visibility internal
//<
processVisibilityRule : function (result, rule) {
    result = !!result;
    if (rule.targetObjectType == "Tab") {
        var wasVisible = this.tabIsVisible(rule.tab);
        if (wasVisible != result) {
            if (result) this.showTab(rule.tab);
            else this.hideTab(rule.tab);
            return true;
        
        // unchanged - nothing to do here
        } else {
            return false;
        }
    }
    // If we didn't handle this with custom logic, invoke Super
    return this.Super("processVisibilityRule", arguments);
},

//> @method tabSet.processEnabledRule()
// Process an "enabled" type rule for this Canvas.
// <P>
// Overridden to handle enabling and disabling menu items if +link{rule.targetObjectType} is
// set to "MenuItem". This allows Menus to support MenuItem.enableWhen.
//
// @param result (boolean) the result of evaluating criteria in the ruleScope for this rule
// @param rule (Rule) the rule to process
// @return (boolean) Returns true if the rule changed the visibility of the target object
// @visibility internal
//<
processEnableRule : function (result, rule) {
    result = !!result; 
    if (rule.targetObjectType == "Tab") {
        var tabObject = this.getTabObject(rule.tab);
        if (tabObject) {
            var wasEnabled = !tabObject.disabled;
            if (wasEnabled != result) {
                if (result) this.enableTab(rule.tab);
                else this.disableTab(rule.tab);
                return true;
            }
                
        } 
        // unchanged - nothing to do here
        return false;
    }
    // If we didn't handle this with custom logic, invoke Super
    return this.Super("processEnableRule", arguments);
},

//>	@method	tabSet.setTabTitle()	(A)
// Changes the title of a tab
// @param	tab      (Tab | number | GlobalId | TabName)
// @param	title    (HTMLString)  new title
// @visibility external
// @example titleChange
//<
setTabTitle : function (tab, title) {
    this.getTabObject(tab).title = title;
    if (this.getTab(tab)) this.getTab(tab).setTitle(title);
    // reset the menu to pick up the new title
    this.resetTabPickerMenu();
},
    
//>	@method	tabSet.setTabPickerTitle()	(A)
// Changes the title of the picker menu item of a tab
// @param	tab      (Tab | number | GlobalId | TabName)
// @param	pickerTitle    (HTMLString)  new title
// @visibility external
//<
setTabPickerTitle : function (tab, pickerTitle) {
    this.setTabProperties(tab, {pickerTitle:pickerTitle});
},

//>	@method	tabSet.setTabIcon() (A)
// Changes the icon for a tab
// @param tab (Tab | number | GlobalId | TabName) tab to update
// @param icon (SCImgURL) new icon
// @visibility external
//<
setTabIcon : function (tab, icon) {
    this.setTabProperties(tab, {icon:icon});
},

//>@method tabSet.enableTab()  
// If the specified tab is disabled, enable it now.
// @param   tab (Tab | number | GlobalId | TabName)
// @see tab.disabled
// @visibility external
//<
enableTab : function (tab) {
    this.setTabDisabled(tab, false);
},

//>@method tabSet.disableTab()  
// If the specified tab is enabled, disable it now.
// @param   tab (Tab | number | GlobalId | TabName)
// @see tab.disabled
// @visibility external
//<
disableTab : function (tab) {
    this.setTabDisabled(tab, true);
},

//>@method tabSet.setTabProperties() (A)
// Apply properties to an existing tab in a tabSet.
// @param tab (Tab | number | GlobalId | TabName) Identifier for the tab to be modified
// @param properties (Object) Javascript object containing the set of properties to be applied
//  to the tab.
// @visibility external
//<
setTabProperties : function (tab, properties) {
    if (!properties) return;
    
    if (properties.ID != null) {
        this.logWarn("setTabProperties(): Unable to modify ID for an existing tab - ignoring " +
                    "this property");
        delete properties.ID;
    }
    
    // A couple of properties require special APIs
    if (properties.pane != null) {
        this.updateTab(tab, properties.pane);
        delete properties.pane;
    }
    if (properties.disabled != null) {
        this.setTabDisabled(tab, properties.disabled);
        delete properties.disabled;
    }
    
    var tabObject = this.getTabObject(tab),
        tab = this.getTab(tab);
    if (!tabObject) return;
    isc.addProperties(tabObject, properties);
    
    if (tab) {
        tab.setProperties(properties);
    }
    
    // If we have a pickerMenu, destroy it so it gets rebuilt when next required
    // Ensures we pick up title / icon etc changes
    this.resetTabPickerMenu();
},

// Actually set the disabled property on a tab. Handled by just disabling the button.
setTabDisabled : function (tab, disabled) {
    var tabObject = this.getTabObject(tab);
    if (tabObject) {
        tabObject.disabled = disabled;
    } else {
        // If the given tab cannot be found in the TabSet, just log and return
        this.logWarn("disableTab() ignored, no such tab '" + (tab.ID?tab.ID:tab) + "'");
        return;
    }
    
    var tab = this.getTab(tab);
    if (tab) {
        // disable the tab so you can't access it.
        tab.setDisabled(disabled);
        // Also disable the pane in case it's showing.
        // Alternative approach would be to deselect the tab, if selected. The problem with 
        // this is we may only have one tab in the tabSet.
        var pane = tab.pane;
        if (pane && this.disablePaneWithTab) {
            if (isc.isA.Canvas(pane)) pane.setDisabled(disabled);
            else pane.disabled = disabled;
        }
    }
    // rebuild the picker menu so the item in question shows up disabled
    this.resetTabPickerMenu();
},

//>	@method	tabSet.addTab()	(A)
// Add a tab
// @param	tab      (Tab)   new tab
// @param	[position] (number)  position where tab should be added
// @see TabSet.addTabs
// @visibility external
// @example tabsAddAndRemove
//<
addTab : function (tab, position) {
    //>EditMode
    // In editMode when loading a screen, each tab is added separately but tab selection 
    // events shouldn't be triggered for these
    if (this.editProxy && this.editingOn && isc._loadingNodeTree) {
        this._suppressTabSelectedHandlers = true;
    } 
    //<EditMode
    var result = this.addTabs(tab, position);
    //>EditMode
    if (this.editProxy && this.editingOn && isc._loadingNodeTree) {
        delete this._suppressTabSelectedHandlers;
    } 
    //<EditMode
    return result;
},

//>	@method	tabSet.addTabs()	(A)
// Add one or more tabs
// @param	tabs      (Tab | Array of Tab)   new tab or tabs
// @param	position (number)  position where tab should be added (or array of positions)
// @see TabSet.addTab
// @visibility external
//<
addTabs : function (newTabs, position) {
    if (!isc.isAn.Array(newTabs)) newTabs = [newTabs];
    var oldSelectedTab = this.getTabObject(this.getSelectedTabNumber()),
        forceSelection = (this.getSelectedTabNumber() == -1);
    
    if (position == null || position > this.tabs.length) position = this.tabs.length;
    for (var i = 0; i < newTabs.length; i++) {
        // use 'createPane' to turn the pane into a hidden, deparented canvas.
        newTabs[i].pane = this.createPane(newTabs[i].pane, newTabs[i]);
        
        // apply tabProperties (see comment in makeTabBar)
        var undef;
        var tabProperties = isc.addProperties({}, this.tabProperties, this.dynamicTabProperties);
        for (var propName in tabProperties) {
            if (newTabs[i][propName] === undef) {
                newTabs[i][propName] = tabProperties[propName];
            }
            if (newTabs[i].autoID && !newTabs[i].name) newTabs[i].name = newTabs[i].autoID;
        }
        
        // Actually add the tab to the config
        this.tabs.addAt(newTabs[i], (position + i))
    }
    this._tabBar.addTabs(newTabs, position);
    
    // If we have a pickerMenu, destroy it so it gets rebuilt when next required
    this.resetTabPickerMenu();
    
    // call fixLayout on a delay
    // Necessary in case the new tabs introduced clipping of the tab-bar
    // Delay required as layout reflow is asynch
    this.delayCall("fixLayout");
    
    if (forceSelection) {
        // If we didn't have a selected tab at the start of this method, ensure we select the
        // first of the new tabs
        this.selectTab(0);
    } else {
        // otherwise, update this.selectedTab (an index) in case tabs were added before the old
        // selected tab
        this.selectedTab = this.getTabNumber(oldSelectedTab);
    }
    
    //>EditMode
    if (this.editProxy) this.editProxy.addTabsEditModeExtras(newTabs);
    //<EditMode

    // Set up when rules on the fly
    if (this.isDrawn()) {
        this._createTabWhenRules(newTabs);
    }
    
    
    return position;
},

//> @method tabSet.tabIsVisible()
// Is the tab +link{tab.hidden,hidden or visible}?
// 
// @param tab (Number | String | Tab) Tab to test
// @return (boolean) returns true if the tab has not been hidden.
// @visibility external
//<
tabIsVisible : function (tab) {
    var tabObject = this.getTabObject(tab);
    return tabObject && !tabObject.hidden;
},

//> @method tabSet.hideTab()
// Hide a tab in this tabset at runtime. If the tab is selected, it will be deselected
// and the tab button will be hidden from the user.
// <P>
// Note that this does not remove a tab from the tabset entirely (see +link{tabSet.removeTab()})
// The tab will no longer be visible to the user or selectable by the user, but the configuration
// will still existing in the +link{tabset.tabs,tabs array} for this tabSet. Developers should
// particularly be aware of this when calling methods that refer to tabs by index - the
// index includes both hidden and visible tabs in the tabset.
// <P>
// Tabs may be marked as hidden at init-time via +link{tab.hidden}.
// <P>
// To test whether a tab is currently visible, use +link{tabSet.tabIsVisible()}
//
// @param tab (Number | String | Tab) Tab to hide
// @visibility external
//<
hideTab : function (tab) {
    
    var tabObject = this.getTabObject(tab),
        tabButton = this.getTab(tab);
    
    if (!tabObject || tabObject.hidden) return;
    tabObject.hidden = true;
    if (tabButton) {

        // If selected, we want to deselect
        var isSelected = (tabObject == this.getSelectedTab());


        // hide the button
        tabButton.hide();

        if (isSelected) this.selectedTabHidden(tabObject,tabButton);
    }
    // We may now no longer need a 'more' tab
    if (this.showMoreTab) {
        this.updateMoreTab();
    }
    this.resetTabPickerMenu();
    // call fixLayout on a delay in case we need to show / hide the scroller
    this.delayCall("fixLayout");

},

selectedTabHidden : function (tabObject, tabButton) {
    var mustHidePane = true;
    for (var i = 0; i < this.tabs.length; i++) {
        if (this.tabs[i].hidden) {
            continue;
        } else {
            mustHidePane = false;
            this.selectTab(this.tabs[i]);
            break;
        }
    }
    if (mustHidePane && tabButton.pane) {
        this.hidePane(tabButton.pane);
    }
},

//> @method tabSet.showTab()
// Show a +link{tab.hidden,hidden tab} at runtime.
// <P>
// To test whether a tab is currently visible, use +link{tabSet.tabIsVisible()}
//
// @param tab (Number | String | Tab) Tab to hide
// @visibility external
//<
showTab : function (tab) {

    var tabObject = this.getTabObject(tab),
        tabButton = this.getTab(tab);

    if (!tabObject || !tabObject.hidden) return;
    delete tabObject.hidden;
    // If we're showing the 'more' tab, update it.
    // This will set the visibility of all buttons, including this one to the appropriate state
    if (this.showMoreTab) {
        this.updateMoreTab();
    // Otherwise, just show the tab button.
    } else if (tabButton && !tabButton.isVisible()) {
        tabButton.show();
    }
    this.resetTabPickerMenu();
    
    // call fixLayout on a delay in case we need to show / hide the scroller
    this.delayCall("fixLayout");
            
},


//> @method tabSet.setTabPane()
// Apply a new +link{tab.pane,pane} to an existing tab in this tabSet
// @param tab (number | String | Tab) Tab to update (may be referenced by ID or index)
// @param pane (Canvas) new Pane for the tab
// @visibility external
//<
setTabPane : function (tab, pane) {
    return this.updateTab(tab,pane);
},

//> @attr tabSet.destroyPanes (boolean : null : IR)
// Whether +link{canvas.destroy,destroy()} should be called on +link{tab.pane} when it a tab is
// removed via +link{removeTab()}.  
// <P>
// With the default setting of <code>null</code> panes will be automatically destroyed.
// An application might set this to false in order to re-use panes in different tabs or in
// different parts of the application.
//
// @group lifecycle
// @visibility external
//<

//>	@method	tabSet.removeTab()	(A)
// Remove a tab.
// <P>
// The pane associated with the removed tab is automatically destroyed when you
// call this method.  To avoid this, call +link{updateTab()} with <code>null</code> as the new
// pane immediately before removing the tab, or set +link{tabSet.destroyPanes} to false.
// 
// @param	tabs      (Tab | GlobalId | TabName | number | Array of Tab)  list of tabs, tabIDs,
//                                                                        or tab numbers
// @see TabSet.removeTabs
// @visibility external
// @example tabsAddAndRemove
//<
removeTab : function (tab, dontDestroy) {
    return this.removeTabs(tab, dontDestroy);
},

//>	@method	tabSet.removeTabs()	(A)
// Remove one or more tabs.  The pane(s) associated with the removed tab(s) is automatically
// destroyed when you call this method.
//
// @param	tabs      (Tab | GlobalId | TabName | number)   list of tabs, tabIDs, tab names, or
//                                                          tab numbers
// @see TabSet.removeTab
// @visibility external
//<
removeTabs : function (tabs, dontDestroy) {
    if (!isc.isAn.Array(tabs)) tabs = [tabs];
    
    // get the actual tab button object from whatever was passed in.
    // We can pass this to tabBar.removeTabs()
    tabs = this.map("getTab", tabs);
    
    var removedSelected = false,
        selectedTab = this.getSelectedTab(),
        autoSelectTab = 0;
    
    for (var i = 0; i < tabs.length; i++) {
        
        // remove the tab from the config
        var tab = tabs[i],
            index = this.getTabNumber(tab)
        ;
        if (index == -1) continue; // can't find specified tab

        var tabObject = this.tabs[index];
        
        // if we remove the selected tab we want to just select another one near it
        if (tabObject == selectedTab) {
            removedSelected = true;
            // auto-select the next tab to the left if there is one, or the current 
            // index otherwise
            if (index > 0) autoSelectTab = index - 1;
            else if (index < this.tabs.length + 1) autoSelectTab = index;
            
        // otherwise we may need to update our internal 'selectedTab' index value
        // to reflect the new position of the already selected tab
        } else {
            if (index < this.selectedTab) {
                this.selectedTab -= 1;
            }
        }

        this.tabs.removeAt(index);

        if (tabObject) {
            // remove the pane
            var pane = tabObject.pane;
            if (pane != null && pane.parentElement === this.paneContainer) {
                this.paneContainer.removeChild(pane);
                if (!dontDestroy && this.destroyPanes !== false) {
                    pane.destroy();
                }
            }
            if (tabObject == this._selectedTabObj) delete this._selectedTabObj;
        }
        // remove the tab button
        this._tabBar.removeTabs(tab);
    }

    // Remove any ...when rules we set up for the tabs we removed
    this._removeTabWhenRules(tabs);
    
    
    // if the selected tab was removed, select the first tab if we have any
    if (removedSelected && this.tabs.length > 0) {
        // if the new selected-tab index is beyond the tab-count, select the last tab
        if (autoSelectTab >= this.tabs.length) autoSelectTab = this.tabs.length - 1;
        this.selectTab(autoSelectTab);
    }
    // If we have a pickerMenu, destroy it so it gets rebuilt when next required
    this.resetTabPickerMenu();

    // call fixLayout on a delay
    // Necessary in case the removed tabs get rid of clipping of the tab-bar
    // Delay required as layout reflow is asynch
    this.delayCall("fixLayout", 0);
    
    //>EditMode
    if (this.editProxy) this.editProxy.removeTabsEditModeExtras();
    //<EditMode

},

//> @method tabSet.removeLastTab()
//  Removes the last tab in the TabSet, excluding the +link{moreTab} if present.
//  @visibility external
//<
removeLastTab : function() {
    var lastTabIndex = this.tabs.length-1;
    this.removeTab(this.tabs[lastTabIndex]);
},

//>	@method	tabSet.reorderTab()
// Move a tab to another location in the tabset.
// @param tab (Tab | GlobalId | TabName | number) tab to move
// @param [moveToPosition] (number) the index to move the tab to - defaults to the end of the
//                                  tabset if not passed
// @visibility external
//<
reorderTab : function (tab, moveToPosition) {
    if (moveToPosition == null || moveToPosition > this.tabs.length) moveToPosition = this.tabs.length;

    var tab = this.getTab(tab);
    if (tab) {
        var index = this.getTabNumber(tab);
        if (index == moveToPosition) return;

        var tabObject = this.getTabObject(tab),
            selectedTab = this.getSelectedTab()
        ;

        // Move the tab button
        this._tabBar.reorderTab(tab, moveToPosition);

        // Resync our matching tab list and selected tab
        this.tabs.removeAt(index);
        this.tabs.addAt(tabObject, moveToPosition);
        if (this.selectedTab == index) {
            this.selectedTab = moveToPosition;
        } else if (index < this.selectedTab && this.selectedTab <= moveToPosition) {
            this.selectedTab--;
        } else if (index > this.selectedTab && this.selectedTab >= moveToPosition) {
            this.selectedTab++;
        }

        // If we have a pickerMenu, destroy it so it gets rebuilt when next required
        this.resetTabPickerMenu();

        // call fixLayout on a delay
        // Necessary in case the new tabs introduced clipping of the tab-bar
        // Delay required as layout reflow is asynch
        this.delayCall("fixLayout");
        
        //>EditMode
        if (this.editProxy) this.editProxy.reorderTabsEditModeExtras(index, moveToPosition);
        //<EditMode

        this.tabsReordered(tab, moveToPosition);
    }
    
},

//> @method tabSet.canCloseTab()
// Returns true if this tab is closeable. Determined by checking +link{tab.canClose} and
// +link{tabSet.canCloseTabs}.
// @param tab (int | GlobalId | TabName | Tab) tab to check
// @return (boolean) true if tab is closeable
//<
canCloseTab : function (tab) {
    tab = this.getTabObject(tab);
    if (tab && tab.canClose != null) return tab.canClose;
    return !!this.canCloseTabs;
},

//> @method tabSet.setCanCloseTab()
// Sets the given tab's +link{tab.canClose,canClose} property to the boolean parameter canClose.
// If canClose is null, this will have the effect of causing the tab to fall back on +link{tabSet.canCloseTabs}.
// @param tab (Tab | GlobalId | TabName | number) tab to change
// @param canClose (boolean) new value for the tab's canClose property, or null to clear it
// @visibility external
//<
setCanCloseTab : function (tab, canClose) {
    tab = this.getTabObject(tab);
    var liveTab = this.getTab(tab);
    tab.canClose = canClose;
    if (liveTab) {
        liveTab.setProperties(this.getTabBar().getCloseIconProperties(tab, this.canCloseTab(tab)));
    }
},

//> @method tabSet.setCanCloseTabs()
// Changes this TabSet's +link{TabSet.canCloseTabs,canCloseTabs} property.
// @param canCloseTabs (boolean) the new value for canCloseTabs.
// @visibility external
//<
setCanCloseTabs : function (canCloseTabs) {
    canCloseTabs = !!canCloseTabs;
    this.canCloseTabs = canCloseTabs;

    var tabs = this.tabs;
    if (!tabs) return;

    // Go through each tab, updating the tab buttons whose corresponding tab object has an
    // unspecified or null canClose property.
    var tb = this.getTabBar();
    for (var i = 0, len = tabs.length; i < len; ++i) {
        var tab = tabs[i];
        if (tab.canClose != null) continue;

        var liveTab = this.getTab(tab);
        if (liveTab) {
            liveTab.setProperties(tb.getCloseIconProperties(tab, canCloseTabs));
        }
    }
},

setCanReorderTabs : function (canReorderTabs) {
    this.canReorderTabs = canReorderTabs;
    this.tabBar.canReorderItems = canReorderTabs;
    this.tabBar.reorderOnDrop = !canReorderTabs;
},

_tabIconClick : function(tab) { 
    var shouldClose = this.canCloseTab(tab);
    if (shouldClose) {
        this.closeClick(tab);
        return false;
    } else return this.tabIconClick(tab); 
    
},


// UI Summary for AI
// ---------------------------------------------------------------------------------------

_uiSummaryProperties: isc.TabSet._addToSuperClassSummaryProps([
    "canCloseTabs", "canEditTabTitles", "canReorderTabs"
]),
getUISummary : function (settings, hierarchyExcluded, thisCanvasExcluded) {
    var summary = this.Super("getUISummary", arguments);

    // add summary for the visible tabs
    var tabs = this.tabs;
    if (tabs) {
        var tabsSummary = [];
        for (var i = 0; i < tabs.length; i++) {
            var tab = tabs[i];
            if (this.tabIsVisible(tab)) {
                var tabSummary = this._getTabUISummary(tab, settings, hierarchyExcluded);
                // remove pane canvii from the listed children canvii
                if (summary.children && tabSummary.pane) {
                    summary.children.removeWhere("id", tabSummary.pane.id);
                }
                tabsSummary.add(tabSummary);
            }
        }
        summary.tabs = tabsSummary;
    }

    if (summary.children && !summary.children.length) {
        delete summary.children;
    }

    return summary;
},

_uiSummaryTabProperties: [
    "name", "title", "canClose", "canEditTitle", "canReorder", "disabled"
],
_getTabUISummary : function (tab, settings, paneExcluded) {
    var summary = {};

    var undefined, summaryProps = this._uiSummaryTabProperties;
    for (var i = 0; i < summaryProps.length; i++) {
        var prop = summaryProps[i];
        if (tab.hasOwnProperty(prop) && tab[prop] !== undefined) {
            summary[prop] = tab[prop];
        }
    }

    var pane = tab.pane;
    if (isc.isA.Canvas(pane)) {
        summary.pane = pane.getUISummary(settings, paneExcluded);
    }

    return summary;
},


//> @method tabSet.closeClick()
// When +link{canCloseTabs} is set, method fired when the user clicks the "close" icon for a
// tab.
// <P>
// Default implementation will remove the tab from the tabSet via +link{removeTab()}.
//
// @param tab (Tab) tab to close
// @visibility external
//<
closeClick : function (tab) {
    // if "onCloseClick" exists, allow it to cancel the default behavior
    
    if (this.onCloseClick && (this.onCloseClick(tab) == false)) {
        return;
    }
    this.removeTab(tab);
},

//> @method tabSet.tabIconClick()
// Method fired when the user clicks the icon for a tab, as specified via +link{tab.icon}.
// <P>
// Default behavior will fire <code>icon.click()</code> if specified, with two parameters
// <code>tab</code> (a pointer to the tab object and <code>tabSet</code> a pointer to the tabSet
// instance.
// @param tab (Tab) with click handler being fired
// @visibility external
//<
tabIconClick : function (tab) {
    var icon = tab.icon;
    if (icon && icon.click) return this.fireCallback(icon.click, 'tab,tabSet', [tab,this]);
},

//> @method tabSet.getTabObject()
// Get the tab Object originally passed to +link{tabSet.tabs}, by index, name or ID.
// If passed a tab Object, just returns it.
//
// @param	tab   (int | GlobalId | TabName | Tab)
// @return (Tab) the tab, or null if not found
// @visibility external
//<
// NOTE: this returns the tab configuration object, not the button, since there may not be a
// Button.
getTabObject : function (tab) {
    // passed the tab button - determine it's index (use this below)
    tab = this.getTabNumber(tab);
    if (tab >= this.tabs.length) {
        var button = this.tabBar.getButton(tab);
        if (button && button.moreTab) return this.moreTab;
    }
    return this.tabs[tab];
},

//> @method tabSet.getTab()
// Get the live Canvas representing a tab by index, ID, reference, or name.  
// If passed a tab Canvas, just returns it.
// <P>
// Note that live Tab instances are not available until +link{Canvas.draw,draw()}.
// <P>
// The returned Tab is considered an internal component of the TabSet.  In order to maximize
// forward compatibility, manipulate tabs through APIs such as a +link{setTabTitle()} instead.
// Also note that a super-lightweight TabSet implementation may not use a separate Canvas per
// Tab, and code that accesses and manipulates Tabs as Canvases won't be compatible with that
// implementation.
//
// @param	tab   (int | GlobalId | TabName | Canvas) identifier for the tab or tab button
// @return (StatefulCanvas) the tab Canvas, or null if not found or TabSet not drawn yet
//
// @visibility external
//<
getTab : function (tab) {
    
    // already the tab button, return it
    if (isc.isAn.Canvas(tab)) return tab;

    if (!this.tabs) return null;

    // if we have a tab-config block, convert it to an index, since the tabBar doesn't see our 
    // 'tabs' array
    // Note this is the full set of tabs, including hidden tabs, as these are included in the
    // buttons array on the tab bar
    if (this.tabs.contains(tab)) tab = this.tabs.indexOf(tab);

    // getButton on the tabBar handles the various possible types of the tab identifier passed in
    tab = this.getTabBar().getButton(tab);
    
    return tab;
},

//> @method tabSet.getTabPane()
// Returns the pane for a given tab.
//
// @param	tab   (Object | number | GlobalId | TabName | Tab)
// @return (Canvas) the tab pane
// @visibility external
//<
getTabPane : function (tab) {
    var tabObject = this.getTabObject(tab);
    return tabObject ? tabObject.pane : null;
},

//> @method tabSet.findTabObject()
// Returns a the first tab in the list that matches the user-passed property name/value pair.
//
// @param	propertyName   (String) name of the property to look for
// @param	propertyValue  (Any) value of the property
//<
findTabObject : function (propertyName, propertyValue) {
    return this.tabs.find(propertyName, propertyValue);
},

//> @method tabSet.getTabNumber()
// Get the index of a tab, from the tab, tab ID or tab name.  If passed a number, just returns it.
// Note that the index returned will include +link{tab.hidden,hidden tabs} as well as visible
// tabs.
//
// @param	tab   (number | GlobalId | TabName | Tab)
// @return (number) the index of the tab, or -1 if not found 
// @visibility external
//<
// Note - we don't call this 'getTabIndex', even though it is an index, because of the conflict
// with the 'tabIndex' of the widget as a whole
getTabNumber : function (tab) {
    if (isc.isA.Number(tab)) return tab;
    if (!this.tabs) return null;
    var index = this.tabs.indexOf(tab);
    if (index != -1) return index;
    
    
    if (isc.isA.String(tab)) {
        var index = this.tabs.findIndex("name", tab);
        if (index == -1) index = this.tabs.findIndex("ID", tab);
        return index;
    }
    
    // At this point it must be a pointer to the tab button, so fall through to 
    // tabBar.getButtonNumber()
    return this.getTabBar().getButtonNumber(this.getTab(tab));
},

//> @method tabSet.updateTab()
// Set the pane for a tab.
// <P>
// Pass in the index of a tab (or a tab object), and a new pane.
// <P>
// NOTE: the old pane for the tab is not destroy()d
// 
// @param	tab   (number | GlobalId | TabName | Tab) tab to update
// @param	pane  (Canvas | ID) new pane for the tab
// @visibility external
//<
updateTab : function (tab, pane) {
    // if we were passed a tab init block, for a new tab, call addTabs instead
    if (isc.isAn.Object(tab) && !isc.isA.Canvas(tab) &&
        this.tabs.indexOf(tab) == -1) 
    {
        if (pane != null) tab.pane = pane;
        return this.addTabs(tab);
    }

    // get the index for the tab (whatever way the "tab" is passed)
    var tabIndex = this.getTabNumber(tab);
    // bad tab specification
    if (tabIndex == -1) {
        this.logWarn("no such tab: " + this.echo(tab));
        return;
    }

    // get rid of the old pane
    var tabObject = this.getTabObject(tabIndex),
        oldPane = tabObject ? tabObject.pane : null;

    if (tabObject != null && tabObject.pane === pane) return; // no-op

    if (oldPane != null) {
        oldPane.hide();
        oldPane.deparent();
    }

    // NOTE: keep tabCanvas.pane and tabObject.pane in sync for EditMode where the Tab needs to
    // be able to respond to getProperty("pane")
    var tabCanvas = this.getTab(tab);

    // if the new pane is null, we're done
    if (pane == null) {
        if (tabCanvas != null) tabCanvas.pane = null;
        return tabObject.pane = null;
    }

    // add the new pane to init block (Using createPane to instantiate as a Canvas if necessary)
    // this makes sure the pane is hidden and not a child of anything except the paneContainer    
    pane = tabObject.pane = this.createPane(pane, tabObject);

    // tabCanvas won't exist if we're not drawn yet
    if (tabCanvas != null) tabCanvas.pane = pane;

    // if the currently visible tab is being updated, ensure the new pane is
    // a member of the paneContainer with the appropriate visibility
    // (If undrawn it'll show up when the tabSet as a whole gets drawn)
    if (this.getSelectedTabNumber() == tabIndex) {
        if (!this.paneContainer.hasMember(pane)) {
            this.paneContainer.addMember(pane);
        // We may have added as a member and suppressed the draw due to the
        // "ignoreMember" logic in createPane - if so stop ignoring - will force
        // a reflow / draw.
        } else if (this.paneContainer.isIgnoringMember(pane)) {
            this.paneContainer.stopIgnoringMember(pane);
        }
        pane.setVisibility(isc.Canvas.INHERIT);
    }
},

//> @method tabSet.revealChild()   ([])
// Reveals the child Canvas passed in by selecting the tab containing that child if it is not
// already selected.  If no tab in this TabSet contains the passed-in Canvas, this method has 
// no effect
//
// @visibility external
// @param child (GlobalId | Canvas)   the child Canvas to reveal, or its global ID
//<
revealChild : function (child) {
    if (!isc.isA.String(child)) child = child.ID;
    if (!child || !this.tabs) return;
    for (var i = 0; i < this.tabs.length; i++) {
        if (this.tabs[i].pane && this.tabs[i].pane.ID == child) {
            this.selectTab(this.tabs[i]);
            break;
        }
    }
},


//>	@method	tabSet.fixLayout()	(A)
//			lay out the children of the tabSet. 
//			this method takes into account the position of the tabBar in the tabSet, 
//			and lays out the tabBar and the paneContainer accordingly.
//<
fixLayout : function (deltaX, deltaY) {
	// abbreviations
	var tb = this._tabBar,
        // round corners: for layout only, manipulate the edgedCanvas instead of the
        // paneContainer
		pc = this._edgedCanvas || this.paneContainer
	;
	// check for nulls, and exit if found.
	// this method requires that both the tabBar and the paneContainer be instantiated before
	// it is called.
	if (tb == null || pc == null) return;

    // avoid resizing-triggered recursive calls
    if (this._fixingLayout) return;
    this._fixingLayout = true;

    // make sure the tab bar is in front of the tabbar baseline
    if (this._tabBarBaseLine.getZIndex(true) >= tb.getZIndex(true)) {
        tb.moveAbove(this._tabBarBaseLine);
    }
	// make sure paneContainer is below _tabBarBaseLine
    if (pc.getZIndex(true) >= this._tabBarBaseLine.getZIndex(true)) {
        pc.moveBelow(this._tabBarBaseLine);
    }

    if (this.showTabBar == false) {
        tb.hide();
        this._tabBarBaseLine.hide();
    } else {
        tb.show();
        this._tabBarBaseLine.show();
    }

    
    var tbOverlap = this._firstNonNull(this.tabBarOverlap, tb.borderThickness,
                                       tb.baseLineThickness);

	// lay out the tabBar and paneContainer, depending on where the tabBar is.
    var tbWidth, tbHeight;
    if (this.showTabBar || !this.shrinkElementOnHide) {
        
        tbWidth =  tb.getWidth();
        tbHeight = tb.getHeight();
    } else {
        tbHeight = tbWidth = tbOverlap = 0;
    }

    var vertical;
    switch (this.tabBarPosition) {
    	case isc.Canvas.TOP :
            vertical = false;
    		pc.setRect(0, 
                       tbHeight - tbOverlap,
                       this.getWidth(),
                       Math.max(1, this.getHeight() - tbHeight + tbOverlap)
                      );
	        break;
        case isc.Canvas.BOTTOM :
            vertical = false;
            tb.setTop(this.getHeight() - tbHeight);
	    	pc.setRect(0,
                       0,
                       this.getWidth(), 
                       Math.max(1, this.getHeight() - tbHeight + tbOverlap)
                      );
            break;
        case isc.Canvas.LEFT :
            vertical = true;
    		pc.setRect(tbWidth - tbOverlap,
                       0,
                       Math.max(1, this.getWidth() - tbWidth + tbOverlap),
                       this.getHeight()
                      );
            break;
        case isc.Canvas.RIGHT :
            vertical = true;
    		tb.setLeft(this.getWidth() - tbWidth);
	    	pc.setRect(0,
                       0,
                       Math.max(1, this.getWidth() - tbWidth + tbOverlap),
                       this.getHeight()
                      );
            break;
    }
    
    
    var pcThickness = vertical ? pc.getVisibleHeight() : pc.getVisibleWidth();
    tb.resizeTo(vertical ? null : pcThickness, vertical ? pcThickness : null);

    // showControls() will show (or hide) the control layout, and return true if showing.
    var showControls = false;
    if (this.showTabBar) {
        
        if (this._shouldAdaptTabsBeforeShowingControls(vertical ? deltaY : deltaX)) {
            this._adjustControlClipping(vertical);
        }
        showControls = this.showControls();
    } else {
        showControls = this.hideControls();
    }
    
    // If we're showing the control layout adjust our tab-bar size to take it into account
    if (showControls) {
        this._adjustControlClipping(vertical);
        this.tabBarControlLayout.moveAbove(tb);
    } else {   
        
        var pcThickness = vertical ? pc.getVisibleHeight() : pc.getVisibleWidth();
        tb.resizeTo(vertical ? null : pcThickness, vertical ? pcThickness : null);
        if (this.isRTL() && !vertical) {
            tb.setLeft(0);
        }
    }

    // If the tab bar is currently scrolled, but there is enough space to display all its
    // tabs, force a scroll back to zero/zero
    
    var totalTabs = this._getTabSizes();
    if (vertical) {
        if (tb.getScrollTop() > 0 && totalTabs <= tb.getViewportHeight()) {
            tb.scrollTo(null, 0, "descrollTabs");
        }
    } else {
        if (tb.getScrollLeft() > 0 && totalTabs <= tb.getViewportWidth()) {
            tb.scrollTo(0, null, "descrollTabs");
        }
    }

    delete this._fixingLayout;
},

//>@method  tabSet.shouldShowControl()
// Should a specific control as specified in +link{tabSet.tabBarControls} be displayed?
// Default implementation will evaluate the +link{Canvas.showIf()} property for custom controls
// included as canvases. Standard controls for scrolling the tabBar will be included if 
// the relevant +link{tabSet.showTabScroller} or +link{tabSet.showTabPicker} property is not
// false, and there is not enough space in the tab-bar to display all the tabs.
// @parameter (Control) control from the +link{tabSet.tabBarControls} array
// @return  (boolean)   true if the control shoudl be displayed
// @group tabBarControls
//<

shouldShowControl : function (control) {
    // The standard controls only show if the tabs are clipped
    if ((control == "tabScroller") || (control == "tabPicker")) {
        if (this.showMoreTab) return false;
        if (!this.showTabScroller && control == "tabScroller") return false;
        if (!this.showTabPicker && control == "tabPicker") return false;
        // If the member width exceeds the available space for the tab-bar we need to show
        // scroller buttons 
        var contentSize = this._getTabSizes();
        if (contentSize == 0) return false;

        
        var otherControlSize=0;
        for (var i = 0; i < this.tabBarControls.length; i++) {
            var otherControl = this.tabBarControls[i];
            if (otherControl == "tabScroller" || otherControl == "tabPicker") continue;
            if (this.shouldShowControl(otherControl)) {
                if (!isc.isA.Canvas(otherControl)) otherControl = this.getControl(otherControl);
                otherControlSize += vertical ? otherControl.getVisibleHeight() : otherControl.getVisibleWidth();
            }
        }

        var vertical = (this._tabBar.orientation == isc.Layout.VERTICAL),
            clipTabs = (contentSize > (vertical ? (this.getViewportHeight() - otherControlSize)
                                                : (this.getViewportWidth() - otherControlSize)));
        return clipTabs;
    }

    var control = this.getControl(control);

    if (isc.isA.Canvas(control) &&
        !this.tabBarControlLayout._shouldIgnoreMember(control))
    {
        return true;
    }
    return false;
},

_getTabSizes : function () {
    var bar = this._tabBar;
    if (!bar) return 0;

    var contentSize = bar.getMemberSizes();
    if (contentSize == null || contentSize.length == 0) return 0;
    
    contentSize = contentSize.sum() + bar.membersMargin * (contentSize.length - 1);
        
    
    var vertical = bar.vertical,
        sizeAdjustment = vertical ? (bar._topMargin  || 0) + (bar._bottomMargin || 0)
                                  : (bar._leftMargin || 0) + (bar._rightMargin  || 0);
    return contentSize + sizeAdjustment;
},

scrollerBackHMarginSize: 0,
scrollerBackVMarginSize: 0,
scrollerForwardHMarginSize: 0,
scrollerForwardVMarginSize: 0,

//> @method tabSet.getScrollerBackImgName() (A)
// Returns the +link{StretchItem.name} to use for the back button part of the <code>"tabScroller"</code>
// standard control.
// @return (String) scrollerBackImg name
// @see TabSet.scroller
//<
getScrollerBackImgName : function () {
    return this.symmetricScroller ? "back" : this.tabBarPosition + "_back";
},

//> @method tabSet.getScrollerForwardImgName() (A)
// Returns the +link{StretchItem.name} to use for the forward button part of the <code>"tabScroller"</code>
// standard control.
// @return (String) scrollerForwardImg name
// @see TabSet.scroller
//<
getScrollerForwardImgName : function () {
    return this.symmetricScroller ? "forward" : this.tabBarPosition + "_forward";
},

//> @method tabSet.getTabPickerSrc() (A)
// Returns the +link{ImgButton.src} to use for the +link{TabSet.tabPicker} button.
// @return (SCImgURL) URL of the tabPicker's src.
//<
getTabPickerSrc : function () {
    var vertical = (this._tabBar.orientation == isc.Layout.VERTICAL);
    if (this.symmetricPickerButton) {
        return vertical ? this.pickerButtonVSrc : this.pickerButtonHSrc;
    } else {
        return this.pickerButtonSrc;
    }
},

//>@method  tabSet.getControl()
// Given an entry in the +link{tabSet.tabBarControls} array, this method will return a pointer
// to the actual widget to display in the control layout.<br>
// If passed a canvas, it will be returned intact.<br>
// Will also map the special strings <code>"tabPicker"</code> and <code>"tabScroller"</code> to
// standard tab picker and scroller controls.
// @param control (String | Canvas)    Control from +link{tabSet.tabBarControls} array.
// @return (Canvas) Control widget to include in the control layout for this tabset
// @group tabBarControls
//<

getControl : function (control) {
    if (isc.isA.Canvas(control)) return control;
    var vertical = (this._tabBar.orientation == isc.Layout.VERTICAL);

    if (control == "tabScroller") {
        if (!this.scroller) {

            // Make the scroller a stretchImgButton with 2 "buttons"
            var sbsize = this.scrollerButtonSize;

            var scrollerSrc;
            if (this.symmetricScroller) {
                scrollerSrc = vertical ? this.scrollerVSrc : this.scrollerHSrc;
            } else {
                scrollerSrc = this.scrollerSrc;
            }
            var backName = this.getScrollerBackImgName(),
                forwardName = this.getScrollerForwardImgName();

            this.scroller = this.createAutoChild("scroller", {
                vertical:vertical,
                width:vertical ? (this.tabBarThickness - this._tabBar.baseLineThickness) : (2*sbsize),
                height:vertical ? (2*sbsize) : (this.tabBarThickness - this._tabBar.baseLineThickness),
                items: this.needEmptyButton ? [{height:vertical ? 5 : null, 
                                                width:vertical ? null : 6,
                                                src:isc.Canvas._blankImgURL, extraCSSText:(vertical ? "margin: 0 auto" : "vertical-align:middle")},
                       isc.addProperties({name:this.getScrollerBackImgName(),
                              width:vertical ? null : sbsize - this.scrollerForwardHMarginSize,
                              height:vertical ? sbsize - this.scrollerForwardVMarginSize : null}, this.scrollerBackImg),
                       {height:vertical ? 8 : null, 
                        width:vertical ? null : 10, 
                        name: "emptyButton",
                        src:isc.Canvas._blankImgURL, extraCSSText:(vertical ? "margin: 0 auto" : "vertical-align:middle")},
                       isc.addProperties({name:this.getScrollerForwardImgName(),
                              width:vertical ? null : sbsize - this.scrollerBackHMarginSize,
                              height:vertical ? sbsize - this.scrollerBackVMarginSize : null}, this.scrollerForwardImg)]
                        :
                        [isc.addProperties({name:this.getScrollerBackImgName(),
                              width:vertical ? null : sbsize - this.scrollerForwardHMarginSize,
                              height:vertical ? sbsize - this.scrollerForwardVMarginSize : null}, this.scrollerBackImg),
                       isc.addProperties({name:this.getScrollerForwardImgName(),
                              width:vertical ? null : sbsize - this.scrollerBackHMarginSize,
                              height:vertical ? sbsize - this.scrollerBackVMarginSize : null}, this.scrollerForwardImg)],
                scrollerPosition:this.tabBarPosition,
                skinImgDir:this.skinImgDir,

                src:scrollerSrc,

                backPartName:backName,
                forwardPartName:forwardName
            }, this.scrollerProperties);
        }

        return this.scroller;

    } else if (control == "tabPicker") {
        var tabPickerSize = (isc.Browser.isTouch ? this.touchPickerButtonSize : this.pickerButtonSize);
        if (!this.tabPicker) {
            var tabSrc = this.getTabPickerSrc();
            this.tabPicker = this.createAutoChild("tabPicker", {
                // use customState to append the tab bar position if necessary
                customState:this.symmetricPickerButton ? null : this.tabBarPosition,
                pickerPosition:this.tabBarPosition,
                skinImgDir:this.skinImgDir,
                src:tabSrc,
                height:(vertical ? tabPickerSize : (this.tabBarThickness - this._tabBar.baseLineThickness)),
                width:(vertical ? (this.tabBarThickness - this._tabBar.baseLineThickness) : tabPickerSize)
            });
        }

        return this.tabPicker;
    }

    // If the control is a string, check for it being a widget's global ID
    if (isc.isA.String(control) && isc.isA.Canvas(window[control])) return window[control];

    // At this point we don't recognize the controller - log a warning and bail
    this.logWarn("Unable to resolve specified tabBarControl:" + isc.Log.echo(control) + 
                   " to a valid control. Not displaying.");
    return null;
},

// Method to actually show the controlLayout if required.
// If no controls are to be displayed this method falls through to hideControls()
// Returns true if any controls are displayed, false otherwise
showControls : function () {
    var controlSet = this.tabBarControls,
        controlSize = 0,
        barPos = this.tabBarPosition, 
        vertical = barPos == isc.Canvas.RIGHT || barPos == isc.Canvas.LEFT,
        visibleControlIndex = 0;

    var controlLayout = this.tabBarControlLayout;
    // controls should all be housed in a layout
    if (!controlLayout) {
        // create the tabBarControls as an autoChild
        this.tabBarControlLayout = controlLayout =
                                   this.createAutoChild("tabBarControlLayout",
                                   {styleName:this.tabBarControlLayoutDefaults.styleName ||
                                              this.tabBar.styleName,
                                    _shouldIgnoreMember : function (control) {
                                        if (this.Super("_shouldIgnoreMember", arguments)) return true;
                                        if (control.showIf) return !control.fireCallback(control.showIf, [control]);
                                        return false;
                                    },
                                    // if a control is resized while visible, ensure the tabSet 
                                    // is notified so it can keep us right-aligned in the tab-bar
                                    childResized : function () {
                                        this.Super("childResized", arguments);
                                        this.creator._controlLayoutChildResized();
                                    },
                                    // if the visibility of a tabBar control changes, re-layout
                                    // the tabBarControlLayout
                                    childVisibilityChanged : function (child) {
                                        this.Super("childVisibilityChanged", arguments);
                                        this.creator._controlLayoutChildResized();
                                    },
                                    vertical:vertical

                                    // For autoTest APIs
                                    ,locatorParent:this
                                   });
                                   
        // For autoTest: if we are showing tabBarControlLayout, access it directly by name
        this.tabBarControlLayout.setLocatorParent(this, "tabBarControlLayout");

    }

    for (var i = 0; i< controlSet.length; i++) {
        var control = controlSet[i],
            shouldShowControl = this.shouldShowControl(control);
        // Turn the control identifier into a pointer to a Canvas if necessary
        control = this.getControl(control);
        if (!control) continue;

        if (!shouldShowControl && (control == this.scroller || control == this.tabPicker)) {
            continue;
        }

        // At this point the control should be a pointer to a canvas -
        // Ensure the layout is showing, and that the control shows up in the right spot
        if (controlLayout.getMemberNumber(control) != visibleControlIndex) {
            controlLayout.addMember(control, visibleControlIndex);
        }
        visibleControlIndex ++;

        if (shouldShowControl) {
            // Remember how much space the controls take up
            controlSize += vertical ? control.getVisibleHeight() : control.getVisibleWidth();
        }
    }

    // remove any members of the controlLayout beyond the end of the current set of visible
    // controls
    var membersToRemove = [];
    for (var i = visibleControlIndex; i < controlLayout.members.length; i++) {
        membersToRemove.add(i);
    }
    controlLayout.removeMembers(membersToRemove);
    // Note: we're not destroying these members, just deparenting them

    // If we are NOT showing any controls, hide the layout and return false
    if (controlSize == 0) {
        this.hideControls();
        return false;
    }

    this.placeControlLayout(controlSize);

    if (!controlLayout.isDrawn()) {
        if (this.getDrawnState()          != isc.Canvas.UNDRAWN && 
            controlLayout.getDrawnState() == isc.Canvas.UNDRAWN) controlLayout.draw();
    } else if (!controlLayout.isVisible()) controlLayout.show();

    return true;
},

placeControlLayout : function (controlSize) {
    
    // Now figure out the desired sizing / position of the controlLayout and put it in the right
    // place
    var left,top,width,height,
        // Ensure that we don't cover the baseline
        tb = this._tabBar,
        // TabBar.getBreadth() != tabBarThickness if an app explicitly sets the tabbar's height
        // differently in properties/defaults. Notably, this occurs in the Feature Explorer,
        // where the skin switcher is thicker than the tabBarThickness under Enterprise and
        // related skins. getBreadth() is the more accurate distance
        tbThickness = tb.getBreadth() - tb.baseLineThickness,
        barPos = this.tabBarPosition;

    if (barPos == isc.Canvas.LEFT) {
        left = 0;
        top = this.getViewportHeight() - controlSize;
        width = tbThickness;
        height = controlSize;
    } else if (barPos == isc.Canvas.RIGHT) {
        left = this.getViewportWidth() - tbThickness;
        top = this.getViewportHeight() - controlSize;
        width = tbThickness;
        height = controlSize;
    } else if (barPos == isc.Canvas.BOTTOM) {
        width = controlSize;
        left = this.isRTL() ? 0 : (this.getViewportWidth() - controlSize);
        top = this.getViewportHeight() - tbThickness;
        height = tbThickness;
    // Last possibility is TOP
    } else {
        width = controlSize;
        left = this.isRTL() ? 0 : this.getViewportWidth() - controlSize;
        top = 0;
        height = tbThickness;
    }

    this.tabBarControlLayout.setRect(left, top, width, height);
    if (!this.children.contains(this.tabBarControlLayout)) this.addChild(this.tabBarControlLayout);

},



// clip the controls if needed to ensure at least one tab is shown
_adjustControlClipping : function (vertical) {
    var tb = this._tabBar,
        firstTab = tb.getButton(0);

    if (vertical) {
        // size the tabBar so as to show all the controls
        tb.setHeight(Math.max(1, this.getViewportHeight() - 
                              this.tabBarControlLayout.getHeight()));
        // except, ensure the first tab is always visible
        if (firstTab && firstTab.isDrawn()) {
            var minBarHeight = firstTab.getVisibleHeight() + (tb._topMargin || 0),
                controlSize = this.getViewportHeight() - minBarHeight;
            if (tb.getVisibleHeight() < minBarHeight && controlSize > 0) {
                this.placeControlLayout(controlSize);
                tb.setHeight(minBarHeight);
            }
        }
    } else {
        // size the tabBar so as to show all the controls
        tb.setWidth(Math.max(1, this.getViewportWidth() - 
                             this.tabBarControlLayout.getWidth()));
        // except, ensure the first tab is always visible
        if (firstTab && firstTab.isDrawn()) {
            var margin = this.isRTL() ? tb._rightMargin : tb._leftMargin,
                minBarWidth = firstTab.getVisibleWidth() + (margin || 0),
                controlSize = this.getViewportWidth() - minBarWidth;
            if (tb.getVisibleWidth() < minBarWidth && controlSize > 0) {
                this.placeControlLayout(controlSize);
                tb.setWidth(minBarWidth);
            }
        }
        if (this.isRTL()) tb.setLeft(this.tabBarControlLayout.getWidth());
    }
},

// decide whether to make a call to _adjustControlClipping() before showControls()
_shouldAdaptTabsBeforeShowingControls : function (delta) {
    var tb = this._tabBar,
        controls = this.tabBarControlLayout;

    // nothing to do if controls aren't visible, or no adaptive-width tabs are present
    if (!controls || !controls.isVisible() || !tb._canAdaptWidth()) return false;
    
    
    if (delta == null) return true;

    // if the tab navigation controls are already showing for a narrowing of the tabSet, or not
    // already showing for a widening, then skip the extra call to _adjustControlClipping().
    return tb.hasMember(this.tabPicker) || tb.hasMember(this.scroller) ? delta > 0 : delta < 0;
},
        
_controlLayoutChildResized : function () {
    var layout = this.tabBarControlLayout;
    if (!layout) return;
    this.showControls();

    var tb = this.tabBar;
    if (tb) {
        var vertical = (this.tabBarPosition == isc.Canvas.LEFT || 
                        this.tabBarPosition == isc.Canvas.RIGHT);
        if (vertical) {
            tb.setHeight(this.getViewportHeight() - this.tabBarControlLayout.getVisibleHeight());
        } else {
            tb.setWidth(this.getViewportWidth() - this.tabBarControlLayout.getVisibleWidth());
        }
    }
},

// Hide the controlLayout
hideControls : function () {
    if (this.tabBarControlLayout && 
        this.tabBarControlLayout.visibility != isc.Canvas.HIDDEN)
    {
        this.tabBarControlLayout.hide();
    }
},

// Add custom control immediately before tab scroller/picker
addTabBarControl : function (control) {
    var tabBarControls = this.tabBarControls,
        slot
    ;
    for (var i = 0; i < tabBarControls.length; i++) {
        if (tabBarControls[i] == "tabScroller" || tabBarControls[i] == "tabPicker") {
            slot = i;
            break;
        }
    }
    if (slot != null) {
        var controls = this.tabBarControls.duplicate();
        controls.addAt(control, slot);
        this.tabBarControls = controls;
        this.showControls();
    }
},

//>@method  tabSet.scrollForward()
// If there is not enough space to display all the tabs in this tabSet, this method will 
// scroll the next tab (that first tab that is clipped at the end of the tab-bar) into view.
// @visibility external
//<
scrollForward : function () {
    this._tabBar.scrollForward(this.animateTabScrolling);
},

//>@method  tabSet.scrollBack()
// If there is not enough space to display all the tabs in this tabSet, this method will 
// scroll the previous tab (that first tab that is clipped at the beginning of the tab-bar) 
// into view.
// @visibility external
//<
scrollBack : function () {
    this._tabBar.scrollBack(this.animateTabScrolling);
},

// Called from click on the tabPicker control. Displays a menu with options to select
// a tab from the tabSet
showTabPickerMenu : function () {
    
    if (!this._pickerMenu) {
        var tabs = this.tabs,
            items = [];
        for (var i = 0; i < tabs.length; i++) { 
            if (tabs[i].hidden) continue;
            items.add({index:i,
                        enabled:!this.tabs[i].disabled,
                        checkIf:"menu.tabSet.getSelectedTabNumber() == " + i,
                        title:tabs[i].pickerTitle || tabs[i].title, 
                        // Note: We show the tab's icon in the menu, if there is one.
                        // This will show instead of the check-mark which we normally use to 
                        // indicate selection
                        
                        icon:(this.canCloseTab(tabs[i]) ? null : tabs[i].icon),
                        
                        // Calling selectTab will automagically scroll the tab into view if
                        // necessary
                        click:"menu.tabSet.selectTab(item.index)"});
        }
        this._pickerMenu = this.getMenuConstructor().create({tabSet:this, data:items})
    }
    
    // Show it under the button
    
    this._pickerMenu._showOffscreen();        
    this._pickerMenu.placeNear(this.tabPicker.getPageLeft(), this.tabPicker.getPageBottom())
    this._pickerMenu.show();
},

// resetTabPickerMenu - helper to destroy the tab picker menu so it will be rebuilt when next shown
// This ensures it picks up new details from the current set of tabs.
resetTabPickerMenu : function () {
    if (this._pickerMenu) {
        this._pickerMenu.destroy();
        delete this._pickerMenu;
    }
}, 

// fix layout on a change of size
layoutChildren : function (reason, deltaX, deltaY, d) {
    this.invokeSuper(isc.TabSet, "layoutChildren", reason, deltaX, deltaY, d);
    this.fixLayout(deltaX, deltaY);
},

_tabResized : function () {
    this.fixLayout();
},

// NOTE: this is internal because it only shows a new tab, it does not hide the previous tab.
// The external API is selectTab();
_showTab : function (tab) {
    

    if (tab == this.moreTab) {
        this.rebuildMorePane();
    }
	this.paneContainer.scrollTo(0,0,"showTab");

    if (tab != null && tab.pane != null) {
        if (!this.paneContainer.hasMember(tab.pane)) this.paneContainer.addMember(tab.pane);
        var paneMargin = ((tab.paneMargin != null ? tab.paneMargin : this.paneMargin) || 0);
        this.paneContainer.setLayoutMargin(paneMargin);
        tab.pane.show();
        this.paneContainer.stopIgnoringMember(tab.pane);
    }

	this.paneContainer.adjustOverflow();
},

//>	@method	tabSet._tabSelected(tab)	(A)
// Perform actions when a tab is selected. 
// This method is "bound" to the tabBar's buttonSelected method, so that is will fire
// whenever a button on the tabBar is seleced. it performs the following functions:
// 			 - show the associated pane
// 			 - scroll to (0,0)
//
//		@see this.tabBar.buttonSelected
//		@param	tab	(Tab) tab that has been selected.
//<

_tabSelected : function (tab) {
    // fire handler (fire it first so it has an opportunity to alter the tab, eg add a pane on
    // the fly)

    var cancelSelection;

    var currentTabObject = this.getSelectedTab(),
        currentTabNum = this.getSelectedTabNumber(),
        tabNum = this._tabBar.getButtonNumber(tab),
        tabObject = this.getTabObject(tabNum),
        tabDeselected = (currentTabObject != null) && (tabObject != currentTabObject);


    // currentTabNum may already be set to the tab being selected, before this
    // method has run.
    // This can occur on initial selection when tab is added/drawn and
    // on selection due to other tab being removed.
    // Therefore store another flag "_selectedTabObj" to indicate we've actually run
    // our tabSelected handlers and shown the pane.
    // If this flag is set to the tab passed in, no-op.
    
    var isMoreTab = this.showMoreTab && this.tabBar.isShowingMoreTab() && tabObject == this.moreTab;
    if (!isMoreTab) {
        if (tabObject == this._selectedTabObj) return;
        this._selectedTabObj = tabObject;
    }

    if (tabDeselected && !this._suppressTabSelectedHandlers) {
        // fire deselected and selected handlers.
        // Notes: 
        // - If this is the first time the thing is drawn we'll have tabSelected being
        //   fired on the initially selected tab but the "currentTabObject" will also point to that
        //   tab -- in this case don't fire the deselected handler
        // - if a tab is removed programmatically it is deselected. In this case
        //   currentTabObject can be expected to be unset at this point.
        // - if a tab is hidden programatically it is deselected. In this case tab.hidden
        //   will have been set
        if (!currentTabObject.hidden) {
            if (currentTabObject.tabDeselected != null) {
                if (this.fireCallback(
                        
                        currentTabObject.tabDeselected, 
                        "tabSet,tabNum,tabPane,ID,tab,newTab,name",
                        [   this,
                            // deselected tab details
                            this.selectedTab, currentTabObject.pane, currentTabObject.ID, 
                            currentTabObject,
                            // new tab
                            tabObject,
                            currentTabObject.name
                        ]
                    ) == false) 
                {
                    cancelSelection = true;
                }
            }

            if (!cancelSelection && this.tabDeselected != null) {
                cancelSelection = (this.tabDeselected(this.selectedTab, 
                                    currentTabObject.pane, currentTabObject.ID, currentTabObject, 
                                    tabObject, currentTabObject.name) == false)
            }
        }
        var currentPane = currentTabObject.pane;
        // hide the current pane
        if (!cancelSelection && currentPane != null) {
            this.hidePane(currentPane);
        }
    }

    // force the tab to go back to selected state but don't fire any handlers / show or hide
    // tabs, etc.
    if (cancelSelection) {
        this._suppressTabSelectedHandlers = true;

        var cancelledTabObject = tabObject;
        var tab = this.getSelectedTab();
        this.selectTab(tab);
        var tabButton = this.getTab(this.getTabNumber(tab));
        // If this came from a click on the new tab, 
        // explicitly focus back in the tab we just re-selected. This is just better UI - if
        // someone clicked a tab and it didn't select, but focus went there we don't really
        // want a dotted outline on the clicked, but not selected button.
        if (isc.EH.mouseDownTarget() == this.getTab(cancelledTabObject)) {
            // If a clickMask went up (most likely as part of the 'tabDeselected' handler showing a
            // prompt), ensure that on its dismissal focus goes to this tab, not the last clicked
            // tab!
            if (isc.EH.clickMaskUp() && isc.EH.targetIsMasked(tabButton)) {
                var topMask = isc.EH.clickMaskRegistry.last();
                isc.EH.setMaskedFocusCanvas(tabButton, topMask);
            } else {
                tabButton.focus();
            }
        }
        delete this._suppressTabSelectedHandlers;
        return;
    }

    // If pane has been destroyed drop our reference
    var pane = tabObject.pane;
    if (pane && (pane.destroyed || pane.destroying || pane.isPendingDestroy())) {
        tabObject.pane = null;
    }

    // Remember the selected tabNum - used by this.getSelectedTabNumber() etc.
    this.selectedTab = tabNum;
    if (!this._suppressTabSelectedHandlers) {
        var handlerChangedTab;
        if (tabObject.tabSelected != null) {
            this.fireCallback(
                tabObject.tabSelected, 
                "tabSet,tabNum,tabPane,ID,tab,name",
                [this, tabNum, tabObject.pane, tabObject.ID, tabObject, tabObject.name]
            );

            // If this tab is no longer marked as selected, tabSelected() may have shown a 
            // different tab.  In this case don't call _showTab!
            if (this.getSelectedTabNumber() != tabNum) {
                return;
            }
        }

        // fire the notification functions
        if (this.tabSelected) {
            this.tabSelected(tabNum, tabObject.pane, tabObject.ID, tabObject, tabObject.name);

            // Once againk, if this tab is no longer marked as selected, tabSelected() 
            // may have shown a different tab.  In this case don't call _showTab!
            if (this.getSelectedTabNumber() != tabNum) {
                return;
            }
        }
    }
    this._showTab(tabObject);

    // ensure the tab button is scrolled into view
    var tb = this._tabBar;
    // leave the second param as null - tab bar will automatically scroll to appropriate
    // position
    var tabSet = this;
    tb.scrollTabIntoView(tabNum, null, this.animateTabScrolling);
},

hidePane : function (pane) {
    if (pane == null) return;
    pane.hide();
    this.paneContainer.ignoreMember(pane);
    pane.moveTo(this.isRTL() ? 9999 : -9999, -9999);
},


//> @method tab.tabSelected()
// Optional handler to fire when a tab is selected. As with +link{TabSet.tabSelected()} this
// method only fires when the tabset is drawn.
//
// @param tabSet (TabSet) the tabSet containing the tab.
// @param tabNum (Integer) the index of the newly selected tab
// @param tabPane (Canvas) the newly selected tab's pane if set
// @param ID (GlobalId) the ID of the newly selected tab
// @param tab (Tab) the tab object (not tab button instance)
// @param name (TabName) the name of the newly selected tab
//
// @see tab.tabDeselected
// @visibility external
//<


//> @method tab.tabDeselected()
// Optional handler to fire when a tab is deselected. <smartclient>Returning false</smartclient>
// <smartgwt>Calling {@link com.smartgwt.client.widgets.tab.events.TabDeselectedEvent#cancel}
// </smartgwt> will cancel the new selection, leaving this tab selected.
// As with +link{TabSet.tabSelected()} this
// method only fires when the tabset is drawn.
//
// @param tabSet (TabSet) the tabSet containing the tab.
// @param tabNum (Integer) the index of the deselected tab
// @param tabPane (Canvas) the deselected tab's pane if set
// @param ID (GlobalId) the ID of the deselected tab
// @param tab (Tab) the deselected tab object (not tab button instance)
// @param newTab (Tab) the tab object being selected
// @param name (TabName) the name of the deselected tab
//
// @return (boolean) return <code>false</code> to cancel the tab selection
//
// @see tab.tabSelected
// @visibility external
//<


//>	@method	tabSet.getSelectedTab() ([A])
// Returns the currently selected tab object.  This is the object literal used to configure the
// tab, rather than the tab button widget.
// @return (Tab) the currently selected Tab object
// @visibility external
//<
getSelectedTab : function () {
    if (isc.isA.Object(this.selectedTab)) {
        for (var i = 0; i < this.tabs.length; i++) {
            if ((this.selectedTab.ID != null && this.selectedTab.ID == this.tabs[i].ID) ||
                (this.selectedTab.name != null && this.selectedTab.name == this.tabs[i].name))
            {
                return this.tabs[i];
            }
        }
        this.logWarn("There is no a tab that matches the currently selected tab");
        return this.tabs[0];
    } else {
        if (this.selectedTab >= this.tabs.length) return this.moreTab;
        return this.tabs[this.selectedTab];
    }
},

//>	@method	tabSet.getSelectedTabNumber() ([A])
// Returns the index of the currently selected tab object.  
// @return (number) the index of the currently selected tab object
// @visibility external
//<
getSelectedTabNumber : function () {
    if (!isc.isA.Number(this.selectedTab)) this.selectedTab = this.getTabNumber(this.selectedTab);
    // If the specified selectedTabNum doesn't correspond to a tab don't return it.
    if (!this.tabs || !this.tabs[this.selectedTab]) return -1;
    return this.selectedTab;
},



//>	@method	tabSet.selectTab()    ([])
//	Select a tab. Note that this method will have no effect if the tab is +link{tab.hidden,hidden}.
//
// @param	tab   (number | GlobalId | TabName | Tab) tab to select
// @visibility external
// @example tabsOrientation
//<
selectTab : function (tab) {
    var tabIndex = this.getTabNumber(tab),
        tabObject = this.tabs[tabIndex];

    if (tabObject && tabObject.hidden) {
        this.logWarn("Rejecting attempt to select hidden tab:" + tab);
        return;
    }

    if (tabIndex != -1) {
        // calling 'selectTab()' on the tab bar will actually select the button.
        // this handles firing our tabSelected() notification functions
        if (this._tabBar) {
            this._tabBar.selectTab(tabIndex);
        }
        
        // TabBar (subclass of Toolbar) initializes its members (buttons) lazily on draw()
        // We won't get any _tabSelected notifications until after this has happened.
        // Therefore if the tab bar hasn't initialized yet, simply record this.selected tab
        // so methods like this.getSelectedTabNum() / getselectedTabObject() work
        //
        // Note that we explicitly call tabBar.selectTab(this.selectedTab) on draw() to ensure
        // the tab-bar stays in synch
        if (this._tabBar == null || !this._tabBar._buttonsInitialized) {
            this.selectedTab = tabIndex;
        }
        
    }
},

//> @method tabSet.tabForPane()
//Search for a tab that contains a pane.
//@param pane (Canvas) pane to show
//@return (Tab) tab that contains passed pane
//@visibility external
//<
tabForPane : function (pane) {
    if (this.tabs) {
        for (var i = 0; i < this.tabs.length; i++) {
            if (this.tabs[i].pane == pane) {
                return this.tabs[i];
            }
        };        
    }
},

//>	@method	tabSet.getTabBar()
// Returns handle to the TabBar used by this tabset
// @return (TabBar) the tab bar
//<
getTabBar : function () {
    return this._tabBar;
},

_editTabTitle : function (tab) {
    tab = this.getTab(tab);
    
    var canEdit;
    
    if (this.canEditTabTitles) {
        if (tab.canEditTitle !== false) {
            canEdit = true;
        }
    } else {
        if (tab.canEditTitle === true) {
            canEdit = true;
        }
    }
    
    if (canEdit) this.editTabTitle(tab);
    return canEdit;
},

//>	@method	tabSet.editTabTitle()
// Places an editor in the title of the parameter tab and allows the user to edit the title.
// Note that this programmatic method will <b>always</b> allow editing of the specified tab's
// title, regardless of the settings of +link{canEditTabTitles} or +link{Tab.canEditTitle}.
// @param	tab      (Tab | String | Integer)   The tab whose title should be edited (may be
//   specified by ID or index)
// @see TabSet.canEditTabTitles
// @see Tab.canEditTitle
// @visibility external
//<
editTabTitle : function (tab) {
    tab = this.getTab(tab);
    
    if (tab == null || !this.tabBar) return;
    
    if (!isc.isA.DynamicForm(this.titleEditorForm)) {
        var titleEditorConfig =  isc.addProperties(
                {}, this.titleEditorDefaults, 
                this.titleEditorProperties, {
                     handleKeyPress : function (event,eventInfo) {
                        
                        var rv = this.Super("handleKeyPress", arguments);
                        
                        var keyName = event.keyName;
                        
                        if (keyName == "Escape") {
                            this.form.targetTabSet.cancelTabTitleEditing();
                        } else if (keyName == "Enter") {
                            this.form.targetTabSet.saveTabTitle();
                        }
                        return rv;
                    }
                }
        );
        
        
        titleEditorConfig.name = "title";
        
        this.titleEditorForm = isc.DynamicForm.create({
            autoDraw: false,
            margin: 0, padding: 0, cellPadding: 0,
            fields: [
                titleEditorConfig
            ]
        });
        
        // Make the item directly available as a read-only form item (as documented)
        this.titleEditor = this.titleEditorForm.getItem("title");
    }
        
    var editor = this.titleEditorForm;
    editor.setProperties({targetTabSet: this, targetTab: tab});
        
    var item = editor.getItem("title");
    var title = tab.title;
    item.setValue(title);
    
    // Always scroll the tab into view before showing the editor.
     
    this.tabBar.scrollTabIntoView(tab, null, this.animateTabScrolling,
                {target:this, methodName:"showTitleEditor"});
},

//> @method tabSet.cancelTabTitleEditing()
// If the user is currently editing a tab title (see +link{tabSet.canEditTabTitles}), dismiss
// the editor and discard the edit value entered by the user.
// @visibility external
//<
// We'll fire this from standard end edit event (Escape keypress) too
cancelTabTitleEditing : function () {
    if (this.titleEditorForm != null) {
        this.clearTitleEditorForm();
    }
},

//> @method tabSet.saveTabTitle()
// If the user is currently editing a tab title (see +link{tabSet.canEditTabTitles}), save
// the edited tab title and hide the editor.
// @visibility external
//<
// Also fired internally from standard end edit event (click outside / enter keypress);
saveTabTitle : function () {
    if (this.titleEditorForm != null && this.titleEditorForm.isVisible() 
        && this.titleEditorForm.isDrawn()) 
    {
        var cancelEdit = false,
            form = this.titleEditorForm,
            tab = form.targetTab,
            newTitle = form.getValue("title")
        ;
        if (newTitle != tab.title && (this.titleChanged != null)) {
            if (this.fireCallback(
                    this.titleChanged,
                    "newTitle, oldTitle, tab", 
                    [newTitle, tab.title,tab]
                ) == false) 
            {
                cancelEdit = true;
            }
        }
        if (!cancelEdit) this.setTabTitle(form.targetTab, newTitle);
    }
    // Dismiss the editor even if the titleChanged callback returned false, cancelling the
    // edit.
    // If we leave the editor up we're likely to get into tricky situations where
    // for example the developer can change tab with the editor still showing on another tab,
    
    this.clearTitleEditorForm();
},

clearTitleEditorForm : function () {
    if (this.titleEditorForm == null) return;
    this.titleEditorForm.clear();
    if (this.titleEditorForm._titleEditClickEvent != null) {
        isc.Page.clearEvent(this._titleEditClickEvent);
        delete this._titleEditClickEvent;
    }
    // Clear the 'targetTab' flag. This will allow us to avoid performing asyncronous "show"
    // due to pending animations etc. after this method has fired
    this.titleEditorForm.targetTab = null;
},

showTitleEditor : function () {
    var editor = this.titleEditorForm,
        tab = editor ? editor.targetTab : null;

    // This could happen a tab was removed, or clearTitleEditor() was called while waiting
    // for a tab to scroll (animatedly) into view, etc.
    if (tab == null || !this.getTabObject(tab)) {
        return;
    }
    // the editor will be a peer of the TabSet (shares the same parentElement)
    // The tab is a child of the TabBar
    // so left top should be tab left/top within the tabBar + tabBar left + tabBar border/margin

    var left = this.tabBar.getLeft() + this.tabBar.getLeftMargin() - this.tabBar.getScrollLeft()
            + this.tabBar.getLeftBorderSize() + tab.getLeft() + tab.capSize,
        width = tab.getVisibleWidth() - tab.capSize * 2;

    if (this.titleEditorLeftOffset) {
        left += this.titleEditorLeftOffset;
        width -= this.titleEditorLeftOffset;
    }

    if (this.titleEditorRightOffset) {
        width -= this.titleEditorRightOffset;
    }

    var item = editor.getItem("title");
    item.setWidth(width);

    // Editor form will be a peer of the tabSet - needs to float over the content of
    // the tab (nested inside the tabBar).
    var top = this.getTop() + 
              this.tabBar.getTop() + this.tabBar.getTopMargin() - this.tabBar.getScrollTop()
                + this.tabBar.getTopBorderSize() + tab.getTop();
    if (this.titleEditorTopOffset) {
        top += this.titleEditorTopOffset;
    }

    

    editor.moveTo(left, top);

    var item = editor.getItem("title");

    // make the editor a peer so it moves with us.
    // This will also handle showing / hiding / clearing / drawing with us - however
    // we'll also need to clear up the click-outside event on clear/hide so we'll
    // explicitly cancel title editing when we hide / clear instead of relying on this.
    if (editor.masterElement != this) {
        editor._moveWithMaster = true;
        editor._resizeWithMaster = false;
        editor._showWithMaster = false;
        this.addPeer(editor);

    } else {
        editor.draw();
    }
    item.focusInItem();
    item.delayCall("selectValue", [], 100);

    // Save edits on click outside title editor
    
    if (this._titleEditClickEvent == null) {
        var tabSet = this;
        var mouseDownHandler = function () {
            if (!tabSet.destroyed) {
                tabSet._clickOutsideDuringTitleEdit();
            }
        }
        this._titleEditClickEvent = isc.Page.setEvent("mouseDown", mouseDownHandler);
    }
},

_clickOutsideDuringTitleEdit : function () {
    if (isc.EH.getTarget() == this.titleEditorForm) return;
    this.saveTabTitle();
},

// On clear / hide / parent visibility change cancel title editing

// Clear is called recursively so this'll pick up parents clearing too
clear : function (a,b,c,d) {
    if (this.titleEditorForm != null && this.titleEditorForm.isDrawn()) {
        this.cancelTitleEditing();
    }

    // Clear whenRules while we're undrawn
    this._removeTabWhenRules(this.tabs);
    
    this.invokeSuper(isc.TabSet, "clear", a,b,c,d);
},

setVisibility : function (newVisibility, a,b,c,d) {
    this.invokeSuper(isc.TabSet, "setVisibility", newVisibility, a,b,c,d);
    if (!this.isVisible() && this.titleEditorForm != null && this.titleEditorForm.isDrawn()) {
        this.cancelTitleEditing();
    }
},

parentVisibilityChanged : function (newVisibility, a,b,c,d) {
    this.invokeSuper(isc.TabSet, "parentVisibilityChanged", newVisibility, a,b,c,d);
     if (!this.isVisible() && this.titleEditorForm != null && this.titleEditorForm.isDrawn()) {
        this.cancelTitleEditing();
    }
},

// documented where the string method is registered
tabsReordered : function (tabCanvas, tabIndex) {},

// Adding tabs
// ----------------------------------------------------------------------------------------

//>@method tabSet.addTabClicked()
// Event that fires when the +link{addTabButton} is clicked.
// No default behavior.
//
// @visibility external 
//<
addTabClicked : function () {}
});


isc.TabSet.registerStringMethods({
    //>	@method	tabSet.tabSelected()
    // Notification fired when a tab is selected. Note that this will only fire if 
    // this tabSet is drawn. If a tab is selected before +link{TabSet.draw()} 
    // is called, <smartclient>the <code>tabSelected()</code> notification</smartclient>
    // <smartgwt>{@link com.smartgwt.client.widgets.tab.events.TabSelectedEventl}</smartgwt>
    // will fire on <code>draw()</code>.
    // @param tabNum (Integer) the index of the newly selected tab
    // @param tabPane (Canvas) the newly selected tab's pane if set
    // @param ID (GlobalId) the ID of the newly selected tab
    // @param tab (Tab) the tab object (not tab button instance)
    // @param name (TabName) the name of the newly selected tab
    // @visibility external
    //<
    
	tabSelected:"tabNum,tabPane,ID,tab,name",

    //>	@method	tabSet.tabDeselected()
    // Optional handler to fire when a tab is deselected.
    // <smartclient>Returning false</smartclient><smartgwt>Calling
    // {@link com.smartgwt.client.widgets.tab.events.TabDeselectedEvent#cancel}
    // </smartgwt> will cancel the new selection, leaving tab <code>ID</code> selected.  As with
    // <smartclient>+link{TabSet.tabSelected()}</smartclient><smartgwt>
    // {@link com.smartgwt.client.widgets.tab.events.TabSelectedEventl}</smartgwt> this method
    // only fires when the tabset is drawn.
    //
    // @param tabNum (Integer) the index of the deselected tab
    // @param tabPane (Canvas) the deselected tab's pane if set
    // @param ID (GlobalId) the ID of the deselected tab
    // @param tab (Tab) the deselected tab object (not tab button instance)
    // @param newTab (Tab) the tab object being selected
    // @param name (TabName) the name of the deselected tab
    //
    // @return (boolean) return false to cancel the tab deselection
    // @visibility external
    //<
	tabDeselected:"tabNum,tabPane,ID,tab,newTab,name",
    
    
    // getPaneContainerEdges - documented by default implementation
    getPaneContainerEdges:"",
    
    //> @method tabSet.onCloseClick()
    // When +link{canCloseTabs} is set, this notification method fired when the user clicks 
    // the "close" icon for a tab.
    // Return false to cancel default behavior of removing the tab from the TabSet
    // @param tab (Tab) the tab to be removed
    // @return (boolean) return false to suppress removal of the tab
    // @visibility sgwt
    //<
    
    onCloseClick : "tab",
    
    //> @method tabSet.titleChanged()
    // This notification method fired when the user changes the title of a tab in this TabSet.
    // This can happen either through user interaction with the UI if 
    // +link{canEditTabTitles,canEditTabTitles} is set, or programmatically if application 
    // code calls +link{editTabTitle,editTabTitle}.<p>
    // Return false from this method to cancel the change.
    // @param newTitle (String) the new title
    // @param oldTitle (String) the old title
    // @param tab      (Tab)    the tab whose title has changed
    // @return (boolean) return false to suppress the title change
    // @visibility external
    //<
    titleChanged : "newTitle,oldTitle,tab",
    
    //> @method tabSet.showTabContextMenu()
    // Notification fired when the user right-clicks on a tab.
    // Event may be cancelled by returning false
    // @param tabSet (TabSet) This tabset
    // @param tab (Tab) the tab object that recieved the context click event
    // @return (boolean) return false to cancel default right-click behavior
    // @visibility external
    //<
    showTabContextMenu : "tabSet,tab",

	//> @method tabSet.tabsReordered
    // Notification method executed when one or more tabs in the TabSet are reordered.
    // @param tabCanvas (StatefulCanvas) the live Canvas representing the tab that was moved
    // @param tabIndex (Integer) the new index of the tab in the tabSet
	// @visibility external
	//<
    tabsReordered : "tabCanvas,tabIndex"

});

isc.defineClass("PaneContainer", "VLayout").addMethods({
    // override handleKeyPress to allow for navigation between tabs when focus'd on the
    // pane container or its children (via bubbled handleKeyPress events)
    // ctrl+tab - move one pane forward (or back to the first pane)
    // ctrl+shift+tab - move one pane back
    // (This is the Windows behavior - see Windows control panel)
    
    handleKeyPress : function (event, eventInfo) {
        if (event.keyName == "Tab" && event.ctrlKey) {
            var tabSet = this.parentElement,
                lastTabIndex = tabSet.tabs.length-1,
                currentSelection = tabSet.getSelectedTabNumber();

            if (event.shiftKey) {
                if (currentSelection > 0) currentSelection -=1;
                else currentSelection = lastTabIndex;
            } else {
                if (currentSelection < lastTabIndex) currentSelection +=1;
                else currentSelection = 0;
            }

            tabSet.selectTab(currentSelection);
            tabSet.getTabBar().getButton(currentSelection).focus();
            return false;                
        }
        return this.Super("handleKeyPress", arguments);
    }		        
});

// Register "tabs" as duplicate properties
// This means if a tabset subclass is created with tabs explicitly set to a bunch of config
// objects they'll be duplicated on instances rather than copied across directly.
// Ditto if <childName>Defaults is used in the autoChild subsystem.
// Also register the 'pane' sub property so if tab.pane is set it will be duplicated
// rather than shared across tabs
isc.TabSet.registerDupProperties("tabs", ["pane"]);
