/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.embedded_tomcat;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.apache.tomcat.util.IntrospectionUtils;

public class EmbeddedTomcat9
extends Tomcat {
    protected String catalinaHome = null;
    protected static String keystorePassFile = null;
    protected static boolean enableSymlinks = false;
    protected static boolean allowStaticResourceCaching = false;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final long multiplierKB = 1024L;
    private static final long multiplierMB = 0x100000L;
    private static final long multiplierGB = 0x40000000L;

    public EmbeddedTomcat9(String catalinaHome, String hostname) {
        this.setBaseDir(catalinaHome);
        this.enableNaming();
        this.getHost().setCreateDirs(true);
        this.getHost().setDeployIgnore(null);
        this.getHost().setDeployOnStartup(true);
        this.getHost().setAutoDeploy(true);
    }

    public void addHttpListener(int port, Properties connectorProperties, boolean secure, String algorithm, int redirectPort) {
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(port);
        if (secure) {
            connector.setSecure(true);
            connector.setScheme("https");
            String keystorePass = (String)connectorProperties.get("keystorePass");
            if (keystorePass == null && keystorePassFile != null) {
                try {
                    keystorePass = EmbeddedTomcat9.fileAsString(keystorePassFile);
                    keystorePass = keystorePass.trim();
                }
                catch (Exception exception) {
                    System.out.println("Unable to read configured keystorePassFile: " + keystorePassFile + " " + exception.getMessage());
                }
            }
            if (keystorePass != null) {
                connector.setAttribute("keystorePass", (Object)keystorePass);
            }
            connector.setAttribute("clientAuth", (Object)"false");
            connector.setAttribute("sslProtocol", (Object)"TLS");
            connector.setAttribute("SSLEnabled", (Object)true);
            connector.setAttribute("secretRequired", (Object)false);
            if (algorithm != null) {
                connector.setAttribute("algorithm", (Object)algorithm);
            }
        }
        for (String string : connectorProperties.keySet()) {
            Long sizeInBytes;
            String connectorPropertyValue;
            String connectorPropertyValueToLog = connectorPropertyValue = connectorProperties.get(string).toString();
            if (string.startsWith("max") && string.endsWith("Size") && (sizeInBytes = EmbeddedTomcat9.dataSizeNumBytes(connectorPropertyValue, null)) != null && !sizeInBytes.toString().equals(connectorPropertyValue)) {
                connectorPropertyValueToLog = sizeInBytes.toString() + " (" + connectorPropertyValue + ")";
                connectorPropertyValue = sizeInBytes.toString();
            }
            System.out.println("Setting Tomcat <Connector> property (port " + port + "): " + string + "=" + connectorPropertyValueToLog);
            IntrospectionUtils.setProperty((Object)connector, (String)string, (String)connectorPropertyValue);
            connector.setProperty(string, connectorPropertyValue);
        }
        if (redirectPort != -1) {
            connector.setRedirectPort(Integer.valueOf(redirectPort).intValue());
        }
        this.getService().addConnector(connector);
        this.setConnector(connector);
    }

    public void addAjpListener(int port, int redirectPort) {
        Connector connector = new Connector("AJP/1.3");
        connector.setPort(port);
        connector.setAttribute("secretRequired", (Object)false);
        if (redirectPort != -1) {
            connector.setRedirectPort(Integer.valueOf(redirectPort).intValue());
        }
        this.getService().addConnector(connector);
    }

    public StandardContext registerContext(String contextPath, String baseDir) throws Exception {
        if (contextPath.equalsIgnoreCase("root") || contextPath.equalsIgnoreCase("/root")) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        StandardContext context = new StandardContext();
        context.setName(contextPath);
        context.setPath(contextPath);
        context.setDocBase(baseDir);
        StandardManager manager = new StandardManager();
        manager.setPathname(null);
        context.setManager((Manager)manager);
        context.setConfigFile(this.getWebappConfigFile(baseDir, contextPath));
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setDefaultWebXml(baseDir + "/WEB-INF/web-tomcat.xml");
        context.addLifecycleListener((LifecycleListener)contextConfig);
        File contextXml = new File(baseDir + "/WEB-INF/classes/META-INF/context.xml");
        if (contextXml.exists()) {
            try {
                System.out.println("Using configuration in file META-INF/context.xml");
                context.setConfigFile(contextXml.toURI().toURL());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        WebappLoader loader = new WebappLoader(EmbeddedTomcat9.class.getClassLoader());
        context.setLoader((Loader)loader);
        context.setReloadable(false);
        StandardRoot resourceRoot = new StandardRoot((Context)context);
        if (enableSymlinks) {
            resourceRoot.setAllowLinking(true);
        }
        resourceRoot.setCachingAllowed(allowStaticResourceCaching);
        context.setResources((WebResourceRoot)resourceRoot);
        this.getHost().addChild((Container)context);
        return context;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.isomorphic.embedded_tomcat.className", EmbeddedTomcat9.class.getName());
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "EmbeddedTomcat9 [options]";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        OptionBuilder.withLongOpt((String)"catalinaHome");
        OptionBuilder.withDescription((String)"Base Catalina directory (CATALINA_HOME)");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"dir");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"war");
        OptionBuilder.withDescription((String)"Add a WAR deployment with the specified contextPath and baseDir");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"contextPath=baseDir");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"HTTP port number to listen on");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"securePort");
        OptionBuilder.withDescription((String)"HTTPS port number to listen on");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"ajpPort");
        OptionBuilder.withDescription((String)"AJP port number to listen on");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withLongOpt((String)"secureAlgorithm");
        OptionBuilder.withDescription((String)"Set to: IbmX509 if using IBM JDK");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)"hostname");
        OptionBuilder.withDescription((String)"Hostname");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"keystorePassFile");
        OptionBuilder.withDescription((String)"Keystore password file");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given <Connector> property");
        options.addOption(OptionBuilder.create((String)"C"));
        OptionBuilder.withLongOpt((String)"enableSymlinks");
        OptionBuilder.withDescription((String)"Set this parameter to enable symlink resolution in all deployed webapps (sets allowLinking attribute in Tomcat to true).  Do NOT set this on windows. For more info: http://jakarta.apache.org/tomcat/tomcat-5.0-doc/config/context.html");
        options.addOption(OptionBuilder.create((char)'l'));
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            EmbeddedTomcat9.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        String hostname = "localhost";
        if (line.hasOption('n')) {
            hostname = line.getOptionValue('n');
        }
        if (line.hasOption('l')) {
            enableSymlinks = true;
        }
        String catalinaHome = null;
        if (line.hasOption('c')) {
            catalinaHome = line.getOptionValue('c');
        }
        int port = 8080;
        if (line.hasOption('p')) {
            port = Integer.parseInt(line.getOptionValue('p'));
        }
        if (line.hasOption("keystorePassFile")) {
            keystorePassFile = line.getOptionValue("keystorePassFile");
        }
        Properties connectorProperties = line.getOptionProperties("C");
        EmbeddedTomcat9 embeddedTomcat = new EmbeddedTomcat9(catalinaHome, hostname);
        int securePort = -1;
        if (line.hasOption('s')) {
            securePort = Integer.parseInt(line.getOptionValue('s'));
            String algorithm = null;
            if (line.hasOption('a')) {
                algorithm = line.getOptionValue('a');
            }
            embeddedTomcat.addHttpListener(securePort, connectorProperties, true, algorithm, -1);
        }
        embeddedTomcat.addHttpListener(port, connectorProperties, false, null, securePort);
        if (line.hasOption('j')) {
            int ajpPort = Integer.parseInt(line.getOptionValue('j'));
            embeddedTomcat.addAjpListener(ajpPort, securePort);
        }
        if (line.hasOption("w")) {
            String[] wars = line.getOptionValues("w");
            for (int i = 0; i < wars.length; ++i) {
                String warString = wars[i];
                int sepIndex = warString.indexOf("=");
                if (sepIndex == -1) {
                    throw new Exception("format for --war is: contextPath=baseDir");
                }
                String contextPath = warString.substring(0, sepIndex);
                String baseDir = warString.substring(sepIndex + 1, warString.length());
                embeddedTomcat.registerContext(contextPath, baseDir);
            }
        }
        if (System.getenv("HAVE_DEVENV") != null && System.getenv("GLOBAL_DEVENV_BASE") != null) {
            embeddedTomcat.addUser("tomcat", "tomcat");
            embeddedTomcat.addRole("tomcat", "tomcat");
            embeddedTomcat.addUser("role1", "tomcat");
            embeddedTomcat.addRole("role1", "role1");
            embeddedTomcat.addRole("both", "tomcat");
            embeddedTomcat.addRole("both", "role1");
        }
        final Server server = embeddedTomcat.getServer();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    server.stop();
                    server.destroy();
                }
                catch (Exception e) {
                    System.out.println("Error while stopping Tomcat: " + e.getMessage());
                }
            }
        });
        server.await();
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "");
    }

    public static String fileAsString(String fileName) throws IOException {
        FileReader reader = new FileReader(fileName);
        StringWriter writer = new StringWriter();
        EmbeddedTomcat9.copyCharacterStreams(reader, writer);
        ((Reader)reader).close();
        return writer.toString();
    }

    public static void copyCharacterStreams(Reader in, Writer out) throws IOException {
        EmbeddedTomcat9.copyCharacterStreams(in, out, 4096, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        char[] buffer = new char[bufSize];
        if (buffered) {
            in = new BufferedReader(in);
            out = new BufferedWriter(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    public static Long dataSizeNumBytes(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        String stringValue = value.toString().trim();
        long multiplier = 1L;
        int strlen = stringValue.length();
        if (strlen > 2) {
            String units;
            String suffixUC = stringValue.substring(strlen - 2).toUpperCase();
            int numCharsToTrim = 1;
            if (suffixUC.endsWith("B")) {
                units = suffixUC.substring(0, 1);
                numCharsToTrim = 2;
            } else {
                units = suffixUC.substring(1);
            }
            if (units.equals("K")) {
                multiplier = 1024L;
            } else if (units.equals("M")) {
                multiplier = 0x100000L;
            } else if (units.equals("G")) {
                multiplier = 0x40000000L;
            } else {
                numCharsToTrim = 0;
            }
            if (numCharsToTrim > 0) {
                stringValue = stringValue.substring(0, strlen - numCharsToTrim);
            }
        }
        try {
            return multiplier == 1L ? Long.valueOf(stringValue) : Long.valueOf(Long.parseLong(stringValue) * multiplier);
        }
        catch (NumberFormatException nfe) {
            if (stringValue.contains(".")) {
                throw new NumberFormatException("Failed to parse: " + stringValue + " - must be a whole number");
            }
            throw new NumberFormatException("Failed to parse: " + stringValue);
        }
    }

    static {
        try {
            System.setProperty("log4j.configuration", "log4j-embeddedTomcat.isc.config.xml");
            Logger rootLogger = Logger.getRootLogger();
            Enumeration e = rootLogger.getAllAppenders();
            if (!e.hasMoreElements()) {
                rootLogger.addAppender((Appender)new NullAppender());
            }
        }
        catch (Throwable t) {
            System.out.println("Unable to call System.setProperty() - Isomorphic's log4j default configuration will not be available." + t.getMessage());
        }
    }
}

