/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.events.AbstractFileChangeEvent;
import org.apache.commons.vfs2.events.ChangedEvent;
import org.apache.commons.vfs2.events.CreateEvent;
import org.apache.commons.vfs2.events.DeleteEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final FileName rootName;
    private final String rootURI;
    private final Collection<Capability> caps = new HashSet<Capability>();
    private final FileObject parentLayer;
    private final Map<FileName, ArrayList<FileListener>> listenerMap = new HashMap<FileName, ArrayList<FileListener>>();
    private final FileSystemOptions fileSystemOptions;
    private final AtomicLong useCount = new AtomicLong(0L);
    private FileSystemKey cacheKey;
    private final AtomicInteger openStreams = new AtomicInteger(0);

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder builder = DefaultFileSystemConfigBuilder.getInstance();
        String uri = builder.getRootURI(fileSystemOptions);
        if (uri == null) {
            uri = rootName.getURI();
        }
        this.rootURI = uri;
    }

    @Override
    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    @Override
    public void close() {
        this.closeCommunicationLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    protected abstract void addCapabilities(Collection<Capability> var1);

    @Override
    public FileName getRootName() {
        return this.rootName;
    }

    @Override
    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject file) {
        this.getFilesCache().putFile(file);
    }

    private FilesCache getFilesCache() {
        FilesCache filesCache = this.getContext().getFileSystemManager().getFilesCache();
        if (filesCache == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return filesCache;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getFilesCache().getFile(this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getFilesCache().removeFile(this, name);
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return this.caps.contains((Object)capability);
    }

    @Override
    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    @Override
    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    @Override
    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    @Override
    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    @Override
    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.getFileSystemManager().resolveName(this.rootName, nameStr);
        return this.resolveFile(name);
    }

    @Override
    public FileObject resolveFile(FileName name) throws FileSystemException {
        return this.resolveFile(name, true);
    }

    private synchronized FileObject resolveFile(FileName name, boolean useCache) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", name, this.rootName, name.getRootURI());
        }
        FileObject file = useCache ? this.getFileFromCache(name) : null;
        if (file == null) {
            try {
                file = this.createFile((AbstractFileName)name);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/resolve-file.error", (Object)name, (Throwable)e);
            }
            file = this.decorateFileObject(file);
            if (useCache) {
                this.putFileToCache(file);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            file.refresh();
        }
        return file;
    }

    protected FileObject decorateFileObject(FileObject file) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_CALL)) {
            file = new OnCallRefreshFileObject(file);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                file = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(file);
            }
            catch (InstantiationException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", (Object)this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
        }
        return file;
    }

    @Override
    public File replicateFile(FileObject file, FileSelector selector) throws FileSystemException {
        if (!FileObjectUtils.exists(file)) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", (Object)file.getName());
        }
        try {
            return this.doReplicateFile(file, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", (Object)file.getName(), (Throwable)e);
        }
    }

    @Override
    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    @Override
    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    @Override
    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", (Object)this.rootName);
    }

    @Override
    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", (Object)this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file.getName());
            if (listeners == null) {
                listeners = new ArrayList();
                this.listenerMap.put(file.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FileObject file, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file.getName());
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenerMap.remove(file.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject file) {
        this.fireEvent(new CreateEvent(file));
    }

    public void fireFileDeleted(FileObject file) {
        this.fireEvent(new DeleteEvent(file));
    }

    public void fireFileChanged(FileObject file) {
        this.fireEvent(new ChangedEvent(file));
    }

    public boolean isReleaseable() {
        return this.useCount.get() < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        FileListener[] fileListeners = null;
        FileObject fileObject = event.getFileObject();
        FileListener[] fileListenerArray = this.listenerMap;
        synchronized (this.listenerMap) {
            ArrayList<FileListener> listeners = this.listenerMap.get(fileObject.getName());
            if (listeners != null) {
                fileListeners = listeners.toArray(new FileListener[listeners.size()]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (fileListeners != null) {
                for (FileListener fileListener : fileListeners) {
                    try {
                        event.notify(fileListener);
                    }
                    catch (Exception e) {
                        String message = Messages.getString("vfs.provider/notify-listener.warn", (Object)fileObject);
                        VfsLog.warn(this.getLogger(), LOG, message, e);
                    }
                }
            }
            return;
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        this.useCount.incrementAndGet();
    }

    void fileObjectDestroyed(FileObject fileObject) {
        this.useCount.decrementAndGet();
    }

    void setCacheKey(FileSystemKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    void streamOpened() {
        this.openStreams.incrementAndGet();
    }

    void streamClosed() {
        if (this.openStreams.decrementAndGet() == 0) {
            this.notifyAllStreamsClosed();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    public boolean isOpen() {
        return this.openStreams.get() > 0;
    }
}

