/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTableClause
extends Base {
    private static Logger log = new Logger(SQLTableClause.class.getName());
    private List dataSources;
    private boolean isSubSelect = false;
    private String dsToSkip;
    private List customValueFields = null;
    private List customCriteriaFields = null;
    private DSRequest dsRequest;
    private List includeFrom;
    private Boolean useAnsiJoins;

    public SQLTableClause(DSRequest req, SQLDataSource ds) throws Exception {
        this(req, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLTableClause(DSRequest req, List dataSources) throws Exception {
        this(req, dataSources, null);
    }

    public SQLTableClause(DSRequest req, List dataSources, IncludeFromDefinition includeFromDef) throws Exception {
        this.dataSources = dataSources;
        this.dsRequest = req;
        if (includeFromDef != null) {
            this.isSubSelect = true;
            this.includeFrom = DataTools.makeList((Object)includeFromDef);
            this.dsToSkip = includeFromDef.getRelation().getFromDataSource().getName();
        } else {
            this.includeFrom = this.dsRequest.getIncludeFrom();
        }
        if (this.includeFrom == null) {
            this.includeFrom = new ArrayList();
        }
        this.useAnsiJoins = DataTools.asBooleanObject((Object)this.dsRequest.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (this.useAnsiJoins == null) {
            this.useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
    }

    public String getSQLString() throws Exception {
        if (this.dataSources == null && this.includeFrom == null) {
            log.debug((Object)"No datasources, can't generate table clause");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Map allDataSources = this.collectDataSources();
        Iterator i = allDataSources.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object obj = allDataSources.get(key);
            SQLDataSource ds = null;
            String alias = null;
            if (obj instanceof SQLDataSource) {
                ds = (SQLDataSource)((Object)obj);
            } else {
                Map map = (Map)obj;
                ds = (SQLDataSource)((Object)map.get("ds"));
                alias = (String)map.get("alias");
            }
            String schema = ds.getSchemaName();
            if (schema != null) {
                buf.append(schema);
                buf.append(ds.getDriver().getQualifiedSchemaSeparator());
            }
            String tableName = ds.getTable().getNameQuotedIfNecessary(ds);
            buf.append(tableName);
            if (alias != null) {
                buf.append(" ");
                buf.append(alias);
            }
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private Map collectDataSources() {
        HashMap allDataSources = new HashMap();
        if (this.dataSources != null) {
            for (SQLDataSource ds : this.dataSources) {
                if (this.addDataSource(ds.getName(), (DataSource)ds, null, allDataSources)) {
                    return allDataSources;
                }
                if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) continue;
                break;
            }
        }
        if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) {
            for (IncludeFromDefinition incFrom : this.includeFrom) {
                String includeSummaryFunction;
                if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource)) continue;
                String string = includeSummaryFunction = incFrom.getThisField() == null ? null : incFrom.getThisField().getProperty("includeSummaryFunction");
                if (!this.dsRequest.isSummary() && !this.isSubSelect && incFrom.getThisField() != null && includeSummaryFunction != null && (!"CONCAT".equalsIgnoreCase(includeSummaryFunction) || !this.dsRequest.isConcatFetchRequest())) continue;
                DSField thisField = incFrom.getThisField();
                if (thisField != null && thisField.getBoolean("customSQL")) {
                    Iterator j;
                    String thisFieldName = incFrom.getThisFieldName();
                    boolean skipField = true;
                    if (this.customValueFields != null) {
                        j = this.customValueFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField && this.customCriteriaFields != null) {
                        j = this.customCriteriaFields.iterator();
                        while (j.hasNext()) {
                            if (!j.next().equals(thisFieldName)) continue;
                            skipField = false;
                            break;
                        }
                    }
                    if (skipField) continue;
                }
                String alias = incFrom.getAlias(false);
                String allDSKey = incFrom.getDataSourceName();
                if (this.addDataSource(allDSKey = allDSKey + (alias != null ? "*" + alias : ""), incFrom.getDataSource(), alias, allDataSources)) {
                    return allDataSources;
                }
                if (this.addDataSourcesFromJoiningRelations(incFrom, allDataSources)) {
                    return allDataSources;
                }
                IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
                while (target != null && target.getDataSource() instanceof SQLDataSource) {
                    alias = target.getAlias(false);
                    allDSKey = target.getDataSourceName();
                    if (this.addDataSource(allDSKey = allDSKey + (alias != null ? "*" + alias : ""), target.getDataSource(), alias, allDataSources)) {
                        return allDataSources;
                    }
                    incFrom = target;
                    if (this.addDataSourcesFromJoiningRelations(incFrom, allDataSources)) {
                        return allDataSources;
                    }
                    target = incFrom.getTargetIncludeFrom();
                }
            }
        }
        return allDataSources;
    }

    private boolean addDataSourcesFromJoiningRelations(IncludeFromDefinition incFrom, Map relatedDataSources) {
        for (Relation r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
            if (!r.isValid()) continue;
            String alias = r.getToAlias();
            String allDSKey = r.getToDataSource().getName();
            if (!this.addDataSource(allDSKey = allDSKey + (alias != null ? "*" + alias : ""), r.getToDataSource(), alias, relatedDataSources)) continue;
            return true;
        }
        return false;
    }

    public boolean addDataSource(String key, DataSource ds, String alias, Map allDataSources) {
        boolean skipDS;
        boolean bl = skipDS = this.dsToSkip != null && this.dsToSkip.equals(key);
        if (skipDS) {
            this.dsToSkip = null;
        }
        if (!allDataSources.containsKey(key) && !skipDS) {
            if (alias == null) {
                allDataSources.put(key, ds);
            } else {
                HashMap<String, Object> allDSMap = new HashMap<String, Object>();
                allDSMap.put("ds", ds);
                allDSMap.put("alias", alias);
                allDataSources.put(key, allDSMap);
            }
        }
        return this.useAnsiJoins != false && allDataSources.size() == 1;
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }
}

