/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import java.io.Serializable;
import java.util.HashMap;

public class ErrorMessage
extends HashMap
implements Serializable {
    private static final String SEVERITY_FIELD = "severity";
    private static final String ERROR_MESSAGE_FIELD = "errorMessage";
    private static final String SUGGESTED_VALUE_FIELD = "suggestedValue";
    private static final String STOP_ON_ERROR_FIELD = "stopOnError";

    public ErrorMessage() {
    }

    public ErrorMessage(String errorString) {
        this(errorString, null);
    }

    public ErrorMessage(String errorString, Object suggestedValue) {
        this(Severity.ERROR, errorString, suggestedValue);
    }

    public ErrorMessage(Severity severity, String errorString) {
        this(severity, errorString, null);
    }

    public ErrorMessage(Severity severity, String errorString, Object suggestedValue) {
        this.setSeverity(severity);
        this.setErrorString(errorString);
        this.setSuggestedValue(suggestedValue);
    }

    public void setSeverity(Severity severity) {
        this.put(SEVERITY_FIELD, severity);
    }

    public Severity getSeverity() {
        return (Severity)((Object)this.get(SEVERITY_FIELD));
    }

    public void setErrorString(String errorString) {
        this.put(ERROR_MESSAGE_FIELD, errorString);
    }

    public String getErrorString() {
        return (String)this.get(ERROR_MESSAGE_FIELD);
    }

    public void setSuggestedValue(Object suggestedValue) {
        if (suggestedValue != null) {
            this.put(SUGGESTED_VALUE_FIELD, suggestedValue);
        }
    }

    public Object getSuggestedValue() {
        return this.get(SUGGESTED_VALUE_FIELD);
    }

    public void setStopOnError(Boolean stopOnError) {
        this.put(STOP_ON_ERROR_FIELD, stopOnError);
    }

    public Boolean getStopOnError() {
        return (Boolean)this.get(STOP_ON_ERROR_FIELD);
    }

    public static enum Severity {
        INFO,
        WARN,
        ERROR;

    }
}

