/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.ValueMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class PointType
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            log.warn("data is already a List");
            return this.toRecords((List)data, context);
        }
        if (data instanceof Element) {
            Element element = (Element)data;
            if (element.hasAttribute("x") && element.hasAttribute("y")) {
                try {
                    double x = Double.parseDouble(element.getAttribute("x"));
                    double y = Double.parseDouble(element.getAttribute("y"));
                    ArrayList<Double> result = new ArrayList<Double>(2);
                    result.add(x);
                    result.add(y);
                    return result;
                }
                catch (NumberFormatException ex) {
                    throw new Exception("x and y attributes must be numeric");
                }
            }
            throw new Exception("Point must have x and y attributes");
        }
        if (data instanceof HashMap) {
            HashMap map = (HashMap)data;
            if (map.containsKey("x") && map.containsKey("y")) {
                Double y;
                Double x;
                Object attr = map.get("x");
                if (attr instanceof Double) {
                    x = (Double)attr;
                } else if (attr instanceof Number) {
                    x = ((Number)attr).doubleValue();
                } else if (attr instanceof String) {
                    try {
                        x = Double.parseDouble((String)attr);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("X coordinate of point must be number");
                    }
                } else {
                    throw new Exception("Unknow type " + attr.getClass().getName() + " for coordinate x");
                }
                attr = map.get("y");
                if (attr instanceof Double) {
                    y = (Double)attr;
                } else if (attr instanceof Number) {
                    y = ((Number)attr).doubleValue();
                } else if (attr instanceof String) {
                    try {
                        y = Double.parseDouble((String)attr);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("Y coordinate of point must be number");
                    }
                } else {
                    throw new Exception("Unknow type " + attr.getClass().getName() + " for coordinate Y");
                }
                ArrayList<Double> res = new ArrayList<Double>(2);
                res.add(x);
                res.add(y);
                return res;
            }
            throw new Exception("Point must have x and y attributes");
        }
        log.warn("Instance of data is " + data.getClass().getName() + ".Using DataTools.makeListIfSingle to convert it to List");
        return DataTools.makeListIfSingle(data);
    }
}

