/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.util.LocaleMessageProvider;
import com.isomorphic.util.LocaleMessageProviderRegistry;
import com.isomorphic.util.LocaleMessageSourceEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class LocaleMessage {
    public static final String UTF8 = "utf-8";
    public static final String ISO_8859 = "iso-8859";
    private String key;
    private String bundleName;
    private String encoding;
    private String preText;
    private String postText;
    private LocaleMessageSourceEnum source;
    private String sourceFilename;
    private LocaleMessageProvider localeMessageProvider;
    protected static Logger log = new Logger(LocaleMessage.class);
    private static Map<String, ResourceBundle> cachedBundles = new HashMap<String, ResourceBundle>();
    private static Map<String, Properties> cachedProperties = new HashMap<String, Properties>();

    public LocaleMessage(String key, String bundleName, String encoding, String preText, String postText, LocaleMessageSourceEnum source, String sourceFilename, String id) {
        this.key = key;
        this.bundleName = bundleName;
        this.encoding = encoding;
        this.preText = preText == null ? "" : preText;
        this.postText = postText == null ? "" : postText;
        this.source = source;
        this.sourceFilename = sourceFilename;
        this.localeMessageProvider = LocaleMessageSourceEnum.DataSource.equals((Object)source) ? LocaleMessageProviderRegistry.getDSLocaleMessageProvider(id) : LocaleMessageProviderRegistry.getLocaleMessageProvider(id);
    }

    public void setBundle(String bundleName) {
        this.bundleName = bundleName;
    }

    private static InputStream utfToEscapedAscii(InputStream is) throws IOException {
        int length;
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        StringBuilder builder = new StringBuilder(2048);
        char[] buffer = new char[2048];
        boolean firstChar = true;
        while ((length = reader.read(buffer)) >= 0) {
            for (int i = 0; i < length; ++i) {
                char ch = buffer[i];
                if (firstChar) {
                    firstChar = false;
                    if (ch == '\ufeff') {
                        log.debug("Skipping BOM");
                        continue;
                    }
                }
                if (ch <= '\u007f') {
                    builder.append(ch);
                    continue;
                }
                builder.append(String.format("\\u%04x", ch));
            }
        }
        ((Reader)reader).close();
        String dbg = builder.toString();
        log.debug("Escaped ASCII properties: " + dbg);
        byte[] resourceContent = builder.toString().getBytes();
        return new ByteArrayInputStream(resourceContent);
    }

    public String getMessage(Locale locale) {
        if (this.localeMessageProvider != null) {
            return this.localeMessageProvider.getMessage(this.key, locale, this.preText, this.postText, this.source, this.sourceFilename);
        }
        boolean utf8 = UTF8.equals(this.encoding);
        boolean iso = ISO_8859.equals(this.encoding);
        if (!utf8 && !iso) {
            utf8 = Config.getGlobal().getBoolean((Object)"i18n.resourceBundle.parse.utf-8", false);
        }
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ResourceBundle bundle = null;
            if (utf8) {
                Properties props = LocaleMessage.getCachedProperties(this.bundleName, locale);
                if (props == null) {
                    props = this.getUTFProperties(this.bundleName, locale);
                }
                if (props == null) {
                    throw new MissingResourceException("Bad file", this.bundleName, this.key);
                }
                String prop = props.getProperty(this.key);
                if (prop == null) {
                    throw new MissingResourceException("Bad key", this.bundleName, this.key);
                }
                return this.preText + prop + this.postText;
            }
            bundle = LocaleMessage.getCachedBundle(this.bundleName, locale);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(this.bundleName, locale);
                if (bundle != null) {
                    LocaleMessage.cacheBundle(this.bundleName, locale, bundle);
                } else {
                    throw new MissingResourceException("Bad file", this.bundleName, this.key);
                }
            }
            return this.preText + bundle.getString(this.key) + this.postText;
        }
        catch (MissingResourceException mre) {
            String[] packages = new String[]{};
            String packagesString = Config.getGlobal().getString("i18n.resourceBundle.packages");
            if (packagesString != null) {
                packages = packagesString.split(",");
            }
            for (int i = 0; i < packages.length; ++i) {
                try {
                    if (utf8) {
                        Properties props = this.getUTFProperties(packages[i].trim() + "." + this.bundleName, locale);
                        String prop = props.getProperty(this.key);
                        if (prop == null) {
                            throw new MissingResourceException("Bad key", null, null);
                        }
                        return this.preText + prop + this.postText;
                    }
                    ResourceBundle bundle = ResourceBundle.getBundle(packages[i].trim() + "." + this.bundleName, locale);
                    if (bundle == null) {
                        throw new MissingResourceException("Bad file", null, null);
                    }
                    LocaleMessage.cacheBundle(this.bundleName, locale, bundle);
                    return this.preText + bundle.getString(this.key) + this.postText;
                }
                catch (MissingResourceException bundle) {
                    continue;
                }
                catch (Exception e) {
                    log.warn(e);
                }
            }
            log.warn("Failed to get locale message from the '" + this.bundleName + "' bundle using '" + this.key + "' key with error: " + mre.getMessage());
        }
        catch (Exception e) {
            log.warn(e);
        }
        return "<fmt:message key=\"" + this.key + "\">";
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        String message = this.getMessage(Locale.getDefault());
        return "i18n message: key=" + this.key + ", message=" + message;
    }

    protected Properties getUTFProperties(String baseName, Locale locale) throws Exception {
        ArrayList<String> filenames = new ArrayList<String>();
        Properties props = null;
        String bundleName = baseName.replace('.', '/');
        filenames.add(bundleName);
        String[] localeElements = locale.toString().split("_");
        for (int i = 0; i < localeElements.length; ++i) {
            String element = localeElements[i];
            if (element != null && i > 2) {
                log.warn("We were asked to parse properties file " + (String)filenames.get(0) + " for locale " + locale.toString() + ". The Java 7 locale script and extensions elements are not currently supported. Those elements will be ignored - only considering properties files as far as the variant (" + (String)filenames.get(3));
            }
            bundleName = bundleName + "_" + element;
            filenames.add(bundleName);
        }
        Iterator i = filenames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next() + ".properties";
            InputStream utf = this.getClass().getClassLoader().getResourceAsStream(name);
            if (utf == null) {
                log.debug("Unable to locate file " + name + " while doing manual UTF-8 parsing");
                continue;
            }
            InputStream ascii = LocaleMessage.utfToEscapedAscii(utf);
            if (props == null) {
                props = new Properties();
            }
            Properties temp = new Properties(props);
            temp.load(ascii);
            props = temp;
        }
        if (props == null) {
            throw new MissingResourceException("No .properties files found", null, null);
        }
        LocaleMessage.cacheProperties(this.bundleName, locale, props);
        return props;
    }

    private static ResourceBundle getCachedBundle(String bundleName, Locale locale) {
        ResourceBundle bundle = cachedBundles.get(bundleName + "_" + locale.toString());
        if (bundle != null) {
            log.debug("Returning ResourceBundle from cache for props file " + bundleName + "_" + locale.toString());
        } else {
            log.debug("No ResourceBundle in cache for props file " + bundleName + "_" + locale.toString() + " - returning null");
        }
        return bundle;
    }

    private static void cacheBundle(String bundleName, Locale locale, ResourceBundle bundle) {
        if (Config.getGlobal().getBoolean((Object)"i18n.cache.properties", true)) {
            log.debug("Caching ResourceBundle for props file " + bundleName + "_" + locale.toString());
            cachedBundles.put(bundleName + "_" + locale.toString(), bundle);
        } else {
            log.debug("Did not cache ResourceBundle for props file " + bundleName + "_" + locale.toString() + " - caching not configured");
        }
    }

    private static Properties getCachedProperties(String propsName, Locale locale) {
        Properties props = cachedProperties.get(propsName + "_" + locale.toString());
        if (props != null) {
            log.debug("Returning Properties from cache for props file " + propsName + "_" + locale.toString());
        } else {
            log.debug("No Properties in cache for props file " + propsName + "_" + locale.toString() + " - returning null");
        }
        return props;
    }

    private static void cacheProperties(String bundleName, Locale locale, Properties props) {
        if (Config.getGlobal().getBoolean((Object)"i18n.cache.properties", true)) {
            log.debug("Caching ResourceBundle for props file " + bundleName + "_" + locale.toString());
            cachedProperties.put(bundleName + "_" + locale.toString(), props);
        } else {
            log.debug("Did not cache ResourceBundle for props file " + bundleName + "_" + locale.toString() + " - caching not configured");
        }
    }
}

