/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class AtomicFileOutputStream
extends ProxyOutputStream {
    protected String fileName;
    protected String tmpFileName;
    private boolean _isClosed = false;

    public AtomicFileOutputStream(File file) throws IOException {
        super((OutputStream)new FileOutputStream(IOUtil.threadSafeTmpFile(file)));
        this.fileName = file.getCanonicalPath();
        this.tmpFileName = IOUtil._threadSafeTmpFileName(this.fileName);
    }

    public AtomicFileOutputStream(String fileName) throws IOException {
        super((OutputStream)new FileOutputStream(IOUtil.threadSafeTmpFileName(fileName)));
        this.fileName = fileName;
        this.tmpFileName = IOUtil._threadSafeTmpFileName(this.fileName);
    }

    public void close() throws IOException {
        if (!this._isClosed) {
            super.close();
            IOUtil.atomicMove(this.tmpFileName, this.fileName);
        }
        this._isClosed = true;
    }
}

