<#-- @ftlvariable name="openapi" type="java.util.Map<String, Object>" -->
<#-- @ftlvariable name="info" type="java.util.Map<String, Object>"-->
<#-- @ftlvariable name="servers" type="java.util.Map<String, Object>"-->
<#-- @ftlvariable name="tags" type="java.util.Map<String, Object>"-->
<#-- @ftlvariable name="app" type="java.util.Map<String, Object>" -->
<#-- @ftlvariable name="datasources" type="java.util.Map<String, Object>" -->

<#setting number_format="computer">
<#import "lib/parameters.ftl" as parameters />
<#import "lib/responses.ftl" as responses />
<#import "lib/schemas.ftl" as schemas />

openapi: "${openapi.version}"

info:
  version: ${info.version ! "1.0.0"}
  title: ${info.title ! "New Application"}
  description: |
  <#if info.description??>
    <#list description as line>
    ${line?trim}
    </#list>
  <#else>
    A DataSource Operation is a type of operation that acts on the set of stored objects represented by a DataSource, performing one of the basic actions that makes sense on a set of similar records:
      - fetch
      - add
      - update
      - remove
    There is also a fifth DataSource Operation, "custom", which is intended for arbitrary server operations that are more complex than a fetch of some records, or an update to a single record.
    Each DataSource operation has specific requirements around request and response data.  For example, in the "fetch" DataSource operation, the request data is expected to be search criteria,
    and the response data is expected to be a list of matching DataSource records.

    The following API documentation provides the request and response data for all DataSource operations in the application.
  </#if>

servers:
  <#list servers.urls as url>
  - url: ${url}
  </#list>

tags:
  - name: POSTMessage
<#list datasources as id, ds>
  - name: ${id}
  <#if ds.description??>
    description: |
    <#list ds.description as line>
      ${line?trim}
    </#list>
  </#if>
</#list>
x-tagGroups:
  - name: Advanced REST
    tags:
      - POSTMessage
  - name: Simplified REST
    tags:
    <#list datasources as id, ds>
      - ${id}
    </#list>

components:
  schemas:
    RequestBodyModel:
      title: Request Body
      type: object
      xml:
        name: request
      required:
        - dataSource
        - operationType
        - data
      properties:
        dataSource:
          type: string
          description: DataSource this DSRequest will act on.
        operationType:
          type: string
          description: |
            Type of operation being performed: 'fetch', 'add', 'remove', 'update' or 'custom'.
          enum: [fetch, add, update, remove, custom]
        operationId:
          type: string
          description: |
            Optional operationId if the given DataSource supports two or more variants of one of the basic DataSource operations, for instance, a "fetch" that uses full text search and a "fetch" that accepts per-field search criteria.
        startRow:
          type: integer
          description: |
            Starting row of requested results, used only with fetch operations. If unset, 0 is assumed.  Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
        endRow:
          type: integer
          description: |
            End row of requested results, used only with fetch operations. Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
        data:
          type: object
          description: |
            Data, such as search criteria or an updated record, to be used by the given operation. Contents differ by operationType:
              - **fetch**: Filter criteria, as an Object
              - **add**: New record, as an Object
              - **update**: Primary keys of record to update, and new values (or just complete updated record), as an Object
              - **remove**: Primary keys of record to delete, as an Object
              - **custom**: Whatever the custom operation requires

    ResponseBodyModel:
      title: Response Body
      type: object
      properties:
        response:
          type: object
          required:
            - status
            - queueStatus
          properties:
            affectedRows:
              type: integer
            status:
              type: integer
            queueStatus:
              type: integer
            startRow:
              type: integer
            endRow:
              type: integer
            totalRows:
              type: integer
            data:
              nullable: true
              type: array
              xml:
                wrapped: true
              items:
                type: object
                xml:
                  name: record
            relatedUpdates:
              type: array
              items:
                $ref: '#/components/schemas/ResponseBodyModel'

    BatchedRequestBodyModel:
      title: Batched Requests
      type: object
      required:
        - transaction
      properties:
        transaction:
          type: object
          properties:
            operations:
              type: array
              items:
                $ref: "#/components/schemas/RequestBodyModel"

    BatchedResponseBodyModel:
      title: Batched Response
      type: array
      xml:
        wrapped: true
      items:
        $ref: "#/components/schemas/ResponseBodyModel"

    <@schemas.errorModel />
    <@schemas.errorMessage />

  parameters:
    ${app.dynamicDataFormatParamName}:
      name: ${app.dynamicDataFormatParamName}
      description: This governs whether the server expects request bodies to be encoded as XML or JSON, and further influences which format is returned.
      in: query
      schema:
        type: string
        default: ${app.defaultDataFormat!"xml"}
        enum:
          - json
          - xml
    <@parameters.sortBy />
    <@parameters.startRow />
    <@parameters.endRow />
    <@parameters.textMatchStyle defaultValue=app.defaultTextMatchStyle!'exact' />

  responses:
    <@responses.errorResponse />
    <@responses.default />

paths:
  /:
    post:
      tags:
        - POSTMessage
      summary:  DataSource-agnostic AdvancedREST endpoint
      description: |
        Post any operation to any datasource by specifying operation and datasource details in the request body.
        *Prefer this operation to support real-world integrations requiring things like advanced criteria, queueing, etc.*

        Refer to each DataSource's specification individually for documentation illustrating use with DataSource-specific metadata.
      parameters:
        - $ref: "#/components/parameters/${app.dynamicDataFormatParamName}"
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      requestBody:
        content:
          'application/json':
            schema:
              oneOf:
                - $ref: "#/components/schemas/RequestBodyModel"
                - $ref: "#/components/schemas/BatchedRequestBodyModel"
            examples:
              <@exampleFetchRequest format='json' />
              <@exampleBatchRequest format='json' />
              <@exampleAddRequest format='json' />
              <@exampleUpdateRequest format='json' />
              <@exampleRemoveRequest format='json' />
          'application/xml':
            schema:
              $ref: "#/components/schemas/RequestBodyModel"
            examples:
              <@exampleFetchRequest format='xml' />
              <@exampleBatchRequest format='xml' />
              <@exampleAddRequest format='xml' />
              <@exampleUpdateRequest format='xml' />
              <@exampleRemoveRequest format='xml' />
      responses:
        '200':
          description: |
          <#if app.wrapJSONResponses>
            Note that JSON responses are by default wrapped with a prefix/suffix pair as shown below, but these strings may be overridden at the DataSource level.  Refer to each operation's response documentation individually to deterine whether that is the case (as noted by the spec extension x-jsonWrapper element).
            ```
              ${app.jsonPrefix}
              {
                "response": {
                  "affectedRows": 1,
                  "data": [
                    {
                      "CUSTOMER_NUMBER": 1003
                    }
                  ],
                  "operationType": "remove",
                  "queueStatus": 0,
                  "status": 0
                }
              }
              ${app.jsonSuffix}
            ```
          </#if>
          content:
            'application/json':
            <#if app.wrapJSONResponses>
              x-jsonWrapper:
                prefix: ${app.jsonPrefix}
                suffix: ${app.jsonSuffix}
            </#if>
              schema:
                oneOf:
                  - $ref: "#/components/schemas/ResponseBodyModel"
                  - $ref: "#/components/schemas/BatchedResponseBodyModel"
              examples:
                <@exampleFetchResponse format='json' />
                <@exampleBatchResponse format='json' />
                <@exampleAddResponse format='json' />
                <@exampleUpdateResponse format='json' />
                <@exampleRemoveResponse format='json' />
            'application/xml':
              schema:
                oneOf:
                  - $ref: "#/components/schemas/ResponseBodyModel"
                  - $ref: "#/components/schemas/BatchedResponseBodyModel"
              examples:
                <@exampleFetchResponse format='xml' />
                <@exampleBatchResponse format='xml' />
                <@exampleAddResponse format='xml' />
                <@exampleUpdateResponse format='xml' />
                <@exampleRemoveResponse format='xml' />

<#list datasources as id, ds>
  <#if ds.defaultOperations.fetch??>
  /RESTDataSource/${id}/fetch:
    $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1fetch
  </#if>
  <#if ds.defaultOperations.add??>
  /RESTDataSource/${ds.id}/add:
    $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1add
  </#if>
  <#if ds.defaultOperations.update??>
  /RESTDataSource/${ds.id}/update:
    $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1update
  </#if>
  <#if ds.defaultOperations.remove??>
  /RESTDataSource/${id}/remove:
    $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1remove
  </#if>
  <#list ds.namedOperations as op>
  <#if op.operationType == 'custom'>
    <#continue />
  </#if>
  <#if op.operationId??>
    /RESTDataSource/${ds.id}/${op.operationType}/${op.operationId!"blert"}:
      $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1${op.operationType}~1${op.encodedOperationId}
  </#if>    
  </#list>
  /RESTDataSource/${ds.id}/batch:
    $ref: ${id}.yaml#/paths/~1RESTDataSource~1${ds.encodedId}~1batch
  <#if ds.defaultOperations?size != 0>
  /${ds.id}:
    $ref: ${id}.yaml#/paths/~1${ds.encodedId}
  </#if>
  <#if ds.primaryKey??>
  /${id}/{${ds.primaryKey}}:
    $ref: ${id}.yaml#/paths/~1${ds.encodedId}~1%7B${ds.encodedPrimaryKey}%7D
  </#if>
  <#list ds.namedOperations as op>
  <#-- TODO fix customs -->
  <#if op.operationType == 'custom'>
    <#continue />
  </#if>
  <#if op.operationId??>
    /${id}/${op.operationType}/${op.operationId!"blert"}:
      $ref: ${id}.yaml#/paths/~1${ds.encodedId}~1${op.operationType}~1${op.encodedOperationId}
  </#if>
  </#list>
</#list>

<#--
paths:
  '/'
    post:
      requestBody:
        content:
          'application/json':
            examples:
  -->
<#macro exampleFetchRequest format >
              fetch:
                summary: Fetch Employees w/ Advanced Criteria
              <#if format="json">
                value: {
                  "dataSource": "Employees",
                  "operationType": "fetch",
                  "startRow": 0,
                  "endRow": 75,
                  "data": {
                    "_constructor": "AdvancedCriteria",
                    "operator": "or",
                    "criteria": {
                      "criterion": [
                        {
                          "fieldName": "REPORTS_TO_TITLE",
                          "operator": "isNull"
                        },
                        {
                          "fieldName": "REPORTS_TO_TITLE",
                          "operator": "equals",
                          "value": "President"
                        },
                        {
                          "operator": "and",
                          "criteria": {
                            "criterion": [
                              {
                                "fieldName": "REPORTS_TO_TITLE",
                                "operator": "equals",
                                "value": "VP Sales"
                              },
                              {
                                "fieldName": "JOB_TITLE",
                                "operator": "notEqual",
                                "value": "Sales Rep"
                              }
                            ]
                          }
                        }
                      ]
                    }
                  }
                }
              <#else>
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Employees</dataSource>
                    <operationType>fetch</operationType>
                    <startRow>0</startRow>
                    <endRow>75</endRow>
                    <data>
                      <_constructor>AdvancedCriteria</_constructor>
                      <operator>or</operator>
                      <criteria>
                        <criterion>
                          <fieldName>REPORTS_TO_TITLE</fieldName>
                          <operator>isNull</operator>
                        </criterion>
                        <criterion>
                          <fieldName>REPORTS_TO_TITLE</fieldName>
                          <operator>equals</operator>
                          <value>President</value>
                        </criterion>
                        <criterion>
                          <operator>and</operator>
                          <criteria>
                            <criterion>
                              <fieldName>REPORTS_TO_TITLE</fieldName>
                              <operator>equals</operator>
                              <value>VP Sales</value>
                            </criterion>
                            <criterion>
                              <fieldName>JOB_TITLE</fieldName>
                              <operator>notEqual</operator>
                              <value>Sales Rep</value>
                            </criterion>
                          </criteria>
                        </criterion>
                      </criteria>
                    </data>
                  </request>
              </#if>
</#macro>
<#macro exampleBatchRequest format>
              batched:
                summary: Batched Transactions
              <#if format = 'json'>
                value: {
                  "transaction": {
                    "operations": [
                      {
                        "dataSource": "Customers",
                        "operationType": "add",
                        "data": {
                          "CUSTOMER_NAME": "Isomorphic Software",
                          "CONTACT_FIRST_NAME": "SmartClient",
                          "CONTACT_LAST_NAME": "Developer",
                          "ADDRESS_LINE1": "1 Sansome Street",
                          "ADDRESS_LINE2": "Suite 3500",
                          "CITY": "San Francisco",
                          "STATE": "CA",
                          "POSTAL_CODE": "94104",
                          "COUNTRY": "USA",
                          "PHONE": "866-223-4569"
                        }
                      },
                      {
                        "dataSource": "Customers",
                        "operationType": "add",
                        "data": {
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "STATE": "AZ",
                          "POSTAL_CODE": "85718",
                          "COUNTRY": "USA",
                          "PHONE": "555-765-4321"
                        }
                      }
                    ]
                  }
                }
              <#else>
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <transaction>
                    <operations>
                      <request>
                        <dataSource>Customers</dataSource>
                        <operationType>add</operationType>
                        <data>
                          <CUSTOMER_NAME>Isomorphic Software</CUSTOMER_NAME>
                          <CONTACT_FIRST_NAME>SmartClient</CONTACT_FIRST_NAME>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <ADDRESS_LINE1>1 Sansome Street</ADDRESS_LINE1>
                          <ADDRESS_LINE2>Suite 3500</ADDRESS_LINE2>
                          <CITY>San Francisco</CITY>
                          <STATE>CA</STATE>
                          <POSTAL_CODE>94104</POSTAL_CODE>
                          <COUNTRY>USA</COUNTRY>
                          <PHONE>866-223-4569</PHONE>
                        </data>
                      </request>
                      <request>
                        <dataSource>Customers</dataSource>
                        <operationType>add</operationType>
                        <data>
                          <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                          <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                          <CITY>Tucson</CITY>
                          <STATE>AZ</STATE>
                          <POSTAL_CODE>85718</POSTAL_CODE>
                          <COUNTRY>USA</COUNTRY>
                          <PHONE>555-765-4321</PHONE>
                        </data>
                      </request>
                    </operations>
                  </transaction>
              </#if>
</#macro>
<#macro exampleAddRequest format>
              add:
                summary: Add Customer
            <#if format='json'>
                value: {
                  "dataSource": "Customers",
                  "operationType": "add",
                  "data": {
                    "CUSTOMER_NAME": "ACME Corporation",
                    "CONTACT_FIRST_NAME": "SmartGWT",
                    "CONTACT_LAST_NAME": "Developer",
                    "ADDRESS_LINE1": "7575 East Border St.",
                    "CITY": "Tucson",
                    "STATE": "AZ",
                    "POSTAL_CODE": "85718",
                    "COUNTRY": "USA",
                    "PHONE": "555-765-4321"
                  }
                }
            <#else>
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>add</operationType>
                    <data>
                      <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                      <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                      <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                      <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                      <CITY>Tucson</CITY>
                      <STATE>AZ</STATE>
                      <POSTAL_CODE>85718</POSTAL_CODE>
                      <COUNTRY>USA</COUNTRY>
                      <PHONE>555-765-4321</PHONE>
                    </data>
                  </request>
            </#if>
</#macro>
<#macro exampleUpdateRequest format>
              update:
                summary: Update Customer
              <#if format = 'json'>
                value: {
                  "dataSource": "Customers",
                  "operationType": "update",
                  "data": {
                    "CUSTOMER_NUMBER": 1003,
                    "CREDIT_LIMIT": 5000.01
                  }
                }
              <#else>
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>update</operationType>
                    <data>
                      <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                      <CREDIT_LIMIT>5000.01</CREDIT_LIMIT>
                    </data>
                  </request>
              </#if>
</#macro>
<#macro exampleRemoveRequest format>
              remove:
                summary: Remove Customer
              <#if format='json'>
                value: {
                  "dataSource": "Customers",
                  "operationType": "remove",
                  "data": {
                    "CUSTOMER_NUMBER": 1003
                  }
                }
              <#else>
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>remove</operationType>
                    <data>
                      <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                    </data>
                  </request>
              </#if>
</#macro>

<#--
paths:
  '/'
    post:
      responses:
        200:
          content:
            'application/json':
              examples:
  -->
<#macro exampleFetchResponse format>
                fetch:
                  summary: Fetch Employees w/ Advanced Criteria
                <#if format='json'>
                  value: {
                    "response": {
                      "affectedRows": 0,
                      "data": [
                        {
                          "EMAIL": "dmurphy@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1002,
                          "EXTENSION": "x5800",
                          "FIRST_NAME": "Diane",
                          "FORMATTED_NAME": "Murphy, Diane",
                          "JOB_TITLE": "President",
                          "LAST_NAME": "Murphy",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO_NAME": "Murphy, Diane",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "mpatterso@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1056,
                          "EXTENSION": "x4611",
                          "FIRST_NAME": "Mary",
                          "FORMATTED_NAME": "Patterson, Mary",
                          "JOB_TITLE": "VP Sales",
                          "LAST_NAME": "Patterson",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1002,
                          "REPORTS_TO_NAME": "Patterson, Mary",
                          "REPORTS_TO_TITLE": "President",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "jfirrelli@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1076,
                          "EXTENSION": "x9273",
                          "FIRST_NAME": "Jeff",
                          "FORMATTED_NAME": "Firrelli, Jeff",
                          "JOB_TITLE": "VP Marketing",
                          "LAST_NAME": "Firrelli",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1002,
                          "REPORTS_TO_NAME": "Firrelli, Jeff",
                          "REPORTS_TO_TITLE": "President",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "wpatterson@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1088,
                          "EXTENSION": "x4871",
                          "FIRST_NAME": "William",
                          "FORMATTED_NAME": "Patterson, William",
                          "JOB_TITLE": "Sales Manager (APAC)",
                          "LAST_NAME": "Patterson",
                          "OFFICE_CODE": "6",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Patterson, William",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "APAC"
                        },
                        {
                          "EMAIL": "gbondur@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1102,
                          "EXTENSION": "x5408",
                          "FIRST_NAME": "Gerard",
                          "FORMATTED_NAME": "Bondur, Gerard",
                          "JOB_TITLE": "Sale Manager (EMEA)",
                          "LAST_NAME": "Bondur",
                          "OFFICE_CODE": "4",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Bondur, Gerard",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "EMEA"
                        },
                        {
                          "EMAIL": "abow@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1143,
                          "EXTENSION": "x5428",
                          "FIRST_NAME": "Anthony",
                          "FORMATTED_NAME": "Bow, Anthony",
                          "JOB_TITLE": "Sales Manager (NA)",
                          "LAST_NAME": "Bow",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Bow, Anthony",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "NA"
                        }
                      ],
                      "endRow": 6,
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "fetch",
                      "queueStatus": 0,
                      "startRow": 0,
                      "status": 0,
                      "totalRows": 6
                    }
                  }
                <#else>
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>0</startRow>
                      <endRow>6</endRow>
                      <totalRows>6</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <FORMATTED_NAME>Murphy, Diane</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1002</EMPLOYEE_NUMBER>
                          <JOB_TITLE>President</JOB_TITLE>
                          <REPORTS_TO_NAME>Murphy, Diane</REPORTS_TO_NAME>
                          <EXTENSION>x5800</EXTENSION>
                          <LAST_NAME>Murphy</LAST_NAME>
                          <EMAIL>dmurphy@classicmodelcars.com</EMAIL>
                          <FIRST_NAME>Diane</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Patterson, Mary</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1056</EMPLOYEE_NUMBER>
                          <JOB_TITLE>VP Sales</JOB_TITLE>
                          <REPORTS_TO_NAME>Patterson, Mary</REPORTS_TO_NAME>
                          <EXTENSION>x4611</EXTENSION>
                          <REPORTS_TO_TITLE>President</REPORTS_TO_TITLE>
                          <LAST_NAME>Patterson</LAST_NAME>
                          <EMAIL>mpatterso@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1002</REPORTS_TO>
                          <FIRST_NAME>Mary</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Firrelli, Jeff</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1076</EMPLOYEE_NUMBER>
                          <JOB_TITLE>VP Marketing</JOB_TITLE>
                          <REPORTS_TO_NAME>Firrelli, Jeff</REPORTS_TO_NAME>
                          <EXTENSION>x9273</EXTENSION>
                          <REPORTS_TO_TITLE>President</REPORTS_TO_TITLE>
                          <LAST_NAME>Firrelli</LAST_NAME>
                          <EMAIL>jfirrelli@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1002</REPORTS_TO>
                          <FIRST_NAME>Jeff</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Patterson, William</FORMATTED_NAME>
                          <TERRITORY>APAC</TERRITORY>
                          <EMPLOYEE_NUMBER>1088</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sales Manager (APAC)</JOB_TITLE>
                          <REPORTS_TO_NAME>Patterson, William</REPORTS_TO_NAME>
                          <EXTENSION>x4871</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Patterson</LAST_NAME>
                          <EMAIL>wpatterson@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>William</FIRST_NAME>
                          <OFFICE_CODE>6</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Bondur, Gerard</FORMATTED_NAME>
                          <TERRITORY>EMEA</TERRITORY>
                          <EMPLOYEE_NUMBER>1102</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sale Manager (EMEA)</JOB_TITLE>
                          <REPORTS_TO_NAME>Bondur, Gerard</REPORTS_TO_NAME>
                          <EXTENSION>x5408</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Bondur</LAST_NAME>
                          <EMAIL>gbondur@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>Gerard</FIRST_NAME>
                          <OFFICE_CODE>4</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Bow, Anthony</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1143</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sales Manager (NA)</JOB_TITLE>
                          <REPORTS_TO_NAME>Bow, Anthony</REPORTS_TO_NAME>
                          <EXTENSION>x5428</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Bow</LAST_NAME>
                          <EMAIL>abow@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>Anthony</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                      </data>
                    </response>
                </#if>
</#macro>
<#macro exampleBatchResponse format>
                batched:
                  summary: Batched Transactions
                <#if format='json'>
                  value: [
                    {
                      "response": {
                        "affectedRows": 1,
                        "data": [
                          {
                              "ADDRESS_LINE1": "1 Sansome Street",
                              "ADDRESS_LINE2": "Suite 3500",
                              "CITY": "San Francisco",
                              "CONTACT_FIRST_NAME": "SmartClient",
                              "CONTACT_LAST_NAME": "Developer",
                              "COUNTRY": "USA",
                              "CUSTOMER_NAME": "Isomorphic Software",
                              "CUSTOMER_NUMBER": 1001,
                              "PHONE": "866-223-4569",
                              "POSTAL_CODE": "94104",
                              "STATE": "CA"
                          }
                        ],
                        "invalidateCache": false,
                        "isDSResponse": true,
                        "operationType": "add",
                        "queueStatus": 0,
                        "status": 0
                      }
                    },
                    {
                      "response": {
                        "affectedRows": 1,
                        "data": [
                          {
                            "ADDRESS_LINE1": "7575 East Border St.",
                            "CITY": "Tucson",
                            "CONTACT_FIRST_NAME": "SmartGWT",
                            "CONTACT_LAST_NAME": "Developer",
                            "COUNTRY": "USA",
                            "CUSTOMER_NAME": "ACME Corporation",
                            "CUSTOMER_NUMBER": 1002,
                            "PHONE": "555-765-4321",
                            "POSTAL_CODE": "85718",
                            "STATE": "AZ"
                          }
                        ],
                        "invalidateCache": false,
                        "isDSResponse": true,
                        "operationType": "add",
                        "queueStatus": 0,
                        "status": 0
                      }
                    }
                  ]
                <#else>
                  value: |
                    <?xml version="1.0"?>
                    <responses>
                      <response>
                        <status>0</status>
                        <queueStatus>0</queueStatus>
                        <startRow>-1</startRow>
                        <endRow>-1</endRow>
                        <totalRows>-1</totalRows>
                        <queueStatus>0</queueStatus>
                        <data>
                          <record>
                            <ADDRESS_LINE1>1 Sansome Street</ADDRESS_LINE1>
                            <ADDRESS_LINE2>Suite 3500</ADDRESS_LINE2>
                            <CUSTOMER_NUMBER>1001</CUSTOMER_NUMBER>
                            <CUSTOMER_NAME>Isomorphic Software</CUSTOMER_NAME>
                            <CITY>San Francisco</CITY>
                            <COUNTRY>USA</COUNTRY>
                            <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                            <POSTAL_CODE>94104</POSTAL_CODE>
                            <PHONE>866-223-4569</PHONE>
                            <STATE>CA</STATE>
                            <CONTACT_FIRST_NAME>SmartClient</CONTACT_FIRST_NAME>
                          </record>
                        </data>
                      </response>
                      <response>
                        <status>0</status>
                        <queueStatus>0</queueStatus>
                        <startRow>-1</startRow>
                        <endRow>-1</endRow>
                        <totalRows>-1</totalRows>
                        <queueStatus>0</queueStatus>
                        <data>
                          <record>
                            <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                            <CUSTOMER_NUMBER>1002</CUSTOMER_NUMBER>
                            <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                            <CITY>Tucson</CITY>
                            <COUNTRY>USA</COUNTRY>
                            <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                            <POSTAL_CODE>85718</POSTAL_CODE>
                            <PHONE>555-765-4321</PHONE>
                            <STATE>AZ</STATE>
                            <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                          </record>
                        </data>
                      </response>
                    </responses>
                </#if>
</#macro>
<#macro exampleAddResponse format>
                add:
                  summary: Add Customer
                <#if format='json'>
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "COUNTRY": "USA",
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CUSTOMER_NUMBER": 1003,
                          "PHONE": "555-765-4321",
                          "POSTAL_CODE": "85718",
                          "STATE": "AZ"
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "add",
                      "queueStatus": 0,
                      "status": 0
                    }
                  }
                <#else>
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>-1</startRow>
                      <endRow>-1</endRow>
                      <totalRows>-1</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                          <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                          <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                          <CITY>Tucson</CITY>
                          <COUNTRY>USA</COUNTRY>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <POSTAL_CODE>85718</POSTAL_CODE>
                          <PHONE>555-765-4321</PHONE>
                          <STATE>AZ</STATE>
                          <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                        </record>
                      </data>
                    </response>
                </#if>
</#macro>
<#macro exampleUpdateResponse format>
                update:
                  summary: Update Customer
                <#if format='json'>
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "COUNTRY": "USA",
                          "CREDIT_LIMIT": 5000.01,
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CUSTOMER_NUMBER": 1015,
                          "PHONE": "555-765-4321",
                          "POSTAL_CODE": "85718",
                          "STATE": "AZ"
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "update",
                      "queueStatus": 0,
                      "status": 0
                    }
                  }
                <#else>
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>-1</startRow>
                      <endRow>-1</endRow>
                      <totalRows>-1</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                          <CREDIT_LIMIT>5000.01</CREDIT_LIMIT>
                          <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                          <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                          <CITY>Tucson</CITY>
                          <COUNTRY>USA</COUNTRY>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <POSTAL_CODE>85718</POSTAL_CODE>
                          <PHONE>555-765-4321</PHONE>
                          <STATE>AZ</STATE>
                          <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                        </record>
                      </data>
                    </response>
                </#if>
</#macro>
<#macro exampleRemoveResponse format>
                remove:
                  summary: Remove Customer
                <#if format='json'>
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "CUSTOMER_NUMBER": 1003
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "remove",
                      "queueStatus": 0,
                      "status": 0
                    }
                  }
                <#else>
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>-1</startRow>
                      <endRow>-1</endRow>
                      <totalRows>-1</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                        </record>
                      </data>
                    </response>
                </#if>
</#macro>