<#-- @ftlvariable name="app" type="java.util.Map<String, Object>" -->
<#import "parameters.ftl" as parameters>
<#import "datasource-utils.ftl" as utils>
<#--
paths:
  /Customer:
-->
<#macro fetch fetchOperation>
    get:
      operationId: "${fetchOperation.uid}_usingSimplifiedREST"
      summary: Fetch ${ds.title}
      description: Performs a fetch against the '${ds.id}' datasource, with any query params interpreted as simple search criteria.
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      <#list fetchOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=fetchOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      responses:
        200:
          <@responsedef operation=fetchOperation />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro add addOperation>
    post:
      operationId: "${addOperation.uid}_usingSimplifiedREST"
      summary: Add ${ds.title}
      description: Adds the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
      <#list addOperation.parameters as field>
      <#if field.format?? && field.format == 'sequence'>
        <#continue />
      </#if>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=addOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef addOperation />
      responses:
        201:
          <@responsedef operation=addOperation format="record" />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro update updateOperation>
  <#if updateOperation.allowMultiUpdate??>
    patch:
      description: Updates the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.  Note that in the absence of any primary key values this operation will update multiple records, if allowed.
  <#else>
    put:
      description: Updates the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.  Note that in the absence of any primary key values this operation will behave just like the POST method, resulting in an added record.
  </#if>
      operationId: "${updateOperation.uid}_usingSimplifiedREST"
      summary: Update ${ds.title}
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
      <#list updateOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=updateOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef updateOperation />
      responses:
        200:
          <@responsedef operation=updateOperation format="any" />
      <#if !updateOperation.allowMultiUpdate??>
        201:
          <@responsedef operation=updateOperation format="any" />
      </#if>
        204:
          $ref: "#/components/responses/204"
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro remove removeOperation>
    delete:
      operationId: "${removeOperation.uid}_usingSimplifiedREST"
      summary: Remove ${ds.title}
      description: Removes the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
      <#list removeOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=removeOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      responses:
        200:
          <@responsedef operation=removeOperation />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro fetchByPath fetchOperation>
    get:
      operationId: "${fetchOperation.uid}_usingPath"
      summary: Fetch ${ds.title} by path
      description: Performs a fetch against the '${ds.id}' datasource, using the path parameter value as simple search criteria.
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/textMatchStyle"
        - $ref: "#/components/parameters/pathToKey"
      responses:
        200:
          <@responsedef operation=fetchOperation format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro updateByPath updateOperation>
    put:
      operationId: "${updateOperation.uid}_usingPath"
      summary: Update ${ds.title} by path
      description: Update ${ds.id} by key, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/pathToKey"
      <#list updateOperation.parameters as field>
        <#if field.primaryKey??>
          <#continue />
        </#if>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=updateOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef operation=updateOperation pathIncludesKey=true/>
      responses:
        200:
          <@responsedef operation=updateOperation format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro removeByPath removeOperation>
    delete:
      operationId: "${removeOperation.uid}_usingPath"
      summary: Remove ${ds.title} by path
      description: Remove ${ds.id} by key, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${ds.id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/pathToKey"
      responses:
        200:
          <@responsedef operation=removeOperation format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro namedOperationBinding namedOperation>
  <#local method = namedOperation.httpMethod>
  /${ds.id}/${namedOperation.operationType}/${namedOperation.operationId}:
    ${method}:
      operationId: "${namedOperation.uid}_usingSimplifiedREST"
      summary: ${ds.id}.${namedOperation.operationId}
      description: |
      <#if namedOperation.description??>
        <#list namedOperation.description as line>
        ${line?trim}
        </#list>
      </#if>
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"json" />
        - $ref: "#/components/parameters/hybridMode"
      <#if namedOperation.operationType == 'fetch' || namedOperation.operationType == 'custom'>
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      </#if>
      <#list namedOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=namedOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      <#if namedOperation.operationType != 'fetch' && namedOperation.operationType != 'remove'>
      requestBody:
        <@utils.requestbodydef namedOperation />
      </#if>
      responses:
        200:
          <@responsedef operation=namedOperation />
        204:
          $ref: "#/components/responses/204"
        default:
           $ref: "#/components/responses/default"
</#macro>

<#macro responsedef operation format=operation.payloadFormat>
          description: |
            Expected Response.
            - '${ds.id} Record' responses are sent for adds, fetches that supply the primary key value as a path segment (not as a query param or POSTED data), and updates or removes that specify the primary key either as param(s) or as a path segment.
            - 'Array responses' are always generated for any fetch which doesn't specify the primary key as a path segment, or any update or remove request that doesn't specify a primary key.
            - 'DSResponses' are returned if the hybridMode parameter value is true, whether by default or overridden via request parameter.

        <#if app.wrapJSONResponses>
            Note that JSON responses are wrapped with a prefix/suffix pair as noted in the x-jsonWrapper element and illustrated in the example below.
            ```
              ${ds.jsonPrefix!app.jsonPrefix}
              {
                "response": {
                  "status": 0,
                  "queueStatus": 0,
                  "startRow": 0,
                  "endRow": 0,
                  "totalRows": 0,
                  "data": []
                }
              }
              ${ds.jsonSuffix!app.jsonSuffix}
            ```
          x-jsonWrapper:
            prefix: ${ds.jsonPrefix!app.jsonPrefix}
            suffix: ${ds.jsonSuffix!app.jsonSuffix}
        </#if>
          content:
            application/json:
              <@responseschema operation, format />
              examples:
              <#if format == "record" || format == "any">
                Record:
                  value:
                  <#list operation.outputs as field>
                    ${field.name}: "${field.sample!''}"
                  </#list>
              </#if>
              <#if format == "array" || format == "any">
                Array:
                  value: [{
                  <#list operation.outputs as field>
                    ${field.name}: "${field.sample!''}"<#sep>,
                  </#list>
                  }]
              </#if>
                DSResponse:
                  value:
                    response:
                      status: 0,
                      queueStatus: 0,
                    <#if operation.operationType == 'fetch'>
                      startRow: 0,
                      endRow: 1,
                      totalRows: 1,
                    <#else>
                      affectedRows: 1,
                    </#if>
                      data: [{
                      <#list operation.outputs as field>
                        ${field.name}: "${field.sample!''}"<#sep>,
                      </#list>
                      }]
            application/xml:
              <@responseschema operation, format />
              examples:
              <#if format == "record" || format == "any">
                Record:
                  value: |
                    <record>
                    <#list operation.outputs as field>
                      <${field.name}>"${field.sample!''}"</${field.name}>
                    </#list>
                    </record>
              </#if>
              <#if format == "array" || format == "any">
                Array:
                  value: |
                    <data>
                      <record>
                      <#list operation.outputs as field>
                        <${field.name}>"${field.sample!''}"</${field.name}>
                      </#list>
                      </record>
                    </data>
              </#if>
                DSResponse:
                  value: |
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                    <#if operation.operationType == 'fetch'>
                      <startRow>0</startRow>
                      <endRow>1</endRow>
                      <totalRows>1</totalRows>
                    <#else>
                      <affectedRows>1</affectedRows>
                  </#if>
                      <data>
                        <record>
                        <#list operation.outputs as field>
                          <${field.name}>"${field.sample!''}"</${field.name}>
                        </#list>
                        </record>
                      </data>
                    </response>
</#macro>

<#macro responseschema operation, format>
              schema:
                oneOf:
                <#if format == "record" || format == "any">
                  - title: ${ds.id} Record
                    type: object
                    xml:
                      name: record
                    <#list operation.requiredOutputs>
                    required:
                      <#items as field>
                      - ${field.name}
                      </#items>
                    </#list>
                    properties:
                    <#list operation.outputs as field>
                      ${field.name}:
                        <@utils.describe indentation=24 field=field operation=operation context="response"/>
                        <@utils.fielddef indentation=24 field=field />
                    </#list>
                </#if>
                <#if format == "array" ||format == "any">
                  - title: Record Array
                    type: array
                    xml:
                      wrapped: true
                      name: data
                    items:
                      type: object
                      xml:
                        name: record
                      <#list operation.requiredOutputs>
                      required:
                        <#items as field>
                        - ${field.name}
                        </#items>
                      </#list>
                      properties:
                      <#list operation.outputs as field>
                        ${field.name}:
                          <@utils.describe indentation=26 field=field operation=operation context="response"/>
                          <@utils.fielddef indentation=26 field=field />
                      </#list>
                </#if>
                  - title: DSResponse
                    type: object
                    required:
                      - response
                    properties:
                      response:
                        type: object
                        required:
                          - queueStatus
                          - status
                          - data
                        properties:
                          affectedRows:
                            type: integer
                          status:
                            type: integer
                          queueStatus:
                            type: integer
                          startRow:
                            type: integer
                          endRow:
                            type: integer
                          totalRows:
                            type: integer
                          data:
                            type: array
                            xml:
                              wrapped: true
                            items:
                              type: object
                              xml:
                                name: record
                              <#list operation.requiredOutputs>
                              required:
                                <#items as field>
                                - ${field.name}
                                </#items>
                              </#list>
                              properties:
                              <#list operation.outputs as field>
                                ${field.name}:
                                  <@utils.describe indentation=34 field=field operation=operation context="response"/>
                                  <@utils.fielddef indentation=34 field=field />
                              </#list>
</#macro>