/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthStatus;
import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.AuthenticatorHandledResponse;
import com.isomorphic.auth.ConfigAuthenticator;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Config;
import com.isomorphic.base.InitListener;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.servlet.URIRegexRule;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
extends URIRegexFilter {
    public String loginPage = "/isomorphic/login/iscAuth/login.html";
    public String logoutPage = "/isomorphic/login/iscAuth/logout.html";
    public String maxLoginAttemptsExceededPage = "/isomorphic/login/iscAuth/maxLoginAttemptsExceeded.html";
    public String defaultLoginRedirect = "/";
    public String initialTargetParam = "initialTarget";
    protected boolean passInitialTargetAsQueryParam = false;
    public String authStateParam = "authState";
    public int maxTries = -1;
    public String realm;
    public String username;
    public String password;
    public String superuserRole;
    public List<String> roles;
    public String enableOnRequestAttribute;
    public String disableOnRequestAttribute;
    protected IAuthenticator authenticator = null;
    protected String authenticatorName = null;
    protected Logger log;
    protected boolean enabled = Authentication.enabled;
    protected String filterName;

    public void setLoginPage(String value) {
        this.loginPage = value;
    }

    public void setLogoutPage(String value) {
        this.logoutPage = value;
    }

    public void setMaxLoginAttemptsExceededPage(String value) {
        this.maxLoginAttemptsExceededPage = value;
    }

    public void setDefaultLoginRedirect(String value) {
        this.defaultLoginRedirect = value;
    }

    public void setInitialTargetParam(String value) {
        this.initialTargetParam = value;
    }

    public void setPassInitialTargetAsQueryParam(String value) {
        this.passInitialTargetAsQueryParam = Boolean.valueOf(value);
    }

    public void setAuthStateParam(String value) {
        this.authStateParam = value;
    }

    public void setMaxTries(String value) {
        this.maxTries = Integer.valueOf(value);
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setSuperUserRole(String value) {
        this.superuserRole = value;
    }

    public void setRoles(String value) {
        if (value == null) {
            this.roles = null;
        }
        this.setRoles(DataTools.commaSeparatedStringToList(value));
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setEnableOnRequestAttribute(String value) {
        this.enableOnRequestAttribute = value;
    }

    public void setDisableOnRequestAttribute(String value) {
        this.disableOnRequestAttribute = value;
    }

    public void setAuthenticator(String value) throws Exception {
        this.authenticatorName = value;
        String configRoot = "authenticator." + this.authenticatorName;
        String authenticatorImpl = config.getString(configRoot);
        if (authenticatorImpl == null) {
            authenticatorImpl = config.getString(configRoot + ".implementer");
        }
        if (authenticatorImpl == null) {
            throw new Exception("Can't find config block for authenticator: " + this.authenticatorName + " - looking for " + configRoot + " block in server.properties");
        }
        try {
            Reflection.classForName(authenticatorImpl);
        }
        catch (ClassNotFoundException e) {
            throw new Exception(configRoot + " defines: " + authenticatorImpl + " as its implementor, but no such class exists in the runtime (class.forName())");
        }
        Config authDefaults = config.getSubtree("authenticator.default");
        Config authConfig = config.getSubtree(configRoot);
        Config mergedConfig = new Config(DataTools.cascadeMaps(new Map[]{authDefaults, authConfig, new HashMap()}));
        mergedConfig.put("implementer", authenticatorImpl);
        mergedConfig.put("configRoot", configRoot);
        this.authenticator = (IAuthenticator)mergedConfig.getClassInstance();
        if (this.superuserRole == null) {
            this.superuserRole = config.getString("authenticator." + this.authenticatorName + ".superuserRole", null);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.defaultAction == null) {
            this.setDefaultAction("match");
        }
        super.init(filterConfig);
        if (this.username != null && this.password != null && ServletTools.servletOrFilterParametersToMap(filterConfig).get("authenticator") == null) {
            try {
                this.setAuthenticator("simpleConfig");
            }
            catch (Exception e) {
                this.log.error((Object)"can't auto-initialize simpleConfig authenticator - check your configuration", e);
                throw new ServletException(e.toString());
            }
        }
        if (this.authenticator instanceof ConfigAuthenticator) {
            if (this.username != null) {
                ((ConfigAuthenticator)this.authenticator).username = this.username;
            }
            if (this.password != null) {
                ((ConfigAuthenticator)this.authenticator).password = this.password;
            }
        }
        if (this.realm == null) {
            this.realm = filterConfig.getFilterName();
        }
        this.log = new Logger(this.getClass().getName(), filterConfig.getFilterName() + "(" + this.authenticatorName + ", realm: " + this.realm + ")");
        try {
            if (!this.enabled) {
                this.log.warn("AuthenticationFilter present in web.xml, but authentication globally disabled in config via authentication.enabled: false.  Not initializing, will allow all requests without any checks.");
                return;
            }
            if (this.rules == null) {
                this.log.info("No rules file defined, treating all intercepted resources as private");
            } else {
                try {
                    this.rules.add(0, new URIRegexRule("match:^/isomorphic/login/loginSuccessMarker.html", "authFilter default"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error initializing known good regex rule", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize AuthenticationFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestContext context = null;
        try {
            boolean isLogoutPage;
            String authState;
            if (!this.enabled || this.enableOnRequestAttribute != null && request.getAttribute(this.enableOnRequestAttribute) == null || this.disableOnRequestAttribute != null && request.getAttribute(this.disableOnRequestAttribute) != null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String initialPath = ServletTools.getInitialRequestURI(request);
            String currentPath = ServletTools.getCurrentRequestURI(request);
            String comparePath = "initial".equals(this.matchURI) ? initialPath : currentPath;
            this.applyResponseHeaders(response);
            request.setAttribute("_isc_authenticationEnabled", (Object)Boolean.TRUE);
            context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            context.request.setAttribute(Authentication.authenticatorKey, this.authenticator);
            String overrideRealm = (String)context.request.getAttribute("isc.auth.realm");
            this.authenticator.setRealm(context, overrideRealm != null ? overrideRealm : this.realm);
            boolean isLoginPage = comparePath.equals(this.loginPage) || !this.loginPage.startsWith("/") && comparePath.endsWith(this.loginPage);
            String initialTarget = context.request.getQueryParameter(this.initialTargetParam);
            if (initialTarget != null && !"".equals(initialTarget.trim())) {
                if (isLoginPage) {
                    this.authenticator.setInitialTarget(context, initialTarget);
                }
            } else {
                initialTarget = this.authenticator.getInitialTarget(context);
            }
            if (this.authenticator.containsCredentials(context)) {
                int loginCounter = this.authenticator.getLoginCounter(context);
                request.setAttribute("isc.LAST_AUTH_UID", (Object)this.authenticator.getSubmittedUsername(context));
                if (this.maxTries > 0 && loginCounter < this.maxTries || this.maxTries < 0) {
                    Principal user = this.authenticator.authenticate(context);
                    if (user != null) {
                        this.authenticator.setUser(context, user);
                        this.log.info("Authentication attempt succeeded");
                        this.authenticator.setLoginCounter(context, 0);
                        this.authenticator.setInitialTarget(context, null);
                        ServletTools.clearCookie("loginRedirect", context, this.loginPage, null);
                        if (isLoginPage) {
                            if (initialTarget == null) {
                                initialTarget = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                            }
                            this.log.debug("Sending to initial target: " + initialTarget);
                            response.sendRedirect(initialTarget);
                            return;
                        }
                    } else {
                        if (this.maxTries > 0) {
                            this.authenticator.setLoginCounter(context, ++loginCounter);
                        }
                        this.log.info("Authentication failed, try # " + loginCounter);
                        if ("NONE".equals(this.loginPage)) {
                            response.sendError(401);
                            return;
                        }
                    }
                }
                if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                    this.log.debug("Attempt to authenticate, but maxTries (" + this.maxTries + ") has been reached");
                    boolean redirectSent = this.maxLoginsExceeded(context, comparePath);
                    if (redirectSent) {
                        return;
                    }
                }
            }
            if (isLoginPage && (authState = context.request.getParameter(this.authStateParam)) != null) {
                try {
                    String loginPageURI = ServletTools.getInitialRequestURI((HttpServletRequest)context.request);
                    this.authenticator.handleAuthStateChange(context, authState, loginPageURI);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error during auth state change", e);
                    this.authenticator.setStatus(context, AuthStatus.INVALID_REQUEST);
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (comparePath.equals("/favicon.ico")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (comparePath.equals(this.maxLoginAttemptsExceededPage)) {
                context.setNoCacheHeaders();
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            Object userId = null;
            String userName = null;
            boolean userLookedUp = false;
            boolean bl = isLogoutPage = comparePath.equals(this.logoutPage) || !this.logoutPage.startsWith("/") && comparePath.endsWith(this.logoutPage);
            if (isLogoutPage) {
                userId = this.authenticator.getUserId(context);
                userName = this.authenticator.getUserName(context);
                if (userId != null) {
                    this.log.debug("Logging out (user: " + userName + ")");
                    this.authenticator.logout(context);
                }
                context.setNoCacheHeaders();
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (isLoginPage) {
                String currentRedirect;
                String loginRedirect = this.authenticator.getInitialTarget(context);
                if (loginRedirect == null) {
                    loginRedirect = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                }
                if ((currentRedirect = ServletTools.getCookieValue("loginRedirect", (HttpServletRequest)context.request)) == null) {
                    ServletTools.setCookie(context, "loginRedirect", loginRedirect, this.loginPage);
                }
                if (this.authenticator.getInitialTargetJsCallback(context) != null) {
                    RPCManager.writeIframePrefix(response.getWriter(), null, context, this.authenticator.getInitialTargetJsCallback(context));
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                if (this.authenticator.getInitialTargetJsCallback(context) == null) return;
                RPCManager.writeIframePostfix(response.getWriter());
                this.authenticator.setInitialTargetJsCallback(context, null);
                return;
            }
            URIRegexRule matchedRule = this.applyRules(initialPath, currentPath, this.matchURI);
            String action = matchedRule.getAction();
            if ("block".equals(action)) {
                response.sendError(404);
                this.log.warn("DENIED access to blocked resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
                return;
            }
            List<String> requiresRoles = null;
            if (matchedRule.hasMetaData()) {
                List<String> metaData = matchedRule.getMetaData();
                requiresRoles = DataTools.simpleSplit(metaData.get(0), ",");
                if (matchedRule.getMatchType() == URIRegexRule.MatchType.INITIAL && !"initial".equals(this.matchURI) && !"ignore".equals(action)) {
                    this.log.warn("DENIED access to resource " + comparePath + " since rule " + matchedRule.toString() + " is a potential security risk; it is not 'ignore' but requires a match against the initial URI when the filter matchURI setting targets the current URI");
                    return;
                }
            }
            if (!"match".equals(action)) {
                String referrerPath;
                URIRegexRule referrerMatchedRule;
                String referrerAction;
                String referrer = request.getHeader("referer");
                String origin = request.getHeader("origin");
                if (referrer != null && origin != null && "match".equals(referrerAction = (referrerMatchedRule = this.applyRules(referrerPath = referrer.substring(origin.length()), null, "initial")).getAction())) {
                    userId = this.authenticator.getUserId(context);
                    userName = this.authenticator.getUserName(context);
                    userLookedUp = true;
                    if (userName == null) {
                        this.log.info("Unauthenticated access from protected referrer - forcing auth on to present relogin (assuming i.e. IDACall case)");
                        action = "match";
                    }
                }
            }
            if ("match".equals(action)) {
                if (!userLookedUp) {
                    userId = this.authenticator.getUserId(context);
                    userName = this.authenticator.getUserName(context);
                    userLookedUp = true;
                }
                if (userName == null) {
                    Map reqProps;
                    String t;
                    context.setNoCacheHeaders();
                    if ("NONE".equals(this.loginPage) && !this.authenticator.containsCredentials(context)) {
                        response.sendError(401);
                        return;
                    }
                    int loginCounter = this.authenticator.getLoginCounter(context);
                    if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                        this.maxLoginsExceeded(context, comparePath);
                        return;
                    }
                    initialTarget = this.getInitialTarget(context);
                    if (initialTarget != null) {
                        initialTarget = ServletTools.adjustForContextPath(initialTarget, request);
                    }
                    this.authenticator.setInitialTarget(context, initialTarget);
                    if (context.request.isMultipart() && (t = (String)(reqProps = context.request.getStringParams()).get("_transaction")) != null) {
                        ValidationContext vc = new ValidationContext();
                        vc.setRestrictedXMLMode(true);
                        Object to = XML.toDSRecords(new StringReader(t), vc);
                        vc.freeResources();
                        this.authenticator.setInitialTargetJsCallback(context, (String)((Map)to).get("jscallback"));
                    }
                    String loginTarget = this.loginPage;
                    if (this.passInitialTargetAsQueryParam && initialTarget != null && !"".equals(initialTarget.trim())) {
                        loginTarget = ServletTools.addQueryParameter(loginTarget, "initialTarget", URLEncoder.encode(initialTarget, "UTF-8"));
                    }
                    if (!loginTarget.startsWith("/")) {
                        comparePath = initialPath;
                        loginTarget = comparePath + "/" + loginTarget;
                    }
                    response.sendRedirect(ServletTools.adjustForContextPath(loginTarget, request));
                    String why = "not authenticated for realm: " + this.realm;
                    this.log.debug("REDIRECTING user to login page: " + this.loginPage + " for access to private resource: " + comparePath + " (" + why + ")");
                    return;
                }
                if (requiresRoles != null && requiresRoles.size() > 0) {
                    boolean isAuthorized = false;
                    List<String> userRoles = this.roles != null ? this.roles : this.authenticator.getUserRoles(context);
                    if (this.superuserRole != null && userRoles.contains(this.superuserRole)) {
                        isAuthorized = true;
                    } else if (requiresRoles.contains("devenv") && config.getBoolean((Object)"devenv", false)) {
                        isAuthorized = true;
                    } else {
                        for (String requiresRole : requiresRoles) {
                            if (!userRoles.contains(requiresRole)) continue;
                            isAuthorized = true;
                            break;
                        }
                    }
                    if (!isAuthorized) {
                        this.log.warn("DENIED access to resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ") user does not have required role. Required role(s): " + requiresRoles + ", User role(s): " + userRoles);
                        return;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ALLOWED authenticated access (user: " + userName + ") to private resource: " + comparePath);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("ALLOWED access to public resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
            }
            if (userName != null && request.getAttribute("isc_auth_uid") == null) {
                Logger.putMDC("isc.auth.userName", userName);
                request.setAttribute("isc_auth_uid", userId);
                request.setAttribute("isc_auth_username", (Object)userName);
            }
            ISCHttpServletRequest wrappedRequest = new ISCHttpServletRequest(request);
            wrappedRequest.setPrincipalContext(context, this.authenticator);
            this.authenticator.track(context);
            boolean appliedConfigOverrides = this.applyConfigOverrides(matchedRule);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
            if (!appliedConfigOverrides) return;
            config.popThreadLocal();
            return;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (AuthenticatorHandledResponse ahr) {
            return;
        }
        catch (Exception e) {
            this.log.forceError("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
            throw new ServletException("Auth failure - see server logs for details");
        }
        finally {
            if (!InitListener.isRegistered) {
                Logger.removeMDC("isc.auth.userName");
            }
            if (context != null) {
                try {
                    context.completeResponse();
                }
                catch (Exception exception) {}
                try {
                    response.flushBuffer();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getInitialTarget(RequestContext context) {
        String queryString = context.request.getQueryString();
        String initialTarget = ServletTools.getInitialRequestURI((HttpServletRequest)context.request);
        if (queryString != null && queryString.length() > 0) {
            if (!queryString.startsWith("?")) {
                initialTarget = initialTarget + "?";
            }
            initialTarget = initialTarget + queryString;
        }
        return initialTarget;
    }

    private boolean maxLoginsExceeded(RequestContext context, String comparePath) throws Exception {
        this.authenticator.setStatus(context, AuthStatus.TOO_MANY_LOGIN_ATTEMPTS);
        String maxTriesURL = this.maxLoginAttemptsExceededPage;
        if (maxTriesURL == null && comparePath.equals(this.loginPage)) {
            this.log.debug("maxTries is set, but maxLoginAttemptsExceededPage is not defined, re-serving loginPage for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ")");
            return false;
        }
        this.log.debug("REDIRECTING user to: " + maxTriesURL + " for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ")");
        context.response.sendRedirect(ServletTools.adjustForContextPath(maxTriesURL, (HttpServletRequest)context.request));
        return true;
    }
}

