/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.log.Logger;
import com.isomorphic.scripting.ScriptException;
import com.isomorphic.scripting.ScriptExceptionItem;
import com.isomorphic.scripting.ScriptXBase;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.syntax.SyntaxException;

public class ScriptGroovy
extends ScriptXBase {
    private static Logger log = new Logger(ScriptGroovy.class.getName());
    private static Map groovyScriptCache = Collections.synchronizedMap(new LRUMap(config.getInt("scripting.groovy.cacheMapSize", 512)));

    @Override
    public String getImportDirectives(List imports) throws Exception {
        String ret = "";
        if (imports != null) {
            for (String impFullLine : imports) {
                if (impFullLine == null) continue;
                for (String impSplitted : impFullLine.split(";")) {
                    for (String imp : impSplitted.split(" ")) {
                        if ((imp = imp.trim()).equals("")) continue;
                        ret = ret + "import " + imp + ";\n";
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public Map evalScript() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object evalResult = null;
        GroovyShell shell = null;
        try {
            shell = new GroovyShell(cl);
        }
        catch (Throwable e) {
            log.error((Object)"Unable to init Groovy - is it installed?", e);
            throw new Exception(e);
        }
        String scriptToEval = null;
        try {
            scriptToEval = (this.importDirectives == null ? "" : this.importDirectives) + "\n" + (this.header == null ? "" : this.header) + "\n" + (this.script == null ? "" : this.script) + "\n" + (this.footer == null ? "" : this.footer);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating assembled script:\n" + scriptToEval);
            } else {
                log.info("Evaluating script:\n" + this.script);
            }
            Script groovyScript = null;
            if (config.getBoolean((Object)"script.groovy.cacheScripts", true)) {
                Class groovyScriptClass = (Class)groovyScriptCache.get(scriptToEval);
                if (groovyScriptClass == null) {
                    groovyScript = shell.parse(scriptToEval);
                    groovyScriptCache.put(scriptToEval, groovyScript.getClass());
                } else {
                    groovyScript = (Script)groovyScriptClass.newInstance();
                }
            } else {
                groovyScript = shell.parse(scriptToEval);
            }
            if (this.bindings != null) {
                groovyScript.setBinding(new Binding(this.bindings));
            }
            evalResult = groovyScript.run();
        }
        catch (CompilationFailedException cfe) {
            throw ScriptGroovy.processCompilationFailedException(cfe, this);
        }
        catch (Exception e) {
            throw this.fillInStackTrace(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        return result;
    }

    public static Exception processCompilationFailedException(CompilationFailedException cfe, ScriptXBase script) {
        ErrorCollector ec = null;
        if (cfe instanceof MultipleCompilationErrorsException) {
            ec = ((MultipleCompilationErrorsException)cfe).getErrorCollector();
        } else {
            ProcessingUnit pu = cfe.getUnit();
            if (pu == null) {
                log.warn("Unable to obtain ProcessingUnit to derive script offset");
                throw cfe;
            }
            ec = pu.getErrorCollector();
        }
        if (ec == null) {
            log.warn("Unable to obtain ErrorCollector to derive script offset");
            throw cfe;
        }
        int errorCount = ec.getErrorCount();
        if (errorCount < 1) {
            log.warn("Have error, but errorCount is " + errorCount);
            throw cfe;
        }
        ArrayList<ScriptExceptionItem> items = new ArrayList<ScriptExceptionItem>();
        for (int i = 0; i < errorCount; ++i) {
            SyntaxException se = ec.getSyntaxError(i);
            int line = se.getLine();
            String message = se.getOriginalMessage();
            items.add(script.getScriptExceptionItem(ScriptExceptionItem.Type.PARSE, line, message, se.getStartColumn()));
        }
        if (items.size() > 0) {
            return new ScriptException(script.scriptSourceName, items);
        }
        return cfe;
    }
}

